//============================================================================================
/**
 * @file	pmsiv_sub.c
 * @bfief	ȈՉb͉ʁi`扺FTuʁj
 * @author	taya
 * @date	06.02.10
 */
//============================================================================================
#include "common.h"
#include "gflib\heapsys.h"
#include "gflib\strbuf.h"
#include "system\arc_util.h"
#include "system\window.h"
#include "system\pms_word.h"
#include "system\winframe.naix"
#include "system\msgdata.h"
#include "msgdata\msg_pms_input.h"
#include "msgdata\msg.naix"


#include "pms_input_prv.h"
#include "pms_input_view.h"


//======================================================================

enum {


	GROUP_WIN_XPOS = 4,
	GROUP_WIN_YPOS = 5,
	GROUP_WIN_PALNO = 0,

	INITIAL_WIN_XPOS = 19,
	INITIAL_WIN_YPOS = 5,
	INITIAL_WIN_PALNO = 1,

	BUTTON_WIN_WIDTH = 9,
	BUTTON_WIN_HEIGHT = 5,
	BUTTON_WIN_CHARSIZE = BUTTON_WIN_WIDTH*BUTTON_WIN_HEIGHT,

	PUSH_BUTTON_WRITE_OX = 5,
	PUSH_BUTTON_WRITE_OY = 5,
	RELEASE_BUTTON_WRITE_OX = 4,
	RELEASE_BUTTON_WRITE_OY = 4,

	WIN_COL_PUSH_GROUND = 0x0a,
	WIN_COL_RELEASE_GROUND = 0x09,
	WIN_COL1 = 0x01,
	WIN_COL2 = 0x02,
	WIN_COL3 = 0x03,

};

enum {
	SCREEN_PATTERN_PUSH_GROUP,
	SCREEN_PATTERN_PUSH_INITIAL,
};


//======================================================================


//======================================================================
//--------------------------------------------------------------
/**
 *	
 */
//--------------------------------------------------------------
struct _PMSIV_SUB {
	PMS_INPUT_VIEW*        vwk;
	const PMS_INPUT_WORK*  mwk;
	const PMS_INPUT_DATA*  dwk;

	GF_BGL_INI*        bgl;

	CLACT_WORK_PTR     category_button;
	CLACT_WORK_PTR     initial_button;
	CLACT_WORK_PTR     up_button;
	CLACT_WORK_PTR     down_button;

	u16   screen_group[0x400];
	u16   screen_initial[0x400];

};


//==============================================================
// Prototype
//==============================================================
static u32 create_bg_screen( GF_BGL_INI* bgl, u32 dat_id, u32 charpos, int ptn, const STRBUF* str_group, const STRBUF* str_initial, u16* scr_buf );
static void print_str( GF_BGL_BMPWIN* win, const STRBUF* str, u32 x, u32 y, u32 fill_color, GF_PRINTCOLOR print_color );




//------------------------------------------------------------------
/**
 * 
 *
 * @param   vwk		
 * @param   mwk		
 * @param   dwk		
 *
 * @retval  PMSIV_SUB*		
 */
//------------------------------------------------------------------
PMSIV_SUB*  PMSIV_SUB_Create( PMS_INPUT_VIEW* vwk, const PMS_INPUT_WORK* mwk, const PMS_INPUT_DATA* dwk )
{
	PMSIV_SUB*  wk = sys_AllocMemory( HEAPID_PMS_INPUT_VIEW, sizeof(PMSIV_SUB) );

	wk->vwk = vwk;
	wk->mwk = mwk;
	wk->dwk = dwk;
	wk->bgl = PMSIView_GetBGL(vwk);

	wk->category_button = NULL;
	wk->initial_button = NULL;
	wk->up_button = NULL;
	wk->down_button = NULL;

	return wk;
}
//------------------------------------------------------------------
/**
 * 
 *
 * @param   wk		
 *
 */
//------------------------------------------------------------------
void PMSIV_SUB_Delete( PMSIV_SUB* wk )
{
	if( wk->category_button )
	{
		CLACT_Delete( wk->category_button );
	}
	if( wk->initial_button )
	{
		CLACT_Delete( wk->initial_button );
	}
	if( wk->up_button )
	{
		CLACT_Delete( wk->up_button );
	}
	if( wk->down_button )
	{
		CLACT_Delete( wk->down_button );
	}

	sys_FreeMemoryEz( wk );
}



//------------------------------------------------------------------
/**
 * 
 *
 * @param   wk		
 *
 */
//------------------------------------------------------------------
void PMSIV_SUB_SetupGraphicDatas( PMSIV_SUB* wk )
{
	enum {
		CLEAR_CHARPOS = 0,
		CLEAR_CHARCODE = 0x11,

	};

	GF_BGL_INI* bgl;
	STRBUF* str_group;
	STRBUF* str_initial;
	u32 charpos;

	FontProc_LoadFont( FONT_BUTTON, HEAPID_BASE_SYSTEM );

	bgl = PMSIView_GetBGL( wk->vwk );

	ArcUtil_PalSet( ARC_PMSI_GRAPHIC, NARC_pmsi_bg_sub_nclr, PALTYPE_SUB_BG, 0, 0x40, HEAPID_PMS_INPUT_VIEW );

	str_group = MSGDAT_GetStrDirectAlloc(ARC_MSG, NARC_msg_pms_input_dat, str_group_mode, HEAPID_PMS_INPUT_VIEW );
	str_initial = MSGDAT_GetStrDirectAlloc(ARC_MSG, NARC_msg_pms_input_dat, str_initial_mode, HEAPID_PMS_INPUT_VIEW );


	charpos = ArcUtil_BgCharSet(ARC_PMSI_GRAPHIC, NARC_pmsi_bg_sub_lz_ncgr, bgl,
		FRM_SUB_BG, 0, 0, TRUE, HEAPID_PMS_INPUT_VIEW );
	charpos /= 0x20;


	charpos = create_bg_screen( bgl, NARC_pmsi_bg_sub_l_lz_nscr, charpos, SCREEN_PATTERN_PUSH_GROUP,
			str_group, str_initial, wk->screen_group );

	create_bg_screen( bgl, NARC_pmsi_bg_sub_r_lz_nscr, charpos, SCREEN_PATTERN_PUSH_INITIAL,
			str_group, str_initial, wk->screen_initial );

	GF_BGL_ScreenBufSet( bgl, FRM_SUB_BG, wk->screen_group, 0x800 );


//	GF_BGL_CharFill( bgl, FRM_SUB_BG, CLEAR_CHARCODE, 1, CLEAR_CHARPOS );
//	GF_BGL_ScrFill( bgl, FRM_SUB_BG, CLEAR_CHARPOS, 0, 0, 32, 32, 0 );
//	ArcUtil_ScrnSet(ARC_PMSI_GRAPHIC, NARC_pmsi_bg_sub_l_lz_nscr, bgl,
//		FRM_SUB_BG, 0, 0, TRUE, HEAPID_PMS_INPUT_VIEW );


	STRBUF_Delete(str_group);
	STRBUF_Delete(str_initial);
	FontProc_UnloadFont( FONT_BUTTON );


	GF_BGL_LoadScreenReq( bgl, FRM_SUB_BG );

}


static u32 create_bg_screen( GF_BGL_INI* bgl, u32 dat_id, u32 charpos, int ptn, const STRBUF* str_group, const STRBUF* str_initial, u16* scr_buf )
{
	NNSG2dScreenData* screen;
	void*  screen_load_ptr;

	GF_BGL_BMPWIN  group_win;
	GF_BGL_BMPWIN  initial_win;

	screen_load_ptr = ArcUtil_ScrnDataGet(ARC_PMSI_GRAPHIC, dat_id, TRUE, &screen, HEAPID_PMS_INPUT_VIEW );
	GF_BGL_ScreenBufSet( bgl, FRM_SUB_BG, screen->rawData, 0x800 );


	GF_BGL_BmpWinAdd(	bgl, &group_win, FRM_SUB_BG,
						GROUP_WIN_XPOS, GROUP_WIN_YPOS, BUTTON_WIN_WIDTH, BUTTON_WIN_HEIGHT,
						GROUP_WIN_PALNO, charpos );
	charpos += BUTTON_WIN_CHARSIZE;

	GF_BGL_BmpWinAdd(	bgl, &initial_win, FRM_SUB_BG,
						INITIAL_WIN_XPOS, INITIAL_WIN_YPOS, BUTTON_WIN_WIDTH, BUTTON_WIN_HEIGHT,
						INITIAL_WIN_PALNO, charpos );
	charpos += BUTTON_WIN_CHARSIZE;


	if( ptn ==  SCREEN_PATTERN_PUSH_GROUP )
	{
		print_str( &group_win, str_group, PUSH_BUTTON_WRITE_OX, PUSH_BUTTON_WRITE_OY,
			WIN_COL_PUSH_GROUND, GF_PRINTCOLOR_MAKE(WIN_COL1, WIN_COL2, WIN_COL3) );

		print_str( &initial_win, str_initial, RELEASE_BUTTON_WRITE_OX, RELEASE_BUTTON_WRITE_OY,
			WIN_COL_RELEASE_GROUND, GF_PRINTCOLOR_MAKE(WIN_COL1, WIN_COL2, WIN_COL3) );
	}
	else
	{
		print_str( &initial_win, str_initial, PUSH_BUTTON_WRITE_OX, PUSH_BUTTON_WRITE_OY,
			WIN_COL_PUSH_GROUND, GF_PRINTCOLOR_MAKE(WIN_COL1, WIN_COL2, WIN_COL3) );

		print_str( &group_win, str_group, RELEASE_BUTTON_WRITE_OX, RELEASE_BUTTON_WRITE_OY,
			WIN_COL_RELEASE_GROUND, GF_PRINTCOLOR_MAKE(WIN_COL1, WIN_COL2, WIN_COL3) );
	}

	GF_BGL_BmpWinMakeScrn( &group_win );
	GF_BGL_BmpWinMakeScrn( &initial_win );

	MI_CpuCopy16( GF_BGL_ScreenAdrsGet(bgl, FRM_SUB_BG), scr_buf, 0x800 );

	GF_BGL_BmpWinDel(&group_win);
	GF_BGL_BmpWinDel(&initial_win);
	sys_FreeMemoryEz( screen_load_ptr );

	return charpos;
}

static void print_str( GF_BGL_BMPWIN* win, const STRBUF* str, u32 x, u32 y, u32 fill_color, GF_PRINTCOLOR print_color )
{
	GF_BGL_BmpWinDataFill( win, fill_color );
	GF_STR_PrintColor( win, FONT_BUTTON, str, x, y, MSG_NO_PUT, print_color, NULL );
	GF_BGL_BmpWinCgxOn( win );
}

//------------------------------------------------------------------
/**
 * 
 *
 * @param   wk		
 *
 */
//------------------------------------------------------------------
void PMSIV_SUB_ChangeCategoryButton( PMSIV_SUB* wk )
{
	const u16* scrn;

	if( PMSI_GetCategoryMode(wk->mwk) == CATEGORY_MODE_GROUP )
	{
		scrn = wk->screen_group;
	}
	else
	{
		scrn = wk->screen_initial;
	}


	GF_BGL_ScreenBufSet( wk->bgl, FRM_SUB_BG, scrn, 0x800 );
	GF_BGL_LoadScreenReq( wk->bgl, FRM_SUB_BG );

}
