//============================================================================================
/**
 * @file	plist_item.c
 * @bfief	|PXgʃACegp
 * @author	Hiroyuki Nakamura
 * @date	05.12.12
 */
//============================================================================================
#include "common.h"

#include "system/procsys.h"
#include "system/clact_tool.h"
#include "system/bmp_menu.h"
#include "system/msgdata.h"
#include "system/wordset.h"
#include "system/numfont.h"
/*
#include "system/window.h"
#include "system/snd_tool.h"
#include "poketool/monsno.h"
#include "poketool/pokeicon.h"
*/
#include "battle/battle_common.h"
#include "poketool/pokeparty.h"
#include "poketool/status_rcv.h"
#include "poketool/waza_tool.h"
#include "itemtool/item.h"
#include "itemtool/myitem.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_pokelist.h"
#include "application/app_tool.h"

#define	PLIST_ITEM_H_GLOBAL
#include "application/pokelist.h"
#include "plist_sys.h"
#include "plist_bmp.h"
#include "plist_obj.h"
#include "plist_item.h"


#define	RCV_FLG_SLEEP		( 0x01 )	// 
#define	RCV_FLG_POISON		( 0x02 )	// ŉ
#define	RCV_FLG_BURN		( 0x04 )	// Ώ
#define	RCV_FLG_ICE			( 0x08 )	// X
#define	RCV_FLG_PARALYZE	( 0x10 )	// ჉
#define	RCV_FLG_PANIC		( 0x20 )	// 
#define	RCV_FLG_ALL			( 0x3f )	// S

enum {
	ITEM_TYPE_BTL_ST_UP = 0,	// 퓬pXe[^XAbvn
	ITEM_TYPE_ALLDETH_RCV,		// Sm
	ITEM_TYPE_LV_UP,			// LvUpn
	ITEM_TYPE_NEMURI_RCV,		// 
	ITEM_TYPE_DOKU_RCV,			// ŉ
	ITEM_TYPE_YAKEDO_RCV,		// Ώ
	ITEM_TYPE_KOORI_RCV,		// X
	ITEM_TYPE_MAHI_RCV,			// ჉
	ITEM_TYPE_KONRAN_RCV,		// 
	ITEM_TYPE_ALL_ST_RCV,		// S
	ITEM_TYPE_MEROMERO_RCV,		// 
	ITEM_TYPE_HP_RCV,			// HP ( m )
	ITEM_TYPE_HP_UP,			// HPw͒lUP
	ITEM_TYPE_ATC_UP,			// Uw͒lUP
	ITEM_TYPE_DEF_UP,			// hw͒lUP
	ITEM_TYPE_AGL_UP,			// fw͒lUP
	ITEM_TYPE_SPA_UP,			// Uw͒lUP
	ITEM_TYPE_SPD_UP,			// hw͒lUP
	ITEM_TYPE_EVO,				// in
	ITEM_TYPE_PP_UP,			// ppUpn
	ITEM_TYPE_PP_3UP,			// pp3Upn
	ITEM_TYPE_PP_RCV,			// pp񕜌n
	ITEM_TYPE_ETC,				// ̑
};



static int NormalRecover( void * work );
static int HP_RecoverFuncInit( void * work );
static int HP_RecoverFuncMain( void * work );

static void PL_WazaSet( PLIST_WORK * wk, POKEMON_PARAM * pp, u32 pos );
static int PL_NewWazaSetYes( void * work );
static int PL_NewWazaSetNo( void * work );
static int PL_NewWazaSetCancelYes( void * work );
static int PL_NewWazaSetCancelNo( void * work );









static u8 ItemRecoverCheck( u16 item )
{
	ITEMDATA * dat;
	s32	prm;

	dat = GetItemArcData( item, ITEM_GET_DATA, HEAPID_POKELIST );

	// p[^ĂȂACe͂̑
	if( ItemBufParamGet( dat, ITEM_PRM_W_TYPE ) != ITEM_WKTYPE_POKEUSE ){
		sys_FreeMemoryEz( dat );
		return ITEM_TYPE_ETC;
	}

	// 퓬pXe[^XAbvn
	if( ItemBufParamGet( dat, ITEM_PRM_ATTACK_UP ) != 0 ||
		ItemBufParamGet( dat, ITEM_PRM_DEFENCE_UP ) != 0 ||
		ItemBufParamGet( dat, ITEM_PRM_SP_ATTACK_UP ) != 0 ||
		ItemBufParamGet( dat, ITEM_PRM_SP_DEFENCE_UP ) != 0 ||
		ItemBufParamGet( dat, ITEM_PRM_AGILITY_UP ) != 0 ||
		ItemBufParamGet( dat, ITEM_PRM_HIT_UP ) != 0 ||
		ItemBufParamGet( dat, ITEM_PRM_CRITICAL_UP ) != 0 ){

		sys_FreeMemoryEz( dat );
		return ITEM_TYPE_BTL_ST_UP;
	}

	// Sm
	if( ItemBufParamGet( dat, ITEM_PRM_ALL_DEATH_RCV ) != 0 ){
		sys_FreeMemoryEz( dat );
		return ITEM_TYPE_ALLDETH_RCV;
	}

	// LvUpn
	if( ItemBufParamGet( dat, ITEM_PRM_LV_UP ) != 0 ){
		sys_FreeMemoryEz( dat );
		return ITEM_TYPE_LV_UP;
	}

	// Status񕜌n
	prm = ItemBufParamGet( dat, ITEM_PRM_SLEEP_RCV );				// 
	prm += ( ItemBufParamGet( dat, ITEM_PRM_POISON_RCV ) << 1 );	// 
	prm += ( ItemBufParamGet( dat, ITEM_PRM_BURN_RCV ) << 2 );		// Ώ
	prm += ( ItemBufParamGet( dat, ITEM_PRM_ICE_RCV ) << 3 );		// X
	prm += ( ItemBufParamGet( dat, ITEM_PRM_PARALYZE_RCV ) << 4 );	// 
	prm += ( ItemBufParamGet( dat, ITEM_PRM_PANIC_RCV ) << 5 );		// 
	switch( prm ){
	case RCV_FLG_SLEEP:		// 
		sys_FreeMemoryEz( dat );
		return ITEM_TYPE_NEMURI_RCV;
	case RCV_FLG_POISON:	// 
		sys_FreeMemoryEz( dat );
		return ITEM_TYPE_DOKU_RCV;
	case RCV_FLG_BURN:		// Ώ
		sys_FreeMemoryEz( dat );
		return ITEM_TYPE_YAKEDO_RCV;
	case RCV_FLG_ICE:		// X
		sys_FreeMemoryEz( dat );
		return ITEM_TYPE_KOORI_RCV;
	case RCV_FLG_PARALYZE:	// 
		sys_FreeMemoryEz( dat );
		return ITEM_TYPE_MAHI_RCV;
	case RCV_FLG_PANIC:		// 
		sys_FreeMemoryEz( dat );
		return ITEM_TYPE_KONRAN_RCV;
	case RCV_FLG_ALL:		// S
		sys_FreeMemoryEz( dat );
		return ITEM_TYPE_ALL_ST_RCV;
	}
	// 
	if( ItemBufParamGet( dat, ITEM_PRM_MEROMERO_RCV ) != 0 ){
		sys_FreeMemoryEz( dat );
		return ITEM_TYPE_MEROMERO_RCV;
	}

	// HP ( m )
	if( ItemBufParamGet( dat, ITEM_PRM_HP_RCV ) != 0 ){
		sys_FreeMemoryEz( dat );
		return ITEM_TYPE_HP_RCV;
	}

	// h[sOn
	// HPw͒lUP
	if( ItemBufParamGet( dat, ITEM_PRM_HP_EXP_POINT ) != 0 ){
		sys_FreeMemoryEz( dat );
		return ITEM_TYPE_HP_UP;
	}
	// Uw͒lUP
	if( ItemBufParamGet( dat, ITEM_PRM_POWER_EXP_POINT ) != 0 ){
		sys_FreeMemoryEz( dat );
		return ITEM_TYPE_ATC_UP;
	}
	// hw͒lUP
	if( ItemBufParamGet( dat, ITEM_PRM_DEFENCE_EXP_POINT ) != 0 ){
		sys_FreeMemoryEz( dat );
		return ITEM_TYPE_DEF_UP;
	}
	// fw͒lUP
	if( ItemBufParamGet( dat, ITEM_PRM_AGILITY_EXP_POINT ) != 0 ){
		sys_FreeMemoryEz( dat );
		return ITEM_TYPE_AGL_UP;
	}
	// Uw͒lUP
	if( ItemBufParamGet( dat, ITEM_PRM_SP_ATTACK_EXP_POINT ) != 0 ){
		sys_FreeMemoryEz( dat );
		return ITEM_TYPE_SPA_UP;
	}
	// hw͒lUP
	if( ItemBufParamGet( dat, ITEM_PRM_SP_DEFENCE_EXP_POINT ) != 0 ){
		sys_FreeMemoryEz( dat );
		return ITEM_TYPE_SPD_UP;
	}

	// in
	if( ItemBufParamGet( dat, ITEM_PRM_EVOLUTION ) != 0 ){
		sys_FreeMemoryEz( dat );
		return ITEM_TYPE_EVO;
	}

	// ppUpn
	if( ItemBufParamGet( dat, ITEM_PRM_PP_UP ) != 0 ){
		sys_FreeMemoryEz( dat );
		return ITEM_TYPE_PP_UP;
	}

	// pp3Upn
	if( ItemBufParamGet( dat, ITEM_PRM_PP_3UP ) != 0 ){
		sys_FreeMemoryEz( dat );
		return ITEM_TYPE_PP_3UP;
	}

	// pp񕜌n
	if( ItemBufParamGet( dat, ITEM_PRM_PP_RCV ) != 0 ||
		ItemBufParamGet( dat, ITEM_PRM_ALL_PP_RCV ) != 0 ){

		sys_FreeMemoryEz( dat );
		return ITEM_TYPE_PP_RCV;
	}

	sys_FreeMemoryEz( dat );
	return ITEM_TYPE_ETC;
}

static void SetStatusRecoverMsg( PLIST_WORK * wk, u16 itemno )
{
	POKEMON_PARAM * pp;
	STRBUF * str;

	pp  = PokeParty_GetMemberPointer( wk->dat->pp, wk->pos );
	WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(pp) );

	switch( ItemRecoverCheck( itemno ) ){
	case ITEM_TYPE_DOKU_RCV:	// ŉ
		str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_15 );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		break;
	case ITEM_TYPE_NEMURI_RCV:	// 
		str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_35 );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		break;
	case ITEM_TYPE_YAKEDO_RCV:	// Ώ
		str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_17 );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		break;
	case ITEM_TYPE_KOORI_RCV:	// X
		str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_18 );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		break;
	case ITEM_TYPE_MAHI_RCV:	// ჉
		str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_16 );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		break;
	case ITEM_TYPE_KONRAN_RCV:	// 
		str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_23 );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		break;
	case ITEM_TYPE_MEROMERO_RCV:	// 
		str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_24 );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		break;
	case ITEM_TYPE_ALL_ST_RCV:	// Xe[^XُS
		str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_21 );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		break;
	case ITEM_TYPE_HP_UP:		// h[sOACe HPw͒lUP
		str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_25 );
		WORDSET_RegisterPokeStatusName( wk->wset, 1, 0 );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		break;
	case ITEM_TYPE_ATC_UP:		// h[sOACe Uw͒lUP
		str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_25 );
		WORDSET_RegisterPokeStatusName( wk->wset, 1, 1 );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		break;
	case ITEM_TYPE_DEF_UP:		// h[sOACe hw͒lUP
		str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_25 );
		WORDSET_RegisterPokeStatusName( wk->wset, 1, 2 );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		break;
	case ITEM_TYPE_AGL_UP:		// h[sOACe fw͒lUP
		str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_25 );
		WORDSET_RegisterPokeStatusName( wk->wset, 1, 3 );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		break;
	case ITEM_TYPE_SPA_UP:		// h[sOACe Uw͒lUP
		str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_25 );
		WORDSET_RegisterPokeStatusName( wk->wset, 1, 4 );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		break;
	case ITEM_TYPE_SPD_UP:		// h[sOACe hw͒lUP
		str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_25 );
		WORDSET_RegisterPokeStatusName( wk->wset, 1, 5 );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		break;
	case ITEM_TYPE_PP_UP:		// PPUp
	case ITEM_TYPE_PP_3UP:		// PP3Up
		MSGMAN_GetString( wk->msg_man, mes_pokelist_04_19, wk->msg_buf );
		break;
	case ITEM_TYPE_PP_RCV:		// PP
		MSGMAN_GetString( wk->msg_man, mes_pokelist_04_22, wk->msg_buf );
		break;
	default:
		MSGMAN_GetString( wk->msg_man, mes_pokelist_04_45, wk->msg_buf );
	}
}


void PokeList_ItemUseMain( PLIST_WORK * wk )
{
	switch( ItemRecoverCheck( wk->dat->item ) ){
	case ITEM_TYPE_BTL_ST_UP:		// 퓬pXe[^XAbvn
	case ITEM_TYPE_ETC:				// ̑
		// bZ[W\ďI
		break;

	case ITEM_TYPE_ALLDETH_RCV:		// Sm
		// S̉񕜏
		break;

	case ITEM_TYPE_LV_UP:			// LvUpn
		// bZ[W\ -> p[^\
		break;

	case ITEM_TYPE_NEMURI_RCV:		// 
	case ITEM_TYPE_DOKU_RCV:		// ŉ
	case ITEM_TYPE_YAKEDO_RCV:		// Ώ
	case ITEM_TYPE_KOORI_RCV:		// X
	case ITEM_TYPE_MAHI_RCV:		// ჉
	case ITEM_TYPE_KONRAN_RCV:		// 
	case ITEM_TYPE_ALL_ST_RCV:		// S
	case ITEM_TYPE_MEROMERO_RCV:	// 
	case ITEM_TYPE_HP_UP:			// HPw͒lUP
	case ITEM_TYPE_ATC_UP:			// Uw͒lUP
	case ITEM_TYPE_DEF_UP:			// hw͒lUP
	case ITEM_TYPE_AGL_UP:			// fw͒lUP
	case ITEM_TYPE_SPA_UP:			// Uw͒lUP
	case ITEM_TYPE_SPD_UP:			// hw͒lUP
		wk->strcv_func = NormalRecover;
		break;

	case ITEM_TYPE_HP_RCV:			// HP ( m )
		wk->strcv_func = HP_RecoverFuncInit;
		break;

	case ITEM_TYPE_EVO:				// in
		// i
		break;

	case ITEM_TYPE_PP_UP:			// ppUpn
	case ITEM_TYPE_PP_3UP:			// pp3Upn
	case ITEM_TYPE_PP_RCV:			// pp񕜌n
		// ZI -> bZ[W\
		break;
	}
}

int PokeList_ItemUseMsgWait( void * work )
{
	PLIST_WORK * wk = (PLIST_WORK *)work;

	if( GF_MSG_PrintEndCheck( wk->msg_index ) != 0 ){
		return SEQ_ITEMUSE_WAIT;
	}

	if( sys.trg & ( PAD_BUTTON_A|PAD_BUTTON_B ) ){
		MyItem_SubItem( wk->dat->myitem, wk->dat->item, 1, HEAPID_POKELIST );
		APP_WipeStart( APP_WIPE_OUT, HEAPID_POKELIST, &wk->wipe_flg );
		wk->dat->ret_mode = PL_RET_NORMAL;
		return SEQ_OUT;
	}

	return SEQ_ITEMUSE_WAIT;
}


//--------------------------------------------------------------------------------------------
/**
 * ʏ
 */
//--------------------------------------------------------------------------------------------
static int NormalRecover( void * work )
{
	PLIST_WORK * wk = (PLIST_WORK *)work;

	PokeParty_StatusRecover( wk->dat->pp, wk->dat->item, wk->pos, 0, HEAPID_POKELIST );

	PokeList_PanelPPDataMake( wk, wk->pos );
	PokeListParamPut( wk, wk->pos, MSG_NO_PUT );
	PokeListParamBmpCgxOn( wk, wk->pos );
	PokeList_StatusIconChg( wk, wk->pos, wk->panel[wk->pos].st );	// ԈُACR

	SetStatusRecoverMsg( wk, wk->dat->item );

	PokeListLargeMsgPut( wk, PL_MSG_COMP_EXPAND, 1 );

	wk->strcv_func = PokeList_ItemUseMsgWait;

	return SEQ_ITEMUSE_WAIT;
}


//--------------------------------------------------------------------------------------------
/**
 * HP
 */
//--------------------------------------------------------------------------------------------
static int HP_RecoverFuncInit( void * work )
{
	PLIST_WORK * wk;
	POKEMON_PARAM * pp;
	STRBUF * str;
	u32	now_hp;

	wk = (PLIST_WORK *)work;

	PokeParty_StatusRecover( wk->dat->pp, wk->dat->item, wk->pos, 0, HEAPID_POKELIST );

	pp     = PokeParty_GetMemberPointer( wk->dat->pp, wk->pos );
	now_hp = PokeParaGet( pp, ID_PARA_hp, NULL );
	str    = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_14 );
	WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(pp) );
	WORDSET_RegisterNumber(
		wk->wset,1,now_hp-wk->panel[wk->pos].hp,3,NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT);
	WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
	STRBUF_Delete( str );

	wk->strcv_func = HP_RecoverFuncMain;

	return SEQ_ITEMUSE_WAIT;
}

static int HP_RecoverFuncMain( void * work )
{
	PLIST_WORK * wk = (PLIST_WORK *)work;
	POKEMON_PARAM * pp;
	u32	now_hp;

	pp     = PokeParty_GetMemberPointer( wk->dat->pp, wk->pos );
	now_hp = PokeParaGet( pp, ID_PARA_hp, NULL );

	wk->panel[wk->pos].hp++;

	PokeListHPClear( wk, wk->pos );
	GF_BGL_BmpWinDataFill( &wk->win[WIN_POKE1_HPBAR+wk->pos*5], 0 );

	PokeListHPPut( wk, wk->pos, MSG_ALLPUT );
	PokeListHPBerPut( wk, wk->pos, MSG_ALLPUT );

	if( wk->panel[wk->pos].hp == now_hp ){
		PokeListLargeMsgPut( wk, PL_MSG_COMP_EXPAND, 1 );
		wk->strcv_func = PokeList_ItemUseMsgWait;
	}

	return SEQ_ITEMUSE_WAIT;
}



//--------------------------------------------------------------------------------------------
/**
 * Z}V
 *
 * @retval	"0-3 = Zʒu"
 * @retval	"0xfd = łɊoĂ"
 * @retval	"0xfe = Zς"
 * @retval	"0xff = "
 */
//--------------------------------------------------------------------------------------------
u8 PokeList_WazaOboeCheck( PLIST_WORK * wk, POKEMON_PARAM * pp )
{
	u16	waza;
	u8	i;

	// łɊoĂ邩
	for( i=0; i<4; i++ ){
		waza = (u16)PokeParaGet( pp, ID_PARA_waza1+i, NULL );
		if( waza == wk->dat->waza ){
			return 0xfd;
		}
		if( waza == 0 ){ break; }
	}

	// o邩
	if( 0 ){
		return 0xff;
	}

	// 󂫂邩
	if( i == 4 ){
		return 0xfe;
	}

	return i;
}


int PokeList_WazaOboeInit( PLIST_WORK * wk )
{
	POKEMON_PARAM * pp;
	STRBUF * str;
	u32	ret;

	pp  = PokeParty_GetMemberPointer( wk->dat->pp, wk->pos );
	ret = PokeList_WazaOboeCheck( wk, pp );

	WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(pp) );
	WORDSET_RegisterWazaName( wk->wset, 1, wk->dat->waza );

	switch( ret ){
	case 0:
	case 1:
	case 2:
	case 3:
		PL_WazaSet( wk, pp, ret );
		str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_11 );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		PokeListLargeMsgPut( wk, PL_MSG_COMP_EXPAND, 1 );
		wk->dat->ret_mode = PL_RET_NORMAL;
		wk->next_seq = SEQ_ENDTRG_WAIT;
		break;

	case 0xfd:		// oĂ
		str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_13 );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		PokeListLargeMsgPut( wk, PL_MSG_COMP_EXPAND, 1 );
		wk->dat->ret_mode = PL_RET_NORMAL;
		wk->next_seq = SEQ_ENDTRG_WAIT;
		break;

	case 0xfe:		// 󂫂Ȃ
		str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_06 );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		PokeListLargeMsgPut( wk, PL_MSG_COMP_EXPAND, 1 );
		wk->yesno.yes = PL_NewWazaSetYes;
		wk->yesno.no  = PL_NewWazaSetNo;
		wk->next_seq = SEQ_YESNO_INIT;
		break;

	case 0xff:		// 
		str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_12 );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		PokeListLargeMsgPut( wk, PL_MSG_COMP_EXPAND, 1 );
		wk->dat->ret_mode = PL_RET_NORMAL;
		wk->next_seq = SEQ_ENDTRG_WAIT;
		break;
	}

	return SEQ_MSG_WAIT;
}

int PokeList_WazaSetRetInit( PLIST_WORK * wk )
{
	POKEMON_PARAM * pp;
	STRBUF * str;

	pp  = PokeParty_GetMemberPointer( wk->dat->pp, wk->pos );

	WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(pp) );

	if( wk->dat->waza_pos == 4 ){
		WORDSET_RegisterWazaName( wk->wset, 1, wk->dat->waza );
		return PL_NewWazaSetNo( wk );
	}

	WORDSET_RegisterWazaName(
		wk->wset, 1, PokeParaGet( pp, ID_PARA_waza1+wk->dat->waza_pos, NULL ) );
	str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_10 );
	WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
	STRBUF_Delete( str );
	PokeListLargeMsgPut( wk, PL_MSG_COMP_EXPAND, 1 );

	wk->next_seq = SEQ_WAZASET_RET_SET;
	return SEQ_MSG_WAIT;
}

int PokeList_WazaSetRetSet( PLIST_WORK * wk )
{
	POKEMON_PARAM * pp;
	STRBUF * str;

	if( sys.trg & (PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL) ){
		pp  = PokeParty_GetMemberPointer( wk->dat->pp, wk->pos );

		PL_WazaSet( wk, pp, wk->dat->waza_pos );
		str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_11 );
		WORDSET_RegisterWazaName( wk->wset, 1, wk->dat->waza );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		PokeListLargeMsgPut( wk, PL_MSG_COMP_EXPAND, 0 );
		wk->dat->ret_mode = PL_RET_NORMAL;
		wk->next_seq = SEQ_ENDTRG_WAIT;
		return SEQ_MSG_WAIT;
	}
	return SEQ_WAZASET_RET_SET;
}

static int PL_NewWazaSetYes( void * work )
{
	PLIST_WORK * wk;
	STRBUF * str;

	wk  = work;
	str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_09 );
	WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
	STRBUF_Delete( str );
	PokeListLargeMsgPut( wk, PL_MSG_COMP_EXPAND, 0 );
	wk->dat->ret_mode = PL_RET_WAZASET;
	wk->next_seq = SEQ_ENDTRG_WAIT;
	return SEQ_MSG_WAIT;
}

static int PL_NewWazaSetNo( void * work )
{
	PLIST_WORK * wk;
	STRBUF * str;

	wk  = work;
	str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_07 );
	WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
	STRBUF_Delete( str );
	PokeListLargeMsgPut( wk, PL_MSG_COMP_EXPAND, 1 );
	wk->yesno.yes = PL_NewWazaSetCancelYes;
	wk->yesno.no  = PL_NewWazaSetCancelNo;
	wk->next_seq = SEQ_YESNO_INIT;
	return SEQ_MSG_WAIT;
}

static int PL_NewWazaSetCancelYes( void * work )
{
	PLIST_WORK * wk;
	STRBUF * str;

	wk  = work;
	str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_08 );
	WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
	STRBUF_Delete( str );
	PokeListLargeMsgPut( wk, PL_MSG_COMP_EXPAND, 0 );
	wk->dat->ret_mode = PL_RET_NORMAL;
	wk->next_seq = SEQ_ENDTRG_WAIT;
	return SEQ_MSG_WAIT;
}

static int PL_NewWazaSetCancelNo( void * work )
{
	PLIST_WORK * wk;
	STRBUF * str;

	wk  = work;
	str = MSGMAN_AllocString( wk->msg_man, mes_pokelist_04_06 );
	WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
	STRBUF_Delete( str );
	PokeListLargeMsgPut( wk, PL_MSG_COMP_EXPAND, 0 );
	wk->yesno.yes = PL_NewWazaSetYes;
	wk->yesno.no  = PL_NewWazaSetNo;
	wk->next_seq = SEQ_YESNO_INIT;
	return SEQ_MSG_WAIT;
}

static void PL_WazaSet( PLIST_WORK * wk, POKEMON_PARAM * pp, u32 pos )
{
	u32	buf;

	buf = wk->dat->waza;
	PokeParaPut( pp, ID_PARA_waza1+pos, &buf );
	buf = 0;
	PokeParaPut( pp, ID_PARA_pp_count1+pos, &buf );
	buf = WT_PPMaxGet( wk->dat->waza, 0 );
	PokeParaPut( pp, ID_PARA_pp1+pos, &buf );

	if( wk->dat->item != ITEM_DUMMY_DATA ){
		if( HidenWazaCheck( wk->dat->waza ) == FALSE ){
			MyItem_SubItem( wk->dat->myitem, wk->dat->item, 1, HEAPID_POKELIST );
		}
	}
}
