//============================================================================================
/**
 * @file	plist_menu.c
 * @bfief	|PXgʃj[֘A
 * @author	Hiroyuki Nakamura
 * @date	05.10.18
 */
//============================================================================================
#include "common.h"
#include "system/procsys.h"
#include "system/bmp_menu.h"
#include "system/fontproc.h"
#include "system/msgdata.h"
#include "system/wordset.h"
#include "system/numfont.h"
#include "system/clact_tool.h"
#include "system/window.h"
#include "system/brightness.h"
#include "msgdata/msg_pokelist.h"
#include "poketool/poke_tool.h"
#include "poketool/pokeparty.h"
#include "poketool/monsno.h"
#include "itemtool/item.h"
#include "itemtool/myitem.h"
#include "application/app_tool.h"
#include "application/mailtool.h"
/*
#include "system/pm_str.h"
#include "msgdata/msg_pokelist.h"
#include "application/app_tool.h"
*/

#define	PLIST_MENU_H_GLOBAL
#include "application/pokelist.h"
#include "plist_sys.h"
#include "plist_bmp.h"
#include "plist_obj.h"
#include "plist_menu.h"



static void Menu_RowSelectInit( PLIST_WORK * wk, int * seq );
static void Menu_ChgSelect( PLIST_WORK * wk, int * seq );
static void Menu_Status( PLIST_WORK * wk, int * seq );
static void Menu_Skill( PLIST_WORK * wk, int * seq );

static void Menu_NarabikaeMain( void * work );
static void Menu_NarabikaeScreenWrite( PLIST_WORK * wk, u8 pos );
static void Menu_NarabikaeObjMove( PLIST_WORK * wk, u8 pos, u8 mv );
static void Menu_NarabikaeChg( PLIST_WORK * wk );
static void PLM_NarabikaeScrnRemake( PLIST_WORK * wk, u8 pos );

static void Menu_Iaigiri( PLIST_WORK * wk, int * seq );
static void Menu_Iwakudaki( PLIST_WORK * wk, int * seq );
static void Menu_Kairiki( PLIST_WORK * wk, int * seq );
static void Menu_Naminori( PLIST_WORK * wk, int * seq );
static void Menu_Kiribarai( PLIST_WORK * wk, int * seq );
static void Menu_RockClimb( PLIST_WORK * wk, int * seq );
static void Menu_Sorawotobu( PLIST_WORK * wk, int * seq );
static void Menu_Takinobori( PLIST_WORK * wk, int * seq );
static void Menu_Flash( PLIST_WORK * wk, int * seq );
static void Menu_Teleport( PLIST_WORK * wk, int * seq );
static void Menu_Anawohoru( PLIST_WORK * wk, int * seq );
static void Menu_Amaikaori( PLIST_WORK * wk, int * seq );

static void Menu_ItemMenuInit( PLIST_WORK * wk, int * seq );
static void Menu_ItemMenuItemSet( PLIST_WORK * wk, int *seq );
static void Menu_ItemMenuItemGet( PLIST_WORK * wk, int * seq );
static void Menu_MailMenuInit( PLIST_WORK * wk, int * seq );
static void Menu_MailMenuMailRead( PLIST_WORK * wk, int * seq );
static void Menu_MailMenuMailGet( PLIST_WORK * wk, int * seq );
static int PL_MailGetPCYes( void * work );
static int PL_MailGetPCNo( void * work );
static int PL_MailGetBagYes( void * work );
static int PL_MailGetBagNo( void * work );
static void Menu_ContestIn( PLIST_WORK * wk, int * seq );
static void Menu_BattleIn( PLIST_WORK * wk, int * seq );
static void Menu_BattleOut( PLIST_WORK * wk, int * seq );

static const u32 MenuParamTbl[] = {
	(const u32)Menu_RowSelectInit,		// Ȃт
	(const u32)Menu_Status,				// 悳݂
	(const u32)Menu_ItemMenuInit,		// 
	(const u32)Menu_ItemMenuItemSet,	// ̃j[F
	(const u32)Menu_ItemMenuItemGet,	// ̃j[F
	(const u32)Menu_MailMenuInit,		// [
	(const u32)Menu_MailMenuMailRead,	// [@
	(const u32)Menu_MailMenuMailGet,	// [@Ƃ
	BMPMENU_CANCEL,					// 
	BMPMENU_CANCEL,					// ߂
	(const u32)Menu_ChgSelect,		// ꂩ
	(const u32)Menu_BattleIn,			// 񂩂i퓬QIj
	(const u32)Menu_BattleOut,			// 񂩂Ȃ
	(const u32)Menu_ContestIn,			// 񂩂iReXgQj

	(const u32)Menu_Iwakudaki,		// ZF킭
	(const u32)Menu_Iaigiri,		// ZF
	(const u32)Menu_Sorawotobu,		// ZFƂ
	(const u32)Menu_Kiribarai,		// ZF΂炢
	(const u32)Menu_Kairiki,		// ZF肫
	(const u32)Menu_Naminori,		// ZFȂ݂̂
	(const u32)Menu_RockClimb,		// ZFbNNC
	(const u32)Menu_Takinobori,		// ZF̂ڂ

	(const u32)Menu_Flash,			// ZFtbV
	(const u32)Menu_Teleport,		// ZFe|[g
	(const u32)Menu_Anawohoru,		// ZFȂق
	(const u32)Menu_Amaikaori,		// ZF܂

	BMPMENU_CANCEL
};


u32 PokeListMenuParamGet( u8 id )
{
	return MenuParamTbl[id];
}


//--------------------------------------------------------------------------------------------
/**
 * j[j
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PokeListMenuExit( PLIST_WORK * wk )
{
	BmpMenuWinClear( &wk->add_win[ADD_WIN_MENU], WINDOW_TRANS_OFF );
	GF_BGL_BmpWinOff( &wk->add_win[ADD_WIN_MENU] );
	BmpMenuExit( wk->mw, NULL );
	BMP_MENULIST_Delete( wk->md );
	GF_BGL_BmpWinDel( &wk->add_win[ADD_WIN_MENU] );
}


//============================================================================================
//	
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * j[úv
 *
 * @param
 *
 * @return
 */
//--------------------------------------------------------------------------------------------
static void Menu_ItemMenuInit( PLIST_WORK * wk, int * seq )
{
	BMPMENU_HEADER	mh;

	PokeListMenuExit( wk );

	PokeListMiddleMsgPut( wk, mes_pokelist_03_02, 0 );

	wk->md = BMP_MENULIST_Create( 3, HEAPID_POKELIST );
	BMP_MENULIST_AddString(
		wk->md, wk->menu_str[MENU_ITEM_S], PokeListMenuParamGet(MENU_ITEM_S) );
	BMP_MENULIST_AddString(
		wk->md, wk->menu_str[MENU_ITEM_G], PokeListMenuParamGet(MENU_ITEM_G) );
	BMP_MENULIST_AddString(
		wk->md, wk->menu_str[MENU_CANCEL], PokeListMenuParamGet(MENU_CANCEL) );

	mh.menu  = wk->md;
	mh.win   = &wk->win[WIN_ITEM_MENU];
	mh.font  = FONT_SYSTEM;
	mh.x_max = 1;
	mh.y_max = 3;
	mh.line_spc = 0;
	mh.c_disp_f = 0;
	mh.loop_f = 0;

	BmpMenuWinWrite( &wk->win[WIN_ITEM_MENU], WINDOW_TRANS_OFF, PL_MENU_WIN_CGX, PAL_MENU_WIN );
	wk->mw = BmpMenuAddEx( &mh, 8, 0, 0, HEAPID_POKELIST, PAD_BUTTON_CANCEL );

	*seq = SEQ_ITEM_MENU;
}

//--------------------------------------------------------------------------------------------
/**
 * j[uv
 *
 * @param
 *
 * @return
 */
//--------------------------------------------------------------------------------------------
static void Menu_ItemMenuItemSet( PLIST_WORK * wk, int * seq )
{
	BmpMenuExit( wk->mw, NULL );
	BMP_MENULIST_Delete( wk->md );

	wk->dat->ret_mode = PL_RET_ITEMSET;

	APP_WipeStart( APP_WIPE_OUT, HEAPID_POKELIST, &wk->wipe_flg );
	*seq = SEQ_OUT;
}


//--------------------------------------------------------------------------------------------
/**
 * j[uv
 *
 * @param
 *
 * @return
 */
//--------------------------------------------------------------------------------------------
static void Menu_ItemMenuItemGet( PLIST_WORK * wk, int * seq )
{
	POKEMON_PARAM * pp;

	BmpMenuWinClear( &wk->win[WIN_ITEM_MENU], WINDOW_TRANS_OFF );
	BmpMenuExit( wk->mw, NULL );
	BMP_MENULIST_Delete( wk->md );

	if( wk->panel[wk->pos].item == 0 ){
		pp = PokeParty_GetMemberPointer( wk->dat->pp, wk->pos );
		MSGMAN_GetString( wk->msg_man, mes_pokelist_04_29, wk->str_buf );
		WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(pp) );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, wk->str_buf );
	}else if(MyItem_AddItem(wk->dat->myitem,wk->panel[wk->pos].item,1,HEAPID_POKELIST)==TRUE){
		u32	item;

		pp = PokeParty_GetMemberPointer( wk->dat->pp, wk->pos );
		item = 0;
		PokeParaPut( pp, ID_PARA_item, &item );

		MSGMAN_GetString( wk->msg_man, mes_pokelist_04_30, wk->str_buf );
		WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(pp) );
		WORDSET_RegisterItemName( wk->wset, 1, wk->panel[wk->pos].item );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, wk->str_buf );
		wk->panel[wk->pos].item = 0;
		PokeList_ItemIconChg( wk, wk->pos, wk->panel[wk->pos].item );
	}else{
		MSGMAN_GetString( wk->msg_man, mes_pokelist_04_31, wk->msg_buf );
	}

	BmpTalkWinWrite( &wk->win[WIN_L_MSG], WINDOW_TRANS_OFF, PL_TALK_WIN_CGX, PAL_TALK_WIN );
	GF_BGL_BmpWinDataFill( &wk->win[WIN_L_MSG], FBMP_COL_WHITE );
	PokeList_TalkMsgStart( wk );
	*seq = SEQ_ITEM_MENU_GET;
}

int PokeList_ItemMenuItemGetEndWait( PLIST_WORK * wk )
{
	if( GF_MSG_PrintEndCheck( wk->msg_index ) == 0 ){
		if( sys.trg & (PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL) ){
			BmpTalkWinClear( &wk->win[WIN_L_MSG], WINDOW_TRANS_OFF );
			PokeListSmallMsgPut( wk, mes_pokelist_02_01, 1 );
			CATS_ObjectPaletteSet( wk->act_work[PLIST_ACT_CURSOR1], 0 );
			return SEQ_MAIN;
		}
	}
	return SEQ_ITEM_MENU_GET;
}


//============================================================================================
//	[
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * j[u[v
 *
 * @param
 *
 * @return
 */
//--------------------------------------------------------------------------------------------
static void Menu_MailMenuInit( PLIST_WORK * wk, int * seq )
{
	BMPMENU_HEADER	mh;

	PokeListMenuExit( wk );

	PokeListMiddleMsgPut( wk, mes_pokelist_03_03, 0 );

	wk->md = BMP_MENULIST_Create( 3, HEAPID_POKELIST );
	BMP_MENULIST_AddString(
		wk->md, wk->menu_str[MENU_MAIL_R], PokeListMenuParamGet(MENU_MAIL_R) );
	BMP_MENULIST_AddString(
		wk->md, wk->menu_str[MENU_MAIL_G], PokeListMenuParamGet(MENU_MAIL_G) );
	BMP_MENULIST_AddString(
		wk->md, wk->menu_str[MENU_CANCEL], PokeListMenuParamGet(MENU_CANCEL) );

	mh.menu  = wk->md;
	mh.win   = &wk->win[WIN_ITEM_MENU];
	mh.font  = FONT_SYSTEM;
	mh.x_max = 1;
	mh.y_max = 3;
	mh.line_spc = 0;
	mh.c_disp_f = 0;
	mh.loop_f = 0;

	BmpMenuWinWrite( &wk->win[WIN_ITEM_MENU], WINDOW_TRANS_OFF, PL_MENU_WIN_CGX, PAL_MENU_WIN );
	wk->mw = BmpMenuAddEx( &mh, 8, 0, 0, HEAPID_POKELIST, PAD_BUTTON_CANCEL );

	*seq = SEQ_ITEM_MENU;
}

//--------------------------------------------------------------------------------------------
/**
 * j[u[@ށv
 *
 * @param
 *
 * @return
 */
//--------------------------------------------------------------------------------------------
static void Menu_MailMenuMailRead( PLIST_WORK * wk, int * seq )
{
	BmpMenuExit( wk->mw, NULL );
	BMP_MENULIST_Delete( wk->md );

	wk->dat->ret_mode = PL_RET_MAILREAD;

	APP_WipeStart( APP_WIPE_OUT, HEAPID_POKELIST, &wk->wipe_flg );
	*seq = SEQ_OUT;
}

//--------------------------------------------------------------------------------------------
/**
 * j[u[@Ƃv
 *
 * @param
 *
 * @return
 */
//--------------------------------------------------------------------------------------------
static void Menu_MailMenuMailGet( PLIST_WORK * wk, int * seq )
{
	BmpMenuWinClear( &wk->win[WIN_ITEM_MENU], WINDOW_TRANS_OFF );
	BmpMenuExit( wk->mw, NULL );
	BMP_MENULIST_Delete( wk->md );

	PokeListLargeMsgPut( wk, mes_pokelist_04_01, 1 );
	wk->yesno.yes = PL_MailGetPCYes;
	wk->yesno.no  = PL_MailGetPCNo;
	wk->next_seq = SEQ_YESNO_INIT;
	*seq = SEQ_MSG_WAIT;
}

static int PL_MailGetPCYes( void * work )
{
	PLIST_WORK * wk = work;
	POKEMON_PARAM * pp;

	wk = work;
	pp = PokeParty_GetMemberPointer( wk->dat->pp, wk->pos );

	if( MailSys_MoveMailPoke2Paso(wk->dat->mailblock,pp,HEAPID_POKELIST) != MAILDATA_NULLID ){
		wk->panel[wk->pos].item = 0;
		PokeList_ItemIconChg( wk, wk->pos, wk->panel[wk->pos].item );
		PokeListLargeMsgPut( wk, mes_pokelist_04_02, 0 );
	}else{
		PokeListLargeMsgPut( wk, mes_pokelist_04_04, 0 );
	}
	wk->next_seq = SEQ_ITEMGET_END;
	return SEQ_MSG_WAIT;
}

static int PL_MailGetPCNo( void * work )
{
	PLIST_WORK * wk = work;

	PokeListLargeMsgPut( wk, mes_pokelist_04_03, 0 );
	wk->yesno.yes = PL_MailGetBagYes;
	wk->yesno.no  = PL_MailGetBagNo;
	wk->next_seq = SEQ_YESNO_INIT;
	return SEQ_MSG_WAIT;
}

static int PL_MailGetBagYes( void * work )
{
	PLIST_WORK * wk = work;

	if( MyItem_AddItem( wk->dat->myitem, wk->panel[wk->pos].item, 1, HEAPID_POKELIST ) == TRUE ){
		POKEMON_PARAM * pp;
		u32	item;

		pp = PokeParty_GetMemberPointer( wk->dat->pp, wk->pos );
		item = 0;
		PokeParaPut( pp, ID_PARA_item, &item );

		wk->panel[wk->pos].item = 0;
		PokeList_ItemIconChg( wk, wk->pos, wk->panel[wk->pos].item );
		PokeListLargeMsgPut( wk, mes_pokelist_04_05, 0 );
	}else{
		PokeListLargeMsgPut( wk, mes_pokelist_04_31, 0 );
	}
	wk->next_seq = SEQ_ITEMGET_END;
	return SEQ_MSG_WAIT;
}

static int PL_MailGetBagNo( void * work )
{
	PLIST_WORK * wk = work;

	BmpTalkWinClear( &wk->win[WIN_L_MSG], WINDOW_TRANS_OFF );
	PokeListSmallMsgPut( wk, mes_pokelist_02_01, 1 );
	CATS_ObjectPaletteSet( wk->act_work[PLIST_ACT_CURSOR1], 0 );
	return SEQ_MAIN;
}

int PokeList_ItemGetEnd( PLIST_WORK * wk )
{
	if( sys.trg & (PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL) ){
		BmpTalkWinClear( &wk->win[WIN_L_MSG], WINDOW_TRANS_OFF );
		PokeListSmallMsgPut( wk, mes_pokelist_02_01, 1 );
		CATS_ObjectPaletteSet( wk->act_work[PLIST_ACT_CURSOR1], 0 );
		return SEQ_MAIN;
	}
	return SEQ_ITEMGET_END;
}









//--------------------------------------------------------------------------------------------
/**
 * Ȃт
 *
 */
//--------------------------------------------------------------------------------------------
static void Menu_RowSelectInit( PLIST_WORK * wk, int * seq )
{
	s16	x, y;

	wk->chg_flg = 1;
	wk->chg_pos = wk->pos;

	// _~[J[\\
	CATS_ObjectPaletteSet( wk->act_work[PLIST_ACT_CURSOR1], 0 );
	CATS_ObjectPosGet( wk->act_work[PLIST_ACT_CURSOR1], &x, &y );
	CATS_ObjectPosSet( wk->act_work[PLIST_ACT_CURSOR2], x, y );
	CLACT_AnmChg(
		wk->act_work[PLIST_ACT_CURSOR2],
		PokeListSelCursorCheck( wk->dat->type, wk->chg_pos )+2 );
	CLACT_SetDrawFlag( wk->act_work[PLIST_ACT_CURSOR2], 1 );

	// v[gJ[`FW
	PokeListPanelPaletteSet( wk, wk->chg_pos );

	// bZ[W\
	BmpTalkWinClear( &wk->win[WIN_M_MSG], WINDOW_TRANS_OFF );
	// j[폜
	PokeListMenuExit( wk );

	// bZ[W\
	PokeListSmallMsgPut( wk, mes_pokelist_02_02, 1 );

	*seq = SEQ_ROW_SEL;
}

void PokeListRowCancel( PLIST_WORK * wk )
{
	wk->chg_flg = 0;
	CLACT_SetDrawFlag( wk->act_work[PLIST_ACT_CURSOR2], 0 );
	if( wk->pos < PL_SEL_POS_ENTER ){
		PokeListPanelPaletteSet( wk, wk->pos );
	}
	PokeListPanelPaletteSet( wk, wk->chg_pos );
	PokeListSmallMsgPut( wk, mes_pokelist_02_01, 0 );
}

void PokeListMenuRowMoveInit( PLIST_WORK * wk )
{
	u16 * plate_bg;
	u16 * str_bg;
	s8	px1, py1, px2, py2;
	u16	i;

	wk->chg_wk.pos[0] = wk->pos;
	wk->chg_wk.pos[1] = wk->chg_pos;
	wk->chg_wk.flg    = 1;
	wk->chg_wk.cnt    = 0;
	wk->chg_wk.seq    = 0;

	if( wk->chg_wk.pos[0] & 1 ){
		wk->chg_wk.mv[0] = 1;
	}else{
		wk->chg_wk.mv[0] = 0;
	}
	if( wk->chg_wk.pos[1] & 1 ){
		wk->chg_wk.mv[1] = 1;
	}else{
		wk->chg_wk.mv[1] = 0;
	}

	// XN[Rs[
	plate_bg = (u16 *)GF_BGL_ScreenAdrsGet( wk->bgl, GF_BGL_FRAME2_M );
	str_bg   = (u16 *)GF_BGL_ScreenAdrsGet( wk->bgl, GF_BGL_FRAME1_M );

	px1 = wk->panel[ wk->chg_wk.pos[0] ].plate_px;
	py1 = wk->panel[ wk->chg_wk.pos[0] ].plate_py;
	px2 = wk->panel[ wk->chg_wk.pos[1] ].plate_px;
	py2 = wk->panel[ wk->chg_wk.pos[1] ].plate_py;

	for( i=0; i<PL_PANEL_SY; i++ ){
		// 1
		memcpy(
			&wk->chg_wk.plate_bg[0][ i*PL_PANEL_SX ],
			&plate_bg[ px1 + (py1+i)*32 ],
			PL_PANEL_SX*2 );
		memcpy(
			&wk->chg_wk.str_bg[0][ i*PL_PANEL_SX ],
			&str_bg[ px1 + (py1+i)*32 ],
			PL_PANEL_SX*2 );
		// 2
		memcpy(
			&wk->chg_wk.plate_bg[1][ i*PL_PANEL_SX ],
			&plate_bg[ px2 + (py2+i)*32 ],
			PL_PANEL_SX*2 );
		memcpy(
			&wk->chg_wk.str_bg[1][ i*PL_PANEL_SX ],
			&str_bg[ px2 + (py2+i)*32 ],
			PL_PANEL_SX*2 );
	}

	// J[\\
	CLACT_SetDrawFlag( wk->act_work[PLIST_ACT_CURSOR1], 0 );
	CLACT_SetDrawFlag( wk->act_work[PLIST_ACT_CURSOR2], 0 );

	wk->vblank_func = Menu_NarabikaeMain;
}

static void Menu_NarabikaeMain( void * work )
{
	PLIST_WORK * wk = work;
	MENU_NARABIKAE_WORK * nwk = &wk->chg_wk;

	switch( nwk->seq ){
	case 0:		// ړ
		nwk->cnt+=1;

		Menu_NarabikaeScreenWrite( wk, 0 );
		Menu_NarabikaeScreenWrite( wk, 1 );

		Menu_NarabikaeObjMove( wk, 0, nwk->mv[0] );
		Menu_NarabikaeObjMove( wk, 1, nwk->mv[1] );

		GF_BGL_LoadScreenReq( wk->bgl, GF_BGL_FRAME2_M );
		GF_BGL_LoadScreenReq( wk->bgl, GF_BGL_FRAME1_M );

		if( nwk->cnt == 16 ){
			nwk->seq = 1;
		}
		break;
	case 1:		// ꂩ
		Menu_NarabikaeChg( wk );
		nwk->seq = 2;
		break;
	case 2:		// ړ
		nwk->cnt-=1;

		Menu_NarabikaeScreenWrite( wk, 0 );
		Menu_NarabikaeScreenWrite( wk, 1 );

		Menu_NarabikaeObjMove( wk, 0, nwk->mv[0]^1 );
		Menu_NarabikaeObjMove( wk, 1, nwk->mv[1]^1 );

		GF_BGL_LoadScreenReq( wk->bgl, GF_BGL_FRAME2_M );
		GF_BGL_LoadScreenReq( wk->bgl, GF_BGL_FRAME1_M );

		if( nwk->cnt == 0 ){
			nwk->seq = 3;
		}
		break;
	case 3:		// AEI
		PokeParty_ExchangePosition( wk->dat->pp, nwk->pos[0], nwk->pos[1] );
		CLACT_SetDrawFlag( wk->act_work[PLIST_ACT_CURSOR1], 1 );
		nwk->flg = 0;
		wk->chg_flg = 0;
		PokeListPanelPaletteSet( wk, wk->pos );
		PokeListPanelPaletteSet( wk, wk->chg_pos );
		PokeListSmallMsgPut( wk, mes_pokelist_02_01, 0 );
		wk->vblank_func = NULL;
	}
}

static void Menu_NarabikaeScreenWrite( PLIST_WORK * wk, u8 pos )
{
	MENU_NARABIKAE_WORK * nwk;
	s8	px, py;
	u8	i;

	nwk = &wk->chg_wk;

	px = wk->panel[ nwk->pos[pos] ].plate_px;
	py = wk->panel[ nwk->pos[pos] ].plate_py;

	GF_BGL_ScrFill(
		wk->bgl, GF_BGL_FRAME2_M, 0, px, py, PL_PANEL_SX, PL_PANEL_SY, GF_BGL_SCRWRT_PALNL );
	GF_BGL_ScrFill(
		wk->bgl, GF_BGL_FRAME1_M, 0, px, py, PL_PANEL_SX, PL_PANEL_SY, GF_BGL_SCRWRT_PALNL );

	if( nwk->mv[pos] == 0 ){
		GF_BGL_ScrWriteExpand(
			wk->bgl, GF_BGL_FRAME2_M, px, py, 16-nwk->cnt, PL_PANEL_SY,
			&nwk->plate_bg[pos], nwk->cnt, 0, PL_PANEL_SX, PL_PANEL_SY );
		GF_BGL_ScrWriteExpand(
			wk->bgl, GF_BGL_FRAME1_M, px, py, 16-nwk->cnt, PL_PANEL_SY,
			&nwk->str_bg[pos], nwk->cnt, 0, PL_PANEL_SX, PL_PANEL_SY );
	}else{
		GF_BGL_ScrWriteExpand(
			wk->bgl, GF_BGL_FRAME2_M, px+nwk->cnt, py, 16-nwk->cnt, PL_PANEL_SY,
			&nwk->plate_bg[pos], 0, 0, PL_PANEL_SX, PL_PANEL_SY );
		GF_BGL_ScrWriteExpand(
			wk->bgl, GF_BGL_FRAME1_M, px+nwk->cnt, py, 16-nwk->cnt, PL_PANEL_SY,
			&nwk->str_bg[pos], 0, 0, PL_PANEL_SX, PL_PANEL_SY );
	}
}

static void Menu_NarabikaeObjMove( PLIST_WORK * wk, u8 pos, u8 mv )
{
	MENU_NARABIKAE_WORK * nwk;
	s16	x, y;

	nwk = &wk->chg_wk;

	CATS_ObjectPosGet( wk->act_work[PLIST_ACT_BALL1+nwk->pos[pos]], &x, &y );

	if( mv == 0 ){
		wk->panel[nwk->pos[pos]].mons_px -= 8;
		wk->panel[nwk->pos[pos]].st_px -= 8;
		wk->panel[nwk->pos[pos]].item_px -= 8;
		x -= 8;
	}else{
		wk->panel[nwk->pos[pos]].mons_px += 8;
		wk->panel[nwk->pos[pos]].st_px += 8;
		wk->panel[nwk->pos[pos]].item_px += 8;
		x += 8;
	}

	CATS_ObjectPosSet(
		wk->panel[nwk->pos[pos]].icon_cwp,
		wk->panel[nwk->pos[pos]].mons_px,
		wk->panel[nwk->pos[pos]].mons_py );

	CATS_ObjectPosSet(
		wk->act_work[PLIST_ACT_ST1+nwk->pos[pos]],
		wk->panel[nwk->pos[pos]].st_px,
		wk->panel[nwk->pos[pos]].st_py );

	CATS_ObjectPosSet(
		wk->act_work[PLIST_ACT_ITEM1+nwk->pos[pos]],
		wk->panel[nwk->pos[pos]].item_px,
		wk->panel[nwk->pos[pos]].item_py );

	CATS_ObjectPosSet( wk->act_work[PLIST_ACT_BALL1+nwk->pos[pos]], x, y );
}

static void Menu_NarabikaeChg( PLIST_WORK * wk )
{
	PL_PANEL_DATA * cpy;

	MENU_NARABIKAE_WORK * nwk;
	CATS_ACT_PTR	cap;
	s16	pos;

	nwk = &wk->chg_wk;

	// f[^ꂩ
	cpy = sys_AllocMemory( HEAPID_POKELIST, sizeof(PL_PANEL_DATA) );
	*cpy = wk->panel[ nwk->pos[0] ];
	wk->panel[ nwk->pos[0] ] = wk->panel[ nwk->pos[1] ];
	wk->panel[ nwk->pos[1] ] = *cpy;
	sys_FreeMemory( HEAPID_POKELIST, cpy );

	// v[gƃACR̍W͖߂
	pos = wk->panel[ nwk->pos[0] ].mons_px;
	wk->panel[ nwk->pos[0] ].mons_px = wk->panel[ nwk->pos[1] ].mons_px;
	wk->panel[ nwk->pos[1] ].mons_px = pos;
	pos = wk->panel[ nwk->pos[0] ].mons_py;
	wk->panel[ nwk->pos[0] ].mons_py = wk->panel[ nwk->pos[1] ].mons_py;
	wk->panel[ nwk->pos[1] ].mons_py = pos;

	pos = wk->panel[ nwk->pos[0] ].st_px;
	wk->panel[ nwk->pos[0] ].st_px = wk->panel[ nwk->pos[1] ].st_px;
	wk->panel[ nwk->pos[1] ].st_px = pos;
	pos = wk->panel[ nwk->pos[0] ].st_py;
	wk->panel[ nwk->pos[0] ].st_py = wk->panel[ nwk->pos[1] ].st_py;
	wk->panel[ nwk->pos[1] ].st_py = pos;

	pos = wk->panel[ nwk->pos[0] ].item_px;
	wk->panel[ nwk->pos[0] ].item_px = wk->panel[ nwk->pos[1] ].item_px;
	wk->panel[ nwk->pos[1] ].item_px = pos;
	pos = wk->panel[ nwk->pos[0] ].item_py;
	wk->panel[ nwk->pos[0] ].item_py = wk->panel[ nwk->pos[1] ].item_py;
	wk->panel[ nwk->pos[1] ].item_py = pos;

	pos = wk->panel[ nwk->pos[0] ].plate_px;
	wk->panel[ nwk->pos[0] ].plate_px = wk->panel[ nwk->pos[1] ].plate_px;
	wk->panel[ nwk->pos[1] ].plate_px = pos;
	pos = wk->panel[ nwk->pos[0] ].plate_py;
	wk->panel[ nwk->pos[0] ].plate_py = wk->panel[ nwk->pos[1] ].plate_py;
	wk->panel[ nwk->pos[1] ].plate_py = pos;

	// p[^
	PokeListParamPut( wk, nwk->pos[0], MSG_NO_PUT );
	PokeListParamPut( wk, nwk->pos[1], MSG_NO_PUT );
	PokeListParamBmpCgxOn( wk, nwk->pos[0] );
	PokeListParamBmpCgxOn( wk, nwk->pos[1] );

	PLM_NarabikaeScrnRemake( wk, 0 );
	PLM_NarabikaeScrnRemake( wk, 1 );

	PokeList_StatusIconChg( wk, nwk->pos[0], wk->panel[nwk->pos[0]].st );	// ԈُACR
	PokeList_StatusIconChg( wk, nwk->pos[1], wk->panel[nwk->pos[1]].st );	// ԈُACR

	PokeList_ItemIconChg( wk, nwk->pos[0], wk->panel[nwk->pos[0]].item );	// ACeACR
	PokeList_ItemIconChg( wk, nwk->pos[1], wk->panel[nwk->pos[1]].item );	// ACeACR
}

static void PLM_NarabikaeScrnRemake( PLIST_WORK * wk, u8 pos )
{
	MENU_NARABIKAE_WORK * nwk;
	const u16 * scrn;
	u16 * buf;
	u16	pal;
	u16	i;

	nwk  = &wk->chg_wk;
	buf  = nwk->plate_bg[pos];
	scrn = PokeList_HPGageCharGet();

	if( wk->panel[ nwk->pos[pos] ].mons == MONSNO_TAMAGO ){
		for( i=0; i<PL_PANEL_HPGAGE_SX; i++ ){
			pal = buf[PL_PANEL_HPGAGE_PY*16+PL_PANEL_HPGAGE_PX+i] & 0xf000;
			buf[PL_PANEL_HPGAGE_PY*16+PL_PANEL_HPGAGE_PX+i] = pal | PL_PANEL_HPGAGE_CLEAR_CHR;
		}
	}else{
		for( i=0; i<PL_PANEL_HPGAGE_SX; i++ ){
			pal = buf[PL_PANEL_HPGAGE_PY*16+PL_PANEL_HPGAGE_PX+i] & 0xf000;
			buf[PL_PANEL_HPGAGE_PY*16+PL_PANEL_HPGAGE_PX+i] = pal | scrn[i];
		}
	}
}




//--------------------------------------------------------------------------------------------
/**
 * 񂩂i퓬QIj
 *
 */
//--------------------------------------------------------------------------------------------
static void Menu_BattleIn( PLIST_WORK * wk, int * seq )
{
	u8	i;

	BmpTalkWinClear( &wk->win[WIN_M_MSG], WINDOW_TRANS_OFF );
	PokeListMenuExit( wk );

	for( i=0; i<wk->dat->in_max; i++ ){
		if( wk->dat->in_num[i] != 0 ){ continue; }

		wk->dat->in_num[i] = wk->pos+1;

		PokeList_PanelBattleInCommPut( wk, wk->pos );
		PokeListSmallMsgPut( wk, mes_pokelist_02_06, 1 );

		CATS_ObjectPaletteSet( wk->act_work[PLIST_ACT_CURSOR1], 0 );
		*seq = SEQ_MAIN;
		return;
	}

	switch( wk->dat->in_max ){
	case 2:
		PokeListLargeMsgPut( wk, mes_pokelist_04_40, 1 );
		break;
	case 3:
		PokeListLargeMsgPut( wk, mes_pokelist_04_62, 1 );
		break;
	default:
		PokeListLargeMsgPut( wk, mes_pokelist_04_63, 1 );
	}
	wk->next_seq = SEQ_BTLIN_ERR;
	*seq = SEQ_MSG_WAIT;
}

int PokeList_BattleInWaitError( PLIST_WORK * wk )
{
	if( sys.trg & (PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL) ){
		BmpTalkWinClear( &wk->win[WIN_L_MSG], WINDOW_TRANS_OFF );
		PokeListSmallMsgPut( wk, mes_pokelist_02_06, 1 );
		CATS_ObjectPaletteSet( wk->act_work[PLIST_ACT_CURSOR1], 0 );
		return SEQ_MAIN;
	}
	return SEQ_BTLIN_ERR;
}


//--------------------------------------------------------------------------------------------
/**
 * 񂩂Ȃ
 *
 */
//--------------------------------------------------------------------------------------------
static void Menu_BattleOut( PLIST_WORK * wk, int * seq )
{
	u8	i;

	for( i=0; i<wk->dat->in_max; i++ ){
		if( wk->dat->in_num[i] == wk->pos+1 ){
			wk->dat->in_num[i] = 0;
			for( i=i; i<wk->dat->in_max-1; i++ ){
				wk->dat->in_num[i] = wk->dat->in_num[i+1];
				wk->dat->in_num[i+1] = 0;
			}
			break;
		}
	}

	for( i=0; i<6; i++ ){
		if( wk->panel[i].flg == 0 ){ continue; }
		PokeList_PanelBattleInCommPut( wk, i );
	}

	BmpTalkWinClear( &wk->win[WIN_M_MSG], WINDOW_TRANS_OFF );
	PokeListMenuExit( wk );
	PokeListSmallMsgPut( wk, mes_pokelist_02_01, 1 );
	CATS_ObjectPaletteSet( wk->act_work[PLIST_ACT_CURSOR1], 0 );
	*seq = SEQ_MAIN;
}



//--------------------------------------------------------------------------------------------
/**
 * 񂩂iReXgQj
 *
 */
//--------------------------------------------------------------------------------------------
static void Menu_ContestIn( PLIST_WORK * wk, int * seq )
{
	wk->dat->ret_mode = PL_RET_NORMAL;

	BmpMenuExit( wk->mw, NULL );
	BMP_MENULIST_Delete( wk->md );
	APP_WipeStart( APP_WIPE_OUT, HEAPID_POKELIST, &wk->wipe_flg );

	*seq = SEQ_OUT;
}



//--------------------------------------------------------------------------------------------
/**
 * ꂩ
 *
 */
//--------------------------------------------------------------------------------------------
static void Menu_ChgError( void * work );
static void ChgErrorMsgMake( PLIST_WORK * wk, u32 id );

static void Menu_ChgSelect( PLIST_WORK * wk, int * seq )
{
	// 擪
	if( wk->pos == 0 ){
		PokeListMenuExit( wk );
		BmpTalkWinClear( &wk->win[WIN_M_MSG], WINDOW_TRANS_OFF );
		ChgErrorMsgMake( wk, mes_pokelist_04_54 );
		PokeListLargeMsgPut( wk, PL_MSG_COMP_EXPAND, 1 );
		*seq = SEQ_FUNC_WAIT;
		wk->vblank_func = Menu_ChgError;
		return;
	}
	// HP=0
	if( wk->panel[wk->pos].hp == 0 ){
		PokeListMenuExit( wk );
		BmpTalkWinClear( &wk->win[WIN_M_MSG], WINDOW_TRANS_OFF );
		ChgErrorMsgMake( wk, mes_pokelist_04_55 );
		PokeListLargeMsgPut( wk, PL_MSG_COMP_EXPAND, 1 );
		*seq = SEQ_FUNC_WAIT;
		wk->vblank_func = Menu_ChgError;
		return;
	}
/*
	// Z
	if( wk->dat->chg_waza != 0 ){
		PokeListMenuExit( wk );
		BmpTalkWinClear( &wk->win[WIN_M_MSG], WINDOW_TRANS_OFF );
		ChgErrorMsgMake( wk, mes_pokelist_04_55 );
		PokeListLargeMsgPut( wk, PL_MSG_COMP_EXPAND, 1 );
		*seq = SEQ_FUNC_WAIT;
		wk->vblank_func = Menu_ChgError;
		return;
	}
*/
	wk->dat->ret_mode = PL_RET_CHANGE;

	BmpMenuExit( wk->mw, NULL );
	BMP_MENULIST_Delete( wk->md );
	APP_WipeStart( APP_WIPE_OUT, HEAPID_POKELIST, &wk->wipe_flg );

	*seq = SEQ_OUT;
}

static void ChgErrorMsgMake( PLIST_WORK * wk, u32 id )
{
	POKEMON_PARAM * pp;
	STRBUF * str;

	pp  = PokeParty_GetMemberPointer( wk->dat->pp, wk->pos );
	str = MSGMAN_AllocString( wk->msg_man, id );
	WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(pp) );
	WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
	STRBUF_Delete( str );
}



static void Menu_ChgError( void * work )
{
	PLIST_WORK * wk = (PLIST_WORK *)work;

	if( GF_MSG_PrintEndCheck( wk->msg_index ) != 0 ){ return; }

	if( sys.trg & ( PAD_BUTTON_A|PAD_BUTTON_B ) ){
		BmpTalkWinClear( &wk->win[WIN_L_MSG], WINDOW_TRANS_OFF );
		PokeListSmallMsgPut( wk, mes_pokelist_02_01, 1 );
		wk->vblank_func = NULL;
	}
}


//--------------------------------------------------------------------------------------------
/**
 * Xe[^X
 *
 */
//--------------------------------------------------------------------------------------------
static void Menu_Status( PLIST_WORK * wk, int * seq )
{
	wk->dat->ret_mode = PL_RET_STATUS;

	BmpMenuExit( wk->mw, NULL );
	BMP_MENULIST_Delete( wk->md );
	APP_WipeStart( APP_WIPE_OUT, HEAPID_POKELIST, &wk->wipe_flg );

	*seq = SEQ_OUT;
}



//--------------------------------------------------------------------------------------------
/**
 * Z
 *
 */
//--------------------------------------------------------------------------------------------
static void Menu_Skill( PLIST_WORK * wk, int * seq )
{
	if( (wk->dat->ex_skill&(1<<(wk->dat->ret_mode-PL_RET_IWAKUDAKI))) == 0 ){
		BmpTalkWinClear( &wk->win[WIN_M_MSG], WINDOW_TRANS_OFF );
		PokeListMenuExit( wk );
		PokeListLargeMsgPut( wk, mes_pokelist_04_44, 1 );
		wk->next_seq = SEQ_MENUWAZA_ERR;
		*seq = SEQ_MSG_WAIT;
		return;
	}
	BmpMenuExit( wk->mw, NULL );
	BMP_MENULIST_Delete( wk->md );
	APP_WipeStart( APP_WIPE_OUT, HEAPID_POKELIST, &wk->wipe_flg );

	*seq = SEQ_OUT;
}

static void Menu_Iaigiri( PLIST_WORK * wk, int * seq )
{
	wk->dat->ret_mode = PL_RET_IAIGIRI;
	Menu_Skill( wk, seq );
}
static void Menu_Iwakudaki( PLIST_WORK * wk, int * seq )
{
	wk->dat->ret_mode = PL_RET_IWAKUDAKI;
	Menu_Skill( wk, seq );
}
static void Menu_Kairiki( PLIST_WORK * wk, int * seq )
{
	wk->dat->ret_mode = PL_RET_KAIRIKI;
	Menu_Skill( wk, seq );
}
static void Menu_Naminori( PLIST_WORK * wk, int * seq )
{
	wk->dat->ret_mode = PL_RET_NAMINORI;
	Menu_Skill( wk, seq );
}
static void Menu_Kiribarai( PLIST_WORK * wk, int * seq )
{
	wk->dat->ret_mode = PL_RET_KIRIBARAI;
	Menu_Skill( wk, seq );
}
static void Menu_RockClimb( PLIST_WORK * wk, int * seq )
{
	wk->dat->ret_mode = PL_RET_ROCKCLIMB;
	Menu_Skill( wk, seq );
}
static void Menu_Sorawotobu( PLIST_WORK * wk, int * seq )
{
	wk->dat->ret_mode = PL_RET_SORAWOTOBU;
	Menu_Skill( wk, seq );
}
static void Menu_Takinobori( PLIST_WORK * wk, int * seq )
{
	wk->dat->ret_mode = PL_RET_TAKINOBORI;
	Menu_Skill( wk, seq );
}
static void Menu_Flash( PLIST_WORK * wk, int * seq )
{
	wk->dat->ret_mode = PL_RET_FLASH;
	Menu_Skill( wk, seq );
}
static void Menu_Teleport( PLIST_WORK * wk, int * seq )
{
	wk->dat->ret_mode = PL_RET_TELEPORT;
	Menu_Skill( wk, seq );
}
static void Menu_Anawohoru( PLIST_WORK * wk, int * seq )
{
	wk->dat->ret_mode = PL_RET_ANAWOHORU;
	Menu_Skill( wk, seq );
}
static void Menu_Amaikaori( PLIST_WORK * wk, int * seq )
{
	wk->dat->ret_mode = PL_RET_AMAIKAORI;
	Menu_Skill( wk, seq );
}

int PokeList_MenuWazaError( PLIST_WORK * wk )
{
	if( sys.trg & (PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL) ){
		BmpTalkWinClear( &wk->win[WIN_L_MSG], WINDOW_TRANS_OFF );
		PokeListSmallMsgPut( wk, mes_pokelist_02_01, 1 );
		CATS_ObjectPaletteSet( wk->act_work[PLIST_ACT_CURSOR1], 0 );
		return SEQ_MAIN;
	}
	return SEQ_MENUWAZA_ERR;
}
