//============================================================================================
/**
 * @file	plist_sys.h
 * @bfief	|PXg֘At@C̋ʒ`
 * @author	Hiroyuki Nakamura
 * @date	05.09.29
 */
//============================================================================================
#ifndef PLIST_SYS_H
#define PLIST_SYS_H


#define	PL_PANEL_SX			( 16 )
#define	PL_PANEL_SY			( 6 )

#define	PL_HP_DOTTO_MAX		( 48 )	// HPQ[W̃hbgTCY

#define	PL_PANEL_HPGAGE_CLEAR_CHR	( 0x17 )	// plHPQ[WXʒu
#define	PL_PANEL_HPGAGE_PX			( 6 )		// plHPQ[WXʒu
#define	PL_PANEL_HPGAGE_PY			( 3 )		// plHPQ[WYʒu
#define	PL_PANEL_HPGAGE_SX			( 9 )		// plHPQ[WXTCY
#define	PL_PANEL_HPGAGE_SY			( 1 )		// plHPQ[WYTCY

#define	PL_MENU_WIN_CGX		( 1 )
#define	PL_TALK_WIN_CGX		( PL_MENU_WIN_CGX + MENU_WIN_CGX_SIZ )

#define	TMP_MSG_SIZE		( 256 )		// bZ[WWJ̈TCYij
#define	MENU_STR_SIZE		( 32 )		// j[WJ̈TCYij

// V[PX
enum {
	SEQ_IN = 0,
	SEQ_MAIN,
	SEQ_MENU,

	SEQ_MENUWAZA_ERR,		// ZgpG[

	SEQ_ITEMUSE_SEL,
	SEQ_ITEMUSE_WAIT,

	// obÓuv
	SEQ_ITEMSET_SEL,
	SEQ_ITEMSET_YN_INIT,
	SEQ_ITEMSET_YN_MAIN,
	SEQ_ITEMSET_WAIT,

	SEQ_MAILSET_END,

	SEQ_ITEM_MENU,
	SEQ_ITEM_MENU_SET_RET,	// obO߂
	SEQ_ITEM_MENU_GET,

	SEQ_ITEMGET_END,

	SEQ_WAZASET_SEL,		// Zo
	SEQ_WAZASET_RET_SET,	// ZoFYĊo

	SEQ_BTLIN_ERR,			// 퓬QG[

	SEQ_MSG_WAIT,		// bZ[WEFCg
	SEQ_ENDTRG_WAIT,	// gK[EFCg -> I
	SEQ_YESNO_INIT,		// ͂E\
	SEQ_YESNO_MAIN,		// ͂EI

	SEQ_ROW_SEL,
	SEQ_FUNC_WAIT,
	SEQ_OUT,
};

// BGpbg
enum {
	PAL_FONT = 0,
	PAL_BG,

	PAL_PANEL_0 = 3,
	PAL_PANEL_1,
	PAL_PANEL_2,
	PAL_PANEL_3,
	PAL_PANEL_4,
	PAL_PANEL_5,

	PAL_MENU_WIN = 14,
	PAL_TALK_WIN
};

// BMPEBhECfbNX
enum {
	WIN_POKE1_NAME = 0,
	WIN_POKE1_LV,
	WIN_POKE1_HP,
	WIN_POKE1_HPBAR,
	WIN_POKE1_COMM,
	WIN_POKE2_NAME,
	WIN_POKE2_LV,
	WIN_POKE2_HP,
	WIN_POKE2_HPBAR,
	WIN_POKE2_COMM,
	WIN_POKE3_NAME,
	WIN_POKE3_LV,
	WIN_POKE3_HP,
	WIN_POKE3_HPBAR,
	WIN_POKE3_COMM,
	WIN_POKE4_NAME,
	WIN_POKE4_LV,
	WIN_POKE4_HP,
	WIN_POKE4_HPBAR,
	WIN_POKE4_COMM,
	WIN_POKE5_NAME,
	WIN_POKE5_LV,
	WIN_POKE5_HP,
	WIN_POKE5_HPBAR,
	WIN_POKE5_COMM,
	WIN_POKE6_NAME,
	WIN_POKE6_LV,
	WIN_POKE6_HP,
	WIN_POKE6_HPBAR,
	WIN_POKE6_COMM,

	WIN_ENTER,			// uĂv
	WIN_EXIT,			// uǂv

	WIN_S_MSG,			// PsbZ[W
	WIN_M_MSG,			// PsbZ[Wij[\j
	WIN_L_MSG,			// QsbZ[Wiʏj
	WIN_ITEM_MENU,		// ACej[

	WIN_MAX
};

// ǉBMPEBhECfbNX
enum {
	ADD_WIN_MENU = 0,

	ADD_WIN_MAX
};

// OBJ`
enum {
	PLIST_ACT_BALL1 = 0,
	PLIST_ACT_BALL2,
	PLIST_ACT_BALL3,
	PLIST_ACT_BALL4,
	PLIST_ACT_BALL5,
	PLIST_ACT_BALL6,
	PLIST_ACT_CURSOR1,
	PLIST_ACT_CURSOR2,
	PLIST_ACT_ENTER,
	PLIST_ACT_EXIT,

	PLIST_ACT_ST1,
	PLIST_ACT_ST2,
	PLIST_ACT_ST3,
	PLIST_ACT_ST4,
	PLIST_ACT_ST5,
	PLIST_ACT_ST6,

	PLIST_ACT_ITEM1,
	PLIST_ACT_ITEM2,
	PLIST_ACT_ITEM3,
	PLIST_ACT_ITEM4,
	PLIST_ACT_ITEM5,
	PLIST_ACT_ITEM6,

	PLIST_ACT_MAX
};

enum {
	MENU_ROW = 0,	// mes_pokelist_05_01	Ȃт
	MENU_STATUS,	// mes_pokelist_05_02	悳݂
	MENU_ITEM,		// mes_pokelist_05_03	
	MENU_ITEM_S,	// mes_pokelist_05_03	̃j[F
	MENU_ITEM_G,	// mes_pokelist_05_03	̃j[F
	MENU_MAIL,		// mes_pokelist_05_04	[
	MENU_MAIL_R,	// mes_pokelist_05_05	[@
	MENU_MAIL_G,	// mes_pokelist_05_06	[@Ƃ
	MENU_GET,		// mes_pokelist_05_07	
	MENU_CANCEL,	// mes_pokelist_05_08	߂
	MENU_CHANGE,	// mes_pokelist_05_09	ꂩ
	MENU_BATTLE_IN,		// mes_pokelist_05_10	񂩂i퓬QIj
	MENU_OUT,		// mes_pokelist_05_11	񂩂Ȃ
	MENU_CONTEST_IN,	// mes_pokelist_05_10	񂩂iReXgQj

	MENU_W_IWAKUDAKI,	// ZF킭
	MENU_W_IAIGIRI,		// ZF
	MENU_W_SORAWOTOBU,	// ZFƂ
	MENU_W_KIRIBARAI,	// ZF΂炢
	MENU_W_KAIRIKI,		// ZF肫
	MENU_W_NAMINORI,	// ZFȂ݂̂
	MENU_W_ROCKCLIMB,	// ZFbNNC
	MENU_W_TAKINOBORI,	// ZF̂ڂ
	MENU_W_FLASH,		// ZFtbV
	MENU_W_TELEPORT,	// ZFe|[g
	MENU_W_ANAWOHORU,	// ZFȂق
	MENU_W_AMAIKAORI,	// ZF܂

	MENU_STR_MAX = MENU_W_IWAKUDAKI+4
};


typedef int (*STRCV_FUNC)(void*);
typedef int (*YESNO_FUNC)(void*);

// ͂E[N
typedef struct {
	YESNO_FUNC	yes;
	YESNO_FUNC	no;
}YESNO_WORK;


// |Pf[^
typedef struct {
	STRBUF * name;			// jbNl[

	u16	mons;			// |Pԍ
	u16	hp;				// HP
	u16	mhp;			// őHP
	u16	lv;				// x
	u16	item;			// ACeԍ
//	u16	mail:14;		// [ID
	u16	st:13;			// Ԉُ
	u16	sex:2;			// 
	u16	contest:1;		// ReXgɎQł邩

	s8	plate_px;
	s8	plate_py;

	s16	mons_px;
	s16	mons_py;

	s16	st_px;
	s16	st_py;

	s16	item_px;
	s16	item_py;

	CLACT_WORK_PTR	icon_cwp;
//	CLACT_WORK_PTR	item_cwp;
	u8	anm_cnt;
	u8	flg;
}PL_PANEL_DATA;

// Ȃтp[N
typedef struct {
	u16	plate_bg[2][PL_PANEL_SX*PL_PANEL_SY];
	u16	str_bg[2][PL_PANEL_SX*PL_PANEL_SY];
	u8	pos[2];
	u8	mv[2];
	u8	flg;
	u8	seq;
	u8	cnt;
}MENU_NARABIKAE_WORK;

// |PXg[N
typedef struct {
	GF_BGL_INI * bgl;						// BGLf[^

	GF_BGL_BMPWIN	win[WIN_MAX];			// BMPEBhEf[^iʏj
	GF_BGL_BMPWIN	add_win[ADD_WIN_MAX];	// BMPEBhEf[^iǉj

	u16	pal[16*8];							// pbgۑ

	PLIST_DATA * dat;

	CATS_SYS_PTR	csp;
	CATS_RES_PTR	crp;

	CLACT_WORK_PTR	act_work[PLIST_ACT_MAX];

	NUMFONT * num_font;					// 8x8tHg
	MSGDATA_MANAGER * msg_man;			// bZ[Wf[^}l[W
	WORDSET * wset;						// PZbg
	STRBUF * msg_buf;					// bZ[WWJ̈
	STRBUF * str_buf;					// bZ[WWJ̈
	STRBUF * menu_str[MENU_STR_MAX];	// j[WJ̈

	BMP_MENULIST_DATA * md;			// BMPj[f[^
	BMPMENU_WORK * mw;				// BMPj[[N

	PL_PANEL_DATA	panel[6];

	const POINTER_WORK * mv_tbl;

	MENU_NARABIKAE_WORK	chg_wk;

	TCB_PTR		vtask;
	INTR_FUNC	vblank_func;

	STRCV_FUNC	strcv_func;

	YESNO_WORK	yesno;

	u8	next_seq;		// ̃V[PX

	u8	chg_pos:6;
	u8	chg_flg:1;

	u8	cancel_flg:1;

	u8	msg_index;

	u8	pos;

	BOOL	wipe_flg;

}PLIST_WORK;



//---------------------------------------------------------------------------------------------
/**
 * |P邩`FbN
 *
 * @param	wk		|PXg[N
 * @param	pos		ʒu
 *
 * @retval	"TRUE = "
 * @retval	"FALSE = Ȃ"
 */
//---------------------------------------------------------------------------------------------
extern u8 PokeListDataCheck( PLIST_WORK * wk, u8 pos );

//---------------------------------------------------------------------------------------------
/**
 * |Pp[^擾
 *
 * @param	wk		|PXg[N
 *
 * @retval	"TRUE = "
 * @retval	"FALSE = Ȃ"
 */
//---------------------------------------------------------------------------------------------
extern u8 PokeList_PanelPPDataMake( PLIST_WORK * wk, u8 pos );


extern void PokeListPanelPaletteSet( PLIST_WORK * wk, u8 num );

extern u8 PokeListSelCursorCheck( u8 type, u8 pos );

extern const u16 * PokeList_HPGageCharGet(void);

extern u8 PokeList_BattleInCheck( PLIST_WORK * wk, u8 num );


#endif	/* PLIST_SYS_H */
