//============================================================================================
/**
 * @file	pokelist.c
 * @bfief	|PXgʏ
 * @author	Hiroyuki Nakamura
 * @date	05.09.20
 */
//============================================================================================
#include "common.h"
#include "gflib/touchpanel.h"
#include "system/procsys.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/clact_tool.h"
#include "system/brightness.h"
#include "system/fontproc.h"
#include "system/bmp_menu.h"
#include "system/window.h"
#include "system/msgdata.h"
#include "system/numfont.h"
#include "system/wordset.h"
#include "system/snd_tool.h"
#include "poketool/monsno.h"
#include "poketool/pokeicon.h"
#include "poketool/pokeparty.h"
#include "poketool/status_rcv.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_pokelist.h"
#include "battle/battle_common.h"
#include "battle/wazano_def.h"
#include "itemtool/item.h"
#include "itemtool/myitem.h"
#include "contest/contest_def.h"
#include "application/app_tool.h"

#define	POKELIST_H_GLOBAL
#include "application/pokelist.h"
#include "plist_sys.h"
#include "plist_obj.h"
#include "plist_bmp.h"
#include "plist_menu.h"
#include "plist_item.h"
#include "plist_gra.naix"


//============================================================================================
//	萔`
//============================================================================================
// I
enum {
	SEL_POKE = 0,
	SEL_MOVE,
	SEL_TOUCH,
	SEL_CANCEL,
	SEL_ENTER,
	SEL_NONE,
};


// pl^Cv
enum {
	PANELTYPE_NORMAL = 0,
	PANELTYPE_MULTI,
	PANELTYPE_DETH,
	PANELTYPE_CHANGE,

	PANELTYPE_SELECT,
};

// j[I
enum {
	MENU_SEL_NONE = 0,
	MENU_SEL_CANCEL
};


// pl̍W
typedef struct {
	u16	plate_px;	// v[gXW
	u16	plate_py;	// v[gYW

	u16	icon_px;	// |PACRXW
	u16	icon_py;	// |PACRYW

	u16	ball_px;	// {[OBJXW
	u16	ball_py;	// {[OBJYW
}PANEL_POS;



#define	PL_SE_SELECT	( SEQ_SE_DP_SELECT )
#define	PL_SE_KETTEI	( SEQ_SE_DP_SELECT )


//============================================================================================
//	vg^Cv錾
//============================================================================================
extern u8 MsgSpeedGet(void);

static PROC_RESULT PokeListProc_Init( PROC * proc, int * seq );
static PROC_RESULT PokeListProc_Main( PROC * proc, int * seq );
static PROC_RESULT PokeListProc_End( PROC * proc, int * seq );

static int MainSeq_In( PLIST_WORK * wk );
static int MainSeq_Main( PLIST_WORK * wk );
static int MainSeq_ItemUseSel( PLIST_WORK * wk );
static int MainSeq_ItemSetSel( PLIST_WORK * wk );
static int MainSeq_MsgWait( PLIST_WORK * wk );
static int MainSeq_EndTrgWait( PLIST_WORK * wk );
static int MainSeq_YesNoInit( PLIST_WORK * wk );
static int MainSeq_YesNoMain( PLIST_WORK * wk );
static int MainSeq_WazaSetSel( PLIST_WORK * wk );

//static void PokeListVBlank( void * work );
static void PokeListVBlank( TCB_PTR tcb, void * work );

static void PokeListVramBankSet(void);
static void PokeListBgSet( GF_BGL_INI * ini );
static void PokeListBgExit( GF_BGL_INI * ini );
static void PokeListBgGraphicSet( PLIST_WORK * wk );
static PLIST_WORK * PokeListWorkInit( PROC * proc );
static void ListModeSet( PLIST_WORK * wk );
static void PokePanelMake( PLIST_WORK * wk );
static u8 PokeMultiCheck( PLIST_WORK * wk, u8 num );
static u8 PokeSelectMain( PLIST_WORK * wk );
static void PanelSelectChg( PLIST_WORK * wk, u8 pos, u8 flg );
static void InitCursorPosSet( PLIST_WORK * wk );
static void CancelCheck( PLIST_WORK * wk );
static int PL_SelectEnter( PLIST_WORK * wk );

static u8 MenuControl( PLIST_WORK * wk, int * seq );
static void MenuExit( PLIST_WORK * wk );
static u8 PokeSelectRow( PLIST_WORK * wk );
static void SubButtonScrnPut( PLIST_WORK * wk, u8 pos, u8 flg );
static int SubButtonCheck( PLIST_WORK * wk );

static u8 PokeSelectItemUse( PLIST_WORK * wk );
static void ItemUseCheck( PLIST_WORK * wk );

static u8 PokeItemCheck( PLIST_WORK * wk );
static int PokeItemSetInit_Bag( PLIST_WORK * wk );
static void PokeList_ItemSet( PLIST_WORK * wk, POKEMON_PARAM * pp );
static int PokeItemSetWait_Bag( PLIST_WORK * wk );
static int PokeItemSetYesNoInit_Bag( PLIST_WORK * wk );
static int PokeItemSetYesNoMain_Bag( PLIST_WORK * wk );
static int MainSeq_ItemMenuSel( PLIST_WORK * wk );
static int PokeItemEndCheck( PLIST_WORK * wk );
static int PL_MailSetEnd( PLIST_WORK * wk );


//============================================================================================
//	O[oϐ
//============================================================================================
// vZX`f[^
const PROC_DATA PokeListProcData = {
	PokeListProc_Init,
	PokeListProc_Main,
	PokeListProc_End,
	NO_OVERLAY_ID,
};

static const u16 TopPlateChar[] = {
0x00,0x48,0x48,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x11,
0x67,0x68,0x69,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x25,
0x87,0x88,0x89,0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x32,
0x4a,0x4b,0x4c,0x17,0x17,0x17,0x20,0x21,0x22,0x22,0x22,0x22,0x22,0x22,0x23,0x13,
0x6a,0x6b,0x6c,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x13,
0x8a,0x8b,0x8c,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,
};
static const u16 NormalPlateChar[] = {
0x00,0x29,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x11,
0x2a,0x2b,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x25,
0x30,0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x32,
0x12,0x17,0x17,0x17,0x17,0x17,0x20,0x21,0x22,0x22,0x22,0x22,0x22,0x22,0x23,0x13,
0x12,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x13,
0x14,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,
};
static const u16 NoPlateChar[] = {
0x00,0x2e,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x09,
0x2f,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x0b,
0x0a,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x0b,
0x0a,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x0b,
0x0a,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x0b,
0x0c,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0e,
};

// pl̍We[u
static const PANEL_POS PanelPosTable[2][6] =
{
	{	// VO/_u
		{ 0,0,		30,16,		16,14 },
		{ 16,1,		158,24,		144,22 },
		{ 0,6,		30,64,		16,62 },
		{ 16,7,		158,72,		144,70 },
		{ 0,12,		30,112,		16,110 },
		{ 16,13,	158,120,	144,118 }
	},
	{	// }`
		{ 0,0,		30,16,		16,14 },
		{ 16,0,		158,24-8,	144,22-8 },
		{ 0,6,		30,64,		16,62 },
		{ 16,6,		158,72-8,	144,70-8 },
		{ 0,12,		30,112,		16,110 },
		{ 16,12,	158,120-8,	144,118-8 }
	}
};

// ʏ̃J[\ړe[u
static const POINTER_WORK NormalMoveTable[] =
{
/*
	{  64, 24+1,0,0,	4,2,7,1 },	// 0
	{ 192, 32+1,0,0,	7,3,0,2 },	// 1
	{  64, 72+1,0,0,	0,4,1,3 },	// 2
	{ 192, 80+1,0,0,	1,5,2,4 },	// 3
	{  64,120+1,0,0,	2,0,3,5 },	// 4
	{ 192,128+1,0,0,	3,7,4,7 },	// 5
	{   0,  0,0,0,	0,0,0,0 },	// 6	_~[ij
	{ 224,168,0,0,	5,1,5,0 }	// 7
*/
	{  64, 24+1,0,0,	7,1,7,1 },	// 0
	{ 192, 32+1,0,0,	0,2,0,2 },	// 1
	{  64, 72+1,0,0,	1,3,1,3 },	// 2
	{ 192, 80+1,0,0,	2,4,2,4 },	// 3
	{  64,120+1,0,0,	3,5,3,5 },	// 4
	{ 192,128+1,0,0,	4,7,4,7 },	// 5
	{   0,  0,0,0,	0,0,0,0 },	// 6	_~[ij
	{ 224,168,0,0,	5,0,5,0 }	// 7
};
// }`og̃J[\ړe[u
static const POINTER_WORK MultiMoveTable[] =
{
	{  64, 24+1,0,0,	4,2,1,1 },			// 0
	{ 192, 24+1,0,0,	7,3,0,0 },			// 1
	{  64, 72+1,0,0,	0,4,3,3 },			// 2
	{ 192, 72+1,0,0,	1,5,2,2 },			// 3
	{  64,120+1,0,0,	2,0,5,5 },			// 4
	{ 192,120+1,0,0,	3,7,4,4 },			// 5
	{ 224,168,0,0,	0,0,0,0 },			// 6	_~[ij
	{ 224,168,0,0,	5,1,0xff,0xff }		// 7
};
// uĂvL̃J[\ړe[u
static const POINTER_WORK SelectMoveTable[] =
{
/*
	{  64, 24+1,0,0,	4,2,7,1 },	// 0
	{ 192, 32+1,0,0,	7,3,0,2 },	// 1
	{  64, 72+1,0,0,	0,4,1,3 },	// 2
	{ 192, 80+1,0,0,	1,5,2,4 },	// 3
	{  64,120+1,0,0,	2,0,3,5 },	// 4
	{ 192,128+1,0,0,	3,6,4,6 },	// 5
	{ 224,168,0,0,	5,7,5,7 },	// 6
	{ 224,184,0,0,	6,1,6,0 },	// 7
*/
	{  64, 24+1,0,0,	7,1,7,1 },	// 0
	{ 192, 32+1,0,0,	0,2,0,2 },	// 1
	{  64, 72+1,0,0,	1,3,1,3 },	// 2
	{ 192, 80+1,0,0,	2,4,2,4 },	// 3
	{  64,120+1,0,0,	3,5,3,5 },	// 4
	{ 192,128+1,0,0,	4,6,4,6 },	// 5
	{ 224,168,0,0,	5,7,5,7 },	// 6
	{ 224,184,0,0,	6,0,6,0 },	// 7
};

// j[̋Ze[u
static const u16 WazaTbl[] = {
	WAZANO_IWAKUDAKI,		// ZF킭
	WAZANO_IAIGIRI,			// ZF
	WAZANO_SORAWOTOBU,		// ZFƂ
	WAZANO_KIRIBARAI,		// ZF΂炢
	WAZANO_KAIRIKI,			// ZF肫
	WAZANO_NAMINORI,		// ZFȂ݂̂
	WAZANO_ROKKUKURAIMU,	// ZFbNN
	WAZANO_TAKINOBORI,		// ZF̂ڂ

	WAZANO_HURASSYU,	// ZFtbV
	WAZANO_TEREPOOTO,	// ZFe|[g
	WAZANO_ANAWOHORU,	// ZFȂق
	WAZANO_AMAIKAORI	// ZF܂
};


//============================================================================================
//	vZX֐
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * vZX֐F
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT PokeListProc_Init( PROC * proc, int * seq )
{
	PLIST_WORK * wk;

	sys_VBlankFuncChange( NULL, NULL );	// VBlankZbg
	sys_HBlankIntrStop();	//HBlank荞ݒ~

	GF_Disp_GX_VisibleControlInit();
	GF_Disp_GXS_VisibleControlInit();
	GX_SetVisiblePlane( 0 );
	GXS_SetVisiblePlane( 0 );

	sys_KeyRepeatSpeedSet( 4, 8 );
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_POKELIST, 0x20000 );

	wk = PokeListWorkInit( proc );

	APP_WipeStart( APP_WIPE_IN, HEAPID_POKELIST, &wk->wipe_flg );

	// LZݒ
	CancelCheck( wk );

	PokeListVramBankSet();
	PokeListBgSet( wk->bgl );
	PokeListBgGraphicSet( wk );

	InitTPSystem();						// ^b`plVXe
	InitTPNoBuff(4);

	PokeListBmpAdd( wk );

	PokeListCellActorInit( wk );
	PokeListCellActSet( wk );

	ListModeSet( wk );

	PokePanelMake( wk );

	PanelSelectChg( wk, wk->pos, 1 );

	if( wk->dat->mode == PL_MODE_ITEMUSE ){
		PokeListSmallMsgPut( wk, mes_pokelist_02_04, 1 );
	}else if( wk->dat->mode == PL_MODE_WAZASET ){
		PokeListSmallMsgPut( wk, mes_pokelist_02_05, 1 );
	}else if( wk->dat->mode == PL_MODE_ITEMSET ){
		PokeListSmallMsgPut( wk, mes_pokelist_02_03, 1 );
	}else if( wk->dat->mode == PL_MODE_WAZASET_RET ||
			  wk->dat->mode == PL_MODE_MAILSET || wk->dat->mode == PL_MODE_MAILSET_BAG ){
		CATS_ObjectPaletteSet( wk->act_work[PLIST_ACT_CURSOR1], 1 );
	}else if( wk->dat->mode == PL_MODE_SELECT ){
		PokeListSmallMsgPut( wk, mes_pokelist_02_06, 1 );
	}else if( wk->dat->mode != PL_MODE_ITEMSET_RET ){
		PokeListSmallMsgPut( wk, mes_pokelist_02_01, 1 );
	}else{
		CATS_ObjectPaletteSet( wk->act_work[PLIST_ACT_CURSOR1], 1 );
	}

	PokeListMenuStrMake( wk );
	InitCursorPosSet( wk );

//	sys_HBlankIntrSet( BagInWipeEff );	// HBlankZbg
//	sys_VBlankFuncChange( PokeListVBlank, wk );	// VBlankZbg

//	wk->vtask = VIntrTCB_Add( PokeListVBlank, wk, 0 );
	wk->vtask = VWaitTCB_Add( PokeListVBlank, wk, 0 );

	return PROC_RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * vZX֐FC
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT PokeListProc_Main( PROC * proc, int * seq )
{
	PLIST_WORK * wk  = PROC_GetWork( proc );

	switch( *seq ){
	case SEQ_IN:
		*seq = MainSeq_In( wk );
		break;

	case SEQ_MAIN:
		*seq = MainSeq_Main( wk );
		break;

	case SEQ_MENU:
		if( MenuControl( wk, seq ) == MENU_SEL_CANCEL ){
			*seq = SEQ_MAIN;
		}
		break;

	case SEQ_MENUWAZA_ERR:
		*seq = PokeList_MenuWazaError( wk );
		break;

	case SEQ_ITEMUSE_SEL:
		*seq = MainSeq_ItemUseSel( wk );
		break;

	case SEQ_ITEMUSE_WAIT:
		*seq = wk->strcv_func( wk );
		break;

	case SEQ_ITEMSET_SEL:
		*seq = MainSeq_ItemSetSel( wk );
		break;
	case SEQ_ITEMSET_YN_INIT:
		*seq = PokeItemSetYesNoInit_Bag( wk );
		break;
	case SEQ_ITEMSET_YN_MAIN:
		*seq = PokeItemSetYesNoMain_Bag( wk );
		break;
	case SEQ_ITEMSET_WAIT:
		*seq = PokeItemSetWait_Bag( wk );
		break;

	case SEQ_MAILSET_END:
		*seq = PL_MailSetEnd( wk );
		break;

	case SEQ_ITEM_MENU:
		*seq = MainSeq_ItemMenuSel( wk );
		break;

	case SEQ_ITEM_MENU_SET_RET:
		*seq = PokeItemSetInit_Bag( wk );
		break;

	case SEQ_ITEM_MENU_GET:
		*seq = PokeList_ItemMenuItemGetEndWait( wk );
		break;

	case SEQ_ITEMGET_END:
		*seq = PokeList_ItemGetEnd( wk );
		break;

	case SEQ_WAZASET_SEL:	// Zo
		*seq = MainSeq_WazaSetSel( wk );
		break;

	case SEQ_WAZASET_RET_SET:
		*seq = PokeList_WazaSetRetSet( wk );
		break;

	case SEQ_BTLIN_ERR:		// 퓬QG[
		*seq = PokeList_BattleInWaitError( wk );
		break;

	case SEQ_MSG_WAIT:		// bZ[WEFCg
		*seq = MainSeq_MsgWait( wk );
		break;

	case SEQ_ENDTRG_WAIT:	// gK[EFCg -> I
		*seq = MainSeq_EndTrgWait( wk );
		break;

	case SEQ_YESNO_INIT:	// ͂E\
		*seq = MainSeq_YesNoInit( wk );
		break;

	case SEQ_YESNO_MAIN:	// ͂EI
		*seq = MainSeq_YesNoMain( wk );
		break;

	case SEQ_ROW_SEL:
		{
			u8	sel = PokeSelectRow( wk );

			if( sel == SEL_POKE ){
				*seq = SEQ_FUNC_WAIT;
			}else if( sel == SEL_CANCEL ){
				*seq = SEQ_MAIN;
			}
		}
		break;

	case SEQ_FUNC_WAIT:
		if( wk->vblank_func == NULL ){
			*seq = SEQ_MAIN;
		}
		break;

	case SEQ_OUT:
		if( wk->wipe_flg == TRUE ){
			wk->dat->ret_sel = wk->pos;
			return PROC_RES_FINISH;
		}
		break;
	}

	PokeIconAnime( wk );

//	CATS_Draw( wk->crp );

	return PROC_RES_CONTINUE;
}

static int MainSeq_In( PLIST_WORK * wk )
{
	if( wk->wipe_flg == TRUE ){
		if( wk->dat->mode == PL_MODE_ITEMUSE ){
			return SEQ_ITEMUSE_SEL;
		}else if( wk->dat->mode == PL_MODE_WAZASET ){
			return SEQ_WAZASET_SEL;
		}else if( wk->dat->mode == PL_MODE_WAZASET_RET ){
			return PokeList_WazaSetRetInit( wk );
		}else if( wk->dat->mode == PL_MODE_MAILSET || wk->dat->mode == PL_MODE_MAILSET_BAG ){
			return SEQ_MAILSET_END;
		}else if( wk->dat->mode == PL_MODE_ITEMSET ){
			return SEQ_ITEMSET_SEL;
		}else if( wk->dat->mode == PL_MODE_ITEMSET_RET ){
			return SEQ_ITEM_MENU_SET_RET;
		}else{
			return SEQ_MAIN;
		}
	}
	return SEQ_IN;
}

static int MainSeq_Main( PLIST_WORK * wk )
{
	u8	sel = PokeSelectMain( wk );

	if( sel == SEL_POKE ){
		if( wk->dat->mode == PL_MODE_SET ){
			wk->dat->ret_mode = PL_RET_NORMAL;
			APP_WipeStart( APP_WIPE_OUT, HEAPID_POKELIST, &wk->wipe_flg );
			return SEQ_OUT;
		}else{
			return SEQ_MENU;
		}
	}else if( sel == SEL_ENTER ){
		return PL_SelectEnter( wk );
	}else if( sel == SEL_CANCEL ){
		wk->dat->ret_mode = PL_RET_NORMAL;
		APP_WipeStart( APP_WIPE_OUT, HEAPID_POKELIST, &wk->wipe_flg );
		return SEQ_OUT;
	}else if( sel == SEL_TOUCH ){
		wk->dat->ret_mode = PL_RET_STATUS;
		APP_WipeStart( APP_WIPE_OUT, HEAPID_POKELIST, &wk->wipe_flg );
		return SEQ_OUT;
	}
	return SEQ_MAIN;
}

static int MainSeq_ItemUseSel( PLIST_WORK * wk )
{
	u8	sel = PokeSelectItemUse( wk );

	if( sel == SEL_POKE ){
		ItemUseCheck( wk );
		return SEQ_ITEMUSE_WAIT;
	}else if( sel == SEL_CANCEL ){
		wk->dat->ret_mode = PL_RET_NORMAL;
		APP_WipeStart( APP_WIPE_OUT, HEAPID_POKELIST, &wk->wipe_flg );
		return SEQ_OUT;
	}

	return SEQ_ITEMUSE_SEL;
}

// ACe
static int MainSeq_ItemSetSel( PLIST_WORK * wk )
{
	u8	sel = PokeSelectItemUse( wk );

	if( sel == SEL_POKE ){
		return PokeItemSetInit_Bag( wk );
	}else if( sel == SEL_CANCEL ){
		wk->dat->ret_mode = PL_RET_NORMAL;
		APP_WipeStart( APP_WIPE_OUT, HEAPID_POKELIST, &wk->wipe_flg );
		return SEQ_OUT;
	}

	return SEQ_ITEMSET_SEL;
}

// úvj[
static int MainSeq_ItemMenuSel( PLIST_WORK * wk )
{
	u32	ret = BmpMenuMain( wk->mw );

	switch( ret ){
	case BMPMENU_NULL:
		break;

	case BMPMENU_CANCEL:
		BmpTalkWinClear( &wk->win[WIN_M_MSG], WINDOW_TRANS_OFF );
		BmpMenuWinClear( &wk->win[WIN_ITEM_MENU], WINDOW_TRANS_OFF );
		GF_BGL_BmpWinOff( &wk->win[WIN_ITEM_MENU] );
		BmpMenuExit( wk->mw, NULL );
		BMP_MENULIST_Delete( wk->md );
		PokeListSmallMsgPut( wk, mes_pokelist_02_01, 1 );
		CATS_ObjectPaletteSet( wk->act_work[PLIST_ACT_CURSOR1], 0 );
		return SEQ_MAIN;

	default:
		{
			pPLMenuFunc	func;
			int	seq;

			func = (pPLMenuFunc)ret;
			func( wk, &seq );
			return seq;
		}
	}

	return SEQ_ITEM_MENU;
}

static int MainSeq_MsgWait( PLIST_WORK * wk )
{
	if( GF_MSG_PrintEndCheck( wk->msg_index ) == 0 ){
		return wk->next_seq;
	}
	return SEQ_MSG_WAIT;
}

static int MainSeq_EndTrgWait( PLIST_WORK * wk )
{
	if( sys.trg & (PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL) ){
		APP_WipeStart( APP_WIPE_OUT, HEAPID_POKELIST, &wk->wipe_flg );
		return SEQ_OUT;
	}
	return SEQ_ENDTRG_WAIT;
}

static int MainSeq_YesNoInit( PLIST_WORK * wk )
{
	PokeList_YesNoSelectInit( wk );
	return SEQ_YESNO_MAIN;
}

static int MainSeq_YesNoMain( PLIST_WORK * wk )
{
	switch( BmpYesNoSelectMain( wk->mw, HEAPID_POKELIST ) ){
	case 0:
		return wk->yesno.yes( wk );
	case BMPMENU_CANCEL:
		return wk->yesno.no( wk );
	}
	return SEQ_YESNO_MAIN;
}


static int MainSeq_WazaSetSel( PLIST_WORK * wk )
{
	u8	sel = PokeSelectItemUse( wk );

	if( sel == SEL_POKE ){
		if( wk->panel[wk->pos].mons != MONSNO_TAMAGO ){
			CATS_ObjectPaletteSet( wk->act_work[PLIST_ACT_CURSOR1], 1 );
			return PokeList_WazaOboeInit( wk );
		}
	}else if( sel == SEL_CANCEL ){
		wk->dat->ret_mode = PL_RET_NORMAL;
		APP_WipeStart( APP_WIPE_OUT, HEAPID_POKELIST, &wk->wipe_flg );
		return SEQ_OUT;
	}
	return SEQ_WAZASET_SEL;
}



//--------------------------------------------------------------------------------------------
/**
 * vZX֐FI
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT PokeListProc_End( PROC * proc, int * seq )
{
	PLIST_WORK * wk  = PROC_GetWork( proc );
	u32	i;

	TCB_Delete( wk->vtask );
//	sys_VBlankFuncChange( NULL, NULL );		// VBlankZbg

	PokeListCellActRerease( wk );	// ZAN^[폜

	PokeListBmpWinExit( wk );			// BMPEBhEJ
	PokeListBgExit( wk->bgl );			// BGL폜
	StopTP();							// ^b`plI
	DellVramTransferManager();

	// jbNl[̈
	for( i=0; i<6; i++ ){
		STRBUF_Delete( wk->panel[i].name );
	}

	// bZ[WWJ̈
	STRBUF_Delete( wk->msg_buf );
	STRBUF_Delete( wk->str_buf );

	// j[WJ̈
	for( i=0; i<MENU_STR_MAX; i++ ){
		STRBUF_Delete( wk->menu_str[i] );
	}

	MSGMAN_Delete( wk->msg_man );
	NUMFONT_Delete( wk->num_font );
	WORDSET_Delete( wk->wset );

	PROC_FreeWork( proc );				// [NJ

	sys_DeleteHeap( HEAPID_POKELIST );

	return PROC_RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * VBlank֐
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void PokeListVBlank( TCB_PTR tcb, void * work )
{
	PLIST_WORK * wk = work;

	if( wk->vblank_func != NULL ){
		wk->vblank_func( work );
	}

	CATS_Draw( wk->crp );

	// ZAN^[
	DoVramTransferManager();	// Vram]}l[W[s
	CATS_RenderOamTrans();
	
	OS_SetIrqCheckFlag( OS_IE_V_BLANK );
}

/*
static void PokeListVBlank( void * work )
{
	PLIST_WORK * wk = work;

	GF_BGL_VBlankFunc( wk->bgl );

	// ZAN^[
	DoVramTransferManager();	// Vram]}l[W[s
	CATS_RenderOamTrans();
	
	OS_SetIrqCheckFlag( OS_IE_V_BLANK );
}
*/


//--------------------------------------------------------------------------------------------
/**
 * VRAMݒ
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void PokeListVramBankSet(void)
{
	GF_BGL_DISPVRAM tbl = {
		GX_VRAM_BG_128_A,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg

		GX_VRAM_SUB_BG_128_C,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg

		GX_VRAM_OBJ_128_B,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg

		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg

		GX_VRAM_TEX_NONE,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_NONE			// eNX`pbgXbg
	};
	GF_Disp_SetBank( &tbl );
}

//--------------------------------------------------------------------------------------------
/**
 * BGݒ
 *
 * @param	ini		BGLf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void PokeListBgSet( GF_BGL_INI * ini )
{
	{	// BG SYSTEM
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_2D,
		};
		GF_BGL_InitBG( &BGsys_data );
	}

	{	// WINDOW (BMP)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME0_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME0_M );
	}

	{	// PARAM FONT (BMP)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME1_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME1_M );
	}

	{	// PLATE (CHAR)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe800, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
			2, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME2_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME2_M );
	}

	{	// BG (CHAR)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe000, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
			3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME3_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
	}

	{	// BUTTON (CHAR)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME0_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME0_S );
	}

	{	// BG (CHAR)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME1_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
	}

	GF_BGL_ClearCharSet( GF_BGL_FRAME0_M, 32, 0, HEAPID_POKELIST );
	GF_BGL_ClearCharSet( GF_BGL_FRAME0_S, 32, 0, HEAPID_POKELIST );
}

//--------------------------------------------------------------------------------------------
/**
 * BG
 *
 * @param	ini		BGLf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void PokeListBgExit( GF_BGL_INI * ini )
{
	GF_Disp_GX_VisibleControl(
		GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 | GX_PLANEMASK_BG2 |
		GX_PLANEMASK_BG3 | GX_PLANEMASK_OBJ, VISIBLE_OFF );
	GF_Disp_GXS_VisibleControl(
		GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 | GX_PLANEMASK_OBJ, VISIBLE_OFF );

	GF_BGL_BGControlExit( ini, GF_BGL_FRAME1_S );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME0_S );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME3_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME2_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME1_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME0_M );

	sys_FreeMemory( HEAPID_POKELIST, ini );
}

//--------------------------------------------------------------------------------------------
/**
 * OtBbNf[^Zbg
 *
 * @param	wk		|PXgʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void PokeListBgGraphicSet( PLIST_WORK * wk )
{
	ArcUtil_BgCharSet(
		ARC_PLIST_GRA, NARC_plist_gra_p_list_NCGR,
		wk->bgl, GF_BGL_FRAME3_M, 0, 0, 0, HEAPID_POKELIST );
	ArcUtil_ScrnSet(
		ARC_PLIST_GRA, NARC_plist_gra_p_list_NSCR,
		wk->bgl, GF_BGL_FRAME3_M, 0, 0, 0, HEAPID_POKELIST );

	{
		NNSG2dPaletteData * pal;
		void * buf;
		u16 * cpy;
		
		buf = ArchiveDataLoadMalloc( ARC_PLIST_GRA, NARC_plist_gra_p_list_NCLR, HEAPID_POKELIST );
		NNS_G2dGetUnpackedPaletteData( buf, &pal );
		GF_BGL_PaletteSet( GF_BGL_FRAME3_M, (void *)pal->pRawData, pal->szByte, 0 );
		cpy = (u16 *)pal->pRawData;
		memcpy( wk->pal, &cpy[PAL_PANEL_0*16], 32*8 );
		sys_FreeMemory( HEAPID_POKELIST, buf );
	}

//	SystemFontPaletteLoad( PALTYPE_MAIN_BG, 0, HEAPID_POKELIST );

	// j[EBhEZbg
	MenuWinGraphicSet(
		wk->bgl, GF_BGL_FRAME0_M, PL_MENU_WIN_CGX, PAL_MENU_WIN, 0, HEAPID_POKELIST );
	// bEBhEZbg
	TalkWinGraphicSet(
		wk->bgl, GF_BGL_FRAME0_M, PL_TALK_WIN_CGX, PAL_TALK_WIN, 0, HEAPID_POKELIST );

	ArcUtil_BgCharSet(
		ARC_PLIST_GRA, NARC_plist_gra_list_but_NCGR,
		wk->bgl, GF_BGL_FRAME0_S, 0, 0, 0, HEAPID_POKELIST );
	ArcUtil_PalSet(
		ARC_PLIST_GRA, NARC_plist_gra_list_but_NCLR,
		PALTYPE_SUB_BG, 0x20, 0x20, HEAPID_POKELIST );

	ArcUtil_BgCharSet(
		ARC_PLIST_GRA, NARC_plist_gra_list_sub_NCGR,
		wk->bgl, GF_BGL_FRAME1_S, 0, 0, 0, HEAPID_POKELIST );
	ArcUtil_ScrnSet(
		ARC_PLIST_GRA, NARC_plist_gra_list_sub_NSCR,
		wk->bgl, GF_BGL_FRAME1_S, 0, 0, 0, HEAPID_POKELIST );
	ArcUtil_PalSet(
		ARC_PLIST_GRA, NARC_plist_gra_list_sub_NCLR,
		PALTYPE_SUB_BG, 0, 0x20, HEAPID_POKELIST );
}

//--------------------------------------------------------------------------------------------
/**
 * [N
 *
 * @param	wk
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static PLIST_WORK * PokeListWorkInit( PROC * proc )
{
	PLIST_WORK * wk;
	u32	i;

	wk = PROC_AllocWork( proc, sizeof(PLIST_WORK), HEAPID_POKELIST );
	memset( wk, 0, sizeof(PLIST_WORK) );

	wk->dat = PROC_GetParentWork( proc );
	wk->bgl = GF_BGL_BglIniAlloc( HEAPID_POKELIST );

//	wk->dat->mode = PL_MODE_CONTEST;
//	wk->dat->mode = PL_MODE_SET;
/*
	wk->dat->mode = PL_MODE_SELECT;
	wk->dat->in_num[0] = 0;
	wk->dat->in_num[1] = 0;
	wk->dat->in_num[2] = 0;
	wk->dat->in_num[3] = 0;
	wk->dat->in_num[4] = 0;
	wk->dat->in_num[5] = 0;
	wk->dat->in_min = 3;		// Qŏ
	wk->dat->in_max = 3;		// Qő吔
	wk->dat->in_lv = 100;		// Qx
*/

	// bZ[W}l[W쐬
	wk->msg_man = MSGMAN_Create(
					MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_pokelist_dat, HEAPID_POKELIST );
	// 8x8tHg쐬
	wk->num_font = NUMFONT_Create( 15, 14, FBMP_COL_NULL, HEAPID_POKELIST );

	wk->wset = WORDSET_Create( HEAPID_POKELIST );

	// jbNl[̈쐬
	for( i=0; i<6; i++ ){
		wk->panel[i].name = STRBUF_Create( MONS_NAME_SIZE+EOM_SIZE, HEAPID_POKELIST );
	}

	// bZ[WWJ̈쐬
	wk->msg_buf = STRBUF_Create( TMP_MSG_SIZE, HEAPID_POKELIST );
	wk->str_buf = STRBUF_Create( TMP_MSG_SIZE, HEAPID_POKELIST );

	// j[WJ̈쐬
	for( i=0; i<MENU_STR_MAX; i++ ){
		wk->menu_str[i] = STRBUF_Create( MENU_STR_SIZE, HEAPID_POKELIST );
	}

	wk->pos = wk->dat->ret_sel;

	return wk;
}

//--------------------------------------------------------------------------------------------
/**
 * LZݒ
 *
 * @param	wk
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void CancelCheck( PLIST_WORK * wk )
{
	if( ( wk->dat->mode & PL_MODE_NO_CANCEL ) != 0 ){
		wk->cancel_flg = 1;
		wk->dat->mode ^= PL_MODE_NO_CANCEL;
	}else{
		wk->cancel_flg = 0;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * [hƂ̐ݒ
 *
 * @param	wk
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void ListModeSet( PLIST_WORK * wk )
{
	u8	flg = 3;

	// J[\ړe[uݒ
	if( wk->dat->type == PL_TYPE_MULTI ){
		wk->mv_tbl = MultiMoveTable;
	}else if( wk->dat->mode == PL_MODE_SELECT ){
		wk->mv_tbl = SelectMoveTable;
	}else{
		wk->mv_tbl = NormalMoveTable;
	}

	// uĂv\
	if( wk->dat->mode != PL_MODE_SELECT ){
		CLACT_SetDrawFlag( wk->act_work[PLIST_ACT_ENTER], 0 );
		CLACT_AnmChg( wk->act_work[PLIST_ACT_EXIT], 0 );
		{
			s16	x, y;

			CATS_ObjectPosGet( wk->act_work[PLIST_ACT_EXIT], &x, &y );
			CATS_ObjectPosSet( wk->act_work[PLIST_ACT_EXIT], x, y-8 );
		}
		flg ^= 1;
	}

	// uǂv\
	if( wk->dat->mode == PL_MODE_IN ){
		CLACT_SetDrawFlag( wk->act_work[PLIST_ACT_EXIT], 0 );
		flg ^= 2;
	}

	PokeListSelectMsgPut( wk, flg );
}

//---------------------------------------------------------------------------------------------
/**
 * |P邩`FbN
 *
 * @param	wk		|PXg[N
 * @param	pos		ʒu
 *
 * @retval	"TRUE = "
 * @retval	"FALSE = Ȃ"
 */
//---------------------------------------------------------------------------------------------
u8 PokeListDataCheck( PLIST_WORK * wk, u8 pos )
{
	return wk->panel[pos].flg;
}

//---------------------------------------------------------------------------------------------
/**
 * |Pp[^擾
 *
 * @param	wk		|PXg[N
 *
 * @retval	"TRUE = "
 * @retval	"FALSE = Ȃ"
 */
//---------------------------------------------------------------------------------------------
u8 PokeList_PanelPPDataMake( PLIST_WORK * wk, u8 pos )
{
	POKEMON_PARAM * pp;
	u32	prm;
	u16	mons;

	if( PokeParty_GetPokeCount( wk->dat->pp ) <= pos ){
		return FALSE;
	}

	pp = PokeParty_GetMemberPointer( wk->dat->pp, pos );

	mons = (u16)PokeParaGet( pp, ID_PARA_monsno_egg, NULL );
	if( mons == 0 ){ return FALSE; }

	PokeListNameMake( wk, pp, pos );

	wk->panel[pos].mons = mons;
	wk->panel[pos].hp   = (u16)PokeParaGet( pp, ID_PARA_hp, NULL );
	wk->panel[pos].mhp  = (u16)PokeParaGet( pp, ID_PARA_hpmax, NULL );
	wk->panel[pos].lv   = (u16)PokeParaGet( pp, ID_PARA_level, NULL );
	wk->panel[pos].item = (u16)PokeParaGet( pp, ID_PARA_item, NULL );
	wk->panel[pos].sex  = PokeSexGet( pp );
	wk->panel[pos].flg  = 1;

	prm = PokeParaGet( pp, ID_PARA_condition, NULL );

	// 
	if( ( prm & (CONDITION_DOKU|CONDITION_DOKUDOKU) ) != 0 ){
		wk->panel[pos].st = PL_ST_DOKU;
	// 
	}else if( ( prm & CONDITION_NEMURI ) != 0 ){
		wk->panel[pos].st = PL_ST_NEMURI;
	// Ώ
	}else if( ( prm & CONDITION_YAKEDO ) != 0 ){
		wk->panel[pos].st = PL_ST_YAKEDO;
	// X
	}else if( ( prm & CONDITION_KOORI ) != 0 ){
		wk->panel[pos].st = PL_ST_KOORI;
	// 
	}else if( ( prm & CONDITION_MAHI ) != 0 ){
		wk->panel[pos].st = PL_ST_MAHI;
	// m
	}else if( wk->panel[pos].hp == 0 ){
		wk->panel[pos].st = PL_ST_HINSI;
	// Ȃ
	}else{
		wk->panel[pos].st = PL_ST_NONE;
	}

	// ReXgQ`FbN
	if( wk->dat->mode == PL_MODE_CONTEST ){
		if( wk->panel[pos].mons == MONSNO_TAMAGO || wk->panel[pos].hp == 0 ){
			wk->panel[pos].contest = 0;
		}else{
			u32	medal;

			switch( wk->dat->con_type ){
			case CONTYPE_STYLE:		// ReXg^CvFiD悳
				medal = PokeParaGet( pp, ID_PARA_stylemedal, NULL );
				break;
			case CONTYPE_BEAUTIFUL:	// ReXg^CvF
				medal = PokeParaGet( pp, ID_PARA_beautifulmedal, NULL );
				break;
			case CONTYPE_CUTE:		// ReXg^CvF
				medal = PokeParaGet( pp, ID_PARA_cutemedal, NULL );
				break;
			case CONTYPE_CLEVER:	// ReXg^CvF
				medal = PokeParaGet( pp, ID_PARA_clevermedal, NULL );
				break;
			case CONTYPE_STRONG:	// ReXg^CvF痂
				medal = PokeParaGet( pp, ID_PARA_strongmedal, NULL );
			}
			if( wk->dat->con_rank <= medal ){
				wk->panel[pos].contest = 1;
			}else{
				wk->panel[pos].contest = 0;
			}
		}
	}

	return TRUE;
}





const u16 * PokeList_HPGageCharGet(void)
{
	return &NormalPlateChar[PL_PANEL_HPGAGE_PY*16+PL_PANEL_HPGAGE_PX];
}

static void PlateSet( PLIST_WORK * wk, u8 pos, u8 px, u8 py, u8 gage )
{
	const u16 * plate;

	if( pos == 0 || ( wk->dat->type != PL_TYPE_SINGLE && pos == 1 ) ){
		plate = TopPlateChar;
	}else{
		plate = NormalPlateChar;
	}

	wk->panel[pos].plate_px = (s8)px;
	wk->panel[pos].plate_py = (s8)py;

	GF_BGL_ScrWriteExpand(
		wk->bgl, GF_BGL_FRAME2_M, px, py, 16, 6, (const void *)plate, 0, 0, 16, 6 );

//	if( wk->panel[pos].mons == MONSNO_TAMAGO ){
	if( gage == 0 ){
		GF_BGL_ScrFill(
			wk->bgl, GF_BGL_FRAME2_M, PL_PANEL_HPGAGE_CLEAR_CHR,
			px+PL_PANEL_HPGAGE_PX, py+PL_PANEL_HPGAGE_PY,
			PL_PANEL_HPGAGE_SX, PL_PANEL_HPGAGE_SY, GF_BGL_SCRWRT_PALNL );
	}

	GF_BGL_ScrPalChange(
		wk->bgl, GF_BGL_FRAME2_M, px, py, 16, 6, PAL_PANEL_0+pos );
	PokeListPanelPaletteSet( wk, pos );
}


static void PokePanelMakeNormal( PLIST_WORK * wk, const PANEL_POS * tbl );
static void PokePanelMakeWazaOboe( PLIST_WORK * wk, const PANEL_POS * tbl );
static void PokePanelMakeContest( PLIST_WORK * wk, const PANEL_POS * tbl );
static void PokePanelMakeBattleIn( PLIST_WORK * wk, const PANEL_POS * tbl );
static void DummyPanelSet( PLIST_WORK * wk, u8 pos, s16 px, s16 py );

static void PokePanelMake( PLIST_WORK * wk )
{
	const PANEL_POS * tbl;

	if( wk->dat->type == PL_TYPE_MULTI ){
		tbl = PanelPosTable[1];
	}else{
		tbl = PanelPosTable[0];
	}

	if( wk->dat->mode == PL_MODE_WAZASET ){
		PokePanelMakeWazaOboe( wk, tbl );
	}else if( wk->dat->mode == PL_MODE_CONTEST ){
		PokePanelMakeContest( wk, tbl );
	}else if( wk->dat->mode == PL_MODE_SELECT ){
		PokePanelMakeBattleIn( wk, tbl );
	}else{
		PokePanelMakeNormal( wk, tbl );
	}

	GF_BGL_LoadScreenReq( wk->bgl, GF_BGL_FRAME2_M );
	GF_BGL_LoadScreenReq( wk->bgl, GF_BGL_FRAME0_S );
}

static void PokePanelMakeNormal( PLIST_WORK * wk, const PANEL_POS * tbl )
{
	u8	i;

	for( i=0; i<6; i++ ){
		if( PokeList_PanelPPDataMake( wk, i ) == TRUE ){
			if( wk->panel[i].mons == MONSNO_TAMAGO ){
				PlateSet( wk, i, tbl[i].plate_px, tbl[i].plate_py, 0 );		// v[gZbg
			}else{
				PlateSet( wk, i, tbl[i].plate_px, tbl[i].plate_py, 1 );		// v[gZbg
			}
			PokeListParamPut( wk, i, MSG_ALLPUT );							// p[^\
			PokeListIconAdd( wk, i, tbl[i].icon_px, tbl[i].icon_py );		// ACR\
			PokeListBallActSet( wk, i, tbl[i].ball_px, tbl[i].ball_py );	// {[
			PokeList_ItemIconChg( wk, i, wk->panel[i].item );				// ACeACR
			PokeList_ItemIconPosSet(wk,i,tbl[i].icon_px,tbl[i].icon_py);	// ACeړ
			PokeList_StatusIconChg( wk, i, wk->panel[i].st );				// ԈُACR

			SubButtonScrnPut( wk, i, 0 );		// Tuʂ̃{^

		}else{
			DummyPanelSet( wk, i, tbl[i].plate_px, tbl[i].plate_py );
		}
	}
}

static void PokePanelMakeWazaOboe( PLIST_WORK * wk, const PANEL_POS * tbl )
{
	u8	i;

	for( i=0; i<6; i++ ){
		if( PokeList_PanelPPDataMake( wk, i ) == TRUE ){
			PlateSet( wk, i, tbl[i].plate_px, tbl[i].plate_py, 0 );			// v[gZbg
			PokeList_PanelWazaOboeCommPut( wk, i );
			PokeListIconAdd( wk, i, tbl[i].icon_px, tbl[i].icon_py );		// ACR\
			PokeListBallActSet( wk, i, tbl[i].ball_px, tbl[i].ball_py );	// {[
			PokeList_ItemIconChg( wk, i, wk->panel[i].item );				// ACeACR
			PokeList_ItemIconPosSet(wk,i,tbl[i].icon_px,tbl[i].icon_py);	// ACeړ
			PokeList_StatusIconChg( wk, i, wk->panel[i].st );				// ԈُACR

			SubButtonScrnPut( wk, i, 0 );		// Tuʂ̃{^

		}else{
			DummyPanelSet( wk, i, tbl[i].plate_px, tbl[i].plate_py );
		}
	}
}

static void PokePanelMakeContest( PLIST_WORK * wk, const PANEL_POS * tbl )
{
	u8	i;

	for( i=0; i<6; i++ ){
		if( PokeList_PanelPPDataMake( wk, i ) == TRUE ){
			PlateSet( wk, i, tbl[i].plate_px, tbl[i].plate_py, 0 );			// v[gZbg
			PokeList_PanelContestCommPut( wk, i );
			PokeListIconAdd( wk, i, tbl[i].icon_px, tbl[i].icon_py );		// ACR\
			PokeListBallActSet( wk, i, tbl[i].ball_px, tbl[i].ball_py );	// {[
			PokeList_ItemIconChg( wk, i, wk->panel[i].item );				// ACeACR
			PokeList_ItemIconPosSet(wk,i,tbl[i].icon_px,tbl[i].icon_py);	// ACeړ
			PokeList_StatusIconChg( wk, i, wk->panel[i].st );				// ԈُACR

			SubButtonScrnPut( wk, i, 0 );		// Tuʂ̃{^

		}else{
			DummyPanelSet( wk, i, tbl[i].plate_px, tbl[i].plate_py );
		}
	}
}

static void PokePanelMakeBattleIn( PLIST_WORK * wk, const PANEL_POS * tbl )
{
	u8	i;

	for( i=0; i<6; i++ ){
		if( PokeList_PanelPPDataMake( wk, i ) == TRUE ){
			PlateSet( wk, i, tbl[i].plate_px, tbl[i].plate_py, 0 );			// v[gZbg
			PokeList_PanelBattleInNamePut( wk, i );
			PokeList_PanelBattleInCommPut( wk, i );
			PokeListIconAdd( wk, i, tbl[i].icon_px, tbl[i].icon_py );		// ACR\
			PokeListBallActSet( wk, i, tbl[i].ball_px, tbl[i].ball_py );	// {[
			PokeList_ItemIconChg( wk, i, wk->panel[i].item );				// ACeACR
			PokeList_ItemIconPosSet(wk,i,tbl[i].icon_px,tbl[i].icon_py);	// ACeړ
			PokeList_StatusIconChg( wk, i, wk->panel[i].st );				// ԈُACR

			SubButtonScrnPut( wk, i, 0 );		// Tuʂ̃{^

		}else{
			DummyPanelSet( wk, i, tbl[i].plate_px, tbl[i].plate_py );
		}
	}
}

static void DummyPanelSet( PLIST_WORK * wk, u8 pos, s16 px, s16 py )
{
	GF_BGL_ScrWriteExpand(
		wk->bgl, GF_BGL_FRAME2_M, px, py, 16, 6, (const void *)NoPlateChar, 0, 0, 16, 6 );
	GF_BGL_ScrPalChange( wk->bgl, GF_BGL_FRAME2_M, px, py, 16, 6, PAL_BG );
	PokeList_StatusIconChg( wk, pos, PL_ST_NONE );
	PokeList_ItemIconChg( wk, pos, 0 );
}



void PokeListPanelPaletteSet( PLIST_WORK * wk, u8 num )
{
	POKEMON_PARAM * pp;
	u8	pal;

	pp = PokeParty_GetMemberPointer( wk->dat->pp, num );

	if( wk->chg_flg == 1 && ( num == wk->pos || num == wk->chg_pos ) ){
		pal = PANELTYPE_CHANGE + PANELTYPE_SELECT;
	}else{
		if( num == wk->pos ){
			pal = PANELTYPE_SELECT;
		}else{
			pal = 0;
		}
		if( PokeParaGet( pp, ID_PARA_hp, 0 ) == 0 ){
			pal += PANELTYPE_DETH;
		}else if( PokeMultiCheck( wk, num ) == TRUE ){
			pal += PANELTYPE_MULTI;
		}else{
			pal += PANELTYPE_NORMAL;
		}
	}

	GF_BGL_PaletteSet( GF_BGL_FRAME2_M, &wk->pal[pal*16], 8*2, (PAL_PANEL_0+num)*32 );
}



static u8 PokeMultiCheck( PLIST_WORK * wk, u8 num )
{
	if( wk->dat->type == PL_TYPE_MULTI && ( num & 1 ) != 0 ){
		return TRUE;
	}
	return FALSE;
}


static void InitCursorPosSet( PLIST_WORK * wk )
{
	u8	px, py;

	PointerWkMoveSel( wk->mv_tbl, &px, &py, NULL, NULL, wk->pos, POINT_MV_NULL );
	CLACT_AnmChg(
		wk->act_work[PLIST_ACT_CURSOR1],
		PokeListSelCursorCheck( wk->dat->type, wk->pos ) );
	CATS_ObjectPosSet( wk->act_work[PLIST_ACT_CURSOR1], px, py );
}


static u8 PokemonSelect( PLIST_WORK * wk )
{
	u8	mv_pos;
	u8	mv_type;
	u8	px, py;

	mv_type = POINT_MV_NULL;

	if( sys.repeat & PAD_KEY_UP ){
		mv_type = POINT_MV_UP;
	}else if( sys.repeat & PAD_KEY_DOWN ){
		mv_type = POINT_MV_DOWN;
	}else if( sys.repeat & PAD_KEY_LEFT ){
		mv_type = POINT_MV_LEFT;
	}else if( sys.repeat & PAD_KEY_RIGHT ){
		mv_type = POINT_MV_RIGHT;
	}

	if( mv_type != POINT_MV_NULL ){
		mv_pos = wk->pos;
		while(1){
			mv_pos = PointerWkMoveSel( wk->mv_tbl, &px, &py, NULL, NULL, mv_pos, mv_type );
			if( mv_pos == PL_SEL_POS_ENTER || mv_pos == PL_SEL_POS_EXIT || mv_pos == 0xff ){
				break;
			}
			if( PokeListDataCheck( wk, mv_pos ) != 0 ){
				break;
			}
		}
		if( mv_pos != wk->pos && mv_pos != 0xff ){
			if( mv_pos == PL_SEL_POS_ENTER || mv_pos == PL_SEL_POS_EXIT ){
				CLACT_SetDrawFlag( wk->act_work[PLIST_ACT_CURSOR1], 0 );
			}else{
				CLACT_AnmChg(
					wk->act_work[PLIST_ACT_CURSOR1],
					PokeListSelCursorCheck( wk->dat->type, mv_pos ) );
				CLACT_SetDrawFlag( wk->act_work[PLIST_ACT_CURSOR1], 1 );
				CATS_ObjectPosSet( wk->act_work[PLIST_ACT_CURSOR1], px, py );
			}

			{
				u8	old_pos = wk->pos;

				wk->pos = mv_pos;
				PanelSelectChg( wk, old_pos, 0 );
				PanelSelectChg( wk, wk->pos, 1 );

				Snd_SePlay( PL_SE_SELECT );

				// {^ύX
				if( old_pos < PL_SEL_POS_ENTER ){
					SubButtonScrnPut( wk, old_pos, 0 );
					GF_BGL_LoadScreenReq( wk->bgl, GF_BGL_FRAME0_S );
				}
			}

			return SEL_MOVE;
		}
	}

	{
		int	ret = SubButtonCheck( wk );

		if( ret != RECT_HIT_NONE ){
			u8	old_pos = wk->pos;

			wk->pos = (u8)ret;
			PanelSelectChg( wk, old_pos, 0 );
			PanelSelectChg( wk, wk->pos, 1 );

			if( old_pos < PL_SEL_POS_ENTER ){
				SubButtonScrnPut( wk, old_pos, 0 );
			}
			SubButtonScrnPut( wk, wk->pos, 1 );

			PointerWkMoveSel( wk->mv_tbl, &px, &py, NULL, NULL, wk->pos, POINT_MV_NULL );
			CLACT_AnmChg(
				wk->act_work[PLIST_ACT_CURSOR1],
				PokeListSelCursorCheck( wk->dat->type, wk->pos ) );
			CLACT_SetDrawFlag( wk->act_work[PLIST_ACT_CURSOR1], 1 );
			CATS_ObjectPosSet( wk->act_work[PLIST_ACT_CURSOR1], px, py );

			GF_BGL_LoadScreenReq( wk->bgl, GF_BGL_FRAME0_S );

			Snd_SePlay( SEQ_SE_DP_BAG_011 );

			return SEL_TOUCH;
		}
	}

	return SEL_NONE;
}




static void PL_MenuPut( PLIST_WORK * wk );
static u8 FieldModeMenuMake( PLIST_WORK * wk, u8 * prm );
static u8 ContestModeMenuMake( PLIST_WORK * wk, u8 * prm );
static u8 BattleInModeMenuMake( PLIST_WORK * wk, u8 * prm );


static u8 PokeSelectMain( PLIST_WORK * wk )
{
	if( sys.trg & PAD_BUTTON_DECIDE ){
		Snd_SePlay( PL_SE_KETTEI );
		if( wk->pos == PL_SEL_POS_ENTER ){
			return SEL_ENTER;
		}else if( wk->pos == PL_SEL_POS_EXIT ){
			if( wk->cancel_flg == 0 ){
				return SEL_CANCEL;
			}
		}else if( wk->dat->mode == PL_MODE_SET ){
			return SEL_POKE;
		}else{
			PL_MenuPut( wk );
			return SEL_POKE;
		}
	}

	if( sys.trg & PAD_BUTTON_CANCEL ){
		if( wk->cancel_flg == 0 ){
			Snd_SePlay( PL_SE_KETTEI );
			wk->pos = PL_SEL_POS_EXIT;
			return SEL_CANCEL;
		}
	}

	return PokemonSelect( wk );
}

static void PL_MenuPut( PLIST_WORK * wk )
{
	u8 * prm;
	u8	siz;

	BmpTalkWinClear( &wk->win[WIN_S_MSG], WINDOW_TRANS_OFF );
	prm = sys_AllocMemory( HEAPID_POKELIST, 8 );

	if( wk->dat->mode == PL_MODE_FIELD ){
		siz = FieldModeMenuMake( wk, prm );
	}else if( wk->dat->mode == PL_MODE_SELECT ){
		siz = BattleInModeMenuMake( wk, prm );
	}else{
		siz = ContestModeMenuMake( wk, prm );
	}
	PokeListMenuDataMake( wk, prm, siz );
	sys_FreeMemory( HEAPID_POKELIST, prm );

	PokeListMenuMsgMake( wk );
	PokeListMiddleMsgPut( wk, PL_MSG_COMP_EXPAND, 1 );

	CATS_ObjectPaletteSet( wk->act_work[PLIST_ACT_CURSOR1], 1 );
}

static u8 FieldModeMenuMake( PLIST_WORK * wk, u8 * prm )
{
	POKEMON_PARAM * pp = PokeParty_GetMemberPointer( wk->dat->pp, wk->pos );
	u16	waza;
	u8	i, j=0, mid;

	prm[0] = MENU_STATUS;

	for( i=0; i<4; i++ ){
#if 1	// zm
		waza = (u16)PokeParaGet( pp, ID_PARA_waza1+i, NULL );
		if( waza == 0 ){ break; }
		mid = PokeList_WazaMenuIDGet( waza );
#else	// fobOH
		mid = j+MENU_W_IWAKUDAKI;
		waza = WazaTbl[j];
#endif
		if( mid != 0xff ){
			prm[1+j] = mid;
			PokeList_WazaMenuStrGet( wk, waza, j );
			j++;
		}
	}

	prm[1+j] = MENU_ROW;
	if( ItemMailCheck( wk->panel[wk->pos].item ) == TRUE ){
		prm[2+j] = MENU_MAIL;
	}else{
		prm[2+j] = MENU_ITEM;
	}
	prm[3+j] = MENU_CANCEL;

	return (4+j);
}

static u8 ContestModeMenuMake( PLIST_WORK * wk, u8 * prm )
{
	prm[0] = MENU_STATUS;
	if( wk->panel[wk->pos].contest == 1 ){
		prm[1] = MENU_CONTEST_IN;
		prm[2] = MENU_CANCEL;
		return 3;
	}
	prm[1] = MENU_CANCEL;
	return 2;
}

static u8 BattleInModeMenuMake( PLIST_WORK * wk, u8 * prm )
{
	u8	i, j=0;

	prm[0] = MENU_STATUS;
	switch( PokeList_BattleInCheck( wk, wk->pos ) ){
	case 0:		// QłȂ
		prm[1] = MENU_CANCEL;
		return 2;

	case 1:		// Q\
		prm[1] = MENU_BATTLE_IN;
		prm[2] = MENU_CANCEL;
		return 3;

	case 2:		// QĂ
		prm[1] = MENU_OUT;
		prm[2] = MENU_CANCEL;
		return 3;
	}
	return 1;
}

u8 PokeList_BattleInCheck( PLIST_WORK * wk, u8 num )
{
	u8	i;

	for( i=0; i<wk->dat->in_max; i++ ){
		if( wk->dat->in_num[i] == num+1 ){
			return 2;
		}
	}

	if( wk->panel[num].mons == MONSNO_TAMAGO || wk->panel[num].lv > wk->dat->in_lv ){
		return 0;
	}

	return 1;
}


static void PanelSelectChg( PLIST_WORK * wk, u8 pos, u8 flg )
{
	if( pos == 6 ){
		u8	anm = CLACT_AnmGet( wk->act_work[PLIST_ACT_ENTER] );
		if( flg == 0 ){
			anm = ( anm & 2 );
		}else{
			anm = ( anm & 2 ) + 1;
		}
		CLACT_AnmChg( wk->act_work[PLIST_ACT_ENTER], anm );
		return;
	}
	if( pos == 7 ){
		u8	anm = CLACT_AnmGet( wk->act_work[PLIST_ACT_EXIT] );
		if( flg == 0 ){
			anm = ( anm & 2 );
		}else{
			anm = ( anm & 2 ) + 1;
		}
		CLACT_AnmChg( wk->act_work[PLIST_ACT_EXIT], anm );
		return;
	}

	// IĂȂԂɂ
	if( flg == 0 ){
		// |PWύX
		wk->panel[pos].mons_px -= 2;
		wk->panel[pos].mons_py -= 2;
		// {[AjύX
		CLACT_AnmChg( wk->act_work[PLIST_ACT_BALL1+pos], 0 );
	// IĂԂɂ
	}else{
		// |PWύX
		wk->panel[pos].mons_px += 2;
		wk->panel[pos].mons_py += 2;
		// {[AjύX
		CLACT_AnmChg( wk->act_work[PLIST_ACT_BALL1+pos], 1 );
	}

	// v[gpbgύX
	PokeListPanelPaletteSet( wk, pos );
}

u8 PokeListSelCursorCheck( u8 type, u8 pos )
{
	if( pos == 0 || ( type != PL_TYPE_SINGLE && pos == 1 ) ){
		return 1;
	}
	return 0;
}



static u8 PokeSelectRow( PLIST_WORK * wk )
{
	if( sys.trg & PAD_BUTTON_DECIDE ){
		Snd_SePlay( PL_SE_KETTEI );
		if( wk->pos >= PL_SEL_POS_ENTER || wk->pos == wk->chg_pos ){
			PokeListRowCancel( wk );
			return SEL_CANCEL;
		}else{
			PokeListMenuRowMoveInit( wk );
			return SEL_POKE;
		}
	}

	if( sys.trg & PAD_BUTTON_CANCEL ){
		Snd_SePlay( PL_SE_KETTEI );
		PokeListRowCancel( wk );
		return SEL_CANCEL;
	}

	return PokemonSelect( wk );
}


static int PL_SelectEnter( PLIST_WORK * wk )
{
	u8	i;

	for( i=0; i<wk->dat->in_min; i++ ){
		if( wk->dat->in_num[i] == 0 ){
			switch( wk->dat->in_max ){
			case 2:
				PokeListLargeMsgPut( wk, mes_pokelist_04_47, 1 );
				break;
			case 3:
				PokeListLargeMsgPut( wk, mes_pokelist_04_60, 1 );
				break;
			case 4:
				PokeListLargeMsgPut( wk, mes_pokelist_04_61, 1 );
				break;
			default:
				PokeListLargeMsgPut( wk, mes_pokelist_02_01, 1 );
				break;
			}
			wk->next_seq = SEQ_BTLIN_ERR;
			return SEQ_MSG_WAIT;
		}
	}
	wk->dat->ret_mode = PL_RET_NORMAL;
	APP_WipeStart( APP_WIPE_OUT, HEAPID_POKELIST, &wk->wipe_flg );
	return SEQ_OUT;
}




#define	SUB_BUTTON_CGX	( 5 )
#define	SUB_BUTTON_PAL	( 1 << 12 )
#define	SUB_BUTTON_SX	( 5 )
#define	SUB_BUTTON_SY	( 5 )


static const u8 SubButtonPosTbl[6][2] =
{
	{  1,  3 },
	{ 26,  3 },
	{  1, 10 },
	{ 26, 10 },
	{  1, 17 },
	{ 26, 17 },
};

static const RECT_HIT_TBL SubButtonRect[] =
{
	{  3*8,  8*8-1,  1*8,  6*8-1 },
	{  3*8,  8*8-1, 26*8, 31*8-1 },
	{ 10*8, 15*8-1,  1*8,  6*8-1 },
	{ 10*8, 15*8-1, 26*8, 31*8-1 },
	{ 17*8, 22*8-1,  1*8,  6*8-1 },
	{ 17*8, 22*8-1, 26*8, 31*8-1 },
	{ RECT_HIT_END, 0, 0, 0 }
};

static void SubButtonScrnPut( PLIST_WORK * wk, u8 pos, u8 flg )
{
	u16 * scrn;
	u16	pls;
	u8	px, py;
	u8	i, j;

	scrn = (u16 *)GF_BGL_ScreenAdrsGet( wk->bgl, GF_BGL_FRAME0_S );
	pls  = SUB_BUTTON_CGX + SUB_BUTTON_PAL + SUB_BUTTON_SX * SUB_BUTTON_SY * flg;
	px   = SubButtonPosTbl[pos][0];
	py   = SubButtonPosTbl[pos][1];

	for( i=0; i<SUB_BUTTON_SY; i++ ){
		for( j=0; j<SUB_BUTTON_SX; j++ ){
			scrn[ (py+i)*32 + px+j ] = i*SUB_BUTTON_SX + j + pls;
		}
	}
}

//--------------------------------------------------------------------------------------------
/**
 * ^b`pl̃{^
 *
 * @param	wk		|PXgʂ̃[N
 *
 * @retval	"RECT_HIT_NONE = ĂȂ"
 * @retval	"RECT_HIT_NONE != {^ԍ"
 */
//--------------------------------------------------------------------------------------------
static int SubButtonCheck( PLIST_WORK * wk )
{
	int	ret = GF_TP_RectHitTrg( SubButtonRect );

	if( ret != RECT_HIT_NONE ){
		u16	pat = 0xfffe;

		if( GF_BGL_DotCheck( wk->bgl, GF_BGL_FRAME0_S, sys.tp_x, sys.tp_y, &pat ) == FALSE ){
			return RECT_HIT_NONE;
		}
	}
	return ret;
}



//============================================================================================
//============================================================================================
//	j[
//============================================================================================
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * j[Rg[
 *
 * @param	wk		obOʂ̃[N
 *
 * @retval	"MENU_SEL_NONE = ܂IĂȂ"
 * @retval	"MENU_SEL_CANCEL = LZ"
 * @retval	"MENU_SEL_NONE = "
 */
//--------------------------------------------------------------------------------------------
static u8 MenuControl( PLIST_WORK * wk, int * seq )
{
	u32	ret = BmpMenuMain( wk->mw );

	switch( ret ){
	case BMPMENU_NULL:
		break;

	case BMPMENU_CANCEL:
		BmpTalkWinClear( &wk->win[WIN_M_MSG], WINDOW_TRANS_OFF );
		PokeListMenuExit( wk );
		if( wk->dat->mode == PL_MODE_SELECT ){
			PokeListSmallMsgPut( wk, mes_pokelist_02_06, 1 );
		}else{
			PokeListSmallMsgPut( wk, mes_pokelist_02_01, 1 );
		}
		CATS_ObjectPaletteSet( wk->act_work[PLIST_ACT_CURSOR1], 0 );
		return MENU_SEL_CANCEL;

	default:
		{
			pPLMenuFunc	func = (pPLMenuFunc)ret;
			func( wk, seq );
		}
	}

	return MENU_SEL_NONE;
}







u16 PokeList_WazaNumGet( u8 menu_id )
{
	return WazaTbl[menu_id-MENU_W_IWAKUDAKI];
}

u8	PokeList_WazaMenuIDGet( u16 waza )
{
	u16	i;

	for( i=0; i<NELEMS(WazaTbl); i++ ){
		if( waza == WazaTbl[i] ){
			return ( i+MENU_W_IWAKUDAKI );
		}
	}
	return 0xff;
}

void PokeList_SkillUseFlagSet( PLIST_DATA * dat, u16 waza )
{
	dat->ex_skill |= (1<<PokeList_WazaMenuIDGet(waza) );
}






//============================================================================================
//============================================================================================
//	ACegp
//============================================================================================
//============================================================================================
static u8 PokeSelectItemUse( PLIST_WORK * wk )
{
	if( sys.trg & PAD_BUTTON_DECIDE ){
		Snd_SePlay( PL_SE_KETTEI );
		if( wk->pos == PL_SEL_POS_EXIT ){
			if( wk->cancel_flg == 0 ){
				return SEL_CANCEL;
			}
		}else{
			return SEL_POKE;
		}
	}

	if( sys.trg & PAD_BUTTON_CANCEL ){
		if( wk->cancel_flg == 0 ){
			Snd_SePlay( PL_SE_KETTEI );
			wk->pos = PL_SEL_POS_EXIT;
			return SEL_CANCEL;
		}
	}

	return PokemonSelect( wk );
}

static void ItemUseCheck( PLIST_WORK * wk )
{
	if( PokeParty_StatusRecoverCheck(
			wk->dat->pp, wk->dat->item, wk->pos, 0, HEAPID_POKELIST ) == TRUE ){

//		PokeListLargeMsgPut( wk, mes_pokelist_04_45, 1 );
//		wk->strcv_func = PokeList_ItemUseMsgWait;
		PokeList_ItemUseMain( wk );
	}else{
		PokeListLargeMsgPut( wk, mes_pokelist_04_45, 1 );
		wk->pos = PL_SEL_POS_EXIT;
		wk->strcv_func = PokeList_ItemUseMsgWait;
	}
}


//============================================================================================
//============================================================================================
//	iobOj
//============================================================================================
//============================================================================================

// |P̎ĂACe
enum {
	POKEITEM_NONE = 0,	// ĂȂ
	POKEITEM_NORMAL,	// [ȊÕACeĂ
	POKEITEM_MAIL,		// [Ă
};

// ACe邩ǂ
enum {
	ITEMSET_TRUE = 0,	// 
	ITEMSET_FALSE		// obOςȂ̂Ń
};

//--------------------------------------------------------------------------------------------
/**
 * ACeĂ邩ǂ
 *
 * @param	wk		obOʂ̃[N
 *
 * @retval	"POKEITEM_NONE = ĂȂ"
 * @retval	"POKEITEM_NORMAL = [ȊÕACeĂ"
 * @retval	"POKEITEM_MAIL = [Ă"
 */
//--------------------------------------------------------------------------------------------
static u8 PokeItemCheck( PLIST_WORK * wk )
{
	if( wk->panel[wk->pos].item == 0 ){
		return POKEITEM_NONE;
	}else if( ItemMailCheck( wk->panel[wk->pos].item ) == TRUE ){
		return POKEITEM_MAIL;
	}
	return POKEITEM_NORMAL;
}

// 鏉
static int PokeItemSetInit_Bag( PLIST_WORK * wk )
{
	POKEMON_PARAM * pp;
	GF_BGL_BMPWIN * win;
	int	ret;
	
	pp  = PokeParty_GetMemberPointer( wk->dat->pp, wk->pos );
	win = &wk->win[WIN_L_MSG];

	switch( PokeItemCheck( wk ) ){
	case POKEITEM_NONE:		// ĂȂ
		// [Ȃ烁[ʂ֔΂
		if( ItemMailCheck( wk->dat->item ) == TRUE ){
			wk->dat->ret_mode = PL_RET_MAILSET;
			APP_WipeStart( APP_WIPE_OUT, HEAPID_POKELIST, &wk->wipe_flg );
			return SEQ_OUT;
		}
		PokeList_ItemSet( wk, pp );
		MSGMAN_GetString( wk->msg_man, mes_pokelist_04_59, wk->str_buf );
		WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(pp) );
		WORDSET_RegisterItemName( wk->wset, 1, wk->dat->item );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, wk->str_buf );
		ret = SEQ_ITEMSET_WAIT;
		break;

	case POKEITEM_NORMAL:	// [ȊÕACeĂ
		MSGMAN_GetString( wk->msg_man, mes_pokelist_04_28, wk->str_buf );
		WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(pp) );
		WORDSET_RegisterItemName( wk->wset, 1, wk->panel[wk->pos].item );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, wk->str_buf );
		ret = SEQ_ITEMSET_YN_INIT;
		break;

	case POKEITEM_MAIL:		// [Ă
		MSGMAN_GetString( wk->msg_man, mes_pokelist_04_27, wk->msg_buf );
		ret = SEQ_ITEMSET_WAIT;
		break;
	}

	BmpTalkWinWrite( win, WINDOW_TRANS_OFF, PL_TALK_WIN_CGX, PAL_TALK_WIN );
	GF_BGL_BmpWinDataFill( win, FBMP_COL_WHITE );
	PokeList_TalkMsgStart( wk );
	return ret;
}

static void PokeList_ItemSet( PLIST_WORK * wk, POKEMON_PARAM * pp )
{
	u32	item = wk->dat->item;

	MyItem_SubItem( wk->dat->myitem, wk->dat->item, 1, HEAPID_POKELIST );
	PokeParaPut( pp, ID_PARA_item, &item );

	wk->panel[wk->pos].item = wk->dat->item;
	PokeList_ItemIconChg( wk, wk->pos, wk->panel[wk->pos].item );
}

static void PokeList_ItemSetReturn( PLIST_WORK * wk, POKEMON_PARAM * pp, u32 set, u32 get )
{
	MyItem_AddItem( wk->dat->myitem, (u16)set, 1, HEAPID_POKELIST );
	PokeParaPut( pp, ID_PARA_item, &get );

	wk->panel[wk->pos].item = (u16)get;
	PokeList_ItemIconChg( wk, wk->pos, wk->panel[wk->pos].item );
}


static int PokeItemSetWait_Bag( PLIST_WORK * wk )
{
	if( GF_MSG_PrintEndCheck( wk->msg_index ) == 0 ){
		if( sys.trg & (PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL) ){
			return PokeItemEndCheck( wk );
		}
	}
	return SEQ_ITEMSET_WAIT;
}

static int PokeItemSetYesNoInit_Bag( PLIST_WORK * wk )
{
	if( GF_MSG_PrintEndCheck( wk->msg_index ) == 0 ){
		PokeList_YesNoSelectInit( wk );
		return SEQ_ITEMSET_YN_MAIN;
	}
	return SEQ_ITEMSET_YN_INIT;
}

static int PokeItemSetYesNoMain_Bag( PLIST_WORK * wk )
{
	switch( BmpYesNoSelectMain( wk->mw, HEAPID_POKELIST ) ){
	case 0:
		{
			POKEMON_PARAM * pp;
			GF_BGL_BMPWIN * win;
			u32	set_item;
			u32	get_item;

			pp  = PokeParty_GetMemberPointer( wk->dat->pp, wk->pos );
			win = &wk->win[WIN_L_MSG];

			set_item = wk->dat->item;
			get_item = wk->panel[wk->pos].item;

			PokeList_ItemSet( wk, pp );
			if( MyItem_AddItem(wk->dat->myitem,(u16)get_item,1,HEAPID_POKELIST) == FALSE ){
//				MyItem_AddItem( wk->dat->myitem, (u16)set_item, 1, HEAPID_POKELIST );
//				PokeParaPut( pp, ID_PARA_item, &get_item );
				PokeList_ItemSetReturn( wk, pp, set_item, get_item );
				MSGMAN_GetString( wk->msg_man, mes_pokelist_04_31, wk->msg_buf );
			}else{
				// [Ȃ烁[ʂ֔΂
				if( ItemMailCheck( wk->dat->item ) == TRUE ){
//					MyItem_AddItem( wk->dat->myitem, (u16)set_item, 1, HEAPID_POKELIST );
//					PokeParaPut( pp, ID_PARA_item, &get_item );
					PokeList_ItemSetReturn( wk, pp, set_item, get_item );
					wk->dat->ret_mode = PL_RET_MAILSET;
					APP_WipeStart( APP_WIPE_OUT, HEAPID_POKELIST, &wk->wipe_flg );
					return SEQ_OUT;
				}
				MSGMAN_GetString( wk->msg_man, mes_pokelist_04_32, wk->str_buf );
				WORDSET_RegisterItemName( wk->wset, 1, get_item );
				WORDSET_RegisterItemName( wk->wset, 2, set_item );
				WORDSET_ExpandStr( wk->wset, wk->msg_buf, wk->str_buf );
			}
			GF_BGL_BmpWinDataFill( win, FBMP_COL_WHITE );
			PokeList_TalkMsgStart( wk );
		}
		return SEQ_ITEMSET_WAIT;

	case BMPMENU_CANCEL:
		return PokeItemEndCheck( wk );
	}
	return SEQ_ITEMSET_YN_MAIN;
}

static int PokeItemEndCheck( PLIST_WORK * wk )
{
	if( wk->dat->mode == PL_MODE_ITEMSET_RET ){
		BmpTalkWinClear( &wk->win[WIN_L_MSG], WINDOW_TRANS_OFF );
		PokeListSmallMsgPut( wk, mes_pokelist_02_01, 1 );
		CATS_ObjectPaletteSet( wk->act_work[PLIST_ACT_CURSOR1], 0 );
		wk->dat->mode = PL_MODE_FIELD;
		return SEQ_MAIN;
	}
	wk->dat->ret_mode = PL_RET_BAG;
	APP_WipeStart( APP_WIPE_OUT, HEAPID_POKELIST, &wk->wipe_flg );
	return SEQ_OUT;
}




static int PL_MailSetEnd( PLIST_WORK * wk )
{
	POKEMON_PARAM * pp;
	GF_BGL_BMPWIN * win;
	u32	set_item;
	u32	get_item;

	pp  = PokeParty_GetMemberPointer( wk->dat->pp, wk->pos );
	win = &wk->win[WIN_L_MSG];

	set_item = wk->dat->item;
	get_item = wk->panel[wk->pos].item;

	PokeList_ItemSet( wk, pp );
	if( get_item == 0 ){
		MSGMAN_GetString( wk->msg_man, mes_pokelist_04_59, wk->str_buf );
		WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(pp) );
		WORDSET_RegisterItemName( wk->wset, 1, wk->dat->item );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, wk->str_buf );
	}else{
		MSGMAN_GetString( wk->msg_man, mes_pokelist_04_32, wk->str_buf );
		WORDSET_RegisterItemName( wk->wset, 1, get_item );
		WORDSET_RegisterItemName( wk->wset, 2, set_item );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, wk->str_buf );
	}
	BmpTalkWinWrite( win, WINDOW_TRANS_OFF, PL_TALK_WIN_CGX, PAL_TALK_WIN );
	GF_BGL_BmpWinDataFill( win, FBMP_COL_WHITE );
	PokeList_TalkMsgStart( wk );

	if( wk->dat->mode == PL_MODE_MAILSET_BAG ){
		wk->dat->mode = PL_MODE_ITEMSET_RET;
	}
	return SEQ_ITEMSET_WAIT;
}




//--------------------------------------------------------------------------------------------
/**
 * ACeACR̃L̃A[JCuCfbNX擾
 *
 * @param	none
 *
 * @return	L̃A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
u32 Pokelist_ItemIconCgxArcGet(void)
{
	return NARC_plist_gra_item_icon_NCGR;

}

//--------------------------------------------------------------------------------------------
/**
 * ACeACR̃pbg̃A[JCuCfbNX擾
 *
 * @param	none
 *
 * @return	pbg̃A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
u32 Pokelist_ItemIconPalArcGet(void)
{
	return NARC_plist_gra_item_icon_NCLR;
}

//--------------------------------------------------------------------------------------------
/**
 * ACeACR̃Z̃A[JCuCfbNX擾
 *
 * @param	none
 *
 * @return	Z̃A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
u32 Pokelist_ItemIconCellArcGet(void)
{
	return NARC_plist_gra_item_icon_NCER;
}

//--------------------------------------------------------------------------------------------
/**
 * ACeACR̃ZAj̃A[JCuCfbNX擾
 *
 * @param	none
 *
 * @return	ZAj̃A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
u32 Pokelist_ItemIconCAnmArcGet(void)
{
	return NARC_plist_gra_item_icon_NANR;
}
