/**
 *	@brief	|g@AN^[VXe
 */

#include "common.h"
#include "field/field_matrix.h"
#include "field/field_place_name.h"
#include "system/procsys.h"
#include "system/arc_util.h"
#include "system/arc_tool.h"
#include "system/clact_util.h"
#include "system/clact_tool.h"
#include "system/render_oam.h"
#include "system/fontproc.h"
#include "system/pm_str.h"
#include "system/msgdata.h"
#include "system/bmp_list.h"
#include "system/pm_str.h"
#include "system/buflen.h"
#include "system/window.h"

#include "application/poru_tool.h"
#include "porusys.h"

#define PORUC_ACTRES_MAX	(2)

///vg^Cv
void PoruCase_ActorInit(PORU_CASE_WORK *wk);
void PoruCase_ActorRelease(PORU_CASE_WORK *wk);
void PoruCase_ActorMain(PORU_CASE_WORK *wk);
void PoruCase_ActorTrans(PORU_CASE_WORK* wk);

void PoruCase_ActorInit(PORU_CASE_WORK *wk)
{
	initVramTransferManagerHeap(32,wk->heapID);

	//ZAN^[VXe
	wk->pActSys = CATS_AllocMemory(wk->heapID);
	wk->pActRes = CATS_ResourceCreate(wk->pActSys);

	{
		TCATS_OAM_INIT	coi = {
			0,128,		///< C	OAMǗ̈EJn/I
			0,32,		///< C	AtBǗ̈EJn/I
			0,128,		///< Tu	OAMǗ̈EJn/I
			0,32,		///< Tu	AtBǗ̈EJn/I
		};
		TCATS_CHAR_MANAGER_MAKE ccmm = {
			PORUC_ACTRES_MAX,	//ID䐔
			1024,	//CʃTCY(byteP)
			1024,	//TuʃTCY(byteP)
			GX_OBJVRAMMODE_CHAR_1D_32K,	//COBJ[hw
			GX_OBJVRAMMODE_CHAR_1D_32K,	//TuOBJ[hw
		};

		CATS_SystemInit( wk->pActSys, &coi, &ccmm, 32 );
		CATS_ClactSetInit( wk->pActSys, wk->pActRes,PORUCASE_ACTMAX );

		//OAM
		REND_OAM_UtilOamRamClear_Main(wk->heapID);
		REND_OAM_UtilOamRamClear_Sub(wk->heapID);
	}

	{
		TCATS_RESOURCE_FILE_LIST list = {
			"data/porucase_chr.resdat",		// LN^
			"data/porucase_pal.resdat",		// pbg
			"data/porucase_cell.resdat",	// Z
			"data/porucase_canm.resdat",	// ZAj
			NULL,						// }`Z
			NULL,						// }`ZAj
			"data/porucase_celact.cldat"		// wb_[		
		};
		CATS_ResourceLoadBinary( wk->pActSys, wk->pActRes, &list );
	}
	
	GF_Disp_GX_VisibleControl(GX_PLANEMASK_OBJ,VISIBLE_ON);
	GF_Disp_GXS_VisibleControl(GX_PLANEMASK_OBJ,VISIBLE_ON);
}

void PoruCase_ActorRelease(PORU_CASE_WORK *wk)
{
	CATS_ResourceDestructor(wk->pActSys,wk->pActRes);
	CATS_FreeMemory(wk->pActSys);
	DellVramTransferManager();	
}

void PoruCase_ActorMain(PORU_CASE_WORK *wk)
{
	CATS_Draw(wk->pActRes);
}

void PoruCase_ActorTrans(PORU_CASE_WORK* wk)
{
	CATS_RenderOamTrans();
}

