/**
 *	@file	poru_tool.c
 *	@brief	|gP[XfRg[(풓)
 *	@date	06.03.01
 *	@author	Miyuki Iwasawa
 */

#include "common.h"
#include "system/procsys.h"
#include "system/msgdata.h"
#include "system/fontproc.h"
#include "system/bmp_list.h"
#include "system/pm_str.h"
#include "system/buflen.h"
#include "system/window.h"
#include "gflib/number_str.h"

#include "msgdata/msg.naix"
#include "msgdata/msg_poruto_select.h"

#include "application/poru_tool.h"
#include "savedata/poruto_util.h"
#include "porusys.h"

#define BUFSIZ_PLVMSG	(10)

typedef enum{
 SEQ_CASE_INIT,
 SEQ_CASE_WAIT,
 SEQ_PSEL_WAIT,
 SEQ_PST_WAIT,
 SEQ_DEMO_WAIT,
 SEQ_COND_CALL,
 SEQ_COND_WAIT,
 SEQ_FINISH,
};

///|gRg[C[N
typedef struct _PORUTO_MAIN_DAT{
	int heapID;	///<q[vID
	int seq;	///<V[PX
	
	u8	pokePos;
	u8	pokePara;
	u16	pokeNo;
	PORUTO_PARAM* param;

	void *app_work;	///<TuvZXp[N
	PROC*	proc;	///<TuvZX[N
}PORUTO_MAIN_DAT;

///I[o[CvZX`
static PROC_RESULT PoruSys_Init(PROC* proc,int* seq);
static PROC_RESULT PoruSys_Main(PROC* proc,int* seq);
static PROC_RESULT PoruSys_End(PROC* proc,int* seq);

const PROC_DATA PorutoSysProcData = {
	PoruSys_Init,
	PoruSys_Main,
	PoruSys_End,
	NO_OVERLAY_ID,
};

static void PoruSys_SaveDataPut(PORUTO_MAIN_DAT* wk);
//==============================================================
//TuV[PXvg^Cv
static int seq_CaseInit(PORUTO_MAIN_DAT* wk);
static int seq_CaseWait(PORUTO_MAIN_DAT* wk);
static int seq_PokeListWait(PORUTO_MAIN_DAT* wk);
static int seq_PokeStatusWait(PORUTO_MAIN_DAT* wk);
static int seq_PoruDemoWait(PORUTO_MAIN_DAT* wk);
static int seq_PokeConditionCall(PORUTO_MAIN_DAT* wk);
static int seq_PokeConditionWait(PORUTO_MAIN_DAT* wk);

/**
 *	@brief	|gVXeĂяo[Nf[^쐬
 *
 *	K PorutoSys_ReleaseCallWork()֐ŉ邱ƁI
 */
PORUTO_PARAM* PorutoSys_CreateCallWork(SAVEDATA* savedata,int heapID)
{
	PORUTO_PARAM* wk;
	PORUTO_DATA* dat;
	PORU_LIST* pl;
	WORDSET* wset;
	STRBUF	*lvbuf;
	u8	param[PORUTO_PARAID_NUM];
	u8 i = 0,ct = 0,j = 0;
	u8	flags = 0;
	
	wk = sys_AllocMemory(heapID,sizeof(PORUTO_PARAM));
	MI_CpuClear8(wk,sizeof(PORUTO_PARAM));

	//Z[uf[^ubN擾
	wk->poruSave = SaveData_GetPorutoBlock(savedata);
	wk->mySave = SaveData_GetMyStatus(savedata);
	wk->ppSave = SaveData_GetTemotiPokemon(savedata);
	wk->itemSave = SaveData_GetMyItem(savedata);

	{
		MSGDATA_MANAGER* msgman;
		msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL,ARC_MSG,
				NARC_msg_poruto_select_dat,heapID);
		lvbuf = MSGMAN_AllocString(msgman,mes_p_select_04_01);
		MSGMAN_Delete(msgman);
	}

	dat = PorutoData_AllocWork(heapID);
	wset = WORDSET_CreateEx(1,WORDSET_DEFAULT_BUFLEN,heapID);	


	//|gf[^擾
	for(i = 0;i < PORUTO_STOCK_MAX;i++){
		PORUTO_GetData(wk->poruSave,i,dat);

		if(!PorutoData_IsEnable(dat)){
			continue;
		}
		PorutoData_GetParamArray(dat,param);

		//ef[^擾
		pl = &(wk->list[ct]);
		
		pl->id = i;
		pl->level = PorutoData_GetLevel(dat);
		pl->flavor = param[PORUTO_PARAID_FLAVOR];
		pl->taste = param[PORUTO_PARAID_TASTE];

		pl->lvbuf = STRBUF_Create(BUFSIZ_PLVMSG,heapID);

		//|gxWJ
		WORDSET_RegisterNumber(wset,0,pl->level,2,
				NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
		WORDSET_ExpandStr(wset,pl->lvbuf,lvbuf);

		flags = 1;
		for(j = 0;j < 5;j++){
			if(param[j+PORUTO_PARAID_SPICY]){
				pl->flags |= flags;
			}
			flags <<= 1;
		}
		pl->valid = pl->view = 1;
		pl->myid = ct++;
		pl->next = pl->prev = 0xFF;
	}

	//[N
	WORDSET_Delete(wset);
	sys_FreeMemoryEz(dat);
	STRBUF_Delete(lvbuf);
	
	wk->porunum = ct;	//|g擾
	return wk;
}

/**
 *	@brief	|gP[XĂяo[N
 */
void PorutoSys_ReleaseCallWork(PORUTO_PARAM* pp)
{
	int i;

	for(i = 0;i < pp->porunum;i++){
		if(pp->list[i].lvbuf != NULL){
			STRBUF_Delete(pp->list[i].lvbuf);
		}
	}
	sys_FreeMemoryEz(pp);
}

//------------------------------------------------------
/**
 *	@brief	TuvZXĂяo
 *	@param	proc	TuvZX|C^
 */
//------------------------------------------------------
static BOOL PorutoSysProcCall(PROC** proc)
{
	if(*proc){
		if(ProcMain(*proc)){
			PROC_Delete(*proc);
			*proc = NULL;
			return TRUE;
		}
	}
	return FALSE;
}

/**
 *	@brief	|gVXeĂяo
 **/
static PROC_RESULT PoruSys_Init(PROC* proc,int* seq)
{
	PORUTO_MAIN_DAT* wk = NULL;
	void* pp = PROC_GetParentWork(proc);

	//[NGA擾
	HeapStatePush();

	//q[v쐬
	sys_CreateHeap(HEAPID_BASE_APP,HEAPID_PORUTO,0x1000);
	
	wk = PROC_AllocWork(proc,sizeof(PORUTO_MAIN_DAT),HEAPID_PORUTO);
	MI_CpuClear8(wk,sizeof(PORUTO_MAIN_DAT));

	//
	wk->heapID = HEAPID_PORUTO;
	//ʃ[N|C^ۑ
	wk->param = pp;

	return PROC_RES_FINISH;
}

/**
 *	@brief	|gRg[C
 */
static PROC_RESULT PoruSys_Main(PROC* proc,int* seq)
{
	PORUTO_MAIN_DAT* wk = (PORUTO_MAIN_DAT*)PROC_GetWork(proc);

	switch(*seq){
	case SEQ_CASE_INIT:
		*seq = seq_CaseInit(wk);
		break;
	case SEQ_CASE_WAIT:
		*seq = seq_CaseWait(wk);
		break;
	case SEQ_PSEL_WAIT:
		*seq = seq_PokeListWait(wk);
		break;
	case SEQ_PST_WAIT:
		*seq = seq_PokeStatusWait(wk);
		break;
	case SEQ_COND_CALL:
		*seq = seq_PokeConditionCall(wk);
		break;
	case SEQ_COND_WAIT:
		*seq = seq_PokeConditionWait(wk);
		break;
	case SEQ_FINISH:
		return PROC_RES_FINISH;
	}
	
	return PROC_RES_CONTINUE;
}

/**
 *	@brief	|gRg[I
 */
static PROC_RESULT	PoruSys_End(PROC* proc,int* seq)
{
	PORUTO_MAIN_DAT* wk = (PORUTO_MAIN_DAT*)PROC_GetWork(proc);

	//Z[uf[^f
	PoruSys_SaveDataPut(wk);

	//[N
	PROC_FreeWork(proc);
	
	HeapStatePop();
	HeapStateCheck(wk->heapID);
	
	sys_DeleteHeap(wk->heapID);
	return PROC_RES_FINISH;
}

/**
 *	@brief	|gZ[uf[^o
 */
static void PoruSys_SaveDataPut(PORUTO_MAIN_DAT* wk)
{
	u8 i = 0;
	PORU_LIST* pl;
	
	for(i = 0;i < wk->param->porunum;i++){
		pl = &wk->param->list[i];
		
		if(pl->del){	//f[^폜
			PORUTO_DelData(wk->param->poruSave,pl->id);
		}
	}
}

//============================================================
//TuV[PX

/**
 *	@brief	|gP[X
 */
static int seq_CaseInit(PORUTO_MAIN_DAT* wk)
{
	// I[o[CID錾
	FS_EXTERN_OVERLAY(porutocase);

	static const PROC_DATA CaseProcData = {
		PoruCase_Init,
		PoruCase_Main,
		PoruCase_End,
		FS_OVERLAY_ID(porutocase),
//		NO_OVERLAY_ID,
	};
	
	wk->proc = PROC_Create(&CaseProcData,wk->param,wk->heapID);
	return SEQ_CASE_WAIT;	
}

/**
 *	@brief	|gP[XI҂
 */
static int seq_CaseWait(PORUTO_MAIN_DAT* wk)
{
	PLIST_DATA* pld;
	if(!PorutoSysProcCall(&wk->proc)){
		return SEQ_CASE_WAIT;
	}
	//I
	if(wk->param->ret_mode == PCASE_RET_CANCEL){
		return SEQ_FINISH;
	}
	
	//|PXgĂяo
	pld = sys_AllocMemory( wk->heapID, sizeof(PLIST_DATA) );
	MI_CpuClear8( pld,sizeof(PLIST_DATA) );
	pld->pp = wk->param->ppSave;
	pld->myitem = wk->param->itemSave;
	pld->type = PL_TYPE_SINGLE;
	pld->mode = PL_MODE_SET;

	wk->proc = PROC_Create(&PokeListProcData,pld,wk->heapID);
	wk->app_work = (void*)pld;

	return SEQ_PSEL_WAIT;
}

/**
 *	@brief	|PXgI҂
 */
static int seq_PokeListWait(PORUTO_MAIN_DAT* wk)
{
	u8	pos;
	PLIST_DATA *pld;
	PSTATUS_DATA* psd;
	static const u8 PST_PageTbl[] = {
		PST_PAGE_CONDITION,	// uRfBVv
		PST_PAGE_RET,			// uǂv
		PST_PAGE_MAX
	};
	
	if(!PorutoSysProcCall(&wk->proc)){
		return SEQ_PSEL_WAIT;
	}
	
	//߂l`FbN
	pld = (PLIST_DATA*)wk->app_work;
	pos = pld->ret_sel;
	wk->pokePos = pos;	///莝io[ۑ
	sys_FreeMemoryEz(wk->app_work);
	
	if(pos == PL_SEL_POS_EXIT){
		return SEQ_CASE_INIT;	//|gP[Xɖ߂
	}

	//|PXe[^XĂяo
	//
	psd = sys_AllocMemory( wk->heapID, sizeof(PSTATUS_DATA) );

	psd->ppd  = wk->param->ppSave;
	psd->ppt  = PST_PP_TYPE_POKEPARTY;
	psd->pos  = pos;
	psd->max  = (u8)PokeParty_GetPokeCount( psd->ppd );
	psd->waza = 0;
	psd->mode = PST_MODE_PORUTO;
	PokeStatus_PageSet( psd, PST_PageTbl);

	wk->proc = PROC_Create(&PokeStatusProcData,pld,wk->heapID);
	
	wk->app_work = (void*)psd;
	return SEQ_PST_WAIT;
}

/**
 *	@brief	|PXe[^XI҂
 */
static int seq_PokeStatusWait(PORUTO_MAIN_DAT* wk)
{
	PSTATUS_DATA* psd;
	u8	ret;
	
	if(!PorutoSysProcCall(&wk->proc)){
		return SEQ_PST_WAIT;
	}
	
	//߂l`FbN
	psd = (PSTATUS_DATA*)wk->app_work;
	ret = psd->ret_mode;
	sys_FreeMemoryEz(wk->app_work);
	
	if(ret == PST_RET_CANCEL){
		return SEQ_CASE_INIT;	//|gP[Xɖ߂
	}

	//Iꂽ|g
	wk->param->list[wk->param->selID].del = 1;
	//|g^fĂяo
	//
	return SEQ_COND_CALL;
}

/**
 *	@brief	|gfI҂
 */
static int seq_PoruDemoWait(PORUTO_MAIN_DAT* wk)
{
	u8	pos;
	PSTATUS_DATA* psd;
	static const u8 PST_PageTbl[] = {
		PST_PAGE_CONDITION,	// uRfBVv
		PST_PAGE_MAX
	};
	
	if(!PorutoSysProcCall(&wk->proc)){
		return SEQ_DEMO_WAIT;
	}
	
	//|PXe[^XĂяo(RfBVω)
	//
	psd = sys_AllocMemory( wk->heapID, sizeof(PSTATUS_DATA) );

	psd->ppd  = wk->param->ppSave;
	psd->ppt  = PST_PP_TYPE_POKEPARTY;
	psd->pos  = wk->pokePos;
	psd->max  = (u8)PokeParty_GetPokeCount( psd->ppd );
	psd->waza = 0;
	psd->mode = PST_MODE_CONDITION;
	PokeStatus_PageSet( psd, PST_PageTbl);

	wk->proc = PROC_Create(&PokeStatusProcData,psd,wk->heapID);
	
	wk->app_work = (void*)psd;
	return SEQ_COND_WAIT;
}

/**
 *	@brief	RfBVĂяo
 */
static int seq_PokeConditionCall(PORUTO_MAIN_DAT* wk)
{
	u8	pos;
	PSTATUS_DATA* psd;
	static const u8 PST_PageTbl[] = {
		PST_PAGE_CONDITION,	// uRfBVv
		PST_PAGE_MAX
	};
	
	//|PXe[^XĂяo(RfBVω)
	//
	psd = sys_AllocMemory( wk->heapID, sizeof(PSTATUS_DATA) );

	psd->ppd  = wk->param->ppSave;
	psd->ppt  = PST_PP_TYPE_POKEPARTY;
	psd->pos  = wk->pokePos;
	psd->max  = (u8)PokeParty_GetPokeCount( psd->ppd );
	psd->waza = 0;
	psd->mode = PST_MODE_CONDITION;
	PokeStatus_PageSet( psd, PST_PageTbl);

	wk->proc = PROC_Create(&PokeStatusProcData,psd,wk->heapID);
	
	wk->app_work = (void*)psd;
	return SEQ_COND_WAIT;
}

/**
 *	@brief	RfBV\I҂
 */
static int seq_PokeConditionWait(PORUTO_MAIN_DAT* wk)
{
	u8	pos;
	PSTATUS_DATA* psd;

	if(!PorutoSysProcCall(&wk->proc)){
		return SEQ_COND_WAIT;
	}
	sys_FreeMemoryEz(wk->app_work);
	
	//|gXg֖߂
	return SEQ_CASE_INIT;
}
