/**
 *	@file	porucase_bmp.c
 *	@brief	|gP[XBMPEBhE
 *	@author Miyuki Iwasawa
 *	@date	06.03.15
 */

#include "common.h"
#include "system/procsys.h"
#include "system/arc_util.h"
#include "system/arc_tool.h"
#include "system/snd_tool.h"
#include "system/fontproc.h"
#include "system/bmp_list.h"
#include "system/pm_str.h"
#include "system/msgdata.h"
#include "system/buflen.h"
#include "system/window.h"
#include "system/clact_util.h"
#include "system/clact_tool.h"
#include "system/render_oam.h"
#include "system/window.h"
#include "system/poruto_name.h"
#include "system/pmfprint.h"
#include "application/app_tool.h"
#include "application/poru_tool.h"
#include "savedata/poruto_util.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_poruto_select.h"
#include "porusys.h"
#include "poru_act.h"
#include "porucase_bmp.h"

#define WINCLR_COL(col)	(((col)<<4)|(col))

#define LV_OFS_X	(8)

static void PoruListCB_ForLine(BMPLIST_WORK* work,u32 param,u8 y);
static void PoruListCB_ForMove( BMPLIST_WORK * work, u32 param, u8 mode );

static const BMPLIST_HEADER PoruListHeader = {
	NULL,					//\f[^|C^
	PoruListCB_ForMove,PoruListCB_ForLine,	//R[obN(J[\ړ/s)
	NULL,					//GF_BGL_BMPWIN\̃f[^ւ̃|C^
	0,6,					//Xgڐ,\ő區ڐ
	0,8,0,					//\XW(x//J[\)
	0,						//\xW
	FBMP_COL_BLACK,FBMP_COL_NULL,FBMP_COL_BLK_SDW,		//F,wiF,eF
	0,0,				//ԊuX,Y
	BMPLIST_NO_SKIP,	//y[WXLbv^Cv
	FONT_SYSTEM,		//w
	1,					//afJ[\(allow)\tO(0:ON,1:OFF)
	NULL,				//[N|C^
};
static const BMPLIST_HEADER MenuListHeader = {
	NULL,					//\f[^|C^
	NULL,NULL,				//R[obN(J[\ړ/s)
	NULL,					//GF_BGL_BMPWIN\̃f[^ւ̃|C^
	0,3,					//Xgڐ,\ő區ڐ
	0,8,0,					//\XW(x//J[\)
	0,						//\xW
	FBMP_COL_BLACK,FBMP_COL_WHITE,FBMP_COL_BLK_SDW,		//F,wiF,eF
	0,0,				//ԊuX,Y
	BMPLIST_NO_SKIP,	//y[WXLbv^Cv
	FONT_SYSTEM,		//w
	0,					//afJ[\(allow)\tO(0:ON,1:OFF)
	NULL,				//[N|C^
};

/**
 *	@brief	|gXg[NNA
 */
static void porulist_linkClear(PORU_LIST* pl)
{
	pl->view = 0;
	pl->next = pl->prev = 0xFF;
}

/**
 * @brief	|gbZ[W`
 */
extern u8 MsgSpeedGet(void);
static void poru_msgWrite(PORU_CASE_WORK* wk,STRBUF* msg,u8 spd,u8 win_f)
{
	GF_PRINTCOLOR col = GF_PRINTCOLOR_MAKE(FBMP_COL_BLACK,FBMP_COL_BLK_SDW,FBMP_COL_WHITE);

	//EBhE`
	if(win_f){
		BmpTalkWinWrite( &wk->win[WIN_MSG], WINDOW_TRANS_OFF, BMPL_TALK_WIN_CGX, BMPL_TALK_WIN_PAL);
	}
	GF_BGL_BmpWinFill( &(wk->win[WIN_MSG]),WINCLR_COL(FBMP_COL_WHITE),
		0, 0,BMPL_MSG_SX*8,BMPL_MSG_SY*8);

	MsgPrintSkipFlagSet( MSG_SKIP_ON );
	MsgPrintAutoFlagSet( MSG_SKIP_OFF );
	
	//bZ[W`
	wk->msgIdx = GF_STR_PrintColor(
		&wk->win[WIN_MSG], FONT_TALK, msg,
		0, 0, spd, col, NULL );
}

/**
 *	@brief	|gXg̃[hʗvf
 */
u16 PoruList_GetListNum(PORUTO_PARAM* pp,PORU_CASE_WORK* wk)
{
	u16 i,count = 0;
	u8 mode,flag;
	PORU_LIST* pl;

	wk->startID = wk->endID = 0xFF;

	if(wk->viewMode == 5){
		mode = 0x1F;
	}else{
		mode = 1;
		for(i = 0;i < wk->viewMode;i++){
			mode <<= 1;
		}
	}
	
	for(i = 0;i < pp->porunum;i++){
		pl = &pp->list[i];
		porulist_linkClear(pl);
		if((!pl->valid) || pl->del){
			continue;
		}
		flag = (pl->flags & 0x1F);
		if((flag & mode) == 0){
			continue;
		}
		pl->view = 1;	//viewtOOn

		//Xgq
		if(wk->startID == 0xFF){
			wk->startID = wk->endID = pl->myid;
		}else{
			pp->list[wk->endID].next = pl->myid;
		}
		pl->prev = wk->endID; 
		wk->endID = pl->myid;
		++count;
	}
	//zXg
//	pp->list[wk->endID].next = wk->startID;
	pp->list[wk->startID].prev = wk->endID;
	
	//u߂vڕ͕Km
	count += 1;
	
	return count;
}

/**
 *	@brief	|gXgj[쐬
 */
void PoruList_CreatePMenu(PORU_CASE_WORK* wk)
{
	u8 i = 0,next = 0;
	PORU_LIST* pl;
	
	wk->viewNum =  PoruList_GetListNum(wk->param,wk);
	
	//BMPXg̈쐬
	wk->plist = BMP_MENULIST_Create(wk->viewNum,wk->heapID);

	for(i = wk->startID;i != 0xFF;i = next){
		pl = &(wk->param->list[i]);
		next = pl->next;

		BMP_MENULIST_AddString(wk->plist,
			PorutoName_GetNameAdrByMan(wk->nameMan,pl->flavor),pl->myid);
	}

	//u߂vXgɒǉ
	BMP_MENULIST_AddString(wk->plist,wk->msgDat.endbuf,0xFF);

	//BMPXg
	MI_CpuCopy8(&PoruListHeader,&wk->plist_h,sizeof(BMPLIST_HEADER));

	wk->curPos = wk->param->curPos;		//Öʒu𕜋A
	wk->listPos = wk->param->listPos;
	if(wk->curPos == 4){
		if(wk->listPos == 0){
			--wk->curPos;
		}else if((wk->curPos + wk->listPos) == (wk->viewNum-1)){
			--wk->listPos;	//ʒu
		}
	}

	wk->plist_h.win = &(wk->win[WIN_PLIST]);
	wk->plist_h.list = wk->plist;
	wk->plist_h.work = (void*)wk;
	wk->plist_h.count = wk->viewNum;

	//Xgǉ
	wk->plist_wk = BmpListSet(&wk->plist_h,wk->listPos,wk->curPos,wk->heapID);
	//LV\EBhEOn
	GF_BGL_BmpWinOn(&wk->win[WIN_PLISTLV]);
}

/**
 *	@brief	|gXg@j[Xg폜
 */
void PoruList_DeletePMenu(PORU_CASE_WORK* wk,BOOL trans)
{
	//EBhË揉
	GF_BGL_BmpWinFill( &(wk->win[WIN_PLIST]),WINCLR_COL(FBMP_COL_NULL),
			0, 0,BMPL_PLIST_SX*8,BMPL_PLIST_SY*8);
	GF_BGL_BmpWinFill( &(wk->win[WIN_PLISTLV]),WINCLR_COL(FBMP_COL_NULL),
			0, 0,BMPL_PLISTLV_SX*8,BMPL_PLISTLV_SY*8);

	if(trans){
		GF_BGL_BmpWinOff(&wk->win[WIN_PLIST]);
		GF_BGL_BmpWinOff(&wk->win[WIN_PLISTLV]);
	}

	//Xg
	BmpListExit(wk->plist_wk,&(wk->listPos),&(wk->curPos));
	BMP_MENULIST_Delete(wk->plist);

	//J[\ʒuۑ
	wk->param->listPos = wk->listPos;
	wk->param->curPos = wk->curPos;

	wk->plist_wk = NULL;
	wk->plist = NULL;
}

/**
 *	@brief	}[NAN^[Zbg
 */
static void flaverActSet(PORU_CASE_WORK* wk,PORU_LIST* pl)
{
	u8 i = 0,flag = 0x01;

	if(pl == NULL){
		for(i = 0;i < 5;i++){
			CLACT_SetDrawFlag(wk->pActFmk[i], 0);
		}
		return;
	}
	for(i = 0;i < 5;i++){
		if(pl->flags&flag){
			CLACT_SetDrawFlag(wk->pActFmk[i], 1);
		}else{
			CLACT_SetDrawFlag(wk->pActFmk[i], 0);
		}
		flag <<= 1;
	}
}

/**
 *	@brief	|gXg@j[R[obO(\)
 *	
 *	@param	work	BMPXgŐݒ肵[N
 *	@param	index	BMPXggpĂEBhECfbNX
 *	@param	param	BMPXg̃p[^
 *	@param	y		YW
 *
 *	@return	none
 */
//--------------------------------------------------------------------------------------------
static void PoruListCB_ForLine(BMPLIST_WORK* work,u32 param,u8 y)
{
	PORU_CASE_WORK* wk = (PORU_CASE_WORK*)BmpListParamGet(work,BMPLIST_ID_WORK);
	GF_PRINTCOLOR col;
	
	col = GF_PRINTCOLOR_MAKE(FBMP_COL_BLACK,FBMP_COL_BLK_SDW,FBMP_COL_NULL);

	//LV\

	//f[^Vtg
	if(sys.repeat & PAD_KEY_UP){
		GF_BGL_BmpWinShift(
			&wk->win[WIN_PLISTLV], GF_BGL_BMPWIN_SHIFT_D,
			16, WINCLR_COL(FBMP_COL_NULL) );
	}else if(sys.repeat & PAD_KEY_DOWN){
		GF_BGL_BmpWinShift(
			&wk->win[WIN_PLISTLV], GF_BGL_BMPWIN_SHIFT_U,
			16, WINCLR_COL(FBMP_COL_NULL) );
	}

	//LV\	
	if(param == 0xFF){
		GF_BGL_BmpWinFill( &(wk->win[WIN_PLISTLV]),WINCLR_COL(FBMP_COL_NULL),
			0, y,BMPL_PLISTLV_SX*8,16);
	}else{
		GF_STR_PrintColor(
			&wk->win[WIN_PLISTLV], FONT_SYSTEM, wk->param->list[param].lvbuf,
			LV_OFS_X, y, MSG_NO_PUT, col, NULL );
	}
}

//--------------------------------------------------------------------------------------------
/**
 *	@brief	|gXg@j[R[obO(J[\ړ)
 *
 * @param	work	BMPXgŐݒ肵[N
 * @param	param	BMPXg̃p[^
 * @param	mode	 = 1
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void PoruListCB_ForMove( BMPLIST_WORK * work, u32 param, u8 mode )
{
	PORU_CASE_WORK* wk = (PORU_CASE_WORK*)BmpListParamGet(work,BMPLIST_ID_WORK);
	GF_PRINTCOLOR col;
	u16 scr,cur;

	col = GF_PRINTCOLOR_MAKE(FBMP_COL_BLACK,FBMP_COL_BLK_SDW,FBMP_COL_NULL);

	//J[\ړ
	BmpListPosGet( work, &scr, &cur );
	CATS_ObjectPosSet(wk->pAct[0],105,cur*16+39);

	//Ȃ߂炩EBhEUNA
	GF_BGL_BmpWinFill( &(wk->win[WIN_TASTE]),WINCLR_COL(FBMP_COL_NULL),
		0, 0,BMPL_TASTE_SX*8,BMPL_TASTE_SY*8);

	if(param == 0xFF){
		flaverActSet(wk,NULL);
		GF_BGL_BmpWinOn(&wk->win[WIN_TASTE]);
		return;
	}
	//}[N`
	flaverActSet(wk,&wk->param->list[param]);
	
	//Ȃ߂炩\
	STRBUF_Clear(wk->msgDat.tmp);
	WORDSET_RegisterNumber(wk->msgDat.wset,0,wk->param->list[param].taste,3,
			NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	WORDSET_ExpandStr(wk->msgDat.wset,wk->msgDat.tmp,wk->msgDat.tbuf);		
	
	GF_STR_PrintColor(
		&wk->win[WIN_TASTE], FONT_SYSTEM, wk->msgDat.tmp,
		0, 0, MSG_ALLPUT, col, NULL );
}

/**
 *	@brief	j[Xg쐬
 */
void MenuList_Create(PORU_CASE_WORK* wk)
{
	u8 i = 0;
	
	//BMPXg̈쐬
	wk->mlist = BMP_MENULIST_Create(MLIST_MAX,wk->heapID);

	for(i = 0;i < MLIST_MAX;i++){
		BMP_MENULIST_AddArchiveString(wk->mlist,
			wk->msgMan,mes_p_select_02_01+i,i);
	}

	//BMPXg
	MI_CpuCopy8(&MenuListHeader,&wk->mlist_h,sizeof(BMPLIST_HEADER));

	wk->mlist_h.win = &(wk->win[WIN_MENU]);
	wk->mlist_h.list = wk->mlist;
	wk->mlist_h.work = (void*)wk;
	wk->mlist_h.count = MLIST_MAX;

	//EBhEt[`
	BmpMenuWinWrite( &wk->win[WIN_MENU], WINDOW_TRANS_OFF, BMPL_MENU_WIN_CGX, BMPL_MENU_WIN_PAL );

	//Xgǉ
	wk->mlist_wk = BmpListSet(&wk->mlist_h,0,0,wk->heapID);
}

/**
 *	@brief	j[Xg폜
 */
void MenuList_Delete(PORU_CASE_WORK* wk)
{
	u16 cur,list;
	
	//EBhENA
	BmpMenuWinClear(&(wk->win[WIN_MENU]),WINDOW_TRANS_ON);	
	GF_BGL_BmpWinOff(&wk->win[WIN_MENU]);

	//Xg
	BmpListExit(wk->mlist_wk,&list,&cur);
	BMP_MENULIST_Delete(wk->mlist);

	wk->mlist_wk = NULL;
	wk->mlist = NULL;
}

/**
 *	@brief	YesNoEBhE`ObZ[W\
 */
void YesNoList_StartMsgSet(PORU_CASE_WORK* wk)
{
	//|ĝĂ܂bZ[W`
	STRBUF_Clear(wk->msgDat.tmp);
	WORDSET_RegisterWord( wk->msgDat.wset,0,
			PorutoName_GetNameAdrByMan(wk->nameMan,wk->param->list[wk->selectID].flavor),
			PM_NEUTRAL,TRUE,PM_LANG);
	WORDSET_ExpandStr(wk->msgDat.wset,wk->msgDat.tmp,wk->msgDat.qbuf);		

	poru_msgWrite(wk,wk->msgDat.tmp,MsgSpeedGet(),TRUE);
}

/**
 *	@brief	|ĝĂ܂bZ[WZbg
 */
void YesNoList_DelMsgSet(PORU_CASE_WORK* wk)
{
	//|ĝĂ܂bZ[W`
	STRBUF_Clear(wk->msgDat.tmp);
	WORDSET_RegisterWord( wk->msgDat.wset,0,
			PorutoName_GetNameAdrByMan(wk->nameMan,wk->param->list[wk->selectID].flavor),
			PM_NEUTRAL,TRUE,PM_LANG);
	WORDSET_ExpandStr(wk->msgDat.wset,wk->msgDat.tmp,wk->msgDat.dbuf);		

	poru_msgWrite(wk,wk->msgDat.tmp,MsgSpeedGet(),FALSE);
}

/**
 *	@brief	YesNoEBhE
 */
void YesNoList_Create(PORU_CASE_WORK* wk)
{
	// ͂E
	static const BMPWIN_DAT YesNoBmpWin = {
		BMPL_MYN_FRM,BMPL_MYN_PX,BMPL_MYN_PY,BMPL_MYN_SX,BMPL_MYN_SY,
		BMPL_MYN_PAL,BMPL_MYN_CGX
	};

	wk->ynmenu_wk = BmpYesNoSelectInit(
				wk->bgl, &YesNoBmpWin, BMPL_MENU_WIN_CGX, BMPL_MENU_WIN_PAL, wk->heapID);
}
