/***
 *	@file	porusys.h
 *	@brief	|gW[[Jwb_
 *	@author	Miyuki Iwasawa
 *	@date	06.03.11
 */

#ifndef __H_PORU_SYS_H__
#define __H_PORU_SYS_H__

#include "application/poru_tool.h"
#include "system/clact_util.h"
#include "system/clact_tool.h"
#include "system/poruto_name.h"
#include "system/wordset.h"
#include "system/bmp_menu.h"
#include "porucase.dat"

#define NORMAL_ACTMAX	(2)
#define FMARK_ACTMAX	(5)
#define BUTTON_ACTMAX	(6)

#define PORUCASE_ACTMAX	( \
 NORMAL_ACTMAX + \
 FMARK_ACTMAX + \
 BUTTON_ACTMAX \
)

#define WORDSET_PORU_BUFLEN	(64)

typedef enum{
 PCASE_RET_CANCEL,
 PCASE_RET_DECIDE,
}PCASE_RET;

typedef enum{
 PCASE_MODE_PSEL,
 PCASE_MODE_MSEL,
 PCASE_MODE_MSELWAIT,
 PCASE_MODE_YNSET,
 PCASE_MODE_YNWAIT,
 PCASE_MODE_DEL,
 PCASE_MODE_EXIT,
};

typedef struct _PORUCASE_MSG{
	WORDSET* wset;		//[N
	STRBUF	*tmp;		//ėp
	STRBUF	*endbuf;	//߂
	STRBUF	*tbuf;		//炩
	STRBUF	*qbuf;		//̂Ă܂H
	STRBUF	*dbuf;		//̂Ă܂
}PORUCASE_MSG;

typedef struct _PORU_CASE_WORK{
	int	heapID;
	int	seq;
	int	sub_seq;
	int	wipe_f;
	int ret_mode;
	u16	selMode;
	u8	selectID;
	u8	viewMode;

	u8	viewNum;
	u8	startID;
	u8	endID;

	u8	msgIdx;
	PORUTO_PARAM* param;	///<pp[^
	GF_BGL_INI *bgl;	///<BGLf[^

	///|g擾}l[W
	PORUTO_NAME_MAN	*nameMan;
	MSGDATA_MANAGER *msgMan;
	PORUCASE_MSG	msgDat;

	///|gXgRg[
	u16		listPos;
	u16		curPos;
	BMPLIST_HEADER	plist_h;
	BMPLIST_HEADER	mlist_h;
	BMPLIST_WORK* plist_wk; 
	BMPLIST_WORK* mlist_wk; 
	BMPLIST_DATA* plist; 
	BMPLIST_DATA* mlist; 
	BMPMENU_WORK* ynmenu_wk; 

	///OtBbN\[X
	void*	pScrBuf01;
	void*	pScrBuf02;
	NNSG2dScreenData*	pScr01;
	NNSG2dScreenData*	pScr02;
	GF_BGL_BMPWIN	win[WIN_MAX];
	
	CATS_SYS_PTR	pActSys;	///<ZAN^[VXe
	CATS_RES_PTR	pActRes;	///<ZAN^[\[X
	CLACT_WORK_PTR	pAct[NORMAL_ACTMAX];		///<AN^[
	CLACT_WORK_PTR	pActFmk[FMARK_ACTMAX];		///<AN^[
	CLACT_WORK_PTR	pActBtn[BUTTON_ACTMAX];		///<AN^[

}PORU_CASE_WORK;

#include "poru_act.h"

///|gW[OQ
extern PROC_RESULT PoruCase_Init(PROC* proc,int* seq);
extern PROC_RESULT PoruCase_Main(PROC* proc,int* seq);
extern PROC_RESULT PoruCase_End(PROC* proc,int* seq);

#endif	//__H_PORU_SYS_H__

