//=============================================================================
/**
 * @file	comm_tradelist.c
 * @brief	f[^𑗂邽߂̃R}he[uĂ܂
 *          tB[hpł
 *          comm_command_field.h  enum ƓтłKv܂
 * @author	Akito Mori
 * @date    2005.12.21
 */
//=============================================================================

#include "common.h"
#include "communication/communication.h"
#include "system/clact_tool.h"
#include "system/msgdata_util.h"
#include "system/wordset.h"
#include "system/gra_tool.h"
#include "system/bmp_menu.h"
#include "savedata/friendlist.h"
#include "savedata/friendlist_local.h"


typedef struct TRADELIST_WORK TRADELIST_WORK;

#include "tradelist_def.h"
#include "comm_command_tradelist.h"

#include "field/fieldsys.h" //FIELDSYS_WORK
#include "system/mystatus.h"
#include "poketool/pokeparty.h"


extern void TradeListCommSendPokeData(int netID, POKEPARTY *party, int no);
extern void TradeListCommSend(int netID, int command, int pos);
void CommTradeListFriendList(int netID, int size, void* pBuff, void* pWork);


static int PositionChangeLR(u8 pos);
static int _getZero(void);
static int _getOne(void);
static int _getPokePartySplitSize(void);
static int _getFriendListSize(void);



static const CommPacketTbl _CommPacketTbl[] = {
	
	{CommTradeListPokemonData, _getPokePartySplitSize}, // CT_POKEDATA
	{CommTradeListCusorPos,   _getOne},                	// CT_CURSOR_POS,		///< J[\ʒu
	{CommTradeListDecide,   	_getOne},               // CT_TRADE_DECIDE,		///< 
	{CommTradeListResultYes,   _getOne},                // CT_TRADE_YES,		///< ͂
    {CommTradeListResultNo,		_getOne},               // CT_TRADE_NO,			///< 
    {CommTradeListTradeStart,	_getOne},               // CT_TRADE_START,		///< f
	{CommTradeListFriendList,	_getFriendListSize},	// CT_FRIENDLIST,		///< 肠O[vf[^
    {CommTradeListEnd,			_getZero},              // CT_TRADE_END,		///< I

};


//==============================================================================
/**
 * 
 *
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommCommandTradeListInitialize(void* pWork)
{
    int length = sizeof(_CommPacketTbl)/sizeof(CommPacketTbl);
    CommCommandInitialize(_CommPacketTbl, length, pWork);
}

//------------------------------------------------------------------
/**
 * ʐMŎ擾J[\ʒuE]iuv͂̂܂܁j
 *
 * @param   pos		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int PositionChangeLR(u8 pos)
{
	// 
	if(pos==12){
		return 12;
	}
	// ͉E
	if(pos<6){
		return pos+6;
	}
	//cEȂ̂ō
	return pos-6;
}

//------------------------------------------------------------------
/**
 * đĂPOKEPARTYRs[֐
 *
 * @param   party		
 * @param   buf		
 * @param   no		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void CopyPokePartySplitData(POKEPARTY *party, void *buf, int no)
{
	u32 adrs   = (u32)party+no*POKEPARTY_SEND_ONCE_SIZE;
	u32 total  = no*POKEPARTY_SEND_ONCE_SIZE+POKEPARTY_SEND_ONCE_SIZE;
	u32 offset = no*POKEPARTY_SEND_ONCE_SIZE;


	if(total > PokeParty_GetWorkSize()){
		int rest;

		rest = PokeParty_GetWorkSize() - offset;
		memcpy((void*)adrs,buf,rest);
	}else{
		memcpy((void*)adrs,buf,POKEPARTY_SEND_ONCE_SIZE);
	}
}

//==============================================================================
/**
 * |Pf[^Mi[B̃f[^MĂяo(eq݂̑MɂȂj
 * qɂPQ̕𑗐M邱ƂɂȂ͂
 * 
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommTradeListPokemonData(int netID, int size, void* pBuff, void* pWork)
{
	FIELDSYS_WORK  *fsys = (FIELDSYS_WORK*)pWork;
	TRADELIST_WORK *tlw  = fsys->tradelist_work;



	// Mf[^̂hcƈႤ̂łΎ荞
	if(netID!=CommGetCurrentID()){

		OS_Printf("|P netID = %d  no=%d, %d/%d  pokesize=%d\n",netID,tlw->exchange_friend_count,(tlw->exchange_friend_count+1)*POKEPARTY_SEND_ONCE_SIZE,PokeParty_GetWorkSize(),PokemonParam_GetWorkSize());

		// [NPokePartyɃRs[
//		PokeParty_Add(tlw->FriendPokeParty, (POKEMON_PARAM *)pBuff);
//		CopyPokePartySplitData(tlw->FriendPokeParty,pBuff,tlw->exchange_friend_count++);
		memcpy((void*)tlw->FriendPokeParty,pBuff,POKEPARTY_SEND_ONCE_SIZE);
		tlw->exchange_friend_count++;

		// ̃f[^𑗐M
		if((tlw->exchange_friend_count)*POKEPARTY_SEND_ONCE_SIZE >= PokeParty_GetWorkSize()){
//			tlw->exchange_finish = 1;
			if(CommGetCurrentID()==1){
				TradeListCommSend(CommGetCurrentID(),CT_TRADE_START,0);
			}else{
				TradeListCommSendPokeData(CommGetCurrentID(), tlw->MyPokeParty, tlw->exchange_work);
			}
		}else{
			TradeListCommSendPokeData(CommGetCurrentID(), tlw->MyPokeParty, tlw->exchange_work);
		}
		tlw->exchange_work++;
	}

}


//==============================================================================
/**
 * Xg̃J[\ʒuMƂ̃R[obN
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommTradeListCusorPos(int netID, int size, void* pBuff, void* pWork)
{
	TRADELIST_WORK *tlw  = ((FIELDSYS_WORK*)pWork)->tradelist_work;
	u8 *pos = (u8*)pBuff;

	// őf[^Ȃhĉ̗p
	if(netID!=CommGetCurrentID()){
		tlw->cursor_pos[1] =  PositionChangeLR( *pos );
	}
}
void CommTradeListDecide(int netID, int size, void* pBuff, void* pWork)
{
	TRADELIST_WORK *tlw  = ((FIELDSYS_WORK*)pWork)->tradelist_work;
	u8 *data = (u8*)pBuff;

	OS_Printf("ID%d :IR}h\n",netID);
	
	tlw->end_flag[netID] = *data;
}
void CommTradeListResultYes(int netID, int size, void* pBuff, void* pWork)
{
	
}
void CommTradeListResultNo(int netID, int size, void* pBuff, void* pWork)
{
	
}
//==============================================================================
/**
 * ʐMʂJn
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommTradeListTradeStart(int netID, int size, void* pBuff, void* pWork)
{
	TRADELIST_WORK *tlw  = ((FIELDSYS_WORK*)pWork)->tradelist_work;
	
	OS_Printf("Jnf[^\n");

	tlw->exchange_finish=2;

}


void CommTradeListEnd(int netID, int size, void* pBuff, void* pWork)
{

}


//==============================================================================
/**
 * $brief   肠O[vɓo^邽߂̃f[^M
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommTradeListFriendList(int netID, int size, void* pBuff, void* pWork)
{
	TRADELIST_WORK *tlw  = ((FIELDSYS_WORK*)pWork)->tradelist_work;
	
	OS_Printf("肠O[vf[^\n");
	
	if(CommGetCurrentID()!=netID){
		FriendList_Update( tlw->friendlist, (FRIEND_LIST*)pBuff, 1, HEAPID_TRADELIST );
		tlw->exchange_finish = 3;
	}
}


void SetFieldSys_in_TradeWorkPtr(FIELDSYS_WORK* fsys, TRADELIST_WORK *tradelist_work)
{
	fsys->tradelist_work = tradelist_work;
}

static int _getFriendListSize(void)
{
    return sizeof(FRIEND_LIST);
}


static int _getZero(void)
{
    return 0;
}

static int _getOne(void)
{
    return 1;
}

static int _getPokePartySplitSize(void)
{
	return POKEPARTY_SEND_ONCE_SIZE;
}


