//============================================================================================
/**
 * @file	tradelist.c
 * @bfief	|PXg
 * @author	Akito Mori
 * @date	05.12.08
 */
//============================================================================================

#include "common.h"
#include "system/procsys.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/pm_str.h"
#include "system/clact_tool.h"
#include "system/msgdata_util.h"
#include "system/wordset.h"
#include "msgdata/msg.naix"
#include "system/wipe.h"
#include "system/brightness.h"
#include "system/fontproc.h"
#include "system/lib_pack.h"
#include "system/fontoam.h"
#include "system/softsprite.h"
#include "system/gra_tool.h"
#include "system/bmp_menu.h"
#include "savedata/savedata.h"
#include "system/window.h"
#include "gflib/msg_print.h"
#include "gflib/touchpanel.h"
#include "poketool/monsno.h"
#include "poketool/pokeicon.h"
#include "application/tradelist.h"
#include "system/bmp_tool.h"
#include "system/snd_tool.h"
#include "gflib/strbuf_family.h"
#include "communication/communication.h"
#include "poketool/pokeparty.h"
#include "itemtool/item.h"
#include "field/comm_union_beacon.h"
#include "savedata/friendlist.h"
#include "savedata/friendlist_local.h"


#include "msgdata/msg_connect.h"
#include "msgdata/msg_dstrade.h"

#include "tradelist_bmp.h"

#include "comm_command_tradelist.h"

#define NAMEIN_MOVE_SE		(SEQ_SE_DP_SELECT)
#define NAMEIN_DECIDE_SE	(SEQ_SE_DP_SELECT)
#define NAMEIN_BS_SE		(SEQ_SE_DP_SELECT)

#define POKEICON_VRAM_OFFSET ( 4*32+18  )
#define POKEICON_TRANS_CELL  ( 4*4      )
#define POKEICON_TRANS_SIZE	 ( POKEICON_TRANS_CELL*0x20 )
#define POKEICON_PAL_OFFSET	 ( 10 )

#define POKEGRA_VRAM_OFFSET  ( 0 )
#define POKEGRA_VRAM_SIZE     ( 0x20*10*10 )


#define TRADELISTSTR_MAX	 ( 12*2 )		// ʂňԃLԂ̂12LȂ̂ł̔{obt@Ă
#define TRADELIST_CACT_MAX   ( 2+12+12+2+2) // J[\Q@|PPQ@ACePQ@|PQ@Q

#include "tradelist.naix"			// OtBbNA[JCu`
//============================================================================================
//	萔`
//============================================================================================
enum {
	SEQ_IN = 0,
	SEQ_MAIN,
	SEQ_OUT,
};

enum{
	MODE_NORMAL=0,
	MODE_TRADE_SELECT,
	MODE_END_SELECT,
};

enum{
	TRADELIST_SEQ_POKEMON_EXCHANGE,
	TRADELIST_SEQ_MAIN,
	TRADELIST_SEQ_END,
};


#include "tradelist_def.h"


//============================================================================================
//	AGB玝Ăf[^
//============================================================================================
//J[\ړp̃e[u
//㉺Ȅɒ`Ă܂
//  O P    U  V
//  Q R    W  X
//  S T  POPP
//             PQ
static const u8 movepostbl[][4][6]={
									//   0 ̈ʒu4̍s̗Dxð(㉺Ȅ)
									//   Ȃ̕Dx
	{{ 4, 2,12,12},{ 2, 4,12,12},{ 7, 6, 1, 0},{ 1, 6, 7, 0},},		//0
	{{ 5, 3,12,12},{ 3, 5,12,12},{ 0, 7, 6, 1},{ 6, 7, 0, 1},},		
	{{ 0, 0, 0, 0},{ 4, 0, 0, 0},{ 9, 8, 7, 6},{ 3, 1,     },},		
	{{ 1, 1, 1, 1},{ 5, 1, 1, 1},{ 2, 9, 8, 7},{ 8, 9, 6, 6},},		
	{{ 2, 2, 2, 2},{ 0, 0, 0, 0},{11,10,9,8,7,6},{ 5,3,1,  },},		
	{{ 3, 3, 3, 3},{ 1, 1, 1, 1},{ 4, 4, 4, 4},{10, 8, 6,  },},		//5
	{{10, 8,12,  },{ 8,10,12,  },{ 1, 0,     },{ 7, 0, 1,  },},		
	{{12,        },{ 9,12,     },{ 6,        },{ 0,        },},		
	{{ 6,        },{10, 6,     },{ 3, 2, 1, 0},{ 9, 7,     },},		
	{{ 7,        },{11,12,     },{ 8,        },{ 2, 1, 0,  },},		
	{{ 8,        },{ 6,        },{ 5, 4, 3, 2,1,0},{11, 9, 7, },},	//10
	{{ 9,        },{12,        },{10,        },{ 4, 2, 0,  },},		
	{{11, 9, 7, 6},{ 7, 6,     },{12,        },{12,        },},		

};


static const int trade_msg_table[][4]=
{
	{mes_dstrade_02_01,   0, 0, },
	{mes_dstrade_02_02,   1, mes_dstrade_03_01,  3 },
	{mes_dstrade_02_02,   1, mes_dstrade_03_02,  4 },
	{mes_dstrade_04_01,   2, 0,0,   },
	{mes_dstrade_04_03,   2, 0,0,   },
	{mes_dstrade_04_04,   2, 0,0,   },
	{mes_dstrade_04_07,   2, 0,0,   },
	{mes_dstrade_04_08,   2, 0,0,   },
};


//============================================================================================
//	vg^Cv錾
//============================================================================================
/*** ֐vg^Cv ***/
static PROC_RESULT TradeListProc_Init( PROC * proc, int * seq );
static void TransPokeIconCharaPal( NNSG2dCharacterData *chara, int pokeno, int no , CLACT_WORK_PTR icon);
static void TrainerNamePrint( GF_BGL_BMPWIN *win, FIELDSYS_WORK *fsys);
static void PokemonInfoSubPrint( GF_BGL_BMPWIN *win, int cardno );
static PROC_RESULT TradeListProc_Main( PROC * proc, int * seq );
static PROC_RESULT TradeListProc_End( PROC * proc, int * seq );
static void VBlankFunc( void * work );
static void VramBankSet(void);
static void BgInit( GF_BGL_INI * ini );
static void char_pltt_manager_init(void);
static void InitWork(TRADELIST_WORK *wk, PROC * proc);
static void BgExit( GF_BGL_INI * ini, GF_BGL_BMPWIN *win );
static void TradeListMakeScreenSet(GF_BGL_INI *bgl, int mynum, int friendnum);
static void BgGraphicSet( TRADELIST_WORK * wk );
static void InitCellActor(TRADELIST_WORK *wk);
static void SetCellActor(TRADELIST_WORK *wk);
static void DebugOBJPOSGet(TRADELIST_WORK *wk);
static int AroundWork(int w, int min, int max);
static void ControlCursor(u32 *CommWork);
static void TouchFunc(TRADELIST_WORK *wk);
static void CursorColTrans(u16 *CursorCol);
static int NextCursorSearch(int pos, int arrow, int *existtbl);
static void CursorPosChange(int pos, CLACT_WORK_PTR CursorAct, int side);
static int  ViewChange(u32 *Command, int *pos, CLACT_WORK_PTR CusorAct, int *existtbl, int side);
static void TransPokeGra_SubLcd(int side, int pokeno, u8 *char_work);
void TradeListCommSend(int netID, int command, int pos);
void TradeListCommSendPokeData(int netID, POKEPARTY *party, int no);
static void Regist_WordSetPokeName(WORDSET *wordset, POKEPARTY *party, int start );
static void Print_MainPokeName(GF_BGL_BMPWIN *win, WORDSET *wordset, MSGDATA_MANAGER *manager, POKEPARTY *party, int start );
static void TransPokeStr_SubLcd(GF_BGL_BMPWIN *win, int side, POKEPARTY *party, int pos, TRADELIST_WORK *wk);
static void PokemonDataExchange(POKEPARTY *my, POKEPARTY *your, int mysel, int yoursel);


static int TradeListPokemonExchange( TRADELIST_WORK *wk );
static int TradeListMain( TRADELIST_WORK *wk );


static int trade_seq_normal(TRADELIST_WORK *wk);
static int trade_seq_end(TRADELIST_WORK *wk );
static int trade_seq_mypoke(TRADELIST_WORK *wk );
static int trade_seq_friendpoke(TRADELIST_WORK *wk );
static int trade_seq_endyesno_wait(TRADELIST_WORK *wk);
static int trade_seq_endyesno(TRADELIST_WORK *wk );
static int trade_seq_mypoke_menu(TRADELIST_WORK *wk );
static int trade_seq_decide(TRADELIST_WORK *wk );
static int trade_seq_decide_wait(TRADELIST_WORK *wk );
static int trade_seq_friend_menu(TRADELIST_WORK *wk );
static int trade_seq_return_wait(TRADELIST_WORK *wk);
static int trade_seq_return(TRADELIST_WORK *wk);
static int trade_seq_trade_yesno(TRADELIST_WORK *wk );
static int trade_seq_trade_yesno_wait(TRADELIST_WORK *wk);
static int trade_seq_trade_yesno_result( TRADELIST_WORK *wk );
static int trade_seq_go_next( TRADELIST_WORK *wk );

static void CommSendFriendList( MYSTATUS *mystatus, FRIEND_LIST *friendlist, FRIEND_LIST *sendbuf );


static void ArcUtil_ScrnSetNoTrans(u32 fileIdx, u32 dataIdx, GF_BGL_INI* bgl, u32 frm, u32 offs, u32 transSize, BOOL compressedFlag, u32 heapID);

//============================================================================================
//	O[oϐ
//============================================================================================
// vZX`f[^
const PROC_DATA TradeListProcData = {
	TradeListProc_Init,
	TradeListProc_Main,
	TradeListProc_End,
	NO_OVERLAY_ID,
};


#define POKE_NICKNAME_LEN	(10+1)

//============================================================================================
//	vZX֐
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * vZX֐F
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT TradeListProc_Init( PROC * proc, int * seq )
{
	TRADELIST_WORK * wk;

	switch(*seq){
	case 0:
		sys_VBlankFuncChange( NULL, NULL );	// VBlankZbg
		sys_HBlankIntrStop();	//HBlank荞ݒ~

		GF_Disp_GX_VisibleControlInit();
		GF_Disp_GXS_VisibleControlInit();
		GX_SetVisiblePlane( 0 );
		GXS_SetVisiblePlane( 0 );

		sys_CreateHeap( HEAPID_BASE_APP, HEAPID_TRADELIST, 0x50000 );

		wk = PROC_AllocWork( proc, sizeof(TRADELIST_WORK), HEAPID_TRADELIST );
		memset( wk, 0, sizeof(TRADELIST_WORK) );
		wk->bgl = GF_BGL_BglIniAlloc( HEAPID_TRADELIST );
		
		// }l[W[
		wk->PokeNameWordSet  = WORDSET_CreateEx( 12, POKE_NICKNAME_LEN*2, HEAPID_TRADELIST );
		wk->WindowStrWordSet = WORDSET_Create( HEAPID_TRADELIST );
		wk->SubLcdWordSet    = WORDSET_Create( HEAPID_TRADELIST );

		wk->MsgManager = MSGMAN_Create( MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_dstrade_dat, HEAPID_TRADELIST );

		// [N
		InitWork(wk,proc);

		// L[s[gԊuύX
		sys_KeyRepeatSpeedSet( 4, 8 );

		VramBankSet();
		BgInit( wk->bgl );
		// PxύXZbg
		WIPE_Start( WIPE_PATTERN_WMS, WIPE_TYPE_FADEIN, WIPE_TYPE_FADEIN, WIPE_FADE_BLACK, 
				16, 1, HEAPID_TRADELIST, &wk->wipe_end);


		GF_BGL_VisibleSet( GF_BGL_FRAME0_M, VISIBLE_ON );

		BgGraphicSet( wk );

		// VBlank֐Zbg
		sys_VBlankFuncChange( VBlankFunc, NULL );	
  


		// OBJLApbg}l[W[
		char_pltt_manager_init();

		// CellActorVXe
		InitCellActor(wk);
		
		// CellActro\o^
		SetCellActor(wk);

		// BMPWINo^E`
		BmpMessageSet(wk->bgl,wk->TradeListWin);

		//FIELDSYS_WORKtradelist_worko^
		wk->fsys = (FIELDSYS_WORK*)PROC_GetParentWork(proc);
		SetFieldSys_in_TradeWorkPtr(wk->fsys, wk);

		// ʐMҋ@c
		TradeListWindowPrint(
			&wk->TradeListWin[BMP_M_MES3_WIN],
			mes_dstrade_04_01,
			FONT_TALK,
			wk->MsgManager,
			wk->PokeNameWordSet
		);

		// ʐMR}hXgpɕύX
		CommCommandTradeListInitialize(wk->fsys);

		// euʐMvɃr[R
		if(CommGetCurrentID()==0){
			Union_BeaconChange( UNION_PARENT_MODE_TRADENOW );
		}
		
		(*seq)++;
		break;
	case 1:
		(*seq) = 0;
		return PROC_RES_FINISH;
		break;
	}
	return PROC_RES_CONTINUE;
}


//------------------------------------------------------------------
/**
 * |PACR]i|P̖O̎j
 *
 * @param   chara	LN^[t@CAhX
 * @param   pal		pbgt@CAhX
 * @param   pokeno	|P̊JNO
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void TransPokeIconCharaPal( NNSG2dCharacterData *chara, int pokeno, int no, CLACT_WORK_PTR icon)
{
	u8 *pokepal;

	// LN^[]
	GX_LoadOBJ(chara->pRawData, (POKEICON_VRAM_OFFSET+no*POKEICON_TRANS_CELL)*0x20, POKEICON_TRANS_SIZE);


	
	// pbgݒ
	CLACT_PaletteOffsetChg( icon,  PokeIconPaletteIDGet(pokeno)+POKEICON_PAL_OFFSET);

//	pokepal = (u8*)pal->pRawData;
//	GX_LoadOBJPltt((void*)(pokepal + PokeIconPaletteIDGet(pokeno)*0x20), (POKEICON_PAL_OFFSET+no)*0x20, 0x20);

}

static const STRCODE endstr[]={ya_,me_,ru_,EOM_};

//------------------------------------------------------------------
/**
 * ̒ʐM̖O`
 *
 * @param   bgl		
 * @param   win		
 * @param   fsys		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void TrainerNamePrint( GF_BGL_BMPWIN *win, FIELDSYS_WORK *fsys)
{
	STRBUF *MyNameBuf, *FriendNameBuf, *EndBuf;
	// Todo O̎擾@̃C^[tF[X͂肵gݑւ
	// 
	MYSTATUS *mystatus, *friendstatus;

	

	mystatus     = CommMPGetMyStatus();
	friendstatus = CommInfoGetMyStatus(CommGetCurrentID()^1);
	
	MyNameBuf     = MyStatus_CreateNameString(mystatus,     HEAPID_TRADELIST);
	FriendNameBuf = MyStatus_CreateNameString(friendstatus, HEAPID_TRADELIST);

	EndBuf    = STRBUF_Create( TRADELISTSTR_MAX, HEAPID_TRADELIST );
	STRBUF_SetStringCode( EndBuf, endstr );
	

	// ̖O
	TradeListPrint(&win[BMP_M_MYNAME_WIN], MyNameBuf, TRADELIST_NAME_W, MSG_ALLPUT, CENTER_PRINT);
	// ̖O
	TradeListPrint(&win[BMP_M_FRIENDNAME_WIN], FriendNameBuf, TRADELIST_NAME_W, MSG_ALLPUT, CENTER_PRINT);
	// uv
	TradeListPrint(&win[BMP_M_ENDSTR_WIN], EndBuf, TRADELIST_ENDSTR_W, MSG_ALLPUT, CENTER_PRINT);

	STRBUF_Delete( EndBuf );
	STRBUF_Delete( FriendNameBuf );
	STRBUF_Delete( MyNameBuf);
}

static const STRCODE testname[]={HU_,SI_,GI_,DA_,NE_,EOM_};
static const STRCODE testlevel[]={L__,v__,spc_,n1_,n0_,n0_,EOM_};
static const STRCODE testmotimono[]={mo_,ti_,mo_,no_,EOM_};
static const STRCODE testitem[]={HA_,bou_,BA_,bou_,ME_,bou_,RU_,EOM_};

static void PokemonInfoSubPrint( GF_BGL_BMPWIN *win, int cardno )
{
	STRBUF *PokeNameBuf, *LevelBuf, *MotimonoBuf, *ItemBuf;
	int    page;
	
	page = cardno / 6;
	
	// Todo PokeParty̎擾̎dgݑւ
	
	PokeNameBuf = STRBUF_Create( TRADELISTSTR_MAX, HEAPID_TRADELIST );
	LevelBuf 	= STRBUF_Create( TRADELISTSTR_MAX, HEAPID_TRADELIST );
	MotimonoBuf = STRBUF_Create( TRADELISTSTR_MAX, HEAPID_TRADELIST );
	ItemBuf 	= STRBUF_Create( TRADELISTSTR_MAX, HEAPID_TRADELIST );

	STRBUF_SetStringCode( PokeNameBuf, testname);
	STRBUF_SetStringCode( LevelBuf,    testlevel);
	STRBUF_SetStringCode( MotimonoBuf, testmotimono);
	STRBUF_SetStringCode( ItemBuf,     testitem);
	
	TradeListPrint(&win[BMP_S_MYPOKENAME_WIN+page], PokeNameBuf, SUB_POKENAME_W, MSG_ALLPUT, CENTER_PRINT);
	TradeListPrint(&win[BMP_S_MYPOKELEVEL_WIN+page], LevelBuf, SUB_POKELEVEL_W, MSG_ALLPUT, LEFT_PRINT);
	TradeListPrint(&win[BMP_S_MOTIMONO0_WIN+page], MotimonoBuf, SUB_MOTIMONOSTR_W, MSG_ALLPUT, LEFT_PRINT);
	TradeListPrint(&win[BMP_S_MYITEM_WIN+page], ItemBuf, SUB_ITEM_W, MSG_ALLPUT, CENTER_PRINT);

//	GF_STR_PrintColor(	&win[BMP_S_MYPOKENAME_WIN+page],  FONT_SYSTEM, PokeNameBuf,     0, 0, MSG_ALLPUT, GF_PRINTCOLOR_MAKE(1, 12, 0), NULL );
//	GF_STR_PrintColor(	&win[BMP_S_MYPOKELEVEL_WIN+page], FONT_SYSTEM, LevelBuf, 0, 0, MSG_ALLPUT, GF_PRINTCOLOR_MAKE(1, 12, 0), NULL );
//	GF_STR_PrintColor(	&win[BMP_S_MOTIMONO0_WIN+page],   FONT_SYSTEM, MotimonoBuf,     0, 0, MSG_ALLPUT, GF_PRINTCOLOR_MAKE(1, 12, 0), NULL );
//	GF_STR_PrintColor(	&win[BMP_S_MYITEM_WIN+page],      FONT_SYSTEM, ItemBuf, 0, 0, MSG_ALLPUT, GF_PRINTCOLOR_MAKE(1, 12, 0), NULL );

	STRBUF_Delete( ItemBuf  );
	STRBUF_Delete( MotimonoBuf );
	STRBUF_Delete( LevelBuf  );
	STRBUF_Delete( PokeNameBuf );
	               
}



static tradedebugno = 0;

//--------------------------------------------------------------------------------------------
/**
 * vZX֐FC
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------

static PROC_RESULT TradeListProc_Main( PROC * proc, int * seq )
{
	TRADELIST_WORK * wk  = PROC_GetWork( proc );

	switch( *seq ){
	case SEQ_IN:
		if( wk->wipe_end){
			*seq = SEQ_MAIN;
			TrainerNamePrint( wk->TradeListWin, PROC_GetParentWork(proc) );

			PokemonInfoSubPrint(wk->TradeListWin, 0);
			PokemonInfoSubPrint(wk->TradeListWin, 6);
			OS_Printf("|Pp[eB[ = %d\n",PokeParty_GetPokeCount(wk->MyPokeParty));
		}
		break;

	case SEQ_MAIN:
		switch(wk->tradeseq){
		// |Pf[^
		case TRADELIST_SEQ_POKEMON_EXCHANGE:
			wk->tradeseq = TradeListPokemonExchange(wk);
			break;
		//
		case TRADELIST_SEQ_MAIN:
			wk->tradeseq = TradeListMain(wk);
			TouchFunc(wk);
			break;
		case TRADELIST_SEQ_END:
			WIPE_Start(WIPE_PATTERN_WMS, WIPE_TYPE_FADEOUT, WIPE_TYPE_FADEOUT, WIPE_FADE_BLACK, 
				16, 1, HEAPID_TRADELIST, &wk->wipe_end);
			wk->wipe_end = 0;
			*seq = SEQ_OUT;
			break;
		}

		break;

	case SEQ_OUT:
		if( wk->wipe_end ){
			return PROC_RES_FINISH;
		}
		break;
	}
	CLACT_Draw( wk->clactSet );									// ZAN^[풓֐

	return PROC_RES_CONTINUE;
}


//------------------------------------------------------------------
/**
 * WordSetɃ|P̖Oo^
 *
 * @param   wordset		
 * @param   party		
 * @param   start		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void Regist_WordSetPokeName(WORDSET *wordset, POKEPARTY *party, int start )
{
	int i;
	for(i=0;i<PokeParty_GetPokeCount(party);i++){
		WORDSET_RegisterPokeNickName( wordset, i+start, PPPPointerGet(PokeParty_GetMemberPointer(party, i)));
	}
}

//------------------------------------------------------------------
/**
 * |PPQ̕]
 *
 * @param   win		
 * @param   wordset		
 * @param   manager		
 * @param   party		
 * @param   start		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void Print_MainPokeName(GF_BGL_BMPWIN *win, WORDSET *wordset, MSGDATA_MANAGER *manager, POKEPARTY *party, int start )
{
	int i;
	for(i=0;i<PokeParty_GetPokeCount(party);i++){
		STRBUF *name = MSGDAT_UTIL_AllocExpandString( wordset, manager, mes_dstrade_01_02+start+i, HEAPID_TRADELIST );
		TradeListPrint(&win[i], name, TRADELIST_POKENAME_W, MSG_ALLPUT, LEFT_PRINT);
		STRBUF_Delete( name );
	}
}

static void LoadPokeIcon(POKEPARTY *party, int start, TRADELIST_WORK *wk)
{
	int i;
	for(i=0;i<PokeParty_GetPokeCount(party);i++){
		wk->PokeIconBuf[i+start] = ArcUtil_CharDataGet( ARC_POKEICON, 
			PokeIconCgxArcIndexGetByMonsNo( wk->existtbl[i+start], 0 ), 0, &wk->PokeIconCharaDat[i+start], HEAPID_TRADELIST );
		DC_FlushRange(wk->PokeIconCharaDat[i+start],0x20*4*4);
		TransPokeIconCharaPal(wk->PokeIconCharaDat[i+start], wk->existtbl[i+start], i+start, wk->PokeIconActWork[i+start]);

		// ACeACR̕\E[EACêǂ炩
		if(wk->item[i+start]==0){
			// ACê͖Ŕ\
			CLACT_SetDrawFlag(wk->PokeItemActWork[i+start], 0);
		}else{
			// ACe[ɂ킹ĉ摜`FW
			CLACT_AnmChg( wk->PokeItemActWork[i+start], 3+wk->item[i+start]-1 );
		}
	}
	
	// c͑SĔ\
	for(;i<6;i++){
		CLACT_SetDrawFlag(wk->PokeIconActWork[i+start], 0);
		CLACT_SetDrawFlag(wk->PokeItemActWork[i+start], 0);
	}
}

enum{
	EXCHANGE_SEQ_START = 0,
	EXCHANGE_SEQ_WAIT,
	EXCHANGE_SEQ_FINISH,
	EXCHANGE_SEQ_DATA_SETUP,
	EXCHANGE_SEQ_FRIENDLIST,
	EXCHANGE_SEQ_FRIENDLIST_END,
	EXCHANGE_SEQ_IN,
	EXCHANGE_SEQ_FADE1,
	EXCHANGE_SEQ_FADE2,
	EXCHANGE_SEQ_FADE3,
	EXCHANGE_SEQ_FADE4,
};

//------------------------------------------------------------------
/**
 * Xg|Pf[^L
 *
 * @param   wk		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int TradeListPokemonExchange( TRADELIST_WORK *wk )
{
	switch(wk->exchangeseq){
	case EXCHANGE_SEQ_START:
		wk->exchange_work         = 0;
		wk->exchange_finish       = 0;
		wk->exchange_friend_count = 0;
		if(CommGetCurrentID()==1){
			// qʐMJn(q@j
			TradeListCommSendPokeData(CommGetCurrentID(), wk->MyPokeParty, wk->exchange_work);
			wk->exchange_work++;
		}
		wk->exchangeseq++;
//		wk->exchangeseq = EXCHANGE_SEQ_IN;

		break;
	case EXCHANGE_SEQ_WAIT:
		if(wk->exchange_finish!=0){
//			if(CommGetCurrentID()==0){
//				TradeListCommSend(CommGetCurrentID(),CT_TRADE_START, 0);
//			}
			wk->exchangeseq = EXCHANGE_SEQ_FINISH;
		}
		break;
	case EXCHANGE_SEQ_FINISH:
//		if(wk->exchange_finish==2){
			wk->exchangeseq++;

			// |POo^
			Regist_WordSetPokeName(wk->PokeNameWordSet, wk->MyPokeParty,     0 );
			Regist_WordSetPokeName(wk->PokeNameWordSet, wk->FriendPokeParty, 6 );
			
			// |POBmp`
			Print_MainPokeName(&wk->TradeListWin[BMP_M_MYPOKENAME0_WIN],wk->PokeNameWordSet,wk->MsgManager,wk->MyPokeParty,     0);
			Print_MainPokeName(&wk->TradeListWin[BMP_M_FRIENDPOKENAME0_WIN],wk->PokeNameWordSet,wk->MsgManager,wk->FriendPokeParty, 6);

			TradeListMakeScreenSet(wk->bgl, PokeParty_GetPokeCount(wk->MyPokeParty), PokeParty_GetPokeCount(wk->FriendPokeParty));

//		}
		break;
	case EXCHANGE_SEQ_DATA_SETUP:
		{
			{
				int i,item;
				for(i=0;i<13;i++){
				wk->existtbl[i] = 0;
				}
				for(i=0;i<PokeParty_GetPokeCount(wk->MyPokeParty);i++){
					wk->existtbl[i] = PokeParaGet(PokeParty_GetMemberPointer(wk->MyPokeParty, i),ID_PARA_monsno,NULL);
					item = PokeParaGet(PokeParty_GetMemberPointer(wk->MyPokeParty, i),ID_PARA_item,NULL);
					if(item!=0){
						wk->item[i]     = ItemMailCheck( item )+1;	// [QAitemP
					}
				}
				for(i=0;i<PokeParty_GetPokeCount(wk->FriendPokeParty);i++){
					wk->existtbl[i+6] = PokeParaGet(PokeParty_GetMemberPointer(wk->FriendPokeParty, i),ID_PARA_monsno,NULL);
					item = PokeParaGet(PokeParty_GetMemberPointer(wk->FriendPokeParty, i),ID_PARA_item,NULL);
					if(item!=0){
						wk->item[i+6]     = ItemMailCheck( item )+1;	// [QAitemP
					}
				}
				wk->existtbl[12] = 1;
			}


			// ACRf[^ǂݍœ]
			LoadPokeIcon( wk->MyPokeParty,     0, wk);
			LoadPokeIcon( wk->FriendPokeParty, 6, wk);

		}
		wk->exchangeseq++;
		break;
	case EXCHANGE_SEQ_FRIENDLIST:
		CommSendFriendList( CommMPGetMyStatus(), wk->friendlist, &wk->SendList );
		wk->exchangeseq++;
		break;
	case EXCHANGE_SEQ_FRIENDLIST_END:
		if(wk->exchange_finish==3){
			wk->exchangeseq++;
		}

		break;
	case EXCHANGE_SEQ_IN:
		ChangeBrightnessRequest( 8, 0, -16, PLANEMASK_BG1|PLANEMASK_BG2|PLANEMASK_BG3|PLANEMASK_OBJ, MASK_MAIN_DISPLAY );
		GF_BGL_VisibleSet( GF_BGL_FRAME1_M, VISIBLE_ON );
		GF_BGL_VisibleSet( GF_BGL_FRAME2_M, VISIBLE_ON );
		GF_BGL_VisibleSet( GF_BGL_FRAME3_M, VISIBLE_ON );
		GF_Disp_GX_VisibleControl(GX_PLANEMASK_OBJ,  VISIBLE_ON);	//OBJʂnm
		
		wk->exchangeseq++;
		break;
	case EXCHANGE_SEQ_FADE1:
		if( IsFinishedBrightnessChg(MASK_MAIN_DISPLAY) ){
			wk->exchangeseq++;
			// ʗp|POtBbN]
			TransPokeGra_SubLcd(0,wk->existtbl[0], wk->PokeGra[0]);
			TransPokeStr_SubLcd(wk->TradeListWin,0,wk->MyPokeParty, 0, wk);


//			TransPokeGra_SubLcd(1,2, wk->PokeGra[1]);
		}
		break;
	case EXCHANGE_SEQ_FADE2:
		ChangeBrightnessRequest( 8, 0, -16, PLANEMASK_BG0|PLANEMASK_BG1|PLANEMASK_BG2|PLANEMASK_OBJ, MASK_SUB_DISPLAY );
		GF_BGL_VisibleSet( GF_BGL_FRAME0_S, VISIBLE_ON );
		GF_BGL_VisibleSet( GF_BGL_FRAME1_S, VISIBLE_ON );
		GF_BGL_VisibleSet( GF_BGL_FRAME2_S, VISIBLE_ON );
		GF_Disp_GXS_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_ON);	//OBJʂnm
			wk->exchangeseq++;
		break;
	case EXCHANGE_SEQ_FADE3:
		if( IsFinishedBrightnessChg(MASK_SUB_DISPLAY) ){
			// |PIł
			GF_BGL_ScrFill(	wk->bgl, GF_BGL_FRAME0_M, 0, 0, 0, 32, 24,  0);
			TradeListWindowPrint(
				&wk->TradeListWin[BMP_M_MES1_WIN],
				mes_dstrade_02_01,FONT_TALK,
				wk->MsgManager,
				wk->PokeNameWordSet
			);

			OS_Printf("|Pp[eB[ = %d\n",PokeParty_GetPokeCount(wk->MyPokeParty));
			return TRADELIST_SEQ_MAIN;
		}
		break;
	}

	return TRADELIST_SEQ_POKEMON_EXCHANGE;
}




//------------------------------------------------------------------
/**
 * XgC[v
 *
 * @param   wk		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int TradeListMain( TRADELIST_WORK *wk )
{
	// J[\ړ
	switch(wk->inputmode){
	case MODE_NORMAL:

		if(wk->func!=NULL){
			wk->inputmode = wk->func(wk);
		}
		break;
	case MODE_END_SELECT:
		return TRADELIST_SEQ_END;
		break;
	case MODE_TRADE_SELECT:
		break;
	
	}


	// ̃J[\ړ(J[\ړ牺ʂ̃|P\ύXj
	if(ViewChange(&wk->CommWork[0], &wk->cursor_pos[0], wk->clActWork[0], wk->existtbl,0)){
		if(wk->cursor_pos[0]!=12){
			TransPokeGra_SubLcd(wk->cursor_pos[0]/6, wk->existtbl[wk->cursor_pos[0]],wk->PokeGra[wk->cursor_pos[0]/6] );
			if(wk->cursor_pos[0]<6){
				TransPokeStr_SubLcd(wk->TradeListWin,0,wk->MyPokeParty,    wk->cursor_pos[0], wk);
			}else{
				TransPokeStr_SubLcd(wk->TradeListWin,1,wk->FriendPokeParty, wk->cursor_pos[0]-6, wk);
			}
		}
	
	}

	// ̃J[\ړ
	ViewChange(&wk->CommWork[1], &wk->cursor_pos[1], wk->clActWork[1], wk->existtbl,1);
	CursorColTrans(&wk->CursorPal);


	// J[\ʒuW𑗐M
	TradeListCommSend(CommGetCurrentID(), CT_CURSOR_POS, wk->cursor_pos[0]);

	return TRADELIST_SEQ_MAIN;
}


//--------------------------------------------------------------------------------------------
/**
 * vZX֐FI
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT TradeListProc_End( PROC * proc, int * seq )
{
	TRADELIST_WORK  *wk    = PROC_GetWork( proc );
	int i;

	// ZAN^[\[X
	// L]}l[W[j
	CLACT_U_CharManagerDelete(wk->resObjTbl[MAIN_LCD][CLACT_U_CHAR_RES]);
	CLACT_U_CharManagerDelete(wk->resObjTbl[SUB_LCD][CLACT_U_CHAR_RES]);

	// pbg]}l[W[j
	CLACT_U_PlttManagerDelete(wk->resObjTbl[MAIN_LCD][CLACT_U_PLTT_RES]);
	CLACT_U_PlttManagerDelete(wk->resObjTbl[SUB_LCD][CLACT_U_PLTT_RES]);
		
	// LEpbgEZEZAj̃\[X}l[W[j
	for(i=0;i<CLACT_RESOURCE_NUM;i++){
		CLACT_U_ResManagerDelete(wk->resMan[i]);
	}
	// ZAN^[Zbgj
	CLACT_DestSet(wk->clactSet);

	//OAM_[j
	REND_OAM_Delete();

	// |PACR
	for(i=0;i<PokeParty_GetPokeCount(wk->MyPokeParty);i++){
		sys_FreeMemory( HEAPID_TRADELIST,wk->PokeIconBuf[i] );
	}
	for(i=0;i<PokeParty_GetPokeCount(wk->FriendPokeParty);i++){
		sys_FreeMemory( HEAPID_TRADELIST,wk->PokeIconBuf[i+6] );
	}

	sys_FreeMemoryEz(wk->FriendPokeParty);

	DeleteCharManager();
	DeletePlttManager();

	// BMPEBhEJ
	TradeListBmpExit(wk->TradeListWin);

	// BGL폜
	BgExit(wk->bgl,wk->TradeListWin);


	// bZ[W}l[W[E[hZbg}l[W[
	MSGMAN_Delete( wk->MsgManager );
	WORDSET_Delete( wk->SubLcdWordSet );
	WORDSET_Delete( wk->WindowStrWordSet );
	WORDSET_Delete( wk->PokeNameWordSet );

	// STRBUF
	STRBUF_Delete(wk->MyName);

	PROC_FreeWork( proc );				// [NJ

	sys_VBlankFuncChange( NULL, NULL );		// VBlankZbg

	sys_DeleteHeap( HEAPID_TRADELIST );


	return PROC_RES_FINISH;
}


//--------------------------------------------------------------------------------------------
/**
 * VBlank֐
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void VBlankFunc( void * work )
{
	// ZAN^[
	// Vram]}l[W[s
	DoVramTransferManager();

	// _LOAM}l[WVram]
	REND_OAMTrans();	
	
	OS_SetIrqCheckFlag( OS_IE_V_BLANK );
}


//--------------------------------------------------------------------------------------------
/**
 * VRAMݒ
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void VramBankSet(void)
{
	GF_BGL_DISPVRAM tbl = {
		GX_VRAM_BG_128_A,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg

		GX_VRAM_SUB_BG_128_C,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg

		GX_VRAM_OBJ_128_B,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg

		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg

		GX_VRAM_TEX_NONE,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_NONE			// eNX`pbgXbg
	};
	GF_Disp_SetBank( &tbl );
}

//--------------------------------------------------------------------------------------------
/**
 * BGݒ
 *
 * @param	ini		BGLf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BgInit( GF_BGL_INI * ini )
{
	// BG SYSTEM
	{	
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_2D,
		};
		GF_BGL_InitBG( &BGsys_data );
	}

	// ----------C-------------------
	// CʃEChEBG0
	{	
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME0_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME0_M );


	}

	// Cʃ|PBG1
	{	
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x08000, GX_BG_EXTPLTT_01,
			1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME1_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME1_M );
	}

	// CʃplBG2
	{	
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe000, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
			2, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME2_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME2_M );
	}

	// CʔwiBG3
	{	
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe800, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
			3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME3_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
	}

	// -----Tu-------------

	// TuʃeLXgBG (CHAR)
	{	
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME0_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME0_S );
	}

	// TuʃJ[hBG (CHAR)
	{	
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME1_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
	}
	// TuʔwiBG (CHAR)
	{	
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xd800, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME2_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
	}

	GF_BGL_ClearCharSet( GF_BGL_FRAME0_M, 32, 0, HEAPID_TRADELIST );
	GF_BGL_ClearCharSet( GF_BGL_FRAME0_S, 32, 0, HEAPID_TRADELIST );

	// BGXN[WX^
	{
		int i;
		for(i=0;i<4;i++){
			GF_BGL_ScrollSet( ini, GF_BGL_FRAME0_M+i, GF_BGL_SCROLL_X_SET, 0 );
			GF_BGL_ScrollSet( ini, GF_BGL_FRAME0_M+i, GF_BGL_SCROLL_Y_SET, 0 );
			GF_BGL_ScrollSet( ini, GF_BGL_FRAME0_S+i, GF_BGL_SCROLL_X_SET, 0 );
			GF_BGL_ScrollSet( ini, GF_BGL_FRAME0_S+i, GF_BGL_SCROLL_Y_SET, 0 );
		}
	}

	GF_BGL_VisibleSet( GF_BGL_FRAME0_M, VISIBLE_OFF );
	GF_BGL_VisibleSet( GF_BGL_FRAME1_M, VISIBLE_OFF );
	GF_BGL_VisibleSet( GF_BGL_FRAME2_M, VISIBLE_OFF );
	GF_BGL_VisibleSet( GF_BGL_FRAME3_M, VISIBLE_OFF );
	GF_BGL_VisibleSet( GF_BGL_FRAME0_S, VISIBLE_OFF );
	GF_BGL_VisibleSet( GF_BGL_FRAME1_S, VISIBLE_OFF );
	GF_BGL_VisibleSet( GF_BGL_FRAME2_S, VISIBLE_OFF );

	// ʂ̃n[hEFAEChE0nm
//	GX_SetVisibleWnd( GX_WNDMASK_W0 );
//	G2_SetWnd0InsidePlane( GX_WND_PLANEMASK_BG2 | GX_WND_PLANEMASK_OBJ,1);
//	G2_SetWndOutsidePlane( GX_WND_PLANEMASK_BG0 | GX_WND_PLANEMASK_BG1 |GX_WND_PLANEMASK_BG2 | GX_WND_PLANEMASK_OBJ,1);
//	G2_SetWnd0Position(0, 0, 255, 64);


}


//------------------------------------------------------------------
/**
 * |PXg[N
 *
 * @param   wk		NAMEIN_WORK*
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void InitWork(TRADELIST_WORK *wk, PROC * proc)
{
	TRADELIST_PARAM *trade_param = PROC_GetParentWork(proc);

	

	wk->seq = NAMEIN_MODE;

	wk->yesnoseq      = 0;
	wk->MyPokeNum     = 6;
	wk->FriendPokeNum = 6;
	wk->cursor_pos[0] = 0;
	wk->cursor_pos[1] = 6;
	wk->inputmode     = MODE_NORMAL;

	wk->tradeseq      = 0;
	wk->exchangeseq   = 0;
	wk->func          = trade_seq_normal;
	wk->end_flag[0]   = 0;
	wk->end_flag[1]   = 0;
	

	// 莝|Pf[^擾
	wk->MyPokeParty     = trade_param->myparty;;
	wk->friendlist      = trade_param->friendlist;
	
	// ̃|Pf[^p[N
	wk->FriendPokeParty = sys_AllocMemory( HEAPID_TRADELIST, PokeParty_GetWorkSize());
	PokeParty_Init(wk->FriendPokeParty, 6);
	memset(wk->FriendPokeParty,0xff,PokeParty_GetWorkSize());
	
	wk->MyName = MyStatus_CreateNameString(trade_param->mystatus, 	HEAPID_TRADELIST);
	
}

//--------------------------------------------------------------------------------------------
/**
 * BG
 *
 * @param	ini		BGLf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BgExit( GF_BGL_INI * ini, GF_BGL_BMPWIN *win )
{
	int i;

//	for(i=0;i<BMP_NAMEIN_MAX;i++){
//		GF_BGL_BmpWinDel( &win[i] );
//	}

	//bEChEpobt@
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME2_S);
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME1_S );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME0_S );

	GF_BGL_BGControlExit( ini, GF_BGL_FRAME3_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME2_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME1_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME0_M );


	sys_FreeMemory( HEAPID_TRADELIST, ini );
}


//------------------------------------------------------------------
/**
 * ]ȂŃXN[f[^ǂݍ
 *
 * @param   fileIdx		
 * @param   dataIdx		
 * @param   bgl		
 * @param   frm		
 * @param   offs		
 * @param   transSize		
 * @param   compressedFlag		
 * @param   heapID		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void ArcUtil_ScrnSetNoTrans(u32 fileIdx, u32 dataIdx, GF_BGL_INI* bgl, u32 frm, u32 offs, u32 transSize, BOOL compressedFlag, u32 heapID)
{
	void* arcData = ArcUtil_Load( fileIdx, dataIdx, compressedFlag, heapID, ALLOC_BOTTOM );

	if( arcData != NULL )
	{
		NNSG2dScreenData* scrnData;

		if( NNS_G2dGetUnpackedScreenData( arcData, &scrnData ) )
		{
			if( transSize == 0 )
			{
				transSize = scrnData->szByte;
			}

			if( GF_BGL_ScreenAdrsGet( bgl, frm ) != NULL )
			{
				GF_BGL_ScreenBufSet( bgl, frm, scrnData->rawData, transSize );
			}
		}
		sys_FreeMemoryEz( arcData );
	}
}

#define POKEPARTY_NUM	(  6 )

#define CARD_W			(  8 )
#define CARD_H			(  5 )

#define LEFT_CARD_SX	(  0 )
#define LEFT_CARD_SY	(  4 )
#define RIGHT_CARD_SX	( 16 )
#define RIGHT_CARD_SY	(  4 )

static const card_pos_table[][2]={
	{LEFT_CARD_SX,			LEFT_CARD_SY},
	{LEFT_CARD_SX+CARD_W,	LEFT_CARD_SY},
	{LEFT_CARD_SX,			LEFT_CARD_SY+CARD_H},
	{LEFT_CARD_SX+CARD_W,	LEFT_CARD_SY+CARD_H},
	{LEFT_CARD_SX,			LEFT_CARD_SY+CARD_H*2},
	{LEFT_CARD_SX+CARD_W,	LEFT_CARD_SY+CARD_H*2},

	{RIGHT_CARD_SX,			RIGHT_CARD_SY},
	{RIGHT_CARD_SX+CARD_W,	RIGHT_CARD_SY},
	{RIGHT_CARD_SX,			RIGHT_CARD_SY+CARD_H},
	{RIGHT_CARD_SX+CARD_W,	RIGHT_CARD_SY+CARD_H},
	{RIGHT_CARD_SX,			RIGHT_CARD_SY+CARD_H*2},
	{RIGHT_CARD_SX+CARD_W,	RIGHT_CARD_SY+CARD_H*2},
};

//------------------------------------------------------------------
/**
 * O\J[h
 *
 * @param   bgl		
 * @param   mynum		
 * @param   friendnum		
 *
 * @retval  void 			
 */
//------------------------------------------------------------------
static void TradeListMakeScreenSet(GF_BGL_INI *bgl, int mynum, int friendnum)
{
	int i;

#if 0
	// |P̐ɂ킹ăJ[h̐ς
	for(i=mynum;i<6;i++)
	{
		GF_BGL_ScrFill(	bgl, GF_BGL_FRAME2_M, 0, card_pos_table[i][0], card_pos_table[i][1], CARD_W, CARD_H,  0);
	}
	for(i=friendnum;i<6;i++)
	{
		GF_BGL_ScrFill(	bgl, GF_BGL_FRAME2_M, 0, card_pos_table[i+6][0], card_pos_table[i+6][1], CARD_W, CARD_H,  0);
	}
#endif

	// XN[]
	GF_BGL_LoadScreen( bgl, GF_BGL_FRAME2_M, GF_BGL_ScreenAdrsGet( bgl, GF_BGL_FRAME2_M ), 32*24*2, 0 );

}

//--------------------------------------------------------------------------------------------
/**
 * OtBbNf[^Zbg
 *
 * @param	wk		|PXgʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BgGraphicSet( TRADELIST_WORK * wk )
{
	GF_BGL_INI *bgl = wk->bgl;

	// ㉺ʂafpbg]
	ArcUtil_PalSet(    ARC_TRADELIST_GRA, NARC_TradeList_DsTradeList_nclr, PALTYPE_SUB_BG,  0, 16*3*2,  HEAPID_TRADELIST);
	ArcUtil_PalSet(    ARC_TRADELIST_GRA, NARC_TradeList_DsTradeList_nclr, PALTYPE_MAIN_BG, 0, 16*3*2,  HEAPID_TRADELIST);

	// BGL]
	ArcUtil_BgCharSet( ARC_TRADELIST_GRA, NARC_TradeList_chara_lz_ncgr, bgl, GF_BGL_FRAME2_M, 0, 32*8*0x20, 1, HEAPID_TRADELIST);

	// BG2XN[ǂݍ݁î݁j
	ArcUtil_ScrnSetNoTrans(   ARC_TRADELIST_GRA, NARC_TradeList_main2_lz_nscr, bgl, GF_BGL_FRAME2_M, 0, 32*24*2, 1, HEAPID_TRADELIST);

	// BG3XN[]
	ArcUtil_ScrnSet(   ARC_TRADELIST_GRA, NARC_TradeList_main3_lz_nscr, bgl, GF_BGL_FRAME3_M, 0, 32*24*2, 1, HEAPID_TRADELIST);
	

	// BGL]
	ArcUtil_BgCharSet( ARC_TRADELIST_GRA, NARC_TradeList_chara_lz_ncgr, bgl, GF_BGL_FRAME1_S, 0, 32*8*0x20, 1, HEAPID_TRADELIST);

	// BGXN[]
	ArcUtil_ScrnSet(   ARC_TRADELIST_GRA, NARC_TradeList_sub2_lz_nscr, bgl, GF_BGL_FRAME1_S, 0, 32*24*2, 1, HEAPID_TRADELIST);

	// BGXN[]
	ArcUtil_ScrnSet(   ARC_TRADELIST_GRA, NARC_TradeList_main3_lz_nscr, bgl, GF_BGL_FRAME2_S, 0, 32*24*2, 1, HEAPID_TRADELIST);

	GF_BGL_ScrClear( bgl, GF_BGL_FRAME0_S );

}


//** CharManager PlttManagerp **//
#define TRADELIST_CHAR_CONT_NUM					(20)
#define TRADELIST_CHAR_VRAMTRANS_MAIN_SIZE		(2048)
#define TRADELIST_CHAR_VRAMTRANS_SUB_SIZE		(2048)
#define TRADELIST_PLTT_CONT_NUM					(20)

//-------------------------------------
//
//	LN^}l[W[
//	pbg}l[W[̏
//
//=====================================
static void char_pltt_manager_init(void)
{
	// LN^}l[W[
	{
		CHAR_MANAGER_MAKE cm = {
			TRADELIST_CHAR_CONT_NUM,
			TRADELIST_CHAR_VRAMTRANS_MAIN_SIZE,
			TRADELIST_CHAR_VRAMTRANS_SUB_SIZE,
			HEAPID_TRADELIST
		};
		InitCharManager(&cm);
	}
	// pbg}l[W[
	InitPlttManager(TRADELIST_PLTT_CONT_NUM, HEAPID_TRADELIST);

	// ǂݍ݊Jnʒu
	CharLoadStartAll();
	PlttLoadStartAll();
}


//------------------------------------------------------------------
/**
 * [_[ʗpZAN^[
 *
 * @param   wk		[_[\̂̃|C^
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void InitCellActor(TRADELIST_WORK *wk)
{
	int i;
	
	
	// OAM}l[W[̏
	NNS_G2dInitOamManagerModule();

	// LOAM}l[W쐬
	// _pOAM}l[W쐬
	// ō쐬OAM}l[W݂ȂŋL
	REND_OAMInit( 
			0, 127,		// COAMǗ̈
			0, 32,		// CʃAtBǗ̈
			0, 127,		// TuOAMǗ̈
			0, 32,		// TuʃAtBǗ̈
			HEAPID_TRADELIST);
	
	
	
	// ZAN^[
	wk->clactSet = CLACT_U_SetEasyInit( TRADELIST_CACT_MAX, &wk->renddata, HEAPID_TRADELIST );
	
	//\[X}l[W[
	for(i=0;i<CLACT_RESOURCE_NUM;i++){		//\[X}l[W[쐬
		wk->resMan[i] = CLACT_U_ResManagerInit(2, i, HEAPID_TRADELIST);
	}


	//---------ʗp-------------------
	
	//charaǂݍ
	wk->resObjTbl[MAIN_LCD][CLACT_U_CHAR_RES] = CLACT_U_ResManagerResAddArcChar(wk->resMan[CLACT_U_CHAR_RES], 
							ARC_TRADELIST_GRA, NARC_TradeList_obj_lz_ncgr, 1, 0, NNS_G2D_VRAM_TYPE_2DMAIN, HEAPID_TRADELIST);

	//palǂݍ
	wk->resObjTbl[MAIN_LCD][CLACT_U_PLTT_RES] = CLACT_U_ResManagerResAddArcPltt(wk->resMan[CLACT_U_PLTT_RES],
							ARC_TRADELIST_GRA, NARC_TradeList_DsTradeList_nclr, 0, 0, NNS_G2D_VRAM_TYPE_2DMAIN, 7, HEAPID_TRADELIST);

	//cellǂݍ
	wk->resObjTbl[MAIN_LCD][CLACT_U_CELL_RES] = CLACT_U_ResManagerResAddArcKindCell(wk->resMan[CLACT_U_CELL_RES],
							ARC_TRADELIST_GRA, NARC_TradeList_obj_lz_ncer, 1, 0, CLACT_U_CELL_RES,HEAPID_TRADELIST);

	//֐animǂݍ
	wk->resObjTbl[MAIN_LCD][CLACT_U_CELLANM_RES] = CLACT_U_ResManagerResAddArcKindCell(wk->resMan[CLACT_U_CELLANM_RES],
							ARC_TRADELIST_GRA, NARC_TradeList_obj_lz_nanr, 1, 0, CLACT_U_CELLANM_RES,HEAPID_TRADELIST);


	//---------ʗp-------------------


	//charaǂݍ
	wk->resObjTbl[SUB_LCD][CLACT_U_CHAR_RES] = CLACT_U_ResManagerResAddArcChar(wk->resMan[CLACT_U_CHAR_RES], 
							ARC_TRADELIST_GRA, NARC_TradeList_obj_s_lz_ncgr, 1, 1, NNS_G2D_VRAM_TYPE_2DSUB, HEAPID_TRADELIST);

	//palǂݍ
	wk->resObjTbl[SUB_LCD][CLACT_U_PLTT_RES] = CLACT_U_ResManagerResAddArcPltt(wk->resMan[CLACT_U_PLTT_RES],
							ARC_TRADELIST_GRA, NARC_TradeList_DsTradeList_nclr, 0, 1, NNS_G2D_VRAM_TYPE_2DSUB, 4, HEAPID_TRADELIST);

	//cellǂݍ
	wk->resObjTbl[SUB_LCD][CLACT_U_CELL_RES] = CLACT_U_ResManagerResAddArcKindCell(wk->resMan[CLACT_U_CELL_RES],
							ARC_TRADELIST_GRA, NARC_TradeList_obj_s_lz_ncer, 1, 1, CLACT_U_CELL_RES,HEAPID_TRADELIST);

	//֐animǂݍ
	wk->resObjTbl[SUB_LCD][CLACT_U_CELLANM_RES] = CLACT_U_ResManagerResAddArcKindCell(wk->resMan[CLACT_U_CELLANM_RES],
							ARC_TRADELIST_GRA, NARC_TradeList_obj_s_lz_nanr, 1, 1, CLACT_U_CELLANM_RES,HEAPID_TRADELIST);

	// \[X}l[W[]

	// Chara]
	CLACT_U_CharManagerSet( wk->resObjTbl[MAIN_LCD][CLACT_U_CHAR_RES] );
	CLACT_U_CharManagerSet( wk->resObjTbl[SUB_LCD][CLACT_U_CHAR_RES] );

	// pbg]
	CLACT_U_PlttManagerSet( wk->resObjTbl[MAIN_LCD][CLACT_U_PLTT_RES] );
	CLACT_U_PlttManagerSet( wk->resObjTbl[SUB_LCD][CLACT_U_PLTT_RES] );

	// |PACRppbgCɓǂݍVRAM]
	ArcUtil_PalSet( ARC_POKEICON, PokeIconPalArcIndexGet(), PALTYPE_MAIN_OBJ, POKEICON_PAL_OFFSET*0x20, 0x20*4, HEAPID_TRADELIST );


}

//------------------------------------------------------------------
/**
 * ʂ̃|P摜]
 *
 * @param   side		E(0-1)
 * @param   pokeno		|P̊JNO
 * @param   char_work	|P摜ǂݍޗ̈
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void TransPokeGra_SubLcd(int side, int pokeno, u8 *char_work)
{
	SOFT_SPRITE_ARC ssa;
	
	PokeGraArcDataGet(&ssa,pokeno, PM_MALE , PARA_FRONT, PARA_NORMAL);

	ChangesInto_OAM_from_PokeTex(ssa.arc_no, ssa.index_chr, HEAPID_TRADELIST, 0, 0, 10, 10, char_work);
	DC_FlushRange(char_work,0x20*10*10);

	GXS_LoadOBJ(char_work, POKEGRA_VRAM_OFFSET + side*POKEGRA_VRAM_SIZE, POKEGRA_VRAM_SIZE);
	ArcUtil_PalSet( ssa.arc_no, ssa.index_pal, PALTYPE_SUB_OBJ, 0x20*(2+side), 32, HEAPID_TRADELIST );
	

}

//------------------------------------------------------------------
/**
 * Tuʂɕ`s
 *
 * @param   win		
 * @param   side		
 * @param   party		
 * @param   pos		
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void TransPokeStr_SubLcd(GF_BGL_BMPWIN *win, int side, POKEPARTY *party, int pos, TRADELIST_WORK *wk)
{
	STRBUF *name, *level, *item;
	u16 itemno,levelnum;

	name = STRBUF_Create(20,HEAPID_TRADELIST);
	PokeParaGet(PokeParty_GetMemberPointer(party, pos),ID_PARA_nickname_buf,name);

	// |P
	GF_BGL_BmpWinDataFill( &win[BMP_S_MYPOKENAME_WIN+side], 0 );
	TradeListPrint(&win[BMP_S_MYPOKENAME_WIN+side], name, SUB_POKENAME_W, MSG_ALLPUT, CENTER_PRINT);
	STRBUF_Delete(name);

	// xuLV.@000v
	level = STRBUF_Create(10,HEAPID_TRADELIST);
	GF_BGL_BmpWinDataFill( &win[BMP_S_MYPOKELEVEL_WIN+side], 0 );
	MSGMAN_GetString( wk->MsgManager, mes_dstrade_05_03, level );
	TradeListPrint( &win[BMP_S_MYPOKELEVEL_WIN+side], level, SUB_POKENAME_W, MSG_NO_PUT, LEFT_PRINT);
	
	levelnum = PokeParaGet(PokeParty_GetMemberPointer(party, pos),ID_PARA_level,NULL);
	STRBUF_SetNumber( level, levelnum, 3, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	TradeListPrint( &win[BMP_S_MYPOKELEVEL_WIN+side], name, SUB_POKENAME_W, MSG_ALLPUT, 40);
	STRBUF_Delete(level);
	


	// ACe
	itemno = PokeParaGet(PokeParty_GetMemberPointer(party, pos),ID_PARA_item,NULL);
	GF_BGL_BmpWinDataFill( &win[BMP_S_MYITEM_WIN+side], 0 );

	// uȂvƂ͂܂\łȂiitemname=0́uHHHvj
	item = STRBUF_Create(20,HEAPID_TRADELIST);
	GetItemName( item, itemno, HEAPID_TRADELIST );
	TradeListPrint(&win[BMP_S_MYITEM_WIN+side], item, SUB_POKENAME_W, MSG_ALLPUT, CENTER_PRINT);
	STRBUF_Delete(item);

}


typedef struct{
	CLACT_WORK_PTR parent;
	CLACT_WORK_PTR child;
	int dx;
	int id;
}FUNC_BUTTON_TASK_WORK;


#define TRADELIST_CURSOR_1_X (  0*8 )
#define TRADELIST_CURSOR_2_X (  8*8 )
#define TRADELIST_CURSOR_3_X ( 16*8 )
#define TRADELIST_CURSOR_4_X ( 24*8 )
#define TRADELIST_CURSOR_1_Y (  4*8 )
#define TRADELIST_CURSOR_2_Y (  9*8 )
#define TRADELIST_CURSOR_3_Y ( 14*8 )
#define TRADELIST_CURSOR_END_X	(24*8 )
#define TRADELIST_CURSOR_END_Y	(20*8 )


#define SUB_POKEMON1_POS_X	 (  63 )
#define SUB_POKEMON2_POS_X	 ( 192 )
#define SUB_POKEMON_POS_Y	 (  96 )
#define SUB_ARROW_POS_X		 ( 118 )
#define SUB_ARROW1_POS_Y	 ( 72 )
#define SUB_ARROW2_POS_Y	 ( 108 )

static const main_cursor_pos[][4]={
	{TRADELIST_CURSOR_1_X,TRADELIST_CURSOR_1_Y, },
	{TRADELIST_CURSOR_2_X,TRADELIST_CURSOR_1_Y, },
	{TRADELIST_CURSOR_1_X,TRADELIST_CURSOR_2_Y, },
	{TRADELIST_CURSOR_2_X,TRADELIST_CURSOR_2_Y, },
	{TRADELIST_CURSOR_1_X,TRADELIST_CURSOR_3_Y, },
	{TRADELIST_CURSOR_2_X,TRADELIST_CURSOR_3_Y, },
	{TRADELIST_CURSOR_3_X,TRADELIST_CURSOR_1_Y, },
	{TRADELIST_CURSOR_4_X,TRADELIST_CURSOR_1_Y, },
	{TRADELIST_CURSOR_3_X,TRADELIST_CURSOR_2_Y, },
	{TRADELIST_CURSOR_4_X,TRADELIST_CURSOR_2_Y, },
	{TRADELIST_CURSOR_3_X,TRADELIST_CURSOR_3_Y, },
	{TRADELIST_CURSOR_4_X,TRADELIST_CURSOR_3_Y, },
	{TRADELIST_CURSOR_END_X,TRADELIST_CURSOR_END_Y, },

};

static const sub_icon_pos[][2]={
	{SUB_POKEMON1_POS_X, SUB_POKEMON_POS_Y},
	{SUB_POKEMON2_POS_X, SUB_POKEMON_POS_Y},
	{SUB_ARROW_POS_X, SUB_ARROW1_POS_Y,},
	{SUB_ARROW_POS_X, SUB_ARROW2_POS_Y,},
};

//------------------------------------------------------------------
/**
 * ZAN^[o^
 *
 * @param   wk			NAMEIN_WORK*
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void SetCellActor(TRADELIST_WORK *wk)
{
	// ZAN^[wb_쐬
	CLACT_U_MakeHeader(&wk->clActHeader_m, 0, 0, 0, 0, CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE,
	0, 1,
	wk->resMan[CLACT_U_CHAR_RES],
	wk->resMan[CLACT_U_PLTT_RES],
	wk->resMan[CLACT_U_CELL_RES],
	wk->resMan[CLACT_U_CELLANM_RES],
	NULL,NULL);

	CLACT_U_MakeHeader(&wk->clActHeader_s, 1, 1, 1, 1, CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE,
	0, 0,
	wk->resMan[CLACT_U_CHAR_RES],
	wk->resMan[CLACT_U_PLTT_RES],
	wk->resMan[CLACT_U_CELL_RES],
	wk->resMan[CLACT_U_CELLANM_RES],
	NULL,NULL);

	{
		//o^i[
		CLACT_ADD add;
		int i;

		add.ClActSet	= wk->clactSet;
		add.ClActHeader	= &wk->clActHeader_m;

		add.mat.x		= FX32_CONST(32) ;
		add.mat.y		= FX32_CONST(96) ;		//ʂ͏㉺AĂiMAINASUBj
		add.mat.z		= 0;
		add.sca.x		= FX32_ONE;
		add.sca.y		= FX32_ONE;
		add.sca.z		= FX32_ONE;
		add.rot			= 0;
		add.pri			= 0;
		add.DrawArea	= NNS_G2D_VRAM_TYPE_2DMAIN;
		add.heap		= HEAPID_TRADELIST;

		//ZAN^[\Jn

		// ʗp
		for(i=0;i<2;i++){
			add.mat.x = FX32_ONE*main_cursor_pos[i][0];
			add.mat.y = FX32_ONE*main_cursor_pos[i][1];
			wk->clActWork[i] = CLACT_Add(&add);
			CLACT_SetAnmFlag(wk->clActWork[i],1);
			CursorPosChange(wk->cursor_pos[i],wk->clActWork[i], i);
		}

		// |PACR
		for(i=0;i<12;i++){
			add.mat.x = FX32_ONE*(main_cursor_pos[i][0]+16);
			add.mat.y = FX32_ONE*(main_cursor_pos[i][1]-6);
			wk->PokeIconActWork[i] = CLACT_Add(&add);
			CLACT_SetAnmFlag(wk->PokeIconActWork[i],1);
			CLACT_AnmChg( wk->PokeIconActWork[i], 5+i );
			CLACT_DrawPriorityChg(wk->PokeIconActWork[i], 5);	// ꂼ̃AN^[̃vCIeBݒ
		}

		// |P̃ACe
		for(i=0;i<12;i++){
			add.mat.x = FX32_ONE*(main_cursor_pos[i][0]+16+20);
			add.mat.y = FX32_ONE*(main_cursor_pos[i][1]+16);
			add.pri			= 0;
			wk->PokeItemActWork[i] = CLACT_Add(&add);
			CLACT_DrawPriorityChg(wk->PokeItemActWork[i], 3);	// ꂼ̃AN^[̃vCIeBݒ
		}

		// ʗp(|PQ́EQj
		for(i=0;i<2;i++){
			add.ClActHeader	= &wk->clActHeader_s;
			add.mat.x = FX32_ONE*sub_icon_pos[i][0];
			add.mat.y = FX32_ONE*(sub_icon_pos[i][1]) + SUB_SURFACE_Y;
			add.DrawArea	= NNS_G2D_VRAM_TYPE_2DSUB;
			wk->SubLCDIconActWork[i] = CLACT_Add(&add);
			CLACT_SetAnmFlag(wk->SubLCDIconActWork[i],1);
			CLACT_AnmChg( wk->SubLCDIconActWork[i], i );
		}
		
	}	
	
}







#ifdef PM_DEBUG
//------------------------------------------------------------------
/**
 * fobO\pOBJBG𓮂
 *
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void DebugOBJPOSGet(TRADELIST_WORK *wk)
{
		if( sys.cont & PAD_KEY_UP){
			VecFx32 tmpVex;
			wk->framenum[wk->frame][1]--;
			tmpVex.x = FX32_ONE*wk->framenum[wk->frame][0];
			tmpVex.y = FX32_ONE*wk->framenum[wk->frame][1];
			CLACT_SetMatrix(wk->clActWork[wk->frame], &tmpVex);
			OS_Printf("frame %d x=%d, y=%d\n",wk->frame, wk->framenum[wk->frame][0],wk->framenum[wk->frame][1]);
		}
		if( sys.cont & PAD_KEY_DOWN){
			VecFx32 tmpVex;
			wk->framenum[wk->frame][1]++;
			tmpVex.x = FX32_ONE*wk->framenum[wk->frame][0];
			tmpVex.y = FX32_ONE*wk->framenum[wk->frame][1];
			CLACT_SetMatrix(wk->clActWork[wk->frame], &tmpVex);
			OS_Printf("frame %d x=%d, y=%d\n",wk->frame, wk->framenum[wk->frame][0],wk->framenum[wk->frame][1]);
			
		}
		if( sys.cont & PAD_KEY_LEFT){
			VecFx32 tmpVex;
			wk->framenum[wk->frame][0]--;
			tmpVex.x = FX32_ONE*wk->framenum[wk->frame][0];
			tmpVex.y = FX32_ONE*wk->framenum[wk->frame][1];
			CLACT_SetMatrix(wk->clActWork[wk->frame], &tmpVex);
			OS_Printf("frame %d x=%d, y=%d\n",wk->frame, wk->framenum[wk->frame][0],wk->framenum[wk->frame][1]);
			
		}
		if( sys.cont & PAD_KEY_RIGHT){
			VecFx32 tmpVex;
			wk->framenum[wk->frame][0]++;
			tmpVex.x = FX32_ONE*wk->framenum[wk->frame][0];
			tmpVex.y = FX32_ONE*wk->framenum[wk->frame][1];
			CLACT_SetMatrix(wk->clActWork[wk->frame], &tmpVex);
			OS_Printf("frame %d x=%d, y=%d\n",wk->frame, wk->framenum[wk->frame][0],wk->framenum[wk->frame][1]);
		}

}

#endif

#define MOVE_UP 	1
#define MOVE_DOWN 	2
#define MOVE_LEFT 	3
#define MOVE_RIGHT 	4

static const arrowtbl[][2]={{0,0},{0,-1},{0,1},{-1,0},{1,0}};

static int AroundWork(int w, int min, int max)
{
	if(w>=max){
		w = min;
	}
	if(w<min){
		w = max-1;
	}
	return w;
}


//------------------------------------------------------------------
/**
 * J[\ړ
 *
 * @param   wk		NAMEIN_WORK*
 *
 * @retval  none	
 */
//------------------------------------------------------------------
static void ControlCursor(u32 *CommWork)
{
	int move  = 0;
	int arrow = 0;

	// L[͂ɑ΂ĈړŜ̈
	if( sys.repeat & PAD_KEY_UP){
		arrow = MOVE_UP;
		move++;
	}
	if( sys.repeat & PAD_KEY_DOWN){
		arrow = MOVE_DOWN;
		move++;
	}
	if( sys.repeat & PAD_KEY_LEFT){
		arrow = MOVE_LEFT;
		move++;
	}
	if( sys.repeat & PAD_KEY_RIGHT){
		arrow = MOVE_RIGHT;
		move++;
	}


	// ړύX
	if(move){
		if(sys.cont & PAD_BUTTON_R){
			CommWork[1] = arrow;
		}else{
			*CommWork = arrow;
		}
//		CursorMove(wk,arrow);				// J[\̈ړ肷
//		CursorAppearUpDate(wk,arrow);		// ړ̌ʃJ[\̌`󂪂ǂ̂悤ɕς邩肷
	}

}



// ʗp{^ʒu`
#define SUB_BUTTON1_POSX			( 3*8  )
#define SUB_BUTTON1_POSY			( 7*8  )
#define SUB_BUTTON2_POSX			( 19*8 )
#define SUB_BUTTON2_POSY			( 7*8  )

#define SUB_BUTTON_W			( 8*10 )
#define SUB_BUTTON_H			( 8*10 )

static const RECT_HIT_TBL sub_button_hittbl[]={
	{SUB_BUTTON1_POSY, SUB_BUTTON1_POSY+SUB_BUTTON_H, SUB_BUTTON1_POSX, SUB_BUTTON1_POSX+SUB_BUTTON_W},
//	{SUB_BUTTON2_POSY, SUB_BUTTON2_POSY+SUB_BUTTON_H, SUB_BUTTON2_POSX, SUB_BUTTON2_POSX+SUB_BUTTON_W},
	{RECT_HIT_END,0,0,0},		// If[^
};



//------------------------------------------------------------------
/**
 * ^b`plŉ{^ւ
 *
 * @param   wk		NAMEIN_WORK̃|C^
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void TouchFunc(TRADELIST_WORK *wk)
{
	int button=-1,i;

	// ͏
	button=GF_TP_RectHitTrg( sub_button_hittbl );
	if( button != RECT_HIT_NONE ){
		CLACT_AnmChg( wk->SubLCDIconActWork[button], 4+button );	// ʂ̕BGɍ킹ď㉺ɓ
//		CLACT_AnmChg( wk->clActWork[11], sub_button_info[1][2]+1 );	// ʂ̕BGɍ킹ď㉺ɓ
	}

	// ڂ̏
//	button=GF_TP_RectHitCont( sub_button_hittbl );


}


//------------------------------------------------------------------
/**
 * J[\̃pbgύXi_Łj
 *
 * @param   CursorCol	sinɓnp[^i360܂Łj
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void CursorColTrans(u16 *CursorCol)
{
	fx32  sin;
	GXRgb tmp;
	int   r,g,b;

	*CursorCol+=20;
	if(*CursorCol>360){
		*CursorCol = 0;
	}

	sin = Sin360R(*CursorCol);
	g   = 15 +( sin * 10 ) / FX32_ONE;
	tmp = GX_RGB(29,g,0);


	GX_LoadOBJPltt((u16*)&tmp, (16+13)*2, 2);
}




//--------------------------------------------------------------------------
/**
 * ق̎̈ړ݂͑Ă邩ō6܂ŒT
 *
 * @param   pos		݂̈ʒuԍ
 * @param   arrow	ړ
 *
 * @retval  u8		ړ
 */
//--------------------------------------------------------------------------
static int NextCursorSearch(int pos, int arrow, int *existtbl)
{
	int i,w;
	w = 0;
	for(i=0;i<6;i++){
		if(existtbl[movepostbl[pos][arrow][i]]!=0){
			w = movepostbl[pos][arrow][i];
			break;
		}
	}
	return w;
}


static const CursorAnmTable[][3]={
	{ 0, 1, 2},
	{17,18,19},
};
//--------------------------------------------------------------------------
/**
 * وړ
 *
 * @param   pos		J[\ʒui[Ă郏[Ñ|C^
 * @param   arrow	ړ
 *
 * @retval  none		
 *
 *
 */
//--------------------------------------------------------------------------
static void CursorPosChange(int pos, CLACT_WORK_PTR CursorAct,int side)
{
	VecFx32 tmpVex;
	GF_ASSERT(pos<13);

	tmpVex.x = FX32_ONE*main_cursor_pos[pos][0];
	tmpVex.y = FX32_ONE*main_cursor_pos[pos][1];

	if(pos==12){
		CLACT_SetMatrix(CursorAct, &tmpVex);
		CLACT_AnmChg( CursorAct, CursorAnmTable[side][2] );	// pJ[\ɃAN^[ύX
	}else{
		CLACT_SetMatrix(CursorAct, &tmpVex);
		if(pos<6){
			CLACT_AnmChg( CursorAct, CursorAnmTable[side][0] );	// pɃAN^[ύX
		}else{
			CLACT_AnmChg( CursorAct, CursorAnmTable[side][1] );	// EpɃAN^[ύX
		}
	}

}


//------------------------------------------------------------------
/**
 * J[\ړꍇɍWE`̕ύXs
 *
 * @param   Command		
 * @param   pos		
 * @param   CursorAct		
 * @param   existtbl		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int ViewChange(u32 *Command, int *pos, CLACT_WORK_PTR CursorAct, int *existtbl, int side)
{
	int arrow  = *Command - 1;
	int w      = 0;
	int result = 0;
	
	if(side==0){
		if(*Command){
			w = NextCursorSearch(*pos,arrow,existtbl);
			CursorPosChange(w,CursorAct,side);
			if(*pos!=w){					//ړĂSE炷
				Snd_SePlay(NAMEIN_MOVE_SE);
				*pos = w;					//WXV
				result = 1;
			}
		}
		*Command = 0;	//R}hNA
	}else{
		CursorPosChange(*pos,CursorAct,side);
	}

	return result;
}


//------------------------------------------------------------------
/**
 * Mf[^𑗂iɃJ[\̈ʒu𑗐Mj
 *
 * @param   netID		
 * @param   pos		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
void TradeListCommSend(int netID, int command, int pos)
{
	
	u8 data = pos;

	CommSendData(command,&data,1);
}



//------------------------------------------------------------------
/**
 * 
 *
 * @param   party		
 * @param   no		
 *
 * @retval  void *		
 */
//------------------------------------------------------------------
static void *GetPartyAdrs(POKEPARTY *party, int no)
{
	u32 adrs = (u32)party;
	
	return (void*)(adrs+no*POKEPARTY_SEND_ONCE_SIZE);
}


//==============================================================================
/**
 * |Pf[^𑗐MiʐM̐eqŊ֐ւj
 *
 * @param   netID		
 * @param   party		
 * @param   no		
 *
 * @retval  none		
 */
//==============================================================================
void TradeListCommSendPokeData(int netID, POKEPARTY *party, int no)
{
	if(CommIsConnect(netID)){			// fobOňlp𓮂Ȃ̂ŔÔ
		u8 data = no;
		CommSendHugeData(CT_POKEDATA,GetPartyAdrs(party,no),POKEPARTY_SEND_ONCE_SIZE);
	}
}


//------------------------------------------------------------------
/**
 * $brief   肠O[vf[^̑M
 *
 * @param   mystatus		
 * @param   friendlist		
 * @param   sendbuf		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void CommSendFriendList( MYSTATUS *mystatus, FRIEND_LIST *friendlist, FRIEND_LIST *sendbuf )
{
	int i;

	// Mf[^̍쐬
	PM_strcpy( sendbuf->name, MyStatus_GetMyName( mystatus ));	// O
	sendbuf->id = MyStatus_GetID(mystatus);						// ID
	sendbuf->region   = MyStatus_GetRegionCode(mystatus);		// [W
	sendbuf->rom_code = MyStatus_GetRomCode(mystatus);			// ROM
	
	for(i=0;i<FRIENDLIST_FRIEND_MAX;i++){							// ̒m荇ID
		sendbuf->group_id[i]      = friendlist[i].id;			// m荇̒m荇ƂĂ͓n߂ɐ`
		sendbuf->group_romcode[i] = friendlist[i].rom_code;
		sendbuf->group_region[i]  = friendlist[i].region;
	}


	// M
	CommSendHugeData( CT_FRINEDLIST, sendbuf, sizeof(FRIEND_LIST) );
	
}


//------------------------------------------------------------------
/**
 * ʏړ
 *
 * @param   wk		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int trade_seq_normal(TRADELIST_WORK *wk)
{
	ControlCursor(&wk->CommWork[0]);

	if(sys.trg & PAD_BUTTON_A){
		if(wk->cursor_pos[0]==12){
			wk->func = trade_seq_endyesno;
		}else if(wk->cursor_pos[0]<6){
			wk->func = trade_seq_mypoke;
		}else if(wk->cursor_pos[0]>=6 && wk->cursor_pos[0]<12){
			wk->func = trade_seq_friendpoke;
		}
	}
	return MODE_NORMAL;
}

//------------------------------------------------------------------
/**
 * Ixdrmn
 *
 * @param   wk		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int trade_seq_endyesno(TRADELIST_WORK *wk )
{
	GF_BGL_ScrFill(	wk->bgl, GF_BGL_FRAME0_M, 0, 0, 0, 32, 24,  0);
	TradeListWindowPrint(
		&wk->TradeListWin[BMP_M_MES3_WIN],
		mes_dstrade_04_04,FONT_TALK,
		wk->MsgManager,
		wk->PokeNameWordSet
	);
	wk->func = trade_seq_endyesno_wait;

	return MODE_NORMAL;
	
}

//------------------------------------------------------------------
/**
 * Ixdrmn҂
 *
 * @param   wk		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int trade_seq_endyesno_wait(TRADELIST_WORK *wk)
{
	switch(TradeListYesNoFunc(wk->bgl, &wk->YesNoMenu, &wk->yesnoseq)){
	case 0:
		GF_BGL_ScrFill(	wk->bgl, GF_BGL_FRAME0_M, 0, 0, 0, 32, 24,  0);
		TradeListWindowPrint(
			&wk->TradeListWin[BMP_M_MES3_WIN],
			mes_dstrade_04_07,FONT_TALK,
			wk->MsgManager,
			wk->PokeNameWordSet
		);
		// ߂鎖
		TradeListCommSend(CommGetCurrentID(), CT_TRADE_DECIDE, DECIDE_COMMAND_END);
		wk->func = trade_seq_end;
		break;
	case BMPMENU_CANCEL:
		GF_BGL_ScrFill(	wk->bgl, GF_BGL_FRAME0_M, 0, 0, 0, 32, 24,  0);
		TradeListWindowPrint(
			&wk->TradeListWin[BMP_M_MES1_WIN],
			mes_dstrade_02_01,FONT_TALK,
			wk->MsgManager,
			wk->PokeNameWordSet
		);
		wk->func = trade_seq_normal;
		break;
	default:
		break;
	}

	return MODE_NORMAL;
}

static int trade_seq_return(TRADELIST_WORK *wk)
{
	GF_BGL_ScrFill(	wk->bgl, GF_BGL_FRAME0_M, 0, 0, 0, 32, 24,  0);
	TradeListWindowPrint(
		&wk->TradeListWin[BMP_M_MES3_WIN],
		wk->fail_reason,FONT_TALK,
		wk->MsgManager,
		wk->PokeNameWordSet
	);
	wk->func = trade_seq_return_wait;
	
	return MODE_NORMAL;
}

static int trade_seq_return_wait(TRADELIST_WORK *wk)
{
	if(sys.trg & PAD_BUTTON_A){
		GF_BGL_ScrFill(	wk->bgl, GF_BGL_FRAME0_M, 0, 0, 0, 32, 24,  0);
		TradeListWindowPrint(
			&wk->TradeListWin[BMP_M_MES1_WIN],
			mes_dstrade_02_01,FONT_TALK,
			wk->MsgManager,
			wk->PokeNameWordSet
		);
		wk->func=trade_seq_normal;
	}

	return MODE_NORMAL;
}

//------------------------------------------------------------------
/**
 * I
 *
 * @param   wk		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int trade_seq_end(TRADELIST_WORK *wk)
{
	if(wk->end_flag[0]!=0 && wk->end_flag[1]!=0){
		if(wk->end_flag[0]==1 && wk->end_flag[1]==1){
			return MODE_END_SELECT;
		}else{
			wk->func = trade_seq_return;
		}
		wk->end_flag[0] = 0;
		wk->end_flag[1] = 0;
		wk->fail_reason = mes_dstrade_04_03;	// ̓LZ܂B
	}
	return MODE_NORMAL;
}


//------------------------------------------------------------------
/**
 * ̃|PI
 *
 * @param   wk		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int trade_seq_mypoke(TRADELIST_WORK *wk )
{
	BMPMENU_HEADER temp;

	temp.font  = FONT_SYSTEM;
	temp.x_max = 1;
	temp.y_max = 3;
	temp.line_spc = 0;
	temp.c_disp_f = 0;
	temp.loop_f   = 0;
	
	WORDSET_RegisterPokeNickName(wk->WindowStrWordSet, 0, 
		PPPPointerGet(PokeParty_GetMemberPointer(wk->MyPokeParty, wk->cursor_pos[0])));
	
	GF_BGL_ScrFill(	wk->bgl, GF_BGL_FRAME0_M, 0, 0, 0, 32, 24,  0);
	TradeListWindowPrint(
		&wk->TradeListWin[BMP_M_MES2_WIN],
		mes_dstrade_02_02,FONT_TALK,
		wk->MsgManager,
		wk->WindowStrWordSet
	);
	
	wk->BmpMenuList = BMP_MENULIST_Create( 3, HEAPID_TRADELIST );
	BMP_MENULIST_AddArchiveString( wk->BmpMenuList, wk->MsgManager, mes_dstrade_03_01, 0 );
	BMP_MENULIST_AddArchiveString( wk->BmpMenuList, wk->MsgManager, mes_dstrade_03_02, 1 );
	BMP_MENULIST_AddArchiveString( wk->BmpMenuList, wk->MsgManager, mes_dstrade_03_03, 2 );
	
	temp.menu = wk->BmpMenuList;
	temp.win  = &wk->TradeListWin[BMP_M_SELECT1_WIN];

	TradeListWinWrite( &wk->TradeListWin[BMP_M_SELECT1_WIN] );
	wk->BmpMenuWork = BmpMenuAddEx( &temp, 8, 0, 0, HEAPID_TRADELIST, PAD_BUTTON_B );
	

	wk->func = trade_seq_mypoke_menu;
	
	return MODE_NORMAL;
}

static int trade_seq_mypoke_menu(TRADELIST_WORK *wk )
{
	switch(BmpMenuMain( wk->BmpMenuWork )){
	case 0:		// 悳݂
		GF_BGL_ScrFill(	wk->bgl, GF_BGL_FRAME0_M, 0, 0, 0, 32, 24,  0);
		TradeListWindowPrint(
			&wk->TradeListWin[BMP_M_MES1_WIN],
			mes_dstrade_02_01,FONT_TALK,
			wk->MsgManager,
			wk->PokeNameWordSet
		);
		BmpMenuExit( wk->BmpMenuWork, NULL );
		BMP_MENULIST_Delete( wk->BmpMenuList );
		wk->func = trade_seq_normal;
		break;
	case 1:		// 񂷂
		GF_BGL_ScrFill(	wk->bgl, GF_BGL_FRAME0_M, 0, 0, 0, 32, 24,  0);
		TradeListWindowPrint(
			&wk->TradeListWin[BMP_M_MES3_WIN],
			mes_dstrade_04_01,FONT_TALK,
			wk->MsgManager,
			wk->PokeNameWordSet
		);
		BmpMenuExit( wk->BmpMenuWork, NULL );
		BMP_MENULIST_Delete( wk->BmpMenuList );
		wk->func = trade_seq_decide;
		break;
	case 2:case BMPMENU_CANCEL:	// LZ
		GF_BGL_ScrFill(	wk->bgl, GF_BGL_FRAME0_M, 0, 0, 0, 32, 24,  0);
		TradeListWindowPrint(
			&wk->TradeListWin[BMP_M_MES1_WIN],
			mes_dstrade_02_01,FONT_TALK,
			wk->MsgManager,
			wk->PokeNameWordSet
		);
		BmpMenuExit( wk->BmpMenuWork, NULL );
		BMP_MENULIST_Delete( wk->BmpMenuList );
		wk->func = trade_seq_normal;
		break;
	}
	return MODE_NORMAL;

}



static int trade_seq_decide(TRADELIST_WORK *wk )
{
	GF_BGL_ScrFill(	wk->bgl, GF_BGL_FRAME0_M, 0, 0, 0, 32, 24,  0);
	TradeListWindowPrint(
		&wk->TradeListWin[BMP_M_MES3_WIN],
		mes_dstrade_04_01,FONT_TALK,
		wk->MsgManager,
		wk->PokeNameWordSet
	);

	// 
	TradeListCommSend(CommGetCurrentID(), CT_TRADE_DECIDE, DECIDE_COMMAND_NEXT);
	
	wk->func = trade_seq_decide_wait;
	
	return MODE_NORMAL;
}

static int trade_seq_decide_wait(TRADELIST_WORK *wk )
{
	if(wk->end_flag[0]!=0 && wk->end_flag[1]!=0){
		if(wk->end_flag[0]==DECIDE_COMMAND_NEXT && wk->end_flag[0]==DECIDE_COMMAND_NEXT){
			wk->func = trade_seq_trade_yesno;
		}else{
			wk->func = trade_seq_return;
		}
		wk->fail_reason = mes_dstrade_04_03;	// ̓LZ܂B
		wk->end_flag[0] = 0;
		wk->end_flag[1] = 0;


	}

	return MODE_NORMAL;
}

static int trade_seq_trade_yesno(TRADELIST_WORK *wk )
{
	
	GF_BGL_ScrFill(	wk->bgl, GF_BGL_FRAME0_M, 0, 0, 0, 32, 24,  0);
	WORDSET_RegisterPokeNickName(wk->WindowStrWordSet, 0, 
		PPPPointerGet(PokeParty_GetMemberPointer(wk->MyPokeParty,     wk->cursor_pos[0])));
	WORDSET_RegisterPokeNickName(wk->WindowStrWordSet, 1, 
		PPPPointerGet(PokeParty_GetMemberPointer(wk->FriendPokeParty, wk->cursor_pos[1]-6)));

	TradeListWindowPrint(
		&wk->TradeListWin[BMP_M_MES3_WIN],
		mes_dstrade_04_02,FONT_TALK,
		wk->MsgManager,
		wk->WindowStrWordSet
	);
	
	
	wk->func = trade_seq_trade_yesno_wait;
	return MODE_NORMAL;
}

static int trade_seq_trade_yesno_wait(TRADELIST_WORK *wk)
{
	switch(TradeListYesNoFunc(wk->bgl, &wk->YesNoMenu, &wk->yesnoseq)){
	case 0:
		GF_BGL_ScrFill(	wk->bgl, GF_BGL_FRAME0_M, 0, 0, 0, 32, 24,  0);
		TradeListWindowPrint(
			&wk->TradeListWin[BMP_M_MES3_WIN],
			mes_dstrade_04_01,FONT_TALK,
			wk->MsgManager,
			wk->PokeNameWordSet
		);
		wk->func = trade_seq_trade_yesno_result;
		// 
		TradeListCommSend(CommGetCurrentID(), CT_TRADE_DECIDE, DECIDE_COMMAND_YES);
		break;
	case BMPMENU_CANCEL:
		GF_BGL_ScrFill(	wk->bgl, GF_BGL_FRAME0_M, 0, 0, 0, 32, 24,  0);
		TradeListWindowPrint(
			&wk->TradeListWin[BMP_M_MES3_WIN],
			mes_dstrade_04_01,FONT_TALK,
			wk->MsgManager,
			wk->PokeNameWordSet
		);
		wk->func = trade_seq_trade_yesno_result;
		// ߂鎖
		TradeListCommSend(CommGetCurrentID(), CT_TRADE_DECIDE, DECIDE_COMMAND_NO);
		break;
	default:
		break;
	}

	return MODE_NORMAL;
}


static int trade_seq_trade_yesno_result( TRADELIST_WORK *wk )
{
	if(wk->end_flag[0]!=0 && wk->end_flag[1]!=0){
		if(wk->end_flag[0]==DECIDE_COMMAND_YES && wk->end_flag[0]==DECIDE_COMMAND_YES){
			wk->func = trade_seq_go_next;
		}else{
			wk->func = trade_seq_return;
		}
		wk->end_flag[0] = 0;
		wk->end_flag[1] = 0;
		wk->fail_reason = mes_dstrade_04_08;	// ̓LZ܂B

	}

	return MODE_NORMAL;
	
}

static void PokemonDataExchange(POKEPARTY *my, POKEPARTY *your, int mysel, int yoursel)
{
	POKEMON_PARAM *pp,*pp2;
	
	pp  = PokemonParam_AllocWork(HEAPID_TRADELIST);
	pp2 = PokemonParam_AllocWork(HEAPID_TRADELIST);
	
	//URs[
	memcpy(pp, PokeParty_GetMemberPointer(  my,   mysel),PokemonParam_GetWorkSize());
	memcpy(pp2,PokeParty_GetMemberPointer(your, yoursel),PokemonParam_GetWorkSize());

	PokeParty_Delete(  my, mysel);
	PokeParty_Delete(your, yoursel);

	PokeParty_Add(  my, pp2);
	PokeParty_Add(your, pp);


	sys_FreeMemoryEz(pp);
	sys_FreeMemoryEz(pp2);
}

static  int trade_seq_go_next( TRADELIST_WORK *wk )
{

	// |Pf[^ւ
	PokemonDataExchange(wk->MyPokeParty, wk->FriendPokeParty, wk->cursor_pos[0], wk->cursor_pos[1]-6);

	return MODE_END_SELECT;
}

//------------------------------------------------------------------
/**
 * ̃|PI
 *
 * @param   wk		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int trade_seq_friendpoke(TRADELIST_WORK *wk )
{

	BMPMENU_HEADER temp;

	temp.font  = FONT_SYSTEM;
	temp.x_max = 1;
	temp.y_max = 2;
	temp.line_spc = 0;
	temp.c_disp_f = 0;
	temp.loop_f   = 0;
	
	WORDSET_RegisterPokeNickName(wk->WindowStrWordSet, 0, 
		PPPPointerGet(PokeParty_GetMemberPointer(wk->FriendPokeParty, wk->cursor_pos[0]-6)));
	
	GF_BGL_ScrFill(	wk->bgl, GF_BGL_FRAME0_M, 0, 0, 0, 32, 24,  0);
	TradeListWindowPrint(
		&wk->TradeListWin[BMP_M_MES2_WIN],
		mes_dstrade_02_02,FONT_TALK,
		wk->MsgManager,
		wk->WindowStrWordSet
	);
	
	wk->BmpMenuList = BMP_MENULIST_Create( 2, HEAPID_TRADELIST );
	BMP_MENULIST_AddArchiveString( wk->BmpMenuList, wk->MsgManager, mes_dstrade_03_01, 0 );
	BMP_MENULIST_AddArchiveString( wk->BmpMenuList, wk->MsgManager, mes_dstrade_03_03, 1 );
	
	temp.menu = wk->BmpMenuList;
	temp.win  = &wk->TradeListWin[BMP_M_SELECT2_WIN];

	TradeListWinWrite( &wk->TradeListWin[BMP_M_SELECT2_WIN] );
	wk->BmpMenuWork = BmpMenuAddEx( &temp, 8, 0, 0, HEAPID_TRADELIST, PAD_BUTTON_B );
	

	wk->func = trade_seq_friend_menu;

	return MODE_NORMAL;
	
}

static int trade_seq_friend_menu(TRADELIST_WORK *wk )
{
	switch(BmpMenuMain( wk->BmpMenuWork )){
	case 1:
		GF_BGL_ScrFill(	wk->bgl, GF_BGL_FRAME0_M, 0, 0, 0, 32, 24,  0);
		TradeListWindowPrint(
			&wk->TradeListWin[BMP_M_MES1_WIN],
			mes_dstrade_02_01,FONT_TALK,
			wk->MsgManager,
			wk->PokeNameWordSet
		);
		wk->func = trade_seq_normal;
		BmpMenuExit( wk->BmpMenuWork, NULL );
		BMP_MENULIST_Delete( wk->BmpMenuList );
		break;
	case 2:case BMPMENU_CANCEL:
		GF_BGL_ScrFill(	wk->bgl, GF_BGL_FRAME0_M, 0, 0, 0, 32, 24,  0);
		TradeListWindowPrint(
			&wk->TradeListWin[BMP_M_MES1_WIN],
			mes_dstrade_02_01,FONT_TALK,
			wk->MsgManager,
			wk->PokeNameWordSet
		);
		BmpMenuExit( wk->BmpMenuWork, NULL );
		BMP_MENULIST_Delete( wk->BmpMenuList );
		wk->func = trade_seq_normal;
		break;
	}
	return MODE_NORMAL;

}


