//============================================================================================
/**
 * @file	tradelist.c
 * @bfief	|PXg
 * @author	Akito Mori
 * @date	05.12.08
 */
//============================================================================================

#include "common.h"
#include "system/procsys.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/pm_str.h"
#include "system/clact_tool.h"
#include "system/msgdata_util.h"
#include "system/wordset.h"
#include "msgdata/msg.naix"
#include "system/brightness.h"
#include "system/fontproc.h"
#include "system/lib_pack.h"
#include "system/fontoam.h"
#include "system/window.h"
#include "system/bmp_menu.h"
#include "gflib/msg_print.h"
#include "gflib/touchpanel.h"
#include "poketool/monsno.h"
#include "poketool/pokeicon.h"
#include "application/tradelist.h"
#include "system/bmp_menu.h"
#include "system/bmp_tool.h"
#include "system/snd_tool.h"
#include "gflib/strbuf_family.h"
#include "savedata/friendlist.h"
#include "savedata/friendlist_local.h"


#include "tradelist_def.h"
#include "tradelist_bmp.h"



//------------------------------------------------------------------
// ef[^`
//------------------------------------------------------------------
#define MENUWIN_FRAME_OFFSET	(512 - MENU_WIN_CGX_SIZ)
#define TALKWIN_FRAME_OFFSET	(512 - (MENU_WIN_CGX_SIZ+TALK_WIN_CGX_SIZ) )


// TuBMPWINzu
static const u16 sub_bmp_table[][5]={
	{SUB_MYPOKENAME_X,		SUB_POKENAME_Y,SUB_POKENAME_W,SUB_POKENAME_H,SUB_MYPOKEBMP_OFFSET},
	{SUB_FRIENDPOKENAME_X,	SUB_POKENAME_Y,SUB_POKENAME_W,SUB_POKENAME_H,SUB_FRIENDPOKEBMP_OFFSET},

	{SUB_MYPOKELEVEL_X,		SUB_POKELEVEL_Y,	SUB_POKELEVEL_W, SUB_POKELEVEL_H, SUB_MYPOKELVBMP_OFFSET },
	{SUB_FRIENDPOKELEVEL_X,	SUB_POKELEVEL_Y,	SUB_POKELEVEL_W, SUB_POKELEVEL_H, SUB_FRIENDPOKELVBMP_OFFSET },
	
	{SUB_MOTIMONOSTR_L_X, 	SUB_MOTIMONOSTR_Y,	 SUB_MOTIMONOSTR_W,	 SUB_MOTIMONOSTR_H,	 SUB_MYMOTIMONOSTRBMP_OFFSET },
	{SUB_MOTIMONOSTR_R_X,	SUB_MOTIMONOSTR_Y,	 SUB_MOTIMONOSTR_W,	 SUB_MOTIMONOSTR_H,	  SUB_FRIENDMOTIMONOSTRBMP_OFFSET},

	{SUB_MYITEM_X,			SUB_ITEM_Y,SUB_ITEM_W	,SUB_ITEM_H	,SUB_MYITEMBMP_OFFSET },
	{SUB_FRIENDITEM_X,		SUB_ITEM_Y,SUB_ITEM_W	,SUB_ITEM_H	,SUB_FRIENDITEMBMP_OFFSET },
	
};

static const u16 main_pokename_table[][2]={
	{TRADELIST_POKENAME_X + TRADELIST_POKENAME_OFSX*0, TRADELIST_POKENAME_Y + TRADELIST_POKENAME_OFSY*0,},
	{TRADELIST_POKENAME_X + TRADELIST_POKENAME_OFSX*1, TRADELIST_POKENAME_Y + TRADELIST_POKENAME_OFSY*0,},
	{TRADELIST_POKENAME_X + TRADELIST_POKENAME_OFSX*0, TRADELIST_POKENAME_Y + TRADELIST_POKENAME_OFSY*1,},
	{TRADELIST_POKENAME_X + TRADELIST_POKENAME_OFSX*1, TRADELIST_POKENAME_Y + TRADELIST_POKENAME_OFSY*1,},
	{TRADELIST_POKENAME_X + TRADELIST_POKENAME_OFSX*0, TRADELIST_POKENAME_Y + TRADELIST_POKENAME_OFSY*2,},
	{TRADELIST_POKENAME_X + TRADELIST_POKENAME_OFSX*1, TRADELIST_POKENAME_Y + TRADELIST_POKENAME_OFSY*2,},

	{TRADELIST_POKENAME_X + TRADELIST_POKENAME_OFSX*2, TRADELIST_POKENAME_Y + TRADELIST_POKENAME_OFSY*0,},
	{TRADELIST_POKENAME_X + TRADELIST_POKENAME_OFSX*3, TRADELIST_POKENAME_Y + TRADELIST_POKENAME_OFSY*0,},
	{TRADELIST_POKENAME_X + TRADELIST_POKENAME_OFSX*2, TRADELIST_POKENAME_Y + TRADELIST_POKENAME_OFSY*1,},
	{TRADELIST_POKENAME_X + TRADELIST_POKENAME_OFSX*3, TRADELIST_POKENAME_Y + TRADELIST_POKENAME_OFSY*1,},
	{TRADELIST_POKENAME_X + TRADELIST_POKENAME_OFSX*2, TRADELIST_POKENAME_Y + TRADELIST_POKENAME_OFSY*2,},
	{TRADELIST_POKENAME_X + TRADELIST_POKENAME_OFSX*3, TRADELIST_POKENAME_Y + TRADELIST_POKENAME_OFSY*2,},

};

//------------------------------------------------------------------
/**
 * BMPWINiplɃtHg`j
 *
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
void BmpMessageSet(GF_BGL_INI *bgl, GF_BGL_BMPWIN *TradeListWin)
{
	int i;

	// Cʂ̖̎O
	GF_BGL_BmpWinAdd(bgl, &TradeListWin[BMP_M_MYNAME_WIN], GF_BGL_FRAME1_M,
				TRADELIST_MYNAME_X, TRADELIST_NAME_Y, TRADELIST_NAME_W, TRADELIST_NAME_H, 1,  MAIN_MYNAMEBMP_OFFSET);
	GF_BGL_BmpWinDataFill( &TradeListWin[BMP_M_MYNAME_WIN], 0 );

	GF_BGL_BmpWinAdd(bgl, &TradeListWin[BMP_M_FRIENDNAME_WIN], GF_BGL_FRAME1_M,
				TRADELIST_FRIENDNAME_X, TRADELIST_NAME_Y, TRADELIST_NAME_W, TRADELIST_NAME_H, 1,  MAIN_FRIENDNAMEBMP_OFFSET);
	GF_BGL_BmpWinDataFill( &TradeListWin[BMP_M_FRIENDNAME_WIN], 0 );

	// uv
	GF_BGL_BmpWinAdd(bgl, &TradeListWin[BMP_M_ENDSTR_WIN], GF_BGL_FRAME1_M,
				TRADELIST_ENDSTR_X,	TRADELIST_ENDSTR_Y,TRADELIST_ENDSTR_W,TRADELIST_ENDSTR_H,1,	MAIN_ENDSTRBMP_OFFSET);
	GF_BGL_BmpWinDataFill( &TradeListWin[BMP_M_ENDSTR_WIN], 0 );


	// Cʂ̉bEChE
	TalkWinGraphicSet( bgl, GF_BGL_FRAME0_M, TALKWIN_FRAME_OFFSET, 10, 0, HEAPID_TRADELIST );           
	MenuWinGraphicSet( bgl, GF_BGL_FRAME0_M, MENUWIN_FRAME_OFFSET, 11, /*TalkWinNumGet()*/ 0, HEAPID_TRADELIST );

	GF_BGL_BmpWinAdd(bgl, &TradeListWin[BMP_M_MES1_WIN], GF_BGL_FRAME0_M,
			TRADELIST_TALKWIN1_X, TRADELIST_TALKWIN1_Y, TRADELIST_TALKWIN1_W, TRADELIST_TALKWIN1_H, 1,  MAIN_TALKWIN1_OFFSET);
	GF_BGL_BmpWinDataFill( &TradeListWin[BMP_M_MES1_WIN], 0 );
	GF_BGL_BmpWinAdd(bgl, &TradeListWin[BMP_M_MES2_WIN], GF_BGL_FRAME0_M,
			TRADELIST_TALKWIN2_X, TRADELIST_TALKWIN2_Y, TRADELIST_TALKWIN2_W, TRADELIST_TALKWIN2_H, 1,  MAIN_TALKWIN2_OFFSET);
	GF_BGL_BmpWinDataFill( &TradeListWin[BMP_M_MES2_WIN], 0 );
	GF_BGL_BmpWinAdd(bgl, &TradeListWin[BMP_M_MES3_WIN], GF_BGL_FRAME0_M,
			TRADELIST_TALKWIN3_X, TRADELIST_TALKWIN3_Y, TRADELIST_TALKWIN3_W, TRADELIST_TALKWIN3_H, 1,  MAIN_TALKWIN3_OFFSET);
	GF_BGL_BmpWinDataFill( &TradeListWin[BMP_M_MES3_WIN], 0 );

	GF_BGL_BmpWinAdd(bgl, &TradeListWin[BMP_M_SELECT1_WIN], GF_BGL_FRAME0_M,
			TRADELIST_SELECT1_X, TRADELIST_SELECT1_Y, TRADELIST_SELECT1_W, TRADELIST_SELECT1_H, 1,  MAIN_SELECT1_OFFSET);
	GF_BGL_BmpWinDataFill( &TradeListWin[BMP_M_SELECT1_WIN], 0 );
	GF_BGL_BmpWinAdd(bgl, &TradeListWin[BMP_M_SELECT2_WIN], GF_BGL_FRAME0_M,
			TRADELIST_SELECT2_X, TRADELIST_SELECT2_Y, TRADELIST_SELECT2_W, TRADELIST_SELECT2_H, 1,  MAIN_SELECT2_OFFSET);
	GF_BGL_BmpWinDataFill( &TradeListWin[BMP_M_SELECT2_WIN], 0 );
	

	// |P̖O
	for(i=0;i<12;i++){
		GF_BGL_BmpWinAdd(bgl, &TradeListWin[BMP_M_MYPOKENAME0_WIN+i], GF_BGL_FRAME1_M,
				main_pokename_table[i][0],
				main_pokename_table[i][1],
				TRADELIST_POKENAME_W,
				TRADELIST_POKENAME_H,
				1,  
				MAIN_POKENAME_OFFSET+i*(TRADELIST_POKENAME_W*TRADELIST_POKENAME_H));
		GF_BGL_BmpWinDataFill( &TradeListWin[BMP_M_MYPOKENAME0_WIN+i], 0 );
	}

	// Tuʂ̕
	for(i=0;i<8;i++){
		GF_BGL_BmpWinAdd(bgl, &TradeListWin[BMP_S_MYPOKENAME_WIN+i], GF_BGL_FRAME0_S,
				sub_bmp_table[i][0], sub_bmp_table[i][1],sub_bmp_table[i][2],sub_bmp_table[i][3], 1,  sub_bmp_table[i][4]);
		GF_BGL_BmpWinDataFill( &TradeListWin[BMP_S_MYPOKENAME_WIN+i], 0 );

	}


}	



//==============================================================================
/**
 * BMP
 *
 * @param   TradeListWin		
 *
 * @retval  none		
 */
//==============================================================================
void TradeListBmpExit(GF_BGL_BMPWIN *TradeListWin)
{
	int i;

	// |P̖O
	for(i=0;i<12;i++){
		GF_BGL_BmpWinDel( &TradeListWin[BMP_M_MYPOKENAME0_WIN+i] );
	}


	// Tuʂ̕
	for(i=0;i<8;i++){
		GF_BGL_BmpWinDel( &TradeListWin[BMP_S_MYPOKENAME_WIN+i] );
	}

	GF_BGL_BmpWinDel( &TradeListWin[BMP_M_MYNAME_WIN]		);
	GF_BGL_BmpWinDel( &TradeListWin[BMP_M_FRIENDNAME_WIN]	);
	GF_BGL_BmpWinDel( &TradeListWin[BMP_M_ENDSTR_WIN]		);

	GF_BGL_BmpWinDel(  &TradeListWin[BMP_M_MES1_WIN] );
	GF_BGL_BmpWinDel(  &TradeListWin[BMP_M_MES2_WIN] );
	GF_BGL_BmpWinDel(  &TradeListWin[BMP_M_MES3_WIN] );
	GF_BGL_BmpWinDel(  &TradeListWin[BMP_M_SELECT1_WIN] );
	GF_BGL_BmpWinDel(  &TradeListWin[BMP_M_SELECT2_WIN] );
	


	
}


//------------------------------------------------------------------
/**
 * Xgł̕\
 *
 * @param   win		
 * @param   strbuf		
 * @param   bmp_width	Z^OƂBMPWIN̉iLP)
 * @param   wait		
 * @param   print_sw	LEFT_PRINTōl,CENTER_PRINTŃZ^O
 *
 * @retval  none		
 */
//------------------------------------------------------------------
void TradeListPrint(GF_BGL_BMPWIN *win, STRBUF *strbuf, int bmp_width, u32 wait, int print_sw)
{
	int sx = 0;
	
	// Z^OsH
	if(print_sw==CENTER_PRINT){
		int strlen;

		strlen = FontProc_GetPrintStrWidth( FONT_SYSTEM, strbuf, 0 );
		sx = (bmp_width*8-strlen) / 2;
	}else{
		// LEFT_PRINTȊȌꍇ͉ړItZbgɂȂ
		sx = print_sw;
	}

	GF_STR_PrintColor( win, FONT_SYSTEM, strbuf, sx, 0, wait, GF_PRINTCOLOR_MAKE(1, 12, 0), NULL );
}

//==============================================================================
/**
 * 
 *
 * @param   win		
 * @param   strbuf	
 * @param   msg		
 *
 * @retval  none		
 */
//==============================================================================
void TradeListWindowPrint(GF_BGL_BMPWIN *win, int msg, int font, MSGDATA_MANAGER *Man, WORDSET *WordSet)
{
	STRBUF *temp;
	
	temp = MSGDAT_UTIL_AllocExpandString( WordSet, Man, msg, HEAPID_TRADELIST );

	if(font==FONT_TALK){
		BmpTalkWinWrite( win, WINDOW_TRANS_ON, TALKWIN_FRAME_OFFSET, 10 );
	}else{
		BmpMenuWinWrite( win, WINDOW_TRANS_ON, MENUWIN_FRAME_OFFSET, 11 );
	}

	GF_BGL_BmpWinDataFill( win, 15 );
	GF_STR_PrintColor( win, font, temp, 0, 0, MSG_ALLPUT, GF_PRINTCOLOR_MAKE(1, 12, 15), NULL );
	
	STRBUF_Delete( temp );

}

static const BMPWIN_DAT TradeYesNoBmpDat={
	GF_BGL_FRAME0_M,25,13,6,4,1,MAIN_YESNO_OFFSET,
};

u32 TradeListYesNoFunc(GF_BGL_INI * bgl, BMPMENU_WORK **menu, int *seq)
{
	u32 result=BMPMENU_NULL;
	
	switch(*seq){
	case 0:
		*menu = BmpYesNoSelectInit(	bgl, &TradeYesNoBmpDat, MENUWIN_FRAME_OFFSET, 11, HEAPID_TRADELIST );
		(*seq)++;
		break;
	case 1:
		result=BmpYesNoSelectMain( *menu, HEAPID_TRADELIST);
		if(result!=BMPMENU_NULL){
//			BmpYesNoWinDel( *menu, HEAPID_TRADELIST );
			(*seq)=0;
		}
	}

	return result;
}

void TradeListWinWrite(GF_BGL_BMPWIN *win)
{

	BmpMenuWinWrite( win, WINDOW_TRANS_ON, MENUWIN_FRAME_OFFSET, 11 );
	
}