//============================================================================================
/**
 * @file	tradelist_def.h
 * @bfief	|PXgʗpwb_
 * @author	Akito Mori
 * @date	05.12.08
 */
//============================================================================================

#ifndef __TRADELIST_DEF_H__
#define __TRADELIST_DEF_H__
//---------------------------------------------------------------
//--BMPWINp`-------------------------------------------------
//---------------------------------------------------------------

#define TRADELIST_WIN_OFFSET	( 1 )		// BGVRAM̃X^[g炱܂ł̓EChEgpɋ󂯂Ă

// ̉ʂ̃g[i[
#define TRADELIST_MYNAME_X			(  3    )
#define TRADELIST_FRIENDNAME_X		(  16+3 )
#define TRADELIST_NAME_Y			(  1 )
#define TRADELIST_NAME_W			( 10 )
#define TRADELIST_NAME_H			(  2 )
#define MAIN_MYNAMEBMP_OFFSET   	( TRADELIST_WIN_OFFSET )
#define MAIN_FRIENDNAMEBMP_OFFSET	( MAIN_MYNAMEBMP_OFFSET + ( TRADELIST_NAME_W * TRADELIST_NAME_H))

//̉ʂ́uv
#define TRADELIST_ENDSTR_X		(  26 )
#define TRADELIST_ENDSTR_Y		(  21 )
#define TRADELIST_ENDSTR_W		(   5 )
#define TRADELIST_ENDSTR_H		(   2 )
#define MAIN_ENDSTRBMP_OFFSET   ( MAIN_FRIENDNAMEBMP_OFFSET + ( TRADELIST_NAME_W * TRADELIST_NAME_H))


// |P̖O(12j
#define TRADELIST_POKENAME_X	(  1 )
#define TRADELIST_POKENAME_Y	(  7 )
#define TRADELIST_POKENAME_W	(  7 )
#define TRADELIST_POKENAME_H	(  2 )
#define TRADELIST_POKENAME_OFSX	(  8 )
#define TRADELIST_POKENAME_OFSY	(  5 )
#define MAIN_POKENAME_OFFSET	( MAIN_ENDSTRBMP_OFFSET    + (TRADELIST_ENDSTR_W*TRADELIST_ENDSTR_H))



// ̉ʂ̃bZ[WEChEPiPŁj
#define TRADELIST_TALKWIN1_X	(   2 )
#define TRADELIST_TALKWIN1_Y	(  21 )
#define TRADELIST_TALKWIN1_W	(  20 )
#define TRADELIST_TALKWIN1_H	(   2 )
#define MAIN_TALKWIN1_OFFSET    (   1 )

// ̉ʂ̃bZ[WEChE2i2ŁEZj
#define TRADELIST_TALKWIN2_X	(   2 )
#define TRADELIST_TALKWIN2_Y	(  19 )
#define TRADELIST_TALKWIN2_W	(  14 )
#define TRADELIST_TALKWIN2_H	(   4 )
#define MAIN_TALKWIN2_OFFSET    ( TRADELIST_TALKWIN1_W * TRADELIST_TALKWIN1_H )

// ̉ʂ̃bZ[WEChE3i2ŁEj
#define TRADELIST_TALKWIN3_X	(   2 )
#define TRADELIST_TALKWIN3_Y	(  19 )
#define TRADELIST_TALKWIN3_W	(  27 )
#define TRADELIST_TALKWIN3_H	(   4 )
#define MAIN_TALKWIN3_OFFSET    ( TRADELIST_TALKWIN2_W * TRADELIST_TALKWIN2_H )

// ̉ʂ̑IEChE1( RŁj
#define TRADELIST_SELECT1_X		(  20 )
#define TRADELIST_SELECT1_Y		(  17 )
#define TRADELIST_SELECT1_W		(  11 )
#define TRADELIST_SELECT1_H		(   6 )
#define MAIN_SELECT1_OFFSET     ( MAIN_TALKWIN3_OFFSET + (TRADELIST_TALKWIN3_W*TRADELIST_TALKWIN3_H ))

// ̉ʂ̑IEChE2( 2Łj
#define TRADELIST_SELECT2_X		(  20 )
#define TRADELIST_SELECT2_Y		(  19 )
#define TRADELIST_SELECT2_W		(  11 )
#define TRADELIST_SELECT2_H		(   4 )
#define MAIN_SELECT2_OFFSET   	( MAIN_SELECT1_OFFSET + (TRADELIST_SELECT1_W*TRADELIST_SELECT1_H))


// ̉ʂ̂͂EEChE
#define MAIN_YESNO_OFFSET	  	( MAIN_SELECT2_OFFSET + (TRADELIST_SELECT2_W*TRADELIST_SELECT2_H))


// ̉ʂ̃|P̖O
#define SUB_MYPOKENAME_X		(  4 )
#define SUB_FRIENDPOKENAME_X	(  4+16 )
#define SUB_POKENAME_Y			(  1 )
#define SUB_POKENAME_W			( 10 )
#define SUB_POKENAME_H			(  2 )
#define SUB_MYPOKEBMP_OFFSET 		( 0 )
#define SUB_FRIENDPOKEBMP_OFFSET	( SUB_MYPOKEBMP_OFFSET + ( SUB_POKENAME_W * SUB_POKENAME_H))


// ̉ʂ̃x\
#define SUB_MYPOKELEVEL_X		(  2 )
#define SUB_FRIENDPOKELEVEL_X	(  2+16 )
#define SUB_POKELEVEL_Y			(  3 )
#define SUB_POKELEVEL_W			(  7 )
#define SUB_POKELEVEL_H			(  2 )
#define SUB_MYPOKELVBMP_OFFSET 		( SUB_FRIENDPOKEBMP_OFFSET + ( SUB_POKENAME_W * SUB_POKENAME_H))
#define SUB_FRIENDPOKELVBMP_OFFSET	( SUB_MYPOKELVBMP_OFFSET   + ( SUB_POKELEVEL_W * SUB_POKELEVEL_H))

// ̉ʂ̕úv
#define SUB_MOTIMONOSTR_L_X		(  2 )
#define SUB_MOTIMONOSTR_R_X		(  2+16 )
#define SUB_MOTIMONOSTR_Y		( 19 )
#define SUB_MOTIMONOSTR_W		(  7 )
#define SUB_MOTIMONOSTR_H		(  2 )
#define SUB_MYMOTIMONOSTRBMP_OFFSET 	( SUB_FRIENDPOKELVBMP_OFFSET  + ( SUB_POKELEVEL_W * SUB_POKELEVEL_H))
#define SUB_FRIENDMOTIMONOSTRBMP_OFFSET	( SUB_MYMOTIMONOSTRBMP_OFFSET + ( SUB_MOTIMONOSTR_W * SUB_MOTIMONOSTR_H))

// ̉ʂ̃ACe
#define SUB_MYITEM_X			(  2 )
#define SUB_FRIENDITEM_X		(  2+16 )
#define SUB_ITEM_Y				( 21 )
#define SUB_ITEM_W				( 12 )
#define SUB_ITEM_H				(  2 )
#define SUB_MYITEMBMP_OFFSET 		( SUB_FRIENDMOTIMONOSTRBMP_OFFSET + ( SUB_MOTIMONOSTR_W * SUB_MOTIMONOSTR_H))
#define SUB_FRIENDITEMBMP_OFFSET	( SUB_MYITEMBMP_OFFSET + ( SUB_ITEM_W * SUB_ITEM_H))




//-----------------------------------------
// \p`
//-----------------------------------------
enum{
	LEFT_PRINT   = 0,
	CENTER_PRINT,
};


#define INPUT_SCREEN_MAX	( 5)	
#define INPUT_WORD_W		(17)
#define INPUT_WORD_H		( 5)
#define INPUT_WORD_WH		(INPUT_WORD_W*INPUT_WORD_H)
#define INPUT_WORD_MAX		(32)	//͖

// CellActorɏ郊\[X}l[W̎ނ̐i}`ZE}`ZAj͎gpȂj
#define CLACT_RESOURCE_NUM		(  4 )
#define NAMEIN_OAM_NUM			( 14 )
#define NAMELINE_OAM_NUM		( 10 )

// J[\CLACT_WORKio[
#define CLACT_CURSOR_NUM		(  8 )

// pl̓]
#define WORDPANEL_TRANS_SIZE	( 32*13*2 )

// pl̈ʒu`
#define WORDPANEL_POS_REGX		(  -11 )
#define WORDPANEL_POS_REGY		(  -80 )
#define HIDDENPANEL_POS_REGX	(  234 )
#define DOWNPANEL_POS_REGY		( -196 )

#define WORDPANEL_IN_SPEED		( 24 )
#define WORDPANEL_OUT_SPEED		( 10 )

// ͍ςݕ̉OBJ
#define NAMELINE_POS_X			( 10*8   )
#define NAMELINE_POS_Y			(  6*8+5 )

// p\RE@E|PACROBJʒu
#define NAMEIN_MYICON_X			( 24 )
#define NAMEIN_MYICON_Y			( 16 )

// |P̐ʃACR̈ʒu
#define NAMEIN_SEXICON_Y		( NAMELINE_POS_Y - 12)

// O͏ʒu`iȂ̂Ȃ܂́Hj
#define NAME_INFO_POSX			(  8 )
#define NAME_INFO_POSY			(  2 )
#define NAME_INFO_POSW			( 18 )
#define NAME_INFO_POSH			(  2 )
#define NAMEINFO_WIN_SIZE		( NAME_INFO_POSW*NAME_INFO_POSH )


// O͌ʕ\ʒu`
#define NAME_RESULT_POSX		( 10   )
#define NAME_RESULT_POSY		(  5   )
#define NAME_RESULT_POSW		( 9*2  )
#define NAME_RESULT_POSH		(  2   )



// pl̑Jڗp
enum{
	NAMEIN_MODE_REQ  = 0, 
	NAMEIN_MODE_SET,
	NAMEIN_MODE_ANIM,
	NAMEIN_MODE_ANIM_WAIT,
	NAMEIN_MODE,
};

// @\{^`
enum{
	NAMEIN_MODE_HIRA = 0,
	NAMEIN_MODE_KANA,
	NAMEIN_MODE_ALPHA,
	NAMEIN_MODE_KIGOU,
};

// ㉺ʎw`
#define BOTH_LCD	( 2 )
#define MAIN_LCD	( GF_BGL_MAIN_DISP )	// v͂O
#define SUB_LCD		( GF_BGL_SUB_DISP )		// PȂłB

// BMPWINw
enum{

	// ---C--
	BMP_M_MYNAME_WIN=0,			// ̖O
	BMP_M_FRIENDNAME_WIN,		// ̖O
	BMP_M_TRADEMES_WIN,			// bEChE
	BMP_M_TRADECENTER_WIN1,		// EChE
	BMP_M_SELECT_WIN,			// IEChE
	BMP_M_YESNO_WIN,			// xdrmnEChE
	BMP_M_ENDSTR_WIN,			// uv
	BMP_M_MYPOKENAME0_WIN,		// ̎莝|P̖O
	BMP_M_MYPOKENAME1_WIN,
	BMP_M_MYPOKENAME2_WIN,
	BMP_M_MYPOKENAME3_WIN,
	BMP_M_MYPOKENAME4_WIN,
	BMP_M_MYPOKENAME5_WIN,
	BMP_M_FRIENDPOKENAME0_WIN,	// ̎莝|P̖O
	BMP_M_FRIENDPOKENAME1_WIN,
	BMP_M_FRIENDPOKENAME2_WIN,
	BMP_M_FRIENDPOKENAME3_WIN,
	BMP_M_FRIENDPOKENAME4_WIN,
	BMP_M_FRIENDPOKENAME5_WIN,

	BMP_M_MES1_WIN,
	BMP_M_MES2_WIN,
	BMP_M_MES3_WIN,
	BMP_M_SELECT1_WIN,
	BMP_M_SELECT2_WIN,

	// ---Tu--
	BMP_S_MYPOKENAME_WIN,		// ̃|P̖O+ʃACR
	BMP_S_FRIENDPOKENAME_WIN,
	BMP_S_MYPOKELEVEL_WIN,		// |P̃x
	BMP_S_FRIENDPOKELEVEL_WIN,
	BMP_S_MOTIMONO0_WIN,		// úv
	BMP_S_MOTIMONO1_WIN,
	BMP_S_MYITEM_WIN,			// ACe
	BMP_S_FRIENDITEM_WIN,
	BMP_TRADELIST_MAX,
};

// @\{^p`
#define FUNCBUTTON_NUM	( 7 ) 		// @\{^̐
#define START_WORDPANEL ( 0 )		// ŏ̓̕pl̔ԍiOЂ炪ȁj

// CT_DECIDEpR}h
#define DECIDE_COMMAND_END		1
#define DECIDE_COMMAND_NEXT		2
#define DECIDE_COMMAND_YES		3
#define DECIDE_COMMAND_NO		4

//============================================================================================
//	\̒`
//============================================================================================

typedef struct {
	int x;			// ݈ʒu
	int y;			//
	int oldx;		// 1STEPÖʒu
	int oldy;		//
	int lastxarrow;	// Ō̈ړ

	int on;			// \ONEOFF
}TRADELIST_CURSOR;


struct TRADELIST_WORK{

	FIELDSYS_WORK		*fsys;
	int					tradeseq;
	int					exchangeseq;
	int					exchange_work;
	int					exchange_finish;
	int					exchange_friend_count;

	int					end_flag[2];
	int					fail_reason;
	BOOL				wipe_end;

	TRADELIST_CURSOR 	Cursor;								// J[\@XEYEߋXE\ON
	int				cursor_pos[2];
	u16				CursorPal;
	u16 			wordmap[INPUT_WORD_H][INPUT_WORD_W];	// Ճ}bv
	u16 			nowmap;									// ݂̕}bv
	u16				nowinput;								// ݂̃J[\ʒu
	int				inputmode;
	u16				subtouchword[3];						// R̉{^ɔzuĂ镶R[h
	u16				pokeno[12];								// |P̊JNO
	u32				CommWork[2];
	u32				CommSeq[2][3];

	int				MyPokeNum;								// ̎莝|P̐
	int				FriendPokeNum;							// ̎莝|P̐

	GF_BGL_INI		*bgl;

	WORDSET			*PokeNameWordSet;								// bZ[WWJp[N}l[W[
	WORDSET			*WindowStrWordSet;								// bZ[WWJp[N}l[W[
	WORDSET			*SubLcdWordSet;								// bZ[WWJp[N}l[W[
	MSGDATA_MANAGER *MsgManager;							// bZ[Wf[^}l[W[
//	STRBUF			*TitleStr;								// O̓^Cg
	STRBUF			*WindowPrintStr;						// |Pł
	STRBUF			*MyName;


	CLACT_SET_PTR 			clactSet;								// ZAN^[Zbg
	CLACT_U_EASYRENDER_DATA	renddata;								// ȈՃ_[f[^
	CLACT_U_RES_MANAGER_PTR	resMan[CLACT_RESOURCE_NUM];				// \[X}l[W
	CLACT_U_RES_OBJ_PTR 	resObjTbl[BOTH_LCD][CLACT_RESOURCE_NUM];// \[XIuWFe[u
	CLACT_HEADER			clActHeader_m;							// ZAN^[wb_[
	CLACT_HEADER			clActHeader_s;							// ZAN^[wb_[
	CLACT_WORK_PTR			clActWork[NAMEIN_OAM_NUM];				// ZAN^[[N|C^z
	CLACT_WORK_PTR			PokeIconActWork[12];
	CLACT_WORK_PTR			PokeItemActWork[12];
	CLACT_WORK_PTR			SubLCDIconActWork[4];

	TCB_PTR					FuncButtonTask[FUNCBUTTON_NUM];

	GF_BGL_BMPWIN 			TradeListWin[BMP_TRADELIST_MAX];			// O͗pBMPEChE
	BMPMENU_WORK 			*YesNoMenu;
	BMPMENU_DATA			*BmpMenuList;
	BMPMENU_WORK 			*BmpMenuWork;

	int						yesnoseq;

	int						seq;									// ݂̕͏ԁiOK/AjjȂ
	int						mode;									// ݍőOʂ̕pl

	int						front;									// OɗĂBG
	VecFx32					panelpos[2];							// ړ2BGʗpW[N(Œ菭ł͎gĂȂj

	int						word;									
	int						existtbl[13];							///< ۂ߹݂邩ǂ׸
	int						item[12];								///< ĂACe

	int						old_subbutton;							// Ỏʃ{^
	int						subbutton_mode;
	int						subbutton_work;

	int						funcbutton[FUNCBUTTON_NUM];				// {^ԃtO

	void*					BgCharaBuf;
	NNSG2dCharacterData*	BgCharaDat;

	void*					PokeIconBuf[12];						// |PACRf[^
	NNSG2dCharacterData*	PokeIconCharaDat[12];					

	u8						PokeGra[2][0x20*10*10];					// |POtBbNf[^
	
	u8						ObjTransWork[32*4*2];					//

	int 					(*func)(TRADELIST_WORK *wk);

	POKEPARTY				*MyPokeParty;
	POKEPARTY				*FriendPokeParty;

	FRIEND_LIST				*friendlist;
	FRIEND_LIST				SendList;

#ifdef PM_DEBUG
	int 					frame;									//
	int						framenum[9][2];							//
#endif
};

#endif