//============================================================================================
/**
 * @file	trainer_card.c
 * @bfief	g[i[J[h
 * @author	Nozomu Saito
 * @date	05.11.15
 */
//============================================================================================
#include "trcard_sys.h"
#include "gflib/touchpanel.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/clact_tool.h"
#include "system/brightness.h"
#include "system/fontproc.h"

//#include "system/msgdata.h"
//#include "system/numfont.h"
#include "system/snd_tool.h"
#include "trcard_snd_def.h"
#include "trcard_bmp.h"
#include "trcard_obj.h"
//#include "system/bmp_tool.h"
#include "application/app_tool.h"
#include "trainer_case.naix"

#define MIN_SCRUCH	(3)
#define MAX_SCRUCH	(40)
#define REV_SPEED	(FX32_SHIFT - wk->RevSpeed)
#define TRC_SCREEN_WIDTH	(32)
#define CGX_WIDE		(32)
#define BUTTON_CGX_POS	(4*CGX_WIDE)
#define	MAIN_BUTTON_CGX_SIZE	(4)
#define MAIN_BUTTON_POS_Y	(19)
#define MAIN_BUTTON_POS_X	(14)

#define NOBODY_CGX_POS	(5*CGX_WIDE+26)
#define	GYM_READER_CGX_SIZE	(5)
#define COVER_CGX_WIDTH	(16)

#define BRUSH_UP_VAL	(/*256*/20)
#define BADGE_BAD_PLTT_NO	(12)

#define TRC_BG_TRAINER		(GF_BGL_FRAME3_S)//(GF_BGL_FRAME0_S)
#define TRC_BG_FONT			(GF_BGL_FRAME3_S)
#define TRC_BG_CASE			(GF_BGL_FRAME1_S)
#define TRC_BG_CARD			(GF_BGL_FRAME2_S)
#define TRC_BG_UNDER_CASE	(GF_BGL_FRAME2_M)
#define TRC_BG_COVER		(GF_BGL_FRAME3_M)

#define CARD_SCALE_MIN	(0x24)

enum {
	SEQ_IN,
	SEQ_MAIN,
	SEQ_OUT,
	SEQ_REV,
	SEQ_COVER,
};

typedef enum {
	TRC_KEY_REQ_NONE = 0,
	TRC_KEY_REQ_TP_BEAT,
	TRC_KEY_REQ_TP_BRUSH,
	TRC_KEY_REQ_A_BUTTON,
	TRC_KEY_REQ_B_BUTTON,
}TRC_KEY_REQ;

typedef enum {
	COVER_CLOSE = 0,
	COVER_OPEN = 1,
}COVER_STATE;

enum {
	CASE_BUTTON,
	BADGE0,
	BADGE1,
	BADGE2,
	BADGE3,
	BADGE4,
	BADGE5,
	BADGE6,
	BADGE7,
};

enum {
	ANIME_NOTHING,
	ANIME_BUTTON_PUSH,
	ANIME_BUTTON_PULL
};

typedef struct {
	const RECT_HIT_TBL *const CoverTpRect[2];	//0:Jo[ĂƂ 1:Jo[JĂƂ
}RECT_HIT_TBL_LIST;

// 8obWƃP[X{^̃^b`ple[u
static const RECT_HIT_TBL TpRect1[] =
{
	//					E
	{ 19*8, 23*8-1,	15*8,	19*8-1, },
	{ 5*8,  10*8-1,	3*8,	8*8-1,  },
	{ 5*8,  10*8-1,	10*8,	15*8-1, },
	{ 5*8,  10*8-1,	17*8,	21*8-1, },
	{ 5*8,  10*8-1,	24*8,	29*8-1, },
	{ 12*8, 17*8-1,	3*8,	8*8-1,  },
	{ 12*8, 17*8-1,	10*8,	15*8-1, },
	{ 12*8, 17*8-1,	17*8,	21*8-1, },
	{ 12*8, 17*8-1,	24*8,	29*8-1, },
	{ RECT_HIT_END, 0, 0, 0 }
};

//Jo[ĂƂ̃^b`ple[u({^̂)
static const RECT_HIT_TBL TpRect2[] =
{
	//					E
	{ 19*8, 23*8-1,	15*8,	19*8-1, },
	{ RECT_HIT_END, 0, 0, 0 }
};

static const RECT_HIT_TBL_LIST TpHit[] =	{
	{TpRect2,TpRect2},		// ʐM(TR_CARD_DATA::BrushValid == 0) Jo[JĂAobWłȂ
	{TpRect2,TpRect1},		//ʏ펞(TR_CARD_DATA::BrushValid == 1)	Jo[JobW
};

static const u8 ButtonAnimePush[] = {
	1,1,	//1t[A1Ԗ
	0,2,	//IA2Ԗ
};
static const u8 ButtonAnimePull[] = {
	1,1,	//1t[A1Ԗ
	0,0,	//IA     0Ԗ
};

static const u8 * const ButtonAnime[] = {
	ButtonAnimePush,
	ButtonAnimePull
};


//============================================================================================
//	vg^Cv錾
//============================================================================================

static void SetTrCardVramBank(void);
static void SetTrCardBg( GF_BGL_INI * ini );
static void SetTrCardBgGraphic( TR_CARD_WORK * wk );

static void TrCardBgExit( GF_BGL_INI * ini );

static BOOL CardRev(TR_CARD_WORK * wk );
static BOOL CoverOpenClose(TR_CARD_WORK *wk);
static BOOL PushButton(TR_CARD_WORK *wk, const u8 *inAnime);
static int CheckKey(TR_CARD_WORK *wk);
static void BrushBadge(TR_CARD_WORK *wk);
static void SetCardPalette(const u8 inCardRank);
static void SetCasePalette(const u8 inVersion);
static void ChangeBgButton(TR_CARD_WORK *wk, const u8 inAnmNum);
static void ChangeBgGymReader(TR_CARD_WORK *wk, const u8 inNo);
static void VBlankFunc( void * work );
static void DispTrainer(TR_CARD_WORK *wk);
static void ClearTrainer(TR_CARD_WORK *wk);
/**
static void MakeTrainerInfo(const u8 inBadgeBrushFlg,
							const u8 inVersion,
							const u8 inCardRank,
							const MYSTATUS *inMyStatus,
							const int inMoney,
							const int inBook,
							const int inScore,
							const int inStartTime,
							const int inClearTime,
							const int inCommNum,
							const int inBtlWin,
							const int inBtlLose,
							const int inTrade,
							TR_CARD_DATA *outTrCardData);
static void MakeBadgeInfo(TR_BADGE_DATA *outTrBadgeData);
*/
static void BadgeLvUp(TR_CARD_WORK *wk, const u8 inBadgeNo);
static void ResetAffinePlane(void);
static void ButtonAnimeControl(TR_CARD_WORK *wk);
//============================================================================================
//	O[oϐ
//============================================================================================

#if 0
//--------------------------------------------------------------------------------------------
/**
 * f[^쐬
 *
 * @param	
 * @param	
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
TR_CARD_DATA *MakeTrainerCardData(	const u8 inBadgeBrushFlg,
									const u8 inVersion,
									const u8 inCardRank,
									const MYSTATUS *inMyStatus,
									const int inMoney,
									const int inBook,
									const int inScore,
									const int inStartTime,
									const int inClearTime,
									const int inCommNum,
									const int inBtlWin,
									const int inBtlLose,
									const int inTrade,
									const u16 inHeapID)
{
	TR_CARD_DATA * tcd = sys_AllocMemory( inHeapID, sizeof(TR_CARD_DATA) );
	memset( tcd, 0, sizeof(TR_CARD_DATA) );
	MakeTrainerInfo(inBadgeBrushFlg, inVersion, inCardRank,
					inMyStatus, inMoney, inBook,
					inScore, inStartTime, inClearTime,
					inCommNum, inBtlWin, inBtlLose, inTrade,
					tcd);
	MakeBadgeInfo(tcd->BadgeData);
	return tcd; 
}
#endif
//--------------------------------------------------------------------------------------------
/**
 * vZX֐F
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
PROC_RESULT TrCardProc_Init( PROC * proc, int * seq )
{
	TR_CARD_WORK * wk;

	sys_VBlankFuncChange( NULL, NULL );	// VBlankZbg
	sys_HBlankIntrSet( NULL,NULL );		// HBlankZbg

	GF_Disp_GX_VisibleControlInit();
	GF_Disp_GXS_VisibleControlInit();
	GX_SetVisiblePlane( 0 );
	GXS_SetVisiblePlane( 0 );

	APP_BrightnessReq( APP_BRIGHT_IN );	// PxύXZbg
	
	sys_KeyRepeatSpeedSet( 4, 8 );
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_TR_CARD, 0x20000 );

	wk = PROC_AllocWork( proc, sizeof(TR_CARD_WORK), HEAPID_TR_CARD );
	memset( wk, 0, sizeof(TR_CARD_WORK) );
	wk->TrCardData = PROC_GetParentWork( proc );
	wk->bgl = GF_BGL_BglIniAlloc( HEAPID_TR_CARD );

/**
	// bZ[W}l[W쐬
	wk->msg_man = MSGMAN_Create(
					MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_pokelist_dat, HEAPID_POKELIST );
	// 8x8tHg쐬
	wk->num_font = NUMFONT_Create(
					FBMP_COL_WHITE, FBMP_COL_WHT_SDW, FBMP_COL_NULL, HEAPID_POKELIST );
*/
	SetTrCardVramBank();
	SetTrCardBg( wk->bgl );
	SetTrCardBgGraphic( wk );

	InitTPSystem();						// ^b`plVXe
	InitTPNoBuff(4);

	//֘A
	Snd_BadgeWorkInit( &wk->SndBadgeWork );
	Snd_SePlay( SND_TRCARD_CALL );		//Ăяo
	
	InitTRCardCellActor( &wk->ObjWork );
	SetTrCardActor( &wk->ObjWork );

	AddTrCardBmp( wk->bgl, wk->win );
/**
	PokeListBmpAdd( wk );

	PokeListCellActorInit( wk );
	PokeListCellActSet( wk );

	ListModeSet( wk );

	PokePanelMake( wk );

	PanelSelectChg( wk, wk->pos, 1 );

	PokeListSmallMsgPut( wk, mes_pokelist_02_01, 1 );

	PokeListMenuStrMake( wk );
	InitCursorPosSet( wk );

	wk->vtask = VWaitTCB_Add( PokeListVBlank, wk, 0 );
*/
	//Ƃ肠ASneiɂ
	{
		u8 no;
		for(no=0;no<8;no++){
			ChangeBgGymReader(wk,no);
		}
		GF_BGL_LoadScreenReq( wk->bgl, TRC_BG_COVER );
	}
	
	WriteTrWinInfo( wk->win, wk->TrCardData );
	wk->is_back = FALSE;		//\ʂX^[g
	wk->IsOpen = COVER_CLOSE;			//P[X͕ԂX^[g

	wk->touch = RECT_HIT_NONE;			//^b`pl͉ĂȂ

	wk->ButtonPushFlg = FALSE;			//{^ĂȂ
	wk->AnimeType = ANIME_NOTHING;		//{^Aj
	//obWxɍ킹ăpbgZbg
	{
		u8 i;
		for(i=0;i<8;i++){
			SetBadgePalette(&wk->ObjWork, i, BADGE_BAD_PLTT_NO-wk->TrCardData->BadgeData[i].BadgeLevel);
			if (wk->TrCardData->BadgeData[i].BadgeLevel == 3){
				CLACT_SetDrawFlag(wk->ObjWork.ClActWork[TR_CARD_STAR_ACT_START+i], 1);	//\
			}
			else if (wk->TrCardData->BadgeData[i].BadgeLevel == 4){
				CLACT_SetDrawFlag(wk->ObjWork.ClActWork[TR_CARD_GRATE_STAR_ACT_START+i], 1);	//\
			}
		}
	}

	//gkʂZbg
	ResetAffinePlane();
	

	sys_VBlankFuncChange(VBlankFunc, NULL );	// VBlankZbg

	//BGMڂ
	Snd_BgmFadeIn( BGM_VOL_TR_CASE, BGM_FADE_TR_CASE_TIME, BGM_FADEIN_START_VOL_NOW );

	return PROC_RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * vZX֐FC
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
PROC_RESULT TrCardProc_Main( PROC * proc, int * seq )
{
	TR_CARD_WORK * wk  = PROC_GetWork( proc );

	switch( *seq ){
	case SEQ_IN:
		if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == TRUE ){
			*seq = SEQ_MAIN;
		}
		break;

	case SEQ_MAIN:
		{
			int req;
			req = CheckKey(wk);

			if (req == TRC_KEY_REQ_TP_BEAT){
///				wk->BeforeTouch = wk->touch;	//^b`Ώۂ̕ۑ
				//^b`plev[gƃ^b`Wr
				if (wk->touch == CASE_BUTTON){
					wk->ButtonPushFlg = TRUE;		//{^
					wk->AnimeType = ANIME_BUTTON_PUSH;	//{^Aj
					//{^GtFNgAN^[\
					CLACT_SetDrawFlag(wk->ObjWork.ClActWork[TR_CARD_BTNEFF_ACT_START], 1);	//\
					CLACT_SetAnmFlag(wk->ObjWork.ClActWork[TR_CARD_BTNEFF_ACT_START],1);
					CLACT_AnmChg( wk->ObjWork.ClActWork[TR_CARD_BTNEFF_ACT_START], 10 );
					
					OS_Printf("Jo[̊J\n");
					wk->sub_seq = 0;	//TuV[PX
					//{^Aj
					wk->AnmNum = 0;
					wk->ButtonAnmCount = 0;
					//V[PX҂tO
					wk->rc_cover = FALSE;
					*seq = SEQ_COVER;	//Jo[̊J
				}else{
					u8 no = wk->touch-1;
					//obWL
					if (wk->TrCardData->BadgeData[no].BadgeHold){
						//obW
						OS_Printf("o܂\n");
						Snd_BadgeWorkPlay( &wk->SndBadgeWork, no, wk->TrCardData->BadgeData[no].BadgeLevel );
					}
				}
			}else if (req == TRC_KEY_REQ_TP_BRUSH){
				if ( (wk->ButtonPushFlg)&&(wk->touch != CASE_BUTTON) ){
					wk->ButtonPushFlg = FALSE;
					wk->AnimeType = ANIME_BUTTON_PULL;	//{^߂Aj
				}
				//Jo[󂢂Ă΁Aob`
				BrushBadge(wk);//ob`
			}else{
				if ( wk->ButtonPushFlg ){
					wk->ButtonPushFlg = FALSE;
					wk->AnimeType = ANIME_BUTTON_PULL;	//{^߂Aj
				}

				if (req == TRC_KEY_REQ_A_BUTTON){
					if (wk->is_back == FALSE){//Ԃ
						wk->is_back = TRUE;
						//\ʂ
///						NonDispWinInfo(wk->win, TRC_BMPWIN_TR_ID, TRC_BMPWIN_START_TIME);
						wk->sub_seq = 0;	//TuV[PX
						*seq = SEQ_REV;	//J[h]
					}else{
						ChangeBrightnessRequest( 8, -16, 0, PLANEMASK_ALL, MASK_DOUBLE_DISPLAY );
						*seq = SEQ_OUT;
					}
				}else if (req == TRC_KEY_REQ_B_BUTTON){
					if (wk->is_back == TRUE){	//\ɂ
						wk->is_back = FALSE;
						//ʂ
///						NonDispWinInfo(wk->win, TRC_BMPWIN_CLEAR_TIME, TRC_BMPWIN_TRADE_INFO);
						wk->sub_seq = 0;	//TuV[PX
						*seq = SEQ_REV;	//J[h]
					}else{
						ChangeBrightnessRequest( 8, -16, 0, PLANEMASK_ALL, MASK_DOUBLE_DISPLAY );
						*seq = SEQ_OUT;
					}
				}
			}
		}
		break;

	case SEQ_OUT:
		if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == TRUE ){
			return PROC_RES_FINISH;
		}
		break;
	
	case SEQ_REV:	//o[X
		if ( CardRev(wk) ){
			//\
			if (wk->is_back){	//ʕ\
///				WriteTrWinInfoRev( wk->win );
			}else{				//\ʕ\
				//g[i[BGʂ\
				///GF_BGL_VisibleSet(TRC_BG_TRAINER, VISIBLE_ON);
///				WriteTrWinInfo( wk->win, wk->TrCardData );
			}
			*seq = SEQ_MAIN;
		}
		break;
	case SEQ_COVER:
		if (wk->AnimeType == ANIME_NOTHING){
			int req;
			req = CheckKey(wk);

			if (req == TRC_KEY_REQ_TP_BEAT){
				if (wk->touch == CASE_BUTTON){
					wk->ButtonPushFlg = TRUE;		//{^
					wk->AnimeType = ANIME_BUTTON_PUSH;	//{^Aj
					//{^Aj
					wk->AnmNum = 0;
					wk->ButtonAnmCount = 0;
				}
			}else if (req == TRC_KEY_REQ_TP_BRUSH){
				if ( (wk->ButtonPushFlg)&&(wk->touch != CASE_BUTTON) ){
					wk->ButtonPushFlg = FALSE;
					wk->AnimeType = ANIME_BUTTON_PULL;	//{^߂Aj
				}
			}else{
				if ( wk->ButtonPushFlg ){
					wk->ButtonPushFlg = FALSE;
					wk->AnimeType = ANIME_BUTTON_PULL;	//{^߂Aj
				}
			}
		}
		//J
		if (wk->rc_cover == FALSE){
			wk->rc_cover = CoverOpenClose(wk);
		}

		if (wk->rc_cover){
			wk->rc_cover = FALSE;
			*seq = SEQ_MAIN;
		}
		break;
	}

	//{^Aj
	ButtonAnimeControl(wk);
	

	CLACT_Draw( wk->ObjWork.ClactSet );									// ZAN^[풓֐

	return PROC_RES_CONTINUE;
}

//--------------------------------------------------------------------------------------------
/**
 * vZX֐FI
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
PROC_RESULT TrCardProc_End( PROC * proc, int * seq )
{
	TR_CARD_WORK * wk  = PROC_GetWork( proc );

	//gpgkʂɖ߂
	ResetAffinePlane();
	
///	TCB_Delete( wk->vtask );
	RereaseCellObject(&wk->ObjWork);		//2DIuWFNg֘Ä

	sys_FreeMemoryEz( wk->TrScrnArcData );//g[i[XN[

	ExitTrCardBmpWin( wk->win );			// BMPEBhEJ
	TrCardBgExit( wk->bgl );			// BGL폜
	StopTP();							// ^b`plI

///	DellVramTransferManager();

	PROC_FreeWork( proc );				// [NJ

///	MSGMAN_Delete( wk->msg_man );
///	NUMFONT_Delete( wk->num_font );

	sys_VBlankFuncChange( NULL, NULL );		// VBlankZbg
	sys_DeleteHeap( HEAPID_TR_CARD );

	//BGM̉ʂɖ߂
	Snd_BgmFadeIn( BGM_VOL_MAX, BGM_FADE_TR_CASE_TIME, BGM_FADEIN_START_VOL_NOW );
	
	return PROC_RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * VRAMݒ
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void SetTrCardVramBank(void)
{
	GF_BGL_DISPVRAM tbl = {
		GX_VRAM_BG_64_E,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg

		GX_VRAM_SUB_BG_128_C,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg

		GX_VRAM_OBJ_128_B,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg

		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg

		GX_VRAM_TEX_NONE,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_NONE			// eNX`pbgXbg
	};
	GF_Disp_SetBank( &tbl );
}

//--------------------------------------------------------------------------------------------
/**
 * J[hpbgݒ(ݒ肷ƁAP[X̓_Co[WɂȂ)
 *
 * @param	inCardRank		J[hN
 *
 * @return	Ȃ
 */
//--------------------------------------------------------------------------------------------
static void SetCardPalette(const u8 inCardRank)
{
	{
		void *buf;
		NNSG2dPaletteData *dat;
		switch(inCardRank){
		case 0:
			buf = ArcUtil_PalDataGet(
				ARC_TR_CASE_GRA, NARC_trainer_case_card_0_NCLR, &dat, HEAPID_TR_CARD );
			break;
		case 1:
			buf = ArcUtil_PalDataGet(
				ARC_TR_CASE_GRA, NARC_trainer_case_card_1_NCLR, &dat, HEAPID_TR_CARD );
			break;
		case 2:
			buf = ArcUtil_PalDataGet(
				ARC_TR_CASE_GRA, NARC_trainer_case_card_2_NCLR, &dat, HEAPID_TR_CARD );
			break;
		case 3:
			buf = ArcUtil_PalDataGet(
				ARC_TR_CASE_GRA, NARC_trainer_case_card_3_NCLR, &dat, HEAPID_TR_CARD );
			break;
		case 4:
			buf = ArcUtil_PalDataGet(
				ARC_TR_CASE_GRA, NARC_trainer_case_card_4_NCLR, &dat, HEAPID_TR_CARD );
			break;
		case 5:
			buf = ArcUtil_PalDataGet(
				ARC_TR_CASE_GRA, NARC_trainer_case_card_5_NCLR, &dat, HEAPID_TR_CARD );
			break;
		}

		{
			u16 * adr;
			adr = dat->pRawData;
			DC_FlushRange( dat->pRawData, 2*16*2 );
			GXS_LoadBGPltt( &adr[16], 2*16, 2*16*2 );
			sys_FreeMemoryEz(buf);
		}
	}
}

//--------------------------------------------------------------------------------------------
/**
 * P[XpbgZbg
 *
 * @param	inVersion	o[W
 *
 * @return	Ȃ
 */
//--------------------------------------------------------------------------------------------
static void SetCasePalette(const u8 inVersion)
{
	void *buf;
	NNSG2dPaletteData *dat;
	switch(inVersion){
	case VERSION_DIAMOND:		//_C
		buf = ArcUtil_PalDataGet(
				ARC_TR_CASE_GRA, NARC_trainer_case_card_case_d_NCLR, &dat, HEAPID_TR_CARD );
		break;
	case VERSION_PEARL:		//p[
		buf = ArcUtil_PalDataGet(
				ARC_TR_CASE_GRA, NARC_trainer_case_card_case_p_NCLR, &dat, HEAPID_TR_CARD );
		break;
	default:	//ʃo[W
		buf = ArcUtil_PalDataGet(
				ARC_TR_CASE_GRA, NARC_trainer_case_card_case_d_NCLR, &dat, HEAPID_TR_CARD );
		break;
	}
		
	DC_FlushRange( dat->pRawData, 2*16 );
	GX_LoadBGPltt( dat->pRawData, 0, 2*16 );
	GXS_LoadBGPltt( dat->pRawData, 0, 2*16 );
	sys_FreeMemoryEz(buf);
;
}

//--------------------------------------------------------------------------------------------
/**
 * BGݒ
 *
 * @param	ini		BGLf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void SetTrCardBg( GF_BGL_INI * ini )
{

	GX_SetDispSelect(GX_DISP_SELECT_SUB_MAIN);
	
	{	// BG SYSTEM
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS, GX_BGMODE_1, GX_BGMODE_4, GX_BG0_AS_2D,
		};
		GF_BGL_InitBG( &BGsys_data );
	}
/**
	{	// BG (TRAINER CHAR)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
			1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, TRC_BG_TRAINER, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, TRC_BG_TRAINER );
	}
*/
	{	// FONT (BMP)
		GF_BGL_BGCNT_HEADER ExAffineBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_256,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x04000, GX_BG_EXTPLTT_01,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, TRC_BG_FONT, &ExAffineBgCntDat, GF_BGL_MODE_256X16 );
		GF_BGL_ScrClear( ini, TRC_BG_FONT );
	}

	{	// BG (CASE CHAR)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe000, GX_BG_CHARBASE_0x0c000, GX_BG_EXTPLTT_01,
			3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, TRC_BG_CASE, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, TRC_BG_CASE );
	}

	{	// BG (CARD CHAR)
		GF_BGL_BGCNT_HEADER AffineBgCntDat = {
			0, 0, 0x400, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_256,
			GX_BG_SCRBASE_0xe800, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			2, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, TRC_BG_CARD, &AffineBgCntDat, GF_BGL_MODE_AFFINE );
		GF_BGL_ScrClear( ini, TRC_BG_CARD );
	}

	{	// BG (UNDER_CASE CHAR)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, TRC_BG_UNDER_CASE, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, TRC_BG_UNDER_CASE );
	}

	{	// BG (UNDER_CASE_COVER CHAR)
		GF_BGL_BGCNT_HEADER AffineBgCntDat = {
			0, 0, 0x400, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_256,
			GX_BG_SCRBASE_0xe800, GX_BG_CHARBASE_0x04000, GX_BG_EXTPLTT_01,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, TRC_BG_COVER, &AffineBgCntDat, GF_BGL_MODE_AFFINE );
		GF_BGL_ScrClear( ini, TRC_BG_COVER );
	}

	
/*
	{	// BUTTON (CHAR)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME0_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME0_S );
	}

	{	// BG (CHAR)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME1_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
	}

	GF_BGL_ClearCharSet( GF_BGL_FRAME0_M, 32, 0, HEAPID_POKELIST );
	GF_BGL_ClearCharSet( GF_BGL_FRAME0_S, 32, 0, HEAPID_POKELIST );
*/	
}

//--------------------------------------------------------------------------------------------
/**
 * OtBbNf[^Zbg
 *
 * @param	wk		ʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void SetTrCardBgGraphic( TR_CARD_WORK * wk )
{
	// TRAINER_PALETTE(UP_DISPLAY)
	{
		void *buf;
		NNSG2dPaletteData *dat;
		buf = ArcUtil_PalDataGet(
				ARC_TR_CASE_GRA, NARC_trainer_case_card_0_NCLR, &dat, HEAPID_TR_CARD );
		DC_FlushRange( dat->pRawData, 2*16*16 );
		GXS_LoadBGPltt( dat->pRawData, 0, 2*16*16 );
		sys_FreeMemoryEz(buf);
	}
	// CASE PALETTE
	SetCasePalette(wk->TrCardData->Version);
	// CARD PALETTE
	SetCardPalette(wk->TrCardData->CardRank);
	
	// UNSER_CASE_COVER PALETTE(UNDER_DISPLAY)
	{
		void *buf;
		NNSG2dPaletteData *dat;
		buf = ArcUtil_PalDataGet(
				ARC_TR_CASE_GRA, NARC_trainer_case_card_futa_NCLR, &dat, HEAPID_TR_CARD );
		DC_FlushRange( dat->pRawData, 16*2*16 );
		GX_LoadBGPltt( dat->pRawData, 0, 16*2*16 );
		sys_FreeMemoryEz(buf);
	}

	//TRAINER
	ArcUtil_BgCharSet(
			ARC_TR_CASE_GRA, NARC_trainer_case_card_trainer_NCGR, wk->bgl, TRC_BG_TRAINER, 0, 0, 0, HEAPID_TR_CARD );
	if (wk->TrCardData->TrSex == PM_MALE){
		//j
/**
		ArcUtil_ScrnSet(
				ARC_TR_CASE_GRA, NARC_trainer_case_card_trainer01_NSCR, wk->bgl, TRC_BG_TRAINER, 0, 0, 0, HEAPID_TR_CARD );
*/		
		wk->TrScrnArcData = ArcUtil_ScrnDataGet(ARC_TR_CASE_GRA, NARC_trainer_case_card_trainer01_NSCR,
												0, &wk->ScrnData, HEAPID_TR_CARD);
	}else{
		//
/**
		ArcUtil_ScrnSet(
				ARC_TR_CASE_GRA, NARC_trainer_case_card_trainer02_NSCR, wk->bgl, TRC_BG_TRAINER, 0, 0, 0, HEAPID_TR_CARD );
*/
		wk->TrScrnArcData = ArcUtil_ScrnDataGet(ARC_TR_CASE_GRA, NARC_trainer_case_card_trainer02_NSCR,
												0, &wk->ScrnData, HEAPID_TR_CARD);
	}
	DispTrainer(wk);

	//CARD
	ArcUtil_BgCharSet(
			ARC_TR_CASE_GRA, NARC_trainer_case_card_NCGR, wk->bgl, TRC_BG_CARD, 0, 0, 0, HEAPID_TR_CARD );
	ArcUtil_ScrnSet(
			ARC_TR_CASE_GRA, NARC_trainer_case_card_faca_NSCR, wk->bgl, TRC_BG_CARD, 0, 0, 0, HEAPID_TR_CARD );
	//CASE
	ArcUtil_BgCharSet(
			ARC_TR_CASE_GRA, NARC_trainer_case_card_case_NCGR, wk->bgl, TRC_BG_CASE, 0, 0, 0, HEAPID_TR_CARD );
	ArcUtil_ScrnSet(
			ARC_TR_CASE_GRA, NARC_trainer_case_card_case_NSCR, wk->bgl, TRC_BG_CASE, 0, 0, 0, HEAPID_TR_CARD );

	//UNDER_CASE
	ArcUtil_BgCharSet(
			ARC_TR_CASE_GRA, NARC_trainer_case_card_case2_NCGR, wk->bgl, TRC_BG_UNDER_CASE, 0, 0, 0, HEAPID_TR_CARD );
	ArcUtil_ScrnSet(
			ARC_TR_CASE_GRA, NARC_trainer_case_card_case2_NSCR, wk->bgl, TRC_BG_UNDER_CASE, 0, 0, 0, HEAPID_TR_CARD );
	//UNDER_CASE_COVER
	ArcUtil_BgCharSet(
			ARC_TR_CASE_GRA, NARC_trainer_case_card_futa_NCGR, wk->bgl, TRC_BG_COVER, 0, 0, 0, HEAPID_TR_CARD );
	ArcUtil_ScrnSet(
			ARC_TR_CASE_GRA, NARC_trainer_case_card_futa_NSCR, wk->bgl, TRC_BG_COVER, 0, 0, 0, HEAPID_TR_CARD );

}

//--------------------------------------------------------------------------------------------
/**
 * BG
 *
 * @param	ini		BGLf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void TrCardBgExit( GF_BGL_INI * ini )
{
	GF_Disp_GX_VisibleControl(
		GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 | GX_PLANEMASK_BG2 |
		GX_PLANEMASK_BG3 | GX_PLANEMASK_OBJ, VISIBLE_OFF );
	GF_Disp_GXS_VisibleControl(
		GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 | GX_PLANEMASK_OBJ, VISIBLE_OFF );

///	GF_BGL_BGControlExit( ini, GF_BGL_FRAME1_S );
////	GF_BGL_BGControlExit( ini, TRC_BG_TRAINER );
	GF_BGL_BGControlExit( ini, TRC_BG_FONT );
	GF_BGL_BGControlExit( ini, TRC_BG_CARD );
	GF_BGL_BGControlExit( ini, TRC_BG_CASE );
	GF_BGL_BGControlExit( ini, TRC_BG_UNDER_CASE );
	GF_BGL_BGControlExit( ini, TRC_BG_COVER );
///	GF_BGL_BGControlExit( ini, GF_BGL_FRAME0_M );

	sys_FreeMemoryEz( ini );
}

#define FIRST_SPEED	(8)

//--------------------------------------------------------------------------------------------
/**
 * J[hЂԂ
 *
 * @param	wk		ʂ̃[N
 *
 * @return	BOOL	TRUE:I	FALSEF
 */
//--------------------------------------------------------------------------------------------
static BOOL CardRev( TR_CARD_WORK *wk )
{
	BOOL rc;
	MtxFx22 mtx;
    fx32 rScale_x,rScale_y;
	rc = FALSE;
	switch(wk->sub_seq){
	case 0:
/**
		if (wk->is_back == TRUE){
			//g[i[BGʂojbV
			GF_BGL_VisibleSet(TRC_BG_TRAINER, VISIBLE_OFF);	
		}
*/		
		wk->RevSpeed = FIRST_SPEED;	
		//
		//Ɗg債
		wk->CardScaleX = 1 << FX32_SHIFT;
		wk->CardScaleY = 1 << FX32_SHIFT;
		wk->CardScaleX += 2 << (FX32_SHIFT - 6);
		wk->CardScaleY += 2 << (FX32_SHIFT - 6);

		Snd_SePlay( SND_TRCARD_REV );		//ЂԂ

		wk->sub_seq++;
		break;
	case 1:
		//k߂
		wk->CardScaleX -= 2 << (REV_SPEED);
		if (wk->CardScaleX <= 0){//J[hXN[ύX
			wk->CardScaleX = CARD_SCALE_MIN;	//oO\h~(l̓J[ȟ݂ێłʂ̖ڕ)
#if 0			
			if (wk->is_back == TRUE){
///				GF_BGL_NTRCHR_ScrnLoad( wk->bgl, TRC_BG_CARD, "../../data/card_back.NSCR", 0 );
				ArcUtil_ScrnSet(
						ARC_TR_CASE_GRA, NARC_trainer_case_card_back_NSCR, wk->bgl, TRC_BG_CARD, 0, 0, 0, HEAPID_TR_CARD );
				//\ʂ
				NonDispWinInfo(wk->win, TRC_BMPWIN_TR_ID, TRC_BMPWIN_START_TIME);
				//g[i[
				ClearTrainer(wk);
				//ʕ\
				WriteTrWinInfoRev( wk->win );
			}else{
///				GF_BGL_NTRCHR_ScrnLoad( wk->bgl, TRC_BG_CARD, "../../data/card_faca.NSCR", 0 );
				ArcUtil_ScrnSet(
						ARC_TR_CASE_GRA, NARC_trainer_case_card_faca_NSCR, wk->bgl, TRC_BG_CARD, 0, 0, 0, HEAPID_TR_CARD );
				//ʂ
				NonDispWinInfo(wk->win, TRC_BMPWIN_CLEAR_TIME, TRC_BMPWIN_TRADE_INFO);
				//g[i[\
				DispTrainer(wk);
				//\ʕ\
				WriteTrWinInfo( wk->win, wk->TrCardData );
				
			}
#endif			
			wk->sub_seq++;
		}

		wk->RevSpeed--;
		if (wk->RevSpeed <=1 ){
			wk->RevSpeed = 1;
		}
		break;
	case 2:
		if (wk->is_back == TRUE){
///			GF_BGL_NTRCHR_ScrnLoad( wk->bgl, TRC_BG_CARD, "../../data/card_back.NSCR", 0 );
			ArcUtil_ScrnSet(
					ARC_TR_CASE_GRA, NARC_trainer_case_card_back_NSCR, wk->bgl, TRC_BG_CARD, 0, 0, 0, HEAPID_TR_CARD );
			//\ʂ
			NonDispWinInfo(wk->win, TRC_BMPWIN_TR_ID, TRC_BMPWIN_START_TIME);
			//g[i[
			ClearTrainer(wk);
			//ʕ\
			WriteTrWinInfoRev( wk->win );
		}else{
///			GF_BGL_NTRCHR_ScrnLoad( wk->bgl, TRC_BG_CARD, "../../data/card_faca.NSCR", 0 );
			ArcUtil_ScrnSet(
					ARC_TR_CASE_GRA, NARC_trainer_case_card_faca_NSCR, wk->bgl, TRC_BG_CARD, 0, 0, 0, HEAPID_TR_CARD );
			//ʂ
			NonDispWinInfo(wk->win, TRC_BMPWIN_CLEAR_TIME, TRC_BMPWIN_TRADE_INFO);
			//g[i[\
			DispTrainer(wk);
			//\ʕ\
			WriteTrWinInfo( wk->win, wk->TrCardData );
		}
		wk->sub_seq++;
		break;
	case 3:
		//L
		wk->RevSpeed++;
		if(wk->RevSpeed > FIRST_SPEED){
			wk->RevSpeed = FIRST_SPEED;
		}

		wk->CardScaleX += 2 << (REV_SPEED);
		if (wk->CardScaleX >= (1 << FX32_SHIFT)){
			wk->CardScaleX = 1 << FX32_SHIFT;
			//̃TCY
			wk->CardScaleX = 1 << FX32_SHIFT;
			wk->CardScaleY = 1 << FX32_SHIFT;

			Snd_SePlay( SND_TRCARD_REV_AFTER );		//ЂԂ\
			rc = TRUE;
		}
		break;
	}

	rScale_x = FX_Inv(wk->CardScaleX);
	rScale_y = FX_Inv(wk->CardScaleY);
    mtx._00 = rScale_x;
    mtx._01 = 0;
    mtx._10 = 0;
    mtx._11 = rScale_y;
    SVC_WaitVBlankIntr();          // Waiting the end of VBlank interrup
	G2S_SetBG2Affine(&mtx,          // a matrix for rotation and scaling
                        128, 96,      // the center of rotation
                        0, 0           // the reference point before rotation and scaling applied
            );
	G2S_SetBG3Affine(&mtx,          // a matrix for rotation and scaling
                        128, 96,      // the center of rotation
                        0, 0           // the reference point before rotation and scaling applied
            );

	return rc;
}

/**
static const fx32 CoverSpeed[] =
{
	2 << (FX32_SHIFT - 11),
	2 << (FX32_SHIFT - 11),
	2 << (FX32_SHIFT - 7),
	2 << (FX32_SHIFT - 7),
	2 << (FX32_SHIFT - 6),
	2 << (FX32_SHIFT - 6),
	2 << (FX32_SHIFT - 5),
	2 << (FX32_SHIFT - 5),
	2 << (FX32_SHIFT - 4),
	2 << (FX32_SHIFT - 4),
	2 << (FX32_SHIFT - 4),
	2 << (FX32_SHIFT - 4),
	2 << (FX32_SHIFT - 4),
	1 << (FX32_SHIFT - 4),
	1 << (FX32_SHIFT - 4),
	1 << (FX32_SHIFT - 4),
};

#define COVER_MOVE	(16)
*/

static const fx32 CoverSpeed[] =
{
	2 << (FX32_SHIFT - 6),
	2 << (FX32_SHIFT - 6),
	2 << (FX32_SHIFT - 6),
	2 << (FX32_SHIFT - 6),
	2 << (FX32_SHIFT - 6),
	2 << (FX32_SHIFT - 5),
	2 << (FX32_SHIFT - 5),
	2 << (FX32_SHIFT - 5),
	2 << (FX32_SHIFT - 5),
	2 << (FX32_SHIFT - 5),
	2 << (FX32_SHIFT - 4),
	2 << (FX32_SHIFT - 4),
	2 << (FX32_SHIFT - 4),
	2 << (FX32_SHIFT - 4),
};

#define COVER_MOVE	(14)



//--------------------------------------------------------------------------------------------
/**
 * P[XJo[̊J
 *
 * @param	wk		ʂ̃[N
 *
 * @return	BOOL	TRUE:I	FALSEF
 */
//--------------------------------------------------------------------------------------------

static BOOL CoverOpenClose(TR_CARD_WORK *wk)
{
	MtxFx22 mtx;
    fx32 rScale_x,rScale_y;

	switch(wk->sub_seq){
	case 0:
		wk->Counter = 0;		
		if (wk->IsOpen == COVER_CLOSE){
			wk->CoverScaleY = 1 << FX32_SHIFT;
			wk->sub_seq = 1;
		}else{
			wk->sub_seq = 2;
		}
		break;
	case 1:		
		//J
		wk->CoverScaleY -= CoverSpeed[wk->Counter++];///2 << (FX32_SHIFT - 4);
		if (wk->Counter==COVER_MOVE){//J[hXN[ύX
			wk->IsOpen = COVER_OPEN;		//J
			wk->sub_seq = 3;
		}
		break;
	case 2:
		//߂
		wk->CoverScaleY += CoverSpeed[(COVER_MOVE-1)-(wk->Counter++)];///2 << (FX32_SHIFT - 4);
		
		if (wk->Counter == COVER_MOVE){//J[hXN[ύX
			wk->IsOpen = COVER_CLOSE;		//
			wk->CoverScaleY = (1 << FX32_SHIFT);
			wk->sub_seq = 3;
		}
		break;
	case 3:	
		return TRUE;
	}

	rScale_x = FX_Inv(1 << FX32_SHIFT);
	rScale_y = FX_Inv(wk->CoverScaleY);
    mtx._00 = rScale_x;
    mtx._01 = 0;
    mtx._10 = 0;
    mtx._11 = rScale_y;
    SVC_WaitVBlankIntr();          // Waiting the end of VBlank interrup
	G2_SetBG3Affine(&mtx,          // a matrix for rotation and scaling
                        128, 0,      // the center of rotation
                        0, 0           // the reference point before rotation and scaling applied
            );

	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * L[
 *
 * @param	wk		ʂ̃[N
 *
 * @return	int		NGXg
 */
//--------------------------------------------------------------------------------------------
static int CheckKey(TR_CARD_WORK *wk)
{
	int key_req;
	BOOL tp_key_flg;
	tp_key_flg = FALSE;
	key_req = TRC_KEY_REQ_NONE;

	wk->touch = RECT_HIT_NONE;

#ifdef PM_DEBUG
	if (sys.trg & PAD_BUTTON_R){
		wk->TrCardData->CardRank = (wk->TrCardData->CardRank+1)%6;
		SetCardPalette(wk->TrCardData->CardRank);
		return key_req;
	}
	if (sys.trg & PAD_BUTTON_L){
		if (wk->TrCardData->Version == VERSION_DIAMOND){
			wk->TrCardData->Version = VERSION_PEARL;
		}else{
			wk->TrCardData->Version = VERSION_DIAMOND;
		}
		SetCasePalette(wk->TrCardData->Version);
		return key_req;
	}
#endif
	if (sys.tp_trg){
		OS_Printf("xy=%d,%d\n",sys.tp_x,sys.tp_y);
		wk->brushOK = TRUE;	//obW\
	}
	
	wk->touch = GF_TP_RectHitTrg( TpHit[wk->TrCardData->BrushValid].CoverTpRect[wk->IsOpen] );
	//qbg
	if (wk->touch != RECT_HIT_NONE){	//^b`plgK[
		//obWL
		if (/*wk->TrCardData->BadgeData[wk->touch-1].BadgeHold*/1){
			OS_Printf("hit=%d\n",wk->touch);
			tp_key_flg = TRUE;	//^b`plNGXg
			key_req = TRC_KEY_REQ_TP_BEAT;
		}
	}else if (sys.tp_cont){	//^b`plx^
		wk->touch = GF_TP_RectHitCont( TpHit[wk->TrCardData->BrushValid].CoverTpRect[wk->IsOpen] );
		if (wk->brushOK){
			//obWL
			if (wk->TrCardData->BadgeData[wk->touch-1].BadgeHold){
				tp_key_flg = TRUE;	//^b`plNGXg
				key_req = TRC_KEY_REQ_TP_BRUSH;
			}
		}
	}else{	//^b`plGĂȂ
		wk->brushOK = FALSE;	//obWs\
	}

	//^b`plL[NĂȂ΃{^
	if (tp_key_flg == FALSE){
		if ( (sys.trg & PAD_BUTTON_A)||(sys.trg & PAD_BUTTON_X) ){
			key_req = TRC_KEY_REQ_A_BUTTON;
		}else if ( (sys.trg & PAD_BUTTON_B)||(sys.trg & PAD_BUTTON_Y) ){
			key_req = TRC_KEY_REQ_B_BUTTON;
		}
	}

	return key_req;
}

static void BrushBadge(TR_CARD_WORK *wk)
{
	BOOL scruch;
	int sub;
	scruch = FALSE;
	//ێWƃ^b`W̍
	if( (sys.tp_x!=0xffff)&&(sys.tp_y!=0xffff)&&
			(wk->BeforeX!=0xffff)&&(wk->BeforeY!=0xffff) ){	//lLH
		//ێWƃ^b`WobWɂ邩𒲂ׂ
		if ( (wk->touch!=RECT_HIT_NONE)&&(wk->touch!=CASE_BUTTON) ){
			//obWL
			if (wk->TrCardData->BadgeData[wk->touch-1].BadgeHold){
				//Klȏ̏ꍇ͖Ƃɂ
				if ( wk->BeforeX > sys.tp_x ){
					sub = wk->BeforeX - sys.tp_x;
				}else{
					sub = sys.tp_x - wk->BeforeX;
				}
				if ( (sub>=MIN_SCRUCH)&&(sub<=MAX_SCRUCH) ){
					if ( wk->BeforeY > sys.tp_y ){
						sub = wk->BeforeY - sys.tp_y;
					}else{
						sub = sys.tp_y - wk->BeforeY;
					}
					if (sub<=MAX_SCRUCH){
						scruch = TRUE;			//
					}
				}else if (sub<=MAX_SCRUCH){
					if ( wk->BeforeY > sys.tp_y ){
						sub = wk->BeforeY - sys.tp_y;
					}else{
						sub = sys.tp_y - wk->BeforeY;
					}
					if ((sub>=MIN_SCRUCH)&&(sub<=MAX_SCRUCH)){
						scruch = TRUE;		//
					}
				}

				if (scruch){
					OS_Printf("scruch_%d\n",wk->touch);
					OS_Printf("sc=%d,%d-%d,%d\n",wk->BeforeX,wk->BeforeY,sys.tp_x,sys.tp_y);
					//ԍXV
					//xXV
					BadgeLvUp(wk, wk->touch-1);	
					OS_Printf("brush=%d,%d\n",wk->touch,wk->TrCardData->BadgeData[wk->touch-1].BadgeScruchCount);
				}
			}
		}
///		wk->BeforeTouch = wk->touch;
	}
		//ێWXV
	wk->BeforeX = sys.tp_x;
	wk->BeforeY = sys.tp_y;
}


static void ChangeBgButton(TR_CARD_WORK *wk, const u8 inAnmNum)
{
    u16 * buf;
    u16 start;
    u8  x, y;
    
    buf   = (u16 *)GF_BGL_ScreenAdrsGet( wk->bgl, TRC_BG_UNDER_CASE );
	start = BUTTON_CGX_POS+(MAIN_BUTTON_CGX_SIZE*inAnmNum);

    for( y=0; y<MAIN_BUTTON_CGX_SIZE; y++ ){
        for( x=0; x<MAIN_BUTTON_CGX_SIZE; x++ ){
            buf[ (y+MAIN_BUTTON_POS_Y)*TRC_SCREEN_WIDTH + x+MAIN_BUTTON_POS_X ] = start+y*CGX_WIDE+x + (0<<12);
        }
    }
	GF_BGL_LoadScreenReq( wk->bgl, TRC_BG_UNDER_CASE );
}

#define GYM_READER_ST_SCR_POS_X	(3)		//XN[JnWX(LP)
#define GYM_READER_ST_SCR_POS_Y	(4)		//XN[JnWY(LP)
#define GYM_READER_SCR_OFFSET	(7)		//W[_[\Ԋu(LP)
#define GYM_READER_SIDE_NUM		(4)		//W[_[\l

static void ChangeBgGymReader(TR_CARD_WORK *wk, const u8 inNo)
{
    u8 * buf;
    u16 start;
    u8  x, y;
    
	u8 dst_start_x,pos_x;
	u8 dst_start_y,pos_y;

	dst_start_x = GYM_READER_ST_SCR_POS_X;
	dst_start_y = GYM_READER_ST_SCR_POS_Y;

	pos_x = inNo%GYM_READER_SIDE_NUM;
	pos_y = inNo/GYM_READER_SIDE_NUM;

	dst_start_x += (pos_x*GYM_READER_SCR_OFFSET);
	dst_start_y += (pos_y*GYM_READER_SCR_OFFSET);

    buf   = (u8 *)GF_BGL_ScreenAdrsGet( wk->bgl, TRC_BG_COVER );
	start = NOBODY_CGX_POS;

    for( y=0; y<GYM_READER_CGX_SIZE; y++ ){
        for( x=0; x<GYM_READER_CGX_SIZE	; x++ ){
            buf[ (y+dst_start_y)*TRC_SCREEN_WIDTH + x+dst_start_x ] = start+y*COVER_CGX_WIDTH+x;
        }
    }
}


//--------------------------------------------------------------------------------------------
/**
 * VBlank֐
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void VBlankFunc( void * work )
{
	// ZAN^[
	// Vram]}l[W[s
	DoVramTransferManager();

	// _LOAM}l[WVram]
	REND_OAMTrans();	
	
	OS_SetIrqCheckFlag( OS_IE_V_BLANK );
}
#if 0
//--------------------------------------------------------------------------------------------
/**
 * g[i[J[hWāAf[^쐬
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void MakeTrainerInfo(const u8 inBadgeBrushFlg,
							const u8 inVersion,
							const u8 inCardRank,
							const MYSTATUS *inMyStatus,
							const int inMoney,
							const int inBook,
							const int inScore,
							const int inStartTime,
							const int inClearTime,
							const int inCommNum,
							const int inBtlWin,
							const int inBtlLose,
							const int inTrade,
							TR_CARD_DATA *outTrCardData)
{
	//\tgo[W
	outTrCardData->Version = PM_VERSION;
	//J[hN;
	outTrCardData->CardRank = TR_CARD_RANK_NORMAL;
	//obWAvLtO
	outTrCardData->BrushValid = inBadgeBrushFlg;
	//g[i[ID
	outTrCardData->TrainerID = 999999;
	//O
	//outTrCardData->TrainerName;
	//Â
	outTrCardData->Money = MyStatus_GetGold(inMyStatus);
	//
	outTrCardData->PokeBook = ZukanWork_GetPokeGetCount(SaveData_GetZukanWork(fsys->savedata));
	//XRA
	outTrCardData->Score = 999999;
	//vC
	//Jn
	//NA
	//ʐM
	outTrCardData->CommNum = 999999;
	//ʐM퓬
	outTrCardData->CommBattleWin = 9999;
	outTrCardData->CommBattleLose = 9999;
	//ʐM
	outTrCardData->CommTrade = 999999;
}

//--------------------------------------------------------------------------------------------
/**
 * obWf[^쐬
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void MakeBadgeInfo(TR_BADGE_DATA *outTrBadgeData)
{
	u8 i;
#ifdef PM_DEBUG	
	for(i=0;i<8;i++){
		outTrBadgeData[i].GymReaderNo = i;			//W[_[ʃio[
		outTrBadgeData[i].BadgeType = i;			//obWʃio[
		outTrBadgeData[i].BadgeLevel = 0;			//obWx
		outTrBadgeData[i].BadgeHold = 1;			//obWtO
		outTrBadgeData[i].BadgeScruchCount = 0;		//
	}
#endif	
}
#endif
//--------------------------------------------------------------------------------------------
/**
 * obWxAbv
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------

static void BadgeLvUp(TR_CARD_WORK *wk, const u8 inBadgeNo)
{
	int count;
	count = ++(wk->TrCardData->BadgeData[inBadgeNo].BadgeScruchCount);
	if (count >= BRUSH_UP_VAL){
		int lv = ++(wk->TrCardData->BadgeData[inBadgeNo].BadgeLevel);
		if (lv > TR_CARD_BADGE_LV_MAX){
			wk->TrCardData->BadgeData[inBadgeNo].BadgeLevel = TR_CARD_BADGE_LV_MAX;
			wk->TrCardData->BadgeData[inBadgeNo].BadgeScruchCount = BRUSH_UP_VAL;
		}else{
			wk->TrCardData->BadgeData[inBadgeNo].BadgeScruchCount = 0;
			if (lv <= TR_CARD_BADGE_LV_MAX-1){
				SetBadgePalette(&wk->ObjWork, inBadgeNo, BADGE_BAD_PLTT_NO-lv);
			}
			//AN^[\
			if (lv == TR_CARD_BADGE_LV_MAX-1){
				CLACT_SetDrawFlag(wk->ObjWork.ClActWork[TR_CARD_STAR_ACT_START+inBadgeNo], 1);	//\
			}else if(lv == TR_CARD_BADGE_LV_MAX){
				CLACT_SetDrawFlag(wk->ObjWork.ClActWork[TR_CARD_STAR_ACT_START+inBadgeNo], 0);	//\
				CLACT_SetDrawFlag(wk->ObjWork.ClActWork[TR_CARD_GRATE_STAR_ACT_START+inBadgeNo], 1);	//\
			}
		}
	}
}

//--------------------------------------------------------------------------------------------
/**
 * gkʃZbg
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void ResetAffinePlane(void)
{
	MtxFx22 mtx;
    fx32 rScale_x,rScale_y;
	
	rScale_x = FX_Inv((1 << FX32_SHIFT));
	rScale_y = FX_Inv((1 << FX32_SHIFT));
    mtx._00 = rScale_x;
    mtx._01 = 0;
    mtx._10 = 0;
    mtx._11 = rScale_y;
    SVC_WaitVBlankIntr();          // Waiting the end of VBlank interrup
	G2S_SetBG2Affine(&mtx,          // a matrix for rotation and scaling
                        128, 96,      // the center of rotation
                        0, 0           // the reference point before rotation and scaling applied
            );
	G2S_SetBG3Affine(&mtx,          // a matrix for rotation and scaling
                        128, 96,      // the center of rotation
                        0, 0           // the reference point before rotation and scaling applied
            );
	SVC_WaitVBlankIntr();          // Waiting the end of VBlank interrup
	G2_SetBG3Affine(&mtx,          // a matrix for rotation and scaling
                        128, 0,      // the center of rotation
                        0, 0           // the reference point before rotation and scaling applied
            );
}


//--------------------------------------------------------------------------------------------
/**
 * {^AjRg[
 *
 * @param	wk			ʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void ButtonAnimeControl(TR_CARD_WORK *wk)
{
	if (wk->AnimeType == ANIME_BUTTON_PUSH){
		//{^
		if( PushButton(wk, ButtonAnime[0]) ){
			wk->AnimeType = ANIME_NOTHING;
		}
	}else if (wk->AnimeType == ANIME_BUTTON_PULL){
		//{^߂
		if( PushButton(wk, ButtonAnime[1]) ){
			wk->AnimeType = ANIME_NOTHING;
		}
	}
}

//--------------------------------------------------------------------------------------------
/**
 * {^Aj
 *
 * @param	wk			ʂ̃[N
 * @param	inAnime		Aje[u
 *
 * @return	BOOL	TRUE:I	FALSEF
 */
//--------------------------------------------------------------------------------------------
static BOOL PushButton(TR_CARD_WORK *wk, const u8 *inAnime)
{
	u8 frame,num;
	frame = inAnime[wk->AnmNum*2];
	if (frame == 0){
		//I
		wk->ButtonAnmCount = 0;
		wk->AnmNum = 0;
		return TRUE;
	}else if (wk->ButtonAnmCount>=frame){
		wk->ButtonAnmCount = 0;
		wk->AnmNum++;
	}
	
	num = inAnime[wk->AnmNum*2+1];
	if (wk->ButtonAnmCount == 0){
		ChangeBgButton(wk, num);
	}
	wk->ButtonAnmCount++;

	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * g[i[XN[]
 *
 * @param	wk			ʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void DispTrainer(TR_CARD_WORK *wk)
{
	u32 transSize;
	
	transSize = wk->ScrnData->szByte;
	
	if( GF_BGL_ScreenAdrsGet( wk->bgl, TRC_BG_TRAINER ) != NULL ){
		GF_BGL_ScreenBufSet( wk->bgl, TRC_BG_TRAINER, wk->ScrnData->rawData, transSize );
	}
	
	GF_BGL_LoadScreen( wk->bgl, TRC_BG_TRAINER, wk->ScrnData->rawData, transSize, 0 );
}

//--------------------------------------------------------------------------------------------
/**
 * g[i[XN[NA
 *
 * @param	wk			ʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void ClearTrainer(TR_CARD_WORK *wk)
{
	GF_BGL_ScrFill(wk->bgl, TRC_BG_TRAINER, 0, 20, 6, 6, 9, GF_BGL_SCRWRT_PALNL);
}

