//============================================================================================
/**
 * @file	trcard_bmp.c
 * @bfief	g[i[J[hBMP֘A
 * @author	Nozomu Saito
 * @date	05.11.15
 */
//============================================================================================
#include "common.h"
//#include "system/procsys.h"
#include "system/fontproc.h"
#include "system/pm_str.h"
#include "system/bmp_tool.h"
#include "system/buflen.h"
//#include "system/bmp_menu.h"
//#include "system/window.h"
//#include "system/msgdata.h"
//#include "system/wordset.h"
//#include "system/numfont.h"
//#include "system/clact_tool.h"
//#include "msgdata/msg_pokelist.h"
//#include "poketool/poke_tool.h"
//#include "poketool/pokeparty.h"
//#include "application/app_tool.h"

#include "trcard_bmp.h"

#define FONT_BG	(GF_BGL_FRAME3_S)
//CGX
#define TR_BG_BASE	(1)
#define TR_BG_SIZE	(32*3)
////////////////////////////////////////////////////////////////
//\
////////////////////////////////////////////////////////////////
//g[i[NO					:30
#define WIN_TR_NO_PX	(2)
#define WIN_TR_NO_PY	(4)
#define WIN_TR_NO_SX	(15)
#define WIN_TR_NO_SY	(2)
//#define WIN_TR_NO_PAL	(TR_FONT_PAL)
#define WIN_TR_NO_CGX	(TR_BG_BASE+TR_BG_SIZE)

//O							:30
#define WIN_NAME_PX	(2)
#define WIN_NAME_PY	(6)
#define WIN_NAME_SX	(15)
#define WIN_NAME_SY	(2)
#define WIN_NAME_CGX	(WIN_TR_NO_CGX+WIN_TR_NO_SX*WIN_TR_NO_SY)

//Â					:30
#define WIN_MONEY_PX	(2)
#define WIN_MONEY_PY	(9)
#define WIN_MONEY_SX	(15)
#define WIN_MONEY_SY	(2)
#define WIN_MONEY_CGX	(WIN_NAME_CGX+WIN_NAME_SX*WIN_NAME_SY)

//						:30
#define WIN_BOOK_PX	(2)
#define WIN_BOOK_PY	(12)
#define WIN_BOOK_SX	(15)
#define WIN_BOOK_SY	(2)
#define WIN_BOOK_CGX	(WIN_MONEY_CGX+WIN_MONEY_SX*WIN_MONEY_SY)

//XRA						:30
#define WIN_SCORE_PX	(2)
#define WIN_SCORE_PY	(15)
#define WIN_SCORE_SX	(15)
#define WIN_SCORE_SY	(2)
#define WIN_SCORE_CGX	(WIN_BOOK_CGX+WIN_BOOK_SX*WIN_BOOK_SY)

//vC					:56
#define WIN_TIME_PX	(2)
#define WIN_TIME_PY	(18)
#define WIN_TIME_SX	(28)
#define WIN_TIME_SY	(2)
#define WIN_TIME_CGX	(WIN_SCORE_CGX+WIN_SCORE_SX*WIN_SCORE_SY)

//X^[g					:56
#define WIN_S_TIME_PX	(2)
#define WIN_S_TIME_PY	(20)
#define WIN_S_TIME_SX	(28)
#define WIN_S_TIME_SY	(2)
#define WIN_S_TIME_CGX	(WIN_TIME_CGX+WIN_TIME_SX*WIN_TIME_SY)
//////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////
//łǂ
#define WIN_CLEAR_PX	(2)
#define WIN_CLEAR_PY	(2)
#define WIN_CLEAR_SX	(28)
#define WIN_CLEAR_SY	(4)
#define WIN_CLEAR_CGX	(TR_BG_BASE+TR_BG_SIZE)
//
#define WIN_COMM_PX	(2)
#define WIN_COMM_PY	(7)
#define WIN_COMM_SX	(28)
#define WIN_COMM_SY	(2)
#define WIN_COMM_CGX	(WIN_CLEAR_CGX+WIN_CLEAR_SX*WIN_CLEAR_SY)

//ʐMΐ
#define WIN_BATTLE_PX	(2)
#define WIN_BATTLE_PY	(9)
#define WIN_BATTLE_SX	(28)
#define WIN_BATTLE_SY	(2)
#define WIN_BATTLE_CGX	(WIN_COMM_CGX+WIN_COMM_SX*WIN_COMM_SY)

//ʐM
#define WIN_TRADE_PX	(2)
#define WIN_TRADE_PY	(11)
#define WIN_TRADE_SX	(28)
#define WIN_TRADE_SY	(2)
#define WIN_TRADE_CGX	(WIN_BATTLE_CGX+WIN_BATTLE_SX*WIN_BATTLE_SY)

static const BMPWIN_DAT TrCardBmpData[] =
{
	
	{	// 0:g[i[NO
		FONT_BG, WIN_TR_NO_PX, WIN_TR_NO_PY,
		WIN_TR_NO_SX, WIN_TR_NO_SY, TR_FONT_PAL, WIN_TR_NO_CGX
	},	
	{	// 1:O
		FONT_BG, WIN_NAME_PX, WIN_NAME_PY,
		WIN_NAME_SX, WIN_NAME_SY, TR_FONT_PAL, WIN_NAME_CGX
	},
	{	// 2:Â
		FONT_BG, WIN_MONEY_PX, WIN_MONEY_PY,
		WIN_MONEY_SX, WIN_MONEY_SY, TR_FONT_PAL, WIN_MONEY_CGX
	},	
	{	// 3:
		FONT_BG, WIN_BOOK_PX, WIN_BOOK_PY,
		WIN_BOOK_SX, WIN_BOOK_SY, TR_FONT_PAL, WIN_BOOK_CGX
	},
	{	// 4:XRA
		FONT_BG, WIN_SCORE_PX, WIN_SCORE_PY,
		WIN_SCORE_SX, WIN_SCORE_SY, TR_FONT_PAL, WIN_SCORE_CGX
	},
	{	//@5:vC
		FONT_BG, WIN_TIME_PX, WIN_TIME_PY,
		WIN_TIME_SX, WIN_TIME_SY, TR_FONT_PAL, WIN_TIME_CGX
	},
	{	//@6:Jn
		FONT_BG, WIN_S_TIME_PX, WIN_S_TIME_PY,
		WIN_S_TIME_SX, WIN_S_TIME_SY, TR_FONT_PAL, WIN_S_TIME_CGX
	},
	
	{	//@7:łǂ
		FONT_BG, WIN_CLEAR_PX, WIN_CLEAR_PY,
		WIN_CLEAR_SX, WIN_CLEAR_SY, TR_FONT_PAL, WIN_CLEAR_CGX
	},

	{	//@8:ʐM
		FONT_BG, WIN_COMM_PX, WIN_COMM_PY,
		WIN_COMM_SX, WIN_COMM_SY, TR_FONT_PAL, WIN_COMM_CGX
	},
	{	//@9:ʐMΐ
		FONT_BG, WIN_BATTLE_PX, WIN_BATTLE_PY,
		WIN_BATTLE_SX, WIN_BATTLE_SY, TR_FONT_PAL, WIN_BATTLE_CGX
	},
	{	//@10:ʐM
		FONT_BG, WIN_TRADE_PX, WIN_TRADE_PY,
		WIN_TRADE_SX, WIN_TRADE_SY, TR_FONT_PAL, WIN_TRADE_CGX
	},
};

static void WriteNumData(	GF_BGL_BMPWIN *inWin,
							const u32 inBmpWidth,
							const u32 inRightSpace,
							const u32 inStartY,
							STRCODE *buff,
							const u32 inNum,
							const u8 digit);
static void WriteStrData(	GF_BGL_BMPWIN *inWin,
							const u32 inBmpWidth,
							const u32 inRightSpace,
							const u32 inStartY,
							const STRCODE *buff);

void AddTrCardBmp( GF_BGL_INI * bgl, GF_BGL_BMPWIN	*win )
{
#if 1
	u8 i;
	const BMPWIN_DAT * dat =TrCardBmpData;
	for(i=0;i<TR_CARD_WIN_MAX;i++){
		GF_BGL_BmpWinAddEx( bgl, &win[i], &dat[i] );
	}
	//擪LNAiXN[NAĂƂ́ÃLŖ܂j
	GF_BGL_CharFill( bgl, FONT_BG, 0, 1, 0 );
#endif
}


//--------------------------------------------------------------------------------------------
/**
 * BMPEBhEj
 *
 * @param	wk		g[i[J[h[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ExitTrCardBmpWin( GF_BGL_BMPWIN	*win )
{
	u16	i;

	for( i=0; i<TR_CARD_WIN_MAX; i++ ){
		GF_BGL_BmpWinDel( &win[i] );
	}
/**	
	for( i=0; i<ADD_WIN_MAX; i++ ){
		if( GF_BGL_BmpWinAddCheck( &wk->add_win[i] ) == TRUE ){
			GF_BGL_BmpWinDel( &wk->add_win[i] );
		}
	}
*/	
}

static const u16 id[] = {h_I__,h_D__,h_N__,h_o__,period_,EOM_};
static const u16 namae[] = {na_,ma_,e_,EOM_};
static const u16 okane[] = {o_,ko_,du_,ka_,i_,EOM_};
static const u16 zukan[] = {PO_,KE_,MO_,N_,zu_,ka_,n_,EOM_};
static const u16 score[] = {h_S__,h_C__,h_O__,h_R__,h_E__,EOM_};
static const u16 jikan[] = {PU_,RE_,I_,zi_,ka_,n_,EOM_};
static const u16 kaisi[] = {bo_,u_,ke_,n_,wo_,spc_,ha_,zi_,me_,ta_,spc_,to_,ki_,EOM_};
static const u16 dendou[] = {ha_,zi_,me_,te_,no_,spc_,de_,n_,do_,u_,i_,ri_,EOM_};
static const u16 tuusin_kai[] = {tu_,u_,si_,n_,si_,ta_,spc_,ka_,i_,su_,u_,EOM_};
static const u16 taisen[] = {tu_,u_,si_,n_,spc_,ta_,i_,se_,n_,EOM_};
static const u16 koukan[] = {tu_,u_,si_,n_,spc_,ko_,u_,ka_,n_,EOM_};
static const u16 suuji9[] = {n9_,n9_,n9_,n9_,n9_,n9_,EOM_};
static const u16 suuji8[] = {n8_,n8_,n8_,n8_,n8_,n8_,EOM_};
static const u16 suuji7[] = {n7_,n7_,n7_,n7_,n7_,n7_,EOM_};
static const u16 suuji6[] = {n6_,n6_,n6_,n6_,n6_,n6_,EOM_};
static const u16 suuji5[] = {n5_,n5_,n5_,n5_,n5_,n5_,EOM_};
static const u16 suuji4[] = {n4_,n4_,n4_,n4_,n4_,n4_,EOM_};
static const u16 suuji3[] = {n3_,n3_,n3_,n3_,n3_,n3_,EOM_};
static const u16 suuji2[] = {n2_,n2_,n2_,n2_,n2_,n2_,EOM_};
static const u16 suuji1[] = {n1_,n1_,n1_,n1_,n1_,n1_,EOM_};
static const u16 suuji0[] = {n0_,n0_,n0_,n0_,n0_,n0_,EOM_};
static const u16 * const test_print[] = {
	id,
	namae,
	okane,
	zukan,
	score,
	jikan,
	kaisi,
	dendou,
	tuusin_kai,
	taisen,
	koukan,
	suuji9,
	suuji8,
	suuji7,
	suuji6,
	suuji5,
	suuji4,
	suuji3,
	suuji2,
	suuji1,
	suuji0,

};

static const u8 col_tbl[] = { FBMP_COL_NULL, FBMP_COL_BLACK, FBMP_COL_BLK_SDW };	// iwij


void WriteTrWinInfo( GF_BGL_BMPWIN	*win, const TR_CARD_DATA *inTrCardData )
{
	u8 i;
	GF_BGL_BmpWinFill(
		&win[0], 0, 0, 0,  WIN_TR_NO_SX*8,  WIN_TR_NO_SY*8 );
	GF_BGL_BmpWinFill(
		&win[1], 0, 0, 0,  WIN_NAME_SX*8,  WIN_NAME_SY*8 );
	GF_BGL_BmpWinFill(
		&win[2], 0, 0, 0,  WIN_MONEY_SX*8,  WIN_MONEY_SY*8 );
	GF_BGL_BmpWinFill(
		&win[3], 0, 0, 0,  WIN_BOOK_SX*8,  WIN_BOOK_SY*8 );
	GF_BGL_BmpWinFill(
		&win[4], 0, 0, 0,  WIN_SCORE_SX*8,  WIN_SCORE_SY*8 );
	GF_BGL_BmpWinFill(
		&win[5], 0, 0, 0,  WIN_TIME_SX*8,  WIN_TIME_SY*8 );
	GF_BGL_BmpWinFill(
		&win[6], 0, 0, 0,  WIN_S_TIME_SX*8,  WIN_S_TIME_SY*8 );
	for(i=0;i<7;i++){
		BmpMsgPrintColor(	&win[i],
								FONT_SYSTEM,
								0, 0,
								col_tbl,
								MSG_ALLPUT,
								test_print[i] );
		OS_Printf("len = %d\n",FontProc_GetStrWidth(FONT_SYSTEM,test_print[i],0));
	}
	for(i=0;i<10;i++){
		OS_Printf("numlen = %d\n",FontProc_GetStrWidth(FONT_SYSTEM,test_print[10+i],0));
	}
	//GF_BGL_BmpWinOff( &win[0] );
	
	{
		STRCODE id_buff[6+1];
		STRCODE name_buff[BUFLEN_PERSON_NAME];
		STRCODE money_buff[6+1];
		STRCODE poke_num_buff[3+1];
		STRCODE score_buff[6+1];
		STRCODE time_h_buff[3+1];
		STRCODE time_m_buff[2+1];
		STRCODE s_time_y_buff[4+1];
		STRCODE s_time_m_buff[2+1];
		STRCODE s_time_d_buff[2+1];
		//ID
		WriteNumData(	&win[TRC_BMPWIN_TR_ID],
						8*15, 0, 0, id_buff, inTrCardData->TrainerID, 6);
			
		//Ȃ܂
		WriteStrData(	&win[TRC_BMPWIN_TR_NAME],
						8*15, 0, 0, inTrCardData->TrainerName );
		
		//Â
		WriteNumData(	&win[TRC_BMPWIN_MONEY],
						8*15, 8, 0, money_buff, inTrCardData->Money, 6);
		
		//
		WriteNumData(	&win[TRC_BMPWIN_BOOK],
						8*15, 8*2, 0, poke_num_buff, inTrCardData->PokeBook, 3);
		
		//XRA
		WriteNumData(	&win[TRC_BMPWIN_SCORE],
						8*15, 0, 0, score_buff, 999999, 6);
		
		//vC
		WriteNumData(	&win[TRC_BMPWIN_PLAY_TIME],
						8*28, 0, 0, time_m_buff, inTrCardData->PlayTime_m, 2);		//
		WriteNumData(	&win[TRC_BMPWIN_PLAY_TIME],
						8*28, 3*8, 0, time_h_buff, inTrCardData->PlayTime_h, 3);		//
		
		//X^[g
		WriteNumData(	&win[TRC_BMPWIN_START_TIME],
						8*28, 1*8, 0, s_time_d_buff, 99, 2);	//
		WriteNumData(	&win[TRC_BMPWIN_START_TIME],
						8*28, 4*8, 0, s_time_m_buff, 99, 2);	//
		WriteNumData(	&win[TRC_BMPWIN_START_TIME],
						8*28, 7*8, 0, s_time_y_buff, 9999, 4);	//N

	}
}

void WriteTrWinInfoRev( GF_BGL_BMPWIN	*win )
{
	u8 i;
	GF_BGL_BmpWinFill(
		&win[7], 0, 0, 0,  WIN_CLEAR_SX*8,  WIN_CLEAR_SY*8 );
	GF_BGL_BmpWinFill(
		&win[8], 0, 0, 0,  WIN_COMM_SX*8,  WIN_COMM_SY*8 );
	GF_BGL_BmpWinFill(
		&win[9], 0, 0, 0,  WIN_BATTLE_SX*8,  WIN_BATTLE_SY*8 );
	GF_BGL_BmpWinFill(
		&win[10], 0, 0, 0,  WIN_TRADE_SX*8,  WIN_TRADE_SY*8 );

	for(i=7;i<TR_CARD_WIN_MAX;i++){
		BmpMsgPrintColor(	&win[i],
								FONT_SYSTEM,
								0, 0,
								col_tbl,
								MSG_ALLPUT,
								test_print[i] );
		OS_Printf("revlen = %d\n",FontProc_GetStrWidth(FONT_SYSTEM,test_print[i],0));

	}
	//GF_BGL_BmpWinOff( &win[0] );
	{
		STRCODE clear_y_buff[4+1];
		STRCODE clear_mo_buff[2+1];
		STRCODE clear_d_buff[2+1];
		STRCODE clear_h_buff[3+1];
		STRCODE clear_m_buff[2+1];
		
		STRCODE comm_buff[6+1];
		STRCODE battle_w_buff[4+1];
		STRCODE battle_l_buff[4+1];
		STRCODE trade_buff[6+1];
		//a
		WriteNumData(	&win[TRC_BMPWIN_CLEAR_TIME],
						8*28, 8*1, 0, clear_d_buff, 99, 2);		//
		WriteNumData(	&win[TRC_BMPWIN_CLEAR_TIME],
						8*28, 8*4, 0, clear_mo_buff, 99, 2);	//
		WriteNumData(	&win[TRC_BMPWIN_CLEAR_TIME],
						8*28, 8*7, 0, clear_y_buff, 9999, 4);	//N
		WriteNumData(	&win[TRC_BMPWIN_CLEAR_TIME],
						8*28, 0, 16, clear_m_buff, 99, 2);		//
		WriteNumData(	&win[TRC_BMPWIN_CLEAR_TIME],
						8*28, 8*3, 16, clear_h_buff, 999, 3);	//
		
		//ʐM
		WriteNumData(	&win[TRC_BMPWIN_COMM_INFO],
						8*28, 8, 0, comm_buff, 999999, 6);
		
		//ʐMΐ
		WriteNumData(	&win[TRC_BMPWIN_BATTLE_INFO],
						8*28, 0, 0, battle_w_buff, 9999, 4);
		WriteNumData(	&win[TRC_BMPWIN_BATTLE_INFO],
						8*28, 8*7, 0, battle_l_buff, 9999, 4);
		
		//ʐM
		WriteNumData(	&win[TRC_BMPWIN_TRADE_INFO],
						8*28, 8, 0, trade_buff, 999999, 6);
		
	}
}

void NonDispWinInfo(GF_BGL_BMPWIN	*win, const u8 start, const u8 end)
{
	u8 i;
	for(i=start;i<=end;i++){
		GF_BGL_BmpWinOff( &win[i] );
	}
}

static void WriteNumData(	GF_BGL_BMPWIN *inWin,
							const u32 inBmpWidth,
							const u32 inRightSpace,
							const u32 inStartY,
							STRCODE *buff,
							const u32 inNum,
							const u8 digit)
{
	u32 len;
	PM_NumMsgSetUnsigned(buff, inNum, NUM_MODE_SPACE, digit);
	len = FontProc_GetStrWidth(FONT_SYSTEM,buff,0);

	BmpMsgPrintColor(	inWin,
						FONT_SYSTEM,
						inBmpWidth-(len+inRightSpace), inStartY,
						col_tbl,
						MSG_ALLPUT,
						buff );
}

static void WriteStrData(	GF_BGL_BMPWIN *inWin,
							const u32 inBmpWidth,
							const u32 inRightSpace,
							const u32 inStartY,
							const STRCODE *buff)
{
	u32 len;
	len = FontProc_GetStrWidth(FONT_SYSTEM,buff,0);

	BmpMsgPrintColor(	inWin,
						FONT_SYSTEM,
						inBmpWidth-(len+inRightSpace), inStartY,
						col_tbl,
						MSG_ALLPUT,
						buff );
}
