//============================================================================================
/**
 *	
 */
//============================================================================================
#include "common.h"
#include "system/lib_pack.h"
#include "system/bmp_list.h"
#include "field/field.h"
#include "field/fieldsys.h"
#include "field/fieldmap.h"
#include "system/fontproc.h"
#include "field/fld_bmp.h"
#include "system/pm_str.h"
#include "field/vm.h"
#include "field/script.h"
#include "field/scrcmd.h"
#include "field/sxytype.h"
#include "system/snd_tool.h"
#include "system/palanm.h"

#include "system/fontproc.h"
#include "system/bmp_tool.h"
#include "system/arc_util.h"

//============================================================================================
//	`
//============================================================================================
typedef struct EARTH_DEMO_WORK_tag
{
	GF_BGL_INI * bgl;						// BGLf[^
	int work[16];

	NNSG3dRenderObj			renderobj;
	NNSG3dResMdl*			resmodel;
	NNSG3dResFileHeader* 	resfileheader;

	VecFx32 trans;	//W
	VecFx32 scale;	//XP[
	VecFx32	rotate;	//]	

	GF_CAMERA_PTR camera_p;		//J[N|C^
	CAMERA_ANGLE camera_angle;	//JAO
	VecFx32	light_vec;			//CgAO
	u16 camera_status;

	u16	rotate_speed;
	u16	end_flg;
#ifdef PM_DEBUG	
	GF_BGL_BMPWIN	debug_win;
#endif	
}EARTH_DEMO_WORK;

enum{
	EARTHDEMO_SEQ_MODELLOAD,	//ff[^[h
	EARTHDEMO_SEQ_DISPON,		//`nm
	EARTHDEMO_SEQ_MOVE_EARTH,	//C
	EARTHDEMO_SEQ_MOVE_CAMERA,	//
	EARTHDEMO_SEQ_END,			//I
};

static void EarthLogo_VramBankSet(void);
static void EarthLogo_BGSet(void);
static PROC_RESULT Earth_Logo_Demo_Init(PROC * proc, int * seq);
static PROC_RESULT Earth_Logo_Demo_Main(PROC * proc, int * seq);
static PROC_RESULT Earth_Logo_Demo_Exit(PROC * proc, int * seq);
static void EarthLogo_ModelLoad( EARTH_DEMO_WORK * wk );
static void EarthLogo_ModelRelease( EARTH_DEMO_WORK * wk );
static void EarthLogo3D_Draw( EARTH_DEMO_WORK * wk );
static void EarthVecFx32_to_MtxFx33( MtxFx33* dst, VecFx32* src );
extern void	Main_SetNextProc(FSOverlayID ov_id, const PROC_DATA * proc_data);

static void SetDebugEarthWinBG(GF_BGL_INI *ini);
static void AddDebugEarthBmp(GF_BGL_INI *bgl, GF_BGL_BMPWIN *win);
static void ExitDebugEarthBmp( GF_BGL_BMPWIN *win );
static void WriteDebugEarthWinInfo( GF_BGL_BMPWIN *win, EARTH_DEMO_WORK *wk);


NNSG3dRenderObj			test_renderobj;
NNSG3dResMdl*			test_resmodel;
NNSG3dResFileHeader* 	test_resfileheader;
VecFx32					test_scale;

#define INIT_EARTH_TRANS_XVAL	(0)
#define INIT_EARTH_TRANS_YVAL	(0)
#define INIT_EARTH_TRANS_ZVAL	(0)
#define INIT_EARTH_SCALE_XVAL	(FX32_ONE)
#define INIT_EARTH_SCALE_YVAL	(FX32_ONE)
#define INIT_EARTH_SCALE_ZVAL	(FX32_ONE)
#define INIT_EARTH_ROTATE_XVAL	(0)
#define INIT_EARTH_ROTATE_YVAL	(0)
#define INIT_EARTH_ROTATE_ZVAL	(0)

#define INIT_CAMERA_TARGET_XVAL	(0)
#define INIT_CAMERA_TARGET_YVAL	(0)
#define INIT_CAMERA_TARGET_ZVAL	(0)
#define INIT_CAMERA_POS_XVAL	(0)
#define INIT_CAMERA_POS_YVAL	(0)
#define INIT_CAMERA_POS_ZVAL	(0x128000)
#define INIT_CAMERA_DISTANCE_NEAR	(0x050000)
#define INIT_CAMERA_DISTANCE_FAR	(0x128000)
#define INIT_CAMERA_PERSPWAY	(0x05c1)
#define INIT_CAMERA_CLIP_NEAR	(0)
#define INIT_CAMERA_CLIP_FAR	(FX32_ONE*100)
#define CAMERA_ANGLE_MIN		(-0x4000+0x200)
#define CAMERA_ANGLE_MAX		(0x4000+0x200)

#define USE_LIGHT_NUM			(0)
#define LIGHT_VECDEF			(FX32_ONE-1)
#define INIT_LIGHT_ANGLE_XVAL	(0)
#define INIT_LIGHT_ANGLE_YVAL	(0)
#define INIT_LIGHT_ANGLE_ZVAL	(-LIGHT_VECDEF)

enum {
	CAMERA_FAR = 0,
	CAMERA_NEAR,
};

//============================================================================================
//	vZX`f[^
//============================================================================================
const PROC_DATA Earth_Logo_Demo_proc_data = {
	Earth_Logo_Demo_Init,
	Earth_Logo_Demo_Main,
	Earth_Logo_Demo_Exit,
	NO_OVERLAY_ID,
};

//============================================================================================
//	C
//============================================================================================
#define HEAPID_EARTH_DEMO (HEAPID_TITLE_DEMO)
static PROC_RESULT Earth_Logo_Demo_Init(PROC * proc, int * seq)
{
	EARTH_DEMO_WORK * wk;

	sys_VBlankFuncChange( NULL, NULL );	// VBlankZbg
	sys_HBlankIntrSet( NULL,NULL );		// HBlankZbg

	EarthLogo_VramBankSet();

	GF_Disp_GX_VisibleControlInit();
	GF_Disp_GXS_VisibleControlInit();
	GX_SetVisiblePlane( 0 );
	GXS_SetVisiblePlane( 0 );
	EarthLogo_BGSet();
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0 , VISIBLE_OFF );

	sys_KeyRepeatSpeedSet( 4, 8 );
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_EARTH_DEMO, 0x100000 );

	wk = PROC_AllocWork( proc, sizeof(EARTH_DEMO_WORK), HEAPID_EARTH_DEMO );
	memset( wk, 0, sizeof(EARTH_DEMO_WORK) );

	simple_3DBGInit( HEAPID_EARTH_DEMO );
	
	wk->bgl = GF_BGL_BglIniAlloc( HEAPID_EARTH_DEMO );

	SetDebugEarthWinBG(wk->bgl);
	AddDebugEarthBmp(wk->bgl, &wk->debug_win);

	WriteDebugEarthWinInfo( &wk->debug_win, wk);
	
	
	wk->camera_p = GFC_AllocCamera( HEAPID_EARTH_DEMO );

	GF_Disp_DispOn();

	return	PROC_RES_FINISH;
}

//----------------------------------
static PROC_RESULT Earth_Logo_Demo_Main(PROC * proc, int * seq)
{
	EARTH_DEMO_WORK * wk  = PROC_GetWork( proc );

	switch(*seq){

	case EARTHDEMO_SEQ_MODELLOAD://ff[^[h

		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0 , VISIBLE_OFF );//[hJnFRcʂnee
		EarthLogo_ModelLoad(wk);//f[hC
		{
			//ff[^p[^
			wk->trans.x	= INIT_EARTH_TRANS_XVAL; 
			wk->trans.y	= INIT_EARTH_TRANS_YVAL; 
			wk->trans.z	= INIT_EARTH_TRANS_ZVAL; 

			wk->scale.x	= INIT_EARTH_SCALE_XVAL;
			wk->scale.y	= INIT_EARTH_SCALE_YVAL;
			wk->scale.z	= INIT_EARTH_SCALE_ZVAL;

			wk->rotate.x  = INIT_EARTH_ROTATE_XVAL;
			wk->rotate.y  = INIT_EARTH_ROTATE_YVAL;
			wk->rotate.z  = INIT_EARTH_ROTATE_ZVAL;
		}
		{
			//Jݒ
			VecFx32	target_pos	= 	{ INIT_CAMERA_TARGET_XVAL,
									  INIT_CAMERA_TARGET_YVAL,
									  INIT_CAMERA_TARGET_ZVAL };
			VecFx32	camera_pos	=	{ INIT_CAMERA_POS_XVAL,
									  INIT_CAMERA_POS_YVAL,
									  INIT_CAMERA_POS_ZVAL };

			GFC_InitCameraTC(	&target_pos,
							&camera_pos,
							INIT_CAMERA_PERSPWAY,
							GF_CAMERA_PERSPECTIV,
							FALSE,
							wk->camera_p);
			GFC_SetCameraClip(INIT_CAMERA_CLIP_NEAR,INIT_CAMERA_CLIP_FAR,wk->camera_p);
			GFC_SetCameraView(GF_CAMERA_PERSPECTIV,wk->camera_p);
			GFC_AttachCamera(wk->camera_p);
			wk->camera_status = CAMERA_FAR;
		}
		{
			//Cgݒ
			wk->light_vec.x = INIT_LIGHT_ANGLE_XVAL;
			wk->light_vec.y = INIT_LIGHT_ANGLE_YVAL;
			wk->light_vec.z = INIT_LIGHT_ANGLE_ZVAL;
			NNS_G3dGlbLightVector(USE_LIGHT_NUM,wk->light_vec.x,wk->light_vec.y,wk->light_vec.z);
			NNS_G3dGlbLightVector(1,-LIGHT_VECDEF,-LIGHT_VECDEF,-LIGHT_VECDEF);
		}
		EarthLogo3D_Draw(wk);//Rc`GW
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0 , VISIBLE_ON );//[hIFRcʂnm

		//PxύXZbgihmj
		ChangeBrightnessRequest (2,	//EFCg
								BRIGHTNESS_NORMAL,	// BPx
								BRIGHTNESS_BLACK,	// JnPx
								PLANEMASK_ALL,MASK_DOUBLE_DISPLAY);//Ώۖ

		*seq = EARTHDEMO_SEQ_DISPON;

		return	PROC_RES_CONTINUE;

	case EARTHDEMO_SEQ_DISPON:	//`nm

		EarthLogo3D_Draw(wk);//Rc`GW

		wk->end_flg = 0;
		if(IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) == TRUE){	//PxύX҂
			*seq = EARTHDEMO_SEQ_MOVE_EARTH;
		}
		return	PROC_RES_CONTINUE;

	case EARTHDEMO_SEQ_MOVE_EARTH:	//n]

		switch(wk->camera_status){
		case CAMERA_NEAR:
			wk->rotate_speed = 0x020;
			test_scale.x = FX32_ONE/4;
			test_scale.y = FX32_ONE/4;
			test_scale.z = FX32_ONE;
			break;
		case CAMERA_FAR:
			wk->rotate_speed = 0x200;
			test_scale.x = FX32_ONE;
			test_scale.y = FX32_ONE;
			test_scale.z = FX32_ONE;
			break;
		}

		if(sys.trg & PAD_BUTTON_A){
			if(wk->camera_status == CAMERA_FAR){
				wk->camera_status = CAMERA_NEAR;
			}else{
				wk->camera_status = CAMERA_FAR;
			}
			*seq = EARTHDEMO_SEQ_MOVE_CAMERA;
			break;
		}
		if(sys.cont & PAD_KEY_LEFT){
			wk->rotate.y += wk->rotate_speed;
		}
		if(sys.cont & PAD_KEY_RIGHT){
			wk->rotate.y -= wk->rotate_speed;
		}
		if(sys.cont & PAD_KEY_UP){
			if((wk->rotate.x + wk->rotate_speed) < CAMERA_ANGLE_MAX){
				wk->rotate.x += wk->rotate_speed;
			}else{
				wk->rotate.x = CAMERA_ANGLE_MAX;
			}
		}
		if(sys.cont & PAD_KEY_DOWN){
			if((wk->rotate.x - wk->rotate_speed) > CAMERA_ANGLE_MIN){
				wk->rotate.x -= wk->rotate_speed;
			}else{
				wk->rotate.x = CAMERA_ANGLE_MIN;
			}
		}
		//]\
		WriteDebugEarthWinInfo( &wk->debug_win, wk);
		EarthLogo3D_Draw(wk);//Rc`GW
		return	PROC_RES_CONTINUE;

	case EARTHDEMO_SEQ_MOVE_CAMERA:	//Jړ
		{
			fx32 distance = GFC_GetCameraDistance(wk->camera_p);
			u16	move_speed = 0x08000;
			BOOL end_flg = FALSE;

			switch(wk->camera_status){
			case CAMERA_NEAR://߂Â
				if(distance > (INIT_CAMERA_DISTANCE_NEAR + move_speed)){
					distance -= move_speed;
				}else{
					distance = INIT_CAMERA_DISTANCE_NEAR;
					end_flg = TRUE;
				}
				break;

			case CAMERA_FAR://
				if(distance < (INIT_CAMERA_DISTANCE_FAR - move_speed)){
					distance += move_speed;
				}else{
					distance = INIT_CAMERA_DISTANCE_FAR;
					end_flg = TRUE;
				}
				break;
			}
			GFC_SetCameraDistance(distance,wk->camera_p);
			if(end_flg == TRUE){
				*seq = EARTHDEMO_SEQ_MOVE_EARTH;
			}
			EarthLogo3D_Draw(wk);//Rc`GW
		}
		return	PROC_RES_CONTINUE;

	case EARTHDEMO_SEQ_END:	//I

		EarthLogo3D_Draw(wk);//Rc`GW
		
		if(IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) == TRUE){	//PxύX҂
			EarthLogo_ModelRelease( wk );
			(*seq) = 0;
			return	PROC_RES_FINISH;
		}
		return	PROC_RES_CONTINUE;
	}
	return	PROC_RES_CONTINUE;
}

//----------------------------------
static PROC_RESULT Earth_Logo_Demo_Exit(PROC * proc, int * seq)
	
{
	EARTH_DEMO_WORK * wk  = PROC_GetWork( proc );

	GF_Disp_GX_VisibleControl(
		GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 | GX_PLANEMASK_BG2 |
		GX_PLANEMASK_BG3 | GX_PLANEMASK_OBJ, VISIBLE_OFF );
	GF_Disp_GXS_VisibleControl(
		GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 | GX_PLANEMASK_OBJ, VISIBLE_OFF );

	GFC_FreeCamera(wk->camera_p);
	simple_3DBGExit();
	sys_FreeMemoryEz(wk->bgl);

	PROC_FreeWork( proc );				// [NJ

	sys_VBlankFuncChange( NULL, NULL );		// VBlankZbg
	sys_DeleteHeap( HEAPID_EARTH_DEMO );

	//Main_SetNextProc(NO_OVERLAY_ID, &TitleProcData);
	return	PROC_RES_FINISH;
}

//----------------------------------
//uq`lݒ
//----------------------------------
static void EarthLogo_VramBankSet(void)
{
	GF_BGL_DISPVRAM vramSetTable = {
		GX_VRAM_BG_128_C,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
		GX_VRAM_SUB_BG_32_H,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
		GX_VRAM_OBJ_16_F,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
		GX_VRAM_TEX_01_AB,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_0123_E			// eNX`pbgXbg
	};
	GF_Disp_SetBank( &vramSetTable );
}

//----------------------------------
//afݒ
//----------------------------------
static void EarthLogo_BGSet(void)
{
	{//BG SYSTEM
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS,GX_BGMODE_0,GX_BGMODE_0,GX_BG0_AS_3D
		};	
		GF_BGL_InitBG(&BGsys_data);
	}
}

//----------------------------------
//Rcf[^[h֐
//----------------------------------
static void EarthLogo_ModelLoad( EARTH_DEMO_WORK * wk )
{
	simple_3DModelSet(	HEAPID_EARTH_DEMO,
						"graphic/wifi_earth.nsbmd",
						&wk->renderobj,
						&wk->resmodel,
						&wk->resfileheader);
	simple_3DModelSet(	HEAPID_EARTH_DEMO,
						"data/earth_mark.nsbmd",
						&test_renderobj,
						&test_resmodel,
						&test_resfileheader);
}

static void EarthLogo_ModelRelease( EARTH_DEMO_WORK * wk )
{
	sys_FreeMemoryEz(wk->resfileheader);
}

//----------------------------------
//Rc`֐
//----------------------------------
static void EarthLogo3D_Draw( EARTH_DEMO_WORK * wk )
{
	MtxFx33 rotate_tmp = {FX32_ONE,0,0,0,FX32_ONE,0,0,0,FX32_ONE};

	GF_G3X_Reset();
	GFC_CameraLookAt();
#if 0
	//GbW}[LOeXg
	NNS_G3dGlbPolygonAttr(
				TMAP_MLIGHT_FLAG,			// Cg   
				GX_POLYGONMODE_MODULATE,	// ʏ̃|S[h
				GX_CULL_BACK,				// JobNs
				20,							//|SID
				8,							// At@l
				GX_POLYGON_ATTR_MISC_NONE/*GX_POLYGON_ATTR_MISC_XLU_DEPTH_UPDATE*/);
#endif
	{
		EarthVecFx32_to_MtxFx33(	&rotate_tmp,&wk->rotate);

		simple_3DModelDraw(	&wk->renderobj,
							&wk->trans,
							&rotate_tmp,
							&wk->scale);
		//}[LO
		{
			VecFx32 vec={0,0,0};
			MtxFx33 rot = {FX32_ONE,0,0,0,FX32_ONE,0,0,0,FX32_ONE};
			simple_3DModelDraw(	&test_renderobj,
								&vec,
								&rot,
								&test_scale);
		}
	}

	GF_G3_RequestSwapBuffers(GX_SORTMODE_AUTO,GX_BUFFERMODE_W);
}

//----------------------------------
//Rc]vZ
//----------------------------------
static void  EarthVecFx32_to_MtxFx33( MtxFx33* dst, VecFx32* src )
{
	MtxFx33 tmp;

	MTX_RotY33(	dst,FX_SinIdx((u16)src->y),FX_CosIdx((u16)src->y));

	MTX_RotX33(	&tmp,FX_SinIdx((u16)src->x),FX_CosIdx((u16)src->x));
	MTX_Concat33(dst,&tmp,dst);

	MTX_RotZ33(	&tmp,FX_SinIdx((u16)src->z),FX_CosIdx((u16)src->z));
	MTX_Concat33(dst,&tmp,dst);
}

#ifdef PM_DEBUG

static void SetDebugEarthWinBG(GF_BGL_INI * ini)
{
	{	// FONT (BMP)
		GF_BGL_BGCNT_HEADER BgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x04000, GX_BG_EXTPLTT_01,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, /*TRC_BG_FONT*/GF_BGL_FRAME3_M, &BgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, /*TRC_BG_FONT*/GF_BGL_FRAME3_M );
	}

	SystemFontPaletteLoad( PALTYPE_MAIN_BG, 16<<1, HEAPID_EARTH_DEMO );
}

static const BMPWIN_DAT DebugEarthBmpData =
{
	GF_BGL_FRAME3_M, 0, 0,
	8, 4, FLD_SYSFONT_PAL, 1
};

static void AddDebugEarthBmp(GF_BGL_INI * bgl, GF_BGL_BMPWIN	*win)
{
	GF_BGL_BmpWinAddEx( bgl, win, &DebugEarthBmpData );
	//GF_BGL_CharFill( bgl, FONT_BG, 0, 1, 0 );
	
	GF_BGL_BmpWinFill(
		win, 0, 0, 0,  8*8,  4*8 );
}

static void ExitDebugEarthBmp( GF_BGL_BMPWIN	*win )
{
	GF_BGL_BmpWinDel( win );
}

static void WriteDebugEarthWinInfo( GF_BGL_BMPWIN	*win, EARTH_DEMO_WORK * wk)
{
	u16 buff[10];
	PM_HexNumMsgSet(buff, (u16)wk->rotate.x, NUM_MODE_SPACE, 4);
	GF_MSG_Print( win, FONT_SYSTEM, buff, 0, 0, MSG_ALLPUT, NULL );
	PM_HexNumMsgSet(buff, (u16)wk->rotate.y, NUM_MODE_SPACE, 4);
	GF_MSG_Print( win, FONT_SYSTEM, buff, 0, 16, MSG_ALLPUT, NULL );
}

#endif	//PM_DEBUG

