/**
 *	@file	tmap.h
 *	@brief	^E}bvW[łJwb_
 *	@date	05.11.02
 *	@author	Miyuki Iwasawa
 */
#ifndef _TMAP_H_
#define _TMAP_H_

#include "townmap.dat"
#include "tmap_gra.naix"	//A[JCut@C

///ʃ}N`
#ifdef PM_DEBUG
#define TMAP_HEAP_PRINT(str) {\
 OS_Printf( "\nINFO : townmap.c -> %s\n",(str));	\
 OS_Printf( "TOWNMAP_HEAP_SIZE : 0x%x\n", sys_GetHeapFreeSize( HEAPID_TOWNMAP ) ); \
}
#else	//PM_DEBUG
#define TMAP_HEAP_PRINT
#endif	//PM_DEBUG

//XN[TCY擾}N
#define SCWS_GET(p)	((p)->screenWidth/8)
#define SCHS_GET(p)	((p)->screenHeight/8)

#define TMAP_BUFLEN_ZNW	(10*2)
#define TOWNV_TYPE_MAX	(4)
#define TOWN_VIEW_MAX	(18)

#define TMAP_BLOCK_OFFSETX	(2)
#define TMAP_BLOCK_OFFSETZ	(2)
#define TMAP_BLOCK_UNIT	(16)
#define TMAP_SBLOCK_UNIT	(16)

#define FORCUS_CHG_SYNC	(8)

//CDotItZbg
#define TMAP_MDOT_OFSX	(25)
#define TMAP_MDOT_OFSZ	(-34)
#define TMAP_MDOT_UNIT	(7)


//================================================================
///f[^^`GA
//================================================================
///3DIuWFNgf[^
typedef struct _TMAP_3DOBJ_RES{
	NNSG3dResFileHeader	*pResHeader;
	NNSG3dResMdl	*pMdl;
	NNSG3dResTex	*pTex;
	NNSG3dTexKey	texKey;
	NNSG3dTexKey	tex44Key;
	NNSG3dPlttKey	pltKey;
}TMAP_3DOBJ_RES;

typedef struct _VecU16{
	u16	x;
	u16	y;
	u16	z;
}VecU16;
typedef struct _TMAP_3DOBJ_RENDER{
	VecFx32	pos;
	VecFx32	scale;
	VecU16	rot;
	NNSG3dRenderObj	obj;
}TMAP_3DOBJ_RENDER;

typedef struct _TMAP_3DOBJ_CMB{
	NNSG3dResFileHeader	*pResHeader;
	NNSG3dResMdl	*pMdl;
	NNSG3dResTex	*pTex;
	NNSG3dTexKey	texKey;
	NNSG3dTexKey	tex44Key;
	NNSG3dPlttKey	pltKey;
	NNSG3dRenderObj	obj;
}TMAP_3DOBJ_CMB;

typedef struct _TMAP_3DOBJ_SRT{
	VecFx32	pos;
	VecFx32	scale;
	VecU16	rot;
}TMAP_3DOBJ_SRT;

///<Jp[^
typedef struct _TMAP_CAMERA_PARAM{
	VecFx32	pos;	///<J|WV
	VecFx32	target;	///<^[Qbg|WV
	
	fx32	near;	///<NearNbv
	fx32	far;	///<FarNbv
	fx32	pers;	///<pers
}TMAP_CAMERA_PARAM;

typedef struct _TMAP_2DSCRN{
	void* pFile;
	NNSG2dScreenData* pRes;
}TMAP_2DSCRN;

typedef struct _TMAP_SCROLLPRM{
	int	scrX;
	int	scrY;
	int	difX;
	int	difY;
}TMAP_SCROLLPRM;

///^E}bvpf[^^
typedef struct _TMAP_GDAT{
	u16	x;			//<ObhWX
	u16	z;			//<ObhWZ
	u16	kType;		//<Ŕ^Cv`
	u16 kIdx;		//<ŔIndexNo
	u16	gmes01;		//<KChbZ[W01CfbNX
	u16	gmes02;		//<KChbZ[W02CfbNX
	u16	gmes01_ox;	//<KChbZ[W01\ItZbgX
	u16	gmes01_oy;	//<KChbZ[W01\ItZbgY
	u16	gmes02_ox;	//<KChbZ[W02\ItZbgX
	u16	gmes02_oy;	//<KChbZ[W02\ItZbgY
	void*	flag;	//<KCh\Rg[tOAhX
	u32	view;		//<ViewtO
}TMAP_GDAT;

typedef struct _TMAP_GDAT_LIST{
	int	num;	///<f[^
	TMAP_GDAT *pDat;	//f[^z
}TMAP_GDAT_LIST;

///^EViewpf[^\
typedef struct _TOWN_VIEW{
	int		zoneID;	//<][ID
	u8		ptn;	//<摜p^[	
	u8		typ;	//<摜p^[	
	u16		r;	//<]p
	fx32	x;	//<xW
	fx32	z;	//<yW
}TOWN_VIEW;

typedef struct _TMAP_VIEW_OBJ{
	TOWN_VIEW	prm;
	int		flag;
	CLACT_WORK_PTR	pAct;
}TMAP_VIEW_OBJ;

typedef struct _TMAP_VIEW_DAT{
	u16	dat_num;
	u8	selCount;
	u8	selFrame;

	TMAP_VIEW_OBJ *selPos;
	TMAP_VIEW_OBJ *pDat;
}TMAP_VIEW_DAT;

///vg^Cv
struct TMAP_MAIN_DAT;
///TuvZX`p֐^
//typedef int (*TMapSubProc)(TMAP_MAIN_DAT* pMain);

///C[N
typedef struct TMAP_MAIN_DAT{
	u8	mode;	///<샂[h擾
	u8	forcus;	///<㉺ʂǂɐ䂪邩H
	u16	mapView;	///<zz}bv`搧tO
	int	heapID;	///<HeapID
	int	main_seq;	///<V[PX
	int	sub_seq;	///<V[PX
	int seq;
	int	wipe_f;		///<CvtO

	int	cposX;
	int cposZ;
	int	gx;
	int gz;
	
	GF_BGL_INI *bgl;	///<BGLf[^
	TOWNMAP_PARAM* param;	///<Opp[^IO
	FMZ_PTR	pZone;		///<][f[^擾|C^
	void*	pSwork;			///<Tu[Nmۃ|C^
	int (*keyFunc)(struct TMAP_MAIN_DAT*);

	TMAP_VIEW_DAT*	pVDat;
	TMAP_GDAT_LIST* pBDat;
	TMAP_FOOT	foot[TMAP_FVIEW_MAX];
	
	///bZ[W\[X
	MSGDATA_MANAGER*	pMsgMap;
	MSGDATA_MANAGER*	pMsgTMap;
	STRBUF				*placeName;
	
	///VBlank]pۑp[^
	int	vb_trans;
	int	vb_zoneID;
	TMAP_GDAT*	vb_block;
	
	///OtBbN\[X
	void*	pScrBuf01;
	void*	pScrBuf01_back;
	void*	pScrBuf01_dis;
	void*	pScrBuf02_dm;
	void*	pScrBuf02_dr;
	void*	pScrBuf02_dswm;
	void*	pScrBuf02_sw;
	
	NNSG2dScreenData*	pScr01;
	NNSG2dScreenData*	pScr01_back;
	NNSG2dScreenData*	pScr01_dis;
	NNSG2dScreenData*	pScr02_dm;
	NNSG2dScreenData*	pScr02_dr;
	NNSG2dScreenData*	pScr02_dswm;
	NNSG2dScreenData*	pScr02_sw;

	CATS_SYS_PTR	pCActSys;	///<ZAN^[VXe
	CATS_RES_PTR	pCActRes;	///<ZAN^[\[X
	CATS_ACT_PTR	pCAct;		///<ANg
}TMAP_MAIN_DAT;

///TuvZX`p֐^
typedef int (*TMapSubProc)(TMAP_MAIN_DAT* pMain);

typedef struct _TMAP_SUB_PROC{
	TMapSubProc	init;
	TMapSubProc	build;
	TMapSubProc	keyIO;
	TMapSubProc	main;
	TMapSubProc	draw;
	TMapSubProc	release;
	TMapSubProc	vBlank;
}TMAP_SUB_PROC;

///==============================================================
//^E}bvW[O[o֐
///==============================================================
/**
 *	@brief	^E}bvJp[^̓Kp
 *
 *	@param	wk	GF_CAMERA_PTR^[Nւ̃|C^Â͗\ߊmۂĂ
 *	@param	param	TMAP_CAMERA_PARAM*@ێĂJp[^
 */
extern void TMap_AttachCamera(GF_CAMERA_PTR wk,TMAP_CAMERA_PARAM *param);
/**
 *	@brief t@C烂f\[X擾
 *
 *  @param	heapID	q[vhc
 *	@param	name	char*:nsbmdt@C
 *	@param	res		TMAP_3DOBJ_RES f[^\̂ւ̃|C^
 */
extern void TMapLoad3DObj(int heapID,char* name,TMAP_3DOBJ_RES* res);
/**
 *	@brief f\[Xj
 *
 *	@param	res		TMAP_3DOBJ_RES f[^\̂ւ̃|C^
 */
extern void TMapRelease3DObj(TMAP_3DOBJ_RES* res);

/**
 *	@brief f\[X烌_[IuWFNg쐬
 *
 *	@param	obj		TMAP_3DOBJ_RENDERf[^\̂ւ̃|C^
 *	@param	res		TMAP_3DOBJ_RES f[^\̂ւ̃|C^
 *	@param	trans	VecFx32^ւ̃|C^
 *	@param	scale	VecFx32^ւ̃|C^
 *	@param	rotate	VecU16^ւ̃|C^
 */
extern void TMapMake3DRenderObj(TMAP_3DOBJ_RENDER* obj,TMAP_3DOBJ_RES* res,
		VecFx32* trans,VecFx32* scale,VecU16* rotate);

/**
 *	@brief	^EView\[X쐬
 */
extern TMAP_VIEW_DAT* TownViewDataCreate(TMAP_MAIN_DAT* pMain,short res_num,short dat_num);

/**
 *	@brief	^EView\[X
 */
extern void TownViewDataRelease(TMAP_MAIN_DAT* pMain,TMAP_VIEW_DAT* wp);

/**
 *	@brief	^EView {`
 */
extern void TownViewDataDraw(TMAP_MAIN_DAT* pMain,TMAP_VIEW_DAT* wp);

/**
 *	@brief	}bvubNf[^[h
 */
extern TMAP_GDAT_LIST* TMapBlockDataLoad(TMAP_MAIN_DAT* pMain,const char* path);

/**
 *	@brief	}bvubNf[^
 */
extern void TMapBlockDataRelease(TMAP_GDAT_LIST* pWork);

/**
 *	^EView f[^ZoneID̂T
 */
extern TMAP_VIEW_OBJ* TownViewDataSearchPos(TMAP_VIEW_DAT* wp,int zoneID);

/**
 *	@brief	^EView
 */
extern int TownViewDataSelectPos(TMAP_VIEW_DAT* wp,int zoneID);

/**
 *	@brief	}bvubNf[^@ubNf[^擾
 *
 *	@param	pWork	f[^Xgz̐擪|C^
 *	@param	x		ubNXW
 *	@param	z		ubNZW
 *	@param	mapView	zz}bv`tO
 *	ubNx,zWubNf[^ւ̃|C^擾
 *	ȂꍇNULLԂ
 */
extern TMAP_GDAT* TMapBlockDataGet(TMAP_GDAT_LIST* pWork,int x,int z,int mapView);

#endif	//_TMAP_H_
