/**
 *	@file	tmap_act.c
 *	@brief	^E}bvW[@ZAN^[
 *	@author	Miyuki Iwasawa
 *	@date	05.12.21
 */

#include "common.h"
#include "field/field_matrix.h"
#include "field/field_place_name.h"
#include "system/procsys.h"
#include "system/arc_util.h"
#include "system/arc_tool.h"
#include "system/clact_util.h"
#include "system/clact_tool.h"
#include "system/render_oam.h"
#include "system/fontproc.h"
#include "system/pm_str.h"
#include "system/msgdata.h"

#include "gflib/camera.h"
#include "gflib/simple_3dgraphics.h"
#include "gflib/mdlanm.h"
#include "application/worldmap/townmap.h"
#include "tmap.h"

#define TMAPACT_CUR_NUM	(1)
#define TMAPACT_HERO_NUM	(1)
#define TMAPACT_BTN_NUM	(1)
#define TMAPACT_FOOT_MAX	(5)
#define TMAPACT_TVIEW_MAX	(18)

#define TMAP_ACT_MAX	(\
 TMAPACT_CUR_NUM + \
 TMAPACT_HERO_NUM + \
 TMAPACT_BTN_NUM + \
 TMAPACT_FOOT_MAX + \
 TMAPACT_TVIEW_MAX)

#define TMAP_ACTRES_MAX	(5)


///vg^Cv
void TMapCellActorInit(TMAP_MAIN_DAT *pMain);
void TMapCellActorRelease(TMAP_MAIN_DAT *pMain);
void TMapCellActorMain(TMAP_MAIN_DAT *pMain);
void TMapCellActorTrans(TMAP_MAIN_DAT* pMain);


void TMapCellActorInit(TMAP_MAIN_DAT *pMain)
{
	GF_Disp_GX_VisibleControl(GX_PLANEMASK_OBJ,VISIBLE_ON);
	GF_Disp_GXS_VisibleControl(GX_PLANEMASK_OBJ,VISIBLE_ON);

	initVramTransferManagerHeap(32,pMain->heapID);

	//ZAN^[VXe
	pMain->pCActSys = CATS_AllocMemory(pMain->heapID);
	pMain->pCActRes = CATS_ResourceCreate(pMain->pCActSys);

	{
		TCATS_OAM_INIT	coi = {
			0,128,		///< C	OAMǗ̈EJn/I
			0,32,		///< C	AtBǗ̈EJn/I
			0,128,		///< Tu	OAMǗ̈EJn/I
			0,32,		///< Tu	AtBǗ̈EJn/I
		};
		TCATS_CHAR_MANAGER_MAKE ccmm = {
			TMAP_ACTRES_MAX,	//ID䐔
			1024,	//CʃTCY(byteP)
			1024,	//TuʃTCY(byteP)
			GX_OBJVRAMMODE_CHAR_1D_32K,	//COBJ[hw
			GX_OBJVRAMMODE_CHAR_1D_32K,	//TuOBJ[hw
		};

		CATS_SystemInit( pMain->pCActSys, &coi, &ccmm, 32 );
		CATS_ClactSetInit( pMain->pCActSys, pMain->pCActRes,TMAP_ACT_MAX );
	}

	{
		TCATS_RESOURCE_FILE_LIST list = {
			"data/tmapn_res_chr.txt",		// LN^
			"data/tmapn_res_pal.txt",		// pbg
			"data/tmapn_res_cell.txt",	// Z
			"data/tmapn_res_canm.txt",	// ZAj
			NULL,						// }`Z
			NULL,						// }`ZAj
			"data/tmapn_celact.txt"		// wb_[		
		};
		CATS_ResourceLoad(pMain->pCActSys,pMain->pCActRes,&list);
	}
}

void TMapCellActorRelease(TMAP_MAIN_DAT *pMain)
{
	CATS_ResourceDestructor(pMain->pCActSys,pMain->pCActRes);
	CATS_FreeMemory(pMain->pCActSys);
	DellVramTransferManager();	
}

void TMapCellActorMain(TMAP_MAIN_DAT *pMain)
{
	CATS_Draw(pMain->pCActRes);
}

void TMapCellActorTrans(TMAP_MAIN_DAT* pMain)
{
	CATS_RenderOamTrans();
}


