/**
 *	@file	tmap_nrm.c
 *	@brief	^E}bv@m[}[h
 *	@date	05.11.02
 *	@author	Miyuki Iwasawa
 */
#include "common.h"
#include "field/field_matrix.h"
#include "field/field_place_name.h"
#include "system/procsys.h"
#include "system/bmp_list.h"
#include "system/arc_util.h"
#include "system/arc_tool.h"
#include "system/snd_tool.h"
#include "system/fontproc.h"
#include "system/pm_str.h"
#include "system/msgdata.h"
#include "system/buflen.h"
#include "system/window.h"
#include "system/brightness.h"
#include "system/clact_util.h"
#include "system/clact_tool.h"
#include "system/render_oam.h"
#include "system/wipe.h"
#include "gflib/touchpanel.h"
#include "application/worldmap/townmap.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_townmap.h"
#include "msgdata/msg_place_name.h"
#include "tmap.h"
#include "tmap_act.h"

#include "tmap_nrm.dat"
//̂place_name.c
extern void GetPlaceNameFromZoneIDNew(	const int inZoneID,
									const u32 inHeapID,
									STRBUF *outName);

///Օ\\
#define DIR_NOT			(-1)	///<Ȃꍇ
#define DIR_UP			(0)		///<
#define DIR_DOWN		(1)		///<
#define DIR_LEFT		(2)		///<
#define DIR_RIGHT		(3)		///<E
#define DIR_ROT_UP		(0)
#define DIR_ROT_LEFT	(1)
#define DIR_ROT_DOWN	(2)
#define DIR_ROT_RIGHT	(3)

typedef struct _TMAP_FVIEW{
	int	x;
	int	z;
	u16	dir;	//
	u8	idx;
	u8	valid;
	
	CLACT_WORK_PTR	pAct;	///<AN^[[N
}TMAP_FVIEW;
typedef struct _TMAP_FOOTVIEW{
	int	num;	//Lf[^
	TMAP_FVIEW	foot[TMAP_FVIEW_MAX];
}TMAP_FOOTVIEW;

typedef struct _TMAP_MODE_NORMAL{
	int	seq;		///<V[N
	int	sub_seq;	///<V[N
	int	sub_ct;	///<V[N
	int	main_ct;	///<V[N
	u8	forcus;	///<㉺ʂǂɐ䂪邩H
	u8	key_f;	///<L[tO
	u8	view_f;	///<r[XVtO
	u8	cmove_f;	///<J[\ړǂH
	u8	tp_f;	///<^b`plRg[tO
	u8	guide_f;	///<KChXVtO	
	u16	repeat_f;	///<s[g
	int cposX;		///<݂̃J[\ʒu(ubN)
	int cposZ;		///<݂̃J[\ʒu(ubN)
	int	czoneID;	///<݂̃][ID
	int	ozoneID;	///<Â][ID
	
	int	oPosData[TMAP_POSDATA_MAX];	///<|WVf[^̃IWi
	int	posData[TMAP_POSDATA_MAX];	///<\[gς݃f[^

	GF_BGL_BMPWIN	win[WIN_MAX];	///<BMPEBhEf[^

	TMAP_SCROLLPRM	scrBGM0;	///<XN[p[^
	TMAP_SCROLLPRM	scrBGS0;	///<XN[p[^

	TMAP_VIEW_DAT*	pTView;	///<^EViewf[^
	TMAP_GDAT*		pBlock;	///<ubNf[^

	TMAP_FOOTVIEW	fView;	///<Օ`

	CLACT_WORK_PTR	pCAW_btn;	///<AN^[[N
	CLACT_WORK_PTR	pCAW_cur;	///<AN^[[N
	CLACT_WORK_PTR	pCAW_hero;	///<AN^[[N
}TMAP_MODE_NORMAL;

///vg^Cv
int	TMapNormal_Init(TMAP_MAIN_DAT* pMain);
int	TMapNormal_Build(TMAP_MAIN_DAT* pMain);
int	TMapNormal_KeyIn(TMAP_MAIN_DAT* pMain);
int	TMapNormal_Main(TMAP_MAIN_DAT* pMain);
int	TMapNormal_Draw(TMAP_MAIN_DAT* pMain);
int TMapNormal_Release(TMAP_MAIN_DAT *pMain);
int TMapNormal_VBlank(TMAP_MAIN_DAT *pMain);

int	TMapJump_KeyWait(TMAP_MAIN_DAT* pMain);
int	TMapJump_Main(TMAP_MAIN_DAT* pMain);

static void TMap_BoardMsgSet(TMAP_MAIN_DAT* pMain,TMAP_GDAT* pBlock,int zoneID);
static void TMap_BoardGraphicOff(TMAP_MAIN_DAT* pMain);
static void TMap_GuideTagSet(TMAP_MAIN_DAT* pMain,GF_BGL_BMPWIN* win);
static void TMapN_BmpWinSet(TMAP_MAIN_DAT* pMain);
static void TMapN_BmpWinExit(TMAP_MAIN_DAT* pMain);
static void TMapN_SubButtonSet(TMAP_MAIN_DAT* pMain,u8 frm,u8 mode);
static void TMapN_2DGrapDefSet(TMAP_MAIN_DAT* pMain);
static void TMapN_2DGrapClear(TMAP_MAIN_DAT* pMain);
static void TMapN_CellActSet(TMAP_MAIN_DAT* pMain);
static void TMapN_FootViewInit(TMAP_MAIN_DAT* pMain);
static void TMapN_FootViewRelease(TMAP_MAIN_DAT* pMain);

static void TMapN_CheckKeyCursor(TMAP_MAIN_DAT* pMain,int key);
static void TMapN_ZoneNameWrite(TMAP_MAIN_DAT* pMain,GF_BGL_BMPWIN* win,int zoneID);
static void TMapN_BlockExpWrite(TMAP_MAIN_DAT *pMain,GF_BGL_BMPWIN* win,TMAP_GDAT* pBlock);
static void TMapN_BlockChange(TMAP_MAIN_DAT* pMain);
static void TMapN_BlockReset(TMAP_MAIN_DAT* pMain);
static void TMapN_CursorDrawUp(TMAP_MAIN_DAT* pMain);
static void TMapN_SubScrollSet(TMAP_MAIN_DAT* pMain,int x,int y);
static int TMapNS_SubViewForcusIn(TMAP_MAIN_DAT* pMain);
static int TMapNS_SubViewForcusOut(TMAP_MAIN_DAT* pMain);

static int TMapJ_CheckJumpPos(TMAP_MAIN_DAT* pMain);

/**
 *	@brief	m[}[h
 */
int	TMapNormal_Init(TMAP_MAIN_DAT* pMain)
{
	TMAP_MODE_NORMAL* wk;

	pMain->pSwork = sys_AllocMemory(pMain->heapID,sizeof(TMAP_MODE_NORMAL));
	wk = (TMAP_MODE_NORMAL*)pMain->pSwork;
	memset(wk,0,sizeof(TMAP_MODE_NORMAL));

	return TMAP_SEQ_FINISH;	
}

/**
 *	@brief	m[}[h
 */
int TMapNormal_Release(TMAP_MAIN_DAT *pMain)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;

	//r[NA
	TMapN_2DGrapClear(pMain);
	TMapN_FootViewRelease(pMain);
	TownViewDataRelease(pMain,wk->pTView);
	TMapN_BmpWinExit(pMain);
	sys_FreeMemoryEz(wk);
	return TMAP_SEQ_FINISH;	
}

/**
 *	@brief	m[}[hf[^\z
 */
int	TMapNormal_Build(TMAP_MAIN_DAT* pMain)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;
	
	switch(wk->seq){
	case 0:
		//C̃f[^p
		wk->cposX = pMain->cposX;
		wk->cposZ = pMain->cposZ;
		wk->czoneID = -1;	//_~[l
		//TuʃJ[\ʒu`
		wk->scrBGS0.scrX = (wk->cposX*TMAP_SBLOCK_UNIT+8)	- 128+16;
		wk->scrBGS0.scrY = (wk->cposZ*TMAP_SBLOCK_UNIT)	- 96;

		TMapN_SubScrollSet(pMain,wk->scrBGS0.scrX,wk->scrBGS0.scrY);

		//BmpEBhE
		TMapN_BmpWinSet(pMain);
		
		//Ճ}[N
		TMapN_FootViewInit(pMain);
		break;
	case 1:
		//2DGrapSet
		TMapN_2DGrapDefSet(pMain);

		//ZAN^[ǉ
		TMapN_CellActSet(pMain);
		
		//^EView쐬
		wk->pTView = TownViewDataCreate(pMain,TOWNV_TYPE_MAX,TOWN_VIEW_MAX);
	
		TMapN_BlockReset(pMain);
		TMapN_BlockChange(pMain);
		wk->seq = 0;
		return TMAP_SEQ_FINISH;
	}
	wk->seq++;
	return TMAP_SEQ_CONTINUE;
}


/**
 *	@brief	m[}[hL[擾
 */
int	TMapNormal_KeyIn(TMAP_MAIN_DAT* pMain)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;
	int	bgs0_X = 0,bgs0_Y = 0;
	
	if(sys.trg & PAD_BUTTON_DECIDE){
		Snd_SePlay(SEQ_SE_DP_DECIDE);
		return TMAP_SEQ_FINISH;	
	}

	TMapN_CheckKeyCursor(pMain,sys.game_cont);

	return TMAP_SEQ_CONTINUE;
}

/**
 *	@brief	Wv[hL[擾	L[EFCg[h
 */
int	TMapJump_KeyWait(TMAP_MAIN_DAT* pMain)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;
	int	bgs0_X = 0,bgs0_Y = 0;
	
	if(sys.trg & PAD_BUTTON_DECIDE){
		if(TMapJ_CheckJumpPos(pMain)){
			Snd_SePlay(SEQ_SE_DP_DECIDE);
			return TMAP_SEQ_FINISH;
		}
		return TMAP_SEQ_CONTINUE;
	}

	TMapN_CheckKeyCursor(pMain,sys.game_cont);
	return TMAP_SEQ_CONTINUE;
}

/**
 *	@brief	m[}[h@CRg[
 *	@param	pMain TMAP_MAIN_DATւ̃|C^
 */
int TMapNormal_Main(TMAP_MAIN_DAT* pMain)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;
	
	if(wk->view_f & VIEW_UP){
		//ubNXV
		if(wk->guide_f >= 2){
			TMapN_BlockChange(pMain);
			wk->view_f = VIEW_CLEAR;
			wk->repeat_f = 0;
			wk->guide_f = 0;
		}
#if 0
		else if(wk->forcus == TMAPN_FORCUS_SUB && wk->guide_f == 1){
			TMapN_BlockExpWrite(pMain,&(wk->win[WIN_BLOCK]),NULL);
			TMap_BoardMsgSet(pMain,NULL,wk->czoneID);		
		}
#endif
	}else if(wk->forcus == TMAPN_FORCUS_SUB && wk->repeat_f == 1){
		TMapN_BlockExpWrite(pMain,&(wk->win[WIN_BLOCK]),NULL);
		TMap_BoardMsgSet(pMain,NULL,wk->czoneID);		
	}

	TMapN_CursorDrawUp(pMain);
	TownViewDataDraw(pMain,wk->pTView);
	
	switch(wk->seq){
	case TM_N_KEYWAIT:
		break;
	case TM_N_FADEOUT:
		if(!TMapNS_SubViewForcusIn(pMain)){
			return TMAP_SEQ_CONTINUE;
		}
		wk->seq = TM_N_KEYWAIT;
		break;
	case TM_N_FADEINWAIT:
		break;
	case TM_N_FADEIN:
		if(!TMapNS_SubViewForcusOut(pMain)){
			return TMAP_SEQ_CONTINUE;
		}
		wk->seq = TM_N_KEYWAIT;
		break;
	case TM_N_FADEOUTWAIT:
		break;
	}
	return TMAP_SEQ_CONTINUE;
}

/**
 *	@brief	Wv[h@CRg[
 *	@param	pMain TMAP_MAIN_DATւ̃|C^
 */
int TMapJump_Main(TMAP_MAIN_DAT* pMain)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;

	switch(wk->seq){
	case TMAPJ_KEYWAIT:
		break;
	case TMAPJ_SELINIT:
		break;
	default:
		return TMAP_SEQ_CONTINUE;
	}
	if(wk->view_f & VIEW_UP){
		//ubNXV
		if(wk->guide_f >= 2){
			TMapN_BlockChange(pMain);
			wk->view_f = VIEW_CLEAR;
			wk->repeat_f = 0;
			wk->guide_f = 0;
		}
#if 0
		else if(wk->forcus == TMAPN_FORCUS_SUB && wk->guide_f == 1){
			TMapN_BlockExpWrite(pMain,&(wk->win[WIN_BLOCK]),NULL);
			TMap_BoardMsgSet(pMain,NULL,wk->czoneID);		
		}
#endif
	}else if(wk->forcus == TMAPN_FORCUS_SUB && wk->repeat_f == 1){
		TMapN_BlockExpWrite(pMain,&(wk->win[WIN_BLOCK]),NULL);
		TMap_BoardMsgSet(pMain,NULL,wk->czoneID);		
	}
	TMapN_CursorDrawUp(pMain);
	
	return TMAP_SEQ_CONTINUE;
}

/**
 *	@brief	m[}[h@DrawV[PX
 *	@param	pMain TMAP_MAIN_DATւ̃|C^
 */
int TMapNormal_Draw(TMAP_MAIN_DAT* pMain)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;
	TMAP_FVIEW *wp;
	int i;

	//Օ`
	for(i = 0;i < wk->fView.num;i++){
		wp = &(wk->fView.foot[i]);
	}

	TownViewDataDraw(pMain,wk->pTView);
	return TMAP_SEQ_CONTINUE;
}

/**
 *	@brief	Ŕt[ VBlank]
 *	@param	pMain TMAP_MAIN_DATւ̃|C^
 */
int TMapNormal_VBlank(TMAP_MAIN_DAT* pMain)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;
	GF_BGL_BMPWIN* win = &wk->win[WIN_BOARD];
	TMAP_GDAT* pBlock = pMain->vb_block;
	int	zoneID = pMain->vb_zoneID;

	u32	siz;
	GF_PRINTCOLOR col;
	STRCODE name[BUFLEN_PLACE_NAME];

	if(!pMain->vb_trans){
		return TMAP_SEQ_CONTINUE;
	}
	//tOOff
	pMain->vb_trans = 0;

	//
	if(pBlock == NULL){
		//ubNf[^
		TMap_BoardGraphicOff(pMain);
		return TMAP_SEQ_CONTINUE;
	}

	STRBUF_Clear(pMain->placeName);
	GetPlaceNameFromZoneIDNew(zoneID,pMain->heapID,pMain->placeName);
	
	BoardWinGraphicSet(	pMain->bgl,
			BMPL_BOARD_FRM,BMPW_BOARD_CGX,BMPL_BOARD_PAL,
			pBlock->kType, pBlock->kIdx,pMain->heapID);

	BmpBoardWinWrite(win, WINDOW_TRANS_OFF,
			BMPW_BOARD_CGX,BMPL_BOARD_PAL,BOARD_TYPE_TOWN);
	
	GF_BGL_BmpWinDataFill(win,FBMP_COL_WHITE);
	GF_STR_PrintSimple(	win,
					FONT_TALK,
					pMain->placeName,
					0,0,
					MSG_NO_PUT,
					NULL );

	GF_BGL_BmpWinOn(win);
	return TMAP_SEQ_CONTINUE;
}
/**
 *	@brief	^b`pl`FbN
 */
static int TMapNS_TPCheck(TMAP_MAIN_DAT* pMain,int mode)
{
	int ret;
	u16 pat;
	static const RECT_HIT_TBL TMapN_TpRect[] = {
		{0,191,0,255},
		{TMSCR_DSWMB_DPY*8,TMSCR_DSWMB_DEY*8,TMSCR_DSWMB_DPX*8,TMSCR_DSWMB_DEX*8},
		{RECT_HIT_END,0,0,0}
	};
	
	ret = GF_TP_RectHitCont(&(TMapN_TpRect[1-mode]));
	if(ret == RECT_HIT_NONE || mode == TMAPN_FORCUS_SUB){
		return ret;
	}
	pat = 0x0012;	//0000 0000 0001 0010	pbgbit
	if(GF_BGL_DotCheck(pMain->bgl,GF_BGL_FRAME1_S,sys.tp_x,sys.tp_y,&pat) == FALSE){
		return ret;
	}
	return RECT_HIT_NONE;
}

/**
 *	@brief	J[\ړL[`FbN
 */
static void TMapN_CheckKeyCursor(TMAP_MAIN_DAT* pMain,int key)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;

	if(wk->key_f){
		if(!(key & (PAD_KEY_UP|PAD_KEY_DOWN|PAD_KEY_RIGHT|PAD_KEY_LEFT))){
			if(wk->guide_f == 1){	//ςȂ`FbN
				++wk->guide_f;
			}
		}
		return;	//J[\ړ
	}
	if(GF_TP_GetCont()){
		if(wk->tp_f == 0 && TMapNS_TPCheck(pMain,wk->forcus) != RECT_HIT_NONE){
			if(wk->forcus == TMAPN_FORCUS_MAIN){
				wk->key_f |= (KEYS_SCHANGE | KEYS_FREEZE);
				wk->seq = TM_N_FADEOUT;
			}else{
				wk->key_f |= (KEYS_SCHANGE | KEYS_FREEZE);
				wk->seq = TM_N_FADEIN;
			}
			wk->tp_f = 1;
			Snd_SePlay(SEQ_SE_DP_BAG_004);
			return;
		}
	}else{
		wk->tp_f = 0;
	}
	if(!(key & (PAD_KEY_UP|PAD_KEY_DOWN|PAD_KEY_RIGHT|PAD_KEY_LEFT))){
		if(wk->guide_f == 1){
			++wk->guide_f;
		}
		return;
	}
	if(key & PAD_KEY_UP){
		if(wk->cposZ >= CMOVE_MINZ){
			wk->cposZ -= 1;
			wk->key_f |= KEYS_CMOVE_MZ;
		}
	}
	if(key & PAD_KEY_DOWN){
		if(wk->cposZ <= CMOVE_MAXZ){
			wk->cposZ += 1;
			wk->key_f |= KEYS_CMOVE_PZ;
		}
	}
	if(key & PAD_KEY_RIGHT){
		if(wk->cposX <= CMOVE_MAXX){
			wk->cposX += 1;
			wk->key_f |= KEYS_CMOVE_PX;
		}
	}
	if(key & PAD_KEY_LEFT){
		if(wk->cposX >= CMOVE_MINX){
			wk->cposX -= 1;
			wk->key_f |= KEYS_CMOVE_MX;
		}
	}
	wk->cmove_f = CMOVE_COUNT;
	wk->key_f |= KEYS_FREEZE;	//L[tbN

	if(wk->view_f != 0){
		wk->repeat_f++;
	}else{
		wk->repeat_f = 0;
	}
	wk->view_f = 0;
	wk->guide_f = 1;
//	Snd_SePlay(SEQ_SE_DP_BAG_006);
	return;
}

/**
 *	@brief	J[\ړubN؂ւ
 */
static void TMapN_BlockChange(TMAP_MAIN_DAT* pMain)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;
	
	//n\
	TMapN_ZoneNameWrite(
		pMain,&(wk->win[WIN_M01]),wk->czoneID);
	
	//ԃ|WV`FbN
	TownViewDataSelectPos(wk->pTView,wk->czoneID);
	
	if(wk->forcus == TMAPN_FORCUS_SUB){
		//ubN
		TMapN_BlockExpWrite(pMain,&(wk->win[WIN_BLOCK]),wk->pBlock);
		TMap_BoardMsgSet(pMain,wk->pBlock,wk->czoneID);
	}
	GF_BGL_LoadScreenV_Req(pMain->bgl,GF_BGL_FRAME0_S);
	GF_BGL_LoadScreenV_Req(pMain->bgl,GF_BGL_FRAME1_S);
}

/**
 *	@brief	J[\ړubN؂ւ
 */
static void TMapN_BlockReset(TMAP_MAIN_DAT* pMain)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;
	
	//݂̃][擾
	wk->ozoneID = wk->czoneID;
	wk->czoneID = GetFieldMatrixZoneID((FMZ_CONST_PTR)pMain->pZone,wk->cposX,wk->cposZ);

	//݂̃ubNf[^擾
	wk->pBlock = TMapBlockDataGet(pMain->pBDat,wk->cposX,wk->cposZ,pMain->mapView);
}

/**
 *	@brief	][̕\֐
 *
 */
static void TMapN_ZoneNameWrite(TMAP_MAIN_DAT *pMain,GF_BGL_BMPWIN* win,int zoneID)
{
	u32	siz;
	GF_PRINTCOLOR col;
	
	STRBUF_Clear(pMain->placeName);
	
	GF_BGL_BmpWinDataFill(win,0);
	col = GF_PRINTCOLOR_MAKE(1,2,0);
	if(zoneID >= 0){
		GetPlaceNameFromZoneIDNew(zoneID,pMain->heapID,pMain->placeName);

		if(pMain->mode == TMAP_MJUMP){
			siz = BMPL_M01_NSX;
		}else{
			siz = (BMPL_M01_SX*8)-FontProc_GetPrintStrWidth(FONT_SYSTEM,pMain->placeName,0);
			siz/=2;
		}
		GF_STR_PrintColor(	win,
							FONT_SYSTEM,
							pMain->placeName,
							siz,BMPL_M01_WINY,
							MSG_NO_PUT,
							col,
							NULL );
	}

	//ǂ֔т܂H
	if(pMain->mode == TMAP_MJUMP){
		STRBUF* buf_q = MSGMAN_AllocString(pMain->pMsgTMap,mes_townmap_01_01);
		GF_STR_PrintColor(	win,
							FONT_SYSTEM,
							buf_q,
							0,BMPL_M01_WINY,
							MSG_ALLPUT,
							col,
							NULL );
		STRBUF_Delete(buf_q);
	}

	GF_BGL_BmpWinOn(win);
}

/**
 *	@brief	ubN̕\֐
 *
 */
static void TMapN_BlockExpWrite(TMAP_MAIN_DAT *pMain,GF_BGL_BMPWIN* win,TMAP_GDAT* pBlock)
{
	u32	siz;
	GF_PRINTCOLOR col;
	STRBUF *ex1;
	STRBUF *ex2;
	if(pBlock == NULL){
		//EBhENA
		GF_BGL_BmpWinOff(win);
		return;
	}
	
	ex1 = MSGMAN_AllocString(pMain->pMsgTMap,pBlock->gmes01);
	ex2 = MSGMAN_AllocString(pMain->pMsgTMap,pBlock->gmes02);

	col = GF_PRINTCOLOR_MAKE(1,2,0);
	
	GF_BGL_BmpWinDataFill(win,0);
	GF_STR_PrintColor(	win,
						FONT_SYSTEM,
						ex1,
						pBlock->gmes01_ox,pBlock->gmes01_oy,
						MSG_NO_PUT,
						col,
						NULL );
	GF_STR_PrintColor(	win,
						FONT_SYSTEM,
						ex2,
						pBlock->gmes02_ox,pBlock->gmes02_oy,
						MSG_ALLPUT,
						col,
						NULL );
	GF_BGL_BmpWinOn(win);

	STRBUF_Delete(ex2);
	STRBUF_Delete(ex1);
}
/**
 *	@brief	J[\̕`ꏊXV
 */
static void TMapN_CursorDrawUp(TMAP_MAIN_DAT* pMain)
{
	int	dif = SUBSCR_MOVE_UNIT;
	TMAP_MODE_NORMAL* wk = pMain->pSwork;
	
	if(!wk->cmove_f){
		return;
	}
	if(wk->cmove_f-- == CMOVE_COUNT){
		//J[\ړ
		CATS_ObjectPosSet(wk->pCAW_cur,
				wk->cposX*CMOVE_UNIT+CMOVE_OFSX,
				wk->cposZ*CMOVE_UNIT+CMOVE_OFSZ);
		CLACT_AnmFrameChg(wk->pCAW_cur,FX32_ONE);	//Ajp^[Zbg

		//ubNf[^Zbg
		TMapN_BlockReset(pMain);

		//ʃ][\Cg
		TMapN_ZoneNameWrite(
			pMain,&(wk->win[WIN_M01]),
			GetFieldMatrixZoneID((FMZ_CONST_PTR)pMain->pZone,wk->cposX,wk->cposZ));
		dif += 1;
	}
	
	if(wk->key_f & KEYS_CMOVE_MZ){
		wk->scrBGS0.scrY -= dif;
	}
	if(wk->key_f & KEYS_CMOVE_PZ){
		wk->scrBGS0.scrY += dif;
	}
	if(wk->key_f & KEYS_CMOVE_PX){
		wk->scrBGS0.scrX += dif;
	}
	if(wk->key_f & KEYS_CMOVE_MX){
		wk->scrBGS0.scrX -= dif;
	}
	TMapN_SubScrollSet(pMain,wk->scrBGS0.scrX,wk->scrBGS0.scrY);

	if(wk->cmove_f > 0){
		return;
	}
	wk->view_f = VIEW_UP;	//viewXV
	wk->key_f = 0;	//L[tbN

	if(wk->ozoneID != wk->czoneID){
		TownViewDataSelectPos(wk->pTView,-1);
	}
}

/**
 *	@brief	Ŕt[bZ[W\
 *	@param	pMain TMAP_MAIN_DATւ̃|C^
 */
static void TMap_BoardMsgSet(TMAP_MAIN_DAT* pMain,TMAP_GDAT* pBlock,int zoneID)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;
	GF_BGL_BMPWIN* win = &wk->win[WIN_BOARD];
	
	u32	siz;
	GF_PRINTCOLOR col;
	STRBUF *name;

	//p[^ۑ(ۂ̍XVVBlankɍs)
	pMain->vb_zoneID = zoneID;
	pMain->vb_block = pBlock;
	pMain->vb_trans = 1;
	return;
}

/**
 *	@brief	Ŕt[\Off
 *	@param	pMain TMAP_MAIN_DATւ̃|C^
 */
static void TMap_BoardGraphicOff(TMAP_MAIN_DAT* pMain)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;
	GF_BGL_BMPWIN	*win = &wk->win[WIN_BOARD];

	GF_BGL_BmpWinDataFill(win,FBMP_COL_NULL);
	GF_BGL_BmpWinOff(win);
	
	BmpBoardWinClear(win,BOARD_TYPE_TOWN,WINDOW_TRANS_ON);
	GF_BGL_LoadScreenV_Req(pMain->bgl,BMPL_BOARD_FRM);
}


/**
 *	@brief	KCh^O\
 *	@param	pMain TMAP_MAIN_DATւ̃|C^
 */
static void TMap_GuideTagSet(TMAP_MAIN_DAT* pMain,GF_BGL_BMPWIN* win)
{
	u32	siz;
	GF_PRINTCOLOR col;
	STRBUF *buf;

	//BG`
	GF_BGL_ScrWriteFree(pMain->bgl,GF_BGL_FRAME1_S,
			TMSCR_DSWMG_DPX,TMSCR_DSWMG_DPY,TMSCR_DSWMG_DSX,TMSCR_DSWMG_DSY,
			pMain->pScr02_dswm->rawData,
			TMSCR_DSWMG_SPX,TMSCR_DSWMG_SPY,
			pMain->pScr02_dswm->screenWidth/8,pMain->pScr02_dswm->screenHeight/8);

	//bZ[W`
	buf = MSGMAN_AllocString(pMain->pMsgTMap,mes_townmap_02_01);

	siz = BMPL_GUIDE_NSX-FontProc_GetPrintStrWidth( FONT_SYSTEM,buf, 0 );
	siz/=2;
	
	col = GF_PRINTCOLOR_MAKE(1,2,0);
	GF_BGL_BmpWinDataFill(win,FBMP_COL_NULL);
	GF_STR_PrintColor(	win,
						FONT_SYSTEM,
						buf,
						siz,0,
						MSG_ALLPUT,
						col,
						NULL );
	GF_BGL_BmpWinOn(win);

	STRBUF_Delete(buf);
}

/**
 *	@brief	BmpWindow
 *	@param	pMain TMAP_MAIN_DATւ̃|C^
 */
static void TMapN_BmpWinSet(TMAP_MAIN_DAT* pMain)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;

	GF_BGL_BmpWinAdd(
		pMain->bgl, &wk->win[WIN_M01], BMPL_M01_FRM,
		BMPL_M01_PX, BMPL_M01_PY, BMPL_M01_SX, BMPL_M01_SY, BMPL_M01_PAL, BMPL_M01_CGX );
	
	GF_BGL_BmpWinAdd(
		pMain->bgl, &wk->win[WIN_BOARD], BMPL_BOARD_FRM,
		BMPL_BOARD_PX, BMPL_BOARD_PY, BMPL_BOARD_SX, BMPL_BOARD_SY, BMPL_BOARD_PAL, BMPL_BOARD_CGX );

	GF_BGL_BmpWinAdd(
		pMain->bgl, &wk->win[WIN_BLOCK], BMPL_BLOCK_FRM,
		BMPL_BLOCK_PX, BMPL_BLOCK_PY, BMPL_BLOCK_SX, BMPL_BLOCK_SY, BMPL_BLOCK_PAL, BMPL_BLOCK_CGX );

	GF_BGL_BmpWinAdd(
		pMain->bgl, &wk->win[WIN_GUIDE], BMPL_GUIDE_FRM,
		BMPL_GUIDE_PX, BMPL_GUIDE_PY, BMPL_GUIDE_SX, BMPL_GUIDE_SY, BMPL_GUIDE_PAL, BMPL_GUIDE_CGX );

	//EBhENA
	GF_BGL_BmpWinDataFill(&(wk->win[WIN_M01]),0);
	GF_BGL_BmpWinDataFill(&(wk->win[WIN_BOARD]),0);
	GF_BGL_BmpWinDataFill(&(wk->win[WIN_BLOCK]),0);
	GF_BGL_BmpWinDataFill(&(wk->win[WIN_GUIDE]),0);
	GF_BGL_BmpWinOn(&wk->win[WIN_M01]);

	GF_BGL_BmpWinOff(&wk->win[WIN_BOARD]);
	GF_BGL_BmpWinOff(&wk->win[WIN_BLOCK]);
	GF_BGL_BmpWinOff(&wk->win[WIN_GUIDE]);

}

/**
 *	@brief	BmpWindow
 *	@param	pMain TMAP_MAIN_DATւ̃|C^
 */
static void TMapN_BmpWinExit(TMAP_MAIN_DAT* pMain)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;
	u16	i;
	for(i = 0;i < WIN_MAX;i++){
		GF_BGL_BmpWinDel(&wk->win[i]);
	}
}

/**
 *	@brief	{^XN[`
 *
 *	@param	pMain	TMAP_MAIN_DAT*
 *	@param	frm		Ajt[No
 *	@param	mode	obNނǂ̃tO(ނƂOn)
 */
static void TMapN_SubButtonSet(TMAP_MAIN_DAT* pMain,u8 frm,u8 mode)
{
	if(mode){
		GF_BGL_ScrWriteExpand(pMain->bgl,GF_BGL_FRAME1_S,
			0,0,32,24,
			pMain->pScr02_sw->rawData,
			0,0,
			pMain->pScr02_sw->screenWidth/8,pMain->pScr02_sw->screenHeight/8);
	}
	GF_BGL_ScrWriteFree(pMain->bgl,GF_BGL_FRAME1_S,
		TMSCR_DSWMB_DPX,TMSCR_DSWMB_DPY,TMSCR_DSWMB_DSX,TMSCR_DSWMB_DSY,
		pMain->pScr02_dswm->rawData,
		frm*TMSCR_DSWMB_DSX+TMSCR_DSWMB_SPX,TMSCR_DSWMB_SPY,
		pMain->pScr02_dswm->screenWidth/8,pMain->pScr02_dswm->screenHeight/8);
}

/**
 *	@brief	zz}bv`@Tu[`
 *	
 */
	typedef struct _HMAP{
		u8	dpx,dpy;
		u8	px,py;
		u8	sx,sy;
	}HMAP;
	
static void TMap_HaifuMapSet(TMAP_MAIN_DAT* pMain,int mode)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;

	static const HMAP hmap[] = {
		{HMAP01_MB_DPX,HMAP01_MB_DPY,HMAP01_MB_PX,HMAP01_MB_PY,HMAP01_MB_SX,HMAP01_MB_SY},
		{HMAP01_ML_DPX,HMAP01_ML_DPY,HMAP01_ML_PX,HMAP01_ML_PY,HMAP01_ML_SX,HMAP01_ML_SY},
		
		{HMAP02_MB_DPX,HMAP02_MB_DPY,HMAP02_MB_PX,HMAP02_MB_PY,HMAP02_MB_SX,HMAP02_MB_SY},
		{HMAP02_ML_DPX,HMAP02_ML_DPY,HMAP02_ML_PX,HMAP02_ML_PY,HMAP02_ML_SX,HMAP02_ML_SY},
	};
	HMAP* mback,*mload,*sback,*sload;

	mback = (HMAP*)&(hmap[mode*2+0]);
	mload = (HMAP*)&(hmap[mode*2+1]);
	sback = (HMAP*)&(hmap[mode*2+0]);
	sload = (HMAP*)&(hmap[mode*2+1]);

	GF_BGL_ScrWriteExpand(pMain->bgl,GF_BGL_FRAME2_M,
			mload->px,mload->py,mload->sx,mload->sy,
			pMain->pScr01_dis->rawData,
			mload->dpx,mload->dpy,SCWS_GET(pMain->pScr01_dis),SCHS_GET(pMain->pScr01_dis));	

	//wi}bv
	GF_BGL_ScrWriteExpand(pMain->bgl,GF_BGL_FRAME3_M,
			mback->px,mback->py,mback->sx,mback->sy,
			pMain->pScr01_dis->rawData,
			mback->dpx,mback->dpy,SCWS_GET(pMain->pScr01_dis),SCHS_GET(pMain->pScr01_dis));	
#if 0		
	GF_BGL_ScrWriteFree(pMain->bgl,GF_BGL_FRAME2_S,
			sload->px,sload->py,sload->sx,sload->sy,pMain->pScr02_dr->rawData,
			sload->dpx,sload->dpy,pMain->pScr02_dr->screenWidth/8,pMain->pScr02_dr->screenHeight/8);
	GF_BGL_ScrWriteFree(pMain->bgl,GF_BGL_FRAME3_S,
			sback->px,sback->py,sback->sx,sback->sy,pMain->pScr02_dm->rawData,
			sback->dpx,sback->dpy,pMain->pScr02_dm->screenWidth/8,pMain->pScr02_dm->screenHeight/8);
#endif
}

/**
 *	@brief m[}[h@BGf[^Zbg
 */
static void TMapN_2DGrapDefSet(TMAP_MAIN_DAT* pMain)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;
	int sp = 0;
	
	//[h
	GF_BGL_ScrWriteExpand(pMain->bgl,GF_BGL_FRAME2_M,
			0,0,32,24,
			pMain->pScr01->rawData,
			0,0,SCWS_GET(pMain->pScr01),SCHS_GET(pMain->pScr01));	

	//wi}bv
	GF_BGL_ScrWriteExpand(pMain->bgl,GF_BGL_FRAME3_M,
			0,0,32,24,
			pMain->pScr01_back->rawData,
			0,0,SCWS_GET(pMain->pScr01_back),SCHS_GET(pMain->pScr01_back));	
	
	if(pMain->mode == TMAP_MNORMAL){
		sp = ZONEN_BG_SY;
		GF_BGL_ScrWriteExpand(pMain->bgl,GF_BGL_FRAME3_M,
				ZONEN_BG_PX,ZONEN_BG_PY,ZONEN_BG_SX,ZONEN_BG_SY,
				pMain->pScr01_back->rawData,
				0,ZONEN_BG_PY,SCWS_GET(pMain->pScr01_back),SCHS_GET(pMain->pScr01_back));	
	}
	
	//Tu
	TMapN_SubButtonSet(pMain,0,1);
	
	GF_BGL_ScrWriteFree(pMain->bgl,GF_BGL_FRAME2_S,0,0,64,64,pMain->pScr02_dr->rawData,
			0,0,pMain->pScr02_dr->screenWidth/8,pMain->pScr02_dr->screenHeight/8);
	GF_BGL_ScrWriteFree(pMain->bgl,GF_BGL_FRAME3_S,0,0,64,64,pMain->pScr02_dm->rawData,
			0,0,pMain->pScr02_dm->screenWidth/8,pMain->pScr02_dm->screenHeight/8);

	//zz}bv̕`
	if(pMain->mapView | 0x0001){	//zz}bv1
		TMap_HaifuMapSet(pMain,0);
	}
	if(pMain->mapView | 0x0002){	//zz}bv2
		TMap_HaifuMapSet(pMain,1);
	}
	if(pMain->mapView | 0x0004){	//zz}bv3
		;	
	}
	
	GF_BGL_LoadScreenV_Req(pMain->bgl,GF_BGL_FRAME2_M);
	GF_BGL_LoadScreenV_Req(pMain->bgl,GF_BGL_FRAME3_M);
	GF_BGL_LoadScreenV_Req(pMain->bgl,GF_BGL_FRAME1_S);
	GF_BGL_LoadScreenV_Req(pMain->bgl,GF_BGL_FRAME2_S);
	GF_BGL_LoadScreenV_Req(pMain->bgl,GF_BGL_FRAME3_S);
}

static void TMapN_2DGrapClear(TMAP_MAIN_DAT* pMain)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;

	//XN[Zbg
	GF_BGL_ScrollSet(pMain->bgl,GF_BGL_FRAME2_S,GF_BGL_SCROLL_Y_SET,0);
	GF_BGL_ScrollSet(pMain->bgl,GF_BGL_FRAME3_S,GF_BGL_SCROLL_Y_SET,0);
	GF_BGL_ScrollSet(pMain->bgl,GF_BGL_FRAME2_S,GF_BGL_SCROLL_X_SET,0);
	GF_BGL_ScrollSet(pMain->bgl,GF_BGL_FRAME3_S,GF_BGL_SCROLL_X_SET,0);
	
	GF_BGL_ScrFill(pMain->bgl,GF_BGL_FRAME0_M,0x0000,0,0,32,32,GF_BGL_SCRWRT_PALIN);
	GF_BGL_ScrFill(pMain->bgl,GF_BGL_FRAME1_M,0x0000,0,0,32,32,GF_BGL_SCRWRT_PALIN);
	GF_BGL_ScrFill(pMain->bgl,GF_BGL_FRAME2_M,0x0000,0,0,32,32,GF_BGL_SCRWRT_PALIN);
	GF_BGL_ScrFill(pMain->bgl,GF_BGL_FRAME3_M,0x0000,0,0,32,32,GF_BGL_SCRWRT_PALIN);
	GF_BGL_ScrFill(pMain->bgl,GF_BGL_FRAME0_S,0x0000,0,0,32,32,GF_BGL_SCRWRT_PALIN);
	GF_BGL_ScrFill(pMain->bgl,GF_BGL_FRAME1_S,0x0000,0,0,32,32,GF_BGL_SCRWRT_PALIN);
	GF_BGL_ScrFill(pMain->bgl,GF_BGL_FRAME2_S,0x0000,0,0,32,32,GF_BGL_SCRWRT_PALIN);
	GF_BGL_ScrFill(pMain->bgl,GF_BGL_FRAME3_S,0x0000,0,0,32,32,GF_BGL_SCRWRT_PALIN);
	
	GF_BGL_LoadScreenV_Req(pMain->bgl,GF_BGL_FRAME0_M);
	GF_BGL_LoadScreenV_Req(pMain->bgl,GF_BGL_FRAME1_M);
	GF_BGL_LoadScreenV_Req(pMain->bgl,GF_BGL_FRAME2_M);
	GF_BGL_LoadScreenV_Req(pMain->bgl,GF_BGL_FRAME3_M);
	
	GF_BGL_LoadScreenV_Req(pMain->bgl,GF_BGL_FRAME0_S);
	GF_BGL_LoadScreenV_Req(pMain->bgl,GF_BGL_FRAME1_S);
	GF_BGL_LoadScreenV_Req(pMain->bgl,GF_BGL_FRAME2_S);
	GF_BGL_LoadScreenV_Req(pMain->bgl,GF_BGL_FRAME3_S);
}

/**
 *	@brief m[}[h@AN^[Zbg
 */
static const TCATS_OBJECT_ADD_PARAM	ActAddParam[] =
{
	{	// {^GtFNg
		0,	//ID
		0, 0, 0,	//x,y,z
		0, TMAP_SPRI_BTN, 0, NNS_G2D_VRAM_TYPE_2DSUB,	//anmNO,pri,pal,d_area
		0, 0, 0, 0	//prm1,prm2,prm3,prm4
	},
	{	// CJ[\ 
		1,
		0, 0, 0,
		0, TMAP_SPRI_CUR, 0, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// C@ 
		2,
		0, 0, 0,
		0, TMAP_SPRI_HERO, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
};

static void TMapN_CellActSet(TMAP_MAIN_DAT* pMain)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;

	//Tuʗp{^
	wk->pCAW_btn =	CATS_ObjectAdd( pMain->pCActSys,
			pMain->pCActRes,
			&ActAddParam[0] );

	CLACT_SetDrawFlag(wk->pCAW_btn, 0 );
	CLACT_SetAnmFrame(wk->pCAW_btn,FX32_ONE);
	CATS_ObjectPosSet(wk->pCAW_btn,128,104);

	//CJ[\
	wk->pCAW_cur =	CATS_ObjectAdd( pMain->pCActSys,
			pMain->pCActRes,
			&ActAddParam[1] );

	CLACT_SetDrawFlag(wk->pCAW_cur, 1 );
	CLACT_SetAnmFrame(wk->pCAW_cur,FX32_CONST(2));
	CLACT_SetAnmFlag(wk->pCAW_cur,1);
	CATS_ObjectPosSet(wk->pCAW_cur,
			wk->cposX*CMOVE_UNIT+CMOVE_OFSX,wk->cposZ*CMOVE_UNIT+CMOVE_OFSZ);

	//C@
	wk->pCAW_hero = CATS_ObjectAdd( pMain->pCActSys,
			pMain->pCActRes,
			&ActAddParam[2]);

	CLACT_SetDrawFlag(wk->pCAW_hero,1);
	CLACT_SetAnmFrame(wk->pCAW_hero,pMain->param->player_sex);
	CATS_ObjectPosSet(wk->pCAW_hero,
			wk->cposX*CMOVE_UNIT+CMOVE_OFSX,wk->cposZ*CMOVE_UNIT+CMOVE_OFSZ);
}

/**
 *	@brief	m[}[hTuʃXN[lZbg	
 */
static void TMapN_SubScrollSet(TMAP_MAIN_DAT* pMain,int x,int y)
{
	if(x < TMAPN_BGS0X_MIN){
		GF_BGL_ScrollReq(pMain->bgl,GF_BGL_FRAME2_S,GF_BGL_SCROLL_X_SET,TMAPN_BGS0X_MIN);
		GF_BGL_ScrollReq(pMain->bgl,GF_BGL_FRAME3_S,GF_BGL_SCROLL_X_SET,TMAPN_BGS0X_MIN);
	}else if(x > TMAPN_BGS0X_MAX){
		GF_BGL_ScrollReq(pMain->bgl,GF_BGL_FRAME2_S,GF_BGL_SCROLL_X_SET,TMAPN_BGS0X_MAX);
		GF_BGL_ScrollReq(pMain->bgl,GF_BGL_FRAME3_S,GF_BGL_SCROLL_X_SET,TMAPN_BGS0X_MAX);
	}else{
		GF_BGL_ScrollReq(pMain->bgl,GF_BGL_FRAME2_S,GF_BGL_SCROLL_X_SET,x);
		GF_BGL_ScrollReq(pMain->bgl,GF_BGL_FRAME3_S,GF_BGL_SCROLL_X_SET,x);
	}
	
	if(y < TMAPN_BGS0Y_MIN){
		GF_BGL_ScrollReq(pMain->bgl,GF_BGL_FRAME2_S,GF_BGL_SCROLL_Y_SET,TMAPN_BGS0Y_MIN);
		GF_BGL_ScrollReq(pMain->bgl,GF_BGL_FRAME3_S,GF_BGL_SCROLL_Y_SET,TMAPN_BGS0Y_MIN);
	}else if(y > TMAPN_BGS0Y_MAX){
		GF_BGL_ScrollReq(pMain->bgl,GF_BGL_FRAME2_S,GF_BGL_SCROLL_Y_SET,TMAPN_BGS0Y_MAX);
		GF_BGL_ScrollReq(pMain->bgl,GF_BGL_FRAME3_S,GF_BGL_SCROLL_Y_SET,TMAPN_BGS0Y_MAX);
	}else{
		GF_BGL_ScrollReq(pMain->bgl,GF_BGL_FRAME2_S,GF_BGL_SCROLL_Y_SET,y);
		GF_BGL_ScrollReq(pMain->bgl,GF_BGL_FRAME3_S,GF_BGL_SCROLL_Y_SET,y);
	}
}

/**
 *	@brief m[}[h@Ճf[^
 */
static int TMapNS_IsFootMarkHit(TMAP_FOOTVIEW* pv,int x,int z)
{
	int i = 0;
	
	for(i = 0;i < pv->num;i++){
		if(pv->foot[i].x == x && pv->foot[i].z == z){
			return i;
		}
	}
	return -1;
}

/**
 *	@brief	m[}[h@Ճ}[N\[X쐬
 */
static void TMapN_FootViewInit(TMAP_MAIN_DAT* pMain)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;
	TMAP_FOOT	*wp;
	TMAP_FVIEW	*dest;
	int i = 0,ret,idx;

	//,,E,
	static const u16 dirTable[4] = {DIR_ROT_UP,DIR_ROT_DOWN,DIR_ROT_RIGHT,DIR_ROT_LEFT};
	static const TCATS_OBJECT_ADD_PARAM	ActAddParam =
	{
		TMAP_ACTID_FOOT,	//ID
		0, 0, 0,	//x,y,z
		0, TMAP_SPRI_FOOT, TMAP_APAL_FOOT, NNS_G2D_VRAM_TYPE_2DMAIN,	//anmNO,pri,pal,d_area
		0, 0, 0, 0	//prm1,prm2,prm3,prm4
	};

	//f[^
	memset(&(wk->fView),0,sizeof(TMAP_FOOTVIEW));
	for(i = 0;i < TMAP_FVIEW_MAX;i++){
		wp = &(pMain->param->foot[i]);
		if(wp->valid == 0){
			break;
		}
		if(wp->x == pMain->gx && wp->z == pMain->gz){
			continue;	//݂̎@ʒu̓X[
		}
		ret = TMapNS_IsFootMarkHit(&(wk->fView),wp->x,wp->z);
		if(ret < 0){
			dest = &(wk->fView.foot[wk->fView.num++]);
		}else{
			dest = &(wk->fView.foot[ret]);
		}
		dest->x = wp->x;
		dest->z = wp->z;
		if(wp->dir > DIR_RIGHT){
			dest->dir = 0;
			idx = 5;
		}else{
			dest->dir = dirTable[wp->dir];
			idx = 0;
		}
		dest->idx = i;//(TMAP_FVIEW_MAX-1)-i;
		dest->valid = 1;

		dest->pAct = CATS_ObjectAdd(pMain->pCActSys,
				pMain->pCActRes,&(ActAddParam));

		CATS_ObjectPosSet(dest->pAct,
				dest->x*TMAP_MDOT_UNIT+TMAP_MDOT_OFSX,
				dest->z*TMAP_MDOT_UNIT+TMAP_MDOT_OFSZ);
		CLACT_AnmFrameChg(dest->pAct,FX32_CONST(idx+dest->idx));
		//]pݒ
		CLACT_SetRotationAffine(dest->pAct,16384*dest->dir,CLACT_AFFINE_NORMAL);
		CLACT_DrawPriorityChg(dest->pAct,2);
	}
}

/**
 *	@brief	m[}[h@Ճ}[N\[X
 */
static void TMapN_FootViewRelease(TMAP_MAIN_DAT* pMain)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;
	TMAP_FVIEW	*dest;
	int i = 0,ret;
	for(i = 0;i < wk->fView.num;i++){
		dest = &(wk->fView.foot[i]);
		CATS_ObjectDel(dest->pAct);
	}
}

/**
 *	@brief	TuʃtH[JXC@Tu
 */
static const u8 btnAnmTbl[] = {1,2,1,0};
static int TMapNS_SubViewForcusIn(TMAP_MAIN_DAT* pMain)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;
	
	switch(wk->sub_seq){
	case 0:
		if(wk->sub_ct == 0){
			CLACT_SetDrawFlag(wk->pCAW_btn, 1 );
			CLACT_SetAnmFlag(wk->pCAW_btn,1);	//I[gAjZbg
			CLACT_AnmFrameSet(wk->pCAW_btn,1);	//AjX^[gt[Zbg
		}
	case 1:
	case 2:
		//{^Aj
		if(wk->sub_ct % 2){
			TMapN_SubButtonSet(pMain,btnAnmTbl[wk->sub_seq],0);
			GF_BGL_LoadScreenV_Req(pMain->bgl,GF_BGL_FRAME1_S);
			wk->sub_ct = 0;
			wk->sub_seq++;
			return 0;
		}
		wk->sub_ct++;
		break;
	case 3:
		wk->sub_ct++;
		if(wk->sub_ct < 2){
			return 0;
		}
		CLACT_SetDrawFlag(wk->pCAW_btn, 0);
		CLACT_SetAnmFlag(wk->pCAW_btn,0);	//I[gAj~߂
		//tF[hAEg
		pMain->wipe_f = 0;
		WIPE_Start(WIPE_PATTERN_S,
				WIPE_TYPE_SPLITIN_HCENTER,
				WIPE_TYPE_SHUTTEROUT_DOWN,0x0000,8,1,pMain->heapID,&(pMain->wipe_f)
				);

		wk->sub_ct = 0;
		wk->sub_seq++;
		break;
	case 4:
		//tF[h҂
		if(!pMain->wipe_f){
			return 0;
		}
		//ʏ
		wk->forcus = TMAPN_FORCUS_SUB;
		GF_BGL_ScrFill(pMain->bgl,GF_BGL_FRAME0_S,0x0000,0,0,32,32,GF_BGL_SCRWRT_PALIN);
		GF_BGL_ScrFill(pMain->bgl,GF_BGL_FRAME1_S,0x0000,0,0,32,32,GF_BGL_SCRWRT_PALIN);
		
		TMap_GuideTagSet(pMain,&(wk->win[WIN_GUIDE]));
		TMapN_BlockReset(pMain);
		TMapN_BlockChange(pMain);

		pMain->wipe_f = 0;
		WIPE_Start(WIPE_PATTERN_S,
				WIPE_TYPE_SPLITIN_HCENTER,
				WIPE_TYPE_SHUTTERIN_UP,0x0000,8,1,pMain->heapID,&(pMain->wipe_f)
				);

		wk->sub_seq++;
		break;
	case 5:
		if(!pMain->wipe_f){
			return 0;
		}
		wk->key_f = 0;
		wk->sub_seq = 0;
		return 1;
	}
	return 0;
}

/**
 *	@brief	TuʃtH[JXAEg@Tu
 */
static int TMapNS_SubViewForcusOut(TMAP_MAIN_DAT* pMain)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;
	
	switch(wk->sub_seq){
	case 0:
		//tF[hAEg
		pMain->wipe_f = 0;
		WIPE_Start(WIPE_PATTERN_S,
				WIPE_TYPE_SPLITIN_HCENTER,
				WIPE_TYPE_SHUTTEROUT_DOWN,0x0000,8,1,pMain->heapID,&(pMain->wipe_f)
				);

		wk->sub_seq++;
		break;
	case 1:
		//tF[h҂
		if(!pMain->wipe_f){
			return 0;
		}
		GF_BGL_ScrFill(pMain->bgl,GF_BGL_FRAME0_S,0x0000,0,0,32,32,GF_BGL_SCRWRT_PALIN);
		TMapN_SubButtonSet(pMain,0,1);
	
		GF_BGL_LoadScreenV_Req(pMain->bgl,GF_BGL_FRAME0_S);
		GF_BGL_LoadScreenV_Req(pMain->bgl,GF_BGL_FRAME1_S);
	
		pMain->wipe_f = 0;
		WIPE_Start(WIPE_PATTERN_S,
				WIPE_TYPE_SPLITIN_HCENTER,
				WIPE_TYPE_SHUTTERIN_UP,0x0000,8,1,pMain->heapID,&(pMain->wipe_f)
				);
		wk->sub_seq++;
		break;
	case 2:
		if(!pMain->wipe_f){
			return 0;
		}
		wk->forcus = TMAPN_FORCUS_MAIN;
		wk->key_f = 0;
		wk->sub_seq = 0;
		return 1;
	}
	return 0;
}

/**
 *	@brief	Wv[hAA`FbN
 *	@param	pMain TMAP_MAIN_DATւ̃|C^
 */
static int TMapJ_CheckJumpPos(TMAP_MAIN_DAT* pMain)
{
	TMAP_MODE_NORMAL* wk = pMain->pSwork;
	TMAP_VIEW_OBJ *pd = NULL;
	u8	jump_f = 1;

	if(wk->pBlock == NULL){
		return 0;	//ԂŔׂȂꏊ
	}
	pd = TownViewDataSearchPos(wk->pTView,wk->czoneID);
	if(pd == NULL || pd->flag == 0){
//		return 0;	//܂ׂȂ
	}
	pMain->param->retval = 1;
	pMain->param->ret_x = wk->cposX;
	pMain->param->ret_z = wk->cposZ;
	pMain->param->ret_zone = wk->czoneID;
	return 1;
}
