/**
 *	@file	townmap.c
 *	@brief	[h}bvW[@C
 *	@outhor	Miyuki Iwasawa
 *	@date	05.09.07
 */
#include "common.h"
#include "system/procsys.h"
#include "system/arc_util.h"
#include "system/arc_tool.h"
#include "system/brightness.h"
#include "system/bmp_list.h"
#include "system/bmp_menu.h"
#include "system/bmp_tool.h"
#include "system/pm_str.h"
#include "system/msgdata.h"
#include "system/fontproc.h"
#include "system/snd_tool.h"
#include "system/clact_util.h"
#include "system/clact_tool.h"
#include "system/render_oam.h"
#include "system/wipe.h"
#include "system/buflen.h"
#include "gflib/touchpanel.h"
#include "field/field_matrix.h"
#include "field/field_place_name.h"
#include "fielddata/maptable/zone_id.h"
#include "application/app_tool.h"
#include "application/worldmap/townmap.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_place_name.h"
#include "msgdata/msg_townmap.h"
#include "tmap.h"
#include "tmap_act.h"
#include "town.dat"

#define OSP_TMAP_HEAP_SIZE	0	//q[vgpOSvgL

//================================================================
///f[^^`GA
//================================================================
//vg^Cv錾@O[o
//================================================================
///CĂяo

//vg^Cv錾@[J
//================================================================
///I[o[CvZX
PROC_RESULT TMapProc_Init( PROC *proc,int *seq);
PROC_RESULT TMapProc_Main( PROC *proc,int *seq);
PROC_RESULT TMapProc_End( PROC *proc,int *seq);

///VBlank֘A
static void TMapVBlank(void * work);
///VRAMoN`
static void TMapVramBankSet(void);
///vZX
static int TMapInitCommon(TMAP_MAIN_DAT* wk);
static void TMapBGLSet(TMAP_MAIN_DAT* wk,GF_BGL_INI *ini);
static void TMapBgGrapSet(TMAP_MAIN_DAT* wk);
static void TMapBgGrapRelease(TMAP_MAIN_DAT* wk);
static void SetCameraParamInit(TMAP_CAMERA_PARAM* wk);
static void TMapEndCommon(TMAP_MAIN_DAT* wk);
static void TMapMainDraw(TMAP_MAIN_DAT* wk);

//================================================================
///f[^`GA
//================================================================

///[hʐ֐`
extern int	TMapNormal_Init(TMAP_MAIN_DAT* pMain);
extern int	TMapNormal_Build(TMAP_MAIN_DAT* pMain);
extern int	TMapNormal_KeyIn(TMAP_MAIN_DAT* pMain);
extern int	TMapNormal_Main(TMAP_MAIN_DAT* pMain);
extern int	TMapNormal_Draw(TMAP_MAIN_DAT* pMain);
extern int	TMapNormal_Release(TMAP_MAIN_DAT* pMain);
extern int	TMapNormal_VBlank(TMAP_MAIN_DAT* pMain);

extern int	TMapJump_KeyWait(TMAP_MAIN_DAT* pMain);
extern int	TMapJump_Main(TMAP_MAIN_DAT* pMain);
const TMAP_SUB_PROC TMapSubProcData[TMAP_MODE_MAX] = {
 {
	TMapNormal_Init,
	TMapNormal_Build,
	TMapNormal_KeyIn,
	TMapNormal_Main,
	TMapNormal_Draw,
	TMapNormal_Release,
	TMapNormal_VBlank,
 },
 {
	TMapNormal_Init,
	TMapNormal_Build,
	TMapJump_KeyWait,
	TMapNormal_Main,
	TMapNormal_Draw,
	TMapNormal_Release,
	TMapNormal_VBlank,
 },
};

//--------------------------------------------------
///vOGA
//----------------------------------------------------------------
/**
 *	@brief	[h}bv vZX
 *	@param	proc	vZXf[^
 *	@param	seq		V[PX
 *
 *	@return	
 */
PROC_RESULT TMapProc_Init( PROC *proc,int *seq)
{
	TMAP_IO_DAT dat;
	TMAP_MAIN_DAT *wk = NULL;
	TOWNMAP_PARAM * param = (TOWNMAP_PARAM*)PROC_GetParentWork(proc);

	//[NGA擾
	HeapStatePush();

	//q[v쐬
	sys_CreateHeap(HEAPID_BASE_APP,HEAPID_TOWNMAP,0x20000);
	TMAP_HEAP_PRINT("vZXJn");
	
	wk = PROC_AllocWork( proc,sizeof(TMAP_MAIN_DAT),HEAPID_TOWNMAP);
	memset(wk,0,sizeof(TMAP_MAIN_DAT));
	
	//p[^p
	wk->param = param;
	if(param->mode < TMAP_MODE_MAX){
		wk->mode = param->mode;
	}else{
		wk->mode = TMAP_MNORMAL;
	}
	wk->mapView = param->view_f;	//zz}bv`tOp
	wk->heapID = HEAPID_TOWNMAP;

	TMAP_HEAP_PRINT("vZXI");
	return PROC_RES_FINISH;
}

/**
 *	@brief	[h}bv vZXC
 *	@param	proc	vZXf[^
 *	@param	seq		V[PX
 *
 *	@return	
 */
PROC_RESULT TMapProc_Main( PROC *proc,int *seq)
{
	TMAP_MAIN_DAT *wk = PROC_GetWork(proc);

	switch(wk->main_seq){
	case 0:
		//C
		if(TMapInitCommon(wk) != TMAP_SEQ_FINISH){
			return PROC_RES_CONTINUE;	
		}
		TMAP_HEAP_PRINT("CI");
		//Tu擾
		(TMapSubProcData[wk->mode].init)(wk);
		wk->main_seq++;
		break;
	case 1:
		//[hʏ
		if((TMapSubProcData[wk->mode].build)(wk) != TMAP_SEQ_FINISH){
			return PROC_RES_CONTINUE;	
		}
		TMAP_HEAP_PRINT("TuI");
		wk->wipe_f = 0;
		WIPE_Start(WIPE_PATTERN_FMAS,
				WIPE_TYPE_SPLITIN_HCENTER,
				WIPE_TYPE_HOLEIN,0x0000,6,1,wk->heapID,&(wk->wipe_f)
				);
		TMapMainDraw(wk);
		wk->main_seq++;
		break;
	case 2:
		SetBrightness( BRIGHTNESS_NORMAL, PLANEMASK_ALL, MASK_DOUBLE_DISPLAY );
		//uhݒ
		G2_SetBlendAlpha(GX_BLEND_PLANEMASK_BG2,GX_BLEND_PLANEMASK_BG3,28,4);
		
		TMapMainDraw(wk);
		wk->main_seq++;
		break;
	case 3:
		TMapMainDraw(wk);
		if(!wk->wipe_f){
			break;
		}
		wk->main_seq++;
		break;
	case 4:
		if( ((wk->keyFunc)(wk) == TMAP_SEQ_FINISH) ||
			(sys.trg & PAD_BUTTON_B)){
			//W[INGXg
//			APP_BrightnessReq(APP_BRIGHT_OUT);
			wk->wipe_f = 0;
			WIPE_Start(WIPE_PATTERN_FMAS,
				WIPE_TYPE_SPLITOUT_HSIDE,
				WIPE_TYPE_HOLEOUT,0x0000,16,1,wk->heapID,&(wk->wipe_f)
				);
			wk->main_seq++;
		}
		//TuC
		TMapSubProcData[wk->mode].main(wk);
		TMapMainDraw(wk);
		break;
	case 5:
		if(!wk->wipe_f){
			TMapSubProcData[wk->mode].main(wk);
			TMapMainDraw(wk);
			break;
		}
		//ʂݒ
		SetBrightness( BRIGHTNESS_BLACK, PLANEMASK_ALL, MASK_DOUBLE_DISPLAY );
		WIPE_ResetWndMask(WIPE_DISP_MAIN);
		WIPE_ResetWndMask(WIPE_DISP_SUB);
		
		//[hʉ
		(TMapSubProcData[wk->mode].release)(wk);
		wk->main_seq++;
		break;
	case 6:
		TMapEndCommon(wk);
		TMAP_HEAP_PRINT("I");
		return PROC_RES_FINISH;	
	default:
		break;
	}
	return PROC_RES_CONTINUE;
}

/**
 *	@brief	[h}bv vZXI
 *	@param	proc	vZXf[^
 *	@param	seq		V[PX
 *
 *	@return	
 */
PROC_RESULT TMapProc_End( PROC *proc,int *seq)
{
	int i = 0;

	TMAP_MAIN_DAT *wk = PROC_GetWork(proc);
	
	//[NGA
	PROC_FreeWork(proc);

	HeapStatePop();
	HeapStateCheck(wk->heapID);
	
	TMAP_HEAP_PRINT("vZXI");
	sys_DeleteHeap(HEAPID_TOWNMAP);
	return PROC_RES_FINISH;
}

/**
 *	@brief ^E}bvW[
 */
static void TMapVBlank(void * work)
{
	TMAP_MAIN_DAT* wk = work;

	//TuV[PXs
	if(TMapSubProcData[wk->mode].vBlank != NULL){
		(TMapSubProcData[wk->mode].vBlank)(wk);	
	}
	
	NNS_GfdDoVramTransfer();	//VRam]}l[Ws
	TMapCellActorTrans(wk);
	GF_BGL_VBlankFunc( wk->bgl );
	OS_SetIrqCheckFlag( OS_IE_V_BLANK);
}

/**
 *	@brief ^E}bvW[ VRAM BANK Set
 */
static void TMapVramBankSet(void)
{
#if 0
	GF_BGL_DISPVRAM vramSetTable = {
		GX_VRAM_BG_128_B,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
		GX_VRAM_SUB_BG_128_C,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
		GX_VRAM_OBJ_64_E,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
		GX_VRAM_TEX_0_A,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_01_FG			// eNX`pbgXbg
	};
#else
	GF_BGL_DISPVRAM vramSetTable = {
		GX_VRAM_BG_128_A,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
		GX_VRAM_SUB_BG_128_C,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
		GX_VRAM_OBJ_64_E,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
		GX_VRAM_TEX_NONE,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_NONE			// eNX`pbgXbg
	};

#endif	
	GF_Disp_SetBank( &vramSetTable );
}


/**
 *	@brief ^E}bvʏ
 *
 *	@param	wk	TMAP_MAIN_DAT*
 */
static int TMapInitCommon(TMAP_MAIN_DAT* wk)
{
	switch(wk->sub_seq){
	case 0:
		//Blank֐Zbg
		sys_VBlankFuncChange(NULL, NULL);
		sys_HBlankIntrStop();	//HBlank荞ݒ~

		GF_Disp_GX_VisibleControlInit();
		GF_Disp_GXS_VisibleControlInit();
		GX_SetVisiblePlane(0);
		GXS_SetVisiblePlane(0);
		
		//@ʒu擾
		if(wk->param->player_x == 0 && wk->param->player_z == 0){
			wk->gx = 3;
			wk->gz = 27;
		}else{
			wk->gx = wk->param->player_x/32;
			wk->gz = wk->param->player_z/32;
		}
		wk->cposX = wk->gx;
		wk->cposZ = wk->gz;

		//bZ[W\[X擾
		wk->pMsgMap = MSGMAN_Create(MSGMAN_TYPE_DIRECT,ARC_MSG,
				NARC_msg_place_name_dat,wk->heapID);
		wk->pMsgTMap = MSGMAN_Create(MSGMAN_TYPE_DIRECT,ARC_MSG,
				NARC_msg_townmap_dat,wk->heapID);
		wk->placeName = STRBUF_Create(BUFLEN_PLACE_NAME,wk->heapID);
		
		//][\[X擾
		wk->pZone = InitFMZ(wk->heapID);

		//ubNf[^擾
		wk->pBDat = TMapBlockDataLoad(wk,"data/tmap_block.dat");
		break;
	case 1:
		//BankZbg
		TMapVramBankSet();

		//BG֘AZbg
		wk->bgl = GF_BGL_BglIniAlloc(wk->heapID);

		TMapBGLSet(wk,wk->bgl);
		TMapBgGrapSet(wk);
		
		//^b`pl
		InitTPSystem();
		InitTPNoBuff(4);

		//ZAN^[
		TMapCellActorInit(wk);
		break;
	case 2:
		sys_VBlankFuncChange(TMapVBlank, wk);	//VBlankSet

		//ftHgL[擾֐Zbg
		wk->keyFunc = TMapSubProcData[wk->mode].keyIO;
		wk->sub_seq = 0;
		return TMAP_SEQ_FINISH;
	}
	wk->sub_seq++;
	return TMAP_SEQ_CONTINUE;
}
/**
 *	@brief	^E}bvʏI
 *	@param	wk	TMAP_MAIN_DAT*
 */
static void TMapEndCommon(TMAP_MAIN_DAT* wk)
{
	int i;

	//^b`plI
	StopTP();

	GF_Disp_GX_VisibleControl(
		GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 | GX_PLANEMASK_BG2 |
		GX_PLANEMASK_BG3 | GX_PLANEMASK_OBJ, VISIBLE_OFF );
	GF_Disp_GXS_VisibleControl(
		GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 | GX_PLANEMASK_BG2 |
		GX_PLANEMASK_BG3 | GX_PLANEMASK_OBJ, VISIBLE_OFF);
	
	sys_VBlankFuncChange(NULL, NULL);
	sys_HBlankIntrStop();	//HBlank荞ݒ~

	//ZAN^[I
	TMapCellActorRelease(wk);

	TMapBgGrapRelease(wk);
	for(i = 0;i < 8;i++){
		GF_BGL_BGControlExit( wk->bgl, i);
	}

	sys_FreeMemoryEz(wk->bgl);

	//ubNf[^
	TMapBlockDataRelease(wk->pBDat);
	//][f[^
	FreeFMZ(wk->pZone);
	//bZ[W}l[W[
	STRBUF_Delete(wk->placeName);
	MSGMAN_Delete(wk->pMsgTMap);
	MSGMAN_Delete(wk->pMsgMap);
}

/**
 *	@brief	^E}bvDraw
 */
static void TMapMainDraw(TMAP_MAIN_DAT* wk)
{
	//TuDraw
	(TMapSubProcData[wk->mode].draw)(wk);
	
	//AN^[
	TMapCellActorMain(wk);
}
/**
 *	@brief	^E}bv BGLݒ
 */
static void TMapBGLSet(TMAP_MAIN_DAT* wk,GF_BGL_INI *ini)
{
	int i,frame;
	
	{	//BG SYSTEM
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS,GX_BGMODE_0,GX_BGMODE_0,GX_BG0_AS_2D
		};
		GF_BGL_InitBG(&BGsys_data);
	}
	
	{
	GF_BGL_BGCNT_HEADER TextBgCntDat[] = {
		{	//MAIN BG0
			0,0,0x800,0,GF_BGL_SCRSIZ_256x256,GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800,GX_BG_CHARBASE_0x00000,GX_BG_EXTPLTT_01,
			0,0,0,FALSE},
		{	//MAIN BG1
			0,0,0x800,0,GF_BGL_SCRSIZ_256x256,GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000,GX_BG_CHARBASE_0x00000,GX_BG_EXTPLTT_01,
			1,0,0,FALSE},
		{	//MAIN BG2
			0,0,0x800,0,GF_BGL_SCRSIZ_256x256,GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe800,GX_BG_CHARBASE_0x00000,GX_BG_EXTPLTT_01,
			2,0,0,FALSE},
		{	//MAIN BG3
			0,0,0x800,0,GF_BGL_SCRSIZ_256x256,GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe000,GX_BG_CHARBASE_0x00000,GX_BG_EXTPLTT_01,
			3,0,0,FALSE},
		{	//SUB BG0
			0,0,0x800,0,GF_BGL_SCRSIZ_256x256,GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800,GX_BG_CHARBASE_0x00000,GX_BG_EXTPLTT_01,
			0,0,0,FALSE},
		{	//SUB BG1
			0,0,0x800,0,GF_BGL_SCRSIZ_256x256,GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000,GX_BG_CHARBASE_0x00000,GX_BG_EXTPLTT_01,
			1,0,0,FALSE},
		{	//SUB BG2
			0,0,0x2000,0,GF_BGL_SCRSIZ_512x512,GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xd000,GX_BG_CHARBASE_0x10000,GX_BG_EXTPLTT_01,
			2,0,0,FALSE},
		{	//SUB BG3
			0,0,0x2000,0,GF_BGL_SCRSIZ_512x512,GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xb000,GX_BG_CHARBASE_0x10000,GX_BG_EXTPLTT_01,
			3,0,0,FALSE},
	};
	frame = GF_BGL_FRAME0_M;
	for(i = 0;i < 8;i++){
		GF_BGL_BGControlSet(ini,frame,&(TextBgCntDat[i]),GF_BGL_MODE_TEXT);
		GF_BGL_ScrClear(ini,frame++);
	}
	}
	GF_BGL_ClearCharSet(GF_BGL_FRAME0_M,32,0,wk->heapID);
	GF_BGL_ClearCharSet(GF_BGL_FRAME1_M,32,0,wk->heapID);
	GF_BGL_ClearCharSet(GF_BGL_FRAME2_M,32,0,wk->heapID);
	GF_BGL_ClearCharSet(GF_BGL_FRAME3_M,32,0,wk->heapID);
	GF_BGL_ClearCharSet(GF_BGL_FRAME0_S,32,0,wk->heapID);
	GF_BGL_ClearCharSet(GF_BGL_FRAME1_S,32,0,wk->heapID);
	GF_BGL_ClearCharSet(GF_BGL_FRAME2_S,32,0,wk->heapID);
	GF_BGL_ClearCharSet(GF_BGL_FRAME3_S,32,0,wk->heapID);
}

/**
 *	@brief	^E}bv@2D\[Xt@C]
 */
static void ArcFileVramLoad(TMAP_MAIN_DAT* wk,ARCHANDLE* handle,int arcID,int fileID,int frame,int mode)
{
	u32	size;
	void* pSrc;
	NNSG2dCharacterData* pChar;
	NNSG2dPaletteData*	pPal;
	
	size = ArchiveDataSizeGet(arcID,fileID);
	pSrc = sys_AllocMemoryLo(wk->heapID,size);
	ArchiveDataLoadByHandle(handle,fileID,(void*)pSrc);

	if(mode == 0){
		NNS_G2dGetUnpackedCharacterData(pSrc,&pChar); 
		GF_BGL_LoadCharacter(wk->bgl,frame,
				pChar->pRawData,pChar->szByte,0);
	}else{
		NNS_G2dGetUnpackedPaletteData(pSrc,&pPal);
		GF_BGL_PaletteSet(frame,pPal->pRawData,pPal->szByte,0);
	}
	sys_FreeMemoryEz(pSrc);
}

/**
 *	@brief	^E}bv@2DXN[\[X擾
 */
static void ArcScrFileLoad(TMAP_MAIN_DAT* wk,ARCHANDLE* handle,
	int arcID,int fileID,void** pBuf,NNSG2dScreenData** pDat)
{
	int size;
	
	size = ArchiveDataSizeGet(arcID,fileID);
	*pBuf = sys_AllocMemory(wk->heapID,size);
	ArchiveDataLoadByHandle(handle,fileID,*pBuf);
	NNS_G2dGetUnpackedScreenData(*pBuf,pDat); 
}

/**
 *	@brief	^E}bv@2D\[Xt@C擾
 */
#define GRA_M01_NCGR	(NARC_tmap_gra_tmap01_ncgr)
#define GRA_S01_NCGR	(NARC_tmap_gra_tmap02_ncgr)
#define GRA_S02_NCGR	(NARC_tmap_gra_tmap02_sw_ncgr)

#define GRA_M01_NCLR	(NARC_tmap_gra_tmap01_nclr)
#define GRA_S01_NCLR	(NARC_tmap_gra_tmap02_nclr)

#define GRA_M_MLOAD	(NARC_tmap_gra_tmap01_mload_nscr)
#define GRA_M_BACK	(NARC_tmap_gra_tmap01_back_nscr)
#define GRA_M_DIS	(NARC_tmap_gra_tmap01_dis_nscr)
#define GRA_S_DM	(NARC_tmap_gra_tmap02_dm_nscr)
#define GRA_S_DR	(NARC_tmap_gra_tmap02_dr_nscr)
#define GRA_S_DSWM	(NARC_tmap_gra_tmap02_dswm_nscr)
#define GRA_S_SW	(NARC_tmap_gra_tmap02_sw_nscr)

//#define GRA_
static void TMapBgGrapSet(TMAP_MAIN_DAT* wk)
{
	void* tmp;
	u32	size,arcID;
	ARCHANDLE* handle;

	arcID = ARC_TMAP_GRA;

	//A[JCũnh擾
	handle = ArchiveDataHandleOpen(ARC_TMAP_GRA,wk->heapID);

	//LN^f[^]
	ArcFileVramLoad(wk,handle,arcID,GRA_M01_NCGR,GF_BGL_FRAME1_M,0);
	ArcFileVramLoad(wk,handle,arcID,GRA_S01_NCGR,GF_BGL_FRAME2_S,0);
	ArcFileVramLoad(wk,handle,arcID,GRA_S02_NCGR,GF_BGL_FRAME1_S,0);

	//pbg]
	ArcFileVramLoad(wk,handle,arcID,GRA_M01_NCLR,PALTYPE_MAIN_BG,1);
	ArcFileVramLoad(wk,handle,arcID,GRA_S01_NCLR,PALTYPE_SUB_BG,1);

	//XN[
	ArcScrFileLoad(wk,handle,arcID,GRA_M_MLOAD,&wk->pScrBuf01,&wk->pScr01);
	ArcScrFileLoad(wk,handle,arcID,GRA_M_BACK,&wk->pScrBuf01_back,&wk->pScr01_back);
	ArcScrFileLoad(wk,handle,arcID,GRA_M_DIS,&wk->pScrBuf01_dis,&wk->pScr01_dis);
	
	ArcScrFileLoad(wk,handle,arcID,GRA_S_DM,&wk->pScrBuf02_dm,&wk->pScr02_dm);
	ArcScrFileLoad(wk,handle,arcID,GRA_S_DR,&wk->pScrBuf02_dr,&wk->pScr02_dr);
	ArcScrFileLoad(wk,handle,arcID,GRA_S_DSWM,&wk->pScrBuf02_dswm,&wk->pScr02_dswm);
	ArcScrFileLoad(wk,handle,arcID,GRA_S_SW,&wk->pScrBuf02_sw,&wk->pScr02_sw);

	//N[Y
	ArchiveDataHandleClose( handle );
	//XN[f[^擾
#if 0
	size = ArchiveDataSizeGet(ARC_TMAP_GRA,NARC_tmap_gra_tmap01_mload_nscr);
	wk->pScrBuf01 = sys_AllocMemory(wk->heapID,size);
	ArchiveDataLoadByHandle(handle,NARC_tmap_gra_tmap01_mload_nscr,(void*)wk->pScrBuf01);
	NNS_G2dGetUnpackedScreenData(wk->pScrBuf01,&(wk->pScr01)); 

	size = ArchiveDataSizeGet(ARC_TMAP_GRA,NARC_tmap_gra_tmap01_back_nscr);
	wk->pScrBuf01_back = sys_AllocMemory(wk->heapID,size);
	ArchiveDataLoadByHandle(handle,NARC_tmap_gra_tmap01_back_nscr,(void*)wk->pScrBuf01_back);
	NNS_G2dGetUnpackedScreenData(wk->pScrBuf01_back,&(wk->pScr01_back)); 
	
	size = ArchiveDataSizeGet(ARC_TMAP_GRA,NARC_tmap_gra_tmap02_dm_nscr);
	wk->pScrBuf02_dm = sys_AllocMemory(wk->heapID,size);
	ArchiveDataLoadByHandle(handle,NARC_tmap_gra_tmap02_dm_nscr,(void*)wk->pScrBuf02_dm);
	NNS_G2dGetUnpackedScreenData(wk->pScrBuf02_dm,&(wk->pScr02_dm)); 
	
	size = ArchiveDataSizeGet(ARC_TMAP_GRA,NARC_tmap_gra_tmap02_dr_nscr);
	wk->pScrBuf02_dr = sys_AllocMemory(wk->heapID,size);
	ArchiveDataLoadByHandle(handle,NARC_tmap_gra_tmap02_dr_nscr,(void*)wk->pScrBuf02_dr);
	NNS_G2dGetUnpackedScreenData(wk->pScrBuf02_dr,&(wk->pScr02_dr)); 

	size = ArchiveDataSizeGet(ARC_TMAP_GRA,NARC_tmap_gra_tmap02_dswm_nscr);
	wk->pScrBuf02_dswm = sys_AllocMemory(wk->heapID,size);
	ArchiveDataLoadByHandle(handle,NARC_tmap_gra_tmap02_dswm_nscr,(void*)wk->pScrBuf02_dswm);
	NNS_G2dGetUnpackedScreenData(wk->pScrBuf02_dswm,&(wk->pScr02_dswm)); 
	
	//N[Y
	ArchiveDataHandleClose( handle );
	ArcUtil_BgCharSet(
		ARC_TMAP_GRA,NARC_tmap_gra_tmap01_ncgr,
		wk->bgl,GF_BGL_FRAME1_M,0,0,0,wk->heapID );
	ArcUtil_BgCharSet(
		ARC_TMAP_GRA,NARC_tmap_gra_tmap02_ncgr,
		wk->bgl,GF_BGL_FRAME3_S,0,0,0,wk->heapID );
	ArcUtil_PalSet(
		ARC_TMAP_GRA,NARC_tmap_gra_tmap01_nclr,
		PALTYPE_MAIN_BG,0,32*3,wk->heapID );
	ArcUtil_PalSet(
		ARC_TMAP_GRA,NARC_tmap_gra_tmap02_nclr,
		PALTYPE_SUB_BG,0,160,wk->heapID );
#endif
	//tHgppbgZbg
	SystemFontPaletteLoad(PALTYPE_MAIN_BG,FONT_SYS_PAL*32,wk->heapID);
	SystemFontPaletteLoad(PALTYPE_SUB_BG,FONT_SYS_PAL*32,wk->heapID);
}

/**
 *	@brief	C2DOtBbN\[X
 */
static void TMapBgGrapRelease(TMAP_MAIN_DAT* wk)
{
	sys_FreeMemoryEz(wk->pScrBuf02_sw);
	sys_FreeMemoryEz(wk->pScrBuf02_dswm);
	sys_FreeMemoryEz(wk->pScrBuf02_dr);
	sys_FreeMemoryEz(wk->pScrBuf02_dm);
	sys_FreeMemoryEz(wk->pScrBuf01_dis);
	sys_FreeMemoryEz(wk->pScrBuf01_back);
	sys_FreeMemoryEz(wk->pScrBuf01);
}

/**
 *	@brief	^EView\[X쐬
 */
TMAP_VIEW_DAT* TownViewDataCreate(TMAP_MAIN_DAT* pMain,short res_num,short dat_num)
{
	TMAP_VIEW_DAT* wp;
	TMAP_VIEW_OBJ *pd;
	const TOWN_VIEW*	pView;
	short i;

	static const TCATS_OBJECT_ADD_PARAM	ActAddParam =
	{
		TMAP_ACTID_TVIEW,	//ID
		0, 0, 0,	//x,y,z
		0, TMAP_SPRI_TOWN, TMAP_APAL_NTOWN, NNS_G2D_VRAM_TYPE_2DMAIN,	//anmNO,pri,pal,d_area
		0, 0, 0, 0	//prm1,prm2,prm3,prm4
	};
	
	wp = sys_AllocMemory(pMain->heapID,sizeof(TMAP_VIEW_DAT));
	memset(wp,0,sizeof(TMAP_VIEW_DAT));

	wp->dat_num = dat_num;

	wp->pDat = sys_AllocMemory(pMain->heapID,sizeof(TMAP_VIEW_OBJ)*wp->dat_num);
	memset(wp->pDat,0,sizeof(TMAP_VIEW_OBJ)*wp->dat_num);

	//^Er[f[^擾
	pView = TownViewDat;
	for(i = 0;i < wp->dat_num;i++){
		pd = &wp->pDat[i];

		//ǂݍ݃p[^
		pd->prm.zoneID = pView[i].zoneID;
		pd->prm.ptn = pView[i].ptn;
		pd->prm.typ = pView[i].typ;
		pd->prm.r = pView[i].r;
		pd->prm.x = pView[i].x;
		pd->prm.z = pView[i].z;
	
		//BtO`FbN
		pd->flag = 1;
		
		//Zǉ
		pd->pAct = CATS_ObjectAdd( pMain->pCActSys,	pMain->pCActRes,&ActAddParam);
		CLACT_SetDrawFlag(pd->pAct, 1);

		//Town or City
		CLACT_PaletteNoChg( pd->pAct,TMAP_APAL_NTOWN+pd->prm.typ+pd->flag);
		
		//]pݒ
		CLACT_SetRotationAffine(pd->pAct,16384*pd->prm.r,CLACT_AFFINE_NORMAL);

		//p^[ݒ&ʒuݒ
		CLACT_AnmFrameChg(pd->pAct,FX32_CONST(pd->prm.ptn));
		CATS_ObjectPosSet(pd->pAct,
				pd->prm.x+TMAP_MDOT_OFSX,
				pd->prm.z+TMAP_MDOT_OFSZ);

	}

	return wp;
}

/**
 *	@brief	^EView\[X
 */
void TownViewDataRelease(TMAP_MAIN_DAT* pMain,TMAP_VIEW_DAT* wp)
{
	TMAP_VIEW_OBJ *pd;
	short i;

	//Zj
	for(i = 0;i < wp->dat_num;i++){
		pd = &wp->pDat[i];
		CLACT_SetRotationAffine(pd->pAct,0,CLACT_AFFINE_NONE);
		CLACT_Delete(pd->pAct);
	}
	sys_FreeMemoryEz(wp->pDat);
	sys_FreeMemoryEz(wp);
}

/**
 *	^EView f[^ZoneID̂T
 */
TMAP_VIEW_OBJ* TownViewDataSearchPos(TMAP_VIEW_DAT* wp,int zoneID)
{
	TMAP_VIEW_OBJ *pd;
	short i,flag;
	
	for(i = 0;i < wp->dat_num;i++){
		pd = &(wp->pDat[i]);
		if(pd->prm.zoneID != zoneID){
			continue;
		}
		return pd;
	}
	return NULL;
}
/**
 *	@brief	^EView
 */
int TownViewDataSelectPos(TMAP_VIEW_DAT* wp,int zoneID)
{
	TMAP_VIEW_OBJ *pd;
	short i,flag;
	
	flag = 0;
	if(wp == NULL){
		return 0;
	}
	pd = TownViewDataSearchPos(wp,zoneID);
	if(pd == NULL || pd->flag == 0){
		if(wp->selPos != NULL){
			CLACT_PaletteNoChg(wp->selPos->pAct,
				TMAP_APAL_NTOWN+wp->selPos->prm.typ+wp->selPos->flag);
		}
		wp->selPos = NULL;
		return 0;
	}
	if(wp->selPos == NULL){
		wp->selCount = 0;
		wp->selFrame = 0;
	}
	wp->selPos = pd;
	return 1;
}

/**
 *	@brief	^EView {`
 */
void TownViewDataDraw(TMAP_MAIN_DAT* pMain,TMAP_VIEW_DAT* wp)
{
	short i;
	TMAP_VIEW_OBJ *pd;

	if(wp->selPos == NULL || pMain->mode != TMAP_MJUMP){
		return;
	}

	if(wp->selFrame == 0){
		CLACT_PaletteNoChg( wp->selPos->pAct,TMAP_APAL_A1TOWN+wp->selPos->prm.typ);
	}else{
		CLACT_PaletteNoChg( wp->selPos->pAct,	//IWi
				TMAP_APAL_NTOWN+wp->selPos->prm.typ+wp->selPos->flag);
	}
	wp->selCount++;
	if(wp->selCount == TMAP_ACT_TANMF){
		wp->selCount = 0;
		wp->selFrame ^= 1;
	}
}

/**
 *	@brief	}bvubNf[^[h
 */
TMAP_GDAT_LIST* TMapBlockDataLoad(TMAP_MAIN_DAT* pMain,const char* path)
{
	FSFile fp;
	int ret,i;
	int dat_num;
	TMAP_GDAT_LIST *pWork;
	TMAP_GDAT *wp;
	
	FS_InitFile(&fp);
	if(!FS_OpenFile(&fp,path)){
		OS_Printf("FS_OpenFile(\"%s\") ... ERROR!\n",path);
		GF_ASSERT(0);
		return NULL;
	}
	//f[^擾
	ret = FS_ReadFile(&fp,&dat_num,4);
	GF_ASSERT(ret >= 0 && "ERROR:tmap block data num can't read");
	
	//m
	pWork = sys_AllocMemory(pMain->heapID,sizeof(TMAP_GDAT_LIST));
	memset(pWork,0,sizeof(TMAP_GDAT_LIST));
	pWork->pDat = sys_AllocMemory(pMain->heapID,sizeof(TMAP_GDAT)*dat_num);
	memset(pWork->pDat,0,sizeof(TMAP_GDAT)*dat_num);

	pWork->num = dat_num;	//ۑ

	for(i = 0;i < pWork->num;i++){
		wp = &(pWork->pDat[i]);
		ret = FS_ReadFile(&fp,wp,sizeof(TMAP_GDAT));
	}
	(void)FS_CloseFile(&fp);

	return pWork;
}

/**
 *	@brief	}bvubNf[^
 */
void TMapBlockDataRelease(TMAP_GDAT_LIST* pWork)
{
	sys_FreeMemoryEz(pWork->pDat);
	sys_FreeMemoryEz(pWork);
}

/**
 *	@brief	}bvubNf[^@ubNf[^擾
 *
 *	@param	pWork	f[^Xgz̐擪|C^
 *	@param	x		ubNXW
 *	@param	z		ubNZW
 *	@param	mapView	zz}bv`tO
 *	ubNx,zWubNf[^ւ̃|C^擾
 *	ȂꍇNULLԂ
 */
TMAP_GDAT* TMapBlockDataGet(TMAP_GDAT_LIST* pWork,int x,int z,int mapView)
{
	int i;
	TMAP_GDAT* wp;

	OS_Printf("TMapBlockNum = %d : get(%d,%d)\n",pWork->num,x,z);
	for(i = 0;i < pWork->num;i++){
		wp = &(pWork->pDat[i]);
//		OS_Printf("TMapBlockGet Search = %d (%d,%d)\n",i,wp->x,wp->z);
		if((wp->x == x) && (wp->z == z)){
			if(wp->view == 0 || (wp->view & 1)){
//				OS_Printf("TMapBlockGet Index = %d\n",i);
				return wp;
			}else{
				return NULL;
			}
		}
	}
//	OS_Printf("TMapBlockGet Index = none\n");
	return NULL;
}

//============================================================================================
//	fobO
//============================================================================================
