//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		zkn_cursor.c
 *	@brief		}cursorVXe
 *	@author		tomoya takahashi
 *	@data		2006.03.02
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "include/gflib/system.h"
#include "include/gflib/assert.h"
#include <string.h>

#define	__ZKN_CURSOR_H_GLOBAL
#include "include/application/zukanlist/zkn_cursor.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	cursorVXe
//=====================================
typedef struct _ZKN_CURSOR {
	const ZKN_CURSOR_ONEDATA* p_data;
	int max_x;
	int max_y;
	int now_x;
	int now_y;
} ;


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static int inline GetNowIdx( const ZKN_CURSOR* cp_cursor );
static int inline GetIdx( const ZKN_CURSOR* cp_cursor, int x, int y );
static void MoveXCursor( ZKN_CURSOR* p_cursor, int param );
static void MoveYCursor( ZKN_CURSOR* p_cursor, int param );

static void ZknCursorContAddX( ZKN_CURSOR* p_cursor, int param );
static void ZknCursorContAddY( ZKN_CURSOR* p_cursor, int param );
static void inline ZknCursorContSetX( ZKN_CURSOR* p_cursor, int param );
static void inline ZknCursorContSetY( ZKN_CURSOR* p_cursor, int param );
static void ZknCursorContSetContID( ZKN_CURSOR* p_cursor, int param );

//----------------------------------------------------------------------------
/**
 *	@brief	}CURSORVXe[Nm
 *
 *	@param	heap	q[v
 *
 *	@return	CURSORVXe[N
 */
//-----------------------------------------------------------------------------
ZKN_CURSOR* ZKN_CURSOR_Alloc( int heap )
{
	ZKN_CURSOR* p_cursor;

	p_cursor = sys_AllocMemory( heap, sizeof(ZKN_CURSOR) );
	memset( p_cursor, 0, sizeof(ZKN_CURSOR) );

	return p_cursor;
}

//----------------------------------------------------------------------------
/**
 *	@brief	}CURSORVXe[Nj
 *
 *	@param	p_cursor	CURSORVXe[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_CURSOR_Free( ZKN_CURSOR* p_cursor )
{
	sys_FreeMemoryEz( p_cursor );
}

//----------------------------------------------------------------------------
/**
 *	@brief	}CURSORVXe
 *
 *	@param	p_cursor	CURSORVXe[N
 *	@param	cp_data		CURSORf[^
 *	@param	max_x		Xf[^
 *	@param	max_y		Yf[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_CURSOR_Init( ZKN_CURSOR* p_cursor, const ZKN_CURSOR_ONEDATA* cp_data, int max_x, int max_y )
{
	memset( p_cursor, 0, sizeof(ZKN_CURSOR) );
	p_cursor->p_data = cp_data;
	p_cursor->max_x = max_x;
	p_cursor->max_y	= max_y;
}

//----------------------------------------------------------------------------
/**
 *	@brief	}CURSORVXeRg[
 *
 *	@param	p_cursor	CURSORVXe[N
 *	@param	cont		R}h
 *	@param	param		l
 *
 *	@return	none	
 */
//-----------------------------------------------------------------------------
void ZKN_CURSOR_Cont( ZKN_CURSOR* p_cursor, int cont, int param )
{
	int i;
	
	switch( cont ){
	case ZKN_CURSOR_CONT_ADD_X:		// Xړ	
		ZknCursorContAddX( p_cursor, param );
		break;
		
	case ZKN_CURSOR_CONT_ADD_Y:		// Yړ	
		ZknCursorContAddY( p_cursor, param );
		break;
		
	case ZKN_CURSOR_CONT_SET_X:		// Xݒ	
		ZknCursorContSetX( p_cursor, param );
		break;
		
	case ZKN_CURSOR_CONT_SET_Y:		// Yݒ	
		ZknCursorContSetY( p_cursor, param );
		break;
		
	case ZKN_CURSOR_CONT_SET_CONTID:	// ǗID̈ʒuɃJ[\ړ
		ZknCursorContSetContID( p_cursor, param );
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	݂ʒůǗID擾
 *
 *	@param	cp_cursor	CURSORVXe[N
 *
 *	@return	ǗID
 */
//-----------------------------------------------------------------------------
int ZKN_CURSOR_GetContID( const ZKN_CURSOR* cp_cursor )
{
	int now_idx;
	
	now_idx = GetNowIdx( cp_cursor );
	return cp_cursor->p_data[ now_idx ].cont_id;
}

//----------------------------------------------------------------------------
/**
 *	@brief	CURSORʒu̍W擾
 *
 *	@param	cp_cursor	CURSORVXe[N
 *	@param	p_x			XWi[
 *	@param	p_y			YWi[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_CURSOR_GetMat( const ZKN_CURSOR* cp_cursor, int* p_x, int* p_y )
{
	int now_idx;
	
	now_idx = GetNowIdx( cp_cursor );
	
	*p_x = cp_cursor->p_data[ now_idx ].x;
	*p_y = cp_cursor->p_data[ now_idx ].y;
}

//----------------------------------------------------------------------------
/**
 *	@brief	CURSORʒü̗TCY擾
 *
 *	@param	cp_cursor	CURSORVXe[N
 *	@param	p_x			XTCYi[
 *	@param	p_y			YTCYi[
 *
 *	@return
 */
//-----------------------------------------------------------------------------
void ZKN_CURSOR_GetSize( const ZKN_CURSOR* cp_cursor, int* p_x, int* p_y )
{
	int now_idx;
	
	now_idx = GetNowIdx( cp_cursor );
	
	*p_x = cp_cursor->p_data[ now_idx ].size_x;
	*p_y = cp_cursor->p_data[ now_idx ].size_y;
}


//----------------------------------------------------------------------------
/**
 *	@brief	J[\Pf[^̓ei[
 *
 *	@param	p_data		i[
 *	@param	x			W
 *	@param	y			W
 *	@param	size_x		TCY
 *	@param	size_y		TCY
 *	@param	movex_id	XID
 *	@param	movey_id	YID
 *	@param	cont_id		[U[ǗID
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_CURSOR_SetOneData( ZKN_CURSOR_ONEDATA* p_data, int x, int y, int size_x, int size_y, int movex_id, int movey_id, int cont_id )
{
	p_data->x = x;
	p_data->y = y;
	p_data->size_x = size_x;
	p_data->size_y = size_y;
	p_data->movex_id = movex_id;
	p_data->movey_id = movey_id;
	p_data->cont_id  = cont_id;
}


//----------------------------------------------------------------------------
/**
 *	@brief	4̍W擾
 *
 *	@param	cp_cursor	J[\VXe[N
 *	@param	way			ʒu 
 *	@param	p_x			Wi[
 *	@param	p_y			Wi[
 *
 *	@return
 */
//-----------------------------------------------------------------------------
void ZKN_CURSOR_GetRectMat( const ZKN_CURSOR* cp_cursor, int way, int* p_x, int* p_y )
{
	int x, y;
	int size_x, size_y;

	// W̎擾
	ZKN_CURSOR_GetMat( cp_cursor, &x, &y );

	// TCY̎擾
	ZKN_CURSOR_GetSize( cp_cursor, &size_x, &size_y );

	// W߂
	ZKN_CURSOR_UTIL_GetRectMat( way, p_x, p_y, x, y, size_x, size_y );
}


//----------------------------------------------------------------------------
/**
 *	@brief	TCYƒSWeʒu̍W擾
 *
 *	@param	way			
 *	@param	p_x			XWi[
 *	@param	p_y			YWi[
 *	@param	def_x		SX
 *	@param	def_y		SY
 *	@param	size_x		TCYX
 *	@param	size_y		TCYY
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_CURSOR_UTIL_GetRectMat( int way, int* p_x, int* p_y, int def_x, int def_y, int size_x, int size_y )
{
	// XWݒ
	if( (way == ZKN_CURSOR_MAT_TOP_LEFT) ||
		(way == ZKN_CURSOR_MAT_BOTTOM_LEFT) ){
		def_x -= size_x / 2;	
	}else{
		def_x += size_x / 2;	
	}
	
	// YWݒ
	if( (way == ZKN_CURSOR_MAT_TOP_LEFT) ||
		(way == ZKN_CURSOR_MAT_TOP_RIGHT) ){
		def_y -= size_y / 2;	
	}else{
		def_y += size_y / 2;	
	}

	*p_x = def_x;
	*p_y = def_y;
}


//-----------------------------------------------------------------------------
/**
 *				vCx[g֐
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	@brief	̃f[^zvf擾
 *
 *	@param	cp_cursor	CURSORVXe[N
 *
 *	@return	zvf
 */
//-----------------------------------------------------------------------------
static int inline GetNowIdx( const ZKN_CURSOR* cp_cursor )
{
	int now_idx;
	
	now_idx = cp_cursor->now_y * cp_cursor->max_x;
	now_idx += cp_cursor->now_x;

	return now_idx;
}

//----------------------------------------------------------------------------
/**
 *	@brief	̃f[^zvf擾
 *
 *	@param	cp_cursor	CURSORVXe[N
 *	@param	x			擾X
 *	@param	y			擾Y
 *
 *	őTCYcp_cursor̂̂gp
 *
 *	@return	zvf
 */
//-----------------------------------------------------------------------------
static int inline GetIdx( const ZKN_CURSOR* cp_cursor, int x, int y )
{
	int now_idx;
	
	now_idx = y * cp_cursor->max_x;
	now_idx += x;

	return now_idx;
}


//----------------------------------------------------------------------------
/**
 *	@brief	XCURSOR𓮂
 *
 *	@param	p_cursor	CURSORVXe[N
 *	@param	param		l	(-1 or 1)
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void MoveXCursor( ZKN_CURSOR* p_cursor, int param )
{
	int move_x;
	const ZKN_CURSOR_ONEDATA* p_data;
	int data_idx;
	int move_param;

	GF_ASSERT( (param == -1) || (param == 1) );
	
	move_param = 0;

	// ݒW߂
	do{
		// ړlvZ
		move_param += param;
		move_x = p_cursor->now_x + move_param;

		// ő吔ORŒᐔI
		if( (move_x < 0) || (move_x >= p_cursor->max_x) ){
			break;
		}

		// ړƂ̃f[^擾
		data_idx = GetIdx( p_cursor, move_x, p_cursor->now_y );
		p_data = &p_cursor->p_data[ data_idx ];

	}while( p_data->movex_id == ZKN_CURSOR_MOVE_SKIP );

	// XL͈͓Ȃlݒ
	if( (move_x >= 0) && (move_x < p_cursor->max_x) ){
		// ړđv`FbN
		if( p_data->movex_id == ZKN_CURSOR_MOVE_NORMAL ){
			// l𔽉f
			p_cursor->now_x = move_x;
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief@YCURSOR𓮂
 *
 *	@param	p_cursor	CURSORVXe[N
 *	@param	param		l	(-1 or 1)
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void MoveYCursor( ZKN_CURSOR* p_cursor, int param )
{
	int move_y;
	const ZKN_CURSOR_ONEDATA* p_data;
	int data_idx;
	int move_param;

	GF_ASSERT( (param == -1) || (param == 1) );
	
	move_param = 0;

	// ݒW߂
	do{
		// ړlvZ
		move_param += param;
		move_y = p_cursor->now_y + move_param;

		// cő吔ORŒᐔI
		if( (move_y < 0) || (move_y >= p_cursor->max_y) ){
			break;
		}

		// ړƂ̃f[^擾
		data_idx = GetIdx( p_cursor, p_cursor->now_x, move_y );
		p_data = &p_cursor->p_data[ data_idx ];

	}while( p_data->movey_id == ZKN_CURSOR_MOVE_SKIP );

	// XL͈͓Ȃlݒ
	if( (move_y >= 0) && (move_y < p_cursor->max_y) ){
		// ړđv`FbN
		if( p_data->movex_id == ZKN_CURSOR_MOVE_NORMAL ){
			// l𔽉f
			p_cursor->now_y = move_y;
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	Xparam̐i
 *
 *	@param	p_cursor	CURSORVXe[N
 *	@param	param		i߂l
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknCursorContAddX( ZKN_CURSOR* p_cursor, int param )
{
	int i;
	int way;
	int abs;
	
	// vX}CiX߂
	abs = MATH_ABS( param );
	way = param / abs;
	
	for( i=0; i<abs; i++ ){
		MoveXCursor( p_cursor, way );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	Yparam̐i
 *
 *	@param	p_cursor	CURSORVXe[N
 *	@param	param		i߂l
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknCursorContAddY( ZKN_CURSOR* p_cursor, int param )
{
	int i;
	int way;
	int abs;
	
	// vX}CiX߂
	abs = MATH_ABS( param );
	way = param / abs;
	
	for( i=0; i<abs; i++ ){
		MoveYCursor( p_cursor, way );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	J[\ʒuparamɂ
 *
 *	@param	p_cursor	CURSORʒu
 *	@param	param		ݒl
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void inline ZknCursorContSetX( ZKN_CURSOR* p_cursor, int param )
{
	GF_ASSERT( (param >= 0) && (param < p_cursor->max_x) );	
	p_cursor->now_x = param;
}

//----------------------------------------------------------------------------
/**
 *	@brief	J[\ʒuparamɂ
 *
 *	@param	p_cursor	CURSORʒu
 *	@param	param		ݒl
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void inline ZknCursorContSetY( ZKN_CURSOR* p_cursor, int param )
{
	GF_ASSERT( (param >= 0) && (param < p_cursor->max_y) );	
	p_cursor->now_y = param;
}

//----------------------------------------------------------------------------
/**
 *	@brief	param̊ǗIDCURSORʒuɈړ
 *
 *	@param	p_cursor	CURSORVXe[N
 *	@param	param		ǗID
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknCursorContSetContID( ZKN_CURSOR* p_cursor, int param )
{
	int i;
	int data_num = p_cursor->max_x * p_cursor->max_y;

	for( i=0; i<data_num; i++ ){
		
		if( p_cursor->p_data[i].cont_id == param ){
			p_cursor->now_x = i % p_cursor->max_x;
			p_cursor->now_y = i / p_cursor->max_x;
			break;
		}
	}
}
