//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		zkn_event.c
 *	@brief		AvP[VύX@}ӏIȂǂ̃CxgǗ
 *	@author		tomoya takahashi
 *	@data		2006.01.17
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include <string.h>

#define	__ZKN_EVENT_H_GLOBAL
#include "include/application/zukanlist/zkn_event.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//		CxgǗVXe
//=====================================
typedef struct _ZKN_EVENT_SYS{
	ZKN_EVENT_DATA* p_event_data;	// Cxgf[^
	int event_num;					// Cxg
	ZKN_EVENT_DATA* p_event_do;		// s̃Cxg
} ZKN_EVENT_SYS;


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static BOOL EventDoCheck( ZKN_EVENT_SYS_PTR event );
static ZKN_EVENT_DATA* EventStartCheck( ZKN_EVENT_SYS_PTR event, int event_key );
static void EventDataSet( ZKN_EVENT_SYS_PTR event, ZKN_EVENT_DATA* cp_event_data );


//----------------------------------------------------------------------------
/**
 *
 *	@brief	}ӃCxg[Nm
 *
 *	@param	heap	gpq[v
 *
 *	@return	[N|C^
 *
 *
 */
//-----------------------------------------------------------------------------
ZKN_EVENT_SYS_PTR ZKN_EVENT_MemoryAlloc( int heap )
{
	ZKN_EVENT_SYS_PTR event;

	event = sys_AllocMemory( heap, sizeof(ZKN_EVENT_SYS) );
	GF_ASSERT( event );
	memset( event, 0, sizeof(ZKN_EVENT_SYS) );

	return event;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	}ӃCxg
 *
 *	@param	event			Cxg[N
 *	@param	p_event_data	Cxgf[^e[u
 *	@param	event_num		Cxgf[^e[uvf
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_EVENT_Init( ZKN_EVENT_SYS_PTR event, ZKN_EVENT_DATA* p_event_data, int event_num )
{
	GF_ASSERT( event );
	
	event->p_event_data		= p_event_data;
	event->event_num		= event_num;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	}ӃCxgC
 *
 *	@param	event			Cxg[N
 *	@param	event_key		CxgL[
 *
 *	@return	s̃Cxge[u
 *
 *
 */
//-----------------------------------------------------------------------------
const ZKN_EVENT_DATA* ZKN_EVENT_Main( ZKN_EVENT_SYS_PTR event, int event_key )
{
	ZKN_EVENT_DATA* p_event_data;
	BOOL ret;
	
	GF_ASSERT( event );

	// ŝ̂Ƃ
	// s邩`FbN
	if( EventDoCheck( event ) == FALSE ){

		// sJn`FbN
		p_event_data = EventStartCheck( event, event_key );
		if( p_event_data ){
			EventDataSet( event, p_event_data );
		}
	}

	// s
	if( EventDoCheck( event ) == TRUE ){
		
		// Cxgs
		ret = event->p_event_do->func( &event->p_event_do->work );

		// I`FbN
		if( ret == TRUE ){
			EventDataSet( event, NULL );
		}
	}

	return event->p_event_do;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Cxgs`FbN
 *
 *	@param	event	Cxg
 *
 *	@retval	TRUE	Cxg
 *	@retval FALSE	CxgȂ
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL ZKN_EVENT_DoCheck( ZKN_EVENT_SYS_PTR event )
{
	GF_ASSERT(event);

	if( event->p_event_do ){
		return TRUE;
	}

	return FALSE;
}




//-----------------------------------------------------------------------------
/**
 *			vCx[g֐
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	Cxgs`FbN
 *
 *	@param	event	Cxg[N
 *
 *	@retval	TRUE	s
 *	@retval	FALSE	sĂȂ
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL EventDoCheck( ZKN_EVENT_SYS_PTR event )
{
	if( event->p_event_do ){
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	CxgJn`FbN
 *
 *	@param	event		Cxg[N
 *	@param	event_key	CxgL[
 *
 *	@return	JnCxgf[^e[u	Ƃ NULL
 *
 *
 */
//-----------------------------------------------------------------------------
static ZKN_EVENT_DATA* EventStartCheck( ZKN_EVENT_SYS_PTR event, int event_key )
{
	int i;		// [vp

	for( i=0; i<event->event_num; i++ ){

		GF_ASSERT( event->p_event_data );
		
		if( event->p_event_data[ i ].key_msk & event_key ){

			return event->p_event_data + i;
		}
	}

	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Cxgf[^ݒ
 *
 *	@param	event			Cxg[N
 *	@param	p_event_data	Cxgf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void EventDataSet( ZKN_EVENT_SYS_PTR event, ZKN_EVENT_DATA* p_event_data )
{
	event->p_event_do = p_event_data;

	// V[PXf[^
	if( event->p_event_do ){
		event->p_event_do->work.seq = 0;
	}
}
