//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		zkn_glbdata.c
 *	@brief		}ӃO[of[^
 *	@author		tomoya takahashi
 *	@data		2006.01.20
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include <string.h>
#include "include/system/arc_util.h"
#include "src/application/zukanlist/zkn_data/zukan_data.naix"

#include "include/application/zukanlist/zkn_glbdata.h"
#include "include/poketool/poke_tool.h"


//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define ZKN_SORTDATA_START_IDX	( NARC_zukan_data_zkn_sort_zenkoku_dat )
#define ZKN_SORTDATA_ONESIZE	( sizeof(u16) )
enum{
	// {
	ZKN_SORTDATA_ZENKOKU,
	ZKN_SORTDATA_SHINOH,
	
	// \[gް
	ZKN_SORTDATA_AIUEO,
	ZKN_SORTDATA_HEAVY,
	ZKN_SORTDATA_LIGHT,
	ZKN_SORTDATA_TALL,
	ZKN_SORTDATA_SMALL,
	
	// O
	ZKN_SORTDATA_NAME_A,
	ZKN_SORTDATA_NAME_KA,
	ZKN_SORTDATA_NAME_SA,
	ZKN_SORTDATA_NAME_TA,
	ZKN_SORTDATA_NAME_NA,
	ZKN_SORTDATA_NAME_HA,
	ZKN_SORTDATA_NAME_MA,
	ZKN_SORTDATA_NAME_RA,
	ZKN_SORTDATA_NAME_YAWA,

	// ^Cv
	ZKN_SORTDATA_TYPE_NORMAL,
	ZKN_SORTDATA_TYPE_BATTLE,	
	ZKN_SORTDATA_TYPE_HIKOU,	
	ZKN_SORTDATA_TYPE_POISON,	
	ZKN_SORTDATA_TYPE_JIMEN,	
	ZKN_SORTDATA_TYPE_IWA,		
	ZKN_SORTDATA_TYPE_MUSHI,	
	ZKN_SORTDATA_TYPE_GHOST,	
	ZKN_SORTDATA_TYPE_METAL,	
	ZKN_SORTDATA_TYPE_FIRE,	
	ZKN_SORTDATA_TYPE_WATER,	
	ZKN_SORTDATA_TYPE_KUSA,	
	ZKN_SORTDATA_TYPE_ELECTRIC,
	ZKN_SORTDATA_TYPE_SP,		
	ZKN_SORTDATA_TYPE_KOORI,	
	ZKN_SORTDATA_TYPE_DRAGON,	
	ZKN_SORTDATA_TYPE_AKU,	

	// `
	ZKN_SORTDATA_FORM_FOUR_LEGS,
	ZKN_SORTDATA_FORM_TWO_LEGS,
	ZKN_SORTDATA_FORM_TAIL,
	ZKN_SORTDATA_FORM_HARABAI,
	ZKN_SORTDATA_FORM_FOUR_WING,
	ZKN_SORTDATA_FORM_TWO_WING,
	ZKN_SORTDATA_FORM_HAITSUKUBARI,
	ZKN_SORTDATA_FORM_STRAIGHT,
	ZKN_SORTDATA_FORM_ARM,
	ZKN_SORTDATA_FORM_LEGS,
	ZKN_SORTDATA_FORM_MANY_LEGS,
	ZKN_SORTDATA_FORM_WATER,
	ZKN_SORTDATA_FORM_CIRCLE,
	ZKN_SORTDATA_FORM_COMP,
	ZKN_SORTDATA_NUM
};







//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//----------------------------------------------------------------------------
// Kvߊlf[^e[uvf
#define ZKN_GLB_POKEMON_GET_DATA_TBL_ONE_IN	( 16 )	// Pvfɓ|Pf[^
#define ZKN_GLB_POKEMON_GET_DATA_NUM		( 481 )	// Pvfɓ|Pf[^
#define ZKN_GLB_POKEMON_GET_DATA_TBL_NUM	( 31 )	// ZKN_GLB_POKEMON_GET_DATA_NUM / ZKN_GLB_POKEMON_GET_DATA_TBL_ONE_IN
#define ZKN_GLB_POKEMON_GET_DATA_MSK		(0x3)	// f[^擾p

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void ZknPokeListTblMakeSortData( u16* p_buff, int* p_count, const ZUKAN_WORK* cp_zukansave_data, const u16* cp_tbl, int num );
static void ZknPokeListTblMakeSarch( u16* p_buff, int* p_count, const u16* cp_tbl, int num, const u16* cp_sarch_tbl, int sarch_num );
static void ZknPokeListTblMake( ZKN_POKELIST_TBL* p_poke_list, const ZUKAN_WORK* cp_zukansave_data, const u16* cp_tbl, int tbl_num );
static void ZknPokeListDrawTblMake( ZKN_POKELIST_TBL* p_poke_list, const u16* cp_all_tbl, int all_tbl_num );
static void ZknPokeListDrawTblCopy( ZKN_POKELIST_TBL* p_poke_list );
static void ZknPokeListTblSeeGetNumCount( ZKN_POKELIST_TBL* p_poke_list, int* p_see_num, int* p_get_num );

static u16* ZKN_SORTDATA_Get( int heap, int idx, int* p_arry_num );

static void ZknPokeListSort_Core( int sort_type, u16* p_buff, int* p_count, const u16* cp_tbl, int num, int heap );
static void ZknPokeListSarchName_Core( int search_name, u16* p_buff, int* p_count, const u16* cp_tbl, int num, int heap );
static void ZknPokeListSarchType_Core( int search_type, u16* p_buff, int* p_count, const u16* cp_tbl, int num, int heap );
static void ZknPokeListSarchForm_Core( int search_form, u16* p_buff, int* p_count, const u16* cp_tbl, int num, int heap );

//-----------------------------------------------------------------------------
/**
 *	O[oϐ
 *
 */
//-----------------------------------------------------------------------------
#define ZENKOKU_POKEON_TBL_NUM	(MONSNO_END)
//----------------------------------------------------------------------------
/**
 *
 *	@brief	O[of[^
 *
 *	@param	p_glb				O[of[^
 *	@param	p_init				f[^
 *	@param	heap				q[v
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_GLBDATA_Init( ZKN_GLB_DATA* p_glb, ZKN_GLB_DATA_INIT* p_init, int heap )
{
	int sort_type;
	int search_name;
	int search_type1;
	int search_type2;
	int search_form;
	BOOL check;
	
	memset( p_glb, 0, sizeof(ZKN_GLB_DATA) );

	// }ӃZ[uf[^ݒ
	p_glb->cp_zukansave_data = p_init->cp_zukansave_data;

	// ԑ
	p_glb->time_zone = p_init->time_zone;

	// S}ӂȂS}Ӄ[hŊJn
	if( ZukanWork_GetZenkokuZukanFlag( p_glb->cp_zukansave_data ) ){
		p_glb->zkn_mode = ZKN_MODE_ZENKOKU;
		p_glb->zkn_allmap_get = TRUE;

		// |PXgf[^쐬
		sort_type	= ZKN_POKELIST_SORT_NORMAL;
		search_name = ZKN_POKELIST_SEARCH_NAME_NONE;
		search_type1= ZKN_POKELIST_SEARCH_TYPE_NONE;
		search_type2= ZKN_POKELIST_SEARCH_TYPE_NONE;
		search_form = ZKN_POKELIST_SEARCH_FORM_NONE;
	}else{
		// VIE[hŊJn
		p_glb->zkn_mode = ZKN_MODE_SHINOH;
		p_glb->zkn_allmap_get = FALSE;

		// |PXgf[^쐬
		sort_type	= ZKN_POKELIST_SORT_NORMAL;
		search_name = ZKN_POKELIST_SEARCH_NAME_NONE;
		search_type1= ZKN_POKELIST_SEARCH_TYPE_NONE;
		search_type2= ZKN_POKELIST_SEARCH_TYPE_NONE;
		search_form = ZKN_POKELIST_SEARCH_FORM_NONE;
	}
	// |PXg쐬
	check = ZKN_GLBDATA_PokeListTblMake( p_glb, sort_type, 
			search_name, search_type1, search_type2, search_form,
			p_glb->zkn_mode, heap );
	// Xg쐬ʂ0
	GF_ASSERT( check );

/*
	// 擾
	p_glb->see_num = ZukanWork_GetPokeSeeCount( p_glb->cp_zukansave_data );
	
	// ߊl擾
	p_glb->get_num = ZukanWork_GetPokeGetCount( p_glb->cp_zukansave_data );

//*/

	// R[h
	p_glb->rom_code = MyStatus_GetRomCode( p_init->cp_hero_data );

	// l
	p_glb->hero_sex = MyStatus_GetMySex( p_init->cp_hero_data );	

	// lO
	p_glb->hero_name = MyStatus_CreateNameString( p_init->cp_hero_data, heap );

	// df[^擾
	p_glb->height_gram = ZKN_HEIGHTGRAM_Alloc( heap );
	// j`FbN
	if( p_glb->hero_sex == 0 ){
		ZKN_HEIGHTGRAM_Load( p_glb->height_gram, ZKN_HEIGHT_GRAM_TYPE_MAN, heap );
	}else{
		ZKN_HEIGHTGRAM_Load( p_glb->height_gram, ZKN_HEIGHT_GRAM_TYPE_GIRL, heap );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	O[of[^j
 *
 *	@param	p_glb	O[of[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_GLBDATA_Delete( ZKN_GLB_DATA* p_glb )
{

	// l
	STRBUF_Delete( p_glb->hero_name );
	
	// f[^
	ZKN_HEIGHTGRAM_Release( p_glb->height_gram );
	ZKN_HEIGHTGRAM_Free( p_glb->height_gram );
	p_glb->height_gram = NULL;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pio[̃|P\鐫ʂ擾
 *
 *	@param	cp_glb		O[of[^
 *	@param	monsno		X^[io[
 *	@param	count		ZUKAN_WORK_SEX_FIRST@ZUKAN_WORK_SEX_SECOND
 *
 *	@retval	PARA_MALE		IX
 *	@retval	PARA_FEMALE		X
 *	@retval	PARA_UNK		s
 */
//-----------------------------------------------------------------------------
u32 ZKN_GLBDATA_SaveData_SexGet( const ZKN_GLB_DATA* cp_glb, int monsno, int count )
{
	u32 sex;
	sex = ZukanWork_GetPokeSexFlag( cp_glb->cp_zukansave_data, monsno, count );
	return sex;
}

//----------------------------------------------------------------------------
/**
 *	@brief	Am[tH[̎擾
 *
 *	@param	cp_glb		O[of[^
 *	@param	count		(0`27)
 *
 *	@return	tHio[
 */
//-----------------------------------------------------------------------------
u32 ZKN_GLBDATA_SaveData_AnoonFormGet( const ZKN_GLB_DATA* cp_glb, int count )
{
	int form;
	GF_ASSERT( count < 28 );

	form = ZukanWork_GetPokeAnoonForm( cp_glb->cp_zukansave_data, count );

	return form;
}

//----------------------------------------------------------------------------
/**
 *	@brief	E~EVGAID擾
 *
 *	@param	cp_glb		O[of[^
 *	@param	count				(0`2)
 *
 *	@return	E~EVGAID
 */
//-----------------------------------------------------------------------------
u32 ZKN_GLBDATA_SaveData_UmiushiAreaGet( const ZKN_GLB_DATA* cp_glb, int count )
{
	int area;
	GF_ASSERT( count < 2 );

	area = ZukanWork_GetPokeUmiushiArea( cp_glb->cp_zukansave_data, count );

	return area;
}

//----------------------------------------------------------------------------
/**
 *	@brief	~mVGAID擾
 *
 *	@param	cp_glb		O[of[^
 *	@param	count				(0`2)
 *
 *	@return	~mVGAID
 */
//-----------------------------------------------------------------------------
u32 ZKN_GLBDATA_SaveData_MinomushiAreaGet( const ZKN_GLB_DATA* cp_glb, int count )
{
	int area;
	GF_ASSERT( count < 2 );

	area = ZukanWork_GetPokeMinomushiArea( cp_glb->cp_zukansave_data, count );

	return area;
}

//----------------------------------------------------------------------------
/**	
 *	@brief	ʂ̐擾
 *
 *	@param	cp_glb	`O[o
 *	@param	monsno	X^[io[
 *
 *	@return	ʂ̐
 */
//-----------------------------------------------------------------------------
u32 ZKN_GLBDATA_SaveData_SexNumGet( const ZKN_GLB_DATA* cp_glb, int monsno )
{
	int sex = ZKN_GLBDATA_SaveData_SexGet( cp_glb, monsno, ZUKAN_WORK_SEX_SECOND );
	
	
	// 2ڂ̐ʂ݂`FbN
	if( sex == ZUKAN_WORK_GET_SEX_ERR ){
		return 1;
	}

	return 2;
}

//----------------------------------------------------------------------------
/**
 *	@brief	Am[̎ނ擾
 *
 *	@param	cp_glb	O[o
 *
 *	@return	
 */
//-----------------------------------------------------------------------------
u32 ZKN_GLBDATA_SaveData_AnoonNumGet( const ZKN_GLB_DATA* cp_glb )
{
	return ZukanWork_GetPokeAnoonSeeNum( cp_glb->cp_zukansave_data );
}

//----------------------------------------------------------------------------
/**
 *	@brief	E~EV|P
 *
 *	@param	cp_glb 
 *
 *	@return	
 */
//-----------------------------------------------------------------------------
u32 ZKN_GLBDATA_SaveData_UmiushiNumGet( const ZKN_GLB_DATA* cp_glb )
{
	return ZukanWork_GetPokeUmiushiSeeNum( cp_glb->cp_zukansave_data );
}

//----------------------------------------------------------------------------
/**
 *	@brief@~mV|P
 *
 *	@param	cp_glb 
 *
 *	@return	
 */
//-----------------------------------------------------------------------------
u32 ZKN_GLBDATA_SaveData_MinomushiNumGet( const ZKN_GLB_DATA* cp_glb )
{
	return ZukanWork_GetPokeMinomushiSeeNum( cp_glb->cp_zukansave_data );
}




//----------------------------------------------------------------------------
/**
 *	@brief	OtBbNo[WtO擾
 *
 *	@param	cp_glb	O[o
 *
 *	@retval	TRUE	o[WAbv
 *	@retval	FALSE	o[WAbv
 */
//-----------------------------------------------------------------------------
BOOL ZKN_GLBDATA_SaveData_GraModeGet( const ZKN_GLB_DATA* cp_glb )
{
	return ZukanWork_GetGraphicVersionUpFlag( cp_glb->cp_zukansave_data );
}

//----------------------------------------------------------------------------
/**
 *	@brief	o[WtO擾
 *
 *	@param	cp_glb		O[o
 *	@param	country		R[h 
 *
 *	@retval	TRUE	o[WAbv
 *	@retval	FALSE	o[WAbv
 */
//-----------------------------------------------------------------------------
BOOL ZKN_GLBDATA_SaveData_TextModeGet( const ZKN_GLB_DATA* cp_glb, int country )
{
//	return ZukanWork_GetTextVersionUpFlag( cp_glb->cp_zukansave_data, country );
	return FALSE;
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXge[u̍쐬
 *
 *	@param	p_glb			O[of[^
 *	@param	sort_type		\[g^Cv
 *	@param	search_name		OT[`
 *	@param	search_type1	^CvT[`
 *	@param	search_type2	^CvT[`
 *	@param	search_form		tH[T[`
 *	@param	shinoh			VIE}ӂȂTRUE
 *	@param	heap			gpq[v
 *	
 *	@retval	TRUE	쐬
 *	@retval	FALSE	쐬ʃXgO
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL ZKN_GLBDATA_PokeListTblMake( ZKN_GLB_DATA* p_glb, int sort_type, int search_name, int search_type1, int search_type2, int search_form, int shinoh, int heap )
{
	
	u16* p_buff0;	// ްpe[uobt@
	int count0;
	u16* p_buff1;	// ʎ󂯎pe[uobt@
	int count1;
	u16* p_all_list_data;	// đOS߹ؽް
	int all_list_data_count;
	BOOL ret;

	// obt@̈m
	p_buff0 = sys_AllocMemoryLo( heap, sizeof(u16) * POKEMON_LIST_TBL_NUM );
	GF_ASSERT( p_buff0 );
	memset( p_buff0, 0, sizeof(u16) * POKEMON_LIST_TBL_NUM );
	count0 = 0;
	p_buff1 = sys_AllocMemoryLo( heap, sizeof(u16) * POKEMON_LIST_TBL_NUM );
	GF_ASSERT( p_buff1 );
	memset( p_buff1, 0, sizeof(u16) * POKEMON_LIST_TBL_NUM );
	count1 = 0;

	// |Pf[^VIEe[u玝Ă̂
	// S}ӂĂ̂
	if( shinoh == ZKN_MODE_SHINOH ){
		// VIE
		p_all_list_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_SHINOH, &all_list_data_count );
		ZknPokeListTblMakeSortData( p_buff0, &count0, p_glb->cp_zukansave_data, p_all_list_data, all_list_data_count );
	}else{
		// S
		p_all_list_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_ZENKOKU, &all_list_data_count );
		ZknPokeListTblMakeSortData( p_buff0, &count0, p_glb->cp_zukansave_data, p_all_list_data, all_list_data_count );
	}
	
	// 
	ZknPokeListSort_Core( sort_type, p_buff1, &count1, p_buff0, count0, heap );
	memcpy( p_buff0, p_buff1, sizeof(u16) * count1 );	// f[^Rs[
	count0 = count1;
	memset( p_buff1, 0, sizeof(u16) * count1 );
	count1 = 0;
	
	// 
	do{
		// Ȃ܂񂳂
		ZknPokeListSarchName_Core( search_name, p_buff1, &count1, p_buff0, count0, heap );
		if( count1 == 0 ){
			ret = FALSE;
			break;
		}
		memcpy( p_buff0, p_buff1, sizeof(u16) * count1 );	// f[^Rs[
		count0 = count1;
		memset( p_buff1, 0, sizeof(u16) * count1 );
		count1 = 0;

		// ^Cv
		ZknPokeListSarchType_Core( search_type1, p_buff1, &count1, p_buff0, count0, heap );
		if( count1 == 0 ){
			ret = FALSE;
			break;
		}
		memcpy( p_buff0, p_buff1, sizeof(u16) * count1 );	// f[^Rs[
		count0 = count1;
		memset( p_buff1, 0, sizeof(u16) * count1 );
		count1 = 0;

		// 2
		ZknPokeListSarchType_Core( search_type2, p_buff1, &count1, p_buff0, count0, heap );
		if( count1 == 0 ){
			ret = FALSE;
			break;
		}
		memcpy( p_buff0, p_buff1, sizeof(u16) * count1 );	// f[^Rs[
		count0 = count1;
		memset( p_buff1, 0, sizeof(u16) * count1 );
		count1 = 0;

		// 
		ZknPokeListSarchForm_Core( search_form, p_buff1, &count1, p_buff0, count0, heap );
		if( count1 == 0 ){
			ret = FALSE;
			break;
		}
		memcpy( p_buff0, p_buff1, sizeof(u16) * count1 );	// f[^Rs[
		count0 = count1;
		memset( p_buff1, 0, sizeof(u16) * count1 );
		count1 = 0;


		// ް烊Xg쐬
		// |PXgf[^쐬
		ZknPokeListTblMake( &p_glb->poke_list, p_glb->cp_zukansave_data, p_buff0, count0 );

		// \[gƂ̓Rs[̂
		// X^[io[ŃXg쐬Ƃ̓X^[io[ŕ`惊Xg쐬
		if( (sort_type == ZKN_POKELIST_SORT_NORMAL) &&
			(search_name == ZKN_POKELIST_SEARCH_NAME_NONE) &&
			(search_type1 == ZKN_POKELIST_SEARCH_TYPE_NONE) &&
			(search_type2 == ZKN_POKELIST_SEARCH_TYPE_NONE) &&
			(search_form == ZKN_POKELIST_SEARCH_FORM_NONE) ){
			ZknPokeListDrawTblMake( &p_glb->poke_list, p_all_list_data, all_list_data_count );
		}else{
			ZknPokeListDrawTblCopy( &p_glb->poke_list );
		}
		ret = TRUE;
	}while(0);
	

	// ݂@߂܂vZ
	ZknPokeListTblSeeGetNumCount( &p_glb->poke_list, &p_glb->see_num, &p_glb->get_num );
	

	// obt@j
	sys_FreeMemoryEz( p_buff0 );
	sys_FreeMemoryEz( p_buff1 );
	sys_FreeMemoryEz( p_all_list_data );

	return ret;
}


//----------------------------------------------------------------------------
/**
 *	@brief	S}Ӄ[hɕύXł邩`FbN
 *
 *	@param	cp_glb		O[of[^
 *	@param	zkn_mode	ύX}Ӄ[h
 *
 *	@retval	TRUE	o
 *	@retval FALSE	oȂ
 */
//-----------------------------------------------------------------------------
BOOL ZKN_GLBDATA_PokeZknModeChengeCheck( const ZKN_GLB_DATA* cp_glb, int zkn_mode )
{
	// VIE}ӂ͖
	if( zkn_mode == ZKN_MODE_SHINOH ){
		return TRUE;
	}

	// S͑S}ӂĂOK
	if( cp_glb->zkn_allmap_get ){
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	}Ӄ[hύX
 *
 *	@param	p_glb		O[of[^
 *	@param	zkn_mode	}Ӄ[h
 *
 *	@retval	TRUE		ύXł
 *	@retval	FALSE		ύXłȂ
 */
//-----------------------------------------------------------------------------
BOOL ZKN_GLBDATA_PokeZknModeChenge( ZKN_GLB_DATA* p_glb, int zkn_mode )
{
	BOOL check;

	check = ZKN_GLBDATA_PokeZknModeChengeCheck( p_glb, zkn_mode );

	if( check ){
		p_glb->zkn_mode = zkn_mode;
	}


	return check;
}

//----------------------------------------------------------------------------
/**
 *	@brief	}Ӄ[h擾
 *
 *	@param	cp_glb	O[of[^
 *
 *	@return	}Ӄ[h
 */
//-----------------------------------------------------------------------------
int ZKN_GLBDATA_PokeZknModeGet( const ZKN_GLB_DATA* cp_glb )
{
	return cp_glb->zkn_mode;
}

//----------------------------------------------------------------------------
/**	
 *	@brief	|PXge[uio[ݒ\
 *
 *	@param	cp_glb		O[of[^
 *	@param	no			`FbNio[
 *
 *	@retval	TRUE	ݒ\
 *	@retval	FALSE	ݒs\
 */
//-----------------------------------------------------------------------------
BOOL ZKN_GLBDATA_PokeListTblNoSetCheck( const ZKN_GLB_DATA* cp_glb, int no )
{
	// ݒ\`FbN
	if( ((no) >= 0) &&
		((no) < cp_glb->poke_list.tbl_poke_num) ){
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PXge[uio[ݒ
 *
 *	@param	p_glb		O[of[^
 *	@param	no			ݒio[
 *
 *	@retval	TRUE	ݒ萬
 *	@retval	FALSE	ݒ莸s	ilsj
 */
//-----------------------------------------------------------------------------
BOOL ZKN_GLBDATA_PokeListTblNoSet( ZKN_GLB_DATA* p_glb, int no )
{
	// ݒ\`FbN
	if( ZKN_GLBDATA_PokeListTblNoSetCheck( p_glb, no ) ){
		p_glb->poke_list.tbl_no = no;
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	Z
 *
 *	@param	p_glb	O[of[^
 *	@param	no		l
 *
 *	@retval	TRUE	ݒ萬
 *	@retval	FALSE	ݒ莸s		0ő吔ɂȂĂ܂
 */
//-----------------------------------------------------------------------------
BOOL ZKN_GLBDATA_PokeListTblNoAdd( ZKN_GLB_DATA* p_glb, int no )
{
	if( ZKN_GLBDATA_PokeListTblNoSetCheck( p_glb, p_glb->poke_list.tbl_no + no ) ){
		p_glb->poke_list.tbl_no += no;
		return TRUE;
	}

	if( no >= 0 ){
		p_glb->poke_list.tbl_no = p_glb->poke_list.tbl_poke_num - 1;
	}else{
		p_glb->poke_list.tbl_no = 0;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	e[uio[擾
 *
 *	@param	cp_glb	O[of[^
 *
 *	@return	݂̃e[uio[
 */
//-----------------------------------------------------------------------------
int ZKN_GLBDATA_PokeListTblNoGet( const ZKN_GLB_DATA* cp_glb )
{
	return cp_glb->poke_list.tbl_no;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PXge[u擾
 *
 *	@param	cp_glb	O[of[^
 *
 *	@return	e[u
 */
//-----------------------------------------------------------------------------
int ZKN_GLBDATA_PokeListTblNumGet( const ZKN_GLB_DATA* cp_glb )
{
	return cp_glb->poke_list.tbl_poke_num;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pio[擾
 *
 *	@param	cp_glb	O[of[^
 *
 *	@return	|Pio[
 */
//-----------------------------------------------------------------------------
int ZKN_GLBDATA_PokeMonsNoGet( const ZKN_GLB_DATA* cp_glb )
{
	return cp_glb->poke_list.zkn_pokelist_tbl[ cp_glb->poke_list.tbl_no ].mons_no;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|P@ߊl@^Cv擾
 *
 *	@param	cp_glb	O[of[^
 *
 *	@retval	ZKN_POKELIST_TYPE_NONE,	// 킩Ȃ
 *	@retval ZKN_POKELIST_TYPE_SEE,	// 
 *	@retval	ZKN_POKELIST_TYPE_GET,	// ߂܂
 */
//-----------------------------------------------------------------------------
int ZKN_GLBDATA_PokeMonsTypeGet( const ZKN_GLB_DATA* cp_glb )
{
	return cp_glb->poke_list.zkn_pokelist_tbl[ cp_glb->poke_list.tbl_no ].type;
}


//----------------------------------------------------------------------------
/**
 *	@brief	|PXge[u擾
 *
 *	@param	cp_glb		O[of[^
 *	@param	tbl_no		e[[uio[
 *
 *	@return	e[u|C^
 */
//-----------------------------------------------------------------------------
const ZKN_POKELIST_DATA* ZKN_GLBDATA_PokeListTblGet( const ZKN_GLB_DATA* cp_glb, int tbl_no )
{
	//擾\ 
	if( ZKN_GLBDATA_PokeListTblNoSetCheck( cp_glb, tbl_no ) ){
		return &cp_glb->poke_list.zkn_pokelist_tbl[ tbl_no ];
	}

	return NULL;
}

//----------------------------------------------------------------------------
/**
 *	@brief	`|PXg̃e[uio[ݒ`FbN
 *
 *	@param	cp_glb	O[of[^
 *	@param	no		ݒio[
 *
 *	@retval	TRUE 
 *	@retval	FALSE s
 */
//-----------------------------------------------------------------------------
BOOL ZKN_GLBDATA_PokeListDrawTblNoSetCheck( const ZKN_GLB_DATA* cp_glb, int no )
{
	if( (cp_glb->poke_list.draw_tbl_poke_num > no) && (no >= 0) ){
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	`|PXgio[ݒ
 *
 *	@param	p_glb	O[o
 *	@param	no		|PXge[uio[
 *	
 *	@retval	TRUE 
 *	@retval	FALSE s
 */
//-----------------------------------------------------------------------------
BOOL ZKN_GLBDATA_PokeListDrawTblNoSet( ZKN_GLB_DATA* p_glb, int no )
{
	if( ZKN_GLBDATA_PokeListDrawTblNoSetCheck( p_glb, no ) ){
		p_glb->poke_list.draw_tbl_no = no;

		// |PXgɂf
		ZKN_GLBDATA_PokeListTblNoSet( p_glb, p_glb->poke_list.zkn_pokelistdraw_tbl[ p_glb->poke_list.draw_tbl_no ] );
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	`|PXgio[Z
 *
 *	@param	p_glb
 *	@param	no 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
BOOL ZKN_GLBDATA_PokeListDrawTblNoAdd( ZKN_GLB_DATA* p_glb, int no )
{
	if( ZKN_GLBDATA_PokeListDrawTblNoSetCheck( p_glb, p_glb->poke_list.draw_tbl_no + no ) ){
		p_glb->poke_list.draw_tbl_no += no;

		// |PXgɂf
		ZKN_GLBDATA_PokeListTblNoSet( p_glb, p_glb->poke_list.zkn_pokelistdraw_tbl[ p_glb->poke_list.draw_tbl_no ] );
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	`e[uio[擾
 *
 *	@param	cp_glb	ݕ`O[oio[ݒ
 *
 *	@return	
 */
//-----------------------------------------------------------------------------
int ZKN_GLBDATA_PokeListDrawTblNoGet( const ZKN_GLB_DATA* cp_glb )
{
	return cp_glb->poke_list.draw_tbl_no;
}

//----------------------------------------------------------------------------
/**
 *	@brief	`e[u擾
 *
 *	@param	cp_glb 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
int ZKN_GLBDATA_PokeListDrawTblNumGet( const ZKN_GLB_DATA* cp_glb )
{
	return cp_glb->poke_list.draw_tbl_poke_num;
}

//----------------------------------------------------------------------------
/**
 *	@brief	\f[^e[uio[擾
 *
 *	@param	cp_glb
 *	@param	no 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
int ZKN_GLBDATA_PokeListDrawTblDataGet( const ZKN_GLB_DATA* cp_glb, int no )
{
	return cp_glb->poke_list.zkn_pokelistdraw_tbl[ no ];
}

//----------------------------------------------------------------------------
/**
 *	@brief	̃|PXgIʒuɕ`惊Xgʒu킹
 *
 *	@param	cp_glb	O[o
 *
 *	@return
 */
//-----------------------------------------------------------------------------
void ZKN_GLBDATA_PokeListDrawTblSetNowTblNo( ZKN_GLB_DATA* p_glb )
{
	int i;

	for( i=0; i<p_glb->poke_list.draw_tbl_poke_num; i++ ){

		if( ZKN_GLBDATA_PokeListDrawTblDataGet( p_glb, i ) == ZKN_GLBDATA_PokeListTblNoGet( p_glb ) ){
			
			ZKN_GLBDATA_PokeListDrawTblNoSet( p_glb, i );
			break;
		}
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	|P擾
 *
 *	@param	cp_glb	O[of[^
 *
 *	@return	
 */
//-----------------------------------------------------------------------------
int ZKN_GLBDATA_PokeSeeNumGet( const ZKN_GLB_DATA* cp_glb )
{
	return cp_glb->see_num;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pߊl擾
 *
 *	@param	cp_glb	O[of[^v
 *
 *	@return	ߊl
 */
//-----------------------------------------------------------------------------
int ZKN_GLBDATA_PokeGetNumGet( const ZKN_GLB_DATA* cp_glb )
{
	return cp_glb->get_num;
}

//----------------------------------------------------------------------------
/**
 *	@brief	
 *
 *	@param	cp_glb	O[of[^
 *
 *	@return	0_C 1p[
 */
//-----------------------------------------------------------------------------
int ZKN_GLBDATA_RomDataGet( const ZKN_GLB_DATA* cp_glb )
{
	return cp_glb->rom_code;
}

//----------------------------------------------------------------------------
/**
 *	@brief	l
 *
 *	@param	cp_glb	O[of[^
 *
 *	@return	l
 */
//-----------------------------------------------------------------------------
STRBUF* ZKN_GLBDATA_HeroNameGet( const ZKN_GLB_DATA* cp_glb )
{
	return cp_glb->hero_name;
}

//----------------------------------------------------------------------------
/**
 *	@brief	l
 *
 *	@param	cp_glb	O[of[^
 *
 *	@return	
 */
//-----------------------------------------------------------------------------
u32 ZKN_GLBDATA_HeroSexGet( const ZKN_GLB_DATA* cp_glb )
{
	return cp_glb->hero_sex;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|POeLXgo[WtO擾
 *
 *	@param	cp_glb	O[of[^
 *	@param	lang	R[h
 *
 *	@retval	TRUE	tOĂ
 *	@retval	FALSE	tOĂȂ
 */
//-----------------------------------------------------------------------------
BOOL ZKN_GLBDATA_PokeTextVersionFlagGet( const ZKN_GLB_DATA* cp_glb, int lang )
{
	int monsno = ZKN_GLBDATA_PokeMonsNoGet( cp_glb );

	return ZukanWork_GetTextVersionUpFlag( cp_glb->cp_zukansave_data, monsno, lang );
}

//----------------------------------------------------------------------------
/**
 *	@brief	OtBbNo[WtO
 *
 *	@param	cp_glb	O[of[^
 *
 *	@retval	TRUE o[WAbvς
 *	@retval	FALSE o[WAbvĂȂ
 */
//-----------------------------------------------------------------------------
BOOL ZKN_GLBDATA_PokeGraphicVersionFlagGet( const ZKN_GLB_DATA* cp_glb )
{
	return ZukanWork_GetGraphicVersionUpFlag( cp_glb->cp_zukansave_data );
}

//----------------------------------------------------------------------------
/**
 *	@brief	^b`pl@J[\tO؂ւ
 *
 *	@param	cp_glb	O[of[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_GLBDATA_TouchCursorFlagSet( ZKN_GLB_DATA* cp_glb )
{
	// ^b`plD
	if( sys.tp_cont ){
		cp_glb->touch_cursor_flag = ZKN_TCHCUSO_TOUCHPANEL;
		return ;
	}

	// L[͗DxႢ
	if( sys.cont ){
		cp_glb->touch_cursor_flag = ZKN_TCHCUSO_CURSOR;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	^b`plJ[\tO擾
 *
 *	@param	cp_glb	O[of[^
 *
 *	@retval	ZKN_TCHCUSO_TOUCHPANEL		^b`plōs
 *	@retval ZKN_TCHCUSO_CURSOR			J[\ōs
 */
//-----------------------------------------------------------------------------
BOOL ZKN_GLBDATA_TouchCursorFlagGet( const ZKN_GLB_DATA* cp_glb )
{
	return cp_glb->touch_cursor_flag;
}




//-----------------------------------------------------------------------------
/**
 *		vCx[g֐
 */
//-----------------------------------------------------------------------------

//----------------------------------------------------------------------------
/**
 *
 *	@brief	VIE@S@Xg獡߂܂Ă|PXg쐬
 *
 *	@param	p_buff				Xg쐬		(e[uȏ゠邱)
 *	@param	p_count				JEg
 *	@param	cp_zukansave_data	}ӃZ[uf[^
 *	@param	cp_tbl				\[ge[u
 *	@param	num					e[u
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void ZknPokeListTblMakeSortData( u16* p_buff, int* p_count, const ZUKAN_WORK* cp_zukansave_data, const u16* cp_tbl, int num )
{
	int i;			// [vp

	*p_count = 0;
	for( i=0; i<num; i++ ){
		
		// Ƃ邩`FbN
		if( ZukanWork_GetPokeSeeFlag( cp_zukansave_data, cp_tbl[ i ] ) ){
			p_buff[ *p_count ] = cp_tbl[ i ];
			(*p_count) ++;
		}
		
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\[gĂe[uȂ炳ɍi荞
 *
 *	@param	p_buff		f[^i[
 *	@param	p_count		JE^
 *	@param	cp_tbl		\[gς݃f[^e[u
 *	@param	num			e[u
 *	@param	cp_sarch_tbl@T[`e[u
 *	@param	sarch_num	T[`e[u
 *
 *	@return	none
 *		
 */
//-----------------------------------------------------------------------------
static void ZknPokeListTblMakeSarch( u16* p_buff, int* p_count, const u16* cp_tbl, int num, const u16* cp_sarch_tbl, int sarch_num )
{
	int i,j;			// [vp

	*p_count = 0;
	for( i=0; i<num; i++ ){
		
		for( j=0; j<sarch_num; j++ ){
			if( cp_tbl[i] == cp_sarch_tbl[j] ){
				break;
			}
		}
		
		// T[`e[uɂݒ
		if( j < sarch_num ){
			p_buff[ *p_count ] = cp_tbl[ i ];
			(*p_count) ++;
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	}Ӄ|PXge[u쐬֐
 *
 *	@param	p_poke_list			쐬
 *	@param	cp_zukansave_data	}ӃZ[uf[^
 *	@param	cp_tbl				|PŃ\[gς݃e[u
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void ZknPokeListTblMake( ZKN_POKELIST_TBL* p_poke_list, const ZUKAN_WORK* cp_zukansave_data, const u16* cp_tbl, int tbl_num )
{
	int i;	// [vp

	p_poke_list->tbl_poke_num = 0;
	for( i=0; i<tbl_num; i++ ){
		
		// ߂܂Ƃ邩`FbN
		if( ZukanWork_GetPokeGetFlag( cp_zukansave_data, cp_tbl[ i ] ) ){
			p_poke_list->zkn_pokelist_tbl[ p_poke_list->tbl_poke_num ].type = ZKN_POKELIST_TYPE_GET;
		}else{
			p_poke_list->zkn_pokelist_tbl[ p_poke_list->tbl_poke_num ].type = ZKN_POKELIST_TYPE_SEE;
		}

		p_poke_list->zkn_pokelist_tbl[ p_poke_list->tbl_poke_num ].mons_no = cp_tbl[ i ];

		p_poke_list->tbl_poke_num ++;
	}
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	}Ӄ|PXg`e[u쐬֐
 *
 *	@param	p_poke_list			쐬
 *	@param	cp_all_tbl			\[gf[^
 *	@param	tbl_num				e[u
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void ZknPokeListDrawTblMake( ZKN_POKELIST_TBL* p_poke_list, const u16* cp_all_tbl, int all_tbl_num )
{
	int i;	// [vp
	int count;

	// f[^`f[^쐬		̏Ȃf[^_~[ƂĊi[
	count = 0;
	p_poke_list->draw_tbl_poke_num = 0;
	for( i=0; i<all_tbl_num; i++ ){
		
		// e[uȏɂȂI
		if( count < p_poke_list->tbl_poke_num ){
			if( p_poke_list->zkn_pokelist_tbl[ count ].mons_no == cp_all_tbl[ i ] ){
				p_poke_list->zkn_pokelistdraw_tbl[ p_poke_list->draw_tbl_poke_num ] = count;
				count ++;
				p_poke_list->draw_tbl_poke_num++;

			}else{
				p_poke_list->zkn_pokelistdraw_tbl[ p_poke_list->draw_tbl_poke_num ] = POKEMON_LIST_DRAWTBL_DUMMY;
				p_poke_list->draw_tbl_poke_num++;
			}
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PXg`e[uRs[
 *
 *	@param	p_poke_list		|PXgf[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListDrawTblCopy( ZKN_POKELIST_TBL* p_poke_list )
{
	int i;	// [vp

	p_poke_list->draw_tbl_poke_num = 0;
	for( i=0; i<p_poke_list->tbl_poke_num; i++ ){
		
		p_poke_list->zkn_pokelistdraw_tbl[ p_poke_list->draw_tbl_poke_num ] = i;
		p_poke_list->draw_tbl_poke_num++;
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	\[gް擾
 *
 *	@param	heap		q[v
 *	@param	idx			ްޯ
 *	@param	p_arry_num	zvf擾
 *
 *	@return	ްobt@		vfp_arry_numɊi[
 */
//-----------------------------------------------------------------------------
static u16* ZKN_SORTDATA_Get( int heap, int idx, int* p_arry_num )
{
	u32 size;
	u16* p_buf;
	
	GF_ASSERT( ZKN_SORTDATA_NUM > idx );
	

	// ǂݍ
	p_buf = ArcUtil_LoadEx( ARC_ZUKAN_DATA, ZKN_SORTDATA_START_IDX + idx, FALSE, heap, ALLOC_TOP, &size );

	*p_arry_num = size / ZKN_SORTDATA_ONESIZE;

	return p_buf;
}


//----------------------------------------------------------------------------
/**
 *	@brief	ď@s
 *
 *	@param	sort_type		
 *	@param	p_buff			ʊi[
 *	@param	p_count			ʂ̗vfi[
 *	@param	cp_tbl			ް
 *	@param	num				ް
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSort_Core( int sort_type, u16* p_buff, int* p_count, const u16* cp_tbl, int num, int heap )
{
	u16* p_sort_data;	// ް
	int sort_data_count;
	

	// тI
	switch( sort_type ){
	case ZKN_POKELIST_SORT_NORMAL:		// |Pio[
		// ̂܂
		p_sort_data = NULL;
		break;
		
	case ZKN_POKELIST_SORT_GOZYUUON:		// ܏\
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_AIUEO, &sort_data_count );
		break;
		
	case ZKN_POKELIST_SORT_GRAM_L:		// d
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_HEAVY, &sort_data_count );
		break;
		
	case ZKN_POKELIST_SORT_GRAM_S:		// y
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_LIGHT, &sort_data_count );
		break;
		
	case ZKN_POKELIST_SORT_HIGH_L:		// 
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_TALL, &sort_data_count );
		break;
		
	case ZKN_POKELSIT_SOTT_HIGH_S:		// Ⴂ
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_SMALL, &sort_data_count );
		break;
		
	default:
		GF_ASSERT(0);
		break;
	}

	if( p_sort_data != NULL ){
		ZknPokeListTblMakeSarch( p_buff, p_count,  p_sort_data, sort_data_count, cp_tbl, num );
		sys_FreeMemoryEz( p_sort_data );
	}else{

		// ̂܂܃Rs[
		memcpy( p_buff, cp_tbl, ZKN_SORTDATA_ONESIZE * num );
		*p_count = num;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	O
 *
 *	@param	search_name		
 *	@param	p_buff			i[obt@
 *	@param	p_count			obt@vf
 *	@param	cp_tbl			ް
 *	@param	num				ްvf
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSarchName_Core( int search_name, u16* p_buff, int* p_count, const u16* cp_tbl, int num, int heap )
{
	u16* p_sort_data;	// ް
	int sort_data_count;

	// Ȃ܂
	switch( search_name ){
	case ZKN_POKELIST_SEARCH_NAME_NONE:
		// ̂܂
		p_sort_data = NULL;
		break;
	case ZKN_POKELIST_SEARCH_NAME_A:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_NAME_A, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_NAME_KA:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_NAME_KA, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_NAME_SA:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_NAME_SA, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_NAME_TA:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_NAME_TA, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_NAME_NA:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_NAME_NA, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_NAME_HA:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_NAME_HA, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_NAME_MA:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_NAME_MA, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_NAME_RA:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_NAME_RA, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_NAME_YAWA:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_NAME_YAWA, &sort_data_count );
		break;
	default:
		GF_ASSERT(0);
		break;
	}

	if( p_sort_data != NULL ){
		ZknPokeListTblMakeSarch( p_buff, p_count, cp_tbl, num,  p_sort_data, sort_data_count );
		sys_FreeMemoryEz( p_sort_data );
	}else{

		// ̂܂܃Rs[
		memcpy( p_buff, cp_tbl, ZKN_SORTDATA_ONESIZE * num );
		*p_count = num;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	ߌ
 *
 *	@param	search_type		
 *	@param	p_buff			i[obt@
 *	@param	p_count			obt@vf
 *	@param	cp_tbl			ް
 *	@param	num				ްvf
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSarchType_Core( int search_type, u16* p_buff, int* p_count, const u16* cp_tbl, int num, int heap )
{
	u16* p_sort_data;	// ް
	int sort_data_count;

	// 
	switch( search_type ){
	case ZKN_POKELIST_SEARCH_TYPE_NONE:
		p_sort_data = NULL;
		break;
	case ZKN_POKELIST_SEARCH_TYPE_NORMAL:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_TYPE_NORMAL, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_TYPE_BATTLE:	
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_TYPE_BATTLE, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_TYPE_HIKOU:	
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_TYPE_HIKOU, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_TYPE_POISON:	
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_TYPE_POISON, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_TYPE_JIMEN:	
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_TYPE_JIMEN, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_TYPE_IWA:		
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_TYPE_IWA, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_TYPE_MUSHI:	
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_TYPE_MUSHI, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_TYPE_GHOST:	
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_TYPE_GHOST, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_TYPE_METAL:	
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_TYPE_METAL, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_TYPE_FIRE:	
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_TYPE_FIRE, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_TYPE_WATER:	
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_TYPE_WATER, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_TYPE_KUSA:	
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_TYPE_KUSA, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_TYPE_ELECTRIC:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_TYPE_ELECTRIC, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_TYPE_SP:		
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_TYPE_SP, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_TYPE_KOORI:	
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_TYPE_KOORI, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_TYPE_DRAGON:	
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_TYPE_DRAGON, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_TYPE_AKU:	
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_TYPE_AKU, &sort_data_count );
		break;

	default:
		GF_ASSERT(0);
		break;
	}

	if( p_sort_data != NULL ){
		ZknPokeListTblMakeSarch( p_buff, p_count, cp_tbl, num,  p_sort_data, sort_data_count );
		sys_FreeMemoryEz( p_sort_data );
	}else{

		// ̂܂܃Rs[
		memcpy( p_buff, cp_tbl, ZKN_SORTDATA_ONESIZE * num );
		*p_count = num;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	`
 *
 *	@param	search_form		
 *	@param	p_buff			i[obt@
 *	@param	p_count			obt@vf
 *	@param	cp_tbl			ް
 *	@param	num				ްvf
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSarchForm_Core( int search_form, u16* p_buff, int* p_count, const u16* cp_tbl, int num, int heap )
{
	u16* p_sort_data;	// ް
	int sort_data_count;

	// 
	switch( search_form ){
	case ZKN_POKELIST_SEARCH_FORM_NONE:
		p_sort_data = NULL;
		break;
	case ZKN_POKELIST_SEARCH_FORM_FOUR_LEGS:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_FORM_FOUR_LEGS, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_FORM_TWO_LEGS:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_FORM_TWO_LEGS, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_FORM_TAIL:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_FORM_TAIL, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_FORM_HARABAI:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_FORM_HARABAI, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_FORM_FOUR_WING:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_FORM_FOUR_WING, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_FORM_TWO_WING:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_FORM_TWO_WING, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_FORM_HAITSUKUBARI:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_FORM_HAITSUKUBARI, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_FORM_STRAIGHT:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_FORM_STRAIGHT, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_FORM_ARM:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_FORM_ARM, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_FORM_LEGS:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_FORM_LEGS, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_FORM_MANY_LEGS:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_FORM_MANY_LEGS, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_FORM_WATER:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_FORM_WATER, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_FORM_CIRCLE:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_FORM_CIRCLE, &sort_data_count );
		break;
	case ZKN_POKELIST_SEARCH_FORM_COMP:
		p_sort_data = ZKN_SORTDATA_Get( heap, ZKN_SORTDATA_FORM_COMP, &sort_data_count );
		break;
	default:
		GF_ASSERT(0);
		break;
	}

	if( p_sort_data != NULL ){
		ZknPokeListTblMakeSarch( p_buff, p_count, cp_tbl, num,  p_sort_data, sort_data_count );
		sys_FreeMemoryEz( p_sort_data );
	}else{

		// ̂܂܃Rs[
		memcpy( p_buff, cp_tbl, ZKN_SORTDATA_ONESIZE * num );
		*p_count = num;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	߹ؽē̌@JEg
 *
 *	@param	p_poke_list		߹ؽăe[u
 *	@param	p_see_num		i[
 *	@param	p_get_num		i[
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknPokeListTblSeeGetNumCount( ZKN_POKELIST_TBL* p_poke_list, int* p_see_num, int* p_get_num )
{
	int i;	// [vp

	*p_see_num = 0;
	*p_get_num = 0;
	
	for( i=0; i<p_poke_list->tbl_poke_num; i++ ){
		if(p_poke_list->zkn_pokelist_tbl[ i ].type == ZKN_POKELIST_TYPE_GET	){

			(*p_get_num)++;
		}
		(*p_see_num)++;
	}
}
