//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		zkn_pokelist_sub.c
 *	@brief		|PXgTu
 *	@author		tomoya takahashi
 *	@data		2006.01.20
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include <string.h>
#include "include/gflib/button_man.h"
#include "include/gflib/calctool.h"


#include "include/application/zukanlist/zkn_pokelist.h"
#include "include/application/zukanlist/zkn_event_func.h"

#include "include/application/zukanlist/zkn_snd_def.h"

#include "include/system/brightness.h"
#include "include/system/arc_util.h"
#include "include/system/msgdata_util.h"
#include "include/msgdata/msg.naix"
#include "include/msgdata/msg_zkn.h"

#include "include/application/zukanlist/zukan.naix"

#include "include/application/zukanlist/zkn_pokelist_sub.h"


//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

#define ZKN_POKELIST_SUB_EVENT_NUM	( 1 )


#define ZKN_POKELIST_SUB_FADEIN_COUNT	( ZKN_FADE_SYNC_LONG_COMMON)
#define ZKN_POKELIST_SUB_FADEOUT_COUNT	( ZKN_FADE_SYNC_LONG_COMMON)



#define ZKN_POKELSIT_SUB_FONT_BMP_SIZE_CX	( 10 )
#define ZKN_POKELSIT_SUB_FONT_BMP_SIZE_CY	( 4 )

//-------------------------------------
//	zC[ʗp萔
//=====================================
#define ZKN_POKELIST_SUB_EVENT_POKELIST		( 0x1 << 0 )	// }ӎޕϊ

#define ZKN_POKELIST_SUB_SEARCH_BUTTON_X	( 48 )
#define ZKN_POKELIST_SUB_ZUKANCHG_BUTTON_X	( 48 )
#define ZKN_POKELIST_SUB_ZUKANSEE_BUTTON_X	( 48 )
#define ZKN_POKELIST_SUB_LISTSTART_BUTTON_X	( 124 )
#define ZKN_POKELIST_SUB_LISTEND_BUTTON_X	( 124 )

#define ZKN_POKELIST_SUB_SEARCH_BUTTON_Y	( 40 )
#define ZKN_POKELIST_SUB_ZUKANCHG_BUTTON_Y	( 88 )
#define ZKN_POKELIST_SUB_ZUKANSEE_BUTTON_Y	( 152 )
#define ZKN_POKELIST_SUB_LISTSTART_BUTTON_Y	( 64 )
#define ZKN_POKELIST_SUB_LISTEND_BUTTON_Y	( 146 )

#define ZKN_POKELIST_SUB_SEARCH_BUTTON_SIZE_X		( 96 )
#define ZKN_POKELIST_SUB_SEARCH_BUTTON_SIZE_Y		( 48 )
#define ZKN_POKELIST_SUB_ZUKANCHG_BUTTON_SIZE_X		( 96 )
#define ZKN_POKELIST_SUB_ZUKANCHG_BUTTON_SIZE_Y		( 48 )
#define ZKN_POKELIST_SUB_ZUKANSEE_BUTTON_SIZE_X		( 96 )
#define ZKN_POKELIST_SUB_ZUKANSEE_BUTTON_SIZE_Y		( 80 )
#define ZKN_POKELIST_SUB_LISTSTART_BUTTON_SIZE_X	( 16 )
#define ZKN_POKELIST_SUB_LISTSTART_BUTTON_SIZE_Y	( 16 )
#define ZKN_POKELIST_SUB_LISTEND_BUTTON_SIZE_X	( 16 )
#define ZKN_POKELIST_SUB_LISTEND_BUTTON_SIZE_Y	( 16 )

#define ZKN_POKELSIT_SUB_SEARCH_BUTTON_SEQ	( 2 )	// XgZbg{^V[PX
#define ZKN_POKELSIT_SUB_ZUKANCHG_BUTTON_SEQ	( 0 )	// Xg̐擪փ{^V[PX
#define ZKN_POKELSIT_SUB_ZUKANSEE_BUTTON_SEQ	( 1 )	// Xg̍Ōփ{^V[PX
#define ZKN_POKELSIT_SUB_LISTSTART_BUTTON_SEQ	( 3 )
#define ZKN_POKELSIT_SUB_LISTEND_BUTTON_SEQ	( 4 )

#define ZKN_POKELIST_SUB_BUTTON_FONT_COL		( 3 )
#define ZKN_POKELIST_SUB_BUTTON_FONT_COL_ZUKAN	( 2 )
#define ZKN_POKELIST_SUB_BUTTON_FONT_COL_CLOSE	( 1 )
#define ZKN_POKELIST_SUB_BUTTON_FONT_PUSH_COL	( 5 )

#define ZKN_POKELIST_SUB_FADE_DEF_X	( ZKN_POKELIST_SUB_BUTTON_X )

#define ZKN_POKELSIT_SUB_MAT_X	( -120 )
#define ZKN_POKELSIT_SUB_MAT_Y	( 0 )
#define ZKN_POKELIST_SUB_BGCX	( 128 )		// BGAtBϊpS
#define ZKN_POKELIST_SUB_BGCY	( 104 )		// BGAtBϊpS
#define ZKN_POKELIST_SUB_CX		( ZKN_POKELIST_SUB_BGCX + (-ZKN_POKELSIT_SUB_MAT_X) )	// S
#define ZKN_POKELIST_SUB_CY		( ZKN_POKELIST_SUB_BGCY + (-ZKN_POKELSIT_SUB_MAT_Y) )	// S
#define ZKN_POKELSIT_SUB_R		( 104 )		// a

#define ZKN_POKELIST_SUB_LOCK_MOVE_MAX	( FX_GET_ROTA_NUM( 90 ) )	// L[̂Ƃ1̃XgƂɉzC[̊px
#define ZKN_POKELIST_SUB_COUNT_R	( ZKN_POKELIST_SUB_LOCK_MOVE_MAX / ZKN_POKELIST_MOVE_END_COUNT )	// ̊pxJEg1Ƃ
#define ZKN_POKELIST_SUB_SUB_R	( 24 )	// px炵Ă
#define ZKN_POKELIST_SUB_SUBLIMIT_R	( ZKN_POKELIST_SUB_COUNT_R + 512 )// l𔽉fȂ~bg
#define ZKN_POKELIST_SUB_SUBDRAWLIMIT_R	( 64 )// l𔽉fȂ~bg
#define ZKN_POKELIST_SUB_SUB_MIN_SP	( 700 )// ȉ̃Xs[ĥƂ͔Ȃ

#define ZKN_POKELIST_SUB_BGFADE_DEF_X	( ZKN_POKELSIT_SUB_MAT_X )

#define ZKN_POKELIST_SUB_FONTOAM_OFS_X	( -40 )
#define ZKN_POKELIST_SUB_FONTOAM_OFS_Y	( -14 )

#define ZKN_POKELIST_SUB_CLACT_NUM	( 3 )


// B{^
#define ZKN_POKELIST_SUB_BUTTON_B_X	( 140 )
#define ZKN_POKELIST_SUB_BUTTON_B_Y	( 8 )
#define ZKN_POKELIST_SUB_BUTTON_B_ANM	( 5 )
#define ZKN_POKELIST_SUB_FONT_B_OFS		( 10 )
#define ZKN_POKELIST_SUB_FONT_B_OFS_Y	( -8 )
#define ZKN_POKELIST_SUB_FONT_B_BMP_CX	( 14 )
#define ZKN_POKELIST_SUB_FONT_B_BMP_CY	( 2 )

// {^萔
enum{
	ZKN_POKELIST_SUB_BUTTON_SEARCH,
	ZKN_POKELIST_SUB_BUTTON_ZUKANCHG,
	ZKN_POKELIST_SUB_BUTTON_ZUKANSEE,
	ZKN_POKELIST_SUB_BUTTON_LISTSTART,
	ZKN_POKELIST_SUB_BUTTON_LISTEND,
	ZKN_POKELIST_SUB_BUTTON_WHEEL,		// zC[
	ZKN_POKELIST_SUB_BUTTON_NUM,
};

// V[PX
enum{
	ZKN_POKELIST_SUB_SEQINIT_ALLOC,
	ZKN_POKELIST_SUB_SEQINIT_LOAD,
	ZKN_POKELIST_SUB_SEQINIT_FADEIN_INIT,
	ZKN_POKELIST_SUB_SEQINIT_FADEIN,
	ZKN_POKELIST_SUB_SEQINIT_END,
};

// jV[PX
enum{
	ZKN_POKELIST_SUB_SEQDELETE_FADEOUT_INIT,
	ZKN_POKELIST_SUB_SEQDELETE_FADEOUT,
	ZKN_POKELIST_SUB_SEQDELETE_RELEASE,
	ZKN_POKELIST_SUB_SEQDELETE_FREE,
	ZKN_POKELIST_SUB_SEQDELETE_END,
};



//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------

//-------------------------------------
//	|PXg@Tu
//	zC[Av@O[of[^
//=====================================
typedef struct {
	int button_event[ ZKN_POKELIST_SUB_BUTTON_NUM ];	// {^Cxgf[^
	ZKN_POKELIST_GLB_DATA* p_pokelist_glb;		// |PXgmainf[^
	int* p_event_key;		// CxgL[
	int heap;
} ZKN_POKELIST_SUB_GLB;

//-------------------------------------
//	|PXg@Tu
//	zC[Av@OtBbNO[of[^
//=====================================
typedef struct {
	ZKN_GLB_DRAWDATA* p_glb_draw;
} ZKN_POKELIST_SUB_GLBDRAW;

//-------------------------------------
//	|PXg@Tu
//	zC[Av@[N
//=====================================
typedef struct {
	// {^}l[W
	BUTTON_MAN* p_button_man;
	void* p_button_work;
	TP_HIT_TBL *hit_tbl;	// {^f[^

	int move_rota;		// ړpx
	int move_rota_list;	// ړpxlfp
	int tp_last_x;
	int tp_last_y;
} ZKN_POKELIST_SUB_WORK;

//-------------------------------------
//	{^p[N
//=====================================
typedef struct {
	ZKN_POKELIST_SUB_WORK* p_work;
	ZKN_POKELIST_SUB_GLB* p_glb;
} ZKN_POKELIST_SUB_BUTTON_WORK;


//-------------------------------------
//	|PXg@Tu
//	zC[Av@`[N
//=====================================
typedef struct {
	CLACT_WORK_PTR clact[ ZKN_POKELIST_SUB_CLACT_NUM ];
	ZKN_FONTOAM_DATA* p_fontoam[ ZKN_POKELIST_SUB_CLACT_NUM ];

	CLACT_WORK_PTR list_start;
	CLACT_WORK_PTR list_end;

	CLACT_WORK_PTR act_B;
	ZKN_FONTOAM_DATA* p_fontoam_B;

	u16 wheel_rota;		// zC[̌݉]p
	u16 save_wheel_rota;// zC[̊pxۑ̈

	// \[XIuWF
	CLACT_U_RES_OBJ_PTR		res_obj[ ZKN_CLACT_RES_OBJ_NUM_DEF ];

} ZKN_POKELIST_SUB_DRAWWORK;





//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *		AvP[Vf[^쐬֌W
 */
//-----------------------------------------------------------------------------

static ZKN_POKELIST_SUB_GLB* MakePokeListSubGlb( int heap, ZKN_SYS_PTR zkn_sys );
static ZKN_POKELIST_SUB_GLBDRAW* MakePokeListSubGlbDraw( int heap, ZKN_SYS_PTR zkn_sys );
static ZKN_EVENT_DATA* MakePokeListSubEvent( int heap, ZKN_SYS_PTR zkn_sys );
static void DeletePokeListSubGlb( ZKN_POKELIST_SUB_GLB* p_glb );
static void DeletePokeListSubGlbDraw( ZKN_POKELIST_SUB_GLBDRAW* p_glb );
static void DeletePokeListSubEvent( ZKN_EVENT_DATA* p_event );

static int EventDataNumGet( void );


//-----------------------------------------------------------------------------
/**
 *		vZX֌W
 */
//-----------------------------------------------------------------------------

static int ZknPokeListSubProcDoFuncInit( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata );
static int ZknPokeListSubProcDoFuncMain( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata );
static int ZknPokeListSubProcDoFuncDelete( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata );
static int ZknPokeListSubProcDrawFuncInit( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata );
static int ZknPokeListSubProcDrawFuncMain( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata );
static int ZknPokeListSubProcDrawFuncDelete( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata );


// {^̓
static void ZknPokelistSubButtonFontMove( CLACT_WORK_PTR act, ZKN_FONTOAM_DATA* p_fontoam, int def_y, int off_pltt, int on_pltt );

static void ZknPokeListSubButtonMake( ZKN_POKELIST_SUB_WORK* p_work, ZKN_POKELIST_SUB_GLB* p_glb, int heap );
static void ZknPokeListSubButtonMove( ZKN_POKELIST_SUB_WORK* p_work, ZKN_POKELIST_SUB_GLB* p_glb );
static void ZknPokeListSubButtonDelete( ZKN_POKELIST_SUB_WORK* p_work );
static void ZknPokeListSubButtonCallBack( u32 button_no, u32 event, void* p_work );
static void ZknPokeListSubButton_KeyMove( ZKN_POKELIST_SUB_GLB* p_glb );

// \[Xǂݍ
static void ZknPokeListSubResLoad( ZKN_POKELIST_SUB_DRAWWORK* p_work, ZKN_POKELIST_SUB_GLBDRAW* p_drawglb, const ZKN_POKELIST_SUB_GLB* cp_glb, int heap );
static void ZknPokeListSubResDelete( ZKN_POKELIST_SUB_DRAWWORK* p_work, ZKN_POKELIST_SUB_GLBDRAW* p_drawglb, int heap );
static void ZknPokeListSubBgLoad( ZKN_POKELIST_SUB_GLBDRAW* p_drawglb, const ZKN_POKELIST_SUB_GLB* cp_glb, int heap );
static void ZknPokeListSubOamResLoad( ZKN_POKELIST_SUB_DRAWWORK* p_work, ZKN_POKELIST_SUB_GLBDRAW* p_drawglb, int heap );
static void ZknPokeListSubOamResRelease( ZKN_POKELIST_SUB_DRAWWORK* p_work, ZKN_POKELIST_SUB_GLBDRAW* p_drawglb );
static void ZknPokeListSubAddClact( ZKN_POKELIST_SUB_DRAWWORK* p_work, ZKN_POKELIST_SUB_GLBDRAW* p_drawglb, const ZKN_POKELIST_SUB_GLB* cp_glb, int heap );
static void ZknPokeListSubDeleteClact( ZKN_POKELIST_SUB_DRAWWORK* p_work );
static void ZknPokeListSubFontMake( ZKN_POKELIST_SUB_DRAWWORK* p_work, ZKN_POKELIST_SUB_GLBDRAW* p_drawglb, const ZKN_POKELIST_SUB_GLB* cp_glb, int heap );
static void ZknPokeListSubFontDelete( ZKN_POKELIST_SUB_DRAWWORK* p_work );

static void ZknPokeListSubBgSetUp( ZKN_POKELIST_SUB_GLBDRAW* p_drawglb, int heap );
static void ZknPokeListSubBgDelete( ZKN_POKELIST_SUB_GLBDRAW* p_drawglb, int heap );

// 
static void ZknPokeListSubListCount( ZKN_POKELIST_SUB_WORK* p_work, ZKN_POKELIST_SUB_GLB* p_glb );
static void ZknPokeListSubMoveRotaGet( ZKN_POKELIST_SUB_WORK* p_work );
static void ZknPokeListSubDrawMove( ZKN_POKELIST_SUB_DRAWWORK* p_drawwork, ZKN_POKELIST_SUB_GLBDRAW* p_drawglb, int add_num );
static void ZknPokeListSubDrawMoveLockTime( ZKN_POKELIST_SUB_DRAWWORK* p_drawwork, ZKN_POKELIST_SUB_GLBDRAW* p_drawglb, const ZKN_POKELIST_SUB_GLB* cp_glb );
static void ZknPokeListSubResist( ZKN_POKELIST_SUB_WORK* p_work, int move_count, int move_way );


//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXg@Tuʁ@zC[AvP[V쐬
 *	
 *	@param	p_data		AvP[Vf[^
 *	@param	zkn_sys		}ӃVXe
 *	@param	heap		q[v
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_PokeListSubAplMake( ZKN_APL_DATA* p_data, ZKN_SYS_PTR zkn_sys, int heap )
{
	ZKN_POKELIST_SUB_GLB*		p_glb;
	ZKN_POKELIST_SUB_GLBDRAW*	p_glbdraw;
	ZKN_EVENT_DATA*	p_event;
	
	p_glb = MakePokeListSubGlb( heap, zkn_sys );
	p_glbdraw = MakePokeListSubGlbDraw( heap, zkn_sys );
	p_event = MakePokeListSubEvent( heap, zkn_sys );

	p_data->p_glb_data		= p_glb;
	p_data->p_glb_draw		= p_glbdraw;
	p_data->p_event_data	= p_event;
	p_data->event_num		= EventDataNumGet();

	p_data->do_func[ ZKN_PROC_FUNC_INIT ] = ZknPokeListSubProcDoFuncInit;
	p_data->do_func[ ZKN_PROC_FUNC_MAIN ] = ZknPokeListSubProcDoFuncMain;
	p_data->do_func[ ZKN_PROC_FUNC_DELETE ] = ZknPokeListSubProcDoFuncDelete;
	p_data->draw_func[ ZKN_PROC_FUNC_INIT ] = ZknPokeListSubProcDrawFuncInit;
	p_data->draw_func[ ZKN_PROC_FUNC_MAIN ] = ZknPokeListSubProcDrawFuncMain;
	p_data->draw_func[ ZKN_PROC_FUNC_DELETE ] = ZknPokeListSubProcDrawFuncDelete;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXg@Tuʁ@zC[Avf[^j
 *
 *	@param	p_data	AvP[Vf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_PokeListSubAplDelete( ZKN_APL_DATA* p_data )
{
	DeletePokeListSubGlb( p_data->p_glb_data ); 
	DeletePokeListSubGlbDraw( p_data->p_glb_data ); 
	DeletePokeListSubEvent( p_data->p_event_data );
}


//-----------------------------------------------------------------------------
/**
 *		vCx[g֐
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXg@Tuʁ@zC[@O[of[^쐬@
 *
 *	@param	heap		q[v
 *	@param	zkn_sys		}ӃVXe
 *	
 *	@return	O[of[^
 *
 *
 */
//-----------------------------------------------------------------------------
static ZKN_POKELIST_SUB_GLB* MakePokeListSubGlb( int heap, ZKN_SYS_PTR zkn_sys )
{
	ZKN_POKELIST_SUB_GLB* p_glb;
	ZKN_APL_DATA* p_apl;
	int i;

	p_glb = sys_AllocMemory( heap, sizeof(ZKN_POKELIST_SUB_GLB) );
	GF_ASSERT( p_glb );
	memset( p_glb, 0, sizeof(ZKN_POKELIST_SUB_GLB) );

	p_apl = ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_POKELIST );
	p_glb->p_pokelist_glb = p_apl->p_glb_data;

	// 
	for( i=0; i<ZKN_POKELIST_SUB_BUTTON_NUM; i++ ){
		p_glb->button_event[ i ] = ZKN_UTIL_BUTTON_PUSH_NONE;
	}

	// CxgL[|C^
	p_glb->p_event_key = ZKN_SYS_GetEventKeyPtrSub( zkn_sys );

	// q[v
	p_glb->heap = heap;

	return p_glb;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXg@Tuʁ@zC[@O[of[^쐬@
 *
 *	@param	heap		q[v
 *	@param	zkn_sys		}ӃVXe
 *	
 *	@return	O[of[^
 *
 *
 */
//-----------------------------------------------------------------------------
static ZKN_POKELIST_SUB_GLBDRAW* MakePokeListSubGlbDraw( int heap, ZKN_SYS_PTR zkn_sys )
{
	ZKN_POKELIST_SUB_GLBDRAW* p_glb;
	ZKN_APL_DATA* p_apl;

	p_glb = sys_AllocMemory( heap, sizeof(ZKN_POKELIST_SUB_GLBDRAW) );
	GF_ASSERT( p_glb );
	memset( p_glb, 0, sizeof(ZKN_POKELIST_SUB_GLBDRAW) );

	p_glb->p_glb_draw = ZKN_SYS_GetGlbDrawData( zkn_sys );

	return p_glb;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXg@Tuʁ@zC[@Cxgf[^쐬@
 *
 *	@param	heap		q[v
 *	@param	zkn_sys		}ӃVXe
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static ZKN_EVENT_DATA* MakePokeListSubEvent( int heap, ZKN_SYS_PTR zkn_sys )
{
	ZKN_EVENT_DATA* p_event_tbl;	// Cxge[u쐬
	int event_num = EventDataNumGet();

	// Cxge[um
	p_event_tbl = sys_AllocMemory( heap, sizeof(ZKN_EVENT_DATA) * event_num );
	GF_ASSERT( p_event_tbl );
	memset( p_event_tbl, 0, sizeof(ZKN_EVENT_DATA) * event_num );

	
	// Cxgf[^쐬
	ZKN_EVENT_MakeStartMainPokeList( &p_event_tbl[0], zkn_sys, heap, ZKN_POKELIST_SUB_EVENT_POKELIST );

	return p_event_tbl;
}	

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXg@Tuʁ@zC[@	O[of[^j
 *
 *	@param	p_glb	O[of[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void DeletePokeListSubGlb( ZKN_POKELIST_SUB_GLB* p_glb )
{
	GF_ASSERT( p_glb );

	sys_FreeMemoryEz( p_glb );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXg@Tuʁ@zC[@	O[of[^j
 *
 *	@param	p_glb	O[of[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void DeletePokeListSubGlbDraw( ZKN_POKELIST_SUB_GLBDRAW* p_glb )
{
	GF_ASSERT( p_glb );

	sys_FreeMemoryEz( p_glb );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXg@Tuʁ@zC[@	Cxgf[^j
 *
 *	@param	p_event		Cxgf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void DeletePokeListSubEvent( ZKN_EVENT_DATA* p_event )
{
	GF_ASSERT( p_event );
	
	// Cxgf[^j
	ZKN_EVENT_DeleteData( &p_event[0] );

	sys_FreeMemoryEz( p_event );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	zC[AvCxg擾
 *
 *	@param	none
 *
 *	@return	zC[AvCxgf[^
 *
 *
 */
//-----------------------------------------------------------------------------
static int EventDataNumGet( void )
{
	return ZKN_POKELIST_SUB_EVENT_NUM;
}

//-----------------------------------------------------------------------------
/**
 *		vZX֌W
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	[]
 *	@brief	AvP[VvZX	f[^ύX
 *
 *	@param	p_dodata	ZKN_PROC_DO_DATA
 *	@param	p_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknPokeListSubProcDoFuncInit( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata )
{
	ZKN_POKELIST_SUB_GLB*  p_glb = p_glbdata;

	p_dodata->p_work = sys_AllocMemory( p_dodata->heap, sizeof(ZKN_POKELIST_SUB_WORK) );
	GF_ASSERT(p_dodata->p_work);
	memset( p_dodata->p_work, 0, sizeof(ZKN_POKELIST_SUB_WORK) );

	
	// {^f[^쐬
	ZknPokeListSubButtonMake( p_dodata->p_work, p_glb, p_dodata->heap );
	return ZKN_PROC_TRUE;
}

//----------------------------------------------------------------------------
/**
 *	[C]
 *	@brief	AvP[VvZX	f[^ύX
 *
 *	@param	p_dodata	ZKN_PROC_DO_DATA
 *	@param	p_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknPokeListSubProcDoFuncMain( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata )
{
	ZKN_POKELIST_SUB_GLB*  p_glb = p_glbdata;
	ZKN_POKELIST_SUB_WORK* p_work = p_dodata->p_work;
	

	// I
	if( p_dodata->end_req == TRUE ){
		return ZKN_PROC_TRUE;
	}

	// lock
	if( p_dodata->lock == TRUE ){
		return ZKN_PROC_FALSE;
	}

	// zC[̉]px炵Ă
	ZknPokeListSubResist( p_work, p_glb->p_pokelist_glb->move_count, p_glb->p_pokelist_glb->move_way );

	// {^Cxg
	ZknPokeListSubButtonMove( p_work, p_glb );

	// XgJEg
	if( p_glb->p_pokelist_glb->sub_wheel_lock == FALSE ){		
		// CʂTuzC[lockĂȂΓ
		ZknPokeListSubListCount( p_work, p_glb );
	}else{
		p_work->move_rota = 0;	// lockꂽƂ߂
	}

	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 *	[j]
 *	@brief	AvP[VvZX	f[^ύX
 *
 *	@param	p_dodata	ZKN_PROC_DO_DATA
 *	@param	p_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknPokeListSubProcDoFuncDelete( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata )
{
	// {^f[^j
	ZknPokeListSubButtonDelete( p_dodata->p_work );
	
	// j
	sys_FreeMemoryEz( p_dodata->p_work );
	return ZKN_PROC_TRUE;
}

//----------------------------------------------------------------------------
/**
 * []
 *
 *	@brief	AvP[VvZX	`
 *
 *	@param	p_glbdraw	`O[of[^
 *	@param	p_drawdata	ZKN_PROC_DRAW_DATA
 *	@param	cp_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *	@param	cp_dodata	̏̓[Nf[^
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknPokeListSubProcDrawFuncInit( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata )
{
	const ZKN_POKELIST_SUB_GLB* cp_glb = cp_glbdata;
	const ZKN_POKELIST_SUB_WORK* cp_datawork = cp_dodata->p_work;
	ZKN_POKELIST_SUB_GLBDRAW* p_drawglb = p_glbdraw;
	ZKN_POKELIST_SUB_DRAWWORK* p_drawwork = p_drawdata->p_work;
	BOOL check;

	switch( p_drawdata->seq ){
	case ZKN_POKELIST_SUB_SEQINIT_ALLOC:
		// m
		p_drawdata->p_work = sys_AllocMemory( p_drawdata->heap, sizeof(ZKN_POKELIST_SUB_DRAWWORK) );
		GF_ASSERT( p_drawdata->p_work );
		memset( p_drawdata->p_work, 0, sizeof(ZKN_POKELIST_SUB_DRAWWORK) );
		p_drawdata->seq++;
		break;

	case ZKN_POKELIST_SUB_SEQINIT_LOAD:
		ZknPokeListSubResLoad( p_drawwork, p_drawglb, cp_glb, p_drawdata->heap );
		p_drawdata->seq++;
		break;
		
	case ZKN_POKELIST_SUB_SEQINIT_FADEIN_INIT:
		ChangeBrightnessRequest( ZKN_POKELIST_SUB_FADEIN_COUNT, 
				BRIGHTNESS_NORMAL, BRIGHTNESS_BLACK, PLANEMASK_ALL, MASK_SUB_DISPLAY );

		p_drawdata->seq++;
		break;
		
	case ZKN_POKELIST_SUB_SEQINIT_FADEIN:
		if( IsFinishedBrightnessChg( MASK_SUB_DISPLAY  ) ){
			p_drawdata->seq++;
		}
		break;

	case ZKN_POKELIST_SUB_SEQINIT_END:
		p_drawdata->seq++;
		return ZKN_PROC_TRUE;

	}

	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 * [C]
 *
 *	@brief	AvP[VvZX	`
 *
 *	@param	p_glbdraw	`O[of[^
 *	@param	p_drawdata	ZKN_PROC_DRAW_DATA
 *	@param	cp_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *	@param	cp_dodata	̏̓[Nf[^
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknPokeListSubProcDrawFuncMain( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata )
{
	const ZKN_POKELIST_SUB_GLB* cp_glb = cp_glbdata;
	const ZKN_POKELIST_SUB_WORK* cp_datawork = cp_dodata->p_work;
	ZKN_POKELIST_SUB_GLBDRAW* p_drawglb = p_glbdraw;
	ZKN_POKELIST_SUB_DRAWWORK* p_drawwork = p_drawdata->p_work;

	
	// {^
	ZKN_UTIL_ButtonMove( p_drawwork->clact[ ZKN_POKELIST_SUB_BUTTON_SEARCH ],
			cp_glb->button_event[ ZKN_POKELIST_SUB_BUTTON_SEARCH ] );
	ZKN_UTIL_ButtonMove( p_drawwork->clact[ ZKN_POKELIST_SUB_BUTTON_ZUKANCHG ], cp_glb->button_event[ ZKN_POKELIST_SUB_BUTTON_ZUKANCHG ] );
	ZKN_UTIL_ButtonMove( p_drawwork->clact[ ZKN_POKELIST_SUB_BUTTON_ZUKANSEE ], cp_glb->button_event[ ZKN_POKELIST_SUB_BUTTON_ZUKANSEE ] );
	ZKN_UTIL_ButtonMove( p_drawwork->list_start, cp_glb->button_event[ ZKN_POKELIST_SUB_BUTTON_LISTSTART ] );
	ZKN_UTIL_ButtonMove( p_drawwork->list_end, cp_glb->button_event[ ZKN_POKELIST_SUB_BUTTON_LISTEND ] );

	// {^
	ZknPokelistSubButtonFontMove( 
			p_drawwork->clact[ ZKN_POKELIST_SUB_BUTTON_SEARCH ],
			p_drawwork->p_fontoam[ ZKN_POKELIST_SUB_BUTTON_SEARCH ],
			ZKN_POKELIST_SUB_FONTOAM_OFS_Y,
			ZKN_POKELIST_SUB_BUTTON_FONT_COL,
			ZKN_POKELIST_SUB_BUTTON_FONT_PUSH_COL );
	ZknPokelistSubButtonFontMove( p_drawwork->clact[ ZKN_POKELIST_SUB_BUTTON_ZUKANCHG ], p_drawwork->p_fontoam[ ZKN_POKELIST_SUB_BUTTON_ZUKANCHG ],
			ZKN_POKELIST_SUB_FONTOAM_OFS_Y,
			ZKN_POKELIST_SUB_BUTTON_FONT_COL,
			ZKN_POKELIST_SUB_BUTTON_FONT_PUSH_COL );
	ZknPokelistSubButtonFontMove( p_drawwork->clact[ ZKN_POKELIST_SUB_BUTTON_ZUKANSEE ], p_drawwork->p_fontoam[ ZKN_POKELIST_SUB_BUTTON_ZUKANSEE ],
			ZKN_POKELIST_SUB_FONTOAM_OFS_Y,
			ZKN_POKELIST_SUB_BUTTON_FONT_COL_ZUKAN,
			ZKN_POKELIST_SUB_BUTTON_FONT_PUSH_COL );

	// zC[
	if( cp_glb->p_pokelist_glb->sub_wheel_lock == FALSE ){
		ZknPokeListSubDrawMove( p_drawwork, p_drawglb, cp_datawork->move_rota );		
	}else{
		// lockĂƂ̓
		ZknPokeListSubDrawMoveLockTime( p_drawwork, p_drawglb, cp_glb );
	}
	
	return ZKN_PROC_FALSE;
}
	
//----------------------------------------------------------------------------
/**
 * [j]
 *
 *	@brief	AvP[VvZX	`
 *
 *	@param	p_glbdraw	`O[of[^
 *	@param	p_drawdata	ZKN_PROC_DRAW_DATA
 *	@param	cp_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *	@param	cp_dodata	̏̓[Nf[^
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknPokeListSubProcDrawFuncDelete( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata )
{
	const ZKN_POKELIST_SUB_GLB* cp_glb = cp_glbdata;
	const ZKN_POKELIST_SUB_WORK* cp_datawork = cp_dodata->p_work;
	ZKN_POKELIST_SUB_GLBDRAW* p_drawglb = p_glbdraw;
	ZKN_POKELIST_SUB_DRAWWORK* p_drawwork = p_drawdata->p_work;
	BOOL check;

	
	switch( p_drawdata->seq ){
	case ZKN_POKELIST_SUB_SEQDELETE_FADEOUT_INIT:
		ChangeBrightnessRequest( ZKN_POKELIST_SUB_FADEIN_COUNT, 
				BRIGHTNESS_BLACK, BRIGHTNESS_NORMAL, PLANEMASK_ALL, MASK_SUB_DISPLAY );
		
		p_drawdata->seq++;
		break;
		
	case ZKN_POKELIST_SUB_SEQDELETE_FADEOUT:
		if( IsFinishedBrightnessChg( MASK_SUB_DISPLAY  ) ){
			p_drawdata->seq++;
		}
		break;

	case ZKN_POKELIST_SUB_SEQDELETE_RELEASE:
		ZknPokeListSubResDelete( p_drawwork, p_drawglb, p_drawdata->heap );
		p_drawdata->seq++;
		break;
		
	case ZKN_POKELIST_SUB_SEQDELETE_FREE:
		sys_FreeMemoryEz( p_drawdata->p_work );
		p_drawdata->p_work = NULL;
		p_drawdata->seq++;
		break;
		
	case ZKN_POKELIST_SUB_SEQDELETE_END:
		return ZKN_PROC_TRUE;
	}
	
	return ZKN_PROC_FALSE;
}


//----------------------------------------------------------------------------
/**
 *	@brief	zC[ʃ{^쐬
 *
 *	@param	p_work	zC[[N
 *	@param	p_glb	O[of[^
 *	@param	heap	q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSubButtonMake( ZKN_POKELIST_SUB_WORK* p_work, ZKN_POKELIST_SUB_GLB* p_glb, int heap )
{
	ZKN_POKELIST_SUB_BUTTON_WORK* p_button_work;
	
	// e[u쐬
	p_work->hit_tbl = sys_AllocMemory( heap, sizeof(TP_HIT_TBL) * ZKN_POKELIST_SUB_BUTTON_NUM );

	// e[uf[^ݒ
	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl[ ZKN_POKELIST_SUB_BUTTON_SEARCH ],
			ZKN_POKELIST_SUB_SEARCH_BUTTON_Y - (ZKN_POKELIST_SUB_SEARCH_BUTTON_SIZE_Y/2),
			ZKN_POKELIST_SUB_SEARCH_BUTTON_Y + (ZKN_POKELIST_SUB_SEARCH_BUTTON_SIZE_Y/2),
			ZKN_POKELIST_SUB_SEARCH_BUTTON_X - (ZKN_POKELIST_SUB_SEARCH_BUTTON_SIZE_X/2),
			ZKN_POKELIST_SUB_SEARCH_BUTTON_X + (ZKN_POKELIST_SUB_SEARCH_BUTTON_SIZE_X/2) );

	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl[ ZKN_POKELIST_SUB_BUTTON_ZUKANCHG ],
			ZKN_POKELIST_SUB_ZUKANCHG_BUTTON_Y - (ZKN_POKELIST_SUB_ZUKANCHG_BUTTON_SIZE_Y/2),
			ZKN_POKELIST_SUB_ZUKANCHG_BUTTON_Y + (ZKN_POKELIST_SUB_ZUKANCHG_BUTTON_SIZE_Y/2),
			ZKN_POKELIST_SUB_ZUKANCHG_BUTTON_X - (ZKN_POKELIST_SUB_ZUKANCHG_BUTTON_SIZE_X/2),
			ZKN_POKELIST_SUB_ZUKANCHG_BUTTON_X + (ZKN_POKELIST_SUB_ZUKANCHG_BUTTON_SIZE_X/2) );

	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl[ ZKN_POKELIST_SUB_BUTTON_ZUKANSEE ],
			ZKN_POKELIST_SUB_ZUKANSEE_BUTTON_Y - (ZKN_POKELIST_SUB_ZUKANSEE_BUTTON_SIZE_Y/2),
			ZKN_POKELIST_SUB_ZUKANSEE_BUTTON_Y + (ZKN_POKELIST_SUB_ZUKANSEE_BUTTON_SIZE_Y/2),
			ZKN_POKELIST_SUB_ZUKANSEE_BUTTON_X - (ZKN_POKELIST_SUB_ZUKANSEE_BUTTON_SIZE_X/2),
			ZKN_POKELIST_SUB_ZUKANSEE_BUTTON_X + (ZKN_POKELIST_SUB_ZUKANSEE_BUTTON_SIZE_X/2) );

	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl[ ZKN_POKELIST_SUB_BUTTON_LISTSTART ],
			ZKN_POKELIST_SUB_LISTSTART_BUTTON_Y - (ZKN_POKELIST_SUB_LISTSTART_BUTTON_SIZE_Y/2),
			ZKN_POKELIST_SUB_LISTSTART_BUTTON_Y + (ZKN_POKELIST_SUB_LISTSTART_BUTTON_SIZE_Y/2),
			ZKN_POKELIST_SUB_LISTSTART_BUTTON_X - (ZKN_POKELIST_SUB_LISTSTART_BUTTON_SIZE_X/2),
			ZKN_POKELIST_SUB_LISTSTART_BUTTON_X + (ZKN_POKELIST_SUB_LISTSTART_BUTTON_SIZE_X/2) );

	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl[ ZKN_POKELIST_SUB_BUTTON_LISTEND ],
			ZKN_POKELIST_SUB_LISTEND_BUTTON_Y - (ZKN_POKELIST_SUB_LISTEND_BUTTON_SIZE_Y/2),
			ZKN_POKELIST_SUB_LISTEND_BUTTON_Y + (ZKN_POKELIST_SUB_LISTEND_BUTTON_SIZE_Y/2),
			ZKN_POKELIST_SUB_LISTEND_BUTTON_X - (ZKN_POKELIST_SUB_LISTEND_BUTTON_SIZE_X/2),
			ZKN_POKELIST_SUB_LISTEND_BUTTON_X + (ZKN_POKELIST_SUB_LISTEND_BUTTON_SIZE_X/2) );

	p_work->hit_tbl[ ZKN_POKELIST_SUB_BUTTON_WHEEL ].circle.code = TP_USE_CIRCLE;
	p_work->hit_tbl[ ZKN_POKELIST_SUB_BUTTON_WHEEL ].circle.x	 = ZKN_POKELIST_SUB_CX;
	p_work->hit_tbl[ ZKN_POKELIST_SUB_BUTTON_WHEEL ].circle.y	 = ZKN_POKELIST_SUB_CY;
	p_work->hit_tbl[ ZKN_POKELIST_SUB_BUTTON_WHEEL ].circle.r	 = ZKN_POKELSIT_SUB_R;

	// {^p[N쐬
	p_button_work = sys_AllocMemory( heap, sizeof(ZKN_POKELIST_SUB_BUTTON_WORK) );	
	p_button_work->p_work = p_work;
	p_button_work->p_glb  = p_glb;
	p_work->p_button_work = p_button_work;


	// {^}l[W쐬
	p_work->p_button_man = BMN_Create( 
			p_work->hit_tbl,
			ZKN_POKELIST_SUB_BUTTON_NUM,
			ZknPokeListSubButtonCallBack,
			p_button_work,
			heap );
}

//----------------------------------------------------------------------------
/**
 *	@brief	zC[{^
 *
 *	@param	p_work	[N
 *	@param	p_glb	O[of[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSubButtonMove( ZKN_POKELIST_SUB_WORK* p_work, ZKN_POKELIST_SUB_GLB* p_glb )
{
	int i;
	
	// ꂽSẴ{^̊Gɖ߂
	for( i = 0; i < ZKN_POKELIST_SUB_BUTTON_NUM; i++ ){
		p_glb->button_event[ i ] = ZKN_UTIL_BUTTON_PUSH_NONE;
	}

	// L[ɂ{^
	ZknPokeListSubButton_KeyMove( p_glb );
	
	// ^b`plɂ{^
	BMN_Main( p_work->p_button_man );

}

//----------------------------------------------------------------------------
/**
 *	@brief	zC[{^j
 *
 *	@param	p_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSubButtonDelete( ZKN_POKELIST_SUB_WORK* p_work )
{
	BMN_Delete( p_work->p_button_man );

	sys_FreeMemoryEz( p_work->p_button_work );

	// e[u[Nj
	sys_FreeMemoryEz( p_work->hit_tbl );
	p_work->hit_tbl = NULL;
}

//----------------------------------------------------------------------------
/**
 *	@brief	zC[{^R[obN
 *
 *	@param	button_no	{^io[
 *	@param	event		Cxgio[
 *	@param	p_work		[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSubButtonCallBack( u32 button_no, u32 event, void* p_work )
{
	ZKN_POKELIST_SUB_BUTTON_WORK* p_button_work = p_work;
	ZKN_POKELIST_SUB_GLB* p_glb = p_button_work->p_glb;
	ZKN_POKELIST_SUB_WORK* p_datawork = p_button_work->p_work;
	ZKN_GLB_DATA* p_zkn_glb = p_glb->p_pokelist_glb->p_glb;
	int poketbl_num;
	int zkn_mode;


	// {^Cxgf[^ݒ
	p_glb->button_event[ button_no ] = event;

	switch( event ){
	case BMN_EVENT_TOUCH:
		p_datawork->tp_last_x = sys.tp_x;
		p_datawork->tp_last_y = sys.tp_y;
		break;

	case BMN_EVENT_HOLD:
		switch( button_no ){
		case ZKN_POKELIST_SUB_BUTTON_SEARCH:
			p_glb->p_pokelist_glb->sort_chg = TRUE;
			break;

		case ZKN_POKELIST_SUB_BUTTON_ZUKANCHG:
			p_glb->p_pokelist_glb->zukan_chg = TRUE;
			break;
				
		case ZKN_POKELIST_SUB_BUTTON_ZUKANSEE:
			p_glb->p_pokelist_glb->zukan_see = TRUE;
			break;
			
		case ZKN_POKELIST_SUB_BUTTON_LISTSTART:
			ZKN_GLBDATA_PokeListTblNoSet( p_zkn_glb, 0 );

			(*p_glb->p_event_key) |= ZKN_POKELIST_SUB_EVENT_POKELIST;
			// JE^
			 p_glb->p_pokelist_glb->move_count = 0;	
			// zC[̓~߂
			p_datawork->move_rota = 0;
			// tF[hC[hύX
			p_glb->p_pokelist_glb->fade_mode = ZKN_POKELIST_BG_FADE_SHUTTER;
			p_glb->p_pokelist_glb->fade_zukan_data = FALSE;
			// Ȃ
			p_glb->p_pokelist_glb->move_way = ZKN_POKE_LIST_NO_MOVE;
			// \̕ύX̓tF[hIĂ
			p_glb->p_pokelist_glb->move_draw = FALSE;
			break;
			
		case ZKN_POKELIST_SUB_BUTTON_LISTEND:
			poketbl_num = ZKN_GLBDATA_PokeListTblNumGet( p_zkn_glb );
			ZKN_GLBDATA_PokeListTblNoSet( p_zkn_glb, poketbl_num - 1 );
			(*p_glb->p_event_key) |= ZKN_POKELIST_SUB_EVENT_POKELIST;
			// JE^
			p_glb->p_pokelist_glb->move_count = 0;	
			// zC[̓~߂
			p_datawork->move_rota = 0;
			// tF[hC[hύX
			p_glb->p_pokelist_glb->fade_mode = ZKN_POKELIST_BG_FADE_SHUTTER;
			p_glb->p_pokelist_glb->fade_zukan_data = FALSE;
			// Ȃ
			p_glb->p_pokelist_glb->move_way = ZKN_POKE_LIST_NO_MOVE;
			// \̕ύX̓tF[hIĂ
			p_glb->p_pokelist_glb->move_draw = FALSE;
			break;

		default:
			break;
		}

		if( button_no == ZKN_POKELIST_SUB_BUTTON_WHEEL ){
 
			// CʑŃ^b`plz[hĂȂ`FbN
			if( p_glb->p_pokelist_glb->sub_wheel_lock == FALSE ){
				// ړpx߂
				ZknPokeListSubMoveRotaGet( p_datawork );	

				// ]pZKN_POKELIST_SUB_SUB_MIN_SPȂOɂ
				if( (p_datawork->move_rota <= ZKN_POKELIST_SUB_SUB_MIN_SP) &&
					(p_datawork->move_rota >= -ZKN_POKELIST_SUB_SUB_MIN_SP) ){
					p_datawork->move_rota = 0;
				}

			}

			p_datawork->tp_last_x = sys.tp_x;
			p_datawork->tp_last_y = sys.tp_y;
		}
		break;

	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PXgTuʁ@\[Xǂݍ
 *
 *	@param	p_work		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	cp_glb		O[of[^
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSubResLoad( ZKN_POKELIST_SUB_DRAWWORK* p_work, ZKN_POKELIST_SUB_GLBDRAW* p_drawglb, const ZKN_POKELIST_SUB_GLB* cp_glb, int heap )
{
	// wi
	ZknPokeListSubBgLoad( p_drawglb, cp_glb, heap );

	// zC[
	ZknPokeListSubBgSetUp( p_drawglb, heap );

	// OAM
	ZknPokeListSubOamResLoad( p_work, p_drawglb, heap );

	// ZAN^[o^
	ZknPokeListSubAddClact( p_work, p_drawglb, cp_glb, heap );

	// FONTOAMo^
	ZknPokeListSubFontMake( p_work, p_drawglb, cp_glb, heap );

	// BGD揇ʕύX
	GF_BGL_PrioritySet( ZKN_BG_FRM_AFFINE_S, 3 );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PXgTuʁ@\[Xj
 *
 *	@param	p_work		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSubResDelete( ZKN_POKELIST_SUB_DRAWWORK* p_work, ZKN_POKELIST_SUB_GLBDRAW* p_drawglb, int heap )
{
	// FONTOAM
	ZknPokeListSubFontDelete( p_work );

	// CLACT
	ZknPokeListSubDeleteClact( p_work );

	// OAM
	ZknPokeListSubOamResRelease( p_work, p_drawglb );

	// BG
	ZknPokeListSubBgDelete( p_drawglb, heap );

	// BGD揇ʕύX
	GF_BGL_PrioritySet( ZKN_BG_FRM_AFFINE_S, 1 );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PXgTuʁ@BGʂ̐ݒ
 *
 *	@param	p_drawglb	`O[o
 *	@param	cp_glb		O[of[^
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSubBgLoad( ZKN_POKELIST_SUB_GLBDRAW* p_drawglb, const ZKN_POKELIST_SUB_GLB* cp_glb, int heap )
{
	void* buff;
	NNSG2dScreenData* p_scrn;
	GF_BGL_INI* p_bg = p_drawglb->p_glb_draw->p_bg;

	
	
	// pbgf[^]
	ZKN_GLBDATA_PalSet( p_drawglb->p_glb_draw, NARC_zukan_zkn_list_NCLR, PALTYPE_SUB_BG, 0, 0, heap );

	// Ӱނ̎͐FύX
	if( cp_glb->p_pokelist_glb->p_glb->sort_search_flag == ZKN_SORTSEARCH_SORT ){

		ZKN_GLBDATA_PalSet( p_drawglb->p_glb_draw, NARC_zukan_zkn_list2_NCLR, PALTYPE_SUB_BG, 96, 32, heap );
	}

	
	// LN^f[^]
	ZKN_GLBDATA_BgCharSet( p_drawglb->p_glb_draw, NARC_zukan_zkn_list_sub_lzh_NCGR, p_bg, ZKN_BG_FRM_BACK_S, 0, 0, TRUE, heap );

	// XN[f[^ǂݍ
	buff = ZKN_GLBDATA_ScrnDataGet( p_drawglb->p_glb_draw, NARC_zukan_zkn_list_bg_sub1_lzh_NSCR, TRUE, &p_scrn, heap );
	
	// XN[f[^
	GF_BGL_ScrWrite( p_bg, ZKN_BG_FRM_BACK_S,
			p_scrn->rawData, 0, 0,
			p_scrn->screenWidth / 8, p_scrn->screenHeight / 8 );

	sys_FreeMemoryEz( buff );
	
	// XN[f[^]
	GF_BGL_LoadScreenV_Req(p_bg, ZKN_BG_FRM_BACK_S );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PXgTuʁ@OAM\[Xǂݍ
 *
 *	@param	p_work		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSubOamResLoad( ZKN_POKELIST_SUB_DRAWWORK* p_work, ZKN_POKELIST_SUB_GLBDRAW* p_drawglb, int heap )
{
	ZKN_GLB_DRAWDATA* p_draw_glb = p_drawglb->p_glb_draw;
	ARCHANDLE* p_handle = ZKN_GLBDATA_ArcHandlGet( p_drawglb->p_glb_draw );
	
	// LN^f[^ǂݍ
	p_work->res_obj[ CLACT_U_CHAR_RES ] = CLACT_U_ResManagerResAddArcChar_ArcHandle( 
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ], p_handle,
			NARC_zukan_zkn_list_oam_sub_lzh_NCGR, TRUE,
			NARC_zukan_zkn_list_oam_sub_lzh_NCGR + ZKN_POKELIST_SUB_RES_ID_OFS,
			NNS_G2D_VRAM_TYPE_2DSUB, heap );
	// ]
	CLACT_U_CharManagerSetAreaCont( p_work->res_obj[ CLACT_U_CHAR_RES ] );
	// OtBbNf[^j
	CLACT_U_ResManagerResOnlyDelete( p_work->res_obj[ CLACT_U_CHAR_RES ] );

	// pbgf[^ǂݍ
	p_work->res_obj[ CLACT_U_PLTT_RES ] = CLACT_U_ResManagerResAddArcPltt_ArcHandle( 
			p_draw_glb->res_manager[ CLACT_U_PLTT_RES ], p_handle,
			NARC_zukan_zkn_list_oam_NCLR, FALSE, 
			NARC_zukan_zkn_list_oam_NCLR + ZKN_POKELIST_SUB_RES_ID_OFS, 
			NNS_G2D_VRAM_TYPE_2DSUB, 
			ZKN_POKELIST_SUB_TBL_PLTT_LOAD, heap );
	// ]
	CLACT_U_PlttManagerSetCleanArea( p_work->res_obj[ CLACT_U_PLTT_RES ] );	
	// OtBbNf[^j
	CLACT_U_ResManagerResOnlyDelete( p_work->res_obj[ CLACT_U_PLTT_RES ] );


	// Zf[^ǂݍ
	p_work->res_obj[ CLACT_U_CELL_RES ] = CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ], p_handle,
			NARC_zukan_zkn_list_oam_sub_lzh_NCER, TRUE,
			NARC_zukan_zkn_list_oam_sub_lzh_NCER + ZKN_POKELIST_SUB_RES_ID_OFS,
			CLACT_U_CELL_RES, heap );

	// ZAjf[^ǂݍ
	p_work->res_obj[ CLACT_U_CELLANM_RES ] = CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ], p_handle, 
			NARC_zukan_zkn_list_oam_sub_lzh_NANR, TRUE,
			NARC_zukan_zkn_list_oam_sub_lzh_NANR + ZKN_POKELIST_SUB_RES_ID_OFS,
			CLACT_U_CELLANM_RES, heap );

}

//----------------------------------------------------------------------------
/**
 *	@brief	|PXgTuʁ@OAM\[Xj
 *
 *	@param	p_work		`惏[N
 *	@param	p_drawglb	`O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSubOamResRelease( ZKN_POKELIST_SUB_DRAWWORK* p_work, ZKN_POKELIST_SUB_GLBDRAW* p_drawglb )
{
	ZKN_GLB_DRAWDATA* p_draw_glb = p_drawglb->p_glb_draw;


	CLACT_U_CharManagerDelete( p_work->res_obj[ CLACT_U_CHAR_RES ] );
	CLACT_U_PlttManagerDelete( p_work->res_obj[ CLACT_U_PLTT_RES ] );

	// \[Xj
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ],
			p_work->res_obj[ CLACT_U_CHAR_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_PLTT_RES ],
			p_work->res_obj[ CLACT_U_PLTT_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ],
			p_work->res_obj[ CLACT_U_CELL_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ],
			p_work->res_obj[ CLACT_U_CELLANM_RES ] );

}

//----------------------------------------------------------------------------
/**
 *	@brief	zC[ZAN^[o^
 *
 *	@param	p_work		[N
 *	@param	p_drawglb	`O[of[^
 *	@param	cp_glb		O[of[^
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSubAddClact( ZKN_POKELIST_SUB_DRAWWORK* p_work, ZKN_POKELIST_SUB_GLBDRAW* p_drawglb, const ZKN_POKELIST_SUB_GLB* cp_glb, int heap )
{
	CLACT_HEADER		clact_head;
	CLACT_ADD_SIMPLE	add;
	ZKN_GLB_DRAWDATA*	p_draw_glb = p_drawglb->p_glb_draw;
	
	// AN^[wb_[쐬
	CLACT_U_MakeHeader( &clact_head,
			NARC_zukan_zkn_list_oam_sub_lzh_NCGR + ZKN_POKELIST_SUB_RES_ID_OFS,
			NARC_zukan_zkn_list_oam_NCLR + ZKN_POKELIST_SUB_RES_ID_OFS, 
			NARC_zukan_zkn_list_oam_sub_lzh_NCER + ZKN_POKELIST_SUB_RES_ID_OFS,
			NARC_zukan_zkn_list_oam_sub_lzh_NANR + ZKN_POKELIST_SUB_RES_ID_OFS,
			CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE, 0, 0,
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ],
			p_draw_glb->res_manager[ CLACT_U_PLTT_RES ],
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ],
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ],
			NULL, NULL );

	// o^ʕݒ
	add.ClActSet	= p_draw_glb->clact_set;
	add.ClActHeader = &clact_head;
	add.pri			= 8;
	add.DrawArea	= NNS_G2D_VRAM_TYPE_2DSUB;
	add.heap		= heap;
	
	// |PT
	add.mat.x = ZKN_POKELIST_SUB_SEARCH_BUTTON_X << FX32_SHIFT;
	add.mat.y = ZKN_POKELIST_SUB_SEARCH_BUTTON_Y << FX32_SHIFT;
	add.mat.y += SUB_SURFACE_Y;
	p_work->clact[ ZKN_POKELIST_SUB_BUTTON_SEARCH ] = CLACT_AddSimple( &add );
	CLACT_AnmChg( p_work->clact[ ZKN_POKELIST_SUB_BUTTON_SEARCH ],
			ZKN_POKELSIT_SUB_SEARCH_BUTTON_SEQ );
	// Ӱނ͔̎\
	if( cp_glb->p_pokelist_glb->p_glb->sort_search_flag == ZKN_SORTSEARCH_SORT ){
		CLACT_SetDrawFlag( p_work->clact[ ZKN_POKELIST_SUB_BUTTON_SEARCH ], FALSE );
	}

	// }ӂ؂ւ
	add.mat.x = ZKN_POKELIST_SUB_ZUKANCHG_BUTTON_X << FX32_SHIFT;
	add.mat.y = ZKN_POKELIST_SUB_ZUKANCHG_BUTTON_Y << FX32_SHIFT;
	add.mat.y += SUB_SURFACE_Y;
	p_work->clact[ ZKN_POKELIST_SUB_BUTTON_ZUKANCHG ] = CLACT_AddSimple( &add );
	CLACT_AnmChg( p_work->clact[ ZKN_POKELIST_SUB_BUTTON_ZUKANCHG ], ZKN_POKELSIT_SUB_ZUKANCHG_BUTTON_SEQ );

	// }ӂ؂ւȂƂ͔\ɂ
	// Ӱނ͔̎\
	if( (ZKN_GLBDATA_PokeZknModeChengeCheck( cp_glb->p_pokelist_glb->p_glb, ZKN_MODE_ZENKOKU ) == FALSE) ||
		(cp_glb->p_pokelist_glb->p_glb->sort_search_flag == ZKN_SORTSEARCH_SORT) ){
		CLACT_SetDrawFlag( p_work->clact[ ZKN_POKELIST_SUB_BUTTON_ZUKANCHG ], FALSE );
	}

	// }ӂ
	add.mat.x = ZKN_POKELIST_SUB_ZUKANSEE_BUTTON_X << FX32_SHIFT;
	add.mat.y = ZKN_POKELIST_SUB_ZUKANSEE_BUTTON_Y << FX32_SHIFT;
	add.mat.y += SUB_SURFACE_Y;
	p_work->clact[ ZKN_POKELIST_SUB_BUTTON_ZUKANSEE ] = CLACT_AddSimple( &add );
	CLACT_AnmChg( p_work->clact[ ZKN_POKELIST_SUB_BUTTON_ZUKANSEE ], ZKN_POKELSIT_SUB_ZUKANSEE_BUTTON_SEQ );

	// Xg̐擪
	add.mat.x = ZKN_POKELIST_SUB_LISTSTART_BUTTON_X << FX32_SHIFT;
	add.mat.y = ZKN_POKELIST_SUB_LISTSTART_BUTTON_Y << FX32_SHIFT;
	add.mat.y += SUB_SURFACE_Y;
	p_work->list_start = CLACT_AddSimple( &add );
	CLACT_AnmChg( p_work->list_start, ZKN_POKELSIT_SUB_LISTSTART_BUTTON_SEQ );

	// Xg̍Ō
	add.mat.x = ZKN_POKELIST_SUB_LISTEND_BUTTON_X << FX32_SHIFT;
	add.mat.y = ZKN_POKELIST_SUB_LISTEND_BUTTON_Y << FX32_SHIFT;
	add.mat.y += SUB_SURFACE_Y;
	p_work->list_end = CLACT_AddSimple( &add );
	CLACT_AnmChg( p_work->list_end, ZKN_POKELSIT_SUB_LISTEND_BUTTON_SEQ );


	// BƂ{^
	add.mat.x = ZKN_POKELIST_SUB_BUTTON_B_X << FX32_SHIFT;
	add.mat.y = ZKN_POKELIST_SUB_BUTTON_B_Y << FX32_SHIFT;
	add.mat.y += SUB_SURFACE_Y;
	p_work->act_B = CLACT_AddSimple( &add );
	CLACT_AnmChg( p_work->act_B, ZKN_POKELIST_SUB_BUTTON_B_ANM );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ZAN^[j
 *
 *	@param	p_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSubDeleteClact( ZKN_POKELIST_SUB_DRAWWORK* p_work )
{
	CLACT_Delete( p_work->clact[ ZKN_POKELIST_SUB_BUTTON_SEARCH ] );
	CLACT_Delete( p_work->clact[ ZKN_POKELIST_SUB_BUTTON_ZUKANCHG ] );
	CLACT_Delete( p_work->clact[ ZKN_POKELIST_SUB_BUTTON_ZUKANSEE ] );
	CLACT_Delete( p_work->list_start );
	CLACT_Delete( p_work->list_end );
	CLACT_Delete( p_work->act_B );
}

//----------------------------------------------------------------------------
/**
 *	@brief	tHgOAM쐬
 *
 *	@param	p_work		[N
 *	@param	p_drawglb	`O[o
 *	@param	cp_glb		O[of[^
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSubFontMake( ZKN_POKELIST_SUB_DRAWWORK* p_work, ZKN_POKELIST_SUB_GLBDRAW* p_drawglb, const ZKN_POKELIST_SUB_GLB* cp_glb, int heap )
{
	GF_BGL_BMPWIN* win;	// 񏑂ݐ
	ZKN_FONTOAM_INIT fontoam_init;
	CLACT_U_RES_OBJ_PTR res_obj;
	ZKN_GLB_DRAWDATA* p_glb_draw = p_drawglb->p_glb_draw;
	int pltt_ofs;	// pbgAhX

	// CLACTo^ĂKv
	GF_ASSERT( p_work->clact[ ZKN_POKELIST_SUB_BUTTON_SEARCH ] );

	// pbg̃\[Xf[^擾
	// pbgvNV擾p
	res_obj = CLACT_U_ResManagerGetIDResObjPtr( p_glb_draw->res_manager[ CLACT_U_PLTT_RES ], NARC_zukan_zkn_list_oam_NCLR + ZKN_POKELIST_SUB_RES_ID_OFS );

	// f[^̋ʕ쐬
	// ʃf[^
	fontoam_init.zkn_fontoam = p_glb_draw->fontoam_sys;
	fontoam_init.pltt		 = CLACT_U_PlttManagerGetProxy( res_obj, NULL );
	fontoam_init.x			 = ZKN_POKELIST_SUB_FONTOAM_OFS_X;
	fontoam_init.y			 = ZKN_POKELIST_SUB_FONTOAM_OFS_Y;
	fontoam_init.bg_pri		 = 0;
	fontoam_init.soft_pri	 = 0;
	fontoam_init.draw_area	 = NNS_G2D_VRAM_TYPE_2DSUB;
	fontoam_init.heap		 = heap;

	// pbg]AhX擾
	pltt_ofs = GetPlttProxyOffset( fontoam_init.pltt, NNS_G2D_VRAM_TYPE_2DSUB );

	
	// rbg}bvEBhE쐬
	win = ZKN_FONTOAM_GetBmp( p_glb_draw->fontoam_sys, 
			ZKN_POKELSIT_SUB_FONT_BMP_SIZE_CX,
			ZKN_POKELSIT_SUB_FONT_BMP_SIZE_CY );

	// SORTʂ
	ZKN_FONTOAM_PrintBmpStr( p_glb_draw->fontoam_sys, win,
			NARC_msg_zkn_dat, ZNK_POKELIST_BUTTON_05, 0, 0 );
	fontoam_init.p_bmp		 = win;
	fontoam_init.parent = p_work->clact[ ZKN_POKELIST_SUB_BUTTON_SEARCH ];
	p_work->p_fontoam[ ZKN_POKELIST_SUB_BUTTON_SEARCH ] = ZKN_FONTOAM_Make( &fontoam_init );
	FONTOAM_SetPaletteNo( p_work->p_fontoam[ ZKN_POKELIST_SUB_BUTTON_SEARCH ]->p_fontoam, pltt_ofs + ZKN_POKELIST_SUB_BUTTON_FONT_COL );
	// Ӱނ͔̎\
	if( cp_glb->p_pokelist_glb->p_glb->sort_search_flag == ZKN_SORTSEARCH_SORT ){
		FONTOAM_SetDrawFlag( p_work->p_fontoam[ ZKN_POKELIST_SUB_BUTTON_SEARCH ]->p_fontoam, FALSE );
	}

	// rbg}bvEBhEj
	ZKN_FONTOAM_DeleteBmp( win );


	// rbg}bvEBhE쐬
	win = ZKN_FONTOAM_GetBmp( p_glb_draw->fontoam_sys, 
			ZKN_POKELSIT_SUB_FONT_BMP_SIZE_CX,
			ZKN_POKELSIT_SUB_FONT_BMP_SIZE_CY );

	// }Ӑ؂ւ
	ZKN_FONTOAM_PrintBmpStr( p_glb_draw->fontoam_sys, win,
			NARC_msg_zkn_dat, ZNK_POKELIST_BUTTON_03, 0, 0 );
	fontoam_init.p_bmp		 = win;
	fontoam_init.parent = p_work->clact[ ZKN_POKELIST_SUB_BUTTON_ZUKANCHG ];
	p_work->p_fontoam[ ZKN_POKELIST_SUB_BUTTON_ZUKANCHG ] = ZKN_FONTOAM_Make( &fontoam_init );
	FONTOAM_SetPaletteNo( p_work->p_fontoam[ ZKN_POKELIST_SUB_BUTTON_ZUKANCHG ]->p_fontoam, pltt_ofs + ZKN_POKELIST_SUB_BUTTON_FONT_COL );

	// }ӂ؂ւȂƂ͔\ɂ
	if( (ZKN_GLBDATA_PokeZknModeChengeCheck( cp_glb->p_pokelist_glb->p_glb, ZKN_MODE_ZENKOKU ) == FALSE) ||
		(cp_glb->p_pokelist_glb->p_glb->sort_search_flag == ZKN_SORTSEARCH_SORT) ){
		FONTOAM_SetDrawFlag( p_work->p_fontoam[ ZKN_POKELIST_SUB_BUTTON_ZUKANCHG ]->p_fontoam, FALSE );
	}
	
	// rbg}bvEBhEj
	ZKN_FONTOAM_DeleteBmp( win );


	// rbg}bvEBhE쐬
	win = ZKN_FONTOAM_GetBmp( p_glb_draw->fontoam_sys, 
			ZKN_POKELSIT_SUB_FONT_BMP_SIZE_CX,
			ZKN_POKELSIT_SUB_FONT_BMP_SIZE_CY );
	
	// }ӂ
	ZKN_FONTOAM_PrintBmpStr( p_glb_draw->fontoam_sys, win,
			NARC_msg_zkn_dat, ZNK_BUTTON_00, 0, 0 );
	fontoam_init.p_bmp		 = win;
	fontoam_init.parent = p_work->clact[ ZKN_POKELIST_SUB_BUTTON_ZUKANSEE ];
	p_work->p_fontoam[ ZKN_POKELIST_SUB_BUTTON_ZUKANSEE ] = ZKN_FONTOAM_Make( &fontoam_init );
	FONTOAM_SetPaletteNo( p_work->p_fontoam[ ZKN_POKELIST_SUB_BUTTON_ZUKANSEE ]->p_fontoam, pltt_ofs + ZKN_POKELIST_SUB_BUTTON_FONT_COL_ZUKAN );

	// rbg}bvEBhEj
	ZKN_FONTOAM_DeleteBmp( win );


	// rbg}bvEBhE쐬
	win = ZKN_FONTOAM_GetBmp( p_glb_draw->fontoam_sys, 
			ZKN_POKELIST_SUB_FONT_B_BMP_CX,
			ZKN_POKELIST_SUB_FONT_B_BMP_CY );

	// B{^̉̃tHgOAM
	if( cp_glb->p_pokelist_glb->p_glb->sort_search_flag == ZKN_SORTSEARCH_NONE ){
		ZKN_FONTOAM_PrintBmpStr( p_glb_draw->fontoam_sys, win,
				NARC_msg_zkn_dat, ZNK_BACK_00, 0, 0 );
	}else{
		ZKN_FONTOAM_PrintBmpStr( p_glb_draw->fontoam_sys, win,
				NARC_msg_zkn_dat, ZNK_BACK_01, 0, 0 );
	}
	fontoam_init.p_bmp		 = win;
	fontoam_init.parent = p_work->act_B;
	fontoam_init.x			 = ZKN_POKELIST_SUB_FONT_B_OFS;
	fontoam_init.y			 = ZKN_POKELIST_SUB_FONT_B_OFS_Y;
	p_work->p_fontoam_B = ZKN_FONTOAM_Make( &fontoam_init );
	FONTOAM_SetPaletteNo( p_work->p_fontoam_B->p_fontoam, pltt_ofs + ZKN_POKELIST_SUB_BUTTON_FONT_COL_CLOSE );

	// rbg}bvEBhEj
	ZKN_FONTOAM_DeleteBmp( win );
}

//----------------------------------------------------------------------------
/**
 *	@brief	tHgOAMj
 *
 *	@param	p_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSubFontDelete( ZKN_POKELIST_SUB_DRAWWORK* p_work )
{
	ZKN_FONTOAM_Delete( p_work->p_fontoam[ ZKN_POKELIST_SUB_BUTTON_SEARCH ] );
	ZKN_FONTOAM_Delete( p_work->p_fontoam[ ZKN_POKELIST_SUB_BUTTON_ZUKANCHG ] );
	ZKN_FONTOAM_Delete( p_work->p_fontoam[ ZKN_POKELIST_SUB_BUTTON_ZUKANSEE ] );
	ZKN_FONTOAM_Delete( p_work->p_fontoam_B );
}



//----------------------------------------------------------------------------
/**
 *	@brief	zC[ʂ̕\	
 *
 *	@param	p_drawglb	`O[of[^
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSubBgSetUp( ZKN_POKELIST_SUB_GLBDRAW* p_drawglb, int heap )
{
	void* buff;
	NNSG2dScreenData* p_scrn;
	GF_BGL_INI* p_bg = p_drawglb->p_glb_draw->p_bg;
	
	// LN^f[^]
	ZKN_GLBDATA_BgCharSet( p_drawglb->p_glb_draw, NARC_zukan_zkn_list_disk_lzh_NCGR, p_bg, ZKN_BG_FRM_AFFINE_S, 0, 0, TRUE, heap );

	// XN[f[^ǂݍ
	buff = ZKN_GLBDATA_ScrnDataGet( p_drawglb->p_glb_draw, NARC_zukan_zkn_list_bg_disk_lzh_NSCR, TRUE, &p_scrn, heap );
	
	// XN[f[^
	GF_BGL_ScrWrite( p_bg, ZKN_BG_FRM_AFFINE_S,
			p_scrn->rawData, 0, 0,
			p_scrn->screenWidth / 8, p_scrn->screenHeight / 8 );

	sys_FreeMemoryEz( buff );
	
	// XN[f[^]
	GF_BGL_LoadScreenV_Req(p_bg, ZKN_BG_FRM_AFFINE_S );

	// XN[Wݒ
	GF_BGL_ScrollSet( p_bg, ZKN_BG_FRM_AFFINE_S, GF_BGL_SCROLL_X_SET, ZKN_POKELIST_SUB_BGFADE_DEF_X );
	GF_BGL_ScrollSet( p_bg, ZKN_BG_FRM_AFFINE_S, GF_BGL_SCROLL_Y_SET, ZKN_POKELSIT_SUB_MAT_Y );
}

//----------------------------------------------------------------------------
/**
 *	@brief	XN[
 *
 *	@param	p_drawglb	`O[o
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSubBgDelete( ZKN_POKELIST_SUB_GLBDRAW* p_drawglb, int heap )
{
	GF_BGL_INI* p_bg = p_drawglb->p_glb_draw->p_bg;
	GF_BGL_ClearCharSet( ZKN_BG_FRM_AFFINE_S, 64, 0, heap );
	GF_BGL_ScrClear( p_bg, ZKN_BG_FRM_AFFINE_S );
}

//----------------------------------------------------------------------------
/**
 *	@brief	XgJEg
 *
 *	@param	p_work	[N
 *	@param	p_glb	O[of[^
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSubListCount( ZKN_POKELIST_SUB_WORK* p_work, ZKN_POKELIST_SUB_GLB* p_glb )
{
	int rota;
	ZKN_GLB_DATA* p_zkn_glb = p_glb->p_pokelist_glb->p_glb;
	int add_count;

	// JEgłȂȂ瑫
	if( p_glb->p_pokelist_glb->move_count <= 0 ){
		
		// JEgl
		if( p_work->move_rota_list != 0 ){
			// l
			if( p_work->move_rota_list < 0 ){
				add_count = 1;
			}else{
				add_count = -1;
			}
			
			// o^
			// s瓮~
			if( ZKN_GLBDATA_PokeListDrawTblNoAdd( p_zkn_glb, add_count ) == FALSE ){
				p_work->move_rota_list = 0;
				p_work->move_rota = 0;
				p_glb->p_pokelist_glb->move_way = ZKN_POKE_LIST_NO_MOVE;
			}else{
				p_glb->p_pokelist_glb->move_count = ZKN_POKELIST_MOVE_END_COUNT;
			
				// Iړ
				Snd_SePlay( ZKN_SND_SELECT_MOVE_ONE );
			}

		}else{

			// JEgOȂI
			p_glb->p_pokelist_glb->move_way = ZKN_POKE_LIST_NO_MOVE;
		}
	}

	// ݒ
	if( p_work->move_rota_list < 0 ){
		p_glb->p_pokelist_glb->move_way = ZKN_POKE_LIST_UP;
	}else{
		if( p_work->move_rota_list > 0 ){
			p_glb->p_pokelist_glb->move_way = ZKN_POKE_LIST_DOWN;
		}
	}

	// Xg
	if( p_glb->p_pokelist_glb->move_way != ZKN_POKE_LIST_NO_MOVE ){
		
		// Βlɂ
		if( p_work->move_rota_list < 0 ){
			rota = -p_work->move_rota_list;
		}else{
			rota = p_work->move_rota_list;
		}

		// JEgl擾
		rota /= ZKN_POKELIST_SUB_COUNT_R;

		// JEg
		p_glb->p_pokelist_glb->move_count -= rota;
		// JE^Ō܂ōs`FbN
		if( p_glb->p_pokelist_glb->move_count < 0 ){	
			p_glb->p_pokelist_glb->move_count = 0;
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	]px擾
 *
 *	@param	p_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSubMoveRotaGet( ZKN_POKELIST_SUB_WORK* p_work )
{
	int last_rota;
	int now_rota;
	int zettai;
	int last_y, last_x;
	int now_y, now_x;

	// zC[̒SW̒lɂ
	last_x = p_work->tp_last_x - ZKN_POKELIST_SUB_CX;
	last_y = p_work->tp_last_y - ZKN_POKELIST_SUB_CY;
	now_x = sys.tp_x - ZKN_POKELIST_SUB_CX;
	now_y = sys.tp_y - ZKN_POKELIST_SUB_CY;

	last_rota = FX_Atan2Idx( last_y, last_x );
	now_rota = FX_Atan2Idx( now_y, now_x );

	p_work->move_rota = now_rota - last_rota;

	// Βl߂
	if( p_work->move_rota < 0 ){
		zettai = -p_work->move_rota;
	}else{
		zettai = p_work->move_rota;
	}

	// 180ȏɂȂ邱Ƃ͍lɂ̏ꍇ,ORUOƂčl
	if( zettai >= FX_GET_ROTA_NUM(180) ){
		zettai = FX_GET_ROTA_NUM(360) - zettai;
		zettai = -zettai;		// 0->360ƂlɂȂ邩xNgςKv
	}

	// ݒ
	if( p_work->move_rota < 0 ){
		p_work->move_rota = -zettai;
	}else{
		p_work->move_rota = zettai;
	}

}

//----------------------------------------------------------------------------
/**
 *	@brief	zC[̕`擮
 *
 *	@param	p_drawwork	`惏[N
 *	@param	p_drawglb	`O[of[^
 *	@param	add_num		]p𓮂l
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSubDrawMove( ZKN_POKELIST_SUB_DRAWWORK* p_drawwork, ZKN_POKELIST_SUB_GLBDRAW* p_drawglb, int add_num )
{
	// ]px߂
	p_drawwork->wheel_rota += add_num;
	p_drawwork->wheel_rota &= 0xffff;

	// ]px̐ݒ
	GF_BGL_RadianSetReq( p_drawglb->p_glb_draw->p_bg, ZKN_BG_FRM_AFFINE_S, GF_BGL_RADION_SET, p_drawwork->wheel_rota / 182 );
	GF_BGL_RotateCenterSetReq( p_drawglb->p_glb_draw->p_bg, ZKN_BG_FRM_AFFINE_S, GF_BGL_CENTER_X_SET, ZKN_POKELIST_SUB_BGCX );
	GF_BGL_RotateCenterSetReq( p_drawglb->p_glb_draw->p_bg, ZKN_BG_FRM_AFFINE_S, GF_BGL_CENTER_Y_SET, ZKN_POKELIST_SUB_BGCY );

	// lockꂽƋNpɊpxۑ
	p_drawwork->save_wheel_rota = p_drawwork->wheel_rota;
}

//----------------------------------------------------------------------------
/**
 *	@brief	lockĂƂɃzC[̊G𓮂
 *
 *	@param	p_drawwork		`惏[N
 *	@param	p_drawglb		`O[o
 *	@param	cp_glb			O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSubDrawMoveLockTime( ZKN_POKELIST_SUB_DRAWWORK* p_drawwork, ZKN_POKELIST_SUB_GLBDRAW* p_drawglb, const ZKN_POKELIST_SUB_GLB* cp_glb )
{
	int rota_num;
	int calc;
	int count = ZKN_POKELIST_MOVE_END_COUNT - cp_glb->p_pokelist_glb->move_count;
	
	//@̊pxvZ
	calc = ZKN_POKELIST_SUB_LOCK_MOVE_MAX * count;
	rota_num = calc / ZKN_POKELIST_MOVE_END_COUNT;
	
	// -ݒ
	if( cp_glb->p_pokelist_glb->move_way == ZKN_POKE_LIST_UP ){
		rota_num = -rota_num;
	}

	// ]px߂
	p_drawwork->wheel_rota = p_drawwork->save_wheel_rota + rota_num;
	p_drawwork->wheel_rota &= 0xffff;

	// ]px̐ݒ
	GF_BGL_RadianSetReq( p_drawglb->p_glb_draw->p_bg, ZKN_BG_FRM_AFFINE_S, GF_BGL_RADION_SET, p_drawwork->wheel_rota / 182 );
	GF_BGL_RotateCenterSetReq( p_drawglb->p_glb_draw->p_bg, ZKN_BG_FRM_AFFINE_S, GF_BGL_CENTER_X_SET, ZKN_POKELIST_SUB_BGCX );
	GF_BGL_RotateCenterSetReq( p_drawglb->p_glb_draw->p_bg, ZKN_BG_FRM_AFFINE_S, GF_BGL_CENTER_Y_SET, ZKN_POKELIST_SUB_BGCY );


	// JE^0̎]pZ[u
	if( cp_glb->p_pokelist_glb->move_count == 0 ){
		p_drawwork->save_wheel_rota = p_drawwork->wheel_rota;
	} 
}


//----------------------------------------------------------------------------
/**
 *	@brief	zC[̃Xs[h𗎂Ƃ
 *
 *	@param	p_work	[N
 *	@param	move_count JE^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSubResist( ZKN_POKELIST_SUB_WORK* p_work, int move_count, int move_way )
{
	// `p]pvZ
	if( p_work->move_rota > 0 ){
		if( p_work->move_rota - ZKN_POKELIST_SUB_SUB_R >= ZKN_POKELIST_SUB_SUBDRAWLIMIT_R ){

			p_work->move_rota -= ZKN_POKELIST_SUB_SUB_R;
		}else{
			p_work->move_rota = ZKN_POKELIST_SUB_SUBDRAWLIMIT_R;
		}
	}else{

		if( p_work->move_rota + ZKN_POKELIST_SUB_SUB_R <= -ZKN_POKELIST_SUB_SUBDRAWLIMIT_R ){
			p_work->move_rota += ZKN_POKELIST_SUB_SUB_R;
		}else{
			p_work->move_rota = -ZKN_POKELIST_SUB_SUBDRAWLIMIT_R;
		}
	}

	// pxlfppxɐݒ
	p_work->move_rota_list = p_work->move_rota;


	// ]px@ZKN_POKELIST_SUB_COUNT_R̂Ƃ
	// move_count0Ȃ]~߂
	if( (p_work->move_rota <= ZKN_POKELIST_SUB_SUBLIMIT_R) && 
		(p_work->move_rota >= -ZKN_POKELIST_SUB_SUBLIMIT_R)){
		if( move_count == 0 ){
			p_work->move_rota_list = 0;

			// ZKN_POKELIST_SUB_SUBDRAWLIMIT_RȉȂ`p
			// Ƃ߂
			if( (p_work->move_rota <= ZKN_POKELIST_SUB_SUBDRAWLIMIT_R) && 
				(p_work->move_rota >= -ZKN_POKELIST_SUB_SUBDRAWLIMIT_R)){
				p_work->move_rota = 0;
			}
		}else{

			// JEgƂ܂Ȃ悤
			// ZKN_POKELIST_SUB_COUNT_RɂȂ
			if( move_way == ZKN_POKE_LIST_UP ){
				p_work->move_rota_list = -ZKN_POKELIST_SUB_SUBLIMIT_R;
				p_work->move_rota = -ZKN_POKELIST_SUB_SUBLIMIT_R;
			}else{
				p_work->move_rota_list = ZKN_POKELIST_SUB_SUBLIMIT_R;
				p_work->move_rota = ZKN_POKELIST_SUB_SUBLIMIT_R;
			}
		}
	}

}

//----------------------------------------------------------------------------
/**
 *	@brief	{^tHg
 *
 *	@param	act				AN^[
 *	@param	p_fontoam		tHgOAM
 *	@param	def_y			ftHgYʒu
 *	@param	off_pltt		{^OFF̃J[pbg
 *	@param	on_pltt			{^OÑJ[pbg
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokelistSubButtonFontMove( CLACT_WORK_PTR act, ZKN_FONTOAM_DATA* p_fontoam, int def_y, int off_pltt, int on_pltt )
{
	ZKN_UTIL_ButtonFontMove_Col( act, p_fontoam, def_y, off_pltt, on_pltt );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Cʂ̊ǗĂL[ɂ{^̓
 *
 *	@param	p_glb	O[of[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListSubButton_KeyMove( ZKN_POKELIST_SUB_GLB* p_glb )
{
	ZKN_POKELIST_GLB_DATA* p_main_glb = p_glb->p_pokelist_glb;
	
	// }Ӊʂ
	if( p_main_glb->zukan_see ){
		p_glb->button_event[ ZKN_POKELIST_SUB_BUTTON_ZUKANSEE ] = BMN_EVENT_HOLD;
		return;
	}//*/

	// SORTʂ
	if( p_main_glb->sort_chg ){
		p_glb->button_event[ ZKN_POKELIST_SUB_BUTTON_SEARCH ] = BMN_EVENT_HOLD;
		return;
	}

	// }ӂ؂ւ
	if( p_main_glb->zukan_chg ){
		p_glb->button_event[ ZKN_POKELIST_SUB_BUTTON_ZUKANCHG ] = BMN_EVENT_HOLD;
		return;
	}
}
