//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		range_data.c
 *	@brief		zf[^擾֐
 *	@author		tomoya takahashi 
 *	@data		2006.02.11
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include "system/arc_util.h"
#include "system/arc_tool.dat"

#include "gflib/clact.h"

#include "include/poketool/monsno.h"
#include "src/application/zukanlist/zkn_data/zukan_data.naix"

#define __ZKN_RANGE_DATA_H_GLOBAL
#include "include/application/zukanlist/zkn_range_data.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	|Pzf[^e^CvJnio[
//=====================================
#define ZKN_RANGEDATA_DAN_MORNING_ARC_S	(NARC_zukan_data_zkn_dan_range_morning_mons_000_mrang)
#define ZKN_RANGEDATA_DAN_NOON_ARC_S	(NARC_zukan_data_zkn_dan_range_noon_mons_000_mrang)
#define ZKN_RANGEDATA_DAN_NIGHT_ARC_S	(NARC_zukan_data_zkn_dan_range_night_mons_000_mrang)
#define ZKN_RANGEDATA_DAN_SPECIAL_ARC_S	(NARC_zukan_data_zkn_dan_range_special_mons_000_mrang)
#define ZKN_RANGEDATA_FLD_MORNING_ARC_S	(NARC_zukan_data_zkn_fld_range_morning_mons_000_mrang)
#define ZKN_RANGEDATA_FLD_NOON_ARC_S	(NARC_zukan_data_zkn_fld_range_noon_mons_000_mrang)
#define ZKN_RANGEDATA_FLD_NIGHT_ARC_S	(NARC_zukan_data_zkn_fld_range_night_mons_000_mrang)
#define ZKN_RANGEDATA_FLD_SPECIAL_ARC_S	(NARC_zukan_data_zkn_fld_range_special_mons_000_mrang)


//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static int ZknRangeDataZoneLinkIdGet( int zone_id, int arc_dataidx, int heap );



//----------------------------------------------------------------------------
/**
 *	@brief	X^[io[zf[^擾
 *
 *	@param	p_inbuff		f[^i[
 *	@param	mons_no			X^[io[
 *	@param	type			z^Cv
 *	@param	heap			gpq[v
 */
//-----------------------------------------------------------------------------
void ZKN_RANGEDATA_GetMonsNoRange( ZKN_RANGE_DATA_MONS* p_inbuff, int mons_no, int type, int heap )
{
	int arc_start;
	u32 data_size;
	
	switch( type ){
	// _Wzf[^
	case ZKN_RANGEDATA_TYPE_DAN_MORNING:
		arc_start = ZKN_RANGEDATA_DAN_MORNING_ARC_S;
		break;
	case ZKN_RANGEDATA_TYPE_DAN_NOON:
		arc_start = ZKN_RANGEDATA_DAN_NOON_ARC_S;
		break;
	case ZKN_RANGEDATA_TYPE_DAN_NIGHT:
		arc_start = ZKN_RANGEDATA_DAN_NIGHT_ARC_S;
		break;
	case ZKN_RANGEDATA_TYPE_DAN_SPECIAL:
		arc_start = ZKN_RANGEDATA_DAN_SPECIAL_ARC_S;
		break;
	
	// tB[hzf[^
	case ZKN_RANGEDATA_TYPE_FLD_MORNING:
		arc_start = ZKN_RANGEDATA_FLD_MORNING_ARC_S;
		break;
	case ZKN_RANGEDATA_TYPE_FLD_NOON:
		arc_start = ZKN_RANGEDATA_FLD_NOON_ARC_S;
		break;
	case ZKN_RANGEDATA_TYPE_FLD_NIGHT:
		arc_start = ZKN_RANGEDATA_FLD_NIGHT_ARC_S;
		break;
	case ZKN_RANGEDATA_TYPE_FLD_SPECIAL:
		arc_start = ZKN_RANGEDATA_FLD_SPECIAL_ARC_S;
		break;
	}
	
	// A[JCuǂݍ
	p_inbuff->p_rangeid = (int *)ArcUtil_LoadEx( ARC_ZUKAN_DATA, arc_start + mons_no, FALSE, heap, ALLOC_TOP, &data_size );
	
	// f[^TCYzvf󂯎
	p_inbuff->num = data_size / sizeof(int);
}

//----------------------------------------------------------------------------
/**
 *	@brief	X^[io[zf[^j
 *
 *	@param	p_inbuff 
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_RANGEDATA_DeleteMonsNoRange( ZKN_RANGE_DATA_MONS* p_inbuff )
{
	GF_ASSERT( p_inbuff );
	GF_ASSERT( p_inbuff->p_rangeid );
	
	sys_FreeMemoryEz( p_inbuff->p_rangeid );
	p_inbuff->p_rangeid = NULL;
	p_inbuff->num = 0;
}

//----------------------------------------------------------------------------
/**
 *	@brief	][IDɑΉ_WzID擾
 *
 *	@param	zone_id	][ID
 *	@param	heap	q[v
 *
 *	@retval	ZKN_DAN_ID_NONE		ΉIDȂ
 *	@retval	̑				ΉID
 */
//-----------------------------------------------------------------------------
int ZKN_RANGEDATA_GetZoneIDLinkDanRangeID( int zone_id, int heap )
{
	return ZknRangeDataZoneLinkIdGet( zone_id, NARC_zukan_data_zkn_dan_id_rzidlink, heap );
}

//----------------------------------------------------------------------------
/**
 *	@brief	][IDɑΉtB[hzID擾
 *
 *	@param	zone_id	][ID
 *	@param	heap	q[v
 *
 *	@retval	ZKN_FLD_ID_NONE		ΉIDȂ
 *	@retval	̑				ΉID
 */
//-----------------------------------------------------------------------------
int ZKN_RANGEDATA_GetZoneIDLinkFldRangeID( int zone_id, int heap )
{
	return ZknRangeDataZoneLinkIdGet( zone_id, NARC_zukan_data_zkn_fld_id_rzidlink, heap );
}


//----------------------------------------------------------------------------
/**
 *	@brief	_WObhWf[^擾
 *
 *	@param	heap		q[v
 *	@param	p_num		f[^zvfi[	int̕ϐ	(NULLL)
 *			̒lZKN_DAN_ID_MAXƓ
 *
 *	@return	z	j͊e
 */
//-----------------------------------------------------------------------------
ZKN_RANGE_DATA_DAN_GRID* ZKN_RANGEDATA_GetDanGridOamData( int heap, int* p_num )
{
	ZKN_RANGE_DATA_DAN_GRID* p_buff;
	u32 data_size;

	
	// A[JCuǂݍ
	p_buff = (ZKN_RANGE_DATA_DAN_GRID*)ArcUtil_LoadEx( ARC_ZUKAN_DATA, NARC_zukan_data_zkn_dan_griddata_dangri, FALSE, heap, ALLOC_TOP, &data_size );


	// f[^TCYzp擾
	if( p_num ){
		*p_num = data_size / sizeof(ZKN_RANGE_DATA_DAN_GRID);
	}

	return p_buff;
}


//----------------------------------------------------------------------------
/**
 *	@brief	tB[hObhn`f[^擾
 *
 *	@param	heap		q[v
 *	@param	p_num		f[^zvfi[	int ̕ϐ@iNULLLj
 *			̒lZKN_FLD_ID_MAXƓ
 *	
 *	@return	z@j͊e
 */
//-----------------------------------------------------------------------------
ZKN_RANGE_DATA_FLD_GRID* ZKN_RANGEDATA_GetFldGridAraaData( int heap, int* p_num )
{
	ZKN_RANGE_DATA_FLD_GRID* p_buff;
	u32 data_size;

	
	// A[JCuǂݍ
	p_buff = (ZKN_RANGE_DATA_FLD_GRID*)ArcUtil_LoadEx( ARC_ZUKAN_DATA, NARC_zukan_data_zkn_fld_griddata_fldgri, FALSE, heap, ALLOC_TOP, &data_size );


	// f[^TCYzp擾
	if( p_num ){
		*p_num = data_size / sizeof(ZKN_RANGE_DATA_FLD_GRID);
	}

	return p_buff;
}

//----------------------------------------------------------------------------
/**
 *	@brief	tB[hz}f[^
 *
 *	@param	p_buff			ݐobt@
 *	@param	buff_x			obt@TCY
 *	@parm	buff_y			obt@TCY
 *	@param	cp_write_data	݃f[^	(ϐ̃|C^)
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_RANGE_DATA_FldGridDataWrite( u8* p_buff, u8 buff_x, u8 buff_y, const ZKN_RANGE_DATA_FLD_GRID* cp_write_data )
{
	int i,j;	// [v

	GF_ASSERT( (cp_write_data->gridy + cp_write_data->sizey) < buff_y );
	GF_ASSERT( (cp_write_data->gridx + cp_write_data->sizex) < buff_x );

	for( i=cp_write_data->gridy; i<cp_write_data->gridy + cp_write_data->sizey; i++ ){

		for( j=cp_write_data->gridx; j<cp_write_data->gridx + cp_write_data->sizex; j++ ){

			p_buff[ (i*buff_x) + j ] |= cp_write_data->arry[ ((i-cp_write_data->gridy) * cp_write_data->sizex) + (j-cp_write_data->gridx)  ];
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	X^[zf[^̃tB[hz}bv쐬
 *
 *	@param	p_buff				i[
 *	@param	buff_x				i[obt@TCY
 *	@param	buff_y				i[obt@TCY
 *	@param	cp_write_data		tB[hn`f[^izj
 *	@param	cp_mons_range		X^[zf[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_RANGE_DATA_FldGridDataWriteMonsRangeData( u8* p_buff, int buff_x, int buff_y, const ZKN_RANGE_DATA_FLD_GRID* cp_write_data, const ZKN_RANGE_DATA_MONS* cp_mons_range )
{
	int i;	// [vp

	for( i=0; i<cp_mons_range->num - 1; i++ ){	// X^[zŌ̓_~[

		GF_ASSERT( cp_mons_range->p_rangeid[i] );	// 0͂
		ZKN_RANGE_DATA_FldGridDataWrite( p_buff, buff_x, buff_y,
				&cp_write_data[ cp_mons_range->p_rangeid[i] ] );
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	_WWOAMAN^[ɐݒ
 *
 *	@param	p_act			AN^[
 *	@param	ofs_x			ލWl
 *	@param	ofs_y			ލWl
 *	@param	gridsizex		ObhTCY
 *	@param	gridsizey		ObhTCY
 *	@param	cp_write_data	_W
 *	@param	norm_seq		ʏAjV[PX
 *	@param	sp_seq			AjV[PX
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_RANGE_DATA_DanGridDataSet( CLACT_WORK_PTR p_act, int ofsx, int ofsy, int gridsizex, int gridsizey, const ZKN_RANGE_DATA_DAN_GRID* cp_write_data, int norm_seq, int sp_seq )
{
	VecFx32 mat;

	mat.x = (cp_write_data->gridx * gridsizex) + ofsx;
	mat.y = (cp_write_data->gridy * gridsizey) + ofsy;
	mat.x <<= FX32_SHIFT;
	mat.y <<= FX32_SHIFT;
	
	CLACT_SetMatrix( p_act, &mat );


	// OAMݒ
	if( cp_write_data->oam_flg ){
		CLACT_AnmChg( p_act, sp_seq );
	}else{
		CLACT_AnmChg( p_act, norm_seq );
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	_WWOAMݒ֐
 *
 *	@param	pp_act				AN^[z
 *	@param	use_start			gpJn
 *	@param	act_max				AN^[zvf
 *	@param	ofs_x				ލWl
 *	@param	ofs_y				ލWl
 *	@param	gridsizex			PObhXTCY
 *	@param	gridsizey			PObhYTCY
 *	@param	cp_write_data		_WObhf[^z
 *	@param	cp_mons_range		X^[zf[^
 *	@param	norm_seq		ʏAjV[PX
 *	@param	sp_seq				OAM̏ꍇ̃AjV[PX
 *
 *	@return	gpAN^[
 */
//-----------------------------------------------------------------------------
int ZKN_RANGE_DATA_DanGridDataSetMonsRangeData( CLACT_WORK_PTR* pp_act, int use_start, int act_max, int ofs_x, int ofsy, int gridsizex, int gridsizey, const ZKN_RANGE_DATA_DAN_GRID* cp_write_data, const ZKN_RANGE_DATA_MONS* cp_mons_range, int norm_seq, int sp_seq )
{
	int i;
	int act_count = use_start;

	for( i=0; i<cp_mons_range->num - 1; i++ ){	// X^[zŌ̓_~[

		GF_ASSERT( cp_mons_range->p_rangeid[i] );
		GF_ASSERT( act_count < act_max );
		
		ZKN_RANGE_DATA_DanGridDataSet( pp_act[act_count], ofs_x, ofsy, gridsizex, gridsizey, &cp_write_data[ cp_mons_range->p_rangeid[i] ], norm_seq, sp_seq );
		act_count++;

	}

	return act_count;
}

//-----------------------------------------------------------------------------
/**
 *
 *		[vCx[g֐]
 * 
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	@brief	][IDɑΉIDԂ
 *
 *	@param	zone_id		][ID
 *	@param	arc_dataidx	A[JCuf[^IND	i_WLinkf[^ORtB[hLINKf[^j
 *	@param	heap		q[v
 *
 *	@return	ΉID
 */
//-----------------------------------------------------------------------------
static int ZknRangeDataZoneLinkIdGet( int zone_id, int arc_dataidx, int heap )
{
	int* p_buff;
	u32 data_size;
	int num;
	int i;
	int ret;
	
	GF_ASSERT( (arc_dataidx == NARC_zukan_data_zkn_dan_id_rzidlink)||
			(arc_dataidx == NARC_zukan_data_zkn_fld_id_rzidlink) );
	
	// A[JCuǂݍ
	p_buff = (int *)ArcUtil_LoadEx( ARC_ZUKAN_DATA, arc_dataidx, FALSE, heap, ALLOC_BOTTOM, &data_size );
	
	// f[^TCYzvf󂯎
	num = data_size / sizeof(int);

	// ȂƂ0ԂƂꂼ̕zIDNONE萔ɂȂ
	ret = 0;
	// [v	ꏏ̃io[炻̔z̗vfzID
	for( i=0; i<num; i++ ){
		if( p_buff[i] == zone_id ){

			ret = i;
			break;
		}
	}

	sys_FreeMemoryEz( p_buff );
	return ret;
}
