//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		zkn_sound.c
 *	@brief		AvP[V
 *	@author		tomoya takahashi
 *	@data		2006.01.20
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include <string.h>
#include "include/application/zukanlist/zkn_event_func.h"

#include "include/system/snd_tool.h"


#include "include/gflib/display.h"
#include "include/system/brightness.h"
#include "include/system/arc_tool.dat"
#include "include/system/arc_util.h"
#include "include/system/clact_util.h"
#include "include/application/zukanlist/zukan.naix"
#include "include/gflib/button_man.h"
#include "include/system/msgdata_util.h"
#include "include/msgdata/msg.naix"
#include "include/msgdata/msg_zkn.h"

#include "include/application/zukanlist/zkn_snd_def.h"
#include "include/application/zukanlist/zkn_zukan_common.h"
#include "include/application/zukanlist/zkn_sound_sub.h"

#define	__ZKN_SOUND_H_GLOBAL
#include "include/application/zukanlist/zkn_sound.h"


//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define ZKN_SOUND_EVENT_NUM ( 0 )	// Cxg
//#define ZKN_SOUND_EVENT_CHANGE_BIG ( 0x1 << 0 )	// 傫ׂ

#define ZKN_SOUND_OAM_BG_PRI	(0)
#define ZKN_SOUND_OAM_PRI	(17)

//-------------------------------------
//	V[PX
//=====================================
enum{
	ZKN_SOUND_SEQINIT_ALLOC,
	ZKN_SOUND_SEQINIT_LOAD,
	ZKN_SOUND_SEQINIT_FADEIN,
	ZKN_SOUND_SEQINIT_END,
};
enum{
	ZKN_SOUND_SEQDELETE_FADEOUT_INIT,
	ZKN_SOUND_SEQDELETE_FADEOUT,
	ZKN_SOUND_SEQDELETE_RELEASE,
	ZKN_SOUND_SEQDELETE_FREE,
	ZKN_SOUND_SEQDELETE_END,
};



// g`f[^`
#define ZKN_SOUND_DRAW_BMP_ONE_SIZE_X	( 1 )
#define ZKN_SOUND_DRAW_BMP_ONE_SIZE_Y	( 1 )
#define ZKN_SOUND_DRAW_BMP_Y_MAX		( 32 )
#define ZKN_SOUND_DRAW_BMP_DEF_Y		( 151 )
#define ZKN_SOUND_DRAW_BMP_PL_TBL		(9)
#define ZKN_SOUND_DRAW_BMP_PL			(6)


// g`f[^XN[
#define ZKN_SOUND_SCRL_BMP_SPEED	( 4 )


// _Ot
#define ZKN_SOUND_GRAPH_NUM			( 9 )		// Ot̉vf
#define ZKN_SOUND_GRAPH_ZANZOU_NUM	( 9 )		// c̏cvf
#define ZKN_SOUND_GRAPH_MAT_DEF_X	( 112 )
#define ZKN_SOUND_GRAPH_MAT_DEF_Y	( 96 )
#define ZKN_SOUND_GRAPH_MAT_OFS_X	( 16 )
#define ZKN_SOUND_GRAPH_MAT_OFS_Y	( -8 )
#define ZKN_SOUND_GRAPH_DES_COUNT	( 2 )
#define ZKN_SOUND_GRAPH_DOWN_COUNT	( 16 )

// tF[hp
#define ZKN_SOUND_FADE_PLANEMSK	( GX_BLEND_PLANEMASK_BG1|GX_BLEND_PLANEMASK_BG3|GX_BLEND_PLANEMASK_BD )

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	ʁ@O[oϐ
//=====================================
typedef struct {
	int*				p_event_key;		// CxgL[
	ZKN_GLB_DATA*		p_glb;				// O[of[^

	// CRO[o
	ZKN_APL_DATA*	p_main_common;	// Avf[^

	// TuTEhAvf[^
	ZKN_APL_DATA*	p_sub_sound;	// Avf[^
} ZKN_SOUND_GLB;

//-------------------------------------
//	ʁ@`O[oϐ
//=====================================
typedef struct {
	ZKN_GLB_DRAWDATA*	p_drawglb;			// `O[of[^

	int pokegra_move_x;
	int pokegra_move_y;

	int fade_mode;		// tF[h[h
	int fade_sync;		// tF[hVN
} ZKN_SOUND_DRAWGLB;


//-------------------------------------
//	ʁ@[N
//=====================================
typedef struct {
	// f[^
	const SNDWaveData* cp_snd_data;
	int tick;
	int data_num;
	u8 snd_graph_data[ ZKN_SOUND_GRAPH_NUM ];

} ZKN_SOUND_WORK;

//-------------------------------------
//	Otcf[^
//=====================================
typedef struct {
	CLACT_WORK_PTR act;
	int dess_count;		// \JE^
} ZKN_GRAPH_ZANZOU;

//-------------------------------------
//	Ot擪
//=====================================
typedef struct {
	CLACT_WORK_PTR act;
	int level;			// 郌x
	int down_count;	// ܂ł̃JE^

} ZKNGRAPH_TOP;


//-------------------------------------
//	OtPvff[^
//=====================================
typedef struct {
	ZKN_GRAPH_ZANZOU zanzou[ ZKN_SOUND_GRAPH_ZANZOU_NUM ];
	ZKNGRAPH_TOP	top;
} ZKN_GRAPH_ONE_DATA;


//-------------------------------------
//	ʁ@[N
//=====================================
typedef struct {
	// |POtF[hp샏[N
	ZKN_UTIL_MOVE_WORK pokegra_move;

	// Otf[^
	ZKN_GRAPH_ONE_DATA snd_graph_act[ ZKN_SOUND_GRAPH_NUM ];
	CLACT_U_RES_OBJ_PTR res_obj[ ZKN_CLACT_RES_OBJ_NUM_DEF ];

	// BMPXN[
	int scrl_num;
	int last_y;
	int last_tick;

} ZKN_SOUND_DRAW;

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *		AvP[Vf[^쐬֌W
 */
//-----------------------------------------------------------------------------
static ZKN_SOUND_GLB* MakeSoundGlb( int heap, ZKN_SYS_PTR zkn_sys );
static ZKN_SOUND_DRAWGLB* MakeSoundDrawGlb( int heap, ZKN_SYS_PTR zkn_sys );
//static ZKN_EVENT_DATA* MakeSoundEvent( int heap, ZKN_SYS_PTR zkn_sys );
static void DeleteSoundGlb( ZKN_SOUND_GLB* p_glb );
static void DeleteSoundDrawGlb( ZKN_SOUND_DRAWGLB* p_glb );
//static void DeleteSoundEvent( ZKN_EVENT_DATA* p_event );


static int SoundEventDataNumGet( void );


//-----------------------------------------------------------------------------
/**
 *		vZX֌W
 */
//-----------------------------------------------------------------------------
static int ZknSoundProcDoFuncInit( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata );
static int ZknSoundProcDoFuncMain( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata );
static int ZknSoundProcDoFuncDelete( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata );
static int ZknSoundProcDrawFuncInit( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata );
static int ZknSoundProcDrawFuncMain( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata );
static int ZknSoundProcDrawFuncDelete( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata );


// |PO
static void ZknSoundPokeGraOn( ZKN_SOUND_DRAWGLB* p_drawglb, const ZKN_SOUND_GLB* cp_glb );
static void ZknSoundPokeGraOff( ZKN_SOUND_DRAWGLB* p_drawglb );

// tF[h
static void ZknSoundOamFadeInit( ZKN_SOUND_DRAW* p_draw );
static void ZknSoundOamFadeDelete( ZKN_SOUND_DRAW* p_draw );
static void ZknSoundFadeInit( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb, const ZKN_SOUND_GLB* cp_glb, BOOL fadein_out );
static BOOL ZknSoundFadeMain( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb, const ZKN_SOUND_GLB* cp_glb, BOOL fadein_out );
static void ZknSoundFadeOtherInit( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb, const ZKN_SOUND_GLB* cp_glb, BOOL fadein_out );
static BOOL ZknSoundFadeOtherMain( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb, const ZKN_SOUND_GLB* cp_glb, BOOL fadein_out );

// Resourceǂݍ
static void ZknSoundLoadRes( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb, const ZKN_SOUND_GLB* cp_glb, const ZKN_SOUND_WORK* cp_datawork, int heap );
static void ZknSoundDeleteRes( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb );
static void ZknSoundSetUpBg( ZKN_SOUND_DRAWGLB* p_drawglb, const ZKN_SOUND_GLB* cp_glb, int heap );
static void ZknSoundPutBackBg( ZKN_SOUND_DRAWGLB* p_drawglb );
static void ZknSoundOamResLoad( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb, int heap );
static void ZknSoundOamResDelete( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb );
static void ZknSoundOamInit( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb, int heap );
static void ZknSoundOamDelete( ZKN_SOUND_DRAW* p_draw );
static void ZknSoundFontOamInit( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb, const ZKN_SOUND_GLB* cp_glb, int heap );
static void ZknSoundFontOamDelete( ZKN_SOUND_DRAW* p_draw );


static void ZknSoundGetTich( ZKN_SOUND_WORK* p_work, ZKN_SOUND_GLB* p_glb );


static void ZknSoundBmpScrollSetUp( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb );
static void ZknSoundBmpScroll( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb, const ZKN_SOUND_WORK* cp_work );
static void ZknSoundBmpDraw( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb, const SNDWaveData* cp_snd_data, int start, int end, int draw_xnum, int x, int def_y, int* p_set_y );
static void ZknSoundBmpDammyDraw( ZKN_SOUND_DRAWGLB* p_drawglb, int start, int end, int x, int def_y, int* p_set_y );
static void ZknSoundBmpDrawOne( GF_BGL_BMPWIN* p_bmp, u8 data, int x, int def_y, int* p_set_y );

// _Ot
static void ZknSoundGraphLevelSet( ZKN_SOUND_WORK* p_work, ZKN_SOUND_GLB* p_glb );
static void ZknSoundGraphInit( ZKN_SOUND_DRAW* p_draw );
static void ZknSoundGraphMove( ZKN_SOUND_DRAW* p_draw, const ZKN_SOUND_WORK* cp_work );

static void ZknSoundGraphInitData( ZKN_GRAPH_ONE_DATA* p_data, int x_num );
static void ZknSoundGraphMoveData( ZKN_GRAPH_ONE_DATA* p_data, int level );
static void ZknSoundGraphSetLevelMatrixTop( CLACT_WORK_PTR act, int level );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	@Av쐬
 *
 *	@param	p_data		AvP[Vf[^
 *	@param	zkn_sys		}ӃVXe
 *	@param	heap		gpq[v
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_SoundAplMake( ZKN_APL_DATA* p_data, ZKN_SYS_PTR zkn_sys, int heap )
{
	ZKN_SOUND_GLB*	p_glb;
	ZKN_SOUND_DRAWGLB*	p_drawglb;
//	ZKN_EVENT_DATA*	p_event;
	
	p_glb = MakeSoundGlb( heap, zkn_sys );
	p_drawglb = MakeSoundDrawGlb( heap, zkn_sys );
//	p_event = MakeSoundEvent( heap, zkn_sys );

	p_data->p_glb_data		= p_glb;
	p_data->p_glb_draw		= p_drawglb;
	p_data->p_event_data	= NULL;
//	p_data->p_event_data	= p_event;
	p_data->event_num		= SoundEventDataNumGet();

	p_data->do_func[ ZKN_PROC_FUNC_INIT ] = ZknSoundProcDoFuncInit;
	p_data->do_func[ ZKN_PROC_FUNC_MAIN ] = ZknSoundProcDoFuncMain;
	p_data->do_func[ ZKN_PROC_FUNC_DELETE ] = ZknSoundProcDoFuncDelete;
	p_data->draw_func[ ZKN_PROC_FUNC_INIT ] = ZknSoundProcDrawFuncInit;
	p_data->draw_func[ ZKN_PROC_FUNC_MAIN ] = ZknSoundProcDrawFuncMain;
	p_data->draw_func[ ZKN_PROC_FUNC_DELETE ] = ZknSoundProcDrawFuncDelete;
}
//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXg	Tuʁ@j[Avj
 *
 *	@param	p_data	AvP[Vf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_SoundAplDelete( ZKN_APL_DATA* p_data )
{
	DeleteSoundGlb( p_data->p_glb_data ); 
	DeleteSoundDrawGlb( p_data->p_glb_draw ); 
//	DeleteSoundEvent( p_data->p_event_data );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|POtF[hAEgݒ
 *
 *	@param	p_data	AvP[Vf[^
 *	@param	x		wW
 *	@param	y		xW
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_SoundPokeGraFadeOutSet( ZKN_APL_DATA* p_data, int x, int y )
{
	ZKN_SOUND_DRAWGLB* p_glb = p_data->p_glb_draw;

	p_glb->pokegra_move_x = x;
	p_glb->pokegra_move_y = y;
}

//----------------------------------------------------------------------------
/**
 *	@brief	tF[h[hݒ
 *
 *	@param	p_data		AvP[Vf[^
 *	@param	fade_mode	tF[h[h
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_SoundFadeModeSet( ZKN_APL_DATA* p_data, int fade_mode )
{
	ZKN_SOUND_DRAWGLB* p_glb = p_data->p_glb_draw;

	p_glb->fade_mode = fade_mode;
}

//----------------------------------------------------------------------------
/**
 *	@brief	tF[hVNݒ
 *
 *	@param	p_data		AvP[Vf[^
 *	@param	fade_mode	tF[hVN
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_SoundFadeModeSync( ZKN_APL_DATA* p_data, int fade_sync )
{
	ZKN_SOUND_DRAWGLB* p_glb = p_data->p_glb_draw;

	p_glb->fade_sync = fade_sync;
}


//-----------------------------------------------------------------------------
/**
 *		vCx[g֐
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	@O[of[^쐬
 *
 *	@param	heap		q[v
 *	@param	zkn_sys		}ӃVXe
 *
 *	@return	O[of[^
 *
 *
 */
//-----------------------------------------------------------------------------
static ZKN_SOUND_GLB* MakeSoundGlb( int heap, ZKN_SYS_PTR zkn_sys )
{
	ZKN_SOUND_GLB* p_glb;
	ZKN_APL_DATA* p_apl;

	p_glb = sys_AllocMemory( heap, sizeof(ZKN_SOUND_GLB) );
	GF_ASSERT( p_glb );
	memset( p_glb, 0, sizeof(ZKN_SOUND_GLB) );

	// mainʂ̃CxgL[
	p_glb->p_event_key = ZKN_SYS_GetEventKeyPtrMain( zkn_sys ); 

	// O[of[^
	p_glb->p_glb = ZKN_SYS_GetGlbData( zkn_sys );
	
	// ߂O[oAvf[^擾
	p_glb->p_main_common = ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_ZUKAN_COMMON );

	// TuO[oAvf[^擾
	p_glb->p_sub_sound = ZKN_GetAplDataSub( zkn_sys, ZKN_SYS_APLSUB_SOUND );

	return p_glb;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	@O[of[^쐬
 *
 *	@param	heap		q[v
 *	@param	zkn_sys		}ӃVXe
 *
 *	@return	O[of[^
 *
 *
 */
//-----------------------------------------------------------------------------
static ZKN_SOUND_DRAWGLB* MakeSoundDrawGlb( int heap, ZKN_SYS_PTR zkn_sys )
{
	ZKN_SOUND_DRAWGLB* p_glb;
	ZKN_APL_DATA* p_apl;

	p_glb = sys_AllocMemory( heap, sizeof(ZKN_SOUND_DRAWGLB) );
	GF_ASSERT( p_glb );
	memset( p_glb, 0, sizeof(ZKN_SOUND_DRAWGLB) );

	// `f[^
	p_glb->p_drawglb = ZKN_SYS_GetGlbDrawData( zkn_sys );

	return p_glb;
}
#if 0
//----------------------------------------------------------------------------
/**
 *
 *	@brief	@Cxg쐬
 *
 *	@param	heap		gpq[v
 *	@param	zkn_sys		}ӃVXe
 *
 *	@return	Cxgf[^
 *
 *
 */
//-----------------------------------------------------------------------------
static ZKN_EVENT_DATA* MakeSoundEvent( int heap, ZKN_SYS_PTR zkn_sys )
{
	ZKN_EVENT_DATA* p_event_tbl;
	int event_num = SoundEventDataNumGet();

	// Cxgf[^e[u쐬
	p_event_tbl = sys_AllocMemory( heap, sizeof(ZKN_EVENT_DATA) * event_num );
	GF_ASSERT( p_event_tbl );
	memset( p_event_tbl, 0, sizeof(ZKN_EVENT_DATA) * event_num );
	
	MakeSoundChangeBig( heap, &p_event_tbl[0], zkn_sys );

	return p_event_tbl;
}
#endif

//----------------------------------------------------------------------------
/**
 *
 *	@brief	@O[of[^j
 *
 *	@param	p_glb		O[of[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void DeleteSoundGlb( ZKN_SOUND_GLB* p_glb )
{
	GF_ASSERT( p_glb );
	sys_FreeMemoryEz( p_glb );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	@O[of[^j
 *
 *	@param	p_glb		O[of[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void DeleteSoundDrawGlb( ZKN_SOUND_DRAWGLB* p_glb )
{
	GF_ASSERT( p_glb );
	sys_FreeMemoryEz( p_glb );
}
#if 0
//----------------------------------------------------------------------------
/**
 *
 *	@brief	@Cxgf[^j
 *
 *	@param	p_event	Cxgf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void DeleteSoundEvent( ZKN_EVENT_DATA* p_event )
{
	GF_ASSERT( p_event );
	
	DeleteSoundChangeBig( &p_event[0] );

	sys_FreeMemoryEz( p_event );
}
#endif

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Av@Cxg擾
 *	
 *	@param	none	
 *
 *	@return	Av@Cxg
 *
 *
 */
//-----------------------------------------------------------------------------
static int SoundEventDataNumGet( void )
{
	return ZKN_SOUND_EVENT_NUM;
}


//-----------------------------------------------------------------------------
/**
 *		vZX֌W
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	[]
 *	@brief	AvP[VvZX	f[^ύX
 *
 *	@param	p_dodata	ZKN_PROC_DO_DATA
 *	@param	p_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknSoundProcDoFuncInit( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata )
{
	ZKN_SOUND_GLB* p_glb = p_glbdata;
	ZKN_SOUND_WORK* p_work;
	int mons_no = ZKN_GLBDATA_PokeMonsNoGet( p_glb->p_glb );
	
	// [N쐬
	p_work = sys_AllocMemory( p_dodata->heap, sizeof(ZKN_SOUND_WORK) );
	GF_ASSERT( p_work );
	memset( p_work, 0, sizeof(ZKN_SOUND_WORK) );
	p_dodata->p_work = p_work;
	

	// TEhf[^擾
	p_work->cp_snd_data = Snd_ZukanWaveDataSet( mons_no );

	// f[^z񐔎擾
	p_work->data_num = Snd_WaveDataSampleSizeGet( p_work->cp_snd_data );

	// `bN擾
	ZknSoundGetTich( p_work, p_glb );
	
	return ZKN_PROC_TRUE;
}

//----------------------------------------------------------------------------
/**
 *	[C]
 *	@brief	AvP[VvZX	f[^ύX
 *
 *	@param	p_dodata	ZKN_PROC_DO_DATA
 *	@param	p_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknSoundProcDoFuncMain( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata )
{
	ZKN_SOUND_GLB* p_glb = p_glbdata;
	ZKN_SOUND_WORK*	p_work = p_dodata->p_work;
	
	
	// I
	if( p_dodata->end_req == TRUE ){
		return ZKN_PROC_TRUE;
	}

	// lock
	if( p_dodata->lock == TRUE ){
		return ZKN_PROC_FALSE;
	}

	// `bN擾
	ZknSoundGetTich( p_work, p_glb );

	// g`xݒ
	ZknSoundGraphLevelSet( p_work, p_glb );

	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 *	[j]
 *	@brief	AvP[VvZX	f[^ύX
 *
 *	@param	p_dodata	ZKN_PROC_DO_DATA
 *	@param	p_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknSoundProcDoFuncDelete( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata )
{
	ZKN_SOUND_WORK* p_work = p_dodata->p_work;

	
	sys_FreeMemoryEz( p_work );
	p_dodata->p_work = NULL;
	
	return ZKN_PROC_TRUE;
}

//----------------------------------------------------------------------------
/**
 * []
 *
 *	@brief	AvP[VvZX	`
 *
 *	@param	p_glbdraw	`O[of[^
 *	@param	p_drawdata	ZKN_PROC_DRAW_DATA
 *	@param	cp_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *	@param	cp_dodata	̏̓[Nf[^
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknSoundProcDrawFuncInit( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata )
{
	const ZKN_SOUND_GLB* cp_dataglb = cp_glbdata;
	const ZKN_SOUND_WORK* cp_datawork = cp_dodata->p_work;
	ZKN_SOUND_DRAWGLB* p_drawglb = p_glbdraw;
	ZKN_SOUND_DRAW* p_drawwork = p_drawdata->p_work;
	BOOL check;

	switch( p_drawdata->seq ){
	case ZKN_SOUND_SEQINIT_ALLOC:
		p_drawdata->p_work = sys_AllocMemory( p_drawdata->heap, sizeof(ZKN_SOUND_DRAW) );
		memset( p_drawdata->p_work, 0, sizeof(ZKN_SOUND_DRAW) );
		p_drawdata->seq++;
		break;
		
	case ZKN_SOUND_SEQINIT_LOAD:
		ZknSoundLoadRes( p_drawwork, p_drawglb, cp_dataglb, cp_datawork, p_drawdata->heap );

		
		// tF[h
		if( p_drawglb->fade_mode == ZKN_SOUND_FADE_MODE_MY ){
			ZknSoundFadeInit( p_drawwork, p_drawglb, cp_dataglb, TRUE );
		}else{
			ZknSoundFadeOtherInit( p_drawwork, p_drawglb, cp_dataglb, TRUE );
		}

		// ̃tF[h
		Snd_BgmFadeOut( 0, BGM_FADE_ZUKAN_NAKIGOE_TIME );		//tF[hAEg
		
		p_drawdata->seq++;
		break;
		
	case ZKN_SOUND_SEQINIT_FADEIN:
		if( p_drawglb->fade_mode == ZKN_SOUND_FADE_MODE_MY ){
			check = ZknSoundFadeMain( p_drawwork, p_drawglb, cp_dataglb, TRUE );
		}else{
			check = ZknSoundFadeOtherMain( p_drawwork, p_drawglb, cp_dataglb, TRUE );
		}

		if( (check == TRUE) && ( Snd_FadeCheck() == 0 ) ){
			Snd_PlayerPause( PLAYER_FIELD, TRUE );		//tB[hBGM|[Y
			p_drawdata->seq++;
		}
		break;
		
	case ZKN_SOUND_SEQINIT_END:
		return ZKN_PROC_TRUE;
	}

	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 * [C]
 *
 *	@brief	AvP[VvZX	`
 *
 *	@param	p_glbdraw	`O[of[^
 *	@param	p_drawdata	ZKN_PROC_DRAW_DATA
 *	@param	cp_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *	@param	cp_dodata	̏̓[Nf[^
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknSoundProcDrawFuncMain( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata )
{
	const ZKN_SOUND_GLB* cp_dataglb = cp_glbdata;
	const ZKN_SOUND_WORK* cp_datawork = cp_dodata->p_work;
	ZKN_SOUND_DRAWGLB* p_drawglb = p_glbdraw;
	ZKN_SOUND_DRAW* p_drawwork = p_drawdata->p_work;

	// g`f[^
	ZknSoundBmpScroll( p_drawwork, p_drawglb, cp_datawork );

	// Ot
	ZknSoundGraphMove( p_drawwork, cp_datawork );

	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 * [j]
 *
 *	@brief	AvP[VvZX	`
 *
 *	@param	p_glbdraw	`O[of[^
 *	@param	p_drawdata	ZKN_PROC_DRAW_DATA
 *	@param	cp_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *	@param	cp_dodata	̏̓[Nf[^
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknSoundProcDrawFuncDelete( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata )
{
	const ZKN_SOUND_GLB* cp_dataglb = cp_glbdata;
	const ZKN_SOUND_WORK* cp_datawork = cp_dodata->p_work;
	ZKN_SOUND_DRAWGLB* p_drawglb = p_glbdraw;
	ZKN_SOUND_DRAW* p_drawwork = p_drawdata->p_work;
	BOOL check;


	switch( p_drawdata->seq ){
	case ZKN_SOUND_SEQDELETE_FADEOUT_INIT:
		if( p_drawglb->fade_mode == ZKN_SOUND_FADE_MODE_MY ){
			ZknSoundFadeInit( p_drawwork, p_drawglb, cp_dataglb, FALSE );
		}else{
			ZknSoundFadeOtherInit( p_drawwork, p_drawglb, cp_dataglb, FALSE );
		}

		Snd_PlayerPause( PLAYER_FIELD, FALSE );			//tB[hBGMĊJ
		Snd_BgmFadeIn( BGM_VOL_ZUKAN, BGM_FADE_ZUKAN_NAKIGOE_TIME, BGM_FADEIN_START_VOL_MIN );	//tF[hC

		p_drawdata->seq++;
		break;
		
	case ZKN_SOUND_SEQDELETE_FADEOUT:
		if( p_drawglb->fade_mode == ZKN_SOUND_FADE_MODE_MY ){
			check = ZknSoundFadeMain( p_drawwork, p_drawglb, cp_dataglb, FALSE );
		}else{
			check = ZknSoundFadeOtherMain( p_drawwork, p_drawglb, cp_dataglb, FALSE );
		}
		if( check ){
			p_drawdata->seq++;
		}
		break;

	case ZKN_SOUND_SEQDELETE_RELEASE:
		
		ZknSoundDeleteRes( p_drawwork, p_drawglb );
		
		p_drawdata->seq++;
		break;
		
	case ZKN_SOUND_SEQDELETE_FREE:

		sys_FreeMemoryEz(p_drawdata->p_work);
		p_drawdata->p_work = NULL;
		p_drawdata->seq++;
		break;
		
		
	case ZKN_SOUND_SEQDELETE_END:
		return ZKN_PROC_TRUE;
	}

	return ZKN_PROC_FALSE;
}


//----------------------------------------------------------------------------
/**
 *	@brief	|POtBbN\ON
 *
 *	@param	p_drawglb	`O[o
 *	@param	cp_glb		O[of[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundPokeGraOn( ZKN_SOUND_DRAWGLB* p_drawglb, const ZKN_SOUND_GLB* cp_glb )
{
	SOFT_SPRITE* p_pokegra = ZKN_GlbPokemonGraphicGet( p_drawglb->p_drawglb );
	int monsno = ZKN_GLBDATA_PokeMonsNoGet( cp_glb->p_glb );

	// |Pݒ
	ZKN_UTIL_PokemonGraphicSet( p_drawglb->p_drawglb, cp_glb->p_glb, monsno,
			PARA_FRONT, PARA_NORMAL, ZKN_SOUND_POKEGRA_DRAW_X, ZKN_SOUND_POKEGRA_DRAW_Y );
	
	// \
	SoftSpriteParaSet( p_pokegra, SS_PARA_VANISH, FALSE );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|POtBbN\OFF
 *
 *	@param	p_drawglb	`O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundPokeGraOff( ZKN_SOUND_DRAWGLB* p_drawglb )
{
	SOFT_SPRITE* p_pokegra = ZKN_GlbPokemonGraphicGet( p_drawglb->p_drawglb );

	// \OFF
	SoftSpriteParaSet( p_pokegra, SS_PARA_VANISH, TRUE );

	// \tgpbgtF[hĂ\̂OFF
	SoftSpritePalFadeOff( p_pokegra );
}

//----------------------------------------------------------------------------
/**
 *	@brief	OAMtF[h
 *
 *	@param	p_draw	`惏[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundOamFadeInit( ZKN_SOUND_DRAW* p_draw )
{
	int i, j;

	// SOtAN^[
	for( i=0; i<ZKN_SOUND_GRAPH_NUM; i++ ){

		for( j=0; j<ZKN_SOUND_GRAPH_ZANZOU_NUM; j++ ){
			CLACT_ObjModeSet( p_draw->snd_graph_act[i].zanzou[ j ].act, GX_OAM_MODE_XLU );
		}
		CLACT_ObjModeSet( p_draw->snd_graph_act[i].top.act, GX_OAM_MODE_XLU );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	OAMtF[hZbg
 *
 *	@param	p_draw	`惏[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundOamFadeDelete( ZKN_SOUND_DRAW* p_draw )
{
	int i, j;

	// SOtAN^[
	for( i=0; i<ZKN_SOUND_GRAPH_NUM; i++ ){

		for( j=0; j<ZKN_SOUND_GRAPH_ZANZOU_NUM; j++ ){
			CLACT_ObjModeSet( p_draw->snd_graph_act[i].zanzou[ j ].act, GX_OAM_MODE_NORMAL );
		}
		CLACT_ObjModeSet( p_draw->snd_graph_act[i].top.act, GX_OAM_MODE_NORMAL );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	tF[h
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	cp_glb		O[of[^
 *	@param	fadein_out	tF[hCAEg
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundFadeInit( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb, const ZKN_SOUND_GLB* cp_glb, BOOL fadein_out )
{
	// OAMݒ
	ZknSoundOamFadeInit( p_draw );

	// uCglXsĂ悢
	if( ZKN_ZukanCommonBrightnessOnFlagGet( cp_glb->p_main_common ) ){
		if( fadein_out ){
			// tF[hC
			ZKN_GLB_ChangeFadeRequest( &p_drawglb->p_drawglb->fade, ZKN_SOUND_FADE_SYNC, 
					BRIGHTNESS_BLACK, BRIGHTNESS_NORMAL, 0, 16, ZKN_SOUND_FADE_PLANEMSK, ZKN_BRIGHTNESS_MSK_PLANE2DEF, ZKN_UTIL_FADE_MAIN );
		}else{
			// tF[hAEg
			ZKN_GLB_ChangeFadeRequest( &p_drawglb->p_drawglb->fade, ZKN_SOUND_FADE_SYNC, 
					BRIGHTNESS_NORMAL, BRIGHTNESS_BLACK, 16, 0, ZKN_SOUND_FADE_PLANEMSK, ZKN_BRIGHTNESS_MSK_PLANE2DEF, ZKN_UTIL_FADE_MAIN );
		}
	}

	// uCglXlݒ
	ZKN_GLB_SpritePokeGraPalFade( p_drawglb->p_drawglb, &p_drawglb->p_drawglb->fade );
}

//----------------------------------------------------------------------------
/**
 *	@brief	tF[hC
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	cp_glb		O[of[^
 *	@param	fadein_out	tF[hCAEg
 *
 *	@retval	TRUE	tF[hI
 *	@retval	FALSE	tF[hr
 */
//-----------------------------------------------------------------------------
static BOOL ZknSoundFadeMain( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb, const ZKN_SOUND_GLB* cp_glb, BOOL fadein_out )
{
	BOOL check;

	// uCglX悤łĂ邩`FbN
	if( ZKN_ZukanCommonBrightnessOnFlagGet( cp_glb->p_main_common ) ){
		check = ZKN_GLB_ChangeFadeMain( &p_drawglb->p_drawglb->fade );
	}else{
		check = ZKN_GLB_ChangeFadeEndCheck( &p_drawglb->p_drawglb->fade );
	}

	// II
	if( check ){
		if( fadein_out ){
			// OAMj
			ZknSoundOamFadeDelete( p_draw );
		}

		return TRUE;
	}else{
		// uCglXlݒ
		ZKN_GLB_SpritePokeGraPalFade( p_drawglb->p_drawglb, &p_drawglb->p_drawglb->fade );
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	AvP[Vւ̃tF[h
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	cp_glb		O[of[^
 *	@param	fadein_out	tF[hC@AEg
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundFadeOtherInit( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb, const ZKN_SOUND_GLB* cp_glb, BOOL fadein_out )
{
	// OAMݒ
	ZknSoundOamFadeInit( p_draw );


	// tF[hAEg̎̏
	if( fadein_out == FALSE ){
		// |POtBbNtF[h
		ZKN_UTIL_MoveReq( &p_draw->pokegra_move, ZKN_SOUND_POKEGRA_DRAW_X, p_drawglb->pokegra_move_x, ZKN_SOUND_POKEGRA_DRAW_Y, p_drawglb->pokegra_move_y, p_drawglb->fade_sync );
	}

	// uCglXgėǂ
	if( ZKN_ZukanCommonBrightnessOnFlagGet( cp_glb->p_main_common ) ){
		
		if( fadein_out ){
			// tF[hC
			ZKN_GLB_ChangeFadeRequest( &p_drawglb->p_drawglb->fade, p_drawglb->fade_sync, 
					BRIGHTNESS_BLACK, BRIGHTNESS_NORMAL, 0, 16, ZKN_SOUND_FADE_PLANEMSK, ZKN_BRIGHTNESS_MSK_PLANE2DEF, ZKN_UTIL_FADE_MAIN );
		}else{
			// tF[hAEg
			ZKN_GLB_ChangeFadeRequest( &p_drawglb->p_drawglb->fade, p_drawglb->fade_sync, 
					BRIGHTNESS_NORMAL, BRIGHTNESS_BLACK, 16, 0, ZKN_SOUND_FADE_PLANEMSK, ZKN_BRIGHTNESS_MSK_PLANE2DEF, ZKN_UTIL_FADE_MAIN );
		}
	}
}
//----------------------------------------------------------------------------
/**
 *	@brief	AvP[Vւ̃tF[hC
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	cp_glb		O[of[^
 *	@param	fadein_out	tF[hC@AEg
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
static BOOL ZknSoundFadeOtherMain( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb, const ZKN_SOUND_GLB* cp_glb, BOOL fadein_out )
{
	BOOL check[ 2 ];
	int i;
	

	// tF[hAEĝƂ݂̂̏
	if( fadein_out == FALSE ){
		// |POtBbN
		check[0] = ZKN_UTIL_MoveMain( &p_draw->pokegra_move );

		// Wݒ
		ZKN_GlbPokemonGraphicSetMatrix( p_drawglb->p_drawglb, p_draw->pokegra_move.x, p_draw->pokegra_move.y );

	}else{
		check[0] = TRUE;
	}
	
	// uCglXgpĂ悢Ƃ͎fade𓮂
	if( ZKN_ZukanCommonBrightnessOnFlagGet( cp_glb->p_main_common ) ){
		check[1] = ZKN_GLB_ChangeFadeMain( &p_drawglb->p_drawglb->fade );
	}else{
		check[1] = ZKN_GLB_ChangeFadeEndCheck( &p_drawglb->p_drawglb->fade );
	}

	for( i=0; i<2; i++ ){
		if( check[i] == FALSE ){
			break;
		}
	}

	if( i==2 ){

		// tF[hĈƂ͔j
		if( fadein_out == TRUE ){
			// OAMݒj
			ZknSoundOamFadeDelete( p_draw );
		}
		return TRUE;
	}

	return FALSE;
}


//----------------------------------------------------------------------------
/**
 *	@brief	Resourceǂݍ݁ʍ\z
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	cp_glb		O[of[^
 *	@param	cp_datawork	f[^[N
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundLoadRes( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb, const ZKN_SOUND_GLB* cp_glb, const ZKN_SOUND_WORK* cp_datawork, int heap )
{
	
	// BGݒ
	ZknSoundSetUpBg( p_drawglb, cp_glb, heap );


	// OAM\[Xǂݍ
	ZknSoundOamResLoad( p_draw, p_drawglb, heap );

	// AN^[o^
	ZknSoundOamInit( p_draw, p_drawglb, heap );

	// FONTOAM
	ZknSoundFontOamInit( p_draw, p_drawglb, cp_glb, heap );

	// |POON
	ZknSoundPokeGraOn( p_drawglb, cp_glb );

	// XN[ݒ
	ZknSoundBmpScrollSetUp( p_draw, p_drawglb );

	// Ot
	ZknSoundGraphInit( p_draw );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Resourcej
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundDeleteRes( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb )
{
	// FONTOAM
	ZknSoundFontOamDelete( p_draw );
	
	// AN^[j
	ZknSoundOamDelete( p_draw );

	// OAM\[Xj
	ZknSoundOamResDelete( p_draw, p_drawglb );

	// BGݒ胊Zbg
	ZknSoundPutBackBg( p_drawglb );
	
}

//----------------------------------------------------------------------------
/**
 *	@brief	wiʃZbg	
 *
 *	@param	p_drawglb	`O[o
 *	@param	cp_glb		O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSetUpBg( ZKN_SOUND_DRAWGLB* p_drawglb, const ZKN_SOUND_GLB* cp_glb, int heap )
{
	void* buff;
	NNSG2dScreenData* p_scrn;

	// LN^f[^]
	ZKN_GLBDATA_BgCharSet( p_drawglb->p_drawglb, NARC_zukan_zkn_data_main_lzh_NCGR, p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_BACK_M, 0, 0, TRUE, heap );
	// XN[f[^ǂݍ
	buff = ZKN_GLBDATA_ScrnDataGet( p_drawglb->p_drawglb, NARC_zukan_zkn_voice_bg_main1_lzh_NSCR, TRUE, &p_scrn, heap );
	
	// XN[f[^
	GF_BGL_ScrWrite( p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_BACK_M,
			p_scrn->rawData, 0, 0,
			p_scrn->screenWidth / 8, p_scrn->screenHeight / 8 );

	sys_FreeMemoryEz( buff );

	// XN[f[^]
	GF_BGL_LoadScreenV_Req(p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_BACK_M );
}

//----------------------------------------------------------------------------
/**
 *	@brief	BGʂɖ߂
 *
 *	@param	p_drawglb
 *	@param	cp_glb 
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundPutBackBg( ZKN_SOUND_DRAWGLB* p_drawglb )
{
	GF_BGL_ScrollReq( p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_FONT_M, GF_BGL_SCROLL_X_SET, 0 );

	// `GÃLN^
	GF_BGL_BmpWinFill( &p_drawglb->p_drawglb->bmp_mfont,
			0 , 
			0,
			0,
			256,
			192 );
	

	GF_BGL_ScrClear( p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_FONT_M );

	GF_BGL_BmpWinSet_Pal( &p_drawglb->p_drawglb->bmp_mfont, ZKN_BG_FONT_COLOR );
}


//----------------------------------------------------------------------------
/**
 *	@brief	OAMResourceǂݍ
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundOamResLoad(  ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb, int heap )
{
	ZKN_GLB_DRAWDATA* p_draw_glb = p_drawglb->p_drawglb;
	ARCHANDLE* p_handle = ZKN_GLBDATA_ArcHandlGet( p_drawglb->p_drawglb );

	// LN^f[^ǂݍ
	p_draw->res_obj[ CLACT_U_CHAR_RES ] = CLACT_U_ResManagerResAddArcChar_ArcHandle( 
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ], p_handle,
			NARC_zukan_zkn_voice_oam_main_lzh_NCGR, TRUE,
			NARC_zukan_zkn_voice_oam_main_lzh_NCGR + ZKN_SOUND_RES_ID,
			NNS_G2D_VRAM_TYPE_2DMAIN, heap );
	// ]
	CLACT_U_CharManagerSetAreaCont( p_draw->res_obj[ CLACT_U_CHAR_RES ] );
	// OtBbNf[^j
	CLACT_U_ResManagerResOnlyDelete( p_draw->res_obj[ CLACT_U_CHAR_RES ] );

	// pbgf[^ǂݍ
	p_draw->res_obj[ CLACT_U_PLTT_RES ] = CLACT_U_ResManagerResAddArcPltt_ArcHandle( 
			p_draw_glb->res_manager[ CLACT_U_PLTT_RES ], p_handle,
			NARC_zukan_zkn_voice_oam_main_NCLR, FALSE, 
			NARC_zukan_zkn_voice_oam_main_NCLR + ZKN_SOUND_RES_ID, 
			NNS_G2D_VRAM_TYPE_2DMAIN, 
			ZKN_SOUND_PLTT_LOAD, heap );
	// ]
	CLACT_U_PlttManagerSetCleanArea( p_draw->res_obj[ CLACT_U_PLTT_RES ] );	
	// OtBbNf[^j
	CLACT_U_ResManagerResOnlyDelete( p_draw->res_obj[ CLACT_U_PLTT_RES ] );


	// Zf[^ǂݍ
	p_draw->res_obj[ CLACT_U_CELL_RES ] = CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ], p_handle,
			NARC_zukan_zkn_voice_oam_main_lzh_NCER, TRUE,
			NARC_zukan_zkn_voice_oam_main_lzh_NCER + ZKN_SOUND_RES_ID,
			CLACT_U_CELL_RES, heap );

	// ZAjf[^ǂݍ
	p_draw->res_obj[ CLACT_U_CELLANM_RES ] = CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ], p_handle, 
			NARC_zukan_zkn_voice_oam_main_lzh_NANR, TRUE,
			NARC_zukan_zkn_voice_oam_main_lzh_NANR + ZKN_SOUND_RES_ID,
			CLACT_U_CELLANM_RES, heap );
}

//----------------------------------------------------------------------------
/**
 *	@brief	OAMResourcej
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundOamResDelete( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb )
{
	ZKN_GLB_DRAWDATA* p_draw_glb = p_drawglb->p_drawglb;

	CLACT_U_CharManagerDelete( p_draw->res_obj[ CLACT_U_CHAR_RES ] );
	CLACT_U_PlttManagerDelete( p_draw->res_obj[ CLACT_U_PLTT_RES ] );

	// \[Xj
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ],
			p_draw->res_obj[ CLACT_U_CHAR_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_PLTT_RES ],
			p_draw->res_obj[ CLACT_U_PLTT_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ],
			p_draw->res_obj[ CLACT_U_CELL_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ],
			p_draw->res_obj[ CLACT_U_CELLANM_RES ] );
}

//----------------------------------------------------------------------------
/**
 *	@brief	OAMAN^[obt@쐬
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundOamInit( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb, int heap )
{
	CLACT_HEADER		clact_head;
	CLACT_ADD_SIMPLE	add;
	ZKN_GLB_DRAWDATA*	p_draw_glb = p_drawglb->p_drawglb;
	int i, j;
	
	// AN^[wb_[쐬
	CLACT_U_MakeHeader( &clact_head,
			NARC_zukan_zkn_voice_oam_main_lzh_NCGR + ZKN_SOUND_RES_ID,
			NARC_zukan_zkn_voice_oam_main_NCLR + ZKN_SOUND_RES_ID, 
			NARC_zukan_zkn_voice_oam_main_lzh_NCER + ZKN_SOUND_RES_ID,
			NARC_zukan_zkn_voice_oam_main_lzh_NANR + ZKN_SOUND_RES_ID,
			CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE, 0, ZKN_SOUND_OAM_BG_PRI,
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ],
			p_draw_glb->res_manager[ CLACT_U_PLTT_RES ],
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ],
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ],
			NULL, NULL );
	add.ClActSet	= p_draw_glb->clact_set;
	add.ClActHeader = &clact_head;
	add.pri			= ZKN_SOUND_OAM_PRI;
	add.DrawArea	= NNS_G2D_VRAM_TYPE_2DMAIN;
	add.heap		= heap;
	add.mat.x		= 0;
	add.mat.y		= 0;

	// SOtAN^[
	for( i=0; i<ZKN_SOUND_GRAPH_NUM; i++ ){

		for( j=0; j<ZKN_SOUND_GRAPH_ZANZOU_NUM; j++ ){
			p_draw->snd_graph_act[ i ].zanzou[ j ].act = CLACT_AddSimple( &add );
		}
		p_draw->snd_graph_act[ i ].top.act = CLACT_AddSimple( &add );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	OAMAN^[obt@j
 *
 *	@param	p_draw	`惏[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundOamDelete( ZKN_SOUND_DRAW* p_draw )
{
	int i, j;

	// SOtAN^[
	for( i=0; i<ZKN_SOUND_GRAPH_NUM; i++ ){

		for( j=0; j<ZKN_SOUND_GRAPH_ZANZOU_NUM; j++ ){
			CLACT_Delete( p_draw->snd_graph_act[ i ].zanzou[ j ].act );
		}
		CLACT_Delete( p_draw->snd_graph_act[ i ].top.act );
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	tHgOAM쐬
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	p_glb		O[of[^
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundFontOamInit( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb, const ZKN_SOUND_GLB* cp_glb, int heap )
{
}

//----------------------------------------------------------------------------
/**
 *	@brief	tHgOAMj
 *
 *	@param	p_draw `惏[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundFontOamDelete( ZKN_SOUND_DRAW* p_draw )
{
}

//----------------------------------------------------------------------------
/**
 *	@brief	`bN擾
 *
 *	@param	p_work	[N
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundGetTich( ZKN_SOUND_WORK* p_work, ZKN_SOUND_GLB* p_glb )
{
	int pitch = ZKN_SoundSubAplGetPitchNum( p_glb->p_sub_sound );
	
	// `bN擾
	p_work->tick = Snd_ZukanPlayerGetSampleTick( SND_HANDLE_PMVOICE, p_work->cp_snd_data, pitch );
}


//----------------------------------------------------------------------------
/**
 *	@brief	g`f[^rbg}bvɏ
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	cp_snd_data	f[^
 *	@param	start		`f[^zJnʒu
 *	@param	end			`f[^zIʒu
 *	@param	draw_xnum	`悷邘l		̐ɏ
 *	@param	x			`悘W
 *	@param	def_y		ftHgYʒu
 *	@param	p_set_y		Ōɐݒ肵YW
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundBmpDraw( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb, const SNDWaveData* cp_snd_data, int start, int end, int draw_xnum, int x, int def_y, int* p_set_y )
{
	const u8* p_snd_wave = Snd_WaveDataSampleAdrsGet( cp_snd_data );
	int i;
	int arry_idx;		// QƔzCfbNX
	int arry_num;		// zvf

	// `GÃLN^
	GF_BGL_BmpWinFill( &p_drawglb->p_drawglb->bmp_mfont,
			0 , x,
			def_y - ZKN_SOUND_DRAW_BMP_Y_MAX,
			ZKN_SOUND_DRAW_BMP_ONE_SIZE_X * (draw_xnum),
			ZKN_SOUND_DRAW_BMP_Y_MAX * 2 );
	
	arry_num = end - start;
	
	for( i=0; i<draw_xnum; i++ ){
		arry_idx = FX_Mul( arry_num << FX32_SHIFT, i << FX32_SHIFT );
		arry_idx = FX_Div( arry_idx, draw_xnum << FX32_SHIFT ) >> FX32_SHIFT;
		
		
		arry_idx += start;

		ZknSoundBmpDrawOne( &p_drawglb->p_drawglb->bmp_mfont, 
				p_snd_wave[ arry_idx ], x, def_y, p_set_y );

		x += ZKN_SOUND_DRAW_BMP_ONE_SIZE_X;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	P̃f[^rbg}bvɏ
 *
 *	@param	p_bmp
 *	@param	data
 *	@param	x
 *	@param	def_y
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundBmpDrawOne( GF_BGL_BMPWIN* p_bmp, u8 data, int x, int def_y, int* p_set_y )
{
	int y;
	int draw_st_y;
	int draw_y, draw_y2;

	// yWɕύX
	if( data > 127 ){
		y = data - 255;
	}else{
		y = data;
	}

	if( y != 0 ){
		// 킹		-32`32̒lɕύX
		y = FX_Mul( ZKN_SOUND_DRAW_BMP_Y_MAX << FX32_SHIFT, y << FX32_SHIFT );	
		y = FX_Div( y, 127 << FX32_SHIFT ) >> FX32_SHIFT;
	}

	//@`c@ƕ`JnW擾
	draw_y = (def_y + y);
	draw_y2 = (def_y + (*p_set_y));
	if( draw_y > draw_y2 ){

		draw_st_y = draw_y2;

		draw_y = draw_y - draw_y2;		
		
	}else{
		draw_st_y = draw_y;

		draw_y = draw_y2 - draw_y;		
	}
	draw_y ++;
	draw_y *= ZKN_SOUND_DRAW_BMP_ONE_SIZE_Y;

	GF_BGL_BmpWinFill( p_bmp, ZKN_SOUND_DRAW_BMP_PL, x, draw_st_y, ZKN_SOUND_DRAW_BMP_ONE_SIZE_X, draw_y );

	// ݒ肵_ۑ
	*p_set_y = y;
}

//----------------------------------------------------------------------------
/**
 *	@brief	_~[f[^`悷
 *
 *	@param	p_drawglb
 *	@param	start
 *	@param	end
 *	@param	x
 *	@param	def_y 
 *	@param	p_set_y
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSoundBmpDammyDraw( ZKN_SOUND_DRAWGLB* p_drawglb, int start, int end, int x, int def_y, int* p_set_y )
{
	int i;
	
	// `GÃLN^
	GF_BGL_BmpWinFill( &p_drawglb->p_drawglb->bmp_mfont,
			0, x, def_y - ZKN_SOUND_DRAW_BMP_Y_MAX,
			ZKN_SOUND_DRAW_BMP_ONE_SIZE_X * (end - start),
			ZKN_SOUND_DRAW_BMP_Y_MAX * 2 );
	
	for( i=start; i<end; i++ ){
		ZknSoundBmpDrawOne( &p_drawglb->p_drawglb->bmp_mfont, 
				0, x, def_y, p_set_y );

		x += ZKN_SOUND_DRAW_BMP_ONE_SIZE_X;
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	rbg}bvEBhẼXN[
 *
 *	@param	p_draw
 *	@param	p_drawglb
 *	@param	cp_work 
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundBmpScroll( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb, const ZKN_SOUND_WORK* cp_work )
{
	int draw_x;

	// Xs[hŃXN[
	p_draw->scrl_num += ZKN_SOUND_SCRL_BMP_SPEED;
	p_draw->scrl_num %= 256;

	// `Jnʒu
	draw_x = p_draw->scrl_num - (ZKN_SOUND_SCRL_BMP_SPEED * 2);
	if( draw_x < 0 ){
		draw_x += 256;
	}

	// XN[WƃXs[hg`f[^`
	if( p_draw->last_tick != cp_work->tick ){
		ZknSoundBmpDraw( p_draw, p_drawglb, 
				cp_work->cp_snd_data, 
				p_draw->last_tick, cp_work->tick, ZKN_SOUND_SCRL_BMP_SPEED,
				draw_x, ZKN_SOUND_DRAW_BMP_DEF_Y, &p_draw->last_y );
	}else{
		ZknSoundBmpDammyDraw( p_drawglb, 
				0, ZKN_SOUND_SCRL_BMP_SPEED,
				draw_x, ZKN_SOUND_DRAW_BMP_DEF_Y, &p_draw->last_y );
	}

	// XN[ݒ
	GF_BGL_ScrollReq( p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_FONT_M, GF_BGL_SCROLL_X_SET, p_draw->scrl_num );
	
	// CG]ݒ
	GF_BGL_BmpWinOnVReq( &p_drawglb->p_drawglb->bmp_mfont );

	// `bNۑ
	p_draw->last_tick = cp_work->tick;
}

//----------------------------------------------------------------------------
/**
 *	@brief	g`f[^̏
 *
 *	@param	p_draw		`惏[N	
 *	@param	p_drawglb	`O[o
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSoundBmpScrollSetUp( ZKN_SOUND_DRAW* p_draw, ZKN_SOUND_DRAWGLB* p_drawglb )
{
	GF_BGL_BmpWinSet_Pal( &p_drawglb->p_drawglb->bmp_mfont, ZKN_SOUND_DRAW_BMP_PL_TBL );
	
	ZknSoundBmpDammyDraw( p_drawglb, 
			0, 256,
			0, ZKN_SOUND_DRAW_BMP_DEF_Y, &p_draw->last_y );
	
	GF_BGL_BmpWinOn( &p_drawglb->p_drawglb->bmp_mfont );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Ot̃f[^S
 *
 *	@param	p_draw 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSoundGraphInit( ZKN_SOUND_DRAW* p_draw )
{
	int i;

	// Otf[^
	for( i=0; i<ZKN_SOUND_GRAPH_NUM; i++ ){
		ZknSoundGraphInitData( &p_draw->snd_graph_act[i], i );
	}
}

//----------------------------------------------------------------------------
/**	
 *	@brief	Ot
 *
 *	@param	p_draw	`惏[N
 *	@param	cp_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundGraphMove( ZKN_SOUND_DRAW* p_draw, const ZKN_SOUND_WORK* cp_work )
{
	int i;

	// Otf[^
	for( i=0; i<ZKN_SOUND_GRAPH_NUM; i++ ){
		ZknSoundGraphMoveData( &p_draw->snd_graph_act[i], cp_work->snd_graph_data[ i ] );
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	Otf[^
 *
 *	@param	p_data	f[^
 *	@param	x_num	vf	
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundGraphInitData( ZKN_GRAPH_ONE_DATA* p_data, int x_num )
{
	int i;
	VecFx32 mat;

	// Wݒ聕\ɂ
	mat.x = (ZKN_SOUND_GRAPH_MAT_DEF_X + ( ZKN_SOUND_GRAPH_MAT_OFS_X*x_num )) << FX32_SHIFT;
	mat.y = ZKN_SOUND_GRAPH_MAT_DEF_Y << FX32_SHIFT;
	for( i=0; i<ZKN_SOUND_GRAPH_ZANZOU_NUM; i++ ){
		CLACT_SetMatrix( p_data->zanzou[ i ].act, &mat );
		CLACT_SetDrawFlag( p_data->zanzou[ i ].act, FALSE );
		mat.y += ZKN_SOUND_GRAPH_MAT_OFS_Y << FX32_SHIFT;
		CLACT_AnmChg( p_data->zanzou[ i ].act, 1 );
	}

	// 擪̃AN^[̍WƏ[Nݒ
	mat.y = ZKN_SOUND_GRAPH_MAT_DEF_Y << FX32_SHIFT;
	CLACT_SetMatrix( p_data->top.act, &mat );
	CLACT_SetDrawFlag( p_data->top.act, FALSE );
}


//----------------------------------------------------------------------------
/**
 *	@brief	Ot
 *
 *	@param	p_data	Otf[^
 *	@param	level	̃x
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundGraphMoveData( ZKN_GRAPH_ONE_DATA* p_data, int level )
{
	int i;
	int now_max_level = 0;
	
	// levelɂe[N̐ݒ
	for( i=0; i<level; i++ ){
		CLACT_SetDrawFlag( p_data->zanzou[i].act, TRUE );
		p_data->zanzou[i].dess_count = ZKN_SOUND_GRAPH_DES_COUNT * (i + 1);
	}

	// c
	for( i=0; i<ZKN_SOUND_GRAPH_ZANZOU_NUM; i++ ){
		// `悵ĂȂ
		// jJE^0ɂȂ܂ŕ`悷
		if( CLACT_GetDrawFlag( p_data->zanzou[i].act ) ){
			if( (p_data->zanzou[i].dess_count - 1) > 0 ){
				p_data->zanzou[i].dess_count--;
				now_max_level = i + 1;	// ̍ő僌x
			}else{

				CLACT_SetDrawFlag( p_data->zanzou[i].act, FALSE );
			}

		}
	}
	
	// level̍Wɒ_Ă
	if( p_data->top.level <= now_max_level ){
		
		ZknSoundGraphSetLevelMatrixTop( p_data->top.act, now_max_level );
		p_data->top.down_count = ZKN_SOUND_GRAPH_DOWN_COUNT;

		// 邱Ƃɂԉ̎͂Oł\
		// Ȃɂ㏸Ƃɂ̂ݕ`JnƂɂȂ͂
		if( p_data->top.level < now_max_level ){
			// \
			CLACT_SetDrawFlag( p_data->top.act, TRUE );
		}

		p_data->top.level = now_max_level;

	}



	// 擪
	if( p_data->top.level > 0 ){

		// _EJEg0菬Ȃ痎Ă
		if( p_data->top.down_count < 0 ){
			p_data->top.level --;
			ZknSoundGraphSetLevelMatrixTop( p_data->top.act, p_data->top.level );
		}else{
			p_data->top.down_count --;
		}
	}else{

		// \
		CLACT_SetDrawFlag( p_data->top.act, FALSE );
	}
	
}

//----------------------------------------------------------------------------
/**
 *	@brief	AN^[ɈxYWݒ肷
 *
 *	@param	act
 *	@param	level 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSoundGraphSetLevelMatrixTop( CLACT_WORK_PTR act, int level )
{
	VecFx32 mat;
	const VecFx32* cp_mat;
	
	cp_mat = CLACT_GetMatrix( act );
	mat = *cp_mat;
	mat.y = (ZKN_SOUND_GRAPH_MAT_DEF_Y + ( ZKN_SOUND_GRAPH_MAT_OFS_Y*level)) << FX32_SHIFT;
	CLACT_SetMatrix( act, &mat );
}

//----------------------------------------------------------------------------
/**
 *	@brief	_Otf[^擾֐
 *
 *	@param	p_work	[N
 *	@param	p_glb	O[of[^
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundGraphLevelSet( ZKN_SOUND_WORK* p_work, ZKN_SOUND_GLB* p_glb )
{
	int pitch = ZKN_SoundSubAplGetPitchNum( p_glb->p_sub_sound );
	
	memset( p_work->snd_graph_data, 0, sizeof(u8)* ZKN_SOUND_GRAPH_NUM);

	if( Snd_PMVoicePlayCheck() != 0 ){	// Đ̂ݎ擾
		Snd_ZukanWaveLevelSet_New( p_work->cp_snd_data, p_work->snd_graph_data, ZKN_SOUND_GRAPH_NUM, pitch );
	}
}
