//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		zkn_sound_sub.c
 *	@brief		Tu
 *	@author		tomoya takahashi 
 *	@data		2006.01.21
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include <string.h>
#include "include/application/zukanlist/zkn_event_func.h"

#include "include/system/snd_tool.h"

#include "include/gflib/calctool.h"
#include "include/gflib/vram_transfer_manager.h"

#include "include/system/brightness.h"
#include "include/system/arc_tool.dat"
#include "include/system/arc_util.h"
#include "include/system/clact_util.h"
#include "include/application/zukanlist/zukan.naix"
#include "include/gflib/button_man.h"
#include "include/system/msgdata_util.h"
#include "include/msgdata/msg.naix"
#include "include/msgdata/msg_zkn.h"

#include "include/application/zukanlist/zkn_snd_def.h"
#include "include/application/zukanlist/zkn_zukan_common.h"
#include "include/application/zukanlist/zkn_cursor.h"
#include "include/application/zukanlist/zkn_sound.h"


#define	__ZKN_SOUND_SUB_SUB_H_GLOBAL
#include "include/application/zukanlist/zkn_sound_sub.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define ZKN_SOUND_SUB_EVENT_NUM ( 0 )	// Cxg

#define ZKN_SOUND_SUB_OAM_BG_PTR	( 2 )

enum{
	ZKN_SOUNDSUB_SEQINIT_ALLOC,
	ZKN_SOUNDSUB_SEQINIT_LOAD,
	ZKN_SOUNDSUB_SEQINIT_FADEIN,
	ZKN_SOUNDSUB_SEQINIT_END,
};
enum{
	ZKN_SOUNDSUB_SEQDELETE_FADEOUT_INIT,
	ZKN_SOUNDSUB_SEQDELETE_FADEOUT,
	ZKN_SOUNDSUB_SEQDELETE_RELEASE,
	ZKN_SOUNDSUB_SEQDELETE_FREE,
	ZKN_SOUNDSUB_SEQDELETE_END,
};


//-------------------------------------
//	{^
//=====================================
enum{
	ZKN_SOUNDSUB_BUTTON_SWITCH,
	ZKN_SOUNDSUB_BUTTON_DIAL,
	ZKN_SOUNDSUB_BUTTON_DISK,
	ZKN_SOUNDSUB_BUTTON_NUM,
};
#define ZKN_SOUNDSUB_BUTTON_SWITCH_X	( 64 )
#define ZKN_SOUNDSUB_BUTTON_SWITCH_Y	( 67 )
#define ZKN_SOUNDSUB_BUTTON_SWITCH_SIZXH	( 42 )	// TCY̔
#define ZKN_SOUNDSUB_BUTTON_SWITCH_SIZYH	( 14 )	// TCY̔
#define ZKN_SOUNDSUB_BUTTON_DIAL_X	( 51 )
#define ZKN_SOUNDSUB_BUTTON_DIAL_Y	( 157 )
#define ZKN_SOUNDSUB_BUTTON_DIAL_R	( 32 )

#define ZKN_SOUNDSUB_DISK_BG_CENTER_X	( ZKN_SOUNDSUB_DISK_BG_BGCX - (ZKN_SOUNDSUB_DISK_BG_X) )
#define ZKN_SOUNDSUB_DISK_BG_CENTER_Y	( ZKN_SOUNDSUB_DISK_BG_BGCY - (ZKN_SOUNDSUB_DISK_BG_Y) )
#define ZKN_SOUNDSUB_DISK_BG_R			( 72 )

//-------------------------------------
//	Tu{^
//	̈̂Ԃ̗p
//=====================================
enum{
	ZKN_SOUNDSUB_BUTTON_SUB_STARTSTOP,
	ZKN_SOUNDSUB_BUTTON_SUB_LOOP,
	ZKN_SOUNDSUB_BUTTON_SUB_NUM,
};
#define ZKN_SOUNDSUB_BUTTON_STARTSTOP_X	( 180 )
#define ZKN_SOUNDSUB_BUTTON_STARTSTOP_Y	( 131 )
#define ZKN_SOUNDSUB_BUTTON_STARTSTOP_SIZXH	( 24 )	// TCY̔
#define ZKN_SOUNDSUB_BUTTON_STARTSTOP_SIZYH	( 24 )	// TCY̔
#define ZKN_SOUNDSUB_BUTTON_STARTSTOP_X_DRAW	( ZKN_SOUNDSUB_BUTTON_STARTSTOP_X )	// `ʒu̕␳p
#define ZKN_SOUNDSUB_BUTTON_STARTSTOP_Y_DRAW	( ZKN_SOUNDSUB_BUTTON_STARTSTOP_Y )	// `ʒu̕␳p

#define ZKN_SOUNDSUB_BUTTON_LOOP_X	( 230 )
#define ZKN_SOUNDSUB_BUTTON_LOOP_Y	( 166 )
#define ZKN_SOUNDSUB_BUTTON_LOOP_SIZXH	( 32 )	// TCY̔
#define ZKN_SOUNDSUB_BUTTON_LOOP_SIZYH	( 32 )	// TCY̔
#define ZKN_SOUNDSUB_BUTTON_LOOP_X_DRAW	( ZKN_SOUNDSUB_BUTTON_LOOP_X )	// `ʒu̕␳p
#define ZKN_SOUNDSUB_BUTTON_LOOP_Y_DRAW	( ZKN_SOUNDSUB_BUTTON_LOOP_Y )	// `ʒu̕␳p

// Đ{^ʒuJ[\
#define ZKN_SOUNDSUB_CURSOR_START_SIZX ( 24 )
#define ZKN_SOUNDSUB_CURSOR_START_SIZY ( 24 )

// Aj[VV[PX
enum{
	ZKN_SOUNDSUB_SEQ_SWITCH_PICH_PAN,
	ZKN_SOUNDSUB_SEQ_DIAL,
	ZKN_SOUNDSUB_SEQ_SOUND_STOP_ANM,
	ZKN_SOUNDSUB_SEQ_SOUND_START_ANM,
	ZKN_SOUNDSUB_SEQ_SWITCH_PAN_PICH,
	ZKN_SOUNDSUB_SEQ_SOUND_LOOPON_ANM,
	ZKN_SOUNDSUB_SEQ_SOUND_LOOPOFF_ANM,
};
#define ZKN_SOUNDSUB_ANIME_FRAME	( FX32_ONE * 2 )


// sb`XCb`
enum{
	ZKN_SOUNDSUB_SWITCH_00,
	ZKN_SOUNDSUB_SWITCH_01,
	ZKN_SOUNDSUB_SWITCH_02,
	ZKN_SOUNDSUB_SWITCH_03,
	ZKN_SOUNDSUB_SWITCH_04,
	ZKN_SOUNDSUB_SWITCH_05,
	ZKN_SOUNDSUB_SWITCH_06,
	ZKN_SOUNDSUB_SWITCH_07,
	ZKN_SOUNDSUB_SWITCH_08,
};
enum{
	ZKN_SOUNDSUB_SEQ_SWITCH_PICH,
	ZKN_SOUNDSUB_SEQ_SWITCH_PAN,
	ZKN_SOUNDSUB_SEQ_SWITCH_NUM
};
#define ZKN_SOUNDSUB_SWITCH_MOVE_OK_DIS		( 12 )

// Đ{^
enum{
	ZKN_SOUNDSUB_START_00,
	ZKN_SOUNDSUB_START_01,
	ZKN_SOUNDSUB_START_02,
	ZKN_SOUNDSUB_START_03,
	ZKN_SOUNDSUB_START_04,
	ZKN_SOUNDSUB_START_05,
};
#define ZKN_SOUNDDUB_BUTTON_START_NOTOUCH	( 100 )

// [v{^
enum{
	ZKN_SOUNDSUB_LOOP_00,
	ZKN_SOUNDSUB_LOOP_01,
	ZKN_SOUNDSUB_LOOP_02,
	ZKN_SOUNDSUB_LOOP_03,
	ZKN_SOUNDSUB_LOOP_04,
	ZKN_SOUNDSUB_LOOP_05,
};

#define ZKN_SOUNDSUB_DIAL_LOOP_WAIT	( 10 )


// _CA
enum{
	ZKN_SOUNDSUB_DIAL_NONE,
	ZKN_SOUNDSUB_DIAL_REVERB,
	ZKN_SOUNDSUB_DIAL_FILTER,
};

#define ZKN_SOUNDSUB_DIAL_DIVISION	( 8 )

#define ZKN_SOUNDSUB_DIAL_NUM	( 21 )
#define ZKN_SOUNDSUB_DIAL_FILTER_NUM	( 1 )
#define ZKN_SOUNDSUB_DIAL_MOVE_LIMIT_ROTA	( FX_GET_ROTA_NUM( 1 ) )
#define ZKN_SOUNDSUB_DIAL_LIMIT		( 135 )
#define ZKN_SOUNDSUB_DIAL_LIMIT_MIN	( ZKN_SOUNDSUB_DIAL_LIMIT )
#define ZKN_SOUNDSUB_DIAL_LIMIT_MAX	( (360 - ZKN_SOUNDSUB_DIAL_LIMIT) )	

#define ZKN_SOUNDSUB_DIAL_CUT_ONE_NUM	( ZKN_SOUNDSUB_DIAL_LIMIT / ZKN_SOUNDSUB_DIAL_DIVISION )
#define ZKN_SOUNDSUB_DIAL_MIN_CUT_NUM	( FX_GET_ROTA_NUM(ZKN_SOUNDSUB_DIAL_CUT_ONE_NUM) )	// ƂÅpx̔{̒lɂ

// fBXN̍W
#define ZKN_SOUNDSUB_DISK_BG_X		( -48 )
#define ZKN_SOUNDSUB_DISK_BG_Y		( -16 )
#define ZKN_SOUNDSUB_DISK_BG_BGCX	( 131 )		// BGAtBϊpS
#define ZKN_SOUNDSUB_DISK_BG_BGCY	( 99 )		// BGAtBϊpS
#define ZKN_SOUNDSUB_DISK_BG_ROTA_MUL	( -16 )

#define ZKN_SOUNDSUB_DISK_PITCK_MAX	( 1024 )
#define ZKN_SOUNDSUB_DISK_CHORUS_MAX	( 127 )
#define ZKN_SOUNDSUB_DISK_PAN_MAX	( 127 )
#define ZKN_SOUNDSUB_DISK_PITCH_PAN_PL	( 7 )

// sb`p
#define ZKN_SOUNDSUB_BUTTONFONT_BMP_SIZE_CX	( 8 )
#define ZKN_SOUNDSUB_BUTTONFONT_BMP_SIZE_CY	( 2 )
#define ZKN_SOUNDSUB_PITCH_FOTN_X		( 40 )
#define ZKN_SOUNDSUB_PAN_FOTN_X			( 50 )
#define ZKN_SOUNDSUB_PITCH_PAN_FOTN_Y	( 86 )
#define ZKN_SOUNDSUB_BUTTON_PAL_OFS	(0)

#define ZKN_SOUNDSUB_FADE_PLANEMSK	( GX_BLEND_PLANEMASK_BG2|GX_BLEND_PLANEMASK_BG3|GX_BLEND_PLANEMASK_BD )

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	ȂTuʁ@O[oϐ
//=====================================
typedef struct {
	int* p_event_key;

	ZKN_GLB_DATA* p_glb;
	
	// }ӃRTuAvf[^
	const ZKN_APL_DATA* cp_zukan_common_apl;

	// OĎQƗp
	int now_pitch;		// ݒ蒆̃sb`
} ZKN_SOUND_SUB_GLB;

//-------------------------------------
//	傫׃Tuʉʁ@`O[oϐ
//=====================================
typedef struct {
	ZKN_GLB_DRAWDATA* p_drawglb;
} ZKN_SOUND_SUB_DRAWGLB;

//-------------------------------------
//	{^R[obNւ̃[N
//=====================================
typedef struct {
	void* p_glb;
	void* p_work;
} ZKN_SOUND_BUTTON_CALLBACK;

//-------------------------------------
//	ȂTuʁ@[N
//=====================================
typedef struct {
	// {^}l[W
	BUTTON_MAN* p_button_man;
	TP_HIT_TBL *hit_tbl;	// {^f[^
	ZKN_SOUND_BUTTON_CALLBACK callcack;

	// Tu{^}l[W
	TP_HIT_TBL* p_sub_hit_tbl;	// ̈̂Ԃ̂𔻒肷邽
	BUTTON_MAN* p_sub_button_man;
	int sub_button_event[ ZKN_SOUNDSUB_BUTTON_SUB_NUM ];

	// Đ{^p
	BOOL hit_start_stop_flag;

	
	// Đ{^tO
	BOOL start_touch_on;
		
	
	// Đ
	BOOL sound_play;

	// sb`XCb`	iR[XƃpύXXCb`ɕύX܂j
	int pitch_switch_touch;
	int pitch_switch_flag;
	int pitch_switch_touch_start_x;
	int pitch_num;		// sb`ݒ萔
	int pan_num;		// pݒ萔
	int chorus_num;		// R[X{[
	BOOL pitch_pan_push;// ĂƂTRUE

	// o[u/tB^[_C
	BOOL dial_touch;
	int	dial_flag;		// Ȃ0 o[u1 tB^[2
	int dial_start_x;
	int dial_start_y;
	int dial_rota;		// ݂̉]p
	int dial_div;		// ݂̕ʒu


	// [v
	BOOL loop;			// TRUE [v
	int loop_wait;		// [vEGCg

	const SNDWaveData* cp_snd_data;	// TEhf[^

} ZKN_SOUND_SUB_WORK;

//-------------------------------------
//	Aj{^[N
//=====================================
typedef struct {
	int anm_seq1;		// V[PX1
	int anm_seq2;		// V[PX2
	int now_anm_seq;	// ̃V[PX

	BOOL flag;			// V[PXXCb`tO

	int anm_num_max;	// Ajڰѐő
	int push_anm_limit;	// Aj̃~bgڰѐ
} ZKN_SOUND_SUB_ANM_BUTTON;


//-------------------------------------
//	ȂTuʉʁ@[N
//=====================================
typedef struct {
	// _C
	CLACT_WORK_PTR	dial;			// _C	
	
	//@Jn~
	CLACT_WORK_PTR	startstop;		// Jn~
	ZKN_SOUND_SUB_ANM_BUTTON start_stop_anim;

	// [v{^
	CLACT_WORK_PTR	loop;
	ZKN_SOUND_SUB_ANM_BUTTON loop_anim;
	
	// XCb`
	CLACT_WORK_PTR	pich_switch;	// XCb`	
	int now_switch;	// \ĂXCb`
	fx32 pich_switch_frame;

	//	fBXN 
	int disk_last_tick;
	u16	disk_rota;

	// sb`p
	ZKN_FONTOAM_DATA* p_fontoam[ ZKN_SOUNDSUB_SEQ_SWITCH_NUM ];

	// \[X
	CLACT_U_RES_OBJ_PTR res_obj[ ZKN_CLACT_RES_OBJ_NUM_DEF ];

	// fBXN点悤pbg
	void* p_pltt_buff;
	NNSG2dPaletteData* p_plt;
	BOOL pltt_anm;	// pbgONĂƂTRUE
} ZKN_SOUND_SUB_DRAW;


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *		AvP[Vf[^쐬֌W
 */
//-----------------------------------------------------------------------------
static ZKN_SOUND_SUB_GLB* MakeSoundSubGlb( int heap, ZKN_SYS_PTR zkn_sys );
static ZKN_SOUND_SUB_DRAWGLB* MakeSoundSubDrawGlb( int heap, ZKN_SYS_PTR zkn_sys );
static ZKN_EVENT_DATA* MakeSoundSubEvent( int heap, ZKN_SYS_PTR zkn_sys );
static void DeleteSoundSubGlb( ZKN_SOUND_SUB_GLB* p_glb );
static void DeleteSoundSubDrawGlb( ZKN_SOUND_SUB_DRAWGLB* p_glb );
static void DeleteSoundSubEvent( ZKN_EVENT_DATA* p_event );


static int SoundSubEventDataNumGet( void );


//-----------------------------------------------------------------------------
/**
 *		vZX֌W
 */
//-----------------------------------------------------------------------------
static int ZknSoundSubProcDoFuncInit( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata );
static int ZknSoundSubProcDoFuncMain( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata );
static int ZknSoundSubProcDoFuncDelete( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata );
static int ZknSoundSubProcDrawFuncInit( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata );
static int ZknSoundSubProcDrawFuncMain( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata );
static int ZknSoundSubProcDrawFuncDelete( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata );

// tF[h
static void ZknSoundSubOamFadeInit( ZKN_SOUND_SUB_DRAW* p_draw );
static void ZknSoundSubOamFadeDelete( ZKN_SOUND_SUB_DRAW* p_draw );
static void ZknSoundSubFadeInit( ZKN_SOUND_SUB_DRAW* p_draw, ZKN_SOUND_SUB_DRAWGLB* p_drawglb, const ZKN_SOUND_SUB_GLB* cp_glb, BOOL fadein_out );
static BOOL ZknSoundSubFadeMain( ZKN_SOUND_SUB_DRAW* p_draw, ZKN_SOUND_SUB_DRAWGLB* p_drawglb, const ZKN_SOUND_SUB_GLB* cp_glb, BOOL fadein_out );

// {^
static void ZknSoundSubButtonMake( ZKN_SOUND_SUB_WORK* p_work, ZKN_SOUND_SUB_GLB* p_glb, int heap );
static void ZknSoundSubButtonMove( ZKN_SOUND_SUB_WORK* p_work, ZKN_SOUND_SUB_GLB* p_glb );
static void ZknSoundSubButtonDelete( ZKN_SOUND_SUB_WORK* p_work );
static void ZknSoundSubButtonCallBack( u32 button_no, u32 event, void* p_work );

// J[\
static void ZknSoundSubCursorMove( ZKN_SOUND_SUB_WORK* p_work, ZKN_SOUND_SUB_GLB* p_glb );
static void ZknSoundSubCursorDrawMove( ZKN_SOUND_SUB_DRAWGLB* p_drawglb, const ZKN_SOUND_SUB_GLB* cp_glb );

static void ZknSoundSubStartButtonCallBack( u32 button_no, u32 event, void* p_work );
static void ZknSoundSubButtonTouch( u32 button_no, ZKN_SOUND_SUB_GLB* p_glb, ZKN_SOUND_SUB_WORK* p_work );
static void ZknSoundSubButtonHold( u32 button_no, ZKN_SOUND_SUB_GLB* p_glb, ZKN_SOUND_SUB_WORK* p_work );
static void ZknSoundSubButtonRelease( u32 button_no, ZKN_SOUND_SUB_GLB* p_glb, ZKN_SOUND_SUB_WORK* p_work );
static void ZknSoundSubButtonSlideOut( u32 button_no, ZKN_SOUND_SUB_GLB* p_glb, ZKN_SOUND_SUB_WORK* p_work );

// Đ
static void ZknSoundSubSoundStart( ZKN_SOUND_SUB_WORK* p_work, ZKN_SOUND_SUB_GLB* p_glb, int monsno );
static void ZknSoundSubSoundStop( ZKN_SOUND_SUB_WORK* p_work );
static void ZknSoundSubSoundLoop(  ZKN_SOUND_SUB_WORK* p_work, ZKN_SOUND_SUB_GLB* p_glb );
static void ZknSoundSubSoundLoopSet( ZKN_SOUND_SUB_WORK* p_work, BOOL flag );

// {^Aj
static void ZknSoundSubButtonAnimeMain( CLACT_WORK_PTR act, ZKN_SOUND_SUB_ANM_BUTTON* p_anmdata, BOOL now_flg, BOOL next_flg );
static void ZknSoundSubButtonAnimeMain_NO_Loop( CLACT_WORK_PTR act, ZKN_SOUND_SUB_ANM_BUTTON* p_anmdata, BOOL next_flg, int button_event );
static void ZknSoundSubButtonAnimeSeqSet( CLACT_WORK_PTR act, ZKN_SOUND_SUB_ANM_BUTTON* p_anmdata, BOOL flg );

// XCb`
static void ZknSoundSubSwitchDrawMove( ZKN_SOUND_SUB_DRAW* p_draw, const ZKN_SOUND_SUB_WORK* cp_work );
static void ZknSoundSubStartStopDrawMove( ZKN_SOUND_SUB_DRAW* p_draw, const ZKN_SOUND_SUB_WORK* cp_work );
static void ZknSoundSubLoopDrawMove( ZKN_SOUND_SUB_DRAW* p_draw, const ZKN_SOUND_SUB_WORK* cp_work );

static void ZknSoundSubPitchPanFontDraw( ZKN_SOUND_SUB_DRAW* p_draw );
static void ZknSoundSubPitchPanChorusOnOff( ZKN_SOUND_SUB_WORK* p_work, BOOL flag );
static void ZknSoundSubPitchPanChorusFlagOnOff( ZKN_SOUND_SUB_WORK* p_work, BOOL flag );
static void ZknSoundSubPitchPanChorusNumReset( ZKN_SOUND_SUB_WORK* p_work );
static void ZknSoundSubPitchPanChorusSet( ZKN_SOUND_SUB_WORK* p_work );
static void ZknSoundSubPitchPanAnm( ZKN_SOUND_SUB_DRAW* p_draw, const ZKN_SOUND_SUB_WORK* cp_work );

static void ZknSoundSubChorusStart( const ZKN_SOUND_SUB_GLB* cp_glb );
static void ZknSoundSubChorusSet( int volume );
static void ZknSoundSubPitchSet( int num );

// _C
static void ZknSoundSubDialCalc( ZKN_SOUND_SUB_WORK* p_work );
static void ZknSoundSubDialDivSet( ZKN_SOUND_SUB_WORK* p_work );
static void ZknSoundSubDialNumSet( ZKN_SOUND_SUB_WORK* p_work );
static void ZKnSoundSubDialDrawMove( ZKN_SOUND_SUB_DRAW* p_draw, const ZKN_SOUND_SUB_WORK* cp_work );
static void ZknSoundSubReverbEffectStop( ZKN_SOUND_SUB_WORK* p_work );

// fBXN
static void ZknSoundSubDiskDrawMove( ZKN_SOUND_SUB_DRAW* p_draw, ZKN_SOUND_SUB_DRAWGLB* p_drawglb, const ZKN_SOUND_SUB_WORK* cp_work );

static void ZknSoundSubDiskPitchSet( ZKN_SOUND_SUB_WORK* p_work, int x );
static void ZknSoundSubDiskChorusSet( ZKN_SOUND_SUB_WORK* p_work, int x );
static void ZknSoundSubDiskPanSet( ZKN_SOUND_SUB_WORK* p_work, int x );

// ǂݍ
static void ZknSoundSubLoadResource( ZKN_SOUND_SUB_DRAW* p_draw, ZKN_SOUND_SUB_DRAWGLB* p_drawglb, int heap );
static void ZknSoundSubReleaseResource( ZKN_SOUND_SUB_DRAW* p_draw, ZKN_SOUND_SUB_DRAWGLB* p_drawglb, int heap );
static void ZknSoundSubSetUpBg( ZKN_SOUND_SUB_DRAWGLB* p_drawglb, int heap );
static void ZknSoundSubPutDownBg( ZKN_SOUND_SUB_DRAWGLB* p_drawglb );
static void ZknSoundSubLoadOamData( ZKN_SOUND_SUB_DRAW* p_draw, ZKN_SOUND_SUB_DRAWGLB* p_drawglb, int heap );
static void ZknSoundSubReleaseOamData( ZKN_SOUND_SUB_DRAW* p_draw, ZKN_SOUND_SUB_DRAWGLB* p_drawglb );
static void ZknSoundSubAddClact( ZKN_SOUND_SUB_DRAW* p_draw, ZKN_SOUND_SUB_DRAWGLB* p_drawglb, int heap );
static void ZknSoundSubDeleteClact( ZKN_SOUND_SUB_DRAW* p_draw );
static void ZknSoundSubAddFontOam( ZKN_SOUND_SUB_DRAW* p_draw, ZKN_SOUND_SUB_DRAWGLB* p_drawglb, int heap );
static void ZknSoundSubDeleteFontOam( ZKN_SOUND_SUB_DRAW* p_draw, ZKN_SOUND_SUB_DRAWGLB* p_drawglb );

static void ZknSoundSubPlttLoad( ZKN_SOUND_SUB_DRAW* p_draw, ZKN_SOUND_SUB_DRAWGLB* p_drawglb, int heap );
static void ZknSoundSubPlttRelease( ZKN_SOUND_SUB_DRAW* p_draw );
static void ZknSoundSubPlttOn( ZKN_SOUND_SUB_DRAW* p_draw );
static void ZknSoundSubPlttOff( ZKN_SOUND_SUB_DRAW* p_draw );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ȂTuʁ@Av쐬
 *
 *	@param	p_data		AvP[Vf[^
 *	@param	zkn_sys		}ӃVXe
 *	@param	heap		gpq[v
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_SoundSubAplMake( ZKN_APL_DATA* p_data, ZKN_SYS_PTR zkn_sys, int heap )
{
	ZKN_SOUND_SUB_GLB*	p_glb;
	ZKN_SOUND_SUB_DRAWGLB*	p_drawglb;
	ZKN_EVENT_DATA*	p_event;
	
	p_glb = MakeSoundSubGlb( heap, zkn_sys );
	p_drawglb = MakeSoundSubDrawGlb( heap, zkn_sys );
	p_event = MakeSoundSubEvent( heap, zkn_sys );

	p_data->p_glb_data		= p_glb;
	p_data->p_glb_draw		= p_drawglb;
	p_data->p_event_data	= p_event;
	p_data->event_num		= SoundSubEventDataNumGet();

	p_data->do_func[ ZKN_PROC_FUNC_INIT ] = ZknSoundSubProcDoFuncInit;
	p_data->do_func[ ZKN_PROC_FUNC_MAIN ] = ZknSoundSubProcDoFuncMain;
	p_data->do_func[ ZKN_PROC_FUNC_DELETE ] = ZknSoundSubProcDoFuncDelete;
	p_data->draw_func[ ZKN_PROC_FUNC_INIT ] = ZknSoundSubProcDrawFuncInit;
	p_data->draw_func[ ZKN_PROC_FUNC_MAIN ] = ZknSoundSubProcDrawFuncMain;
	p_data->draw_func[ ZKN_PROC_FUNC_DELETE ] = ZknSoundSubProcDrawFuncDelete;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXg	Tuʁ@j[Avj
 *
 *	@param	p_data	AvP[Vf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_SoundSubAplDelete( ZKN_APL_DATA* p_data )
{
	DeleteSoundSubGlb( p_data->p_glb_data ); 
	DeleteSoundSubDrawGlb( p_data->p_glb_draw ); 
	DeleteSoundSubEvent( p_data->p_event_data );
}


//----------------------------------------------------------------------------
/**
 *	@brief	sb`擾
 *
 *	@param	cp_data	AvP[Vf[^
 *
 *	@return	sb`
 */
//-----------------------------------------------------------------------------
int ZKN_SoundSubAplGetPitchNum( const ZKN_APL_DATA* cp_data )
{
	const ZKN_SOUND_SUB_GLB* cp_glb = cp_data->p_glb_data;

	return cp_glb->now_pitch;
}



//-----------------------------------------------------------------------------
/**
 *		vCx[g֐
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	ȂTuʁ@O[of[^쐬
 *
 *	@param	heap		q[v
 *	@param	zkn_sys		}ӃVXe
 *
 *	@return	O[of[^
 *
 *
 */
//-----------------------------------------------------------------------------
static ZKN_SOUND_SUB_GLB* MakeSoundSubGlb( int heap, ZKN_SYS_PTR zkn_sys )
{
	ZKN_SOUND_SUB_GLB* p_glb;

	p_glb = sys_AllocMemory( heap, sizeof(ZKN_SOUND_SUB_GLB) );
	GF_ASSERT( p_glb );
	memset( p_glb, 0, sizeof(ZKN_SOUND_SUB_GLB) );

	// ϐ
	// CxgL[
	p_glb->p_event_key = ZKN_SYS_GetEventKeyPtrSub( zkn_sys );		

	// O[of[^
	p_glb->p_glb = ZKN_SYS_GetGlbData( zkn_sys );

	// }ӃRAvO[of[^
	p_glb->cp_zukan_common_apl = ZKN_GetAplDataSub( zkn_sys, ZKN_SYS_APLSUB_ZUKAN_COMMON );
	
	return p_glb;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ȂTuʁ@O[of[^쐬
 *
 *	@param	heap		q[v
 *	@param	zkn_sys		}ӃVXe
 *
 *	@return	O[of[^
 *
 *
 */
//-----------------------------------------------------------------------------
static ZKN_SOUND_SUB_DRAWGLB* MakeSoundSubDrawGlb( int heap, ZKN_SYS_PTR zkn_sys )
{
	ZKN_SOUND_SUB_DRAWGLB* p_glb;
	ZKN_APL_DATA* p_apl;

	p_glb = sys_AllocMemory( heap, sizeof(ZKN_SOUND_SUB_DRAWGLB) );
	GF_ASSERT( p_glb );
	memset( p_glb, 0, sizeof(ZKN_SOUND_SUB_DRAWGLB) );


	// `f[^
	p_glb->p_drawglb = ZKN_SYS_GetGlbDrawData( zkn_sys );

	return p_glb;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ȂTuʁ@Cxg쐬
 *
 *	@param	heap		gpq[v
 *	@param	zkn_sys		}ӃVXe
 *
 *	@return	Cxgf[^
 *
 *
 */
//-----------------------------------------------------------------------------
static ZKN_EVENT_DATA* MakeSoundSubEvent( int heap, ZKN_SYS_PTR zkn_sys )
{
	return NULL;	// ͂Ȃ
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ȂTuʁ@O[of[^j
 *
 *	@param	p_glb		O[of[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void DeleteSoundSubGlb( ZKN_SOUND_SUB_GLB* p_glb )
{
	GF_ASSERT( p_glb );
	sys_FreeMemoryEz( p_glb );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ȂTuʁ@O[of[^j
 *
 *	@param	p_glb		O[of[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void DeleteSoundSubDrawGlb( ZKN_SOUND_SUB_DRAWGLB* p_glb )
{
	GF_ASSERT( p_glb );
	sys_FreeMemoryEz( p_glb );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ȂTuʁ@Cxgf[^j
 *
 *	@param	p_event	Cxgf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void DeleteSoundSubEvent( ZKN_EVENT_DATA* p_event )
{
	// ͂Ȃ
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ȂTuʃAv@Cxg擾
 *	
 *	@param	none	
 *
 *	@return	ȂTuʃAv@Cxg
 *
 *
 */
//-----------------------------------------------------------------------------
static int SoundSubEventDataNumGet( void )
{
	return ZKN_SOUND_SUB_EVENT_NUM;
}


//-----------------------------------------------------------------------------
/**
 *		vZX֌W
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	[]
 *	@brief	AvP[VvZX	f[^ύX
 *
 *	@param	p_dodata	ZKN_PROC_DO_DATA
 *	@param	p_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknSoundSubProcDoFuncInit( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata )
{
	ZKN_SOUND_SUB_GLB* p_glb = p_glbdata;
	ZKN_SOUND_SUB_WORK* p_work = p_dodata->p_work;
	int i;
	int monsno = ZKN_GLBDATA_PokeMonsNoGet( p_glb->p_glb );

	// [N̍쐬
	p_work = sys_AllocMemory( p_dodata->heap, sizeof(ZKN_SOUND_SUB_WORK) );
	memset( p_work, 0, sizeof(ZKN_SOUND_SUB_WORK) );


	// {^쐬
	ZknSoundSubButtonMake( p_work, p_glb, p_dodata->heap );

	// {^̏ԂPݒ
	// {^
	ZknSoundSubButtonMove( p_work, p_glb );

	// TEhf[^擾
	p_work->cp_snd_data = Snd_ZukanWaveDataSet( monsno );	


	p_dodata->p_work = p_work;
	
	return ZKN_PROC_TRUE;
}

//----------------------------------------------------------------------------
/**
 *	[C]
 *	@brief	AvP[VvZX	f[^ύX
 *
 *	@param	p_dodata	ZKN_PROC_DO_DATA
 *	@param	p_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknSoundSubProcDoFuncMain( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata )
{

	ZKN_SOUND_SUB_GLB* p_glb = p_glbdata;
	ZKN_SOUND_SUB_WORK* p_work = p_dodata->p_work;
	
	// I
	if( p_dodata->end_req == TRUE ){
		return ZKN_PROC_TRUE;
	}

	// lock
	if( p_dodata->lock == TRUE ){
		return ZKN_PROC_FALSE;
	}

	// ݍĐ̃sb`擾
	p_glb->now_pitch = p_work->pitch_num;

	// `FbN
	if( ZKN_ZukanCommonSubMoveFlagGet( p_glb->cp_zukan_common_apl ) ){
		// Đ`FbN
		if( Snd_PMVoicePlayCheck() == FALSE ){
			// [v[hł͂ȂȂ~ɂ
			if( p_work->loop == FALSE ){
				ZknSoundSubSoundStop( p_work );
			}
		}

		// {^
		ZknSoundSubButtonMove( p_work, p_glb );
		
		// J[\
		// J[\LŁATuAvɃJ[\삪ĂƂ̂
		if( ZKN_ZukanCommonSubCursorFlagGet( p_glb->cp_zukan_common_apl ) &&
			ZKN_GLBDATA_TouchCursorFlagGet( p_glb->p_glb ) ){

			ZknSoundSubCursorMove( p_work, p_glb );
		}
		

		// [v[h̏
		if( p_work->loop && p_work->sound_play ){
			ZknSoundSubSoundLoop( p_work, p_glb );
		}

	}

	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 *	[j]
 *	@brief	AvP[VvZX	f[^ύX
 *
 *	@param	p_dodata	ZKN_PROC_DO_DATA
 *	@param	p_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknSoundSubProcDoFuncDelete( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata )
{
	ZKN_SOUND_SUB_GLB* p_glb = p_glbdata;
	ZKN_SOUND_SUB_WORK* p_work = p_dodata->p_work;

	// {^j
	ZknSoundSubButtonDelete( p_work );

	// [Nj
	sys_FreeMemoryEz( p_work );

	return ZKN_PROC_TRUE;
}

//----------------------------------------------------------------------------
/**
 * []
 *
 *	@brief	AvP[VvZX	`
 *
 *	@param	p_glbdraw	`O[of[^
 *	@param	p_drawdata	ZKN_PROC_DRAW_DATA
 *	@param	cp_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *	@param	cp_dodata	̏̓[Nf[^
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknSoundSubProcDrawFuncInit( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata )
{
	const ZKN_SOUND_SUB_GLB* cp_dataglb = cp_glbdata;
	const ZKN_SOUND_SUB_WORK* cp_datawork = cp_dodata->p_work;
	ZKN_SOUND_SUB_DRAWGLB*	p_drawglb = p_glbdraw;
	ZKN_SOUND_SUB_DRAW*		p_drawwork = p_drawdata->p_work;

	switch( p_drawdata->seq ){
	case ZKN_SOUNDSUB_SEQINIT_ALLOC:
		p_drawdata->p_work = sys_AllocMemory( p_drawdata->heap, sizeof(ZKN_SOUND_SUB_DRAW) );
		memset( p_drawdata->p_work, 0, sizeof(ZKN_SOUND_SUB_DRAW) );
		p_drawdata->seq++;
		break;
		
	case ZKN_SOUNDSUB_SEQINIT_LOAD:
		// Resourceǂݍ
		ZknSoundSubLoadResource( p_drawwork, p_drawglb, p_drawdata->heap );
		// tF[h
		ZknSoundSubFadeInit( p_drawwork, p_drawglb, cp_dataglb, TRUE );
		
		p_drawdata->seq++;
		break;
		
	case ZKN_SOUNDSUB_SEQINIT_FADEIN:
		
		if( ZknSoundSubFadeMain( p_drawwork, p_drawglb, cp_dataglb, TRUE ) ){
			p_drawdata->seq++;
		}
		break;
		
	case ZKN_SOUNDSUB_SEQINIT_END:
		// J[\AjJn
		ZKN_UTIL_CursorSetAnimeStopFlag( &p_drawglb->p_drawglb->cursor, FALSE );
		return ZKN_PROC_TRUE;
		
	default:
		break;
	}
	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 * [C]
 *
 *	@brief	AvP[VvZX	`
 *
 *	@param	p_glbdraw	`O[of[^
 *	@param	p_drawdata	ZKN_PROC_DRAW_DATA
 *	@param	cp_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *	@param	cp_dodata	̏̓[Nf[^
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknSoundSubProcDrawFuncMain( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata )
{
	const ZKN_SOUND_SUB_GLB* cp_dataglb = cp_glbdata;
	const ZKN_SOUND_SUB_WORK* cp_datawork = cp_dodata->p_work;
	ZKN_SOUND_SUB_DRAWGLB*	p_drawglb = p_glbdraw;
	ZKN_SOUND_SUB_DRAW*		p_drawwork = p_drawdata->p_work;

	// `FbN
	if( ZKN_ZukanCommonSubMoveFlagGet( cp_dataglb->cp_zukan_common_apl ) ){

		// XCb`
		ZknSoundSubSwitchDrawMove( p_drawwork, cp_datawork );

		// ĐXgbv`
		ZknSoundSubStartStopDrawMove( p_drawwork, cp_datawork );

		// [v`
		ZknSoundSubLoopDrawMove( p_drawwork, cp_datawork );

		// _CA`
		ZKnSoundSubDialDrawMove( p_drawwork, cp_datawork );

		// fBXN
		ZknSoundSubDiskDrawMove( p_drawwork, p_drawglb, cp_datawork );

		// XCb`
		ZknSoundSubPitchPanFontDraw( p_drawwork );

		// sb`ppbgAj
		ZknSoundSubPitchPanAnm( p_drawwork, cp_datawork );

		// J[\
		ZknSoundSubCursorDrawMove( p_drawglb, cp_dataglb );
	}


	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 * [j]
 *
 *	@brief	AvP[VvZX	`
 *
 *	@param	p_glbdraw	`O[of[^
 *	@param	p_drawdata	ZKN_PROC_DRAW_DATA
 *	@param	cp_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *	@param	cp_dodata	̏̓[Nf[^
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknSoundSubProcDrawFuncDelete( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata )
{
	const ZKN_SOUND_SUB_GLB* cp_dataglb = cp_glbdata;
	const ZKN_SOUND_SUB_WORK* cp_datawork = cp_dodata->p_work;
	ZKN_SOUND_SUB_DRAWGLB*	p_drawglb = p_glbdraw;
	ZKN_SOUND_SUB_DRAW*		p_drawwork = p_drawdata->p_work;

	switch( p_drawdata->seq ){
	case ZKN_SOUNDSUB_SEQDELETE_FADEOUT_INIT:
		// J[\Aj~
		ZKN_UTIL_CursorSetAnimeStopFlag( &p_drawglb->p_drawglb->cursor, TRUE );

		// OFFpbgݒ
		ZknSoundSubPlttOff( p_drawwork );
		
		// tF[h
		ZknSoundSubFadeInit( p_drawwork, p_drawglb, cp_dataglb, FALSE );
		p_drawdata->seq++;
		break;
		
	case ZKN_SOUNDSUB_SEQDELETE_FADEOUT:
		if( ZknSoundSubFadeMain( p_drawwork, p_drawglb, cp_dataglb, FALSE ) ){
			p_drawdata->seq++;
		}
		break;

	case ZKN_SOUNDSUB_SEQDELETE_RELEASE:
		// Resourceǂݍ
		ZknSoundSubReleaseResource( p_drawwork, p_drawglb, p_drawdata->heap );
		p_drawdata->seq++;
		break;
		
	case ZKN_SOUNDSUB_SEQDELETE_FREE:
		sys_FreeMemoryEz( p_drawdata->p_work );
		p_drawdata->seq++;
		break;
		
		
	case ZKN_SOUNDSUB_SEQDELETE_END:
		return ZKN_PROC_TRUE;
		
	default:
		break;
	}
	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	OAMtF[h	
 *
 *	@param	p_draw	`惏[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubOamFadeInit( ZKN_SOUND_SUB_DRAW* p_draw )
{
	CLACT_ObjModeSet( p_draw->dial, GX_OAM_MODE_XLU );
	CLACT_ObjModeSet( p_draw->pich_switch, GX_OAM_MODE_XLU );
	CLACT_ObjModeSet( p_draw->startstop, GX_OAM_MODE_XLU );
	CLACT_ObjModeSet( p_draw->loop, GX_OAM_MODE_XLU );

	FONTOAM_ObjModeSet( p_draw->p_fontoam[ ZKN_SOUNDSUB_SEQ_SWITCH_PICH ]->p_fontoam, GX_OAM_MODE_XLU );
	FONTOAM_ObjModeSet( p_draw->p_fontoam[ ZKN_SOUNDSUB_SEQ_SWITCH_PAN ]->p_fontoam, GX_OAM_MODE_XLU );
}

//----------------------------------------------------------------------------
/**
 *	@brief	OAMtF[h@㏈
 *
 *	@param	p_draw 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubOamFadeDelete( ZKN_SOUND_SUB_DRAW* p_draw )
{
	CLACT_ObjModeSet( p_draw->dial, GX_OAM_MODE_NORMAL );
	CLACT_ObjModeSet( p_draw->pich_switch, GX_OAM_MODE_NORMAL );
	CLACT_ObjModeSet( p_draw->startstop, GX_OAM_MODE_NORMAL );
	CLACT_ObjModeSet( p_draw->loop, GX_OAM_MODE_NORMAL );

	FONTOAM_ObjModeSet( p_draw->p_fontoam[ ZKN_SOUNDSUB_SEQ_SWITCH_PICH ]->p_fontoam, GX_OAM_MODE_NORMAL );
	FONTOAM_ObjModeSet( p_draw->p_fontoam[ ZKN_SOUNDSUB_SEQ_SWITCH_PAN ]->p_fontoam, GX_OAM_MODE_NORMAL );
}

//----------------------------------------------------------------------------
/**
 *	@brief	TuʃtF[h
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb		`O[o
 *	@param	cp_glb		O[o
 *	@param	fadein_out	tF[hC@TRUE@AEg FALSE	
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubFadeInit( ZKN_SOUND_SUB_DRAW* p_draw, ZKN_SOUND_SUB_DRAWGLB* p_drawglb, const ZKN_SOUND_SUB_GLB* cp_glb, BOOL fadein_out )
{
	// OAMݒ
	ZknSoundSubOamFadeInit( p_draw );

	// uCglXsĂ悢
	if( ZKN_ZukanCommonSubBrightnessOnFlagGet( cp_glb->cp_zukan_common_apl ) ){
		if( fadein_out ){
			// tF[hC
			ZKN_GLB_ChangeFadeRequest( &p_drawglb->p_drawglb->fade_sub, ZKN_SOUND_FADE_SYNC, 
					BRIGHTNESS_BLACK, BRIGHTNESS_NORMAL, 0, 16, ZKN_SOUNDSUB_FADE_PLANEMSK, ZKN_BRIGHTNESS_MSK_PLANE2DEF, ZKN_UTIL_FADE_SUB );
		}else{
			// tF[hAEg
			ZKN_GLB_ChangeFadeRequest( &p_drawglb->p_drawglb->fade_sub, ZKN_SOUND_FADE_SYNC, 
					BRIGHTNESS_NORMAL, BRIGHTNESS_BLACK, 16, 0, ZKN_SOUNDSUB_FADE_PLANEMSK, ZKN_BRIGHTNESS_MSK_PLANE2DEF, ZKN_UTIL_FADE_SUB );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	tF[h@C
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb		`O[o
 *	@param	cp_glb		O[o
 *	@param	fadein_out	tF[hC@TRUE@AEg@FALSE
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
static BOOL ZknSoundSubFadeMain( ZKN_SOUND_SUB_DRAW* p_draw, ZKN_SOUND_SUB_DRAWGLB* p_drawglb, const ZKN_SOUND_SUB_GLB* cp_glb, BOOL fadein_out )
{
	BOOL check;

	// uCglX悤łĂ邩`FbN
	if( ZKN_ZukanCommonSubBrightnessOnFlagGet( cp_glb->cp_zukan_common_apl ) ){
		check = ZKN_GLB_ChangeFadeMain( &p_drawglb->p_drawglb->fade_sub );
	}else{
//		check = ZKN_GLB_ChangeFadeEndCheck( &p_drawglb->p_drawglb->fade_sub );
		check = IsFinishedBrightnessChg( MASK_SUB_DISPLAY );
	}

	// II
	if( check ){
		if( fadein_out ){
			// OAMj
			ZknSoundSubOamFadeDelete( p_draw );
		}

		return TRUE;
	}

	return FALSE;
}



//----------------------------------------------------------------------------
/**
 *	@brief	{^쐬֐
 *
 *	@param	p_work	[N
 *	@param	p_glb	O[o
 *	@param	heap	q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubButtonMake( ZKN_SOUND_SUB_WORK* p_work, ZKN_SOUND_SUB_GLB* p_glb, int heap )
{
	// e[u쐬
	p_work->hit_tbl = sys_AllocMemory( heap, sizeof(TP_HIT_TBL) * ZKN_SOUNDSUB_BUTTON_NUM );
	p_work->p_sub_hit_tbl = sys_AllocMemory( heap, sizeof(TP_HIT_TBL) * ZKN_SOUNDSUB_BUTTON_SUB_NUM );

	// e[uf[^ݒ
	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl[ ZKN_SOUNDSUB_BUTTON_SWITCH ],
			ZKN_SOUNDSUB_BUTTON_SWITCH_Y - (ZKN_SOUNDSUB_BUTTON_SWITCH_SIZYH),
			ZKN_SOUNDSUB_BUTTON_SWITCH_Y + (ZKN_SOUNDSUB_BUTTON_SWITCH_SIZYH),
			ZKN_SOUNDSUB_BUTTON_SWITCH_X - (ZKN_SOUNDSUB_BUTTON_SWITCH_SIZXH),
			ZKN_SOUNDSUB_BUTTON_SWITCH_X + (ZKN_SOUNDSUB_BUTTON_SWITCH_SIZXH) );

	p_work->hit_tbl[ ZKN_SOUNDSUB_BUTTON_DIAL ].circle.code = TP_USE_CIRCLE;
	p_work->hit_tbl[ ZKN_SOUNDSUB_BUTTON_DIAL ].circle.x = ZKN_SOUNDSUB_BUTTON_DIAL_X;
	p_work->hit_tbl[ ZKN_SOUNDSUB_BUTTON_DIAL ].circle.y = ZKN_SOUNDSUB_BUTTON_DIAL_Y;
	p_work->hit_tbl[ ZKN_SOUNDSUB_BUTTON_DIAL ].circle.r = ZKN_SOUNDSUB_BUTTON_DIAL_R;


	p_work->hit_tbl[ ZKN_SOUNDSUB_BUTTON_DISK ].circle.code = TP_USE_CIRCLE;
	p_work->hit_tbl[ ZKN_SOUNDSUB_BUTTON_DISK ].circle.x = ZKN_SOUNDSUB_DISK_BG_CENTER_X;
	p_work->hit_tbl[ ZKN_SOUNDSUB_BUTTON_DISK ].circle.y = ZKN_SOUNDSUB_DISK_BG_CENTER_Y;
	p_work->hit_tbl[ ZKN_SOUNDSUB_BUTTON_DISK ].circle.r = ZKN_SOUNDSUB_DISK_BG_R;


	// Tu{^}l[Wp
	ZKN_UTIL_HitTblDataSet( &p_work->p_sub_hit_tbl[ ZKN_SOUNDSUB_BUTTON_SUB_STARTSTOP ],
			ZKN_SOUNDSUB_BUTTON_STARTSTOP_Y - (ZKN_SOUNDSUB_BUTTON_STARTSTOP_SIZYH),
			ZKN_SOUNDSUB_BUTTON_STARTSTOP_Y + (ZKN_SOUNDSUB_BUTTON_STARTSTOP_SIZYH),
			ZKN_SOUNDSUB_BUTTON_STARTSTOP_X - (ZKN_SOUNDSUB_BUTTON_STARTSTOP_SIZXH),
			ZKN_SOUNDSUB_BUTTON_STARTSTOP_X + (ZKN_SOUNDSUB_BUTTON_STARTSTOP_SIZXH) );

	ZKN_UTIL_HitTblDataSet( &p_work->p_sub_hit_tbl[ ZKN_SOUNDSUB_BUTTON_SUB_LOOP ],
			ZKN_SOUNDSUB_BUTTON_LOOP_Y - (ZKN_SOUNDSUB_BUTTON_LOOP_SIZYH),
			ZKN_SOUNDSUB_BUTTON_LOOP_Y + (ZKN_SOUNDSUB_BUTTON_LOOP_SIZYH),
			ZKN_SOUNDSUB_BUTTON_LOOP_X - (ZKN_SOUNDSUB_BUTTON_LOOP_SIZXH),
			ZKN_SOUNDSUB_BUTTON_LOOP_X + (ZKN_SOUNDSUB_BUTTON_LOOP_SIZXH) );

	p_work->callcack.p_glb = p_glb;
	p_work->callcack.p_work = p_work;


	// {^}l[W쐬
	p_work->p_button_man = BMN_Create( 
			p_work->hit_tbl,
			ZKN_SOUNDSUB_BUTTON_NUM,
			ZknSoundSubButtonCallBack,
			&p_work->callcack,
			heap );

	// Đ{^p}l[W
	p_work->p_sub_button_man = BMN_Create( 
			p_work->p_sub_hit_tbl,
			ZKN_SOUNDSUB_BUTTON_SUB_NUM,
			ZknSoundSubStartButtonCallBack,
			&p_work->callcack,
			heap );
	
}

//----------------------------------------------------------------------------
/**
 *	@brief	{^쏈
 *
 *	@param	p_work	[N
 *	@param	p_glb	O[of[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubButtonMove( ZKN_SOUND_SUB_WORK* p_work, ZKN_SOUND_SUB_GLB* p_glb )
{
	int i;
	// {^Cxgi[
	for( i=0; i<ZKN_SOUNDSUB_BUTTON_SUB_NUM; i++ ){
		p_work->sub_button_event[ i ] = ZKN_SOUNDDUB_BUTTON_START_NOTOUCH;
	}
	
	BMN_Main( p_work->p_button_man );

	BMN_Main( p_work->p_sub_button_man );
}

//----------------------------------------------------------------------------
/**
 *	@brief	{^j
 *
 *	@param	p_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubButtonDelete( ZKN_SOUND_SUB_WORK* p_work )
{
	BMN_Delete( p_work->p_button_man );
	BMN_Delete( p_work->p_sub_button_man );

	// e[u[Nj
	sys_FreeMemoryEz( p_work->hit_tbl );
	p_work->hit_tbl = NULL;
	sys_FreeMemoryEz( p_work->p_sub_hit_tbl );
	p_work->p_sub_hit_tbl = NULL;
}

//----------------------------------------------------------------------------
/**
 *	@brief	{^R[obN֐
 *
 *	@param	button_no	{^io[
 *	@param	event		{^Cxg^Cv
 *	@param	p_work		[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubButtonCallBack( u32 button_no, u32 event, void* p_work )
{
	ZKN_SOUND_BUTTON_CALLBACK* p_work_data = p_work;
	ZKN_SOUND_SUB_GLB* p_glb = p_work_data->p_glb;
	ZKN_SOUND_SUB_WORK* p_subwork = p_work_data->p_work;

	switch( event ){
	case BMN_EVENT_TOUCH:
		ZknSoundSubButtonTouch( button_no, p_glb, p_subwork );
		break;

	case BMN_EVENT_HOLD:
		ZknSoundSubButtonHold( button_no, p_glb, p_subwork );
		break;

	case BMN_EVENT_RELEASE:	
		ZknSoundSubButtonRelease( button_no, p_glb, p_subwork );
		break;

	case BMN_EVENT_SLIDEOUT:
		ZknSoundSubButtonSlideOut( button_no, p_glb, p_subwork );
		break;
		
	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	Đ{^R[obN֐
 *
 *	@param	button_no	{^io[
 *	@param	event		{^Cxg^Cv
 *	@param	p_work		[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubStartButtonCallBack( u32 button_no, u32 event, void* p_work )
{
	ZKN_SOUND_BUTTON_CALLBACK* p_work_data = p_work;
	ZKN_SOUND_SUB_GLB* p_glb = p_work_data->p_glb;
	ZKN_SOUND_SUB_WORK* p_subwork = p_work_data->p_work;
	int monsno = ZKN_GLBDATA_PokeMonsNoGet( p_glb->p_glb );

	// {^Cxgݒ
	p_subwork->sub_button_event[ button_no ] = event;

	switch( event ){
	case BMN_EVENT_TOUCH:
		p_subwork->start_touch_on = FALSE;
		break;

	case BMN_EVENT_HOLD:
		if( p_subwork->start_touch_on == FALSE ){
			p_subwork->start_touch_on = TRUE;
			switch( button_no ){
			case ZKN_SOUNDSUB_BUTTON_SUB_STARTSTOP:
				// [v[h̎̏
				if( p_subwork->loop == TRUE ){
					// Đ~ݒ
					if( p_subwork->sound_play == FALSE ){
						ZknSoundSubSoundStart( p_subwork, p_glb, monsno );
					}else{
						// ~
						ZknSoundSubSoundStop( p_subwork );
					}
				}else{
					// ȂĂƂ߂
					if( p_subwork->sound_play == TRUE ){
						Snd_PMVoiceStop(0);
					}	
					
					ZknSoundSubSoundStart( p_subwork, p_glb, monsno );
				}
				break;

			// [v{^
			case ZKN_SOUNDSUB_BUTTON_SUB_LOOP:
				ZknSoundSubSoundLoopSet( p_subwork, p_subwork->loop ^ 1 );
				// {^Ƀ^b`
				Snd_SePlay( ZKN_SND_BUTTON );
				break;

			default:
				break;
			}
		}
		break;

	case BMN_EVENT_RELEASE:	
		break;

	case BMN_EVENT_SLIDEOUT:
		break;
		
	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	{^^b`֐
 *
 *	@param	button_no		{^io[
 *	@param	p_glb			O[of[^
 *	@param	p_work			[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubButtonTouch( u32 button_no, ZKN_SOUND_SUB_GLB* p_glb, ZKN_SOUND_SUB_WORK* p_work )
{

	switch( button_no ){
	case ZKN_SOUNDSUB_BUTTON_SWITCH:
		// Đ͕ύXłȂ̂Œ~
		if( p_work->sound_play == TRUE ){
			ZknSoundSubSoundStop( p_work );
		}

		// TvOJnW擾
		p_work->pitch_switch_touch_start_x = sys.tp_x;
		p_work->pitch_switch_touch = TRUE;
		
		break;
		
	case ZKN_SOUNDSUB_BUTTON_DIAL:
		// Đ͕ύXłȂ̂Œ~
		if( p_work->sound_play == TRUE ){
			ZknSoundSubSoundStop( p_work );
		}

		// TvOJnW擾
		p_work->dial_touch = TRUE;
		p_work->dial_start_x = sys.tp_x;
		p_work->dial_start_y = sys.tp_y;
		
		break;
		
	case ZKN_SOUNDSUB_BUTTON_DISK:

		// Đ`FbN
		if( p_work->sound_play ){

			// Đ{^[vɃqbgĂ邩`FbN
			p_work->hit_start_stop_flag = GF_TP_SingleHitCont( &p_work->p_sub_hit_tbl[ZKN_SOUNDSUB_BUTTON_SUB_STARTSTOP] );
			p_work->hit_start_stop_flag |= GF_TP_SingleHitCont( &p_work->p_sub_hit_tbl[ZKN_SOUNDSUB_BUTTON_SUB_LOOP] );

		}else{

			// TRUEɂ邱Ƃɂ
			// fBXNʂ^b`̏
			// sȂ
			p_work->hit_start_stop_flag = TRUE;
		}

		break;

	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	{^Hold
 *
 *	@param	button_no
 *	@param	p_glb
 *	@param	p_work 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubButtonHold( u32 button_no, ZKN_SOUND_SUB_GLB* p_glb, ZKN_SOUND_SUB_WORK* p_work )
{
	int touch_move;

	switch( button_no ){
	case ZKN_SOUNDSUB_BUTTON_SWITCH:
		// ^b`tOĂƂ̂
		if( p_work->pitch_switch_touch == TRUE ){

			// TvOWvZ
			touch_move = sys.tp_x - p_work->pitch_switch_touch_start_x;

			// ̃XCb`Ԃ؂ւ邩`FbN
			if( p_work->pitch_switch_flag == ZKN_SOUNDSUB_SEQ_SWITCH_PICH ){
				// ؂ւ`FbN
				if( ZKN_SOUNDSUB_SWITCH_MOVE_OK_DIS <= touch_move ){
					p_work->pitch_switch_flag = ZKN_SOUNDSUB_SEQ_SWITCH_PAN;
					p_work->pitch_switch_touch_start_x = sys.tp_x;	// ^b`Jn܂ݒ

					// {^Ƀ^b`
					Snd_SePlay( ZKN_SND_SWITCH );
				}
			}else{

				// ؂ւ`FbN
				if( -ZKN_SOUNDSUB_SWITCH_MOVE_OK_DIS >= touch_move ){
					p_work->pitch_switch_flag = ZKN_SOUNDSUB_SEQ_SWITCH_PICH;
					p_work->pitch_switch_touch_start_x = sys.tp_x;	// ^b`Jn܂ݒ

					// {^Ƀ^b`
					Snd_SePlay( ZKN_SND_SWITCH );
				}
			}
		}
		break;
		
	case ZKN_SOUNDSUB_BUTTON_DIAL:
		// Đ͕ύXłȂ
		if( p_work->dial_touch == TRUE ){

			// _CpxvZ
			ZknSoundSubDialCalc( p_work );

			// ݕʒuݒ
			ZknSoundSubDialDivSet( p_work );

			// ̒li[
			p_work->dial_start_x = sys.tp_x;
			p_work->dial_start_y = sys.tp_y;
		}
		break;
		
	case ZKN_SOUNDSUB_BUTTON_DISK:


		// Đ{^ɐGĂȂƂ
		if( p_work->hit_start_stop_flag == FALSE  ){

			// ĐŖȂsȂ悤ɂ
			if( p_work->sound_play == FALSE ){
				p_work->hit_start_stop_flag = TRUE;

				// ݒ蒆tO𗎂Ƃ
				ZknSoundSubPitchPanChorusOnOff( p_work, FALSE );
			}else{
			
				// Z^[ォŏ
				if( sys.tp_y < ZKN_SOUNDSUB_DISK_BG_CENTER_Y ){
					// sb`ORp̐ݒ
					if( p_work->pitch_switch_flag == ZKN_SOUNDSUB_SEQ_SWITCH_PICH ){
//						ZknSoundSubDiskPitchSet( p_work, sys.tp_x );
						ZknSoundSubDiskChorusSet( p_work, sys.tp_x );
					}else{
						ZknSoundSubDiskPanSet( p_work, sys.tp_x );
					}
					p_work->pitch_num = 0;	// sb`̒l͏
					// ݒ蒆tO𗧂Ă
					ZknSoundSubPitchPanChorusOnOff( p_work, TRUE );
				}else{

					// ݒ蒆tO𗎂Ƃ
					ZknSoundSubPitchPanChorusFlagOnOff( p_work, FALSE );

					// sb`̒lŒɂ
					p_work->pitch_num = SND_ZUKAN_PITCH_MIN;
				}
			}

			// sb`p̒lݒ
			ZknSoundSubPitchPanChorusSet( p_work );
		}
		break;

	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	{^Release
 *
 *	@param	button_no
 *	@param	p_glb
 *	@param	p_work 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubButtonRelease( u32 button_no, ZKN_SOUND_SUB_GLB* p_glb, ZKN_SOUND_SUB_WORK* p_work )
{
		
	switch( button_no ){
	case ZKN_SOUNDSUB_BUTTON_SWITCH:
		p_work->pitch_switch_touch = FALSE;
		break;
		
	case ZKN_SOUNDSUB_BUTTON_DIAL:
		p_work->dial_rota = p_work->dial_div * ZKN_SOUNDSUB_DIAL_MIN_CUT_NUM;
		
		p_work->dial_touch = FALSE;
		break;
		
	case ZKN_SOUNDSUB_BUTTON_DISK:
		// Đ{^ɐGĂȂƂ
		if( p_work->hit_start_stop_flag == FALSE  ){

			// ݒ蒆tO𗎂Ƃ
			ZknSoundSubPitchPanChorusOnOff( p_work, FALSE );
			
			// sb`p̒lݒ
			ZknSoundSubPitchPanChorusSet( p_work );
		}
		break;

	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	{^XChAEg
 *
 *	@param	button_no
 *	@param	p_glb
 *	@param	p_work 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubButtonSlideOut( u32 button_no, ZKN_SOUND_SUB_GLB* p_glb, ZKN_SOUND_SUB_WORK* p_work )
{
	switch( button_no ){
	case ZKN_SOUNDSUB_BUTTON_SWITCH:
		p_work->pitch_switch_touch = FALSE;
		break;
		
	case ZKN_SOUNDSUB_BUTTON_DIAL:
		p_work->dial_rota = p_work->dial_div * ZKN_SOUNDSUB_DIAL_MIN_CUT_NUM;
		p_work->dial_touch = FALSE;
		break;
		
	case ZKN_SOUNDSUB_BUTTON_DISK:
		// Đ{^ɐGĂȂƂ
		if( p_work->hit_start_stop_flag == FALSE  ){

			// ݒ蒆tO𗎂Ƃ
			ZknSoundSubPitchPanChorusOnOff( p_work, FALSE );
			
			// sb`p̒lݒ
			ZknSoundSubPitchPanChorusSet( p_work );
		}
		break;

	default:
		break;
	}
}




//----------------------------------------------------------------------------
/**
 *	@brief	OtBbN
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubLoadResource( ZKN_SOUND_SUB_DRAW* p_draw, ZKN_SOUND_SUB_DRAWGLB* p_drawglb, int heap )
{
	// wi
	ZknSoundSubSetUpBg( p_drawglb, heap );

	// OAM
	ZknSoundSubLoadOamData( p_draw, p_drawglb, heap );

	// ZAN^[o^
	ZknSoundSubAddClact( p_draw, p_drawglb, heap );

	// FONTOAMo^
	ZknSoundSubAddFontOam( p_draw, p_drawglb, heap );

	// Ajppbgǂݍ
	ZknSoundSubPlttLoad( p_draw, p_drawglb, heap );

}

//----------------------------------------------------------------------------
/**
 *	@brief	OtBbNj
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubReleaseResource( ZKN_SOUND_SUB_DRAW* p_draw, ZKN_SOUND_SUB_DRAWGLB* p_drawglb, int heap )
{
	int i;
	
	// ZAN^[j
	ZknSoundSubDeleteClact( p_draw );

	// FONTOAMj
	ZknSoundSubDeleteFontOam( p_draw, p_drawglb );

	// OAM
	ZknSoundSubReleaseOamData( p_draw, p_drawglb );

	// wi
	ZknSoundSubPutDownBg( p_drawglb );

	// Ajppbgj
	ZknSoundSubPlttRelease( p_draw );
}

//----------------------------------------------------------------------------
/**
 *	@brief	BGʃZbgAbv
 *
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubSetUpBg( ZKN_SOUND_SUB_DRAWGLB* p_drawglb, int heap )
{
	void* buff;
	NNSG2dScreenData* p_scrn;

	// LN^f[^]
	ZKN_GLBDATA_BgCharSet( p_drawglb->p_drawglb, NARC_zukan_zkn_data_sub_lzh_NCGR, p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_BACK_S, 0, 0, TRUE, heap );

	// XN[f[^ǂݍ
	buff = ZKN_GLBDATA_ScrnDataGet( p_drawglb->p_drawglb, NARC_zukan_zkn_voice_bg_sub1_lzh_NSCR, TRUE, &p_scrn, heap );
	
	// XN[f[^
	GF_BGL_ScrWrite( p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_BACK_S,
			p_scrn->rawData, 0, 0,
			p_scrn->screenWidth / 8, p_scrn->screenHeight / 8 );

	sys_FreeMemoryEz( buff );

	// XN[f[^]
	GF_BGL_LoadScreenV_Req(p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_BACK_S );


	// fBXN
	// LN^f[^]
	ZKN_GLBDATA_BgCharSet( p_drawglb->p_drawglb, NARC_zukan_zkn_voice_disk_lzh_NCGR, p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_AFFINE_S, 0, 0, TRUE, heap );

	// XN[f[^ǂݍ
	buff = ZKN_GLBDATA_ScrnDataGet( p_drawglb->p_drawglb, NARC_zukan_zkn_voice_disk_lzh_NSCR, TRUE, &p_scrn, heap );
	
	// XN[f[^
	GF_BGL_ScrWrite( p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_AFFINE_S,
			p_scrn->rawData, 0, 0,
			p_scrn->screenWidth / 8, p_scrn->screenHeight / 8 );

	sys_FreeMemoryEz( buff );

	// XN[f[^]
	GF_BGL_LoadScreenV_Req(p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_AFFINE_S );

	// fBXNWBGD揇ʐݒ
	GF_BGL_ScrollSet( p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_AFFINE_S, GF_BGL_SCROLL_X_SET, ZKN_SOUNDSUB_DISK_BG_X );
	GF_BGL_ScrollSet( p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_AFFINE_S, GF_BGL_SCROLL_Y_SET, ZKN_SOUNDSUB_DISK_BG_Y );
	GF_BGL_PrioritySet( ZKN_BG_FRM_AFFINE_S, 3 );
}

//----------------------------------------------------------------------------
/**
 *	@brief	BGʍŏI
 *
 *	@param	p_drawglb 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubPutDownBg( ZKN_SOUND_SUB_DRAWGLB* p_drawglb )
{
	// XN[
	GF_BGL_ScrClear( p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_BACK_S );
	GF_BGL_ScrClear( p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_AFFINE_S );

	GF_BGL_PrioritySet( ZKN_BG_FRM_AFFINE_S, 1 );
}

//----------------------------------------------------------------------------
/**
 *	@brief	OAM\[Xǂݍ
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubLoadOamData( ZKN_SOUND_SUB_DRAW* p_draw, ZKN_SOUND_SUB_DRAWGLB* p_drawglb, int heap )
{
	ZKN_GLB_DRAWDATA* p_draw_glb = p_drawglb->p_drawglb;
	ARCHANDLE* p_handle = ZKN_GLBDATA_ArcHandlGet( p_drawglb->p_drawglb );
	
	// LN^f[^ǂݍ
	p_draw->res_obj[ CLACT_U_CHAR_RES ] = CLACT_U_ResManagerResAddArcChar_ArcHandle( 
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ], p_handle,
			NARC_zukan_zkn_voice_oam_sub_lzh_NCGR, TRUE,
			NARC_zukan_zkn_voice_oam_sub_lzh_NCGR + ZKN_SOUND_SUB_RES_ID,
			NNS_G2D_VRAM_TYPE_2DSUB, heap );
	// ]
	CLACT_U_CharManagerSetAreaCont( p_draw->res_obj[ CLACT_U_CHAR_RES ] );
	// OtBbNf[^j
	CLACT_U_ResManagerResOnlyDelete( p_draw->res_obj[ CLACT_U_CHAR_RES ] );

	// pbgf[^ǂݍ
	p_draw->res_obj[ CLACT_U_PLTT_RES ] = CLACT_U_ResManagerResAddArcPltt_ArcHandle( 
			p_draw_glb->res_manager[ CLACT_U_PLTT_RES ], p_handle,
			NARC_zukan_zkn_voice_oam_sub_NCLR, FALSE, 
			NARC_zukan_zkn_voice_oam_sub_NCLR + ZKN_SOUND_SUB_RES_ID, 
			NNS_G2D_VRAM_TYPE_2DSUB, 
			ZKN_SOUNDSUB_PLTT_LOAD, heap );
	// ]
	CLACT_U_PlttManagerSetCleanArea( p_draw->res_obj[ CLACT_U_PLTT_RES ] );	
	// OtBbNf[^j
	CLACT_U_ResManagerResOnlyDelete( p_draw->res_obj[ CLACT_U_PLTT_RES ] );


	// Zf[^ǂݍ
	p_draw->res_obj[ CLACT_U_CELL_RES ] = CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ], p_handle,
			NARC_zukan_zkn_voice_oam_sub_lzh_NCER, TRUE,
			NARC_zukan_zkn_voice_oam_sub_lzh_NCER + ZKN_SOUND_SUB_RES_ID,
			CLACT_U_CELL_RES, heap );

	// ZAjf[^ǂݍ
	p_draw->res_obj[ CLACT_U_CELLANM_RES ] = CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ], p_handle, 
			NARC_zukan_zkn_voice_oam_sub_lzh_NANR, TRUE,
			NARC_zukan_zkn_voice_oam_sub_lzh_NANR + ZKN_SOUND_SUB_RES_ID,
			CLACT_U_CELLANM_RES, heap );
}

//----------------------------------------------------------------------------
/**
 *	@brief	OAM\[Xj
 *
 *	@param	p_draw			`惏[N
 *	@param	p_drawglb		`O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubReleaseOamData( ZKN_SOUND_SUB_DRAW* p_draw, ZKN_SOUND_SUB_DRAWGLB* p_drawglb )
{
	ZKN_GLB_DRAWDATA* p_draw_glb = p_drawglb->p_drawglb;


	CLACT_U_CharManagerDelete( p_draw->res_obj[ CLACT_U_CHAR_RES ] );
	CLACT_U_PlttManagerDelete( p_draw->res_obj[ CLACT_U_PLTT_RES ] );

	// \[Xj
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ],
			p_draw->res_obj[ CLACT_U_CHAR_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_PLTT_RES ],
			p_draw->res_obj[ CLACT_U_PLTT_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ],
			p_draw->res_obj[ CLACT_U_CELL_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ],
			p_draw->res_obj[ CLACT_U_CELLANM_RES ] );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ZAN^[o^
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubAddClact( ZKN_SOUND_SUB_DRAW* p_draw, ZKN_SOUND_SUB_DRAWGLB* p_drawglb, int heap )
{
	CLACT_HEADER		clact_head;
	CLACT_ADD_SIMPLE	add;
	ZKN_GLB_DRAWDATA*	p_draw_glb = p_drawglb->p_drawglb;
	int i;
	int x, y;
	
	// AN^[wb_[쐬
	CLACT_U_MakeHeader( &clact_head,
			NARC_zukan_zkn_voice_oam_sub_lzh_NCGR + ZKN_SOUND_SUB_RES_ID,
			NARC_zukan_zkn_voice_oam_sub_NCLR + ZKN_SOUND_SUB_RES_ID, 
			NARC_zukan_zkn_voice_oam_sub_lzh_NCER + ZKN_SOUND_SUB_RES_ID,
			NARC_zukan_zkn_voice_oam_sub_lzh_NANR + ZKN_SOUND_SUB_RES_ID,
			CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE, 0, ZKN_SOUND_SUB_OAM_BG_PTR,
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ],
			p_draw_glb->res_manager[ CLACT_U_PLTT_RES ],
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ],
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ],
			NULL, NULL );

	// o^ʕݒ
	add.ClActSet	= p_draw_glb->clact_set;
	add.ClActHeader = &clact_head;
	add.pri			= 31;
	add.DrawArea	= NNS_G2D_VRAM_TYPE_2DSUB;
	add.heap		= heap;
	
	// sb`switch
	add.mat.x = ZKN_SOUNDSUB_BUTTON_SWITCH_X << FX32_SHIFT;
	add.mat.y = ZKN_SOUNDSUB_BUTTON_SWITCH_Y << FX32_SHIFT;
	add.mat.y += SUB_SURFACE_Y;
	p_draw->pich_switch = CLACT_AddSimple( &add );
	CLACT_AnmChg( p_draw->pich_switch, ZKN_SOUNDSUB_SEQ_SWITCH_PAN_PICH );	
	CLACT_SetAnmFlag( p_draw->pich_switch, TRUE );
	CLACT_SetAnmFrame( p_draw->pich_switch, ZKN_SOUNDSUB_ANIME_FRAME );
	CLACT_AnmFrameSet( p_draw->pich_switch,ZKN_SOUNDSUB_SWITCH_08 );

	// _C
	add.mat.x = ZKN_SOUNDSUB_BUTTON_DIAL_X << FX32_SHIFT;
	add.mat.y = ZKN_SOUNDSUB_BUTTON_DIAL_Y << FX32_SHIFT;
	add.mat.y += SUB_SURFACE_Y;
	p_draw->dial = CLACT_AddSimple( &add );
	CLACT_AnmChg( p_draw->dial, ZKN_SOUNDSUB_SEQ_DIAL );	
	CLACT_SetAffineParam( p_draw->dial, CLACT_AFFINE_NORMAL );

	// Jn~
	add.mat.x = ZKN_SOUNDSUB_BUTTON_STARTSTOP_X_DRAW << FX32_SHIFT;
	add.mat.y = ZKN_SOUNDSUB_BUTTON_STARTSTOP_Y_DRAW << FX32_SHIFT;
	add.mat.y += SUB_SURFACE_Y;
	p_draw->startstop = CLACT_AddSimple( &add );
	CLACT_AnmChg( p_draw->startstop, ZKN_SOUNDSUB_SEQ_SOUND_START_ANM );	
	CLACT_SetAnmFlag( p_draw->startstop, TRUE );
	CLACT_SetAnmFrame( p_draw->startstop, ZKN_SOUNDSUB_ANIME_FRAME );
	CLACT_AnmFrameSet(p_draw->startstop, ZKN_SOUNDSUB_START_05 );
	// Ajf[^ݒ
	p_draw->start_stop_anim.anm_seq1 = ZKN_SOUNDSUB_SEQ_SOUND_START_ANM; 
	p_draw->start_stop_anim.anm_seq2 = ZKN_SOUNDSUB_SEQ_SOUND_STOP_ANM; 
	p_draw->start_stop_anim.now_anm_seq = ZKN_SOUNDSUB_SEQ_SOUND_START_ANM;
	p_draw->start_stop_anim.anm_num_max = ZKN_SOUNDSUB_START_05;
	p_draw->start_stop_anim.push_anm_limit = ZKN_SOUNDSUB_START_02;


	// [v
	add.mat.x = ZKN_SOUNDSUB_BUTTON_LOOP_X_DRAW << FX32_SHIFT;
	add.mat.y = ZKN_SOUNDSUB_BUTTON_LOOP_Y_DRAW << FX32_SHIFT;
	add.mat.y += SUB_SURFACE_Y;
	p_draw->loop = CLACT_AddSimple( &add );
	CLACT_AnmChg( p_draw->loop, ZKN_SOUNDSUB_SEQ_SOUND_LOOPOFF_ANM );	
	CLACT_SetAnmFlag( p_draw->loop, TRUE );
	CLACT_SetAnmFrame( p_draw->loop, ZKN_SOUNDSUB_ANIME_FRAME );
	CLACT_AnmFrameSet(p_draw->loop, ZKN_SOUNDSUB_LOOP_05 );
	// Ajf[^ݒ
	p_draw->loop_anim.anm_seq1 = ZKN_SOUNDSUB_SEQ_SOUND_LOOPOFF_ANM; 
	p_draw->loop_anim.anm_seq2 = ZKN_SOUNDSUB_SEQ_SOUND_LOOPON_ANM; 
	p_draw->loop_anim.now_anm_seq = ZKN_SOUNDSUB_SEQ_SOUND_LOOPOFF_ANM;
	p_draw->loop_anim.anm_num_max = ZKN_SOUNDSUB_LOOP_05;
	p_draw->loop_anim.push_anm_limit = ZKN_SOUNDSUB_LOOP_02;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ZAN^[j
 *
 *	@param	p_draw	`惏[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubDeleteClact( ZKN_SOUND_SUB_DRAW* p_draw )
{
	CLACT_Delete( p_draw->dial );
	CLACT_Delete( p_draw->pich_switch );
	CLACT_Delete( p_draw->startstop );
	CLACT_Delete( p_draw->loop );
}


//----------------------------------------------------------------------------
/**
 *	@brief	tHgOAM쐬
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubAddFontOam( ZKN_SOUND_SUB_DRAW* p_draw, ZKN_SOUND_SUB_DRAWGLB* p_drawglb, int heap )
{
	GF_BGL_BMPWIN* win;	// 񏑂ݐ
	ZKN_FONTOAM_INIT fontoam_init;
	CLACT_U_RES_OBJ_PTR res_obj;
	ZKN_GLB_DRAWDATA* p_glb_draw = p_drawglb->p_drawglb;
	int pltt_ofs;	// pbgAhX

	// pbg̃\[Xf[^擾
	// pbgvNV擾p
	res_obj = CLACT_U_ResManagerGetIDResObjPtr( p_glb_draw->res_manager[ CLACT_U_PLTT_RES ], NARC_zukan_zkn_voice_oam_sub_NCLR + ZKN_SOUND_SUB_RES_ID );

	// f[^̋ʕ쐬
	// ʃf[^
	fontoam_init.zkn_fontoam = p_glb_draw->fontoam_sys;
	fontoam_init.pltt		 = CLACT_U_PlttManagerGetProxy( res_obj, NULL );
	fontoam_init.parent		 = NULL;
	fontoam_init.y			 = ZKN_SOUNDSUB_PITCH_PAN_FOTN_Y + 192;
	fontoam_init.bg_pri		 = ZKN_SOUND_SUB_OAM_BG_PTR;
	fontoam_init.soft_pri	 = 0;
	fontoam_init.draw_area	 = NNS_G2D_VRAM_TYPE_2DSUB;
	fontoam_init.heap		 = heap;

	// pbg]AhX擾
	pltt_ofs = GetPlttProxyOffset( fontoam_init.pltt, NNS_G2D_VRAM_TYPE_2DSUB );

	// rbg}bvEBhE쐬
	win = ZKN_FONTOAM_GetBmp( p_glb_draw->fontoam_sys, 
			ZKN_SOUNDSUB_BUTTONFONT_BMP_SIZE_CX,
			ZKN_SOUNDSUB_BUTTONFONT_BMP_SIZE_CY );


	// sb`
	fontoam_init.x			 = ZKN_SOUNDSUB_PITCH_FOTN_X;
	ZKN_FONTOAM_PrintBmpStr( p_glb_draw->fontoam_sys, win,
			NARC_msg_zkn_dat, ZNK_SOUND_BUTTON_00, 0, 0 );
	fontoam_init.p_bmp		 = win;
	p_draw->p_fontoam[ ZKN_SOUNDSUB_SEQ_SWITCH_PICH ] = ZKN_FONTOAM_Make( &fontoam_init );
	FONTOAM_SetPaletteNo( p_draw->p_fontoam[ ZKN_SOUNDSUB_SEQ_SWITCH_PICH ]->p_fontoam, pltt_ofs + ZKN_SOUNDSUB_BUTTON_PAL_OFS );

	// rbg}bvEBhEj
	ZKN_FONTOAM_DeleteBmp( win );


	// rbg}bvEBhE쐬
	win = ZKN_FONTOAM_GetBmp( p_glb_draw->fontoam_sys, 
			ZKN_SOUNDSUB_BUTTONFONT_BMP_SIZE_CX,
			ZKN_SOUNDSUB_BUTTONFONT_BMP_SIZE_CY );


	// p
	fontoam_init.x			 = ZKN_SOUNDSUB_PAN_FOTN_X;
	ZKN_FONTOAM_PrintBmpStr( p_glb_draw->fontoam_sys, win,
			NARC_msg_zkn_dat, ZNK_SOUND_BUTTON_01, 0, 0 );
	fontoam_init.p_bmp		 = win;
	p_draw->p_fontoam[ ZKN_SOUNDSUB_SEQ_SWITCH_PAN ] = ZKN_FONTOAM_Make( &fontoam_init );
	FONTOAM_SetPaletteNo( p_draw->p_fontoam[ ZKN_SOUNDSUB_SEQ_SWITCH_PAN ]->p_fontoam, pltt_ofs + ZKN_SOUNDSUB_BUTTON_PAL_OFS );

	// rbg}bvEBhEj
	ZKN_FONTOAM_DeleteBmp( win );

	// pW
	FONTOAM_SetDrawFlag( p_draw->p_fontoam[ ZKN_SOUNDSUB_SEQ_SWITCH_PAN ]->p_fontoam, FALSE );

}

//----------------------------------------------------------------------------
/**
 *	@brief	tHgOAMj
 *	
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubDeleteFontOam( ZKN_SOUND_SUB_DRAW* p_draw, ZKN_SOUND_SUB_DRAWGLB* p_drawglb )
{
	int i;
	for( i=0; i<ZKN_SOUNDSUB_SEQ_SWITCH_NUM; i++ ){
		ZKN_FONTOAM_Delete( p_draw->p_fontoam[ i ] );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	sb`p؂ւXCb`
 *
 *	@param	p_draw		`惏[N
 *	@param	cp_work		[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubSwitchDrawMove( ZKN_SOUND_SUB_DRAW* p_draw, const ZKN_SOUND_SUB_WORK* cp_work )
{
	int anm_frm;
	
	if( p_draw->now_switch != cp_work->pitch_switch_flag ){
		anm_frm = CLACT_AnmFrameGet( p_draw->pich_switch );
		
		// AjV[PXύX
		if( cp_work->pitch_switch_flag == ZKN_SOUNDSUB_SEQ_SWITCH_PICH ){
			CLACT_AnmChg( p_draw->pich_switch, ZKN_SOUNDSUB_SEQ_SWITCH_PAN_PICH );
			CLACT_AnmFrameSet( p_draw->pich_switch, ZKN_SOUNDSUB_SWITCH_08 - anm_frm );
		}else{
			CLACT_AnmChg( p_draw->pich_switch, ZKN_SOUNDSUB_SEQ_SWITCH_PICH_PAN );
			CLACT_AnmFrameSet( p_draw->pich_switch, ZKN_SOUNDSUB_SWITCH_08 - anm_frm );
		}

		p_draw->now_switch = cp_work->pitch_switch_flag;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	ĐXgbv`擮
 *
 *	@param	p_draw		`惏[N
 *	@param	cp_work		[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubStartStopDrawMove( ZKN_SOUND_SUB_DRAW* p_draw, const ZKN_SOUND_SUB_WORK* cp_work )
{
	int button_event = cp_work->sub_button_event[ZKN_SOUNDSUB_BUTTON_SUB_STARTSTOP];

	// [vĐŖƂ͒~{^ɂȂȂ
	if( cp_work->loop == FALSE ){

		ZknSoundSubButtonAnimeMain_NO_Loop( p_draw->startstop, &p_draw->start_stop_anim,
				FALSE, button_event );
	}else{

		ZknSoundSubButtonAnimeMain( p_draw->startstop, &p_draw->start_stop_anim,
				cp_work->sound_play, button_event );


	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	[v{^Aj
 *
 *	@param	p_draw		`惏[N
 *	@param	cp_work		[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubLoopDrawMove( ZKN_SOUND_SUB_DRAW* p_draw, const ZKN_SOUND_SUB_WORK* cp_work )
{
	int button_event = cp_work->sub_button_event[ZKN_SOUNDSUB_BUTTON_SUB_LOOP];

	ZknSoundSubButtonAnimeMain( p_draw->loop, &p_draw->loop_anim,
			cp_work->loop, button_event );
}


//----------------------------------------------------------------------------
/**
 *	@brief	_C
 *
 *	@param	p_work 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubDialCalc( ZKN_SOUND_SUB_WORK* p_work )
{
	int last_rota;
	int now_rota;
	int zettai;
	int last_y, last_x;
	int now_y, now_x;
	int rota_num;

	// zC[̒SW̒lɂ
	last_x = p_work->dial_start_x - ZKN_SOUNDSUB_BUTTON_DIAL_X;
	last_y = p_work->dial_start_y - ZKN_SOUNDSUB_BUTTON_DIAL_Y;
	now_x = sys.tp_x - ZKN_SOUNDSUB_BUTTON_DIAL_X;
	now_y = sys.tp_y - ZKN_SOUNDSUB_BUTTON_DIAL_Y;

	last_rota = FX_Atan2Idx( last_y, last_x );
	now_rota = FX_Atan2Idx( now_y, now_x );

	rota_num = now_rota - last_rota;

	// Βl߂
	if( rota_num < 0 ){
		zettai = -rota_num;
	}else{
		zettai = rota_num;
	}

	// 180ȏɂȂ邱Ƃ͍lɂ̏ꍇ,ORUOƂčl
	if( zettai >= FX_GET_ROTA_NUM(180) ){
		zettai = FX_GET_ROTA_NUM(360) - zettai;
		zettai = -zettai;		// 0->360ƂlɂȂ邩xNgςKv
	}

	// ݒ
	if( rota_num < 0 ){
		rota_num = -zettai;
	}else{
		rota_num = zettai;
	}

	// ~bgȉ̒lȂ甲
	if( MATH_IAbs( rota_num ) < ZKN_SOUNDSUB_DIAL_MOVE_LIMIT_ROTA ){
		return;
	}

	// 
	p_work->dial_rota += rota_num;


	// }CiXɂȂ
	if( p_work->dial_rota < 0 ){
		p_work->dial_rota += FX_GET_ROTA_NUM( 360 );
	}else{
		p_work->dial_rota %= FX_GET_ROTA_NUM( 360 );
	}

//	OS_Printf( "before rota %d\n", p_work->dial_rota / 182 );

	// ~bgpx܂łsȂ悤ɂ
	if( (p_work->dial_rota >= FX_GET_ROTA_NUM( ZKN_SOUNDSUB_DIAL_LIMIT_MIN )) &&
		(p_work->dial_rota <= FX_GET_ROTA_NUM( ZKN_SOUNDSUB_DIAL_LIMIT_MAX )) ){

		if( rota_num > 0 ){
			p_work->dial_rota = FX_GET_ROTA_NUM( ZKN_SOUNDSUB_DIAL_LIMIT_MIN );
		}else{
			p_work->dial_rota = FX_GET_ROTA_NUM( ZKN_SOUNDSUB_DIAL_LIMIT_MAX );
		}
	}

/*	// ŒpxɖȂƂ0ɂ
	if( (p_work->dial_rota <= ZKN_SOUNDSUB_DIAL_MIN_CUT_NUM) ||
		(p_work->dial_rota >= (FX_GET_ROTA_NUM(360) - ZKN_SOUNDSUB_DIAL_MIN_CUT_NUM)) ){

		p_work->dial_rota = 0;
	}//*/

//	OS_Printf( "after rota %d\n", p_work->dial_rota / 182 );
}

//----------------------------------------------------------------------------
/**
 *	@brief	_C̊px𕪊Ă錈߂ꂽpx̒lɐݒ
 *
 *	@param	p_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubDialDivSet( ZKN_SOUND_SUB_WORK* p_work )
{

	// px̔{ɂȂ特炷
	if( (p_work->dial_rota / ZKN_SOUNDSUB_DIAL_MIN_CUT_NUM) != p_work->dial_div ){
		// ̂ŉo
		Snd_SePlay( ZKN_SND_DIAL );

		p_work->dial_div= p_work->dial_rota / ZKN_SOUNDSUB_DIAL_MIN_CUT_NUM;
	}

}


//----------------------------------------------------------------------------
/**
 *	@brief	_CA]pxɂlݒ
 *
 *	@param	p_work 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubDialNumSet( ZKN_SOUND_SUB_WORK* p_work )
{
	int set_num;

	// 0ȂS~
	if( p_work->dial_rota == 0 ){
		ZknSoundSubReverbEffectStop( p_work );

		return ;
	}
	
	if( (p_work->dial_rota > FX_GET_ROTA_NUM(0)) &&
		(p_work->dial_rota <= FX_GET_ROTA_NUM(180)) ){
		// o[uݒ肳ĂƂ͂Ƃ߂
		if( p_work->dial_flag == ZKN_SOUNDSUB_DIAL_REVERB ){
			Snd_CaptureStopReverb(0);
		}

		// GtFNgJnĂȂƂ͊Jn
		if( p_work->dial_flag != ZKN_SOUNDSUB_DIAL_FILTER ){
			Snd_CaptureStartEffect();
			p_work->dial_flag = ZKN_SOUNDSUB_DIAL_FILTER;
		}


		// ݒlvZ
		set_num = p_work->dial_div * ZKN_SOUNDSUB_DIAL_FILTER_NUM;
		
		if( set_num == 0 ){
			set_num = 1;
		}

		// tB^[ݒ
		Snd_CaptureEffectLevel( set_num );

	}else{
		// tB^[ݒ肳Ă鎞͎~߂
		if( p_work->dial_flag == ZKN_SOUNDSUB_DIAL_FILTER ){
			Snd_CaptureStopEffect();
		}

		// o[uJnĂȂƂ͊Jn
		if( p_work->dial_flag != ZKN_SOUNDSUB_DIAL_REVERB ){
			Snd_CaptureStartReverb( 0 );
			p_work->dial_flag = ZKN_SOUNDSUB_DIAL_REVERB;
		}
		

		// 0Ȃ360ɂ
		if( p_work->dial_rota == 0 ){
			p_work->dial_rota = FX_GET_ROTA_NUM(ZKN_SOUNDSUB_DIAL_LIMIT);
		}
		
		// ݒlvZ
		set_num = p_work->dial_div * ZKN_SOUNDSUB_DIAL_NUM;

		// o[uݒ
		Snd_CaptureReverbVol( set_num, 0 );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	pxɂOAM̉]
 *
 *	@param	p_draw
 *	@param	cp_work 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZKnSoundSubDialDrawMove( ZKN_SOUND_SUB_DRAW* p_draw, const ZKN_SOUND_SUB_WORK* cp_work )
{
	CLACT_SetRotation( p_draw->dial, cp_work->dial_rota );
}


//----------------------------------------------------------------------------
/**
 *	@brief	`bNɂăfBXN
 *
 *	@param	p_draw	
 *	@param	cp_work 
 *	@param	p_drawglb
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubDiskDrawMove( ZKN_SOUND_SUB_DRAW* p_draw, ZKN_SOUND_SUB_DRAWGLB* p_drawglb, const ZKN_SOUND_SUB_WORK* cp_work )
{
	int now_tick = Snd_ZukanPlayerGetSampleTick( SND_HANDLE_PMVOICE, cp_work->cp_snd_data, cp_work->pitch_num );

	// now_tick0烋[v̂last0ɂ
	if( now_tick == 0 ){
		p_draw->disk_last_tick = 0;
	}

	// `bN̕ωʕ]
	p_draw->disk_rota += (now_tick - p_draw->disk_last_tick) * ZKN_SOUNDSUB_DISK_BG_ROTA_MUL;
	p_draw->disk_rota &= 0xffff;

	// ]px̐ݒ
	GF_BGL_RadianSetReq( p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_AFFINE_S, GF_BGL_RADION_SET, p_draw->disk_rota / 182 );
	GF_BGL_RotateCenterSetReq( p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_AFFINE_S, GF_BGL_CENTER_X_SET, ZKN_SOUNDSUB_DISK_BG_BGCX );
	GF_BGL_RotateCenterSetReq( p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_AFFINE_S, GF_BGL_CENTER_Y_SET, ZKN_SOUNDSUB_DISK_BG_BGCY );

	p_draw->disk_last_tick = now_tick;
}


//----------------------------------------------------------------------------
/**
 *	@brief	sb`ݒ
 *
 *	@param	x	W
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubDiskPitchSet( ZKN_SOUND_SUB_WORK* p_work, int x )
{
	int dis_x;
	fx32 calc;
	int set_num;
	
	// XWsb`ݒ
	dis_x = x - ZKN_SOUNDSUB_DISK_BG_CENTER_X;

	calc = FX_Mul( ZKN_SOUNDSUB_DISK_PITCK_MAX << FX32_SHIFT, dis_x << FX32_SHIFT );
	calc = FX_Div( calc, ZKN_SOUNDSUB_DISK_BG_R << FX32_SHIFT );
	
	set_num = calc >> FX32_SHIFT;

	// ݒ
	p_work->pitch_num = set_num;
}

//----------------------------------------------------------------------------
/**
 *	@brief	R[X{[ݒ
 *
 *	@param	p_work	[N
 *	@param	x		XW
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubDiskChorusSet( ZKN_SOUND_SUB_WORK* p_work, int x )
{
	int dis_x;
	fx32 calc;
	int set_num;
	
	// XWsb`ݒ
	dis_x = x - (ZKN_SOUNDSUB_DISK_BG_CENTER_X - ZKN_SOUNDSUB_DISK_BG_R);	// ̋ɂ

	calc = FX_Mul( ZKN_SOUNDSUB_DISK_CHORUS_MAX << FX32_SHIFT, dis_x << FX32_SHIFT );
	calc = FX_Div( calc, (ZKN_SOUNDSUB_DISK_BG_R*2) << FX32_SHIFT );
	
	set_num = calc >> FX32_SHIFT;

	// ݒ
	p_work->chorus_num = set_num;
}

//----------------------------------------------------------------------------
/**
 *	@brief	pݒ
 *
 *	@param	x	W
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubDiskPanSet( ZKN_SOUND_SUB_WORK* p_work, int x )
{
	int dis_x;
	fx32 calc;
	int set_num;
	
	// XWpݒ
	dis_x = x - ZKN_SOUNDSUB_DISK_BG_CENTER_X;

	calc = FX_Mul( ZKN_SOUNDSUB_DISK_PAN_MAX << FX32_SHIFT, dis_x << FX32_SHIFT );
	calc = FX_Div( calc, ZKN_SOUNDSUB_DISK_BG_R << FX32_SHIFT );
	
	set_num = calc >> FX32_SHIFT;

	// ݒ
	p_work->pan_num = set_num;
}

//----------------------------------------------------------------------------
/**
 *	@brief	sb`p\ݒ
 *
 *	@param	p_draw 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubPitchPanFontDraw( ZKN_SOUND_SUB_DRAW* p_draw )
{
	if( p_draw->now_switch == ZKN_SOUNDSUB_SEQ_SWITCH_PICH ){
		FONTOAM_SetDrawFlag( p_draw->p_fontoam[ ZKN_SOUNDSUB_SEQ_SWITCH_PICH ]->p_fontoam, TRUE );
		FONTOAM_SetDrawFlag( p_draw->p_fontoam[ ZKN_SOUNDSUB_SEQ_SWITCH_PAN ]->p_fontoam, FALSE );
	}else{
		FONTOAM_SetDrawFlag( p_draw->p_fontoam[ ZKN_SOUNDSUB_SEQ_SWITCH_PICH ]->p_fontoam, FALSE );
		FONTOAM_SetDrawFlag( p_draw->p_fontoam[ ZKN_SOUNDSUB_SEQ_SWITCH_PAN ]->p_fontoam, TRUE );
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	{^Aj
 *
 *	@param	act			AN^[
 *	@param	p_anmdata	Ajf[^
 *	@param	next_flg	̃tO
 *	@param	button_event@{^Cxg
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubButtonAnimeMain( CLACT_WORK_PTR act, ZKN_SOUND_SUB_ANM_BUTTON* p_anmdata, BOOL next_flg, int button_event )
{
	int anm_frm;

	// XChAEg邱Ƃ͂Ȃ
	if( button_event == BMN_EVENT_SLIDEOUT ){
		button_event = BMN_EVENT_RELEASE;
	}

	anm_frm = CLACT_AnmFrameGet( act );
	
	// XCb`ςAjI[gōs
	if( p_anmdata->flag != next_flg ){
		
		// AjV[PXύX
		ZknSoundSubButtonAnimeSeqSet( act, p_anmdata,  next_flg );

		p_anmdata->flag = next_flg;
	}


	// {^CxgƂ̓{^ڰтRg[
	switch( button_event ){
	case BMN_EVENT_TOUCH:		///< Gꂽu
		break;
		
	case BMN_EVENT_HOLD:		///< GÂĂ
		// push_anm_limit܂ŃAji߂
		if( anm_frm > p_anmdata->push_anm_limit ){
			CLACT_AnmFrameSet( act, p_anmdata->push_anm_limit );
			CLACT_SetAnmFrame( act, 0 );
		}
		break;

	case BMN_EVENT_RELEASE:
		CLACT_SetAnmFrame( act, ZKN_SOUNDSUB_ANIME_FRAME );
		break;
		
	case ZKN_SOUNDDUB_BUTTON_START_NOTOUCH:
		break;

	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	{^Aj		[vȂƂ悤
 *
 *	@param	act			AN^[
 *	@param	p_anmdata	Ajf[^
 *	@param	next_flg	̃tO
 *	@param	button_event@{^Cxg
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubButtonAnimeMain_NO_Loop( CLACT_WORK_PTR act, ZKN_SOUND_SUB_ANM_BUTTON* p_anmdata, BOOL next_flg, int button_event )
{
	int anm_frm;

	// XChAEgI邱Ƃ͂Ȃ
	if( button_event == BMN_EVENT_RELEASE ){
		button_event = BMN_EVENT_SLIDEOUT;
	}

	anm_frm = CLACT_AnmFrameGet( act );
	
	// XCb`ςAjI[gōs
	if( p_anmdata->flag != next_flg ){
		
		// AjV[PXύX
		ZknSoundSubButtonAnimeSeqSet( act, p_anmdata,  next_flg );

		p_anmdata->flag = next_flg;
	}


	// {^CxgƂ̓{^ڰтRg[
	switch( button_event ){
	case BMN_EVENT_TOUCH:		///< Gꂽu
		// AjV[PXݒ
		if( next_flg == TRUE ){
			ZknSoundSubButtonAnimeSeqSet( act, p_anmdata,  FALSE );
		}else{
			ZknSoundSubButtonAnimeSeqSet( act, p_anmdata,  TRUE );
		}
		CLACT_AnmFrameSet( act, p_anmdata->push_anm_limit - 1 );
		break;
		
	case BMN_EVENT_HOLD:		///< GÂĂ
		CLACT_AnmFrameSet( act, p_anmdata->push_anm_limit );
		CLACT_SetAnmFrame( act, 0 );
		break;

	case BMN_EVENT_SLIDEOUT:		///< ʃ^b`܂܃{^̈悩Oꂽu
		// AjV[PXݒ
		ZknSoundSubButtonAnimeSeqSet( act, p_anmdata,  next_flg );
		CLACT_SetAnmFrame( act, ZKN_SOUNDSUB_ANIME_FRAME );
		break;//*/

	case ZKN_SOUNDDUB_BUTTON_START_NOTOUCH:
		break;

	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	AjV[PXύX
 *
 *	@param	act			AN^[
 *	@param	p_anmdata	Ajf[^
 *	@param	flg			tO
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubButtonAnimeSeqSet( CLACT_WORK_PTR act, ZKN_SOUND_SUB_ANM_BUTTON* p_anmdata, BOOL flg )
{
	int anm_frm;

	anm_frm = CLACT_AnmFrameGet( act );

	// AjV[PXύX
	if( flg == TRUE ){
		// ~
		if( p_anmdata->now_anm_seq == p_anmdata->anm_seq1 ){
			CLACT_AnmChg( act, p_anmdata->anm_seq2 );
			p_anmdata->now_anm_seq = p_anmdata->anm_seq2;
			CLACT_AnmFrameSet( act, p_anmdata->anm_num_max - anm_frm );
		}
	}else{

		// Đ
		if( p_anmdata->now_anm_seq == p_anmdata->anm_seq2 ){
			CLACT_AnmChg( act, p_anmdata->anm_seq1 );
			p_anmdata->now_anm_seq = p_anmdata->anm_seq1;
			CLACT_AnmFrameSet( act, p_anmdata->anm_num_max - anm_frm );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	Đ
 *
 *	@param	p_work
 *	@param	monno
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubSoundStart( ZKN_SOUND_SUB_WORK* p_work, ZKN_SOUND_SUB_GLB* p_glb, int monsno )
{
	p_work->sound_play = TRUE;

	Snd_PMVoicePlay( monsno );

	// o[utB^[ݒɂlݒ
	ZknSoundSubDialNumSet( p_work );

	// sb`p̒lݒ
	ZknSoundSubPitchPanChorusSet( p_work );

	// R[XĐ
	ZknSoundSubChorusStart( p_glb );
}

//----------------------------------------------------------------------------
/**
 *	@brief	~ɍs
 *
 *	@param	p_work 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubSoundStop( ZKN_SOUND_SUB_WORK* p_work )
{
	Snd_PMVoiceStop(0);

	p_work->sound_play = FALSE;

	// o[utB^[~߂
	ZknSoundSubReverbEffectStop( p_work );
}

//----------------------------------------------------------------------------
/**
 *	@brief	o[utB^[~߂
 *
 *	@param	p_work 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubReverbEffectStop( ZKN_SOUND_SUB_WORK* p_work )
{
	// tB^[o[u̐ݒ~߂
	if( p_work->dial_flag == ZKN_SOUNDSUB_DIAL_REVERB ){
		Snd_CaptureStopReverb(0);
	}
	// tB^[ݒ肳Ă鎞͎~߂
	if( p_work->dial_flag == ZKN_SOUNDSUB_DIAL_FILTER ){
		Snd_CaptureStopEffect();
	}

	p_work->dial_flag = ZKN_SOUNDSUB_DIAL_NONE;
}


//----------------------------------------------------------------------------
/**
 *	@brief	[vĐ
 ;*
 *	@param	p_work
 *	@param	p_glb 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubSoundLoop(  ZKN_SOUND_SUB_WORK* p_work, ZKN_SOUND_SUB_GLB* p_glb )
{
	int monsno = ZKN_GLBDATA_PokeMonsNoGet( p_glb->p_glb );

	// Ƃ܂Đ
	if( Snd_PMVoicePlayCheck() == FALSE ){

		p_work->loop_wait--;
		if( p_work->loop_wait == 0 ){
			ZknSoundSubSoundStart( p_work, p_glb, monsno );
			p_work->loop_wait = ZKN_SOUNDSUB_DIAL_LOOP_WAIT;
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	[vĐݒ
 *
 *	@param	p_work	[Nk
 *	@param	flag	TRUE@[v@FALSE@ʂɖ߂
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubSoundLoopSet( ZKN_SOUND_SUB_WORK* p_work, BOOL flag )
{
	p_work->loop = flag;
	p_work->loop_wait = ZKN_SOUNDSUB_DIAL_LOOP_WAIT;
}

//----------------------------------------------------------------------------
/**
 *	@brief	pbgǂݍ
 *
 *	@param	p_draw	`惏[N
 *	@param	heap	q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubPlttLoad( ZKN_SOUND_SUB_DRAW* p_draw, ZKN_SOUND_SUB_DRAWGLB* p_drawglb, int heap )
{
	p_draw->p_pltt_buff = ZKN_GLBDATA_PalDataGet( p_drawglb->p_drawglb, NARC_zukan_zkn_data_voice_NCLR, &p_draw->p_plt, heap );
}

//----------------------------------------------------------------------------
/**
 *	@brief	pbgj
 *
 *	@param	p_draw	`惏[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubPlttRelease( ZKN_SOUND_SUB_DRAW* p_draw )
{
	sys_FreeMemoryEz( p_draw->p_pltt_buff );
	p_draw->p_pltt_buff = NULL;
	p_draw->p_plt = NULL;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ONpbgݒ
 *
 *	@param	p_draw	`惏[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubPlttOn( ZKN_SOUND_SUB_DRAW* p_draw )
{
	AddVramTransferManager(
			NNS_GFD_DST_2D_BG_PLTT_SUB,
			ZKN_SOUNDSUB_DISK_PITCH_PAN_PL * 32,
			p_draw->p_plt->pRawData,
			32 );
}

//----------------------------------------------------------------------------
/**
 *	@brief	OFFpbgݒ
 *
 *	@param	p_draw	`惏[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubPlttOff( ZKN_SOUND_SUB_DRAW* p_draw )
{
	AddVramTransferManager(
			NNS_GFD_DST_2D_BG_PLTT_SUB,
			ZKN_SOUNDSUB_DISK_PITCH_PAN_PL * 32,
			&((u8*)(p_draw->p_plt->pRawData))[32],
			32 );
}


//----------------------------------------------------------------------------
/**
 *	@brief	sb`p̃IIt
 *
 *	@param	p_work	[N
 *	@param	flag	tO@TRUE@ON@@FALSE@OFF
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubPitchPanChorusOnOff( ZKN_SOUND_SUB_WORK* p_work, BOOL flag )
{
	ZknSoundSubPitchPanChorusFlagOnOff( p_work, flag );

	if( flag == FALSE ){
		ZknSoundSubPitchPanChorusNumReset( p_work );
	}
}
//@tȌグ
static void ZknSoundSubPitchPanChorusFlagOnOff( ZKN_SOUND_SUB_WORK* p_work, BOOL flag )
{
	// ON@OFFݒ
	p_work->pitch_pan_push = flag;
}
// l̏
static void ZknSoundSubPitchPanChorusNumReset( ZKN_SOUND_SUB_WORK* p_work )
{
	p_work->pitch_num = 0;
	p_work->pan_num = 0;
	p_work->chorus_num = 0;
}

//----------------------------------------------------------------------------
/**
 *	@brief	sb`pR[Xݒ
 *
 *	@param	p_work 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubPitchPanChorusSet( ZKN_SOUND_SUB_WORK* p_work )
{
	// ĐȂݒ
	if( p_work->sound_play ){
		ZknSoundSubPitchSet( p_work->pitch_num );
		Snd_PlayerSetTrackPan( SND_HANDLE_PMVOICE, 0xffff, p_work->pan_num );

		ZknSoundSubChorusSet( p_work->chorus_num );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	R[Xݒ
 *
 *	@param@O[of[^	
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubChorusStart( const ZKN_SOUND_SUB_GLB* cp_glb )
{
	int monsno = ZKN_GLBDATA_PokeMonsNoGet( cp_glb->p_glb );

	//ĐƃR[XĐ
	//mۂ͂Ă܂B
	//Snd_PMVoicePlayPtn_ZukanChorus( monsno, 0 );
	Snd_PMVoicePlayEx( PV_ZUKAN_CHORUS, monsno, PV_PTN_PARAM_NONE, 0, PV_PTN_PARAM_NONE );
}

//----------------------------------------------------------------------------
/**
 *	@brief	R[Xݒ
 *
 *	@param	p_work	[N
 *	@param	volume	{[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubChorusSet( int volume )
{
	Snd_PlayerMoveVolume( SND_HANDLE_CHORUS, volume, 0 );
}

//----------------------------------------------------------------------------
/**
 *	@brief	sb`pAj
 *
 *	@param	p_draw
 *	@param	cp_work 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubPitchPanAnm( ZKN_SOUND_SUB_DRAW* p_draw, const ZKN_SOUND_SUB_WORK* cp_work )
{
	// pbgAj
	if( cp_work->pitch_pan_push != p_draw->pltt_anm ){
		
		if( cp_work->pitch_pan_push == TRUE ){
			ZknSoundSubPlttOn( p_draw );	
		}else{
			ZknSoundSubPlttOff( p_draw );	
		}
		p_draw->pltt_anm = cp_work->pitch_pan_push;
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	J[\
 *
 *	@param	p_work		[N
 *	@param	p_glb		O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubCursorMove( ZKN_SOUND_SUB_WORK* p_work, ZKN_SOUND_SUB_GLB* p_glb )
{
	int monsno = ZKN_GLBDATA_PokeMonsNoGet( p_glb->p_glb );

	// 삷
	if( sys.trg & PAD_BUTTON_A ){

		// Đ
		if( p_work->loop == FALSE ){
			// ȂĂƂ߂
			if( p_work->sound_play == TRUE ){
				Snd_PMVoiceStop(0);
			}	
			
			ZknSoundSubSoundStart( p_work, p_glb, monsno );
		}else{
			// Đ~ݒ
			if( p_work->sound_play == FALSE ){
				ZknSoundSubSoundStart( p_work, p_glb, monsno );
			}else{
				// ~
				ZknSoundSubSoundStop( p_work );
			}
		}
	}	
}

//----------------------------------------------------------------------------
/**
 *	@brief	J[\`揈
 *
 *	@param	p_drawglb	`O[o
 *	@param	cp_glb		O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubCursorDrawMove( ZKN_SOUND_SUB_DRAWGLB* p_drawglb, const ZKN_SOUND_SUB_GLB* cp_glb )
{
	ZKN_GLB_DRAWDATA* p_draw = p_drawglb->p_drawglb;
	
	if( ZKN_ZukanCommonSubCursorFlagGet( cp_glb->cp_zukan_common_apl ) == TRUE ){
	
		ZKN_UTIL_CursorSetMatrix( p_draw, ZKN_SOUNDSUB_BUTTON_STARTSTOP_X, ZKN_SOUNDSUB_BUTTON_STARTSTOP_Y, ZKN_SOUNDSUB_CURSOR_START_SIZX, ZKN_SOUNDSUB_CURSOR_START_SIZY );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	sb`ݒ
 *
 *	@param	num 
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoundSubPitchSet( int num )
{
	Snd_PlayerSetTrackPitch( SND_HANDLE_PMVOICE, 0xffff, num);
	Snd_PlayerSetTrackPitch( SND_HANDLE_CHORUS, 0xffff, SND_ZUKAN_PITCH_CHORUS + num );
}
