//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		zkn_sys.c
 *	@brief		}ӃVXe
 *	@author		tomoya takahashi
 *	@data		2006.01.17
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include "calctool.h"
#include "calc2d.h"
#include <string.h>
#include <nnsys.h>
#include "touchpanel_system.h"
#include "include/system/heapdefine.h"
#include "include/gflib/display.h"
#include "include/gflib/vram_transfer_manager.h"
#include "include/system/wipe.h"

#include "include/application/zukanlist/zkn_defain.h"
#include "include/application/zukanlist/zkn_snd_def.h"

// `֌W
#include "include/system/render_oam.h"
#include "include/gflib/char_manager.h"
#include "include/gflib/pltt_manager.h"
#include "gf_gx.h"

#include "button_man.h"
#include "include/system/fontproc.h"
#include "include/system/msgdata_util.h"
#include "include/msgdata/msg.naix"
#include "include/msgdata/msg_zkn.h"

#include "include/application/zukanlist/zkn_sys_static.h"


#include "include/application/zukanlist/zkn_pokelist.h"
#include "include/application/zukanlist/zkn_pokelist_sub.h"
#include "include/application/zukanlist/zkn_sortsearch.h"
#include "include/application/zukanlist/zkn_sortsearch_sub.h"
#include "include/application/zukanlist/zkn_range.h"
#include "include/application/zukanlist/zkn_range_sub.h"
#include "include/application/zukanlist/zkn_zukan.h"
#include "include/application/zukanlist/zkn_zukan_graver.h"
#include "include/application/zukanlist/zkn_zukan_textver.h"
#include "include/application/zukanlist/zkn_zukan_sub.h"
#include "include/application/zukanlist/zkn_zukan_common.h"
#include "include/application/zukanlist/zkn_big.h"
#include "include/application/zukanlist/zkn_big_weight.h"
#include "include/application/zukanlist/zkn_big_sub.h"
#include "include/application/zukanlist/zkn_sound.h"
#include "include/application/zukanlist/zkn_sound_sub.h"
#include "include/application/zukanlist/zkn_event_func.h"
#include "include/application/zukanlist/zkn_world_text_sys.h"
#include "include/application/zukanlist/zkn_zukan_graver_sub.h"

#define __ZKN_SYS_H_GLOBAL
#include "include/application/zukanlist/zkn_sys.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *	}ӃvbN
 */
//-----------------------------------------------------------------------------
#define ZKN_VRAMTRANSFER_MANAGER_NUM	( 8 )

#define ZKN_PROC_FADE_DIV	( 6 )
#define ZKN_PROC_FADE_SYNC	( 1 )


//-------------------------------------
//	
//	}ӃvbN[N
//	
//=====================================
typedef struct {
	// }ӃVXe
	ZKN_SYS_PTR		zkn_sys;

	BOOL fade_end_flag;
} ZKN_PROC_WORK;



//-----------------------------------------------------------------------------
/**
 *		vg^Cv錾
 */
//-----------------------------------------------------------------------------
static void ZknVBlankFunc( void* work );

static void ZknFadeInReq( ZKN_PROC_WORK* p_work );
static void ZknFadeOutReq( ZKN_PROC_WORK* p_work );
static BOOL ZknFadeMain( ZKN_PROC_WORK* p_work );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	}ӃvbN
 *
 *	@param	proc		vbNf[^	
 *	@param	seq			V[PX
 *
 *	@return	
 *
 *	typedef enum {
 *		PROC_RES_CONTINUE = 0,		///<p
 *		PROC_RES_FINISH,			///<I
 *	}PROC_RESULT;
 *
 *
 */
//-----------------------------------------------------------------------------
PROC_RESULT ZKN_ProcInit( PROC* proc, int* seq )
{
	ZKN_PROC_WORK* zkn_w;
	ZKN_PEARENT_DATA* zkn_pearent;
	ZKN_SYS_INIT_DATA zkn_init;
	BOOL check;

	// 
	Snd_DataSetByScene( SND_SCENE_SUB_ZUKAN, 0, 0 );	// TEhf[^[hi}ӁjiBGMpj

	// q[v쐬
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_ZUKAN, 0x40000 );

	// }Ӄ[N쐬
	zkn_w = PROC_AllocWork( proc, sizeof(ZKN_PROC_WORK), HEAPID_ZUKAN );
	GF_ASSERT( zkn_w );
	memset( zkn_w, 0, sizeof(ZKN_PROC_WORK) );

	// VramTransferManager
	initVramTransferManagerHeap( ZKN_VRAMTRANSFER_MANAGER_NUM, HEAPID_ZUKAN );

	// }ӊǗ҃f[^擾
	zkn_pearent = PROC_GetParentWork( proc );

	// VBlank HBlankݒ
	sys_VBlankFuncChange( ZknVBlankFunc, zkn_w );	// VBlankZbg
	sys_HBlankIntrStop();	//HBlank荞ݒ~

	// ^b`plI[gTvOJn
	InitTPSystem();
	check = InitTPNoBuff( 4 );
	GF_ASSERT( check == TP_OK );

	// `ZbgAbv
	ZKN_SYS_SetUpDraw( HEAPID_ZUKAN );

	// }ӃVXe쐬
	zkn_init.cp_zukansave_data	= zkn_pearent->cp_zukansave_data;
	zkn_init.cp_hero_data		= zkn_pearent->cp_hero_data;
	zkn_init.time_zone			= zkn_pearent->time_zone;
	zkn_w->zkn_sys = ZKN_SYS_Init( HEAPID_ZUKAN, &zkn_init );

	// i
	Snd_BgmFadeOut( BGM_VOL_ZUKAN, BGM_FADE_ZUKAN_TIME );		//tF[hAEg
	
	return PROC_RES_FINISH;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	}ӃvbNC
 *
 *	@param	proc		vbNf[^	
 *	@param	seq			V[PX
 *
 *	@return	
 *
 *	typedef enum {
 *		PROC_RES_CONTINUE = 0,		///<p
 *		PROC_RES_FINISH,			///<I
 *	}PROC_RESULT;
 *
 *
 */
//-----------------------------------------------------------------------------
PROC_RESULT ZKN_ProcMain( PROC* proc, int* seq )
{
	ZKN_PROC_WORK* zkn_w = PROC_GetWork( proc );
	BOOL ret;

#if 0
	switch( *seq ){
	// tF[hC
	case 0:
		ZknFadeInReq( zkn_w );
		(*seq)++;
		break;
	case 1:
		if( ZknFadeMain( zkn_w ) ){
			(*seq)++;
		}
		break;
		
	// C
	case 2:
		ret = ZKN_SYS_Main( zkn_w->zkn_sys );

		// I`FbN
		if( ret == TRUE ){
			zkn_w->zkn_sys = NULL;
			(*seq)++;
		}
		break;

	// tF[hAEg
	case 3:
		ZknFadeOutReq( zkn_w );
		(*seq)++;
		break;
	case 4:
		if( ZknFadeMain( zkn_w ) ){
			WIPE_ResetWndMask( WIPE_DISP_MAIN );
			WIPE_ResetWndMask( WIPE_DISP_SUB );

			return PROC_RES_FINISH;
		}
		break;
	}
#else
	ret = ZKN_SYS_Main( zkn_w->zkn_sys );

	// I`FbN
	if( ret == TRUE ){
		zkn_w->zkn_sys = NULL;
		return PROC_RES_FINISH;
	}
#endif

	return PROC_RES_CONTINUE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	}ӃvbNI
 *
 *	@param	proc		vbNf[^	
 *	@param	seq			V[PX
 *
 *	@return	
 *
 *	typedef enum {
 *		PROC_RES_CONTINUE = 0,		///<p
 *		PROC_RES_FINISH,			///<I
 *	}PROC_RESULT;
 *
 *
 */
//-----------------------------------------------------------------------------
PROC_RESULT ZKN_ProcEnd( PROC* proc, int* seq )
{
	ZKN_PROC_WORK* zkn_w = PROC_GetWork( proc );
	BOOL check;

	sys_VBlankFuncChange( NULL, NULL );	// VBlankZbg

	// ^b`plTvOI
	check = StopTP();
	GF_ASSERT( check == TP_OK );
	
	// \f[^j
	ZKN_SYS_ReleaseDraw();

	// VramTransferManagerj
	DellVramTransferManager();

	// [Nj
	PROC_FreeWork( proc );

	// q[vj
	sys_DeleteHeap( HEAPID_ZUKAN );

	// ߂
	Snd_BgmFadeIn( BGM_VOL_MAX, BGM_FADE_ZUKAN_TIME, BGM_FADEIN_START_VOL_NOW );

	return PROC_RES_FINISH;
}


//-----------------------------------------------------------------------------
/**
 *			vCx[g֐
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	VBlank֐
 *
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void ZknVBlankFunc( void* work )
{
	ZKN_PROC_WORK* zkn_w = work;

	if( zkn_w->zkn_sys ){
		ZKN_Vblank( zkn_w->zkn_sys  );
	}

	// Vram]^XN
	DoVramTransferManager();
}

//----------------------------------------------------------------------------
/**
 *	@brief	tF[hCݒ
 *
 *	@param	p_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknFadeInReq( ZKN_PROC_WORK* p_work )
{
	WIPE_Start(
			WIPE_PATTERN_WMS,
			WIPE_TYPE_FADEIN,
			WIPE_TYPE_FADEIN,
			WIPE_FADE_BLACK,
			ZKN_PROC_FADE_DIV,
			ZKN_PROC_FADE_SYNC,
			HEAPID_ZUKAN,
			&p_work->fade_end_flag
			);
}

//----------------------------------------------------------------------------
/**
 *	@brief	tF[hAEgݒ
 *
 *	@param	p_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknFadeOutReq( ZKN_PROC_WORK* p_work )
{
	WIPE_Start(
			WIPE_PATTERN_WMS,
			WIPE_TYPE_FADEOUT,
			WIPE_TYPE_FADEOUT,
			WIPE_FADE_BLACK,
			ZKN_PROC_FADE_DIV,
			ZKN_PROC_FADE_SYNC,
			HEAPID_ZUKAN,
			&p_work->fade_end_flag
			);
}

//----------------------------------------------------------------------------
/**
 *	@brief	tF[h`FbN
 *
 *	@param	p_work	[N
 *
 *	@retval	TRUE		tF[hI
 *	@retval	FALSE		tF[h
 */
//-----------------------------------------------------------------------------
static BOOL ZknFadeMain( ZKN_PROC_WORK* p_work )
{
	return p_work->fade_end_flag;
}















//-----------------------------------------------------------------------------
/**
 *		}ӃVXe
 */
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *			}ӃVXef[^
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	}ӃVXe\
//=====================================
typedef struct _ZKN_SYS{
	// ItO
	BOOL				zkn_delete;
	// q[v
	int					heap;

	// O[of[^
	ZKN_GLB_DATA	glb;
	
	// `O[of[^
	ZKN_GLB_DRAWDATA draw_glb;
	

	//-----------------------------------------------------------------------------
	/**
	 *		Cxg֌W		ij
	 */
	//-----------------------------------------------------------------------------
	// CxgL[
	// eAvP[VpCxgL[
	int					event_key_main;	
	int					event_key_sub;	
	// AvP[VʂœAvP[VpCxgL[iDxj
	int					event_key_common_main;
	int					event_key_common_sub;
	
	// CxgǗ
	// eAvP[Vp
	ZKN_EVENT_SYS_PTR	event_main;	
	ZKN_EVENT_SYS_PTR	event_sub;
	// AvP[VʂœAvP[Vp
	ZKN_EVENT_SYS_PTR	event_main_common;
	ZKN_EVENT_SYS_PTR	event_sub_common;

	// AvP[VJnCxgf[^
	ZKN_EVENT_DATA	event_apl_start_main;

	//-----------------------------------------------------------------------------
	/**
	 *		AvP[V֌W
	 */
	//-----------------------------------------------------------------------------
	// eAvP[Vf[^
	ZKN_APL_DATA	main_apl_data[ ZKN_SYS_APLMAIN_NUM ];
	ZKN_APL_DATA	sub_apl_data[ ZKN_SYS_APLSUB_NUM ];
	
	//-------------------------------------
	//	؂ւAvP[V
	//=====================================
	// C@Tu@vZXǗ
	ZKN_PROC_SYS_PTR	main_proc;
	ZKN_PROC_SYS_PTR	sub_proc;

	//-------------------------------------
	//	ƕ\ĂAvP[V
	//=====================================
	// eAvP[VʕvbN
	ZKN_PROC_SYS_PTR	main_common_proc;
	ZKN_PROC_SYS_PTR	sub_common_proc;
	
} ZKN_SYS;




//-----------------------------------------------------------------------------
/**
 *				֐|C^e[u
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//		AvP[Vf[^쐬
//=====================================
// CʃAv
const static ZKN_APL_DATA_MAKE_FUNC ZknAplMainDataMakeFunc[ ZKN_SYS_APLMAIN_NUM ] = {
	ZKN_PokeListAplMake,
	ZKN_SortSearchAplMake,
	ZKN_ZukanAplMake,
	ZKN_ZukanGraverAplMake,
	ZKN_ZukanTextverAplMake,
	ZKN_ZukanCommonAplMake,
	ZKN_RangeAplMake,
	ZKN_SoundAplMake,
	ZKN_BigAplMake,
	ZKN_BigWeAplMake,
};
// TuʃAv
const static ZKN_APL_DATA_MAKE_FUNC ZknAplSubDataMakeFunc[ ZKN_SYS_APLSUB_NUM ] = {
	ZKN_PokeListSubAplMake,
	ZKN_SortSearchSubAplMake,
	ZKN_ZukanSubAplMake,
	ZKN_ZukanCommonSubAplMake,
	ZKN_RangeSubAplMake,
	ZKN_SoundSubAplMake,
	ZKN_BigSubAplMake,
	ZKN_GraphicSubAplMake,
};

//-------------------------------------
//		AvP[Vf[^j
//=====================================
// CʃAv
const static ZKN_APL_DATA_DELETE_FUNC ZknAplMainDataDeleteFunc[ ZKN_SYS_APLMAIN_NUM ] = {
	ZKN_PokeListAplDelete,
	ZKN_SortSearchAplDelete,
	ZKN_ZukanAplDelete,
	ZKN_ZukanGraverAplDelete,
	ZKN_ZukanTextverAplDelete,
	ZKN_ZukanCommonAplDelete,
	ZKN_RangeAplDelete,
	ZKN_SoundAplDelete,
	ZKN_BigAplDelete,
	ZKN_BigWeAplDelete,
};
// TuʃAv
const static ZKN_APL_DATA_DELETE_FUNC ZknAplSubDataDeleteFunc[ ZKN_SYS_APLSUB_NUM ] = {
	ZKN_PokeListSubAplDelete,
	ZKN_SortSearchSubAplDelete,
	ZKN_ZukanSubAplDelete,
	ZKN_ZukanCommonSubAplDelete,
	ZKN_RangeSubAplDelete,
	ZKN_SoundSubAplDelete,
	ZKN_BigSubAplDelete,
	ZKN_GraphicSubAplDelete,
};

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void DeleteZkn( ZKN_SYS_PTR zkn );

static void VramBankSet( void );
static void OamSet( int heap );
static void setup_3d( void );
static void putback_3d( void );


static void StartAlp( ZKN_SYS_PTR zkn );

static void MakeMainAplStartEvent( int heap, ZKN_EVENT_DATA* p_event_data, ZKN_SYS_PTR zkn_sys );
static void DeleteMainAplStartEvent( ZKN_EVENT_DATA* p_event_data );

static void MakeSubAplStartEvent( int heap, ZKN_EVENT_DATA* p_event_data, ZKN_SYS_PTR zkn_sys );
static void DeleteSubAplStartEvent( ZKN_EVENT_DATA* p_event_data );



//-----------------------------------------------------------------------------
/**
 *			AvP[VJnCxg
 */
//-----------------------------------------------------------------------------
#define ZKN_SYS_EVENT_MSK_APL_START  ( 1 )	// AvP[VX^[g

//-------------------------------------
//	AvP[VX^[gCxg
//=====================================
typedef struct {
	ZKN_EVENT_SYS_PTR	event;	
	ZKN_EVENT_SYS_PTR	event_common;	

	ZKN_APL_DATA*	p_apl_data;
	ZKN_APL_DATA*	p_apl_data_common;

	ZKN_PROC_SYS_PTR	proc;
	ZKN_PROC_SYS_PTR	proc_common;
} ZKN_SYS_APLSTART_EVENT;
static BOOL ZKN_EVENT_ZknSysAplStart( ZKN_EVENT_WORK* p_work );





//----------------------------------------------------------------------------
/**
 *
 *	@brief	}ӃVXe
 *
 *	@param	heap	gpq[v
 *	@param	p_init	VXef[^
 *
 *	@return	쐬}ӃVXe
 *
 *
 */
//-----------------------------------------------------------------------------
ZKN_SYS_PTR ZKN_SYS_Init( int heap, const ZKN_SYS_INIT_DATA* p_init )
{
	ZKN_SYS_PTR zkn_sys;
	int i;
	ZKN_GLB_DATA_INIT glb_init;

	// CVXe[N쐬
	zkn_sys = sys_AllocMemory( heap, sizeof(ZKN_SYS) );
	GF_ASSERT( zkn_sys );
	memset( zkn_sys, 0, sizeof(ZKN_SYS) );

	// q[v
	zkn_sys->heap	= heap;
	

	// CxgVXe쐬
	zkn_sys->event_main	= ZKN_EVENT_MemoryAlloc( heap );
	zkn_sys->event_sub	= ZKN_EVENT_MemoryAlloc( heap );
	zkn_sys->event_main_common = ZKN_EVENT_MemoryAlloc( heap );
	zkn_sys->event_sub_common  = ZKN_EVENT_MemoryAlloc( heap );

	// vZXǗVXe쐬
	zkn_sys->main_proc = ZKN_PROC_MemoryAlloc( heap );
	zkn_sys->sub_proc = ZKN_PROC_MemoryAlloc( heap );
	zkn_sys->main_common_proc = ZKN_PROC_MemoryAlloc( heap );
	zkn_sys->sub_common_proc = ZKN_PROC_MemoryAlloc( heap );

	
	// O[of[^
	glb_init.cp_zukansave_data = p_init->cp_zukansave_data;
	glb_init.cp_hero_data = p_init->cp_hero_data;
	glb_init.time_zone = p_init->time_zone;
	ZKN_GLBDATA_Init( &zkn_sys->glb, &glb_init, heap );

	// `O[of[^
	ZKN_GlbDrawDataInit( &zkn_sys->draw_glb, heap );

	

	// AvP[Vf[^쐬
	for( i=0; i<ZKN_SYS_APLMAIN_NUM; i++ ){
		if( ZknAplMainDataMakeFunc[ i ] ){
			ZknAplMainDataMakeFunc[ i ]( &zkn_sys->main_apl_data[ i ], zkn_sys, heap );
		}
	}
	for( i=0; i<ZKN_SYS_APLSUB_NUM; i++ ){
		if( ZknAplSubDataMakeFunc[ i ] ){
			ZknAplSubDataMakeFunc[ i ]( &zkn_sys->sub_apl_data[ i ], zkn_sys, heap );
		}
	}

	// AvP[VJnCxg쐬
	ZKN_EVENT_MakeChangePokeList( heap, &zkn_sys->event_apl_start_main, zkn_sys, ZKN_SYS_EVENT_MSK_APL_START );

	// ŏ̃AvP[VCxgs
	StartAlp( zkn_sys );


	return zkn_sys;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	}ӃC
 *
 *	@param	zkn		}ӃVXe
 *
 *
 *	@retval	TRUE	I	̂͂I
 *	@retval	FALSE	s
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL ZKN_SYS_Main( ZKN_SYS_PTR zkn )
{
	GF_ASSERT( zkn );


	// ^b`plJ[\tOݒ
	ZKN_GLBDATA_TouchCursorFlagSet( &zkn->glb );


	// Cxg͓Ȃ
	if( (ZKN_EVENT_DoCheck( zkn->event_main_common ) == FALSE) &&
		(ZKN_EVENT_DoCheck( zkn->event_main ) == FALSE) &&
		(ZKN_EVENT_DoCheck( zkn->event_sub_common ) == FALSE) &&
		(ZKN_EVENT_DoCheck( zkn->event_sub ) == FALSE) ){
		
		ZKN_PROC_MoveLock( zkn->main_common_proc, FALSE );		// Cʁ@Av
		ZKN_PROC_MoveLock( zkn->sub_common_proc, FALSE );		// Tuʁ@Av
		ZKN_PROC_MoveLock( zkn->main_proc, FALSE );			// C
		ZKN_PROC_MoveLock( zkn->sub_proc, FALSE );				// Tu
	}else{
		ZKN_PROC_MoveLock( zkn->main_common_proc, TRUE );		// Cʁ@Av
		ZKN_PROC_MoveLock( zkn->sub_common_proc, TRUE );		// Tuʁ@Av
		ZKN_PROC_MoveLock( zkn->main_proc, TRUE );			// C
		ZKN_PROC_MoveLock( zkn->sub_proc, TRUE );				// Tu
	}


	// vZX
	ZKN_PROC_Main( zkn->main_common_proc );		// Cʁ@Av
	ZKN_PROC_Main( zkn->sub_common_proc );		// Tuʁ@Av
	ZKN_PROC_Main( zkn->main_proc );			// C
	ZKN_PROC_Main( zkn->sub_proc );				// Tu

	ZKN_PROC_Draw( zkn->main_common_proc );		// Cʁ@Av
	ZKN_PROC_Draw( zkn->sub_common_proc );		// Tuʁ@Av
	ZKN_PROC_Draw( zkn->main_proc );			// C
	ZKN_PROC_Draw( zkn->sub_proc );				// Tu

	//-----------------------------------------------------------------------------
	/**
	 *			Cxg		()
	 *			common̔̕D悷
	 *			P삵ĂCxgΑ͓Ȃ
	 */
	//-----------------------------------------------------------------------------
	// AvʃAvCxgǗ
	// CʃCxg
	if( (ZKN_EVENT_DoCheck( zkn->event_main ) == FALSE) &&
		(ZKN_EVENT_DoCheck( zkn->event_sub_common ) == FALSE) &&
		(ZKN_EVENT_DoCheck( zkn->event_sub ) == FALSE) ){

		ZKN_EVENT_Main( zkn->event_main_common, zkn->event_key_common_main );	
	}
	if( (ZKN_EVENT_DoCheck( zkn->event_main_common ) == FALSE) &&
		(ZKN_EVENT_DoCheck( zkn->event_sub_common ) == FALSE) &&
		(ZKN_EVENT_DoCheck( zkn->event_sub ) == FALSE) ){
		ZKN_EVENT_Main( zkn->event_main, zkn->event_key_main );
	}

	// eAvCxgǗ
	if( (ZKN_EVENT_DoCheck( zkn->event_main_common ) == FALSE) &&
		(ZKN_EVENT_DoCheck( zkn->event_main ) == FALSE) &&
		(ZKN_EVENT_DoCheck( zkn->event_sub ) == FALSE) ){
		ZKN_EVENT_Main( zkn->event_sub_common, zkn->event_key_common_sub );
	}
	if( (ZKN_EVENT_DoCheck( zkn->event_main_common ) == FALSE) &&
		(ZKN_EVENT_DoCheck( zkn->event_main ) == FALSE) &&
		(ZKN_EVENT_DoCheck( zkn->event_sub_common ) == FALSE) ){
		ZKN_EVENT_Main( zkn->event_sub, zkn->event_key_sub );
	}

	// `main
	GF_G3X_Reset();
	
	ZKN_GlbDrawDataMain( &zkn->draw_glb );
	
	/* WIg_OGW֘ÃXbv */
	GF_G3_RequestSwapBuffers(GX_SORTMODE_AUTO, GX_BUFFERMODE_Z);

	// CxgL[NA
	zkn->event_key_common_main = 0;
	zkn->event_key_common_sub = 0;
	zkn->event_key_main = 0;
	zkn->event_key_sub	= 0;


	// I`FbN
	if( zkn->zkn_delete == TRUE ){

		// j
		DeleteZkn( zkn );
		zkn = NULL;
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`֌W̃ZbgAbv
 *
 *	@param	heap	gpq[v
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_SYS_SetUpDraw( int heap )
{
	// oNZbgAbv
	VramBankSet();
	
	// oam֌WZbgAbv
	OamSet( heap );


	// 3D
	setup_3d();
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`֌W̔j
 *
 *	@param	none
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_SYS_ReleaseDraw( void )
{
	// _[LOAM}l[Wj
	REND_OAM_Delete();
	
	// LN^f[^j
	DeleteCharManager();
	// pbgf[^j
	DeletePlttManager();

	// 3D
	putback_3d();
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	VuNԊ֐
 *
 *	@param	zkn		}ӃVXe 
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_Vblank( ZKN_SYS_PTR zkn )
{
	ZKN_GlbDrawDataVBlank( &zkn->draw_glb );

	// _[OAM]
	REND_OAMTrans();
}



//-----------------------------------------------------------------------------
/**
 *		}ӃVXêݎQƉ\
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	CʃvZXVXe擾
 *
 *	@param	zkn		}ӃVXe
 *
 *	@return	vZXVXe
 *
 *
 */
//-----------------------------------------------------------------------------
ZKN_PROC_SYS_PTR ZKN_SYS_GetProcSysMain( ZKN_SYS_PTR zkn )
{
	GF_ASSERT( zkn );

	return zkn->main_proc;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	TuʃvZXVXe擾
 *
 *	@param	zkn		}ӃVXe
 *
 *	@return	vZXVXe
 *
 *
 */
//-----------------------------------------------------------------------------
ZKN_PROC_SYS_PTR ZKN_SYS_GetProcSysSub( ZKN_SYS_PTR zkn )
{
	GF_ASSERT( zkn );

	return zkn->sub_proc;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	CʋʃvZXVXe
 *
 *	@param	zkn		}ӃVXe
 *
 *	@return	vZXVXe
 *
 *
 */
//-----------------------------------------------------------------------------
ZKN_PROC_SYS_PTR ZKN_SYS_GetProcSysMainCommon( ZKN_SYS_PTR zkn )
{
	GF_ASSERT( zkn );

	return zkn->main_common_proc;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	TuʋʃvZXVXe
 *
 *	@param	zkn		}ӃVXe
 *
 *	@return	vZXVXe
 *
 *
 */
//-----------------------------------------------------------------------------
ZKN_PROC_SYS_PTR ZKN_SYS_GetProcSysSubCommon( ZKN_SYS_PTR zkn )
{
	GF_ASSERT( zkn );

	return zkn->sub_common_proc;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C CxgVXe|C^擾
 *
 *	@param	zkn }ӃVXe
 *
 *	@return	CxgVXe|C^
 *
 *
 */
//-----------------------------------------------------------------------------
ZKN_EVENT_SYS_PTR ZKN_SYS_GetEventSysMain( ZKN_SYS_PTR zkn )
{
	GF_ASSERT( zkn );

	return zkn->event_main;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Tu CxgVXe|C^擾
 *
 *	@param	zkn }ӃVXe
 *
 *	@return	CxgVXe|C^
 *
 *
 */
//-----------------------------------------------------------------------------
ZKN_EVENT_SYS_PTR ZKN_SYS_GetEventSysSub( ZKN_SYS_PTR zkn )
{
	GF_ASSERT( zkn );

	return zkn->event_sub;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C ʃAv CxgVXe|C^擾
 *
 *	@param	zkn }ӃVXe
 *
 *	@return	CxgVXe|C^
 *
 *
 */
//-----------------------------------------------------------------------------
ZKN_EVENT_SYS_PTR ZKN_SYS_GetEventSysMainCommon( ZKN_SYS_PTR zkn )
{
	GF_ASSERT( zkn );

	return zkn->event_main_common;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Tu ʃAv CxgVXe|C^擾
 *
 *	@param	zkn }ӃVXe
 *
 *	@return	CxgVXe|C^
 *
 *
 */
//-----------------------------------------------------------------------------
ZKN_EVENT_SYS_PTR ZKN_SYS_GetEventSysSubCommon( ZKN_SYS_PTR zkn )
{
	GF_ASSERT( zkn );

	return zkn->event_sub_common;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	CxgL[|C^擾
 *
 *	@param	zkn		}ӃVXe
 *
 *	@return	CxgL[|C^
 *
 *
 */
//-----------------------------------------------------------------------------
int* ZKN_SYS_GetEventKeyPtrMain( ZKN_SYS_PTR zkn )
{
	GF_ASSERT( zkn );

	return &zkn->event_key_main;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	CxgL[|C^擾
 *
 *	@param	zkn		}ӃVXe
 *
 *	@return	CxgL[|C^
 *
 *
 */
//-----------------------------------------------------------------------------
int* ZKN_SYS_GetEventKeyPtrSub( ZKN_SYS_PTR zkn )
{
	GF_ASSERT( zkn );

	return &zkn->event_key_sub;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	CxgL[|C^擾
 *
 *	@param	zkn		}ӃVXe
 *
 *	@return	CxgL[|C^
 *
 *
 */
//-----------------------------------------------------------------------------
int* ZKN_SYS_GetEventKeyPtrMainCommon( ZKN_SYS_PTR zkn )
{
	GF_ASSERT( zkn );

	return &zkn->event_key_common_main;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	CxgL[|C^擾
 *
 *	@param	zkn		}ӃVXe
 *
 *	@return	CxgL[|C^
 *
 *
 */
//-----------------------------------------------------------------------------
int* ZKN_SYS_GetEventKeyPtrSubCommon( ZKN_SYS_PTR zkn )
{
	GF_ASSERT( zkn );

	return &zkn->event_key_common_sub;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	}ӔjtO擾
 *
 *	@param	zkn		}ӃVXe
 *
 *	@return	}ӔjtO
 *
 * }ӔjtÓASɃjĂv
 * ԂɂȂĂTRUEɂ
 *
 */
//-----------------------------------------------------------------------------
BOOL* ZKN_SYS_GetZknDeleteFlag( ZKN_SYS_PTR zkn )
{
	GF_ASSERT( zkn );

	return &zkn->zkn_delete;
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	O[of[^擾
 *
 *	@param	zkn		}ӃVXe
 *
 *	@return	}ӃO[of[^
 *
 *
 */
//-----------------------------------------------------------------------------
ZKN_GLB_DATA* ZKN_SYS_GetGlbData( ZKN_SYS_PTR zkn )
{
	GF_ASSERT( zkn );

	return &zkn->glb;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	}ӕ`O[of[^
 *
 *	@param	zkn		}ӃVXe
 *
 *	@return	}ӕ`O[of[^
 *
 *
 */
//-----------------------------------------------------------------------------
ZKN_GLB_DRAWDATA* ZKN_SYS_GetGlbDrawData( ZKN_SYS_PTR zkn )
{
	GF_ASSERT( zkn );

	return &zkn->draw_glb;
}

//----------------------------------------------------------------------------
/**
 *[main]
 *	@brief	}ӃAvP[Vf[^擾
 *
 *	@param	zkn			}ӃVXe
 *	@param	apl_no		AvP[Vf[^
 *
 *	@return	AvP[Vf[^
 *
 *
 */
//-----------------------------------------------------------------------------
ZKN_APL_DATA* ZKN_GetAplDataMain( ZKN_SYS_PTR zkn, int apl_no )
{
	GF_ASSERT( apl_no < ZKN_SYS_APLMAIN_NUM );

	return &zkn->main_apl_data[ apl_no ];
}

//----------------------------------------------------------------------------
/**
 *[sub]
 *	@brief	}ӃAvP[Vf[^擾
 *
 *
 *	@param	zkn			}ӃVXe
 *	@param	apl_no		AvP[Vf[^
 *
 *	@return	AvP[Vf[^
 *
 *
 */
//-----------------------------------------------------------------------------
ZKN_APL_DATA* ZKN_GetAplDataSub( ZKN_SYS_PTR zkn, int apl_no )
{
	GF_ASSERT( apl_no < ZKN_SYS_APLSUB_NUM );

	return &zkn->sub_apl_data[ apl_no ];
}



//-----------------------------------------------------------------------------
/**
 *		ȃAvP[VʂĎgpł
 */
//-----------------------------------------------------------------------------
#define ZKN_UTIL_BUTTON_ANIM_SPEED	( FX32_ONE * 2 )

#define ZKN_UTIL_FONTBUTTON_ANIM_PUSH1	( -2 )
#define ZKN_UTIL_FONTBUTTON_ANIM_PUSH2	( -4 )
#define ZKN_UTIL_FONTBUTTON_ANIM_SELECT	( -2 )

//----------------------------------------------------------------------------
/**
 *	@brief	{^OtBbNʓ
 *
 *	@param	act				AN^[
 *	@param	button_event	{^Cxg
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_UTIL_ButtonMove( CLACT_WORK_PTR act, int button_event )
{

	// ꂽƂAĂƂ̓Aj
	switch( button_event ){
	case BMN_EVENT_TOUCH:		///< Gꂽu
		CLACT_AnmFrameSet( act, ZKN_UTIL_BUTTON_FRAME_PUSH1 );
		break;

	case BMN_EVENT_HOLD:			///< GÂĂ
		// vbVQt[ڂ܂ŃAj
		CLACT_AnmFrameSet( act, ZKN_UTIL_BUTTON_FRAME_PUSH2 );
		break;
		
	case BMN_EVENT_RELEASE:		///< ꂽu
		// It[ݒ
		CLACT_AnmFrameSet( act, ZKN_UTIL_BUTTON_FRAME_SELECT );
		break;//*/
		
	case BMN_EVENT_SLIDEOUT:		///< ʃ^b`܂܃{^̈悩Oꂽu
	case ZKN_UTIL_BUTTON_PUSH_NONE:	///< ĂȂƂ
		// 擪܂łǂ
		if( CLACT_AnmFrameGet( act ) > ZKN_UTIL_BUTTON_FRAME_NONE ){
			CLACT_AnmFrameChg( act, -ZKN_UTIL_BUTTON_ANIM_SPEED );
		}
		break;

	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	{^tHg̃{^Aj
 *
 *	@param	act				eAN^[
 *	@param	p_fontoam		tHgOAM
 *	@param	def_y			Yʒu
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_UTIL_ButtonFontMove( CLACT_WORK_PTR act, ZKN_FONTOAM_DATA* p_fontoam, int def_y )
{
	int button_anm = CLACT_AnmFrameGet( act );
	int x, y;

	switch( button_anm ){
	case ZKN_UTIL_BUTTON_FRAME_NONE:		// 
		FONTOAM_GetMat( p_fontoam->p_fontoam, &x, &y );

		y = def_y;
		FONTOAM_SetMat( p_fontoam->p_fontoam, x, y );
		break;
		
	case ZKN_UTIL_BUTTON_FRAME_PUSH1:	// vbVAjPt[
		FONTOAM_GetMat( p_fontoam->p_fontoam, &x, &y );

		y = def_y + ZKN_UTIL_FONTBUTTON_ANIM_PUSH1;
		FONTOAM_SetMat( p_fontoam->p_fontoam, x, y );
		break;
		
	case ZKN_UTIL_BUTTON_FRAME_PUSH2:	// vbVAjQt[
		FONTOAM_GetMat( p_fontoam->p_fontoam, &x, &y );

		y = def_y + ZKN_UTIL_FONTBUTTON_ANIM_PUSH2;
		FONTOAM_SetMat( p_fontoam->p_fontoam, x, y );
		break;
		
	case ZKN_UTIL_BUTTON_FRAME_SELECT:	// I
		FONTOAM_GetMat( p_fontoam->p_fontoam, &x, &y );

		y = def_y + ZKN_UTIL_FONTBUTTON_ANIM_SELECT;
		FONTOAM_SetMat( p_fontoam->p_fontoam, x, y );
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	{^tHgJ[ύX
 *
 *	@param	act				AN^[
 *	@param	p_fontoam		{^tHg
 *	@param	def_y			ftHgYʒu
 *	@param	off_pltt		ItJ[pbgް
 *	@param	on_pltt			IJ[pbgް
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_UTIL_ButtonFontMove_Col( CLACT_WORK_PTR act, ZKN_FONTOAM_DATA* p_fontoam, int def_y, int off_pltt, int on_pltt )
{
	int now_frm;
	
	ZKN_UTIL_ButtonFontMove( 
			act,
			p_fontoam,
			def_y );

	// ݃t[擾
	now_frm = CLACT_AnmFrameGet( act );

	// J[pbgݒ
	if( now_frm < ZKN_UTIL_BUTTON_FRAME_PUSH2 ){
		// off_pltt
		FONTOAM_SetPaletteOffsetAddTransPlttNo( p_fontoam->p_fontoam, off_pltt );
	}else{
		// on_pltt
		FONTOAM_SetPaletteOffsetAddTransPlttNo( p_fontoam->p_fontoam, on_pltt );
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	蔻e[uf[^ݒ
 *
 *	@param	p_tbl		e[u
 *	@param	top			
 *	@param	bottom		
 *	@param	left		
 *	@param	right		E
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_UTIL_HitTblDataSet( TP_HIT_TBL* p_tbl, int top, int bottom, int left, int right )
{
	p_tbl->rect.top = top;
	p_tbl->rect.bottom = bottom;
	p_tbl->rect.left = left;
	p_tbl->rect.right = right;
}


//----------------------------------------------------------------------------
/**
 *	@brief	BGtF[hAEg
 *
 *	@param	p_data		tF[hf[^
 *	@param	p_bg		BGVXe
 *	@param	frm			t[io[
 *	@param	p_scrn		XN[f[^
 *	@param	top_cs		tF[hJn̈ʒu
 *	@param	top_ce		tF[hÏʒu
 *	@param	bottom_cs	tF[hJn̈ʒu
 *	@param	bottom_ce	tF[hÏʒu
 *	@param	count_max	JEgő吔
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_UTIL_BgShutterFadeInit( ZKN_UTIL_BGSHTTER_DADE* p_data, GF_BGL_INI* p_bg, int frm, NNSG2dScreenData* p_scrn, int top_cs, int top_ce, int bottom_cs, int bottom_ce, int count_max )
{
	p_data->p_bg		= p_bg;
	p_data->frm			= frm;
	p_data->p_scrn		= p_scrn;
	p_data->top_start	= top_cs;
	p_data->top_dis		= top_ce - top_cs;
	p_data->bottom_start= bottom_cs;
	p_data->bottom_dis	= bottom_ce - bottom_cs;
	p_data->move_count_max	= count_max;
	p_data->move_count	= 0;
}

//----------------------------------------------------------------------------
/**
 *	@brief	BGVb^[tF[h
 *
 *	@param	p_data	tF[hf[^
 *
 *	@retval	TRUE@	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
BOOL ZKN_UTIL_BgShutterFade( ZKN_UTIL_BGSHTTER_DADE* p_data )
{
	int top_w_size;
	int bottom_w_size;

	
	if( p_data->move_count <= p_data->move_count_max ){

		// XN[N[
		GF_BGL_ScrFill( p_data->p_bg, p_data->frm,
				0, 0, 0, 32, 24, GF_BGL_SCRWRT_PALNL );
		
		// ݃TCY߂
		top_w_size = (p_data->top_dis * p_data->move_count) / p_data->move_count_max;
		bottom_w_size = (p_data->bottom_dis * p_data->move_count) / p_data->move_count_max;
		top_w_size += p_data->top_start;
		bottom_w_size += p_data->bottom_start;
		
		// XN[f[^
		if( top_w_size > 0 ){
			GF_BGL_ScrWriteExpand( p_data->p_bg, p_data->frm,
					0, 0,
					32, top_w_size,
					p_data->p_scrn->rawData,
					0, 32 - top_w_size,
					32, 32 );
		}

		// XN[f[^
		if( (32 - bottom_w_size) > 0 ){
			GF_BGL_ScrWriteExpand( p_data->p_bg, p_data->frm,
					0, 32 - bottom_w_size,
					32, bottom_w_size,
					p_data->p_scrn->rawData,
					0, 0,
					32, 32 );
		}
		
		// XN[f[^]
		GF_BGL_LoadScreenV_Req(p_data->p_bg, p_data->frm );


		p_data->move_count++;

		return FALSE;
	}
	
	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	rbg}bv̈ɐ̖Ozu
 *
 *	@param	p_bmp		rbg}bv̈
 *	@param	num			X^[io[
 *	@param	heap		gpq[v
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_UTIL_PokeListPokeNameBmpMake( GF_BGL_BMPWIN* p_bmp, int num, int heap )
{
	STRBUF*	p_num;		// |Pio[
	STRBUF*	p_name;		// |P


	// pSTRobt@쐬
	p_num = STRBUF_Create( ZKN_POKELIST_POKENAME_NO_NUM, heap );

	// 쐬
	STRBUF_SetNumber( p_num, num, ZKN_POKELIST_POKENAME_NO_KETA,
			NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT );

	// Oobt@쐬
	p_name = ZKN_WT_GetPokeName( num, PM_LANG, heap );

	// 
	GF_STR_PrintColor( p_bmp, FONT_BUTTON, p_num, ZKN_POKELIST_POKENAME_NO_MAT_X, ZKN_POKELIST_POKENAME_MAT_Y, MSG_NO_PUT, ZKN_FOTNOAM_COLOR, NULL );
	GF_STR_PrintColor( p_bmp, FONT_BUTTON, p_name, ZKN_POKELIST_POKENAME_NAME_MAT_X, ZKN_POKELIST_POKENAME_MAT_Y, MSG_NO_PUT, ZKN_FOTNOAM_COLOR, NULL );
		
	// STRBUFj
	STRBUF_Delete( p_num );
	ZKN_WT_DeleteStrBuf( p_name );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PXgrbg}bvf[^쐬
 *
 *	@param	p_drawglb			`O[o
 *	@param	cp_glb				f[^O[o
 *	@param	heap				q[v
 *	@param	mons_no				X^[io[
 *
 *	@return
	// BMP̈j
	ZKN_FONTOAM_DeleteBmp( p_bmp );	ŔjĂ
 */
//-----------------------------------------------------------------------------
GF_BGL_BMPWIN* ZKN_UTIL_PokeListPokeNameTblBmpMake( ZKN_GLB_DRAWDATA* p_drawglb, const ZKN_GLB_DATA* cp_glb, int heap, int mons_no  )
{
	GF_BGL_BMPWIN* p_bmp;	// ݗ̈

	// 񏑂ݗ̈쐬
	p_bmp = ZKN_FONTOAM_GetBmp( p_drawglb->fontoam_sys, ZKN_POKELIST_POKENAME_BMP_SIZE_CX, ZKN_POKELIST_POKENAME_BMP_SIZE_CY );

	// X^[io[ύX
	if( ZKN_GLBDATA_PokeZknModeGet( cp_glb ) == ZKN_MODE_SHINOH ){
		mons_no = PokeZenkokuNo2ShinouNo( mons_no );
	}
	
	// rbg}bv̈ɏ
	ZKN_UTIL_PokeListPokeNameBmpMake( p_bmp, mons_no, heap );

	return p_bmp;
}

//----------------------------------------------------------------------------
/**
 *	@brief	`O[oGAɃ|PXgf[^쐬
 *
 *	@param	p_drawglb	`O[o
 *	@param	cp_glb		O[of[^
 *	@param	heap		q[v
 *	@param	poke_tbl_no	|Pe[uio[iZKN_GLB_DATAj
 *	@param	x			Xge[uW
 *	@param	y			Xge[up
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_UTIL_PokeListPokeNameMakeGlb( ZKN_GLB_DRAWDATA* p_drawglb, const ZKN_GLB_DATA* cp_glb, int heap, int poke_tbl_no, fx32 x, fx32 y )
{
	CLACT_WORK_PTR glb_act;
	CLACT_WORK_PTR glbicon_act;
	ZKN_FONTOAM_INIT fontoam_init;
	GF_BGL_BMPWIN* p_bmp;	// ݗ̈
	CLACT_U_RES_OBJ_PTR pltt_obj;	// pbgvNV擾p
	VecFx32 mat;
	const ZKN_POKELIST_DATA* cp_pokedata;

	//@|Pf[^
	cp_pokedata = ZKN_GLBDATA_PokeListTblGet( cp_glb, poke_tbl_no );
	
	// O[öɂAN^[擾
	glb_act = ZKN_GlbPokeNameTblClactGet( p_drawglb );	
	glbicon_act = ZKN_GlbPokeNameIconClactGet( p_drawglb );
	
	// |PXge[u̍Wݒ
	mat.x = x;
	mat.y = y;
	CLACT_SetMatrix( glb_act, &mat );
	CLACT_SetDrawFlag( glb_act, TRUE );	// \
	
	// ߂܂|PȂACR쐬
	if( cp_pokedata->type == ZKN_POKELIST_TYPE_GET ){
		mat.x = x + ZKN_POKELIST_ICON_X_OFS;
		mat.y = y;
		CLACT_SetMatrix( glbicon_act, &mat );
		CLACT_SetDrawFlag( glbicon_act, TRUE );	// \
	}else{
		CLACT_SetDrawFlag( glbicon_act, FALSE );	// \
	}
	

	// |PAN^[ɎgppbgvNV擾
	pltt_obj = ZKN_GlbPokeNameTblResObjGet( p_drawglb, CLACT_U_PLTT_RES );
		
	// |PAN^[쐬
	fontoam_init.zkn_fontoam = p_drawglb->fontoam_sys;
	fontoam_init.pltt		 = CLACT_U_PlttManagerGetProxy( pltt_obj, NULL );
	fontoam_init.parent		 = glb_act;
	fontoam_init.x			 = -(ZKN_POKELIST_POKENAME_BMP_SIZE_X / 2);
	fontoam_init.y			 = -(ZKN_POKELIST_POKENAME_BMP_SIZE_Y / 2);
	fontoam_init.bg_pri		 = 0;
	fontoam_init.soft_pri	 = 0;
	fontoam_init.draw_area	 = NNS_G2D_VRAM_TYPE_2DMAIN;
	fontoam_init.heap		 = heap;


	// 񏑂ݗ̈쐬
	p_bmp = ZKN_UTIL_PokeListPokeNameTblBmpMake( p_drawglb, cp_glb, heap, cp_pokedata->mons_no );			

	// FONTOAMo^
	fontoam_init.p_bmp = p_bmp;
	ZKN_GlbPokeNameTblSet( p_drawglb, &fontoam_init, 0, cp_pokedata->mons_no );
	// BMP̈j
	ZKN_FONTOAM_DeleteBmp( p_bmp );
}

//----------------------------------------------------------------------------
/**
 *	@brief	\Wݒ
 *
 *	@param	p_drawglb	`O[o
 *	@param	x			W
 *	@param	y			W
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_UTIL_PokeListPokeNameGlbMatrixSet(  ZKN_GLB_DRAWDATA* p_drawglb, int x, int y )
{
	CLACT_WORK_PTR glb_act;
	CLACT_WORK_PTR glbicon_act;
	ZKN_FONTOAM_DATA* p_pokename;
	VecFx32 mat;

	// O[öɂAN^[擾
	glb_act = ZKN_GlbPokeNameTblClactGet( p_drawglb );	
	glbicon_act = ZKN_GlbPokeNameIconClactGet( p_drawglb );
	p_pokename = ZKN_GlbPokeNameTblGet( p_drawglb );
	
	// |PXge[u̍Wݒ
	mat.x = x << FX32_SHIFT;
	mat.y = y << FX32_SHIFT;
	CLACT_SetMatrix( glb_act, &mat );
	
	mat.x += ZKN_POKELIST_ICON_X_OFS;
	CLACT_SetMatrix( glbicon_act, &mat );

	FONTOAM_ReflectParentMat( p_pokename->p_fontoam );	
}


//----------------------------------------------------------------------------
/**
 *	@brief	|POtBbNݒ	ʂ͎
 *
 *	@param	p_draw		`惏[N
 *	@param	p_glb		`O[o
 *	@param	mons_no		X^[io[
 *	@param	dir			
 *	@param	col			J[
 *	@param	x			W
 *	@param	y			W
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_UTIL_PokemonGraphicSet( ZKN_GLB_DRAWDATA* p_draw, ZKN_GLB_DATA* p_glb, int mons_no, int dir, int col, int x, int y )
{
	int monsno = ZKN_GLBDATA_PokeMonsNoGet( p_glb );
	int sex;
	

	// |Pݒ肩`FbN
	
	//@ʎ擾
	sex = ZKN_GLBDATA_SaveData_SexGet( p_glb, monsno, ZUKAN_WORK_SEX_FIRST );
	GF_ASSERT( sex != ZUKAN_WORK_GET_SEX_ERR );	// ܂݂ĂȂ

	
	// |Pݒ
	ZKN_GlbPokemonGraphicSet( p_draw, monsno,
			sex, dir, col, x, y );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|POtBbNݒ@ݒp
 *
 *	@param	p_draw		`惏[N
 *	@param	p_glb		`O[o
 *	@param	mons_no		X^[io[
 *	@param	dir			
 *	@param	x			W
 *	@param	y			W
 *	@param	count		ZUKAN_WORK_SEX_FIRST@ZUKAN_WORK_SEX_SECOND
 *	@param	idx			|PXvCgCfbNX
 *
 *	@retval	ݒ肵ʃio[
 *	@retval	ZUKAN_WORK_GET_SEX_ERR	G[
 */
//-----------------------------------------------------------------------------
u32 ZKN_UTIL_PokemonGraphicSet_FS_Idx( ZKN_GLB_DRAWDATA* p_draw, const ZKN_GLB_DATA* cp_glb, int mons_no, int dir, int x, int y, int count, int idx )
{
	int monsno = ZKN_GLBDATA_PokeMonsNoGet( cp_glb );
	int sex;

	//@ʎ擾
	sex = ZKN_GLBDATA_SaveData_SexGet( cp_glb, monsno, count );

	// ʂݒ
	if( sex != ZUKAN_WORK_GET_SEX_ERR ){
		// |Pݒ
		ZKN_GlbPokemonGraphicSet_Idx( p_draw, monsno,
				sex, dir, PARA_NORMAL, x, y, idx );

	}
	
	return sex;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|POtBbNAm[ݒ
 *
 *	@param	p_draw		`惏[N
 *	@param	p_glb		`O[o
 *	@param	dir			
 *	@param	x			XW
 *	@param	y			YW
 *	@param	count		JEg	i0`27j
 *	@param	idx			XvCgCfbNX
 *
 *	@retval	ݒ肵tH[io[
 *	@retval	ZUKAN_WORK_GET_SEX_ERR	G[
 */
//-----------------------------------------------------------------------------
u32 ZKN_UTIL_PokemonGraphicSet_Anoon_Idx( ZKN_GLB_DRAWDATA* p_draw, const ZKN_GLB_DATA* cp_glb, int dir, int x, int y, int count, int idx )
{
	int form;
	
	form = ZKN_GLBDATA_SaveData_AnoonFormGet( cp_glb, count );
	
	// tHݒ
	if( form != ZUKAN_WORK_GET_SEX_ERR ){

		// |Pݒ
		ZKN_GlbPokemonGraphicSet_Idx( p_draw, MONSNO_ANNOON,
				PARA_UNK, dir, PARA_NORMAL, x, y, idx );
	}
	
	return form;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|POtBbNE~EV|Pݒ
 *
 *	@param	p_draw		`惏[N
 *	@param	p_glb		`O[o
 *	@param	dir			
 *	@param	x			XW
 *	@param	y			YW
 *	@param	count		Ԑ	i0`2j
 *	@param	idx			XvCgzCfbNX 
 *
 *	@retval	ݒ肵GAID
 *	@retval	ZUKAN_WORK_GET_SEX_ERR	G[
 */
//-----------------------------------------------------------------------------
u32 ZKN_UTIL_PokemonGraphicSet_Umiushi_Idx( ZKN_GLB_DRAWDATA* p_draw, const ZKN_GLB_DATA* cp_glb, int dir, int x, int y, int count, int idx )
{
	int area;
	
	area = ZKN_GLBDATA_SaveData_UmiushiAreaGet( cp_glb, count );
	
	// GAݒ
	if( area != ZUKAN_WORK_GET_SEX_ERR ){

		// |Pݒ
/*		ZKN_GlbPokemonGraphicSet_Idx( p_draw, MONS_UMIUSHI,
				PARA_UNK, dir, PARA_NORMAL, x, y, idx );//*/
	}
	
	return area;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|POtBbN~mV|Pݒ
 *
 *	@param	p_draw		`惏[N
 *	@param	p_glb		`O[o
 *	@param	dir			
 *	@param	x			XW
 *	@param	y			YW
 *	@param	count		Ԑ	i0`2j
 *	@param	idx			XvCgzCfbNX 
 *
 *	@retval	ݒ肵GAID
 *	@retval	ZUKAN_WORK_GET_SEX_ERR	G[
 */
//-----------------------------------------------------------------------------
u32 ZKN_UTIL_PokemonGraphicSet_Minomushi_Idx( ZKN_GLB_DRAWDATA* p_draw, const ZKN_GLB_DATA* cp_glb, int dir, int x, int y, int count, int idx )
{
	int area;
	
	area = ZKN_GLBDATA_SaveData_MinomushiAreaGet( cp_glb, count );
	
	// GAݒ
	if( area != ZUKAN_WORK_GET_SEX_ERR ){

		// |Pݒ
/*		ZKN_GlbPokemonGraphicSet_Idx( p_draw, MONS_MINOMUSHI,
				PARA_UNK, dir, PARA_NORMAL, x, y, idx );//*/
	}
	
	return area;
}

//----------------------------------------------------------------------------
/**
 *	@brief	}GMM當擾
 *
 *	@param	data_idx		ްIDX
 *	@param	heap			q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
STRBUF* ZKN_UTIL_ZknGmmGet( int data_idx, int heap )
{
	STRBUF* str;
	MSGDATA_MANAGER* man = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_zkn_dat, heap);

	str = MSGMAN_AllocString( man, data_idx );

	MSGMAN_Delete(man);

	return str;
}





//-----------------------------------------------------------------------------
/**
 *			AvP[VJnCxg
 */
//-----------------------------------------------------------------------------
static BOOL ZKN_EVENT_ZknSysAplStart( ZKN_EVENT_WORK* p_work )
{
	ZKN_PROC_INIT			proc_init;
	ZKN_SYS_APLSTART_EVENT*	p_data = p_work->p_data;
	
	if( p_data->p_apl_data ){
		// vZXɓo^
		proc_init.p_glb_data	= p_data->p_apl_data->p_glb_data;
		proc_init.p_glb_draw	= p_data->p_apl_data->p_glb_draw;
		proc_init.cp_do_func	= p_data->p_apl_data->do_func;
		proc_init.cp_draw_func	= p_data->p_apl_data->draw_func;
		ZKN_PROC_Init( p_data->proc, &proc_init );

		// Cxgo^
		ZKN_EVENT_Init( p_data->event, p_data->p_apl_data->p_event_data, p_data->p_apl_data->event_num );
	}

	if( p_data->p_apl_data_common ){
		// vZXɓo^
		proc_init.p_glb_data	= p_data->p_apl_data_common->p_glb_data;
		proc_init.p_glb_draw	= p_data->p_apl_data_common->p_glb_draw;
		proc_init.cp_do_func	= p_data->p_apl_data_common->do_func;
		proc_init.cp_draw_func	= p_data->p_apl_data_common->draw_func;
		ZKN_PROC_Init( p_data->proc_common, &proc_init );

		// Cxgo^
		ZKN_EVENT_Init( p_data->event_common, p_data->p_apl_data_common->p_event_data, p_data->p_apl_data_common->event_num );
	}

	return TRUE;
}


//-----------------------------------------------------------------------------
/**
 *			vCx[g֐
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
//
/**
 *
 *	@brief	}Ӕj
 *
 *	@param	zkn 
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void DeleteZkn( ZKN_SYS_PTR zkn )
{
	int i;

	// }ӃVXeAvJnCxgf[^j
	ZKN_EVENT_DeleteData( &zkn->event_apl_start_main );
	
	//@Cxgf[^j
	GF_ASSERT(zkn->event_main);
	sys_FreeMemoryEz( zkn->event_main );
	GF_ASSERT(zkn->event_sub);
	sys_FreeMemoryEz( zkn->event_sub );
	GF_ASSERT(zkn->event_main_common);
	sys_FreeMemoryEz( zkn->event_main_common );
	GF_ASSERT(zkn->event_sub_common);
	sys_FreeMemoryEz( zkn->event_sub_common );

	// vZXf[^j
	GF_ASSERT(zkn->main_proc);
	sys_FreeMemoryEz( zkn->main_proc );
	GF_ASSERT(zkn->sub_proc);
	sys_FreeMemoryEz( zkn->sub_proc );
	GF_ASSERT(zkn->main_common_proc);
	sys_FreeMemoryEz( zkn->main_common_proc );
	GF_ASSERT(zkn->sub_common_proc);
	sys_FreeMemoryEz( zkn->sub_common_proc );

	// AvP[Vf[^j
	for( i=0; i<ZKN_SYS_APLMAIN_NUM; i++ ){
		if(ZknAplMainDataDeleteFunc[i]){
			ZknAplMainDataDeleteFunc[i]( &zkn->main_apl_data[ i ] );
		}
	}
	for( i=0; i<ZKN_SYS_APLSUB_NUM; i++ ){
		if(ZknAplSubDataDeleteFunc[i]){
			ZknAplSubDataDeleteFunc[i]( &zkn->sub_apl_data[ i ] );
		}
	}

	// O[of[^j
	ZKN_GLBDATA_Delete( &zkn->glb );
	// `O[of[^j
	ZKN_GlbDrawDataDelete( &zkn->draw_glb );

	sys_FreeMemoryEz( zkn );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	VramBankZbgAbv
 *
 *	@param	none
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void VramBankSet( void )
{
	GF_BGL_DISPVRAM vramSetTable = {
		GX_VRAM_BG_128_B,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
		GX_VRAM_SUB_BG_128_C,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
		GX_VRAM_OBJ_80_EF,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
		GX_VRAM_TEX_0_A,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_0_G				// eNX`pbgXbg
	};
	GF_Disp_SetBank( &vramSetTable );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	OAMZbgAbv
 *
 *	@param	none
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void OamSet( int heap )
{
	// OAM}l[W[̏
	NNS_G2dInitOamManagerModule();

	// LOAM}l[W쐬
	// _pOAM}l[W쐬
	// ō쐬OAM}l[W݂ȂŋL
	REND_OAMInit( 
			OAM_OAM_MAIN_S, OAM_OAM_MAIN_E,	// COAMǗ̈
			OAM_AFF_MAIN_S, OAM_AFF_MAIN_E,		// CʃAtBǗ̈
			OAM_OAM_SUB_S, OAM_OAM_SUB_E,		// TuOAMǗ̈
			OAM_AFF_SUB_S, OAM_AFF_SUB_E,		// TuʃAtBǗ̈
			heap);
	
	// LN^}l[W[
	{
		CHAR_MANAGER_MAKE cm = {
			OAM_CHAR_ENTRY_NUM,
			OAM_CHAR_VRAMTRANS_MAIN_SIZE,
			OAM_CHAR_VRAMTRANS_SUB_SIZE,
		};
		cm.heap = heap;
		
		InitCharManagerReg(&cm, GX_OBJVRAMMODE_CHAR_1D_128K, GX_OBJVRAMMODE_CHAR_1D_32K );
	}
	// pbg}l[W[
	InitPlttManager(OAM_PLTT_ENTRY_NUM, heap);

	// ǂݍ݊Jnʒu
	CharLoadStartAll();
	PlttLoadStartAll();

}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	AvP[VJn
 *
 *	@param	none
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void StartAlp( ZKN_SYS_PTR zkn )
{
	ZKN_EVENT_Init( zkn->event_main, &zkn->event_apl_start_main, 1 );
	zkn->event_key_main = ZKN_SYS_EVENT_MSK_APL_START;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	3Dʐݒ
 *
 *	@param	none
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void setup_3d( void )
{
	// NitroSystem:RcGW̏
	NNS_G3dInit();
	// }gNXX^bN̏
    G3X_InitMtxStack();

	// e`惂[h̐ݒ(VF[hA`GCAX)
    G3X_SetShading(GX_SHADING_TOON);
    G3X_AntiAlias(TRUE);
	G3X_AlphaTest(FALSE, 0);	// At@eXg@@It
	G3X_AlphaBlend(TRUE);		// At@uh@I

	// NAJ[̐ݒ
    G3X_SetClearColor(GX_RGB(0, 0, 0),	// clear color
                      0,				// clear alpha
                      0x7fff,			// clear depth
                      63,				// clear polygon ID
                      FALSE				// fog
                      );

	// WIgGWNKĂ΂Ȃ΂ȂȂ
    G3_SwapBuffers(GX_SORTMODE_AUTO, GX_BUFFERMODE_W);

	// r[|[g̐ݒ
    G3_ViewPort(0, 0, 255, 191);

	// }l[WeNX`C[WXbgwXbgǗł悤ɂ
	// ftHg}l[WɂB
	NNS_GfdInitFrmTexVramManager(1, TRUE);
		
	// }l[Wpbg16KBǗł悤ɂ
	// ftHg}l[WɂB
	NNS_GfdInitFrmPlttVramManager(0x4000, TRUE);
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	RDݒŎgpj
 *
 *	@param	none 
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void putback_3d( void )
{
	NNS_GfdResetFrmTexVramState();
	NNS_GfdResetFrmPlttVramState();
}

