//============================================================================================
/**
 * @file	b_bag_anm.c
 * @bfief	퓬pobO {^
 * @author	Hiroyuki Nakamura
 * @date	05.03.15
 */
//============================================================================================
#include "common.h"

#include "system/palanm.h"
#include "system/msgdata.h"
#include "system/numfont.h"
#include "system/wordset.h"
#include "system/clact_tool.h"
#include "battle/battle_common.h"
/*
#include "system/window.h"
#include "system/fontproc.h"
#include "system/pmfprint.h"
#include "system/buflen.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_b_bag.h"
#include "itemtool/item.h"
*/

#define	B_BAG_ANM_H_GLOBAL
#include "b_bag.h"
#include "b_bag_main.h"
#include "b_bag_anm.h"
//#include "b_bag_bmp.h"
//#include "b_bag_bmp_def.h"



#define	DAT_PX_POCKET1_1	( 0 )
#define	DAT_PY_POCKET1_1	( 0 )
#define	DAT_PX_POCKET1_2	( 0 )
#define	DAT_PY_POCKET1_2	( 6 )
#define	DAT_PX_POCKET1_3	( 0 )
#define	DAT_PY_POCKET1_3	( 12 )
#define	DAT_SX_POCKET1		( 16 )
#define	DAT_SY_POCKET1		( 6 )

#define	DAT_PX_POCKET2_1	( 16 )
#define	DAT_PY_POCKET2_1	( 0 )
#define	DAT_PX_POCKET2_2	( 16 )
#define	DAT_PY_POCKET2_2	( 9 )
#define	DAT_PX_POCKET2_3	( 16 )
#define	DAT_PY_POCKET2_3	( 18 )
#define	DAT_SX_POCKET2		( 16 )
#define	DAT_SY_POCKET2		( 9 )

#define	DAT_PX_LASTITEM_1	( 0 )
#define	DAT_PY_LASTITEM_1	( 32 )
#define	DAT_PX_LASTITEM_2	( 0 )
#define	DAT_PY_LASTITEM_2	( 37 )
#define	DAT_PX_LASTITEM_3	( 0 )
#define	DAT_PY_LASTITEM_3	( 42 )
#define	DAT_SX_LASTITEM		( 22 )
#define	DAT_SY_LASTITEM		( 5 )

#define	DAT_PX_RETURN_1		( 0 )
#define	DAT_PY_RETURN_1		( 18 )
#define	DAT_PX_RETURN_2		( 5 )
#define	DAT_PY_RETURN_2		( 18 )
#define	DAT_PX_RETURN_3		( 10 )
#define	DAT_PY_RETURN_3		( 18 )
#define	DAT_SX_RETURN		( 5 )
#define	DAT_SY_RETURN		( 5 )

#define	DAT_PX_ITEM_1		( 0 )
#define	DAT_PY_ITEM_1		( 47 )
#define	DAT_PX_ITEM_2		( 16 )
#define	DAT_PY_ITEM_2		( 47 )
#define	DAT_PX_ITEM_3		( 0 )
#define	DAT_PY_ITEM_3		( 53 )
#define	DAT_SX_ITEM			( 16 )
#define	DAT_SY_ITEM			( 6 )

#define	DAT_PX_NEXT_1		( 0 )
#define	DAT_PY_NEXT_1		( 27 )
#define	DAT_PX_NEXT_2		( 8 )
#define	DAT_PY_NEXT_2		( 27 )
#define	DAT_PX_NEXT_3		( 16 )
#define	DAT_PY_NEXT_3		( 27 )
#define	DAT_SX_NEXT			( 8 )
#define	DAT_SY_NEXT			( 5 )

#define	DAT_SX_USE			( 32 )
#define	DAT_SY_USE			( 24 )


#define	P1_PAGE1_SCR_PX		( 0 )
#define	P1_PAGE1_SCR_PY		( 1 )
#define	P1_PAGE2_SCR_PX		( 0 )
#define	P1_PAGE2_SCR_PY		( 7 )
#define	P1_PAGE3_SCR_PX		( 0 )
#define	P1_PAGE3_SCR_PY		( 13 )
#define	P1_PAGE4_SCR_PX		( 16 )
#define	P1_PAGE4_SCR_PY		( 1 )
#define	P1_PAGE5_SCR_PX		( 16 )
#define	P1_PAGE5_SCR_PY		( 10 )
#define	P1_LASTITEM_SCR_PX	( 0 )
#define	P1_LASTITEM_SCR_PY	( 19 )
#define	P1_RETURN_SCR_PX	( 27 )
#define	P1_RETURN_SCR_PY	( 19 )

#define	P2_ITEM1_SCR_PX		( 32 )
#define	P2_ITEM1_SCR_PY		( 1 )
#define	P2_ITEM2_SCR_PX		( 32 )
#define	P2_ITEM2_SCR_PY		( 7 )
#define	P2_ITEM3_SCR_PX		( 32 )
#define	P2_ITEM3_SCR_PY		( 13 )
#define	P2_ITEM4_SCR_PX		( 48 )
#define	P2_ITEM4_SCR_PY		( 1 )
#define	P2_ITEM5_SCR_PX		( 48 )
#define	P2_ITEM5_SCR_PY		( 7 )
#define	P2_ITEM6_SCR_PX		( 48 )
#define	P2_ITEM6_SCR_PY		( 13 )
#define	P2_NEXT_SCR_PX		( 32 )
#define	P2_NEXT_SCR_PY		( 19 )
#define	P2_RETURN_SCR_PX	( 59 )
#define	P2_RETURN_SCR_PY	( 19 )

#define	P3_USE_SCR_PX		( 0 )
#define	P3_USE_SCR_PY		( 32 )
#define	P3_RETURN_SCR_PX	( 27 )
#define	P3_RETURN_SCR_PY	( 51 )



typedef struct {
	u8	px;
	u8	py;
	u8	sx;
	u8	sy;
}BUTTON_ANM;

static void BBAG_ScrnCopy( u16 * buf, u16 * scrn, u8 px, u8 py, u8 sx, u8 sy );



static const BUTTON_ANM ButtonScreenAnm[] =
{
	{ P1_PAGE1_SCR_PX, P1_PAGE1_SCR_PY, DAT_SX_POCKET1, DAT_SY_POCKET1 },
	{ P1_PAGE2_SCR_PX, P1_PAGE2_SCR_PY, DAT_SX_POCKET1, DAT_SY_POCKET1 },
	{ P1_PAGE3_SCR_PX, P1_PAGE3_SCR_PY, DAT_SX_POCKET1, DAT_SY_POCKET1 },
	{ P1_PAGE4_SCR_PX, P1_PAGE4_SCR_PY, DAT_SX_POCKET2, DAT_SY_POCKET2 },
	{ P1_PAGE5_SCR_PX, P1_PAGE5_SCR_PY, DAT_SX_POCKET2, DAT_SY_POCKET2 },
	{ P1_LASTITEM_SCR_PX, P1_LASTITEM_SCR_PY, DAT_SX_LASTITEM, DAT_SY_LASTITEM },
	{ P1_RETURN_SCR_PX, P1_RETURN_SCR_PY, DAT_SX_RETURN, DAT_SY_RETURN },

	{ P2_ITEM1_SCR_PX, P2_ITEM1_SCR_PY, DAT_SX_ITEM, DAT_SY_ITEM },
	{ P2_ITEM2_SCR_PX, P2_ITEM2_SCR_PY, DAT_SX_ITEM, DAT_SY_ITEM },
	{ P2_ITEM3_SCR_PX, P2_ITEM3_SCR_PY, DAT_SX_ITEM, DAT_SY_ITEM },
	{ P2_ITEM4_SCR_PX, P2_ITEM4_SCR_PY, DAT_SX_ITEM, DAT_SY_ITEM },
	{ P2_ITEM5_SCR_PX, P2_ITEM5_SCR_PY, DAT_SX_ITEM, DAT_SY_ITEM },
	{ P2_ITEM6_SCR_PX, P2_ITEM6_SCR_PY, DAT_SX_ITEM, DAT_SY_ITEM },
	{ P2_NEXT_SCR_PX, P2_NEXT_SCR_PY, DAT_SX_NEXT, DAT_SY_NEXT },
	{ P2_RETURN_SCR_PX, P2_RETURN_SCR_PY, DAT_SX_RETURN, DAT_SY_RETURN },

	{ P3_USE_SCR_PX, P3_USE_SCR_PY, DAT_SX_USE, DAT_SY_USE },
	{ P3_RETURN_SCR_PX, P3_RETURN_SCR_PY, DAT_SX_RETURN, DAT_SY_RETURN },
};

static const u8 BtnBmpWin_Page1[] = { WIN_P1_PP, 0xff };		// uPPӂv
static const u8 BtnBmpWin_Page2[] = { WIN_P1_ZYOUTAI, 0xff };	// u傤ӂv
static const u8 BtnBmpWin_Page3[] = { WIN_P1_HP, 0xff };		// uHPӂv
static const u8 BtnBmpWin_Page4[] = { WIN_P1_BATTLE, 0xff };	// uƂ悤v
static const u8 BtnBmpWin_Page5[] = { WIN_P1_BALL, 0xff };		// u{[v
static const u8 BtnBmpWin_Last[]  = { WIN_P1_LASTITEM, 0xff };	// uɂǂv
static const u8 BtnBmpWin_Item1[] = { WIN_P2_NAME1, WIN_P2_NUM1, 0xff };
static const u8 BtnBmpWin_Item2[] = { WIN_P2_NAME2, WIN_P2_NUM2, 0xff };
static const u8 BtnBmpWin_Item3[] = { WIN_P2_NAME3, WIN_P2_NUM3, 0xff };
static const u8 BtnBmpWin_Item4[] = { WIN_P2_NAME4, WIN_P2_NUM4, 0xff };
static const u8 BtnBmpWin_Item5[] = { WIN_P2_NAME5, WIN_P2_NUM5, 0xff };
static const u8 BtnBmpWin_Item6[] = { WIN_P2_NAME6, WIN_P2_NUM6, 0xff };
static const u8 BtnBmpWin_Item1_S[] = { WIN_P2_NAME1_S, WIN_P2_NUM1_S, 0xff };
static const u8 BtnBmpWin_Item2_S[] = { WIN_P2_NAME2_S, WIN_P2_NUM2_S, 0xff };
static const u8 BtnBmpWin_Item3_S[] = { WIN_P2_NAME3_S, WIN_P2_NUM3_S, 0xff };
static const u8 BtnBmpWin_Item4_S[] = { WIN_P2_NAME4_S, WIN_P2_NUM4_S, 0xff };
static const u8 BtnBmpWin_Item5_S[] = { WIN_P2_NAME5_S, WIN_P2_NUM5_S, 0xff };
static const u8 BtnBmpWin_Item6_S[] = { WIN_P2_NAME6_S, WIN_P2_NUM6_S, 0xff };
static const u8 BtnBmpWin_Next[] = { WIN_P2_NEXT, 0xff };		// uցv
static const u8 BtnBmpWin_Use[] = {
	WIN_P3_NAME, WIN_P3_NUM, WIN_P3_INFO, WIN_P3_USE, 0xff
};

static const u8 * const ButtonBmpWinIndex[] = {
	BtnBmpWin_Page1,	// uPPӂv
	BtnBmpWin_Page2,	// u傤ӂv
	BtnBmpWin_Page3,	// uHPӂv
	BtnBmpWin_Page4,	// uƂ悤v
	BtnBmpWin_Page5,	// u{[v
	BtnBmpWin_Last,		// uɂǂv
	NULL,				// ߂

	BtnBmpWin_Item1,
	BtnBmpWin_Item2,
	BtnBmpWin_Item3,
	BtnBmpWin_Item4,
	BtnBmpWin_Item5,
	BtnBmpWin_Item6,
	BtnBmpWin_Next,		// uցv
	NULL,				// ߂

	BtnBmpWin_Use,		// uv
	NULL,

	BtnBmpWin_Item1_S,
	BtnBmpWin_Item2_S,
	BtnBmpWin_Item3_S,
	BtnBmpWin_Item4_S,
	BtnBmpWin_Item5_S,
	BtnBmpWin_Item6_S,
};

#define	SWAP_BMP_POS	( BBAG_BTNANM_RET3+1 )




void BattleBag_ButtonScreenMake1( BBAG_WORK * wk, u16 * scrn )
{
	// |Pbg{^ij
	BBAG_ScrnCopy(
		wk->btn_pocket1[0], scrn,
		DAT_PX_POCKET1_1, DAT_PY_POCKET1_1, DAT_SX_POCKET1, DAT_SY_POCKET1 );
	BBAG_ScrnCopy(
		wk->btn_pocket1[1], scrn,
		DAT_PX_POCKET1_2, DAT_PY_POCKET1_2, DAT_SX_POCKET1, DAT_SY_POCKET1 );
	BBAG_ScrnCopy(
		wk->btn_pocket1[2], scrn,
		DAT_PX_POCKET1_3, DAT_PY_POCKET1_3, DAT_SX_POCKET1, DAT_SY_POCKET1 );

	// |Pbg{^iEj
	BBAG_ScrnCopy(
		wk->btn_pocket2[0], scrn,
		DAT_PX_POCKET2_1, DAT_PY_POCKET2_1, DAT_SX_POCKET2, DAT_SY_POCKET2 );
	BBAG_ScrnCopy(
		wk->btn_pocket2[1], scrn,
		DAT_PX_POCKET2_2, DAT_PY_POCKET2_2, DAT_SX_POCKET2, DAT_SY_POCKET2 );
	BBAG_ScrnCopy(
		wk->btn_pocket2[2], scrn,
		DAT_PX_POCKET2_3, DAT_PY_POCKET2_3, DAT_SX_POCKET2, DAT_SY_POCKET2 );

	// ŌɎgACe
	BBAG_ScrnCopy(
		wk->btn_lastitem[0], scrn,
		DAT_PX_LASTITEM_1, DAT_PY_LASTITEM_1, DAT_SX_LASTITEM, DAT_SY_LASTITEM );
	BBAG_ScrnCopy(
		wk->btn_lastitem[1], scrn,
		DAT_PX_LASTITEM_2, DAT_PY_LASTITEM_2, DAT_SX_LASTITEM, DAT_SY_LASTITEM );
	BBAG_ScrnCopy(
		wk->btn_lastitem[2], scrn,
		DAT_PX_LASTITEM_3, DAT_PY_LASTITEM_3, DAT_SX_LASTITEM, DAT_SY_LASTITEM );

	// ߂{^
	BBAG_ScrnCopy(
		wk->btn_return[0], scrn,
		DAT_PX_RETURN_1, DAT_PY_RETURN_1, DAT_SX_RETURN, DAT_SY_RETURN );
	BBAG_ScrnCopy(
		wk->btn_return[1], scrn,
		DAT_PX_RETURN_2, DAT_PY_RETURN_2, DAT_SX_RETURN, DAT_SY_RETURN );
	BBAG_ScrnCopy(
		wk->btn_return[2], scrn,
		DAT_PX_RETURN_3, DAT_PY_RETURN_3, DAT_SX_RETURN, DAT_SY_RETURN );

	// ACe
	BBAG_ScrnCopy(
		wk->btn_item[0], scrn, DAT_PX_ITEM_1, DAT_PY_ITEM_1, DAT_SX_ITEM, DAT_SY_ITEM );
	BBAG_ScrnCopy(
		wk->btn_item[1], scrn, DAT_PX_ITEM_2, DAT_PY_ITEM_2, DAT_SX_ITEM, DAT_SY_ITEM );
	BBAG_ScrnCopy(
		wk->btn_item[2], scrn, DAT_PX_ITEM_3, DAT_PY_ITEM_3, DAT_SX_ITEM, DAT_SY_ITEM );

	// 
	BBAG_ScrnCopy(
		wk->btn_next[0], scrn, DAT_PX_NEXT_1, DAT_PY_NEXT_1, DAT_SX_NEXT, DAT_SY_NEXT );
	BBAG_ScrnCopy(
		wk->btn_next[1], scrn, DAT_PX_NEXT_2, DAT_PY_NEXT_2, DAT_SX_NEXT, DAT_SY_NEXT );
	BBAG_ScrnCopy(
		wk->btn_next[2], scrn, DAT_PX_NEXT_3, DAT_PY_NEXT_3, DAT_SX_NEXT, DAT_SY_NEXT );
}

void BattleBag_ButtonScreenMake2( BBAG_WORK * wk, u16 * scrn )
{
	memcpy( wk->btn_use[0], scrn, 32*24*2 );
}
void BattleBag_ButtonScreenMake3( BBAG_WORK * wk, u16 * scrn )
{
	memcpy( wk->btn_use[1], scrn, 32*24*2 );
}
void BattleBag_ButtonScreenMake4( BBAG_WORK * wk, u16 * scrn )
{
	memcpy( wk->btn_use[2], scrn, 32*24*2 );
}


static void BBAG_ScrnCopy( u16 * buf, u16 * scrn, u8 px, u8 py, u8 sx, u8 sy )
{
	u16	i, j;

	for( i=0; i<sy; i++ ){
		for( j=0; j<sx; j++ ){
			buf[i*sx+j] = scrn[ (py+i)*32 + px+j ];
		}
	}
}


static u16 * BBAG_ButtonScreenBufGet( BBAG_WORK * wk, u8 id, u8 num )
{
	switch( id ){
	case BBAG_BTNANM_PAGE1:
	case BBAG_BTNANM_PAGE2:
	case BBAG_BTNANM_PAGE3:
		return wk->btn_pocket1[num];

	case BBAG_BTNANM_PAGE4:
	case BBAG_BTNANM_PAGE5:
		return wk->btn_pocket2[num];

	case BBAG_BTNANM_LAST:
		return wk->btn_lastitem[num];

	case BBAG_BTNANM_RET1:
	case BBAG_BTNANM_RET2:
	case BBAG_BTNANM_RET3:
		return wk->btn_return[num];

	case BBAG_BTNANM_ITEM1:
	case BBAG_BTNANM_ITEM2:
	case BBAG_BTNANM_ITEM3:
	case BBAG_BTNANM_ITEM4:
	case BBAG_BTNANM_ITEM5:
	case BBAG_BTNANM_ITEM6:
		return wk->btn_item[num];

	case BBAG_BTNANM_NEXT:
		return wk->btn_next[num];

	case BBAG_BTNANM_USE:
		return wk->btn_use[num];
	}
	return NULL;
}

static void BBAG_ButtonScreenWrite( BBAG_WORK * wk, u8 id, u8 anm )
{
	u16 * buf = BBAG_ButtonScreenBufGet( wk, id, anm );
	GF_BGL_ScrWrite(
		wk->bgl, GF_BGL_FRAME2_S, buf,
		ButtonScreenAnm[id].px, ButtonScreenAnm[id].py,
		ButtonScreenAnm[id].sx, ButtonScreenAnm[id].sy );
	GF_BGL_LoadScreenV_Req( wk->bgl, GF_BGL_FRAME2_S );
}

static void BBAG_ButtonBmpWinShift( BBAG_WORK * wk, u8 id, u8 anm )
{
	const u8 * tbl;
	u16	i;
	u8	dir, ofs;

	if( id >= BBAG_BTNANM_ITEM1 && id <= BBAG_BTNANM_ITEM6 && wk->p2_swap == 0 ){
		tbl = ButtonBmpWinIndex[SWAP_BMP_POS+id-BBAG_BTNANM_ITEM1];
	}else{
		tbl = ButtonBmpWinIndex[id];
	}
	if( tbl == NULL ){ return; }

	switch( anm ){
	case 0:
	case 2:
		dir = GF_BGL_BMPWIN_SHIFT_D;
		ofs = 1;
		break;
	case 1:
		dir = GF_BGL_BMPWIN_SHIFT_U;
		ofs = 2;
		break;
	}

	for( i=0; i<8; i++ ){
		if( tbl[i] == 0xff ){ break; }
		GF_BGL_BmpWinShift( &wk->add_win[tbl[i]], dir, ofs, 0 );
		GF_BGL_BmpWinOnVReq( &wk->add_win[tbl[i]] );
	}
}

static void BBAG_ButtonObjMove( BBAG_WORK * wk, u8 id, u8 anm )
{
	CATS_ACT_PTR cap;
	u8	i;

	if( id >= BBAG_BTNANM_ITEM1 && id <= BBAG_BTNANM_ITEM6 ){
		cap = wk->cap[id-BBAG_BTNANM_ITEM1];
	}else if( id == BBAG_BTNANM_USE ){
		for( i=0; i<6; i++ ){
			cap = wk->cap[i];
			if( CATS_ObjectEnableGetCap(cap) != 0 ){
				break;
			}
		}
	}else{
		return;
	}

	switch( anm ){
	case 0:
	case 2:
		CATS_ObjectPosMoveCap( cap, 0, 1 );
		break;
	case 1:
		CATS_ObjectPosMoveCap( cap, 0, -2 );
		break;
	}
}


void BattleBag_ButtonAnmInit( BBAG_WORK * wk, u8 id, u8 mode )
{
	wk->btn_seq  = 0;
	wk->btn_cnt  = 0;
	wk->btn_id   = id;
	wk->btn_mode = mode;
	wk->btn_flg  = 1;
}

void BattleBag_ButtonAnmMain( BBAG_WORK * wk )
{
	if( wk->btn_flg == 0 ){ return; }

	switch( wk->btn_seq ){
	case 0:
		BBAG_ButtonScreenWrite( wk, wk->btn_id, 1 );
		BBAG_ButtonBmpWinShift( wk, wk->btn_id, 1 );
		BBAG_ButtonObjMove( wk, wk->btn_id, 1 );
		wk->btn_cnt = 0;
		wk->btn_seq = 1;
		break;

	case 1:
		if( wk->btn_cnt < 1 ){
			wk->btn_cnt++;
			return;
		}
		BBAG_ButtonScreenWrite( wk, wk->btn_id, 2 );
		BBAG_ButtonBmpWinShift( wk, wk->btn_id, 2 );
		BBAG_ButtonObjMove( wk, wk->btn_id, 2 );
		wk->btn_cnt = 0;
		wk->btn_seq = 2;
		break;

	case 2:
		if( wk->btn_mode == BBAG_BTNANM_MODE_CHG ){
			wk->btn_flg = 0;
		}else{
			if( wk->btn_cnt < 1 ){
				wk->btn_cnt++;
				return;
			}
			BBAG_ButtonScreenWrite( wk, wk->btn_id, 0 );
			BBAG_ButtonBmpWinShift( wk, wk->btn_id, 0 );
			BBAG_ButtonObjMove( wk, wk->btn_id, 0 );
			wk->btn_cnt = 0;
			wk->btn_seq = 3;
		}
		break;

	case 3:
		wk->btn_flg = 0;
		break;
	}
}

void BattleBag_ButtonPageScreenInit( BBAG_WORK * wk, u8 page )
{
	switch( page ){
	case BBAG_PAGE_POCKET:	// |PbgIy[W
		BBAG_ButtonScreenWrite( wk, BBAG_BTNANM_PAGE1, 0 );
		BBAG_ButtonScreenWrite( wk, BBAG_BTNANM_PAGE2, 0 );
		BBAG_ButtonScreenWrite( wk, BBAG_BTNANM_PAGE3, 0 );
		BBAG_ButtonScreenWrite( wk, BBAG_BTNANM_PAGE4, 0 );
		BBAG_ButtonScreenWrite( wk, BBAG_BTNANM_PAGE5, 0 );
		BBAG_ButtonScreenWrite( wk, BBAG_BTNANM_LAST, 0 );
		BBAG_ButtonScreenWrite( wk, BBAG_BTNANM_RET1, 0 );
		break;

	case BBAG_PAGE_MAIN:	// ACeIy[W
		BBAG_ButtonScreenWrite( wk, BBAG_BTNANM_ITEM1, 0 );
		BBAG_ButtonScreenWrite( wk, BBAG_BTNANM_ITEM2, 0 );
		BBAG_ButtonScreenWrite( wk, BBAG_BTNANM_ITEM3, 0 );
		BBAG_ButtonScreenWrite( wk, BBAG_BTNANM_ITEM4, 0 );
		BBAG_ButtonScreenWrite( wk, BBAG_BTNANM_ITEM5, 0 );
		BBAG_ButtonScreenWrite( wk, BBAG_BTNANM_ITEM6, 0 );
		BBAG_ButtonScreenWrite( wk, BBAG_BTNANM_NEXT, 0 );
		BBAG_ButtonScreenWrite( wk, BBAG_BTNANM_RET2, 0 );
		break;

	case BBAG_PAGE_ITEM:	// ACegpy[W
		BBAG_ButtonScreenWrite( wk, BBAG_BTNANM_USE, 0 );
		BBAG_ButtonScreenWrite( wk, BBAG_BTNANM_RET3, 0 );
	}
}
