//============================================================================================
/**
 * @file	b_bag_item.c
 * @bfief	퓬pobO ACe֘A
 * @author	Hiroyuki Nakamura
 * @date	05.02.10
 */
//============================================================================================
#include "common.h"
#include "system/palanm.h"
//#include "system/window.h"
//#include "system/fontproc.h"
#include "system/msgdata.h"
#include "system/numfont.h"
#include "system/wordset.h"
#include "system/clact_tool.h"
//#include "system/pmfprint.h"
//#include "system/buflen.h"
#include "battle/battle_common.h"
#include "itemtool/myitem.h"
#include "itemtool/item.h"

#define	B_BAG_ITEM_H_GLOBAL
#include "b_bag.h"
#include "b_bag_main.h"
#include "b_bag_item.h"







//--------------------------------------------------------------------------------------------
/**
 * OgpACe`FbN
 *
 * @param	wk		[N
 *
 * @retval	"TRUE = "
 * @retval	"FALSE = Ȃ"
 */
//--------------------------------------------------------------------------------------------
u8 BattleBag_UsedItemChack( BBAG_WORK * wk )
{
	if( wk->dat->used_item == 0 ){ return FALSE; }

	if( MyItem_CheckItem( wk->dat->myitem, wk->dat->used_item, 1, wk->dat->heap ) == FALSE ){
		wk->dat->used_item = 0;
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------------------------------
/**
 * ACe퓬|PbgɐU蕪
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static const u8 PocketNum[] = {
	4, 3, 2, 1, 0
};

void BattleBag_PocketInit( BBAG_WORK * wk )
{
	MINEITEM * item;
	u32	i, j, k;
	s32	prm;

	for( i=0; i<BAG_POKE_MAX; i++ ){
		j = 0;
		while(1){
			item = MyItem_PosItemGet( wk->dat->myitem, i, j );
			if( item == NULL ){ break; }
			if( !( item->id == 0 || item->no == 0 ) ){
				prm = ItemParamGet( item->id, ITEM_PRM_BTL_POCKET, wk->dat->heap );
				for( k=0; k<5; k++ ){
					if( ( prm & (1<<k) ) == 0 ){ continue; }
					wk->pocket[ PocketNum[k] ][wk->item_max[ PocketNum[k] ]] = *item;
					wk->item_max[ PocketNum[k] ]++;
				}
			}
			j++;
		}
	}

	for( i=0; i<5; i++ ){
		wk->scr_max[i] = wk->item_max[i] / 6;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * wʒuɃACe邩
 *
 * @param	wk		[N
 * @param	pos		ʒuiO`Tj
 *
 * @retval	" = ACeԍ"
 * @retval	"Ȃ = 0"
 */
//--------------------------------------------------------------------------------------------
u16 BattleBag_PosItemCheck( BBAG_WORK * wk, u32 pos )
{
	if( wk->pocket[wk->poke_id][wk->dat->item_scr[wk->poke_id]*6+pos].id != 0 &&
		wk->pocket[wk->poke_id][wk->dat->item_scr[wk->poke_id]*6+pos].no != 0 ){
		return wk->pocket[wk->poke_id][wk->dat->item_scr[wk->poke_id]*6+pos].id;
	}
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ACe@\擾
 *
 * @param	wk		[N
 *
 * @return	ACe@\
 */
//--------------------------------------------------------------------------------------------
u8 BattleBag_ItemUseCheck( BBAG_WORK * wk )
{
	return (u8)ItemParamGet( wk->dat->ret_item, ITEM_PRM_BATTLE, wk->dat->heap );
}
