//============================================================================================
/**
 * @file	b_bag_main.c
 * @bfief	퓬pobO
 * @author	Hiroyuki Nakamura
 * @date	05.02.10
 */
//============================================================================================
#include "common.h"
#include "gflib/touchpanel.h"
#include "system/lib_pack.h"
#include "system/palanm.h"
#include "system/window.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/fontproc.h"
#include "system/msgdata.h"
#include "system/numfont.h"
#include "system/wordset.h"
#include "system/font_arc.h"
#include "system/snd_tool.h"
#include "battle/battle_common.h"
#include "battle/fight_tool.h"
#include "battle/server_tool.h"
#include "battle/battle_server.h"
#include "application/app_tool.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_b_bag.h"
#include "itemtool/myitem.h"
#include "itemtool/itemuse_def.h"

/*
#include "system/procsys.h"
#include "system/clact_tool.h"
#include "poketool/pokeparty.h"
#include "poketool/waza_tool.h"
#include "application/p_status.h"
*/

#define	B_BAG_H_GLOBAL
#define	B_BAG_MAIN_H_GLOBAL
#include "b_bag.h"
#include "b_bag_main.h"
#include "b_bag_bmp.h"
#include "b_bag_item.h"
#include "b_bag_obj.h"
#include "b_bag_anm.h"
#include "b_bag_bmp_def.h"
#include "b_bag_gra.naix"



//============================================================================================
//	萔`
//============================================================================================
enum {
	SEQ_BBAG_INIT = 0,		// 
	SEQ_BBAG_POCKET,		// |PbgI
	SEQ_BBAG_ITEM,			// ACeI
	SEQ_BBAG_USE,			// ACegp

	SEQ_BBAG_PAGE1_CHG,		// |PbgI
	SEQ_BBAG_PAGE2_CHG,		// ACeI
	SEQ_BBAG_PAGE3_CHG,		// ACegp

	SEQ_BBAG_ITEMSEL_NEXT,	// ̃ACey[W

	SEQ_BBAG_ERR,			// G[bZ[WI҂
	SEQ_BBAG_MSG_WAIT,		// bZ[W\
	SEQ_BBAG_TRG_WAIT,		// gK[EFCg

	SEQ_BBAG_BUTTON_WAIT,	// {^AjI҂

	SEQ_BBAG_ENDSET,		// ItF[hZbg
	SEQ_BBAG_END			// I
};

#define	TMP_MSG_BUF_SIZ		( 512 )		// e|bZ[WTCY


//============================================================================================
//	vg^Cv錾
//============================================================================================
static void BattleBag_Main( TCB_PTR tcb, void * work );

static u8 BBAG_SeqInit( BBAG_WORK * wk );
static u8 BBAG_SeqPokeSelect( BBAG_WORK * wk );
static u8 BBAG_SeqItemSelect( BBAG_WORK * wk );
static u8 BBAG_SeqUseSelect( BBAG_WORK * wk );
static u8 BBAG_SeqPage1Chg( BBAG_WORK * wk );
static u8 BBAG_SeqPage2Chg( BBAG_WORK * wk );
static u8 BBAG_SeqPage3Chg( BBAG_WORK * wk );
static u8 BBAG_SeqItemSelNext( BBAG_WORK * wk );
static u8 BBAG_SeqError( BBAG_WORK * wk );
static u8 BBAG_SeqMsgWait( BBAG_WORK * wk );
static u8 BBAG_SeqTrgWait( BBAG_WORK * wk );
static u8 BBAG_SeqButtonWait( BBAG_WORK * wk );
static u8 BBAG_SeqEndSet( BBAG_WORK * wk );
static u8 BBAG_SeqEnd( TCB_PTR tcb, BBAG_WORK * wk );

static void BBAG_VramInit(void);
static void BBAG_BgInit( BBAG_WORK * wk );
static void BBAG_BgExit( GF_BGL_INI * ini );
static void BBAG_BgGraphicSet( BBAG_WORK * wk );
static void BBAG_MsgManSet( BBAG_WORK * wk );
static void BBAG_MsgManExit( BBAG_WORK * wk );
static u8 BBAG_ItemUse( BBAG_WORK * wk );

static void BBAG_PageChgBgScroll( BBAG_WORK * wk, u8 page );
static void BBAG_PageChange( BBAG_WORK * wk, u8 next_page );
static int BBAG_TPCheck( BBAG_WORK * wk, const RECT_HIT_TBL * tbl );


//============================================================================================
//	O[oϐ
//============================================================================================
// |PbgIʂ̃^b`plW
static const RECT_HIT_TBL Page1_HitRect[] =
{
	{  1*8,  7*8-1,  0*8, 16*8-1 },	// PP񕜃|Pbg
	{  7*8, 13*8-1,  0*8, 16*8-1 },	// ԉ񕜃|Pbg
	{ 13*8, 19*8-1,  0*8, 16*8-1 },	// HP񕜃|Pbg
	{  1*8, 10*8-1, 16*8, 32*8-1 },	// 퓬p|Pbg
	{ 10*8, 19*8-1, 16*8, 32*8-1 },	// {[|Pbg
	{ 19*8, 24*8-1,  0*8, 26*8-1 },	// ŌɎgp
	{ 19*8, 24*8-1, 27*8, 32*8-1 },	// ߂
	{ RECT_HIT_END, 0, 0, 0 }
};

// ACeIʂ̃^b`plW
static const RECT_HIT_TBL Page2_HitRect[] =
{
	{  1*8,  7*8-1,  0*8, 16*8-1 },	// ACeP
	{  7*8, 13*8-1,  0*8, 16*8-1 },	// ACeQ
	{ 13*8, 19*8-1,  0*8, 16*8-1 },	// ACeR
	{  1*8,  7*8-1, 16*8, 32*8-1 },	// ACeS
	{  7*8, 13*8-1, 16*8, 32*8-1 },	// ACeT
	{ 13*8, 19*8-1, 16*8, 32*8-1 },	// ACeU
	{ 19*8, 24*8-1,  0*8,  8*8-1 },	// 
	{ 19*8, 24*8-1, 27*8, 32*8-1 },	// ߂
	{ RECT_HIT_END, 0, 0, 0 }
};

// ACeIʂ̃^b`plW
static const RECT_HIT_TBL Page3_HitRect[] =
{
	{  0*8, 18*8-1,  0*8, 32*8-1 },	// gi͈͂Pj
	{ 18*8, 24*8-1,  0*8, 26*8-1 },	// gi͈͂Qj
	{ 19*8, 24*8-1, 27*8, 32*8-1 },	// ߂
	{ RECT_HIT_END, 0, 0, 0 }
};



//--------------------------------------------------------------------------------------------
/**
 * 퓬pobO^XNǉ
 *
 * @param	dat		obOf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BattleBag_TaskAdd( BBAG_DATA * dat )
{
	BBAG_WORK * wk;

	wk = TCB_GetWork( PMDS_taskAdd(BattleBag_Main,sizeof(BBAG_WORK),100,dat->heap) );

	memset( wk, 0, sizeof(BBAG_WORK) );
	wk->dat = dat;
	wk->bgl = BattleWorkGF_BGL_INIGet( dat->bw );
	wk->pfd = BattleWorkPfdGet( dat->bw );
	wk->seq = SEQ_BBAG_INIT;

//	wk->dat->ret_item = 0;
/*
	wk->page = BPLIST_PAGE_SELECT;
	wk->init_poke = dat->sel_poke;
*/

/** Ƃ肠 **/
	{
		u32	i;

		for( i=0; i<5; i++ ){
			wk->dat->item_pos[i] = 0;
			wk->dat->item_scr[i] = 0;
		}
		wk->dat->used_item = 0;
		wk->dat->used_page = 0;
	}

/** fobO **/
//	wk->dat->myitem = MyItem_AllocWork( wk->dat->heap );
//	Debug_MyItem_MakeBag( wk->dat->myitem, wk->dat->heap );
}

//--------------------------------------------------------------------------------------------
/**
 * C^XN
 *
 * @param	tcb
 * @param	work
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BattleBag_Main( TCB_PTR tcb, void * work )
{
	BBAG_WORK * wk = (BBAG_WORK *)work;

	switch( wk->seq ){
	case SEQ_BBAG_INIT:		// 
		wk->seq = BBAG_SeqInit( wk );
		break;

	case SEQ_BBAG_POCKET:	// |PbgI
		wk->seq = BBAG_SeqPokeSelect( wk );
		break;

	case SEQ_BBAG_ITEM:		// ACeI
		wk->seq = BBAG_SeqItemSelect( wk );
		break;

	case SEQ_BBAG_USE:		// ACegp
		wk->seq = BBAG_SeqUseSelect( wk );
		break;

	case SEQ_BBAG_PAGE1_CHG:	// |PbgI
		wk->seq = BBAG_SeqPage1Chg( wk );
		break;
	
	case SEQ_BBAG_PAGE2_CHG:	// ACeI
		wk->seq = BBAG_SeqPage2Chg( wk );
		break;

	case SEQ_BBAG_PAGE3_CHG:	// ACegp
		wk->seq = BBAG_SeqPage3Chg( wk );
		break;

	case SEQ_BBAG_ITEMSEL_NEXT:	// ̃ACey[W
		wk->seq = BBAG_SeqItemSelNext( wk );
		break;

	case SEQ_BBAG_ERR:			// G[bZ[WI҂
		wk->seq = BBAG_SeqError( wk );
		break;

	case SEQ_BBAG_MSG_WAIT:		// bZ[W\
		wk->seq = BBAG_SeqMsgWait( wk );
		break;

	case SEQ_BBAG_TRG_WAIT:		// gK[EFCg
		wk->seq = BBAG_SeqTrgWait( wk );
		break;

	case SEQ_BBAG_BUTTON_WAIT:	// {^AjI҂
		wk->seq = BBAG_SeqButtonWait( wk );
		break;

	case SEQ_BBAG_ENDSET:		// ItF[hZbg
		wk->seq = BBAG_SeqEndSet( wk );
		break;

	case SEQ_BBAG_END:		// I
		if( BBAG_SeqEnd( tcb, wk ) == TRUE ){
			return;
		}
	}

	BattleBag_ButtonAnmMain( wk );
	CATS_Draw( wk->crp );
}

//--------------------------------------------------------------------------------------------
/**
 * V[PX
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 BBAG_SeqInit( BBAG_WORK * wk )
{
	G2S_BlendNone();

	BBAG_VramInit();
	BBAG_BgInit( wk );
	BBAG_BgGraphicSet( wk );
	BBAG_MsgManSet( wk );

	FontProc_LoadFont( FONT_BUTTON, wk->dat->heap );

	BattleBag_PocketInit( wk );

	BattleBag_BmpInit( wk );
	BattleBag_BmpWrite( wk, wk->page );

	BattleBag_ObjInit( wk );
	BattleBag_PageObjSet( wk, wk->page );

	PaletteFadeReq( wk->pfd, PF_BIT_SUB_ALL, 0xffff, 0, 16, 0, 0 );

	return SEQ_BBAG_POCKET;

/*
	BPL_PokeDataMake( wk );

	BPL_PokePlateSet( wk );
*/
}

//--------------------------------------------------------------------------------------------
/**
 * y[WP̃Rg[V[PX
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 BBAG_SeqPokeSelect( BBAG_WORK * wk )
{
	if( PaletteFadeCheck( wk->pfd ) != 0 ){ return SEQ_BBAG_POCKET; }
/*
	if( sys.trg & PAD_BUTTON_A ){
		PaletteFadeReq( wk->pfd, PF_BIT_SUB_ALL, 0xffff, 0, 0, 16, 0 );
		return SEQ_BBAG_END;
	}
*/

	{
		int	ret = BBAG_TPCheck( wk, Page1_HitRect );

		switch( ret ){
		case BBAG_POKE_PPRCV:		// PP񕜃|Pbg
		case BBAG_POKE_STRCV:		// ԉ񕜃|Pbg
		case BBAG_POKE_HPRCV:		// HP񕜃|Pbg
		case BBAG_POKE_BATTLE:		// 퓬p|Pbg
		case BBAG_POKE_BALL:		// {[|Pbg
			wk->poke_id = (u8)ret;
			wk->ret_seq = SEQ_BBAG_PAGE2_CHG;
			BattleBag_ButtonAnmInit(
				wk, BBAG_BTNANM_PAGE1+ret-BBAG_POKE_PPRCV, BBAG_BTNANM_MODE_CHG );
			return SEQ_BBAG_BUTTON_WAIT;

		case BBAG_P1_LASTITEM:		// ŌɎgp
			if( wk->dat->used_item != 0 ){
				wk->poke_id = wk->dat->used_page;
				wk->ret_seq = SEQ_BBAG_PAGE3_CHG;
				BattleBag_ButtonAnmInit( wk, BBAG_BTNANM_LAST, BBAG_BTNANM_MODE_CHG );
			}else{
				wk->ret_seq = SEQ_BBAG_POCKET;
				BattleBag_ButtonAnmInit( wk, BBAG_BTNANM_LAST, BBAG_BTNANM_MODE_END );
			}
			return SEQ_BBAG_BUTTON_WAIT;

		case BBAG_P1_RETURN:		// ߂
			wk->dat->ret_item = 0;
			wk->dat->ret_page = BBAG_POKE_MAX;
			BattleBag_ButtonAnmInit( wk, BBAG_BTNANM_RET1, BBAG_BTNANM_MODE_CHG );
			return SEQ_BBAG_ENDSET;
		}
	}

	return SEQ_BBAG_POCKET;
}

//--------------------------------------------------------------------------------------------
/**
 * y[WQ̃Rg[V[PX
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 BBAG_SeqItemSelect( BBAG_WORK * wk )
{
	{
		int	ret = BBAG_TPCheck( wk, Page2_HitRect );

		switch( ret ){
		case 0:		// ACeP
		case 1:		// ACeQ
		case 2:		// ACeR
		case 3:		// ACeS
		case 4:		// ACeT
		case 5:		// ACeU
			if( BattleBag_PosItemCheck( wk, ret ) == 0 ){
				wk->ret_seq = SEQ_BBAG_ITEM;
				BattleBag_ButtonAnmInit( wk, BBAG_BTNANM_ITEM1+ret, BBAG_BTNANM_MODE_END );
			}else{
				wk->dat->item_pos[wk->poke_id] = (u8)ret;
				wk->ret_seq = SEQ_BBAG_PAGE3_CHG;
				BattleBag_ButtonAnmInit( wk, BBAG_BTNANM_ITEM1+ret, BBAG_BTNANM_MODE_CHG );
			}
			return SEQ_BBAG_BUTTON_WAIT;

		case 6:		// 
			wk->ret_seq = SEQ_BBAG_ITEMSEL_NEXT;
			BattleBag_ButtonAnmInit( wk, BBAG_BTNANM_NEXT, BBAG_BTNANM_MODE_END );
			return SEQ_BBAG_BUTTON_WAIT;

		case 7:		// ߂
			wk->ret_seq = SEQ_BBAG_PAGE1_CHG;
			BattleBag_ButtonAnmInit( wk, BBAG_BTNANM_RET2, BBAG_BTNANM_MODE_CHG );
			return SEQ_BBAG_BUTTON_WAIT;
		}
	}

	return SEQ_BBAG_ITEM;
}

static u8 BBAG_SeqItemSelNext( BBAG_WORK * wk )
{
	wk->dat->item_pos[wk->poke_id] = 0;
	wk->dat->item_scr[wk->poke_id]++;
	if( wk->dat->item_scr[wk->poke_id] > wk->scr_max[wk->poke_id] ){
		wk->dat->item_scr[wk->poke_id] = 0;
	}
	BattleBag_Page2_StrItemPut( wk );
	BattleBag_Page2_StrPageNumPut( wk );
	BattleBag_PageObjSet( wk, wk->page );
	return SEQ_BBAG_ITEM;
}


//--------------------------------------------------------------------------------------------
/**
 * y[WR̃Rg[V[PX
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 BBAG_SeqUseSelect( BBAG_WORK * wk )
{
	{
		int	ret = BBAG_TPCheck( wk, Page3_HitRect );

		switch( ret ){
		case 0:		// gi͈͂Pj
		case 1:		// gi͈͂Qj
			wk->dat->ret_item = BattleBag_PosItemCheck( wk, wk->dat->item_pos[wk->poke_id] );
			wk->dat->ret_page = wk->poke_id;
			BattleBag_ButtonAnmInit( wk, BBAG_BTNANM_USE, BBAG_BTNANM_MODE_END );
			return BBAG_ItemUse( wk );

		case 2:		// ߂
			wk->ret_seq = SEQ_BBAG_PAGE2_CHG;
			BattleBag_ButtonAnmInit( wk, BBAG_BTNANM_RET3, BBAG_BTNANM_MODE_CHG );
			return SEQ_BBAG_BUTTON_WAIT;
		}
	}

	return SEQ_BBAG_USE;
}

static u8 BBAG_ItemUse( BBAG_WORK * wk )
{
	if( wk->poke_id == BBAG_POKE_BATTLE ){
		BBAG_DATA * dat;
		int	smn;
		
		dat = wk->dat;
		smn = BattleBag_SelMonsNoGet( wk );
		
		if( BattleWorkStatusRecover(dat->bw,dat->client_no,smn,0,dat->ret_item) == TRUE ){
			MyItem_SubItem( dat->myitem, dat->ret_item, 1, dat->heap );
			wk->ret_seq = SEQ_BBAG_ENDSET;
			BattleBag_ItemUseMsgSet( wk );
		}else{
			wk->ret_seq = SEQ_BBAG_ERR;
			MSGMAN_GetString( wk->mman, mes_b_bag_m01, wk->msg_buf );
		}
		BattleBag_TalkMsgSet( wk );
		return 	SEQ_BBAG_MSG_WAIT;
	}
	return SEQ_BBAG_ENDSET;
}

static u8 BBAG_SeqPage1Chg( BBAG_WORK * wk )
{
	BBAG_PageChange( wk, BBAG_PAGE_POCKET );
	return SEQ_BBAG_POCKET;
}

static u8 BBAG_SeqPage2Chg( BBAG_WORK * wk )
{
	BBAG_PageChange( wk, BBAG_PAGE_MAIN );
	return SEQ_BBAG_ITEM;
}

static u8 BBAG_SeqPage3Chg( BBAG_WORK * wk )
{
	BBAG_PageChange( wk, BBAG_PAGE_ITEM );
	return SEQ_BBAG_USE;
}


//--------------------------------------------------------------------------------------------
/**
 * ւG[bZ[WI҂V[PX
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 BBAG_SeqError( BBAG_WORK * wk )
{
	BmpTalkWinClear( &wk->talk_win, WINDOW_TRANS_ON );
	return SEQ_BBAG_USE;
}

//--------------------------------------------------------------------------------------------
/**
 * bZ[W\V[PX
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 BBAG_SeqMsgWait( BBAG_WORK * wk )
{
	if( GF_MSG_PrintEndCheck( wk->midx ) == 0 ){
		return SEQ_BBAG_TRG_WAIT;
	}
	return SEQ_BBAG_MSG_WAIT;
}

//--------------------------------------------------------------------------------------------
/**
 * gK[EFCgV[PX
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 BBAG_SeqTrgWait( BBAG_WORK * wk )
{
	if( ( sys.trg & (PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL) ) || GF_TP_GetTrg() == TRUE ){
		return wk->ret_seq;
	}
	return SEQ_BBAG_TRG_WAIT;
}

//--------------------------------------------------------------------------------------------
/**
 * {^AjI҂V[PX
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 BBAG_SeqButtonWait( BBAG_WORK * wk )
{
	if( wk->btn_flg == 0 ){
		return wk->ret_seq;
	}
	return SEQ_BBAG_BUTTON_WAIT;
}

//--------------------------------------------------------------------------------------------
/**
 * ItF[hZbgV[PX
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 BBAG_SeqEndSet( BBAG_WORK * wk )
{
	PaletteFadeReq( wk->pfd, PF_BIT_SUB_ALL, 0xffff, 0, 0, 16, 0 );
	return SEQ_BBAG_END;
}

//--------------------------------------------------------------------------------------------
/**
 * IV[PX
 *
 * @param	wk		[N
 *
 * @retval	"TRUE = I"
 * @retval	"FALSE = tF[h"
 */
//--------------------------------------------------------------------------------------------
static u8 BBAG_SeqEnd( TCB_PTR tcb, BBAG_WORK * wk )
{
	if( PaletteFadeCheck( wk->pfd ) != 0 ){ return FALSE; }

	BattleBag_ObjFree( wk );
	BattleBag_BmpFreeAll( wk );
	BBAG_MsgManExit( wk );
	BBAG_BgExit( wk->bgl );

	FontProc_UnloadFont( FONT_BUTTON );

	wk->dat->end_flg = 1;
	PMDS_taskDel( tcb );

	return TRUE;
}


//--------------------------------------------------------------------------------------------
/**
 * VRAM
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BBAG_VramInit(void)
{
	GF_BGL_DISPVRAM	tbl = {
		GX_VRAM_BG_128_A,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
		GX_VRAM_SUB_BG_128_C,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
		GX_VRAM_OBJ_64_E,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
		GX_VRAM_TEX_0_B,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_01_FG			// eNX`pbgXbg
	};
	GF_Disp_SetBank( &tbl );
}

//--------------------------------------------------------------------------------------------
/**
 * BG
 *
 * @param	dat		Xgf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BBAG_BgInit( BBAG_WORK * wk )
{
	{	// BG SYSTEM
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_3D,
		};
		GF_BGL_InitBGDisp( &BGsys_data, GF_BGL_SUB_DISP );
	}

	{	// BG (CHAR)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x2000, 0, GF_BGL_SCRSIZ_512x512, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xd000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_23,
			3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( wk->bgl, GF_BGL_FRAME2_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
	}

	{	// PARAM FONT (BMP)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
			1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( wk->bgl, GF_BGL_FRAME1_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( wk->bgl, GF_BGL_FRAME1_S );
	}

	{	// WINDOW (BMP)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( wk->bgl, GF_BGL_FRAME0_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( wk->bgl, GF_BGL_FRAME0_S );
	}
	GF_BGL_ClearCharSet( GF_BGL_FRAME1_S, 32, 0, wk->dat->heap );
	GF_BGL_ClearCharSet( GF_BGL_FRAME0_S, 32, 0, wk->dat->heap );
	GF_BGL_LoadScreenV_Req( wk->bgl, GF_BGL_FRAME1_S );
	GF_BGL_LoadScreenV_Req( wk->bgl, GF_BGL_FRAME0_S );
}

//--------------------------------------------------------------------------------------------
/**
 * BG
 *
 * @param	ini		BGLf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BBAG_BgExit( GF_BGL_INI * ini )
{
	GF_Disp_GXS_VisibleControl(
		GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 | GX_PLANEMASK_BG2 | GX_PLANEMASK_OBJ, VISIBLE_OFF );

	GF_BGL_BGControlExit( ini, GF_BGL_FRAME0_S );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME1_S );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME2_S );
}

//--------------------------------------------------------------------------------------------
/**
 * OtBbNf[^Zbg
 *
 * @param	wk		|PXgʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BBAG_BgGraphicSet( BBAG_WORK * wk )
{
	ArcUtil_BgCharSet(
		ARC_BBAG_GRA, NARC_b_bag_gra_b_bag_bg_NCGR,
		wk->bgl, GF_BGL_FRAME2_S, 0, 0, 0, wk->dat->heap );

	ArcUtil_ScrnSet(
		ARC_BBAG_GRA, NARC_b_bag_gra_b_bag_bg00_NSCR,
		wk->bgl, GF_BGL_FRAME2_S, 0, 0, 0, wk->dat->heap );

	{
		NNSG2dScreenData * dat;
		void * buf;
		u16 * scrn;
		
		buf = ArchiveDataLoadMalloc(
					ARC_BBAG_GRA, NARC_b_bag_gra_b_bag_anm_NSCR, wk->dat->heap );
		NNS_G2dGetUnpackedScreenData( buf, &dat );
		scrn = (u16 *)dat->rawData;
		BattleBag_ButtonScreenMake1( wk, scrn );
		sys_FreeMemoryEz( buf );

		scrn = GF_BGL_ScreenAdrsGet( wk->bgl, GF_BGL_FRAME2_S );
		BattleBag_ButtonScreenMake2( wk, &scrn[32*32*2] );

		buf = ArchiveDataLoadMalloc(
					ARC_BBAG_GRA, NARC_b_bag_gra_b_bag_bg21_NSCR, wk->dat->heap );
		NNS_G2dGetUnpackedScreenData( buf, &dat );
		scrn = (u16 *)dat->rawData;
		BattleBag_ButtonScreenMake3( wk, scrn );
		sys_FreeMemoryEz( buf );

		buf = ArchiveDataLoadMalloc(
					ARC_BBAG_GRA, NARC_b_bag_gra_b_bag_bg22_NSCR, wk->dat->heap );
		NNS_G2dGetUnpackedScreenData( buf, &dat );
		scrn = (u16 *)dat->rawData;
		BattleBag_ButtonScreenMake4( wk, scrn );
		sys_FreeMemoryEz( buf );
	}

	PaletteWorkSet_Arc(
		wk->pfd, ARC_BBAG_GRA, NARC_b_bag_gra_b_bag_bg_NCLR,
		wk->dat->heap, FADE_SUB_BG, 0x20*6, 0 );

/*
	// VXetHgpbgZbg
	PaletteWorkSet_Arc(
		wk->pfd, ARC_FONT, NARC_font_system_ncrl,
		wk->dat->heap, FADE_SUB_BG, 0x20, BBAG_PAL_SYS_FONT*16 );
*/

	// btHgpbgZbg
	PaletteWorkSet_Arc(
		wk->pfd, ARC_FONT, NARC_font_talk_ncrl,
		wk->dat->heap, FADE_SUB_BG, 0x20, BBAG_PAL_TALK_FONT*16 );

	// bEBhEZbg
	ArcUtil_BgCharSet(
		ARC_WINFRAME, TalkWinCgxArcGet(0), wk->bgl,
		GF_BGL_FRAME0_S, TALK_WIN_CGX_POS, 0, 0, wk->dat->heap );
	PaletteWorkSet_Arc(
		wk->pfd, ARC_WINFRAME, TalkWinPalArcGet(0),
		wk->dat->heap, FADE_SUB_BG, 0x20, BBAG_PAL_TALK_WIN*16 );
}

//--------------------------------------------------------------------------------------------
/**
 * bZ[W֘AZbg
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BBAG_MsgManSet( BBAG_WORK * wk )
{
	wk->mman = MSGMAN_Create( MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_b_bag_dat, wk->dat->heap );
	wk->nfnt = NUMFONT_Create( 15, 14, FBMP_COL_NULL, wk->dat->heap );
	wk->wset = WORDSET_Create( wk->dat->heap );

	wk->msg_buf = STRBUF_Create( TMP_MSG_BUF_SIZ, wk->dat->heap );
}

//--------------------------------------------------------------------------------------------
/**
 * bZ[W֘A폜
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BBAG_MsgManExit( BBAG_WORK * wk )
{
	MSGMAN_Delete( wk->mman );
	NUMFONT_Delete( wk->nfnt );
	WORDSET_Delete( wk->wset );

	STRBUF_Delete( wk->msg_buf );
}














//--------------------------------------------------------------------------------------------
/**
 * BGXN[
 *
 * @param	wk		[N
 * @param	page	̃y[W
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BBAG_PageChgBgScroll( BBAG_WORK * wk, u8 page )
{
	switch( page ){
	case BBAG_PAGE_POCKET:		// |PbgIy[W
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME2_S, GF_BGL_SCROLL_X_SET, 0 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME2_S, GF_BGL_SCROLL_Y_SET, 0 );
		break;
	case BBAG_PAGE_MAIN:		// ACeIy[W
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME2_S, GF_BGL_SCROLL_X_SET, 256 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME2_S, GF_BGL_SCROLL_Y_SET, 0 );
		break;
	case BBAG_PAGE_ITEM:		// ACegpy[W
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME2_S, GF_BGL_SCROLL_X_SET, 0 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME2_S, GF_BGL_SCROLL_Y_SET, 256 );
		break;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * y[W؂ւ
 *
 * @param	wk			[N
 * @param	next_page	̃y[W
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BBAG_PageChange( BBAG_WORK * wk, u8 next_page )
{
	BBAG_PageChgBgScroll( wk, next_page );

	GF_BGL_ScrClearCodeVReq( wk->bgl, GF_BGL_FRAME0_S, 0 );
	GF_BGL_ScrClearCodeVReq( wk->bgl, GF_BGL_FRAME1_S, 0 );

	BattleBag_BmpFree( wk );
	BattleBag_BmpAdd( wk, next_page );
	BattleBag_BmpWrite( wk, next_page );

	BattleBag_ButtonPageScreenInit( wk, next_page );

	wk->page = next_page;

	BattleBag_PageObjSet( wk, wk->page );
}

//--------------------------------------------------------------------------------------------
/**
 * ^b`pl̃{^
 *
 * @param	wk		[N
 * @param	tbl		TPf[^e[u
 *
 * @retval	"RECT_HIT_NONE = ĂȂ"
 * @retval	"RECT_HIT_NONE != {^ԍ"
 */
//--------------------------------------------------------------------------------------------
static int BBAG_TPCheck( BBAG_WORK * wk, const RECT_HIT_TBL * tbl )
{
	int	ret = GF_TP_RectHitTrg( tbl );
/*
	if( ret != RECT_HIT_NONE ){
		u16	pat = 0xfffe;
		if( GF_BGL_DotCheck( wk->bgl, GF_BGL_FRAME3_S, sys.tp_x, sys.tp_y, &pat ) == FALSE ){
			return RECT_HIT_NONE;
		}
	}
*/
	if( ret != RECT_HIT_NONE ){
		Snd_SePlay( SEQ_SE_DP_DECIDE );
	}

	return ret;
}


int BattleBag_SelMonsNoGet( BBAG_WORK * wk )
{
	int	ret;

	ret = ST_ServerParamDataGet(
			wk->dat->bw,
			BattleWorkServerParamGet(wk->dat->bw), ID_SP_sel_mons_no, wk->dat->client_no );
	return ret;
}
