//============================================================================================
/**
 * @file	b_bag_obj.c
 * @bfief	퓬pobO OBJ֘A
 * @author	Hiroyuki Nakamura
 * @date	05.02.15
 */
//============================================================================================
#include "common.h"
#include "system/msgdata.h"
#include "system/numfont.h"
#include "system/wordset.h"
#include "system/clact_tool.h"
#include "battle/battle_common.h"
#include "battle/fight_tool.h"
#include "itemtool/item.h"

#define	B_BAG_OBJ_H_GLOBAL
#include "b_bag.h"
#include "b_bag_main.h"
#include "b_bag_obj.h"
#include "b_bag_item.h"


//============================================================================================
//	萔`
//============================================================================================
#define	CLACT_ID_COMMON		( 46263 )	// ̉ʂŎgpZAN^[ID

// L\[XID
enum {
	CHR_ID_ITEM1 = CLACT_ID_COMMON,		// ACeACRFP
	CHR_ID_ITEM2,						// ACeACRFQ
	CHR_ID_ITEM3,						// ACeACRFR
	CHR_ID_ITEM4,						// ACeACRFS
	CHR_ID_ITEM5,						// ACeACRFT
	CHR_ID_ITEM6,						// ACeACRFU

	CHR_ID_MAX = CHR_ID_ITEM6 - CLACT_ID_COMMON + 1
};

// pbg\[XID
enum {
	PAL_ID_ITEM1 = CLACT_ID_COMMON,		// ACeACRFP
	PAL_ID_ITEM2,						// ACeACRFQ
	PAL_ID_ITEM3,						// ACeACRFR
	PAL_ID_ITEM4,						// ACeACRFS
	PAL_ID_ITEM5,						// ACeACRFT
	PAL_ID_ITEM6,						// ACeACRFU

	PAL_ID_MAX = PAL_ID_ITEM6 - CLACT_ID_COMMON + 1
};

// Z\[XID
enum {
	CEL_ID_ITEM = CLACT_ID_COMMON,		// ACeACR

	CEL_ID_MAX = CEL_ID_ITEM - CLACT_ID_COMMON + 1
};

// ZAj\[XID
enum {
	ANM_ID_ITEM = CLACT_ID_COMMON,		// ACeACR

	ANM_ID_MAX = ANM_ID_ITEM - CLACT_ID_COMMON + 1
};


//============================================================================================
//	vg^Cv錾
//============================================================================================
static void BBAG_ClactResManInit( BBAG_WORK * wk );
static void BBAG_ClactItemLoad( BBAG_WORK * wk );
static void BBAG_ItemIconCharChg( BBAG_WORK * wk, u16 item, u32 res_id );
static void BBAG_ItemIconPlttChg( BBAG_WORK * wk, u16 item, u16 pos, u32 res_id );
static void BBAG_ClactAddAll( BBAG_WORK * wk );
static void BBAG_Page2ObjSet( BBAG_WORK * wk );
static void BBAG_Page3ObjSet( BBAG_WORK * wk );


//============================================================================================
//	O[oϐ
//============================================================================================
// y[WQ̃ACeACR̍W
static const int P2_ItemIconPos[][2] =
{
	{  44,  44 }, {  44,  92 },
	{  44, 140 }, { 172,  44 },
	{ 172,  92 }, { 172, 140 },
};

// y[WR̃|PACR̍W
static const int P3_ItemIconPos[2] = { 48, 48 };


//--------------------------------------------------------------------------------------------
/**
 * 퓬pobOOBJ
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BattleBag_ObjInit( BBAG_WORK * wk )
{
	BBAG_ClactResManInit( wk );
	BBAG_ClactItemLoad( wk );
	BBAG_ClactAddAll( wk );

	GF_Disp_GXS_VisibleControl( GX_PLANEMASK_OBJ, VISIBLE_ON );
}

//--------------------------------------------------------------------------------------------
/**
 * \[X}l[W[
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BBAG_ClactResManInit( BBAG_WORK * wk )
{
	TCATS_RESOURCE_NUM_LIST	crnl = { CHR_ID_MAX, PAL_ID_MAX, CEL_ID_MAX, ANM_ID_MAX, 0, 0 };
	CATS_SYS_PTR	csp = BattleWorkCATS_SYS_PTRGet( wk->dat->bw );

	wk->crp = CATS_ResourceCreate( csp );
	CATS_ClactSetInit( csp, wk->crp, BBAG_CA_MAX );
	CATS_ResourceManagerInit( csp, wk->crp, &crnl );
}

//--------------------------------------------------------------------------------------------
/**
 * ACeACR̃OtBbN[h
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BBAG_ClactItemLoad( BBAG_WORK * wk )
{
	CATS_SYS_PTR	csp;
	u32	i;
	
	csp = BattleWorkCATS_SYS_PTRGet( wk->dat->bw );

	for( i=0; i<6; i++ ){
		// L
		CATS_LoadResourceCharArc(
			csp, wk->crp, ARC_ITEMICON,
			GetItemIndex(1,ITEM_GET_ICON_CGX), 0, NNS_G2D_VRAM_TYPE_2DSUB, CHR_ID_ITEM1+i );
		// pbg
		CATS_LoadResourcePlttWorkArc(
			wk->pfd, FADE_SUB_OBJ, csp, wk->crp, ARC_ITEMICON,
			GetItemIndex(1,ITEM_GET_ICON_PAL), 0, 1, NNS_G2D_VRAM_TYPE_2DSUB, PAL_ID_ITEM1+i );
	}
	// Z
	CATS_LoadResourceCellArc( csp, wk->crp, ARC_ITEMICON, ItemIconCellGet(), 0, CEL_ID_ITEM );
	// ZAj
	CATS_LoadResourceCellAnmArc( csp, wk->crp, ARC_ITEMICON, ItemIconCAnmGet(), 0, ANM_ID_ITEM );
}

//--------------------------------------------------------------------------------------------
/**
 * ACeACR؂ւ
 *
 * @param	wk		[N
 * @param	cap		ZAN^[f[^
 * @param	item	ACeԍ
 * @param	res_id	L\[XID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BBAG_ItemIconCharChg( BBAG_WORK * wk, u16 item, u32 res_id )
{
	CATS_SYS_PTR	csp = BattleWorkCATS_SYS_PTRGet( wk->dat->bw );

	CATS_ChangeResourceCharArc(
		csp, wk->crp, ARC_ITEMICON,
		GetItemIndex(item,ITEM_GET_ICON_CGX), 0, res_id );
}

static void BBAG_ItemIconPlttChg( BBAG_WORK * wk, u16 item, u16 pos, u32 res_id )
{
	CATS_SYS_PTR	csp = BattleWorkCATS_SYS_PTRGet( wk->dat->bw );

/*
	CATS_ChangeResourcePlttArc(
		csp, wk->crp, ARC_ITEMICON,
		GetItemIndex(item,ITEM_GET_ICON_PAL), 0, res_id );

	PaletteWorkSet_VramCopy( wk->pfd, FADE_SUB_OBJ, pos * 16, 0x20 );
*/
	PaletteWorkSet_Arc(
		wk->pfd, ARC_ITEMICON,
		GetItemIndex(item,ITEM_GET_ICON_PAL), wk->dat->heap,FADE_SUB_OBJ, 0x20, pos*16 );

}

//--------------------------------------------------------------------------------------------
/**
 * ZAN^[ǉiʁj
 *
 * @param	wk		[N
 * @param	id		ǉZAN^[ID
 *
 * @return	ZAN^[f[^
 */
//--------------------------------------------------------------------------------------------
static CATS_ACT_PTR BBAG_ClactAdd( BBAG_WORK * wk, u32 id )
{
	TCATS_OBJECT_ADD_PARAM_S	prm;
	CATS_SYS_PTR	csp;

	csp = BattleWorkCATS_SYS_PTRGet( wk->dat->bw );

	prm.x = 0;
	prm.y = 0;
	prm.z = 0;

	prm.anm = 0;
	prm.pri = 0;
	prm.pal = 0;
	prm.d_area = NNS_G2D_VRAM_TYPE_2DSUB;

	prm.id[0] = CHR_ID_ITEM1+id;
	prm.id[1] = PAL_ID_ITEM1+id;
	prm.id[2] = CEL_ID_ITEM;
	prm.id[3] = ANM_ID_ITEM;
	
	prm.bg_pri = 1;
	prm.vram_trans = 0;

	return CATS_ObjectAdd_S( csp, wk->crp, &prm );
}

//--------------------------------------------------------------------------------------------
/**
 * ZAN^[ǉiSāj
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BBAG_ClactAddAll( BBAG_WORK * wk )
{
	u32	i;

	for( i=0; i<BBAG_CA_MAX; i++ ){
		wk->cap[i] = BBAG_ClactAdd( wk, i );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * 퓬p|PXgOBJ폜
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BattleBag_ObjFree( BBAG_WORK * wk )
{
	CATS_SYS_PTR	csp;
	u32	i;
	
	csp = BattleWorkCATS_SYS_PTRGet( wk->dat->bw );

	for( i=0; i<BBAG_CA_MAX; i++ ){
		CATS_ActorPointerDelete_S( wk->cap[i] );
	}

	CATS_ResourceDestructor_S( csp, wk->crp );
}

//--------------------------------------------------------------------------------------------
/**
 * ZAN^[\čWύX
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BBAG_ClactOn( CATS_ACT_PTR cap, const int x, const int y )
{
	CATS_ObjectEnableCap( cap, 1 );
	CATS_ObjectPosSetCap( cap, x, y );
}

//--------------------------------------------------------------------------------------------
/**
 * y[WƂOBJZbg
 *
 * @param	wk		[N
 * @param	page	y[W
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BattleBag_PageObjSet( BBAG_WORK * wk, u32 page )
{
	u32	i;

	for( i=0; i<BBAG_CA_MAX; i++ ){
		CATS_ObjectEnableCap( wk->cap[i], 0 );
	}

	switch( page ){
	case BBAG_PAGE_MAIN:		// ACeIy[W
		BBAG_Page2ObjSet( wk );
		break;
	case BBAG_PAGE_ITEM:		// ACegpy[W
		BBAG_Page3ObjSet( wk );
		break;
	}
}



static void BBAG_Page2ObjSet( BBAG_WORK * wk )
{
	u32	i;
	u16	item;

	for( i=0; i<6; i++ ){
		item = BattleBag_PosItemCheck( wk, i );
		if( item == 0 ){ continue; }
//		BBAG_ItemIconChange( wk, wk->cap[i], item, CHR_ID_ITEM1+i, PAL_ID_ITEM1+i );
		BBAG_ItemIconCharChg( wk, item, CHR_ID_ITEM1+i );
		BBAG_ItemIconPlttChg( wk, item, (u16)i, PAL_ID_ITEM1+i );
		BBAG_ClactOn( wk->cap[i], P2_ItemIconPos[i][0], P2_ItemIconPos[i][1] );
	}
}

static void BBAG_Page3ObjSet( BBAG_WORK * wk )
{
	u16	item;

	item = BattleBag_PosItemCheck( wk, wk->dat->item_pos[wk->poke_id] );
	BBAG_ItemIconCharChg( wk, item, CHR_ID_ITEM1 );
	BBAG_ItemIconPlttChg( wk, item, 0, PAL_ID_ITEM1 );
	BBAG_ClactOn( wk->cap[0], P3_ItemIconPos[0], P3_ItemIconPos[1] );
}
