//============================================================================================
/**
 * @file	b_plist_anm.c
 * @bfief	퓬p|PXg {^
 * @author	Hiroyuki Nakamura
 * @date	05.03.16
 */
//============================================================================================
#include "common.h"
#include "system/palanm.h"
#include "system/msgdata.h"
#include "system/numfont.h"
#include "system/wordset.h"
#include "system/clact_tool.h"
#include "battle/battle_common.h"

#define	B_PLIST_ANM_H_GLOBAL
#include "b_plist.h"
#include "b_plist_main.h"
#include "b_plist_anm.h"


//============================================================================================
//	萔`
//============================================================================================
// {^AjXN[f[^
// 퓬|P̃v[g
#define	DAT_PX_MAINPOKE_1	( 0 )
#define	DAT_PY_MAINPOKE_1	( 0 )
#define	DAT_PX_MAINPOKE_2	( 0 )
#define	DAT_PY_MAINPOKE_2	( 6 )
#define	DAT_PX_MAINPOKE_3	( 0 )
#define	DAT_PY_MAINPOKE_3	( 12 )
#define	DAT_SX_MAINPOKE		( 16 )
#define	DAT_SY_MAINPOKE		( 6 )
// Tu|P̃v[g
#define	DAT_PX_SUBPOKE_1	( 16 )
#define	DAT_PY_SUBPOKE_1	( 0 )
#define	DAT_PX_SUBPOKE_2	( 16 )
#define	DAT_PY_SUBPOKE_2	( 6 )
#define	DAT_PX_SUBPOKE_3	( 16 )
#define	DAT_PY_SUBPOKE_3	( 12 )
#define	DAT_SX_SUBPOKE		( 16 )
#define	DAT_SY_SUBPOKE		( 6 )
// Xe[^X؂ւ
#define	DAT_PX_STATUS_1		( 26 )
#define	DAT_PY_STATUS_1		( 18 )
#define	DAT_PX_STATUS_2		( 26 )
#define	DAT_PY_STATUS_2		( 22 )
#define	DAT_PX_STATUS_3		( 26 )
#define	DAT_PY_STATUS_3		( 26 )
#define	DAT_SX_STATUS		( 3 )
#define	DAT_SY_STATUS		( 4 )
// Z؂ւ
#define	DAT_PX_WAZA_1	( 29 )
#define	DAT_PY_WAZA_1	( 18 )
#define	DAT_PX_WAZA_2	( 29 )
#define	DAT_PY_WAZA_2	( 22 )
#define	DAT_PX_WAZA_3	( 29 )
#define	DAT_PY_WAZA_3	( 26 )
#define	DAT_SX_WAZA		( 3 )
#define	DAT_SY_WAZA		( 4 )
// ZI
#define	DAT_PX_WAZASEL_1	( 0 )
#define	DAT_PY_WAZASEL_1	( 18 )
#define	DAT_PX_WAZASEL_2	( 0 )
#define	DAT_PY_WAZASEL_2	( 18 )
#define	DAT_PX_WAZASEL_3	( 0 )
#define	DAT_PY_WAZASEL_3	( 18 )
#define	DAT_SX_WAZASEL		( 16 )
#define	DAT_SY_WAZASEL		( 6 )
// ւȂ
#define	DAT_PX_CHANGE_1		( 16 )
#define	DAT_PY_CHANGE_1		( 18 )
#define	DAT_PX_CHANGE_2		( 16 )
#define	DAT_PY_CHANGE_2		( 23 )
#define	DAT_PX_CHANGE_3		( 16 )
#define	DAT_PY_CHANGE_3		( 28 )
#define	DAT_SX_CHANGE		( 10 )
#define	DAT_SY_CHANGE		( 5 )
// |P؂ւij
#define	DAT_PX_UP_1		( 0 )
#define	DAT_PY_UP_1		( 36 )
#define	DAT_PX_UP_2		( 5 )
#define	DAT_PY_UP_2		( 36 )
#define	DAT_PX_UP_3		( 10 )
#define	DAT_PY_UP_3		( 36 )
#define	DAT_SX_UP		( 5 )
#define	DAT_SY_UP		( 5 )
// |P؂ւij
#define	DAT_PX_DOWN_1	( 0 )
#define	DAT_PY_DOWN_1	( 41 )
#define	DAT_PX_DOWN_2	( 5 )
#define	DAT_PY_DOWN_2	( 41 )
#define	DAT_PX_DOWN_3	( 10 )
#define	DAT_PY_DOWN_3	( 41 )
#define	DAT_SX_DOWN		( 5 )
#define	DAT_SY_DOWN		( 6 )
// ߂
#define	DAT_PX_RETURN_1		( 26 )
#define	DAT_PY_RETURN_1		( 30 )
#define	DAT_PX_RETURN_2		( 26 )
#define	DAT_PY_RETURN_2		( 35 )
#define	DAT_PX_RETURN_3		( 26 )
#define	DAT_PY_RETURN_3		( 40 )
#define	DAT_SX_RETURN		( 5 )
#define	DAT_SY_RETURN		( 5 )
// 퓬Z<->ReXgZ
#define	DAT_PX_CONTEST_1	( 16 )
#define	DAT_PY_CONTEST_1	( 33 )
#define	DAT_PX_CONTEST_2	( 16 )
#define	DAT_PY_CONTEST_2	( 37 )
#define	DAT_PX_CONTEST_3	( 16 )
#define	DAT_PY_CONTEST_3	( 41 )
#define	DAT_SX_CONTEST		( 9 )
#define	DAT_SY_CONTEST		( 4 )

// zuʒu
#define	P1_POKE1_SCR_PX		( 0 )
#define	P1_PAGE1_SCR_PY		( 0 )
#define	P1_POKE2_SCR_PX		( 16 )
#define	P1_PAGE2_SCR_PY		( 1 )
#define	P1_POKE3_SCR_PX		( 0 )
#define	P1_PAGE3_SCR_PY		( 6 )
#define	P1_POKE4_SCR_PX		( 16 )
#define	P1_PAGE4_SCR_PY		( 7 )
#define	P1_POKE5_SCR_PX		( 0 )
#define	P1_PAGE5_SCR_PY		( 12 )
#define	P1_POKE6_SCR_PX		( 16 )
#define	P1_PAGE6_SCR_PY		( 13 )
#define	P1_RETURN_SCR_PX	( 27 )
#define	P1_RETURN_SCR_PY	( 19 )

#define	P2_STATUS_SCR_PX	( 32 )
#define	P2_STATUS_SCR_PY	( 4 )
#define	P2_WAZA1_SCR_PX		( 32 )
#define	P2_WAZA1_SCR_PY		( 10 )
#define	P2_WAZA2_SCR_PX		( 61 )
#define	P2_WAZA2_SCR_PY		( 10 )
#define	P2_WAZA3_SCR_PX		( 32 )
#define	P2_WAZA3_SCR_PY		( 14 )
#define	P2_WAZA4_SCR_PX		( 61 )
#define	P2_WAZA4_SCR_PY		( 14 )
#define	P2_CHANGE_SCR_PX	( 32 )
#define	P2_CHANGE_SCR_PY	( 19 )
#define	P2_UP_SCR_PX		( 48 )
#define	P2_UP_SCR_PY		( 19 )
#define	P2_DOWN_SCR_PX		( 53 )
#define	P2_DOWN_SCR_PY		( 19 )
#define	P2_RETURN_SCR_PX	( 59 )
#define	P2_RETURN_SCR_PY	( 19 )

#define	P3_RETURN_SCR_PX	( 27 )
#define	P3_RETURN_SCR_PY	( 51 )

#define	P4_RETURN_SCR_PX	( 59 )
#define	P4_RETURN_SCR_PY	( 51 )

#define	P5_CONTEST_SCR_PX	( 55 )
#define	P5_CONTEST_SCR_PY	( 0 )
#define	P5_WAZA1_SCR_PX		( 32 )
#define	P5_WAZA1_SCR_PY		( 6 )
#define	P5_WAZA2_SCR_PX		( 48 )
#define	P5_WAZA2_SCR_PY		( 6 )
#define	P5_WAZA3_SCR_PX		( 32 )
#define	P5_WAZA3_SCR_PY		( 12 )
#define	P5_WAZA4_SCR_PX		( 48 )
#define	P5_WAZA4_SCR_PY		( 12 )
#define	P5_WAZA5_SCR_PX		( 40 )
#define	P5_WAZA5_SCR_PY		( 18 )
#define	P5_RETURN_SCR_PX	( 59 )
#define	P5_RETURN_SCR_PY	( 19 )

#define	P6_CONTEST_SCR_PX	( 23 )
#define	P6_CONTEST_SCR_PY	( 32 )
#define	P6_CHANGE_SCR_PX	( 0 )
#define	P6_CHANGE_SCR_PY	( 51 )
#define	P6_RETURN_SCR_PX	( 27 )
#define	P6_RETURN_SCR_PY	( 51 )

#define	P7_WAZA1_SCR_PX		( 32 )
#define	P7_WAZA1_SCR_PY		( 38 )
#define	P7_WAZA2_SCR_PX		( 48 )
#define	P7_WAZA2_SCR_PY		( 38 )
#define	P7_WAZA3_SCR_PX		( 32 )
#define	P7_WAZA3_SCR_PY		( 44 )
#define	P7_WAZA4_SCR_PX		( 48 )
#define	P7_WAZA4_SCR_PY		( 44 )
#define	P7_RETURN_SCR_PX	( 59 )
#define	P7_RETURN_SCR_PY	( 51 )

typedef struct {
	u8	px;
	u8	py;
	u8	sx;
	u8	sy;
}BUTTON_ANM;


//============================================================================================
//	vg^Cv錾
//============================================================================================
static void BPL_ScrnCopy( u16 * buf, u16 * scrn, u8 px, u8 py, u8 sx, u8 sy );


//============================================================================================
//	O[oϐ
//============================================================================================
// {^XN[f[^
static const BUTTON_ANM ButtonScreenAnm[] =
{
	{ P1_POKE1_SCR_PX, P1_PAGE1_SCR_PY, DAT_SX_MAINPOKE, DAT_SY_MAINPOKE },
	{ P1_POKE2_SCR_PX, P1_PAGE2_SCR_PY, DAT_SX_MAINPOKE, DAT_SY_MAINPOKE },
	{ P1_POKE3_SCR_PX, P1_PAGE3_SCR_PY, DAT_SX_MAINPOKE, DAT_SY_MAINPOKE },
	{ P1_POKE4_SCR_PX, P1_PAGE4_SCR_PY, DAT_SX_MAINPOKE, DAT_SY_MAINPOKE },
	{ P1_POKE5_SCR_PX, P1_PAGE5_SCR_PY, DAT_SX_MAINPOKE, DAT_SY_MAINPOKE },
	{ P1_POKE6_SCR_PX, P1_PAGE6_SCR_PY, DAT_SX_MAINPOKE, DAT_SY_MAINPOKE },
	{ P1_RETURN_SCR_PX, P1_RETURN_SCR_PY, DAT_SX_RETURN, DAT_SY_RETURN },

	{ P2_STATUS_SCR_PX, P2_STATUS_SCR_PY, DAT_SX_STATUS, DAT_SY_STATUS },
	{ P2_WAZA1_SCR_PX, P2_WAZA1_SCR_PY, DAT_SX_WAZA, DAT_SY_WAZA },
	{ P2_WAZA2_SCR_PX, P2_WAZA2_SCR_PY, DAT_SX_WAZA, DAT_SY_WAZA },
	{ P2_WAZA3_SCR_PX, P2_WAZA3_SCR_PY, DAT_SX_WAZA, DAT_SY_WAZA },
	{ P2_WAZA4_SCR_PX, P2_WAZA4_SCR_PY, DAT_SX_WAZA, DAT_SY_WAZA },
	{ P2_CHANGE_SCR_PX, P2_CHANGE_SCR_PY, DAT_SX_CHANGE, DAT_SY_CHANGE },
	{ P2_UP_SCR_PX, P2_UP_SCR_PY, DAT_SX_UP, DAT_SY_UP },
	{ P2_DOWN_SCR_PX, P2_DOWN_SCR_PY, DAT_SX_DOWN, DAT_SY_DOWN },
	{ P2_RETURN_SCR_PX, P2_RETURN_SCR_PY, DAT_SX_RETURN, DAT_SY_RETURN },

	{ P3_RETURN_SCR_PX, P3_RETURN_SCR_PY, DAT_SX_RETURN, DAT_SY_RETURN },

	{ P4_RETURN_SCR_PX, P4_RETURN_SCR_PY, DAT_SX_RETURN, DAT_SY_RETURN },

	{ P5_WAZA1_SCR_PX, P5_WAZA1_SCR_PY, DAT_SX_WAZASEL, DAT_SY_WAZASEL },
	{ P5_WAZA2_SCR_PX, P5_WAZA2_SCR_PY, DAT_SX_WAZASEL, DAT_SY_WAZASEL },
	{ P5_WAZA3_SCR_PX, P5_WAZA3_SCR_PY, DAT_SX_WAZASEL, DAT_SY_WAZASEL },
	{ P5_WAZA4_SCR_PX, P5_WAZA4_SCR_PY, DAT_SX_WAZASEL, DAT_SY_WAZASEL },
	{ P5_WAZA5_SCR_PX, P5_WAZA5_SCR_PY, DAT_SX_WAZASEL, DAT_SY_WAZASEL },
	{ P5_CONTEST_SCR_PX, P5_CONTEST_SCR_PY, DAT_SX_CONTEST, DAT_SY_CONTEST },
	{ P5_RETURN_SCR_PX, P5_RETURN_SCR_PY, DAT_SX_RETURN, DAT_SY_RETURN },

	{ P6_CHANGE_SCR_PX, P6_CHANGE_SCR_PY, DAT_SX_CHANGE, DAT_SY_CHANGE },
	{ P6_CONTEST_SCR_PX, P6_CONTEST_SCR_PY, DAT_SX_CONTEST, DAT_SY_CONTEST },
	{ P6_RETURN_SCR_PX, P6_RETURN_SCR_PY, DAT_SX_RETURN, DAT_SY_RETURN },

	{ P7_WAZA1_SCR_PX, P7_WAZA1_SCR_PY, DAT_SX_WAZASEL, DAT_SY_WAZASEL },
	{ P7_WAZA2_SCR_PX, P7_WAZA2_SCR_PY, DAT_SX_WAZASEL, DAT_SY_WAZASEL },
	{ P7_WAZA3_SCR_PX, P7_WAZA3_SCR_PY, DAT_SX_WAZASEL, DAT_SY_WAZASEL },
	{ P7_WAZA4_SCR_PX, P7_WAZA4_SCR_PY, DAT_SX_WAZASEL, DAT_SY_WAZASEL },
	{ P7_RETURN_SCR_PX, P7_RETURN_SCR_PY, DAT_SX_RETURN, DAT_SY_RETURN },
};

static const u8 BtnBmpWin_Poke1[] = { WIN_P1_POKE1, 0xff };	// |PP
static const u8 BtnBmpWin_Poke2[] = { WIN_P1_POKE2, 0xff };	// |PQ
static const u8 BtnBmpWin_Poke3[] = { WIN_P1_POKE3, 0xff };	// |PR
static const u8 BtnBmpWin_Poke4[] = { WIN_P1_POKE4, 0xff };	// |PS
static const u8 BtnBmpWin_Poke5[] = { WIN_P1_POKE5, 0xff };	// |PT
static const u8 BtnBmpWin_Poke6[] = { WIN_P1_POKE6, 0xff };	// |PU

static const u8 BtnBmpWin_Change[] = { WIN_P2_CHG, 0xff };	// uꂩv

static const u8 BtnBmpWin_WazaSel1[] = { WIN_P5_SKILL1, 0xff };	// ZP
static const u8 BtnBmpWin_WazaSel2[] = { WIN_P5_SKILL2, 0xff };	// ZQ
static const u8 BtnBmpWin_WazaSel3[] = { WIN_P5_SKILL3, 0xff };	// ZR
static const u8 BtnBmpWin_WazaSel4[] = { WIN_P5_SKILL4, 0xff };	// ZS
static const u8 BtnBmpWin_WazaSel5[] = { WIN_P5_SKILL5, 0xff };	// ZT

static const u8 BtnBmpWin_Delete[] = { WIN_P6_WASURERU, 0xff };	// u킷v

static const u8 BtnBmpWin_WazaRcv1[] = { WIN_P7_SKILL1, 0xff };	// ZP
static const u8 BtnBmpWin_WazaRcv2[] = { WIN_P7_SKILL2, 0xff };	// ZQ
static const u8 BtnBmpWin_WazaRcv3[] = { WIN_P7_SKILL3, 0xff };	// ZR
static const u8 BtnBmpWin_WazaRcv4[] = { WIN_P7_SKILL4, 0xff };	// ZS


static const u8 * const ButtonBmpWinIndex[] = {
	BtnBmpWin_Poke1,	//	BPL_BUTTON_POKE1 = 0,
	BtnBmpWin_Poke2,	//	BPL_BUTTON_POKE2,
	BtnBmpWin_Poke3,	//	BPL_BUTTON_POKE3,
	BtnBmpWin_Poke4,	//	BPL_BUTTON_POKE4,
	BtnBmpWin_Poke5,	//	BPL_BUTTON_POKE5,
	BtnBmpWin_Poke6,	//	BPL_BUTTON_POKE6,
	NULL,				//	BPL_BUTTON_RET1,

	NULL,				//	BPL_BUTTON_STATUS,
	NULL,				//	BPL_BUTTON_WAZA1,
	NULL,				//	BPL_BUTTON_WAZA2,
	NULL,				//	BPL_BUTTON_WAZA3,
	NULL,				//	BPL_BUTTON_WAZA4,
	BtnBmpWin_Change,	//	BPL_BUTTON_CHANGE,
	NULL,				//	BPL_BUTTON_UP,
	NULL,				//	BPL_BUTTON_DOWN,
	NULL,				//	BPL_BUTTON_RET2,

	NULL,				//	BPL_BUTTON_RET3,
	NULL,				//	BPL_BUTTON_RET4,

	BtnBmpWin_WazaSel1,	//	BPL_BUTTON_WAZASEL1,
	BtnBmpWin_WazaSel2,	//	BPL_BUTTON_WAZASEL2,
	BtnBmpWin_WazaSel3,	//	BPL_BUTTON_WAZASEL3,
	BtnBmpWin_WazaSel4,	//	BPL_BUTTON_WAZASEL4,
	BtnBmpWin_WazaSel5,	//	BPL_BUTTON_WAZASEL5,
	NULL,				//	BPL_BUTTON_CONTEST1,
	NULL,				//	BPL_BUTTON_RET5,

	BtnBmpWin_Delete,	//	BPL_BUTTON_SELECT,
	NULL,				//	BPL_BUTTON_CONTEST2,
	NULL,				//	BPL_BUTTON_RET6,

	BtnBmpWin_WazaRcv1,	//	BPL_BUTTON_WAZARCV1,
	BtnBmpWin_WazaRcv2,	//	BPL_BUTTON_WAZARCV2,
	BtnBmpWin_WazaRcv3,	//	BPL_BUTTON_WAZARCV3,
	BtnBmpWin_WazaRcv4,	//	BPL_BUTTON_WAZARCV4,
	NULL,				//	BPL_BUTTON_RET7,
};






void BattlePokeList_ButtonScreenMake( BPLIST_WORK * wk, u16 * scrn )
{
	// 퓬v[g
	BPL_ScrnCopy(
		wk->btn_plate1[0], scrn,
		DAT_PX_MAINPOKE_1, DAT_PY_MAINPOKE_1, DAT_SX_MAINPOKE, DAT_SY_MAINPOKE );
	BPL_ScrnCopy(
		wk->btn_plate1[1], scrn,
		DAT_PX_MAINPOKE_2, DAT_PY_MAINPOKE_2, DAT_SX_MAINPOKE, DAT_SY_MAINPOKE );
	BPL_ScrnCopy(
		wk->btn_plate1[2], scrn,
		DAT_PX_MAINPOKE_3, DAT_PY_MAINPOKE_3, DAT_SX_MAINPOKE, DAT_SY_MAINPOKE );

	// Tv[g
	BPL_ScrnCopy(
		wk->btn_plate2[0], scrn,
		DAT_PX_SUBPOKE_1, DAT_PY_SUBPOKE_1, DAT_SX_SUBPOKE, DAT_SY_SUBPOKE );
	BPL_ScrnCopy(
		wk->btn_plate2[1], scrn,
		DAT_PX_SUBPOKE_2, DAT_PY_SUBPOKE_2, DAT_SX_SUBPOKE, DAT_SY_SUBPOKE );
	BPL_ScrnCopy(
		wk->btn_plate2[2], scrn,
		DAT_PX_SUBPOKE_3, DAT_PY_SUBPOKE_3, DAT_SX_SUBPOKE, DAT_SY_SUBPOKE );

	// Xe[^X؂ւ
	BPL_ScrnCopy(
		wk->btn_st[0], scrn, DAT_PX_STATUS_1, DAT_PY_STATUS_1, DAT_SX_STATUS, DAT_SY_STATUS );
	BPL_ScrnCopy(
		wk->btn_st[1], scrn, DAT_PX_STATUS_2, DAT_PY_STATUS_2, DAT_SX_STATUS, DAT_SY_STATUS );
	BPL_ScrnCopy(
		wk->btn_st[2], scrn, DAT_PX_STATUS_3, DAT_PY_STATUS_3, DAT_SX_STATUS, DAT_SY_STATUS );

	// Z؂ւ
	BPL_ScrnCopy(
		wk->btn_waza1[0], scrn, DAT_PX_WAZA_1, DAT_PY_WAZA_1, DAT_SX_WAZA, DAT_SY_WAZA );
	BPL_ScrnCopy(
		wk->btn_waza1[1], scrn, DAT_PX_WAZA_2, DAT_PY_WAZA_2, DAT_SX_WAZA, DAT_SY_WAZA );
	BPL_ScrnCopy(
		wk->btn_waza1[2], scrn, DAT_PX_WAZA_3, DAT_PY_WAZA_3, DAT_SX_WAZA, DAT_SY_WAZA );

	// ZI
	BPL_ScrnCopy(
		wk->btn_waza2[0], scrn,
		DAT_PX_WAZASEL_1, DAT_PY_WAZASEL_1, DAT_SX_WAZASEL, DAT_SY_WAZASEL );
	BPL_ScrnCopy(
		wk->btn_waza2[1], scrn,
		DAT_PX_WAZASEL_2, DAT_PY_WAZASEL_2, DAT_SX_WAZASEL, DAT_SY_WAZASEL );
	BPL_ScrnCopy(
		wk->btn_waza2[2], scrn,
		DAT_PX_WAZASEL_3, DAT_PY_WAZASEL_3, DAT_SX_WAZASEL, DAT_SY_WAZASEL );

	// ւȂ
	BPL_ScrnCopy(
		wk->btn_chg[0], scrn, DAT_PX_CHANGE_1, DAT_PY_CHANGE_1, DAT_SX_CHANGE, DAT_SY_CHANGE );
	BPL_ScrnCopy(
		wk->btn_chg[1], scrn, DAT_PX_CHANGE_2, DAT_PY_CHANGE_2, DAT_SX_CHANGE, DAT_SY_CHANGE );
	BPL_ScrnCopy(
		wk->btn_chg[2], scrn, DAT_PX_CHANGE_3, DAT_PY_CHANGE_3, DAT_SX_CHANGE, DAT_SY_CHANGE );

	// |P؂ւij
	BPL_ScrnCopy(
		wk->btn_up[0], scrn, DAT_PX_UP_1, DAT_PY_UP_1, DAT_SX_UP, DAT_SY_UP );
	BPL_ScrnCopy(
		wk->btn_up[1], scrn, DAT_PX_UP_2, DAT_PY_UP_2, DAT_SX_UP, DAT_SY_UP );
	BPL_ScrnCopy(
		wk->btn_up[2], scrn, DAT_PX_UP_3, DAT_PY_UP_3, DAT_SX_UP, DAT_SY_UP );

	// |P؂ւij
	BPL_ScrnCopy(
		wk->btn_down[0], scrn, DAT_PX_DOWN_1, DAT_PY_DOWN_1, DAT_SX_DOWN, DAT_SY_DOWN );
	BPL_ScrnCopy(
		wk->btn_down[1], scrn, DAT_PX_DOWN_2, DAT_PY_DOWN_2, DAT_SX_DOWN, DAT_SY_DOWN );
	BPL_ScrnCopy(
		wk->btn_down[2], scrn, DAT_PX_DOWN_3, DAT_PY_DOWN_3, DAT_SX_DOWN, DAT_SY_DOWN );

	// ߂
	BPL_ScrnCopy(
		wk->btn_ret[0], scrn, DAT_PX_RETURN_1, DAT_PY_RETURN_1, DAT_SX_RETURN, DAT_SY_RETURN );
	BPL_ScrnCopy(
		wk->btn_ret[1], scrn, DAT_PX_RETURN_2, DAT_PY_RETURN_2, DAT_SX_RETURN, DAT_SY_RETURN );
	BPL_ScrnCopy(
		wk->btn_ret[2], scrn, DAT_PX_RETURN_3, DAT_PY_RETURN_3, DAT_SX_RETURN, DAT_SY_RETURN );

	// 퓬Z<->ReXgZ
	BPL_ScrnCopy(
		wk->btn_contest[0], scrn,
		DAT_PX_CONTEST_1, DAT_PY_CONTEST_1, DAT_SX_CONTEST, DAT_SY_CONTEST );
	BPL_ScrnCopy(
		wk->btn_contest[1], scrn,
		DAT_PX_CONTEST_2, DAT_PY_CONTEST_2, DAT_SX_CONTEST, DAT_SY_CONTEST );
	BPL_ScrnCopy(
		wk->btn_contest[2], scrn,
		DAT_PX_CONTEST_3, DAT_PY_CONTEST_3, DAT_SX_CONTEST, DAT_SY_CONTEST );
}

static void BPL_ScrnCopy( u16 * buf, u16 * scrn, u8 px, u8 py, u8 sx, u8 sy )
{
	u16	i, j;

	for( i=0; i<sy; i++ ){
		for( j=0; j<sx; j++ ){
			buf[i*sx+j] = scrn[ (py+i)*32 + px+j ];
		}
	}
}


static u16 * BPL_ButtonScreenBufGet( BPLIST_WORK * wk, u8 id, u8 num, u8 pat )
{
	switch( id ){
	case BPL_BUTTON_POKE1:
	case BPL_BUTTON_POKE2:
	case BPL_BUTTON_POKE3:
	case BPL_BUTTON_POKE4:
	case BPL_BUTTON_POKE5:
	case BPL_BUTTON_POKE6:
		if( pat == 0 ){
			return wk->btn_plate1[num];
		}else{
			return wk->btn_plate2[num];
		}

	case BPL_BUTTON_RET1:
	case BPL_BUTTON_RET2:
	case BPL_BUTTON_RET3:
	case BPL_BUTTON_RET4:
	case BPL_BUTTON_RET5:
	case BPL_BUTTON_RET6:
	case BPL_BUTTON_RET7:
		return wk->btn_ret[num];

	case BPL_BUTTON_STATUS:
		return wk->btn_st[num];

	case BPL_BUTTON_WAZA1:
	case BPL_BUTTON_WAZA2:
	case BPL_BUTTON_WAZA3:
	case BPL_BUTTON_WAZA4:
		return wk->btn_waza1[num];

	case BPL_BUTTON_CHANGE:
	case BPL_BUTTON_SELECT:
		return wk->btn_chg[num];

	case BPL_BUTTON_UP:
		return wk->btn_up[num];

	case BPL_BUTTON_DOWN:
		return wk->btn_down[num];

	case BPL_BUTTON_WAZASEL1:
	case BPL_BUTTON_WAZASEL2:
	case BPL_BUTTON_WAZASEL3:
	case BPL_BUTTON_WAZASEL4:
	case BPL_BUTTON_WAZASEL5:
	case BPL_BUTTON_WAZARCV1:
	case BPL_BUTTON_WAZARCV2:
	case BPL_BUTTON_WAZARCV3:
	case BPL_BUTTON_WAZARCV4:
		return wk->btn_waza2[num];

	case BPL_BUTTON_CONTEST1:
	case BPL_BUTTON_CONTEST2:
		return wk->btn_contest[num];
	}

	return NULL;
}


static void BPL_ButtonScreenWrite( BPLIST_WORK * wk, u8 id, u8 anm, u8 pat )
{
	u16 * buf = BPL_ButtonScreenBufGet( wk, id, anm, pat );
	GF_BGL_ScrWrite(
		wk->bgl, GF_BGL_FRAME2_S, buf,
		ButtonScreenAnm[id].px, ButtonScreenAnm[id].py,
		ButtonScreenAnm[id].sx, ButtonScreenAnm[id].sy );
	GF_BGL_LoadScreenV_Req( wk->bgl, GF_BGL_FRAME2_S );
}

static void BPL_ButtonBmpWinShift( BPLIST_WORK * wk, u8 id, u8 anm )
{
	const u8 * tbl;
	u16	i;
	u8	dir, ofs;

	tbl = ButtonBmpWinIndex[id];
	if( tbl == NULL ){ return; }

	switch( anm ){
	case 0:
	case 2:
		dir = GF_BGL_BMPWIN_SHIFT_D;
		ofs = 1;
		break;
	case 1:
		dir = GF_BGL_BMPWIN_SHIFT_U;
		ofs = 3;
		break;
	}

	for( i=0; i<8; i++ ){
		if( tbl[i] == 0xff ){ break; }
		GF_BGL_BmpWinShift( &wk->add_win[tbl[i]], dir, ofs, 0 );
		GF_BGL_BmpWinOnVReq( &wk->add_win[tbl[i]] );
	}
}

static void BPL_ButtonObjMove( BPLIST_WORK * wk, u8 id, u8 anm )
{
	if( id >= BPL_BUTTON_POKE1 && id <= BPL_BUTTON_POKE6 ){
		switch( anm ){
		case 0:
		case 2:
			CATS_ObjectPosMoveCap( wk->cap[BPL_CA_ITEM1+id-BPL_BUTTON_POKE1], 0, 1 );
			CATS_ObjectPosMoveCap( wk->cap[BPL_CA_POKE1+id-BPL_BUTTON_POKE1], 0, 1 );
			break;
		case 1:
			CATS_ObjectPosMoveCap( wk->cap[BPL_CA_ITEM1+id-BPL_BUTTON_POKE1], 0, -3 );
			CATS_ObjectPosMoveCap( wk->cap[BPL_CA_POKE1+id-BPL_BUTTON_POKE1], 0, -3 );
			break;
		}
	}else if( id >= BPL_BUTTON_WAZASEL1 && id <= BPL_BUTTON_WAZASEL5 ){
		switch( anm ){
		case 0:
		case 2:
			CATS_ObjectPosMoveCap( wk->cap[BPL_CA_WAZATYPE1+id-BPL_BUTTON_WAZASEL1], 0, 1 );
			break;
		case 1:
			CATS_ObjectPosMoveCap( wk->cap[BPL_CA_WAZATYPE1+id-BPL_BUTTON_WAZASEL1], 0, -3 );
			break;
		}
	}else if( id >= BPL_BUTTON_WAZARCV1 && id <= BPL_BUTTON_WAZARCV4 ){
		switch( anm ){
		case 0:
		case 2:
			CATS_ObjectPosMoveCap( wk->cap[BPL_CA_WAZATYPE1+id-BPL_BUTTON_WAZARCV1], 0, 1 );
			break;
		case 1:
			CATS_ObjectPosMoveCap( wk->cap[BPL_CA_WAZATYPE1+id-BPL_BUTTON_WAZARCV1], 0, -3 );
			break;
		}
	}
}


void BattlePokeList_ButtonAnmInit( BPLIST_WORK * wk, u8 id, u8 mode )
{
	wk->btn_pat = 0;
	if( id >= BPL_BUTTON_POKE1 && id <= BPL_BUTTON_POKE6 ){
		if( BattlePokeList_PokeSetCheck( wk, id - BPL_BUTTON_POKE1 ) == 2 ){
			wk->btn_pat = 1;
		}
	}
	wk->btn_seq  = 0;
	wk->btn_cnt  = 0;
	wk->btn_id   = id;
	wk->btn_mode = mode;
	wk->btn_flg  = 1;
}

void BattlePokeList_ButtonAnmMain( BPLIST_WORK * wk )
{
	if( wk->btn_flg == 0 ){ return; }

	switch( wk->btn_seq ){
	case 0:
		BPL_ButtonScreenWrite( wk, wk->btn_id, 1, wk->btn_pat );
		BPL_ButtonBmpWinShift( wk, wk->btn_id, 1 );
		BPL_ButtonObjMove( wk, wk->btn_id, 1 );
		wk->btn_cnt = 0;
		wk->btn_seq = 1;
		break;

	case 1:
		if( wk->btn_cnt < 1 ){
			wk->btn_cnt++;
			return;
		}
		BPL_ButtonScreenWrite( wk, wk->btn_id, 2, wk->btn_pat );
		BPL_ButtonBmpWinShift( wk, wk->btn_id, 2 );
		BPL_ButtonObjMove( wk, wk->btn_id, 2 );
		wk->btn_cnt = 0;
		wk->btn_seq = 2;
		break;

	case 2:
		if( wk->btn_mode == BPL_BTNANM_MODE_CHG ){
			wk->btn_flg = 0;
		}else{
			if( wk->btn_cnt < 1 ){
				wk->btn_cnt++;
				return;
			}
			BPL_ButtonScreenWrite( wk, wk->btn_id, 0, wk->btn_pat );
			BPL_ButtonBmpWinShift( wk, wk->btn_id, 0 );
			BPL_ButtonObjMove( wk, wk->btn_id, 0 );
			wk->btn_cnt = 0;
			wk->btn_seq = 3;
		}
		break;

	case 3:
		wk->btn_flg = 0;
		break;
	}
}

void BattlePokeList_ButtonPageScreenInit( BPLIST_WORK * wk, u8 page )
{
	switch( page ){
	case BPLIST_PAGE_SELECT:		// |PIy[W
		{
			u8	i, j;

			for( i=0; i<6; i++ ){
				j = BattlePokeList_PokeSetCheck( wk, i );
				if( j == 1 ){
					BPL_ButtonScreenWrite( wk, BPL_BUTTON_POKE1+i, 0, 0 );
				}else if( j == 2 ){
					BPL_ButtonScreenWrite( wk, BPL_BUTTON_POKE1+i, 0, 1 );
				}
			}
		}
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_RET1, 0, 0 );
		break;

	case BPLIST_PAGE_MAIN:			// Xe[^XCy[W
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_STATUS, 0, 0 );
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_WAZA1, 0, 0 );
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_WAZA2, 0, 0 );
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_WAZA3, 0, 0 );
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_WAZA4, 0, 0 );
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_CHANGE, 0, 0 );
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_UP, 0, 0 );
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_DOWN, 0, 0 );
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_RET2, 0, 0 );
		break;

	case BPLIST_PAGE_STATUS:		// Xe[^Xڍ׃y[W
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_RET3, 0, 0 );
		break;

	case BPLIST_PAGE_SKILL:			// Xe[^XZy[W
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_RET4, 0, 0 );
		break;

	case BPLIST_PAGE_SKILL_SET1:	// Xe[^XZYPy[W
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_WAZASEL1, 0, 0 );
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_WAZASEL2, 0, 0 );
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_WAZASEL3, 0, 0 );
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_WAZASEL4, 0, 0 );
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_WAZASEL5, 0, 0 );
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_CONTEST1, 0, 0 );
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_RET5, 0, 0 );
		break;

	case BPLIST_PAGE_SKILL_SET2:	// Xe[^XZYQy[W
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_SELECT, 0, 0 );
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_CONTEST2, 0, 0 );
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_RET6, 0, 0 );
		break;

	case BPLIST_PAGE_PP_RCV:		// PP񕜋ZIy[W
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_WAZARCV1, 0, 0 );
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_WAZARCV2, 0, 0 );
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_WAZARCV3, 0, 0 );
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_WAZARCV4, 0, 0 );
		BPL_ButtonScreenWrite( wk, BPL_BUTTON_RET7, 0, 0 );
		break;
	}
}









//============================================================================================
//============================================================================================
//============================================================================================
#if 0
//============================================================================================

/*
#include "system/window.h"
#include "system/fontproc.h"
#include "system/pmfprint.h"
#include "system/buflen.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_b_bag.h"
#include "itemtool/item.h"
*/

//#include "b_bag_bmp.h"
//#include "b_bag_bmp_def.h"















static void BBAG_ButtonObjMove( BBAG_WORK * wk, u8 id, u8 anm )
{
	CATS_ACT_PTR cap;
	u8	i;

	if( id >= BBAG_BTNANM_ITEM1 && id <= BBAG_BTNANM_ITEM6 ){
		cap = wk->cap[id-BBAG_BTNANM_ITEM1];
	}else if( id == BBAG_BTNANM_USE ){
		for( i=0; i<6; i++ ){
			cap = wk->cap[i];
			if( CATS_ObjectEnableGetCap(cap) != 0 ){
				break;
			}
		}
	}else{
		return;
	}

	switch( anm ){
	case 0:
	case 2:
		CATS_ObjectPosMoveCap( cap, 0, 1 );
		break;
	case 1:
		CATS_ObjectPosMoveCap( cap, 0, -2 );
		break;
	}
}




#endif
