//============================================================================================
/**
 * @file	b_plist_bmp.c
 * @bfief	퓬p|PXgBMP֘A
 * @author	Hiroyuki Nakamura
 * @date	05.02.01
 */
//============================================================================================
#include "common.h"
#include "system/procsys.h"
#include "system/palanm.h"
#include "system/window.h"
#include "system/fontproc.h"
#include "system/msgdata.h"
#include "system/numfont.h"
#include "system/wordset.h"
#include "system/pmfprint.h"
#include "system/buflen.h"
#include "system/clact_tool.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_b_plist.h"
#include "battle/battle_common.h"
#include "battle/fight_tool.h"
#include "poketool/pokeparty.h"
#include "poketool/waza_tool.h"
#include "itemtool/item.h"
#include "application/app_tool.h"
#include "application/p_status.h"

#define	B_PLIST_BMP_H_GLOBAL
#include "b_plist.h"
#include "b_plist_bmp_def.h"
#include "b_plist_main.h"
#include "b_plist_bmp.h"


//============================================================================================
//	萔`
//============================================================================================
#define	PCOL_N_BLACK	( GF_PRINTCOLOR_MAKE( 1, 2, 0 ) )		// tHgJ[F
#define	PCOL_N_WHITE	( GF_PRINTCOLOR_MAKE( 15, 14, 0 ) )		// tHgJ[F
#define	PCOL_N_BLUE		( GF_PRINTCOLOR_MAKE( 5, 6, 0 ) )		// tHgJ[F
#define	PCOL_N_RED		( GF_PRINTCOLOR_MAKE( 3, 4, 0 ) )		// tHgJ[F

#define	PCOL_P1_WHITE	( GF_PRINTCOLOR_MAKE( 15, 14, 0 ) )		// tHgJ[Fy[WPp
#define	PCOL_BTN		( GF_PRINTCOLOR_MAKE( 9, 10, 11 ) )		// tHgJ[F{^

#define	HP_DOTTO_MAX	( 64 )	// HPQ[W̃hbgTCY

#define	HP_GAGE_COL_G1	( 1 )	// HPQ[WJ[΂P
#define	HP_GAGE_COL_G2	( 2 )	// HPQ[WJ[΂Q
#define	HP_GAGE_COL_Y1	( 3 )	// HPQ[WJ[P
#define	HP_GAGE_COL_Y2	( 4 )	// HPQ[WJ[Q
#define	HP_GAGE_COL_R1	( 5 )	// HPQ[WJ[ԂP
#define	HP_GAGE_COL_R2	( 6 )	// HPQ[WJ[ԂQ


//============================================================================================
//	vg^Cv錾
//============================================================================================
extern u8 MsgSpeedGet(void);

static void BPL_Page1BmpWrite( BPLIST_WORK * wk );
static void BPL_Page2BmpWrite( BPLIST_WORK * wk );
static void BPL_Page3BmpWrite( BPLIST_WORK * wk );
static void BPL_Page4BmpWrite( BPLIST_WORK * wk );
static void BPL_Page5BmpWrite( BPLIST_WORK * wk );
static void BPL_Page6BmpWrite( BPLIST_WORK * wk );
static void BPL_Page7BmpWrite( BPLIST_WORK * wk );


//============================================================================================
//	O[oϐ
//============================================================================================
// ʃftHgEBhEf[^
static const BMPWIN_DAT CommBmpData[] =
{
	{	// Rg\
		GF_BGL_FRAME0_S, WIN_P1_COMMENT_PX, WIN_P1_COMMENT_PY,
		WIN_P1_COMMENT_SX, WIN_P1_COMMENT_SY, WIN_P1_COMMENT_PAL, WIN_P1_COMMENT_CGX
	},
	{	// bZ[W\
		GF_BGL_FRAME0_S, WIN_TALK_PX, WIN_TALK_PY,
		WIN_TALK_SX, WIN_TALK_SY, WIN_TALK_PAL, WIN_TALK_CGX
	}
};

// y[WPBMPEBhEf[^
static const BMPWIN_DAT Page1_BmpData[] =
{
	{	// |PP
		GF_BGL_FRAME1_S, WIN_P1_POKE1_PX, WIN_P1_POKE1_PY,
		WIN_P1_POKE1_SX, WIN_P1_POKE1_SY, WIN_P1_POKE1_PAL, WIN_P1_POKE1_CGX
	},
	{	// |PQ
		GF_BGL_FRAME1_S, WIN_P1_POKE2_PX, WIN_P1_POKE2_PY,
		WIN_P1_POKE2_SX, WIN_P1_POKE2_SY, WIN_P1_POKE2_PAL, WIN_P1_POKE2_CGX
	},
	{	// |PR
		GF_BGL_FRAME1_S, WIN_P1_POKE3_PX, WIN_P1_POKE3_PY,
		WIN_P1_POKE3_SX, WIN_P1_POKE3_SY, WIN_P1_POKE3_PAL, WIN_P1_POKE3_CGX
	},
	{	// |PS
		GF_BGL_FRAME1_S, WIN_P1_POKE4_PX, WIN_P1_POKE4_PY,
		WIN_P1_POKE4_SX, WIN_P1_POKE4_SY, WIN_P1_POKE4_PAL, WIN_P1_POKE4_CGX
	},
	{	// |PT
		GF_BGL_FRAME1_S, WIN_P1_POKE5_PX, WIN_P1_POKE5_PY,
		WIN_P1_POKE5_SX, WIN_P1_POKE5_SY, WIN_P1_POKE5_PAL, WIN_P1_POKE5_CGX
	},
	{	// |PU
		GF_BGL_FRAME1_S, WIN_P1_POKE6_PX, WIN_P1_POKE6_PY,
		WIN_P1_POKE6_SX, WIN_P1_POKE6_SY, WIN_P1_POKE6_PAL, WIN_P1_POKE6_CGX
	},
};

// y[WQBMPEBhEf[^
static const BMPWIN_DAT Page2_BmpData[] =
{
	{	// O
		GF_BGL_FRAME0_S, WIN_P2_NAME_PX, WIN_P2_NAME_PY,
		WIN_P2_NAME_SX, WIN_P2_NAME_SY, WIN_P2_NAME_PAL, WIN_P2_NAME_CGX
	},
	{	// x
		GF_BGL_FRAME0_S, WIN_P2_LV_PX, WIN_P2_LV_PY,
		WIN_P2_LV_SX, WIN_P2_LV_SY, WIN_P2_LV_PAL, WIN_P2_LV_CGX
	},
	{	// HP
		GF_BGL_FRAME0_S, WIN_P2_HP_PX, WIN_P2_HP_PY,
		WIN_P2_HP_SX, WIN_P2_HP_SY, WIN_P2_HP_PAL, WIN_P2_HP_CGX
	},
	{	// HPQ[W
		GF_BGL_FRAME0_S, WIN_P2_HPGAGE_PX, WIN_P2_HPGAGE_PY,
		WIN_P2_HPGAGE_SX, WIN_P2_HPGAGE_SY, WIN_P2_HPGAGE_PAL, WIN_P2_HPGAGE_CGX
	},
	{	// 
		GF_BGL_FRAME0_S, WIN_P2_SPA_PX, WIN_P2_SPA_PY,
		WIN_P2_SPA_SX, WIN_P2_SPA_SY, WIN_P2_SPA_PAL, WIN_P2_SPA_CGX
	},
	{	// 
		GF_BGL_FRAME0_S, WIN_P2_ITEM_PX, WIN_P2_ITEM_PY,
		WIN_P2_ITEM_SX, WIN_P2_ITEM_SY, WIN_P2_ITEM_PAL, WIN_P2_ITEM_CGX
	},
	{	// ZP
		GF_BGL_FRAME0_S, WIN_P2_SKILL1_PX, WIN_P2_SKILL1_PY,
		WIN_P2_SKILL1_SX, WIN_P2_SKILL1_SY, WIN_P2_SKILL1_PAL, WIN_P2_SKILL1_CGX
	},
	{	// PP1
		GF_BGL_FRAME0_S, WIN_P2_PP1_PX, WIN_P2_PP1_PY,
		WIN_P2_PP1_SX, WIN_P2_PP1_SY, WIN_P2_PP1_PAL, WIN_P2_PP1_CGX
	},
	{	// PP/PP 1
		GF_BGL_FRAME0_S, WIN_P2_PPNUM1_PX, WIN_P2_PPNUM1_PY,
		WIN_P2_PPNUM1_SX, WIN_P2_PPNUM1_SY, WIN_P2_PPNUM1_PAL, WIN_P2_PPNUM1_CGX
	},
	{	// ZQ
		GF_BGL_FRAME0_S, WIN_P2_SKILL2_PX, WIN_P2_SKILL2_PY,
		WIN_P2_SKILL2_SX, WIN_P2_SKILL2_SY, WIN_P2_SKILL2_PAL, WIN_P2_SKILL2_CGX
	},
	{	// PP2
		GF_BGL_FRAME0_S, WIN_P2_PP2_PX, WIN_P2_PP2_PY,
		WIN_P2_PP2_SX, WIN_P2_PP2_SY, WIN_P2_PP2_PAL, WIN_P2_PP2_CGX
	},
	{	// PP/PP 2
		GF_BGL_FRAME0_S, WIN_P2_PPNUM2_PX, WIN_P2_PPNUM2_PY,
		WIN_P2_PPNUM2_SX, WIN_P2_PPNUM2_SY, WIN_P2_PPNUM2_PAL, WIN_P2_PPNUM2_CGX
	},
	{	// ZR
		GF_BGL_FRAME0_S, WIN_P2_SKILL3_PX, WIN_P2_SKILL3_PY,
		WIN_P2_SKILL3_SX, WIN_P2_SKILL3_SY, WIN_P2_SKILL3_PAL, WIN_P2_SKILL3_CGX
	},
	{	// PP3
		GF_BGL_FRAME0_S, WIN_P2_PP3_PX, WIN_P2_PP3_PY,
		WIN_P2_PP3_SX, WIN_P2_PP3_SY, WIN_P2_PP3_PAL, WIN_P2_PP3_CGX
	},
	{	// PP/PP 3
		GF_BGL_FRAME0_S, WIN_P2_PPNUM3_PX, WIN_P2_PPNUM3_PY,
		WIN_P2_PPNUM3_SX, WIN_P2_PPNUM3_SY, WIN_P2_PPNUM3_PAL, WIN_P2_PPNUM3_CGX
	},
	{	// ZS
		GF_BGL_FRAME0_S, WIN_P2_SKILL4_PX, WIN_P2_SKILL4_PY,
		WIN_P2_SKILL4_SX, WIN_P2_SKILL4_SY, WIN_P2_SKILL4_PAL, WIN_P2_SKILL4_CGX
	},
	{	// PP4
		GF_BGL_FRAME0_S, WIN_P2_PP4_PX, WIN_P2_PP4_PY,
		WIN_P2_PP4_SX, WIN_P2_PP4_SY, WIN_P2_PP4_PAL, WIN_P2_PP4_CGX
	},
	{	// PP/PP 4
		GF_BGL_FRAME0_S, WIN_P2_PPNUM4_PX, WIN_P2_PPNUM4_PY,
		WIN_P2_PPNUM4_SX, WIN_P2_PPNUM4_SY, WIN_P2_PPNUM4_PAL, WIN_P2_PPNUM4_CGX
	},
	{	// uv
		GF_BGL_FRAME1_S, WIN_P2_CHG_PX, WIN_P2_CHG_PY,
		WIN_P2_CHG_SX, WIN_P2_CHG_SY, WIN_P2_CHG_PAL, WIN_P2_CHG_CGX
	},

	// Xbvp
	{	// O
		GF_BGL_FRAME0_S, WIN_P2_NAME_PX, WIN_P2_NAME_PY,
		WIN_P2_NAME_SX, WIN_P2_NAME_SY, WIN_P2_NAME_PAL, WIN_P2_NAME_S_CGX
	},
	{	// x
		GF_BGL_FRAME0_S, WIN_P2_LV_PX, WIN_P2_LV_PY,
		WIN_P2_LV_SX, WIN_P2_LV_SY, WIN_P2_LV_PAL, WIN_P2_LV_S_CGX
	},
	{	// HP
		GF_BGL_FRAME0_S, WIN_P2_HP_PX, WIN_P2_HP_PY,
		WIN_P2_HP_SX, WIN_P2_HP_SY, WIN_P2_HP_PAL, WIN_P2_HP_S_CGX
	},
	{	// HPQ[W
		GF_BGL_FRAME0_S, WIN_P2_HPGAGE_PX, WIN_P2_HPGAGE_PY,
		WIN_P2_HPGAGE_SX, WIN_P2_HPGAGE_SY, WIN_P2_HPGAGE_PAL, WIN_P2_HPGAGE_S_CGX
	},
	{	// 
		GF_BGL_FRAME0_S, WIN_P2_SPA_PX, WIN_P2_SPA_PY,
		WIN_P2_SPA_SX, WIN_P2_SPA_SY, WIN_P2_SPA_PAL, WIN_P2_SPA_S_CGX
	},
	{	// 
		GF_BGL_FRAME0_S, WIN_P2_ITEM_PX, WIN_P2_ITEM_PY,
		WIN_P2_ITEM_SX, WIN_P2_ITEM_SY, WIN_P2_ITEM_PAL, WIN_P2_ITEM_S_CGX
	},
	{	// ZP
		GF_BGL_FRAME0_S, WIN_P2_SKILL1_PX, WIN_P2_SKILL1_PY,
		WIN_P2_SKILL1_SX, WIN_P2_SKILL1_SY, WIN_P2_SKILL1_PAL, WIN_P2_SKILL1_S_CGX
	},
	{	// PP1
		GF_BGL_FRAME0_S, WIN_P2_PP1_PX, WIN_P2_PP1_PY,
		WIN_P2_PP1_SX, WIN_P2_PP1_SY, WIN_P2_PP1_PAL, WIN_P2_PP1_S_CGX
	},
	{	// PP/PP 1
		GF_BGL_FRAME0_S, WIN_P2_PPNUM1_PX, WIN_P2_PPNUM1_PY,
		WIN_P2_PPNUM1_SX, WIN_P2_PPNUM1_SY, WIN_P2_PPNUM1_PAL, WIN_P2_PPNUM1_S_CGX
	},
	{	// ZQ
		GF_BGL_FRAME0_S, WIN_P2_SKILL2_PX, WIN_P2_SKILL2_PY,
		WIN_P2_SKILL2_SX, WIN_P2_SKILL2_SY, WIN_P2_SKILL2_PAL, WIN_P2_SKILL2_S_CGX
	},
	{	// PP2
		GF_BGL_FRAME0_S, WIN_P2_PP2_PX, WIN_P2_PP2_PY,
		WIN_P2_PP2_SX, WIN_P2_PP2_SY, WIN_P2_PP2_PAL, WIN_P2_PP2_S_CGX
	},
	{	// PP/PP 2
		GF_BGL_FRAME0_S, WIN_P2_PPNUM2_PX, WIN_P2_PPNUM2_PY,
		WIN_P2_PPNUM2_SX, WIN_P2_PPNUM2_SY, WIN_P2_PPNUM2_PAL, WIN_P2_PPNUM2_S_CGX
	},
	{	// ZR
		GF_BGL_FRAME0_S, WIN_P2_SKILL3_PX, WIN_P2_SKILL3_PY,
		WIN_P2_SKILL3_SX, WIN_P2_SKILL3_SY, WIN_P2_SKILL3_PAL, WIN_P2_SKILL3_S_CGX
	},
	{	// PP3
		GF_BGL_FRAME0_S, WIN_P2_PP3_PX, WIN_P2_PP3_PY,
		WIN_P2_PP3_SX, WIN_P2_PP3_SY, WIN_P2_PP3_PAL, WIN_P2_PP3_S_CGX
	},
	{	// PP/PP 3
		GF_BGL_FRAME0_S, WIN_P2_PPNUM3_PX, WIN_P2_PPNUM3_PY,
		WIN_P2_PPNUM3_SX, WIN_P2_PPNUM3_SY, WIN_P2_PPNUM3_PAL, WIN_P2_PPNUM3_S_CGX
	},
	{	// ZS
		GF_BGL_FRAME0_S, WIN_P2_SKILL4_PX, WIN_P2_SKILL4_PY,
		WIN_P2_SKILL4_SX, WIN_P2_SKILL4_SY, WIN_P2_SKILL4_PAL, WIN_P2_SKILL4_S_CGX
	},
	{	// PP4
		GF_BGL_FRAME0_S, WIN_P2_PP4_PX, WIN_P2_PP4_PY,
		WIN_P2_PP4_SX, WIN_P2_PP4_SY, WIN_P2_PP4_PAL, WIN_P2_PP4_S_CGX
	},
	{	// PP/PP 4
		GF_BGL_FRAME0_S, WIN_P2_PPNUM4_PX, WIN_P2_PPNUM4_PY,
		WIN_P2_PPNUM4_SX, WIN_P2_PPNUM4_SY, WIN_P2_PPNUM4_PAL, WIN_P2_PPNUM4_S_CGX
	}
};

// y[WRBMPEBhEf[^
static const BMPWIN_DAT Page3_BmpData[] =
{
	{	// O
		GF_BGL_FRAME1_S, WIN_P3_NAME_PX, WIN_P3_NAME_PY,
		WIN_P3_NAME_SX, WIN_P3_NAME_SY, WIN_P3_NAME_PAL, WIN_P3_NAME_CGX
	},
	{	// 
		GF_BGL_FRAME1_S, WIN_P3_SPANAME_PX, WIN_P3_SPANAME_PY,
		WIN_P3_SPANAME_SX, WIN_P3_SPANAME_SY, WIN_P3_SPANAME_PAL, WIN_P3_SPANAME_CGX
	},
	{	// 
		GF_BGL_FRAME1_S, WIN_P3_SPAINFO_PX, WIN_P3_SPAINFO_PY,
		WIN_P3_SPAINFO_SX, WIN_P3_SPAINFO_SY, WIN_P3_SPAINFO_PAL, WIN_P3_SPAINFO_CGX
	},
	{	// 
		GF_BGL_FRAME1_S, WIN_P3_ITEMNAME_PX, WIN_P3_ITEMNAME_PY,
		WIN_P3_ITEMNAME_SX, WIN_P3_ITEMNAME_SY, WIN_P3_ITEMNAME_PAL, WIN_P3_ITEMNAME_CGX
	},
	{	// 
		GF_BGL_FRAME1_S, WIN_P3_ITEMINFO_PX, WIN_P3_ITEMINFO_PY,
		WIN_P3_ITEMINFO_SX, WIN_P3_ITEMINFO_SY, WIN_P3_ITEMINFO_PAL, WIN_P3_ITEMINFO_CGX
	},
	{	// uHPv
		GF_BGL_FRAME1_S, WIN_P3_HP_PX, WIN_P3_HP_PY,
		WIN_P3_HP_SX, WIN_P3_HP_SY, WIN_P3_HP_PAL, WIN_P3_HP_CGX
	},
	{	// uv
		GF_BGL_FRAME1_S, WIN_P3_POW_PX, WIN_P3_POW_PY,
		WIN_P3_POW_SX, WIN_P3_POW_SY, WIN_P3_POW_PAL, WIN_P3_POW_CGX
	},
	{	// uڂv
		GF_BGL_FRAME1_S, WIN_P3_DEF_PX, WIN_P3_DEF_PY,
		WIN_P3_DEF_SX, WIN_P3_DEF_SY, WIN_P3_DEF_PAL, WIN_P3_DEF_CGX
	},
	{	// u΂₳v
		GF_BGL_FRAME1_S, WIN_P3_AGI_PX, WIN_P3_AGI_PY,
		WIN_P3_AGI_SX, WIN_P3_AGI_SY, WIN_P3_AGI_PAL, WIN_P3_AGI_CGX
	},
	{	// uƂv
		GF_BGL_FRAME1_S, WIN_P3_SPP_PX, WIN_P3_SPP_PY,
		WIN_P3_SPP_SX, WIN_P3_SPP_SY, WIN_P3_SPP_PAL, WIN_P3_SPP_CGX
	},
	{	// uƂڂv
		GF_BGL_FRAME1_S, WIN_P3_SPD_PX, WIN_P3_SPD_PY,
		WIN_P3_SPD_SX, WIN_P3_SPD_SY, WIN_P3_SPD_PAL, WIN_P3_SPD_CGX
	},
	{	// HPl
		GF_BGL_FRAME1_S, WIN_P3_HPNUM_PX, WIN_P3_HPNUM_PY,
		WIN_P3_HPNUM_SX, WIN_P3_HPNUM_SY, WIN_P3_HPNUM_PAL, WIN_P3_HPNUM_CGX
	},
	{	// Ul
		GF_BGL_FRAME1_S, WIN_P3_POWNUM_PX, WIN_P3_POWNUM_PY,
		WIN_P3_POWNUM_SX, WIN_P3_POWNUM_SY, WIN_P3_POWNUM_PAL, WIN_P3_POWNUM_CGX
	},
	{	// hl
		GF_BGL_FRAME1_S, WIN_P3_DEFNUM_PX, WIN_P3_DEFNUM_PY,
		WIN_P3_DEFNUM_SX, WIN_P3_DEFNUM_SY, WIN_P3_DEFNUM_PAL, WIN_P3_DEFNUM_CGX
	},
	{	// fl
		GF_BGL_FRAME1_S, WIN_P3_AGINUM_PX, WIN_P3_AGINUM_PY,
		WIN_P3_AGINUM_SX, WIN_P3_AGINUM_SY, WIN_P3_AGINUM_PAL, WIN_P3_AGINUM_CGX
	},
	{	// Ul
		GF_BGL_FRAME1_S, WIN_P3_SPPNUM_PX, WIN_P3_SPPNUM_PY,
		WIN_P3_SPPNUM_SX, WIN_P3_SPPNUM_SY, WIN_P3_SPPNUM_PAL, WIN_P3_SPPNUM_CGX
	},
	{	// hl
		GF_BGL_FRAME1_S, WIN_P3_SPDNUM_PX, WIN_P3_SPDNUM_PY,
		WIN_P3_SPDNUM_SX, WIN_P3_SPDNUM_SY, WIN_P3_SPDNUM_PAL, WIN_P3_SPDNUM_CGX
	},
	{	// HPQ[W
		GF_BGL_FRAME1_S, WIN_P3_HPGAGE_PX, WIN_P3_HPGAGE_PY,
		WIN_P3_HPGAGE_SX, WIN_P3_HPGAGE_SY, WIN_P3_HPGAGE_PAL, WIN_P3_HPGAGE_CGX
	},
	{	// uLv.v
		GF_BGL_FRAME1_S, WIN_P3_LV_PX, WIN_P3_LV_PY,
		WIN_P3_LV_SX, WIN_P3_LV_SY, WIN_P3_LV_PAL, WIN_P3_LV_CGX
	},
	{	// xl
		GF_BGL_FRAME1_S, WIN_P3_LVNUM_PX, WIN_P3_LVNUM_PY,
		WIN_P3_LVNUM_SX, WIN_P3_LVNUM_SY, WIN_P3_LVNUM_PAL, WIN_P3_LVNUM_CGX
	},
	{	// u̃x܂Łv
		GF_BGL_FRAME1_S, WIN_P3_NEXT_PX, WIN_P3_NEXT_PY,
		WIN_P3_NEXT_SX, WIN_P3_NEXT_SY, WIN_P3_NEXT_PAL, WIN_P3_NEXT_CGX
	},
	{	// ̃xl
		GF_BGL_FRAME1_S, WIN_P3_NEXTNUM_PX, WIN_P3_NEXTNUM_PY,
		WIN_P3_NEXTNUM_SX, WIN_P3_NEXTNUM_SY, WIN_P3_NEXTNUM_PAL, WIN_P3_NEXTNUM_CGX
	}
};

// y[WSBMPEBhEf[^
static const BMPWIN_DAT Page4_BmpData[] =
{
	{	// O
		GF_BGL_FRAME1_S, WIN_P4_NAME_PX, WIN_P4_NAME_PY,
		WIN_P4_NAME_SX, WIN_P4_NAME_SY, WIN_P4_NAME_PAL, WIN_P4_NAME_CGX
	},
	{	// Z
		GF_BGL_FRAME1_S, WIN_P4_SKILL_PX, WIN_P4_SKILL_PY,
		WIN_P4_SKILL_SX, WIN_P4_SKILL_SY, WIN_P4_SKILL_PAL, WIN_P4_SKILL_CGX
	},
	{	// PP
		GF_BGL_FRAME1_S, WIN_P4_PP_PX, WIN_P4_PP_PY,
		WIN_P4_PP_SX, WIN_P4_PP_SY, WIN_P4_PP_PAL, WIN_P4_PP_CGX
	},
	{	// PP/PP
		GF_BGL_FRAME1_S, WIN_P4_PPNUM_PX, WIN_P4_PPNUM_PY,
		WIN_P4_PPNUM_SX, WIN_P4_PPNUM_SY, WIN_P4_PPNUM_PAL, WIN_P4_PPNUM_CGX
	},
	{	// u߂イv
		GF_BGL_FRAME1_S, WIN_P4_HIT_PX, WIN_P4_HIT_PY,
		WIN_P4_HIT_SX, WIN_P4_HIT_SY, WIN_P4_HIT_PAL, WIN_P4_HIT_CGX
	},
	{	// u傭v
		GF_BGL_FRAME1_S, WIN_P4_POW_PX, WIN_P4_POW_PY,
		WIN_P4_POW_SX, WIN_P4_POW_SY, WIN_P4_POW_PAL, WIN_P4_POW_CGX
	},
	{	// l
		GF_BGL_FRAME1_S, WIN_P4_HITNUM_PX, WIN_P4_HITNUM_PY,
		WIN_P4_HITNUM_SX, WIN_P4_HITNUM_SY, WIN_P4_HITNUM_PAL, WIN_P4_HITNUM_CGX
	},
	{	// З͒l
		GF_BGL_FRAME1_S, WIN_P4_POWNUM_PX, WIN_P4_POWNUM_PY,
		WIN_P4_POWNUM_SX, WIN_P4_POWNUM_SY, WIN_P4_POWNUM_PAL, WIN_P4_POWNUM_CGX
	},
	{	// Z
		GF_BGL_FRAME1_S, WIN_P4_INFO_PX, WIN_P4_INFO_PY,
		WIN_P4_INFO_SX, WIN_P4_INFO_SY, WIN_P4_INFO_PAL, WIN_P4_INFO_CGX
	},
	{	// uԂ邢v
		GF_BGL_FRAME1_S, WIN_P4_BUNRUI_PX, WIN_P4_BUNRUI_PY,
		WIN_P4_BUNRUI_SX, WIN_P4_BUNRUI_SY, WIN_P4_BUNRUI_PAL, WIN_P4_BUNRUI_CGX
	},
	{	// ޖ
		GF_BGL_FRAME1_S, WIN_P4_BRNAME_PX, WIN_P4_BRNAME_PY,
		WIN_P4_BRNAME_SX, WIN_P4_BRNAME_SY, WIN_P4_BRNAME_PAL, WIN_P4_BRNAME_CGX
	}
};

// y[WTBMPEBhEf[^
static const BMPWIN_DAT Page5_BmpData[] =
{
	{	// O
		GF_BGL_FRAME1_S, WIN_P5_NAME_PX, WIN_P5_NAME_PY,
		WIN_P5_NAME_SX, WIN_P5_NAME_SY, WIN_P5_NAME_PAL, WIN_P5_NAME_CGX
	},
	{	// ZP
		GF_BGL_FRAME1_S, WIN_P5_SKILL1_PX, WIN_P5_SKILL1_PY,
		WIN_P5_SKILL1_SX, WIN_P5_SKILL1_SY, WIN_P5_SKILL1_PAL, WIN_P5_SKILL1_CGX
	},
	{	// ZQ
		GF_BGL_FRAME1_S, WIN_P5_SKILL2_PX, WIN_P5_SKILL2_PY,
		WIN_P5_SKILL2_SX, WIN_P5_SKILL2_SY, WIN_P5_SKILL2_PAL, WIN_P5_SKILL2_CGX
	},
	{	// ZR
		GF_BGL_FRAME1_S, WIN_P5_SKILL3_PX, WIN_P5_SKILL3_PY,
		WIN_P5_SKILL3_SX, WIN_P5_SKILL3_SY, WIN_P5_SKILL3_PAL, WIN_P5_SKILL3_CGX
	},
	{	// ZS
		GF_BGL_FRAME1_S, WIN_P5_SKILL4_PX, WIN_P5_SKILL4_PY,
		WIN_P5_SKILL4_SX, WIN_P5_SKILL4_SY, WIN_P5_SKILL4_PAL, WIN_P5_SKILL4_CGX
	},
	{	// ZT
		GF_BGL_FRAME1_S, WIN_P5_SKILL5_PX, WIN_P5_SKILL5_PY,
		WIN_P5_SKILL5_SX, WIN_P5_SKILL5_SY, WIN_P5_SKILL5_PAL, WIN_P5_SKILL5_CGX
	},
};

// y[WUBMPEBhEf[^
static const BMPWIN_DAT Page6_BmpData[] =
{
	{	// O
		GF_BGL_FRAME1_S, WIN_P6_NAME_PX, WIN_P6_NAME_PY,
		WIN_P6_NAME_SX, WIN_P6_NAME_SY, WIN_P6_NAME_PAL, WIN_P6_NAME_CGX
	},
	{	// Z
		GF_BGL_FRAME1_S, WIN_P6_SKILL_PX, WIN_P6_SKILL_PY,
		WIN_P6_SKILL_SX, WIN_P6_SKILL_SY, WIN_P6_SKILL_PAL, WIN_P6_SKILL_CGX
	},
	{	// PP
		GF_BGL_FRAME1_S, WIN_P6_PP_PX, WIN_P6_PP_PY,
		WIN_P6_PP_SX, WIN_P6_PP_SY, WIN_P6_PP_PAL, WIN_P6_PP_CGX
	},
	{	// PP/PP
		GF_BGL_FRAME1_S, WIN_P6_PPNUM_PX, WIN_P6_PPNUM_PY,
		WIN_P6_PPNUM_SX, WIN_P6_PPNUM_SY, WIN_P6_PPNUM_PAL, WIN_P6_PPNUM_CGX
	},
	{	// u߂イv
		GF_BGL_FRAME1_S, WIN_P6_HIT_PX, WIN_P6_HIT_PY,
		WIN_P6_HIT_SX, WIN_P6_HIT_SY, WIN_P6_HIT_PAL, WIN_P6_HIT_CGX
	},
	{	// u傭v
		GF_BGL_FRAME1_S, WIN_P6_POW_PX, WIN_P6_POW_PY,
		WIN_P6_POW_SX, WIN_P6_POW_SY, WIN_P6_POW_PAL, WIN_P6_POW_CGX
	},
	{	// l
		GF_BGL_FRAME1_S, WIN_P6_HITNUM_PX, WIN_P6_HITNUM_PY,
		WIN_P6_HITNUM_SX, WIN_P6_HITNUM_SY, WIN_P6_HITNUM_PAL, WIN_P6_HITNUM_CGX
	},
	{	// З͒l
		GF_BGL_FRAME1_S, WIN_P6_POWNUM_PX, WIN_P6_POWNUM_PY,
		WIN_P6_POWNUM_SX, WIN_P6_POWNUM_SY, WIN_P6_POWNUM_PAL, WIN_P6_POWNUM_CGX
	},
	{	// Z
		GF_BGL_FRAME1_S, WIN_P6_INFO_PX, WIN_P6_INFO_PY,
		WIN_P6_INFO_SX, WIN_P6_INFO_SY, WIN_P6_INFO_PAL, WIN_P6_INFO_CGX
	},
	{	// uԂ邢v
		GF_BGL_FRAME1_S, WIN_P6_BUNRUI_PX, WIN_P6_BUNRUI_PY,
		WIN_P6_BUNRUI_SX, WIN_P6_BUNRUI_SY, WIN_P6_BUNRUI_PAL, WIN_P6_BUNRUI_CGX
	},
	{	// ޖ
		GF_BGL_FRAME1_S, WIN_P6_BRNAME_PX, WIN_P6_BRNAME_PY,
		WIN_P6_BRNAME_SX, WIN_P6_BRNAME_SY, WIN_P6_BRNAME_PAL, WIN_P6_BRNAME_CGX
	},
	{	// u킷v
		GF_BGL_FRAME1_S, WIN_P6_WASURERU_PX, WIN_P6_WASURERU_PY,
		WIN_P6_WASURERU_SX, WIN_P6_WASURERU_SY, WIN_P6_WASURERU_PAL, WIN_P6_WASURERU_CGX
	}
};

// y[WVBMPEBhEf[^
static const BMPWIN_DAT Page7_BmpData[] =
{
	{	// O
		GF_BGL_FRAME1_S, WIN_P7_NAME_PX, WIN_P7_NAME_PY,
		WIN_P7_NAME_SX, WIN_P7_NAME_SY, WIN_P7_NAME_PAL, WIN_P7_NAME_CGX
	},
	{	// ZP
		GF_BGL_FRAME1_S, WIN_P7_SKILL1_PX, WIN_P7_SKILL1_PY,
		WIN_P7_SKILL1_SX, WIN_P7_SKILL1_SY, WIN_P7_SKILL1_PAL, WIN_P7_SKILL1_CGX
	},
	{	// ZQ
		GF_BGL_FRAME1_S, WIN_P7_SKILL2_PX, WIN_P7_SKILL2_PY,
		WIN_P7_SKILL2_SX, WIN_P7_SKILL2_SY, WIN_P7_SKILL2_PAL, WIN_P7_SKILL2_CGX
	},
	{	// ZR
		GF_BGL_FRAME1_S, WIN_P7_SKILL3_PX, WIN_P7_SKILL3_PY,
		WIN_P7_SKILL3_SX, WIN_P7_SKILL3_SY, WIN_P7_SKILL3_PAL, WIN_P7_SKILL3_CGX
	},
	{	// ZS
		GF_BGL_FRAME1_S, WIN_P7_SKILL4_PX, WIN_P7_SKILL4_PY,
		WIN_P7_SKILL4_SX, WIN_P7_SKILL4_SY, WIN_P7_SKILL4_PAL, WIN_P7_SKILL4_CGX
	},
};

// |P̃bZ[WID
static const u32 NameMsgID_Tbl[] = {
	mes_b_plist_01_001,
	mes_b_plist_01_101,
	mes_b_plist_01_201,
	mes_b_plist_01_301,
	mes_b_plist_01_401,
	mes_b_plist_01_501
};

// Z̃bZ[WID
static const u32 WazaMsgID_Tbl[] = {
	mes_b_plist_02_100,
	mes_b_plist_02_200,
	mes_b_plist_02_300,
	mes_b_plist_02_400,
};

// Z̃bZ[WIDiy[WTj
static const u32 P5_WazaMsgID_Tbl[] = {
	mes_b_plist_05_100,
	mes_b_plist_05_200,
	mes_b_plist_05_300,
	mes_b_plist_05_400,
	mes_b_plist_05_500
};


//--------------------------------------------------------------------------------------------
/**
 * BMPEBhE
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BattlePokeList_BmpInit( BPLIST_WORK * wk )
{
	u32	i;

	for( i=0; i<WIN_MAX; i++ ){
		GF_BGL_BmpWinAddEx( wk->bgl, &wk->win[i], &CommBmpData[i] );
	}
	BattlePokeList_BmpAdd( wk, wk->page );

	OS_Printf( "BPLIST1 : %d\n", WIN_P1_POKE6_CGX+WIN_P1_POKE6_SX*WIN_P1_POKE6_SY );
	OS_Printf( "BPLIST2 : %d\n", WIN_P2_PPNUM4_S_CGX+WIN_P2_PPNUM4_SX*WIN_P2_PPNUM4_SY );
	OS_Printf( "BPLIST3 : %d\n", WIN_P3_NEXTNUM_CGX+WIN_P3_NEXTNUM_SX*WIN_P3_NEXTNUM_SY );
	OS_Printf( "BPLIST4 : %d\n", WIN_P4_BRNAME_CGX+WIN_P4_BRNAME_SX*WIN_P4_BRNAME_SY );
	OS_Printf( "BPLIST5 : %d\n", WIN_P5_SKILL5_CGX+WIN_P5_SKILL5_SX*WIN_P5_SKILL5_SY );
	OS_Printf( "BPLIST6 : %d\n", WIN_P6_WASURERU_CGX+WIN_P6_WASURERU_SX*WIN_P6_WASURERU_SY );
	OS_Printf( "BPLIST7 : %d\n", WIN_P7_SKILL4_CGX+WIN_P7_SKILL4_SX*WIN_P7_SKILL4_SY );
}

//--------------------------------------------------------------------------------------------
/**
 * y[WƂBMPEBhEǉ
 *
 * @param	wk		[N
 * @param	page	y[W
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BattlePokeList_BmpAdd( BPLIST_WORK * wk, u32 page )
{
	const BMPWIN_DAT * dat;
	u8	i;

	switch( page ){
	case BPLIST_PAGE_SELECT:		// |PIy[W
		dat = Page1_BmpData;
		wk->bmp_add_max = WIN_P1_MAX;
		break;
	case BPLIST_PAGE_MAIN:			// Xe[^XCy[W
		dat = Page2_BmpData;
		wk->bmp_add_max = WIN_P2_MAX;
		break;
	case BPLIST_PAGE_STATUS:		// Xe[^Xڍ׃y[W
		dat = Page3_BmpData;
		wk->bmp_add_max = WIN_P3_MAX;
		break;
	case BPLIST_PAGE_SKILL:			// Xe[^XZy[W
		dat = Page4_BmpData;
		wk->bmp_add_max = WIN_P4_MAX;
		break;
	case BPLIST_PAGE_SKILL_SET1:	// Xe[^XZYPy[W
		dat = Page5_BmpData;
		wk->bmp_add_max = WIN_P5_MAX;
		break;
	case BPLIST_PAGE_SKILL_SET2:	// Xe[^XZYQy[W
		dat = Page6_BmpData;
		wk->bmp_add_max = WIN_P6_MAX;
		break;
	case BPLIST_PAGE_PP_RCV:		// PP񕜋ZIy[W
		dat = Page7_BmpData;
		wk->bmp_add_max = WIN_P7_MAX;
		break;
	}

	wk->add_win = GF_BGL_BmpWinAllocGet( wk->dat->heap, wk->bmp_add_max );
	for( i=0; i<wk->bmp_add_max; i++ ){
		GF_BGL_BmpWinAddEx( wk->bgl, &wk->add_win[i], &dat[i] );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * ǉBMPEBhE폜
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BattlePokeList_BmpFree( BPLIST_WORK * wk )
{
	GF_BGL_BmpWinFree( wk->add_win, wk->bmp_add_max );
}

//--------------------------------------------------------------------------------------------
/**
 * BMPEBhES폜
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BattlePokeList_BmpFreeAll( BPLIST_WORK * wk )
{
	u32	i;

	GF_BGL_BmpWinFree( wk->add_win, wk->bmp_add_max );
	for( i=0; i<WIN_MAX; i++ ){
		GF_BGL_BmpWinDel( &wk->win[i] );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * BMP
 *
 * @param	wk		[N
 * @param	page	y[W
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BattlePokeList_BmpWrite( BPLIST_WORK * wk, u32 page )
{
	switch( page ){
	case BPLIST_PAGE_SELECT:		// |PIy[W
		BPL_Page1BmpWrite( wk );
		break;
	case BPLIST_PAGE_MAIN:			// Xe[^XCy[W
		BPL_Page2BmpWrite( wk );
		break;
	case BPLIST_PAGE_STATUS:		// Xe[^Xڍ׃y[W
		BPL_Page3BmpWrite( wk );
		break;
	case BPLIST_PAGE_SKILL:			// Xe[^XZy[W
		BPL_Page4BmpWrite( wk );
		break;
	case BPLIST_PAGE_SKILL_SET1:	// Xe[^XZYPy[W
		BPL_Page5BmpWrite( wk );
		break;
	case BPLIST_PAGE_SKILL_SET2:	// Xe[^XZYQy[W
		BPL_Page6BmpWrite( wk );
		break;
	case BPLIST_PAGE_PP_RCV:		// PP񕜋ZIy[W
		BPL_Page7BmpWrite( wk );
		break;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * |P\
 *
 * @param	wk		[N
 * @param	idx		EBhECfbNX
 * @param	pos		|Pʒu
 * @param	px		\XW
 * @param	py		\YW
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_NamePut( BPLIST_WORK * wk, u32 idx, u32 fidx, u16 pos, u8 px, u8 py )
{
	GF_BGL_BMPWIN * win;
	BPL_POKEDATA * pd;
	STRBUF * exp;
	STRBUF * str;
	u32	sex_px;

	win = &wk->add_win[idx];
	pd  = &wk->poke[pos];
	exp = STRBUF_Create( BUFLEN_POKEMON_NAME, wk->dat->heap );
	str = MSGMAN_AllocString( wk->mman, NameMsgID_Tbl[pos] );

	WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(pd->pp) );
	WORDSET_ExpandStr( wk->wset, exp, str );

	if( fidx == FONT_SYSTEM ){
		GF_STR_PrintColor( win, fidx, exp, px, py, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	}else{
		GF_STR_PrintColor( win, fidx, exp, px, py, MSG_NO_PUT, PCOL_BTN, NULL );
	}

	STRBUF_Delete( str );
	STRBUF_Delete( exp );

	// 
	if( pd->sex == PARA_MALE ){
		str = MSGMAN_AllocString( wk->mman, mes_b_plist_02_502 );
		sex_px = GF_BGL_BmpWinGet_SizeX(win)*8-FontProc_GetPrintStrWidth(FONT_SYSTEM,str,0);
		if( fidx == FONT_SYSTEM ){
			GF_STR_PrintColor( win, fidx, str, sex_px, py, MSG_NO_PUT, PCOL_N_BLUE, NULL );
		}else{
			GF_STR_PrintColor( win, fidx, str, sex_px, py, MSG_NO_PUT, PCOL_BTN, NULL );
		}
		STRBUF_Delete( str );
	}else if( pd->sex == PARA_FEMALE ){
		str = MSGMAN_AllocString( wk->mman, mes_b_plist_02_503 );
		sex_px = GF_BGL_BmpWinGet_SizeX(win)*8-FontProc_GetPrintStrWidth(FONT_SYSTEM,str,0);
		if( fidx == FONT_SYSTEM ){
			GF_STR_PrintColor( win, fidx, str, sex_px, py, MSG_NO_PUT, PCOL_N_RED, NULL );
		}else{
			GF_STR_PrintColor( win, fidx, str, sex_px, py, MSG_NO_PUT, PCOL_BTN, NULL );
		}
		STRBUF_Delete( str );
	}

	GF_BGL_BmpWinOnVReq( win );
}

//--------------------------------------------------------------------------------------------
/**
 * x\
 *
 * @param	wk		[N
 * @param	idx		EBhECfbNX
 * @param	pos		|Pʒu
 * @param	px		\XW
 * @param	py		\YW
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_LvPut( BPLIST_WORK * wk, u32 idx, u16 pos, u8 px, u8 py )
{
	BPL_POKEDATA * pd = &wk->poke[pos];

	NUMFONT_WriteSet(
		wk->nfnt, NUMFONT_MARK_LV, pd->lv, 3, NUMFONT_MODE_LEFT, &wk->add_win[idx], px+8, py );

	GF_BGL_BmpWinOnVReq( &wk->add_win[idx] );
}

//--------------------------------------------------------------------------------------------
/**
 * HP\
 *
 * @param	wk		[N
 * @param	idx		EBhECfbNX
 * @param	pos		|Pʒu
 * @param	px		\XW
 * @param	py		\YW
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_HPPut( BPLIST_WORK * wk, u32 idx, u16 pos, u8 px, u8 py )
{
	BPL_POKEDATA * pd = &wk->poke[pos];

	NUMFONT_WriteNumber(
		wk->nfnt, pd->hp, 3, NUMFONT_MODE_SPACE, &wk->add_win[idx], px, py );
	NUMFONT_WriteNumber(
		wk->nfnt, pd->mhp, 3, NUMFONT_MODE_LEFT,
		&wk->add_win[idx], px+NUMFONT_NUM_WIDTH*3+8, py );

	GF_BGL_BmpWinOnVReq( &wk->add_win[idx] );
}

//--------------------------------------------------------------------------------------------
/**
 * HPQ[W\
 *
 * @param	wk		[N
 * @param	idx		EBhECfbNX
 * @param	pos		|Pʒu
 * @param	px		\XW
 * @param	py		\YW
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_HPGagePut( BPLIST_WORK * wk, u32 idx, u16 pos, u8 px, u8 py )
{
	BPL_POKEDATA * pd;
	u8	col=1;
	u8	dot;

	pd  = &wk->poke[pos];
	col = 1;
	dot = GetNumDotto( pd->hp, pd->mhp, HP_DOTTO_MAX );

	switch( GetHPGaugeDottoColor( pd->hp, pd->mhp, HP_DOTTO_MAX ) ){
	case HP_DOTTO_NULL:
		return;
	case HP_DOTTO_MAX:		// 
	case HP_DOTTO_GREEN:
		col = HP_GAGE_COL_G1;
		break;
	case HP_DOTTO_YELLOW:	// 
		col = HP_GAGE_COL_Y1;
		break;
	case HP_DOTTO_RED:		// 
		col = HP_GAGE_COL_R1;
		break;
	}

	GF_BGL_BmpWinFill( &wk->add_win[idx], col+1, px, py+2, dot, 1 );
	GF_BGL_BmpWinFill( &wk->add_win[idx], col,   px, py+3, dot, 2 );
	GF_BGL_BmpWinFill( &wk->add_win[idx], col+1, px, py+5, dot, 1 );

	GF_BGL_BmpWinOnVReq( &wk->add_win[idx] );
}

//--------------------------------------------------------------------------------------------
/**
 * \
 *
 * @param	wk		[N
 * @param	idx		EBhECfbNX
 * @param	pos		|Pʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_TokuseiPut( BPLIST_WORK * wk, u32 idx, u32 pos )
{
	BPL_POKEDATA * pd;
	STRBUF * exp;
	STRBUF * str;

	pd  = &wk->poke[pos];
	exp = STRBUF_Create( BUFLEN_POKEMON_ABILITY_NAME, wk->dat->heap );
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_02_000 );

	WORDSET_RegisterTokuseiName( wk->wset, 0, pd->spa );
	WORDSET_ExpandStr( wk->wset, exp, str );

	GF_STR_PrintColor(
		&wk->add_win[idx], FONT_SYSTEM, exp, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );

	STRBUF_Delete( str );
	STRBUF_Delete( exp );

	GF_BGL_BmpWinOnVReq( &wk->add_win[idx] );
}

//--------------------------------------------------------------------------------------------
/**
 * ACe\
 *
 * @param	wk		[N
 * @param	idx		EBhECfbNX
 * @param	pos		|Pʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_ItemPut( BPLIST_WORK * wk, u32 idx, u32 pos )
{
	BPL_POKEDATA * pd;
	STRBUF * exp;
	STRBUF * str;

	pd  = &wk->poke[pos];
	if( pd->item == 0 ){
		exp = MSGMAN_AllocString( wk->mman, mes_b_plist_02_600 );
	}else{
		exp = STRBUF_Create( BUFLEN_ITEM_NAME, wk->dat->heap );
		str = MSGMAN_AllocString( wk->mman, mes_b_plist_02_001 );
		WORDSET_RegisterItemName( wk->wset, 0, pd->item );
		WORDSET_ExpandStr( wk->wset, exp, str );
		STRBUF_Delete( str );
	}
	GF_STR_PrintColor(
		&wk->add_win[idx], FONT_SYSTEM, exp, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );

	STRBUF_Delete( exp );

	GF_BGL_BmpWinOnVReq( &wk->add_win[idx] );
}

//--------------------------------------------------------------------------------------------
/**
 * Z\
 *
 * @param	wk		[N
 * @param	waza	Zԍ
 * @param	widx	EBhECfbNX
 * @param	midx	bZ[WCfbNX
 * @param	fidx	tHgCfbNX
 * @param	py		YW
 * @param	col		J[
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_WazaNamePut(
				BPLIST_WORK * wk, u32 waza, u32 widx, u32 midx, u16 fidx, u16 py, u32 col )
{
	STRBUF * exp;
	STRBUF * str;

	exp = STRBUF_Create( BUFLEN_WAZA_NAME, wk->dat->heap );
	str = MSGMAN_AllocString( wk->mman, midx );

	WORDSET_RegisterWazaName( wk->wset, 0, waza );
	WORDSET_ExpandStr( wk->wset, exp, str );

	GF_STR_PrintColor( &wk->add_win[widx], fidx, exp, 0, py, MSG_NO_PUT, col, NULL );

	STRBUF_Delete( str );
	STRBUF_Delete( exp );

	GF_BGL_BmpWinOnVReq( &wk->add_win[widx] );
}

//--------------------------------------------------------------------------------------------
/**
 * uPPv\
 *
 * @param	wk		[N
 * @param	idx		EBhECfbNX
 * @param	px		\XW
 * @param	py		\YW
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_PPPut( BPLIST_WORK * wk, u16 idx, u8 px, u8 py )
{
	STRBUF * str;

	str = MSGMAN_AllocString( wk->mman, mes_b_plist_02_500 );
	GF_STR_PrintColor(
		&wk->add_win[idx], FONT_SYSTEM, str, px, py, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	GF_BGL_BmpWinOnVReq( &wk->add_win[idx] );
}

//--------------------------------------------------------------------------------------------
/**
 * PPl\
 *
 * @param	wk		[N
 * @param	waza	Zf[^
 * @param	idx		EBhECfbNX
 * @param	px		\XW
 * @param	py		\YW
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_PPNumPut( BPLIST_WORK * wk, BPL_POKEWAZA * waza, u16 idx, u8 px, u8 py )
{
	NUMFONT_WriteNumber(
		wk->nfnt, waza->pp, 2, NUMFONT_MODE_SPACE, &wk->add_win[idx], px, py );
	NUMFONT_WriteNumber(
		wk->nfnt, waza->mpp, 2, NUMFONT_MODE_LEFT,
		&wk->add_win[idx], px+NUMFONT_NUM_WIDTH*2+8, py );

	GF_BGL_BmpWinOnVReq( &wk->add_win[idx] );
}

//--------------------------------------------------------------------------------------------
/**
 * u|P@łv\
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_StrErabuPut( BPLIST_WORK * wk )
{
	STRBUF * str;

	BmpTalkWinWrite(
		&wk->win[WIN_COMMENT], WINDOW_TRANS_OFF, TALK_WIN_CGX_POS, BPL_PAL_TALK_WIN );
	GF_BGL_BmpWinDataFill( &wk->win[WIN_COMMENT], 15 );

	str = MSGMAN_AllocString( wk->mman, mes_b_plist_01_600 );
	GF_STR_PrintColor(
		&wk->win[WIN_COMMENT], FONT_TALK, str, 0, 0, MSG_NO_PUT, PCOL_N_BLACK, NULL );
	STRBUF_Delete( str );

	GF_BGL_BmpWinOnVReq( &wk->win[WIN_COMMENT] );
}

//--------------------------------------------------------------------------------------------
/**
 * uꂩv\
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
#define	IREKAE_PY	( 8 )

static void BPL_StrIrekaePut( BPLIST_WORK * wk )
{
	STRBUF * str;
	u32	siz;

	str = MSGMAN_AllocString( wk->mman, mes_b_plist_02_501 );
	siz = FontProc_GetPrintStrWidth( FONT_BUTTON, str, 0 );
	GF_STR_PrintColor(
		&wk->add_win[WIN_P2_CHG], FONT_BUTTON, str,
		(WIN_P2_CHG_SX*8-siz)/2, IREKAE_PY, MSG_NO_PUT, PCOL_BTN, NULL );
	STRBUF_Delete( str );
	GF_BGL_BmpWinOnVReq( &wk->add_win[WIN_P2_CHG] );
}

//--------------------------------------------------------------------------------------------
/**
 * y[WR̃x\
 *
 * @param	wk		[N
 * @param	pos		|Pʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_P3_LvPut( BPLIST_WORK * wk, u32 pos )
{
	BPL_POKEDATA * pd;
	STRBUF * str;
	STRBUF * exp;
	u32	px;

	pd  = &wk->poke[pos];

	// uLv.v
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_03_000 );
	GF_STR_PrintColor(
		&wk->add_win[WIN_P3_LV], FONT_SYSTEM, str, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	// xl
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_03_001 );
	exp = STRBUF_Create( (3+1)*2, wk->dat->heap );	// (3+EOM_)x2([JCYpɈꉞ)
	WORDSET_RegisterNumber(
		wk->wset, 0, pd->lv, 3, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	WORDSET_ExpandStr( wk->wset, exp, str );
	GF_STR_PrintColor(
		&wk->add_win[WIN_P3_LVNUM], FONT_SYSTEM, exp, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	STRBUF_Delete( exp );
	// u̃x܂Łv
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_03_100 );
	GF_STR_PrintColor(
		&wk->add_win[WIN_P3_NEXT], FONT_SYSTEM, str, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	// ̃xl
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_03_101 );
	exp = STRBUF_Create( (6+1)*2, wk->dat->heap );	// (6+EOM_)x2([JCYpɈꉞ)
	WORDSET_RegisterNumber(
		wk->wset, 0, pd->next_lv_exp - pd->now_exp,
		6, NUMBER_DISPTYPE_SPACE, NUMBER_CODETYPE_DEFAULT );
	WORDSET_ExpandStr( wk->wset, exp, str );
	px = GF_BGL_BmpWinGet_SizeX( &wk->add_win[WIN_P3_NEXTNUM] ) * 8
			- FontProc_GetPrintStrWidth( FONT_SYSTEM, exp, 0 );
	GF_STR_PrintColor(
		&wk->add_win[WIN_P3_NEXTNUM], FONT_SYSTEM, exp, px, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	STRBUF_Delete( exp );

	GF_BGL_BmpWinOnVReq( &wk->add_win[WIN_P3_LV] );
	GF_BGL_BmpWinOnVReq( &wk->add_win[WIN_P3_LVNUM] );
	GF_BGL_BmpWinOnVReq( &wk->add_win[WIN_P3_NEXT] );
	GF_BGL_BmpWinOnVReq( &wk->add_win[WIN_P3_NEXTNUM] );
}

//--------------------------------------------------------------------------------------------
/**
 * y[WR̍U\
 *
 * @param	wk		[N
 * @param	pos		|Pʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_P3_PowPut( BPLIST_WORK * wk, u32 pos )
{
	BPL_POKEDATA * pd;
	STRBUF * str;
	STRBUF * exp;

	pd  = &wk->poke[pos];

	// uv
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_03_400 );
	GF_STR_PrintColor(
		&wk->add_win[WIN_P3_POW], FONT_SYSTEM, str, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	// Ul
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_03_401 );
	exp = STRBUF_Create( (3+1)*2, wk->dat->heap );	// (3+EOM_)x2([JCYpɈꉞ)
	WORDSET_RegisterNumber(
		wk->wset, 0, pd->pow, 3, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	WORDSET_ExpandStr( wk->wset, exp, str );
	GF_STR_PrintColor(
		&wk->add_win[WIN_P3_POWNUM], FONT_SYSTEM, exp, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	STRBUF_Delete( exp );

	GF_BGL_BmpWinOnVReq( &wk->add_win[WIN_P3_POW] );
	GF_BGL_BmpWinOnVReq( &wk->add_win[WIN_P3_POWNUM] );
}

//--------------------------------------------------------------------------------------------
/**
 * y[WR̖h\
 *
 * @param	wk		[N
 * @param	pos		|Pʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_P3_DefPut( BPLIST_WORK * wk, u32 pos )
{
	BPL_POKEDATA * pd;
	STRBUF * str;
	STRBUF * exp;

	pd  = &wk->poke[pos];

	// uڂv
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_03_500 );
	GF_STR_PrintColor(
		&wk->add_win[WIN_P3_DEF], FONT_SYSTEM, str, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	// hl
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_03_501 );
	exp = STRBUF_Create( (3+1)*2, wk->dat->heap );	// (3+EOM_)x2([JCYpɈꉞ)
	WORDSET_RegisterNumber(
		wk->wset, 0, pd->def, 3, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	WORDSET_ExpandStr( wk->wset, exp, str );
	GF_STR_PrintColor(
		&wk->add_win[WIN_P3_DEFNUM], FONT_SYSTEM, exp, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	STRBUF_Delete( exp );

	GF_BGL_BmpWinOnVReq( &wk->add_win[WIN_P3_DEF] );
	GF_BGL_BmpWinOnVReq( &wk->add_win[WIN_P3_DEFNUM] );
}

//--------------------------------------------------------------------------------------------
/**
 * y[WȒf\
 *
 * @param	wk		[N
 * @param	pos		|Pʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_P3_AgiPut( BPLIST_WORK * wk, u32 pos )
{
	BPL_POKEDATA * pd;
	STRBUF * str;
	STRBUF * exp;

	pd  = &wk->poke[pos];

	// u΂₳v
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_03_800 );
	GF_STR_PrintColor(
		&wk->add_win[WIN_P3_AGI], FONT_SYSTEM, str, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	// fl
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_03_801 );
	exp = STRBUF_Create( (3+1)*2, wk->dat->heap );	// (3+EOM_)x2([JCYpɈꉞ)
	WORDSET_RegisterNumber(
		wk->wset, 0, pd->agi, 3, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	WORDSET_ExpandStr( wk->wset, exp, str );
	GF_STR_PrintColor(
		&wk->add_win[WIN_P3_AGINUM], FONT_SYSTEM, exp, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	STRBUF_Delete( exp );

	GF_BGL_BmpWinOnVReq( &wk->add_win[WIN_P3_AGI] );
	GF_BGL_BmpWinOnVReq( &wk->add_win[WIN_P3_AGINUM] );
}

//--------------------------------------------------------------------------------------------
/**
 * y[WR̓U\
 *
 * @param	wk		[N
 * @param	pos		|Pʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_P3_SppPut( BPLIST_WORK * wk, u32 pos )
{
	BPL_POKEDATA * pd;
	STRBUF * str;
	STRBUF * exp;

	pd  = &wk->poke[pos];

	// uƂv
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_03_600 );
	GF_STR_PrintColor(
		&wk->add_win[WIN_P3_SPP], FONT_SYSTEM, str, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	// Ul
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_03_601 );
	exp = STRBUF_Create( (3+1)*2, wk->dat->heap );	// (3+EOM_)x2([JCYpɈꉞ)
	WORDSET_RegisterNumber(
		wk->wset, 0, pd->spp, 3, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	WORDSET_ExpandStr( wk->wset, exp, str );
	GF_STR_PrintColor(
		&wk->add_win[WIN_P3_SPPNUM], FONT_SYSTEM, exp, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	STRBUF_Delete( exp );

	GF_BGL_BmpWinOnVReq( &wk->add_win[WIN_P3_SPP] );
	GF_BGL_BmpWinOnVReq( &wk->add_win[WIN_P3_SPPNUM] );
}

//--------------------------------------------------------------------------------------------
/**
 * y[WR̓h\
 *
 * @param	wk		[N
 * @param	pos		|Pʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_P3_SpdPut( BPLIST_WORK * wk, u32 pos )
{
	BPL_POKEDATA * pd;
	STRBUF * str;
	STRBUF * exp;

	pd  = &wk->poke[pos];

	// uƂڂv
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_03_700 );
	GF_STR_PrintColor(
		&wk->add_win[WIN_P3_SPD], FONT_SYSTEM, str, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	// hl
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_03_701 );
	exp = STRBUF_Create( (3+1)*2, wk->dat->heap );	// (3+EOM_)x2([JCYpɈꉞ)
	WORDSET_RegisterNumber(
		wk->wset, 0, pd->spd, 3, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	WORDSET_ExpandStr( wk->wset, exp, str );
	GF_STR_PrintColor(
		&wk->add_win[WIN_P3_SPDNUM], FONT_SYSTEM, exp, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	STRBUF_Delete( exp );

	GF_BGL_BmpWinOnVReq( &wk->add_win[WIN_P3_SPD] );
	GF_BGL_BmpWinOnVReq( &wk->add_win[WIN_P3_SPDNUM] );
}

//--------------------------------------------------------------------------------------------
/**
 * y[WRHP\
 *
 * @param	wk		[N
 * @param	pos		|Pʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_P3_HPPut( BPLIST_WORK * wk, u32 pos )
{
	BPL_POKEDATA * pd;
	STRBUF * str;
	STRBUF * exp;
	u32	sra_siz, tmp_siz;
	u32	px;

	pd  = &wk->poke[pos];

	// uHPv
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_03_300 );
	GF_STR_PrintColor(
		&wk->add_win[WIN_P3_HP], FONT_SYSTEM, str, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	// u/v
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_03_303 );
	sra_siz = FontProc_GetPrintStrWidth( FONT_SYSTEM, str, 0 );
	px = (GF_BGL_BmpWinGet_SizeX( &wk->add_win[WIN_P3_HPNUM] )*8-sra_siz)/2;
	GF_STR_PrintColor(
		&wk->add_win[WIN_P3_HPNUM], FONT_SYSTEM, str, px, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	// HPl
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_03_301 );
	exp = STRBUF_Create( (3+1)*2, wk->dat->heap );	// (3+EOM_)x2([JCYpɈꉞ)
	WORDSET_RegisterNumber(
		wk->wset, 0, pd->hp, 3, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	WORDSET_ExpandStr( wk->wset, exp, str );
	tmp_siz = FontProc_GetPrintStrWidth( FONT_SYSTEM, exp, 0 );
	GF_STR_PrintColor(
		&wk->add_win[WIN_P3_HPNUM], FONT_SYSTEM, exp,
		px-tmp_siz, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	STRBUF_Delete( exp );
	// őHPl
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_03_302 );
	exp = STRBUF_Create( (3+1)*2, wk->dat->heap );	// (3+EOM_)x2([JCYpɈꉞ)
	WORDSET_RegisterNumber(
		wk->wset, 0, pd->mhp, 3, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	WORDSET_ExpandStr( wk->wset, exp, str );
	GF_STR_PrintColor(
		&wk->add_win[WIN_P3_HPNUM], FONT_SYSTEM, exp,
		px+sra_siz, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	STRBUF_Delete( exp );

	GF_BGL_BmpWinOnVReq( &wk->add_win[WIN_P3_HP] );
	GF_BGL_BmpWinOnVReq( &wk->add_win[WIN_P3_HPNUM] );
}

//--------------------------------------------------------------------------------------------
/**
 * y[WR̓\
 *
 * @param	wk		[N
 * @param	pos		|Pʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_P3_TokuseiInfoPut( BPLIST_WORK * wk, u32 pos )
{
	BPL_POKEDATA * pd;
	MSGDATA_MANAGER * man;
	STRBUF * str;

	pd  = &wk->poke[pos];

	man = MSGMAN_Create(
			MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_tokuseiinfo_dat, wk->dat->heap );
	str = MSGMAN_AllocString( man, pd->spa );
	GF_STR_PrintColor(
		&wk->add_win[WIN_P3_SPAINFO], FONT_SYSTEM, str, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	MSGMAN_Delete( man );
	GF_BGL_BmpWinOnVReq( &wk->add_win[WIN_P3_SPAINFO] );
}

//--------------------------------------------------------------------------------------------
/**
 * y[WR̃ACe\
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_P3_ItemInfoPut( BPLIST_WORK * wk, u32 pos )
{
	GF_BGL_BMPWIN * win;
	BPL_POKEDATA * pd;
	STRBUF * buf;

	pd  = &wk->poke[pos];
	if( pd->item == 0 ){ return; }

	win = &wk->add_win[WIN_P3_ITEMINFO];
	buf = STRBUF_Create( BUFLEN_ITEM_INFO, wk->dat->heap );
	ItemEpuipInfoGet( buf, pd->item, wk->dat->heap );
	GF_STR_PrintColor( win, FONT_SYSTEM, buf, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( buf );

	GF_BGL_BmpWinOnVReq( win );
}

//--------------------------------------------------------------------------------------------
/**
 * u߂イv\
 *
 * @param	wk		[N
 * @param	idx		EBhECfbNX
 *
 * @return	none
 *
 *	y[WSEUŎgp
 */
//--------------------------------------------------------------------------------------------
static void BPL_WazaHitStrPut( BPLIST_WORK * wk, u32 idx )
{
	GF_BGL_BMPWIN * win;
	STRBUF * str;

	win = &wk->add_win[idx];
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_04_200 );
	GF_STR_PrintColor( win, FONT_SYSTEM, str, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	GF_BGL_BmpWinOnVReq( win );
}

//--------------------------------------------------------------------------------------------
/**
 * Z̖l\
 *
 * @param	wk		[N
 * @param	idx		EBhECfbNX
 * @param	hit		l
 *
 * @return	none
 *
 *	y[WSEUŎgp
 */
//--------------------------------------------------------------------------------------------
static void BPL_WazaHitNumPut( BPLIST_WORK * wk, u32 idx, u32 hit )
{
	GF_BGL_BMPWIN * win;
	STRBUF * str;
	STRBUF * exp;

	win = &wk->add_win[idx];
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_04_201 );
	exp = STRBUF_Create( (3+1)*2, wk->dat->heap );	// (3+EOM_)x2([JCYpɈꉞ)
	WORDSET_RegisterNumber(
		wk->wset, 0, hit, 3, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	WORDSET_ExpandStr( wk->wset, exp, str );
	GF_STR_PrintColor( win, FONT_SYSTEM, exp, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	STRBUF_Delete( exp );
	GF_BGL_BmpWinOnVReq( win );
}

//--------------------------------------------------------------------------------------------
/**
 * u傭v\
 *
 * @param	wk		[N
 * @param	idx		EBhECfbNX
 *
 * @return	none
 *
 *	y[WSEUŎgp
 */
//--------------------------------------------------------------------------------------------
static void BPL_WazaPowStrPut( BPLIST_WORK * wk, u32 idx )
{
	GF_BGL_BMPWIN * win;
	STRBUF * str;

	win = &wk->add_win[idx];
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_04_100 );
	GF_STR_PrintColor( win, FONT_SYSTEM, str, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	GF_BGL_BmpWinOnVReq( win );
}

//--------------------------------------------------------------------------------------------
/**
 * Z̈З͒l\
 *
 * @param	wk		[N
 * @param	idx		EBhECfbNX
 * @param	pow		З͒l
 *
 * @return	none
 *
 *	y[WSEUŎgp
 */
//--------------------------------------------------------------------------------------------
static void BPL_WazaPowNumPut( BPLIST_WORK * wk, u32 idx, u32 pow )
{
	GF_BGL_BMPWIN * win;
	STRBUF * str;
	STRBUF * exp;

	win = &wk->add_win[idx];
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_04_101 );
	exp = STRBUF_Create( (3+1)*2, wk->dat->heap );	// (3+EOM_)x2([JCYpɈꉞ)
	WORDSET_RegisterNumber(
		wk->wset, 0, pow, 3, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	WORDSET_ExpandStr( wk->wset, exp, str );
	GF_STR_PrintColor( win, FONT_SYSTEM, exp, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	STRBUF_Delete( exp );
	GF_BGL_BmpWinOnVReq( win );
}

//--------------------------------------------------------------------------------------------
/**
 * Z\
 *
 * @param	wk		[N
 * @param	idx		EBhECfbNX
 * @param	waza	ZID
 *
 * @return	none
 *
 *	y[WSEUŎgp
 */
//--------------------------------------------------------------------------------------------
static void BPL_WazaInfoPut( BPLIST_WORK * wk, u32 idx, u32 waza )
{
	MSGDATA_MANAGER * man;
	GF_BGL_BMPWIN * win;
	STRBUF * str;

	win = &wk->add_win[idx];
	man = MSGMAN_Create(
			MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_wazainfo_dat, wk->dat->heap );
	str = MSGMAN_AllocString( man, waza );
	GF_STR_PrintColor( win, FONT_SYSTEM, str, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	MSGMAN_Delete( man );
	GF_BGL_BmpWinOnVReq( win );
}

//--------------------------------------------------------------------------------------------
/**
 * uԂ邢v\
 *
 * @param	wk		[N
 * @param	idx		EBhECfbNX
 *
 * @return	none
 *
 *	y[WSEUŎgp
 */
//--------------------------------------------------------------------------------------------
static void BPL_WazaBunruiStrPut( BPLIST_WORK * wk, u32 idx )
{
	GF_BGL_BMPWIN * win;
	STRBUF * str;

	win = &wk->add_win[idx];
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_04_300 );
	GF_STR_PrintColor( win, FONT_SYSTEM, str, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	GF_BGL_BmpWinOnVReq( win );
}

//--------------------------------------------------------------------------------------------
/**
 * ގޕ\
 *
 * @param	wk		[N
 * @param	idx		EBhECfbNX
 * @param	kind	ގ
 *
 * @return	none
 *
 *	y[WSEUŎgp
 */
//--------------------------------------------------------------------------------------------
static void BPL_WazaKindPut( BPLIST_WORK * wk, u32 idx, u32 kind )
{
	GF_BGL_BMPWIN * win;
	STRBUF * str;

	win = &wk->add_win[idx];

	switch( kind ){
	case 0:		// 
		str = MSGMAN_AllocString( wk->mman, mes_b_plist_04_301 );
		break;
	case 1:		// ω
		str = MSGMAN_AllocString( wk->mman, mes_b_plist_04_303 );
		break;
	case 2:		// 
		str = MSGMAN_AllocString( wk->mman, mes_b_plist_04_302 );
	}
	GF_STR_PrintColor( win, FONT_SYSTEM, str, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );

	GF_BGL_BmpWinOnVReq( win );
}

//--------------------------------------------------------------------------------------------
/**
 * ZPP\
 *
 * @param	wk		[N
 * @param	idx		EBhECfbNX
 * @param	npp		݂PP
 * @param	mpp		őPP
 *
 * @return	none
 *
 *	y[WSEUŎgp
 */
//--------------------------------------------------------------------------------------------
static void BPL_WazaPPPut( BPLIST_WORK * wk, u32 idx, u32 npp, u32 mpp )
{
	GF_BGL_BMPWIN * win;
	STRBUF * str;
	STRBUF * exp;
	u32	sra_siz, tmp_siz;
	u32	px;

	win = &wk->add_win[idx];

	// u/v
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_04_004 );
	sra_siz = FontProc_GetPrintStrWidth( FONT_SYSTEM, str, 0 );
	px = ( GF_BGL_BmpWinGet_SizeX(win) * 8 - sra_siz ) / 2;
	GF_STR_PrintColor( win, FONT_SYSTEM, str, px, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	// PPl
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_04_002 );
	exp = STRBUF_Create( (2+1)*2, wk->dat->heap );	// (2+EOM_)x2([JCYpɈꉞ)
	WORDSET_RegisterNumber(
		wk->wset, 0, npp, 3, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	WORDSET_ExpandStr( wk->wset, exp, str );
	tmp_siz = FontProc_GetPrintStrWidth( FONT_SYSTEM, exp, 0 );
	GF_STR_PrintColor(
		win, FONT_SYSTEM, exp, px-tmp_siz, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	STRBUF_Delete( exp );
	// őPPl
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_04_003 );
	exp = STRBUF_Create( (2+1)*2, wk->dat->heap );	// (2+EOM_)x2([JCYpɈꉞ)
	WORDSET_RegisterNumber(
		wk->wset, 0, mpp, 3, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	WORDSET_ExpandStr( wk->wset, exp, str );
	GF_STR_PrintColor(
		win, FONT_SYSTEM, exp, px+sra_siz, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	STRBUF_Delete( exp );

	GF_BGL_BmpWinOnVReq( win );
}

//--------------------------------------------------------------------------------------------
/**
 * y[WTPPl\
 *
 * @param	wk		[N
 * @param	waza	ZID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
#define	P5_PPNUM5_PX	( 56 )
#define	P5_PPNUM5_PY	( 32 )

static void BPL_P5_PPNumPut( BPLIST_WORK * wk, u32 waza )
{
	GF_BGL_BMPWIN * win;
	u32	pp;

	win = &wk->add_win[WIN_P5_SKILL5];
	pp  = WT_WazaDataParaGet( waza, ID_WTD_pp );

	NUMFONT_WriteNumber( wk->nfnt, pp, 2, NUMFONT_MODE_SPACE, win, P5_PPNUM5_PX, P5_PPNUM5_PY );
	NUMFONT_WriteNumber(
		wk->nfnt, pp, 2, NUMFONT_MODE_LEFT,
		win, P5_PPNUM5_PX+NUMFONT_NUM_WIDTH*2+8, P5_PPNUM5_PY );

	GF_BGL_BmpWinOnVReq( win );
}

//--------------------------------------------------------------------------------------------
/**
 * u킷v\
 *
 * @param	wk		[N
 * @param	idx		EBhECfbNX
 *
 * @return	none
 *
 *	y[WUŎgp
 */
//--------------------------------------------------------------------------------------------
#define	P6_WASURERU_PY	( 8 )

static void BPL_WasureruStrPut( BPLIST_WORK * wk, u32 idx )
{
	GF_BGL_BMPWIN * win;
	STRBUF * str;

	win = &wk->add_win[idx];
	str = MSGMAN_AllocString( wk->mman, mes_b_plist_05_000 );
	GF_STR_PrintColor( win, FONT_BUTTON, str, 0, P6_WASURERU_PY, MSG_NO_PUT, PCOL_BTN, NULL );
	STRBUF_Delete( str );
	GF_BGL_BmpWinOnVReq( win );
}

//--------------------------------------------------------------------------------------------
/**
 * y[WPBMP\
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
#define	P1_NAME_PX		( 32 )
#define	P1_NAME_PY		( 8 )
#define	P1_HP_PX		( 56 )
#define	P1_HP_PY		( 32 )
#define	P1_HP_SX		( 24 )
#define	P1_HP_SY		( 8 )
#define	P1_HPGAGE_PX	( 48 )
#define	P1_HPGAGE_PY	( 24 )
#define	P1_HPGAGE_SX	( 64 )
#define	P1_HPGAGE_SY	( 8 )
#define	P1_LV_PX		( 0 )
#define	P1_LV_PY		( 32 )

static void BPL_Page1BmpWrite( BPLIST_WORK * wk )
{
	s32	i;

	for( i=0; i<PokeParty_GetPokeCount(wk->dat->pp); i++ ){
		GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P1_POKE1+i ], 0 );

		if( wk->poke[i].mons == 0 ){ continue; }

		BPL_NamePut( wk, WIN_P1_POKE1+i, FONT_BUTTON, i, P1_NAME_PX, P1_NAME_PY );
		BattlePokeList_P1_HPPut( wk, i );

		if( BadStatusIconAnmGet( wk->poke[i].pp ) != ST_ICON_NONE ){
			continue;
		}
		BPL_LvPut( wk, WIN_P1_POKE1+i, i, P1_LV_PX, P1_LV_PY );
	}

	BPL_StrErabuPut( wk );
}

void BattlePokeList_P1_HPPut( BPLIST_WORK * wk, u8 pos )
{
	GF_BGL_BmpWinFill(
		&wk->add_win[WIN_P1_POKE1+pos], 0, P1_HP_PX, P1_HP_PY, P1_HP_SX, P1_HP_SY );
	GF_BGL_BmpWinFill(
		&wk->add_win[WIN_P1_POKE1+pos], 0,
		P1_HPGAGE_PX, P1_HPGAGE_PY, P1_HPGAGE_SX, P1_HPGAGE_SY );

	BPL_HPPut( wk, WIN_P1_POKE1+pos, pos, P1_HP_PX, P1_HP_PY );
	BPL_HPGagePut( wk, WIN_P1_POKE1+pos, pos, P1_HPGAGE_PX, P1_HPGAGE_PY );
}

void BattlePokeList_P1_HPRcv( BPLIST_WORK * wk, u8 pos )
{
	GF_BGL_BmpWinFill(
		&wk->add_win[WIN_P1_POKE1+pos], 0, P1_HP_PX, P1_HP_PY-2, P1_HP_SX, P1_HP_SY );
	GF_BGL_BmpWinFill(
		&wk->add_win[WIN_P1_POKE1+pos], 0,
		P1_HPGAGE_PX, P1_HPGAGE_PY-2, P1_HPGAGE_SX, P1_HPGAGE_SY );

	BPL_HPPut( wk, WIN_P1_POKE1+pos, pos, P1_HP_PX, P1_HP_PY-2 );
	BPL_HPGagePut( wk, WIN_P1_POKE1+pos, pos, P1_HPGAGE_PX, P1_HPGAGE_PY-2 );
}


//--------------------------------------------------------------------------------------------
/**
 * y[WQBMP\
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
#define	P2_NAME_PX		( 0 )
#define	P2_NAME_PY		( 0 )
#define	P2_HP_PX		( 0 )
#define	P2_HP_PY		( 0 )
#define	P2_HPGAGE_PX	( 0 )
#define	P2_HPGAGE_PY	( 0 )
#define	P2_LV_PX		( 0 )
#define	P2_LV_PY		( 0 )
#define	P2_WAZANAME_PY	( 0 )
#define	P2_PPNUM_PX		( 0 )
#define	P2_PPNUM_PY		( 0 )
#define	P2_PP_PX		( 0 )
#define	P2_PP_PY		( 0 )

static void BPL_Page2BmpWrite( BPLIST_WORK * wk )
{
	BPL_POKEWAZA * waza;
	u32	i, swap;

	swap = WIN_P2_NAME_S * wk->p2_swap;

	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P2_NAME+swap ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P2_LV+swap ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P2_HP+swap ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P2_HPGAGE+swap ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P2_SPA+swap ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P2_ITEM+swap ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P2_CHG ], 0 );

	BPL_NamePut(
		wk, WIN_P2_NAME+swap, FONT_SYSTEM,
		wk->dat->sel_poke, P2_NAME_PX, P2_NAME_PY );
	BPL_LvPut( wk, WIN_P2_LV+swap, wk->dat->sel_poke, P2_LV_PX, P2_LV_PY );
	BPL_HPPut( wk, WIN_P2_HP+swap, wk->dat->sel_poke, P2_HP_PX, P2_HP_PY );
	BPL_HPGagePut( wk, WIN_P2_HPGAGE+swap, wk->dat->sel_poke, P2_HPGAGE_PX, P2_HPGAGE_PY );
	BPL_TokuseiPut( wk, WIN_P2_SPA+swap, wk->dat->sel_poke );
	BPL_ItemPut( wk, WIN_P2_ITEM+swap, wk->dat->sel_poke );

	for( i=0; i<4; i++ ){
		GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P2_SKILL1+swap+i*3 ], 0 );
		GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P2_PPNUM1+swap+i*3 ], 0 );
		GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P2_PP1+swap+i*3 ], 0 );

		waza = &wk->poke[wk->dat->sel_poke].waza[i];
		if( waza == 0 ){
			GF_BGL_BmpWinOnVReq( &wk->add_win[ WIN_P2_SKILL1+swap+i*3 ] );
			GF_BGL_BmpWinOnVReq( &wk->add_win[ WIN_P2_PPNUM1+swap+i*3 ] );
			GF_BGL_BmpWinOnVReq( &wk->add_win[ WIN_P2_PP1+swap+i*3 ] );
			continue;
		}

		BPL_WazaNamePut(
			wk, waza->id, WIN_P2_SKILL1+swap+i*3,
			WazaMsgID_Tbl[i], FONT_SYSTEM, P2_WAZANAME_PY, PCOL_N_WHITE );
		BPL_PPNumPut( wk, waza, WIN_P2_PPNUM1+swap+i*3, P2_PPNUM_PX, P2_PPNUM_PY );
		BPL_PPPut( wk, WIN_P2_PP1+swap+i*3, P2_PP_PX, P2_PP_PY );
	}

	BPL_StrIrekaePut( wk );

	wk->p2_swap ^= 1;
}

//--------------------------------------------------------------------------------------------
/**
 * y[WRBMP\
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
#define	P3_NAME_PX		( 0 )
#define	P3_NAME_PY		( 0 )
#define	P3_HPGAGE_PX	( 0 )
#define	P3_HPGAGE_PY	( 0 )

static void BPL_Page3BmpWrite( BPLIST_WORK * wk )
{
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P3_NAME ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P3_HPGAGE ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[WIN_P3_LV], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[WIN_P3_LVNUM], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[WIN_P3_NEXT], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[WIN_P3_NEXTNUM], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[WIN_P3_POW], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[WIN_P3_POWNUM], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[WIN_P3_DEF], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[WIN_P3_DEFNUM], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[WIN_P3_AGI], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[WIN_P3_AGINUM], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[WIN_P3_SPP], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[WIN_P3_SPPNUM], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[WIN_P3_SPD], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[WIN_P3_SPDNUM], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[WIN_P3_HP], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[WIN_P3_HPNUM], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P3_SPANAME ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P3_SPAINFO], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P3_ITEMNAME ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P3_ITEMINFO ], 0 );

	BPL_NamePut(
		wk, WIN_P3_NAME, FONT_SYSTEM,
		wk->dat->sel_poke, P3_NAME_PX, P3_NAME_PY );
	BPL_P3_HPPut( wk, wk->dat->sel_poke );
	BPL_HPGagePut( wk, WIN_P3_HPGAGE, wk->dat->sel_poke, P3_HPGAGE_PX, P3_HPGAGE_PY );
	BPL_P3_LvPut( wk, wk->dat->sel_poke );
	BPL_P3_PowPut( wk, wk->dat->sel_poke );
	BPL_P3_DefPut( wk, wk->dat->sel_poke );
	BPL_P3_AgiPut( wk, wk->dat->sel_poke );
	BPL_P3_SppPut( wk, wk->dat->sel_poke );
	BPL_P3_SpdPut( wk, wk->dat->sel_poke );
	BPL_TokuseiPut( wk, WIN_P3_SPANAME, wk->dat->sel_poke );
	BPL_ItemPut( wk, WIN_P3_ITEMNAME, wk->dat->sel_poke );
	BPL_P3_ItemInfoPut( wk, wk->dat->sel_poke );
	BPL_P3_TokuseiInfoPut( wk, wk->dat->sel_poke );
}

//--------------------------------------------------------------------------------------------
/**
 * y[WSBMP\
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
#define	P4_NAME_PX		( 0 )
#define	P4_NAME_PY		( 0 )
#define	P4_WAZANAME_PY	( 0 )
#define	P4_PP_PX		( 0 )
#define	P4_PP_PY		( 0 )

static void BPL_Page4BmpWrite( BPLIST_WORK * wk )
{
	BPL_POKEWAZA * waza;

	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P4_NAME ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P4_PP ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P4_PPNUM ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P4_SKILL ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P4_HIT ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P4_HITNUM ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P4_POW ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P4_POWNUM ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P4_BUNRUI ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P4_BRNAME ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P4_INFO ], 0 );

	waza = &wk->poke[wk->dat->sel_poke].waza[wk->dat->sel_wp];

	BPL_NamePut(
		wk, WIN_P4_NAME, FONT_SYSTEM, wk->dat->sel_poke, P4_NAME_PX, P4_NAME_PY );
	BPL_PPPut( wk, WIN_P4_PP, P4_PP_PX, P4_PP_PY );
	BPL_WazaNamePut(
		wk, waza->id, WIN_P4_SKILL, 
		WazaMsgID_Tbl[wk->dat->sel_wp], FONT_SYSTEM, P4_WAZANAME_PY, PCOL_N_WHITE );
	BPL_WazaHitStrPut( wk, WIN_P4_HIT );
	BPL_WazaHitNumPut( wk, WIN_P4_HITNUM, waza->hit );
	BPL_WazaPowStrPut( wk, WIN_P4_POW );
	BPL_WazaPowNumPut( wk, WIN_P4_POWNUM, waza->pow );
	BPL_WazaInfoPut( wk, WIN_P4_INFO, waza->id );
	BPL_WazaBunruiStrPut( wk, WIN_P4_BUNRUI );
	BPL_WazaKindPut( wk, WIN_P4_BRNAME, waza->kind );
	BPL_WazaPPPut( wk, WIN_P4_PPNUM, waza->pp, waza->mpp );
}

//--------------------------------------------------------------------------------------------
/**
 * y[WTBMP\
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
#define	P5_NAME_PX		( 0 )
#define	P5_NAME_PY		( 0 )
#define	P5_WAZANAME_PY	( 8 )
#define	P5_PPNUM_PX		( 56 )
#define	P5_PPNUM_PY		( 32 )
#define	P5_PP_PX		( 40 )
#define	P5_PP_PY		( 24 )

static void BPL_Page5BmpWrite( BPLIST_WORK * wk )
{
	BPL_POKEWAZA * waza;
	u32	i;

	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P5_NAME ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P5_SKILL5 ], 0 );

	BPL_NamePut(
		wk, WIN_P5_NAME, FONT_SYSTEM, wk->dat->sel_poke, P5_NAME_PX, P5_NAME_PY );

	for( i=0; i<4; i++ ){
		GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P5_SKILL1+i ], 0 );

		waza = &wk->poke[wk->dat->sel_poke].waza[i];
		if( waza == 0 ){
			GF_BGL_BmpWinOnVReq( &wk->add_win[ WIN_P5_SKILL1+i ] );
			continue;
		}

		BPL_WazaNamePut(
			wk, waza->id, WIN_P5_SKILL1+i, 
			P5_WazaMsgID_Tbl[i], FONT_BUTTON, P5_WAZANAME_PY, PCOL_BTN );
		BPL_PPNumPut( wk, waza, WIN_P5_SKILL1+i, P5_PPNUM_PX, P5_PPNUM_PY );
		BPL_PPPut( wk, WIN_P5_SKILL1+i, P5_PP_PX, P5_PP_PY );
	}

	BPL_WazaNamePut(
		wk, wk->dat->chg_waza, WIN_P5_SKILL5, 
		P5_WazaMsgID_Tbl[4], FONT_BUTTON, P5_WAZANAME_PY, PCOL_BTN );
	BPL_P5_PPNumPut( wk, wk->dat->chg_waza );
	BPL_PPPut( wk, WIN_P5_SKILL5, P5_PP_PX, P5_PP_PY );
}

//--------------------------------------------------------------------------------------------
/**
 * y[WUBMP\
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
#define	P6_NAME_PX		( 0 )
#define	P6_NAME_PY		( 0 )
#define	P6_WAZANAME_PY	( 0 )
#define	P6_PP_PX		( 0 )
#define	P6_PP_PY		( 0 )

static void BPL_Page6BmpWrite( BPLIST_WORK * wk )
{
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P6_NAME ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P6_PP ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P6_PPNUM ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P6_SKILL ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P6_HIT ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P6_HITNUM ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P6_POW ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P6_POWNUM ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P6_BUNRUI ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P6_BRNAME ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P6_INFO ], 0 );
	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P6_WASURERU ], 0 );

	BPL_NamePut(
		wk, WIN_P6_NAME, FONT_SYSTEM, wk->dat->sel_poke, P6_NAME_PX, P6_NAME_PY );
	BPL_PPPut( wk, WIN_P6_PP, P6_PP_PX, P6_PP_PY );
	BPL_WazaHitStrPut( wk, WIN_P6_HIT );
	BPL_WazaPowStrPut( wk, WIN_P6_POW );
	BPL_WazaBunruiStrPut( wk, WIN_P6_BUNRUI );

	if( wk->dat->sel_wp < 4 ){
		BPL_POKEWAZA * waza = &wk->poke[wk->dat->sel_poke].waza[wk->dat->sel_wp];

		BPL_WazaNamePut(
			wk, waza->id, WIN_P6_SKILL, 
			P5_WazaMsgID_Tbl[wk->dat->sel_wp], FONT_SYSTEM, P6_WAZANAME_PY, PCOL_N_WHITE );
		BPL_WazaHitNumPut( wk, WIN_P6_HITNUM, waza->hit );
		BPL_WazaPowNumPut( wk, WIN_P6_POWNUM, waza->pow );
		BPL_WazaInfoPut( wk, WIN_P6_INFO, waza->id );
		BPL_WazaKindPut( wk, WIN_P6_BRNAME, waza->kind );
		BPL_WazaPPPut( wk, WIN_P6_PPNUM, waza->pp, waza->mpp );
	}else{
		u32	pp = WT_WazaDataParaGet( wk->dat->chg_waza, ID_WTD_pp );

		BPL_WazaNamePut(
			wk, wk->dat->chg_waza, WIN_P6_SKILL, 
			P5_WazaMsgID_Tbl[4], FONT_SYSTEM, P6_WAZANAME_PY, PCOL_N_WHITE );
		BPL_WazaInfoPut( wk, WIN_P6_INFO, wk->dat->chg_waza );
		BPL_WazaHitNumPut(
			wk, WIN_P6_HITNUM, WT_WazaDataParaGet(wk->dat->chg_waza,ID_WTD_hitprobability) );
		BPL_WazaPowNumPut(
			wk, WIN_P6_POWNUM, WT_WazaDataParaGet(wk->dat->chg_waza,ID_WTD_damage) );
		BPL_WazaKindPut(
			wk, WIN_P6_BRNAME, WT_WazaDataParaGet(wk->dat->chg_waza,ID_WTD_kind) );
		BPL_WazaPPPut( wk, WIN_P6_PPNUM, pp, pp );
	}

	BPL_WasureruStrPut( wk, WIN_P6_WASURERU );
}

//--------------------------------------------------------------------------------------------
/**
 * y[WVBMP\
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
#define	P7_NAME_PX		( 0 )
#define	P7_NAME_PY		( 0 )
#define	P7_WAZANAME_PY	( 8 )
#define	P7_PPNUM_PX		( 56 )
#define	P7_PPNUM_PY		( 32 )
#define	P7_PP_PX		( 40 )
#define	P7_PP_PY		( 24 )

static void BPL_Page7BmpWrite( BPLIST_WORK * wk )
{
	BPL_POKEWAZA * waza;
	u32	i;

	GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P7_NAME ], 0 );

	BPL_NamePut(
		wk, WIN_P5_NAME, FONT_SYSTEM, wk->dat->sel_poke, P7_NAME_PX, P7_NAME_PY );

	for( i=0; i<4; i++ ){
		GF_BGL_BmpWinDataFill( &wk->add_win[ WIN_P7_SKILL1+i ], 0 );

		waza = &wk->poke[wk->dat->sel_poke].waza[i];
		if( waza == 0 ){
			GF_BGL_BmpWinOnVReq( &wk->add_win[ WIN_P7_SKILL1+i ] );
			continue;
		}

		BPL_WazaNamePut(
			wk, waza->id, WIN_P7_SKILL1+i, 
			P5_WazaMsgID_Tbl[i], FONT_BUTTON, P7_WAZANAME_PY, PCOL_BTN );
		BPL_PPNumPut( wk, waza, WIN_P7_SKILL1+i, P7_PPNUM_PX, P7_PPNUM_PY );
		BPL_PPPut( wk, WIN_P7_SKILL1+i, P7_PP_PX, P7_PP_PY );
	}
}


//--------------------------------------------------------------------------------------------
/**
 * bZ[W\
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BattlePokeList_TalkMsgSet( BPLIST_WORK * wk )
{
	BmpTalkWinWrite( &wk->win[WIN_TALK], WINDOW_TRANS_OFF, TALK_WIN_CGX_POS, BPL_PAL_TALK_WIN );
	GF_BGL_BmpWinDataFill( &wk->win[WIN_TALK], FBMP_COL_WHITE );
	BattlePokeList_TalkMsgStart( wk );
}

//--------------------------------------------------------------------------------------------
/**
 * bZ[W\Jn
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BattlePokeList_TalkMsgStart( BPLIST_WORK * wk )
{
	MsgPrintSkipFlagSet( MSG_SKIP_ON );
	wk->midx = GF_STR_PrintSimple(
				&wk->win[WIN_TALK], FONT_TALK, wk->msg_buf, 0, 0, MsgSpeedGet(), NULL );
}





#define	BPL_RCV_SLEEP		( 0x01 )	// 
#define	BPL_RCV_POISON		( 0x02 )	// 
#define	BPL_RCV_BURN		( 0x04 )	// Ώ
#define	BPL_RCV_ICE			( 0x08 )	// X
#define	BPL_RCV_PARALYZE	( 0x10 )	// 
#define	BPL_RCV_PANIC		( 0x20 )	// 
#define	BPL_RCV_MEROMERO	( 0x40 )	// 
#define	BPL_RCV_ALL			( 0x7f )	// S


void BattlePokeList_ItemUseMsgSet( BPLIST_WORK * wk )
{
	POKEMON_PARAM * pp;
	BPLIST_DATA * dat;
	void * item;
	STRBUF * str;
	u16	hp;
	u8	prm;
	u8	i;

	dat  = wk->dat;
	item = GetItemArcData( dat->item, ITEM_GET_DATA, dat->heap );
	pp   = BattleWorkPokemonParamGet( dat->bw, dat->client_no, dat->list_row[dat->sel_poke] );
	hp   = PokeParaGet( pp, ID_PARA_hp, NULL );
	prm  = 0;
	if( ItemBufParamGet( item, ITEM_PRM_SLEEP_RCV ) != 0 ){
		prm |= BPL_RCV_SLEEP;
	}
	if( ItemBufParamGet( item, ITEM_PRM_POISON_RCV ) != 0 ){
		prm |= BPL_RCV_POISON;
	}
	if( ItemBufParamGet( item, ITEM_PRM_BURN_RCV ) != 0 ){
		prm |= BPL_RCV_BURN;
	}
	if( ItemBufParamGet( item, ITEM_PRM_ICE_RCV ) != 0 ){
		prm |= BPL_RCV_ICE;
	}
	if( ItemBufParamGet( item, ITEM_PRM_PARALYZE_RCV ) != 0 ){
		prm |= BPL_RCV_PARALYZE;
	}
	if( ItemBufParamGet( item, ITEM_PRM_PANIC_RCV ) != 0 ){
		prm |= BPL_RCV_PANIC;
	}
	if( ItemBufParamGet( item, ITEM_PRM_MEROMERO_RCV ) != 0 ){
		prm |= BPL_RCV_MEROMERO;
	}

	// m
	if( wk->poke[dat->sel_poke].hp == 0 && hp != 0 ){
		str = MSGMAN_AllocString( wk->mman, mes_b_plist_m13 );
		WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(pp) );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
	// HP
	}else if( wk->poke[dat->sel_poke].hp != hp ){
		str = MSGMAN_AllocString( wk->mman, mes_b_plist_m07 );
		WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(pp) );
		WORDSET_RegisterNumber(
			wk->wset, 1, hp-wk->poke[dat->sel_poke].hp, 3,
			NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
	// PP
	}else if( ItemBufParamGet( item, ITEM_PRM_PP_RCV ) != 0 ||
		ItemBufParamGet( item, ITEM_PRM_ALL_PP_RCV ) != 0 ){

		MSGMAN_GetString( wk->mman, mes_b_plist_m12, wk->msg_buf );
	// Xe[^XS
	}else if( prm == BPL_RCV_ALL ){
		str = MSGMAN_AllocString( wk->mman, mes_b_plist_m14 );
		WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(pp) );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
	// 
	}else if( prm == BPL_RCV_SLEEP ){
		str = MSGMAN_AllocString( wk->mman, mes_b_plist_m17 );
		WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(pp) );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
	// 
	}else if( prm == BPL_RCV_POISON ){
		str = MSGMAN_AllocString( wk->mman, mes_b_plist_m08 );
		WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(pp) );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
	// Ώ
	}else if( prm == BPL_RCV_BURN ){
		str = MSGMAN_AllocString( wk->mman, mes_b_plist_m10 );
		WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(pp) );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
	// X
	}else if( prm == BPL_RCV_ICE ){
		str = MSGMAN_AllocString( wk->mman, mes_b_plist_m11 );
		WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(pp) );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
	// 
	}else if( prm == BPL_RCV_PARALYZE ){
		str = MSGMAN_AllocString( wk->mman, mes_b_plist_m09 );
		WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(pp) );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
	// 
	}else if( prm == BPL_RCV_PANIC ){
		str = MSGMAN_AllocString( wk->mman, mes_b_plist_m15 );
		WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(pp) );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
	// 
	}else if( prm == BPL_RCV_MEROMERO ){
		str = MSGMAN_AllocString( wk->mman, mes_b_plist_m16 );
		WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(pp) );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
	}

	sys_FreeMemoryEz( item );
}
