//============================================================================================
/**
 * @file	b_plist_main.c
 * @bfief	퓬p|PXg
 * @author	Hiroyuki Nakamura
 * @date	05.02.01
 */
//============================================================================================
#include "common.h"
#include "gflib/touchpanel.h"
#include "system/procsys.h"
#include "system/palanm.h"
#include "system/window.h"
#include "system/lib_pack.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/fontproc.h"
#include "system/msgdata.h"
#include "system/numfont.h"
#include "system/wordset.h"
#include "system/font_arc.h"
#include "system/clact_tool.h"
#include "system/snd_tool.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_b_plist.h"
#include "battle/battle_common.h"
#include "battle/fight_tool.h"
#include "poketool/pokeparty.h"
#include "poketool/waza_tool.h"
#include "poketool/status_rcv.h"
#include "itemtool/item.h"
#include "itemtool/myitem.h"
#include "application/p_status.h"
#include "application/app_tool.h"
#include "b_bag.h"

#define	B_PLIST_H_GLOBAL
#define	B_PLIST_MAIN_H_GLOBAL
#include "b_plist.h"
#include "b_plist_main.h"
#include "b_plist_obj.h"
#include "b_plist_anm.h"
#include "b_plist_bmp.h"
#include "b_plist_bmp_def.h"
#include "b_plist_gra.naix"


//============================================================================================
//	萔`
//============================================================================================
// CV[PX
enum {
	SEQ_BPL_INIT = 0,		// 
	SEQ_BPL_SELECT,			// |PIʃRg[
	SEQ_BPL_ST_MAIN,		// Xe[^XCʃRg[
	SEQ_BPL_ST_INFO,		// Xe[^Xڍ׉ʃRg[
	SEQ_BPL_SKILL,			// ZʃRg[

	SEQ_BPL_PAGE1_CHG,		// |PI
	SEQ_BPL_PAGE2_CHG,		// Xe[^XC
	SEQ_BPL_PAGE3_CHG,		// Xe[^Xڍׂ
	SEQ_BPL_PAGE4_CHG,		// Zʂ
	SEQ_BPL_PAGE5_CHG,		// ZYʂ
	SEQ_BPL_PAGE6_CHG,		// ZYꌈ
	SEQ_BPL_PAGE7_CHG,		// Z񕜂

	SEQ_BPL_POKECHG,		// |P؂ւ
	SEQ_BPL_IREKAE_ERR,		// ւG[I҂

	SEQ_BPL_MSG_WAIT,		// bZ[W\
	SEQ_BPL_TRG_WAIT,		// bZ[W\̃L[҂

	SEQ_BPL_WAZADEL_SEL,	// ZYI
	SEQ_BPL_WAZADEL_MAIN,	// ZYꌈ

	SEQ_BPL_WAZARCV_SEL,	// Z񕜑I

	SEQ_BPL_BUTTON_WAIT,	// {^AjI҂

	SEQ_BPL_STRCV,			// Xe[^X

	SEQ_BPL_ENDSET,			// ItF[hZbg
	SEQ_BPL_END,			// I
};

#define	TMP_MSG_BUF_SIZ		( 512 )		// e|bZ[WTCY

#define	PLATE_BG_SX		( 16 )		// v[gBGTCYX
#define	PLATE_BG_SY		( 6 )		// v[gBGTCYY
#define	PLATE_BG_P_PX	( 0 )		// |Pꍇ̃v[gBGQXW
#define	PLATE_BG_P_PY	( 0 )		// |Pꍇ̃v[gBGQYW
#define	PLATE_BG_N_PX	( 16 )		// |PȂꍇ̃v[gBGQXW
#define	PLATE_BG_N_PY	( 13 )		// |PȂꍇ̃v[gBGQYW

#define	PLATE_POKE1_PX	( 0 )		// |PP̃v[gBGXW
#define	PLATE_POKE1_PY	( 0 )		// |PP̃v[gBGYW
#define	PLATE_POKE2_PX	( 16 )		// |PQ̃v[gBGXW
#define	PLATE_POKE2_PY	( 1 )		// |PQ̃v[gBGYW
#define	PLATE_POKE3_PX	( 0 )		// |PR̃v[gBGXW
#define	PLATE_POKE3_PY	( 6 )		// |PR̃v[gBGYW
#define	PLATE_POKE4_PX	( 16 )		// |PS̃v[gBGXW
#define	PLATE_POKE4_PY	( 7 )		// |PS̃v[gBGYW
#define	PLATE_POKE5_PX	( 0 )		// |PT̃v[gBGXW
#define	PLATE_POKE5_PY	( 12 )		// |PT̃v[gBGYW
#define	PLATE_POKE6_PX	( 16 )		// |PŨv[gBGXW
#define	PLATE_POKE6_PY	( 13 )		// |PŨv[gBGYW

#define	P2_EXPGAGE_PX	( 32+14 )	// y[WQ̌olQ[WXW
#define	P2_EXPGAGE_PY	( 5 )		// y[WQ̌olQ[WYW
#define	P3_EXPGAGE_PX	( 11 )		// y[WŘolQ[WXW
#define	P3_EXPGAGE_PY	( 40 )		// y[WŘolQ[WYW

#define	EXP_CGX			( 0x10 )	// olQ[WLԍ
#define	EXP_DOT_CHR_MAX	( 8 )		// olQ[W̃L
#define	EXP_DOT_MAX		( 64 )		// olQ[W̍őhbg


//============================================================================================
//	vg^Cv錾
//============================================================================================
static void BattlePokeList_Main( TCB_PTR tcb, void * work );

static u8 BPL_SeqInit( BPLIST_WORK * wk );
static u8 BPL_SeqPokeSelect( BPLIST_WORK * wk );
static u8 BPL_SeqStatusMain( BPLIST_WORK * wk );
static u8 BPL_SeqIrekaeErr( BPLIST_WORK * wk );
static u8 BPL_SeqMsgWait( BPLIST_WORK * wk );
static u8 BPL_SeqTrgWait( BPLIST_WORK * wk );
static u8 BPL_SeqPokeChange( BPLIST_WORK * wk );
static u8 BPL_SeqStInfoWaza( BPLIST_WORK * wk );
static u8 BPL_SeqWazaDelSelect( BPLIST_WORK * wk );
static u8 BPL_SeqWazaDelMain( BPLIST_WORK * wk );
static u8 BPL_SeqWazaRcvSelect( BPLIST_WORK * wk );
static u8 BPL_SeqButtonWait( BPLIST_WORK * wk );
static u8 BPL_SeqPage1Chg( BPLIST_WORK * wk );
static u8 BPL_SeqPage2Chg( BPLIST_WORK * wk );
static u8 BPL_SeqPage3Chg( BPLIST_WORK * wk );
static u8 BPL_SeqPage4Chg( BPLIST_WORK * wk );
static u8 BPL_SeqPage5Chg( BPLIST_WORK * wk );
static u8 BPL_SeqPage6Chg( BPLIST_WORK * wk );
static u8 BPL_SeqPage7Chg( BPLIST_WORK * wk );
static u8 BPL_SeqStRcv( BPLIST_WORK * wk );
static u8 BPL_SeqEndSet( BPLIST_WORK * wk );
static u8 BPL_SeqEnd( TCB_PTR tcb, BPLIST_WORK * wk );






static u8 BPL_PokeItemUse( BPLIST_WORK * wk );

static void BPL_VramInit(void);
static void BPL_BgInit( BPLIST_WORK * dat );
static void BPL_BgExit( GF_BGL_INI * ini );
static void BPL_BgGraphicSet( BPLIST_WORK * wk );
static void BPL_MsgManSet( BPLIST_WORK * wk );
static void BPL_MsgManExit( BPLIST_WORK * wk );
static void BPL_PokeDataMake( BPLIST_WORK * wk );

static u8 BPL_PokemonSelect( BPLIST_WORK * wk );
static u8 BPL_StatusMainSelect( BPLIST_WORK * wk );
static u8 BPL_StInfoWazaSelect( BPLIST_WORK * wk );
static int BPL_TPCheck( BPLIST_WORK * wk, const RECT_HIT_TBL * tbl );
static void BPL_PageChange( BPLIST_WORK * wk, u8 next_page );
static void BPL_PageChgBgScroll( BPLIST_WORK * wk, u8 page );
static u8 BPL_IrekaeCheck( BPLIST_WORK * wk );
static u8 BPL_NextPokeGet( BPLIST_WORK * wk, s32 pos, s32 mv );
static void BPL_PokePlateSet( BPLIST_WORK * wk );
static void BPL_ExpGagePut( BPLIST_WORK * wk, u8 page );
static void BPL_P2_ExpGagePut( BPLIST_WORK * wk, u16 cgx, u16 px, u16 py );
static void BPL_P3_ExpGagePut( BPLIST_WORK * wk, u16 cgx, u16 px, u16 py );


//============================================================================================
//	O[oϐ
//============================================================================================
// v[g\ʒu
static const u8 PlatePos[][2] =
{
	{ PLATE_POKE1_PX, PLATE_POKE1_PY },
	{ PLATE_POKE2_PX, PLATE_POKE2_PY },
	{ PLATE_POKE3_PX, PLATE_POKE3_PY },
	{ PLATE_POKE4_PX, PLATE_POKE4_PY },
	{ PLATE_POKE5_PX, PLATE_POKE5_PY },
	{ PLATE_POKE6_PX, PLATE_POKE6_PY }
};

// |PIʈړe[u
static const POINTER_WORK NormalMoveTable[] =
{
	{  0,  0, 16, 6,	6,2,0,1 },		// 0
	{ 16,  1, 16, 6,	4,3,0,1 },		// 1
	{  0,  6, 16, 6,	0,4,2,3 },		// 2
	{ 16,  7, 16, 6,	1,5,2,3 },		// 3
	{  0, 12, 16, 6,	2,1,4,5 },		// 4
	{ 16, 13, 16, 6,	3,6,4,5 },		// 5
	{ 25, 19,  7, 5,	5,0,6,6 },		// 6i߂j
};

// y[WP̃^b`plW
static const RECT_HIT_TBL Page1_HitRect[] =
{
	{  0*8,  6*8-1,  0*8, 16*8-1 },
	{  1*8,  7*8-1, 16*8, 32*8-1 },
	{  6*8, 12*8-1,  0*8, 16*8-1 },
	{  7*8, 13*8-1, 16*8, 32*8-1 },
	{ 12*8, 18*8-1,  0*8, 16*8-1 },
	{ 13*8, 19*8-1, 16*8, 32*8-1 },
	{ 19*8, 24*8-1, 27*8, 32*8-1 },
	{ RECT_HIT_END, 0, 0, 0 }
};

// y[WQ̃^b`plW
static const RECT_HIT_TBL Page2_HitRect[] =
{
	{  4*8,  8*8-1,  0*8,  5*8-1 },		// 0 : Xe[^Xڍ׉ʂ
	{ 10*8, 14*8-1,  0*8,  5*8-1 },		// 1 : ZPʂ
	{ 10*8, 14*8-1, 27*8, 32*8-1 },		// 2 : ZQʂ
	{ 14*8, 18*8-1,  0*8,  5*8-1 },		// 3 : ZRʂ
	{ 14*8, 18*8-1, 27*8, 32*8-1 },		// 4 : ZSʂ
	{ 19*8, 24*8-1,  0*8, 10*8-1 },		// 5 : ꂩ
	{ 19*8, 24*8-1, 21*8, 26*8-1 },		// 6 : Õ|P
	{ 19*8, 24*8-1, 16*8, 21*8-1 },		// 7 : ̃|P
	{ 19*8, 24*8-1, 27*8, 32*8-1 },		// 8 : ߂
	{ RECT_HIT_END, 0, 0, 0 }
};

// y[WRES̃^b`plW
static const RECT_HIT_TBL Page34_HitRect[] =
{
//	{ 19*8, 24*8-1, 25*8, 32*8-1 },		// 0 : ߂
	{ 0*8, 24*8-1, 0*8, 32*8-1 },		// 0 : ߂
	{ RECT_HIT_END, 0, 0, 0 }
};

// y[WT̃^b`plW
static const RECT_HIT_TBL Page5_HitRect[] =
{
	{  6*8, 12*8-1,  0*8, 16*8-1 },		// 0 : ZPʂ
	{  6*8, 12*8-1, 16*8, 32*8-1 },		// 1 : ZQʂ
	{ 12*8, 18*8-1,  0*8, 16*8-1 },		// 2 : ZRʂ
	{ 12*8, 18*8-1, 16*8, 32*8-1 },		// 3 : ZSʂ
	{ 18*8, 24*8-1,  8*8, 24*8-1 },		// 4 : ZTʂ
	{  0*8,  5*8-1, 23*8, 32*8-1 },		// 5 : 퓬<->ReXg̐؂ւ
	{ 19*8, 24*8-1, 27*8, 32*8-1 },		// 6 : ߂
	{ RECT_HIT_END, 0, 0, 0 }
};

// y[WŨ^b`plW
static const RECT_HIT_TBL Page6_HitRect[] =
{
	{ 19*8, 24*8-1,  0*8,  9*8-1 },		// 0 : 퓬
	{  0*8,  5*8-1, 23*8, 32*8-1 },		// 1 : 퓬<->ReXg̐؂ւ
	{ 19*8, 24*8-1, 27*8, 32*8-1 },		// 2 : ߂
	{ RECT_HIT_END, 0, 0, 0 }
};

// y[WṼ^b`plW
static const RECT_HIT_TBL Page7_HitRect[] =
{
	{  6*8, 12*8-1,  0*8, 16*8-1 },		// 0 : ZP
	{  6*8, 12*8-1, 16*8, 32*8-1 },		// 1 : ZQ
	{ 12*8, 18*8-1,  0*8, 16*8-1 },		// 2 : ZR
	{ 12*8, 18*8-1, 16*8, 32*8-1 },		// 3 : ZS
	{ 19*8, 24*8-1, 27*8, 32*8-1 },		// 4 : ߂
	{ RECT_HIT_END, 0, 0, 0 }
};


//--------------------------------------------------------------------------------------------
/**
 * 퓬p|PXg^XNǉ
 *
 * @param	dat		Xgf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BattlePokeList_TaskAdd( BPLIST_DATA * dat )
{
	BPLIST_WORK * wk;

	wk = TCB_GetWork( PMDS_taskAdd(BattlePokeList_Main,sizeof(BPLIST_WORK),0,dat->heap) );

	memset( wk, 0, sizeof(BPLIST_WORK) );
	wk->dat = dat;
	wk->bgl = BattleWorkGF_BGL_INIGet( dat->bw );
	wk->pfd = BattleWorkPfdGet( dat->bw );
	wk->seq = SEQ_BPL_INIT;
	wk->init_poke = dat->sel_poke;

/*** eXg ***/
//	wk->dat->chg_waza = 20;
//	wk->dat->mode = BPL_MODE_WAZASET;
//	wk->page = BPLIST_PAGE_PP_RCV;		// PP񕜋ZIy[W
/**************/
}

//--------------------------------------------------------------------------------------------
/**
 * C^XN
 *
 * @param	tcb
 * @param	work
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BattlePokeList_Main( TCB_PTR tcb, void * work )
{
	BPLIST_WORK * wk = (BPLIST_WORK *)work;

	switch( wk->seq ){
	case SEQ_BPL_INIT:		// 
		wk->seq = BPL_SeqInit( wk );
		break;

	case SEQ_BPL_SELECT:	// |PIʃRg[
		wk->seq = BPL_SeqPokeSelect( wk );
		break;

	case SEQ_BPL_ST_MAIN:	// Xe[^XCʃRg[
		wk->seq = BPL_SeqStatusMain( wk );
		break;

	case SEQ_BPL_ST_INFO:	// Xe[^Xڍ׉ʃRg[
		wk->seq = BPL_SeqStInfoWaza( wk );
		break;

	case SEQ_BPL_SKILL:		// ZʃRg[
		wk->seq = BPL_SeqStInfoWaza( wk );
		break;

	case SEQ_BPL_PAGE1_CHG:
		wk->seq = BPL_SeqPage1Chg( wk );
		break;

	case SEQ_BPL_PAGE2_CHG:
		wk->seq = BPL_SeqPage2Chg( wk );
		break;

	case SEQ_BPL_PAGE3_CHG:
		wk->seq = BPL_SeqPage3Chg( wk );
		break;

	case SEQ_BPL_PAGE4_CHG:
		wk->seq = BPL_SeqPage4Chg( wk );
		break;

	case SEQ_BPL_PAGE5_CHG:
		wk->seq = BPL_SeqPage5Chg( wk );
		break;

	case SEQ_BPL_PAGE6_CHG:
		wk->seq = BPL_SeqPage6Chg( wk );
		break;

	case SEQ_BPL_PAGE7_CHG:
		wk->seq = BPL_SeqPage7Chg( wk );
		break;

	case SEQ_BPL_POKECHG:		// |P؂ւ
		wk->seq = BPL_SeqPokeChange( wk );
		break;

	case SEQ_BPL_IREKAE_ERR:	// ւG[I҂
		wk->seq = BPL_SeqIrekaeErr( wk );
		break;

	case SEQ_BPL_MSG_WAIT:	// bZ[WEFCg
		wk->seq = BPL_SeqMsgWait( wk );
		break;

	case SEQ_BPL_TRG_WAIT:	// bZ[W\̃L[҂
		wk->seq = BPL_SeqTrgWait( wk );
		break;

	case SEQ_BPL_WAZADEL_SEL:	// ZYI
		wk->seq = BPL_SeqWazaDelSelect( wk );
		break;

	case SEQ_BPL_WAZADEL_MAIN:	// ZYꌈ
		wk->seq = BPL_SeqWazaDelMain( wk );
		break;

	case SEQ_BPL_WAZARCV_SEL:	// Z񕜑I
		wk->seq = BPL_SeqWazaRcvSelect( wk );
		break;

	case SEQ_BPL_BUTTON_WAIT:	// {^AjI҂
		wk->seq = BPL_SeqButtonWait( wk );
		break;

	case SEQ_BPL_STRCV:			// Xe[^X
		wk->seq = BPL_SeqStRcv( wk );
		break;

	case SEQ_BPL_ENDSET:	// ItF[hZbg
		wk->seq = BPL_SeqEndSet( wk );
		break;

	case SEQ_BPL_END:		// I
		if( BPL_SeqEnd( tcb, wk ) == TRUE ){
			return;
		}
	}

	CATS_Draw( wk->crp );
	BattlePokeList_ButtonAnmMain( wk );
}

//--------------------------------------------------------------------------------------------
/**
 * V[PX
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 BPL_SeqInit( BPLIST_WORK * wk )
{
	u8	ret;

	G2S_BlendNone();

	if( wk->dat->mode == BPL_MODE_WAZASET ){
		wk->page = BPLIST_PAGE_SKILL_SET1;
		ret = SEQ_BPL_WAZADEL_SEL;
	}else{
		wk->page = BPLIST_PAGE_SELECT;
		ret = SEQ_BPL_SELECT;
	}

	BPL_PokeDataMake( wk );

	BPL_VramInit();
	BPL_BgInit( wk );
	BPL_BgGraphicSet( wk );
	BPL_MsgManSet( wk );

	FontProc_LoadFont( FONT_BUTTON, wk->dat->heap );

	BPL_PokePlateSet( wk );

	BPL_PageChgBgScroll( wk, wk->page );

	BattlePokeList_ObjInit( wk );
	BattlePokeList_PageObjSet( wk, wk->page );

	BattlePokeList_BmpInit( wk );
	BattlePokeList_BmpWrite( wk, wk->page );

	BPL_ExpGagePut( wk, wk->page );

	PaletteFadeReq( wk->pfd, PF_BIT_SUB_ALL, 0xffff, 0, 16, 0, 0 );

	return ret;
}

//--------------------------------------------------------------------------------------------
/**
 * y[WP̃Rg[V[PX
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 BPL_SeqPokeSelect( BPLIST_WORK * wk )
{
	if( PaletteFadeCheck( wk->pfd ) != 0 ){ return SEQ_BPL_SELECT; }

/*
	if( sys.trg & PAD_BUTTON_A ){
		PaletteFadeReq( wk->pfd, PF_BIT_SUB_ALL, 0xffff, 0, 0, 16, 0 );
		return SEQ_BPL_END;
	}
*/

	if( BPL_PokemonSelect( wk ) == TRUE ){
		if( wk->dat->sel_poke == BPL_SEL_EXIT ){
			if( wk->dat->mode != BPL_MODE_NO_CANCEL ){
				BattlePokeList_ButtonAnmInit( wk, BPL_BUTTON_RET1, BPL_BTNANM_MODE_CHG );
				return SEQ_BPL_ENDSET;
			}
		}else{
			BattlePokeList_ButtonAnmInit(
				wk, BPL_BUTTON_POKE1+wk->dat->sel_poke, BPL_BTNANM_MODE_CHG );
			if( wk->dat->mode == BPL_MODE_ITEMUSE ){
				return BPL_PokeItemUse( wk );
			}else{
				wk->ret_seq = SEQ_BPL_PAGE2_CHG;
			}
		}
		return SEQ_BPL_BUTTON_WAIT;
	}

	return SEQ_BPL_SELECT;
}

static u8 BPL_PokeItemUse( BPLIST_WORK * wk )
{
	BPLIST_DATA * dat = wk->dat;

//	BattlePokeList_ButtonAnmInit( wk, BPL_BUTTON_POKE1+dat->sel_poke, BPL_BTNANM_MODE_END );

	if( ItemParamGet( dat->item, ITEM_PRM_PP_RCV, wk->dat->heap ) != 0 &&
		ItemParamGet( dat->item, ITEM_PRM_ALL_PP_RCV, wk->dat->heap ) == 0 ){

		wk->ret_seq = SEQ_BPL_PAGE7_CHG;
		return SEQ_BPL_BUTTON_WAIT;
	}

	if( BattleWorkStatusRecover(dat->bw,dat->client_no,dat->list_row[dat->sel_poke],0,dat->item) == TRUE ){
		wk->rcv_seq = 0;
		wk->ret_seq = SEQ_BPL_STRCV;
		return SEQ_BPL_BUTTON_WAIT;
/*
		BattlePokeList_ItemUseMsgSet( wk );
		BattlePokeList_TalkMsgSet( wk );
		wk->ret_seq = SEQ_BPL_ENDSET;
*/
	}else{
		MSGMAN_GetString( wk->mman, mes_b_plist_m06, wk->msg_buf );
		BattlePokeList_TalkMsgSet( wk );
		wk->dat->sel_poke = BPL_SEL_EXIT;
		wk->ret_seq = SEQ_BPL_ENDSET;
		return SEQ_BPL_MSG_WAIT;
	}
	return SEQ_BPL_MSG_WAIT;
}

//--------------------------------------------------------------------------------------------
/**
 * y[WQ̃Rg[V[PX
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 BPL_SeqStatusMain( BPLIST_WORK * wk )
{
	u8	ret = BPL_StatusMainSelect( wk );

	switch( ret ){
	case 0:
		BattlePokeList_ButtonAnmInit( wk, BPL_BUTTON_STATUS, BPL_BTNANM_MODE_END );
		wk->ret_seq = SEQ_BPL_PAGE3_CHG;
		return SEQ_BPL_BUTTON_WAIT;

	case 1:
	case 2:
	case 3:
	case 4:
		BattlePokeList_ButtonAnmInit( wk, BPL_BUTTON_WAZA1+ret-1, BPL_BTNANM_MODE_END );
		if( wk->poke[wk->dat->sel_poke].waza[ret-1].id == 0 ){
			wk->ret_seq = SEQ_BPL_ST_MAIN;
		}else{
			wk->dat->sel_wp = ret-1;
			wk->ret_seq = SEQ_BPL_PAGE4_CHG;
		}
		return SEQ_BPL_BUTTON_WAIT;

	case 5:
		BattlePokeList_ButtonAnmInit( wk, BPL_BUTTON_CHANGE, BPL_BTNANM_MODE_END );
		if( BPL_IrekaeCheck( wk ) == TRUE ){
			return SEQ_BPL_ENDSET;
		}
		BattlePokeList_TalkMsgSet( wk );
		wk->ret_seq = SEQ_BPL_IREKAE_ERR;
		return SEQ_BPL_MSG_WAIT;

	case 6:
		BattlePokeList_ButtonAnmInit( wk, BPL_BUTTON_DOWN, BPL_BTNANM_MODE_END );
		{
			u8 pos = BPL_NextPokeGet( wk, wk->dat->sel_poke, 1 );
			if( pos == 0xff ){
				wk->ret_seq = SEQ_BPL_ST_MAIN;
				return SEQ_BPL_BUTTON_WAIT;
			}
			wk->dat->sel_poke = pos;
		}
		wk->ret_seq = SEQ_BPL_POKECHG;
		return SEQ_BPL_BUTTON_WAIT;

	case 7:
		BattlePokeList_ButtonAnmInit( wk, BPL_BUTTON_UP, BPL_BTNANM_MODE_END );
		{
			u8 pos = BPL_NextPokeGet( wk, wk->dat->sel_poke, -1 );
			if( pos == 0xff ){
				wk->ret_seq = SEQ_BPL_ST_MAIN;
				return SEQ_BPL_BUTTON_WAIT;
			}
			wk->dat->sel_poke = pos;
		}
		wk->ret_seq = SEQ_BPL_POKECHG;
		return SEQ_BPL_BUTTON_WAIT;

	case 8:
		BattlePokeList_ButtonAnmInit( wk, BPL_BUTTON_RET2, BPL_BTNANM_MODE_END );
		wk->ret_seq = SEQ_BPL_PAGE1_CHG;
		return SEQ_BPL_BUTTON_WAIT;
	}

	return SEQ_BPL_ST_MAIN;
}

//--------------------------------------------------------------------------------------------
/**
 * y[WRES̃Rg[V[PX
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 BPL_SeqStInfoWaza( BPLIST_WORK * wk )
{
	u8	ret = BPL_StInfoWazaSelect( wk );

	if( BPL_StInfoWazaSelect( wk ) != 0xff ){
//		BPL_PageChange( wk, BPLIST_PAGE_MAIN );
		if( wk->page == BPLIST_PAGE_STATUS ){
			BattlePokeList_ButtonAnmInit( wk, BPL_BUTTON_RET3, BPL_BTNANM_MODE_END );
		}else{
			BattlePokeList_ButtonAnmInit( wk, BPL_BUTTON_RET4, BPL_BTNANM_MODE_END );
		}
		wk->ret_seq = SEQ_BPL_PAGE2_CHG;
		return SEQ_BPL_BUTTON_WAIT;
	}
	return wk->seq;
}

//--------------------------------------------------------------------------------------------
/**
 * y[WT̃Rg[V[PX
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 BPL_SeqWazaDelSelect( BPLIST_WORK * wk )
{
	int	ret = BPL_TPCheck( wk, Page5_HitRect );

	switch( ret ){
	case 0:		// Z
	case 1:
	case 2:
	case 3:
	case 4:
		wk->dat->sel_wp = (u8)ret;
		BPL_PageChange( wk, BPLIST_PAGE_SKILL_SET2 );
		return SEQ_BPL_WAZADEL_MAIN;
	case 5:		// 퓬<->ReXg؂ւ
		wk->bc_put ^= 1;
		BattlePokelist_WazaTypeSet( wk );
		break;
	case 6:		// LZ
		wk->dat->sel_wp = 4;
		return SEQ_BPL_ENDSET;
	}
	return SEQ_BPL_WAZADEL_SEL;
}

//--------------------------------------------------------------------------------------------
/**
 * y[WŨRg[V[PX
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 BPL_SeqWazaDelMain( BPLIST_WORK * wk )
{
	switch( BPL_TPCheck( wk, Page6_HitRect ) ){
	case 0:		// 킷
		return SEQ_BPL_ENDSET;
	case 1:		// 퓬<->ReXg؂ւ
		break;
	case 2:		// LZ
		BPL_PageChange( wk, BPLIST_PAGE_SKILL_SET1 );
		return SEQ_BPL_WAZADEL_SEL;
	}
	return SEQ_BPL_WAZADEL_MAIN;
}

//--------------------------------------------------------------------------------------------
/**
 * y[WṼRg[V[PX
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 BPL_SeqWazaRcvSelect( BPLIST_WORK * wk )
{
	BPLIST_DATA * dat;
	int	ret;

	dat = wk->dat;
	ret = BPL_TPCheck( wk, Page7_HitRect );

	switch( ret ){
	case 0:		// Z
	case 1:
	case 2:
	case 3:
		BattlePokeList_ButtonAnmInit( wk, BPL_BUTTON_WAZARCV1+ret, BPL_BTNANM_MODE_END );
		if( wk->poke[dat->sel_poke].waza[ret].id == 0 ){
			wk->ret_seq = SEQ_BPL_WAZARCV_SEL;
			return SEQ_BPL_BUTTON_WAIT;
		}
		if( BattleWorkStatusRecover(dat->bw,dat->client_no,dat->list_row[dat->sel_poke],ret,dat->item) == TRUE ){
			wk->rcv_seq = 0;
			wk->ret_seq = SEQ_BPL_STRCV;
			return SEQ_BPL_BUTTON_WAIT;
		}else{
			MSGMAN_GetString( wk->mman, mes_b_plist_m06, wk->msg_buf );
			BattlePokeList_TalkMsgSet( wk );
			wk->dat->sel_poke = BPL_SEL_EXIT;
			wk->ret_seq = SEQ_BPL_ENDSET;
			return SEQ_BPL_MSG_WAIT;
		}
		break;

	case 4:		// LZ
		BattlePokeList_ButtonAnmInit( wk, BPL_BUTTON_RET7, BPL_BTNANM_MODE_END );
		wk->ret_seq = SEQ_BPL_PAGE1_CHG;
		return SEQ_BPL_BUTTON_WAIT;
	}
	return SEQ_BPL_WAZARCV_SEL;
}


static u8 BPL_SeqPage1Chg( BPLIST_WORK * wk )
{
	BPL_PageChange( wk, BPLIST_PAGE_SELECT );
	return SEQ_BPL_SELECT;
}

static u8 BPL_SeqPage2Chg( BPLIST_WORK * wk )
{
	BPL_PageChange( wk, BPLIST_PAGE_MAIN );
	return SEQ_BPL_ST_MAIN;
}

static u8 BPL_SeqPage3Chg( BPLIST_WORK * wk )
{
	BPL_PageChange( wk, BPLIST_PAGE_STATUS );
	return SEQ_BPL_ST_INFO;
}

static u8 BPL_SeqPage4Chg( BPLIST_WORK * wk )
{
	BPL_PageChange( wk, BPLIST_PAGE_SKILL );
	return SEQ_BPL_SKILL;
}

static u8 BPL_SeqPage5Chg( BPLIST_WORK * wk )
{
	BPL_PageChange( wk, BPLIST_PAGE_SKILL_SET1 );
	return SEQ_BPL_PAGE5_CHG;
}

static u8 BPL_SeqPage6Chg( BPLIST_WORK * wk )
{
	BPL_PageChange( wk, BPLIST_PAGE_SKILL_SET2 );
	return SEQ_BPL_PAGE6_CHG;
}

static u8 BPL_SeqPage7Chg( BPLIST_WORK * wk )
{
	BPL_PageChange( wk, BPLIST_PAGE_PP_RCV );
	return SEQ_BPL_WAZARCV_SEL;
}

//--------------------------------------------------------------------------------------------
/**
 * |P肩V[PX
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 BPL_SeqPokeChange( BPLIST_WORK * wk )
{
	BattlePokeList_PageObjSet( wk, wk->page );
	BattlePokeList_BmpWrite( wk, wk->page );
	BPL_ExpGagePut( wk, wk->page );
	return SEQ_BPL_ST_MAIN;
}

//--------------------------------------------------------------------------------------------
/**
 * ւG[bZ[WI҂V[PX
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 BPL_SeqIrekaeErr( BPLIST_WORK * wk )
{
	BmpTalkWinClear( &wk->win[WIN_TALK], WINDOW_TRANS_ON );
	return SEQ_BPL_ST_MAIN;
}

//--------------------------------------------------------------------------------------------
/**
 * bZ[W\V[PX
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 BPL_SeqMsgWait( BPLIST_WORK * wk )
{
	if( GF_MSG_PrintEndCheck( wk->midx ) == 0 ){
		return SEQ_BPL_TRG_WAIT;
	}
	return SEQ_BPL_MSG_WAIT;
}

//--------------------------------------------------------------------------------------------
/**
 * bZ[W\̃L[҂V[PX
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 BPL_SeqTrgWait( BPLIST_WORK * wk )
{
	if( ( sys.trg & (PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL) ) || GF_TP_GetTrg() == TRUE ){
		return wk->ret_seq;
	}
	return SEQ_BPL_TRG_WAIT;
}

//--------------------------------------------------------------------------------------------
/**
 * {^AjI҂V[PX
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 BPL_SeqButtonWait( BPLIST_WORK * wk )
{
	if( wk->btn_flg == 0 ){
		return wk->ret_seq;
	}
	return SEQ_BPL_BUTTON_WAIT;
}


static u8 BPL_SeqStRcv( BPLIST_WORK * wk )
{
	BPLIST_DATA * dat = wk->dat;

	switch( wk->rcv_seq ){
	case 0:
		wk->poke[dat->sel_poke].pp =
			BattleWorkPokemonParamGet( dat->bw, dat->client_no, dat->list_row[dat->sel_poke] );
		wk->poke[dat->sel_poke].st = BadStatusIconAnmGet( wk->poke[dat->sel_poke].pp );
		if( wk->poke[dat->sel_poke].st == ST_ICON_NONE ){
			CATS_ObjectEnableCap( wk->cap[BPL_CA_STATUS1+dat->sel_poke], 0 );
		}
		BattlePokeList_ItemUseMsgSet( wk );
		wk->rcv_hp = PokeParaGet( wk->poke[dat->sel_poke].pp, ID_PARA_hp, NULL );
		wk->rcv_seq = 1;
		break;

	case 1:
		if( wk->poke[dat->sel_poke].hp != wk->rcv_hp ){
			wk->poke[dat->sel_poke].hp++;
			BattlePokeList_P1_HPRcv( wk, dat->sel_poke );
			break;
		}
		wk->rcv_seq = 2;
		break;

	case 2:
		MyItem_SubItem( dat->myitem, dat->item, 1, dat->heap );
		BattlePokeList_TalkMsgSet( wk );
		wk->ret_seq = SEQ_BPL_ENDSET;
		return SEQ_BPL_MSG_WAIT;
	}
	return SEQ_BPL_STRCV;
}


//--------------------------------------------------------------------------------------------
/**
 * ItF[hZbgV[PX
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 BPL_SeqEndSet( BPLIST_WORK * wk )
{
	PaletteFadeReq( wk->pfd, PF_BIT_SUB_ALL, 0xffff, 0, 0, 16, 0 );
	return SEQ_BPL_END;
}

//--------------------------------------------------------------------------------------------
/**
 * IV[PX
 *
 * @param	wk		[N
 *
 * @retval	"TRUE = I"
 * @retval	"FALSE = tF[h"
 */
//--------------------------------------------------------------------------------------------
static u8 BPL_SeqEnd( TCB_PTR tcb, BPLIST_WORK * wk )
{
	if( PaletteFadeCheck( wk->pfd ) != 0 ){ return FALSE; }

	BPL_MsgManExit( wk );
	BattlePokeList_ObjFree( wk );
	BattlePokeList_BmpFreeAll( wk );
	BPL_BgExit( wk->bgl );

	FontProc_UnloadFont( FONT_BUTTON );

	wk->dat->end_flg = 1;
	PMDS_taskDel( tcb );

	return TRUE;
}


//--------------------------------------------------------------------------------------------
/**
 * VRAM
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_VramInit(void)
{
	GF_BGL_DISPVRAM	tbl = {
		GX_VRAM_BG_128_A,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
		GX_VRAM_SUB_BG_128_C,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
		GX_VRAM_OBJ_64_E,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
		GX_VRAM_TEX_0_B,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_01_FG			// eNX`pbgXbg
	};
	GF_Disp_SetBank( &tbl );
}

//--------------------------------------------------------------------------------------------
/**
 * BG
 *
 * @param	dat		Xgf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_BgInit( BPLIST_WORK * wk )
{
	{	// BG SYSTEM
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_3D,
		};
		GF_BGL_InitBGDisp( &BGsys_data, GF_BGL_SUB_DISP );
	}

	{	// BG (CHAR)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x2000, 0, GF_BGL_SCRSIZ_512x512, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xd000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_23,
			3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( wk->bgl, GF_BGL_FRAME3_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
	}

	{	// BG2 (CHAR)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x2000, 0, GF_BGL_SCRSIZ_512x512, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xb000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_23,
			2, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( wk->bgl, GF_BGL_FRAME2_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
	}

	{	// PARAM FONT (BMP)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
			1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( wk->bgl, GF_BGL_FRAME1_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( wk->bgl, GF_BGL_FRAME1_S );
	}

	{	// WINDOW (BMP)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x18000, GX_BG_EXTPLTT_01,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( wk->bgl, GF_BGL_FRAME0_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( wk->bgl, GF_BGL_FRAME0_S );
	}
	GF_BGL_ClearCharSet( GF_BGL_FRAME1_S, 32, 0, wk->dat->heap );
	GF_BGL_ClearCharSet( GF_BGL_FRAME0_S, 32, 0, wk->dat->heap );
	GF_BGL_LoadScreenV_Req( wk->bgl, GF_BGL_FRAME1_S );
	GF_BGL_LoadScreenV_Req( wk->bgl, GF_BGL_FRAME0_S );
}

//--------------------------------------------------------------------------------------------
/**
 * BG
 *
 * @param	ini		BGLf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_BgExit( GF_BGL_INI * ini )
{
	GF_Disp_GXS_VisibleControl(
		GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 |
		GX_PLANEMASK_BG2 | GX_PLANEMASK_BG3 |
		GX_PLANEMASK_OBJ, VISIBLE_OFF );

	GF_BGL_BGControlExit( ini, GF_BGL_FRAME0_S );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME1_S );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME2_S );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME3_S );
}

//--------------------------------------------------------------------------------------------
/**
 * OtBbNf[^Zbg
 *
 * @param	wk		|PXgʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_BgGraphicSet( BPLIST_WORK * wk )
{
	ArcUtil_BgCharSet(
		ARC_BPLIST_GRA, NARC_b_plist_gra_b_plist_NCGR,
		wk->bgl, GF_BGL_FRAME3_S, 0, 0, 0, wk->dat->heap );

	if( !( wk->dat->mode == BPL_MODE_ITEMUSE || wk->dat->mode == BPL_MODE_WAZASET ) ){
		ArcUtil_ScrnSet(
			ARC_BPLIST_GRA, NARC_b_plist_gra_b_plist00_NSCR,
			wk->bgl, GF_BGL_FRAME3_S, 0, 0, 0, wk->dat->heap );
		ArcUtil_ScrnSet(
			ARC_BPLIST_GRA, NARC_b_plist_gra_b_plist01_NSCR,
			wk->bgl, GF_BGL_FRAME2_S, 0, 0, 0, wk->dat->heap );
	}else{
		ArcUtil_ScrnSet(
			ARC_BPLIST_GRA, NARC_b_plist_gra_b_plist10_NSCR,
			wk->bgl, GF_BGL_FRAME3_S, 0, 0, 0, wk->dat->heap );
		ArcUtil_ScrnSet(
			ARC_BPLIST_GRA, NARC_b_plist_gra_b_plist11_NSCR,
			wk->bgl, GF_BGL_FRAME2_S, 0, 0, 0, wk->dat->heap );
	}

	{
		NNSG2dScreenData * dat;
		void * buf;
		
		buf = ArchiveDataLoadMalloc(
					ARC_BPLIST_GRA, NARC_b_plist_gra_b_plist_anm_NSCR, wk->dat->heap );
		NNS_G2dGetUnpackedScreenData( buf, &dat );
		BattlePokeList_ButtonScreenMake( wk, (u16 *)dat->rawData );
		sys_FreeMemoryEz( buf );
	}

	PaletteWorkSet_Arc(
		wk->pfd, ARC_BPLIST_GRA, NARC_b_plist_gra_b_plist_NCLR,
		wk->dat->heap, FADE_SUB_BG, 0x20*16, 0 );

	// VXetHgpbgZbg
	PaletteWorkSet_Arc(
		wk->pfd, ARC_FONT, NARC_font_system_ncrl,
		wk->dat->heap, FADE_SUB_BG, 0x20, BPL_PAL_SYS_FONT*16 );

	// btHgpbgZbg
	PaletteWorkSet_Arc(
		wk->pfd, ARC_FONT, NARC_font_talk_ncrl,
		wk->dat->heap, FADE_SUB_BG, 0x20, BPL_PAL_TALK_FONT*16 );

	// bEBhEZbg
	ArcUtil_BgCharSet(
		ARC_WINFRAME, TalkWinCgxArcGet(0), wk->bgl,
		GF_BGL_FRAME0_S, TALK_WIN_CGX_POS, 0, 0, wk->dat->heap );
	PaletteWorkSet_Arc(
		wk->pfd, ARC_WINFRAME, TalkWinPalArcGet(0),
		wk->dat->heap, FADE_SUB_BG, 0x20, BPL_PAL_TALK_WIN*16 );
}


//--------------------------------------------------------------------------------------------
/**
 * bZ[W֘AZbg
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_MsgManSet( BPLIST_WORK * wk )
{
	wk->mman = MSGMAN_Create( MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_b_plist_dat, wk->dat->heap );
	wk->nfnt = NUMFONT_Create( 15, 14, FBMP_COL_NULL, wk->dat->heap );
	wk->wset = WORDSET_Create( wk->dat->heap );

	wk->msg_buf = STRBUF_Create( TMP_MSG_BUF_SIZ, wk->dat->heap );
}

//--------------------------------------------------------------------------------------------
/**
 * bZ[W֘A폜
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_MsgManExit( BPLIST_WORK * wk )
{
	MSGMAN_Delete( wk->mman );
	NUMFONT_Delete( wk->nfnt );
	WORDSET_Delete( wk->wset );

	STRBUF_Delete( wk->msg_buf );
}

//--------------------------------------------------------------------------------------------
/**
 * |Pf[^쐬
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_PokeDataMake( BPLIST_WORK * wk )
{
	u16	i, j;

	for( i=0; i<PokeParty_GetPokeCount(wk->dat->pp); i++ ){
		wk->poke[i].pp = PokeParty_GetMemberPointer( wk->dat->pp, i );
		wk->poke[i].mons = PokeParaGet( wk->poke[i].pp, ID_PARA_monsno, NULL );
		
		if( wk->poke[i].mons == 0 ){ continue; }
		
		wk->poke[i].pow = PokeParaGet( wk->poke[i].pp, ID_PARA_pow, NULL );
		wk->poke[i].def = PokeParaGet( wk->poke[i].pp, ID_PARA_def, NULL );
		wk->poke[i].agi = PokeParaGet( wk->poke[i].pp, ID_PARA_agi, NULL );
		wk->poke[i].spp = PokeParaGet( wk->poke[i].pp, ID_PARA_spepow, NULL );
		wk->poke[i].spd = PokeParaGet( wk->poke[i].pp, ID_PARA_spedef, NULL );
		wk->poke[i].hp  = PokeParaGet( wk->poke[i].pp, ID_PARA_hp, NULL );
		wk->poke[i].mhp = PokeParaGet( wk->poke[i].pp, ID_PARA_hpmax, NULL );

		wk->poke[i].type1 = PokePersonalParaGet( wk->poke[i].mons, ID_PER_type1 );
		wk->poke[i].type2 = PokePersonalParaGet( wk->poke[i].mons, ID_PER_type2 );

		wk->poke[i].lv  = (u8)PokeParaGet( wk->poke[i].pp, ID_PARA_level, NULL );
		wk->poke[i].sex = PokeSexGet( wk->poke[i].pp );
		wk->poke[i].st  = BadStatusIconAnmGet( wk->poke[i].pp );
		wk->poke[i].egg = (u8)PokeParaGet( wk->poke[i].pp, ID_PARA_tamago_flag, NULL );

		wk->poke[i].spa  = (u16)PokeParaGet( wk->poke[i].pp, ID_PARA_speabino, NULL );
		wk->poke[i].item = (u16)PokeParaGet( wk->poke[i].pp, ID_PARA_item, NULL );

		wk->poke[i].now_exp     = PokeParaGet( wk->poke[i].pp, ID_PARA_exp, NULL );
		wk->poke[i].now_lv_exp  = PokeLevelExpGet( wk->poke[i].mons, wk->poke[i].lv );
		wk->poke[i].next_lv_exp = PokeLevelExpGet( wk->poke[i].mons, wk->poke[i].lv+1 );

		for( j=0; j<4; j++ ){
			BPL_POKEWAZA * waza = &wk->poke[i].waza[j];

			waza->id   = PokeParaGet( wk->poke[i].pp, ID_PARA_waza1+j, NULL );
			if( waza->id == 0 ){ continue; }
			waza->pp   = PokeParaGet( wk->poke[i].pp, ID_PARA_pp1+j, NULL );
			waza->mpp  = PokeParaGet( wk->poke[i].pp, ID_PARA_pp_count1+j, NULL );
			waza->mpp  = WT_PPMaxGet( waza->id, waza->mpp );
			waza->type = WT_WazaDataParaGet( waza->id, ID_WTD_wazatype );
			waza->kind = WT_WazaDataParaGet( waza->id, ID_WTD_kind );
			waza->hit  = WT_WazaDataParaGet( waza->id, ID_WTD_hitprobability );
			waza->pow  = WT_WazaDataParaGet( waza->id, ID_WTD_damage );
		}
	}
}

//--------------------------------------------------------------------------------------------
/**
 * |PI
 *
 * @param	wk		[N
 *
 * @retval	"TRUE = Iꂽ"
 * @retval	"FALSE = I"
 */
//--------------------------------------------------------------------------------------------
static u8 BPL_PokemonSelect( BPLIST_WORK * wk )
{
/*
	u8	mv_pos;
	u8	mv_type;
	u8	px, py;

	mv_type = POINT_MV_NULL;

	if( sys.repeat & PAD_KEY_UP ){
		mv_type = POINT_MV_UP;
	}else if( sys.repeat & PAD_KEY_DOWN ){
		mv_type = POINT_MV_DOWN;
	}else if( sys.repeat & PAD_KEY_LEFT ){
		mv_type = POINT_MV_LEFT;
	}else if( sys.repeat & PAD_KEY_RIGHT ){
		mv_type = POINT_MV_RIGHT;
	}

	if( mv_type != POINT_MV_NULL ){
		mv_pos = wk->poke_pos;
		while(1){
			mv_pos = PointerWkMoveSel( wk->mv_tbl, &px, &py, NULL, NULL, mv_pos, mv_type );
			if( mv_pos == PL_SEL_POS_ENTER || mv_pos == PL_SEL_POS_EXIT || mv_pos == 0xff ){
				break;
			}
			if( PokeListDataCheck( wk, mv_pos ) != 0 ){
				break;
			}
		}
		if( mv_pos != wk->pos && mv_pos != 0xff ){
			// BGpbg`FW
			return SEL_MOVE;
		}
	}
*/

	{
		int	ret = BPL_TPCheck( wk, Page1_HitRect );

		if( ret != RECT_HIT_NONE ){
			if( ret == BPL_SEL_EXIT || BattlePokeList_PokeSetCheck( wk, ret ) != 0 ){
				wk->dat->sel_poke = (u8)ret;
//				Snd_SePlay( SEQ_SE_DP_BAG_011 );
				return TRUE;
			}
		}
	}

	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * Xe[^XI
 *
 * @param	wk		[N
 *
 * @retval	"0xff != Iꂽ"
 * @retval	"0xff = I"
 */
//--------------------------------------------------------------------------------------------
static u8 BPL_StatusMainSelect( BPLIST_WORK * wk )
{
	int	ret = BPL_TPCheck( wk, Page2_HitRect );

	if( ret == RECT_HIT_NONE ){
		return 0xff;
	}
	return (u8)ret;
}

//--------------------------------------------------------------------------------------------
/**
 * Xe[^XTuI
 *
 * @param	wk		[N
 *
 * @retval	"0xff != Iꂽ"
 * @retval	"0xff = I"
 */
//--------------------------------------------------------------------------------------------
static u8 BPL_StInfoWazaSelect( BPLIST_WORK * wk )
{
	int	ret = BPL_TPCheck( wk, Page34_HitRect );

	if( ret == RECT_HIT_NONE ){
		return 0xff;
	}
	return (u8)ret;
}


//--------------------------------------------------------------------------------------------
/**
 * ^b`pl̃{^
 *
 * @param	wk		[N
 * @param	tbl		TPf[^e[u
 *
 * @retval	"RECT_HIT_NONE = ĂȂ"
 * @retval	"RECT_HIT_NONE != {^ԍ"
 */
//--------------------------------------------------------------------------------------------
static int BPL_TPCheck( BPLIST_WORK * wk, const RECT_HIT_TBL * tbl )
{
	int	ret = GF_TP_RectHitTrg( tbl );
/*
	if( ret != RECT_HIT_NONE ){
		u16	pat = 0xfffe;
		if( GF_BGL_DotCheck( wk->bgl, GF_BGL_FRAME3_S, sys.tp_x, sys.tp_y, &pat ) == FALSE ){
			return RECT_HIT_NONE;
		}
	}
*/
	if( ret != RECT_HIT_NONE ){
		Snd_SePlay( SEQ_SE_DP_DECIDE );
	}

	return ret;
}

//--------------------------------------------------------------------------------------------
/**
 * wʒuɃ|P݂邩
 *
 * @param	wk		[N
 * @param	pos		ʒu
 *
 * @retval	"0 = Ȃ"
 * @retval	"1 = 퓬"
 * @retval	"2 = T"
 */
//--------------------------------------------------------------------------------------------
u8 BattlePokeList_PokeSetCheck( BPLIST_WORK * wk, s32 pos )
{
	if( wk->poke[pos].mons == 0 ){
		return 0;
	}
	if( pos == 0 ){
		return 1;
	}
	return 2;
}

//--------------------------------------------------------------------------------------------
/**
 * ̃|P擾
 *
 * @param	wk		[N
 * @param	pos		݈ʒu
 * @param	mv		ړ
 *
 * @retval	"0xff = ̃|PȂ"
 * @retval	"0xff != ̃|P̈ʒu"
 */
//--------------------------------------------------------------------------------------------
static u8 BPL_NextPokeGet( BPLIST_WORK * wk, s32 pos, s32 mv )
{
	s32	now = pos;

//	if( /*}``FbN*/ ){
		while( 1 ){
			pos += mv;
			if( pos < 0 ){
				pos = 5;
			}else if( pos >= 6 ){
				pos = 0;
			}
			if( now == pos ){ break; }
			if( BattlePokeList_PokeSetCheck( wk, pos ) != 0 ){
				return (u8)pos;
			}
		}
//	}else{
//	}

	return 0xff;
}

//--------------------------------------------------------------------------------------------
/**
 * v[g
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_PokePlateSet( BPLIST_WORK * wk )
{
	s16	i, j;

	for( i=0; i<6; i++ ){
		j = BattlePokeList_PokeSetCheck( wk, i );
		if( j == 1 ){
			GF_BGL_ScrWrite(
				wk->bgl, GF_BGL_FRAME2_S, wk->btn_plate1[0],
				PlatePos[i][0], PlatePos[i][1], PLATE_BG_SX, PLATE_BG_SY );
		}else if( j == 2 ){
			GF_BGL_ScrWrite(
				wk->bgl, GF_BGL_FRAME2_S, wk->btn_plate2[0],
				PlatePos[i][0], PlatePos[i][1], PLATE_BG_SX, PLATE_BG_SY );
		}
	}
	GF_BGL_LoadScreenV_Req( wk->bgl, GF_BGL_FRAME2_S );
}

//--------------------------------------------------------------------------------------------
/**
 * olQ[W
 *
 * @param	wk		[N
 * @param	page	y[Wԍ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_ExpGagePut( BPLIST_WORK * wk, u8 page )
{
	BPL_POKEDATA * pd;
	u32	max;
	u32	now;
	u16	cgx;
	u16	px, py;
	u8	dot;
	u8	i;

	if( page != BPLIST_PAGE_MAIN && page != BPLIST_PAGE_STATUS ){
		return;
	}

	pd = &wk->poke[wk->dat->sel_poke];

	max = pd->next_lv_exp - pd->now_lv_exp;
	now = pd->now_exp - pd->now_lv_exp;
	dot = GetNumDotto( now, max, EXP_DOT_MAX );

	for( i=0; i<EXP_DOT_CHR_MAX; i++ ){
		if( dot >= 8 ){
			cgx = EXP_CGX + 8;
		}else{
			cgx = EXP_CGX + dot;
		}

		if( page == BPLIST_PAGE_MAIN ){
			BPL_P2_ExpGagePut( wk, cgx+32, P2_EXPGAGE_PX+i, P2_EXPGAGE_PY );
		}else{
			BPL_P3_ExpGagePut( wk, cgx, P3_EXPGAGE_PX+i, P3_EXPGAGE_PY );
		}

		if( dot < 8 ){
			dot = 0;
		}else{
			dot -= 8;
		}
	}

	GF_BGL_LoadScreenV_Req( wk->bgl, GF_BGL_FRAME3_S );
}

static void BPL_P2_ExpGagePut( BPLIST_WORK * wk, u16 cgx, u16 px, u16 py )
{
	GF_BGL_ScrFill( wk->bgl, GF_BGL_FRAME3_S, cgx, px, py, 1, 1, GF_BGL_SCRWRT_PALNL );
	GF_BGL_ScrFill( wk->bgl, GF_BGL_FRAME3_S, cgx+32, px, py+1, 1, 1, GF_BGL_SCRWRT_PALNL );
}

static void BPL_P3_ExpGagePut( BPLIST_WORK * wk, u16 cgx, u16 px, u16 py )
{
	GF_BGL_ScrFill( wk->bgl, GF_BGL_FRAME3_S, cgx, px, py, 1, 1, GF_BGL_SCRWRT_PALNL );
}


//--------------------------------------------------------------------------------------------
/**
 * y[W؂ւ
 *
 * @param	wk			[N
 * @param	next_page	̃y[W
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_PageChange( BPLIST_WORK * wk, u8 next_page )
{
	BPL_PageChgBgScroll( wk, next_page );

	GF_BGL_ScrClearCodeVReq( wk->bgl, GF_BGL_FRAME0_S, 0 );
	GF_BGL_ScrClearCodeVReq( wk->bgl, GF_BGL_FRAME1_S, 0 );

	BattlePokeList_PageObjSet( wk, next_page );
	BattlePokeList_BmpFree( wk );
	BattlePokeList_BmpAdd( wk, next_page );
	BattlePokeList_BmpWrite( wk, next_page );
	BPL_ExpGagePut( wk, next_page );

	BattlePokeList_ButtonPageScreenInit( wk, next_page );

	wk->page = next_page;
}

//--------------------------------------------------------------------------------------------
/**
 * BGXN[
 *
 * @param	wk		[N
 * @param	page	̃y[W
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_PageChgBgScroll( BPLIST_WORK * wk, u8 page )
{
	switch( page ){
	case BPLIST_PAGE_SELECT:		// |PIy[W
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME2_S, GF_BGL_SCROLL_X_SET, 0 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME2_S, GF_BGL_SCROLL_Y_SET, 0 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME3_S, GF_BGL_SCROLL_X_SET, 0 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME3_S, GF_BGL_SCROLL_Y_SET, 0 );
		break;
	case BPLIST_PAGE_MAIN:			// Xe[^XCy[W
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME2_S, GF_BGL_SCROLL_X_SET, 256 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME2_S, GF_BGL_SCROLL_Y_SET, 0 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME3_S, GF_BGL_SCROLL_X_SET, 256 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME3_S, GF_BGL_SCROLL_Y_SET, 0 );
		break;
	case BPLIST_PAGE_STATUS:		// Xe[^Xڍ׃y[W
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME2_S, GF_BGL_SCROLL_X_SET, 0 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME2_S, GF_BGL_SCROLL_Y_SET, 256 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME3_S, GF_BGL_SCROLL_X_SET, 0 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME3_S, GF_BGL_SCROLL_Y_SET, 256 );
		break;
	case BPLIST_PAGE_SKILL:			// Xe[^XZy[W
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME2_S, GF_BGL_SCROLL_X_SET, 256 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME2_S, GF_BGL_SCROLL_Y_SET, 256 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME3_S, GF_BGL_SCROLL_X_SET, 256 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME3_S, GF_BGL_SCROLL_Y_SET, 256 );
		break;
	case BPLIST_PAGE_SKILL_SET1:	// Xe[^XZYPy[W
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME2_S, GF_BGL_SCROLL_X_SET, 256 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME2_S, GF_BGL_SCROLL_Y_SET, 0 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME3_S, GF_BGL_SCROLL_X_SET, 256 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME3_S, GF_BGL_SCROLL_Y_SET, 0 );
		break;
	case BPLIST_PAGE_SKILL_SET2:	// Xe[^XZYQy[W
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME2_S, GF_BGL_SCROLL_X_SET, 0 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME2_S, GF_BGL_SCROLL_Y_SET, 256 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME3_S, GF_BGL_SCROLL_X_SET, 0 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME3_S, GF_BGL_SCROLL_Y_SET, 256 );
		break;
	case BPLIST_PAGE_PP_RCV:		// PP񕜋ZIy[W
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME2_S, GF_BGL_SCROLL_X_SET, 256 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME2_S, GF_BGL_SCROLL_Y_SET, 256 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME3_S, GF_BGL_SCROLL_X_SET, 256 );
		GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME3_S, GF_BGL_SCROLL_Y_SET, 256 );
		break;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * ւ`FbN
 *
 * @param	wk		[N
 *
 * @retval	"TRUE = ւ"
 * @retval	"FALSE = ւs"
 */
//--------------------------------------------------------------------------------------------
static u8 BPL_IrekaeCheck( BPLIST_WORK * wk )
{
	BPL_POKEDATA * dat;
	STRBUF * str;

	dat = &wk->poke[wk->dat->sel_poke];
/*
	// l
	if( }``FbN ){
		mes_b_plist_m05
		"[1:03:g[i[:0]́@|PƁ@ꂩ邱Ƃ́@ł܂I"
		return FALSE;
	}
*/
	// oĂ
	if( wk->dat->sel_poke == 0 /*|| _u`FbN*/ ){
		str = MSGMAN_AllocString( wk->mman, mes_b_plist_m01 );
		WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(dat->pp) );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		return FALSE;
	}

	// ^}S
	if( dat->egg != 0 ){
		MSGMAN_GetString( wk->mman, mes_b_plist_m04, wk->msg_buf );
		return FALSE;
	}

	// m
	if( dat->hp == 0 ){
		str = MSGMAN_AllocString( wk->mman, mes_b_plist_m02 );
		WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(dat->pp) );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		return FALSE;
	}

	// Z
	if( wk->dat->chg_waza != 0 ){
		dat = &wk->poke[wk->init_poke];
		str = MSGMAN_AllocString( wk->mman, mes_b_plist_m03 );
		WORDSET_RegisterPokeNickName( wk->wset, 0, PPPPointerGet(dat->pp) );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		return FALSE;
	}

	return TRUE;
}
