//============================================================================================
/**
 * @file	b_plist_main.h
 * @bfief	퓬p|PXg
 * @author	Hiroyuki Nakamura
 * @date	05.02.01
 */
//============================================================================================
#ifndef B_PLIST_MAIN_H
#define B_PLIST_MAIN_H
#undef GLOBAL
#ifdef B_PLIST_MAIN_H_GLOBAL
#define GLOBAL	/*	*/
#else
#define GLOBAL	extern
#endif


//============================================================================================
//	萔`
//============================================================================================
// pbg`
#define	BPL_PAL_NN_PLATE	( 0 )		///< pbg00Fv[giʏEIj
#define	BPL_PAL_MN_PLATE	( 1 )		///< pbg01Fv[gi}`EIj
#define	BPL_PAL_DN_PLATE	( 2 )		///< pbg02Fv[gimEIj
#define	BPL_PAL_NS_PLATE	( 3 )		///< pbg03Fv[giʏEIj
#define	BPL_PAL_MS_PLATE	( 4 )		///< pbg04Fv[gi}`EIj
#define	BPL_PAL_DS_PLATE	( 5 )		///< pbg05Fv[gimEIj
#define	BPL_PAL_HPGAGE		( 9 )		///< pbg09FHPQ[W
//#define	BPL_PAL_BG1			( 10 )		///< pbg10FwiP
//#define	BPL_PAL_BG2			( 11 )		///< pbg11FwiQ
//#define	BPL_PAL_SYS_WIN	( 12 )		///< pbg12FVXeEBhE
#define	BPL_PAL_SYS_FONT	( 10 )		///< pbg13FVXetHg
#define	BPL_PAL_TALK_WIN	( 14 )		///< pbg14FbEBhE
#define	BPL_PAL_TALK_FONT	( 15 )		///< pbg15FbtHg

// EBhECfbNX
enum {
	WIN_COMMENT = 0,	///< RgpEBhE
	WIN_TALK,			///< bpEBhE
	WIN_MAX
};

// y[WP̒ǉEBhECfbNX
enum {
	WIN_P1_POKE1 = 0,	// |PP
	WIN_P1_POKE2,		// |PQ
	WIN_P1_POKE3,		// |PR
	WIN_P1_POKE4,		// |PS
	WIN_P1_POKE5,		// |PT
	WIN_P1_POKE6,		// |PU
	WIN_P1_MAX
};

// y[WQ̒ǉEBhECfbNX
enum {
	WIN_P2_NAME = 0,	// O
	WIN_P2_LV,			// x
	WIN_P2_HP,			// HP
	WIN_P2_HPGAGE,		// HPQ[W
	WIN_P2_SPA,			// 
	WIN_P2_ITEM,		// 
	WIN_P2_SKILL1,		// ZP
	WIN_P2_PP1,			// PP1
	WIN_P2_PPNUM1,		// PP/PP 1
	WIN_P2_SKILL2,		// ZQ
	WIN_P2_PP2,			// PP2
	WIN_P2_PPNUM2,		// PP/PP 2
	WIN_P2_SKILL3,		// ZR
	WIN_P2_PP3,			// PP3
	WIN_P2_PPNUM3,		// PP/PP 3
	WIN_P2_SKILL4,		// ZS
	WIN_P2_PP4,			// PP4
	WIN_P2_PPNUM4,		// PP/PP 4
	WIN_P2_CHG,			// uv

	// Xbvp
	WIN_P2_NAME_S,		// O
	WIN_P2_LV_S,		// x
	WIN_P2_HP_S,		// HP
	WIN_P2_HPGAGE_S,	// HPQ[W
	WIN_P2_SPA_S,		// 
	WIN_P2_ITEM_S,		// 
	WIN_P2_SKILL1_S,	// ZP
	WIN_P2_PP1_S,		// PP1
	WIN_P2_PPNUM1_S,	// PP/PP 1
	WIN_P2_SKILL2_S,	// ZQ
	WIN_P2_PP2_S,		// PP2
	WIN_P2_PPNUM2_S,	// PP/PP 2
	WIN_P2_SKILL3_S,	// ZR
	WIN_P2_PP3_S,		// PP3
	WIN_P2_PPNUM3_S,	// PP/PP 3
	WIN_P2_SKILL4_S,	// ZS
	WIN_P2_PP4_S,		// PP4
	WIN_P2_PPNUM4_S,	// PP/PP 4

	WIN_P2_MAX
};

// y[WR̒ǉEBhECfbNX
enum {
	WIN_P3_NAME = 0,	// O
	WIN_P3_SPANAME,		// 
	WIN_P3_SPAINFO,		// 
	WIN_P3_ITEMNAME,	// 
	WIN_P3_ITEMINFO,	// 
	WIN_P3_HP,			// uHPv
	WIN_P3_POW,			// uv
	WIN_P3_DEF,			// uڂv
	WIN_P3_AGI,			// u΂₳v
	WIN_P3_SPP,			// uƂv
	WIN_P3_SPD,			// uƂڂv
	WIN_P3_HPNUM,		// HPl
	WIN_P3_POWNUM,		// Ul
	WIN_P3_DEFNUM,		// hl
	WIN_P3_AGINUM,		// fl
	WIN_P3_SPPNUM,		// Ul
	WIN_P3_SPDNUM,		// hl
	WIN_P3_HPGAGE,		// HPQ[W
	WIN_P3_LV,			// uLv.v
	WIN_P3_LVNUM,		// xl
	WIN_P3_NEXT,		// u̃x܂Łv
	WIN_P3_NEXTNUM,		// ̃xl
	WIN_P3_MAX
};

// y[WS̒ǉEBhECfbNX
enum {
	WIN_P4_NAME = 0,	// O
	WIN_P4_SKILL,		// Z
	WIN_P4_PP,			// PP
	WIN_P4_PPNUM,		// PP/PP
	WIN_P4_HIT,			// u߂イv
	WIN_P4_POW,			// u傭v
	WIN_P4_HITNUM,		// l
	WIN_P4_POWNUM,		// З͒l
	WIN_P4_INFO,		// Z
	WIN_P4_BUNRUI,		// uԂ邢v
	WIN_P4_BRNAME,		// ޖ
	WIN_P4_MAX
};

// y[WT̒ǉEBhECfbNX
enum {
	WIN_P5_NAME = 0,	// O
	WIN_P5_SKILL1,		// ZP
	WIN_P5_SKILL2,		// ZQ
	WIN_P5_SKILL3,		// ZR
	WIN_P5_SKILL4,		// ZS
	WIN_P5_SKILL5,		// ZT
	WIN_P5_MAX
};

// y[WU̒ǉEBhECfbNX
enum {
	WIN_P6_NAME = 0,	// O
	WIN_P6_SKILL,		// Z
	WIN_P6_PP,			// PP
	WIN_P6_PPNUM,		// PP/PP
	WIN_P6_HIT,			// u߂イv
	WIN_P6_POW,			// u傭v
	WIN_P6_HITNUM,		// l
	WIN_P6_POWNUM,		// З͒l
	WIN_P6_INFO,		// Z
	WIN_P6_BUNRUI,		// uԂ邢v
	WIN_P6_BRNAME,		// ޖ
	WIN_P6_WASURERU,	// u킷v
	WIN_P6_MAX
};

// y[WV̒ǉEBhECfbNX
enum {
	WIN_P7_NAME = 0,	// O
	WIN_P7_SKILL1,		// ZP
	WIN_P7_SKILL2,		// ZQ
	WIN_P7_SKILL3,		// ZR
	WIN_P7_SKILL4,		// ZS
	WIN_P7_MAX
};

enum {
	BPL_CA_ITEM1 = 0,
	BPL_CA_ITEM2,
	BPL_CA_ITEM3,
	BPL_CA_ITEM4,
	BPL_CA_ITEM5,
	BPL_CA_ITEM6,

	BPL_CA_POKE1,
	BPL_CA_POKE2,
	BPL_CA_POKE3,
	BPL_CA_POKE4,
	BPL_CA_POKE5,
	BPL_CA_POKE6,

	BPL_CA_STATUS1,
	BPL_CA_STATUS2,
	BPL_CA_STATUS3,
	BPL_CA_STATUS4,
	BPL_CA_STATUS5,
	BPL_CA_STATUS6,

	BPL_CA_POKETYPE1,
	BPL_CA_POKETYPE2,

	BPL_CA_WAZATYPE1,
	BPL_CA_WAZATYPE2,
	BPL_CA_WAZATYPE3,
	BPL_CA_WAZATYPE4,
	BPL_CA_WAZATYPE5,

	BPL_CA_BUNRUI,

	BPL_CA_MAX
};

typedef struct {
	u16	id;		// Zԍ
	u8	pp;		// PP
	u8	mpp;	// őPP

	u8	type;	// ^Cv
	u8	kind;	// 
	u8	hit;	// 
	u8	pow;	// З
}BPL_POKEWAZA;

typedef struct {
	POKEMON_PARAM * pp;		// |Pf[^

	u16	mons;		// |Pԍ
	u16	pow;		// U

	u16	def;		// h
	u16	agi;		// f

	u16	spp;		// U
	u16	spd;		// h

	u16	hp;			// HP
	u16	mhp;		// őHP

	u8	type1;		// ^CvP
	u8	type2;		// ^CvQ
	u8	lv;			// x
	u8	sex:3;		// 
	u8	st:4;		// Ԉُ
	u8	egg:1;		// ^}S

	u16	spa;		// 
	u16	item;		// ACe

	u32	now_exp;		// ݂̌ol
	u32	now_lv_exp;		// ݂̃x̌ol
	u32	next_lv_exp;	// ̃x̌ol

	BPL_POKEWAZA	waza[4];	// Zf[^

}BPL_POKEDATA;

typedef struct {
	BPLIST_DATA * dat;	// OQƃf[^

	BPL_POKEDATA	poke[6];	// |Pf[^

	GF_BGL_INI * bgl;		// BGf[^

	PALETTE_FADE_PTR pfd;	// pbgtF[hf[^

	u16	btn_plate1[3][16*6];
	u16	btn_plate2[3][16*6];
	u16	btn_st[3][3*4];
	u16	btn_waza1[3][3*4];
	u16	btn_waza2[3][16*6];
	u16	btn_chg[3][10*5];
	u16	btn_up[3][5*5];
	u16	btn_down[3][5*5];
	u16	btn_ret[3][5*5];
	u16	btn_contest[3][9*4];

	u8	btn_seq;
	u8	btn_cnt;
	u8	btn_id;
	u8	btn_mode:4;
	u8	btn_pat:3;
	u8	btn_flg:1;

	NUMFONT * nfnt;					// 8x8tHg
	MSGDATA_MANAGER * mman;			// bZ[Wf[^}l[W
	WORDSET * wset;					// PZbg
	STRBUF * msg_buf;				// bZ[Wpobt@

	CATS_RES_PTR	crp;				// \[XǗ
	CATS_ACT_PTR	cap[BPL_CA_MAX];	// OAMCAP

	GF_BGL_BMPWIN	win[WIN_MAX];	// BMPEBhEf[^iʏj
	GF_BGL_BMPWIN * add_win;		// BMPEBhEf[^iǉj
	u8	bmp_add_max;				// ǉBMP̐
	u8	p2_swap;					// y[WQ̃Xbv`tO

	u8	init_poke;		// ւΏۂ̃|Pʒu

	u8	bc_put;			// Z̕\퓬ReXg

	u8	seq;			// CV[PX
	u8	ret_seq;		// AV[PX
	u8	page;			// ݂̃y[W
	u8	midx;			// bZ[WCfbNX

	u8	rcv_seq;
	u8	rcv_st;
	u16	rcv_hp;

}BPLIST_WORK;




//--------------------------------------------------------------------------------------------
/**
 * wʒuɃ|P݂邩
 *
 * @param	wk		[N
 * @param	pos		ʒu
 *
 * @retval	"0 = Ȃ"
 * @retval	"1 = 퓬"
 * @retval	"2 = T"
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 BattlePokeList_PokeSetCheck( BPLIST_WORK * wk, s32 pos );



#undef GLOBAL
#endif	// B_PLIST_MAIN_H
