//============================================================================================
/**
 * @file	b_plist_obj.c
 * @bfief	퓬p|PXgOBJ
 * @author	Hiroyuki Nakamura
 * @date	05.02.07
 */
//============================================================================================
#include "common.h"
#include "system/procsys.h"
#include "system/palanm.h"
#include "system/msgdata.h"
#include "system/numfont.h"
#include "system/wordset.h"
#include "system/clact_tool.h"
#include "battle/battle_common.h"
#include "battle/fight_tool.h"
#include "battle/wazatype_icon.h"
#include "poketool/pokeparty.h"
#include "poketool/pokeicon.h"
#include "poketool/waza_tool.h"
#include "application/p_status.h"
#include "application/pokelist.h"
#include "itemtool/item.h"

#define	B_PLIST_OBJ_H_GLOBAL
#include "b_plist.h"
#include "b_plist_main.h"
#include "b_plist_obj.h"


//============================================================================================
//	萔`
//============================================================================================
#define	CLACT_ID_COMMON		( 45063 )	// ̉ʂŎgpZAN^[ID

// L\[XID
enum {
	CHR_ID_POKE1 = CLACT_ID_COMMON,		// |PACRFPC
	CHR_ID_POKE2,						// |PACRFQC
	CHR_ID_POKE3,						// |PACRFRC
	CHR_ID_POKE4,						// |PACRFSC
	CHR_ID_POKE5,						// |PACRFTC
	CHR_ID_POKE6,						// |PACRFUC

	CHR_ID_STATUS,						// ԈُACRFPC

	CHR_ID_POKETYPE1,					// |P^CvACRP
	CHR_ID_POKETYPE2,					// |P^CvACRQ

	CHR_ID_WAZATYPE1,					// Z^CvACRP
	CHR_ID_WAZATYPE2,					// Z^CvACRQ
	CHR_ID_WAZATYPE3,					// Z^CvACRR
	CHR_ID_WAZATYPE4,					// Z^CvACRS
	CHR_ID_WAZATYPE5,					// Z^CvACRT

	CHR_ID_BUNRUI,						// ރACR

	CHR_ID_ITEM,						// ACeACR

	CHR_ID_MAX = CHR_ID_ITEM - CLACT_ID_COMMON + 1
};

// pbg\[XID
enum {
	PAL_ID_POKE = CLACT_ID_COMMON,		// |PACRiR{j
	PAL_ID_STATUS,						// ԈُACRiP{j
	PAL_ID_TYPE,						// ^Cv/ރACRiR{j
	PAL_ID_ITEM,						// ACeACRiP{j
	PAL_ID_MAX = PAL_ID_ITEM - CLACT_ID_COMMON + 1
};

// Z\[XID
enum {
	CEL_ID_POKE = CLACT_ID_COMMON,		// |PACR
	CEL_ID_STATUS,						// ԈُACR
	CEL_ID_TYPE,						// ^Cv/ރACR
	CEL_ID_ITEM,						// ACeACR
	CEL_ID_MAX = CEL_ID_ITEM - CLACT_ID_COMMON + 1
};

// ZAj\[XID
enum {
	ANM_ID_POKE = CLACT_ID_COMMON,		// |PACR
	ANM_ID_STATUS,						// ԈُACR
	ANM_ID_TYPE,						// ^Cv/ރACR
	ANM_ID_ITEM,						// ACeACR
	ANM_ID_MAX = ANM_ID_ITEM - CLACT_ID_COMMON + 1
};


//============================================================================================
//	vg^Cv錾
//============================================================================================
static void BPL_ClactResManInit( BPLIST_WORK * wk );
static void BPL_ClactPokeLoad( BPLIST_WORK * wk );
static void BPL_ClactStatusLoad( BPLIST_WORK * wk );
static void BPL_ClactTypeLoad( BPLIST_WORK * wk );
static void BPL_ClactItemLoad( BPLIST_WORK * wk );
static void BPL_ClactAddAll( BPLIST_WORK * wk );

static void BPL_PokeIconPaletteChg( BPLIST_WORK * wk );

static void BPL_Page1ObjSet( BPLIST_WORK * wk );
static void BPL_Page2ObjSet( BPLIST_WORK * wk );
static void BPL_Page3ObjSet( BPLIST_WORK * wk );
static void BPL_Page4ObjSet( BPLIST_WORK * wk );
static void BPL_Page5ObjSet( BPLIST_WORK * wk );
static void BPL_Page6ObjSet( BPLIST_WORK * wk );
static void BPL_Page7ObjSet( BPLIST_WORK * wk );

static void BPL_BattleWazaTypeSet( BPLIST_WORK * wk );
static void BPL_ContestWazaTypeSet( BPLIST_WORK * wk );


//============================================================================================
//	O[oϐ
//============================================================================================
// \[Xe[u
static const int ObjParamEz[][4] =
{	// LApbgAZAZAj
	{ CHR_ID_ITEM, PAL_ID_ITEM, CEL_ID_ITEM, ANM_ID_ITEM },			// ACeACRP
	{ CHR_ID_ITEM, PAL_ID_ITEM, CEL_ID_ITEM, ANM_ID_ITEM },			// ACeACRQ
	{ CHR_ID_ITEM, PAL_ID_ITEM, CEL_ID_ITEM, ANM_ID_ITEM },			// ACeACRR
	{ CHR_ID_ITEM, PAL_ID_ITEM, CEL_ID_ITEM, ANM_ID_ITEM },			// ACeACRS
	{ CHR_ID_ITEM, PAL_ID_ITEM, CEL_ID_ITEM, ANM_ID_ITEM },			// ACeACRT
	{ CHR_ID_ITEM, PAL_ID_ITEM, CEL_ID_ITEM, ANM_ID_ITEM },			// ACeACRU
	{ CHR_ID_POKE1, PAL_ID_POKE, CEL_ID_POKE, ANM_ID_POKE },		// |PACRP
	{ CHR_ID_POKE2, PAL_ID_POKE, CEL_ID_POKE, ANM_ID_POKE },		// |PACRQ
	{ CHR_ID_POKE3, PAL_ID_POKE, CEL_ID_POKE, ANM_ID_POKE },		// |PACRR
	{ CHR_ID_POKE4, PAL_ID_POKE, CEL_ID_POKE, ANM_ID_POKE },		// |PACRS
	{ CHR_ID_POKE5, PAL_ID_POKE, CEL_ID_POKE, ANM_ID_POKE },		// |PACRT
	{ CHR_ID_POKE6, PAL_ID_POKE, CEL_ID_POKE, ANM_ID_POKE },		// |PACRU
	{ CHR_ID_STATUS, PAL_ID_STATUS, CEL_ID_STATUS, ANM_ID_STATUS },	// ԈُACRP
	{ CHR_ID_STATUS, PAL_ID_STATUS, CEL_ID_STATUS, ANM_ID_STATUS },	// ԈُACRQ
	{ CHR_ID_STATUS, PAL_ID_STATUS, CEL_ID_STATUS, ANM_ID_STATUS },	// ԈُACRR
	{ CHR_ID_STATUS, PAL_ID_STATUS, CEL_ID_STATUS, ANM_ID_STATUS },	// ԈُACRS
	{ CHR_ID_STATUS, PAL_ID_STATUS, CEL_ID_STATUS, ANM_ID_STATUS },	// ԈُACRT
	{ CHR_ID_STATUS, PAL_ID_STATUS, CEL_ID_STATUS, ANM_ID_STATUS },	// ԈُACRU
	{ CHR_ID_POKETYPE1, PAL_ID_TYPE, CEL_ID_TYPE, ANM_ID_TYPE },	// |P^CvACRP
	{ CHR_ID_POKETYPE2, PAL_ID_TYPE, CEL_ID_TYPE, ANM_ID_TYPE },	// |P^CvACRQ
	{ CHR_ID_WAZATYPE1, PAL_ID_TYPE, CEL_ID_TYPE, ANM_ID_TYPE },	// Z^CvACRP
	{ CHR_ID_WAZATYPE2, PAL_ID_TYPE, CEL_ID_TYPE, ANM_ID_TYPE },	// Z^CvACRQ
	{ CHR_ID_WAZATYPE3, PAL_ID_TYPE, CEL_ID_TYPE, ANM_ID_TYPE },	// Z^CvACRR
	{ CHR_ID_WAZATYPE4, PAL_ID_TYPE, CEL_ID_TYPE, ANM_ID_TYPE },	// Z^CvACRS
	{ CHR_ID_WAZATYPE5, PAL_ID_TYPE, CEL_ID_TYPE, ANM_ID_TYPE },	// Z^CvACRS
	{ CHR_ID_BUNRUI, PAL_ID_TYPE, CEL_ID_TYPE, ANM_ID_TYPE },		// ރACR
};

// y[WP̃|PACR̍W
static const int P1_PokePos[][2] =
{
	{ 16,  16 }, { 144,  24 },
	{ 16,  64 }, { 144,  72 },
	{ 16, 112 }, { 144, 120 },
};
// y[WP̏ԈُACR̍W
static const int P1_StatusPos[][2] =
{
	{ 16+4,  16+24 }, { 144+4,  24+24 },
	{ 16+4,  64+24 }, { 144+4,  72+24 },
	{ 16+4, 112+24 }, { 144+4, 120+24 },
};

static const int P2_PokePos[2] = { 24, 12 };		// y[WQ̃|PACR̍W
static const int P2_StatusPos[2] = { 192+6, 17 };	// y[WQ̏ԈُACR̍W
// y[WQ̃|P̃^CvACR̍W
static const int P2_PokeTypePos[][2] =
{
	{ 128+2, 16 },
	{ 160+4, 16 }
};
// y[WQ̋Z̃^CvACR̍W
static const int P2_WazaTypePos[][2] =
{
	{  40, 104 },
	{ 152, 104 },
	{  40, 136 },
	{ 152, 136 }
};

static const int P3_PokePos[2] = { 24, 12 };		// y[WR̃|PACR̍W
static const int P3_StatusPos[2] = { 192+6, 17 };	// y[WȐԈُACR̍W
// y[WR̃|P̃^CvACR̍W
static const int P3_PokeTypePos[][2] =
{
	{ 128+2, 16 },
	{ 160+4, 16 }
};

static const int P4_PokePos[2] = { 24, 12 };		// y[WS̃|PACR̍W
static const int P4_StatusPos[2] = { 192+6, 17 };	// y[WS̏ԈُACR̍W
// y[WS̃|P̃^CvACR̍W
static const int P4_PokeTypePos[][2] =
{
	{ 128+2, 16 },
	{ 160+4, 16 }
};
static const int P4_WazaTypePos[2] = { 136, 48 };	// y[WS̋Z^CvACR̍W
static const int P4_WazaKindPos[2] = { 24, 88 };	// y[WS̋ZރACR̍W

static const int P5_PokePos[2] = { 24, 12 };		// y[WT̃|PACR̍W
// y[WT̃|P̃^CvACR̍W
static const int P5_PokeTypePos[][2] =
{
	{ 128+2, 16 },
	{ 160+4, 16 }
};
// y[WT̋Z̃^CvACR̍W
static const int P5_WazaTypePos[][2] =
{
	{  24,  80 },
	{ 152,  80 },
	{  24, 128 },
	{ 152, 128 },
	{  88, 176 }
};

static const int P6_PokePos[2] = { 24, 12 };		// y[WŨ|PACR̍W
// y[WŨ|P̃^CvACR̍W
static const int P6_PokeTypePos[][2] =
{
	{ 128+2, 16 },
	{ 160+4, 16 }
};
static const int P6_WazaTypePos[2] = { 136, 48 };	// y[WŰZ^CvACR̍W
static const int P6_WazaKindPos[2] = { 24, 88 };	// y[WŰZރACR̍W


//--------------------------------------------------------------------------------------------
/**
 * 퓬p|PXgOBJ
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BattlePokeList_ObjInit( BPLIST_WORK * wk )
{
	BPL_ClactResManInit( wk );
	BPL_ClactPokeLoad( wk );
	BPL_ClactStatusLoad( wk );
	BPL_ClactTypeLoad( wk );
	BPL_ClactItemLoad( wk );
	BPL_ClactAddAll( wk );

	GF_Disp_GXS_VisibleControl( GX_PLANEMASK_OBJ, VISIBLE_ON );
}

//--------------------------------------------------------------------------------------------
/**
 * \[X}l[W[
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_ClactResManInit( BPLIST_WORK * wk )
{
	TCATS_RESOURCE_NUM_LIST	crnl = { CHR_ID_MAX, PAL_ID_MAX, CEL_ID_MAX, ANM_ID_MAX, 0, 0 };
	CATS_SYS_PTR	csp = BattleWorkCATS_SYS_PTRGet( wk->dat->bw );

	wk->crp = CATS_ResourceCreate( csp );
	CATS_ClactSetInit( csp, wk->crp, BPL_CA_MAX );
	CATS_ResourceManagerInit( csp, wk->crp, &crnl );
}

//--------------------------------------------------------------------------------------------
/**
 * |PACR̃OtBbN[h
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_ClactPokeLoad( BPLIST_WORK * wk )
{
	CATS_SYS_PTR	csp;
	u32	i;
	
	csp = BattleWorkCATS_SYS_PTRGet( wk->dat->bw );

	// pbg
	CATS_LoadResourcePlttWorkArc(
		wk->pfd, FADE_SUB_OBJ, csp, wk->crp,
		ARC_POKEICON, PokeIconPalArcIndexGet(), 0, 3, NNS_G2D_VRAM_TYPE_2DSUB, PAL_ID_POKE );
	// Z
	CATS_LoadResourceCellArc(
		csp, wk->crp, ARC_POKEICON, PokeIconCellArcIndexGet(), 0, CEL_ID_POKE );
	// ZAj
	CATS_LoadResourceCellAnmArc(
		csp, wk->crp, ARC_POKEICON, PokeIconCellAnmArcIndexGet(), 0, ANM_ID_POKE );
	// L
	for( i=0; i<6; i++ ){
		if( wk->poke[i].mons != 0 ){
			CATS_LoadResourceCharArc(
				csp, wk->crp, ARC_POKEICON,
				PokeIconCgxArcIndexGetByPP(wk->poke[i].pp),
				0, NNS_G2D_VRAM_TYPE_2DSUB, CHR_ID_POKE1+i );
		}else{
			CATS_LoadResourceCharArc(
				csp, wk->crp, ARC_POKEICON,
				PokeIconCgxArcIndexGetByMonsNo(0,0),
				0, NNS_G2D_VRAM_TYPE_2DSUB, CHR_ID_POKE1+i );
		}
	}
}

//--------------------------------------------------------------------------------------------
/**
 * ԈُACR̃OtBbN[h
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_ClactStatusLoad( BPLIST_WORK * wk )
{
	CATS_SYS_PTR	csp = BattleWorkCATS_SYS_PTRGet( wk->dat->bw );

	// pbg
	CATS_LoadResourcePlttWorkArc(
		wk->pfd, FADE_SUB_OBJ, csp, wk->crp, ARC_PSTATUS_GRA,
		BadStatusIconPlttArcGet(), 0, 1, NNS_G2D_VRAM_TYPE_2DSUB, PAL_ID_STATUS );
	// Z
	CATS_LoadResourceCellArc(
		csp, wk->crp, ARC_PSTATUS_GRA, BadStatusIconCellArcGet(), 0, CEL_ID_STATUS );
	// ZAj
	CATS_LoadResourceCellAnmArc(
		csp, wk->crp, ARC_PSTATUS_GRA, BadStatusIconCanmArcGet(), 0, ANM_ID_STATUS );
	// L
	CATS_LoadResourceCharArc(
		csp, wk->crp, ARC_PSTATUS_GRA,
		BadStatusIconCharArcGet(), 0, NNS_G2D_VRAM_TYPE_2DSUB, CHR_ID_STATUS );
}

//--------------------------------------------------------------------------------------------
/**
 * ^Cv/ރACR̃OtBbN[h
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_ClactTypeLoad( BPLIST_WORK * wk )
{
	CATS_SYS_PTR	csp;
	u32	i;
	
	csp = BattleWorkCATS_SYS_PTRGet( wk->dat->bw );

	// pbg
	WazaTypeIcon_PlttWorkResourceLoad(
		wk->pfd, FADE_SUB_OBJ, csp, wk->crp, NNS_G2D_VRAM_TYPE_2DSUB, PAL_ID_TYPE );
	// ZEAj
	WazaTypeIcon_CellAnmResourceLoad( csp, wk->crp, CEL_ID_TYPE, ANM_ID_TYPE );
	// L
	for( i=CHR_ID_POKETYPE1; i<=CHR_ID_WAZATYPE5; i++ ){
		WazaTypeIcon_CharResourceLoad( csp, wk->crp, NNS_G2D_VRAM_TYPE_2DSUB, 0, i );
	}
	// ރL
	WazaKindIcon_CharResourceLoad( csp, wk->crp, NNS_G2D_VRAM_TYPE_2DSUB, 0, CHR_ID_BUNRUI );
}

//--------------------------------------------------------------------------------------------
/**
 * ACeACR̃OtBbN[h
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_ClactItemLoad( BPLIST_WORK * wk )
{
	CATS_SYS_PTR	csp;
	u32	i;
	
	csp = BattleWorkCATS_SYS_PTRGet( wk->dat->bw );

	// pbg
	CATS_LoadResourcePlttWorkArc(
		wk->pfd, FADE_SUB_OBJ, csp, wk->crp, ARC_PLIST_GRA,
		Pokelist_ItemIconPalArcGet(), 0, 1, NNS_G2D_VRAM_TYPE_2DSUB, PAL_ID_ITEM );
	// Z
	CATS_LoadResourceCellArc(
		csp, wk->crp, ARC_PLIST_GRA, Pokelist_ItemIconCellArcGet(), 0, CEL_ID_ITEM );
	// ZAj
	CATS_LoadResourceCellAnmArc(
		csp, wk->crp, ARC_PLIST_GRA, Pokelist_ItemIconCAnmArcGet(), 0, ANM_ID_ITEM );
	// L
	CATS_LoadResourceCharArc(
		csp, wk->crp, ARC_PLIST_GRA,
		Pokelist_ItemIconCgxArcGet(), 0, NNS_G2D_VRAM_TYPE_2DSUB, CHR_ID_ITEM );
}


//--------------------------------------------------------------------------------------------
/**
 * ZAN^[ǉiʁj
 *
 * @param	wk		[N
 * @param	id		ǉZAN^[ID
 *
 * @return	ZAN^[f[^
 */
//--------------------------------------------------------------------------------------------
static CATS_ACT_PTR BPL_ClactAdd( BPLIST_WORK * wk, u32 id )
{
	TCATS_OBJECT_ADD_PARAM_S	prm;
	CATS_SYS_PTR	csp;

	csp = BattleWorkCATS_SYS_PTRGet( wk->dat->bw );

	prm.x = 0;
	prm.y = 0;
	prm.z = 0;

	prm.anm = 0;
	prm.pri = 0;
	prm.pal = 0;
	prm.d_area = NNS_G2D_VRAM_TYPE_2DSUB;

	prm.id[0] = ObjParamEz[id][0];
	prm.id[1] = ObjParamEz[id][1];
	prm.id[2] = ObjParamEz[id][2];
	prm.id[3] = ObjParamEz[id][3];
	
	prm.bg_pri = 1;
	prm.vram_trans = 0;

	return CATS_ObjectAdd_S( csp, wk->crp, &prm );
}

//--------------------------------------------------------------------------------------------
/**
 * ZAN^[ǉiSāj
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_ClactAddAll( BPLIST_WORK * wk )
{
	u32	i;

	for( i=0; i<BPL_CA_MAX; i++ ){
		wk->cap[i] = BPL_ClactAdd( wk, i );
	}
	BPL_PokeIconPaletteChg( wk );
}

//--------------------------------------------------------------------------------------------
/**
 * 퓬p|PXgOBJ폜
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BattlePokeList_ObjFree( BPLIST_WORK * wk )
{
	CATS_SYS_PTR	csp;
	u32	i;
	
	csp = BattleWorkCATS_SYS_PTRGet( wk->dat->bw );

	for( i=0; i<BPL_CA_MAX; i++ ){
		CATS_ActorPointerDelete_S( wk->cap[i] );
	}

	CATS_ResourceDestructor_S( csp, wk->crp );
}

//--------------------------------------------------------------------------------------------
/**
 * ZAN^[\čWύX
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_ClactOn( CATS_ACT_PTR cap, const int x, const int y )
{
	CATS_ObjectEnableCap( cap, 1 );
	CATS_ObjectPosSetCap( cap, x, y );
}

//--------------------------------------------------------------------------------------------
/**
 * |PACR̃pbg؂ւ
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_PokeIconPaletteChg( BPLIST_WORK * wk )
{
	s32	i;

	for( i=0; i<6; i++ ){
		if( wk->poke[i].mons == 0 ){ continue; }
		CATS_ObjectPaletteSetCap(
			wk->cap[BPL_CA_POKE1+i], PokeIconPaletteIDGet(wk->poke[i].mons) );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * ^CvACR؂ւ
 *
 * @param	wk		[N
 * @param	cap		ZAN^[f[^
 * @param	res_id	\[XID
 * @param	type	^Cv
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_TypeIconChange( BPLIST_WORK * wk, CATS_ACT_PTR cap, u32 res_id, u8 type )
{
	CATS_SYS_PTR	csp = BattleWorkCATS_SYS_PTRGet( wk->dat->bw );

	CATS_ChangeResourceCharArc(
		csp, wk->crp, WazaTypeIcon_ArcIDGet(),
		WazaTypeIcon_CgrIDGet(type), WAZATYPEICON_COMP_CHAR, res_id );

	CATS_ObjectPaletteSetCap( cap, WazaTypeIcon_PlttOffsetGet(type)+4 );
}

//--------------------------------------------------------------------------------------------
/**
 * ރACR؂ւ
 *
 * @param	wk		[N
 * @param	cap		ZAN^[f[^
 * @param	kind	
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_KindIconChange( BPLIST_WORK * wk, CATS_ACT_PTR cap, u32 kind )
{
	CATS_SYS_PTR	csp = BattleWorkCATS_SYS_PTRGet( wk->dat->bw );

	CATS_ChangeResourceCharArc(
		csp, wk->crp, WazaKindIcon_ArcIDGet(),
		WazaKindIcon_CgrIDGet(kind), WAZAKINDICON_COMP_CHAR, CHR_ID_BUNRUI );

	CATS_ObjectPaletteSetCap( cap, WazaKindIcon_PlttOffsetGet(kind)+4 );
}

//--------------------------------------------------------------------------------------------
/**
 * ԈُACR؂ւ
 *
 * @param	st		Xe[^X
 * @param	cap		ZAN^[f[^
 * @param	x		XW
 * @param	y		YW
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_StIconPut( u16 st, CATS_ACT_PTR cap, const int x, const int y )
{
	if( st == ST_ICON_NONE ){ return; }

	CATS_ObjectAnimeSeqSetCap( cap, st );
	BPL_ClactOn( cap, x, y );
}

//--------------------------------------------------------------------------------------------
/**
 * |P̃^CvACR؂ւ
 *
 * @param	wk		[N
 * @param	pd		|Pf[^
 * @param	pos		Wf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_PokeTypeIconPut( BPLIST_WORK * wk, BPL_POKEDATA * pd, const int * pos )
{
	BPL_TypeIconChange( wk, wk->cap[BPL_CA_POKETYPE1], CHR_ID_POKETYPE1, pd->type1 );
	BPL_ClactOn( wk->cap[BPL_CA_POKETYPE1], pos[0], pos[1] );
	if( pd->type1 != pd->type2 ){
		BPL_TypeIconChange( wk, wk->cap[BPL_CA_POKETYPE2], CHR_ID_POKETYPE2, pd->type2 );
		BPL_ClactOn( wk->cap[BPL_CA_POKETYPE2], pos[2], pos[3] );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * ACeACR؂ւ
 *
 * @param	item	Xe[^X
 * @param	cap		ZAN^[f[^
 * @param	x		XW
 * @param	y		YW
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_ItemIconPut( u16 item, CATS_ACT_PTR cap, const int x, const int y )
{
	if( item == 0 ){ return; }

	if( ItemMailCheck( item ) == TRUE ){
		CATS_ObjectAnimeSeqSetCap( cap, 1 );
	}else{
		CATS_ObjectAnimeSeqSetCap( cap, 0 );
	}
	BPL_ClactOn( cap, x, y );
}


//--------------------------------------------------------------------------------------------
/**
 * y[WƂOBJZbg
 *
 * @param	wk		[N
 * @param	page	y[W
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BattlePokeList_PageObjSet( BPLIST_WORK * wk, u32 page )
{
	u32	i;

	for( i=0; i<BPL_CA_MAX; i++ ){
		CATS_ObjectEnableCap( wk->cap[i], 0 );
	}

	switch( page ){
	case BPLIST_PAGE_SELECT:	// |PIy[W
		BPL_Page1ObjSet( wk );
		break;
	case BPLIST_PAGE_MAIN:		// Xe[^XCy[W
		BPL_Page2ObjSet( wk );
		break;
	case BPLIST_PAGE_STATUS:	// Xe[^Xڍ׃y[W
		BPL_Page3ObjSet( wk );
		break;
	case BPLIST_PAGE_SKILL:		// Xe[^XZy[W
		BPL_Page4ObjSet( wk );
		break;
	case BPLIST_PAGE_SKILL_SET1:	// Xe[^XZYPy[W
		BPL_Page5ObjSet( wk );
		break;
	case BPLIST_PAGE_SKILL_SET2:	// Xe[^XZYQy[W
		BPL_Page6ObjSet( wk );
		break;
	case BPLIST_PAGE_PP_RCV:		// PP񕜋ZIy[W
		BPL_Page7ObjSet( wk );
		break;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * y[WPOBJZbg
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_Page1ObjSet( BPLIST_WORK * wk )
{
	s32	i;

	for( i=0; i<6; i++ ){
		if( wk->poke[i].mons == 0 ){ continue; }
		// |PACR
		BPL_ClactOn( wk->cap[BPL_CA_POKE1+i], P1_PokePos[i][0], P1_PokePos[i][1] );
		// ԈُACR
		BPL_StIconPut(
			wk->poke[i].st, wk->cap[BPL_CA_STATUS1+i], P1_StatusPos[i][0], P1_StatusPos[i][1] );

		// ACeACR
		BPL_ItemIconPut(
			wk->poke[i].item, wk->cap[BPL_CA_ITEM1+i], P1_PokePos[i][0]+8, P1_PokePos[i][1]+8 );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * y[WQOBJZbg
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_Page2ObjSet( BPLIST_WORK * wk )
{
	BPL_POKEDATA * pd;
	u16	i;

	pd = &wk->poke[wk->dat->sel_poke];

	// |PACR
	BPL_ClactOn( wk->cap[BPL_CA_POKE1+wk->dat->sel_poke], P2_PokePos[0], P2_PokePos[1] );
	// Xe[^Xُ
	BPL_StIconPut(
		pd->st, wk->cap[BPL_CA_STATUS1+wk->dat->sel_poke], P2_StatusPos[0], P2_StatusPos[1] );
	// ^Cv
	BPL_PokeTypeIconPut( wk, pd, &P2_PokeTypePos[0][0] );
	// ACeACR
	BPL_ItemIconPut(
		pd->item, wk->cap[BPL_CA_ITEM1+wk->dat->sel_poke], P2_PokePos[0]+8, P2_PokePos[1]+8 );

	// Z^Cv
	for( i=0; i<4; i++ ){
		if( pd->waza[i].id == 0 ){ continue; }

		BPL_TypeIconChange(
			wk, wk->cap[BPL_CA_WAZATYPE1+i], CHR_ID_WAZATYPE1+i, pd->waza[i].type );
		BPL_ClactOn( wk->cap[BPL_CA_WAZATYPE1+i], P2_WazaTypePos[i][0], P2_WazaTypePos[i][1] );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * y[WROBJZbg
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_Page3ObjSet( BPLIST_WORK * wk )
{
	BPL_POKEDATA * pd = &wk->poke[wk->dat->sel_poke];

	// |PACR
	BPL_ClactOn( wk->cap[BPL_CA_POKE1+wk->dat->sel_poke], P3_PokePos[0], P3_PokePos[1] );
	// Xe[^Xُ
	BPL_StIconPut(
		pd->st, wk->cap[BPL_CA_STATUS1+wk->dat->sel_poke], P3_StatusPos[0], P3_StatusPos[1] );
	// ^Cv
	BPL_PokeTypeIconPut( wk, pd, &P3_PokeTypePos[0][0] );
	// ACeACR
	BPL_ItemIconPut(
		pd->item, wk->cap[BPL_CA_ITEM1+wk->dat->sel_poke], P3_PokePos[0]+8, P3_PokePos[1]+8 );
}

//--------------------------------------------------------------------------------------------
/**
 * y[WSOBJZbg
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_Page4ObjSet( BPLIST_WORK * wk )
{
	BPL_POKEDATA * pd = &wk->poke[wk->dat->sel_poke];

	// |PACR
	BPL_ClactOn( wk->cap[BPL_CA_POKE1+wk->dat->sel_poke], P4_PokePos[0], P4_PokePos[1] );
	// Xe[^Xُ
	BPL_StIconPut(
		pd->st, wk->cap[BPL_CA_STATUS1+wk->dat->sel_poke], P4_StatusPos[0], P4_StatusPos[1] );
	// ^Cv
	BPL_PokeTypeIconPut( wk, pd, &P4_PokeTypePos[0][0] );
	// Z^Cv
	BPL_ClactOn(
		wk->cap[BPL_CA_WAZATYPE1+wk->dat->sel_wp], P4_WazaTypePos[0], P4_WazaTypePos[1] );
	// ACeACR
	BPL_ItemIconPut(
		pd->item, wk->cap[BPL_CA_ITEM1+wk->dat->sel_poke], P4_PokePos[0]+8, P4_PokePos[1]+8 );
	// ރACR
	BPL_KindIconChange(
		wk, wk->cap[BPL_CA_BUNRUI], pd->waza[wk->dat->sel_wp].kind );
	BPL_ClactOn( wk->cap[BPL_CA_BUNRUI], P4_WazaKindPos[0], P4_WazaKindPos[1] );
}

//--------------------------------------------------------------------------------------------
/**
 * y[WTOBJZbg
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_Page5ObjSet( BPLIST_WORK * wk )
{
	BPL_POKEDATA * pd;
	u16	i;

	pd = &wk->poke[wk->dat->sel_poke];

	// |PACR
	BPL_ClactOn( wk->cap[BPL_CA_POKE1+wk->dat->sel_poke], P5_PokePos[0], P5_PokePos[1] );
	// ^Cv
	BPL_PokeTypeIconPut( wk, pd, &P5_PokeTypePos[0][0] );
	// ACeACR
	BPL_ItemIconPut(
		pd->item, wk->cap[BPL_CA_ITEM1+wk->dat->sel_poke], P5_PokePos[0]+8, P5_PokePos[1]+8 );

	// Z^Cv
	BattlePokelist_WazaTypeSet( wk );
}

//--------------------------------------------------------------------------------------------
/**
 * y[WUOBJZbg
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_Page6ObjSet( BPLIST_WORK * wk )
{
	BPL_POKEDATA * pd = &wk->poke[wk->dat->sel_poke];

	// |PACR
	BPL_ClactOn( wk->cap[BPL_CA_POKE1+wk->dat->sel_poke], P6_PokePos[0], P6_PokePos[1] );
	// ^Cv
	BPL_PokeTypeIconPut( wk, pd, &P6_PokeTypePos[0][0] );
	// Z^Cv
	BPL_ClactOn(
		wk->cap[BPL_CA_WAZATYPE1+wk->dat->sel_wp], P6_WazaTypePos[0], P6_WazaTypePos[1] );
	// ACeACR
	BPL_ItemIconPut(
		pd->item, wk->cap[BPL_CA_ITEM1+wk->dat->sel_poke], P6_PokePos[0]+8, P6_PokePos[1]+8 );
	// ރACR
	if( wk->dat->sel_wp < 4 ){
		BPL_KindIconChange(
			wk, wk->cap[BPL_CA_BUNRUI], pd->waza[wk->dat->sel_wp].kind );
	}else{
		BPL_KindIconChange(
			wk, wk->cap[BPL_CA_BUNRUI], WT_WazaDataParaGet(wk->dat->chg_waza,ID_WTD_kind) );
	}
	BPL_ClactOn( wk->cap[BPL_CA_BUNRUI], P6_WazaKindPos[0], P6_WazaKindPos[1] );
}

//--------------------------------------------------------------------------------------------
/**
 * y[WVOBJZbg
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_Page7ObjSet( BPLIST_WORK * wk )
{
	BPL_POKEDATA * pd;
	u16	i;

	pd = &wk->poke[wk->dat->sel_poke];

	// |PACR
	BPL_ClactOn( wk->cap[BPL_CA_POKE1+wk->dat->sel_poke], P5_PokePos[0], P5_PokePos[1] );
	// ^Cv
	BPL_PokeTypeIconPut( wk, pd, &P5_PokeTypePos[0][0] );
	// ACeACR
	BPL_ItemIconPut(
		pd->item, wk->cap[BPL_CA_ITEM1+wk->dat->sel_poke], P5_PokePos[0]+8, P5_PokePos[1]+8 );

	// Z^Cv
	BattlePokelist_WazaTypeSet( wk );
}


//--------------------------------------------------------------------------------------------
/**
 * ZACRZbgF퓬
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_BattleWazaTypeSet( BPLIST_WORK * wk )
{
	BPL_POKEDATA * pd;
	u16	i;

	pd = &wk->poke[wk->dat->sel_poke];

	// Z^Cv
	for( i=0; i<4; i++ ){
		if( pd->waza[i].id == 0 ){ continue; }

		BPL_TypeIconChange(
			wk, wk->cap[BPL_CA_WAZATYPE1+i], CHR_ID_WAZATYPE1+i, pd->waza[i].type );
		BPL_ClactOn( wk->cap[BPL_CA_WAZATYPE1+i], P5_WazaTypePos[i][0], P5_WazaTypePos[i][1] );
	}

	if( wk->dat->chg_waza != 0 ){
		BPL_TypeIconChange(
			wk, wk->cap[BPL_CA_WAZATYPE5], CHR_ID_WAZATYPE5,
			WT_WazaDataParaGet( wk->dat->chg_waza, ID_WTD_wazatype ) );
		BPL_ClactOn( wk->cap[BPL_CA_WAZATYPE5], P5_WazaTypePos[4][0], P5_WazaTypePos[4][1] );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * ZACRZbgFReXg
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BPL_ContestWazaTypeSet( BPLIST_WORK * wk )
{
	BPL_POKEDATA * pd;
	u16	i;

	pd = &wk->poke[wk->dat->sel_poke];

	// Z^Cv
	for( i=0; i<4; i++ ){
		if( pd->waza[i].id == 0 ){ continue; }

		BPL_TypeIconChange(
			wk, wk->cap[BPL_CA_WAZATYPE1+i], CHR_ID_WAZATYPE1+i,
			WT_WazaDataParaGet(pd->waza[i].id,ID_WTD_contype)+ICONTYPE_STYLE );
		BPL_ClactOn( wk->cap[BPL_CA_WAZATYPE1+i], P5_WazaTypePos[i][0], P5_WazaTypePos[i][1] );
	}

	if( wk->dat->chg_waza != 0 ){
		BPL_TypeIconChange(
			wk, wk->cap[BPL_CA_WAZATYPE5], CHR_ID_WAZATYPE5,
			WT_WazaDataParaGet(wk->dat->chg_waza,ID_WTD_contype)+ICONTYPE_STYLE );
		BPL_ClactOn( wk->cap[BPL_CA_WAZATYPE5], P5_WazaTypePos[4][0], P5_WazaTypePos[4][1] );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * ZACRZbgF퓬 or ReXg
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BattlePokelist_WazaTypeSet( BPLIST_WORK * wk )
{
	if( wk->bc_put == 0 ){
		BPL_BattleWazaTypeSet( wk );
	}else{
		BPL_ContestWazaTypeSet( wk );
	}
}
