
//============================================================================================
/**
 * @file	client.c
 * @bfief	퓬NCAgvO
 * @author	HisashiSogabe
 * @date	05.05.24
 */
//============================================================================================

#include "common.h"
#include "battle/battle_server.h"
#include "battle/fight.h"
#include "battle/client.h"
#include "battle/client_tool.h"
#include "battle/wazano_def.h"
#include "battle/tokusyu_def.h"

#include "client_def.h"
#include "gauge.h"

//============================================================================================
/**
 * vg^Cv錾
 */
//============================================================================================

//OJ֐Q
CLIENT_PARAM	*ClientInit(BATTLE_WORK *bw,FIGHT_SYSTEM_BOOT_PARAM *fsbp);
void	ClientMain(BATTLE_WORK *battle_work,CLIENT_PARAM *client_param);
void	ClientEnd(CLIENT_PARAM *client_param);

//֐Wve[u
static	void	ClientDummy(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientEncountEffect(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientPokemonEncount(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientPokemonAppear(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientPokemonReturn(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientPokemonDelete(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientTrainerEncount(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientTrainerOut(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientTrainerIn(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientHPGaugeIn(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientHPGaugeOut(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientCommandSelect(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientWazaSelect(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientDirSelect(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientItemSelect(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientPokemonSelect(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientYesNoSelect(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientAttackMessage(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientMessage(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientWazaEffect(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientPokemonBlinkSet(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientHPGaugeCalcSet(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientEXPGaugeCalcSet(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClienKizetsuEffectSet(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientSePlaySet(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientFadeOutSet(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientPokemonVanishOnOff(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientHPGaugeStatusSet(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientTrainerMessageSet(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientModosuMessageSet(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientKuridasuMessageSet(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientAlertMessageSet(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientHPGaugeRefresh(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientPSPtoPPCopy(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientTrainerBGSlideIn(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientGaugeAnimeStop(BATTLE_WORK *bw,CLIENT_PARAM *cp);
static	void	ClientPokemonRefresh(BATTLE_WORK *bw,CLIENT_PARAM *cp);

//OJ֐Q
static	void	ClientCommandReset(CLIENT_PARAM *cp);

//============================================================================================
/**
 * @param
 */
//============================================================================================
CLIENT_PARAM	*ClientInit(BATTLE_WORK *bw,FIGHT_SYSTEM_BOOT_PARAM *fsbp)
{
	CLIENT_PARAM	*cp;
	int				i;

	cp=sys_AllocMemory(HEAPID_BATTLE,sizeof(CLIENT_PARAM));
	MI_CpuClearFast(cp,sizeof(CLIENT_PARAM));

	cp->client_no=fsbp->client_no;
	cp->client_type=fsbp->client_type;


	//HPQ[W
	cp->gauge.bw = bw;
	cp->gauge.type = Gauge_TypeGet(cp->client_type);
	Gauge_ActorResourceSet(&cp->gauge);
	Gauge_EnableSet(&cp->gauge, CATS_ENABLE_FALSE);
	
	return cp;
}

//============================================================================================
/**
 *	֐Wve[u
 */
//============================================================================================

static	const	clFunc	ClientFunctionTable[]={
	ClientDummy,
	ClientEncountEffect,
	ClientPokemonEncount,
	ClientPokemonAppear,
	ClientPokemonReturn,
	ClientPokemonDelete,
	ClientTrainerEncount,
	ClientTrainerOut,
	ClientTrainerIn,
	ClientHPGaugeIn,
	ClientHPGaugeOut,
	ClientCommandSelect,
	ClientWazaSelect,
	ClientDirSelect,
	ClientItemSelect,
	ClientPokemonSelect,
	ClientYesNoSelect,
	ClientAttackMessage,
	ClientMessage,
	ClientWazaEffect,
	ClientPokemonBlinkSet,
	ClientHPGaugeCalcSet,
	ClientEXPGaugeCalcSet,
	ClienKizetsuEffectSet,
	ClientSePlaySet,
	ClientFadeOutSet,
	ClientPokemonVanishOnOff,
	ClientHPGaugeStatusSet,
	ClientTrainerMessageSet,
	ClientModosuMessageSet,
	ClientKuridasuMessageSet,
	ClientAlertMessageSet,
	ClientHPGaugeRefresh,
	ClientPSPtoPPCopy,
	ClientTrainerBGSlideIn,
	ClientGaugeAnimeStop,
	ClientPokemonRefresh,
};

//============================================================================================
/**
 * @param
 */
//============================================================================================
void	ClientMain(BATTLE_WORK *battle_work,CLIENT_PARAM *client_param)
{
	if(client_param->client_buffer[0]){
		ClientFunctionTable[client_param->client_buffer[0]](battle_work,client_param);
	}
}

//============================================================================================
/**
 * @param
 */
//============================================================================================
void	ClientEnd(CLIENT_PARAM *client_param)
{
	Gauge_ActorResourceDel(&client_param->gauge);	//Q[W폜
	
	sys_FreeMemory(HEAPID_BATTLE,client_param);
}

//============================================================================================
/**
 *	_~[֐i֐e[uio[́A1IWȂ̂ŁA_~[֐pӁj
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientDummy(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
}

//============================================================================================
/**
 *	GJEgGtFNgZbg
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientEncountEffect(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	CT_EncountEffectSet(bw,cp);
	//GJEgGtFNg͏I҂̕KvȂî͂j
	SCIO_ServerQueClear(bw,cp->client_no,CL_ENCOUNT_EFFECT);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	GJEgp̃|PZbg
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientPokemonEncount(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	POKEMON_ENCOUNT_PARAM	*pep=(POKEMON_ENCOUNT_PARAM *)&cp->client_buffer[0];

	CT_PokemonEncountSet(bw,cp,pep);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	|PoGtFNgZbg
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientPokemonAppear(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	POKEMON_APPEAR_PARAM	*pap=(POKEMON_APPEAR_PARAM *)&cp->client_buffer[0];

	CT_PokemonAppearSet(bw,cp,pap);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	|P߂GtFNgZbg
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientPokemonReturn(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	POKEMON_RETURN_PARAM	*prp=(POKEMON_RETURN_PARAM *)&cp->client_buffer[0];

	CT_PokemonReturnSet(bw,cp,prp);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	|P폜
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientPokemonDelete(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	SoftSpriteDel(cp->poke_ss);
	SCIO_ServerQueClear(bw,cp->client_no,CL_POKEMON_DELETE);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	GJEgp̃g[i[Zbg
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientTrainerEncount(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	TRAINER_ENCOUNT_PARAM	*tep=(TRAINER_ENCOUNT_PARAM *)&cp->client_buffer[0];

	CT_TrainerEncountSet(bw,cp,tep);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	g[i[ʊOGtFNgZbg
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientTrainerOut(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	CT_TrainerOutSet(bw,cp);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	g[i[ʓGtFNgZbg
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientTrainerIn(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	TRAINER_IN_PARAM	*tip=(TRAINER_IN_PARAM *)&cp->client_buffer[0];

	CT_TrainerInSet(bw,cp,tip);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	HPQ[WINGtFNgZbg
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientHPGaugeIn(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	HP_GAUGE_IN_PARAM	*hgip=(HP_GAUGE_IN_PARAM *)&cp->client_buffer[0];

	CT_HPGaugeInSet(bw,cp,hgip);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	HPQ[WOUTGtFNgZbg
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientHPGaugeOut(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	CT_HPGaugeOutSet(bw,cp);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	R}hIN
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientCommandSelect(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	COMMAND_SELECT_PARAM	*csp=(COMMAND_SELECT_PARAM *)&cp->client_buffer[0];

	CT_CommandSelectSet(bw,cp,csp);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	ZIN
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientWazaSelect(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	WAZA_SELECT_PARAM	*wsp=(WAZA_SELECT_PARAM *)&cp->client_buffer[0];

	CT_WazaSelectSet(bw,cp,wsp);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	UΏۑIN
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientDirSelect(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	DIR_SELECT_PARAM	*dsp=(DIR_SELECT_PARAM *)&cp->client_buffer[0];

	CT_DirSelectSet(bw,cp,dsp);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	IN
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientItemSelect(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	ITEM_SELECT_PARAM	*isp=(ITEM_SELECT_PARAM *)&cp->client_buffer[0];

	CT_ItemSelectSet(bw,cp,isp);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	|PIN
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientPokemonSelect(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	POKEMON_SELECT_PARAM	*psp=(POKEMON_SELECT_PARAM *)&cp->client_buffer[0];

	CT_PokemonSelectSet(bw,cp,psp);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	Yes/NoIN
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientYesNoSelect(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	YES_NO_SELECT_PARAM	*ynsp=(YES_NO_SELECT_PARAM *)&cp->client_buffer[0];

	CT_YesNoSelectSet(bw,cp,ynsp);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	A^bNbZ[W\
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientAttackMessage(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	ATTACK_MESSAGE_PARAM	*amp=(ATTACK_MESSAGE_PARAM *)&cp->client_buffer[0];

	CT_AttackMessageSet(bw,cp,amp);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	bZ[W\
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientMessage(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	MESSAGE_PARAM	*mp=(MESSAGE_PARAM *)&cp->client_buffer[0];

	CT_MessageSet(bw,cp,mp);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	ZGtFNgN
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientWazaEffect(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	WAZA_EFFECT_PARAM	*wep=(WAZA_EFFECT_PARAM *)&cp->client_buffer[0];

	CT_WazaEffectSet(bw,cp,wep);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	|P_[WuNANVZbg
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientPokemonBlinkSet(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	//ojbVԂ̎̓uNȂ
	if(SoftSpriteParaGet(cp->poke_ss,SS_PARA_VANISH)==SW_VANISH_ON){
		SCIO_ServerQueClear(bw,cp->client_no,CL_POKEMON_BLINK);
	}
	else{
		CT_PokemonBlinkSet(bw,cp);
	}
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	HPQ[WvZZbg
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientHPGaugeCalcSet(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	HP_GAUGE_CALC_PARAM	*hgcp=(HP_GAUGE_CALC_PARAM *)&cp->client_buffer[0];

	CT_HPGaugeCalcSet(bw,cp,hgcp);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	EXPQ[WvZZbg
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientEXPGaugeCalcSet(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	EXP_GAUGE_CALC_PARAM	*egcp=(EXP_GAUGE_CALC_PARAM *)&cp->client_buffer[0];

	CT_EXPGaugeCalcSet(bw,cp,egcp);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	CGtFNgZbg
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClienKizetsuEffectSet(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	KIZETSU_EFFECT_PARAM	*kep=(KIZETSU_EFFECT_PARAM *)&cp->client_buffer[0];

	CT_KizetsuEffectSet(bw,cp,kep);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	w肳ꂽSE炷
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientSePlaySet(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	SE_PLAY_PARAM	*spp=(SE_PLAY_PARAM *)&cp->client_buffer[0];

	CT_SePlaySet(bw,cp,spp);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	ʃtF[hAEgZbg
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientFadeOutSet(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	CT_FadeOutSet(bw,cp);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	|PojbVtOON/OFF
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientPokemonVanishOnOff(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	POKEMON_VANISH_ON_OFF	*vopp=(POKEMON_VANISH_ON_OFF *)&cp->client_buffer[0];

	SoftSpriteParaSet(cp->poke_ss,SS_PARA_VANISH,vopp->sw);

	SCIO_ServerQueClear(bw,cp->client_no,vopp->command_code);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	HPQ[W̏ԈُACR̕\
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientHPGaugeStatusSet(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	HP_GAUGE_STATUS_SET_PARAM	*hgssp=(HP_GAUGE_STATUS_SET_PARAM *)&cp->client_buffer[0];

	CT_HPGaugeStatusSet(bw,cp,hgssp);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	g[i[bZ[W̕\
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientTrainerMessageSet(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	TRAINER_MESSAGE_PARAM	*tmp=(TRAINER_MESSAGE_PARAM *)&cp->client_buffer[0];

	CT_TrainerMessageSet(bw,cp,tmp);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	߂bZ[W\
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientModosuMessageSet(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	MODOSU_MESSAGE_PARAM	*mmp=(MODOSU_MESSAGE_PARAM *)&cp->client_buffer[0];

	CT_ModosuMessageSet(bw,cp,mmp);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	JobZ[W\
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientKuridasuMessageSet(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	KURIDASU_MESSAGE_PARAM	*kmp=(KURIDASU_MESSAGE_PARAM *)&cp->client_buffer[0];

	CT_KuridasuMessageSet(bw,cp,kmp);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	A[gbZ[W\
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientAlertMessageSet(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	ALERT_MESSAGE_PARAM	*amp=(ALERT_MESSAGE_PARAM *)&cp->client_buffer[0];

	CT_AlertMessageSet(bw,cp,amp);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	HPQ[Wĕ`
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientHPGaugeRefresh(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	HP_GAUGE_REFRESH_PARAM	*hgrp=(HP_GAUGE_REFRESH_PARAM *)&cp->client_buffer[0];

	CT_HPGaugeRefreshSet(bw,cp,hgrp);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	PSPKvȃf[^PPɏ߂
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientPSPtoPPCopy(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	PSP_TO_PP_COPY_PARAM	*ptpcp=(PSP_TO_PP_COPY_PARAM *)&cp->client_buffer[0];
	int						i;
	POKEMON_PARAM			*pp;

	pp=BattleWorkPokemonParamGet(bw,cp->client_no,ptpcp->sel_mons_no);

	for(i=0;i<WAZA_TEMOTI_MAX;i++){
		if((ptpcp->monomane_bit&No2Bit(i))==0){
			PokeParaPut(pp,ID_PARA_waza1+i,		(u8 *)&ptpcp->waza[i]);
			PokeParaPut(pp,ID_PARA_pp1+i,		(u8 *)&ptpcp->pp[i]);
		}
	}
	PokeParaPut(pp,ID_PARA_hp,			(u8 *)&ptpcp->hp);
	PokeParaPut(pp,ID_PARA_condition,	(u8 *)&ptpcp->condition);
	if((ptpcp->hatakiotosu&No2Bit(ptpcp->sel_mons_no))==0){
		PokeParaPut(pp,ID_PARA_item,	(u8 *)&ptpcp->item);
	}

	SCIO_ServerQueClear(bw,cp->client_no,ptpcp->command_code);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	^b`plɃg[i[BGSlideIn
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientTrainerBGSlideIn(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	u32				fight_type;
	BI_PARAM_PTR	bip;

	fight_type=BattleWorkFightTypeGet(bw);
	bip = BattleWorkGF_BGL_BIPGet(bw);

	if(cp->client_boot==CLIENT_BOOT_NORMAL){
		if((fight_type&FIGHT_TYPE_MULTI)||
		  (((fight_type&FIGHT_TYPE_MULTI)==0)&&(cp->client_type!=CLIENT_TYPE_C))){
			BINPUT_PlayerBG_ScrollX(bip, BIN_PLAYER_SCROLL_SP_X, 0);
		}
	}

	SCIO_ServerQueClear(bw,cp->client_no,cp->client_buffer[0]);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	Q[W̃Aj[VXgbv
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientGaugeAnimeStop(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	Gauge_AnimeStop(&cp->gauge);
	SCIO_ServerQueClear(bw,cp->client_no,cp->client_buffer[0]);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	|P̏Ԉُ𒼂
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 */
//============================================================================================
static	void	ClientPokemonRefresh(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	POKEMON_REFRESH_PARAM	*prp=(POKEMON_REFRESH_PARAM *)&cp->client_buffer[0];
	POKEMON_PARAM			*pp;
	int						i,poke_count,speabi;
	u32						condition;

	condition=0;

	poke_count=BattleWorkPokeCountGet(bw,cp->client_no);

	for(i=0;i<poke_count;i++){
		pp=BattleWorkPokemonParamGet(bw,cp->client_no,i);
		speabi=PokeParaGet(pp,ID_PARA_speabino,NULL);
		if((prp->waza_no!=WAZANO_IYASINOSUZU)||
		   ((prp->waza_no==WAZANO_IYASINOSUZU)&&(speabi!=TOKUSYU_BOUON))){
			PokeParaPut(pp,ID_PARA_condition,(u8 *)&condition);
		}
	}

	SCIO_ServerQueClear(bw,cp->client_no,prp->command_code);
	ClientCommandReset(cp);
}

//============================================================================================
/**
 *	R}hZbg
 *
 * @param[in]	cp		NCAgp[Ñ|C^
 */
//============================================================================================
static	void	ClientCommandReset(CLIENT_PARAM *cp)
{
	cp->client_buffer[0]=0;
}

