
//============================================================================================
/**
 * @file	client_tool.c
 * @bfief	퓬NCAgpc[vO
 * @author	HisashiSogabe
 * @date	05.07.21
 */
//============================================================================================

#include "common.h"

#include "system/procsys.h"
#include "system/gamedata.h"
#include "application/bag.h"

#include "battle/battle_server.h"
#include "battle/client.h"
#include "battle/fight.h"
#include "battle/fight_tool.h"
#include "battle/server_tool.h"
#include "battle/ground.h"
#include "battle/scio.h"

#include "poketool/poke_tool.h"
#include "poketool/tr_tool.h"
#include "poketool/waza_tool.h"
#include "poketool/monsno.h"

#include "gflib/touchpanel.h"

#include "itemtool/itemsym.h"
#include "itemtool/myitem.h"

#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/snd_tool.h"
#include "system/softsprite.h"
#include "system/gra_tool.h"

#include "wazaeffect/we_sys.h"

#include "client_def.h"
#include "client_tool_def.h"

#include "b_plist.h"
#include "b_bag.h"
#include "gauge.h"
#include "battle/battle_tcb_pri.h"
#include "system/pm_str.h"
#include "system/msg_ds_icon.h"

#include "battle/graphic/batt_bg_def.h"

#include "wazaeffect/d_we.h"
#include "wazaeffect/d_tool.h"
#include "wazaeffect/ball_effect.h"
#include "wazaeffect/smptm_statuseffect.h"
#include "battle_input.h"

#include "msgdata/msg_fightmsg_dp.h"
#include "msgdata/msg_atkmsg.h"

#include "system/poke_anime.h"

#include "communication/communication.h"

#define WAZA_EFF_GAUGE_OFF			///<ZGtFNgHPQ[W

//-----------------------------------------------------------------------------
//					vg^Cv錾
//-----------------------------------------------------------------------------

//ZV[PXn
void	CT_EncountEffectSet(BATTLE_WORK *bw,CLIENT_PARAM *cp);
void	CT_PokemonEncountSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,POKEMON_ENCOUNT_PARAM *pep);
void	CT_PokemonAppearSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,POKEMON_APPEAR_PARAM *pap);
void	CT_PokemonReturnSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,POKEMON_RETURN_PARAM *prp);
void	CT_TrainerEncountSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,TRAINER_ENCOUNT_PARAM *tep);
void	CT_TrainerOutSet(BATTLE_WORK *bw,CLIENT_PARAM *cp);
void	CT_TrainerInSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,TRAINER_IN_PARAM *tip);
void	CT_HPGaugeInSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,HP_GAUGE_IN_PARAM *hgip);
void	CT_HPGaugeOutSet(BATTLE_WORK *bw,CLIENT_PARAM *cp);
void	CT_CommandSelectSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,COMMAND_SELECT_PARAM *csp);
void	CT_WazaSelectSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,WAZA_SELECT_PARAM *wsp);
void	CT_DirSelectSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,DIR_SELECT_PARAM *dsp);
void	CT_ItemSelectSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,ITEM_SELECT_PARAM *isp);
void	CT_PokemonSelectSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,POKEMON_SELECT_PARAM *psp);
void	CT_YesNoSelectSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,YES_NO_SELECT_PARAM *ynsp);
void	CT_AttackMessageSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,ATTACK_MESSAGE_PARAM *amp);
void	CT_MessageSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,MESSAGE_PARAM *amp);
void	CT_WazaEffectSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,WAZA_EFFECT_PARAM *wep);
void	CT_PokemonBlinkSet(BATTLE_WORK *bw,CLIENT_PARAM *cp);
void	CT_HPGaugeCalcSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,HP_GAUGE_CALC_PARAM *hgcp);
void	CT_EXPGaugeCalcSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,EXP_GAUGE_CALC_PARAM *egcp);
void	CT_KizetsuEffectSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,KIZETSU_EFFECT_PARAM *kep);
void	CT_SePlaySet(BATTLE_WORK *bw,CLIENT_PARAM *cp,SE_PLAY_PARAM *spp);
void	CT_FadeOutSet(BATTLE_WORK *bw,CLIENT_PARAM *cp);
void	CT_HPGaugeStatusSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,HP_GAUGE_STATUS_SET_PARAM *hgssp);
void	CT_TrainerMessageSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,TRAINER_MESSAGE_PARAM *tmp);
void	CT_ModosuMessageSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,MODOSU_MESSAGE_PARAM *mmp);
void	CT_KuridasuMessageSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,KURIDASU_MESSAGE_PARAM *kmp);
void	CT_AlertMessageSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,ALERT_MESSAGE_PARAM *amp);
void	CT_HPGaugeRefreshSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,HP_GAUGE_REFRESH_PARAM *hgrp);

//TCBn
static	void	TCB_PokemonEncount(TCB_PTR tcb,void *work);
static	void	TCB_PokemonAppear(TCB_PTR tcb,void *work);
static	void	TCB_PokemonReturn(TCB_PTR tcb,void *work);
static	void	TCB_TrainerEncount(TCB_PTR tcb,void *work);
static	void	TCB_TrainerIn(TCB_PTR tcb,void *work);
static	void	TCB_TrainerOut(TCB_PTR tcb,void *work);
static	void	TCB_HPGaugeIn(TCB_PTR tcb,void *work);
static	void	TCB_HPGaugeOut(TCB_PTR tcb,void *work);
static	void	TCB_CommandSelect(TCB_PTR tcb,void *work);
static	void	TCB_CommandSelectAI(TCB_PTR tcb,void *work);
static	void	TCB_CommandSelectSIO(TCB_PTR tcb,void *work);
static	void	TCB_WazaSelect(TCB_PTR tcb,void *work);
static	void	TCB_WazaSelectAI(TCB_PTR tcb,void *work);
static	void	TCB_WazaSelectSIO(TCB_PTR tcb,void *work);
static	void	TCB_DirSelect(TCB_PTR tcb,void *work);
static	void	TCB_DirSelectAI(TCB_PTR tcb,void *work);
static	void	TCB_DirSelectSIO(TCB_PTR tcb,void *work);
static	void	TCB_ItemSelect(TCB_PTR tcb,void *work);
static	void	TCB_ItemSelectAI(TCB_PTR tcb,void *work);
static	void	TCB_ItemSelectSIO(TCB_PTR tcb,void *work);
static	void	TCB_PokemonSelect(TCB_PTR tcb,void *work);
static	void	TCB_PokemonSelectAI(TCB_PTR tcb,void *work);
static	void	TCB_PokemonSelectSIO(TCB_PTR tcb,void *work);
static	void	TCB_YesNoSelect(TCB_PTR tcb,void *work);
static	void	TCB_YesNoSelectAI(TCB_PTR tcb,void *work);
static	void	TCB_YesNoSelectSIO(TCB_PTR tcb,void *work);
static	void	TCB_WazaEffect(TCB_PTR tcb,void *work);
static	void	TCB_PokemonBlink(TCB_PTR tcb,void *work);
static	void	TCB_HPGaugeCalc(TCB_PTR tcb,void *work);
static	void	TCB_EXPGaugeCalc(TCB_PTR tcb,void *work);
static	void	TCB_KizetsuEffect(TCB_PTR tcb,void *work);
static	void	TCB_FadeOut(TCB_PTR tcb,void *work);

static	void	TCB_MessageWait(TCB_PTR tcb,void *work);
static	void	TCB_AlertMessageWait(TCB_PTR tcb,void *work);

static	void	TCB_EncountEffect(TCB_PTR tcb,void *work);

//O֐c[n
void			CT_UISet(BATTLE_WORK *bw,CLIENT_PARAM *cp);
u8				CT_CPClientTypeGet(CLIENT_PARAM *cp);
SOFT_SPRITE		*CT_CPSoftSpriteGet(CLIENT_PARAM *cp);
GAUGE_WORK		*CT_CPGaugeWorkGet(CLIENT_PARAM *cp);

//OJc[n
static	void	GaugeObjCreate(BATTLE_WORK *bw,int dir,int level,int hp,int hpmax);
static	void	NumCalc(int num,int *bit,int *buf);
static	SOFT_SPRITE	*CT_SoftSpriteAdd(BATTLE_WORK *bw,SOFT_SPRITE_MANAGER *ssm_p,SOFT_SPRITE_ARC *ssa,
									  int pos_x,int pos_y,int pos_z,int ofs_y,int client_no,
									  SOFT_SPRITE_ANIME *anm_tbl,SOFT_SPRITE_MOVE_FUNC *move);
static	void	CT_ModosuMessageParamMake(BATTLE_WORK *bw,CLIENT_PARAM *cp,MODOSU_MESSAGE_PARAM *mmp,MESSAGE_PARAM *mp);
static	void	CT_KuridasuMessageParamMake(BATTLE_WORK *bw,CLIENT_PARAM *cp,KURIDASU_MESSAGE_PARAM *kmp,MESSAGE_PARAM *mp);

//-----------------------------------------------------------------------------
//					萔`
//-----------------------------------------------------------------------------

#define	SCROLL_SPEED	(2)		///<|PGJEgĂƂ̔wiXN[̃Xs[h
#define	ENCOUNT_SPEED	(4)		///<|PGJEgĂƂ̃Xs[h
#define	AFF_SPEED		(0x20)	///<|PoGtFNg̃|P傫ȂXs[h
#define	BLINK_WAIT		(3)		///<_[WuN̊Ԋu
#define	TP_WAIT			(10)	///<^b`plɃ^b`Ă玟̃V[PXɈڍs܂ł̃EGCg
#define	ALERT_WAIT		(40)	///<A[gbZ[W̕\EGCg

#define	POKE_APPEAR_NORMAL_VOL	(127)	//|Poꎞ̖ʁiʏj
#define	POKE_APPEAR_BAD_VOL		(127)	//|Poꎞ̖ʁiԈُAHPj
#define	POKE_KIZETSU_VOL		(127)	//|PC⎞̖

#define	POKE_VOICE_PAN_FRONT	(127)	//|PʖPANݒ
#define	POKE_VOICE_PAN_BACK		(-128)		//|PwʖPANݒ

//-----------------------------------------------------------------------------
//		GJEgWe[u
//-----------------------------------------------------------------------------

static	const	s16	EncountPosTable[][3]={
	{ENCOUNT_X_TYPE_AA,ENCOUNT_Y_TYPE_AA,ENCOUNT_Z_TYPE_AA},
	{ENCOUNT_X_TYPE_BB,ENCOUNT_Y_TYPE_BB,ENCOUNT_Z_TYPE_BB},
	{ENCOUNT_X_TYPE_A,ENCOUNT_Y_TYPE_A,ENCOUNT_Z_TYPE_A},
	{ENCOUNT_X_TYPE_B,ENCOUNT_Y_TYPE_B,ENCOUNT_Z_TYPE_B},
	{ENCOUNT_X_TYPE_C,ENCOUNT_Y_TYPE_C,ENCOUNT_Z_TYPE_C},
	{ENCOUNT_X_TYPE_D,ENCOUNT_Y_TYPE_D,ENCOUNT_Z_TYPE_D},
};

static	const	s16	AppearPosTable[][2]={
	{APPEAR_X_TYPE_AA,MSG_X_TYPE_AA},
	{APPEAR_X_TYPE_BB,MSG_X_TYPE_BB},
	{APPEAR_X_TYPE_A, MSG_X_TYPE_AA},
	{APPEAR_X_TYPE_B, MSG_X_TYPE_BB},
	{APPEAR_X_TYPE_C, MSG_X_TYPE_AA},
	{APPEAR_X_TYPE_D, MSG_X_TYPE_BB},
};

static	const	s16	SlideInPosTable[][3]={
	{SLIDEIN_X_TYPE_AA,SLIDEIN_Y_TYPE_AA,SLIDEIN_Z_TYPE_AA},
	{SLIDEIN_X_TYPE_BB,SLIDEIN_Y_TYPE_BB,SLIDEIN_Z_TYPE_BB},
};

//============================================================================================
/**
 *	GJEgGtFNgZbg
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 * @param[in]	pep		|PGJEgp[^\
 */
//============================================================================================
void	CT_EncountEffectSet(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	TCB_ENCOUNT_EFFECT	*tee;

	tee=(TCB_ENCOUNT_EFFECT *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_ENCOUNT_EFFECT));
	tee->bw=bw;
	tee->seq_no=0;
	tee->wait=0;
	GF_BGL_ScrollSet(BattleWorkGF_BGL_INIGet(bw),GF_BGL_FRAME3_M,GF_BGL_SCROLL_X_DEC,SCROLL_SPEED*130);
	TCB_Add(TCB_EncountEffect,tee,0);
}

//============================================================================================
/**
 *	GJEg|PZbg
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 * @param[in]	pep		|PGJEgp[^\
 */
//============================================================================================
void	CT_PokemonEncountSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,POKEMON_ENCOUNT_PARAM *pep)
{
	int	col;
	SOFT_SPRITE_ARC	ssa;
	SOFT_SPRITE_MANAGER	*ssm;
	TCB_POKEMON_ENCOUNT	*tpe;
	int	fight_type;
	u8	height;

#if 0	//͉ʂ̏풓bZ[Wp 2006.03.14() matsuda
		//Ƃ肠܂Ȃ̂ŃRgAEg
	{
		STRBUF *nick_buf;
		nick_buf = STRBUF_Create(BUFLEN_POKEMON_NAME, HEAPID_BATTLE);
		STRBUF_SetStringCode(nick_buf, pep->nickname);
	}
#endif
	
	ssm=BattleWorkSoftSpriteManagerGet(bw);
	fight_type=BattleWorkFightTypeGet(bw);

	tpe=(TCB_POKEMON_ENCOUNT *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_POKEMON_ENCOUNT));
	tpe->seq_no=0;

	if(cp->client_type&CLIENT_ENEMY_FLAG){
		tpe->dir=PARA_FRONT;
		tpe->gw=BattleWorkGroundWorkGet(bw,GROUND_ENEMY);
		CATS_ObjectPosSetCap(tpe->gw->cap,EncountPosTable[cp->client_type][0],GROUND_ENEMY_Y);
	}
	else{
		tpe->dir=PARA_BACK;
		tpe->gw=BattleWorkGroundWorkGet(bw,GROUND_MINE);
		CATS_ObjectPosSetCap(tpe->gw->cap,EncountPosTable[cp->client_type][0],GROUND_MINE_Y);
	}
	if(pep->rare){
		col=PARA_RARE;
	}
	else{
		col=PARA_NORMAL;
	}
	PokeGraArcDataGet(&ssa,pep->monsno,pep->sex,tpe->dir,col);
	height=PokeHeightGet(pep->monsno,pep->sex,tpe->dir);
	tpe->ss=cp->poke_ss=CT_SoftSpriteAdd(bw,ssm,&ssa,
										 EncountPosTable[cp->client_type][0],
										 EncountPosTable[cp->client_type][1],
										 EncountPosTable[cp->client_type][2],
										 height,
										 cp->client_no,NULL,NULL);

	tpe->appear_pos=AppearPosTable[cp->client_type][POS_APPEAR];
	tpe->bw=bw;
	tpe->command_code=pep->command_code;
	tpe->client_no=cp->client_no;
	tpe->mons_no=pep->monsno;
	tpe->voice=pep->voice;
	tpe->client_type=cp->client_type;
	TCB_Add(TCB_PokemonEncount,tpe,0);
}

//============================================================================================
/**
 *	|PoGtFNgZbg
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 * @param[in]	pap		|PoGtFNgp[^\
 */
//============================================================================================
void	CT_PokemonAppearSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,POKEMON_APPEAR_PARAM *pap)
{
	int	col;
	SOFT_SPRITE_ARC	ssa;
	SOFT_SPRITE_MANAGER	*ssm;
	TCB_POKEMON_APPEAR	*tpa;
	int	fight_type;
	u8	height;

	ssm=BattleWorkSoftSpriteManagerGet(bw);
	fight_type=BattleWorkFightTypeGet(bw);

	tpa=(TCB_POKEMON_APPEAR *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_POKEMON_APPEAR));
	tpa->seq_no=0;

	if(cp->client_type&CLIENT_ENEMY_FLAG){
		tpa->dir=PARA_FRONT;
	}
	else{
		tpa->dir=PARA_BACK;
	}
	if(pap->rare){
		col=PARA_RARE;
	}
	else{
		col=PARA_NORMAL;
	}
	PokeGraArcDataGet(&ssa,pap->monsno,pap->sex,tpa->dir,col);
	tpa->height=PokeHeightGet(pap->monsno,pap->sex,tpa->dir);
	tpa->ss=cp->poke_ss=CT_SoftSpriteAdd(bw,ssm,&ssa,
										 AppearPosTable[cp->client_type][POS_APPEAR],
										 EncountPosTable[cp->client_type][1],
										 EncountPosTable[cp->client_type][2],
										 tpa->height,
										 cp->client_no,NULL,NULL);

	SoftSpriteParaSet(tpa->ss,SS_PARA_AFF_X,AFF_APPEAR_X_S);
	SoftSpriteParaSet(tpa->ss,SS_PARA_AFF_Y,AFF_APPEAR_Y_S);
	tpa->bw=bw;
	tpa->command_code=pap->command_code;
	tpa->client_no=cp->client_no;
	tpa->mons_no=pap->monsno;
	tpa->client_type = cp->client_type;
	tpa->voice=pap->voice;
	TCB_Add(TCB_PokemonAppear,tpa,0);
}

//============================================================================================
/**
 *	|P߂GtFNgZbg
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 */
//============================================================================================
void	CT_PokemonReturnSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,POKEMON_RETURN_PARAM *prp)
{
	TCB_POKEMON_RETURN	*tpr;

	tpr=(TCB_POKEMON_RETURN *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_POKEMON_RETURN));
	tpr->bw=bw;
	tpr->ss=cp->poke_ss;
	tpr->command_code=prp->command_code;
	tpr->client_no=cp->client_no;
	tpr->seq_no=0;
	tpr->height=prp->height;

	TCB_Add(TCB_PokemonReturn,tpr,0);
}

//============================================================================================
/**
 *	GJEgg[i[Zbg
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 * @param[in]	tep		GJEgg[i[p[^\
 */
//============================================================================================
void	CT_TrainerEncountSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,TRAINER_ENCOUNT_PARAM *tep)
{
	int	col;
	SOFT_SPRITE_ARC	ssa;
	SOFT_SPRITE_MANAGER	*ssm;
	TCB_TRAINER_ENCOUNT	*tte;
	u32	sex;
	int	type;

	ssm=BattleWorkSoftSpriteManagerGet(bw);

	tte=(TCB_TRAINER_ENCOUNT *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_TRAINER_ENCOUNT));
	tte->seq_no=0;

	if(cp->client_type&CLIENT_ENEMY_FLAG){
		tte->dir=PARA_FRONT;
		tte->gw=BattleWorkGroundWorkGet(bw,GROUND_ENEMY);
		CATS_ObjectPosSetCap(tte->gw->cap,EncountPosTable[cp->client_type&1][0],GROUND_ENEMY_Y);
	}
	else{
		tte->dir=PARA_BACK;
		tte->gw=BattleWorkGroundWorkGet(bw,GROUND_MINE);
		CATS_ObjectPosSetCap(tte->gw->cap,EncountPosTable[cp->client_type&1][0],GROUND_MINE_Y);
	}
	sex=BattleWorkMySexGet(bw,cp->client_no);
	TrGraArcDataGet(&ssa,tep->tr_id,tte->dir,sex);
	if(BattleWorkFightTypeGet(bw)&FIGHT_TYPE_MULTI){
		type=cp->client_type;
	}
	else{
		type=cp->client_type&1;
	}
	tte->ss=cp->tr_ss=SoftSpriteAdd(ssm,&ssa,
									EncountPosTable[type][0],
									EncountPosTable[type][1],
									EncountPosTable[type][2],
									cp->client_no,
									NULL,
									NULL);
	tte->appear_pos=AppearPosTable[type][POS_APPEAR];
	tte->bw=bw;
	tte->command_code=tep->command_code;
	tte->client_no=cp->client_no;
	tte->tr_id=tep->tr_id;
	tte->client_type = cp->client_type;
	TCB_Add(TCB_TrainerEncount,tte,0);
}

//============================================================================================
/**
 *	g[i[ʊOGtFNgZbg
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 */
//============================================================================================
void	CT_TrainerOutSet(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	TCB_TRAINER_OUT	*tto;

	tto=(TCB_TRAINER_OUT *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_TRAINER_OUT));
	tto->seq_no=0;

	tto->bw=bw;
	tto->command_code=cp->client_buffer[0];
	tto->client_no=cp->client_no;
	tto->ss=cp->tr_ss;
	if(cp->client_type&CLIENT_ENEMY_FLAG){
		tto->dir=PARA_FRONT;
	}
	else{
		tto->dir=PARA_BACK;
	}

	TCB_Add(TCB_TrainerOut,tto,0);
}

//============================================================================================
/**
 *	g[i[ʓGtFNgZbg
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 */
//============================================================================================
void	CT_TrainerInSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,TRAINER_IN_PARAM *tip)
{
	int	col;
	SOFT_SPRITE_ARC	ssa;
	SOFT_SPRITE_MANAGER	*ssm;
	TCB_TRAINER_IN	*tti;
	u32	sex;

	ssm=BattleWorkSoftSpriteManagerGet(bw);

	tti=(TCB_TRAINER_IN *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_TRAINER_IN));
	tti->seq_no=0;

	if(cp->client_type&CLIENT_ENEMY_FLAG){
		tti->dir=PARA_FRONT;
	}
	else{
		tti->dir=PARA_BACK;
	}
	sex=BattleWorkMySexGet(bw,cp->client_no);
	TrGraArcDataGet(&ssa,tip->tr_id,tti->dir,sex);
	tti->ss=cp->tr_ss=SoftSpriteAdd(ssm,&ssa,
									SlideInPosTable[cp->client_type&1][0],
									SlideInPosTable[cp->client_type&1][1],
									SlideInPosTable[cp->client_type&1][2],
									cp->client_no,
									NULL,
									NULL);
	tti->appear_pos=AppearPosTable[cp->client_type&1][tip->pos];
	tti->bw=bw;
	tti->command_code=tip->command_code;
	tti->client_no=cp->client_no;
	tti->tr_id=tip->tr_id;
	TCB_Add(TCB_TrainerIn,tti,0);
}

//============================================================================================
/**
 *	HPQ[WINGtFNgZbg
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 */
//============================================================================================
void	CT_HPGaugeInSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,HP_GAUGE_IN_PARAM *hgip)
{
	GAUGE_WORK *gauge;
	
	gauge = &cp->gauge;
	MI_CpuClearFast(&gauge->param, sizeof(GAUGE_SUB_PARAM));
	gauge->bw = bw;
	gauge->client_no = cp->client_no;
	gauge->type = Gauge_TypeGet(cp->client_type);
	gauge->command_code = hgip->command_code;
	gauge->hp = hgip->hp;
	gauge->hpmax = hgip->hpmax;
	gauge->level = hgip->level;
	gauge->sex = hgip->sex;
	gauge->damage = 0;
	gauge->exp = hgip->now_exp;
	gauge->max_exp = hgip->max_exp;
	gauge->sel_mons_no = hgip->sel_mons_no;
	gauge->status = hgip->status;
	gauge->getball = hgip->get_mark;
	gauge->in_wait = hgip->wait;
	
	Gauge_EnableSet(gauge, CATS_ENABLE_FALSE);
	Gauge_PartsDraw(gauge, gauge->hp, GAUGE_DRAW_ALL);

	gauge->tcb = TCB_Add(TCB_HPGaugeIn, gauge, TCBPRI_HP_GAUGE_IN);
}

//============================================================================================
/**
 *	HPQ[WOUTGtFNgZbg
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 */
//============================================================================================
void	CT_HPGaugeOutSet(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	GAUGE_WORK *gauge;
	
	gauge=&cp->gauge;
	MI_CpuClearFast(&gauge->param, sizeof(GAUGE_SUB_PARAM));
	gauge->bw=bw;
	gauge->client_no=cp->client_no;
	gauge->command_code=cp->client_buffer[0];

	Gauge_ScrollEffectSet(gauge, GAUGE_SCROLL_OUT);
	gauge->tcb = TCB_Add(TCB_HPGaugeOut, gauge, TCBPRI_HP_GAUGE_IN);
}

//============================================================================================
/**
 *	R}hIN
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 */
//============================================================================================
void	CT_CommandSelectSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,COMMAND_SELECT_PARAM *csp)
{
	TCB_COMMAND_SELECT	*tcs;
	int					i,j;
	
	tcs=(TCB_COMMAND_SELECT *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_COMMAND_SELECT));
	MI_CpuClearFast(tcs, sizeof(TCB_COMMAND_SELECT));
	
	tcs->seq_no=0;
	tcs->wait=0;
	tcs->bw=bw;
	tcs->command_code=csp->command_code;
	tcs->client_no=cp->client_no;
	tcs->client_type = cp->client_type;
	tcs->gauge = &cp->gauge;
	tcs->sel_mons_no = csp->sel_mons_no;
	
	for(i=0;i<2;i++){
		for(j=0;j<POKEMON_TEMOTI_MAX;j++){
			tcs->status[i][j]=csp->status[i][j];
		}
	}
	
	for(i = 0; i < POKEMON_TEMOTI_MAX; i++){
		tcs->motivation[i] = csp->motivation[i];
	}

	TCB_Add(cp->ui.UI_CommandSelect,tcs,0);
}

//============================================================================================
/**
 *	ZIN
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 */
//============================================================================================
void	CT_WazaSelectSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,WAZA_SELECT_PARAM *wsp)
{
	TCB_WAZA_SELECT	*tws;
	int i;
	
	tws=(TCB_WAZA_SELECT *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_WAZA_SELECT));

	tws->seq_no=0;
	tws->bw=bw;
	tws->command_code=cp->client_buffer[0];
	tws->client_no=cp->client_no;
	tws->gauge = &cp->gauge;
	tws->sel_mons_no = wsp->sel_mons_no;
	for(i = 0; i < WAZA_TEMOTI_MAX; i++){
		tws->wazano[i] = wsp->wazano[i];
		tws->pp[i] = wsp->pp[i];
		tws->ppmax[i] = wsp->ppmax[i];
	}

	TCB_Add(cp->ui.UI_WazaSelect,tws,0);
}

//============================================================================================
/**
 *	UΏۑIN
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 */
//============================================================================================
void	CT_DirSelectSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,DIR_SELECT_PARAM *dsp)
{
	TCB_DIR_SELECT	*tds;
	int i,no,client_set_max;
	u32	fight_type;
	u8	buf[CLIENT_TYPE_MAX];
	
	tds=(TCB_DIR_SELECT *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_DIR_SELECT));

	tds->seq_no=0;
	tds->bw=bw;
	tds->command_code=cp->client_buffer[0];
	tds->client_no=cp->client_no;
	tds->client_type = cp->client_type;
	tds->range=dsp->range;
	tds->gauge = &cp->gauge;
	tds->light_flag = dsp->flag;
	
	BattleClientTypeBufMake(bw,&buf[0]);
	client_set_max=BattleWorkClientSetMaxGet(bw);
	fight_type=BattleWorkFightTypeGet(bw);
	for(i=0;i<client_set_max;i++){
		if(fight_type&FIGHT_TYPE_2vs2){
			no=buf[i]-CLIENT_TYPE_A;
		}
		else{
			no=buf[i];
		}
		tds->dspp[i].sex=dsp->dspp[no].sex;
		tds->dspp[i].exist=dsp->dspp[no].exist;
		tds->dspp[i].sel_mons_no=dsp->dspp[no].sel_mons_no;
	}

	TCB_Add(cp->ui.UI_DirSelect,tds,0);
}


//============================================================================================
/**
 *	IN
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 */
//============================================================================================
void	CT_ItemSelectSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,ITEM_SELECT_PARAM *isp)
{
	TCB_ITEM_SELECT	*tis;
	int				i;

	tis=(TCB_ITEM_SELECT *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_ITEM_SELECT));
	tis->tps=(TCB_POKEMON_SELECT *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_POKEMON_SELECT));

	tis->seq_no=0;
	tis->bw=bw;
	tis->command_code=isp->command_code;
	tis->client_no=cp->client_no;
	tis->client_type = cp->client_type;
	for(i=0;i<CLIENT_MAX;i++){
		tis->tps->sel_mons_no[i]=isp->sel_mons_no[i];
	}

	TCB_Add(cp->ui.UI_ItemSelect,tis,0);
}

//============================================================================================
/**
 *	|PIN
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 */
//============================================================================================
void	CT_PokemonSelectSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,POKEMON_SELECT_PARAM *psp)
{
	TCB_POKEMON_SELECT	*tps;
	int					i;

	tps=(TCB_POKEMON_SELECT *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_POKEMON_SELECT));

	tps->seq_no=0;
	tps->bw=bw;
	tps->command_code=psp->command_code;
	tps->client_no=psp->client_no;
	tps->list_mode=psp->list_mode;
	tps->chg_waza=psp->chg_waza;
	tps->item=0;
	for(i=0;i<CLIENT_MAX;i++){
		tps->sel_mons_no[i]=psp->sel_mons_no[i];
	}

	TCB_Add(cp->ui.UI_PokemonSelect,tps,0);
}

//============================================================================================
/**
 *	Yes/NoIN
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 */
//============================================================================================
void	CT_YesNoSelectSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,YES_NO_SELECT_PARAM *ynsp)
{
	TCB_YES_NO_SELECT	*tyns;

	tyns=(TCB_YES_NO_SELECT *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_YES_NO_SELECT));

	tyns->seq_no=0;
	tyns->bw=bw;
	tyns->command_code=ynsp->command_code;
	tyns->client_no=cp->client_no;
	tyns->gauge = &cp->gauge;
	tyns->msg_id=ynsp->msg_id;
	
	TCB_Add(cp->ui.UI_YesNoSelect,tyns,0);
}

//============================================================================================
/**
 *	A^bNbZ[W\
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 * @param[in]	amp		A^bNbZ[Wpp[^[N\
 */
//============================================================================================
void	CT_AttackMessageSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,ATTACK_MESSAGE_PARAM *amp)
{
	TCB_MESSAGE_WAIT	*tmw;
	GF_BGL_BMPWIN		*win;
	MSGDATA_MANAGER		*msg_m;
	MESSAGE_PARAM		mp;

	win=BattleWorkGF_BGL_BMPWINGet(bw);
	msg_m=BattleWorkAttackMsgGet(bw);

	tmw=(TCB_MESSAGE_WAIT *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_MESSAGE_WAIT));

	tmw->bw=bw;
	tmw->command_code=amp->command_code;
	tmw->client_no=cp->client_no;

	mp.msg_id=ATKMSG_M_000+amp->waza_no*3;
	mp.msg_tag=TAG_NICK;
	mp.msg_para[0]=cp->client_no|(amp->sel_mons_no<<8);

	tmw->msg_index=BattleMSG_Print(bw,win,msg_m,&mp,BATTLE_MSG_WAIT);

	TCB_Add(TCB_MessageWait,tmw,0);
}

//============================================================================================
/**
 *	bZ[W\
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 * @param[in]	mp		bZ[Wpp[^[N\
 */
//============================================================================================
void	CT_MessageSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,MESSAGE_PARAM *mp)
{
	TCB_MESSAGE_WAIT	*tmw;
	GF_BGL_BMPWIN		*win;
	MSGDATA_MANAGER		*msg_m;

	win=BattleWorkGF_BGL_BMPWINGet(bw);
	msg_m=BattleWorkFightMsgGet(bw);

	tmw=(TCB_MESSAGE_WAIT *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_MESSAGE_WAIT));

	tmw->bw=bw;
	tmw->command_code=cp->client_buffer[0];
	tmw->client_no=cp->client_no;

	tmw->msg_index=BattleMSG_Print(bw,win,msg_m,mp,BATTLE_MSG_WAIT);

	TCB_Add(TCB_MessageWait,tmw,0);
}

//============================================================================================
/**
 *	ZGtFNgN
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 * @param[in]	wep		ZGtFNgpp[^[N\
 */
//============================================================================================
void	CT_WazaEffectSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,WAZA_EFFECT_PARAM *wep)
{
	TCB_WAZA_EFFECT	*twe;
	WES_CALL_BTL_EX_PARAM wcbep;
	int i;
	int	callID;
	
	twe=(TCB_WAZA_EFFECT *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_WAZA_EFFECT));

	twe->seq_no=0;
	twe->bw=bw;
	twe->command_code=cp->client_buffer[0];
	twe->client_no=cp->client_no;
	twe->wsp=BattleWorkWE_SYS_PTRGet(bw);

	/// 퓬ɓng
	if(wep->flag==EFFTYPE_WAZA){
		wcbep.eff_arc_id = ARC_WAZA_EFF;
		callID=wep->waza_no;
	}
	else{
		wcbep.eff_arc_id = ARC_WAZA_EFF_SUB;
		callID=wep->data;
	}
	wcbep.bgl  = BattleWorkGF_BGL_INIGet(bw);					///< BGL*
	wcbep.pfd  = BattleWorkPfdGet(bw);							///< PFD*
	for(i = 0; i < CLIENT_MAX; i++){
		wcbep.excp[i] = BattleWorkExChrClientParamGet(bw, i);
		wcbep.mons_no[i] = wep->mons_no[i];
	}
	BattleClientTypeBufMake(bw, &(wcbep.client_type[0]));		///< NCAgType
	BattleSoftSpriteBufMake(bw, &(wcbep.ss[0]));				///< \tgXvCg
	wcbep.fight_type = BattleWorkFightTypeGet(bw);				///< t@Cg^Cv擾
	
	///< wif[^
	wcbep.haikei_data.arc_index = ARC_BATT_BG;
	wcbep.haikei_data.chr_id	= BATTLE_BG00_NCGR_BIN;
	wcbep.haikei_data.pal_id	= BATT_BG00_D_NCLR;
	wcbep.haikei_data.scr_id	= BATTLE_BG00_NSCR_BIN;
	wcbep.haikei_data.pal_start	= 0;
	wcbep.haikei_data.pal_num	= 8;
	
	WES_Call_Ex(twe->wsp, wep, callID, &wcbep);

	TCB_Add(TCB_WazaEffect,twe,0);
}

//============================================================================================
/**
 *	|P_[WuNANVN
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 */
//============================================================================================
void	CT_PokemonBlinkSet(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	TCB_POKEMON_BLINK	*tpb;

	tpb=(TCB_POKEMON_BLINK *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_POKEMON_BLINK));

	tpb->seq_no=0;
	tpb->bw=bw;
	tpb->ss=cp->poke_ss;
	tpb->command_code=cp->client_buffer[0];
	tpb->client_no=cp->client_no;
	tpb->wait=0;

	TCB_Add(TCB_PokemonBlink,tpb,0);

	Snd_SePlay(SEQ_SE_DP_KOUKA_M);
}

//============================================================================================
/**
 *	HPQ[WvZN
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 */
//============================================================================================
void	CT_HPGaugeCalcSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,HP_GAUGE_CALC_PARAM *hgcp)
{
	GAUGE_WORK *gauge;
	
	GF_ASSERT(cp->gauge.cap != NULL);
	
	gauge = &cp->gauge;
	MI_CpuClear8(&gauge->param, sizeof(GAUGE_SUB_PARAM));
	gauge->bw = bw;
	gauge->command_code = hgcp->command_code;
	gauge->client_no = cp->client_no;
	gauge->type = Gauge_TypeGet(cp->client_type);
	gauge->hp = hgcp->hp;
	gauge->hpmax = hgcp->hpmax;
	gauge->damage = hgcp->damage;
	gauge->level = hgcp->level;
	
	if(hgcp->damage == JIBAKU_HP){
		gauge->hp = 0;
		gauge->damage = 0;
	}
	
	gauge->tcb = TCB_Add(TCB_HPGaugeCalc, gauge, TCBPRI_HP_GAUGE_CALC);
}

//============================================================================================
/**
 *	EXPQ[WvZN
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 */
//============================================================================================
void	CT_EXPGaugeCalcSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,EXP_GAUGE_CALC_PARAM *egcp)
{
	GAUGE_WORK *gauge;
	
	GF_ASSERT(cp->gauge.cap != NULL);
	
	gauge = &cp->gauge;
	MI_CpuClear8(&gauge->param, sizeof(GAUGE_SUB_PARAM));
	gauge->bw = bw;
	gauge->command_code = egcp->command_code;
	gauge->client_no = cp->client_no;

	gauge->exp = egcp->now_exp;
	gauge->max_exp = egcp->max_exp;
	gauge->add_exp = egcp->next_exp - gauge->exp;
	
	if(cp->client_type == CLIENT_TYPE_AA){
		gauge->tcb = TCB_Add(TCB_EXPGaugeCalc, gauge, TCBPRI_HP_GAUGE_CALC);
		return;
	}
	else{
		SCIO_ServerQueClear(gauge->bw, gauge->client_no, gauge->command_code);
	}
}

//============================================================================================
/**
 *	CGtFNgN
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 */
//============================================================================================
void	CT_KizetsuEffectSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,KIZETSU_EFFECT_PARAM *kep)
{
	TCB_KIZETSU_EFFECT	*tke;

	tke=(TCB_KIZETSU_EFFECT *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_KIZETSU_EFFECT));

	if(cp->client_type&CLIENT_ENEMY_FLAG){
		tke->dir=PARA_FRONT;
	}
	else{
		tke->dir=PARA_BACK;
	}

	tke->seq_no=0;
	tke->bw=bw;
	tke->command_code=kep->command_code;
	tke->client_no=cp->client_no;
	tke->ss=cp->poke_ss;
	tke->monsno=kep->monsno;
	tke->sex=kep->sex;

	TCB_Add(TCB_KizetsuEffect,tke,0);
}

//============================================================================================
/**
 *	w肳ꂽSE炷
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 */
//============================================================================================
void	CT_SePlaySet(BATTLE_WORK *bw,CLIENT_PARAM *cp,SE_PLAY_PARAM *spp)
{
	SCIO_ServerQueClear(bw,cp->client_no,spp->command_code);
	Snd_SePlay(spp->se_no);
}

//============================================================================================
/**
 *	ʃtF[hAEgZbg
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 */
//============================================================================================
void	CT_FadeOutSet(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	TCB_FADE_OUT	*tfo;

	tfo=(TCB_FADE_OUT *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_FADE_OUT));

	tfo->seq_no=0;
	tfo->bw=bw;
	tfo->command_code=cp->client_buffer[0];
	tfo->client_no=cp->client_no;

	TCB_Add(TCB_FadeOut,tfo,0);
}

//============================================================================================
/**
 *	HPQ[WɏԈُACRZbg
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 */
//============================================================================================
void	CT_HPGaugeStatusSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,HP_GAUGE_STATUS_SET_PARAM *hgssp)
{
	GF_ASSERT(cp->gauge.cap != NULL);
	
	cp->gauge.status = hgssp->status;
	Gauge_PartsDraw(&cp->gauge, cp->gauge.hp, GAUGE_DRAW_STATUS);
	SCIO_ServerQueClear(bw,cp->client_no,hgssp->command_code);
}

//============================================================================================
/**
 *	g[i[bZ[W\
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 */
//============================================================================================
void	CT_TrainerMessageSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,TRAINER_MESSAGE_PARAM *tmp)
{
	TCB_MESSAGE_WAIT	*tmw;
	GF_BGL_BMPWIN		*win;
	int					tr_id;

	win=BattleWorkGF_BGL_BMPWINGet(bw);
	tr_id=BattleWorkTrainerIDGet(bw,cp->client_no);

	tmw=(TCB_MESSAGE_WAIT *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_MESSAGE_WAIT));

	tmw->bw=bw;
	tmw->command_code=tmp->command_code;
	tmw->client_no=cp->client_no;

	tmw->msg_index=TrainerMSG_Print(bw,win,tr_id,tmp->type,BATTLE_MSG_WAIT);

	TCB_Add(TCB_MessageWait,tmw,0);
}

//============================================================================================
/**
 *	߂bZ[W\
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 */
//============================================================================================
void	CT_ModosuMessageSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,MODOSU_MESSAGE_PARAM *mmp)
{
	TCB_MESSAGE_WAIT	*tmw;
	GF_BGL_BMPWIN		*win;
	MSGDATA_MANAGER		*msg_m;
	MESSAGE_PARAM		mp;

	CT_ModosuMessageParamMake(bw,cp,mmp,&mp);

	win=BattleWorkGF_BGL_BMPWINGet(bw);
	msg_m=BattleWorkFightMsgGet(bw);

	tmw=(TCB_MESSAGE_WAIT *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_MESSAGE_WAIT));

	tmw->bw=bw;
	tmw->command_code=mmp->command_code;
	tmw->client_no=cp->client_no;

	tmw->msg_index=BattleMSG_Print(bw,win,msg_m,&mp,BATTLE_MSG_WAIT);

	TCB_Add(TCB_MessageWait,tmw,0);
}

//============================================================================================
/**
 *	JobZ[W\
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 */
//============================================================================================
void	CT_KuridasuMessageSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,KURIDASU_MESSAGE_PARAM *kmp)
{
	TCB_MESSAGE_WAIT	*tmw;
	GF_BGL_BMPWIN		*win;
	MSGDATA_MANAGER		*msg_m;
	MESSAGE_PARAM		mp;

	CT_KuridasuMessageParamMake(bw,cp,kmp,&mp);

	win=BattleWorkGF_BGL_BMPWINGet(bw);
	msg_m=BattleWorkFightMsgGet(bw);

	tmw=(TCB_MESSAGE_WAIT *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_MESSAGE_WAIT));

	tmw->bw=bw;
	tmw->command_code=kmp->command_code;
	tmw->client_no=cp->client_no;

	tmw->msg_index=BattleMSG_Print(bw,win,msg_m,&mp,BATTLE_MSG_WAIT);

	TCB_Add(TCB_MessageWait,tmw,0);
}

//============================================================================================
/**
 *	A[gbZ[W\
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 */
//============================================================================================
void	CT_AlertMessageSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,ALERT_MESSAGE_PARAM *amp)
{
	TCB_ALERT_MESSAGE_WAIT	*tamw;
	GF_BGL_BMPWIN			*win;
	MSGDATA_MANAGER			*msg_m;

	//A[gbZ[Ŵ͎ݕ\
	if((cp->client_type&CLIENT_ENEMY_FLAG)==0){
		win=BattleWorkGF_BGL_BMPWINGet(bw);
		msg_m=BattleWorkFightMsgGet(bw);

		tamw=(TCB_ALERT_MESSAGE_WAIT *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_ALERT_MESSAGE_WAIT));

		tamw->bw=bw;
		tamw->command_code=amp->command_code;
		tamw->client_no=cp->client_no;
		tamw->seq_no=0;

		tamw->msg_index=BattleMSG_Print(bw,win,msg_m,&amp->mp,BATTLE_MSG_WAIT);

		TCB_Add(TCB_AlertMessageWait,tamw,0);
	}
	else{
		SCIO_AlertMessageEndSet(bw,cp->client_no);
		SCIO_ServerQueClear(bw,cp->client_no,amp->command_code);
	}
}

//============================================================================================
/**
 *	HPQ[Wĕ`
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	cp		NCAgpp[^[N\
 */
//============================================================================================
void	CT_HPGaugeRefreshSet(BATTLE_WORK *bw,CLIENT_PARAM *cp,HP_GAUGE_REFRESH_PARAM *hgrp)
{
	GAUGE_WORK *gauge;
	
	gauge = &cp->gauge;
	MI_CpuClearFast(&gauge->param, sizeof(GAUGE_SUB_PARAM));
	gauge->bw = bw;
	gauge->client_no = cp->client_no;
	gauge->type = Gauge_TypeGet(cp->client_type);
	gauge->command_code = hgrp->command_code;
	gauge->hp = hgrp->hp;
	gauge->hpmax = hgrp->hpmax;
	gauge->level = hgrp->level;
	gauge->sex = hgrp->sex;
	gauge->damage = 0;
	gauge->exp = hgrp->now_exp;
	gauge->max_exp = hgrp->max_exp;
	gauge->sel_mons_no = hgrp->sel_mons_no;
	gauge->status = hgrp->status;
	gauge->getball = hgrp->get_mark;

	Gauge_PartsDraw(gauge, gauge->hp, GAUGE_DRAW_ALL ^ GAUGE_DRAW_EXP);

	SCIO_ServerQueClear(gauge->bw, gauge->client_no, gauge->command_code);
}

//-----------------------------------------------------------------------------
//		TCBTu[`Q
//-----------------------------------------------------------------------------
//============================================================================================
/**
 *	GJEg|PV[PXpTCB
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_PokemonEncount(TCB_PTR tcb,void *work)
{
	TCB_POKEMON_ENCOUNT	*tpe=(TCB_POKEMON_ENCOUNT *)work;
	s16					x,y;

	switch(tpe->seq_no){
	case 0:
		if(tpe->dir==PARA_FRONT){
			SoftSpriteParaCalc(tpe->ss,SS_PARA_POS_X,ENCOUNT_SPEED);
			if((tpe->client_type==CLIENT_TYPE_BB)||(tpe->client_type==CLIENT_TYPE_B)){
				CATS_ObjectPosGetCap(tpe->gw->cap,&x,&y);
				if(x<GROUND_ENEMY_X){
					CATS_ObjectPosMoveCap(tpe->gw->cap,ENCOUNT_SPEED,0);
				}
				else{
					CATS_ObjectPosSetCap(tpe->gw->cap,GROUND_ENEMY_X,GROUND_ENEMY_Y);
				}
			}
			if(SoftSpriteParaGet(tpe->ss,SS_PARA_POS_X)>=tpe->appear_pos){
				if(tpe->mons_no==MONSNO_MIMITTO){
					SoftSpriteAnimeSet(tpe->ss,1);
				}
				PokeAnm_SetPokemonAnime( NULL, tpe->ss, tpe->mons_no, 0);

				Snd_PMVoicePlayEx(tpe->voice,tpe->mons_no,POKE_VOICE_PAN_FRONT,POKE_APPEAR_NORMAL_VOL,HEAPID_BATTLE);
				SoftSpriteParaSet(tpe->ss,SS_PARA_POS_X,tpe->appear_pos);
				if((tpe->client_type==CLIENT_TYPE_BB)||(tpe->client_type==CLIENT_TYPE_B)){
					CATS_ObjectPosSetCap(tpe->gw->cap,GROUND_ENEMY_X,GROUND_ENEMY_Y);
				}
				tpe->seq_no++;
			}
		}
		else{
			SoftSpriteParaCalc(tpe->ss,SS_PARA_POS_X,-ENCOUNT_SPEED);
			if((tpe->client_type==CLIENT_TYPE_AA)||(tpe->client_type==CLIENT_TYPE_A)){
				CATS_ObjectPosGetCap(tpe->gw->cap,&x,&y);
				if(x>GROUND_MINE_X){
					CATS_ObjectPosMoveCap(tpe->gw->cap,-ENCOUNT_SPEED,0);
				}
				else{
					CATS_ObjectPosSetCap(tpe->gw->cap,GROUND_MINE_X,GROUND_MINE_Y);
				}
			}
			if(SoftSpriteParaGet(tpe->ss,SS_PARA_POS_X)<=tpe->appear_pos){
				Snd_PMVoicePlayEx(tpe->voice,tpe->mons_no,POKE_VOICE_PAN_BACK,POKE_APPEAR_NORMAL_VOL,HEAPID_BATTLE);
				SoftSpriteParaSet(tpe->ss,SS_PARA_POS_X,tpe->appear_pos);
				if((tpe->client_type==CLIENT_TYPE_AA)||(tpe->client_type==CLIENT_TYPE_A)){
					CATS_ObjectPosSetCap(tpe->gw->cap,GROUND_MINE_X,GROUND_MINE_Y);
				}
				tpe->seq_no++;
			}
		}
		break;
	case 1:
		SCIO_ServerQueClear(tpe->bw,tpe->client_no,tpe->command_code);
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		break;
	}
}

//============================================================================================
/**
 *	|PoGtFNg{[GtFNge[u
 */
//============================================================================================

static	const	u8	BallMoveEffectTable[]={
	EBMT_THROW_C,		///< 1C̎
	EBMT_STAY_BB,
	EBMT_THROW_L,		///< ɓ
	EBMT_STAY_B,
	EBMT_THROW_R,		///< Eɓ
	EBMT_STAY_D,
};

//============================================================================================
/**
 *	|PoGtFNgV[PXpTCB
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_PokemonAppear(TCB_PTR tcb,void *work)
{
	TCB_POKEMON_APPEAR	*tpa=(TCB_POKEMON_APPEAR *)work;

	switch(tpa->seq_no){
	case 0:
		{
			TBALL_MOVE_DATA bmd;

			bmd.type=BallMoveEffectTable[tpa->client_type];
			bmd.heap_id=HEAPID_BATTLE;
			bmd.mode=EBMM_THROW;
			bmd.id=tpa->client_no;
			bmd.csp=BattleWorkCATS_SYS_PTRGet(tpa->bw);
			bmd.pfd=BattleWorkPfdGet(tpa->bw);

			tpa->bms=BM_Init(&bmd);
			tpa->seq_no++;
		}
		break;
	case 1:
		if(BM_EndCheck(tpa->bms)==FALSE){
			BM_Delete(tpa->bms);
			{
				TBALL_CUSTOM_PARAM bcp = { 0 };
				bcp.client_type = tpa->client_type;			
				tpa->bes = BallEffect_Init(HEAPID_BATTLE, &bcp);
				BallEffect_ExecutedEz(tpa->bes);
				tpa->seq_no++;
			}
		}
		break;
	case 2:
		if((SoftSpriteParaGet(tpa->ss,SS_PARA_AFF_X)==AFF_APPEAR_X_B)
		&&(BallEffect_EndCheck(tpa->bes) == FALSE)){
			if((tpa->mons_no==MONSNO_MIMITTO)&&(tpa->dir=PARA_FRONT)){
				SoftSpriteAnimeSet(tpa->ss,1);
			}
			Snd_PMVoicePlayEx(tpa->voice,tpa->mons_no,POKE_VOICE_PAN_FRONT,POKE_APPEAR_NORMAL_VOL,HEAPID_BATTLE);
			tpa->seq_no = 4;
		}
		else if(SoftSpriteParaGet(tpa->ss,SS_PARA_AFF_X)>=AFF_APPEAR_X_B){
			SoftSpriteParaSet(tpa->ss,SS_PARA_AFF_X,AFF_APPEAR_X_B);
			SoftSpriteParaSet(tpa->ss,SS_PARA_AFF_Y,AFF_APPEAR_Y_B);	
			if((tpa->mons_no==MONSNO_MIMITTO)&&(tpa->dir=PARA_FRONT)){
				SoftSpriteAnimeSet(tpa->ss,1);
			}
			Snd_PMVoicePlayEx(tpa->voice,tpa->mons_no,POKE_VOICE_PAN_BACK,POKE_APPEAR_NORMAL_VOL,HEAPID_BATTLE);
			tpa->seq_no = 3;
		}
		else {
			SoftSpriteParaCalc(tpa->ss,SS_PARA_AFF_X,AFF_SPEED);
			SoftSpriteParaCalc(tpa->ss,SS_PARA_AFF_Y,AFF_SPEED);
			SoftSpriteOYCalc(tpa->ss,tpa->height);
		}
		break;
	case 3:
		if(BallEffect_EndCheck(tpa->bes) == FALSE){
			tpa->seq_no = 4;
		}
		break;
	case 4:
		SCIO_ServerQueClear(tpa->bw,tpa->client_no,tpa->command_code);
		BallEffect_FreeMemory(tpa->bes);
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		break;
	}
}

//============================================================================================
/**
 *	|P߂GtFNgV[PXpTCB
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_PokemonReturn(TCB_PTR tcb,void *work)
{
	TCB_POKEMON_RETURN	*tpr=(TCB_POKEMON_RETURN *)work;

	switch(tpr->seq_no){
	case 0:
		SoftSpriteParaCalc(tpr->ss,SS_PARA_AFF_X,-AFF_SPEED);
		SoftSpriteParaCalc(tpr->ss,SS_PARA_AFF_Y,-AFF_SPEED);
		SoftSpriteOYCalc(tpr->ss,tpr->height);
		if(SoftSpriteParaGet(tpr->ss,SS_PARA_AFF_X)<=AFF_APPEAR_X_S){
			SoftSpriteDel(tpr->ss);
			tpr->seq_no++;
		}
		break;
	case 1:
		SCIO_ServerQueClear(tpr->bw,tpr->client_no,tpr->command_code);
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		break;
	}
}

//============================================================================================
/**
 *	GJEgg[i[V[PXpTCB
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_TrainerEncount(TCB_PTR tcb,void *work)
{
	TCB_TRAINER_ENCOUNT	*tte=(TCB_TRAINER_ENCOUNT *)work;
	s16					x,y;

	switch(tte->seq_no){
	case 0:
		if(tte->dir==PARA_FRONT){
			SoftSpriteParaCalc(tte->ss,SS_PARA_POS_X,ENCOUNT_SPEED);
			if((tte->client_type==CLIENT_TYPE_BB)||(tte->client_type==CLIENT_TYPE_B)){
				CATS_ObjectPosGetCap(tte->gw->cap,&x,&y);
				if(x<GROUND_ENEMY_X){
					CATS_ObjectPosMoveCap(tte->gw->cap,ENCOUNT_SPEED,0);
				}
				else{
					CATS_ObjectPosSetCap(tte->gw->cap,GROUND_ENEMY_X,GROUND_ENEMY_Y);
				}
			}
			if(SoftSpriteParaGet(tte->ss,SS_PARA_POS_X)>=tte->appear_pos){
				SoftSpriteParaSet(tte->ss,SS_PARA_POS_X,tte->appear_pos);
				if((tte->client_type==CLIENT_TYPE_BB)||(tte->client_type==CLIENT_TYPE_B)){
					CATS_ObjectPosSetCap(tte->gw->cap,GROUND_ENEMY_X,GROUND_ENEMY_Y);
				}
				tte->seq_no++;
			}
		}
		else{
			SoftSpriteParaCalc(tte->ss,SS_PARA_POS_X,-ENCOUNT_SPEED);
			if((tte->client_type==CLIENT_TYPE_AA)||(tte->client_type==CLIENT_TYPE_A)){
				CATS_ObjectPosGetCap(tte->gw->cap,&x,&y);
				if(x>GROUND_MINE_X){
					CATS_ObjectPosMoveCap(tte->gw->cap,-ENCOUNT_SPEED,0);
				}
				else{
					CATS_ObjectPosSetCap(tte->gw->cap,GROUND_MINE_X,GROUND_MINE_Y);
				}
			}
			if(SoftSpriteParaGet(tte->ss,SS_PARA_POS_X)<=tte->appear_pos){
				SoftSpriteParaSet(tte->ss,SS_PARA_POS_X,tte->appear_pos);
				if((tte->client_type==CLIENT_TYPE_AA)||(tte->client_type==CLIENT_TYPE_A)){
					CATS_ObjectPosSetCap(tte->gw->cap,GROUND_MINE_X,GROUND_MINE_Y);
				}
				tte->seq_no++;
			}
		}
		break;
	case 1:
		SCIO_ServerQueClear(tte->bw,tte->client_no,tte->command_code);
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		break;
	}
}

//============================================================================================
/**
 *	g[i[ʊOGtFNgV[PXpTCB
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_TrainerOut(TCB_PTR tcb,void *work)
{
	TCB_TRAINER_OUT	*tto=(TCB_TRAINER_OUT *)work;

	switch(tto->seq_no){
	case 0:
		if(tto->dir==PARA_FRONT){
			SoftSpriteParaCalc(tto->ss,SS_PARA_POS_X,ENCOUNT_SPEED);
			if(SoftSpriteParaGet(tto->ss,SS_PARA_POS_X)>=FRAME_OUT_X_R){
				tto->seq_no++;
			}
		}
		else{
			SoftSpriteParaCalc(tto->ss,SS_PARA_POS_X,-ENCOUNT_SPEED);
			if(SoftSpriteParaGet(tto->ss,SS_PARA_POS_X)<=FRAME_OUT_X_L){
				tto->seq_no++;
			}
		}
		if(tto->seq_no){
			SoftSpriteDel(tto->ss);
		}
		break;
	case 1:
		SCIO_ServerQueClear(tto->bw,tto->client_no,tto->command_code);
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		break;
	}
}

//============================================================================================
/**
 *	g[i[ʓGtFNgV[PXpTCB
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_TrainerIn(TCB_PTR tcb,void *work)
{
	TCB_TRAINER_IN	*tti=(TCB_TRAINER_IN *)work;

	switch(tti->seq_no){
	case 0:
		if(tti->dir==PARA_BACK){
			SoftSpriteParaCalc(tti->ss,SS_PARA_POS_X,ENCOUNT_SPEED);
			if(SoftSpriteParaGet(tti->ss,SS_PARA_POS_X)>=tti->appear_pos){
				SoftSpriteParaSet(tti->ss,SS_PARA_POS_X,tti->appear_pos);
				tti->seq_no++;
			}
		}
		else{
			SoftSpriteParaCalc(tti->ss,SS_PARA_POS_X,-ENCOUNT_SPEED);
			if(SoftSpriteParaGet(tti->ss,SS_PARA_POS_X)<=tti->appear_pos){
				SoftSpriteParaSet(tti->ss,SS_PARA_POS_X,tti->appear_pos);
				tti->seq_no++;
			}
		}
		break;
	case 1:
		SCIO_ServerQueClear(tti->bw,tti->client_no,tti->command_code);
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		break;
	}
}

//============================================================================================
/**
 *	HPQ[WINGtFNgV[PXpTCB
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_HPGaugeIn(TCB_PTR tcb,void *work)
{
	GAUGE_WORK *gauge = work;
	
	switch(gauge->param.seq_no){
	case 0:
		if(gauge->in_wait > 0){
			gauge->in_wait--;
			break;
		}

		Gauge_ScrollEffectSet(gauge, GAUGE_SCROLL_IN);
		Gauge_EnableSet(gauge, CATS_ENABLE_TRUE);
		gauge->param.seq_no++;
		break;
	case 1:
		if(gauge->eff_wait_in_out == TRUE){
			gauge->param.seq_no++;
		}
		break;
	default:
		SCIO_ServerQueClear(gauge->bw, gauge->client_no, gauge->command_code);
		gauge->tcb = NULL;
		TCB_Delete(tcb);
		break;
	}
}

//============================================================================================
/**
 *	HPQ[WINGtFNgV[PXpTCB
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_HPGaugeOut(TCB_PTR tcb,void *work)
{
	GAUGE_WORK *gauge = work;
	
	switch(gauge->param.seq_no){
	case 0:
		if(gauge->eff_wait_in_out == TRUE){
			gauge->param.seq_no++;
		}
		break;
	default:
		SCIO_ServerQueClear(gauge->bw, gauge->client_no, gauge->command_code);
		gauge->tcb = NULL;
		TCB_Delete(tcb);
		//Gauge_ActorResourceDel(gauge);
		Gauge_EnableSet(gauge, CATS_ENABLE_FALSE);
		break;
	}
}

//============================================================================================
/**
 *	R}hITCBpV[PXio[
 */
//============================================================================================
enum{	//V[PXԍ
	CSSEQ_COMMAND_INIT,
	CSSEQ_COMMAND_INIT_WAIT,
	
	CSSEQ_COMMAND_SELECT_INIT,
	CSSEQ_COMMAND_SELECT,
	CSSEQ_COMMAND_SELECT_EFFWAIT,
	
	CSSEQ_FINISH,
};

//============================================================================================
/**
 *	R}hITCBivC[pj
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_CommandSelect(TCB_PTR tcb,void *work)
{
	TCB_COMMAND_SELECT	*tcs;
	GF_BGL_INI	*bgl;
	BI_PARAM_PTR bip;
	CLIENT_PARAM		*cp;
	u32					fight_type;
	
	tcs=(TCB_COMMAND_SELECT *)work;
	bgl=BattleWorkGF_BGL_INIGet(tcs->bw);
	bip = BattleWorkGF_BGL_BIPGet(tcs->bw);
	cp=BattleWorkClientParamGet(tcs->bw,tcs->client_no);
	fight_type=BattleWorkFightTypeGet(tcs->bw);
	
	switch(tcs->seq_no){
	case CSSEQ_COMMAND_INIT:
		{
			GF_BGL_BMPWIN		*win=BattleWorkGF_BGL_BMPWINGet(tcs->bw);
			MSGDATA_MANAGER		*msg_m;
			MESSAGE_PARAM		mp;

			msg_m=BattleWorkFightMsgGet(tcs->bw);
			mp.msg_tag=TAG_NICK;
			mp.msg_para[0]=tcs->client_no|(tcs->sel_mons_no<<8);
			mp.msg_id=DousuruMsg;
			BattleMSG_Print(tcs->bw,win,msg_m,&mp,0);
		}
		tcs->seq_no = CSSEQ_COMMAND_INIT_WAIT;
		break;
	case CSSEQ_COMMAND_INIT_WAIT:
		Gauge_AnimeStart(tcs->gauge);
	case CSSEQ_COMMAND_SELECT_INIT:		///<ʍ쐬
		{
			int client_type = tcs->client_type;
			
			if(cp->bip_flag){
				BINPUT_BackFadeReq(bip, BINPUT_BACKFADE_DARK);
				if(BattleWorkBattleStatusFlagGet(tcs->bw) & BATTLE_STATUS_FLAG_FIRST_BATTLE){
					BINPUT_CreateBG(bip, BINPUT_TYPE_FIGHTONLY, FALSE, &client_type);
				}
				else if(client_type == CLIENT_TYPE_C 
						&& (BattleWorkFightTypeGet(tcs->bw) & FIGHT_TYPE_MULTI) == 0){
					BINPUT_CreateBG(bip, BINPUT_TYPE_A_2, FALSE, &client_type);
				}
				else{
					BINPUT_CreateBG(bip, BINPUT_TYPE_A, FALSE, &client_type);
				}
			}
			else{
				if(BattleWorkBattleStatusFlagGet(tcs->bw) & BATTLE_STATUS_FLAG_FIRST_BATTLE){
					BINPUT_CreateBG(bip, BINPUT_COMMAND_IN_FIGHTONLY, FALSE, &client_type);
				}
				else if(client_type != CLIENT_TYPE_C){
					BINPUT_CreateBG(bip, BINPUT_COMMAND_IN, FALSE, &client_type);
				}
				else{
					BINPUT_CreateBG(bip, BINPUT_COMMAND_IN_2, FALSE, &client_type);
				}
				cp->bip_flag=1;
			}
			BINPUT_TemotiMotivationParamSet(bip, tcs->motivation);
			BINPUT_StockBallAnimeUpdate(bip, 
				tcs->status[POKEPARTY_MINE], tcs->status[POKEPARTY_ENEMY]);
			BINPUT_StockBallON(bip);
		}
		tcs->seq_no = CSSEQ_COMMAND_SELECT;
		break;
	case CSSEQ_COMMAND_SELECT:

#ifdef PM_DEBUG

		//ZGtFNgfobOj[
		if (sys.trg & PAD_BUTTON_START){
			DT_MenuInit(HEAPID_BATTLE, tcs->bw, tcb, TCB_CommandSelect);
			return;
		}

		//HP\l؂ւ
		if(sys.trg & PAD_BUTTON_SELECT){
			CLIENT_PARAM	*cp;
			int i;
			for(i=0;i<BattleWorkClientSetMaxGet(tcs->bw);i++){
				cp=BattleWorkClientParamGet(tcs->bw,i);
				Gauge_DebugHPPutFlagFlip(&cp->gauge);
				Gauge_PartsDraw(&cp->gauge, cp->gauge.hp, GAUGE_DRAW_ALL);
			}
		}
#endif

		tcs->tp_ret = BINPUT_TouchCheck(bip);
		if(tcs->tp_ret != RECT_HIT_NONE){
			tcs->wait=TP_WAIT;
			Snd_SePlay(SEQ_SE_DP_DECIDE);
			tcs->seq_no = CSSEQ_COMMAND_SELECT_EFFWAIT;
		}
		break;
	case CSSEQ_COMMAND_SELECT_EFFWAIT:
		if(BINPUT_EffectEndCheck(bip) == TRUE){
			switch(tcs->tp_ret){
			case SELECT_FIGHT_COMMAND:
				break;
			case SELECT_ITEM_COMMAND:
				BINPUT_BackFadeReq(bip, BINPUT_BACKFADE_LIGHT);
				Gauge_AnimeStop(tcs->gauge);
				break;
			case SELECT_POKEMON_COMMAND:
				BINPUT_BackFadeReq(bip, BINPUT_BACKFADE_LIGHT);
				Gauge_AnimeStop(tcs->gauge);
				break;
			case SELECT_ESCAPE_COMMAND:
#ifdef PM_DEBUG
				if(sys.cont&PAD_BUTTON_R){
					tcs->tp_ret = SELECT_DEBUG_ESCAPE_COMMAND;
				}
				else if((tcs->client_type == CLIENT_TYPE_C)&&
					   ((fight_type&FIGHT_TYPE_MULTI)==0)){
					tcs->tp_ret = SELECT_CANCEL;
				}
#else
				if((tcs->client_type == CLIENT_TYPE_C)&&
				  ((fight_type&FIGHT_TYPE_MULTI)==0)){
					tcs->tp_ret = SELECT_CANCEL;
				}
#endif
				break;
			default:
				GF_ASSERT(0 && "R}h삪ݒ肳Ă܂\n");
				break;
			}
			
			BINPUT_StockBallOFF(bip);
			tcs->seq_no = CSSEQ_FINISH;
		}
		break;
	case CSSEQ_FINISH:
		if(BINPUT_BackFadeExeCheck(bip) == TRUE){
			SCIO_CommandSelectReturnSet(tcs->bw,tcs->client_no,tcs->tp_ret);
			SCIO_ServerQueClear(tcs->bw,tcs->client_no,tcs->command_code);
			sys_FreeMemoryEz(work);
			TCB_Delete(tcb);
		}
		break;
	}
}

//============================================================================================
/**
 *	R}hITCBiAIpj
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_CommandSelectAI(TCB_PTR tcb,void *work)
{
	TCB_COMMAND_SELECT	*tcs=(TCB_COMMAND_SELECT *)work;

	SCIO_CommandSelectReturnSet(tcs->bw,tcs->client_no,SELECT_FIGHT_COMMAND);

	SCIO_ServerQueClear(tcs->bw,tcs->client_no,tcs->command_code);
	sys_FreeMemoryEz(work);
	TCB_Delete(tcb);
}

//============================================================================================
/**
 *	R}hITCBiʐMpj
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_CommandSelectSIO(TCB_PTR tcb,void *work)
{
	sys_FreeMemoryEz(work);
	TCB_Delete(tcb);
}

//============================================================================================
/**
 *	ZITCBivC[pj
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_WazaSelect(TCB_PTR tcb,void *work)
{
	TCB_WAZA_SELECT	*tws=(TCB_WAZA_SELECT *)work;
	GF_BGL_INI		*bgl=BattleWorkGF_BGL_INIGet(tws->bw);
	BI_PARAM_PTR bip;
	
	bip = BattleWorkGF_BGL_BIPGet(tws->bw);

	switch(tws->seq_no){
	case 0:		///<ʍ쐬
		{
			GF_BGL_BMPWIN		*win=BattleWorkGF_BGL_BMPWINGet(tws->bw);
			MSGDATA_MANAGER		*msg_m;
			MESSAGE_PARAM		mp;

			msg_m=BattleWorkFightMsgGet(tws->bw);
			mp.msg_tag=TAG_NICK;
			mp.msg_para[0]=tws->client_no|(tws->sel_mons_no<<8);
			mp.msg_id=DousuruMsg;
			BattleMSG_Print(tws->bw,win,msg_m,&mp,0);
		}
		BINPUT_StockBallOFF(bip);
		BINPUT_CreateBG(bip, BINPUT_TYPE_B, FALSE, tws);
		tws->seq_no++;
		break;
	case 1:
		tws->tp_ret = BINPUT_TouchCheck(bip);
		if(tws->tp_ret!=RECT_HIT_NONE){
			Snd_SePlay(SEQ_SE_DP_DECIDE);
			tws->seq_no++;
		}
		break;
	case 2:
		if(BINPUT_EffectEndCheck(bip) == TRUE){
			if(tws->tp_ret != SELECT_CANCEL){
				if((BattleWorkFightTypeGet(tws->bw) & FIGHT_TYPE_2vs2) == 0){
					BINPUT_BackFadeReq(bip, BINPUT_BACKFADE_LIGHT);
					Gauge_AnimeStop(tws->gauge);
				}
			}
			SCIO_WazaSelectReturnSet(tws->bw,tws->client_no,tws->tp_ret);
			tws->seq_no++;
		}
		break;
	case 3:
		BINPUT_CreateBG(bip, BINPUT_TYPE_WALL, FALSE, NULL);
		tws->seq_no++;
		//break;
	default:
		if(BINPUT_BackFadeExeCheck(bip) == TRUE){
			SCIO_ServerQueClear(tws->bw,tws->client_no,tws->command_code);
			sys_FreeMemoryEz(work);
			TCB_Delete(tcb);
		}
		break;
	}
}

//============================================================================================
/**
 *	ZITCBiAIpj
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_WazaSelectAI(TCB_PTR tcb,void *work)
{
	TCB_WAZA_SELECT	*tws=(TCB_WAZA_SELECT *)work;
	int	tp_ret;

	do{
		tp_ret=(gf_rand()%4)+1;
	}while(tws->wazano[tp_ret-1]==0);			//wazano

	SCIO_WazaSelectReturnSet(tws->bw,tws->client_no,tp_ret);

	SCIO_ServerQueClear(tws->bw,tws->client_no,tws->command_code);
	sys_FreeMemoryEz(work);
	TCB_Delete(tcb);
}

//============================================================================================
/**
 *	ZITCBiʐMpj
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_WazaSelectSIO(TCB_PTR tcb,void *work)
{
	sys_FreeMemoryEz(work);
	TCB_Delete(tcb);
}

//============================================================================================
/**
 *	UΏۑITCBivC[pj
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_DirSelect(TCB_PTR tcb,void *work)
{
	TCB_DIR_SELECT	*tds=(TCB_DIR_SELECT *)work;
	GF_BGL_INI		*bgl=BattleWorkGF_BGL_INIGet(tds->bw);
	BI_PARAM_PTR bip;
	
	bip = BattleWorkGF_BGL_BIPGet(tds->bw);

	switch(tds->seq_no){
	case 0:		///<ʍ쐬
		{
			int bg_type;
			
			bg_type = BINPUT_RangeBgTypeGet(tds->range, tds->client_type);
			BINPUT_CreateBG(bip, bg_type, FALSE, tds);
		}
		tds->seq_no++;
		break;
	case 1:
		tds->tp_ret = BINPUT_TouchCheck(bip);
		if(tds->tp_ret != RECT_HIT_NONE){
			Snd_SePlay(SEQ_SE_DP_DECIDE);
			tds->seq_no++;
		}
		break;
	case 2:
		if(BINPUT_EffectEndCheck(bip) == TRUE){
			if(tds->tp_ret != SELECT_CANCEL){
				Gauge_AnimeStop(tds->gauge);
				if(tds->light_flag == TRUE){
					BINPUT_BackFadeReq(bip, BINPUT_BACKFADE_LIGHT);
				}
			}
			tds->seq_no++;
		}
		break;
	case 3:
		BINPUT_CreateBG(bip, BINPUT_TYPE_WALL, FALSE, NULL);
		tds->seq_no++;
		//break;
	default:
		if(BINPUT_BackFadeExeCheck(bip) == TRUE){
			{
				u8	buf[CLIENT_TYPE_MAX];
				u32	fight_type;
				int	ret;

				ret=tds->tp_ret;
				fight_type=BattleWorkFightTypeGet(tds->bw);

				if(ret != SELECT_CANCEL){
					BattleClientNoBufMake(tds->bw,&buf[0]);
					if(fight_type&FIGHT_TYPE_2vs2){
						ret=buf[CLIENT_TYPE_A+(tds->tp_ret-1)]+1;
					}
					else{
						ret=buf[CLIENT_TYPE_AA+(tds->tp_ret-1)]+1;
					}
				}

				SCIO_DirSelectReturnSet(tds->bw,tds->client_no,ret);
				SCIO_ServerQueClear(tds->bw,tds->client_no,tds->command_code);
				sys_FreeMemoryEz(work);
				TCB_Delete(tcb);
			}
		}
		break;
	}
}

//============================================================================================
/**
 *	UΏۑITCBiAIpj
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_DirSelectAI(TCB_PTR tcb,void *work)
{
	TCB_DIR_SELECT	*tds=(TCB_DIR_SELECT *)work;
	int	tp_ret;

	if(tds->range&RANGE_MINE){
		tp_ret=tds->client_no+1;
	}
	else{
		tp_ret=ST_ServerDirClientGet(tds->bw,BattleWorkServerParamGet(tds->bw),tds->client_no)+1;
		GF_ASSERT_MSG(tp_ret<5,"tp_retsł:%d\n",tp_ret);
	}

	SCIO_DirSelectReturnSet(tds->bw,tds->client_no,tp_ret);

	SCIO_ServerQueClear(tds->bw,tds->client_no,tds->command_code);
	sys_FreeMemoryEz(work);
	TCB_Delete(tcb);
}

//============================================================================================
/**
 *	UΏۑITCBiʐMpj
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_DirSelectSIO(TCB_PTR tcb,void *work)
{
	sys_FreeMemoryEz(work);
	TCB_Delete(tcb);
}

//============================================================================================
/**
 *	IV[PXio[
 */
//============================================================================================
enum{
	SEQ_ITEM_SEL_INIT=0,
	SEQ_ITEM_SEL_WAIT,
	SEQ_ITEM_SEL_TASK_SET,
	SEQ_ITEM_SEL_MAIN,
	SEQ_ITEM_SEL_POKE_LIST_INIT,
	SEQ_ITEM_SEL_POKE_LIST_MAIN,
	SEQ_ITEM_SEL_END_INIT,
	SEQ_ITEM_SEL_END
};

//============================================================================================
/**
 *	ITCBivC[pj
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_ItemSelect(TCB_PTR tcb,void *work)
{
	TCB_ITEM_SELECT	*tis=(TCB_ITEM_SELECT *)work;
	BI_PARAM_PTR bip;
	PALETTE_FADE_PTR	pfd;
	SOFT_SPRITE_MANAGER	*ssm_p;

	pfd=BattleWorkPfdGet(tis->bw);
	ssm_p=BattleWorkSoftSpriteManagerGet(tis->bw);

	switch(tis->seq_no){
	case SEQ_ITEM_SEL_INIT:		//obOʂւ̃tF[h
		MSG_DsIconFlashReq(BattleWorkMsgIconGet(tis->bw),MSG_DSI_REQ_STOP);
		PaletteFadeReq(pfd,PF_BIT_MAIN_ALL,0x0c00,0,0,16,0x0000);
		PaletteFadeReq(pfd,PF_BIT_SUB_ALL,0xffff,-1,0,16,0x0000);
		tis->seq_no++;
		break;
	case SEQ_ITEM_SEL_WAIT:
		if(PaletteFadeCheck(pfd)==0){	//PxύXtF[hI҂ĐFX폜
			{
				BattleWorkProcModeSet(tis->bw,BW_PROC_MODE_LIST);
				FightScreenTransition(tis->bw);

				tis->bag_buf=sys_AllocMemory(HEAPID_BATTLE,sizeof(BBAG_DATA));
				tis->bag_buf->bw=tis->bw;
				tis->bag_buf->myst=BattleWorkMyStatusGet(tis->bw,tis->client_no);
				tis->bag_buf->heap=HEAPID_BATTLE;
				tis->bag_buf->end_flg=0;
				tis->bag_buf->myitem=BattleWorkMyItemGet(tis->bw);
				tis->bag_buf->client_no=tis->client_no;
				BattleBag_TaskAdd( tis->bag_buf );
				tis->seq_no=SEQ_ITEM_SEL_MAIN;
			}
		}
		break;
	case SEQ_ITEM_SEL_TASK_SET:
		BattleBag_TaskAdd( tis->bag_buf );
		tis->seq_no++;
	case SEQ_ITEM_SEL_MAIN:
		if(tis->bag_buf->end_flg){
			tis->bag_buf->end_flg=0;
			if(tis->bag_buf->ret_item){
				switch(tis->bag_buf->ret_page){
				case BBAG_POKE_PPRCV:	// PP񕜃|Pbg
				case BBAG_POKE_STRCV:	// ԉ񕜃|Pbg
				case BBAG_POKE_HPRCV:	// HP񕜃|Pbg
					tis->seq_no=SEQ_ITEM_SEL_POKE_LIST_INIT;
					break;
				case BBAG_POKE_BATTLE:	// 퓬p|Pbg
				case BBAG_POKE_BALL:	// {[|Pbg
					tis->seq_no=SEQ_ITEM_SEL_END_INIT;
					break;
				}
			}
			else{
				tis->seq_no=SEQ_ITEM_SEL_END_INIT;
			}
		}
		break;
	//|PXgʂ
	case SEQ_ITEM_SEL_POKE_LIST_INIT:
		{
			int				i;
			int				cnt=0;
			POKEPARTY		*poke_party=BattleWorkPokePartyGet(tis->bw,tis->client_no);
			POKEMON_PARAM	*pp=BattleWorkPokemonParamGet(tis->bw,tis->client_no,tis->tps->sel_mons_no[tis->client_no]);

			tis->tps->plist=sys_AllocMemory(HEAPID_BATTLE,sizeof(BPLIST_DATA));
			tis->tps->plist->pp=PokeParty_AllocPartyWork(HEAPID_BATTLE);
			PokeParty_Add(tis->tps->plist->pp,pp);
			tis->tps->plist->list_row[cnt++]=tis->tps->sel_mons_no[tis->client_no];

			for(i=0;i<PokeParty_GetPokeCount(poke_party);i++){
				if(i!=tis->tps->sel_mons_no[tis->client_no]){
					pp=BattleWorkPokemonParamGet(tis->bw,tis->client_no,i);
					PokeParty_Add(tis->tps->plist->pp,pp);
					tis->tps->plist->list_row[cnt++]=i;
				}
			}

			tis->tps->plist->bw = tis->bw;
			tis->tps->plist->heap = HEAPID_BATTLE;
			tis->tps->plist->sel_poke = 0;
			tis->tps->plist->end_flg = 0;
			tis->tps->plist->chg_waza=0;
			tis->tps->plist->mode=BPL_MODE_ITEMUSE;	// ʏ̃|PI
			tis->tps->plist->item=tis->bag_buf->ret_item;
			tis->tps->plist->client_no=tis->bag_buf->client_no;

			BattlePokeList_TaskAdd( tis->tps->plist );
			tis->seq_no++;
		}
		break;
	case SEQ_ITEM_SEL_POKE_LIST_MAIN:
		if(tis->tps->plist->end_flg){
			tis->tps->plist->end_flg=0;
			sys_FreeMemoryEz(tis->tps->plist->pp);
			sys_FreeMemoryEz(tis->tps->plist);
			if(tis->tps->plist->sel_poke==BPL_SEL_EXIT){
				tis->seq_no=SEQ_ITEM_SEL_TASK_SET;
			}
			else{
				tis->seq_no=SEQ_ITEM_SEL_END_INIT;
			}
		}
		break;
	case SEQ_ITEM_SEL_END_INIT:
		FightScreenRecover(tis->bw);
		PaletteFadeReq(pfd,PF_BIT_MAIN_ALL,0x0c00,0,16,0,0x0000);
		PaletteFadeReq(pfd,PF_BIT_SUB_ALL,0xffff,-1,16,0,0x0000);
		BattleWorkProcModeSet(tis->bw,BW_PROC_MODE_FIGHT);
		tis->seq_no++;
	case SEQ_ITEM_SEL_END:
		if(PaletteFadeCheck(pfd)==0){	//PxύXtF[hI҂ĐFX폜
			{
				ITEM_SELECT_RETURN_PARAM	isrp;

				MSG_DsIconFlashReq(BattleWorkMsgIconGet(tis->bw),MSG_DSI_REQ_START);
	
				if(tis->bag_buf->ret_item==0){
					isrp.item_no=SELECT_CANCEL;
				}
				else{
					isrp.item_no=tis->bag_buf->ret_item;
					isrp.page=tis->bag_buf->ret_page;
					switch(tis->bag_buf->ret_page){
					case BBAG_POKE_PPRCV:	// PP񕜃|Pbg
					case BBAG_POKE_STRCV:	// ԉ񕜃|Pbg
					case BBAG_POKE_HPRCV:	// HP񕜃|Pbg
						isrp.sel_mons_no=SELECT_POKE_1+tis->tps->plist->list_row[tis->tps->plist->sel_poke];
						break;
					case BBAG_POKE_BATTLE:	// 퓬p|Pbg
					case BBAG_POKE_BALL:	// {[|Pbg
						break;
					}
				}
				SCIO_ItemSelectReturnSet(tis->bw,tis->client_no,isrp);
				SCIO_ServerQueClear(tis->bw,tis->client_no,tis->command_code);
				sys_FreeMemoryEz(tis->tps);
				sys_FreeMemoryEz(tis->bag_buf);
				sys_FreeMemoryEz(work);
				TCB_Delete(tcb);
			}
		}
		break;
	}
}

//============================================================================================
/**
 *	ITCBiAIpj
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_ItemSelectAI(TCB_PTR tcb,void *work)
{
	TCB_ITEM_SELECT	*tis=(TCB_ITEM_SELECT *)work;

//	SCIO_ItemSelectReturnSet(tis->bw,tis->client_no,tp_ret);
	SCIO_ServerQueClear(tis->bw,tis->client_no,tis->command_code);
	sys_FreeMemoryEz(work);
	TCB_Delete(tcb);
}

//============================================================================================
/**
 *	ITCBiʐMpj
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_ItemSelectSIO(TCB_PTR tcb,void *work)
{
	sys_FreeMemoryEz(work);
	TCB_Delete(tcb);
}

//============================================================================================
/**
 *	|PITCBivC[pj
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_PokemonSelect(TCB_PTR tcb,void *work)
{
	TCB_POKEMON_SELECT	*tps=(TCB_POKEMON_SELECT *)work;
	PALETTE_FADE_PTR	pfd;
	SOFT_SPRITE_MANAGER	*ssm_p;

	pfd=BattleWorkPfdGet(tps->bw);
	ssm_p=BattleWorkSoftSpriteManagerGet(tps->bw);

	switch(tps->seq_no){
	case 0:		//Xgʂւ̃tF[h
		MSG_DsIconFlashReq(BattleWorkMsgIconGet(tps->bw),MSG_DSI_REQ_STOP);
		PaletteFadeReq(pfd,PF_BIT_MAIN_ALL,0x0c00,0,0,16,0x0000);
		PaletteFadeReq(pfd,PF_BIT_SUB_ALL,0xffff,-1,0,16,0x0000);
		tps->seq_no++;
		break;
	case 1:
		if(PaletteFadeCheck(pfd)==0){	//PxύXtF[hI҂ĐFX폜
			{
				int				i;
				int				cnt=0;
				POKEPARTY		*poke_party=BattleWorkPokePartyGet(tps->bw,tps->client_no);
				POKEMON_PARAM	*pp=BattleWorkPokemonParamGet(tps->bw,tps->client_no,tps->sel_mons_no[tps->client_no]);

				FightScreenTransition(tps->bw);
				BattleWorkProcModeSet(tps->bw,BW_PROC_MODE_LIST);

				tps->plist=sys_AllocMemory(HEAPID_BATTLE,sizeof(BPLIST_DATA));
				tps->plist->pp=PokeParty_AllocPartyWork(HEAPID_BATTLE);
				PokeParty_Add(tps->plist->pp,pp);
				tps->plist->list_row[cnt++]=tps->sel_mons_no[tps->client_no];

				for(i=0;i<PokeParty_GetPokeCount(poke_party);i++){
					if(i!=tps->sel_mons_no[tps->client_no]){
						pp=BattleWorkPokemonParamGet(tps->bw,tps->client_no,i);
						PokeParty_Add(tps->plist->pp,pp);
						tps->plist->list_row[cnt++]=i;
					}
				}

				tps->plist->bw = tps->bw;
				tps->plist->heap = HEAPID_BATTLE;
				tps->plist->sel_poke = 0;
				tps->plist->end_flg = 0;
				tps->plist->chg_waza=tps->chg_waza;
				tps->plist->mode=tps->list_mode;
				tps->plist->item=tps->item;
				tps->plist->client_no=tps->client_no;

				BattlePokeList_TaskAdd( tps->plist );
				tps->seq_no++;
			}
		}
		break;
	case 2:
		if(tps->plist->end_flg){
			FightScreenRecover(tps->bw);
			PaletteFadeReq(pfd,PF_BIT_MAIN_ALL,0x0c00,0,16,0,0x0000);
			PaletteFadeReq(pfd,PF_BIT_SUB_ALL,0xffff,-1,16,0,0x0000);
			BattleWorkProcModeSet(tps->bw,BW_PROC_MODE_FIGHT);
			tps->seq_no++;
		}
		break;
	case 3:
		if(PaletteFadeCheck(pfd)==0){	//PxύXtF[hI҂ĐFX폜
			MSG_DsIconFlashReq(BattleWorkMsgIconGet(tps->bw),MSG_DSI_REQ_START);
			if(tps->plist->sel_poke==BPL_SEL_EXIT){
				SCIO_PokemonSelectReturnSet(tps->bw,tps->client_no,SELECT_CANCEL);
			}
			else{
				SCIO_PokemonSelectReturnSet(tps->bw,tps->client_no,SELECT_POKE_1+tps->plist->list_row[tps->plist->sel_poke]);
			}
			SCIO_ServerQueClear(tps->bw,tps->client_no,tps->command_code);
			sys_FreeMemoryEz(tps->plist->pp);
			sys_FreeMemoryEz(tps->plist);
			sys_FreeMemoryEz(work);
			TCB_Delete(tcb);
		}
		break;
	}
}

//============================================================================================
/**
 *	|PITCBiAIpj
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_PokemonSelectAI(TCB_PTR tcb,void *work)
{
	TCB_POKEMON_SELECT	*tps=(TCB_POKEMON_SELECT *)work;
	int					pos;
	POKEPARTY			*poke_party;
	POKEMON_PARAM		*pp;
	int					client_no,client_pair_no;

	client_no=tps->client_no;
	client_pair_no=BattleWorkPartnerClientNoGet(tps->bw,client_no);

	//bŐ擪T[`HP̂|PJo
	poke_party=BattleWorkPokePartyGet(tps->bw,tps->client_no);
	for(pos=0;pos<PokeParty_GetPokeCount(poke_party);pos++){
		pp=BattleWorkPokemonParamGet(tps->bw,tps->client_no,pos);
		if((PokeParaGet(pp,ID_PARA_hp,NULL))&&
		   (tps->sel_mons_no[client_no]!=pos)&&
		   (tps->sel_mons_no[client_pair_no]!=pos)){
			break;
		}
	}
	SCIO_PokemonSelectReturnSet(tps->bw,tps->client_no,SELECT_POKE_1+pos);
	SCIO_ServerQueClear(tps->bw,tps->client_no,tps->command_code);
	sys_FreeMemoryEz(work);
	TCB_Delete(tcb);
}

//============================================================================================
/**
 *	|PITCBiʐMpj
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_PokemonSelectSIO(TCB_PTR tcb,void *work)
{
	sys_FreeMemoryEz(work);
	TCB_Delete(tcb);
}

//============================================================================================
/**
 *	Yes/NoITCBivC[pj
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_YesNoSelect(TCB_PTR tcb,void *work)
{
	TCB_YES_NO_SELECT	*tyns = work;
	GF_BGL_INI	*bgl=BattleWorkGF_BGL_INIGet(tyns->bw);
	BI_PARAM_PTR bip = BattleWorkGF_BGL_BIPGet(tyns->bw);

	enum{	//V[PXԍ
		CSSEQ_ESCAPE_SELECT_INIT,
		CSSEQ_ESCAPE_SELECT,
		CSSEQ_ESCAPE_SELECT_EFFWAIT,
		
		CSSEQ_FINISH,
	};
	
	switch(tyns->seq_no){
	case CSSEQ_ESCAPE_SELECT_INIT:
		{
			GF_BGL_BMPWIN		*win;
			MSGDATA_MANAGER		*msg_m;
			MESSAGE_PARAM		mp;

			win=BattleWorkGF_BGL_BMPWINGet(tyns->bw);
			msg_m=BattleWorkFightMsgGet(tyns->bw);
			mp.msg_tag=TAG_NONE;
			mp.msg_id=tyns->msg_id;
			BattleMSG_Print(tyns->bw,win,msg_m,&mp,0);
		}
		BINPUT_StockBallOFF(bip);
		BINPUT_CreateBG(bip, BINPUT_TYPE_D, FALSE, NULL);
		tyns->seq_no = CSSEQ_ESCAPE_SELECT;
		break;
	case CSSEQ_ESCAPE_SELECT:
		tyns->tp_ret = BINPUT_TouchCheck(bip);
		if(tyns->tp_ret != RECT_HIT_NONE){
			Snd_SePlay(SEQ_SE_DP_DECIDE);
			tyns->seq_no = CSSEQ_ESCAPE_SELECT_EFFWAIT;
		}
		break;
	case CSSEQ_ESCAPE_SELECT_EFFWAIT:
		if(BINPUT_EffectEndCheck(bip) == TRUE){
			Gauge_AnimeStop(tyns->gauge);
			BINPUT_StockBallOFF(bip);
			BINPUT_CreateBG(bip, BINPUT_TYPE_WALL, FALSE, NULL);
			if(tyns->tp_ret == TRUE){
				BINPUT_BackFadeReq(bip, BINPUT_BACKFADE_LIGHT);
			}
			//tyns->tp_ret = SELECT_ESCAPE_COMMAND;
			tyns->seq_no = CSSEQ_FINISH;
		}
		break;

	case CSSEQ_FINISH:
		if(BINPUT_BackFadeExeCheck(bip) == TRUE){
			SCIO_CommandSelectReturnSet(tyns->bw,tyns->client_no,tyns->tp_ret);
			SCIO_ServerQueClear(tyns->bw,tyns->client_no,tyns->command_code);
			sys_FreeMemoryEz(work);
			TCB_Delete(tcb);
		}
		break;
	}
}

//============================================================================================
/**
 *	Yes/NoITCBiAIpj
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_YesNoSelectAI(TCB_PTR tcb,void *work)
{
}

//============================================================================================
/**
 *	Yes/NoITCBiʐMpj
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_YesNoSelectSIO(TCB_PTR tcb,void *work)
{
	sys_FreeMemoryEz(work);
	TCB_Delete(tcb);
}

//============================================================================================
/**
 *	ZGtFNgTCB
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_WazaEffect(TCB_PTR tcb,void *work)
{
	TCB_WAZA_EFFECT	*twe=(TCB_WAZA_EFFECT *)work;

	switch(twe->seq_no){
	case 0:
#ifdef WAZA_EFF_GAUGE_OFF
		BattleWorkGaugeOff(twe->bw);
#endif WAZA_EFF_GAUGE_OFF
		WES_Executed(twe->wsp);
		if (IsWES_Executed(twe->wsp) == FALSE){		///< Effect Commond End Check
			WES_Reset(twe->wsp);						///< Sysmte Reset
			twe->seq_no++;
		}
		break;
	case 1:
#ifdef WAZA_EFF_GAUGE_OFF
		BattleWorkGaugeOn(twe->bw);
#endif WAZA_EFF_GAUGE_OFF
		SCIO_ServerQueClear(twe->bw,twe->client_no,twe->command_code);
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		break;
	}
}

//============================================================================================
/**
 *	|P_[WuN
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_PokemonBlink(TCB_PTR tcb,void *work)
{
	TCB_POKEMON_BLINK	*tpb=(TCB_POKEMON_BLINK *)work;
	int					vanish;

	if(tpb->seq_no<8){
		if(tpb->wait==0){
			tpb->wait=BLINK_WAIT;
			tpb->seq_no++;
			vanish=SoftSpriteParaGet(tpb->ss,SS_PARA_VANISH);
			vanish^=1;
			SoftSpriteParaSet(tpb->ss,SS_PARA_VANISH,vanish);
		}
		else{
			tpb->wait--;
		}
	}
	else{
		vanish=0;
		SoftSpriteParaSet(tpb->ss,SS_PARA_VANISH,vanish);
		SCIO_ServerQueClear(tpb->bw,tpb->client_no,tpb->command_code);
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
	}
}

//============================================================================================
/**
 *	HPQ[WvZ
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_HPGaugeCalc(TCB_PTR tcb,void *work)
{
	GAUGE_WORK *gauge = work;
	int calc_hp;

	switch(gauge->param.seq_no){
	case 0:
//		Gauge_PartsDraw(gauge, GAUGE_DRAW_HPBAR | GAUGE_DRAW_HPNUM);
		Gauge_InitCalcHP(gauge, gauge->damage);
		gauge->param.seq_no++;
		//break;
	case 1:
		calc_hp = Gauge_CalcHP(gauge);
		if(calc_hp == -1){
			gauge->param.seq_no++;
		}
		break;
	default:
		SCIO_ServerQueClear(gauge->bw, gauge->client_no, gauge->command_code);
		gauge->tcb = NULL;
		TCB_Delete(tcb);
		return;
	}
}

//============================================================================================
/**
 *	EXPQ[WvZ
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_EXPGaugeCalc(TCB_PTR tcb,void *work)
{
	GAUGE_WORK *gauge = work;
	int calc_exp;
	
	switch(gauge->param.seq_no){
	case 0:
		Snd_SePlay(SEQ_SE_DP_EXP);
		Gauge_InitCalcEXP(gauge, gauge->add_exp);
		gauge->param.seq_no++;
		//break;
	case 1:
		calc_exp = Gauge_CalcEXP(gauge);
		if(calc_exp == -1){
			Snd_SeStopBySeqNo(SEQ_SE_DP_EXP, 0);
			if(gauge->exp == gauge->max_exp){
				//check@xAbvV[PXʂɏo炻Ŗ炷
				Snd_SePlay(SEQ_SE_DP_EXPMAX);
			}
			gauge->param.seq_no++;
		}
		break;
	default:
		SCIO_ServerQueClear(gauge->bw, gauge->client_no, gauge->command_code);
		gauge->tcb = NULL;
		TCB_Delete(tcb);
		break;
	}
}

//============================================================================================
/**
 *	CGtFNg
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_KizetsuEffect(TCB_PTR tcb,void *work)
{
	TCB_KIZETSU_EFFECT	*tke=(TCB_KIZETSU_EFFECT *)work;
	int	pos_y;
	int	height;

	switch(tke->seq_no){
	case 0:
		{
			int	pan;

			if(tke->dir==PARA_FRONT){
				pan=POKE_VOICE_PAN_FRONT;
			}
			else{
				pan=POKE_VOICE_PAN_BACK;
			}
			Snd_PMVoicePlayEx(PV_POKEDOWN,tke->monsno,pan,POKE_KIZETSU_VOL,HEAPID_BATTLE);
			tke->seq_no++;
		}
	case 1:
		if(Snd_PMVoicePlayCheck()==FALSE){
			tke->seq_no++;
		}
		break;
	case 2:
		Snd_SePlay(SEQ_SE_DP_POKE_DEAD);
		height=PokeHeightGet(tke->monsno,tke->sex,tke->dir);
		height=SOFT_SPRITE_SIZE_Y-height;
		SoftSpriteVisibleSet(tke->ss,0,0,SOFT_SPRITE_SIZE_X,height);
		tke->seq_no++;
		break;
	case 3:
		pos_y=SoftSpriteParaGet(tke->ss,SS_PARA_POS_Y);
		pos_y+=8;
		SoftSpriteParaSet(tke->ss,SS_PARA_POS_Y,pos_y);
		height=SoftSpriteParaGet(tke->ss,SS_PARA_OFS_SIZE_Y);
		height-=8;
		if(height<0){
			height=0;
		}
		SoftSpriteParaSet(tke->ss,SS_PARA_OFS_SIZE_Y,height);
		if(height==0){
			SoftSpriteDel(tke->ss);
			tke->seq_no++;
		}
		break;
	case 4:
		SCIO_ServerQueClear(tke->bw,tke->client_no,tke->command_code);
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		break;
	}
}

//============================================================================================
/**
 *	ʃtF[hGtFNg
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_FadeOut(TCB_PTR tcb,void *work)
{
	TCB_FADE_OUT	*tfo=(TCB_FADE_OUT *)work;
	PALETTE_FADE_PTR	pfd;
	SOFT_SPRITE_MANAGER	*ssm_p;

	pfd=BattleWorkPfdGet(tfo->bw);
	ssm_p=BattleWorkSoftSpriteManagerGet(tfo->bw);

	switch(tfo->seq_no){
	case 0:
		PaletteFadeReq(pfd,PF_BIT_NORMAL_ALL,0xffff,1,0,16,0x0000);
		SoftSpritePalFadeSetAll(ssm_p,0,16,0,0x0000);
		tfo->seq_no++;
	case 1:
		if(PaletteFadeCheck(pfd)==0){
			tfo->seq_no++;
		}
		break;
	case 2:
		SCIO_ServerQueClear(tfo->bw,tfo->client_no,tfo->command_code);
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		break;
	}
}

//============================================================================================
/**
 *	bZ[W\܂
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_MessageWait(TCB_PTR tcb,void *work)
{
	TCB_MESSAGE_WAIT	*tmw=(TCB_MESSAGE_WAIT *)work;

	if(GF_MSG_PrintEndCheck(tmw->msg_index)==0){
		SCIO_ServerQueClear(tmw->bw,tmw->client_no,tmw->command_code);
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
	}
}

//============================================================================================
/**
 *	bZ[W\܂iA[gbZ[Wpj
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_AlertMessageWait(TCB_PTR tcb,void *work)
{
	TCB_ALERT_MESSAGE_WAIT	*tamw=(TCB_ALERT_MESSAGE_WAIT *)work;

	switch(tamw->seq_no){
	case 0:
		if(GF_MSG_PrintEndCheck(tamw->msg_index)==0){
			tamw->seq_no++;
			tamw->wait=0;
		}
		break;
	case 1:
		if(++tamw->wait==ALERT_WAIT){
			SCIO_AlertMessageEndSet(tamw->bw,tamw->client_no);
			SCIO_ServerQueClear(tamw->bw,tamw->client_no,tamw->command_code);
			sys_FreeMemoryEz(work);
			TCB_Delete(tcb);
		}
		break;
	}
}

//============================================================================================
/**
 *	GJEgGtFNg
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_EncountEffect(TCB_PTR tcb,void *work)
{
	TCB_ENCOUNT_EFFECT	*tee=(TCB_ENCOUNT_EFFECT *)work;
	GF_BGL_INI			*bgl;
	PALETTE_FADE_PTR	pfd;


	bgl=BattleWorkGF_BGL_INIGet(tee->bw);
	pfd=BattleWorkPfdGet(tee->bw);

	if(tee->wait<130){
		GF_BGL_ScrollSet(bgl,GF_BGL_FRAME3_M,GF_BGL_SCROLL_X_INC,SCROLL_SPEED);
	}

	tee->wait++;

	switch(tee->seq_no){
	case 0:
//		PaletteFadeReq(pfd,PF_BIT_MAIN_ALL,0x0400,0,16,0,0x0000);
		tee->seq_no++;
		break;
	case 1:
		if(PaletteFadeCheck(pfd)==0){
			{
				TEC_ADD_PARAM	tap;
	
				tee->ecem=ECEM_Init(HEAPID_BATTLE,NULL);
				
				tap.eff_no=ECE_SPA_GRASS_001;
				tap.camera_type=GF_CAMERA_ORTHO;
				tee->ece[0]=ECEM_Load(tee->ecem,&tap);
	
				tap.eff_no=ECE_SPA_GRASS_002;
				tap.camera_type=GF_CAMERA_ORTHO;
				tee->ece[1]=ECEM_Load(tee->ecem,&tap);
	
				ECE_Call(tee->ece[0]);
	
				tee->seq_no++;
			}
		}
		break;
	case 2:
		if(tee->wait==41){
			ECE_Call(tee->ece[1]);
		}
		if(tee->wait==56){
			PaletteFadeReq(pfd,PF_BIT_NORMAL_ALL,0xf3ff,0,16,0,0xffff);
		}
		if(tee->wait==120){
			PaletteFadeReq(pfd,PF_BIT_MAIN_ALL,0x0c00,0,16,0,0x0000);
			tee->seq_no++;
		}
		break;
	case 3:
		if(ECE_EndCheck(tee->ece[1])==FALSE){
			ECEM_Free(tee->ecem);
			tee->seq_no++;
		}
		break;
	case 4:
		if(tee->wait>=130){
			//bZ[WEChEDSACRpbgAjX^[g
			MSG_DsIconFlashReq(BattleWorkMsgIconGet(tee->bw),MSG_DSI_REQ_START);
			sys_FreeMemoryEz(work);
			TCB_Delete(tcb);
		}
		break;
	}
}

//-----------------------------------------------------------------------------
//		O֐pc[Q
//-----------------------------------------------------------------------------
//============================================================================================
/**
 *	[UC^tF[XZbg
 *
 * @param[in]	bw		퓬VXe[N|C^
 * @param[in]	cp		NCAg[N|C^
 */
//============================================================================================
void	CT_UISet(BATTLE_WORK *bw,CLIENT_PARAM *cp)
{
	int	fight_type=BattleWorkFightTypeGet(bw);

	if(fight_type&FIGHT_TYPE_AI){
		if(cp->client_no){
			cp->ui.UI_CommandSelect=&TCB_CommandSelectAI;
			cp->ui.UI_WazaSelect=&TCB_WazaSelectAI;
			cp->ui.UI_DirSelect=&TCB_DirSelectAI;
			cp->ui.UI_ItemSelect=&TCB_ItemSelectAI;
			cp->ui.UI_PokemonSelect=&TCB_PokemonSelectAI;
			cp->ui.UI_YesNoSelect=&TCB_YesNoSelectAI;
			cp->client_boot=CLIENT_BOOT_AI;
		}
		else{
			cp->ui.UI_CommandSelect=&TCB_CommandSelect;
			cp->ui.UI_WazaSelect=&TCB_WazaSelect;
			cp->ui.UI_DirSelect=&TCB_DirSelect;
			cp->ui.UI_ItemSelect=&TCB_ItemSelect;
			cp->ui.UI_PokemonSelect=&TCB_PokemonSelect;
			cp->ui.UI_YesNoSelect=&TCB_YesNoSelect;
			cp->client_boot=CLIENT_BOOT_NORMAL;
		}
	}
	else if(fight_type&FIGHT_TYPE_MULTI){
		if(cp->client_type!=BattleWorkClientTypeGet(bw,CommGetCurrentID())){
			cp->ui.UI_CommandSelect=&TCB_CommandSelectSIO;
			cp->ui.UI_WazaSelect=&TCB_WazaSelectSIO;
			cp->ui.UI_DirSelect=&TCB_DirSelectSIO;
			cp->ui.UI_ItemSelect=&TCB_ItemSelectSIO;
			cp->ui.UI_PokemonSelect=&TCB_PokemonSelectSIO;
			cp->ui.UI_YesNoSelect=&TCB_YesNoSelectSIO;
			cp->client_boot=CLIENT_BOOT_SIO;
		}
		else{
			cp->ui.UI_CommandSelect=&TCB_CommandSelect;
			cp->ui.UI_WazaSelect=&TCB_WazaSelect;
			cp->ui.UI_DirSelect=&TCB_DirSelect;
			cp->ui.UI_ItemSelect=&TCB_ItemSelect;
			cp->ui.UI_PokemonSelect=&TCB_PokemonSelect;
			cp->ui.UI_YesNoSelect=&TCB_YesNoSelect;
			cp->client_boot=CLIENT_BOOT_NORMAL;
		}
	}
	else if(fight_type&FIGHT_TYPE_SIO){
		if(cp->client_type&CLIENT_ENEMY_FLAG){
			cp->ui.UI_CommandSelect=&TCB_CommandSelectSIO;
			cp->ui.UI_WazaSelect=&TCB_WazaSelectSIO;
			cp->ui.UI_DirSelect=&TCB_DirSelectSIO;
			cp->ui.UI_ItemSelect=&TCB_ItemSelectSIO;
			cp->ui.UI_PokemonSelect=&TCB_PokemonSelectSIO;
			cp->ui.UI_YesNoSelect=&TCB_YesNoSelectSIO;
			cp->client_boot=CLIENT_BOOT_SIO;
		}
		else{
			cp->ui.UI_CommandSelect=&TCB_CommandSelect;
			cp->ui.UI_WazaSelect=&TCB_WazaSelect;
			cp->ui.UI_DirSelect=&TCB_DirSelect;
			cp->ui.UI_ItemSelect=&TCB_ItemSelect;
			cp->ui.UI_PokemonSelect=&TCB_PokemonSelect;
			cp->ui.UI_YesNoSelect=&TCB_YesNoSelect;
			cp->client_boot=CLIENT_BOOT_NORMAL;
		}
	}
	else{
		if(cp->client_type&CLIENT_ENEMY_FLAG){
			cp->ui.UI_CommandSelect=&TCB_CommandSelectAI;
			cp->ui.UI_WazaSelect=&TCB_WazaSelectAI;
			cp->ui.UI_DirSelect=&TCB_DirSelectAI;
			cp->ui.UI_ItemSelect=&TCB_ItemSelectAI;
			cp->ui.UI_PokemonSelect=&TCB_PokemonSelectAI;
			cp->ui.UI_YesNoSelect=&TCB_YesNoSelectAI;
			cp->client_boot=CLIENT_BOOT_AI;
		}
		else{
			cp->ui.UI_CommandSelect=&TCB_CommandSelect;
			cp->ui.UI_WazaSelect=&TCB_WazaSelect;
			cp->ui.UI_DirSelect=&TCB_DirSelect;
			cp->ui.UI_ItemSelect=&TCB_ItemSelect;
			cp->ui.UI_PokemonSelect=&TCB_PokemonSelect;
			cp->ui.UI_YesNoSelect=&TCB_YesNoSelect;
			cp->client_boot=CLIENT_BOOT_NORMAL;
		}
	}
}

//============================================================================================
/**
 *	client_type擾֐
 *
 * @param[in]	cp		NCAg[N|C^
 */
//============================================================================================
u8	CT_CPClientTypeGet(CLIENT_PARAM *cp)
{
	return cp->client_type;
}

//============================================================================================
/**
 *	soft_sprite擾֐
 *
 * @param[in]	cp		NCAg[N|C^
 */
//============================================================================================
SOFT_SPRITE	*CT_CPSoftSpriteGet(CLIENT_PARAM *cp)
{
	return cp->poke_ss;
}

//============================================================================================
/**
 *	gauge_work擾֐
 *
 * @param[in]	cp		NCAg[N|C^
 */
//============================================================================================
GAUGE_WORK		*CT_CPGaugeWorkGet(CLIENT_PARAM *cp)
{
	return &cp->gauge;
}

//-----------------------------------------------------------------------------
//		OJ֐
//-----------------------------------------------------------------------------
//============================================================================================
/**
 *	SoftSpritẽZbgƋZGtFNgpLWJƃp[^擾֐
 *
 * @param[in]	cp		NCAg[N|C^
 */
//============================================================================================
static	SOFT_SPRITE	*CT_SoftSpriteAdd(BATTLE_WORK *bw,SOFT_SPRITE_MANAGER *ssm_p,SOFT_SPRITE_ARC *ssa,
							  int pos_x,int pos_y,int pos_z,int ofs_y,int client_no,
							  SOFT_SPRITE_ANIME *anm_tbl,SOFT_SPRITE_MOVE_FUNC *move)
{
	u8	*oam_temp=ExChrParamExChrBufferGet(BattleWorkExChrParamGet(bw),client_no);

	ChangesInto_BattlePokeData(ssa->arc_no,ssa->index_chr,HEAPID_BATTLE,oam_temp);
	ExChrParamPalIndexSet(BattleWorkExChrParamGet(bw),client_no,ssa->index_pal);
	ExChrParamHeightSet(BattleWorkExChrParamGet(bw),client_no,ofs_y);

	return SoftSpriteAdd(ssm_p,ssa,pos_x,pos_y+ofs_y,pos_z,client_no,anm_tbl,move);
}

//============================================================================================
/**
 *	FightTypeƃbZ[W\Client߂bZ[W̃p[^𐶐
 *
 * @param[in]	cp		NCAg[N|C^
 */
//============================================================================================
static	void	CT_ModosuMessageParamMake(BATTLE_WORK *bw,CLIENT_PARAM *cp,MODOSU_MESSAGE_PARAM *mmp,MESSAGE_PARAM *mp)
{
	if(cp->client_type&CLIENT_ENEMY_FLAG){
		mp->msg_id=IrekaeMsg2;
		mp->msg_tag=TAG_TRTYPE_TRNAME_NICK;
		mp->msg_para[1]=BattleWorkTrainerIDGet(bw,cp->client_no);
		mp->msg_para[0]=TT_TrainerDataParaGet(mp->msg_para[1],ID_TD_tr_type);
		mp->msg_para[2]=cp->client_no|(mmp->sel_mons_no<<8);
	}
	else{
#warning Modosu Message No HP Calc
		//󂯂_[WȂǂŁAbZ[Wω
		mp->msg_id=IrekaeMsg_1;
		mp->msg_tag=TAG_NICK;
		mp->msg_para[0]=cp->client_no|(mmp->sel_mons_no<<8);
	}
}

//============================================================================================
/**
 *	FightTypeƃbZ[W\ClientJobZ[W̃p[^𐶐
 *
 * @param[in]	cp		NCAg[N|C^
 */
//============================================================================================
static	void	CT_KuridasuMessageParamMake(BATTLE_WORK *bw,CLIENT_PARAM *cp,KURIDASU_MESSAGE_PARAM *kmp,MESSAGE_PARAM *mp)
{
	if(cp->client_type&CLIENT_ENEMY_FLAG){
		mp->msg_id=KuridashiMsg;
		mp->msg_tag=TAG_TRTYPE_TRNAME_NICK;
		mp->msg_para[1]=BattleWorkTrainerIDGet(bw,cp->client_no);
		mp->msg_para[0]=TT_TrainerDataParaGet(mp->msg_para[1],ID_TD_tr_type);
		mp->msg_para[2]=cp->client_no|(kmp->sel_mons_no<<8);
	}
	else{
#warning Kuridasu Message No HP Calc
		//^_[WȂǂŁAbZ[Wω
		mp->msg_id=AppearMsg_0;
		mp->msg_tag=TAG_NICK;
		mp->msg_para[0]=cp->client_no|(kmp->sel_mons_no<<8);
	}
}
