
//============================================================================================
/**
 * @file	client_tool_def.h
 * @bfief	퓬NCAgc[vO
 * @author	HisashiSogabe
 * @date	05.07.25
 */
//============================================================================================

#ifndef __CLIENT_TOOL_DEF_H_
#define __CLIENT_TOOL_DEF_H_

#include	"battle/scio.h"
#include	"system/softsprite.h"
#include	"wazaeffect/we_mana.h"
#include	"wazaeffect/ball_effect.h"
#include	"wazaeffect/ec_eff.h"
#include	"poketool/pokeparty.h"
#include	"b_plist.h"
#include	"b_bag.h"

///<POKEMON_ENCOUNTpTCBp[^\̐錾
typedef struct
{
	BATTLE_WORK	*bw;
	SOFT_SPRITE	*ss;
	GROUND_WORK *gw;
	u8			command_code;
	u8			client_no;
	u8			seq_no;
	u8			dir;
	s16			appear_pos;
	u16			mons_no;
	int			voice;
	int			client_type;
}TCB_POKEMON_ENCOUNT;

///<POKEMON_APPEARpTCBp[^\̐錾
typedef struct
{
	BATTLE_WORK	*bw;
	SOFT_SPRITE	*ss;
	BES_PTR		bes;			///< {[GtFNg
	BMS_PTR		bms;
	u8			command_code;
	u8			client_no;
	u8			client_type;
	u8			seq_no;
	u8			dir;
	u8			height;
	u16			mons_no;
	int			voice;
}TCB_POKEMON_APPEAR;

///<POKEMON_RETURNpTCBp[^\̐錾
typedef struct
{
	BATTLE_WORK	*bw;
	SOFT_SPRITE	*ss;
	u8			command_code;
	u8			client_no;
	u8			seq_no;
	u8			height;
}TCB_POKEMON_RETURN;

///<TRAINER_ENCOUNTpTCBp[^\̐錾
typedef struct
{
	BATTLE_WORK	*bw;
	SOFT_SPRITE	*ss;
	GROUND_WORK *gw;
	u8			command_code;
	u8			client_no;
	u8			seq_no;
	u8			dir;
	s16			appear_pos;
	u16			tr_id;
	int			client_type;
}TCB_TRAINER_ENCOUNT;

///<TRAINER_OUTpTCBp[^\̐錾
typedef struct
{
	BATTLE_WORK	*bw;
	SOFT_SPRITE	*ss;
	u8			command_code;
	u8			client_no;
	u8			seq_no;
	u8			dir;
}TCB_TRAINER_OUT;

///<TRAINER_INpTCBp[^\̐錾
typedef struct
{
	BATTLE_WORK	*bw;
	SOFT_SPRITE	*ss;
	u8			command_code;
	u8			client_no;
	u8			seq_no;
	u8			dir;
	s16			appear_pos;
	u16			tr_id;
}TCB_TRAINER_IN;

///<HP_GAUGE_INpTCBp[^\̐錾
typedef struct
{
	BATTLE_WORK	*bw;
	u8			command_code;
	u8			client_no;
	u8			seq_no;
	u8			client_type;
	s16			hp;
	u16			hpmax;
	
	s16			be_hp;		///<󂯂_[W(񕜂ꍇ̓}CiXœ) ϓl
	s16			hp_work;	///<Q[WƗp[N
	
	u8			level;
	
	CATS_ACT_PTR cap;
}TCB_HP_GAUGE_IN;

///<COMMAND_SELECTpTCBp[^\̐錾
typedef struct
{
	BATTLE_WORK	*bw;
	void		*gauge;
	u8			command_code;
	u8			client_no;
	u8			seq_no;
	s8			wait;
	int			tp_ret;
	u8			status[2][POKEMON_TEMOTI_MAX];
	u8			motivation[POKEMON_TEMOTI_MAX];
	u8			msg_index;
	u8			sel_mons_no;
	u8			client_type;
}TCB_COMMAND_SELECT;

///<WAZA_SELECTpTCBp[^\̐錾
typedef struct
{
	BATTLE_WORK	*bw;
	void		*gauge;
	int			tp_ret;
	u16			wazano[WAZA_TEMOTI_MAX];		//wazano
	u8			pp[WAZA_TEMOTI_MAX];			//pp
	u8			ppmax[WAZA_TEMOTI_MAX];			//ppmax
	u8			command_code;
	u8			client_no;
	u8			sel_mons_no;
	u8			seq_no;
}TCB_WAZA_SELECT;

///<DIR_SELECTpTCBp[^\̐錾
typedef struct
{
	BATTLE_WORK	*bw;
	void		*gauge;
	int			tp_ret;
	u8			command_code;
	u8			client_no;
	u8			client_type;
	u8			seq_no;
	DIR_SELECT_POKE_PARAM	dspp[CLIENT_MAX];	
	u16			range;			//ʔ͈
	u8			light_flag;		///1F͉ʔwi𖾂邭Ă
}TCB_DIR_SELECT;

///<POKEMON_SELECTpTCBp[^\̐錾
typedef struct
{
	BATTLE_WORK	*bw;
	PROC		*proc;
	BPLIST_DATA	*plist;

	u8			command_code;
	u8			client_no;
	u8			seq_no;
	u8			list_mode;
	u8			sel_mons_no[CLIENT_MAX];
	int			chg_waza;
	u16			item;
}TCB_POKEMON_SELECT;

///<ITEM_SELECTpTCBp[^\̐錾
typedef struct
{
	BATTLE_WORK			*bw;
	PROC				*proc;
	BBAG_DATA			*bag_buf;
	TCB_POKEMON_SELECT	*tps;
	u8					command_code;
	u8					client_no;
	u8					seq_no;
	u8					client_type;
}TCB_ITEM_SELECT;

///<YES_NO_SELECTpTCBp[^\̐錾
typedef struct
{
	BATTLE_WORK	*bw;
	void		*gauge;
	int			tp_ret;
	u8			command_code;
	u8			client_no;
	u8			seq_no;
	u8			dummy;
	int			msg_id;
}TCB_YES_NO_SELECT;

///<POKEMON_BLINKpTCBp[^\̐錾
typedef struct
{
	BATTLE_WORK	*bw;
	SOFT_SPRITE	*ss;
	u8			command_code;
	u8			client_no;
	u8			seq_no;
	u8			wait;			///<BLINK_WAIT
}TCB_POKEMON_BLINK;

///<HP_GAUGE_CALCpTCBp[^\̐錾
typedef struct
{
	BATTLE_WORK	*bw;
	u8			command_code;
	u8			client_no;
	u8			seq_no;
	u8			dir;
	s16			hp;
	u16			hpmax;
	int			damage;
	u8			level;
}TCB_HP_GAUGE_CALC;

///<KIZETSU_EFFECTpTCBp[^\̐錾
typedef struct
{
	BATTLE_WORK	*bw;
	SOFT_SPRITE	*ss;
	u8			command_code;
	u8			client_no;
	u8			seq_no;
	u8			dir;
	u16			monsno;
	u8			sex;
}TCB_KIZETSU_EFFECT;

///<KIZETSU_EFFECTpTCBp[^\̐錾
typedef struct
{
	BATTLE_WORK	*bw;
	u8			command_code;
	u8			client_no;
	u8			seq_no;
}TCB_FADE_OUT;

///<WAZA_EFFECTpTCBp[^\̐錾
typedef struct
{
	BATTLE_WORK	*bw;
	WE_SYS_PTR	wsp;
	u8			command_code;
	u8			client_no;
	u8			seq_no;
}TCB_WAZA_EFFECT;

typedef struct
{
	BATTLE_WORK	*bw;
	u8			command_code;
	u8			client_no;
	u8			msg_index;
}TCB_MESSAGE_WAIT;

///<STATUS_EFFECTpTCBp[^\̐錾
typedef struct
{
	BATTLE_WORK	*bw;
	int			flag;
	u8			command_code;
	u8			client_no;
	u8			seq_no;
	u8			dummy;
}TCB_STATUS_EFFECT;

typedef struct
{
	BATTLE_WORK	*bw;
	u8			command_code;
	u8			client_no;
	u8			msg_index;
	u8			seq_no;
	u8			wait;
}TCB_ALERT_MESSAGE_WAIT;

///<ENCOUNT_EFFECTpTCBp[^\̐錾
typedef struct
{
	BATTLE_WORK	*bw;
	ECEM_PTR	ecem;
	ECE_PTR		ece[3];
	u8			seq_no;
	u8			wait;
}TCB_ENCOUNT_EFFECT;


#endif __CLIENT_TOOL_DEF_H_
