//=============================================================================
/**
 * @file	comm_command_battle.c
 * @brief	f[^𑗂邽߂̃R}he[uĂ܂
 *          ogpł
 *          comm_command_battle.h  enum ƓтłKv܂
 * @author	Katsumi Ohno
 * @date    2005.11.08
 */
//=============================================================================

#include "common.h"
#include "communication/communication.h"
#include "comm_command_battle.h"

#include "battle/fight_tool.h"

//==============================================================================
//  e[uɏ֐̒`
//==============================================================================

//==============================================================================
//  vg^Cv錾
//==============================================================================

void CommCommandBattleSendData(BATTLE_WORK *bw,int access,int para,void *data,u8 size);
BOOL CommCommandBattleSendServerVersionData(BATTLE_SIO_WORK *bsw,u32 version);
BOOL CommCommandBattleSendMyStatusData(BATTLE_SIO_WORK *bsw);
BOOL CommCommandBattleSendPokeData(BATTLE_SIO_WORK *bsw);
BOOL CommCommandBattleSendMyStatus(BATTLE_SIO_WORK *bsw);
void CommCommandBattleCPInitialize(void* pWork);

//==============================================================================
//  static`
//==============================================================================
static int _getVariable(void);
static int _getZero(void);
static int _getOne(void);
static int _getServerVersion(void);
static int _getMyStatus(void);
static int _getPokeData(void);

static	void CommCommandBattleRecvData(int id_no,int size,void *pData,void *work);
static	void CommCommandBattleRecvServerVersionData(int id_no,int size,void *pData,void *work);
static	void CommCommandBattleRecvMyStatusData(int id_no,int size,void *pData,void *work);
static	void CommCommandBattleRecvPokeData(int id_no,int size,void *pData,void *work);
static	void CommCommandBattleEnd(int id_no,int size,void *pData,void *work);
static	void TCB_CommCommandBattleSendData(TCB_PTR tcb,void *work);
static	void TCB_CommCommandBattleRecvData(TCB_PTR tcb,void *work);

//==============================================================================
//	e[u錾
//  comm_command_battle.h  enum ƓȂтɂĂ
//  CALLBACKĂ΂ꂽȂꍇNULLĂ
//  R}h̃TCYԂ֐Ă炦ƒʐMyȂ܂
//  _getZero̓TCYȂԂ܂B_getVariable͉σf[^gpɎg܂
//  comm_command_field.cQlɂĂ݂Ă
//==============================================================================
static const CommPacketTbl _CommPacketTbl[] = {
    {CommCommandBattleEnd,					_getZero},			// CB_EXIT_BATTLE
	{CommCommandBattleRecvData,				_getVariable},		// CB_BATTLE_DATA,					///<퓬f[^M
	{CommCommandBattleRecvServerVersionData,_getServerVersion},	// CB_BATTLE_SERVER_VERSION_DATA,	///<퓬f[^M
	{CommCommandBattleRecvMyStatusData,		_getMyStatus},		// CB_BATTLE_MYSTATUS_DATA,			///<퓬f[^M
	{CommCommandBattleRecvPokeData,			_getPokeData},		// CB_BATTLE_POKE_DATA,				///<퓬f[^M
};

//--------------------------------------------------------------
/**
 * @brief   ogR}hʐM̏s܂
 * @param   pWork   ogŎgp郏[Ñ|C^
 * @retval  none
 */
//--------------------------------------------------------------

void CommCommandBattleInitialize(void* pWork)
{
    int length = sizeof(_CommPacketTbl)/sizeof(CommPacketTbl);
	BATTLE_WORK		*bw;
	TCB_SIO_SEND	*tss;
	TCB_SIO_RECV	*tsr;

	bw=(BATTLE_WORK *)pWork;
	tss=(TCB_SIO_SEND *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_SIO_SEND));
	tsr=(TCB_SIO_RECV *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_SIO_RECV));

    CommCommandInitialize(_CommPacketTbl, length, pWork);

	tss->bw=bw;
	tss->seq_no=0;
	tsr->bw=bw;
	tsr->seq_no=0;

	BattleWorkTSSSeqNoAdrsSet(bw,&tss->seq_no);
	BattleWorkTSRSeqNoAdrsSet(bw,&tsr->seq_no);

	TCB_Add(TCB_CommCommandBattleSendData,tss,0);
	TCB_Add(TCB_CommCommandBattleRecvData,tsr,0);
}

//--------------------------------------------------------------
/**
 * @brief   ogR}hʐM̏s܂iŏ̎莝̌pj
 * @param   pWork   ogŎgp郏[Ñ|C^
 * @retval  none
 */
//--------------------------------------------------------------

void CommCommandBattleCPInitialize(void* pWork)
{
    int length = sizeof(_CommPacketTbl)/sizeof(CommPacketTbl);

    CommCommandInitialize(_CommPacketTbl, length, pWork);
}

//--------------------------------------------------------------
/**
 * @brief   RƂTCYԂ܂
 * @param   command         R}h
 * @retval  TCY   ςȂ COMM_VARIABLE_SIZE Zero͂OԂ
 */
//--------------------------------------------------------------
static int _getVariable(void)
{
    return COMM_VARIABLE_SIZE;
}

static int _getZero(void)
{
    return 0;
}

static int _getOne(void)
{
    return 1;
}

static int _getServerVersion(void)
{
    return 4;
}

static int _getMyStatus(void)
{
    return MyStatus_GetWorkSize();
}

static int _getPokeData(void)
{
    return PokeParty_GetWorkSize();
}

//--------------------------------------------------------------
/**
 * @brief   ogR}hʐMM
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------
void CommCommandBattleSendData(BATTLE_WORK *bw,int access,int para,void *data,u8 size)
{
	int				i;
	SIO_SEND_DATA	*ssd;
	u8				*src;
	u8				*dest;
	u16				*write;
	u16				*over;

	ssd=(SIO_SEND_DATA *)sys_AllocMemory(HEAPID_BATTLE,sizeof(SIO_SEND_DATA));
	dest=BattleWorkSioSendBufGet(bw);
	write=BattleWorkSioSendWriteGet(bw);
	over=BattleWorkSioSendOverGet(bw);

	//Queւ݂̏Ńobt@I[o[邩`FbN
	if(write[0]+sizeof(SIO_SEND_DATA)+size+1>BATTLE_SIO_BUF_SIZE){
	//I[o[ꍇ́Aoverobt@ɂ̎|i[
	//writeobt@擪ɖ߂
		over[0]=write[0];
		write[0]=0;
	}

	ssd->access=access;
	ssd->para=para;
	ssd->size=size;

	src=(u8 *)ssd;

	for(i=0;i<sizeof(SIO_SEND_DATA);i++){
		dest[write[0]]=src[i];
		write[0]++;
	}

	src=(u8 *)data;

	for(i=0;i<size;i++){
		dest[write[0]]=src[i];
		write[0]++;
	}

#ifdef DEBUG_ONLY_FOR_sogabe
	OS_Printf("Mv܂: w->%04x o->%04x \n",write[0],over[0]);
#endif

	sys_FreeMemoryEz(ssd);
}

//--------------------------------------------------------------
/**
 * @brief   ogR}hʐMM
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

static	void CommCommandBattleRecvData(int id_no,int size,void *pData,void *work)
{
	BATTLE_WORK		*bw=(BATTLE_WORK *)work;
	int				i;
	u8				*src=(u8 *)pData;
	u8				*dest=BattleWorkSioRecvBufGet(bw);
	u16				*write=BattleWorkSioRecvWriteGet(bw);
	u16				*over=BattleWorkSioRecvOverGet(bw);

	//Queւ݂̏Ńobt@I[o[邩`FbN
	if(write[0]+size+1>BATTLE_SIO_BUF_SIZE){
	//I[o[ꍇ́Aoverobt@ɂ̎|i[
	//writeobt@擪ɖ߂
		over[0]=write[0];
		write[0]=0;
	}

#ifdef DEBUG_ONLY_FOR_sogabe
	OS_Printf("Mv܂: size->%d w->%04x o->%04x \n",size,write[0],over[0]);
#endif

	for(i=0;i<size;i++){
		dest[write[0]]=src[i];
		write[0]++;
	}
}

//--------------------------------------------------------------
/**
 * @brief   ogR}hʐMM
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------
BOOL CommCommandBattleSendServerVersionData(BATTLE_SIO_WORK *bsw,u32 version)
{
	POKEPARTY	*ppt;

	//Mobt@ł͂ȂƂ́AMȂ
	if(CommGetSendRestSize()!=COMM_COMMAND_SEND_SIZE_MAX){
		return FALSE;
	}

	return CommSendData(CB_BATTLE_SERVER_VERSION_DATA,(void *)&version,4);
}

//--------------------------------------------------------------
/**
 * @brief   ogR}hʐMMTCBpV[PXio[`
 */
//--------------------------------------------------------------
static	void CommCommandBattleRecvServerVersionData(int id_no,int size,void *pData,void *work)
{
	BATTLE_SIO_WORK		*bsw=(BATTLE_SIO_WORK *)work;

	bsw->bp->server_version[id_no]=*((u32 *)pData);

	bsw->send_count++;
}

//--------------------------------------------------------------
/**
 * @brief   ogR}hʐMM
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------
BOOL CommCommandBattleSendMyStatusData(BATTLE_SIO_WORK *bsw)
{
	MYSTATUS	*ms;

	//Mobt@ł͂ȂƂ́AMȂ
	if(CommGetSendRestSize()!=COMM_COMMAND_SEND_SIZE_MAX){
		return FALSE;
	}

	ms=(MYSTATUS *)&bsw->sio_send_buffer[0];

	MyStatus_Copy(bsw->bp->my_status[0],ms);

	return CommSendHugeData(CB_BATTLE_MYSTATUS_DATA,(void *)&bsw->sio_send_buffer[0],MyStatus_GetWorkSize());
}

//--------------------------------------------------------------
/**
 * @brief   ogR}hʐMMTCBpV[PXio[`
 */
//--------------------------------------------------------------
static	void CommCommandBattleRecvMyStatusData(int id_no,int size,void *pData,void *work)
{
	BATTLE_SIO_WORK		*bsw=(BATTLE_SIO_WORK *)work;

	MyStatus_Copy((MYSTATUS *)pData,bsw->bp->my_status[id_no]);

	bsw->send_count++;
}

//--------------------------------------------------------------
/**
 * @brief   ogR}hʐMM
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------
BOOL CommCommandBattleSendPokeData(BATTLE_SIO_WORK *bsw)
{
	POKEPARTY	*ppt;

	//Mobt@ł͂ȂƂ́AMȂ
	if(CommGetSendRestSize()!=COMM_COMMAND_SEND_SIZE_MAX){
		return FALSE;
	}

	ppt=(POKEPARTY *)&bsw->sio_send_buffer[0];

	PokeParty_Copy(bsw->bp->poke_party[0],ppt);

	return CommSendHugeData(CB_BATTLE_POKE_DATA,(void *)&bsw->sio_send_buffer[0],PokeParty_GetWorkSize());
}

//--------------------------------------------------------------
/**
 * @brief   ogR}hʐMMTCBpV[PXio[`
 */
//--------------------------------------------------------------
static	void CommCommandBattleRecvPokeData(int id_no,int size,void *pData,void *work)
{
	BATTLE_SIO_WORK		*bsw=(BATTLE_SIO_WORK *)work;

	PokeParty_Copy((POKEPARTY *)pData,bsw->bp->poke_party[id_no]);

	OS_TPrintf("PokeDataRecv:%d\n",id_no);

	bsw->send_count++;
}

//--------------------------------------------------------------
/**
 * @brief   ogR}hʐMMTCBpV[PXio[`
 */
//--------------------------------------------------------------
enum{
	TSS_SEQ_SEND,
	TSS_SEQ_END=0xff
};

//--------------------------------------------------------------
/**
 * @brief   ogR}hʐMMTCB
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------
void TCB_CommCommandBattleSendData(TCB_PTR tcb,void *work)
{
	TCB_SIO_SEND	*tss=(TCB_SIO_SEND *)work;
	u8				*src;
	u16				*read;
	u16				*write;
	u16				*over;
	int				size;

	src=BattleWorkSioSendBufGet(tss->bw);
	read=BattleWorkSioSendReadGet(tss->bw);
	write=BattleWorkSioSendWriteGet(tss->bw);
	over=BattleWorkSioSendOverGet(tss->bw);

	switch(tss->seq_no){
	case TSS_SEQ_SEND:
		//Mobt@ł͂ȂƂ́AMȂ
		if(CommGetSendRestSize()!=COMM_COMMAND_SEND_SIZE_MAX){
			break;
		}
		//obt@̓ǂݍ݈ʒuƏ݈ʒuƂ̓f[^Ȃ̂ŁAMȂ
		if(read[0]==write[0]){
			break;
		}
		//obt@̓ǂݍ݈ʒuƃI[o[obt@Ƃ͐擪ɖ߂
		if(read[0]==over[0]){
			read[0]=0;
			over[0]=0;
		}
		OS_Printf("obt@cF%d\n",CommGetSendRestSize());
		size=sizeof(SIO_SEND_DATA)+(src[read[0]+SIO_BUF_SIZE_LOW]|(src[read[0]+SIO_BUF_SIZE_HIGH]<<8));
		if(CommSendData(CB_BATTLE_DATA,(void *)&src[read[0]],size)==TRUE){
			read[0]+=size;
#ifdef DEBUG_ONLY_FOR_sogabe
			OS_Printf("Mobt@AhX: src->%08x\n",&src[0]);
			OS_Printf("Mobt@AhX: bw->%08x\n",BattleWorkSioSendBufGet(tss->bw));
			OS_Printf("M܂: size->%04x r->%04x w->%04x o->%04x\n",size,read[0],write[0],over[0]);
			OS_Printf("obt@cF%d\n",CommGetSendRestSize());
#endif
		}
		break;
	case TSS_SEQ_END:
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		break;
	}
}

//--------------------------------------------------------------
/**
 * @brief   ogR}hʐMMTCBpV[PXio[`
 */
//--------------------------------------------------------------
enum{
	TSR_SEQ_RECV,
	TSR_SEQ_END=0xff
};

//--------------------------------------------------------------
/**
 * @brief   ogR}hʐMMTCB
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------
void TCB_CommCommandBattleRecvData(TCB_PTR tcb,void *work)
{
	TCB_SIO_RECV	*tsr=(TCB_SIO_RECV *)work;
	u8				*src;
	u16				*read;
	u16				*write;
	u16				*over;
	int				size;

	src=BattleWorkSioRecvBufGet(tsr->bw);
	read=BattleWorkSioRecvReadGet(tsr->bw);
	write=BattleWorkSioRecvWriteGet(tsr->bw);
	over=BattleWorkSioRecvOverGet(tsr->bw);

	switch(tsr->seq_no){
	case TSR_SEQ_RECV:
		//obt@̓ǂݍ݈ʒuƏ݈ʒuƂ̓f[^Ȃ̂ŁAMȂ
		if(read[0]==write[0]){
			break;
		}
		//obt@̓ǂݍ݈ʒuƃI[o[obt@Ƃ͐擪ɖ߂
		if(read[0]==over[0]){
			read[0]=0;
			over[0]=0;
		}
		SCIO_CommRecvData(tsr->bw,(void *)&src[read[0]]);
		size=sizeof(SIO_SEND_DATA)+(src[read[0]+SIO_BUF_SIZE_LOW]|(src[read[0]+SIO_BUF_SIZE_HIGH]<<8));
		read[0]+=size;
#ifdef DEBUG_ONLY_FOR_sogabe
		OS_Printf("M܂; r->%04x w->%04x o->%04x\n",read[0],write[0],over[0]);
#endif
		break;
	case TSR_SEQ_END:
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		break;
	}
}

//--------------------------------------------------------------
/**
 * @brief   퓬I
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------
static	void CommCommandBattleEnd(int id_no,int size,void *pData,void *work)
{
	BATTLE_WORK		*bw=(BATTLE_WORK *)work;

	BattleWorkTSSSeqNoSet(bw,TSS_SEQ_END);
	BattleWorkTSRSeqNoSet(bw,TSR_SEQ_END);

	BattleWorkFightEndFlagSet(bw,1);
}

