
//============================================================================================
/**
 * @file	fight.c
 * @bfief	퓬CvO
 * @author	HisashiSogabe
 * @date	05.05.24
 */
//============================================================================================

#include "common.h"

#include "battle/battle_server.h"
#include "battle/server.h"
#include "battle/server_tool.h"
#include "battle/client.h"
#include "battle/client_tool.h"
#include "battle/fight.h"
#include "battle/fight_tool.h"
#include "battle/shinka.h"
#include "fight_def.h"
#include "ground.h"
#include "itemtool/myitem.h"
#include "system/brightness.h"
#include "system/window.h"
#include "field/field.h"
#include "poketool/poke_tool.h"
#include "poketool/pokeparty.h"

#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/softsprite.h"
#include "system/pm_rtc.h"

#include "system/fontproc.h"
#include "system/font_arc.h"
#include "system/palanm.h"

#include "system/pmfprint.h"
#include "system/msgdata.h"
#include "system/msg_ds_icon.h"
#include "system/wordset.h"

#include "system/zukanwork.h"

#include "wazaeffect/battle_particle.h"
#include "system/particle.h"
#include "wazaeffect/we_mana.h"
#include "wazaeffect/we_sys.h"

#include "battle/graphic/batt_bg_def.h"
#include "battle_input.h"
#include "system/numfont.h"
#include "battle/battle_tcb_pri.h"

#include "msgdata/msg.naix"

#include "communication/communication.h"
#include "comm_command_battle.h"

#include "gflib/mmap_get.h"

#include <nitro/sinit.h>
#include "system/pm_overlay.h"
FS_EXTERN_OVERLAY(bc_common);

//============================================================================================
/**
 * 萔錾
 */
//============================================================================================

#define	HEAP_CHECK

#define	BATTLE_BMP_WIN_MAX	(1)		///<퓬ŎgpBMPWINMAX

enum {
	SEQ_INIT = 0,
	SEQ_SIO_INIT,
	SEQ_SIO_MAIN,
	SEQ_FIGHT_INIT,
	SEQ_FIGHT_MAIN,
	SEQ_SHINKA_INIT,
	SEQ_SHINKA_MAIN,
	SEQ_EXIT
};

static	const	u32	BattleServerVersion=0x100;		//퓬T[oo[W@1.00

//============================================================================================
/**
 * vg^Cv錾
 */
//============================================================================================

BOOL BattleSystemProc(PROC *proc,int *seq);
void	FightScreenTransition(BATTLE_WORK *bw);
void	FightScreenEnd(BATTLE_WORK *bw);
void	FightScreenRecover(BATTLE_WORK *bw);

static	void	FightInit(PROC *proc,BATTLE_PARAM *bp);
static	int		FightMain(PROC *proc);
static	void	FightEnd(PROC *proc);

static	void	FightSioInit(PROC *proc,BATTLE_PARAM *bp);
static	BOOL	FightSioMain(PROC *proc);
static	void	FightSioEnd(PROC *proc);

static	void	FightBGCreate(BATTLE_WORK *bw, GF_BGL_INI *bgl);
static	void	FightOBJCreate(BATTLE_WORK *bw);
static	void	FightBGEnd(GF_BGL_INI *bgl);
static	void	FightOBJEnd(BATTLE_WORK *bw);

static	void	FightSystemBoot(BATTLE_WORK *bw,BATTLE_PARAM *bp);

static	void	FightParticleInit(void);	//p[eBN
static	void	FightVBlank(void *work);

static void FightUpdate(TCB_PTR tcb, void *work);

//============================================================================================
/**
 * CL_ACTpf[^
 */
//============================================================================================

static	const TCATS_OAM_INIT BattleTcats = {
	BATTLE_OAM_START_MAIN, BATTLE_OAM_END_MAIN,
	BATTLE_OAM_AFFINE_START_MAIN, BATTLE_OAM_AFFINE_END_MAIN,
	BATTLE_OAM_START_SUB, BATTLE_OAM_END_SUB,
	BATTLE_OAM_AFFINE_START_SUB, BATTLE_OAM_AFFINE_END_SUB,
};

static	const TCATS_CHAR_MANAGER_MAKE BattleCcmm = {
	BATTLE_CHAR_MAX,
	BATTLE_CHAR_VRAMSIZE_MAIN,
	BATTLE_CHAR_VRAMSIZE_SUB,
	GX_OBJVRAMMODE_CHAR_1D_64K,
	GX_OBJVRAMMODE_CHAR_1D_32K
};

const TCATS_RESOURCE_NUM_LIST BattleResourceList = {
	BATTLE_OAMRESOURCE_CHAR_MAX,
	BATTLE_OAMRESOURCE_PLTT_MAX,
	BATTLE_OAMRESOURCE_CELL_MAX,
	BATTLE_OAMRESOURCE_CELLANM_MAX,
	BATTLE_OAMRESOURCE_MCELL_MAX,
	BATTLE_OAMRESOURCE_MCELLANM_MAX,
};

//============================================================================================
/**
 *
 *	퓬PROC֐
 *
 * @param
 */
//============================================================================================
BOOL BattleSystemProc(PROC *proc,int * seq)
{
	BATTLE_PARAM	*bp=PROC_GetParentWork(proc);

	switch( *seq ){

	case SEQ_INIT:
		{
			RTCTime	rtc;

			GF_RTC_GetTime( &rtc );

			gf_srand(rtc.second);
			sys_CreateHeap(HEAPID_BASE_APP,HEAPID_BATTLE,BATTLE_ALLOC_SIZE);
		}
		if(bp->fight_type&FIGHT_TYPE_SIO){
			*seq = SEQ_SIO_INIT;
		}
		else{
			*seq = SEQ_FIGHT_INIT;
		}
		break;
	case SEQ_SIO_INIT:
		FightSioInit(proc,bp);
		*seq = SEQ_SIO_MAIN;
		break;
	case SEQ_SIO_MAIN:
		if(FightSioMain(proc)==TRUE){
			FightSioEnd(proc);
			*seq = SEQ_FIGHT_INIT;
		}
		break;
	case SEQ_FIGHT_INIT:
		FightInit(proc,bp);
		*seq = SEQ_FIGHT_MAIN;
		break;
	case SEQ_FIGHT_MAIN:
		if(FightMain(proc)==1){
			{
				BATTLE_WORK		*bw=PROC_GetWork(proc);
				BOOL			ret=ST_FightShinkaCheck(bw,bp,bw->server_param);

				FightEnd(proc);
				if(ret==TRUE){
					*seq = SEQ_SHINKA_INIT;
				}
				else{
					*seq = SEQ_EXIT;
				}
			}
		}
		break;
	case SEQ_SHINKA_INIT:
		FightShinkaInit(proc,bp);
		*seq = SEQ_SHINKA_MAIN;
		break;
	case SEQ_SHINKA_MAIN:
		if(FightShinkaMain(proc)){
			FightShinkaEnd(proc);
			*seq = SEQ_EXIT;
		}
		break;
	case SEQ_EXIT:
		sys_DeleteHeap(HEAPID_BATTLE);
		Overlay_UnloadID(FS_OVERLAY_ID(bc_common));
		return TRUE;
	}
	return FALSE;
}

//============================================================================================
/**
 *
 *	퓬ʕʏڏiobOƂXgƂɍsƂɍ폜֘A܂Ƃ߂Ăj
 *
 * @param
 */
//============================================================================================
void	FightScreenTransition(BATTLE_WORK *bw)
{
//	sys_VBlankFuncChange(NULL,NULL);

	BINPUT_SystemFree(bw->bip);

	//Tu
	BINPUT_FrameExit(bw->bgl);

//	FightBGEnd(bw->bgl);
//	FightOBJEnd(bw);
	
//	CATS_ResourceDestructor_S(bw->csp,bw->crp);
//	CATS_FreeMemory(bw->csp);

//	DellVramTransferManager();

	//XgAobOʂł{^tHgʂɃ[h\̂Unload
	FontProc_UnloadFont(FONT_BUTTON);
}

//============================================================================================
/**
 *
 *	퓬ʍ폜iobOƂXgƂɍsƂɍ폜֘A番j
 *
 * @param
 */
//============================================================================================
void	FightScreenEnd(BATTLE_WORK *bw)
{
	sys_VBlankFuncChange(NULL,NULL);

	BINPUT_SystemFree(bw->bip);

	FightBGEnd(bw->bgl);
	FightOBJEnd(bw);
	
	CATS_ResourceDestructor_S(bw->csp,bw->crp);
	CATS_FreeMemory(bw->csp);

	DellVramTransferManager();

	//XgAobOʂł{^tHgʂɃ[h\̂Unload
	FontProc_UnloadFont(FONT_BUTTON);
}

//============================================================================================
/**
 *
 *	퓬ʕA
 *
 * @param
 */
//============================================================================================
void	FightScreenRecover(BATTLE_WORK *bw)
{
//	MI_CpuFill16((void*)HW_BG_PLTT, 0x0000, HW_BG_PLTT_SIZE);
	MI_CpuFill16((void*)GF_MMAP_SubBgPlttAddr(), 0x0000, GF_MMAP_SubBgPlttSize());

	//퓬͉ʃVXe[Nm
	bw->bip=BINPUT_SystemInit(bw,BattleWorkMySexGet(bw,CommGetCurrentID()));

	//XgAobOʂUnload\̂ŃtHgă[h
	FontProc_LoadFont(FONT_BUTTON, HEAPID_BATTLE);

//	initVramTransferManagerHeap(BATTLE_VRAM_TRANSFER_TASK_NUM,HEAPID_BATTLE);
//
//	GF_Disp_GX_VisibleControlInit();

	//VRAMݒ
	{
		GF_BGL_DISPVRAM vramSetTable = {
			GX_VRAM_BG_128_A,				// C2DGWBG
			GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
			GX_VRAM_SUB_BG_32_H,			// Tu2DGWBG
			GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
			GX_VRAM_OBJ_64_E,				// C2DGWOBJ
			GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
			GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
			GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
			GX_VRAM_TEX_01_BC,				// eNX`C[WXbg
			GX_VRAM_TEXPLTT_01_FG			// eNX`pbgXbg
		};
		GF_Disp_SetBank( &vramSetTable );

//		MI_CpuClear32((void*)HW_BG_VRAM, HW_BG_VRAM_SIZE);
//		MI_CpuClear32((void*)HW_DB_BG_VRAM, HW_DB_BG_VRAM_SIZE);
//		MI_CpuClear32((void*)HW_OBJ_VRAM, HW_OBJ_VRAM_SIZE);
//		MI_CpuClear32((void*)HW_DB_OBJ_VRAM, HW_DB_OBJ_VRAM_SIZE);
	}
	//Tuʃt[ݒ
	{
		BINPUT_DefaultFrameSet(bw->bgl);
	}
//	GF_Disp_DispOn();

//	GF_Disp_GX_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_ON);
	GF_Disp_GXS_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_ON);

//	FightBGCreate(bw, bw->bgl);
//	GF_BGL_BmpWinAdd(bw->bgl,bw->win,GF_BGL_FRAME1_M,0x02,0x13,27,4,0x0b,TALK_WIN_CGX_SIZ+1);
//	GF_BGL_BmpWinDataFill(bw->win,0xff);
//	BmpTalkWinWrite(bw->win,WINDOW_TRANS_ON,1,0x0a);

//	bw->csp=CATS_AllocMemory(HEAPID_BATTLE);
//	CATS_SystemInit(bw->csp,&BattleTcats,&BattleCcmm,BATTLE_OAM_PLTT_MAX);
//	bw->crp=CATS_ResourceCreate(bw->csp);
//	CATS_ClactSetInit(bw->csp, bw->crp, BATTLE_ACTOR_MAX);
//	CATS_ResourceManagerInit(bw->csp,bw->crp,&BattleResourceList);

	//Tu		AN^[VXeĂĂł
	BINPUT_CreateBG(bw->bip, BINPUT_TYPE_WALL, TRUE, NULL);
	BINPUT_StockBallActorResourceLoad(bw->bip);

//	FightOBJCreate(bw);

//	SoftSpriteRecover(bw->soft_sprite);
//
	//L[AUTO
	MsgPrintAutoFlagSet(MSG_AUTO_ON);
}

//============================================================================================
/**
 * @param
 */
//============================================================================================
static	void	FightInit(PROC *proc,BATTLE_PARAM *bp)
{
	BATTLE_WORK	*bw=PROC_AllocWork(proc,sizeof(BATTLE_WORK), HEAPID_BATTLE);
	SOFT_SPRITE_ARC	ssa;
	int			i;

	MI_CpuClearFast(bw,sizeof(BATTLE_WORK));
	MI_CpuFill16((void*)GF_MMAP_MainBgPlttAddr(), 0x0000, GF_MMAP_MainBgPlttSize());
	MI_CpuFill16((void*)GF_MMAP_SubBgPlttAddr(), 0x0000, GF_MMAP_SubBgPlttSize());

	//3D`n̏
	simple_3DBGInit(HEAPID_BATTLE);

	sys_HBlankIntrStop();	//HBlank荞ݒ~

	for(i=0;i<CLIENT_MAX;i++){
		//}CXe[^X쐬
		bw->my_status[i]=MyStatus_AllocWork(HEAPID_BATTLE);
		MyStatus_Copy(bp->my_status[i],bw->my_status[i]);
	}

	//莝ACe쐬
	bw->my_item=MyItem_AllocWork(HEAPID_BATTLE);
	MyItem_Copy(bp->my_item,bw->my_item);

	//}Ӄ[N쐬
	bw->zw=ZukanWork_AllocWork(HEAPID_BATTLE);
	ZukanWork_Copy(bp->zw,bw->zw);

	FontProc_LoadFont(FONT_BUTTON, HEAPID_BATTLE);
	bw->numfont_hp = NUMFONT_Create(0xe, 1, 0xf, HEAPID_BATTLE);
#if 1	//xnumfont_hpƓgp悤ɂȂ 2005.11.10()	check
	bw->numfont_lv = bw->numfont_hp;
#else
	bw->numfont_lv = NUMFONT_Create(0xe, 1, 0xf, HEAPID_BATTLE);
#endif
	
	bw->pfd = PaletteFadeInit(HEAPID_BATTLE);
	PaletteTrans_AutoSet(bw->pfd, TRUE);
	PaletteFadeWorkAllocSet(bw->pfd, FADE_MAIN_BG, 0x200, HEAPID_BATTLE);
	PaletteFadeWorkAllocSet(bw->pfd, FADE_SUB_BG, 0x200, HEAPID_BATTLE);
	PaletteFadeWorkAllocSet(bw->pfd, FADE_MAIN_OBJ, 0x200, HEAPID_BATTLE);
	PaletteFadeWorkAllocSet(bw->pfd, FADE_SUB_OBJ, 0x200, HEAPID_BATTLE);
	
	bw->bgl=GF_BGL_BglIniAlloc(HEAPID_BATTLE);
	bw->win=GF_BGL_BmpWinAllocGet(HEAPID_BATTLE,BATTLE_BMP_WIN_MAX);

	//ZGtFNgpLWJobt@m
	for(i=0;i<CLIENT_MAX;i++){
		bw->exchr_param[i].exchr_buffer=sys_AllocMemory(HEAPID_BATTLE,EXCHR_BUFFER_SIZE);
	}

	initVramTransferManagerHeap(BATTLE_VRAM_TRANSFER_TASK_NUM,HEAPID_BATTLE);

	//퓬͉ʃVXe[Nm
	bw->bip=BINPUT_SystemInit(bw,BattleWorkMySexGet(bw,CommGetCurrentID()));

	FightBGCreate(bw, bw->bgl);
	GF_BGL_BmpWinAdd(bw->bgl,bw->win,GF_BGL_FRAME1_M,0x02,0x13,27,4,0x0b,TALK_WIN_CGX_SIZ+1);
	GF_BGL_BmpWinDataFill(bw->win,0xff);
	BmpTalkWinWrite(bw->win,WINDOW_TRANS_ON,1,0x0a);

	bw->csp=CATS_AllocMemory(HEAPID_BATTLE);
	CATS_SystemInit(bw->csp,&BattleTcats,&BattleCcmm,BATTLE_OAM_PLTT_MAX);
	bw->crp=CATS_ResourceCreate(bw->csp);
	CATS_ClactSetInit(bw->csp, bw->crp, BATTLE_ACTOR_MAX);
	CATS_ResourceManagerInit(bw->csp,bw->crp,&BattleResourceList);

	//Tu		AN^[VXeĂĂł
	BINPUT_CreateBG(bw->bip, BINPUT_TYPE_WALL_MISSING_PLAYER, TRUE, NULL);
	BINPUT_StockBallActorResourceLoad(bw->bip);
	BINPUT_PlayerBG_SetX(bw->bip, 256);
	BINPUT_EffBGWallSet(bw->bip);

	bw->soft_sprite=SoftSpriteInit(HEAPID_BATTLE);

	FightSystemBoot(bw,bp);

	FightParticleInit();	//p[eBN
	bw->wsp=WES_Create(HEAPID_BATTLE);

	FightOBJCreate(bw);

	InitTPSystem();			// ^b`plVXe
	InitTPNoBuff(4);

	//bZ[W}l[W쐬
	bw->fight_msg=MSGMAN_Create(MSGMAN_TYPE_NORMAL,ARC_MSG,NARC_msg_fightmsg_dp_dat,HEAPID_BATTLE);
	bw->attack_msg=MSGMAN_Create(MSGMAN_TYPE_NORMAL,ARC_MSG,NARC_msg_atkmsg_dat,HEAPID_BATTLE);
	//Pobt@쐬
	bw->wordset=WORDSET_Create(HEAPID_BATTLE);

	bw->msg_buf=STRBUF_Create(BATTLE_MESSAGE_BUF_SIZE,HEAPID_BATTLE);

	PaletteWork_Clear(bw->pfd,FADE_MAIN_BG,FADEBUF_TRANS,0xffff,0,159);
	PaletteWork_Clear(bw->pfd,FADE_MAIN_BG,FADEBUF_TRANS,0xffff,0x0c*16,0x0c*16+4*16);
	PaletteWork_Clear(bw->pfd,FADE_MAIN_BG,FADEBUF_TRANS,0x0000,0x0a*16,0x0a*16+2*16);
	PaletteWork_Clear(bw->pfd,FADE_SUB_BG,FADEBUF_TRANS,0xffff,0,255);

	//bZ[WEChEpDSACRpbgAj
	bw->msg_icon=MSG_DsIconFlashAdd(bw->pfd,MSG_DSI_MAINDISP,0x0b,HEAPID_BATTLE);
	MSG_DsIconFlashReq(bw->msg_icon,MSG_DSI_REQ_STOP);

	bw->update_tcb = TCB_Add(FightUpdate, bw, TCBPRI_FIGHT_UPDATE);

	//n`IDnRs[
	bw->ground_id=bp->ground_id;
	bw->bg_id=bp->bg_id;

	//퓬ʃtORs[
	bw->battle_status_flag=bp->battle_status_flag;

	//L[AUTO
	MsgPrintAutoFlagSet(MSG_AUTO_ON);
}

//============================================================================================
/**
 * @param
 */
//============================================================================================

static	int		FightMain(PROC *proc)
{
	BATTLE_WORK	*bw=PROC_GetWork(proc);
	int	i;

	if(bw->server_flag){
		if(bw->fight_type&FIGHT_TYPE_SIO){
			ServerMain(bw,bw->server_param);
		}
		else{
			bw->fight_end_flag=ServerMain(bw,bw->server_param);
		}
	}
	for(i=0;i<bw->client_set_max;i++){
		ClientMain(bw,bw->client_param[i]);
	}

#if 0	//AN^[̍XV͏̍ŌōsׁATCBֈڂ 2005.10.27() matsuda
		//MainProcŐɃAN^[XVĂ܂ƁǍTCBŃAN^[Ă
		//f1t[xɂȂĂ܂B
		//]䕔mFς
	
	if(bw->proc_mode==BW_PROC_MODE_FIGHT){
		SoftSpriteMain(bw->soft_sprite);
		BattleParticle_Main();
		CATS_Draw(bw->crp);
		CATS_UpdateTransfer();
		G3_SwapBuffers(GX_SORTMODE_MANUAL, GX_BUFFERMODE_Z);
	}
#endif
	return bw->fight_end_flag;
}

//============================================================================================
/**
 * @param
 */
//============================================================================================
static	void	FightEnd(PROC *proc)
{
	BATTLE_WORK		*bw=PROC_GetWork(proc);
	BATTLE_PARAM	*bp=PROC_GetParentWork(proc);
	int	i;

	if(bw->fight_type==FIGHT_TYPE_2vs2_YASEI){
		{
			int	cnt;
			POKEMON_PARAM *pp;
			POKEMON_PARAM *pp2;

			for(cnt=0;cnt<3;cnt++){
				pp=PokeParty_GetMemberPointer(bw->poke_party[0],cnt);
				pp2=PokeParty_GetMemberPointer(bp->poke_party[0],cnt);
				PokeCopyPPtoPP(pp,pp2);
			}
		}
		for(i=0;i<CLIENT_MAX;i++){
			sys_FreeMemoryEz(bw->poke_party[i]);
			MI_CpuCopy8(bw->my_status[i],bp->my_status[i],MyStatus_GetWorkSize());
			sys_FreeMemoryEz(bw->my_status[i]);
		}
	}
	else{
		for(i=0;i<CLIENT_MAX;i++){
			PokeParty_Copy(bw->poke_party[i],bp->poke_party[i]);
			sys_FreeMemoryEz(bw->poke_party[i]);
			MI_CpuCopy8(bw->my_status[i],bp->my_status[i],MyStatus_GetWorkSize());
			sys_FreeMemoryEz(bw->my_status[i]);
		}
	}

	//bZ[WEChEDSACRpbgAjJ
	MSG_DsIconFlashReq(bw->msg_icon,MSG_DSI_REQ_FREE);

	//莝ACeRs[
	MyItem_Copy(bw->my_item,bp->my_item);
	sys_FreeMemoryEz(bw->my_item);

	//}Ӄ[NRs[
	ZukanWork_Copy(bw->zw,bp->zw);
	sys_FreeMemoryEz(bw->zw);

	bp->win_lose_flag=ST_ServerParamDataGet(bw,bw->server_param,ID_SP_win_lose_flag,NULL);

	//ZGtFNgpLWJobt@J
	for(i=0;i<CLIENT_MAX;i++){
		sys_FreeMemoryEz(bw->exchr_param[i].exchr_buffer);
	}

	sys_FreeMemoryEz(bw->msg_buf);

	//pbgtF[hVXe폜
	PaletteFadeWorkAllocFree(bw->pfd, FADE_MAIN_BG);
	PaletteFadeWorkAllocFree(bw->pfd, FADE_SUB_BG);
	PaletteFadeWorkAllocFree(bw->pfd, FADE_MAIN_OBJ);
	PaletteFadeWorkAllocFree(bw->pfd, FADE_SUB_OBJ);
	PaletteFadeFree(bw->pfd);

	//bZ[W}l[W̍폜
	MSGMAN_Delete(bw->fight_msg);
	MSGMAN_Delete(bw->attack_msg);

	//Pobt@폜
	WORDSET_Delete(bw->wordset);

	GF_BGL_BmpWinFree(bw->win,BATTLE_BMP_WIN_MAX);

	Particle_SystemExitAll();
	WES_Delete(bw->wsp);

	ServerEnd(bw->server_param);
	for(i=0;i<bw->client_set_max;i++){
		ClientEnd(bw->client_param[i]);
	}

	SoftSpriteEnd(bw->soft_sprite);

	FightScreenEnd(bw);		//폜֘A܂Ƃ߂Ă֐

	sys_FreeMemoryEz(bw->bgl);

	NUMFONT_Delete(bw->numfont_hp);
#if 1	//xnumfont_hpƓgp悤ɂȂ 2005.11.10()	check
	;
#else
	NUMFONT_Delete(bw->numfont_lv);
#endif
	FontProc_UnloadFont(FONT_BUTTON);

	TCB_Delete(bw->update_tcb);

	StopTP();		//^b`pl̏I

	//3D`n̏
	simple_3DBGExit();
	
	sys_FreeMemoryEz(bw);

}

//============================================================================================
/**
 *	퓬wiʏʐ
 */
//============================================================================================
static	void	FightBGCreate(BATTLE_WORK *bw, GF_BGL_INI *bgl)
{
	GF_Disp_GX_VisibleControlInit();

	//VRAMݒ
	{
		GF_BGL_DISPVRAM vramSetTable = {
			GX_VRAM_BG_128_A,				// C2DGWBG
			GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
			GX_VRAM_SUB_BG_32_H,			// Tu2DGWBG
			GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
			GX_VRAM_OBJ_64_E,				// C2DGWOBJ
			GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
			GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
			GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
			GX_VRAM_TEX_01_BC,				// eNX`C[WXbg
			GX_VRAM_TEXPLTT_01_FG			// eNX`pbgXbg
		};
		GF_Disp_SetBank( &vramSetTable );

		//VRAMNA
		MI_CpuClear32((void*)HW_BG_VRAM, HW_BG_VRAM_SIZE);
		MI_CpuClear32((void*)HW_DB_BG_VRAM, HW_DB_BG_VRAM_SIZE);
		MI_CpuClear32((void*)HW_OBJ_VRAM, HW_OBJ_VRAM_SIZE);
		MI_CpuClear32((void*)HW_DB_OBJ_VRAM, HW_DB_OBJ_VRAM_SIZE);
	}

	// BG SYSTEM
	{
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_3D,
		};
		GF_BGL_InitBG( &BGsys_data );
	}

	// uhݒ
	{
		bw->bld_init_req=1;
	}

	//Cʃt[ݒ
	{
		GF_BGL_BGCNT_HEADER TextBgCntDat[] = {
			///<FRAME1_M
			{
//				0, 0, 0x1000, 0, GF_BGL_SCRSIZ_512x256, GX_BG_COLORMODE_16,
				0, 0, 0x0800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
				GX_BG_SCRBASE_0x0000, GX_BG_CHARBASE_0x04000, GX_BG_EXTPLTT_01,
				BATTLE_BGPRI_WINDOW, 0, 0, FALSE
			},
			///<FRAME2_M
			{
				0, 0, 0x2000, 0, GF_BGL_SCRSIZ_512x512, GX_BG_COLORMODE_16,
				GX_BG_SCRBASE_0x1000, GX_BG_CHARBASE_0x0c000, GX_BG_EXTPLTT_01,
				BATTLE_BGPRI_EFFECT, 0, 0, FALSE
			},
			///<FRAME3_M
			{
				0, 0, 0x1000, 0, GF_BGL_SCRSIZ_512x256, GX_BG_COLORMODE_256,
				GX_BG_SCRBASE_0x3000, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
				BATTLE_BGPRI_BACKGROUND, 0, 0, FALSE
			},
		};
		GF_BGL_BGControlSet(bgl, GF_BGL_FRAME1_M, &TextBgCntDat[0], GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear(bgl, GF_BGL_FRAME1_M );
		GF_BGL_BGControlSet(bgl, GF_BGL_FRAME2_M, &TextBgCntDat[1], GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear(bgl, GF_BGL_FRAME2_M );
		GF_BGL_BGControlSet(bgl, GF_BGL_FRAME3_M, &TextBgCntDat[2], GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear(bgl, GF_BGL_FRAME3_M );

		G2_SetBG0Priority(BATTLE_3DBG_PRIORITY);
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );
	}
	//Tuʃt[ݒ
	{
		BINPUT_DefaultFrameSet(bgl);
	}

	//wiOtBbNf[^[h
	{
//		ArcUtil_BgCharSet(ARC_WINFRAME,TalkWinCgxArcGet(0),bgl,GF_BGL_FRAME1_M,1,0,1,HEAPID_BATTLE);
		TalkWinGraphicNullSet(bgl, GF_BGL_FRAME1_M,1,10,0,HEAPID_BATTLE);
		
		ArcUtil_BgCharSet(ARC_BATT_BG,BATTLE_BG00_NCGR_BIN,bgl,GF_BGL_FRAME3_M,0,0,1,HEAPID_BATTLE);
		//ArcUtil_PalSet(ARC_BATT_BG,BATTLE_BG00_NCLR,PALTYPE_MAIN_BG,0,0,HEAPID_BATTLE);
		PaletteWorkSet_Arc(bw->pfd, ARC_BATT_BG, BATT_BG00_D_NCLR, HEAPID_BATTLE, 
			FADE_MAIN_BG, 0, 0);
		PaletteWorkSet_Arc(bw->pfd, ARC_WINFRAME, TalkWinPalArcGet(0), HEAPID_BATTLE, 
			FADE_MAIN_BG, 0x20, 0x0a*0x10);
		PaletteWorkSet_Arc(bw->pfd, ARC_FONT, NARC_font_talk_ncrl, HEAPID_BATTLE, 
			FADE_MAIN_BG, 0x20, 0x0b*0x10);
		ArcUtil_ScrnSet(ARC_BATT_BG,BATTLE_BG00_NSCR_BIN,bgl,GF_BGL_FRAME3_M,0,0,1,HEAPID_BATTLE);

	}

	GF_Disp_DispOn();

	GF_Disp_GX_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_ON);
	GF_Disp_GXS_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_ON);
//	GX_SetOBJVRamModeChar(GX_OBJVRAMMODE_CHAR_1D_64K);
//	GXS_SetOBJVRamModeChar(GX_OBJVRAMMODE_CHAR_1D_32K);
	sys_VBlankFuncChange(FightVBlank,bw);
}

//============================================================================================
/**
 *	퓬OBJʏʐ
 */
//============================================================================================
static	void	FightOBJCreate(BATTLE_WORK *bw)
{
	Ground_ActorResourceSet(&bw->ground[GROUND_MINE],bw,GROUND_TYPE_NORMAL_MINE);
	Ground_ActorResourceSet(&bw->ground[GROUND_ENEMY], bw, GROUND_TYPE_NORMAL_ENEMY);

}

//============================================================================================
/**
 *	퓬wiʏI
 */
//============================================================================================
static	void	FightBGEnd(GF_BGL_INI *bgl)
{
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_OFF );
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );
	GF_BGL_BGControlExit(bgl, GF_BGL_FRAME1_M );
	GF_BGL_BGControlExit(bgl, GF_BGL_FRAME2_M );
	GF_BGL_BGControlExit(bgl, GF_BGL_FRAME3_M );
	//Tu
	BINPUT_FrameExit(bgl);
}

//============================================================================================
/**
 *	퓬OBJʏI
 */
//============================================================================================
static	void	FightOBJEnd(BATTLE_WORK *bw)
{
	int	i;

//폜
	for(i=0;i<GROUND_MAX;i++){
	  Ground_ActorResourceDel(&bw->ground[i]);
	}
}

//============================================================================================
/**
 *	퓬[`QNp[^e[u
 */
//============================================================================================
//1vs1f[^
static	const	u8 ClientTypeTable1vs1[]={
	{CLIENT_TYPE_AA},
	{CLIENT_TYPE_BB},
};

//ʐM1vs1f[^
static	const	u8 ClientTypeTableSIO1vs1[][2]={
	{
	{CLIENT_TYPE_AA},
	{CLIENT_TYPE_BB},
	},
	{
	{CLIENT_TYPE_BB},
	{CLIENT_TYPE_AA},
	},
};

//2vs2f[^
static	const	u8 ClientTypeTable2vs2[]={
	{CLIENT_TYPE_A},
	{CLIENT_TYPE_B},
	{CLIENT_TYPE_C},
	{CLIENT_TYPE_D},
};

//ʐM2vs2f[^
static	const	u8 ClientTypeTableSIO2vs2[][4]={
	{
	{CLIENT_TYPE_A},
	{CLIENT_TYPE_B},
	{CLIENT_TYPE_C},
	{CLIENT_TYPE_D},
	},
	{
	{CLIENT_TYPE_B},
	{CLIENT_TYPE_A},
	{CLIENT_TYPE_D},
	{CLIENT_TYPE_C},
	}
};

//ʐMMultif[^
static	const	u8 ClientTypeTableSIOMulti[][4]={
	//ʒu0
	{
	{CLIENT_TYPE_A},	//ʒu0
	{CLIENT_TYPE_D},	//ʒu1
	{CLIENT_TYPE_C},	//ʒu2
	{CLIENT_TYPE_B},	//ʒu3
	},
	//ʒu1
	{
	{CLIENT_TYPE_B},	//ʒu0
	{CLIENT_TYPE_C},	//ʒu1
	{CLIENT_TYPE_D},	//ʒu2
	{CLIENT_TYPE_A},	//ʒu3
	},
	//ʒu2
	{
	{CLIENT_TYPE_A},	//ʒu0
	{CLIENT_TYPE_D},	//ʒu1
	{CLIENT_TYPE_C},	//ʒu2
	{CLIENT_TYPE_B},	//ʒu3
	},
	//ʒu3
	{
	{CLIENT_TYPE_B},	//ʒu0
	{CLIENT_TYPE_C},	//ʒu1
	{CLIENT_TYPE_D},	//ʒu2
	{CLIENT_TYPE_A},	//ʒu3
	},
};

//============================================================================================
/**
 *	퓬[`QN
 *
 * @param[in]	battle_work	퓬[N\
 * @param[in]	bp			퓬p[^\
 */
//============================================================================================
static	void	FightSystemBoot(BATTLE_WORK *bw,BATTLE_PARAM *bp)
{
	int	i,j;
	FIGHT_SYSTEM_BOOT_PARAM	fsbp;
	POKEMON_PARAM *pp;
	POKEMON_PARAM *pp2;

	bw->fight_type=bp->fight_type;

	bw->server_param=ServerInit(bw);

	for(i=0;i<CLIENT_MAX;i++){
		bw->poke_party[i]=PokeParty_AllocPartyWork(HEAPID_BATTLE);
	}

	//ʐMΐ
	if(bw->fight_type&FIGHT_TYPE_SIO){
		CommCommandBattleInitialize(bw);
		{
			u8	sio_id=CommGetCurrentID();
			int	cnt;

			//bConnectID0̓zɃT[oN
			if(sio_id==0){
				bw->server_flag=1;
			}

			if(bw->fight_type&FIGHT_TYPE_MULTI){
				pp=PokemonParam_AllocWork(HEAPID_BATTLE);
				for(i=0;i<2;i++){
					for(j=0;j<POKEMON_TEMOTI_MAX;j++){
						PokeParty_Add(bw->poke_party[i],pp);
					}
				}
				sys_FreeMemoryEz(pp);
				for(i=0;i<CLIENT_MAX;i++){
					fsbp.client_no=i;
					fsbp.client_type=ClientTypeTableSIOMulti[CommGetStandNo(sio_id)][CommGetStandNo(i)];
					bw->client_param[i]=ClientInit(bw,&fsbp);
				}
				//莝|PZbg
				for(i=0;i<CLIENT_MAX;i++){
					cnt=PokeParty_GetPokeCount(bp->poke_party[i]);
					if(cnt>3){
						cnt=3;
					}
					//client_paramׂĐȂƌĂׂȂ̂ŁAʃ[v̒Ɉړ
					CT_UISet(bw,bw->client_param[i]);
					switch(CommGetStandNo(i)){
					case TRAINER_STAND_A:
						for(j=0;j<cnt;j++){
							pp=PokeParty_GetMemberPointer(bp->poke_party[i],j);
							pp2=PokeParty_GetMemberPointer(bw->poke_party[0],j);
							PokeCopyPPtoPP(pp,pp2);
						}
						ST_ServerParamDataPut(bw,bw->server_param,ID_SP_sel_mons_no,i,0);
						break;
					case TRAINER_STAND_B:
						for(j=0;j<cnt;j++){
							pp=PokeParty_GetMemberPointer(bp->poke_party[i],j);
							pp2=PokeParty_GetMemberPointer(bw->poke_party[1],j+3);
							PokeCopyPPtoPP(pp,pp2);
						}
						ST_ServerParamDataPut(bw,bw->server_param,ID_SP_sel_mons_no,i,3);
						break;
					case TRAINER_STAND_C:
						for(j=0;j<cnt;j++){
							pp=PokeParty_GetMemberPointer(bp->poke_party[i],j);
							pp2=PokeParty_GetMemberPointer(bw->poke_party[0],j+3);
							PokeCopyPPtoPP(pp,pp2);
						}
						ST_ServerParamDataPut(bw,bw->server_param,ID_SP_sel_mons_no,i,3);
						break;
					case TRAINER_STAND_D:
						for(j=0;j<cnt;j++){
							pp=PokeParty_GetMemberPointer(bp->poke_party[i],j);
							pp2=PokeParty_GetMemberPointer(bw->poke_party[1],j);
							PokeCopyPPtoPP(pp,pp2);
						}
						ST_ServerParamDataPut(bw,bw->server_param,ID_SP_sel_mons_no,i,0);
						break;
					default:
						GF_ASSERT("sȗʒuł\n");
						break;
					}
				}
				bw->client_set_max=CLIENT_MAX;
			}
			//2vs2
			else if(bw->fight_type&FIGHT_TYPE_2vs2){
				for(i=0;i<4;i++){
					fsbp.client_no=i;
					fsbp.client_type=ClientTypeTableSIO2vs2[sio_id][i];
					bw->client_param[i]=ClientInit(bw,&fsbp);
					CT_UISet(bw,bw->client_param[i]);
				}
				bw->client_set_max=i;
				//莝|PZbg
				for(i=0;i<CLIENT_MAX;i++){
					PokeParty_Copy(bp->poke_party[i],bw->poke_party[i]);
				}
				for(i=0;i<bw->client_set_max;i++){
					for(j=0;j<PokeParty_GetPokeCount(bw->poke_party[i&1]);j++){
						pp=PokeParty_GetMemberPointer(bw->poke_party[i&1],j);
						if(i>1){
							if((ST_ServerParamDataGet(bw,bw->server_param,ID_SP_sel_mons_no,i&1)!=j)&&
							   (PokeParaGet(pp,ID_PARA_hp,NULL))){
								break;
							}
						}
						else{
							if(PokeParaGet(pp,ID_PARA_hp,NULL)){
								break;
							}
						}
					}
					ST_ServerParamDataPut(bw,bw->server_param,ID_SP_sel_mons_no,i,j);
				}
			}
			//1vs1
			else{
				for(i=0;i<2;i++){
					fsbp.client_no=i;
					fsbp.client_type=ClientTypeTableSIO1vs1[sio_id][i];
					bw->client_param[i]=ClientInit(bw,&fsbp);
					CT_UISet(bw,bw->client_param[i]);
				}
				bw->client_set_max=i;
				//莝|PZbg
				for(i=0;i<CLIENT_MAX;i++){
					PokeParty_Copy(bp->poke_party[i],bw->poke_party[i]);
					for(j=0;j<PokeParty_GetPokeCount(bw->poke_party[i]);j++){
						pp=PokeParty_GetMemberPointer(bw->poke_party[i],j);
						if(PokeParaGet(pp,ID_PARA_hp,NULL)){
							break;
						}
					}
					ST_ServerParamDataPut(bw,bw->server_param,ID_SP_sel_mons_no,i,j);
				}
			}
		}
	}
	else if(bw->fight_type&FIGHT_TYPE_MULTI){
		{
			int	cnt;
			pp=PokemonParam_AllocWork(HEAPID_BATTLE);
			for(i=0;i<2;i++){
				for(j=0;j<POKEMON_TEMOTI_MAX;j++){
					PokeParty_Add(bw->poke_party[i],pp);
				}
			}
			sys_FreeMemoryEz(pp);
			for(i=0;i<CLIENT_MAX;i++){
				fsbp.client_no=i;
				fsbp.client_type=ClientTypeTable2vs2[i];
				bw->client_param[i]=ClientInit(bw,&fsbp);
				CT_UISet(bw,bw->client_param[i]);
			}
			//莝|PZbg
			for(i=0;i<CLIENT_MAX;i++){
				cnt=PokeParty_GetPokeCount(bp->poke_party[i]);
				if(cnt>3){
					cnt=3;
				}
				switch(i){
				case 0:
					for(j=0;j<cnt;j++){
						pp=PokeParty_GetMemberPointer(bp->poke_party[i],j);
						pp2=PokeParty_GetMemberPointer(bw->poke_party[0],j);
						PokeCopyPPtoPP(pp,pp2);
					}
					ST_ServerParamDataPut(bw,bw->server_param,ID_SP_sel_mons_no,i,0);
					break;
				case 1:
					for(j=0;j<cnt;j++){
						pp=PokeParty_GetMemberPointer(bp->poke_party[i],j);
						pp2=PokeParty_GetMemberPointer(bw->poke_party[1],j);
						PokeCopyPPtoPP(pp,pp2);
					}
					ST_ServerParamDataPut(bw,bw->server_param,ID_SP_sel_mons_no,i,0);
					break;
				case 2:
					for(j=0;j<cnt;j++){
						pp=PokeParty_GetMemberPointer(bp->poke_party[i],j);
						pp2=PokeParty_GetMemberPointer(bw->poke_party[0],j+3);
						PokeCopyPPtoPP(pp,pp2);
					}
					ST_ServerParamDataPut(bw,bw->server_param,ID_SP_sel_mons_no,i,3);
					break;
				case 3:
					for(j=0;j<cnt;j++){
						pp=PokeParty_GetMemberPointer(bp->poke_party[i],j);
						pp2=PokeParty_GetMemberPointer(bw->poke_party[1],j+3);
						PokeCopyPPtoPP(pp,pp2);
					}
					ST_ServerParamDataPut(bw,bw->server_param,ID_SP_sel_mons_no,i,3);
					break;
				}
			}
			bw->server_flag=1;
			bw->client_set_max=CLIENT_MAX;
		}
	}
	//2vs2ŋN
	else if(bw->fight_type&FIGHT_TYPE_2vs2){
		for(i=0;i<4;i++){
			fsbp.client_no=i;
			fsbp.client_type=ClientTypeTable2vs2[i];
			bw->client_param[i]=ClientInit(bw,&fsbp);
			CT_UISet(bw,bw->client_param[i]);
		}
		bw->client_set_max=i;
		//莝|PZbg
		for(i=0;i<CLIENT_MAX;i++){
			PokeParty_Copy(bp->poke_party[i],bw->poke_party[i]);
		}
		for(i=0;i<bw->client_set_max;i++){
			for(j=0;j<PokeParty_GetPokeCount(bw->poke_party[i&1]);j++){
				pp=PokeParty_GetMemberPointer(bw->poke_party[i&1],j);
				if(i>1){
					if((ST_ServerParamDataGet(bw,bw->server_param,ID_SP_sel_mons_no,i&1)!=j)&&
					   (PokeParaGet(pp,ID_PARA_hp,NULL))){
						break;
					}
				}
				else{
					if(PokeParaGet(pp,ID_PARA_hp,NULL)){
						break;
					}
				}
			}
			ST_ServerParamDataPut(bw,bw->server_param,ID_SP_sel_mons_no,i,j);
		}
		bw->server_flag=1;
	}
	//1vs1ŋN
	else{
		for(i=0;i<2;i++){
			fsbp.client_no=i;
			fsbp.client_type=ClientTypeTable1vs1[i];
			bw->client_param[i]=ClientInit(bw,&fsbp);
			CT_UISet(bw,bw->client_param[i]);
		}
		bw->client_set_max=i;
		//莝|PZbg
		for(i=0;i<CLIENT_MAX;i++){
			PokeParty_Copy(bp->poke_party[i],bw->poke_party[i]);
			for(j=0;j<PokeParty_GetPokeCount(bw->poke_party[i]);j++){
				pp=PokeParty_GetMemberPointer(bw->poke_party[i],j);
				if(PokeParaGet(pp,ID_PARA_hp,NULL)){
					break;
				}
			}
			ST_ServerParamDataPut(bw,bw->server_param,ID_SP_sel_mons_no,i,j);
		}
		bw->server_flag=1;
	}


	//g[i[IDZbg
	if(bw->fight_type&FIGHT_TYPE_SIO){
		bw->trainer_id[0]=0;
		bw->trainer_id[1]=0;
		bw->trainer_id[2]=0;
		bw->trainer_id[3]=0;
	}
	else if(bw->fight_type&FIGHT_TYPE_TRAINER){
		bw->trainer_id[0]=0;
		bw->trainer_id[1]=bp->trainer_id[0];
		bw->trainer_id[2]=0;
		bw->trainer_id[3]=bp->trainer_id[1];
	}
}

//============================================================================================
/**
 *	퓬pp[eBN
 */
//============================================================================================
static	void	FightParticleInit(void)
{
	//--------------------------------------------------------------
	//	
	//--------------------------------------------------------------
	// }l[WeNX`C[WXbgwXbgǗł悤ɂ
	// ftHg}l[WɂB
	NNS_GfdInitFrmTexVramManager(2, TRUE);
		
	// }l[Wpbg32KBǗł悤ɂ
	// ftHg}l[WɂB
	NNS_GfdInitFrmPlttVramManager(0x8000, TRUE);

	//|PŎgp镪m
	NNS_GfdAllocFrmTexVram(0x4000, 0, 0);
	NNS_GfdAllocFrmPlttVram(0x20 * 4, 0, NNS_GFD_ALLOC_FROM_LOW);

	//p[eBNVXe[N
	Particle_SystemWorkInit();
}

//--------------------------------------------------------------
/**
 * @brief	VBLANK֐
 *
 * @param	work	VBLankɂ͈KvȂ̂Œ`Ă邪ۂɂNULLĂ̂ŁAANZX͋֎~I
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static	void	FightVBlank(void *work)
{
	BATTLE_WORK *bw = work;

	if(bw->bld_init_req){
		bw->bld_init_req=0;
		G2_BlendNone();
		G2S_BlendNone();
	}

	SoftSpriteTextureTrans(bw->soft_sprite);
	
	DoVramTransferManager();	// Vram]}l[W[s
	CATS_RenderOamTrans();
	PaletteFadeTrans(bw->pfd);

	GF_BGL_VBlankFunc( bw->bgl );

	OS_SetIrqCheckFlag( OS_IE_V_BLANK);
}

//--------------------------------------------------------------
/**
 * @brief   C[v̍ŌɍsVXe֘A̍XV
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		bw
 */
//--------------------------------------------------------------
static void FightUpdate(TCB_PTR tcb, void *work)
{
	BATTLE_WORK *bw = work;
	
	SoftSpriteMain(bw->soft_sprite);
	BattleParticle_Main();
	CATS_Draw(bw->crp);
	CATS_UpdateTransfer();
	GF_G3_RequestSwapBuffers(GX_SORTMODE_MANUAL, GX_BUFFERMODE_Z);
}

//--------------------------------------------------------------
/**
 * @brief   
 *
 * ProcDataŎw肵ȊÕI[o[C̃[hs
 *
 */
//--------------------------------------------------------------
static void NitroStaticInit(void)
{
	Overlay_Load(FS_OVERLAY_ID(bc_common), OVERLAY_LOAD_NOT_SYNCHRONIZE);
}

//--------------------------------------------------------------
/**
 * @brief   ʐMΐ펞̑ΐO莝|PXg\[`
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		bw
 */
//--------------------------------------------------------------
static	void	FightSioInit(PROC *proc,BATTLE_PARAM *bp)
{
	BATTLE_SIO_WORK	*bsw=PROC_AllocWork(proc,sizeof(BATTLE_SIO_WORK), HEAPID_BATTLE);

	bsw->bp=bp;
	bsw->send_count=0;
	bsw->seq_no=0;

	CommCommandBattleCPInitialize(bsw);
}

enum{
	FSM_SEQ_SEND_SV_DATA=0,
	FSM_SEQ_SEND_SV_DATA_WAIT,
	FSM_SEQ_SEND_MS_DATA,
	FSM_SEQ_SEND_MS_DATA_WAIT,
	FSM_SEQ_SEND_POKE_DATA,
	FSM_SEQ_SEND_POKE_DATA_WAIT,
	FSM_SEQ_SEND_DATA_END
};

static	BOOL	FightSioMain(PROC *proc)
{
	BATTLE_SIO_WORK	*bsw=PROC_GetWork(proc);
	BOOL			ret;

	ret=FALSE;

	switch(bsw->seq_no){
	case FSM_SEQ_SEND_SV_DATA:
		if(CommCommandBattleSendServerVersionData(bsw,BattleServerVersion)==TRUE){
			bsw->seq_no++;
		}
		break;
	case FSM_SEQ_SEND_MS_DATA:
		if(CommCommandBattleSendMyStatusData(bsw)==TRUE){
			bsw->seq_no++;
		}
		break;
	case FSM_SEQ_SEND_POKE_DATA:
		if(CommCommandBattleSendPokeData(bsw)==TRUE){
			bsw->seq_no++;
		}
		break;
	case FSM_SEQ_SEND_SV_DATA_WAIT:
	case FSM_SEQ_SEND_MS_DATA_WAIT:
	case FSM_SEQ_SEND_POKE_DATA_WAIT:
		if(bsw->send_count==CommGetConnectNum()){
			bsw->send_count=0;
			bsw->seq_no++;
		}
		break;
	case FSM_SEQ_SEND_DATA_END:
		ret=TRUE;
		break;
	}

	return ret;
}

static	void	FightSioEnd(PROC *proc)
{
	BATTLE_SIO_WORK	*bsw=PROC_GetWork(proc);

	sys_FreeMemoryEz(bsw);
}

