
//============================================================================================
/**
 * @file	fight_def.h
 * @bfief	퓬CvO
 * @author	HisashiSogabe
 * @date	05.05.24
 */
//============================================================================================

#include	"battle/battle_common.h"
#include	"poketool/poke_tool.h"
#include	"../src/poketool/poke_tool_def.h"
#include	"battle/server.h"
#include	"battle/client.h"
#include	"system/softsprite.h"
#include	"wazaeffect/we_mana.h"
#include	"system/clact_tool.h"
#include	"battle/ground.h"
#include	"battle/battle_input.h"
#include "system/numfont.h"
#include "system/msgdata.h"
#include "system/wordset.h"
#include "system/palanm.h"
#include "system/gra_tool.h"

#ifndef __FIGHT_DEF_H_
#define __FIGHT_DEF_H_

typedef struct _MYSTATUS MYSTATUS;
typedef struct _MYITEM MYITEM;
typedef struct _POKEPARTY POKEPARTY;
typedef struct _ZUKAN_WORK ZUKAN_WORK;
typedef struct _BOX_DATA BOX_DATA;

///<퓬p[N\̐錾
struct battle_work
{
	GF_BGL_INI			*bgl;
	GF_BGL_BMPWIN		*win;
	MSGDATA_MANAGER		*fight_msg;					///<퓬bZ[WpbZ[Wf[^}l[W̃|C^
	MSGDATA_MANAGER		*attack_msg;				///<퓬bZ[WpbZ[Wf[^}l[W̃|C^iA^bNbZ[Wj
	WORDSET				*wordset;					///<퓬bZ[WpPobt@
	STRBUF				*msg_buf;					///<bZ[WpɊmۂ[Nւ̃|C^
	TCB_PTR				update_tcb;
	PALETTE_FADE_PTR	pfd;						///<pbgtF[hVXe[Nւ̃|C^
	u32					fight_type;
	SERVER_PARAM		*server_param;
	CLIENT_PARAM		*client_param[CLIENT_MAX];
	int					client_set_max;
	MYSTATUS			*my_status[CLIENT_MAX];		///<v[[
	MYITEM				*my_item;					///<莝ACe
	ZUKAN_WORK			*zw;						///<}Ӄ[N
	BOX_DATA			*box;						///<{bNXf[^
	POKEPARTY			*poke_party[CLIENT_MAX];	///<莝|P̍\
	SOFT_SPRITE_MANAGER	*soft_sprite;
	WE_SYS_PTR			wsp;
	CATS_SYS_PTR		csp;
	CATS_RES_PTR		crp;
	u16					trainer_id[CLIENT_MAX];
	u8					trainer_sex[CLIENT_MAX];
	GROUND_WORK			ground[GROUND_MAX];			///<nʃ[N(@ + G)
	BI_PARAM_PTR		bip;						///<퓬͉ʃVXe[Nւ̃|C^
	NUMFONT				*numfont_hp;				///<8x8tHg(HPp)
	NUMFONT				*numfont_lv;				///<8x8tHg(xp)
	void				*msg_icon;					///<bZ[WEChEDSACRp|C^

	EXCHR_PARAM			exchr_param[CLIENT_MAX];	///<ZGtFNgp|PLWJp[^

	u8					sio_send_buffer[BATTLE_SIO_BUF_SIZE];	///<ʐMMobt@
	u8					sio_recv_buffer[BATTLE_SIO_BUF_SIZE];	///<ʐMMobt@
	u16					sio_send_read;							///<ʐMMobt@ǂݍ݈ʒu
	u16					sio_send_write;							///<ʐMMobt@݈ʒu
	u16					sio_send_over;							///<ʐMMobt@ݎɃI[o[Ƃ̃[N
	u16					sio_recv_read;							///<ʐMMobt@ǂݍ݈ʒu
	u16					sio_recv_write;							///<ʐMMobt@݈ʒu
	u16					sio_recv_over;							///<ʐMMobt@ݎɃI[o[Ƃ̃[N

	u8					*tcb_sio_send_seq_no;					///<ʐMMTCB̃V[PXio[ւ̃|C^
	u8					*tcb_sio_recv_seq_no;					///<ʐMMTCB̃V[PXio[ւ̃|C^

	u8					server_flag;				///<T[oNĂ邩tO
	u8					proc_mode;					///<퓬VXe̓샂[h
	u8					bld_init_req;				///<uhݒ菉vtO
	u8					fight_end_flag;				///<퓬ItO

	int					ground_id;					///<n`ID
	int					bg_id;						///<wiID
	u32					battle_status_flag;			///<퓬ʃtO
};

#endif __FIGHT_DEF_H_
