
//============================================================================================
/**
 * @file	fight_tool.c
 * @bfief	퓬VXepc[vO
 * @author	HisashiSogabe
 * @date	05.07.22
 */
//============================================================================================

#include "common.h"
#include "battle/battle_server.h"
#include "battle/fight.h"
#include "battle/fight_def.h"
#include "battle/client_tool.h"
#include "battle/server_tool.h"
#include "battle/attr_def.h"

#include "poketool/pokeparty.h"
#include "poketool/tr_tool.h"

#include "system/mystatus.h"
#include "system/numfont.h"
#include "system/fontproc.h"
#include "system/msgdata.h"
#include "system/wordset.h"
#include "system/zukanwork.h"
#include "msgdata/msg.naix"

#include "gauge.h"

#include "itemtool\item.h"

//============================================================================================
//	vg^Cv錾
//============================================================================================

GF_BGL_INI			*BattleWorkGF_BGL_INIGet(BATTLE_WORK *bw);
GF_BGL_BMPWIN		*BattleWorkGF_BGL_BMPWINGet(BATTLE_WORK *bw);
u32					BattleWorkFightTypeGet(BATTLE_WORK *bw);
SERVER_PARAM		*BattleWorkServerParamGet(BATTLE_WORK *bw);
CLIENT_PARAM		*BattleWorkClientParamGet(BATTLE_WORK *bw,int client_no);
int					BattleWorkClientSetMaxGet(BATTLE_WORK *bw);
POKEPARTY			*BattleWorkPokePartyGet(BATTLE_WORK *bw,int client_no);
int					BattleWorkPokeCountGet(BATTLE_WORK *bw,int client_no);
POKEMON_PARAM		*BattleWorkPokemonParamGet(BATTLE_WORK *bw,int client_no,int sel_mons_no);
SOFT_SPRITE_MANAGER	*BattleWorkSoftSpriteManagerGet(BATTLE_WORK *bw);
WE_SYS_PTR			BattleWorkWE_SYS_PTRGet(BATTLE_WORK *bw);
CATS_SYS_PTR		BattleWorkCATS_SYS_PTRGet(BATTLE_WORK *bw);
CATS_RES_PTR		BattleWorkCATS_RES_PTRGet(BATTLE_WORK *bw);
GROUND_WORK			*BattleWorkGroundWorkGet(BATTLE_WORK *bw,int ground_no);
BI_PARAM_PTR		BattleWorkGF_BGL_BIPGet(BATTLE_WORK *bw);
NUMFONT				*BattleWorkGF_BGL_NumFontHPGet(BATTLE_WORK *bw);
NUMFONT				*BattleWorkGF_BGL_NumFontLVGet(BATTLE_WORK *bw);
MSGDATA_MANAGER		*BattleWorkFightMsgGet(BATTLE_WORK *bw);
MSGDATA_MANAGER		*BattleWorkAttackMsgGet(BATTLE_WORK *bw);
PALETTE_FADE_PTR	BattleWorkPfdGet(BATTLE_WORK *bw);
u8					*BattleWorkSioSendBufGet(BATTLE_WORK *bw);
u8					*BattleWorkSioRecvBufGet(BATTLE_WORK *bw);
u16					*BattleWorkSioSendReadGet(BATTLE_WORK *bw);
u16					*BattleWorkSioSendWriteGet(BATTLE_WORK *bw);
u16					*BattleWorkSioSendOverGet(BATTLE_WORK *bw);
u16					*BattleWorkSioRecvReadGet(BATTLE_WORK *bw);
u16					*BattleWorkSioRecvWriteGet(BATTLE_WORK *bw);
u16					*BattleWorkSioRecvOverGet(BATTLE_WORK *bw);
EXCHR_PARAM			*BattleWorkExChrParamGet(BATTLE_WORK *bw);
WORDSET				*BattleWorkWORDSETGet(BATTLE_WORK *bw);
STRBUF				*BattleWorkSTRBUFGet(BATTLE_WORK *bw);
u16					BattleWorkTrainerIDGet(BATTLE_WORK *bw,int client_no);
MYSTATUS			*BattleWorkMyStatusGet(BATTLE_WORK *bw,int client_no);
MYITEM				*BattleWorkMyItemGet(BATTLE_WORK *bw);
u32					BattleWorkMySexGet(BATTLE_WORK *bw,int client_no);
u8					BattleWorkClientTypeGet(BATTLE_WORK *bw,int client_no);
u8					BattleWorkMineEnemyCheck(BATTLE_WORK *bw,int client_no);
void				*BattleWorkMsgIconGet(BATTLE_WORK *bw);
BOX_DATA			*BattleWorkBoxDataGet(BATTLE_WORK *bw);
int					BattleWorkGroundIDGet(BATTLE_WORK *bw);
int					BattleWorkBGIDGet(BATTLE_WORK *bw);
int					BattleWorkPartnerClientNoGet(BATTLE_WORK *bw,int client_no);
BOOL				BattleWorkStatusRecover(BATTLE_WORK *bw,int client_no,int sel_mons_no,int waza_pos,int item_no);
u32					BattleWorkBattleStatusFlagGet(BATTLE_WORK *bw);

u8					*ExChrParamExChrBufferGet(EXCHR_PARAM *ep,int no);
int					ExChrParamPalIndexGet(EXCHR_PARAM *ep,int no);
void				ExChrParamPalIndexSet(EXCHR_PARAM *ep,int no,int data);
int					ExChrParamHeightGet(EXCHR_PARAM *ep,int no);
void				ExChrParamHeightSet(EXCHR_PARAM *ep,int no,int data);

void				BattleWorkProcModeSet(BATTLE_WORK *bw,int mode);
void				BattleWorkTSSSeqNoAdrsSet(BATTLE_WORK *bw,u8 *seq_no);
void				BattleWorkTSRSeqNoAdrsSet(BATTLE_WORK *bw,u8 *seq_no);
void				BattleWorkTSSSeqNoSet(BATTLE_WORK *bw,u8 seq_no);
void				BattleWorkTSRSeqNoSet(BATTLE_WORK *bw,u8 seq_no);
void				BattleWorkFightEndFlagSet(BATTLE_WORK *bw,u8 data);
void				BattleWorkGaugeOn(BATTLE_WORK *bw);
void				BattleWorkGaugeOff(BATTLE_WORK *bw);

void				BattleClientNoBufMake(BATTLE_WORK *bw,u8 *buf);
void				BattleClientTypeBufMake(BATTLE_WORK *bw,u8 *buf);
void				BattleSoftSpriteBufMake(BATTLE_WORK *bw,SOFT_SPRITE **buf);

void				BattleGaugePriSet(BATTLE_WORK *bw,int pri);
u32					CalcLosePenalty(POKEPARTY *ppt,MYSTATUS *my_status);

void				FT_ZukanFlagSetSee(BATTLE_WORK *bw,int client_no);
void				FT_ZukanFlagSetGet(BATTLE_WORK *bw,int client_no);
BOOL				FT_ZukanFlagCheckGet(BATTLE_WORK *bw,int mons_no);

void				BattleDefaultBlendSet(void);

u8					TrainerMSG_Print(BATTLE_WORK *bw,GF_BGL_BMPWIN *win,int tr_id,int msg_type,int wait);
u8					BattleMSG_Print(BATTLE_WORK *bw,GF_BGL_BMPWIN *win,MSGDATA_MANAGER *msg_m,MESSAGE_PARAM *mp,int wait);

u32					No2Bit(int no);
int					Bit2No(u32 bit);

static	void	BattleMSG_DirCheck(BATTLE_WORK *bw,MESSAGE_PARAM *mp);
static	void	BattleMSG_TagExpand(BATTLE_WORK *bw,MESSAGE_PARAM *mp);
static	void	BattleMSG_MsgExpand(BATTLE_WORK *bw,MSGDATA_MANAGER *msg_m,MESSAGE_PARAM *mp);

static	void	BattleMSG_NicknameGet(BATTLE_WORK *bw,	u32 buf_id,int para);
static	void	BattleMSG_WazaGet(BATTLE_WORK *bw,		u32 buf_id,int para);
static	void	BattleMSG_ItemGet(BATTLE_WORK *bw,		u32 buf_id,int para);
static	void	BattleMSG_NumGet(BATTLE_WORK *bw,		u32 buf_id,int para);
static	void	BattleMSG_TypeGet(BATTLE_WORK *bw,		u32 buf_id,int para);
static	void	BattleMSG_TokuseiGet(BATTLE_WORK *bw,	u32 buf_id,int para);
static	void	BattleMSG_StatusGet(BATTLE_WORK *bw,	u32 buf_id,int para);
static	void	BattleMSG_ConditionGet(BATTLE_WORK *bw,	u32 buf_id,int para);
static	void	BattleMSG_PokenameGet(BATTLE_WORK *bw,	u32 buf_id,int para);
static	void	BattleMSG_PolockGet(BATTLE_WORK *bw,	u32 buf_id,int para);
static	void	BattleMSG_TasteGet(BATTLE_WORK *bw,		u32 buf_id,int para);
static	void	BattleMSG_TRTypeGet(BATTLE_WORK *bw,	u32 buf_id,int para);
static	void	BattleMSG_TRNameGet(BATTLE_WORK *bw,	u32 buf_id,int para);

//============================================================================================
//	BattleWork\̃[N擾֐Q
//============================================================================================
//============================================================================================
/**
 *	GF_BGL_INI擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	bgl
 */
//============================================================================================
GF_BGL_INI	*BattleWorkGF_BGL_INIGet(BATTLE_WORK *bw)
{
	return	bw->bgl;
}

//============================================================================================
/**
 *	GF_BGL_BMPWIN擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	win
 */
//============================================================================================
GF_BGL_BMPWIN	*BattleWorkGF_BGL_BMPWINGet(BATTLE_WORK *bw)
{
	return	bw->win;
}

//============================================================================================
/**
 *	fight_type擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	fight_type
 */
//============================================================================================
u32	BattleWorkFightTypeGet(BATTLE_WORK *bw)
{
	return	bw->fight_type;
}

//============================================================================================
/**
 *	server_param擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	server_param
 */
//============================================================================================
SERVER_PARAM	*BattleWorkServerParamGet(BATTLE_WORK *bw)
{
	return	bw->server_param;
}

//============================================================================================
/**
 *	client_param擾
 *
 * @param[in]	bw			퓬[N\
 * @param[in]	client_no	擾client_no
 *
 * @retval	client_param
 */
//============================================================================================
CLIENT_PARAM	*BattleWorkClientParamGet(BATTLE_WORK *bw,int client_no)
{
	return	bw->client_param[client_no];
}

//============================================================================================
/**
 *	client_set_max擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	client_set_max
 */
//============================================================================================
int	BattleWorkClientSetMaxGet(BATTLE_WORK *bw)
{
	return	bw->client_set_max;
}

//============================================================================================
/**
 *	POKEPARTY擾
 *
 * @param[in]	bw			퓬[N\
 * @param[in]	client_no	擾client_no
 *
 * @retval	poke_party[client_no]
 */
//============================================================================================
POKEPARTY		*BattleWorkPokePartyGet(BATTLE_WORK *bw,int client_no)
{
	if(bw->fight_type&FIGHT_TYPE_2vs2){
		return	bw->poke_party[client_no&1];
	}
	else{
		return	bw->poke_party[client_no];
	}
}

//============================================================================================
/**
 *	PokeCount擾
 *
 * @param[in]	bw			퓬[N\
 * @param[in]	client_no	擾client_no
 *
 * @retval	poke_party[client_no]->PokeCount
 */
//============================================================================================
int	BattleWorkPokeCountGet(BATTLE_WORK *bw,int client_no)
{
	if(bw->fight_type&FIGHT_TYPE_2vs2){
		return	PokeParty_GetPokeCount(bw->poke_party[client_no&1]);
	}
	else{
		return	PokeParty_GetPokeCount(bw->poke_party[client_no]);
	}
}

//============================================================================================
/**
 *	PokemonParam擾
 *
 * @param[in]	bw			퓬[N\
 * @param[in]	client_no	擾client_no
 * @param[in]	sel_mons_no	擾PokemonParam̐擪̈ʒu
 *
 * @retval	pp[client_no][sel_mons_no]
 */
//============================================================================================
POKEMON_PARAM	*BattleWorkPokemonParamGet(BATTLE_WORK *bw,int client_no,int sel_mons_no)
{
	if(bw->fight_type&FIGHT_TYPE_2vs2){
		return	PokeParty_GetMemberPointer(bw->poke_party[client_no&1],sel_mons_no);
	}
	else{
		return	PokeParty_GetMemberPointer(bw->poke_party[client_no],sel_mons_no);
	}
}

//============================================================================================
/**
 *	soft_sprite_manager擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	soft_sprite_manager
 */
//============================================================================================
SOFT_SPRITE_MANAGER	*BattleWorkSoftSpriteManagerGet(BATTLE_WORK *bw)
{
	return	bw->soft_sprite;
}

//============================================================================================
/**
 *	wsp擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	wsp
 */
//============================================================================================
WE_SYS_PTR	BattleWorkWE_SYS_PTRGet(BATTLE_WORK *bw)
{
	return bw->wsp;
}

//============================================================================================
/**
 *	csp擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	csp
 */
//============================================================================================
CATS_SYS_PTR		BattleWorkCATS_SYS_PTRGet(BATTLE_WORK *bw)
{
	return bw->csp;
}

//============================================================================================
/**
 *	csp擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	crp
 */
//============================================================================================
CATS_RES_PTR		BattleWorkCATS_RES_PTRGet(BATTLE_WORK *bw)
{
	return bw->crp;
}

//============================================================================================
/**
 *	GROUND_WORK擾
 *
 * @param[in]	bw			퓬[N\
 * @param[in]	ground_no	GroundNo
 *
 * @retval	GROUND_WORK
 */
//============================================================================================
GROUND_WORK			*BattleWorkGroundWorkGet(BATTLE_WORK *bw,int ground_no)
{
	return &bw->ground[ground_no];
}

//============================================================================================
/**
 *	bip擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	bip
 */
//============================================================================================
BI_PARAM_PTR	BattleWorkGF_BGL_BIPGet(BATTLE_WORK *bw)
{
	return	bw->bip;
}

//============================================================================================
/**
 *	numfont_hp擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	numfont_hp
 */
//============================================================================================
NUMFONT *	BattleWorkGF_BGL_NumFontHPGet(BATTLE_WORK *bw)
{
	return	bw->numfont_hp;
}

//============================================================================================
/**
 *	numfont_lv擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	numfont_lv
 */
//============================================================================================
NUMFONT *	BattleWorkGF_BGL_NumFontLVGet(BATTLE_WORK *bw)
{
	return	bw->numfont_lv;
}

//============================================================================================
/**
 *	fight_msg擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	fight_msg
 */
//============================================================================================
MSGDATA_MANAGER		*BattleWorkFightMsgGet(BATTLE_WORK *bw)
{
	return bw->fight_msg;
}

//============================================================================================
/**
 *	attack_msg擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	attack_msg
 */
//============================================================================================
MSGDATA_MANAGER		*BattleWorkAttackMsgGet(BATTLE_WORK *bw)
{
	return bw->attack_msg;
}

//============================================================================================
/**
 *	pfd擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	pfd
 */
//============================================================================================
PALETTE_FADE_PTR		BattleWorkPfdGet(BATTLE_WORK *bw)
{
	return bw->pfd;
}

//============================================================================================
/**
 *	sio_send_buffer擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	sio_send_buffer
 */
//============================================================================================
u8	*BattleWorkSioSendBufGet(BATTLE_WORK *bw)
{
	return &bw->sio_send_buffer[0];
}

//============================================================================================
/**
 *	sio_recv_buffer擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	sio_recv_buffer
 */
//============================================================================================
u8	*BattleWorkSioRecvBufGet(BATTLE_WORK *bw)
{
	return &bw->sio_recv_buffer[0];
}

//============================================================================================
/**
 *	sio_send_read擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	sio_send_read
 */
//============================================================================================
u16	*BattleWorkSioSendReadGet(BATTLE_WORK *bw)
{
	return &bw->sio_send_read;
}

//============================================================================================
/**
 *	sio_send_write擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	sio_send_write
 */
//============================================================================================
u16	*BattleWorkSioSendWriteGet(BATTLE_WORK *bw)
{
	return &bw->sio_send_write;
}

//============================================================================================
/**
 *	sio_send_over擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	sio_send_over
 */
//============================================================================================
u16	*BattleWorkSioSendOverGet(BATTLE_WORK *bw)
{
	return &bw->sio_send_over;
}

//============================================================================================
/**
 *	sio_recv_read擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	sio_recv_read
 */
//============================================================================================
u16	*BattleWorkSioRecvReadGet(BATTLE_WORK *bw)
{
	return &bw->sio_recv_read;
}

//============================================================================================
/**
 *	sio_recv_write擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	sio_recv_write
 */
//============================================================================================
u16	*BattleWorkSioRecvWriteGet(BATTLE_WORK *bw)
{
	return &bw->sio_recv_write;
}

//============================================================================================
/**
 *	sio_recv_over擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	sio_recv_over
 */
//============================================================================================
u16	*BattleWorkSioRecvOverGet(BATTLE_WORK *bw)
{
	return &bw->sio_recv_over;
}

//============================================================================================
/**
 *	exchr_param擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	exchr_buffer
 */
//============================================================================================
EXCHR_PARAM	*BattleWorkExChrParamGet(BATTLE_WORK *bw)
{
	return &bw->exchr_param[0];
}

//============================================================================================
/**
 *	wordset擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	wordset
 */
//============================================================================================
WORDSET	*BattleWorkWORDSETGet(BATTLE_WORK *bw)
{
	return bw->wordset;
}

//============================================================================================
/**
 *	strbuf擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	msg_buf
 */
//============================================================================================
STRBUF	*BattleWorkSTRBUFGet(BATTLE_WORK *bw)
{
	return bw->msg_buf;
}

//============================================================================================
/**
 *	g[i[ID擾
 *
 * @param[in]	bw			퓬[N\
 * @param[in]	client_no	擾ClientNo
 *
 * @retval	trainer_id
 */
//============================================================================================
u16	BattleWorkTrainerIDGet(BATTLE_WORK *bw,int client_no)
{
	return bw->trainer_id[client_no];
}

//============================================================================================
/**
 *	}CXe[^X擾
 *
 * @param[in]	bw			퓬[N\
 * @param[in]	client_no	擾ClientNo
 *
 * @retval	my_item
 */
//============================================================================================
MYSTATUS	*BattleWorkMyStatusGet(BATTLE_WORK *bw,int client_no)
{
	return bw->my_status[client_no];
}

//============================================================================================
/**
 *	莝ACe擾
 *
 * @param[in]	bw			퓬[N\
 *
 * @retval	my_item
 */
//============================================================================================
MYITEM	*BattleWorkMyItemGet(BATTLE_WORK *bw)
{
	return bw->my_item;
}

//============================================================================================
/**
 *	}Cf[^̐ʂ擾
 *
 * @param[in]	bw			퓬[N\
 *
 * @retval	̐
 */
//============================================================================================
u32	BattleWorkMySexGet(BATTLE_WORK *bw,int client_no)
{
	return MyStatus_GetMySex(bw->my_status[client_no]);
}

//============================================================================================
/**
 *	ClientType擾
 *
 * @param[in]	bw			퓬[N\
 * @param[in]	client_no	ClientType擾ClientNo
 *
 * @retval	ClientType
 */
//============================================================================================
u8	BattleWorkClientTypeGet(BATTLE_WORK *bw,int client_no)
{
	return CT_CPClientTypeGet(bw->client_param[client_no]);
}

//============================================================================================
/**
 *	G擾
 *
 * @param[in]	bw			퓬[N\
 * @param[in]	client_no	擾ClientNo
 *
 * @retval	0:@1:G
 */
//============================================================================================
u8	BattleWorkMineEnemyCheck(BATTLE_WORK *bw,int client_no)
{
	return CT_CPClientTypeGet(bw->client_param[client_no])&1;
}

//============================================================================================
/**
 *	bZ[WEChEpDSACRL̃|C^擾
 *
 * @param[in]	bw			퓬[N\
 *
 * @retval	bw->msg_icon
 */
//============================================================================================
void	*BattleWorkMsgIconGet(BATTLE_WORK *bw)
{
	return bw->msg_icon;
}

//============================================================================================
/**
 *	{bNX\̃|C^擾
 *
 * @param[in]	bw			퓬[N\
 *
 * @retval	bw->box
 */
//============================================================================================
BOX_DATA	*BattleWorkBoxDataGet(BATTLE_WORK *bw)
{
	return bw->box;
}

//============================================================================================
/**
 *	ground_id擾
 *
 * @param[in]	bw			퓬[N\
 *
 * @retval	bw->ground_id
 */
//============================================================================================
int	BattleWorkGroundIDGet(BATTLE_WORK *bw)
{
	if((bw->ground_id>GROUND_ID_ALL)||(bw->ground_id<0)){
		return GROUND_ID_ALL;
	}
	return	bw->ground_id;
}

//============================================================================================
/**
 *	bg_id擾
 *
 * @param[in]	bw			퓬[N\
 *
 * @retval	bw->bg_id
 */
//============================================================================================
int	BattleWorkBGIDGet(BATTLE_WORK *bw)
{
	return	bw->bg_id;
}

//============================================================================================
/**
 *	w肵ClientNõp[gi[ClientNo擾
 *
 * @param[in]	bw			퓬VXe[N\
 * @param[in]	client_no	擾ClientNo
 *
 * @retval	ClientNo
 */
//============================================================================================
int	BattleWorkPartnerClientNoGet(BATTLE_WORK *bw,int client_no)
{
	int	partner_client_no;
	int	client_set_max;
	u32	fight_type;

	client_set_max=BattleWorkClientSetMaxGet(bw);
	fight_type=BattleWorkFightTypeGet(bw);

	//1vs1͎gԂ
	if((fight_type&FIGHT_TYPE_2vs2)==0){
		return client_no;
	}

	for(partner_client_no=0;partner_client_no<client_set_max;partner_client_no++){
		if((partner_client_no!=client_no)&&
		   (BattleWorkMineEnemyCheck(bw,partner_client_no)==BattleWorkMineEnemyCheck(bw,client_no))){
			break;
		}
	}
#ifdef PM_DEBUG
	if(partner_client_no==client_set_max){
		GF_ASSERT("p[gi[܂ł\n");
		partner_client_no=0;
	}
#endif
	return partner_client_no;
}

//============================================================================================
/**
 *	ACegpă|P̃p[^ωi퓬pACej
 *
 * @param[in]	bw			퓬VXe[N\
 * @param[in]	client_no	ωClientNo
 * @param[in]	sel_mons_no	ωSelMonsNo
 * @param[in]	waza_pos	ωWazaPos
 * @param[in]	item_no		gpACe
 *
 * @retval	FALSE:ACegpłȂ@TRUE:ACegpip[^ως݁j
 */
//============================================================================================

#define	FRIEND1	(100)	//ȂxvZ̒iK
#define	FRIEND2	(200)	//ȂxvZ̒iK

BOOL	BattleWorkStatusRecover(BATTLE_WORK *bw,int client_no,int sel_mons_no,int waza_pos,int item_no)
{
	SERVER_PARAM	*sp;
	POKEMON_PARAM	*pp;
	BOOL			ret;
	int				data;
	int				pos;
	int				friend;

	sp=bw->server_param;
	ret=FALSE;
	pos=ST_ServerParamDataGet(bw,sp,ID_SP_sel_mons_no,client_no);
	friend=0;

	// 
	if(ItemParamGet(item_no,ITEM_PRM_SLEEP_RCV,HEAPID_BATTLE)){
		pp=BattleWorkPokemonParamGet(bw,client_no,sel_mons_no);
		data=PokeParaGet(pp,ID_PARA_condition,NULL);
		if(data&CONDITION_NEMURI){
			data&=CONDITION_NEMURI_OFF;
			PokeParaPut(pp,ID_PARA_condition,&data);
			if(pos==sel_mons_no){
				data=ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_condition,NULL);
				data&=CONDITION_NEMURI_OFF;
				ST_ServerPokemonServerParamPut(sp,client_no,ID_PSP_condition,&data);
				data=ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_condition2,NULL);
				data&=CONDITION2_AKUMU_OFF;
				ST_ServerPokemonServerParamPut(sp,client_no,ID_PSP_condition2,&data);
			}
			ret=TRUE;
		}
	}
	// ŉ
	if(ItemParamGet(item_no,ITEM_PRM_POISON_RCV,HEAPID_BATTLE)){
		pp=BattleWorkPokemonParamGet(bw,client_no,sel_mons_no);
		data=PokeParaGet(pp,ID_PARA_condition,NULL);
		if(data&CONDITION_DOKUALL){
			data&=CONDITION_POISON_OFF;
			PokeParaPut(pp,ID_PARA_condition,&data);
			if(pos==sel_mons_no){
				data=ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_condition,NULL);
				data&=CONDITION_POISON_OFF;
				ST_ServerPokemonServerParamPut(sp,client_no,ID_PSP_condition,&data);
			}
			ret=TRUE;
		}
	}
	// Ώ
	if(ItemParamGet(item_no,ITEM_PRM_BURN_RCV,HEAPID_BATTLE)){
		pp=BattleWorkPokemonParamGet(bw,client_no,sel_mons_no);
		data=PokeParaGet(pp,ID_PARA_condition,NULL);
		if(data&CONDITION_YAKEDO){
			data&=CONDITION_YAKEDO_OFF;
			PokeParaPut(pp,ID_PARA_condition,&data);
			if(pos==sel_mons_no){
				data=ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_condition,NULL);
				data&=CONDITION_YAKEDO_OFF;
				ST_ServerPokemonServerParamPut(sp,client_no,ID_PSP_condition,&data);
			}
			ret=TRUE;
		}
	}
	// X
	if(ItemParamGet(item_no,ITEM_PRM_ICE_RCV,HEAPID_BATTLE)){
		pp=BattleWorkPokemonParamGet(bw,client_no,sel_mons_no);
		data=PokeParaGet(pp,ID_PARA_condition,NULL);
		if(data&CONDITION_KOORI){
			data&=CONDITION_KOORI_OFF;
			PokeParaPut(pp,ID_PARA_condition,&data);
			if(pos==sel_mons_no){
				data=ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_condition,NULL);
				data&=CONDITION_KOORI_OFF;
				ST_ServerPokemonServerParamPut(sp,client_no,ID_PSP_condition,&data);
			}
			ret=TRUE;
		}
	}
	// ჉
	if(ItemParamGet(item_no,ITEM_PRM_PARALYZE_RCV,HEAPID_BATTLE)){
		pp=BattleWorkPokemonParamGet(bw,client_no,sel_mons_no);
		data=PokeParaGet(pp,ID_PARA_condition,NULL);
		if(data&CONDITION_MAHI){
			data&=CONDITION_MAHI_OFF;
			PokeParaPut(pp,ID_PARA_condition,&data);
			if(pos==sel_mons_no){
				data=ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_condition,NULL);
				data&=CONDITION_MAHI_OFF;
				ST_ServerPokemonServerParamPut(sp,client_no,ID_PSP_condition,&data);
			}
			ret=TRUE;
		}
	}
	// 
	if(ItemParamGet(item_no,ITEM_PRM_PANIC_RCV,HEAPID_BATTLE)){
		data=ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_condition2,NULL);
		if(data&CONDITION2_KONRAN){
			data&=CONDITION2_KONRAN_OFF;
			ST_ServerPokemonServerParamPut(sp,client_no,ID_PSP_condition2,&data);
			ret=TRUE;
		}
	}
	// 
	if(ItemParamGet(item_no,ITEM_PRM_MEROMERO_RCV,HEAPID_BATTLE)){
		data=ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_condition2,NULL);
		if(data&CONDITION2_MEROMERO){
			data&=CONDITION2_MEROMERO_OFF;
			ST_ServerPokemonServerParamPut(sp,client_no,ID_PSP_condition2,&data);
			ret=TRUE;
		}
	}
	// \̓K[h
	if(ItemParamGet(item_no,ITEM_PRM_ABILITY_GUARD,HEAPID_BATTLE)){
		data=ST_ServerParamDataGet(bw,sp,ID_SP_shiroikiri_count,client_no);
		if(data==0){
			data=ST_ServerParamDataGet(bw,sp,ID_SP_side_condition,client_no);
			data|=SIDE_CONDITION_SHIROIKIRI;
			ST_ServerParamDataPut(bw,sp,ID_SP_side_condition,client_no,data);
			ST_ServerParamDataPut(bw,sp,ID_SP_shiroikiri_count,client_no,5);
			ret=TRUE;
		}
	}
	// U̓Abv
	if(ItemParamGet(item_no,ITEM_PRM_ATTACK_UP,HEAPID_BATTLE)){
		if(ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_abiritycnt_pow,NULL)<12){
			ST_ServerPokemonServerParamAdd(sp,client_no,ID_PSP_abiritycnt_pow,1);
			ret=TRUE;
		}
	}
	// h̓Abv
	if(ItemParamGet(item_no,ITEM_PRM_DEFENCE_UP,HEAPID_BATTLE)){
		if(ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_abiritycnt_def,NULL)<12){
			ST_ServerPokemonServerParamAdd(sp,client_no,ID_PSP_abiritycnt_def,1);
			ret=TRUE;
		}
	}
	// UAbv
	if(ItemParamGet(item_no,ITEM_PRM_SP_ATTACK_UP,HEAPID_BATTLE)){
		if(ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_abiritycnt_spepow,NULL)<12){
			ST_ServerPokemonServerParamAdd(sp,client_no,ID_PSP_abiritycnt_spepow,1);
			ret=TRUE;
		}
	}
	// hAbv
	if(ItemParamGet(item_no,ITEM_PRM_SP_DEFENCE_UP,HEAPID_BATTLE)){
		if(ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_abiritycnt_spedef,NULL)<12){
			ST_ServerPokemonServerParamAdd(sp,client_no,ID_PSP_abiritycnt_spedef,1);
			ret=TRUE;
		}
	}
	// fAbv
	if(ItemParamGet(item_no,ITEM_PRM_AGILITY_UP,HEAPID_BATTLE)){
		if(ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_abiritycnt_agi,NULL)<12){
			ST_ServerPokemonServerParamAdd(sp,client_no,ID_PSP_abiritycnt_agi,1);
			ret=TRUE;
		}
	}
	// Abv
	if(ItemParamGet(item_no,ITEM_PRM_HIT_UP,HEAPID_BATTLE)){
		if(ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_abiritycnt_hit,NULL)<12){
			ST_ServerPokemonServerParamAdd(sp,client_no,ID_PSP_abiritycnt_hit,1);
			ret=TRUE;
		}
	}
	// NeBJAbv
	if(ItemParamGet(item_no,ITEM_PRM_CRITICAL_UP,HEAPID_BATTLE)){
		data=ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_condition2,NULL);
		if((data&CONDITION2_KIAIDAME)==0){
			data|=CONDITION2_KIAIDAME;
			ST_ServerPokemonServerParamPut(sp,client_no,ID_PSP_condition2,&data);
			ret=TRUE;
		}
	}
	// PP
	if(ItemParamGet(item_no,ITEM_PRM_PP_RCV,HEAPID_BATTLE)){
		data=ItemParamGet(item_no,ITEM_PRM_PP_RCV_POINT,HEAPID_BATTLE);
		pp=BattleWorkPokemonParamGet(bw,client_no,sel_mons_no);
		if(PokeParaGet(pp,ID_PARA_pp1+waza_pos,NULL)!=PokeParaGet(pp,ID_PARA_pp_max1+waza_pos,NULL)){
			PokeParaAdd(pp,ID_PARA_pp1+waza_pos,data);
			if(pos==sel_mons_no){
				ST_ServerPokemonServerParamAdd(sp,client_no,ID_PSP_pp1+waza_pos,data);
			}
			ret=TRUE;
		}
	}
	// PP񕜁iSĂ̋Zj
	if(ItemParamGet(item_no,ITEM_PRM_ALL_PP_RCV,HEAPID_BATTLE)){
		data=ItemParamGet(item_no,ITEM_PRM_PP_RCV_POINT,HEAPID_BATTLE);
		pp=BattleWorkPokemonParamGet(bw,client_no,sel_mons_no);
		for(waza_pos=0;waza_pos<WAZA_TEMOTI_MAX;waza_pos++){
			if(PokeParaGet(pp,ID_PARA_pp1+waza_pos,NULL)!=PokeParaGet(pp,ID_PARA_pp_max1+waza_pos,NULL)){
				PokeParaAdd(pp,ID_PARA_pp1+waza_pos,data);
				if(pos==sel_mons_no){
					ST_ServerPokemonServerParamAdd(sp,client_no,ID_PSP_pp1+waza_pos,data);
				}
				ret=TRUE;
			}
		}
	}
	// HP
	if(ItemParamGet(item_no,ITEM_PRM_HP_RCV,HEAPID_BATTLE)){
		data=0;
		// m
		if(ItemParamGet(item_no,ITEM_PRM_DEATH_RCV,HEAPID_BATTLE)){
			pp=BattleWorkPokemonParamGet(bw,client_no,sel_mons_no);
			if(PokeParaGet(pp,ID_PARA_hp,NULL)==0){
				data=1;
			}
		}
		else{
			data=1;
		}
		pp=BattleWorkPokemonParamGet(bw,client_no,sel_mons_no);
		if((data)&&(PokeParaGet(pp,ID_PARA_hp,NULL)!=PokeParaGet(pp,ID_PARA_hpmax,NULL))){
			data=ItemParamGet(item_no,ITEM_PRM_HP_RCV_POINT,HEAPID_BATTLE);
			switch(data){
			case HP_MAX_RECOVER:
				data=PokeParaGet(pp,ID_PARA_hpmax,NULL);
				break;
			case HP_HALF_RECOVER:
				data=PokeParaGet(pp,ID_PARA_hpmax,NULL)/2;
				if(data==0){
					data=1;
				}
			default:
				break;
			}
			PokeParaAdd(pp,ID_PARA_hp,data);
			if(pos==sel_mons_no){
				ST_ServerPokemonServerParamPut(sp,client_no,ID_PSP_wkw_item_hp_recover,&data);
			}
			ret=TRUE;
		}
	}
	// ȂxP
	if(ItemParamGet(item_no,ITEM_PRM_FRIEND1,HEAPID_BATTLE)){
		pp=BattleWorkPokemonParamGet(bw,client_no,sel_mons_no);
		if((PokeParaGet(pp,ID_PARA_friend,NULL)<FRIEND1)&&(ret==TRUE)){
			friend=ItemParamGet(item_no,ITEM_PRM_FRIEND1_POINT,HEAPID_BATTLE);
		}
	}
	// ȂxQ
	if(ItemParamGet(item_no,ITEM_PRM_FRIEND2,HEAPID_BATTLE)){
		pp=BattleWorkPokemonParamGet(bw,client_no,sel_mons_no);
		if((PokeParaGet(pp,ID_PARA_friend,NULL)>=FRIEND1)&&
		   (PokeParaGet(pp,ID_PARA_friend,NULL)<FRIEND2)&&
		   (ret==TRUE)){
			friend=ItemParamGet(item_no,ITEM_PRM_FRIEND2_POINT,HEAPID_BATTLE);
		}
	}
	// ȂxR
	if(ItemParamGet(item_no,ITEM_PRM_FRIEND3,HEAPID_BATTLE)){
		pp=BattleWorkPokemonParamGet(bw,client_no,sel_mons_no);
		if((PokeParaGet(pp,ID_PARA_friend,NULL)>=FRIEND2)&&(ret==TRUE)){
			friend=ItemParamGet(item_no,ITEM_PRM_FRIEND3_POINT,HEAPID_BATTLE);
		}
	}
	if(friend){
		pp=BattleWorkPokemonParamGet(bw,client_no,sel_mons_no);
#warning FRIEND NO CALC
	//
		data=PokeParaGet(pp,ID_PARA_item,NULL);
		if(ItemParamGet(item_no,ITEM_PRM_EQUIP,HEAPID_BATTLE)==SOUBI_NATUKIDOUP){
			friend++;
		}
	//Ă{[
		if(PokeParaGet(pp,ID_PARA_get_ball,NULL)==ITEM_GOOZYASUBOORU){
			friend++;
		}
	//߂܂ꏊƓ
//		if(PokeParaGet(pp,ID_PARA_get_place,NULL)==GetNowWorldPos()){
//			friend++;
//		}
		PokeParaAdd(pp,ID_PARA_friend,friend);
		if(pos==sel_mons_no){
			ST_ServerPokemonServerParamAdd(sp,client_no,ID_PSP_friend,friend);
		}
	}

	return ret;
}

//============================================================================================
/**
 *	battle_status_flag擾
 *
 * @param[in]	bw		퓬[N\
 *
 * @retval	battle_status_flag
 */
//============================================================================================
u32	BattleWorkBattleStatusFlagGet(BATTLE_WORK *bw)
{
	return bw->battle_status_flag;
}

//============================================================================================
/**
 *	client_now肵exchr_param擾
 *
 * @param[in]	bw		퓬[N\
 * @param[in]	no		Ԗڂ擾邩(0-3)
 *
 * @retval	exchr_param
 */
//============================================================================================
EXCHR_PARAM	*BattleWorkExChrClientParamGet(BATTLE_WORK *bw, int no)
{
	return &bw->exchr_param[no];
}

//============================================================================================
/**
 *	exchr_buffer擾
 *
 * @param[in]	ep		EXCHR_PARAM\
 * @param[in]	no		Ԗڂ擾邩(0-3)
 *
 * @retval	exchr_buffer
 */
//============================================================================================
u8	*ExChrParamExChrBufferGet(EXCHR_PARAM *ep,int no)
{
	GF_ASSERT(no<4);
	return ep[no].exchr_buffer;
}

//============================================================================================
/**
 *	pal_index擾
 *
 * @param[in]	ep		EXCHR_PARAM\
 * @param[in]	no		Ԗڂ擾邩(0-3)
 *
 * @retval	pal_index
 */
//============================================================================================
int	ExChrParamPalIndexGet(EXCHR_PARAM *ep,int no)
{
	GF_ASSERT(no<4);
	return ep[no].pal_index;
}

//============================================================================================
/**
 *	pal_indexɊi[
 *
 * @param[in]	ep		EXCHR_PARAM\
 * @param[in]	no		ԖڂɊi[邩(0-3)
 * @param[in]	data	i[l
 */
//============================================================================================
void	ExChrParamPalIndexSet(EXCHR_PARAM *ep,int no,int data)
{
	GF_ASSERT(no<4);

	ep[no].pal_index=data;
}

//============================================================================================
/**
 *	height擾
 *
 * @param[in]	ep		EXCHR_PARAM\
 * @param[in]	no		Ԗڂ擾邩(0-3)
 *
 * @retval	height
 */
//============================================================================================
int	ExChrParamHeightGet(EXCHR_PARAM *ep,int no)
{
	GF_ASSERT(no<4);
	return ep[no].height;
}

//============================================================================================
/**
 *	heightɊi[
 *
 * @param[in]	ep		EXCHR_PARAM\
 * @param[in]	no		ԖڂɊi[邩(0-3)
 * @param[in]	data	i[l
 */
//============================================================================================
void	ExChrParamHeightSet(EXCHR_PARAM *ep,int no,int data)
{
	GF_ASSERT(no<4);

	ep[no].height=data;
}

//============================================================================================
/**
 *	ProcModeZbg
 *
 * @param[in]	bw		퓬[N\
 * @param[in]	mode	Zbg郂[hio[
 */
//============================================================================================
void	BattleWorkProcModeSet(BATTLE_WORK *bw,int mode)
{
	bw->proc_mode=mode;
}

//============================================================================================
/**
 *	tcb_sio_send_seq_noZbg
 *
 * @param[in]	bw		퓬[N\
 * @param[in]	seq		ZbgV[PXio[[Ñ|C^
 */
//============================================================================================
void	BattleWorkTSSSeqNoAdrsSet(BATTLE_WORK *bw,u8 *seq_no)
{
	bw->tcb_sio_send_seq_no=seq_no;
}

//============================================================================================
/**
 *	tcb_sio_recv_seq_noZbg
 *
 * @param[in]	bw		퓬[N\
 * @param[in]	seq		ZbgV[PXio[[Ñ|C^
 */
//============================================================================================
void	BattleWorkTSRSeqNoAdrsSet(BATTLE_WORK *bw,u8 *seq_no)
{
	bw->tcb_sio_recv_seq_no=seq_no;
}

//============================================================================================
/**
 *	tcb_sio_send_seq_noɃZbg
 *
 * @param[in]	bw		퓬[N\
 * @param[in]	seq		ZbgV[PXio[
 */
//============================================================================================
void	BattleWorkTSSSeqNoSet(BATTLE_WORK *bw,u8 seq_no)
{
	bw->tcb_sio_send_seq_no[0]=seq_no;
}

//============================================================================================
/**
 *	tcb_sio_recv_seq_noɃZbg
 *
 * @param[in]	bw		퓬[N\
 * @param[in]	seq		ZbgV[PXio[
 */
//============================================================================================
void	BattleWorkTSRSeqNoSet(BATTLE_WORK *bw,u8 seq_no)
{
	bw->tcb_sio_recv_seq_no[0]=seq_no;
}

//============================================================================================
/**
 *	fight_end_flagɃZbg
 *
 * @param[in]	bw		퓬[N\
 * @param[in]	data	Zbgio[
 */
//============================================================================================
void	BattleWorkFightEndFlagSet(BATTLE_WORK *bw,u8 data)
{
	bw->fight_end_flag=data;
}

//============================================================================================
/**
 *	HPQ[W\
 *
 * @param[in]	bw		퓬[N\
 * @param[in]	data	Zbgio[
 */
//============================================================================================
void	BattleWorkGaugeOn(BATTLE_WORK *bw)
{
	int			i;
	GAUGE_WORK	*gauge;

	for(i=0;i<bw->client_set_max;i++){
		gauge=CT_CPGaugeWorkGet(bw->client_param[i]);
		Gauge_EnableSet(gauge,CATS_ENABLE_TRUE);
	}
}

//============================================================================================
/**
 *	HPQ[W\
 *
 * @param[in]	bw		퓬[N\
 * @param[in]	data	Zbgio[
 */
//============================================================================================
void	BattleWorkGaugeOff(BATTLE_WORK *bw)
{
	int			i;
	GAUGE_WORK	*gauge;

	for(i=0;i<bw->client_set_max;i++){
		gauge=CT_CPGaugeWorkGet(bw->client_param[i]);
		Gauge_EnableSet(gauge,CATS_ENABLE_FALSE);
	}
}

//============================================================================================
/**
 *	ClientTypeClientNo擾邽߂̃obt@𐶐
 *
 * @param[in]	bw		퓬[N\
 * @param[in]	buf		obt@ւ̃|C^
 */
//============================================================================================
void	BattleClientNoBufMake(BATTLE_WORK *bw,u8 *buf)
{
	int	i;

	for(i=0;i<bw->client_set_max;i++){
		buf[CT_CPClientTypeGet(bw->client_param[i])]=i;
	}
}

//============================================================================================
/**
 *	ClientNoClientType擾邽߂̃obt@𐶐
 *
 * @param[in]	bw		퓬[N\
 * @param[in]	buf		obt@ւ̃|C^
 */
//============================================================================================
void	BattleClientTypeBufMake(BATTLE_WORK *bw,u8 *buf)
{
	int	i;

	for(i=0;i<CLIENT_MAX;i++){
		buf[i]=CLIENT_TYPE_NONE;
	}

	for(i=0;i<bw->client_set_max;i++){
		buf[i]=CT_CPClientTypeGet(bw->client_param[i]);
	}
}

//============================================================================================
/**
 *	ClientNoSoftSprite擾邽߂̃obt@𐶐
 *
 * @param[in]	bw		퓬[N\
 * @param[in]	buf		obt@ւ̃|C^
 */
//============================================================================================
void	BattleSoftSpriteBufMake(BATTLE_WORK *bw,SOFT_SPRITE **buf)
{
	int	i;

	for(i=0;i<CLIENT_MAX;i++){
		buf[i]=NULL;
	}

	for(i=0;i<bw->client_set_max;i++){
		buf[i]=CT_CPSoftSpriteGet(bw->client_param[i]);
	}
}

//============================================================================================
/**
 *	퓬Q[W̃vCIeBZbg
 *
 * @param[in]	bw		퓬[N\
 * @param[in]	pri		ZbgvCIeB
 */
//============================================================================================
void	BattleGaugePriSet(BATTLE_WORK *bw,int pri)
{
	int	i;
	GAUGE_WORK	*gw;

	for(i=0;i<bw->client_set_max;i++){
		gw=CT_CPGaugeWorkGet(bw->client_param[i]);
		Gauge_BGPriSet(gw,pri);
	}
}

//============================================================================================
/**
 * s펞̃yieBvZ
 *
 * @param[in]	pp			莝|Pf[^\
 * @param[in]	my_status	}CXe[^X
 *
 * @retval  u32		邨
 */
//============================================================================================
u32 CalcLosePenalty(POKEPARTY *ppt,MYSTATUS *my_status)
{
	static const u8 Late[] = {
		2, 4, 6, 9, 12, 16, 20, 25, 30,
	};
	u32 sum, my_gold;
	u8	badge_cnt;

//	badge_cnt = GetBadgeCount();
	badge_cnt = 0;
	sum =  GetStockPokeMaxLevel(ppt) * 4 * Late[badge_cnt];

//	my_gold = GetGold(&(fld->my_gold));
	my_gold = 1000;

	if(sum > my_gold){
		sum = my_gold;
	}

	return sum;
}

//============================================================================================
/**
 * |PtOZbg
 *
 * @param[in]	bw			퓬[N\
 * @param[in]	client_no	Zbg|PClientNo
 */
//============================================================================================
void	FT_ZukanFlagSetSee(BATTLE_WORK *bw,int client_no)
{
	int	client_type;

	client_type=CT_CPClientTypeGet(bw->client_param[client_no]);

	if((bw->fight_type&FIGHT_TYPE_NO_ZUKAN)==0){
		if(client_type&CLIENT_ENEMY_FLAG){
			{
				POKEMON_PARAM	*pp;
				int				sel_mons_no;

				sel_mons_no=ST_ServerParamDataGet(bw,bw->server_param,ID_SP_sel_mons_no,client_no);

				pp=BattleWorkPokemonParamGet(bw,client_no,sel_mons_no);
				ZukanWork_SetPokeSee(bw->zw,pp);
			}
		}
	}
}

//============================================================================================
/**
 * |PQbgtOZbg
 *
 * @param[in]	bw			퓬[N\
 * @param[in]	client_no	Zbg|PClientNo
 */
//============================================================================================
void	FT_ZukanFlagSetGet(BATTLE_WORK *bw,int client_no)
{
	int	client_type;

	client_type=CT_CPClientTypeGet(bw->client_param[client_no]);

	if((bw->fight_type&FIGHT_TYPE_NO_ZUKAN)==0){
		if(client_type&CLIENT_ENEMY_FLAG){
			{
				POKEMON_PARAM	*pp;
				int				sel_mons_no;

				sel_mons_no=ST_ServerParamDataGet(bw,bw->server_param,ID_SP_sel_mons_no,client_no);

				pp=BattleWorkPokemonParamGet(bw,client_no,sel_mons_no);
				ZukanWork_SetPokeGet(bw->zw,pp);
			}
		}
	}
}

//============================================================================================
/**
 * |PQbgtO`FbN
 *
 * @param[in]	bw			퓬[N\
 * @param[in]	client_no	Zbg|PClientNo
 */
//============================================================================================
BOOL	FT_ZukanFlagCheckGet(BATTLE_WORK *bw,int mons_no)
{
	return ZukanWork_GetPokeGetFlag(bw->zw,mons_no);
}

//============================================================================================
/**
 * 퓬̃ftHguhݒ
 */
//============================================================================================
void	BattleDefaultBlendSet(void)
{
	G2_BlendNone();
}

//============================================================================================
/**
 *	NoBitɕϊ(RP܂Łj
 *
 * @param[in]	no		ϊio[
 *
 * @retval	no=0:0x01 c
 */
//============================================================================================
u32	No2Bit(int no)
{
	int	i;
	u32	ret=1;

	GF_ASSERT(no<32);

	for(i=0;i<no;i++){
		ret<<=1;
	}
	return ret;
}

//============================================================================================
/**
 *	BitNoɕϊ(RP܂Łj
 *
 * @param[in]	bit		ϊio[
 *
 * @retval	no=0x01:0c
 */
//============================================================================================
int	Bit2No(u32 bit)
{
	int	i;
	u32	mask=1;

	for(i=0;i<32;i++){
		if(bit&mask){
			break;
		}
		mask<<=1;
	}
	return i;
}

//============================================================================================
/**
 *	g[i[bZ[W\֐
 *
 * @param[in]	bw			퓬VXe\̂ւ̃|C^
 * @param[in]	win			BMPWINVXeݒ\̂ւ̃|C^
 * @param[in]	tr_id		\郁bZ[W̃g[i[ID
 * @param[in]	msg_type	\郁bZ[W̃^Cv
 * @param[in]	wait		bZ[W\EGCg
 *
 */
//============================================================================================
u8	TrainerMSG_Print(BATTLE_WORK *bw,GF_BGL_BMPWIN *win,int tr_id,int msg_type,int wait)
{
	TT_TrainerMessageGet(tr_id,msg_type,bw->msg_buf,HEAPID_BATTLE);

	GF_BGL_BmpWinDataFill(win,0xff);

	return GF_STR_PrintSimple(win,FONT_TALK,bw->msg_buf,0,0,wait,NULL);
}

//============================================================================================
/**
 *	퓬bZ[W\֐
 *
 * @param[in]	bw			퓬VXe\̂ւ̃|C^
 * @param[in]	win			BMPWINVXeݒ\̂ւ̃|C^
 * @param[in]	msg_m		bZ[W}l[W[\̂ւ̃|C^
 * @param[in]	mp			bZ[Wp[^\̂ւ̃|C^
 * @param[in]	wait		bZ[W\EGCg
 *
 */
//============================================================================================
u8	BattleMSG_Print(BATTLE_WORK *bw,GF_BGL_BMPWIN *win,MSGDATA_MANAGER *msg_m,MESSAGE_PARAM *mp,int wait)
{
	BattleMSG_DirCheck(bw,mp);
	BattleMSG_TagExpand(bw,mp);
	BattleMSG_MsgExpand(bw,msg_m,mp);

	GF_BGL_BmpWinDataFill(win,0xff);

	return GF_STR_PrintSimple(win,FONT_TALK,bw->msg_buf,0,0,wait,NULL);
}

//============================================================================================
/**
 *	퓬bZ[WDirCheckibZ[ẂAuẮvu₹́vȂǂ̌Ɋւ锻j
 *
 * @param[in]	bw			퓬VXe\̂ւ̃|C^
 * @param[in]	mp			MESSAGE_PARAM\̂ւ̃|C^
 *
 */
//============================================================================================
static	void	BattleMSG_DirCheck(BATTLE_WORK *bw,MESSAGE_PARAM *mp)
{
	u32	fight_type;

	fight_type=BattleWorkFightTypeGet(bw);

	if(mp->msg_tag&TAG_NO_DIR){
		return;
	}

	switch(mp->msg_tag&TAG_NO_DIR_OFF){
	case TAG_NONE:						//^OȂ
	case TAG_WAZA:						//Z
	case TAG_NUM:						//l
	case TAG_TRNAME:					//trainer
	case TAG_WAZA_WAZA:					//Z			Z
	case TAG_ITEM_WAZA:					//		Z
	case TAG_NUM_NUM:					//l			l
	case TAG_TRNAME_TRNAME:				//trainer		trainer
	case TAG_TRNAME_NICK:				//trainer		nickname
	case TAG_TRNAME_ITEM:				//trainer		
	case TAG_TRNAME_NUM:				//trainer		l
	case TAG_TRTYPE_TRNAME:				//trainer	trainer
	case TAG_TRNAME_NICK_NICK:			//trainer		nickname		nickname
	case TAG_TRTYPE_TRNAME_NICK:		//trainer	trainer		nickname
	case TAG_TRTYPE_TRNAME_ITEM:		//trainer	trainer		
	case TAG_TRNAME_NICK_TRNAME_NICK:	//trainer		nickname		trainer		nickname
	case TAG_TRTYPE_TRNAME_NICK_NICK:	//trainer	trainer		nickname		nickname
	case TAG_TRTYPE_TRNAME_NICK_TRNAME:	//trainer	trainer		nickname		trainer
	case TAG_TRTYPE_TRNAME_NICKx2:		//trainer	trainer		nickname Q
		break;

	case TAG_NONE_DIR:					//nicknamei݂AĔȂj
		if(BattleWorkMineEnemyCheck(bw,mp->msg_para[0])){
			mp->msg_id++;
		}
		break;
	case TAG_NICK:						//nickname
	case TAG_NICK_WAZA:					//nickname		Z
	case TAG_NICK_TOKU:					//nickname		
	case TAG_NICK_STAT:					//nickname		Xe[^X
	case TAG_NICK_TYPE:					//nickname		^Cv
	case TAG_NICK_POKE:					//nickname		|P
	case TAG_NICK_ITEM:					//nickname		
	case TAG_NICK_PLOC:					//nickname		|bN
	case TAG_NICK_NUM:					//nickname		l
	case TAG_NICK_TRNAME:				//nickname		trainer
	case TAG_NICK_WAZA_WAZA:			//nickname		Z			Z
	case TAG_NICK_WAZA_NUM:				//nickname		Z			l
	case TAG_NICK_TOKU_WAZA:			//nickname					Z
	case TAG_NICK_TOKU_ITEM:			//nickname					
	case TAG_NICK_TOKU_STAT:			//nickname					Xe[^X
	case TAG_NICK_TOKU_TYPE:			//nickname					^Cv
	case TAG_NICK_TOKU_COND:			//nickname					Ԉُ햼
	case TAG_NICK_TOKU_NUM:				//nickname					l
	case TAG_NICK_ITEM_WAZA:			//nickname					Z
	case TAG_NICK_ITEM_STAT:			//nickname					Xe[^X
	case TAG_NICK_ITEM_COND:			//nickname					Ԉُ햼
		if(BattleWorkMineEnemyCheck(bw,mp->msg_para[0]&0xff)){
			mp->msg_id++;
			if(fight_type&FIGHT_TYPE_TRAINER){
				mp->msg_id++;
			}
		}
		break;
	case TAG_WAZA_NICK:					//Z			nickname
	case TAG_TOKU_NICK:					//		nickname
	case TAG_ITEM_NICK_TASTE:			//		nickname		؂̖̎
		if(BattleWorkMineEnemyCheck(bw,mp->msg_para[1]&0xff)){
			mp->msg_id++;
			if(fight_type&FIGHT_TYPE_TRAINER){
				mp->msg_id++;
			}
		}
		break;
	case TAG_NICK_NICK:					//nickname		nickname
	case TAG_NICK_NICK_WAZA:			//nickname		nickname		Z
	case TAG_NICK_NICK_TOKU:			//nickname		nickname		
	case TAG_NICK_NICK_ITEM:			//nickname		nickname		
		if(BattleWorkMineEnemyCheck(bw,mp->msg_para[0]&0xff)){
			mp->msg_id+=3;
			if(fight_type&FIGHT_TYPE_TRAINER){
				mp->msg_id+=2;
			}
			if(BattleWorkMineEnemyCheck(bw,mp->msg_para[1]&0xff)){
				mp->msg_id++;
			}
		}
		else{
			if(BattleWorkMineEnemyCheck(bw,mp->msg_para[1]&0xff)){
				mp->msg_id++;
				if(fight_type&FIGHT_TYPE_TRAINER){
					mp->msg_id++;
				}
			}
		}
		break;
	case TAG_NICK_TOKU_NICK:			//nickname					nickname
	case TAG_NICK_ITEM_NICK:			//nickname					nickname
	case TAG_NICK_TOKU_NICK_WAZA:		//nickname					nickname		Z
	case TAG_NICK_TOKU_NICK_TOKU:		//nickname					nickname		
	case TAG_NICK_TOKU_NICK_STAT:		//nickname					nickname		Xe[^X
	case TAG_NICK_ITEM_NICK_ITEM:		//nickname					nickname		
		if(BattleWorkMineEnemyCheck(bw,mp->msg_para[0]&0xff)){
			mp->msg_id+=3;
			if(fight_type&FIGHT_TYPE_TRAINER){
				mp->msg_id+=2;
			}
			if(BattleWorkMineEnemyCheck(bw,mp->msg_para[2]&0xff)){
				mp->msg_id++;
			}
		}
		else{
			if(BattleWorkMineEnemyCheck(bw,mp->msg_para[2]&0xff)){
				mp->msg_id++;
				if(fight_type&FIGHT_TYPE_TRAINER){
					mp->msg_id++;
				}
			}
		}
		break;
	default:
		GF_ASSERT("݂ȂTAGłI\n");
		break;
	}
}

//============================================================================================
/**
 *	퓬bZ[W^OWJ֐
 *
 * @param[in]	bw			퓬VXe\̂ւ̃|C^
 * @param[in]	mp			MESSAGE_PARAM\̂ւ̃|C^
 *
 */
//============================================================================================
static	void	BattleMSG_TagExpand(BATTLE_WORK *bw,MESSAGE_PARAM *mp)
{
	switch(mp->msg_tag&TAG_NO_DIR_OFF){
	case TAG_NONE:						//^OȂ
	case TAG_NONE_DIR:					//^OȂi݂AĔ肠j
		break;
	case TAG_NICK:						//nickname
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		break;
	case TAG_WAZA:						//Z
		BattleMSG_WazaGet(		bw,STR_TEMP_BUF0,mp->msg_para[0]);
		break;
	case TAG_NUM:						//l
		BattleMSG_NumGet(		bw,STR_TEMP_BUF0,mp->msg_para[0]);
		break;
	case TAG_TRNAME:					//trainer
		BattleMSG_TRNameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		break;
	case TAG_NICK_NICK:					//nickname		nickname
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		break;
	case TAG_NICK_WAZA:					//nickname		Z
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_WazaGet(		bw,STR_TEMP_BUF1,mp->msg_para[1]);
		break;
	case TAG_NICK_TOKU:					//nickname		
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_TokuseiGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		break;
	case TAG_NICK_STAT:					//nickname		Xe[^X
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_StatusGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		break;
	case TAG_NICK_TYPE:					//nickname		^Cv
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_TypeGet(		bw,STR_TEMP_BUF1,mp->msg_para[1]);
		break;
	case TAG_NICK_POKE:					//nickname		|P
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_PokenameGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		break;
	case TAG_NICK_ITEM:					//nickname		
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_ItemGet(		bw,STR_TEMP_BUF1,mp->msg_para[1]);
		break;
	case TAG_NICK_PLOC:					//nickname		|bN
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_PolockGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		break;
	case TAG_NICK_NUM:					//nickname		l
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_NumGet(		bw,STR_TEMP_BUF1,mp->msg_para[1]);
		break;
	case TAG_NICK_TRNAME:				//nickname		trainer
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_TRNameGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		break;
	case TAG_WAZA_NICK:					//Z			nickname
		BattleMSG_WazaGet(		bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		break;
	case TAG_WAZA_WAZA:					//Z			Z
		BattleMSG_WazaGet(		bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_WazaGet(		bw,STR_TEMP_BUF1,mp->msg_para[1]);
		break;
	case TAG_TOKU_NICK:					//		nickname
		BattleMSG_TokuseiGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		break;
	case TAG_ITEM_WAZA:					//		Z
		BattleMSG_ItemGet(		bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_WazaGet(		bw,STR_TEMP_BUF1,mp->msg_para[1]);
		break;
	case TAG_NUM_NUM:					//l			l
		BattleMSG_NumGet(		bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_NumGet(		bw,STR_TEMP_BUF1,mp->msg_para[1]);
		break;
	case TAG_TRNAME_TRNAME:				//trainer		trainer
		BattleMSG_TRNameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_TRNameGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		break;
	case TAG_TRNAME_NICK:				//trainer		nickname
		BattleMSG_TRNameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		break;
	case TAG_TRNAME_ITEM:				//trainer		
		BattleMSG_TRNameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_ItemGet(		bw,STR_TEMP_BUF1,mp->msg_para[1]);
		break;
	case TAG_TRNAME_NUM:				//trainer		l
		BattleMSG_TRNameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_NumGet(		bw,STR_TEMP_BUF1,mp->msg_para[1]);
		break;
	case TAG_TRTYPE_TRNAME:				//trainer	trainer
		BattleMSG_TRTypeGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_TRNameGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		break;
	case TAG_NICK_NICK_WAZA:			//nickname		nickname		Z
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_WazaGet(		bw,STR_TEMP_BUF2,mp->msg_para[2]);
		break;
	case TAG_NICK_NICK_TOKU:			//nickname		nickname		
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_TokuseiGet(	bw,STR_TEMP_BUF2,mp->msg_para[2]);
		break;
	case TAG_NICK_NICK_ITEM:			//nickname		nickname		
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_ItemGet(		bw,STR_TEMP_BUF2,mp->msg_para[2]);
		break;
	case TAG_NICK_WAZA_WAZA:			//nickname		Z			Z
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_WazaGet(		bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_WazaGet(		bw,STR_TEMP_BUF2,mp->msg_para[2]);
		break;
	case TAG_NICK_WAZA_NUM:				//nickname		Z			l
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_WazaGet(		bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_NumGet(		bw,STR_TEMP_BUF2,mp->msg_para[2]);
		break;
	case TAG_NICK_TOKU_NICK:			//nickname					nickname
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_TokuseiGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF2,mp->msg_para[2]);
		break;
	case TAG_NICK_TOKU_WAZA:			//nickname					Z
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_TokuseiGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_WazaGet(		bw,STR_TEMP_BUF2,mp->msg_para[2]);
		break;
	case TAG_NICK_TOKU_ITEM:			//nickname					
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_TokuseiGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_ItemGet(		bw,STR_TEMP_BUF2,mp->msg_para[2]);
		break;
	case TAG_NICK_TOKU_STAT:			//nickname					Xe[^X
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_TokuseiGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_StatusGet(	bw,STR_TEMP_BUF2,mp->msg_para[2]);
		break;
	case TAG_NICK_TOKU_TYPE:			//nickname					^Cv
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_TokuseiGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_TypeGet(		bw,STR_TEMP_BUF2,mp->msg_para[2]);
		break;
	case TAG_NICK_TOKU_COND:			//nickname					Ԉُ햼
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_TokuseiGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_ConditionGet(	bw,STR_TEMP_BUF2,mp->msg_para[2]);
		break;
	case TAG_NICK_TOKU_NUM:				//nickname					l
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_TokuseiGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_NumGet(		bw,STR_TEMP_BUF2,mp->msg_para[2]);
		break;
	case TAG_NICK_ITEM_NICK:			//nickname					nickname
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_ItemGet(		bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF2,mp->msg_para[2]);
		break;
	case TAG_NICK_ITEM_WAZA:			//nickname					Z
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_ItemGet(		bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_WazaGet(		bw,STR_TEMP_BUF2,mp->msg_para[2]);
		break;
	case TAG_NICK_ITEM_STAT:			//nickname					Xe[^X
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_ItemGet(		bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_StatusGet(	bw,STR_TEMP_BUF2,mp->msg_para[2]);
		break;
	case TAG_NICK_ITEM_COND:			//nickname					Ԉُ햼
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_ItemGet(		bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_ConditionGet(	bw,STR_TEMP_BUF2,mp->msg_para[2]);
		break;
	case TAG_ITEM_NICK_TASTE:			//		nickname		؂̖̎
		BattleMSG_ItemGet(		bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_TasteGet(		bw,STR_TEMP_BUF2,mp->msg_para[2]);
		break;
	case TAG_TRNAME_NICK_NICK:			//trainer		nickname		nickname
		BattleMSG_TRNameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF2,mp->msg_para[2]);
		break;
	case TAG_TRTYPE_TRNAME_NICK:		//trainer	trainer		nickname
		BattleMSG_TRTypeGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_TRNameGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF2,mp->msg_para[2]);
		break;
	case TAG_TRTYPE_TRNAME_ITEM:		//trainer	trainer		
		BattleMSG_TRTypeGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_TRNameGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_ItemGet(		bw,STR_TEMP_BUF2,mp->msg_para[2]);
		break;
	case TAG_NICK_TOKU_NICK_WAZA:		//nickname					nickname		Z
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_TokuseiGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF2,mp->msg_para[2]);
		BattleMSG_WazaGet(		bw,STR_TEMP_BUF3,mp->msg_para[3]);
		break;
	case TAG_NICK_TOKU_NICK_TOKU:		//nickname					nickname		
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_TokuseiGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF2,mp->msg_para[2]);
		BattleMSG_TokuseiGet(	bw,STR_TEMP_BUF3,mp->msg_para[3]);
		break;
	case TAG_NICK_TOKU_NICK_STAT:		//nickname					nickname		Xe[^X
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_TokuseiGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF2,mp->msg_para[2]);
		BattleMSG_StatusGet(	bw,STR_TEMP_BUF3,mp->msg_para[3]);
		break;
	case TAG_NICK_ITEM_NICK_ITEM:		//nickname					nickname		
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_ItemGet(		bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF2,mp->msg_para[2]);
		BattleMSG_ItemGet(		bw,STR_TEMP_BUF3,mp->msg_para[3]);
		break;
	case TAG_TRNAME_NICK_TRNAME_NICK:	//trainer		nickname		trainer		nickname
		BattleMSG_TRNameGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_TRNameGet(	bw,STR_TEMP_BUF2,mp->msg_para[2]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF3,mp->msg_para[3]);
		break;
	case TAG_TRTYPE_TRNAME_NICK_NICK:	//trainer	trainer		nickname		nickname
		BattleMSG_TRTypeGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_TRNameGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF2,mp->msg_para[2]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF3,mp->msg_para[3]);
		break;
	case TAG_TRTYPE_TRNAME_NICK_TRNAME:	//trainer	trainer		nickname		trainer
		BattleMSG_TRTypeGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_TRNameGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF2,mp->msg_para[2]);
		BattleMSG_TRNameGet(	bw,STR_TEMP_BUF3,mp->msg_para[3]);
		break;
	case TAG_TRTYPE_TRNAME_NICKx2:		//trainer	trainer		nickname Q
		BattleMSG_TRTypeGet(	bw,STR_TEMP_BUF0,mp->msg_para[0]);
		BattleMSG_TRNameGet(	bw,STR_TEMP_BUF1,mp->msg_para[1]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF2,mp->msg_para[2]);
		BattleMSG_TRTypeGet(	bw,STR_TEMP_BUF3,mp->msg_para[3]);
		BattleMSG_TRNameGet(	bw,STR_TEMP_BUF4,mp->msg_para[4]);
		BattleMSG_NicknameGet(	bw,STR_TEMP_BUF5,mp->msg_para[5]);
		break;
	default:
		GF_ASSERT("݂ȂTAGłI\n");
		break;
	}
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐ijbNl[j
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	void	BattleMSG_NicknameGet(BATTLE_WORK *bw,u32 buf_id,int para)
{
	POKEMON_PARAM		*pp;

	pp=BattleWorkPokemonParamGet(bw,para&0xff,(para&0xff00)>>8);

	WORDSET_RegisterPokeNickName(bw->wordset,buf_id,&pp->ppp);
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐iZio[j
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	void	BattleMSG_WazaGet(BATTLE_WORK *bw,u32 buf_id,int para)
{
	WORDSET_RegisterWazaName(bw->wordset,buf_id,para);
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐iio[j
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	void	BattleMSG_ItemGet(BATTLE_WORK *bw,u32 buf_id,int para)
{
	WORDSET_RegisterItemName(bw->wordset,buf_id,para);
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐ilj
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	void	BattleMSG_NumGet(BATTLE_WORK *bw,u32 buf_id,int para)
{
	WORDSET_RegisterNumber(bw->wordset,buf_id,para,5,NUMBER_DISPTYPE_LEFT,NUMBER_CODETYPE_DEFAULT);
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐i^Cvj
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	void	BattleMSG_TypeGet(BATTLE_WORK *bw,u32 buf_id,int para)
{
	WORDSET_RegisterPokeTypeName(bw->wordset,buf_id,para);
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐ij
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	void	BattleMSG_TokuseiGet(BATTLE_WORK *bw,u32 buf_id,int para)
{
	WORDSET_RegisterTokuseiName(bw->wordset,buf_id,para);
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐iXe[^Xj
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	void	BattleMSG_StatusGet(BATTLE_WORK *bw,u32 buf_id,int para)
{
	WORDSET_RegisterPokeStatusName(bw->wordset,buf_id,para);
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐iԈُ햼j
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	void	BattleMSG_ConditionGet(BATTLE_WORK *bw,u32 buf_id,int para)
{
	WORDSET_RegisterBadConditionName(bw->wordset,buf_id,para);
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐i|Pj
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	void	BattleMSG_PokenameGet(BATTLE_WORK *bw,u32 buf_id,int para)
{
	POKEMON_PARAM		*pp;

	pp=BattleWorkPokemonParamGet(bw,para&0xff,(para&0xff00)>>8);

	WORDSET_RegisterPokeMonsName(bw->wordset,buf_id,&pp->ppp);
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐i|bNj
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	void	BattleMSG_PolockGet(BATTLE_WORK *bw,u32 buf_id,int para)
{
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐i؂̖̎j
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	void	BattleMSG_TasteGet(BATTLE_WORK *bw,u32 buf_id,int para)
{
	WORDSET_RegisterSeedTasteName(bw->wordset,buf_id,para);
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐ig[i[ʁj
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	void	BattleMSG_TRTypeGet(BATTLE_WORK *bw,u32 buf_id,int para)
{
	WORDSET_RegisterTrTypeName(bw->wordset,buf_id,para);
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐ig[i[j
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	void	BattleMSG_TRNameGet(BATTLE_WORK *bw,u32 buf_id,int para)
{
	//g[i[IDÓA
	if((para&0xffff)==0){
		WORDSET_RegisterPlayerName(bw->wordset,buf_id,BattleWorkMyStatusGet(bw,(para&0xffff0000)>>16));
	}
	else{
		WORDSET_RegisterTrainerName(bw->wordset,buf_id,(para&0xffff));
	}
}


//============================================================================================
/**
 *	퓬bZ[WbZ[WWJ֐
 *
 * @param[in]	bgl		BGVXeݒ\̂ւ̃|C^
 * @param[in]	win		BMPWINVXeݒ\̂ւ̃|C^
 * @param[in]	arc_id	bZ[Wf[^̃A[JCuID
 * @param[in]	msg_id	bZ[Wf[^̃A[JCõbZ[WINDEXID
 * @param[in]	wait	bZ[W\EGCg
 *
 */
//============================================================================================
static	void	BattleMSG_MsgExpand(BATTLE_WORK *bw,MSGDATA_MANAGER *msg_m,MESSAGE_PARAM *mp)
{
	STRBUF	*src_buf;

	src_buf=MSGMAN_AllocString(msg_m,mp->msg_id);

	WORDSET_ExpandStr(bw->wordset,bw->msg_buf,src_buf);

	sys_FreeMemoryEz(src_buf);
}

