//==============================================================================
/**
 * @file	font_obj.h
 * @brief	tHgOBJŕ\
 * @author	matsuda
 * @date	2005.10.17()
 */
//==============================================================================
#ifndef __FONT_OBJ_H__
#define __FONT_OBJ_H__

#include "system/fontproc.h"
#include "system/clact_tool.h"
#include "system/fontproc.h"
#include "gflib/msg_print.h"


//==============================================================================
//	萔`
//==============================================================================
///tHgOBJŎgpoőAN^[
#define FONTOBJ_ACTOR_MAX		(8)	//32Ȃ8256hbgŝŁAƂ肠8

///tHgOBJOAMTCY`
enum{
	FONTOBJ_OAMSIZE_32x16,	///<32x16`OAMgp
};

///XW̃ZbgA擾@
enum{
	FONTOBJ_POS_LEFT,
	FONTOBJ_POS_CENTER,
	FONTOBJ_POS_RIGHT,
};


//==============================================================================
//	\̒`
//==============================================================================
///tHgOBJ쐬Ap[^(tHgOBJp̃AN^[[N)
typedef struct{
	u8 use_oam;			///<gpĂOAM(AN^[)
	u8 type_dot;		///<1OAM̉hbg
	u16 font_len;		///<̃hbg
	s16 x;				///<XW([W)
	s16 y;				///<YW(SW)
	CATS_ACT_PTR cap[FONTOBJ_ACTOR_MAX];

	u16 start_charid;	///<L}l[W[o^JnID
	u16 start_palid;	///<pbg}l[W[o^JnID
	u16 start_cellid;	///<Z}l[W[o^JnID
	u16 start_anmid;	///<ZAj}l[W[o^JnID
}FONTOBJ_ACTWORK;

///tHgOBJ쐬ɕKvȃf[^
typedef struct{
	FONTOBJ_ACTWORK *fa;

	GF_BGL_INI *bgl;
	CATS_SYS_PTR csp;
	CATS_RES_PTR crp;

	FONT_TYPE font;
	const STRBUF* str;
	u32 margin;
	GF_PRINTCOLOR print_color;

	NNS_G2D_VRAM_TYPE d_area;
	int oam_size;
	u32 max_oam;
	int oam_fix;
	int soft_pri;
	int bg_pri;
	int pal_offset;		///<pbgԍItZbg
	
	int heap_id;

	u16 start_charid;	///<L}l[W[o^JnID
	u16 start_palid;	///<pbg}l[W[o^JnID
	u16 start_cellid;	///<Z}l[W[o^JnID
	u16 start_anmid;	///<ZAj}l[W[o^JnID
}FONTOBJ_CREATE_DATA;


//==============================================================================
//	O֐錾
//==============================================================================
extern void FontOBJ_Create(const FONTOBJ_CREATE_DATA *fcd);
extern void FontOBJ_Delete(CATS_RES_PTR crp, FONTOBJ_ACTWORK *fa, int not_pal_free);
extern void FontOBJ_PosSet(FONTOBJ_ACTWORK *fa, int set_type, s16 x, s16 y);
extern void FontOBJ_PosGet(FONTOBJ_ACTWORK *fa, int get_type, s16 *x, s16 *y);
extern void FontOBJ_Enable(FONTOBJ_ACTWORK *fa, int enable);


//==============================================================================
//	inline`
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   tHgOBJ쐬܂
 *
 * @param   fa				tHgOBJAAN^[񂪂ɑ܂
 * @param   bgl				BGLf[^
 * @param   csp				
 * @param   crp				
 * @param   font			tHg^Cv(FONT_SYSTEM)
 * @param   str				f[^
 * @param   margin			Ԋu
 * @param   print_color		̐F
 * @param   d_area			Vram]ʒu(NNS_G2D_VRAM_TYPE_2DMAIN or NNS_G2D_VRAM_TYPE_2DSUB)
 * @param   oam_size		tHgOBJɎgpOAM`(FONTOBJ_OAMSIZE_32x16)
 * @param   max_oam			tHgOBJ쐬ɎgpĂőOAM(1`FONTOBJ_ACTOR_MAX)
 * @param   oam_fix			TRUE=ɍőOAMƂ̃̕L̈gp
 *                          (Ȃ͑Sċ󔒂Ŗ߂܂)
 *                          FALSE=max_oam͈̔͂̒ŕKvȕgp܂
 * @param   soft_pri		AN^[\tgvCIeB
 * @param   bg_pri			AN^[BGvCIeB
 * @param   pal_offset		pbgԍItZbg
 * @param   heap_id			q[vIDB֐ňꎞIɃmۂۂɎgp܂
 *                          (֐o鎞ɂ͉Ă܂)
 * @param   start_charid	tHgOBJ쐬AL}l[Wɓo^JnID
 *                          (IDԍAɕKvOAMAAԂœo^܂)
 * @param   start_palid		pbg}l[Wɓo^JnID(ڍאstart_charidƓł)
 * @param   start_cellid	Z}l[Wɓo^JnID(ڍאstart_charidƓł)
 * @param   start_anmid		ZAj}l[Wɓo^JnID(ڍאstart_charidƓł)
 *
 *
 *
 * ɓo^ς݂̃pbgp`łꍇ́A̓o^ς݂̊ǗIDnĂ
 * 
 * 8x8tHgɂ͖ΉłB
 *
 */
//--------------------------------------------------------------
inline void FontOBJ_CreateInline(FONTOBJ_ACTWORK *fa, GF_BGL_INI *bgl, CATS_SYS_PTR csp, 
	CATS_RES_PTR crp, FONT_TYPE font, const STRBUF* str, u32 margin, GF_PRINTCOLOR print_color, 
	NNS_G2D_VRAM_TYPE d_area, int oam_size, u32 max_oam, int oam_fix,int soft_pri,int bg_pri, 
	int pal_offset, int heap_id, s32 start_charid, s32 start_palid, 
	s32 start_cellid, s32 start_anmid)
{
	FONTOBJ_CREATE_DATA fcd;
	
	fcd.fa = fa;

	fcd.bgl = bgl;
	fcd.csp = csp;
	fcd.crp = crp;

	fcd.font = font;
	fcd.str = str;
	fcd.margin = margin;
	fcd.print_color = print_color;

	fcd.d_area = d_area;
	fcd.oam_size = oam_size;
	fcd.max_oam = max_oam;
	fcd.oam_fix = oam_fix;
	fcd.soft_pri = soft_pri;
	fcd.bg_pri = bg_pri;
	fcd.pal_offset = pal_offset;
	
	fcd.heap_id = heap_id;

	fcd.start_charid = start_charid;
	fcd.start_palid = start_palid;
	fcd.start_cellid = start_cellid;
	fcd.start_anmid = start_anmid;

	FontOBJ_Create(&fcd);
}

#endif	//__FONT_OBJ_H__
