//==============================================================================
/**
 * @file	gauge.c
 * @brief	퓬ʁFHPQ[W
 * @author	matsuda
 * @date	2005.09.27()
 */
//==============================================================================
#include "common.h"
#include "gauge.h"
#include "graphic\batt_obj_def.h"
#include "system/arc_tool.h"
#include "battle/fight_tool.h"
#include "system/fontproc.h"
#include "application/app_tool.h"
#include "system/pm_str.h"
#include "system/numfont.h"
#include "battle/battle_tcb_pri.h"

#include "system/msgdata_util.h"
#include "system/wordset.h"
#include "msgdata/msg_fightmsg_dp.h"


//==============================================================================
//	萔`
//==============================================================================

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
enum{
	GAUGE_REQ_HP,		///<HPo[݃NGXg
	GAUGE_REQ_EXP,		///<EXPo[݃NGXg
};

///Q[WAN^[\tgvCIeB
enum{
	SOFTPRI_START = 10,
	
	SOFTPRI_NAME_AA,	///<AAp|P
	SOFTPRI_NAME_BB,
	SOFTPRI_NAME_A,
	SOFTPRI_NAME_B,
	SOFTPRI_NAME_C,
	SOFTPRI_NAME_D,

	SOFTPRI_ARROW_AA,	///<AApQ[W
	SOFTPRI_ARROW_BB,	///<BBpQ[W
	SOFTPRI_ARROW_A,
	SOFTPRI_ARROW_B,
	SOFTPRI_ARROW_C,
	SOFTPRI_ARROW_D,

	SOFTPRI_GAUGE_AA,	///<AApQ[W{
	SOFTPRI_GAUGE_BB,	///<BBpQ[W{
	SOFTPRI_GAUGE_A,
	SOFTPRI_GAUGE_B,
	SOFTPRI_GAUGE_C,
	SOFTPRI_GAUGE_D,
};

///̃Q[W{̂̒S̕\ItZbgWX
#define ARROW_OFFSET_X		(72 - 2)
///̃Q[W{̂̒S̕\ItZbgWY
#define ARROW_OFFSET_Y		(0)

///Q[WʊOɎẴItZbgX
#define GAUGE_SCROLL_OUT_OFFSET_X		(160)
///Q[WʊOɎẴItZbgY
#define GAUGE_SCROLL_OUT_OFFSET_Y		(0)
///Q[WXN[̑xX
#define GAUGE_SCROLL_SP_X		(12)


//==============================================================================
//	p[c`
//==============================================================================
typedef struct{
	u16 pos;		///]ʒu(oCgItZbg)
	u16 size;		///]TCY
}PARTS_TRANS_PARAM;

//--------------------------------------------------------------
//	O
//--------------------------------------------------------------
///OXTCY(LP)B@*.NCEt@CŐݒ肵Ă鉡̃LL
#define NAME_SIZE_X		(8)
///OYTCY(LP)B@*.NCEt@CŐݒ肵Ăc̃LL
#define NAME_SIZE_Y		(2)
///OCGXItZbg
#define NAME_CHAR_OFFSET	(0)
///OLN^[̃oCgTCY
#define NAME_BYTE_SIZE		(NAME_SIZE_X * NAME_SIZE_Y * 0x20)

//O`ʒu
static const PARTS_TRANS_PARAM NameTrans[][4] = {
	{//GAUGE_TYPE_AA
		{0x12 * 0x20, 6 * 0x20},		///<1OAMFi
		{0x1a * 0x20, 6 * 0x20},		///<1OAMFi
		{0x50 * 0x20, 2 * 0x20},		///<2OAMFi
		{0x58 * 0x20, 2 * 0x20},		///<2OAMFi
	},
	{//GAUGE_TYPE_BB
		{0x11 * 0x20, 7 * 0x20},		///<1OAMFi
		{0x19 * 0x20, 7 * 0x20},		///<1OAMFi
		{0x50 * 0x20, 1 * 0x20},		///<2OAMFi
		{0x58 * 0x20, 1 * 0x20},		///<2OAMFi
	},
	{//GAUGE_TYPE_A
		{0x12 * 0x20, 6 * 0x20},		///<1OAMFi
		{0x1a * 0x20, 6 * 0x20},		///<1OAMFi
		{0x50 * 0x20, 2 * 0x20},		///<2OAMFi
		{0x58 * 0x20, 2 * 0x20},		///<2OAMFi
	},
	{//GAUGE_TYPE_B
		{0x15 * 0x20, 7 * 0x20},		///<1OAMFi
		{0x1d * 0x20, 7 * 0x20},		///<1OAMFi
		{0x54 * 0x20, 1 * 0x20},		///<2OAMFi
		{0x5c * 0x20, 1 * 0x20},		///<2OAMFi
	},
	{//GAUGE_TYPE_C
		{0x12 * 0x20, 6 * 0x20},		///<1OAMFi
		{0x1a * 0x20, 6 * 0x20},		///<1OAMFi
		{0x50 * 0x20, 2 * 0x20},		///<2OAMFi
		{0x58 * 0x20, 2 * 0x20},		///<2OAMFi
	},
	{//GAUGE_TYPE_D
		{0x11 * 0x20, 7 * 0x20},		///<1OAMFi
		{0x19 * 0x20, 7 * 0x20},		///<1OAMFi
		{0x50 * 0x20, 1 * 0x20},		///<2OAMFi
		{0x58 * 0x20, 1 * 0x20},		///<2OAMFi
	},
};

///O`ʒu̔wiFԍ
#define NAME_BACK_COLOR		(0xf)
///O̕F
#define NAME_FONT_COLOR		(GF_PRINTCOLOR_MAKE(0xe, 2, NAME_BACK_COLOR))

//--------------------------------------------------------------
//	x
//--------------------------------------------------------------
//x`ʒu
static const PARTS_TRANS_PARAM LvFontTrans[][2] = {
	{//GAUGE_TYPE_AA
		{0x53 * 0x20, 2 * 0x20},		///<1OAM
		{0x5b * 0x20, 2 * 0x20},		///<2OAM
	},
	{//GAUGE_TYPE_BB
		{0x52 * 0x20, 2 * 0x20},		///<1OAM
		{0x5a * 0x20, 2 * 0x20},		///<2OAM
	},
	{//GAUGE_TYPE_A
		{0x53 * 0x20, 2 * 0x20},		///<1OAM
		{0x5b * 0x20, 2 * 0x20},		///<2OAM
	},
	{//GAUGE_TYPE_B
		{0x56 * 0x20, 2 * 0x20},		///<1OAM
		{0x5e * 0x20, 2 * 0x20},		///<2OAM
	},
	{//GAUGE_TYPE_C
		{0x53 * 0x20, 2 * 0x20},		///<1OAM
		{0x5b * 0x20, 2 * 0x20},		///<2OAM
	},
	{//GAUGE_TYPE_D
		{0x52 * 0x20, 2 * 0x20},		///<1OAM
		{0x5a * 0x20, 2 * 0x20},		///<2OAM
	},
};

//--------------------------------------------------------------
//	x
//--------------------------------------------------------------
//x`ʒu
static const PARTS_TRANS_PARAM LvTrans[][2] = {
	{//GAUGE_TYPE_AA
		{0x55 * 0x20, 3 * 0x20},		///<1OAM
		{0x5d * 0x20, 3 * 0x20},		///<2OAM
	},
	{//GAUGE_TYPE_BB
		{0x54 * 0x20, 3 * 0x20},		///<1OAM
		{0x5c * 0x20, 3 * 0x20},		///<2OAM
	},
	{//GAUGE_TYPE_A
		{0x55 * 0x20, 3 * 0x20},		///<1OAM
		{0x5d * 0x20, 3 * 0x20},		///<2OAM
	},
	{//GAUGE_TYPE_B
		{0x58 * 0x20, 3 * 0x20},		///<1OAM
		{0x60 * 0x20, 3 * 0x20},		///<2OAM
	},
	{//GAUGE_TYPE_C
		{0x55 * 0x20, 3 * 0x20},		///<1OAM
		{0x5d * 0x20, 3 * 0x20},		///<2OAM
	},
	{//GAUGE_TYPE_D
		{0x54 * 0x20, 3 * 0x20},		///<1OAM
		{0x5c * 0x20, 3 * 0x20},		///<2OAM
	},
};

///x`ʒu̔wiFԍ
#define LEVEL_BACK_COLOR		(NAME_BACK_COLOR)
///x̕F
#define LEVEL_FONT_COLOR		(NAME_FONT_COLOR)

//--------------------------------------------------------------
//	HP
//--------------------------------------------------------------
//HP`ʒu
static const PARTS_TRANS_PARAM HPTrans[][2] = {
	{//GAUGE_TYPE_AA
		{0x68 * 0x20, 3 * 0x20},		///<2OAM
		{0, 0 * 0x20},					///<2OAM
	},
	{//GAUGE_TYPE_BB
		{48 * 0x20, 3 * 0x20},			///<1OAM
		{0, 0 * 0x20},					///<2OAM
	},
	{//GAUGE_TYPE_A
		{0x27 * 0x20, 1 * 0x20},		///<1OAM
		{0x60 * 0x20, 2 * 0x20},		///<2OAM
	},
	{//GAUGE_TYPE_B
		{52 * 0x20, 3 * 0x20},			///<1OAM
		{0, 0 * 0x20},					///<2OAM
	},
	{//GAUGE_TYPE_C
		{0x27 * 0x20, 1 * 0x20},		///<1OAM
		{0x60 * 0x20, 2 * 0x20},		///<2OAM
	},
	{//GAUGE_TYPE_D
		{48 * 0x20, 3 * 0x20},			///<1OAM
		{0, 0 * 0x20},					///<2OAM
	},
};

///HP`ʒu̔wiFԍ
#define HP_BACK_COLOR		(0xf)
///HP̕F
#define HP_FONT_COLOR		(GF_PRINTCOLOR_MAKE(0xe, 2, HP_BACK_COLOR))

//--------------------------------------------------------------
//	őHP
//--------------------------------------------------------------
//őHP`ʒu(VOE_uEEG)
enum{
	HPMAX_HIGH = 0x6b * 0x20,	///<őHPFOAM̕`Jnʒu(㑤)
//	HPMAX_LOW = 0x19 * 0x20,	///<őHPFOAM̕`Jnʒu()
	HPMAX_SIZE = 3 * 0x20,		///<őHPF]
};
//őHP`ʒu
static const PARTS_TRANS_PARAM HPMaxTrans[] = {
	//GAUGE_TYPE_AA
	{0x6c * 0x20, 3 * 0x20},		///<2OAM
	//GAUGE_TYPE_BB
	{52 * 0x20, 3 * 0x20},		///<2OAM
	//GAUGE_TYPE_A
	{0x64 * 0x20, 3 * 0x20},		///<2OAM
	//GAUGE_TYPE_B
	{56 * 0x20, 3 * 0x20},		///<2OAM
	//GAUGE_TYPE_C
	{0x64 * 0x20, 3 * 0x20},		///<2OAM
	//GAUGE_TYPE_D
	{52 * 0x20, 3 * 0x20},		///<2OAM
};

///őHP`ʒu̔wiFԍ
#define HPMAX_BACK_COLOR		(HP_BACK_COLOR)
///őHP̕F
#define HPMAX_FONT_COLOR		(HP_FONT_COLOR)

//--------------------------------------------------------------
//	HPo[
//--------------------------------------------------------------
//HPo[`ʒu
static const PARTS_TRANS_PARAM HPBarTrans[][2] = {
	{//GAUGE_TYPE_AA
		{0x27 * 0x20, 1 * 0x20},		///<1OAM
		{0x60 * 0x20, 7 * 0x20},		///<2OAM
	},
	{//GAUGE_TYPE_BB
		{0x26 * 0x20, 2 * 0x20},		///<1OAM
		{0x60 * 0x20, 6 * 0x20},		///<2OAM
	},
	{//GAUGE_TYPE_A
		{0x27 * 0x20, 1 * 0x20},		///<1OAM
		{0x60 * 0x20, 7 * 0x20},		///<2OAM
	},
	{//GAUGE_TYPE_B
		{0x2a * 0x20, 2 * 0x20},		///<1OAM
		{0x64 * 0x20, 6 * 0x20},		///<2OAM
	},
	{//GAUGE_TYPE_C
		{0x27 * 0x20, 1 * 0x20},		///<1OAM
		{0x60 * 0x20, 7 * 0x20},		///<2OAM
	},
	{//GAUGE_TYPE_D
		{0x26 * 0x20, 2 * 0x20},		///<1OAM
		{0x60 * 0x20, 7 * 0x20},		///<2OAM
	},
};

///HPo[`ʒu̔wiFԍ
#define HPBAR_BACK_COLOR		(HP_BACK_COLOR)
///HPo[̕F
#define HPBAR_FONT_COLOR		(HP_FONT_COLOR)

//--------------------------------------------------------------
//	olo[
//--------------------------------------------------------------
//EXPo[`ʒu(VOE_uEEG)
enum{
	EXPBAR_FAST_HIGH = 0x34 * 0x20,		///<EXPo[F1ڂOAM̕`Jnʒu
	EXPBAR_SECOND_HIGH = 0x70 * 0x20,	///<EXPo[F2ڂOAM̕`Jnʒu
	
	EXPBAR_NEXT_OAM = 4,		///<1ڂOAMEXPo[̃L
};

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
//ʓ]ʒu
static const PARTS_TRANS_PARAM SexTrans[][2] = {
	{//GAUGE_TYPE_AA
		{0x52 * 0x20, 1 * 0x20},		///<i
		{0x5a * 0x20, 1 * 0x20},		///<i
	},
	{//GAUGE_TYPE_BB
		{0x51 * 0x20, 1 * 0x20},		///<i
		{0x59 * 0x20, 1 * 0x20},		///<i
	},
	{//GAUGE_TYPE_A
		{0x52 * 0x20, 1 * 0x20},		///<i
		{0x5a * 0x20, 1 * 0x20},		///<i
	},
	{//GAUGE_TYPE_B
		{0x55 * 0x20, 1 * 0x20},		///<i
		{0x5d * 0x20, 1 * 0x20},		///<i
	},
	{//GAUGE_TYPE_C
		{0x52 * 0x20, 1 * 0x20},		///<i
		{0x5a * 0x20, 1 * 0x20},		///<i
	},
	{//GAUGE_TYPE_D
		{0x51 * 0x20, 1 * 0x20},		///<i
		{0x59 * 0x20, 1 * 0x20},		///<i
	},
};

//--------------------------------------------------------------
//	Qbgς݃}[N
//--------------------------------------------------------------
//Qbgς݃}[N]ʒu
static const PARTS_TRANS_PARAM GetBallTrans[] = {
	//GAUGE_TYPE_AA
	{0x22 * 0x20, 1 * 0x20},
	//GAUGE_TYPE_BB
	{0x21 * 0x20, 1 * 0x20},
	//GAUGE_TYPE_A
	{0x22 * 0x20, 1 * 0x20},
	//GAUGE_TYPE_B
	{0x25 * 0x20, 1 * 0x20},
	//GAUGE_TYPE_C
	{0x22 * 0x20, 1 * 0x20},
	//GAUGE_TYPE_D
	{0x21 * 0x20, 1 * 0x20},
};

//--------------------------------------------------------------
//	Ԉُ
//--------------------------------------------------------------
//ʓ]ʒu
static const PARTS_TRANS_PARAM StatusTrans[] = {
	//GAUGE_TYPE_AA
	{0x22 * 0x20, 3 * 0x20},
	//GAUGE_TYPE_BB
	{0x21 * 0x20, 3 * 0x20},
	//GAUGE_TYPE_A
	{0x22 * 0x20, 3 * 0x20},
	//GAUGE_TYPE_B
	{0x25 * 0x20, 3 * 0x20},
	//GAUGE_TYPE_C
	{0x22 * 0x20, 3 * 0x20},
	//GAUGE_TYPE_D
	{0x21 * 0x20, 3 * 0x20},
};


//==============================================================================
//	vg^Cv錾
//==============================================================================
static s32 GaugeOBJ(GAUGE_WORK *gauge, int req_data);
static s32 GaugeProc(s32 MaxHP, s32 NowHP, s32 beHP, s32 *HP_Work, u8 GaugeMax, u16 add_dec);
static u8 PutGaugeProc(s32 MaxHP, s32 NowHP, s32 beHP, s32 *HP_Work, u8 *gauge_chr, u8 GaugeMax);
static u32 DottoOffsetCalc(s32 nowHP, s32 beHP, s32 MaxHP, u8 GaugeMax);
static const u8 * GetGaugePartsAdrs(int parts_num);
static void PutGaugeOBJ(GAUGE_WORK *gauge, u8 req);
void MsgTool_OamSlideBuf(void *src_buf, void *dest_buf, const u8 oam_list[], int list_num);
static void GaugeParts_NameDraw(GAUGE_WORK *gauge);
static void GaugeParts_LevelFontDraw(GAUGE_WORK *gauge);
static void GaugeParts_LevelDraw(GAUGE_WORK *gauge);
static void GaugeParts_HPDraw(GAUGE_WORK *gauge, u32 hp);
static void GaugeParts_HPMaxDraw(GAUGE_WORK *gauge);
static void GaugeParts_SexDraw(GAUGE_WORK *gauge);
static void GaugeParts_GetBallDraw(GAUGE_WORK *gauge);
static void GaugeParts_StatusDraw(GAUGE_WORK *gauge, int gp_num);
static void Gauge_ArrowResourceLoad(CATS_SYS_PTR csp, CATS_RES_PTR crp, PALETTE_FADE_PTR pfd, 
	int gauge_type);
static CATS_ACT_PTR Gauge_ArrowActorSet(CATS_SYS_PTR csp, CATS_RES_PTR crp, int gauge_type);
static void Gauge_ArrowActorDel(GAUGE_WORK *gauge);
static void Gauge_ArrowResourceFree(GAUGE_WORK *gauge);
static const TCATS_OBJECT_ADD_PARAM_S * Sub_GaugeObjHeadGet(u8 gauge_type);
static const TCATS_OBJECT_ADD_PARAM_S * Sub_ArrowObjHeadGet(u8 gauge_type);
static void Gauge_ScrollInOut(TCB_PTR tcb, void *work);


//==============================================================================
//	f[^
//==============================================================================
///AApQ[WAN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S GaugeObjParam_aa = {
	192,112 + 4, 0,		//x, y, z
	0, SOFTPRI_GAUGE_AA, 0,		//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
	{	//gp\[XIDe[u
		SINGLE_GAGE2_NCGR_BIN,	//L
		GAGE_PALETTE_NCLR,	//pbg
		SINGLE_GAGE2_NCER_BIN,	//Z
		SINGLE_GAGE2_NANR_BIN,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	GAUGE_DEFAULT_BGPRI,			//BGvCIeB
	0,			//Vram]tO
};

///BBpQ[WAN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S GaugeObjParam_bb = {
	64,40-4, 0,		//x, y, z
	0, SOFTPRI_GAUGE_BB, 0,		//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
	{	//gp\[XIDe[u
		SINGLE_GAGE1_NCGR_BIN,	//L
		GAGE_PALETTE_NCLR,	//pbg
		SINGLE_GAGE1_NCER_BIN,	//Z
		SINGLE_GAGE1_NANR_BIN,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	GAUGE_DEFAULT_BGPRI,			//BGvCIeB
	0,			//Vram]tO
};

///ApQ[WAN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S GaugeObjParam_a = {
	184,106-10, 0,		//x, y, z
	0, SOFTPRI_GAUGE_A, 0,		//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
	{	//gp\[XIDe[u
		DOUBLE_GAGE3_NCGR_BIN,	//L
		GAGE_PALETTE_NCLR,	//pbg
		DOUBLE_GAGE3_NCER_BIN,	//Z
		DOUBLE_GAGE3_NANR_BIN,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	GAUGE_DEFAULT_BGPRI,			//BGvCIeB
	0,			//Vram]tO
};

///BpQ[WAN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S GaugeObjParam_b = {
	68+3,22-3, 0,		//x, y, z
	0, SOFTPRI_GAUGE_B, 0,		//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
	{	//gp\[XIDe[u
		DOUBLE_GAGE1_NCGR_BIN,	//L
		GAGE_PALETTE_NCLR,	//pbg
		DOUBLE_GAGE1_NCER_BIN,	//Z
		DOUBLE_GAGE1_NANR_BIN,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	GAUGE_DEFAULT_BGPRI,			//BGvCIeB
	0,			//Vram]tO
};

///CpQ[WAN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S GaugeObjParam_c = {
	192,131-3, 0,		//x, y, z
	0, SOFTPRI_GAUGE_C, 0,		//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
	{	//gp\[XIDe[u
		DOUBLE_GAGE4_NCGR_BIN,	//L
		GAGE_PALETTE_NCLR,	//pbg
		DOUBLE_GAGE4_NCER_BIN,	//Z
		DOUBLE_GAGE4_NANR_BIN,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	GAUGE_DEFAULT_BGPRI,			//BGvCIeB
	0,			//Vram]tO
};

///DpQ[WAN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S GaugeObjParam_d = {
	64,22+34-5, 0,		//x, y, z
	0, SOFTPRI_GAUGE_D, 0,		//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
	{	//gp\[XIDe[u
		DOUBLE_GAGE2_NCGR_BIN,	//L
		GAGE_PALETTE_NCLR,	//pbg
		DOUBLE_GAGE2_NCER_BIN,	//Z
		DOUBLE_GAGE2_NANR_BIN,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	GAUGE_DEFAULT_BGPRI,			//BGvCIeB
	0,			//Vram]tO
};

///AApQ[WAN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S ArrowParam_aa = {
	0,0, 0,		//x, y, z
	0, SOFTPRI_ARROW_AA, 0,		//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
	{	//gp\[XIDe[u
		SINGLE_ARROW_ANIMATION2_NCGR_BIN,	//L
		GAGE_PALETTE_NCLR,	//pbg
		SINGLE_ARROW_ANIMATION2_NCER_BIN,	//Z
		SINGLE_ARROW_ANIMATION2_NANR_BIN,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	GAUGE_DEFAULT_BGPRI,			//BGvCIeB
	0,			//Vram]tO
};

///BBpQ[WAN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S ArrowParam_bb = {
	0, 0, 0,		//x, y, z
	0, SOFTPRI_ARROW_BB, 0,		//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
	{	//gp\[XIDe[u
		SINGLE_ARROW_ANIMATION1_NCGR_BIN,	//L
		GAGE_PALETTE_NCLR,	//pbg
		SINGLE_ARROW_ANIMATION1_NCER_BIN,	//Z
		SINGLE_ARROW_ANIMATION1_NANR_BIN,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	GAUGE_DEFAULT_BGPRI,			//BGvCIeB
	0,			//Vram]tO
};

///AAp|PAN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S GaugeName_aa = {
	184,132, 0,		//x, y, z
	0, SOFTPRI_NAME_AA, 0,		//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
	{	//gp\[XIDe[u
		GAUGE_NAME_AA_NCGR_BIN,	//L
		GAUGE_NCLR,	//pbg
		GAUGE_NAME_AA_NCER_BIN,	//Z
		GAUGE_NAME_AA_NANR_BIN,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	GAUGE_DEFAULT_BGPRI,			//BGvCIeB
	0,			//Vram]tO
};

///BBp|PAN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S GaugeName_bb = {
	64,32, 0,		//x, y, z
	0, SOFTPRI_NAME_BB, 0,		//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
	{	//gp\[XIDe[u
		GAUGE_NAME_BB_NCGR_BIN,	//L
		GAUGE_NCLR,	//pbg
		GAUGE_NAME_BB_NCER_BIN,	//Z
		GAUGE_NAME_BB_NANR_BIN,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	GAUGE_DEFAULT_BGPRI,			//BGvCIeB
	0,			//Vram]tO
};


//==============================================================================
//	Of[^
//==============================================================================
#include "gage_parts_txt.dat"


//--------------------------------------------------------------
/**
 * @brief   Q[W̃\[Xǂݍ
 *
 * @param   gauge		
 */
//--------------------------------------------------------------
void Gauge_ResourceLoad(CATS_SYS_PTR csp, CATS_RES_PTR crp, PALETTE_FADE_PTR pfd, int gauge_type)
{
	const TCATS_OBJECT_ADD_PARAM_S *obj_head;
	
	//\[Xǂݍ
	obj_head = Sub_GaugeObjHeadGet(gauge_type);
	
	CATS_LoadResourceCharArc(csp, crp, ARC_BATT_OBJ, obj_head->id[CLACT_U_CHAR_RES], 1, 
		NNS_G2D_VRAM_TYPE_2DMAIN, obj_head->id[CLACT_U_CHAR_RES]);
//	CATS_LoadResourcePlttArc(csp, crp, ARC_BATT_OBJ, obj_head->id[CLACT_U_PLTT_RES], 0, 
//		1, NNS_G2D_VRAM_TYPE_2DMAIN, obj_head->id[CLACT_U_PLTT_RES]);
	CATS_LoadResourcePlttWorkArc(pfd, FADE_MAIN_OBJ, csp, crp, 
		ARC_BATT_OBJ, obj_head->id[CLACT_U_PLTT_RES], 0, 
		1, NNS_G2D_VRAM_TYPE_2DMAIN, obj_head->id[CLACT_U_PLTT_RES]);
	CATS_LoadResourceCellArc(csp, crp, ARC_BATT_OBJ, obj_head->id[CLACT_U_CELL_RES], 1, 
		obj_head->id[CLACT_U_CELL_RES]);
	CATS_LoadResourceCellAnmArc(csp, crp, ARC_BATT_OBJ, 
		obj_head->id[CLACT_U_CELLANM_RES], 1, obj_head->id[CLACT_U_CELLANM_RES]);
}

//--------------------------------------------------------------
/**
 * @brief   Q[W̃\[Xǂݍ
 *
 * @param   gauge		Q[W[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Gauge_ArrowResourceLoad(CATS_SYS_PTR csp, CATS_RES_PTR crp, PALETTE_FADE_PTR pfd, 
	int gauge_type)
{
	const TCATS_OBJECT_ADD_PARAM_S *obj_head;
	
	//\[Xǂݍ
	obj_head = Sub_ArrowObjHeadGet(gauge_type);
	if(obj_head != NULL){
		CATS_LoadResourceCharArc(csp, crp, ARC_BATT_OBJ, obj_head->id[CLACT_U_CHAR_RES], 
			1, NNS_G2D_VRAM_TYPE_2DMAIN, obj_head->id[CLACT_U_CHAR_RES]);
//		CATS_LoadResourcePlttArc(csp, crp, ARC_BATT_OBJ, obj_head->id[CLACT_U_PLTT_RES], 
//			0, 1, NNS_G2D_VRAM_TYPE_2DMAIN, obj_head->id[CLACT_U_PLTT_RES]);
		CATS_LoadResourcePlttWorkArc(pfd, FADE_MAIN_OBJ, csp, crp, 
			ARC_BATT_OBJ, obj_head->id[CLACT_U_PLTT_RES], 
			0, 1, NNS_G2D_VRAM_TYPE_2DMAIN, obj_head->id[CLACT_U_PLTT_RES]);
		CATS_LoadResourceCellArc(csp, crp, ARC_BATT_OBJ, obj_head->id[CLACT_U_CELL_RES], 
			1, obj_head->id[CLACT_U_CELL_RES]);
		CATS_LoadResourceCellAnmArc(csp, crp, ARC_BATT_OBJ, 
			obj_head->id[CLACT_U_CELLANM_RES], 1, 
			obj_head->id[CLACT_U_CELLANM_RES]);
	}
}

//--------------------------------------------------------------
/**
 * @brief   Q[W̃AN^[𐶐
 *
 * @param   gauge		
 *
 * Ƀ\[Xǂݍ܂ĂKv܂B
 */
//--------------------------------------------------------------
CATS_ACT_PTR Gauge_ActorSet(CATS_SYS_PTR csp, CATS_RES_PTR crp, int gauge_type)
{
	const TCATS_OBJECT_ADD_PARAM_S *obj_head;
	CATS_ACT_PTR cap;
	
	obj_head = Sub_GaugeObjHeadGet(gauge_type);

	cap = CATS_ObjectAdd_S(csp, crp, obj_head);
	CATS_ObjectUpdate(cap->act);
	return cap;
}

//--------------------------------------------------------------
/**
 * @brief   Q[W̃AN^[𐶐
 * @param   gauge		Q[W[Nւ̃|C^
 */
//--------------------------------------------------------------
static CATS_ACT_PTR Gauge_ArrowActorSet(CATS_SYS_PTR csp, CATS_RES_PTR crp, int gauge_type)
{
	const TCATS_OBJECT_ADD_PARAM_S *obj_head;
	CATS_ACT_PTR arrow_cap;
	
	obj_head = Sub_ArrowObjHeadGet(gauge_type);
	if(obj_head == NULL){
		arrow_cap = NULL;
		return arrow_cap;
	}
	
	arrow_cap = CATS_ObjectAdd_S(csp, crp, obj_head);
	CATS_ObjectUpdate(arrow_cap->act);
	return arrow_cap;
}

//--------------------------------------------------------------
/**
 * @brief   Q[W̃p[c(HPo[AԈُ퓙)`悷
 *
 * @param   gauge			Q[W[Nւ̃|C^
 * @param   hp				\HP(Calcœro߂\Kv̂HP͈w)
 * @param   draw_flag		`悷p[c̃tO(GAUGE_DRAW_???) rbgw(w)
 *
 * ̊֐͍ĕ`płBHPZ̏Ɏgp̂ł͂܂B
 * HPZ̏sꍇGauge_CalcHP֐gpĂB
 * 
 * ĕ`悷tOɂĂ͍Ɨp[N̏s܂
 */
//--------------------------------------------------------------
void Gauge_PartsDraw(GAUGE_WORK *gauge, u32 hp, u32 draw_flag)
{
	int status_getball = FALSE;
	u32 draw_backup;
	
	GF_ASSERT(gauge->cap != NULL);
	
	draw_backup = draw_flag;
	
	//svȃrbg𗎂Ƃ
	switch(gauge->type){
	case GAUGE_TYPE_BB:
	case GAUGE_TYPE_B:
	case GAUGE_TYPE_D:
		draw_flag &= GAUGE_DRAW_ALL ^ (GAUGE_DRAW_HPNUM | GAUGE_DRAW_HPNUMMAX | GAUGE_DRAW_EXP);
		status_getball = TRUE;	//Xe[^X\m[}`̎AQbgς݃{[\
	#ifdef PM_DEBUG
		if(gauge->debug_hp_put == TRUE){
			if(draw_backup & GAUGE_DRAW_HPNUM){
				draw_flag |= GAUGE_DRAW_HPNUM;
			}
			if(draw_backup & GAUGE_DRAW_HPNUMMAX){
				draw_flag |= GAUGE_DRAW_HPNUMMAX;
			}
		}
	#endif
		break;
	case GAUGE_TYPE_A:
	case GAUGE_TYPE_C:
		draw_flag &= GAUGE_DRAW_ALL ^ (GAUGE_DRAW_HPNUM | GAUGE_DRAW_HPNUMMAX | GAUGE_DRAW_EXP
			| GAUGE_DRAW_GETBALL);
		break;
	}
	
	if(draw_flag & GAUGE_DRAW_HPBAR){
		Gauge_InitCalcHP(gauge, 0);
		GaugeOBJ(gauge, GAUGE_REQ_HP);
	}
	
	if(draw_flag & GAUGE_DRAW_HPNUM){
		GaugeParts_HPDraw(gauge, hp);
	}
	
	if(draw_flag & GAUGE_DRAW_HPNUMMAX){
		GaugeParts_HPMaxDraw(gauge);
	}
	
	if(draw_flag & GAUGE_DRAW_LEVEL_FONT){
		GaugeParts_LevelFontDraw(gauge);
	}
	
	if(draw_flag & GAUGE_DRAW_LEVEL){
		GaugeParts_LevelDraw(gauge);
	}
	
	if(draw_flag & GAUGE_DRAW_NAME){
		GaugeParts_NameDraw(gauge);
	}
	
	if(draw_flag & GAUGE_DRAW_EXP){
		Gauge_InitCalcEXP(gauge, 0);
		GaugeOBJ(gauge, GAUGE_REQ_EXP);
	}
	
	if(draw_flag & GAUGE_DRAW_SEX){
		GaugeParts_SexDraw(gauge);
	}
	
	if(draw_flag & GAUGE_DRAW_GETBALL){
		GaugeParts_GetBallDraw(gauge);
	}
	
	if(draw_flag & GAUGE_DRAW_STATUS){
		switch(gauge->status){
		default:
		case STATUS_NORMAL:
			GaugeParts_StatusDraw(gauge, GP_NON_STATUS);
			
			if(status_getball == TRUE){
				GaugeParts_GetBallDraw(gauge);
			}
			break;
		case STATUS_NEMURI:
			GaugeParts_StatusDraw(gauge, GP_NEMURI);
			break;
		case STATUS_DOKU:
			GaugeParts_StatusDraw(gauge, GP_DOKU);
			break;
		case STATUS_YAKEDO:
			GaugeParts_StatusDraw(gauge, GP_YAKEDO);
			break;
		case STATUS_KOORI:
			GaugeParts_StatusDraw(gauge, GP_KOORI);
			break;
		case STATUS_MAHI:
			GaugeParts_StatusDraw(gauge, GP_MAHI);
			break;
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   Q[W̃AN^[폜
 * @param   gauge		Q[W[Nւ̃|C^
 */
//--------------------------------------------------------------
void Gauge_ActorDel(GAUGE_WORK *gauge)
{
	if(gauge->cap == NULL){
		return;
	}
	CATS_ActorPointerDelete_S(gauge->cap);
	gauge->cap = NULL;
}

//--------------------------------------------------------------
/**
 * @brief   Q[W̃AN^[폜
 * @param   gauge		Q[W[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Gauge_ArrowActorDel(GAUGE_WORK *gauge)
{
	if(gauge->arrow_cap == NULL){
		return;
	}
	CATS_ActorPointerDelete_S(gauge->arrow_cap);
	gauge->arrow_cap = NULL;
}

//--------------------------------------------------------------
/**
 * @brief   Q[W̃\[X
 * @param   gauge		Q[W[Nւ̃|C^
 */
//--------------------------------------------------------------
void Gauge_ResourceFree(GAUGE_WORK *gauge)
{
	CATS_SYS_PTR csp;
	CATS_RES_PTR crp;
	const TCATS_OBJECT_ADD_PARAM_S *obj_head;

	obj_head = Sub_GaugeObjHeadGet(gauge->type);
	
	csp = BattleWorkCATS_SYS_PTRGet(gauge->bw);
	crp = BattleWorkCATS_RES_PTRGet(gauge->bw);

	//\[X
	CATS_FreeResourceChar(crp, obj_head->id[CLACT_U_CHAR_RES]);
//	CATS_FreeResourcePltt(crp, obj_head->id[CLACT_U_PLTT_RES]);
	CATS_FreeResourceCell(crp, obj_head->id[CLACT_U_CELL_RES]);
	CATS_FreeResourceCellAnm(crp, obj_head->id[CLACT_U_CELLANM_RES]);
}

//--------------------------------------------------------------
/**
 * @brief   Q[W̃\[X
 * @param   gauge		Q[W[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Gauge_ArrowResourceFree(GAUGE_WORK *gauge)
{
	CATS_SYS_PTR csp;
	CATS_RES_PTR crp;
	const TCATS_OBJECT_ADD_PARAM_S *obj_head;

	obj_head = Sub_ArrowObjHeadGet(gauge->type);
	if(obj_head == NULL){
		return;
	}
	
	csp = BattleWorkCATS_SYS_PTRGet(gauge->bw);
	crp = BattleWorkCATS_RES_PTRGet(gauge->bw);

	//\[X
	CATS_FreeResourceChar(crp, obj_head->id[CLACT_U_CHAR_RES]);
//	CATS_FreeResourcePltt(crp, obj_head->id[CLACT_U_PLTT_RES]);
	CATS_FreeResourceCell(crp, obj_head->id[CLACT_U_CELL_RES]);
	CATS_FreeResourceCellAnm(crp, obj_head->id[CLACT_U_CELLANM_RES]);
}


//--------------------------------------------------------------
/**
 * @brief   Q[W̃AN^[o^ƃ\[Xo^Zbgɂ
 * @param   gauge		Q[W[Nւ̃|C^
 */
//--------------------------------------------------------------
void Gauge_ActorResourceSet(GAUGE_WORK *gauge)
{
	const TCATS_OBJECT_ADD_PARAM_S *obj_head;
	CATS_SYS_PTR csp;
	CATS_RES_PTR crp;
	PALETTE_FADE_PTR pfd;
	
	csp = BattleWorkCATS_SYS_PTRGet(gauge->bw);
	crp = BattleWorkCATS_RES_PTRGet(gauge->bw);
	pfd = BattleWorkPfdGet(gauge->bw);
	
	obj_head = Sub_GaugeObjHeadGet(gauge->type);

	Gauge_ResourceLoad(csp, crp, pfd, gauge->type);
	gauge->cap = Gauge_ActorSet(csp, crp, gauge->type);
//	Gauge_PartsDraw(gauge, gauge->hp, GAUGE_DRAW_ALL);
	
	//
	Gauge_ArrowResourceLoad(csp, crp, pfd, gauge->type);
	gauge->arrow_cap = Gauge_ArrowActorSet(csp, crp, gauge->type);
	//̍WZbg
	if(gauge->arrow_cap != NULL){
		CATS_ObjectPosSet(gauge->arrow_cap->act, obj_head->x - ARROW_OFFSET_X, 
			obj_head->y + ARROW_OFFSET_Y);
	}
}

//--------------------------------------------------------------
/**
 * @brief   Q[W̃AN^[폜ƃ\[XZbgɂ
 * @param   gauge		Q[W[Nւ̃|C^
 */
//--------------------------------------------------------------
void Gauge_ActorResourceDel(GAUGE_WORK *gauge)
{
	//Q[W{
	Gauge_ActorDel(gauge);
	Gauge_ResourceFree(gauge);
	//
	Gauge_ArrowActorDel(gauge);
	Gauge_ArrowResourceFree(gauge);
}


//--------------------------------------------------------------
/**
 * @brief   HPo[̌vZJnOɍƗp[N̏s
 *
 * @param   gauge		Q[W[Nւ̃|C^
 * @param   damage		_[W(}CiXŃ_[WAvXȂ)
 *
 * Gauge_CalcHPsOɕKĂяoĒuKv܂B
 */
//--------------------------------------------------------------
void Gauge_InitCalcHP(GAUGE_WORK *gauge, int damage)
{
	gauge->hp_work = HP_WORK_INIT_VALUE;
	
	if(gauge->hp + damage < 0){
		damage -= gauge->hp + damage;
	}
	if(gauge->hp + damage > gauge->hpmax){
		damage -= (gauge->hp + damage) - gauge->hpmax;
	}
	
	//-- Q[WvZ[`ɍ킹邽߁A̋t]Ȃǂs --//
	gauge->damage = -damage;
	if(gauge->hp < 0){
		gauge->hp = 0;
	}
	if(gauge->hp > gauge->hpmax){
		gauge->hp = gauge->hpmax;
	}
}

//--------------------------------------------------------------
/**
 * @brief   HPo[̌vZƏ݂s
 *
 * @param   gauge		Q[W[Nւ̃|C^
 *
 * @retval  -1=IB@-1ȊO=vZr̐(ʂɕ\鐔l)
 *
 * Gauge_InitCalcHPɌĂłKv܂B
 */
//--------------------------------------------------------------
s32 Gauge_CalcHP(GAUGE_WORK *gauge)
{
	s32 calc_hp;
	
	calc_hp = GaugeOBJ(gauge, GAUGE_REQ_HP);	//vZo[
	if(calc_hp == -1){
		//vZIɃQ[W[Nhpp[^ŐV̒l(_[WvZ)ōXVĂ
		gauge->hp -= gauge->damage;
		Gauge_PartsDraw(gauge, gauge->hp, GAUGE_DRAW_HPNUM);	//l
	}
	else{
		Gauge_PartsDraw(gauge, calc_hp, GAUGE_DRAW_HPNUM);	//l
	}
	return calc_hp;
}

//--------------------------------------------------------------
/**
 * @brief   EXPo[̌vZJnOɍƗp[N̏s
 *
 * @param   gauge		Q[W[Nւ̃|C^
 * @param   add_exp		ZEXPl
 *
 * Gauge_CalcEXPsOɕKĂяoĒuKv܂B
 */
//--------------------------------------------------------------
void Gauge_InitCalcEXP(GAUGE_WORK *gauge, int add_exp)
{
	gauge->exp_work = HP_WORK_INIT_VALUE;

	if(gauge->exp + add_exp < 0){
		add_exp -= gauge->exp + add_exp;
	}
	if(gauge->exp + add_exp > gauge->max_exp){
		add_exp -= (gauge->exp + add_exp) - gauge->max_exp;
	}

	//-- Q[WvZ[`ɍ킹邽߁A̋t]Ȃǂs --//
	gauge->add_exp = -add_exp;
	if(gauge->exp < 0){
		gauge->exp = 0;
	}
	if(gauge->exp > gauge->max_exp){
		gauge->exp = gauge->max_exp;
	}
}

//--------------------------------------------------------------
/**
 * @brief   EXPo[̌vZƏ݂s
 *
 * @param   gauge		Q[W[Nւ̃|C^
 *
 * @retval  -1=IB@-1ȊO=vZr̐(ʂɕ\鐔l)
 *
 * Gauge_InitCalcEXPɌĂłKv܂B
 */
//--------------------------------------------------------------
s32 Gauge_CalcEXP(GAUGE_WORK *gauge)
{
	s32 calc_exp;
	
	calc_exp = GaugeOBJ(gauge, GAUGE_REQ_EXP);
	if(calc_exp == -1){
		//vZIɃQ[W[Nexpp[^ŐV̒l(_[WvZ)ōXVĂ
		gauge->exp -= gauge->add_exp;
	}
	return calc_exp;
}

//--------------------------------------------------------------
/**
 * @brief   AjJn
 * @param   gauge		Q[W[Nւ̃|C^
 */
//--------------------------------------------------------------
void Gauge_AnimeStart(GAUGE_WORK *gauge)
{
	if(gauge->arrow_cap == NULL){
		return;
	}
	CLACT_SetAnmFlag(gauge->arrow_cap->act, 1);
}

//--------------------------------------------------------------
/**
 * @brief   Aj~
 * @param   gauge		Q[W[Nւ̃|C^
 */
//--------------------------------------------------------------
void Gauge_AnimeStop(GAUGE_WORK *gauge)
{
	if(gauge->arrow_cap == NULL){
		return;
	}
	CLACT_SetAnmFlag(gauge->arrow_cap->act, 0);
	CLACT_AnmFrameSet(gauge->arrow_cap->act, 0);
}

//--------------------------------------------------------------
/**
 * @brief   Q[WBGvCIeBύX
 *
 * @param   gauge		Q[W[Nւ̃|C^
 * @param   bg_pri		BGvCIeB
 */
//--------------------------------------------------------------
void Gauge_BGPriSet(GAUGE_WORK *gauge, int bg_pri)
{
	if(gauge->cap == NULL){
		return;
	}
	CATS_ObjectBGPriSetCap(gauge->cap, bg_pri);
}

//--------------------------------------------------------------
/**
 * @brief   Q[W̕\E\Zbg
 *
 * @param   gauge		Q[W[Nւ̃|C^
 * @param   enable		CATS_ENABLE_TRUE(\) or CATS_ENABLE_FALSE(\)
 */
//--------------------------------------------------------------
void Gauge_EnableSet(GAUGE_WORK *gauge, int enable)
{
	if(gauge->cap == NULL){
		return;
	}
	
	CATS_ObjectEnableCap(gauge->cap, enable);
	if(gauge->arrow_cap != NULL){
		CATS_ObjectEnableCap(gauge->arrow_cap, enable);
	}
}

//--------------------------------------------------------------
/**
 * @brief   Q[WɃItZbg|WVZbg
 *
 * @param   gauge		Q[W[Nւ̃|C^
 * @param   x			ItZbgX
 * @param   y			ItZbgY
 *
 * ʏ̒ʒũItZbgɂȂ܂B
 */
//--------------------------------------------------------------
void Gauge_OffsetPosSet(GAUGE_WORK *gauge, int x, int y)
{
	const TCATS_OBJECT_ADD_PARAM_S *obj_head;
	
	GF_ASSERT(gauge->cap != NULL);

	obj_head = Sub_GaugeObjHeadGet(gauge->type);
	
	CATS_ObjectPosSet(gauge->cap->act, obj_head->x + x, obj_head->y + y);
	if(gauge->arrow_cap != NULL){
		CATS_ObjectPosSet(gauge->arrow_cap->act, 
			obj_head->x + x - ARROW_OFFSET_X, obj_head->y + y + ARROW_OFFSET_Y);
	}
}

//--------------------------------------------------------------
/**
 * @brief   Q[WXN[INEOUTGtFNgN
 *
 * @param   gauge		Q[W[Nւ̃|C^
 * @param   in_out		XN[(GAUGE_SCROLL_IN or GAUGE_SCROLL_OUT)
 *
 * GtFNgIɁAgauge->eff_wait_in_outTRUEZbg܂
 */
//--------------------------------------------------------------
void Gauge_ScrollEffectSet(GAUGE_WORK *gauge, int in_out)
{
	GF_ASSERT(gauge != NULL);
	GF_ASSERT(gauge->cap != NULL);
	
	gauge->eff_wait_in_out = FALSE;
	
	gauge->in_out_dir = in_out;
	if(in_out == GAUGE_SCROLL_IN){
		switch(gauge->type){
		case GAUGE_TYPE_AA:
		case GAUGE_TYPE_A:
		case GAUGE_TYPE_C:
			Gauge_OffsetPosSet(gauge, GAUGE_SCROLL_OUT_OFFSET_X, GAUGE_SCROLL_OUT_OFFSET_Y);
			break;
		default:
			Gauge_OffsetPosSet(gauge, -GAUGE_SCROLL_OUT_OFFSET_X, GAUGE_SCROLL_OUT_OFFSET_Y);
			break;
		}
	}
	else{
		Gauge_OffsetPosSet(gauge, 0, 0);
	}
	TCB_Add(Gauge_ScrollInOut, gauge, TCBPRI_HP_GAUGE_IN_TASK);
}

//--------------------------------------------------------------
/**
 * @brief   Q[WXN[^XN
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		GAUGE_WORKւ̃|C^
 */
//--------------------------------------------------------------
static void Gauge_ScrollInOut(TCB_PTR tcb, void *work)
{
	GAUGE_WORK *gauge = work;
	s16 x, y;
	const TCATS_OBJECT_ADD_PARAM_S *obj_head;
	int end;
	
	end = 0;
	obj_head = Sub_GaugeObjHeadGet(gauge->type);
	CATS_ObjectPosGetCap(gauge->cap, &x, &y);
	switch(gauge->type){
	case GAUGE_TYPE_AA:
	case GAUGE_TYPE_A:
	case GAUGE_TYPE_C:
		if(gauge->in_out_dir == GAUGE_SCROLL_IN){
			x -= GAUGE_SCROLL_SP_X;
			if(x < obj_head->x){
				x = obj_head->x;
				end++;
			}
		}
		else{
			x += GAUGE_SCROLL_SP_X;
			if(x > obj_head->x + GAUGE_SCROLL_OUT_OFFSET_X){
				x = obj_head->x + GAUGE_SCROLL_OUT_OFFSET_X;
				end++;
			}
		}
		break;
	default:
		if(gauge->in_out_dir == GAUGE_SCROLL_IN){
			x += GAUGE_SCROLL_SP_X;
			if(x > obj_head->x){
				x = obj_head->x;
				end++;
			}
		}
		else{
			x -= GAUGE_SCROLL_SP_X;
			if(x < obj_head->x - GAUGE_SCROLL_SP_X){
				x = obj_head->x - GAUGE_SCROLL_SP_X;
				end++;
			}
		}
		break;
	}
	CATS_ObjectPosSetCap(gauge->cap, x, y);
	if(gauge->arrow_cap != NULL){
		CATS_ObjectPosSetCap(gauge->arrow_cap, x - ARROW_OFFSET_X, y + ARROW_OFFSET_Y);
	}
	
	if(end > 0){
		gauge->eff_wait_in_out = TRUE;
		TCB_Delete(tcb);
		return;
	}
}

//--------------------------------------------------------------
/**
 * @brief   Q[W̃fobOHP\tO𔽓]
 *
 * @param   gauge		Q[W[[Nւ̃|C^
 * @param   put			TRUE:\B@FALSE:\
 *
 * PM_DEBUGLłȂꍇ͉܂B
 */
//--------------------------------------------------------------
void Gauge_DebugHPPutFlagFlip(GAUGE_WORK *gauge)
{
#ifdef PM_DEBUG
	gauge->debug_hp_put ^= TRUE;
#endif
}




//==============================================================================
//
//	p[c`
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   Q[Wp[c`FO
 * @param   gauge		Q[W[Nւ̃|C^
 */
//--------------------------------------------------------------
static void GaugeParts_NameDraw(GAUGE_WORK *gauge)
{
	GF_BGL_INI *bgl;
	u8 *buf;
	NNSG2dImageProxy * image;
	GF_BGL_BMPWIN bmpwin;
	MSGDATA_MANAGER *msg_man;
	STRBUF *monsname_p, *monsname_src;
	POKEMON_PARAM *pp;
	POKEMON_PASO_PARAM *ppp;
	WORDSET *wordset;
	
	bgl = BattleWorkGF_BGL_INIGet(gauge->bw);
	msg_man = BattleWorkFightMsgGet(gauge->bw);
	wordset = BattleWorkWORDSETGet(gauge->bw);
	
	//WJ
	monsname_p = STRBUF_Create(BUFLEN_GAUGE_POKESELENAME, HEAPID_BATTLE);
	monsname_src = MSGMAN_AllocString(msg_man, TargetPokemonMsg);
	pp = BattleWorkPokemonParamGet(gauge->bw, gauge->client_no, gauge->sel_mons_no);
	ppp = PPPPointerGet(pp);
	WORDSET_RegisterPokeNickName(wordset, 0, ppp);
	WORDSET_ExpandStr(wordset, monsname_p, monsname_src);
	
	//obt@BMPf[^WJ
	GF_BGL_BmpWinObjAdd(bgl, &bmpwin, NAME_SIZE_X, NAME_SIZE_Y, 
		NAME_CHAR_OFFSET, NAME_BACK_COLOR);
	GF_STR_PrintExpand(&bmpwin, FONT_SYSTEM, monsname_p, 0, 0, MSG_NO_PUT, NAME_FONT_COLOR, GAUGE_FONT_MARGIN, 0, NULL);
	buf = bmpwin.chrbuf;
	
	//`ꂽobt@VRAMɒ
	{
		void *obj_vram;
		u8 *high, *low;
		
		obj_vram = G2_GetOBJCharPtr();
		image = CLACT_ImageProxyGet(gauge->cap->act);
		high = buf;
		low = &buf[NAME_SIZE_X * 0x20];
		//
		MI_CpuCopy16(high, (void*)((u32)obj_vram + NameTrans[gauge->type][0].pos
			+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]), 
			NameTrans[gauge->type][0].size);
		MI_CpuCopy16(low, (void*)((u32)obj_vram + NameTrans[gauge->type][1].pos
			+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]), 
			NameTrans[gauge->type][1].size);
		//E
		MI_CpuCopy16(&high[NameTrans[gauge->type][0].size], 
			(void*)((u32)obj_vram + NameTrans[gauge->type][2].pos
			+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]), 
			NameTrans[gauge->type][2].size);
		MI_CpuCopy16(&low[NameTrans[gauge->type][1].size], 
			(void*)((u32)obj_vram + NameTrans[gauge->type][3].pos
			+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]), 
			NameTrans[gauge->type][3].size);
	}
	
	//BMPf[^
	GF_BGL_BmpWinDel(&bmpwin);
	//obt@
	STRBUF_Delete(monsname_p);
	STRBUF_Delete(monsname_src);
	
#if 0
	//]
	image = CLACT_ImageProxyGet(gauge->cap->act);
	AddVramTransferManager(
		NNS_GFD_DST_2D_OBJ_CHAR_MAIN,
		image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN],
		buf,
		NAME_BYTE_SIZE
		);
#endif
}

//--------------------------------------------------------------
/**
 * @brief   Q[Wp[c`Fx
 * @param   gauge		Q[W[Nւ̃|C^
 */
//--------------------------------------------------------------
static void GaugeParts_LevelFontDraw(GAUGE_WORK *gauge)
{
	u8 *level_buf, *dest_buf;
	NNSG2dImageProxy * image;
	int numfont_size, i, t, k;
	
	numfont_size = (NUMFONT_MARK_WIDTH / 8) * (NUMFONT_HEIGHT / 8) * 32;
	//WJ̈m
	level_buf = sys_AllocMemory(HEAPID_BATTLE, numfont_size);
	dest_buf = sys_AllocMemory(HEAPID_BATTLE, numfont_size * 2);
//	MI_CpuFill8(level_buf, LEVEL_BACK_COLOR | (LEVEL_BACK_COLOR << 4), LEVEL_KETA_MAX * 0x20);
	
	NUMFONT_WriteMarkCGXOnly(BattleWorkGF_BGL_NumFontLVGet(gauge->bw),
		NUMFONT_MARK_LV, level_buf);
	
	//`ꂽobt@VRAMɒ
	{
		void *obj_vram;
		u8 *high, *low;
		
		obj_vram = G2_GetOBJCharPtr();
		image = CLACT_ImageProxyGet(gauge->cap->act);
		
		//Vram烁̈ɈxRs[
		MI_CpuCopy16((void*)((u32)obj_vram + LvFontTrans[gauge->type][0].pos
			+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]), 
			dest_buf, LvFontTrans[gauge->type][0].size);
		MI_CpuCopy16((void*)((u32)obj_vram + LvFontTrans[gauge->type][1].pos
			+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]), 
			&dest_buf[numfont_size], LvFontTrans[gauge->type][1].size);
		
		//̈ɃRs[̂ɐtHg
		k = 0;
		for(t = 0; t < numfont_size; t += 32){
			for(i = 0; i < 16; i++){
				dest_buf[t + 16 + i] = level_buf[k];
				dest_buf[t + i + numfont_size] = level_buf[k + 16];
				k++;
			}
			k += 16;
		}
		
		//oオ̂Vram֏߂
		high = dest_buf;
		low = &dest_buf[numfont_size];
		MI_CpuCopy16(high, (void*)((u32)obj_vram + LvFontTrans[gauge->type][0].pos
			+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]), 
			LvFontTrans[gauge->type][0].size);
		MI_CpuCopy16(low, (void*)((u32)obj_vram + LvFontTrans[gauge->type][1].pos
			+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]), 
			LvFontTrans[gauge->type][1].size);
	}
	
	//WJ̈
	sys_FreeMemoryEz(level_buf);
	sys_FreeMemoryEz(dest_buf);
}

//--------------------------------------------------------------
/**
 * @brief   Q[Wp[c`Fx
 * @param   gauge		Q[W[Nւ̃|C^
 */
//--------------------------------------------------------------
static void GaugeParts_LevelDraw(GAUGE_WORK *gauge)
{
	u8 *level_buf, *dest_buf;
	NNSG2dImageProxy * image;
	int size, i, t, k;
	
	//WJ̈m
	size = LEVEL_KETA_MAX * 0x20;
	level_buf = sys_AllocMemory(HEAPID_BATTLE, size);
	dest_buf = sys_AllocMemory(HEAPID_BATTLE, size * 2);
	MI_CpuFill8(level_buf, LEVEL_BACK_COLOR | (LEVEL_BACK_COLOR << 4), size);
	
	NUMFONT_WriteNumberCGXOnly(BattleWorkGF_BGL_NumFontLVGet(gauge->bw),
		gauge->level, LEVEL_KETA_MAX, NUMFONT_MODE_LEFT, level_buf);
	
	//`ꂽobt@VRAMɒ
	{
		void *obj_vram;
		u8 *high, *low;
		
		obj_vram = G2_GetOBJCharPtr();
		image = CLACT_ImageProxyGet(gauge->cap->act);

		//Vram烁̈ɈxRs[
		MI_CpuCopy16((void*)((u32)obj_vram + LvTrans[gauge->type][0].pos
			+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]), 
			dest_buf, LvTrans[gauge->type][0].size);
		MI_CpuCopy16((void*)((u32)obj_vram + LvTrans[gauge->type][1].pos
			+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]), 
			&dest_buf[size], LvTrans[gauge->type][1].size);

		//̈ɃRs[̂ɐtHg
		k = 0;
		for(t = 0; t < size; t += 32){
			for(i = 0; i < 16; i++){
				dest_buf[t + 16 + i] = level_buf[k];
				dest_buf[t + i + size] = level_buf[k + 16];
				k++;
			}
			k += 16;
		}
		//oオ̂Vram֏߂
		high = dest_buf;
		low = &dest_buf[size];
		MI_CpuCopy16(high, (void*)((u32)obj_vram + LvTrans[gauge->type][0].pos
			+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]), 
			LvTrans[gauge->type][0].size);
		MI_CpuCopy16(low, (void*)((u32)obj_vram + LvTrans[gauge->type][1].pos
			+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]), 
			LvTrans[gauge->type][1].size);
	}
	
	//WJ̈
	sys_FreeMemoryEz(level_buf);
	sys_FreeMemoryEz(dest_buf);
}

//--------------------------------------------------------------
/**
 * @brief   Q[Wp[c`FHP
 * @param   gauge		Q[W[Nւ̃|C^
 * @param   hp			\HP
 */
//--------------------------------------------------------------
static void GaugeParts_HPDraw(GAUGE_WORK *gauge, u32 hp)
{
	u8 *alloc_buf;
	NNSG2dImageProxy * image;
	
	//WJ̈m
	alloc_buf = sys_AllocMemory(HEAPID_BATTLE, HP_KETA_MAX * 0x20);
	MI_CpuFill8(alloc_buf, HP_BACK_COLOR | (HP_BACK_COLOR << 4), HP_KETA_MAX * 0x20);
	
	NUMFONT_WriteNumberCGXOnly(BattleWorkGF_BGL_NumFontHPGet(gauge->bw),
		hp, HP_KETA_MAX, NUMFONT_MODE_SPACE, alloc_buf);
	
	//`ꂽobt@VRAMɒ
	{
		void *obj_vram;
		u8 *high;
		
		obj_vram = G2_GetOBJCharPtr();
		image = CLACT_ImageProxyGet(gauge->cap->act);
		high = alloc_buf;
		//1ڏ
		MI_CpuCopy16(high, (void*)((u32)obj_vram + HPTrans[gauge->type][0].pos
			+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]), 
			HPTrans[gauge->type][0].size);
		//2ڏ
		MI_CpuCopy16(&high[HPTrans[gauge->type][0].size], 
			(void*)((u32)obj_vram + HPTrans[gauge->type][1].pos
			+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]), 
			HPTrans[gauge->type][1].size);
	}
	
	//WJ̈
	sys_FreeMemoryEz(alloc_buf);
}

//--------------------------------------------------------------
/**
 * @brief   Q[Wp[c`FHP
 * @param   gauge		Q[W[Nւ̃|C^
 */
//--------------------------------------------------------------
static void GaugeParts_HPMaxDraw(GAUGE_WORK *gauge)
{
	u8 *alloc_buf;
	NNSG2dImageProxy * image;
	
	//WJ̈m
	alloc_buf = sys_AllocMemory(HEAPID_BATTLE, HP_KETA_MAX * 0x20);
	MI_CpuFill8(alloc_buf, HPMAX_BACK_COLOR | (HPMAX_BACK_COLOR << 4), HP_KETA_MAX * 0x20);
	
	NUMFONT_WriteNumberCGXOnly(BattleWorkGF_BGL_NumFontHPGet(gauge->bw),
		gauge->hpmax, HP_KETA_MAX, NUMFONT_MODE_LEFT, alloc_buf);
	
	//`ꂽobt@VRAMɒ
	{
		void *obj_vram;
		u8 *high;
		
		obj_vram = G2_GetOBJCharPtr();
		image = CLACT_ImageProxyGet(gauge->cap->act);
		high = alloc_buf;
		//
		MI_CpuCopy16(high, (void*)((u32)obj_vram + HPMaxTrans[gauge->type].pos
			+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]), 
			HPMaxTrans[gauge->type].size);
	}
	
	//WJ̈
	sys_FreeMemoryEz(alloc_buf);
}

//--------------------------------------------------------------
/**
 * @brief   Q[Wp[c`F
 * @param   gauge		Q[W[Nւ̃|C^
 */
//--------------------------------------------------------------
static void GaugeParts_SexDraw(GAUGE_WORK *gauge)
{
	NNSG2dImageProxy * image;
	const u8 *parts_sex;
	
	if(gauge->sex == PARA_MALE){
		parts_sex = GetGaugePartsAdrs(GP_SEX_MALE);
	}
	else if(gauge->sex == PARA_FEMALE){
		parts_sex = GetGaugePartsAdrs(GP_SEX_FEMALE);
	}
	else{
		parts_sex = GetGaugePartsAdrs(GP_SEX_UNK);
	}
	
	//`ꂽobt@VRAMɒ
	{
		void *obj_vram;
		
		obj_vram = G2_GetOBJCharPtr();
		image = CLACT_ImageProxyGet(gauge->cap->act);
		
		//
		MI_CpuCopy16(parts_sex, (void*)((u32)obj_vram + SexTrans[gauge->type][0].pos
			+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]), 
			SexTrans[gauge->type][0].size);
		MI_CpuCopy16(&parts_sex[0x20], (void*)((u32)obj_vram + SexTrans[gauge->type][1].pos
			+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]), 
			SexTrans[gauge->type][1].size);
	}
}

//--------------------------------------------------------------
/**
 * @brief   Q[Wp[c`FQbgς݃}[N
 * @param   gauge		Q[W[Nւ̃|C^
 */
//--------------------------------------------------------------
static void GaugeParts_GetBallDraw(GAUGE_WORK *gauge)
{
	NNSG2dImageProxy * image;
	const u8 *parts_ball;
	
	if(gauge->getball == TRUE){
		parts_ball = GetGaugePartsAdrs(GP_GETBALL);
	}
	else{
		parts_ball = GetGaugePartsAdrs(GP_NON_GETBALL);
	}
	
	//`ꂽobt@VRAMɒ
	{
		void *obj_vram;
		
		obj_vram = G2_GetOBJCharPtr();
		image = CLACT_ImageProxyGet(gauge->cap->act);
		
		//
		MI_CpuCopy16(parts_ball, (void*)((u32)obj_vram + GetBallTrans[gauge->type].pos
			+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]), 
			GetBallTrans[gauge->type].size);
	}
}

//--------------------------------------------------------------
/**
 * @brief   Q[Wp[c`F
 * @param   gauge		Q[W[Nւ̃|C^
 */
//--------------------------------------------------------------
static void GaugeParts_StatusDraw(GAUGE_WORK *gauge, int gp_num)
{
	NNSG2dImageProxy * image;
	const u8 *parts_status;
	
	parts_status = GetGaugePartsAdrs(gp_num);
	
	//`ꂽobt@VRAMɒ
	{
		void *obj_vram;
		
		obj_vram = G2_GetOBJCharPtr();
		image = CLACT_ImageProxyGet(gauge->cap->act);
		
		//
		MI_CpuCopy16(parts_status, (void*)((u32)obj_vram + StatusTrans[gauge->type].pos
			+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]), 
			StatusTrans[gauge->type].size);
	}
}







//==============================================================================
//
//	FQ[WvZ[`	(GhڐA)
//
//==============================================================================

//--------------------------------------------------------------
/**
 * @brief   HPQ[W̃o[̕
 *
 * @param   gauge			Q[W[Nւ̃|C^
 * @param   req_data		GAUGE_REQ_???
 *
 * @retval  -1=IB@-1ȊO=vZr̐(ʂɕ\鐔l)
 */
//--------------------------------------------------------------
static s32 GaugeOBJ(GAUGE_WORK *gauge, int req_data)
{
	s32 temp;
	s32 dotto_offset;
	
	//Q[WvZ
	if(req_data == GAUGE_REQ_HP){
		temp = GaugeProc(gauge->hpmax, gauge->hp, gauge->damage, 
			&gauge->hp_work, BAR_HP_CHARMAX, 1);
	}
	else{	//GAUGE_REQ_EXP
		//EXPްނ͌vZl傫̂ŁAޯĂ̵̾Ă牽SyncŏI点邩߂
		dotto_offset = DottoOffsetCalc(gauge->exp, gauge->add_exp, gauge->max_exp,
				BAR_EXP_CHARMAX);
		if(dotto_offset == 0)
			dotto_offset = 1;
		dotto_offset = abs(gauge->add_exp / dotto_offset);
		temp = GaugeProc(gauge->max_exp, gauge->exp, gauge->add_exp,
				&gauge->exp_work, BAR_EXP_CHARMAX, dotto_offset);
	}
	
	//Q[W`
	PutGaugeOBJ(gauge, req_data);
	
	if(temp == -1){
		if(req_data == GAUGE_REQ_HP){
			gauge->hp_work = 0;
		}
		else{
			gauge->exp_work = 0;
		}
	}
	return temp;
}


//--------------------------------------------------------------
/**
 * @brief   Q[Wo[`
 *
 * @param   gauge		Q[W[Nւ̃|C^
 * @param   req			GAUGE_REQ_???
 */
//--------------------------------------------------------------
static void PutGaugeOBJ(GAUGE_WORK *gauge, u8 req)
{
	u8 i;
	u8 gauge_chr[BAR_ALL_MAX];
	u8 parts, parts_num;
	u8 put_dot;
	u8 level;
	const u8 *parts_address;
	void *obj_vram;
	NNSG2dImageProxy * image;
	int one_loop;
	
	obj_vram = G2_GetOBJCharPtr();
	image = CLACT_ImageProxyGet(gauge->cap->act);
	
	switch(req){
	case GAUGE_REQ_HP:
		put_dot = PutGaugeProc(gauge->hpmax, gauge->hp, gauge->damage,
			 &gauge->hp_work, gauge_chr, BAR_HP_CHARMAX);

		//Q[W̕\hbgFƃp[cAhX擾
		{
			int dotto_color;
			
			dotto_color = GetGaugeDottoColor(put_dot, GAUGE_HP_DOTTOMAX);
			switch(dotto_color){
			case HP_DOTTO_GREEN:
				parts_num = 
					(gauge->type == GAUGE_TYPE_AA) ? GP_AA_HPBAR_GREEN : GP_HPBAR_GREEN;
				break;
			case HP_DOTTO_YELLOW:
				parts_num = 
					(gauge->type == GAUGE_TYPE_AA) ? GP_AA_HPBAR_YELLOW : GP_HPBAR_YELLOW;
				break;
			case HP_DOTTO_RED:
			default:
				parts_num = 
					(gauge->type == GAUGE_TYPE_AA) ? GP_AA_HPBAR_RED : GP_HPBAR_RED;
				break;
			}
		}
		parts_address = GetGaugePartsAdrs(parts_num);
		
		one_loop = HPBarTrans[gauge->type][0].size / 0x20;
		for(i = 0; i < BAR_HP_CHARMAX; i++){
			if(i < one_loop){
				MI_CpuCopy16(parts_address + (gauge_chr[i] << 5),
					(void*)((u32)obj_vram + HPBarTrans[gauge->type][0].pos + (i * 0x20)
					+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]),
					0x20);
			}
			else{
				MI_CpuCopy16(parts_address + (gauge_chr[i] << 5),
					(void*)((u32)obj_vram + HPBarTrans[gauge->type][1].pos + ((i-one_loop) * 0x20)
					+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]),
					0x20);
			}
		}
		break;
	
	case GAUGE_REQ_EXP:
		PutGaugeProc(gauge->max_exp, gauge->exp, gauge->add_exp,
				&gauge->exp_work, gauge_chr, BAR_EXP_CHARMAX);
		level = gauge->level;
		if(level == 100){
			for(i = 0; i < BAR_EXP_CHARMAX; i++){
				gauge_chr[i] = 0;
			}
		}
		
		parts_address = GetGaugePartsAdrs(GP_EXP);
		for(i = 0; i < BAR_EXP_CHARMAX; i++){
			if(i < EXPBAR_NEXT_OAM){
				MI_CpuCopy16(parts_address + (gauge_chr[i] << 5),
					(void*)((u32)obj_vram + EXPBAR_FAST_HIGH + (i * 0x20)
					+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]),
					0x20);
			}
			else{
				MI_CpuCopy16(parts_address + (gauge_chr[i] << 5),
					(void*)((u32)obj_vram + EXPBAR_SECOND_HIGH + ((i-EXPBAR_NEXT_OAM) * 0x20)
					+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]),
					0x20);
			}
		}
	#if 0
		for(i = 0; i < BAR_EXP_CHARMAX; i++){
			if(i < 4){
				CpuCopy(
					(void*)(GetGaugePartsAdrs(GP_EXPBAR) + (gauge_chr[i] << 5)),
					((ActWork[gwork[client_no].actno].oamData.CharNo +0x24 + i) << 5)
					+ OBJ_MODE0_VRAM, 0x20, 32);
			}
			else{
				CpuCopy(
					(void*)(GetGaugePartsAdrs(GP_EXPBAR) + (gauge_chr[i] << 5)),
					((ActWork[gwork[client_no].actno].oamData.CharNo +0x60 + i-4) << 5)
					+ OBJ_MODE0_VRAM, 0x20, 32);
			}
		}
	#endif
		break;
	}
}

//--------------------------------------------------------------
/**
 * @brief   Q[Wo[vZ
 *
 * @param   MaxHP		őHP
 * @param   NowHP		HP(vZOHP)
 * @param   beHP		_[W(-Ń_[WA+Ȃ)
 * @param   HP_Work		Ɨp[N
 * @param   GaugeMax	Q[W̃LN^
 * @param   add_dec		ްނZĂl GaugeDottoGaugeMaxȉ̏ꍇ͖
 *
 * @retval  -1 = I	ȊOFvZr̐(ʂɏol)
 */
//--------------------------------------------------------------
static s32 GaugeProc(s32 MaxHP, s32 NowHP, s32 beHP, s32 *HP_Work, u8 GaugeMax, u16 add_dec)
{
	s32 endHP;	//2002.09.14(y)
	s32 ret;
	u8 GaugeMaxDot;
	s32 add_hp;
	
	GaugeMaxDot = GaugeMax * GAUGE_DOTTO;
	
	//-- HP_WorkHP_WORK_INIT_VALUE̎͏Ȃ̂Ń[N --//
	if(*HP_Work == HP_WORK_INIT_VALUE){
		if(MaxHP < GaugeMaxDot){
			*HP_Work = NowHP << 8;
		}
		else{
			*HP_Work = NowHP;
		}
	}

	//-- I --//
	endHP = NowHP - beHP;
	if(endHP < 0)
		endHP = 0;
	else if(endHP > MaxHP)
		endHP = MaxHP;
	
	if(MaxHP < GaugeMaxDot){			//
		if(endHP == (*HP_Work >> 8) && (*HP_Work & 0xff) == 0)
			return (-1);
	}
	else{
		if(endHP == *HP_Work)
			return (-1);
	}
	//-- II --//
	
	if(MaxHP < GaugeMaxDot){
		add_hp = MaxHP * 0x100 / GaugeMaxDot;
		if(beHP < 0){	//ްމ
			*HP_Work += add_hp;
			ret = *HP_Work >> 8;
			if(ret >= endHP){	//Ă̂ŵް۰
				*HP_Work = endHP << 8;
				ret = endHP;
			}
		}
		else{					//ްތ
			*HP_Work -= add_hp;
			ret = *HP_Work >> 8;
			if((*HP_Work & 0xff) > 0)	//Ȃ班Jグŕ\
				ret++;
			if(ret <= endHP){	//Ă̂ŵް۰
				*HP_Work = endHP << 8;
				ret = endHP;
			}
		}
	}
	else{
		if(beHP < 0){		//ްމ
			*HP_Work += add_dec;
			if(*HP_Work > endHP)
				*HP_Work = endHP;
		}
		else{				//ްތ
			*HP_Work -= add_dec;
			if(*HP_Work < endHP)
				*HP_Work = endHP;
		}
		ret = *HP_Work;
	}
	return ret;
}

//--------------------------------------------------------------
/**
 * @brief   Q[W\vZ
 *
 * @param   MaxHP		őHP
 * @param   NowHP		HP(vZOHP)
 * @param   beHP		_[W(-Ń_[WA+Ȃ)
 * @param   HP_Work		Ɨp[N
 * @param   gauge_chr	Q[W\ʑ(GaugeMax̔zvfKv)
 * @param   GaugeMax	Q[W̃LN^
 *
 * @retval  \hbg
 *
 * gauge_chrɓĺA0:ۂ̹ް  1:1ޯĂ̹ް 2:2ޯĂ̹ް  8:8ޯ()̹ް
 */
//--------------------------------------------------------------
static u8 PutGaugeProc(s32 MaxHP, s32 NowHP, s32 beHP, s32 *HP_Work, u8 *gauge_chr, u8 GaugeMax)
{
	int i;
	u32 GaugeMaxDot;
	u32 put_dot, dot_ret;		//\ޯĐ
	s32 AfterHP;
	
	AfterHP = NowHP - beHP;
	if(AfterHP < 0){
		AfterHP = 0;
	}
	else if(AfterHP > MaxHP){
		AfterHP = MaxHP;
	}

	GaugeMaxDot = GAUGE_DOTTO * GaugeMax;
	for(i = 0; i < GaugeMax; i++){	//󔒹ްނŏ
		gauge_chr[i] = 0;
	}

	//̃hbg擾̌vZύXGetNumDottǒvZύX邱!!
	if(MaxHP < GaugeMaxDot){	// by 2002.07.11() matsuda
		put_dot = (*HP_Work * GaugeMaxDot / MaxHP) >> 8;
	}
	else{
		put_dot = *HP_Work * GaugeMaxDot / MaxHP;
	}
	dot_ret = put_dot;
	//ޯČvZł0łAۂHP1ȏ゠Ȃ1ޯĂ̹ްނ\
	if(put_dot == 0 && AfterHP > 0){
		gauge_chr[0] = 1;
		dot_ret = 1;
	}else{
		for(i = 0; i < GaugeMax; i++){
			if(put_dot >= GAUGE_DOTTO){
				gauge_chr[i] = 8;
				put_dot -= GAUGE_DOTTO;
			}
			else{
				gauge_chr[i] = put_dot;
				break;	//ޯĂŝŔ
			}
		}
	}
	return dot_ret;
}

//--------------------------------------------------------------
/**
 * @brief   ްތvZOƌvZ̍ŏIIޯĂ̍߂
 *
 * @param   nowHP		HP(vZOHP)
 * @param   beHP		_[W(-Ń_[WA+Ȃ)
 * @param   MaxHP		őHP
 * @param   GaugeMax	Q[W̃LN^
 *
 * @retval  hbg
 */
//--------------------------------------------------------------
static u32 DottoOffsetCalc(s32 nowHP, s32 beHP, s32 MaxHP, u8 GaugeMax)
{
	s8 now_dotto, end_dotto;
	u8 GaugeMaxDot;
	s32 endHP;
	
	GaugeMaxDot = GaugeMax * GAUGE_DOTTO;

	endHP = nowHP - beHP;
	if(endHP < 0)
		endHP = 0;
	else if(endHP > MaxHP)
		endHP = MaxHP;
	now_dotto = nowHP * GaugeMaxDot / MaxHP;
	end_dotto = endHP * GaugeMaxDot / MaxHP;
	return (abs(now_dotto - end_dotto));
}

//--------------------------------------------------------------
/**
 * @brief   wp[c̃OtBbNAhX擾
 * @param   parts_num		p[cԍ
 * @retval  p[c̃OtBbNAhX
 */
//--------------------------------------------------------------
static const u8 * GetGaugePartsAdrs(int parts_num)
{
	return &gage_parts[parts_num * 0x20];
}

//--------------------------------------------------------------
/**
 * @brief   NCAg^CvQ[W^Cvo
 * @param   client_type		NCAg^Cv
 * @retval  Q[W^Cv
 */
//--------------------------------------------------------------
u8 Gauge_TypeGet(int client_type)
{
	switch(client_type){
	case CLIENT_TYPE_AA:
		return GAUGE_TYPE_AA;
	case CLIENT_TYPE_BB:
		return GAUGE_TYPE_BB;
	case CLIENT_TYPE_A:
		return GAUGE_TYPE_A;
	case CLIENT_TYPE_B:
		return GAUGE_TYPE_B;
	case CLIENT_TYPE_C:
		return GAUGE_TYPE_C;
	case CLIENT_TYPE_D:
		return GAUGE_TYPE_D;
	default:
		GF_ASSERT(0 && "pӂĂȂNCAg^CvnĂ܂");
		return NULL;
	}
	return 0;
}

//--------------------------------------------------------------
/**
 * @brief   Q[W^CvQ[W{̂̃AN^[wb_|C^擾
 * @param   gauge_type		Q[W^Cv
 * @retval  AN^[wb_|C^
 */
//--------------------------------------------------------------
static const TCATS_OBJECT_ADD_PARAM_S * Sub_GaugeObjHeadGet(u8 gauge_type)
{
	const TCATS_OBJECT_ADD_PARAM_S *obj_head;

	//\[Xǂݍ
	switch(gauge_type){
	case GAUGE_TYPE_AA:
		obj_head = &GaugeObjParam_aa;
		break;
	case GAUGE_TYPE_BB:
		obj_head = &GaugeObjParam_bb;
		break;
	case GAUGE_TYPE_A:
		obj_head = &GaugeObjParam_a;
		break;
	case GAUGE_TYPE_B:
		obj_head = &GaugeObjParam_b;
		break;
	case GAUGE_TYPE_C:
		obj_head = &GaugeObjParam_c;
		break;
	case GAUGE_TYPE_D:
		obj_head = &GaugeObjParam_d;
		break;
	default:
		GF_ASSERT(0 && "pӂĂȂQ[W^CvnĂ܂");
		return NULL;
	}
	return obj_head;
}

//--------------------------------------------------------------
/**
 * @brief   Q[W^CṽAN^[wb_|C^擾
 * @param   gauge_type		Q[W^Cv
 * @retval  AN^[wb_|C^(󂪕KvȂ^Cv̏ꍇNULL)
 */
//--------------------------------------------------------------
static const TCATS_OBJECT_ADD_PARAM_S * Sub_ArrowObjHeadGet(u8 gauge_type)
{
	const TCATS_OBJECT_ADD_PARAM_S *obj_head;

	//\[Xǂݍ
	switch(gauge_type){
	case GAUGE_TYPE_AA:
	case GAUGE_TYPE_A:
	case GAUGE_TYPE_C:
		obj_head = &ArrowParam_aa;
		break;
	case GAUGE_TYPE_BB:		//G͖KvȂ
	case GAUGE_TYPE_B:
	case GAUGE_TYPE_D:
		return NULL;
	default:
		GF_ASSERT(0 && "pӂĂȂQ[W^CvnĂ܂");
		return NULL;
	}
	return obj_head;
}
