//==============================================================================
/**
 * @file	gauge.h
 * @brief	퓬ʁFHPQ[W̃wb_
 * @author	matsuda
 * @date	2005.09.27()
 */
//==============================================================================
#ifndef __GAUGE_H__
#define __GAUGE_H__

#include "system/buflen.h"
#include "client_tool_def.h"



//==============================================================================
//	萔`
//==============================================================================
///Q[W̕WBGvCIeB
#define GAUGE_DEFAULT_BGPRI			(0)

//--------------------------------------------------------------
//	Q[W^Cv
//		NCAg^CvlύXĂe[u̕тɉeoȂ悤ɁA
//		Q[W^Cvʂɒ`BNCAg^CvK؂ȃQ[W^Cvo悤ɂ
//		e[u̓Q[W^Cv̕тɏ]ĂΈSɃf[^擾s
//--------------------------------------------------------------
enum{
	GAUGE_TYPE_AA,
	GAUGE_TYPE_BB,
	GAUGE_TYPE_A,
	GAUGE_TYPE_B,
	GAUGE_TYPE_C,
	GAUGE_TYPE_D,
};

///Q[WXN[
enum{
	GAUGE_SCROLL_IN,		///<XN[IN
	GAUGE_SCROLL_OUT,		///<XN[OUT
};


//--------------------------------------------------------------
//	Q[Wp[c`
//--------------------------------------------------------------
///Q[Wp[c`tOFHPo[
#define GAUGE_DRAW_HPBAR		(1 << 0)
///Q[Wp[c`tOFHP(l)
#define GAUGE_DRAW_HPNUM		(1 << 1)
///Q[Wp[c`tOFőHP(l)
#define GAUGE_DRAW_HPNUMMAX		(1 << 2)
///Q[Wp[c`tOFx
#define GAUGE_DRAW_LEVEL		(1 << 3)
///Q[Wp[c`tOFO
#define GAUGE_DRAW_NAME			(1 << 4)
///Q[Wp[c`tOFol
#define GAUGE_DRAW_EXP			(1 << 5)
///Q[Wp[c`tOF
#define GAUGE_DRAW_SEX			(1 << 6)
///Q[Wp[c`tOFx
#define GAUGE_DRAW_LEVEL_FONT	(1 << 7)
///Q[Wp[c`tOFԈُ
#define GAUGE_DRAW_STATUS		(1 << 8)
///Q[Wp[c`tOFQbgς݃}[N
#define GAUGE_DRAW_GETBALL		(1 << 9)
///Q[Wp[c`tOFS
#define GAUGE_DRAW_ALL			(0xffffffff)


//--------------------------------------------------------------
//	Q[W̃p[cOtBbN̔zuԍ
//--------------------------------------------------------------
enum{
	GP_HPBAR_GREEN = 2,			///<HPo[
	GP_HPBAR_YELLOW = 0x0b,		///<HPo[F
	GP_HPBAR_RED = 0x14,		///<HPo[
	
	GP_AA_HPBAR_GREEN = 0x1d,	///<HPo[(NCAgAAp)
	GP_AA_HPBAR_YELLOW = 0x26,	///<HPo[F(NCAgAAp)
	GP_AA_HPBAR_RED = 0x2f,		///<HPo[(NCAgAAp)
	
	GP_EXP = 0x38,				///<ol
	
	GP_NON_GETBALL = 0x55,		///<Qbgς݃}[NȂ
	GP_GETBALL = 0x56,			///<Qbgς݃}[N
	
	GP_SEX_FEMALE = 0x57,		///<ʁF
	GP_SEX_MALE = 0x59,			///<ʁFY
	GP_SEX_UNK = 0x54,			///<ʁFȂ
	
	GP_MAHI = 0x44,				///<
	GP_KOORI = 0x47,			///<X
	GP_NEMURI = 0x4a,			///<
	GP_DOKU = 0x4d,				///<
	GP_YAKEDO = 0x50,			///<₯
	GP_NON_STATUS = 0x53,		///<ԈُȂ
};


//--------------------------------------------------------------
//	FQ[WvZ[`Ŏgp
//--------------------------------------------------------------
///|P̕ԊuX
#define GAUGE_FONT_MARGIN	(0)

///1L̒ɓĂQ[W̃hbg
#define GAUGE_DOTTO			(8)

///HPo[̃L
#define BAR_HP_CHARMAX		(8)
///EXPo[̃L
#define BAR_EXP_CHARMAX		(12)
///Q[Wo[ňԑ傫Q[W̃L
#define BAR_ALL_MAX			(BAR_EXP_CHARMAX)

///HPQ[W̃hbg
#define GAUGE_HP_DOTTOMAX	(GAUGE_DOTTO * BAR_HP_CHARMAX)

///Ɨp[N̏lƂĎgp
#define HP_WORK_INIT_VALUE	(-2147483648)



//==============================================================================
//	\̒`
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   HPQ[WFTup[^
 *
 * NCAg疽߂󂯂閈ɁANAAXVp[^Q
 */
//--------------------------------------------------------------
typedef struct{
	u8			seq_no;
}GAUGE_SUB_PARAM;

//--------------------------------------------------------------
/**
 * @brief   HPQ[W\
 */
//--------------------------------------------------------------
typedef struct{
	GAUGE_SUB_PARAM param;	///<Tup[^
	CATS_ACT_PTR cap;		///<Q[W{̂̃wb_[tAN^[|C^
	CATS_ACT_PTR arrow_cap;	///<̃wb_[tAN^[|C^
	BATTLE_WORK	*bw;		///<퓬VXe[N\
	TCB_PTR tcb;			///<쒆TCB
	GF_BGL_BMPWIN name_bmpwin;	///<OBITMAP`p

	u8			client_no;
	u8 			type;		///<Q[W^Cv(GAUGE_TYPE_???)
	u8			sel_mons_no;	///<Ԗڂ̃|PIĂ邩
	
	s32			hp;			///<HP(be_hpvZOB@mɂ hp+be_hp ŐV̌HPƌ)
	s32			hpmax;		///<őHP
	s32			damage;		///<󂯂_[W(-Ń_[WA+Ȃ)
	s32			hp_work;	///<Q[WƗp[N
	
	s32			exp;		///<݂EXP(add_expvZO) ݂̃x̊JnEXPl
	s32			max_exp;	///<̃xAbv܂łEXP ݂̃x̊JnEXPl
	s32			add_exp;	///<ZEXP
	s32			exp_work;	///<Q[WƗp[N
	
	u8			level;		///<x
	u8			sex;		///<
	u8			status;		///<Ԉُ
	u8			getball;	///<Qbgς݃}[N
	
	u8			command_code;
	u8			in_wait;			///<INGtFNgÕEFCg
	
	u8			in_out_dir:1;		///<XN[(GAUGE_SCROLL_IN or GAUGE_SCROLL_OUT)
	u8			eff_wait_in_out:1;	///<GtFNg҂tO(TRUE=I)FXN[IN or OUT
	u8			eff_wait_lvup:1;	///<GtFNg҂tO(TRUE=I)FxAbv
	
#ifdef PM_DEBUG
	u8			debug_hp_put;	///<TRUE:GHP𐔒lł\
#endif
}GAUGE_WORK;



//==============================================================================
//	O֐錾
//==============================================================================
extern void Gauge_ResourceLoad(CATS_SYS_PTR csp, CATS_RES_PTR crp, PALETTE_FADE_PTR pfd, 
	int gauge_type);
extern CATS_ACT_PTR Gauge_ActorSet(CATS_SYS_PTR csp, CATS_RES_PTR crp, int gauge_type);
extern void Gauge_InitCalcHP(GAUGE_WORK *gauge, int damage);
extern s32 Gauge_CalcHP(GAUGE_WORK *gauge);
extern void Gauge_InitCalcEXP(GAUGE_WORK *gauge, int add_exp);
extern s32 Gauge_CalcEXP(GAUGE_WORK *gauge);
extern void Gauge_ActorDel(GAUGE_WORK *gauge);
extern void Gauge_ResourceFree(GAUGE_WORK *gauge);
extern void Gauge_ActorResourceSet(GAUGE_WORK *gauge);
extern void Gauge_ActorResourceDel(GAUGE_WORK *gauge);
extern void Gauge_PartsDraw(GAUGE_WORK *gauge, u32 hp, u32 draw_flag);
extern void Gauge_AnimeStart(GAUGE_WORK *gauge);
extern void Gauge_AnimeStop(GAUGE_WORK *gauge);
extern u8 Gauge_TypeGet(int client_type);
extern void Gauge_BGPriSet(GAUGE_WORK *gauge, int bg_pri);
extern void Gauge_OffsetPosSet(GAUGE_WORK *gauge, int x, int y);
extern void Gauge_ScrollEffectSet(GAUGE_WORK *gauge, int in_out);
extern void Gauge_EnableSet(GAUGE_WORK *gauge, int enable);

extern void Gauge_DebugHPPutFlagFlip(GAUGE_WORK *gauge);


#endif	//__GAUGE_H__
