//==============================================================================
/**
 * @file	ground.c
 * @brief	퓬ʁFn(|Pɏ邨~)
 * @author	matsuda
 * @date	2005.10.06()
 */
//==============================================================================
#include "common.h"
#include "graphic\batt_obj_def.h"
#include "battle/battle_common.h"
#include "battle/fight_tool.h"
#include "ground.h"
#include "system/arc_tool.h"



//==============================================================================
//	萔`
//==============================================================================
///nʂBGvCIeB
#define GROUND_BGPRI		(2)
///@nʂ̃\tgvCIeB
#define GROUND_SOFTPRI_MINE		(1000)
///Gnʂ̃\tgvCIeB
#define GROUND_SOFTPRI_ENEMY	(1000)


//==============================================================================
//	f[^
//==============================================================================
///nʃAN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S GroundObjParam[] = {
	{//GROUND_TYPE_NORMAL_MINE
		ENCOUNT_X_TYPE_AA, GROUND_MINE_Y, 0,		//x, y, z
		0, GROUND_SOFTPRI_MINE, 0,		//AjԍAD揇ʁApbgԍ
		NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
		{	//gp\[XIDe[u
			GROUND00_M_NCGR_BIN,	//L
			GROUND00_NCLR,	//pbg
			GROUND00_M_NCER_BIN,	//Z
			GROUND00_M_NANR_BIN,	//ZAj
			CLACT_U_HEADER_DATA_NONE,		//}`Z
			CLACT_U_HEADER_DATA_NONE,		//}`ZAj
		},
		GROUND_BGPRI,			//BGvCIeB
		0,			//Vram]tO
	},
	{//GROUND_TYPE_NORMAL_ENEMY
		ENCOUNT_X_TYPE_BB, GROUND_ENEMY_Y, 0,		//x, y, z
		0, GROUND_SOFTPRI_ENEMY, 0,		//AjԍAD揇ʁApbgԍ
		NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
		{	//gp\[XIDe[u
			GROUND00_E_NCGR_BIN,	//L
			GROUND00_NCLR,	//pbg
			GROUND00_E_NCER_BIN,	//Z
			GROUND00_E_NANR_BIN,	//ZAj
			CLACT_U_HEADER_DATA_NONE,		//}`Z
			CLACT_U_HEADER_DATA_NONE,		//}`ZAj
		},
		GROUND_BGPRI,			//BGvCIeB
		0,			//Vram]tO
	},
};


//--------------------------------------------------------------
/**
 * @brief   nʂ̃\[Xǂݍ
 * @param   ground		nʃ[Nւ̃|C^
 */
//--------------------------------------------------------------
void Ground_ResourceLoad(GROUND_WORK *ground)
{
	CATS_SYS_PTR csp;
	CATS_RES_PTR crp;
	const TCATS_OBJECT_ADD_PARAM_S *obj_param;
	
	GF_ASSERT(ground->type < NELEMS(GroundObjParam));
	
	csp = BattleWorkCATS_SYS_PTRGet(ground->bw);
	crp = BattleWorkCATS_RES_PTRGet(ground->bw);
	
	obj_param = &GroundObjParam[ground->type];
	
	CATS_LoadResourceCharArc(csp, crp, ARC_BATT_OBJ, obj_param->id[CLACT_U_CHAR_RES], 1, 
		NNS_G2D_VRAM_TYPE_2DMAIN, obj_param->id[CLACT_U_CHAR_RES]);
//	CATS_LoadResourcePlttArc(csp, crp, ARC_BATT_OBJ, obj_param->id[CLACT_U_PLTT_RES], 0, 
//		1, NNS_G2D_VRAM_TYPE_2DMAIN, obj_param->id[CLACT_U_PLTT_RES]);
	CATS_LoadResourcePlttWorkArc(BattleWorkPfdGet(ground->bw), FADE_MAIN_OBJ, csp, crp, 
		ARC_BATT_OBJ, obj_param->id[CLACT_U_PLTT_RES], 0, 
		1, NNS_G2D_VRAM_TYPE_2DMAIN, obj_param->id[CLACT_U_PLTT_RES]);
	CATS_LoadResourceCellArc(csp, crp, ARC_BATT_OBJ, obj_param->id[CLACT_U_CELL_RES], 1, 
		obj_param->id[CLACT_U_CELL_RES]);
	CATS_LoadResourceCellAnmArc(csp, crp, ARC_BATT_OBJ, obj_param->id[CLACT_U_CELLANM_RES], 1, 
		obj_param->id[CLACT_U_CELLANM_RES]);
}

//--------------------------------------------------------------
/**
 * @brief   nʃAN^[𐶐
 * @param   ground		nʃ[Nւ̃|C^
 *
 * Ƀ\[Xǂݍ܂ĂKv܂B
 */
//--------------------------------------------------------------
void Ground_ActorSet(GROUND_WORK *ground)
{
	CATS_SYS_PTR csp;
	CATS_RES_PTR crp;
	const TCATS_OBJECT_ADD_PARAM_S *obj_param;
	
	csp = BattleWorkCATS_SYS_PTRGet(ground->bw);
	crp = BattleWorkCATS_RES_PTRGet(ground->bw);

	obj_param = &GroundObjParam[ground->type];

	ground->cap = CATS_ObjectAdd_S(csp, crp, obj_param);
	CATS_ObjectUpdate(ground->cap->act);
}

//--------------------------------------------------------------
/**
 * @brief   nʂ̃AN^[폜
 * @param   ground		nʃ[Nւ̃|C^
 */
//--------------------------------------------------------------
void Ground_ActorDel(GROUND_WORK *ground)
{
	if(ground->cap == NULL){
		return;
	}
	CATS_ActorPointerDelete_S(ground->cap);
	ground->cap = NULL;
}

//--------------------------------------------------------------
/**
 * @brief   nʂ̃\[X
 * @param   ground		nʃ[Nւ̃|C^
 */
//--------------------------------------------------------------
void Ground_ResourceFree(GROUND_WORK *ground)
{
	CATS_SYS_PTR csp;
	CATS_RES_PTR crp;
	const TCATS_OBJECT_ADD_PARAM_S *obj_param;
	
	csp = BattleWorkCATS_SYS_PTRGet(ground->bw);
	crp = BattleWorkCATS_RES_PTRGet(ground->bw);

	obj_param = &GroundObjParam[ground->type];
	
	CATS_FreeResourceChar(crp, obj_param->id[CLACT_U_CHAR_RES]);
	CATS_FreeResourcePltt(crp, obj_param->id[CLACT_U_PLTT_RES]);
	CATS_FreeResourceCell(crp, obj_param->id[CLACT_U_CELL_RES]);
	CATS_FreeResourceCellAnm(crp, obj_param->id[CLACT_U_CELLANM_RES]);
}


//==============================================================================
//
//	̊֐Zbgɂ
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   nʂ̃\[XZbgƃAN^[o^Zbgɂ
 *
 * @param   ground		nʃ[Nւ̃|C^
 * @param   bw			퓬VXe[Nւ̃|C^
 * @param   type		nʂ̃OtBbN^Cv(GROUND_TYPE_???)
 */
//--------------------------------------------------------------
void Ground_ActorResourceSet(GROUND_WORK *ground, BATTLE_WORK *bw, u16 type)
{
	MI_CpuClearFast(ground, sizeof(GROUND_WORK));
	ground->bw = bw;
	ground->type = type;
	Ground_ResourceLoad(ground);
	Ground_ActorSet(ground);
}

//--------------------------------------------------------------
/**
 * @brief   nʂ̃AN^[폜ƃ\[XZbgɂ
 * @param   ground		nʃ[Nւ̃|C^
 */
//--------------------------------------------------------------
void Ground_ActorResourceDel(GROUND_WORK *ground)
{
	Ground_ActorDel(ground);
	Ground_ResourceFree(ground);
	MI_CpuClearFast(ground, sizeof(GROUND_WORK));
}

