
//============================================================================================
/**
 * @file	scio.c
 * @bfief	퓬T[oANCAgԃf[^M֐
 * @author	HisashiSogabe
 * @date	05.07.19
 */
//============================================================================================

#include "common.h"

#include "battle/battle_common.h"
#include "battle/battle_server.h"
#include "battle/client.h"
#include "battle/fight.h"
#include "battle/scio.h"
#include "battle/server.h"
#include "battle/server_tool.h"
#include "poketool/waza_tool.h"

#include "scio_def.h"
#include "comm_command_battle.h"

#include "fight_def.h"		///<BattleWorkւ̈ˑx̂ŁA
#include "server_def.h"		///<ServerParamւ̈ˑx̂ŁA
#include "client_def.h"		///<ClientParamւ̈ˑx̂ŁA

//============================================================================================
/**
 * 萔錾
 */
//============================================================================================

//============================================================================================
/**
 * vg^Cv錾
 */
//============================================================================================

void	SCIO_EncountEffectSet(BATTLE_WORK *bw,int send_client);
void	SCIO_PokemonEncountSet(BATTLE_WORK *bw,int send_client);
void	SCIO_PokemonAppearSet(BATTLE_WORK *bw,int send_client);
void	SCIO_PokemonReturnSet(BATTLE_WORK *bw,int send_client);
void	SCIO_PokemonDeleteSet(BATTLE_WORK *bw,int send_client);
void	SCIO_TrainerEncountSet(BATTLE_WORK *bw,int send_client);
void	SCIO_TrainerOutSet(BATTLE_WORK *bw,int send_client);
void	SCIO_TrainerInSet(BATTLE_WORK *bw,int send_client,int pos);
void	SCIO_HPGaugeInSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int send_client,int wait);
void	SCIO_HPGaugeOutSet(BATTLE_WORK *bw,int send_client);
void	SCIO_CommandSelectSet(BATTLE_WORK *bw,int send_client,int sel_mons_no);
void	SCIO_CommandSelectReturnSet(BATTLE_WORK *bw,int send_client,int data);
void	SCIO_WazaSelectSet(BATTLE_WORK *bw,POKEMON_SERVER_PARAM *psp,int send_client,int sel_mons_no);
void	SCIO_WazaSelectReturnSet(BATTLE_WORK *bw,int send_client,int data);
void	SCIO_DirSelectSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int range,int send_client);
void	SCIO_DirSelectReturnSet(BATTLE_WORK *bw,int send_client,int data);
void	SCIO_ItemSelectSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int send_client);
void	SCIO_ItemSelectReturnSet(BATTLE_WORK *bw,int send_client,ITEM_SELECT_RETURN_PARAM isrp);
void	SCIO_PokemonSelectSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int send_client,int list_mode,int chg_waza);
void	SCIO_PokemonSelectReturnSet(BATTLE_WORK *bw,int send_client,int data);
void	SCIO_YesNoSelectSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int send_client,int msg_id);
void	SCIO_YesNoSelectReturnSet(BATTLE_WORK *bw,int send_client,int data);
void	SCIO_AttackMessageSet(BATTLE_WORK *bw,SERVER_PARAM *sp);
void	SCIO_MessageSet(BATTLE_WORK *bw,SERVER_PARAM *sp,MESSAGE_PARAM *mp);
void	SCIO_WazaEffectSet(BATTLE_WORK *bw,SERVER_PARAM *sp);
void	SCIO_PokemonBlinkSet(BATTLE_WORK *bw,int send_client);
void	SCIO_HPGaugeCalcSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int send_client);
void	SCIO_EXPGaugeCalcSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int send_client,int now_exp);
void	SCIO_KizetsuEffectSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int send_client);
void	SCIO_SePlaySet(BATTLE_WORK *bw,SERVER_PARAM *sp,int se_no);
void	SCIO_FadeOutSet(BATTLE_WORK *bw,SERVER_PARAM *sp);
void	SCIO_PokemonVanishOnOff(BATTLE_WORK *bw,int send_client,int sw);
void	SCIO_HPGaugeStatusSet(BATTLE_WORK *bw,int send_client,int status);
void	SCIO_TrainerMessageSet(BATTLE_WORK *bw,int send_client,int type);
void	SCIO_StatusEffectSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int send_client,int status);
void	SCIO_ModosuMessageSet(BATTLE_WORK *bw,int send_client,int sel_mons_no);
void	SCIO_KuridasuMessageSet(BATTLE_WORK *bw,int send_client,int sel_mons_no);

void	SCIO_AlertMessageSet(BATTLE_WORK *bw,int send_client,MESSAGE_PARAM mp);
void	SCIO_AlertMessageEndSet(BATTLE_WORK *bw,int send_client);
void	SCIO_HPGaugeRefreshSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int send_client);
void	SCIO_PSPtoPPCopy(BATTLE_WORK *bw,SERVER_PARAM *sp,int send_client);
void	SCIO_TrainerBGSlideInSet(BATTLE_WORK *bw,int send_client);
void	SCIO_GaugeAnimeStop(BATTLE_WORK *bw,int send_client);
void	SCIO_PokemonRefreshSet(BATTLE_WORK *bw,int send_client,int waza_no);

void	SCIO_ServerQueClear(BATTLE_WORK *bw,int send_client,int index);

void	SCIO_CommRecvData(BATTLE_WORK *bw,void *data);

static	void	SCIO_Interface(BATTLE_WORK *bw,int access,int para,void *data,u8 size);
static	void	SCIO_EffectDataSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int flag,int data,int attack,int defence);

//============================================================================================
/**
 *
 *	f[^M
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 * @param[in]	access	T[oANCAgǂ̃f[^Ȃ̂ SCIO_SERVERFT[o
 *																	 SCIO_CLIENT:NCAg
 *																	 SCIO_SERVER_QUE:T[oL[
 *
 * @param[in]	para	access̒lɂĈӖω SCIO_SERVERFNCAgio[
 *													 SCIO_CLIENT:f[^𑗂NCAgio[
 *													 SCIO_SERVER_QUE:T[oL[폜Ώۂ̃NCAgio[
 * @param[in]	data	f[^̃[Ñ|C^
 * @param[in]	size	f[^̃TCY
 *
 *	data̒g
 *	accessSCIO_CLIENT̎́A
 *	data[0]:߃R[hCfbNX
 *	data[1]`:߃R[hCfbNXƂ̈f[^
 */
//============================================================================================
static	void	SCIO_Interface(BATTLE_WORK *bw,int access,int para,void *data,u8 size)
{
	int	i;
	u8	*send=(u8 *)data;

	//ۂ͒ʐMΐ̎̏쐬
	if(bw->fight_type&FIGHT_TYPE_SIO){
		if(access==SCIO_CLIENT){
			ST_ServerQueSet(bw->server_param,para,send[0]);
		}
		CommCommandBattleSendData(bw,access,para,data,size);
	}
	else{
		if(access==SCIO_SERVER){
			for(i=0;i<size;i++){
				bw->server_param->server_buffer[para][i]=send[i];
			}
		}
		else if(access==SCIO_CLIENT){
			ST_ServerQueSet(bw->server_param,para,send[0]);
			for(i=0;i<size;i++){
				bw->client_param[para]->client_buffer[i]=send[i];
			}
		}
		else if(access==SCIO_SERVER_QUE){
			ST_ServerQueReset(bw->server_param,para,send[0]);
		}
		else{
			OS_Printf("SCIO_Interface:ɂ̂́A\n");
		}
	}
}

//============================================================================================
/**
 *
 *	GJEgGtFNgZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 *
 */
//============================================================================================
void	SCIO_EncountEffectSet(BATTLE_WORK *bw,int send_client)
{
	int	command_code=CL_ENCOUNT_EFFECT;

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&command_code,4);
}

//============================================================================================
/**
 *
 *	|PGJEgZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 *
 */
//============================================================================================
void	SCIO_PokemonEncountSet(BATTLE_WORK *bw,int send_client)
{
	POKEMON_ENCOUNT_PARAM	pep;
	int						i;

	pep.command_code=CL_POKEMON_ENCOUNT;
	pep.sex		=bw->server_param->psp[send_client].sex;
	pep.rare	=bw->server_param->psp[send_client].rare;
	pep.monsno	=bw->server_param->psp[send_client].monsno;
	pep.voice	=ST_ServerPokeVoiceEffNoGet(bw->server_param,send_client);

	for(i=0;i<WAZA_TEMOTI_MAX;i++){
		pep.wazano[i]=	ST_ServerPokemonServerParamGet(bw->server_param,send_client,ID_PSP_waza1+i,		NULL);
		pep.pp[i]=		ST_ServerPokemonServerParamGet(bw->server_param,send_client,ID_PSP_pp1+i,		NULL);
		pep.ppmax[i]=	ST_ServerPokemonServerParamGet(bw->server_param,send_client,ID_PSP_pp_max1+i,	NULL);
	}
	ST_ServerPokemonServerParamGet(bw->server_param,send_client,ID_PSP_nickname,&pep.nickname);

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&pep,sizeof(POKEMON_ENCOUNT_PARAM));
}

//============================================================================================
/**
 *
 *	|PoZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 *
 */
//============================================================================================
void	SCIO_PokemonAppearSet(BATTLE_WORK *bw,int send_client)
{
	POKEMON_APPEAR_PARAM	pap;
	int						i;

	pap.command_code=CL_POKEMON_APPEAR;
	pap.sex		=bw->server_param->psp[send_client].sex;
	pap.rare	=bw->server_param->psp[send_client].rare;
	pap.monsno	=bw->server_param->psp[send_client].monsno;
	pap.voice	=ST_ServerPokeVoiceEffNoGet(bw->server_param,send_client);

	for(i=0;i<WAZA_TEMOTI_MAX;i++){
		pap.wazano[i]=	ST_ServerPokemonServerParamGet(bw->server_param,send_client,ID_PSP_waza1+i,		NULL);
		pap.pp[i]=		ST_ServerPokemonServerParamGet(bw->server_param,send_client,ID_PSP_pp1+i,		NULL);
		pap.ppmax[i]=	ST_ServerPokemonServerParamGet(bw->server_param,send_client,ID_PSP_pp_max1+i,	NULL);
	}
	ST_ServerPokemonServerParamGet(bw->server_param,send_client,ID_PSP_nickname,&pap.nickname);

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&pap,sizeof(POKEMON_APPEAR_PARAM));
}

//============================================================================================
/**
 *
 *	|P߂Zbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 *
 */
//============================================================================================
void	SCIO_PokemonReturnSet(BATTLE_WORK *bw,int send_client)
{
	POKEMON_RETURN_PARAM	prp;
	int						dir;

	if(bw->client_param[send_client]->client_type&CLIENT_ENEMY_FLAG){
		dir=PARA_FRONT;
	}
	else{
		dir=PARA_BACK;
	}

	prp.command_code=CL_POKEMON_RETURN;
	prp.height=PokeHeightGet(bw->server_param->psp[send_client].monsno,bw->server_param->psp[send_client].sex,dir);

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&prp,sizeof(POKEMON_RETURN_PARAM));
}

//============================================================================================
/**
 *
 *	|P폜
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 *
 */
//============================================================================================
void	SCIO_PokemonDeleteSet(BATTLE_WORK *bw,int send_client)
{
	int	command_code=CL_POKEMON_DELETE;

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&command_code,4);
}

//============================================================================================
/**
 *
 *	g[i[GJEgZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 *
 */
//============================================================================================
void	SCIO_TrainerEncountSet(BATTLE_WORK *bw,int send_client)
{
	TRAINER_ENCOUNT_PARAM	tep;

	tep.command_code=CL_TRAINER_ENCOUNT;
	tep.tr_id=bw->trainer_id[send_client];
	tep.tr_sex=bw->trainer_sex[send_client];

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&tep,sizeof(TRAINER_ENCOUNT_PARAM));
}

//============================================================================================
/**
 *
 *	g[i[ʊOGtFNgZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 *
 */
//============================================================================================
void	SCIO_TrainerOutSet(BATTLE_WORK *bw,int send_client)
{
	int	command_code=CL_TRAINER_OUT;

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&command_code,4);
}

//============================================================================================
/**
 *
 *	g[i[ʓGtFNgZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 *
 */
//============================================================================================
void	SCIO_TrainerInSet(BATTLE_WORK *bw,int send_client,int pos)
{
	TRAINER_IN_PARAM	tip;

	tip.command_code=CL_TRAINER_IN;
	tip.tr_id=bw->trainer_id[send_client];
	tip.tr_sex=bw->trainer_sex[send_client];
	tip.pos=pos;

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&tip,sizeof(TRAINER_IN_PARAM));
}

//============================================================================================
/**
 *
 *	HPQ[WʓGtFNgZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 *
 */
//============================================================================================
void	SCIO_HPGaugeInSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int send_client,int wait)
{
	HP_GAUGE_IN_PARAM	hgip;

	hgip.command_code=CL_HP_GAUGE_IN;
	hgip.level=sp->psp[send_client].level;
	hgip.hp=sp->psp[send_client].hp;
	hgip.hpmax=sp->psp[send_client].hpmax;
	hgip.sel_mons_no=sp->sel_mons_no[send_client];
	hgip.status=ST_ServerConditionNoGet(sp,send_client);
	hgip.sex=sp->psp[send_client].sex;
	hgip.now_exp=sp->psp[send_client].exp-PokeLevelExpGet(sp->psp[send_client].monsno,sp->psp[send_client].level);
	hgip.max_exp=PokeLevelExpGet(sp->psp[send_client].monsno,sp->psp[send_client].level+1)-
				 PokeLevelExpGet(sp->psp[send_client].monsno,sp->psp[send_client].level);
	hgip.get_mark=FT_ZukanFlagCheckGet(bw,sp->psp[send_client].monsno);

	hgip.wait=wait;

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&hgip,sizeof(HP_GAUGE_IN_PARAM));
}

//============================================================================================
/**
 *
 *	HPQ[WʊOGtFNgZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 *
 */
//============================================================================================
void	SCIO_HPGaugeOutSet(BATTLE_WORK *bw,int send_client)
{
	int	command_code=CL_HP_GAUGE_OUT;

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&command_code,4);
}

//============================================================================================
/**
 *
 *	R}hIZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 *
 */
//============================================================================================
void	SCIO_CommandSelectSet(BATTLE_WORK *bw,int send_client,int sel_mons_no)
{
	COMMAND_SELECT_PARAM	csp;
	int						i,j;
	POKEPARTY				*poke_party;
	POKEMON_PARAM			*pp;
	u32						fight_type;

	MI_CpuClearFast(&csp, sizeof(COMMAND_SELECT_PARAM));

	csp.command_code=CL_COMMAND_SELECT;
	csp.sel_mons_no=sel_mons_no;

	fight_type=BattleWorkFightTypeGet(bw);

	for(i=0;i<2;i++){
		poke_party=BattleWorkPokePartyGet(bw,i);
		for(j=0;j<PokeParty_GetPokeCount(poke_party);j++){
			pp=PokeParty_GetMemberPointer(poke_party,j);
			if(PokeParaGet(pp,ID_PARA_monsno,NULL)){
				if(PokeParaGet(pp,ID_PARA_hp,NULL)){
					if(PokeParaGet(pp,ID_PARA_condition,NULL)){
						csp.status[i][j]=COMSEL_STATUS_NG;
					}
					else{
						csp.status[i][j]=COMSEL_STATUS_ALIVE;
					}
				}
				else{
					csp.status[i][j]=COMSEL_STATUS_DEAD;
				}
			}
			if(i==0){
				if(fight_type&FIGHT_TYPE_NO_EXP){
					csp.motivation[j]=0;
				}
				else{
					csp.motivation[j]=PokeParaNextLevelExpRatioGet(pp);
				}
			}
		}
	}

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&csp,sizeof(csp));
}

//============================================================================================
/**
 *
 *	R}hIʃZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 * @param[in]	data		f[^
 *
 */
//============================================================================================
void	SCIO_CommandSelectReturnSet(BATTLE_WORK *bw,int send_client,int data)
{
	SCIO_Interface(bw,SCIO_SERVER,send_client,&data,4);
}

//============================================================================================
/**
 *
 *	ZIZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 *
 */
//============================================================================================
void	SCIO_WazaSelectSet(BATTLE_WORK *bw,POKEMON_SERVER_PARAM *psp,int send_client,int sel_mons_no)
{
	WAZA_SELECT_PARAM	wsp;
	int					i;

	wsp.command_code=CL_WAZA_SELECT;
	wsp.sel_mons_no=sel_mons_no;
	for(i=0;i<WAZA_TEMOTI_MAX;i++){
		wsp.wazano[i]=psp->waza[i];
		wsp.pp[i]=psp->pp[i];
		wsp.ppmax[i]=WT_PPMaxGet(psp->waza[i],psp->pp_count[i]);
	}

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&wsp,sizeof(WAZA_SELECT_PARAM));
}

//============================================================================================
/**
 *
 *	ZIʃZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 * @param[in]	data		f[^
 *
 */
//============================================================================================
void	SCIO_WazaSelectReturnSet(BATTLE_WORK *bw,int send_client,int data)
{
	SCIO_Interface(bw,SCIO_SERVER,send_client,&data,4);
}

//============================================================================================
/**
 *
 *	UΏۑIZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 *
 */
//============================================================================================
void	SCIO_DirSelectSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int range,int send_client)
{
	DIR_SELECT_PARAM	dsp;
	int					i;
	u32					fight_type;

	fight_type=BattleWorkFightTypeGet(bw);

	dsp.command_code=CL_DIR_SELECT;
	dsp.range=range;

	if(((fight_type&FIGHT_TYPE_2vs2)==0)||
		(fight_type&FIGHT_TYPE_MULTI)||
	   ((fight_type&FIGHT_TYPE_2vs2)&&(send_client>=2))){
		dsp.flag=1;
	}
	else{
		dsp.flag=0;
	}


	for(i=0;i<CLIENT_MAX;i++){
		if(sp->psp[i].hp){
			dsp.dspp[i].exist=1;
			dsp.dspp[i].sex=sp->psp[i].sex;
			dsp.dspp[i].sel_mons_no=sp->sel_mons_no[i];
		}
		else{
			dsp.dspp[i].exist=0;
		}
	}

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&dsp,sizeof(DIR_SELECT_PARAM));
}

//============================================================================================
/**
 *
 *	UΏۑIʃZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 *
 */
//============================================================================================
void	SCIO_DirSelectReturnSet(BATTLE_WORK *bw,int send_client,int data)
{
	SCIO_Interface(bw,SCIO_SERVER,send_client,&data,4);
}

//============================================================================================
/**
 *
 *	IZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 *
 */
//============================================================================================
void	SCIO_ItemSelectSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int send_client)
{
	ITEM_SELECT_PARAM	isp;
	int					i;

	isp.command_code=CL_ITEM_SELECT;
	for(i=0;i<CLIENT_MAX;i++){
		isp.sel_mons_no[i]=sp->sel_mons_no[i];
	}

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&isp,sizeof(ITEM_SELECT_PARAM));
}

//============================================================================================
/**
 *
 *	IʃZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 * @param[in]	data		f[^
 *
 */
//============================================================================================
void	SCIO_ItemSelectReturnSet(BATTLE_WORK *bw,int send_client,ITEM_SELECT_RETURN_PARAM isrp)
{
	SCIO_Interface(bw,SCIO_SERVER,send_client,&isrp,sizeof(ITEM_SELECT_RETURN_PARAM));
}

//============================================================================================
/**
 *
 *	|PIZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 * @param[in]	list_mode	|PXg̃[h
 * @param[in]	chg_waza	ւłȂZio[Ȃǂw
 *
 */
//============================================================================================
void	SCIO_PokemonSelectSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int send_client,int list_mode,int chg_waza)
{
	POKEMON_SELECT_PARAM	psp;
	int						i;

	psp.command_code=CL_POKEMON_SELECT;
	psp.client_no=send_client;
	psp.list_mode=list_mode;
	psp.chg_waza=chg_waza;

	for(i=0;i<CLIENT_MAX;i++){
		psp.sel_mons_no[i]=sp->sel_mons_no[i];
	}

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&psp,sizeof(POKEMON_SELECT_PARAM));
}

//============================================================================================
/**
 *
 *	|PIʃZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 * @param[in]	data		f[^
 *
 */
//============================================================================================
void	SCIO_PokemonSelectReturnSet(BATTLE_WORK *bw,int send_client,int data)
{
	SCIO_Interface(bw,SCIO_SERVER,send_client,&data,4);
}

//============================================================================================
/**
 *
 *	Yes/NoIZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 * @param[in]	msg_id		I郁bZ[WID
 *
 */
//============================================================================================
void	SCIO_YesNoSelectSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int send_client,int msg_id)
{
	YES_NO_SELECT_PARAM	ynsp;

	ynsp.command_code=CL_YES_NO_SELECT;
	ynsp.msg_id=msg_id;

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&ynsp,sizeof(YES_NO_SELECT_PARAM));
}

//============================================================================================
/**
 *
 *	Yes/NoIʃZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 * @param[in]	data		f[^
 *
 */
//============================================================================================
void	SCIO_YesNoSelectReturnSet(BATTLE_WORK *bw,int send_client,int data)
{
	SCIO_Interface(bw,SCIO_SERVER,send_client,&data,4);
}

//============================================================================================
/**
 *
 *	A^bNbZ[WZbg
 *
 * @param[in]	bw	퓬VXe[Ñ|C^
 * @param[in]	sp	T[op[Ñ|C^
 *
 */
//============================================================================================
void	SCIO_AttackMessageSet(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	ATTACK_MESSAGE_PARAM	amp;

	amp.command_code=CL_ATTACK_MESSAGE;
	amp.sel_mons_no=sp->sel_mons_no[sp->attack_client];
	amp.waza_no=sp->waza_no_now;

	SCIO_Interface(bw,SCIO_CLIENT,sp->attack_client,&amp,sizeof(ATTACK_MESSAGE_PARAM));
}

//============================================================================================
/**
 *
 *	bZ[WZbg
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 * @param[in]	sp		T[op[Ñ|C^
 * @param[in]	mp		bZ[Wp[^\
 */
//============================================================================================
void	SCIO_MessageSet(BATTLE_WORK *bw,SERVER_PARAM *sp,MESSAGE_PARAM *mp)
{
	mp->command_code=CL_MESSAGE;
	SCIO_Interface(bw,SCIO_CLIENT,sp->attack_client,mp,sizeof(MESSAGE_PARAM));
}

//============================================================================================
/**
 *
 *	ZGtFNgZbg
 *
 * @param[in]	bw	퓬VXe[Ñ|C^
 * @param[in]	sp	T[op[Ñ|C^
 *
 */
//============================================================================================
void	SCIO_WazaEffectSet(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	SCIO_EffectDataSet(bw,sp,EFFTYPE_WAZA,NULL,sp->attack_client,sp->defence_client);
}

//============================================================================================
/**
 *
 *	|P_[WuNANVZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 *
 */
//============================================================================================
void	SCIO_PokemonBlinkSet(BATTLE_WORK *bw,int send_client)
{
	int	command_code=CL_POKEMON_BLINK;

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&command_code,4);
}

//============================================================================================
/**
 *
 *	HPQ[WvZZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	sp			T[op[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 *
 */
//============================================================================================
void	SCIO_HPGaugeCalcSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int send_client)
{
	HP_GAUGE_CALC_PARAM	hgcp;

	hgcp.command_code=CL_HP_GAUGE_CALC;
	hgcp.level=sp->psp[send_client].level;
	hgcp.hp=sp->psp[send_client].hp;
	hgcp.hpmax=sp->psp[send_client].hpmax;
	hgcp.damage=sp->hp_calc_work;
	hgcp.sex=sp->psp[send_client].sex;
	hgcp.now_exp=sp->psp[send_client].exp-PokeLevelExpGet(sp->psp[send_client].monsno,sp->psp[send_client].level);
	hgcp.max_exp=PokeLevelExpGet(sp->psp[send_client].monsno,sp->psp[send_client].level+1)-
				 PokeLevelExpGet(sp->psp[send_client].monsno,sp->psp[send_client].level);

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&hgcp,sizeof(HP_GAUGE_CALC_PARAM));
}

//============================================================================================
/**
 *
 *	EXPQ[WvZZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	sp			T[op[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 *
 */
//============================================================================================
void	SCIO_EXPGaugeCalcSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int send_client,int now_exp)
{
	EXP_GAUGE_CALC_PARAM	egcp;

	egcp.command_code=CL_EXP_GAUGE_CALC;
	egcp.now_exp=now_exp;
	egcp.next_exp=sp->psp[send_client].exp-PokeLevelExpGet(sp->psp[send_client].monsno,sp->psp[send_client].level);
	egcp.max_exp=PokeLevelExpGet(sp->psp[send_client].monsno,sp->psp[send_client].level+1)-
				 PokeLevelExpGet(sp->psp[send_client].monsno,sp->psp[send_client].level);

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&egcp,sizeof(EXP_GAUGE_CALC_PARAM));
}

//============================================================================================
/**
 *
 *	CGtFNgZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	sp			T[op[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 *
 */
//============================================================================================
void	SCIO_KizetsuEffectSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int send_client)
{
	KIZETSU_EFFECT_PARAM	kep;

	kep.command_code=CL_KIZETSU_EFFECT;
	kep.monsno		=sp->psp[send_client].monsno;
	kep.sex			=sp->psp[send_client].sex;

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&kep,sizeof(KIZETSU_EFFECT_PARAM));
}

//============================================================================================
/**
 *
 *	SER[
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 * @param[in]	sp		T[op[Ñ|C^
 * @param[in]	se_no	炷SENo
 *
 */
//============================================================================================
void	SCIO_SePlaySet(BATTLE_WORK *bw,SERVER_PARAM *sp,int se_no)
{
	SE_PLAY_PARAM	spp;

	spp.command_code=CL_SE_PLAY;
	spp.se_no=se_no;

	SCIO_Interface(bw,SCIO_CLIENT,sp->attack_client,&spp,sizeof(SE_PLAY_PARAM));
}

//============================================================================================
/**
 *
 *	ʃtF[hAEgZbg
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 * @param[in]	sp		T[op[Ñ|C^
 *
 */
//============================================================================================
void	SCIO_FadeOutSet(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	command_code=CL_FADE_OUT;

	SCIO_Interface(bw,SCIO_CLIENT,0,&command_code,4);
}

//============================================================================================
/**
 *
 *	|PojbVtOON/OFF
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	ojbVΏۃNCAg
 * @param[in]	sw			ojbVON/OFFXCb`
 *
 */
//============================================================================================
void	SCIO_PokemonVanishOnOff(BATTLE_WORK *bw,int send_client,int sw)
{
	POKEMON_VANISH_ON_OFF	pvoo;

	pvoo.command_code=CL_POKEMON_VANISH_ON_OFF;
	pvoo.sw=sw;

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&pvoo,sizeof(pvoo));
}

//============================================================================================
/**
 *
 *	HPQ[WɏԈُACRZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	ZbgΏۃNCAg
 * @param[in]	status		ԈُXe[^X
 *
 */
//============================================================================================
void	SCIO_HPGaugeStatusSet(BATTLE_WORK *bw,int send_client,int status)
{
	HP_GAUGE_STATUS_SET_PARAM	hgssp;

	hgssp.command_code=CL_HP_GAUGE_STATUS_SET;
	hgssp.status=status;

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&hgssp,sizeof(hgssp));
}

//============================================================================================
/**
 *
 *	g[i[bZ[W\
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	bZ[W\ΏۃNCAg
 * @param[in]	type		bZ[W^Cv
 *
 */
//============================================================================================
void	SCIO_TrainerMessageSet(BATTLE_WORK *bw,int send_client,int type)
{
	TRAINER_MESSAGE_PARAM	tmp;

	tmp.command_code=CL_TRAINER_MESSAGE;
	tmp.type=type;

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&tmp,sizeof(TRAINER_MESSAGE_PARAM));
}

//============================================================================================
/**
 *
 *	ԈُGtFNgZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	ZbgΏۃNCAg
 * @param[in]	status		Ԉُ̎
 *
 */
//============================================================================================
void	SCIO_StatusEffectSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int send_client,int status)
{
	SCIO_EffectDataSet(bw,sp,EFFTYPE_STATUS,status,send_client,send_client);
}

//============================================================================================
/**
 *
 *	߂bZ[W\
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	ZbgΏۃNCAg
 *
 */
//============================================================================================
void	SCIO_ModosuMessageSet(BATTLE_WORK *bw,int send_client,int sel_mons_no)
{
	MODOSU_MESSAGE_PARAM	mmp;

	mmp.command_code=CL_MODOSU_MESSAGE;
	mmp.sel_mons_no=sel_mons_no;

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&mmp,sizeof(MODOSU_MESSAGE_PARAM));
}

//============================================================================================
/**
 *
 *	ԈُGtFNgZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	ZbgΏۃNCAg
 * @param[in]	status		Ԉُ̎
 *
 */
//============================================================================================
void	SCIO_KuridasuMessageSet(BATTLE_WORK *bw,int send_client,int sel_mons_no)
{
	KURIDASU_MESSAGE_PARAM	kmp;

	kmp.command_code=CL_KURIDASU_MESSAGE;
	kmp.sel_mons_no=sel_mons_no;

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&kmp,sizeof(KURIDASU_MESSAGE_PARAM));
}

//============================================================================================
/**
 *
 *	A[gbZ[W\
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	ZbgΏۃNCAg
 * @param[in]	msg_id		A[gbZ[WID
 *
 */
//============================================================================================
void	SCIO_AlertMessageSet(BATTLE_WORK *bw,int send_client,MESSAGE_PARAM mp)
{
	ALERT_MESSAGE_PARAM	amp;

	amp.command_code=CL_ALERT_MESSAGE;
	amp.mp=mp;

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&amp,sizeof(ALERT_MESSAGE_PARAM));
}

//============================================================================================
/**
 *
 *	A[gbZ[W\IZbg
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	ZbgΏۃNCAg
 *
 */
//============================================================================================
void	SCIO_AlertMessageEndSet(BATTLE_WORK *bw,int send_client)
{
	int	command;

	command=1;
	SCIO_Interface(bw,SCIO_SERVER,send_client,&command,4);
}

//============================================================================================
/**
 *
 *	HPQ[Wĕ`
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	f[^𑗂NCAg
 *
 */
//============================================================================================
void	SCIO_HPGaugeRefreshSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int send_client)
{
	HP_GAUGE_REFRESH_PARAM	hgrp;

	hgrp.command_code=CL_HP_GAUGE_REFRESH;
	hgrp.level=sp->psp[send_client].level;
	hgrp.hp=sp->psp[send_client].hp;
	hgrp.hpmax=sp->psp[send_client].hpmax;
	hgrp.sel_mons_no=sp->sel_mons_no[send_client];
	hgrp.status=ST_ServerConditionNoGet(sp,send_client);
	hgrp.sex=sp->psp[send_client].sex;
	hgrp.now_exp=sp->psp[send_client].exp-PokeLevelExpGet(sp->psp[send_client].monsno,sp->psp[send_client].level);
	hgrp.max_exp=PokeLevelExpGet(sp->psp[send_client].monsno,sp->psp[send_client].level+1)-
				 PokeLevelExpGet(sp->psp[send_client].monsno,sp->psp[send_client].level);
	hgrp.get_mark=FT_ZukanFlagCheckGet(bw,sp->psp[send_client].monsno);

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&hgrp,sizeof(HP_GAUGE_REFRESH_PARAM));
}

//============================================================================================
/**
 *
 *	Kvȃf[^Rs[
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	ZbgΏۃNCAg
 * @param[in]	sel_mons_no	ZbgΏۃ|Pʒu
 *
 */
//============================================================================================
void	SCIO_PSPtoPPCopy(BATTLE_WORK *bw,SERVER_PARAM *sp,int send_client)
{
	PSP_TO_PP_COPY_PARAM	ptpcp;
	int						i;

	ptpcp.command_code=CL_PSP_TO_PSP_COPY;
	ptpcp.sel_mons_no=sp->sel_mons_no[send_client];
	ptpcp.monomane_bit=sp->psp[send_client].wkw.monomane_bit;
	ptpcp.hp=sp->psp[send_client].hp;
	ptpcp.item=sp->psp[send_client].item;
	ptpcp.hatakiotosu=sp->scw[BattleWorkMineEnemyCheck(bw,send_client)].hatakiotosu_item;
	for(i=0;i<WAZA_TEMOTI_MAX;i++){
		ptpcp.waza[i]=sp->psp[send_client].waza[i];
		ptpcp.pp[i]=sp->psp[send_client].pp[i];
	}
	ptpcp.condition=sp->psp[send_client].condition;

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&ptpcp,sizeof(PSP_TO_PP_COPY_PARAM));
}

//============================================================================================
/**
 *
 *	^b`plɃg[i[BGSlideIn
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	L[NȂΏۃNCAg
 * @param[in]	index		L[NȂΏۖ߃R[h
 *
 */
//============================================================================================
void	SCIO_TrainerBGSlideInSet(BATTLE_WORK *bw,int send_client)
{
	int	command_code=CL_TRAINER_BG_SLIDEIN;

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&command_code,4);
}

//============================================================================================
/**
 *
 *	HPQ[W̃Aj[V~߂
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	L[NȂΏۃNCAg
 * @param[in]	index		L[NȂΏۖ߃R[h
 *
 */
//============================================================================================
void	SCIO_GaugeAnimeStop(BATTLE_WORK *bw,int send_client)
{
	int	command_code=CL_GAUGE_ANIME_STOP;

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&command_code,4);
}

//============================================================================================
/**
 *
 *	|P̏Ԉُ𒼂i₵̂Ȃǁj
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	ΏۃNCAg
 * @param[in]	index		Ώۂ̋Zio[
 *
 */
//============================================================================================
void	SCIO_PokemonRefreshSet(BATTLE_WORK *bw,int send_client,int waza_no)
{
	POKEMON_REFRESH_PARAM	prs;

	prs.command_code=CL_POKEMON_REFRESH;
	prs.waza_no=waza_no;

	SCIO_Interface(bw,SCIO_CLIENT,send_client,&prs,sizeof(POKEMON_REFRESH_PARAM));
}

//============================================================================================
/**
 *
 *	T[oL[NA
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	send_client	L[NȂΏۃNCAg
 * @param[in]	index		L[NȂΏۖ߃R[h
 *
 */
//============================================================================================
void	SCIO_ServerQueClear(BATTLE_WORK *bw,int send_client,int index)
{
	SCIO_Interface(bw,SCIO_SERVER_QUE,send_client,&index,4);
}

//============================================================================================
/**
 *
 *	ʐMŎMf[^eobt@ɃRs[
 *
 * @param[in]	bw			퓬VXe[Ñ|C^
 * @param[in]	size		f[^TCY
 * @param[in]	data		Mf[^
 *
 */
//============================================================================================
void	SCIO_CommRecvData(BATTLE_WORK *bw,void *data)
{
	u8	*src=(u8 *)data;
	u8	access;
	u8	para;
	int	size;
	int	i;

	access=src[SIO_BUF_ACCESS];
	para=src[SIO_BUF_PARA];
	size=src[SIO_BUF_SIZE_LOW]|(src[SIO_BUF_SIZE_HIGH]<<8);

	src+=sizeof(SIO_SEND_DATA);

	if(access==SCIO_SERVER){
		for(i=0;i<size;i++){
			bw->server_param->server_buffer[para][i]=src[i];
		}
	}
	else if(access==SCIO_CLIENT){
		for(i=0;i<size;i++){
			bw->client_param[para]->client_buffer[i]=src[i];
		}
	}
	else if(access==SCIO_SERVER_QUE){
		OS_Printf("SCIO_SERVER_QUE: data->%08x para->%d src->%d\n",data,para,src[0]);
		ST_ServerQueReset(bw->server_param,para,src[0]);
	}
	else{
		OS_Printf("SCIO_CommRecvData:ɂ̂́A\n");
	}
}

//============================================================================================
/**
 *
 *	GtFNgf[^ZbgiZGtFNgXe[^XGtFNgj
 *
 * @param[in]	bw		퓬VXe[Ñ|C^
 * @param[in]	sp		T[op[Ñ|C^
 * @param[in]	flag	GtFNg̃^Cv
 * @param[in]	data	GtFNgpf[^
 *
 */
//============================================================================================
static	void	SCIO_EffectDataSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int flag,int data,int attack,int defence)
{
	WAZA_EFFECT_PARAM	wep;
	int					i;

	wep.command_code=CL_WAZA_EFFECT;
	wep.waza_no=sp->waza_no_now;
	wep.waza_eff_damage=sp->damage;	///< ZŎ󂯂_[W(񕜂̎[ - ])
//	wep.waza_eff_power;								///< oĂZ̈З
//	wep.waza_eff_natuki;							///< Ȃx
//	wep.waza_eff_weather;							///< V
//	wep.waza_eff_cnt;								///< ZGtFNg̃JE^(ԂƂ)
//	wep.waza_eff_no;								///< ݏoĂZGtFNgԍ
	wep.at_client_no=attack;						///< ŨNCAgԍ
	wep.df_client_no=defence;						///< h䑤̃NCAgԍ
//	wep.mode;										///< 퓬EReXgERN[
	wep.csp=bw->csp;								///< CLACTVXe[N
	wep.flag=flag;
	wep.data=data;

	for(i=0;i<CLIENT_MAX;i++){
		wep.mons_no[i]=sp->psp[i].monsno;
	}

	SCIO_Interface(bw,SCIO_CLIENT,attack,&wep,sizeof(WAZA_EFFECT_PARAM));
}

