
//============================================================================================
/**
 * @file	server_tool.c
 * @bfief	퓬T[opc[vO
 * @author	HisashiSogabe
 * @date	05.05.26
 */
//============================================================================================

#include "common.h"

#include "battle/battle_server.h"
#include "battle/fight_tool.h"
#include "battle/server.h"
#include "battle/server_tool.h"
#include "battle/client_tool.h"
#include "battle/tokusyu_def.h"
#include "battle/wazano_def.h"
#include "battle/attr_def.h"

#include "msgdata/msg_fightmsg_dp.h"

#include "poketool/poke_tool.h"
#include "poketool/tr_tool.h"
#include "poketool/waza_tool.h"
#include "poketool/monsno.h"

#include "application/app_tool.h"

#include "itemtool/item.h"

#include "system/arc_tool.h"
#include "system/snd_tool.h"

#include "gflib/strbuf_family.h"

#include "server_def.h"


//============================================================================================
//	vg^Cv錾
//============================================================================================

void	ST_PokemonParamGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int sel_mons_no);
void	ST_ServerSequenceLoad(SERVER_PARAM *sp,int kind,int index);
void	ST_ServerSequenceLoadGosub(SERVER_PARAM *sp,int	kind,int index);
BOOL	ST_ServerSequencePushCheck(SERVER_PARAM *sp);
void	ST_ServerQueSet(SERVER_PARAM *sp,int client_no,int index);
void	ST_ServerQueReset(SERVER_PARAM *sp,int client_no,int index);
BOOL	ST_ServerQueCheck(SERVER_PARAM *sp);
void	ST_ServerBufferClear(SERVER_PARAM *sp,int client_no);
int		ST_ServerPokemonServerParamGet(SERVER_PARAM *sp,int client,int id,void *data);
void	ST_ServerPokemonServerParamPut(SERVER_PARAM *sp,int client,int id,const void *buf);
void	ST_ServerPokemonServerParamAdd(SERVER_PARAM *sp,int client,int id,int value);
void	ST_PokemonServerParamAdd(POKEMON_SERVER_PARAM *psp,int id,int value);
u8		ST_ServerAgiCalc(BATTLE_WORK *bw,SERVER_PARAM *sp,int cl1,int cl2,int flag);
void	ST_ServerGetExpRightFlagClear(SERVER_PARAM *sp,int client_no);
void	ST_ServerGetExpRightFlagSet(SERVER_PARAM *sp,int client_no);
void	ST_ServerGetExpRightFlagReset(SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerAddStatusDirectCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int *seq_no);
BOOL	ST_ServerAddStatusCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int *seq_no);
BOOL	ST_FightShinkaCheck(BATTLE_WORK *bw,BATTLE_PARAM *bp,SERVER_PARAM *sp);
int		ST_ServerDefenceClientSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int attack,u16 waza_no,int flag,int set_range);
void	ST_PSPtoPPCopy(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
void	ST_ServerKeepOff(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
int		ST_ServerConditionNoGet(SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerTrainerMessageCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);
void	ST_ServerWorkInit(SERVER_PARAM *sp);
void	ST_ServerCounterWorkInit(BATTLE_WORK *bw,SERVER_PARAM *sp);
void	ST_ServerReshuffleWorkInit(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
void	ST_ServerKizetsuWorkInit(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
void	ST_ServerOneTurnFlagInit(SERVER_PARAM *sp);
int		ST_ServerWaruagakiCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int waza_bit,int check_bit);
BOOL	ST_ServerWazaNGCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int pos,MESSAGE_PARAM *mp);
int		ST_ServerWazaPosGet(POKEMON_SERVER_PARAM *psp,u16 waza_no);
void	ST_ServerTypeCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int waza_no,int attack_client,int defence_client,u32 *flag);
BOOL	ST_ServerWazaOutCheck(SERVER_PARAM *sp,int client_no);
u8		ST_ServerHitCountCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int flag,int client_no);
int		ST_ServerTagNickParaMake(SERVER_PARAM *sp,int client_no);
void	ST_ServerTypeDamageCalc(SERVER_PARAM *sp);
u16		ST_ServerSelectWazaGet(SERVER_PARAM *sp,int client_no);
int		ST_ServerTokuseiCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int flag,int client_no,int speabi);
BOOL	ST_TameWazaCheck(SERVER_PARAM *sp,int waza_no);
BOOL	ST_ServerTypeCheckTableParaGet(int pos,u8 *type_w,u8 *type_p,u8 *value);
BOOL	ST_RendouWazaCheck(u16 waza_no);
BOOL	ST_ServerWazaNoroiCheck(SERVER_PARAM *sp,u16 waza_no,int client_no);
BOOL	ST_ServerDorobouItemCheck(SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerTrickItemCheck(SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerHukitobasiCheck(SERVER_PARAM *sp);
u8		ST_ServerTokuseiGet(SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerKatayaburiTokuseiCheck(SERVER_PARAM *sp,int attack,int defence,int tokusei);
BOOL	ST_ServerReshuffleCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
BOOL	ST_EscapeNGCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,MESSAGE_PARAM *mp);
BOOL	ST_ServerNamakeCheck(SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerSawaguCheck(SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerHuuinCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int waza_no);
BOOL	ST_ServerWazaKoukaCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int waza_kouka);
void	ST_ServerLoopInit(BATTLE_WORK *bw,SERVER_PARAM *sp);
void	ST_ServerPSPAgiCalc(BATTLE_WORK *bw,SERVER_PARAM *sp);
BOOL	ST_ServerJuuryokuCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int waza_no);
BOOL	ST_ServerHealblockCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int waza_no);
void	ST_ServerTotteokiCountCalc(BATTLE_WORK *bw,SERVER_PARAM *sp);
int		ST_ServerWazaCountGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
int		ST_ServerDamageTokuseiCheck(SERVER_PARAM *sp,int attack,int defence);
BOOL	ST_ServerPCCTokuseiCheck(SERVER_PARAM *sp,int client_no);
int		ST_ServerDamageDiv(int data,int value);
int		ST_ServerPokeAppearCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);
int		ST_ServerDirClientGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerWazaHitTokuseiCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);
BOOL	ST_ServerTokuseiStatusRecoverCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerSinkuroCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int server_seq_no);
BOOL	ST_ServerSoubiItemCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerSoubiItemConditionBadCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerSoubiItemDamageCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
u16		ST_ServerSoubiItemNoGet(SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerWazaEndCheck(SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerWazaHitSoubiItemCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);
u8		ST_ServerSoubiEqpGet(SERVER_PARAM *sp,int client_no);
u8		ST_ServerSoubiAtkGet(SERVER_PARAM *sp,int client_no);
u8		ST_ServerShizennomegumiAtkGet(SERVER_PARAM *sp,int client_no);
u8		ST_ServerShizennomegumiTypeGet(SERVER_PARAM *sp,int client_no);
u8		ST_ServerTsuibamuEqpGet(SERVER_PARAM *sp,int client_no);
u8		ST_ServerNagetsukeruEqpGet(SERVER_PARAM *sp,int client_no);
u8		ST_ServerNagetsukeruAtkGet(SERVER_PARAM *sp,int client_no);
int		ST_ServerPokemonSelectCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerTsuibamuCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerNagetsukeruCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
void	ST_ServerMetronomeCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);
int		ST_ServerPokeVoiceEffNoGet(SERVER_PARAM *sp,int client_no);

//p[^Qbgn
int		ST_ServerParamDataGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int id,int client_no);

//p[^Zbgn
void	ST_ServerOSTFStatusFlagSet(SERVER_PARAM *sp,int client_no,u32 value);
void	ST_ServerParamDataPut(BATTLE_WORK *bw,SERVER_PARAM *sp,int id,int client_no,int data);

//OJȂn
static	BOOL	ST_KoukanaiCheck(SERVER_PARAM *sp,int attack_client,int defence_client,int pos);
static	int		ST_ServerAddStatusParamSet(SERVER_PARAM *sp,int type,u32 flag);
static	void	ST_TypeCheckCalc(SERVER_PARAM *sp,int attack,int power,int damage,u32 *flag);
static	BOOL	ST_TameWazaTurnCheck(SERVER_PARAM *sp,int waza_no);

//============================================================================================
/**
 *	PokemonParamPokemonServerParamɓǂݍ
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	ǂݍclient_no
 * @param[in]	sel_mons_no	ǂݍPokemonParam̐擪̈ʒu
 */
//============================================================================================
void	ST_PokemonParamGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int sel_mons_no)
{
	POKEMON_PARAM	*pp=BattleWorkPokemonParamGet(bw,client_no,sel_mons_no);
	int				i;
	int				dir;

	sp->psp[client_no].monsno=			PokeParaGet(pp,ID_PARA_monsno,			0);
	sp->psp[client_no].pow=				PokeParaGet(pp,ID_PARA_pow,				0);
	sp->psp[client_no].def=				PokeParaGet(pp,ID_PARA_def,				0);
	sp->psp[client_no].agi=				PokeParaGet(pp,ID_PARA_agi,				0);
	sp->psp[client_no].spepow=			PokeParaGet(pp,ID_PARA_spepow,			0);
	sp->psp[client_no].spedef=			PokeParaGet(pp,ID_PARA_spedef,			0);

	for(i=0;i<WAZA_TEMOTI_MAX;i++){
		sp->psp[client_no].waza[i]=		PokeParaGet(pp,ID_PARA_waza1+i,			0);
		sp->psp[client_no].pp[i]=		PokeParaGet(pp,ID_PARA_pp1+i,			0);
		sp->psp[client_no].pp_count[i]=	PokeParaGet(pp,ID_PARA_pp_count1+i,		0);
	}

	sp->psp[client_no].hp_rnd=			PokeParaGet(pp,ID_PARA_hp_rnd,			0);
	sp->psp[client_no].pow_rnd=			PokeParaGet(pp,ID_PARA_pow_rnd,			0);
	sp->psp[client_no].def_rnd=			PokeParaGet(pp,ID_PARA_def_rnd,			0);
	sp->psp[client_no].agi_rnd=			PokeParaGet(pp,ID_PARA_agi_rnd,			0);
	sp->psp[client_no].spepow_rnd=		PokeParaGet(pp,ID_PARA_spepow_rnd,		0);
	sp->psp[client_no].spedef_rnd=		PokeParaGet(pp,ID_PARA_spedef_rnd,		0);

	sp->psp[client_no].tamago_flag=		PokeParaGet(pp,ID_PARA_tamago_flag,		0);
	sp->psp[client_no].nickname_flag=	PokeParaGet(pp,ID_PARA_nickname_flag,	0);

	//og^b`ʂ̎́AȂ
	if((sp->server_status_flag&SERVER_STATUS_FLAG_BATON_TOUCH)==0){
		for(i=0;i<COND_MAX;i++){
			sp->psp[client_no].abiritycnt[i]=COND_NUM_DEFAULT;
		}
	}

	sp->psp[client_no].appear_check_flag=0;			//oꎞVn`FbNǂ
	sp->psp[client_no].ikaku_flag=0;				//oꎞ`FbNǂ
	sp->psp[client_no].trace_flag=0;				//oꎞg[X`FbNǂ
	sp->psp[client_no].download_flag=0;				//oꎞ_E[h`FbN
	sp->psp[client_no].kikenyochi_flag=0;			//oꎞ悿`FbN
	sp->psp[client_no].yochimu_flag=0;				//oꎞ悿ރ`FbN
	sp->psp[client_no].slow_start_flag=0;			//oꎞX[X^[g`FbN
	sp->psp[client_no].slow_start_end_flag=0;		//X[X^[gI`FbN

	sp->psp[client_no].type1=			PokePersonalParaGet(sp->psp[client_no].monsno,ID_PER_type1);
	sp->psp[client_no].type2=			PokePersonalParaGet(sp->psp[client_no].monsno,ID_PER_type2);

	sp->psp[client_no].sex=				PokeSexGet(pp);
	sp->psp[client_no].rare=			PokeRareGet(pp);

	sp->psp[client_no].speabino=		PokeParaGet(pp,ID_PARA_speabino,		0);

	sp->psp[client_no].level=			PokeParaGet(pp,ID_PARA_level,			0);
	sp->psp[client_no].friend=			PokeParaGet(pp,ID_PARA_friend,			0);


	sp->psp[client_no].hp=				PokeParaGet(pp,ID_PARA_hp,				0);
	sp->psp[client_no].hpmax=			PokeParaGet(pp,ID_PARA_hpmax,			0);

	sp->psp[client_no].exp=				PokeParaGet(pp,ID_PARA_exp,				0);
	sp->psp[client_no].personal_rnd=	PokeParaGet(pp,ID_PARA_personal_rnd,	0);
	sp->psp[client_no].condition=		PokeParaGet(pp,ID_PARA_condition,		0);
	sp->psp[client_no].id_no=			PokeParaGet(pp,ID_PARA_id_no,			0);
	sp->psp[client_no].item=			PokeParaGet(pp,ID_PARA_item,			0);

	PokeParaGet(pp,ID_PARA_nickname,&sp->psp[client_no].nickname[0]);
	PokeParaGet(pp,ID_PARA_oyaname,&sp->psp[client_no].oyaname[0]);

	sp->psp[client_no].hit_count=0;
	sp->psp[client_no].message_flag=0;

	//͂ƂĂ鎞́AACeĂȂƂɂ
	dir=BattleWorkMineEnemyCheck(bw,client_no);
	if(sp->scw[dir].hatakiotosu_item&No2Bit(sp->sel_mons_no[client_no])){
		sp->psp[client_no].item=0;
		sp->psp[client_no].recycle_item=0;
		sp->psp[client_no].wkw.karuwaza_flag=0;
	}
	else{
		sp->psp[client_no].recycle_item=sp->psp[client_no].item;
		if(sp->psp[client_no].item){
			sp->psp[client_no].wkw.karuwaza_flag=1;
		}
	}
}

//============================================================================================
/**
 *	V[PXf[^ǂݍ
 *
 * @param[in]	sp		T[opp[^[N\
 * @param[in]	kind	ǂݍރA[JCut@C̎
 * @param[in]	index	ǂݍރf[^̃CfbNX
 */
//============================================================================================
void	ST_ServerSequenceLoad(SERVER_PARAM *sp,int	kind,int index)
{
	GF_ASSERT(ArchiveDataSizeGet(kind,index)<SKILL_SEQ_MAX*4);
	sp->skill_arc_kind=kind;
	sp->skill_arc_index=index;
	sp->skill_seq_no=0;
	ArchiveDataLoad(&sp->SkillSeqWork,kind,index);
}

//============================================================================================
/**
 *	V[PXf[^ǂݍށiTu[`WvΉj
 *
 * @param[in]	sp		T[opp[^[N\
 * @param[in]	kind	ǂݍރA[JCut@C̎
 * @param[in]	index	ǂݍރf[^̃CfbNX
 */
//============================================================================================
void	ST_ServerSequenceLoadGosub(SERVER_PARAM *sp,int	kind,int index)
{
	GF_ASSERT(ArchiveDataSizeGet(kind,index)<SKILL_SEQ_MAX*4);
	GF_ASSERT(sp->push_count<SKILL_SEQ_STACK);
	sp->push_skill_arc_kind[sp->push_count]	=sp->skill_arc_kind;
	sp->push_skill_arc_index[sp->push_count]=sp->skill_arc_index;
	sp->push_skill_seq_no[sp->push_count]	=sp->skill_seq_no;
	sp->push_count++;
	sp->skill_arc_kind=kind;
	sp->skill_arc_index=index;
	sp->skill_seq_no=0;
	ArchiveDataLoad(&sp->SkillSeqWork,kind,index);
}

//============================================================================================
/**
 *	Tu[`Wv`FbN
 *
 * @param[in]	sp		T[opp[^[N\
 *
 * @retval	TRUE:WvȂ@FALSEFWvÕAhXɂǂāAV[PXs
 */
//============================================================================================
BOOL	ST_ServerSequencePushCheck(SERVER_PARAM *sp)
{
	if(sp->push_count){
		sp->push_count--;
		ST_ServerSequenceLoad(sp,sp->push_skill_arc_kind[sp->push_count],sp->push_skill_arc_index[sp->push_count]);
		sp->skill_seq_no=sp->push_skill_seq_no[sp->push_count];
		return FALSE;
	}
	else{
		return TRUE;
	}
}

//============================================================================================
/**
 *	T[o߃L[Ƀp[^Zbg
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	T[o߂ZbgNCAgio[
 * @param[in]	index		߃R[h̃CfbNX
 */
//============================================================================================
void	ST_ServerQueSet(SERVER_PARAM *sp,int client_no,int index)
{
	int	i;

	for(i=0;i<SERVER_QUE_MAX;i++){
		if(sp->ServerQue[client_no][i]==0){
			sp->ServerQue[client_no][i]=index;
			break;
		}
	}
	//T[oL[ӂĂ͂܂̂ŁAASSERTo
	SDK_ASSERTMSG(i!=SERVER_QUE_MAX,"ServerQueSet:ServerQue Overflow!\n");
}

//============================================================================================
/**
 *	T[o߃L[̃Zbg
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	ZbgNCAgio[
 * @param[in]	index		Zbg閽߃R[h̃CfbNX
 */
//============================================================================================
void	ST_ServerQueReset(SERVER_PARAM *sp,int client_no,int index)
{
	int	i;

	//indexO͂肦Ȃ̂ŁAASSERTo
	SDK_ASSERTMSG(index!=0,"ServerQueSet:index == 0\n");

	for(i=0;i<SERVER_QUE_MAX;i++){
		if(sp->ServerQue[client_no][i]==index){
			sp->ServerQue[client_no][i]=0;
			break;
		}
	}
	//T[oL[ɑΏۂȂԂł̊֐Ă΂̂͂܂̂ŁAASSERTo
	SDK_ASSERTMSG(i!=SERVER_QUE_MAX,"ServerQueSet:ServerQue NotFound code=%d!\n",index);
}

//============================================================================================
/**
 *	T[o߃L[󂩃`FbN
 *
 * @param[in]	sp			T[opp[^[N\
 *
 * @retval	TRUE:@FALSE:ł͂Ȃ
 */
//============================================================================================
BOOL	ST_ServerQueCheck(SERVER_PARAM *sp)
{
	int	i,j;
	int	data=0;

	for(i=0;i<CLIENT_MAX;i++){
		for(j=0;j<SERVER_QUE_MAX;j++){
			data+=sp->ServerQue[i][j];
		}
	}
	return (data==0);
}

//============================================================================================
/**
 *	server_bufferNA
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	NAobt@client_no
 */
//============================================================================================
void	ST_ServerBufferClear(SERVER_PARAM *sp,int client_no)
{
	int	i;

	for(i=0;i<BUF_SIZE;i++){
		sp->server_buffer[client_no][i]=0;
	}
}

//============================================================================================
/**
 *	POKEMON_SERVER_PARAMl擾
 *
 * @param[in]	sp		T[op[^[N\
 * @param[in]	client	擾ClientNo
 * @param[in]	id		擾l̃CfbNX
 * @param[in]	data	擾li[|C^iintł͑ȂȂǁj
 */
//============================================================================================
int		ST_ServerPokemonServerParamGet(SERVER_PARAM *sp,int client,int id,void *data)
{
	POKEMON_SERVER_PARAM *psp;

	psp=&sp->psp[client];

	switch(id){
	case ID_PSP_monsno:
		return psp->monsno;
		break;
	case ID_PSP_pow:
		return psp->pow;
		break;
	case ID_PSP_def:
		return psp->def;
		break;
	case ID_PSP_agi:
		return psp->agi;
		break;
	case ID_PSP_spepow:
		return psp->spepow;
		break;
	case ID_PSP_spedef:
		return psp->spedef;
		break;
	case ID_PSP_waza1:
	case ID_PSP_waza2:
	case ID_PSP_waza3:
	case ID_PSP_waza4:
		return psp->waza[id-ID_PSP_waza1];
		break;
	case ID_PSP_hp_rnd:
		return psp->hp_rnd;
		break;
	case ID_PSP_pow_rnd:
		return psp->pow_rnd;
		break;
	case ID_PSP_def_rnd:
		return psp->def_rnd;
		break;
	case ID_PSP_agi_rnd:
		return psp->agi_rnd;
		break;
	case ID_PSP_spepow_rnd:
		return psp->spepow_rnd;
		break;
	case ID_PSP_spedef_rnd:
		return psp->spedef_rnd;
		break;
	case ID_PSP_tamago_flag:
		return psp->tamago_flag;
		break;
	case ID_PSP_nickname_flag:
		return psp->nickname_flag;
		break;
	case ID_PSP_abiritycnt_hp:
	case ID_PSP_abiritycnt_pow:
	case ID_PSP_abiritycnt_def:
	case ID_PSP_abiritycnt_agi:
	case ID_PSP_abiritycnt_spepow:
	case ID_PSP_abiritycnt_spedef:
	case ID_PSP_abiritycnt_hit:
	case ID_PSP_abiritycnt_avoid:
		return psp->abiritycnt[id-ID_PSP_abiritycnt_hp];
		break;
	case ID_PSP_speabino:
		return psp->speabino;
		break;
	case ID_PSP_type1:
		return psp->type1;
		break;
	case ID_PSP_type2:
		return psp->type2;
		break;
	case ID_PSP_sex:
		return psp->sex;
		break;
	case ID_PSP_rare:
		return psp->rare;
		break;
	case ID_PSP_pp1:
	case ID_PSP_pp2:
	case ID_PSP_pp3:
	case ID_PSP_pp4:
		return psp->pp[id-ID_PSP_pp1];
		break;
	case ID_PSP_pp_count1:
	case ID_PSP_pp_count2:
	case ID_PSP_pp_count3:
	case ID_PSP_pp_count4:
		return psp->pp_count[id-ID_PSP_pp_count1];
		break;
	case ID_PSP_pp_max1:
	case ID_PSP_pp_max2:
	case ID_PSP_pp_max3:
	case ID_PSP_pp_max4:
		return WT_PPMaxGet(psp->waza[id-ID_PSP_pp_max1],psp->pp_count[id-ID_PSP_pp_max1]);
		break;
	case ID_PSP_level:
		return psp->level;
		break;
	case ID_PSP_friend:
		return psp->friend;
		break;
	case ID_PSP_nickname:
		{
			int	i;
			u16	*buf=data;

			for(i=0;i<MONS_NAME_SIZE+EOM_SIZE;i++){
				buf[i]=psp->nickname[i];
			}
		}
		break;
	case ID_PSP_nickname_buf:
		STRBUF_SetStringCode((STRBUF*)data, psp->nickname);
		break;
	case ID_PSP_hp:
		return psp->hp;
		break;
	case ID_PSP_hpmax:
		return psp->hpmax;
		break;
	case ID_PSP_oyaname:
		{
			int	i;
			u16	*buf=data;

			for(i=0;i<MONS_NAME_SIZE+EOM_SIZE;i++){
				buf[i]=psp->oyaname[i];
			}
		}
		break;
	case ID_PSP_exp:
		return psp->exp;
		break;
	case ID_PSP_personal_rnd:
		return psp->personal_rnd;
		break;
	case ID_PSP_condition:
		return psp->condition;
		break;
	case ID_PSP_condition2:
		return psp->condition2;
		break;
	case ID_PSP_id_no:
		return psp->id_no;
		break;
	case ID_PSP_item:
		return psp->item;
		break;
	case ID_PSP_recycle_item:
		return psp->recycle_item;
		break;
	case ID_PSP_hit_count:
		return psp->hit_count;
		break;
	case ID_PSP_message_flag:
		return psp->message_flag;
		break;
	case ID_PSP_waza_kouka:
		return psp->waza_kouka;
		break;
	case ID_PSP_wkw_kanashibari_count:
		return psp->wkw.kanashibari_count;
		break;
	case ID_PSP_wkw_encore_count:
		return psp->wkw.encore_count;
		break;
	case ID_PSP_wkw_juuden_count:
		return psp->wkw.juuden_count;
		break;
	case ID_PSP_wkw_chouhatsu_count:
		return psp->wkw.chouhatsu_count;
		break;
	case ID_PSP_wkw_success_count:
		return psp->wkw.success_count;
		break;
	case ID_PSP_wkw_horobinouta_count:
		return psp->wkw.horobinouta_count;
		break;
	case ID_PSP_wkw_korogaru_count:
		return psp->wkw.korogaru_count;
		break;
	case ID_PSP_wkw_renzokugiri_count:
		return psp->wkw.renzokugiri_count;
		break;
	case ID_PSP_wkw_takuwaeru_count:
		return psp->wkw.takuwaeru_count;
		break;
	case ID_PSP_wkw_takuwaeru_def_count:
		return psp->wkw.takuwaeru_def_count;
		break;
	case ID_PSP_wkw_takuwaeru_spedef_count:
		return psp->wkw.takuwaeru_spedef_count;
		break;
	case ID_PSP_wkw_namake_bit:
		return psp->wkw.namake_bit;
		break;
	case ID_PSP_wkw_moraibi_flag:
		return psp->wkw.moraibi_flag;
		break;
	case ID_PSP_wkw_lockon_client_no:
		return psp->wkw.lockon_client_no;
		break;
	case ID_PSP_wkw_monomane_bit:
		return psp->wkw.monomane_bit;
		break;
	case ID_PSP_wkw_shime_client_no:
		return psp->wkw.shime_client_no;
		break;
	case ID_PSP_wkw_manazashi_client_no:
		return psp->wkw.manazashi_client_no;
		break;
	case ID_PSP_wkw_totteoki_count:
		return psp->wkw.totteoki_count;
		break;
	case ID_PSP_wkw_denzihuyuu_count:
		return psp->wkw.denzihuyuu_count;
		break;
	case ID_PSP_wkw_healblock_count:
		return psp->wkw.healblock_count;
		break;
	case ID_PSP_wkw_shutout_count:
		return psp->wkw.shutout_count;
		break;
	case ID_PSP_wkw_handou_count:
		return psp->wkw.handou_count;
		break;
	case ID_PSP_wkw_nekodamashi_count:
		return psp->wkw.nekodamashi_count;
		break;
	case ID_PSP_wkw_migawari_hp:
		return psp->wkw.migawari_hp;
		break;
	case ID_PSP_wkw_henshin_rnd:
		return psp->wkw.henshin_rnd;
		break;
	case ID_PSP_wkw_kanashibari_wazano:
		return psp->wkw.kanashibari_wazano;
		break;
	case ID_PSP_wkw_encore_wazano:
		return psp->wkw.encore_wazano;
		break;
	case ID_PSP_wkw_shime_wazano:
		return psp->wkw.shime_wazano;
		break;
	case ID_PSP_wkw_item_hp_recover:
		return psp->wkw.item_hp_recover;
		break;
	case ID_PSP_work:
		return ST_ServerPokemonServerParamGet(sp,client,sp->temp_work,data);
		break;
	default:
		GF_ASSERT("݂ȂPSPp[^ł\n");
		break;
	}

	return 0;
}

//============================================================================================
/**
 *	POKEMON_SERVER_PARAMɒli[
 *
 * @param[in]	sp		T[op[^[N\
 * @param[in]	client	i[ClientNo
 * @param[in]	id		i[l̃CfbNX
 * @param[in]	data	i[lւ̃|C^
 */
//============================================================================================
void	ST_ServerPokemonServerParamPut(SERVER_PARAM *sp,int client,int id,const void *buf)
{
	int	i;
	u32	*buf32=(u32 *)buf;
	u16	*buf16=(u16 *)buf;
	s16	*bufs16=(s16 *)buf;
	u8	*buf8=(u8 *)buf;
	s8	*bufs8=(s8 *)buf;
	POKEMON_SERVER_PARAM	*psp=&sp->psp[client];

	switch(id){
	case ID_PSP_monsno:
		psp->monsno=buf16[0];
		break;
	case ID_PSP_pow:
		psp->pow=buf16[0];
		break;
	case ID_PSP_def:
		psp->def=buf16[0];
		break;
	case ID_PSP_agi:
		psp->agi=buf16[0];
		break;
	case ID_PSP_spepow:
		psp->spepow=buf16[0];
		break;
	case ID_PSP_spedef:
		psp->spedef=buf16[0];
		break;
	case ID_PSP_waza1:
	case ID_PSP_waza2:
	case ID_PSP_waza3:
	case ID_PSP_waza4:
		psp->waza[id-ID_PSP_waza1]=buf16[0];
		break;
	case ID_PSP_hp_rnd:
		psp->hp_rnd=buf8[0];
		break;
	case ID_PSP_pow_rnd:
		psp->pow_rnd=buf8[0];
		break;
	case ID_PSP_def_rnd:
		psp->def_rnd=buf8[0];
		break;
	case ID_PSP_agi_rnd:
		psp->agi_rnd=buf8[0];
		break;
	case ID_PSP_spepow_rnd:
		psp->spepow_rnd=buf8[0];
		break;
	case ID_PSP_spedef_rnd:
		psp->spedef_rnd=buf8[0];
		break;
	case ID_PSP_tamago_flag:
		psp->tamago_flag=buf8[0];
		break;
	case ID_PSP_nickname_flag:
		psp->nickname_flag=buf8[0];
		break;
	case ID_PSP_abiritycnt_hp:
	case ID_PSP_abiritycnt_pow:
	case ID_PSP_abiritycnt_def:
	case ID_PSP_abiritycnt_agi:
	case ID_PSP_abiritycnt_spepow:
	case ID_PSP_abiritycnt_spedef:
	case ID_PSP_abiritycnt_hit:
	case ID_PSP_abiritycnt_avoid:
		psp->abiritycnt[id-ID_PSP_abiritycnt_hp]=bufs8[0];
		break;
	case ID_PSP_speabino:
		psp->speabino=buf8[0];
		break;
	case ID_PSP_type1:
		psp->type1=buf8[0];
		break;
	case ID_PSP_type2:
		psp->type2=buf8[0];
		break;
	case ID_PSP_sex:
		psp->sex=buf8[0];
		break;
	case ID_PSP_rare:
		psp->rare=buf8[0];
		break;
	case ID_PSP_pp1:
	case ID_PSP_pp2:
	case ID_PSP_pp3:
	case ID_PSP_pp4:
		psp->pp[id-ID_PSP_pp1]=buf8[0];
		break;
	case ID_PSP_pp_count1:
	case ID_PSP_pp_count2:
	case ID_PSP_pp_count3:
	case ID_PSP_pp_count4:
		psp->pp_count[id-ID_PSP_pp_count1]=buf8[0];
		break;
	case ID_PSP_pp_max1:
	case ID_PSP_pp_max2:
	case ID_PSP_pp_max3:
	case ID_PSP_pp_max4:
		GF_ASSERT("Putł܂\n");
		break;
	case ID_PSP_level:
		psp->level=buf8[0];
		break;
	case ID_PSP_friend:
		psp->friend=buf8[0];
		break;
	case ID_PSP_nickname:
		{
			int	i;
			for(i=0;i<MONS_NAME_SIZE+EOM_SIZE;i++){
				psp->nickname[i]=buf16[i];
			}
		}
		break;
	case ID_PSP_hp:
		psp->hp=bufs16[0];
		break;
	case ID_PSP_hpmax:
		psp->hpmax=buf16[0];
		break;
	case ID_PSP_oyaname:
		{
			int	i;

			for(i=0;i<MONS_NAME_SIZE+EOM_SIZE;i++){
				psp->oyaname[i]=buf16[i];
			}
		}
		break;
	case ID_PSP_exp:
		psp->exp=buf32[0];
		break;
	case ID_PSP_personal_rnd:
		psp->personal_rnd=buf32[0];
		break;
	case ID_PSP_condition:
		psp->condition=buf32[0];
		break;
	case ID_PSP_condition2:
		psp->condition2=buf32[0];
		break;
	case ID_PSP_id_no:
		psp->id_no=buf32[0];
		break;
	case ID_PSP_item:
		psp->item=buf16[0];
		break;
	case ID_PSP_recycle_item:
		psp->recycle_item=buf16[0];
		break;
	case ID_PSP_hit_count:
		psp->hit_count=buf8[0];
		break;
	case ID_PSP_message_flag:
		psp->message_flag=buf8[0];
		break;
	case ID_PSP_waza_kouka:
		psp->waza_kouka=buf32[0];
		break;
	case ID_PSP_wkw_kanashibari_count:
		psp->wkw.kanashibari_count=buf8[0];
		break;
	case ID_PSP_wkw_encore_count:
		psp->wkw.encore_count=buf8[0];
		break;
	case ID_PSP_wkw_juuden_count:
		psp->wkw.juuden_count=buf8[0];
		break;
	case ID_PSP_wkw_chouhatsu_count:
		psp->wkw.chouhatsu_count=buf8[0];
		break;
	case ID_PSP_wkw_success_count:
		psp->wkw.success_count=buf8[0];
		break;
	case ID_PSP_wkw_horobinouta_count:
		psp->wkw.horobinouta_count=buf8[0];
		break;
	case ID_PSP_wkw_korogaru_count:
		psp->wkw.korogaru_count=buf8[0];
		break;
	case ID_PSP_wkw_renzokugiri_count:
		psp->wkw.renzokugiri_count=buf8[0];
		break;
	case ID_PSP_wkw_takuwaeru_count:
		psp->wkw.takuwaeru_count=buf8[0];
		break;
	case ID_PSP_wkw_takuwaeru_def_count:
		psp->wkw.takuwaeru_def_count=buf8[0];
		break;
	case ID_PSP_wkw_takuwaeru_spedef_count:
		psp->wkw.takuwaeru_spedef_count=buf8[0];
		break;
	case ID_PSP_wkw_namake_bit:
		psp->wkw.namake_bit=buf8[0];
		break;
	case ID_PSP_wkw_moraibi_flag:
		psp->wkw.moraibi_flag=buf8[0];
		break;
	case ID_PSP_wkw_lockon_client_no:
		psp->wkw.lockon_client_no=buf8[0];
		break;
	case ID_PSP_wkw_monomane_bit:
		psp->wkw.monomane_bit=buf8[0];
		break;
	case ID_PSP_wkw_shime_client_no:
		psp->wkw.shime_client_no=buf8[0];
		break;
	case ID_PSP_wkw_manazashi_client_no:
		psp->wkw.manazashi_client_no=buf8[0];
		break;
	case ID_PSP_wkw_totteoki_count:
		psp->wkw.totteoki_count=buf8[0];
		break;
	case ID_PSP_wkw_denzihuyuu_count:
		psp->wkw.denzihuyuu_count=buf8[0];
		break;
	case ID_PSP_wkw_healblock_count:
		psp->wkw.healblock_count=buf8[0];
		break;
	case ID_PSP_wkw_shutout_count:
		psp->wkw.shutout_count=buf8[0];
		break;
	case ID_PSP_wkw_handou_count:
		psp->wkw.handou_count=buf32[0];
		break;
	case ID_PSP_wkw_nekodamashi_count:
		psp->wkw.nekodamashi_count=buf32[0];
		break;
	case ID_PSP_wkw_migawari_hp:
		psp->wkw.migawari_hp=buf32[0];
		break;
	case ID_PSP_wkw_henshin_rnd:
		psp->wkw.henshin_rnd=buf32[0];
		break;
	case ID_PSP_wkw_kanashibari_wazano:
		psp->wkw.kanashibari_wazano=buf16[0];
		break;
	case ID_PSP_wkw_encore_wazano:
		psp->wkw.encore_wazano=buf16[0];
		break;
	case ID_PSP_wkw_shime_wazano:
		psp->wkw.shime_wazano=buf16[0];
		break;
	case ID_PSP_wkw_item_hp_recover:
		psp->wkw.item_hp_recover=buf32[0];
		break;
	case ID_PSP_work:
		ST_ServerPokemonServerParamPut(sp,client,sp->temp_work,buf);
		break;
	default:
		GF_ASSERT("݂ȂPSPp[^ł\n");
		break;
	}
}

//============================================================================================
/**
 *	POKEMON_SERVER_PARAMɒlZ
 *
 * @param[in]	sp		T[op[^[N\
 * @param[in]	client	ZClientNo
 * @param[in]	id		Zl̃CfbNX
 * @param[in]	value	Zl
 */
//============================================================================================
void	ST_ServerPokemonServerParamAdd(SERVER_PARAM *sp,int client,int id,int value)
{
	ST_PokemonServerParamAdd(&sp->psp[client],id,value);
}

//============================================================================================
/**
 *	POKEMON_SERVER_PARAMɒlZ
 *
 * @param[in]	psp		T[op|Pp[^[N\
 * @param[in]	id		Zl̃CfbNX
 * @param[in]	value	Zlւ̃|C^
 */
//============================================================================================
void	ST_PokemonServerParamAdd(POKEMON_SERVER_PARAM *psp,int id,int value)
{
	int	i;

	switch(id){
	case ID_PSP_pow:
		psp->pow+=value;
		break;
	case ID_PSP_def:
		psp->def+=value;
		break;
	case ID_PSP_agi:
		psp->agi+=value;
		break;
	case ID_PSP_spepow:
		psp->spepow+=value;
		break;
	case ID_PSP_spedef:
		psp->spedef+=value;
		break;
	case ID_PSP_hp_rnd:
		psp->hp_rnd+=value;
		break;
	case ID_PSP_pow_rnd:
		psp->pow_rnd+=value;
		break;
	case ID_PSP_def_rnd:
		psp->def_rnd+=value;
		break;
	case ID_PSP_agi_rnd:
		psp->agi_rnd+=value;
		break;
	case ID_PSP_spepow_rnd:
		psp->spepow_rnd+=value;
		break;
	case ID_PSP_spedef_rnd:
		psp->spedef_rnd+=value;
		break;
	case ID_PSP_abiritycnt_hp:
	case ID_PSP_abiritycnt_pow:
	case ID_PSP_abiritycnt_def:
	case ID_PSP_abiritycnt_agi:
	case ID_PSP_abiritycnt_spepow:
	case ID_PSP_abiritycnt_spedef:
	case ID_PSP_abiritycnt_hit:
	case ID_PSP_abiritycnt_avoid:
		psp->abiritycnt[id-ID_PSP_abiritycnt_hp]+=value;
		break;
	case ID_PSP_pp1:
	case ID_PSP_pp2:
	case ID_PSP_pp3:
	case ID_PSP_pp4:
		{
			int	ppmax;

			ppmax=WT_PPMaxGet(psp->waza[id-ID_PSP_pp1],psp->pp_count[id-ID_PSP_pp1]);

			if(psp->pp[id-ID_PSP_pp1]+value>ppmax){
				psp->pp[id-ID_PSP_pp1]=ppmax;
			}
			else{
				psp->pp[id-ID_PSP_pp1]+=value;
			}
		}
		break;
	case ID_PSP_pp_count1:
	case ID_PSP_pp_count2:
	case ID_PSP_pp_count3:
	case ID_PSP_pp_count4:
		psp->pp_count[id-ID_PSP_pp_count1]+=value;
		break;
	case ID_PSP_level:
		psp->level+=value;
		break;
	case ID_PSP_friend:
		if((psp->friend+value)>FRIEND_MAX){
			psp->friend=FRIEND_MAX;
		}
		else{
			psp->friend+=value;
		}
		break;
	case ID_PSP_hp:
		if(psp->hp+value>psp->hpmax){
			psp->hp=psp->hpmax;
		}
		else{
			psp->hp+=value;
		}
		break;
	case ID_PSP_hpmax:
		psp->hpmax+=value;
		break;
	case ID_PSP_exp:
		psp->exp+=value;
		break;
	case ID_PSP_personal_rnd:
		psp->personal_rnd+=value;
		break;
	case ID_PSP_wkw_kanashibari_count:
		psp->wkw.kanashibari_count+=value;
		break;
	case ID_PSP_wkw_encore_count:
		psp->wkw.encore_count+=value;
		break;
	case ID_PSP_wkw_juuden_count:
		psp->wkw.juuden_count+=value;
		break;
	case ID_PSP_wkw_chouhatsu_count:
		psp->wkw.chouhatsu_count+=value;
		break;
	case ID_PSP_wkw_success_count:
		psp->wkw.success_count+=value;
		break;
	case ID_PSP_wkw_horobinouta_count:
		psp->wkw.horobinouta_count+=value;
		break;
	case ID_PSP_wkw_korogaru_count:
		psp->wkw.korogaru_count+=value;
		break;
	case ID_PSP_wkw_renzokugiri_count:
		psp->wkw.renzokugiri_count+=value;
		break;
	case ID_PSP_wkw_takuwaeru_count:
		psp->wkw.takuwaeru_count+=value;
		break;
	case ID_PSP_wkw_takuwaeru_def_count:
		psp->wkw.takuwaeru_def_count+=value;
		break;
	case ID_PSP_wkw_takuwaeru_spedef_count:
		psp->wkw.takuwaeru_spedef_count+=value;
		break;
	case ID_PSP_wkw_totteoki_count:
		psp->wkw.totteoki_count+=value;
		break;
	case ID_PSP_wkw_denzihuyuu_count:
		psp->wkw.denzihuyuu_count+=value;
		break;
	case ID_PSP_wkw_healblock_count:
		psp->wkw.healblock_count+=value;
		break;
	case ID_PSP_wkw_handou_count:
		psp->wkw.handou_count+=value;
		break;
	case ID_PSP_wkw_nekodamashi_count:
		psp->wkw.nekodamashi_count+=value;
		break;
	case ID_PSP_wkw_migawari_hp:
		psp->wkw.migawari_hp+=value;
		break;
	case ID_PSP_wkw_item_hp_recover:
		psp->wkw.item_hp_recover+=value;
		break;
	default:
		GF_ASSERT("݂ȂPSPp[^ł\n");
		break;
	}
}

//============================================================================================
/**
 *	f𔼌鑕ʃe[u
 */
//============================================================================================
static	const	u8	ItemEqpAgiHalfTable[]={
	SOUBI_DORYOKUTINIBAI,
	SOUBI_SUBAYASADOWN,
	SOUBI_HPDORYOKUTIUP,
	SOUBI_KOUGEKIDORYOKUTIUP,
	SOUBI_BOUGYODORYOKUTIUP,
	SOUBI_SUBAYASADORYOKUTIUP,
	SOUBI_TOKUKOUDORYOKUTIUP,
	SOUBI_TOKUBOUDORYOKUTIUP,
};

//============================================================================================
/**
 *	|P̑fvZ
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	cl1			`FbNClientNo1
 * @param[in]	cl2			`FbNClientNo2
 * @param[in]	flag		Z̐搧vCIeB̗L(0)^(1)
 *
 * @retval	0:\[g̕KvȂ@1:\[g̕Kv@2:\[g̕Kvif̂ŁA_Ō肳ꂽj
 */
//============================================================================================
u8	ST_ServerAgiCalc(BATTLE_WORK *bw,SERVER_PARAM *sp,int cl1,int cl2,int flag)
{
	u8	ret=0;
	u32	agi1,agi2;
	u16	wazano1=0,wazano2=0;
	u8	eqp1;
	u8	atk1;
	u8	eqp2;
	u8	atk2;
	s8	attackpri1=0;
	s8	attackpri2=0;
	u8	sensei1=0,sensei2=0;
	u8	koukou1=0,koukou2=0;
	int	command1;
	int	command2;
	int	wazapos1;
	int	wazapos2;
	int	speabi1;
	int	speabi2;
	int	i;

	speabi1=ST_ServerTokuseiGet(sp,cl1);
	speabi2=ST_ServerTokuseiGet(sp,cl2);

	eqp1=ST_ServerSoubiEqpGet(sp,cl1);
	atk1=ST_ServerSoubiAtkGet(sp,cl1);
	eqp2=ST_ServerSoubiEqpGet(sp,cl2);
	atk2=ST_ServerSoubiAtkGet(sp,cl2);
	
	agi1=sp->psp[cl1].agi*CondChgTable[sp->psp[cl1].abiritycnt[COND_AGI]][0]/
						  CondChgTable[sp->psp[cl1].abiritycnt[COND_AGI]][1];

	agi2=sp->psp[cl2].agi*CondChgTable[sp->psp[cl2].abiritycnt[COND_AGI]][0]/
						  CondChgTable[sp->psp[cl2].abiritycnt[COND_AGI]][1];

	//\͂̂Ă񂫂̃|P퓬ɏoĂƂ̓`FbNȂ
	if((ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_NOOTENKI)==0)&&
	   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_EAROKKU)==0)){
		//\͂́AĴƂf{
		//\͂悤傭́ÂƂf{
		if(((speabi1==TOKUSYU_SUISUI)&&(sp->field_condition&FIELD_CONDITION_AME_ALL))||
		   ((speabi1==TOKUSYU_YOURYOKUSO)&&(sp->field_condition&FIELD_CONDITION_HARE_ALL))){
			agi1*=2;
		}
		//ʂ݂őfAbv́Af2{
		if((eqp1==SOUBI_MIZUDESUBAYASAUP)&&(sp->field_condition&FIELD_CONDITION_AME_ALL)){
			agi1*=2;
		}
		//\͂́AĴƂf{
		//\͂悤傭́ÂƂf{
		if(((speabi2==TOKUSYU_SUISUI)&&(sp->field_condition&FIELD_CONDITION_AME_ALL))||
		   ((speabi2==TOKUSYU_YOURYOKUSO)&&(sp->field_condition&FIELD_CONDITION_HARE_ALL))){
			agi2*=2;
		}
		//ʂ݂őfAbv́Af2{
		if((eqp2==SOUBI_MIZUDESUBAYASAUP)&&(sp->field_condition&FIELD_CONDITION_AME_ALL)){
			agi2*=2;
		}
	}

	//ACeœw͒lQ{̌ʁA΂₳DOWN𑕔Ƒf1/2ɂ
	for(i=0;i<NELEMS(ItemEqpAgiHalfTable);i++){
		if(eqp1==ItemEqpAgiHalfTable[i]){
			agi1/=2;
			break;
		}
	}

	//ACełn𑕔Ƒf2{ɂ
	if(eqp1==SOUBI_ONAZIWAZAONLYSUBAYASAUP){
		agi1*=2;
	}

	//ACeŃ^Ƒf2{ɂ
	if((eqp1==SOUBI_METAMONSUBAYASAUP)&&(sp->psp[cl1].monsno==MONSNO_METAMON)){
		agi1*=2;
	}

	//ACeŐゾƑf2{ɂ
	if((eqp1==SOUBI_MIZUDESUBAYASAUP)&&(BattleWorkGroundIDGet(bw)==GROUND_ID_WATER)){
		agi1*=2;
	}

	//͂₠́AԈُőf2{ɂ
	if((speabi1==TOKUSYU_HAYAASI)&&(sp->psp[cl1].condition&CONDITION_BAD)){
		agi1*=2;
	}
	else{
		//܂Ђ̎́Af1/4ɂ
		if(sp->psp[cl1].condition&CONDITION_MAHI){
			agi1/=4;
		}
	}

	//X[X^[ǵAɂłĂ5^[ȓ͑f𔼕ɂ
	if((speabi1==TOKUSYU_SUROOSUTAATO)&&
	  ((sp->total_turn-sp->psp[cl1].wkw.nekodamashi_count)<5)){
		agi1/=2;
	}

	//킴́AACeĂ܂Ƒf{ɂȂ
	if((speabi1==TOKUSYU_KARUWAZA)&&
	   (sp->psp[cl1].wkw.karuwaza_flag)&&
	   (sp->psp[cl1].item==0)){
		agi1*=2;
	}

	//Zʂ󂯂Ă鎞́Af2{
	if(sp->side_condition[BattleWorkMineEnemyCheck(bw,cl1)]&SIDE_CONDITION_OIKAZE){
		agi1*=2;
	}

	//ACeŐ搧Ǔʂ𑕔Ɛ搧Uɂ
	if(eqp1==SOUBI_SENSEIKOUGEKI){
		if(sp->agi_rand1<(0xffff*atk1/100)){
			sensei1=1;
		}
	}

	//ACeŌUǓʂ𑕔ƌUUɂ
	if(eqp1==SOUBI_KOUKOUNINARU){
		if(sp->agi_rand1<(0xffff*atk1/100)){
			koukou1=1;
		}
	}

	//ACeœw͒lQ{̌ʁA΂₳DOWN𑕔Ƒf1/2ɂ
	for(i=0;i<NELEMS(ItemEqpAgiHalfTable);i++){
		if(eqp2==ItemEqpAgiHalfTable[i]){
			agi2/=2;
			break;
		}
	}

	//ACełn𑕔Ƒf2{ɂ
	if(eqp2==SOUBI_ONAZIWAZAONLYSUBAYASAUP){
		agi2*=2;
	}

	//ACeŃ^Ƒf2{ɂ
	if((eqp2==SOUBI_METAMONSUBAYASAUP)&&(sp->psp[cl2].monsno==MONSNO_METAMON)){
		agi2*=2;
	}

	//ACeŐゾƑf2{ɂ
	if((eqp2==SOUBI_MIZUDESUBAYASAUP)&&(BattleWorkGroundIDGet(bw)==GROUND_ID_WATER)){
		agi2*=2;
	}

	//͂₠́AԈُőf2{ɂ
	if((speabi2==TOKUSYU_HAYAASI)&&(sp->psp[cl2].condition&CONDITION_BAD)){
		agi2*=2;
	}
	else{
		//܂Ђ̎́Af1/4ɂ
		if(sp->psp[cl2].condition&CONDITION_MAHI){
			agi2/=4;
		}
	}

	//X[X^[ǵAɂłĂ5^[ȓ͑f𔼕ɂ
	if((speabi2==TOKUSYU_SUROOSUTAATO)&&
	  ((sp->total_turn-sp->psp[cl2].wkw.nekodamashi_count)<5)){
		agi2/=2;
	}

	//킴́AACeĂ܂Ƒf{ɂȂ
	if((speabi2==TOKUSYU_KARUWAZA)&&
	   (sp->psp[cl2].wkw.karuwaza_flag)&&
	   (sp->psp[cl2].item==0)){
		agi2*=2;
	}

	//Zʂ󂯂Ă鎞́Af2{
	if(sp->side_condition[BattleWorkMineEnemyCheck(bw,cl2)]&SIDE_CONDITION_OIKAZE){
		agi2*=2;
	}

	//ACeŐ搧Ǔʂ𑕔Ɛ搧Uɂ
	if(eqp2==SOUBI_SENSEIKOUGEKI){
		if(sp->agi_rand2<(0xffff*atk2/100)){
			sensei2=1;
		}
	}
	//ACeŌUǓʂ𑕔ƌUUɂ
	if(eqp2==SOUBI_KOUKOUNINARU){
		if(sp->agi_rand2<(0xffff*atk2/100)){
			koukou2=1;
		}
	}

	//ȑfp[^[NɊi[
	sp->psp_agi_point[cl1]=agi1;
	sp->psp_agi_point[cl2]=agi2;

	if(flag==0){
		command1=sp->client_act_work[cl1][ACT_PARA_SELECT_COMMAND];
		command2=sp->client_act_work[cl2][ACT_PARA_SELECT_COMMAND];
		wazapos1=sp->client_act_work[cl1][ACT_PARA_WORK]-1;
		wazapos2=sp->client_act_work[cl2][ACT_PARA_WORK]-1;
		if(command1==SELECT_FIGHT_COMMAND){
			if(sp->otf[cl1].waruagaki_flag){
				wazano1=WAZANO_WARUAGAKI;
			}
			else{
				wazano1=ST_ServerPokemonServerParamGet(sp,cl1,ID_PSP_waza1+wazapos1,NULL);
			}
		}
		if(command2==SELECT_FIGHT_COMMAND){
			if(sp->otf[cl2].waruagaki_flag){
				wazano2=WAZANO_WARUAGAKI;
			}
			else{
				wazano2=ST_ServerPokemonServerParamGet(sp,cl2,ID_PSP_waza1+wazapos2,NULL);
			}
		}
		attackpri1=WT_WazaDataParaGet(wazano1,ID_WTD_attackpri);
		attackpri2=WT_WazaDataParaGet(wazano2,ID_WTD_attackpri);
	}

	if(attackpri1==attackpri2){
		//搧vCIeBꏏ̎́A񂹂̃cÂہAƂAgbN[̏Ō
		if((sensei1)&&(sensei2)){
			if(agi1<agi2){
				ret=1;
			}
			else if((agi1==agi2)&&(gf_rand()&1)){
				ret=2;
			}
		}
		else if((sensei1==0)&&(sensei2)){
			ret=1;
		}
		else if((sensei1)&&(sensei2==0)){
			ret=0;
		}
		else if((koukou1)&&(koukou2)){
			if(agi1>agi2){
				ret=1;
			}
			else if((agi1==agi2)&&(gf_rand()&1)){
				ret=2;
			}
		}
		else if((koukou1)&&(koukou2==0)){
			ret=1;
		}
		else if((koukou1==0)&&(koukou2)){
			ret=0;
		}
		else if((speabi1==TOKUSYU_ATODASI)&&(speabi2==TOKUSYU_ATODASI)){
			if(agi1>agi2){
				ret=1;
			}
			else if((agi1==agi2)&&(gf_rand()&1)){
				ret=2;
			}
		}
		else if((speabi1==TOKUSYU_ATODASI)&&(speabi2!=TOKUSYU_ATODASI)){
			ret=1;
		}
		else if((speabi1!=TOKUSYU_ATODASI)&&(speabi2==TOKUSYU_ATODASI)){
			ret=0;
		}
		else if(sp->field_condition&FIELD_CONDITION_TRICKROOM){
			if(agi1>agi2){
				ret=1;
			}
		}
		else{
			if(agi1<agi2){
				ret=1;
			}
			if((agi1==agi2)&&(gf_rand()&1)){
				ret=2;
			}
		}
	}
	else if(attackpri1<attackpri2){
		ret=1;
	}

	return	ret;
}

//============================================================================================
/**
 *	ollł錠tÕNA
 *
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	client_no	NANCAgio[
 */
//============================================================================================
void	ST_ServerGetExpRightFlagClear(SERVER_PARAM *sp,int client_no)
{
	sp->get_exp_right_flag[(client_no>>1)&1]=0;
}

//============================================================================================
/**
 *	ollł錠tÕZbg
 *
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	client_no	ZbgNCAgio[
 */
//============================================================================================
void	ST_ServerGetExpRightFlagSet(SERVER_PARAM *sp,int client_no)
{
	int	no;

	no=CLIENT_NO_MINE;

	while(no<=CLIENT_NO_MINE2){
		if( ((sp->no_reshuffle_client&No2Bit(no))==0) && ((sp->no_reshuffle_client&No2Bit(client_no))==0) ){
			sp->get_exp_right_flag[(client_no>>1)&1]|=No2Bit(sp->sel_mons_no[no]);
		}
		no+=2;
	}
}

//============================================================================================
/**
 *	ollł錠tÕZbg
 *
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	client_no	ZbgNCAgio[
 */
//============================================================================================
void	ST_ServerGetExpRightFlagReset(SERVER_PARAM *sp,int client_no)
{
	int	no;

	no=CLIENT_NO_MINE;

	while(no<=CLIENT_NO_MINE2){
		if( ((sp->no_reshuffle_client&No2Bit(no))==0) && ((sp->no_reshuffle_client&No2Bit(client_no))==0) ){
			sp->get_exp_right_flag[(client_no>>1)&1]&=(No2Bit(sp->sel_mons_no[no])^0xffffffff);
		}
		no+=2;
	}
}

//============================================================================================
/**
 *	ǉʂ̃`FbNiڒǉ̂݁j
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[out]	seq_no		ǉʂ邽߂̃TuV[PXio[
 */
//============================================================================================
BOOL	ST_ServerAddStatusDirectCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int *seq_no)
{
	BOOL	ret=FALSE;

	if(sp->add_status_flag_direct){
		seq_no[0]=ST_ServerAddStatusParamSet(sp,ADD_STATUS_DIRECT,sp->add_status_flag_direct);
		//C₵Ă鑊ɂ͎s
		if((sp->psp[sp->tsuika_client].hp)&&
		//Zʂ̒ǉł͂𖳎w肪Ȃ́A͂Ŏsɂ
		  (((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)||
		   ((sp->add_status_flag_direct&ADD_STATUS_WAZAKOUKA_NOHIT)&&
		    (sp->waza_status_flag&WAZA_STATUS_FLAG_HAZURE)))){
			ret=TRUE;
		}
		sp->add_status_flag_direct=0;
	}

	return ret;
}

//============================================================================================
/**
 *	ǉʂ̃`FbNiڒǉȊOj
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[out]	seq_no		ǉʂ邽߂̃TuV[PXio[
 */
//============================================================================================
BOOL	ST_ServerAddStatusCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int *seq_no)
{
	BOOL	ret=FALSE;
	u16		kakuritsu;

	//Zʂ̒ǉ́A100%N
	if(sp->add_status_flag_indirect&ADD_STATUS_WAZAKOUKA){
		seq_no[0]=ST_ServerAddStatusParamSet(sp,ADD_STATUS_INDIRECT,sp->add_status_flag_indirect);
		sp->add_status_flag_indirect=0;
		//C₵Ă鑊ɂ͎s ͂Ŏsɂ
		if((sp->psp[sp->tsuika_client].hp)&&(sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0){
			ret=TRUE;
		}
	}
	//Zʂ̒ǉ́A100%N
	else if(sp->add_status_flag_indirect&ADD_STATUS_WAZAKOUKA_NOHIT){
		seq_no[0]=ST_ServerAddStatusParamSet(sp,ADD_STATUS_INDIRECT,sp->add_status_flag_indirect);
		sp->add_status_flag_indirect=0;
		//C₵Ă鑊ɂ͎s
		if(sp->psp[sp->tsuika_client].hp){
			ret=TRUE;
		}
	}
	//Zʂ̒ǉ́A100%N
	else if(sp->add_status_flag_indirect&ADD_STATUS_WAZAKOUKA_PROB){
		//\͂Ă̂߂݂́Am{ɂ
		if(ST_ServerTokuseiGet(sp,sp->attack_client)==TOKUSYU_TENNOMEGUMI){
			kakuritsu=WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_addeffect)*2;
		}
		else{
			kakuritsu=WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_addeffect);
		}
		if((gf_rand()%100)<kakuritsu){
			//ǉʋNɂȂAtOIɂ
			sp->server_status_flag|=SERVER_STATUS_FLAG_TSUIKA;
		}
		seq_no[0]=ST_ServerAddStatusParamSet(sp,ADD_STATUS_INDIRECT,sp->add_status_flag_indirect);
		sp->add_status_flag_indirect=0;
		//C₵Ă鑊ɂ͎s
		if(sp->psp[sp->tsuika_client].hp){
			ret=TRUE;
		}
	}
	else if(sp->add_status_flag_indirect){
		//\͂Ă̂߂݂́Am{ɂ
		if(ST_ServerTokuseiGet(sp,sp->attack_client)==TOKUSYU_TENNOMEGUMI){
			kakuritsu=WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_addeffect)*2;
		}
		else{
			kakuritsu=WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_addeffect);
		}

//fobÔ߁Aǉʂ100%ɂ
#ifdef DEBUG_ONLY_FOR_sogabe
		seq_no[0]=ST_ServerAddStatusParamSet(sp,ADD_STATUS_INDIRECT,sp->add_status_flag_indirect);
		sp->add_status_flag_indirect=0;
		//C₵Ă鑊ɂ͎s ͂Ŏsɂ
		if((sp->psp[sp->tsuika_client].hp)&&(sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0){
			ret=TRUE;
		}
#else
		if((gf_rand()%100)<kakuritsu){
			seq_no[0]=ST_ServerAddStatusParamSet(sp,ADD_STATUS_INDIRECT,sp->add_status_flag_indirect);
			sp->add_status_flag_indirect=0;
			//C₵Ă鑊ɂ͎s ͂Ŏsɂ
			if((sp->psp[sp->tsuika_client].hp)&&(sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0){
				ret=TRUE;
			}
		}
#endif
	}
	else if(sp->add_status_flag_tokusei){
		seq_no[0]=ST_ServerAddStatusParamSet(sp,ADD_STATUS_TOKUSEI,sp->add_status_flag_tokusei);
		sp->add_status_flag_tokusei=0;
		//C₵Ă鑊ɂ͎s
		if(sp->psp[sp->tsuika_client].hp){
			ret=TRUE;
		}
	}

	return ret;
}

//============================================================================================
/**
 * @brief	퓬i`FbN
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[out]	seq_no		ǉʂ邽߂̃TuV[PXio[
 */
//============================================================================================
BOOL	ST_FightShinkaCheck(BATTLE_WORK *bw,BATTLE_PARAM *bp,SERVER_PARAM *sp)
{
	if(sp->level_up_pokemon){
		bp->level_up_flag=sp->level_up_pokemon;
		{
			POKEMON_PARAM *pp;
			int	sel_mons_no;

			for(sel_mons_no=0;sel_mons_no<POKEMON_TEMOTI_MAX;sel_mons_no++){
				if(sp->level_up_pokemon&No2Bit(sel_mons_no)){
					break;
				}
			}
			pp=BattleWorkPokemonParamGet(bw,CLIENT_NO_MINE,sel_mons_no);
			if(PokeShinkaCheck(pp,LEVELUP_SHINKA,NULL)){
				return TRUE;
			}
		}
	}
	return FALSE;
}

//============================================================================================
/**
 * @brief	UΏۂZbg
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	attack		UClientNo
 * @param[in]	waza_no		JoƂĂZ
 * @param[in]	flag		0:DirSelectŃZbgl 1:Ώۂ_őI
 * @param[in]	range		waza_no0̎ɗLRANGEl
 *
 * @retval	ZbgClientNo
 */
//============================================================================================
int		ST_ServerDefenceClientSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int attack,u16 waza_no,int flag,int set_range)
{
	int	defence;
	int	range;

	defence=NONE_CLIENT_NO;

	if(waza_no){
		range=WT_WazaDataParaGet(waza_no,ID_WTD_attackrange);
	}
	else{
		range=set_range;
	}

	if(range==RANGE_DOUBLE){
		{
			int	client_no;
			int	client_set_max=BattleWorkClientSetMaxGet(bw);
			CLIENT_PARAM *cp=BattleWorkClientParamGet(bw,attack);
			u8	flag=CT_CPClientTypeGet(cp);

			for(sp->client_loop=0;sp->client_loop<client_set_max;sp->client_loop++){
				client_no=sp->psp_agi_work[sp->client_loop];
				if(sp->psp[client_no].hp!=0){
					cp=BattleWorkClientParamGet(bw,client_no);
					if( ((flag&CLIENT_ENEMY_FLAG)&&((CT_CPClientTypeGet(cp)&CLIENT_ENEMY_FLAG)==0))||
						((flag&CLIENT_ENEMY_FLAG)==0)&&(CT_CPClientTypeGet(cp)&CLIENT_ENEMY_FLAG)){
						defence=client_no;
						break;
					}
				}
			}
			if(sp->client_loop!=client_set_max){
				sp->client_loop++;
			}
		}
	}
	else if(range==RANGE_TRIPLE){
		{
			int	client_no;
			int	client_set_max;

			client_set_max=BattleWorkClientSetMaxGet(bw);

			for(sp->client_loop=0;sp->client_loop<client_set_max;sp->client_loop++){
				client_no=sp->psp_agi_work[sp->client_loop];
				if(sp->psp[client_no].hp!=0){
					if(client_no!=attack){
						defence=client_no;
						break;
					}
				}
			}
			if(sp->client_loop!=client_set_max){
				sp->client_loop++;
			}
		}
	}
	//тӂȂǂŁAΏۂI΂ɋZȍ
	else if((range==RANGE_TUBOWOTUKU)&&(flag==1)){
		{
			int	fight_type;

			fight_type=BattleWorkFightTypeGet(bw);

			if((fight_type&FIGHT_TYPE_2vs2)&&((gf_rand()%2)==0)){
				defence=attack^2;
			}
			else{
				defence=attack;
			}
		}
	}
	else if((range==RANGE_RANDOM)||(flag==1)){
		{
			int	fight_type;
			int	dir;

			fight_type=BattleWorkFightTypeGet(bw);
			dir=BattleWorkMineEnemyCheck(bw,attack)^1;

			if(fight_type&FIGHT_TYPE_2vs2){
				//̂тƂ܂ꂪȂAI
				if((sp->scw[dir].konoyubitomare_flag)&&(sp->psp[sp->scw[dir].konoyubitomare_client].hp)){
					defence=sp->scw[dir].konoyubitomare_client;
				}
				//ȂA_őI
				else if((sp->psp[attack^1].hp)&&(sp->psp[attack^3].hp)){
					defence=attack^(((gf_rand()%2)==0)?1:3);
					//Z^Cvł񂫂ŁAЂ炢ĂzAI
					if((WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_wazatype)==ELECTRIC_TYPE)&&
					   (ST_ServerTokuseiGet(sp,defence)!=TOKUSYU_HIRAISIN)&&
					   (ST_ServerKatayaburiTokuseiCheck(sp,attack,defence^2,TOKUSYU_HIRAISIN)==TRUE)){
						defence^=2;
					}
					//Z^Cv݂ŁAт݂ĂzAI
					if((WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_wazatype)==WATER_TYPE)&&
					   (ST_ServerTokuseiGet(sp,defence)!=TOKUSYU_YOBIMIZU)&&
					   (ST_ServerKatayaburiTokuseiCheck(sp,attack,defence^2,TOKUSYU_YOBIMIZU)==TRUE)){
						defence^=2;
					}
				}
				//ǂȂAI
				else if(sp->psp[attack^1].hp){
					defence=attack^1;
				}
				else if(sp->psp[attack^3].hp){
					defence=attack^3;
				}
			}
			else{
				if(sp->psp[attack^1].hp){
					defence=attack^1;
				}
			}
		}
	}
	else if((range==RANGE_MINE)||(range==RANGE_NONE)||(range==RANGE_FIELD)||(range==RANGE_MAKIBISHI)){
		defence=attack;
	}
	else if(range==RANGE_TEDASUKE){
		{
			int	fight_type;

			fight_type=BattleWorkFightTypeGet(bw);

			if(fight_type&FIGHT_TYPE_2vs2){
				defence=attack^2;
			}
			else{
				defence=attack;
			}
		}
	}
	else if(range==RANGE_TUBOWOTUKU){
		{
			int	fight_type;

			fight_type=BattleWorkFightTypeGet(bw);

			if(fight_type&FIGHT_TYPE_2vs2){
				defence=sp->client_act_work[attack][ACT_PARA_CLIENT_NO];
			}
			else{
				defence=attack;
			}
		}
	}
	else{
		{
			int	fight_type;
			int	dir;
			int	def_no;

			fight_type=BattleWorkFightTypeGet(bw);
			dir=BattleWorkMineEnemyCheck(bw,attack)^1;
			def_no=sp->client_act_work[attack][ACT_PARA_CLIENT_NO];

			//̂тƂ܂ꂪȂAI
			if((sp->scw[dir].konoyubitomare_flag)&&(sp->psp[sp->scw[dir].konoyubitomare_client].hp)){
				defence=sp->scw[dir].konoyubitomare_client;
			}
			//UΏۂC₵ĂAႤClientɃXCb`
			else if(sp->psp[sp->client_act_work[attack][ACT_PARA_CLIENT_NO]].hp){
				defence=def_no;
				if((fight_type&FIGHT_TYPE_2vs2)&&(sp->psp[defence^2].hp)){
					//Z^Cvł񂫂ŁAЂ炢ĂzAI
					if((WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_wazatype)==ELECTRIC_TYPE)&&
					   (ST_ServerTokuseiGet(sp,defence)!=TOKUSYU_HIRAISIN)&&
					   (ST_ServerKatayaburiTokuseiCheck(sp,attack,defence^2,TOKUSYU_HIRAISIN)==TRUE)){
						defence^=2;
						sp->ostf[defence].hiraisin_flag=1;
					}
					//Z^Cv݂ŁAт݂ĂzAI
					else if((WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_wazatype)==WATER_TYPE)&&
					   (ST_ServerTokuseiGet(sp,defence)!=TOKUSYU_YOBIMIZU)&&
					   (ST_ServerKatayaburiTokuseiCheck(sp,attack,defence^2,TOKUSYU_YOBIMIZU)==TRUE)){
						defence^=2;
						sp->ostf[defence].yobimizu_flag=1;
					}
				}
			}
			else if((fight_type&FIGHT_TYPE_2vs2)&&(sp->psp[def_no^2].hp)){
				defence=def_no^2;
			}
		}
	}

	return defence;
}

//============================================================================================
/**
 *	PokemonServerParamKvȃf[^̂PokemonParamɏ߂
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	ǂݏclient_no
 */
//============================================================================================
void	ST_PSPtoPPCopy(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	//ւ񂵂񂵂Ăꍇ́A߂Ȃ
	if((sp->psp[client_no].condition2&CONDITION2_HENSHIN)==0){
		SCIO_PSPtoPPCopy(bw,sp,client_no);
	}
}

//============================================================================================
/**
 *	ߌñtO𗎂Ƃ
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	tO𗎂Ƃclient_no
 */
//============================================================================================
void	ST_ServerKeepOff(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	sp->psp[client_no].condition2&=CONDITION2_KEEP_OFF;
	sp->psp[client_no].condition2&=CONDITION2_ABARERU_OFF;
	sp->psp[client_no].condition2&=CONDITION2_SAWAGU_OFF;
	sp->field_condition&=((No2Bit(client_no)<<FIELD_SAWAGU_SHIFT)^0xffffffff);
	sp->psp[client_no].condition2&=CONDITION2_GAMAN_OFF;
	sp->psp[client_no].waza_kouka&=WAZAKOUKA_KIE_OFF;
	sp->psp[client_no].wkw.korogaru_count=0;
	sp->psp[client_no].wkw.renzokugiri_count=0;
}

//============================================================================================
/**
 *	RfBVAԈُio[Ԃ
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	Ԉُ`FbNclient_no
 */
//============================================================================================
int		ST_ServerConditionNoGet(SERVER_PARAM *sp,int client_no)
{
	if(sp->psp[client_no].condition&CONDITION_NEMURI){
		return STATUS_NEMURI;
	}
	else if(sp->psp[client_no].condition&CONDITION_DOKU){
		return STATUS_DOKU;
	}
	else if(sp->psp[client_no].condition&CONDITION_YAKEDO){
		return STATUS_YAKEDO;
	}
	else if(sp->psp[client_no].condition&CONDITION_KOORI){
		return STATUS_KOORI;
	}
	else if(sp->psp[client_no].condition&CONDITION_MAHI){
		return STATUS_MAHI;
	}
	else if(sp->psp[client_no].condition&CONDITION_DOKUDOKU){
		return STATUS_DOKU;
	}
	return STATUS_NORMAL;
}

//============================================================================================
/**
 *	퓬Ƀg[i[oĂĕ\郁bZ[W`FbÑV[PXio[
 */
//============================================================================================
enum{
	SEQ_STMC_FIRST_DAMAGE=0,
	SEQ_STMC_HP_HALF,
	SEQ_STMC_POKE_LAST,
	SEQ_STMC_POKE_LAST_HP_HALF,
	SEQ_STMC_END
};

//============================================================================================
/**
 *	퓬Ƀg[i[oĂĕ\郁bZ[W`FbN
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	sp		T[opp[^[N\
 */
//============================================================================================
BOOL	ST_ServerTrainerMessageCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	fight_type;
	int	tr_id;
	int seq_no;

	fight_type=BattleWorkFightTypeGet(bw);

	//ʐMΐ́A肵Ȃ
	if(fight_type&FIGHT_TYPE_SIO){
		return FALSE;
	}
	//g[i[ł͂Ȃ΁A肵Ȃ
	if((fight_type&FIGHT_TYPE_TRAINER)==0){
		return FALSE;
	}
#warning TrainerMessage Undefine 2vs2
	//b2vs2́A肵Ȃ
	if(fight_type&FIGHT_TYPE_2vs2){
		return FALSE;
	}

	tr_id=BattleWorkTrainerIDGet(bw,CLIENT_NO_ENEMY);
	seq_no=SEQ_STMC_FIRST_DAMAGE;

	do{
		switch(seq_no){
		//퓬F|Pɍŏ̃_[W^Ƃ
		case SEQ_STMC_FIRST_DAMAGE:
			if((sp->psp[CLIENT_NO_ENEMY].hit_count==1)&&
			  ((sp->psp[CLIENT_NO_ENEMY].message_flag&TRAINER_MESSAGE_FLAG_FIRST_DAMAGE)==0)){
				if(TT_TrainerMessageCheck(tr_id,TRMSG_FIGHT_FIRST_DAMAGE,HEAPID_BATTLE)){
					sp->psp[CLIENT_NO_ENEMY].message_flag|=TRAINER_MESSAGE_FLAG_FIRST_DAMAGE;
					sp->msg_work=TRMSG_FIGHT_FIRST_DAMAGE;
					return TRUE;
				}
			}
			seq_no++;
			break;
		//퓬F|P̂goȉ
		case SEQ_STMC_HP_HALF:
			if((sp->psp[CLIENT_NO_ENEMY].message_flag&TRAINER_MESSAGE_FLAG_POKE_HP_HALF)==0){
				if(sp->psp[CLIENT_NO_ENEMY].hp<=(sp->psp[CLIENT_NO_ENEMY].hpmax/2)){
					if(TT_TrainerMessageCheck(tr_id,TRMSG_FIGHT_POKE_HP_HALF,HEAPID_BATTLE)){
						sp->psp[CLIENT_NO_ENEMY].message_flag|=TRAINER_MESSAGE_FLAG_POKE_HP_HALF;
						sp->msg_work=TRMSG_FIGHT_POKE_HP_HALF;
						return TRUE;
					}
				}
			}
			seq_no++;
			break;
		//퓬F|PcPC
		case SEQ_STMC_POKE_LAST:
			if((sp->psp[CLIENT_NO_ENEMY].message_flag&TRAINER_MESSAGE_FLAG_POKE_LAST)==0){
				{
					int	i;
					int	cnt;
					POKEPARTY		*poke_party;
					POKEMON_PARAM	*pp;

					poke_party=BattleWorkPokePartyGet(bw,CLIENT_NO_ENEMY);
					cnt=0;
	
					for(i=0;i<PokeParty_GetPokeCount(poke_party);i++){
						pp=PokeParty_GetMemberPointer(poke_party,i);
						if(PokeParaGet(pp,ID_PARA_hp,NULL)){
							cnt++;
						}
					}
					if(cnt==1){
						if(TT_TrainerMessageCheck(tr_id,TRMSG_FIGHT_POKE_LAST,HEAPID_BATTLE)){
							sp->psp[CLIENT_NO_ENEMY].message_flag|=TRAINER_MESSAGE_FLAG_POKE_LAST;
							sp->msg_work=TRMSG_FIGHT_POKE_LAST;
							return TRUE;
						}
					}
				}
			}
			seq_no++;
			break;
		//퓬F|PcPCłgoȉ
		case SEQ_STMC_POKE_LAST_HP_HALF:
			if((sp->psp[CLIENT_NO_ENEMY].message_flag&TRAINER_MESSAGE_FLAG_POKE_LAST_HP_HALF)==0){
				{
					int	i;
					int	cnt;
					POKEPARTY		*poke_party;
					POKEMON_PARAM	*pp;

					poke_party=BattleWorkPokePartyGet(bw,CLIENT_NO_ENEMY);
					cnt=0;
	
					for(i=0;i<PokeParty_GetPokeCount(poke_party);i++){
						pp=PokeParty_GetMemberPointer(poke_party,i);
						if(PokeParaGet(pp,ID_PARA_hp,NULL)){
							cnt++;
						}
					}
					if((cnt==1)&&(sp->psp[CLIENT_NO_ENEMY].hp<=(sp->psp[CLIENT_NO_ENEMY].hpmax/2))){
						if(TT_TrainerMessageCheck(tr_id,TRMSG_FIGHT_POKE_LAST_HP_HALF,HEAPID_BATTLE)){
							sp->psp[CLIENT_NO_ENEMY].message_flag|=TRAINER_MESSAGE_FLAG_POKE_LAST_HP_HALF;
							sp->msg_work=TRMSG_FIGHT_POKE_LAST_HP_HALF;
							return TRUE;
						}
					}
				}
			}
			seq_no++;
			break;
		case SEQ_STMC_END:
			break;
		}
	}while(seq_no!=SEQ_STMC_END);

	return FALSE;
}

//============================================================================================
/**
 *	ServerWork̏
 *
 *	@param[in]	sp	T[op[^\̂̃|C^
 */
//============================================================================================
void	ST_ServerWorkInit(SERVER_PARAM *sp)
{
	int	client_no;

	sp->damage=0;							///<Zɂ_[W[N
	sp->critical=1;							///<NeBJqbg[N
	sp->critical_count=0;					///<NeBJ`FbNɎgpNeBJ̏o₷{[N
	sp->damage_power=0;						///<ZɂU̓[N
	sp->damage_value=10;					///<Zɂ_[W{[N
	sp->waza_type=0;						///<Z^Cv[N

	sp->waza_status_flag=0;					///<ZƂŕωtO

	sp->kizetsu_client=NONE_CLIENT_NO;		///<C₵ClientNo

	sp->add_status_flag_direct=0;			///<ڒǉʃtO
	sp->add_status_flag_indirect=0;			///<ԐڒǉʃtO
	sp->add_status_flag_tokusei=0;			///<ɂǉʃtO
	sp->tsuika_type=ADD_STATUS_NONE;		///<ǉʂ̎ށiځAԐځAj
	sp->tsuika_para=ADD_COND_NONE;			///<ǉʂ̎ށi˂ނA܂ЂƂj
	sp->tsuika_client=NONE_CLIENT_NO;		///<ǉʂNCAg

	sp->renzoku_count=0;					///<AUpJE^
	sp->renzoku_count_temp=0;				///<AUpJE^i\pj
	sp->client_loop=0;						///<̓ZJE^
	sp->loop_flag=0;						///<[vtO
	sp->swoam_type=0;						///<ServerWazaOutAfterMessagep^Cvio[i[[N
	sp->swoam_seq_no=0;						///<ServerWazaOutAfterMessagepV[PXio[i[[N
	sp->waza_out_check_flag=0;				///<HITCHECKLtO
	sp->loop_hit_check=0;					///<[vHITCHECKLtO

	sp->fcc_seq_no=0;						///<FieldConditionCheckpV[PXio[i[[N
	sp->pcc_seq_no=0;						///<PokeConditionCheckpV[PXio[i[[N
	sp->scc_seq_no=0;						///<SideConditionCheckpV[PXio[i[[N
	sp->sba_seq_no=0;						///<ServerBeforeActpV[PXio[i[[N
	sp->swhac_seq_no=0;						///<ServerWazaHitAfterCheckpV[PXio[i[[N
	sp->swoam_seq_no=0;						///<ServerWazaOutAfterMessagepV[PXio[i[[N
	sp->wb_seq_no=0;						///<WazaBeforẽV[PXio[
	sp->woc_seq_no=0;						///<WazaOutCheck̃V[PXio[
	sp->ssc_seq_no=0;						///<ServerStatusCheck̃V[PXio[
	sp->stc_seq_no=0;						///<ServerTokuseiCheck̃V[PXio[

	sp->server_status_flag&=SERVER_STATUS_FLAG_ATTACK_TURN;	//̃^[LȃtO

	sp->magnitude=0;						///<}Oj`[h̑傫

	for(client_no=0;client_no<CLIENT_MAX;client_no++){
		MI_CpuClearFast(&sp->ostf[client_no],sizeof(ONE_SELF_TURN_FLAG));		//̃^[̂ݐ\ȃ[NQ
	}

	sp->agi_rand1=gf_rand();				///<f`FbNɎgp闐l
	sp->agi_rand2=gf_rand();				///<f`FbNɎgp闐l
}

//============================================================================================
/**
 *	JE^[N̏
 *
 *	@param[in]	sp	T[op[^\̂̃|C^
 */
//============================================================================================
void	ST_ServerCounterWorkInit(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	fight_type;
	int	i;

	for(i=0;i<CLIENT_MAX;i++){
		sp->waza_no_hit_client[i]=NONE_CLIENT_NO;
	}

	sp->okodukai_value=1;		///<̔{[N

	fight_type=BattleWorkFightTypeGet(bw);

	if((fight_type&FIGHT_TYPE_2vs2)==0){
		sp->no_reshuffle_client|=No2Bit(CLIENT_NO_MINE2);
		sp->no_reshuffle_client|=No2Bit(CLIENT_NO_ENEMY2);
	}
}

//============================================================================================
/**
 *	T[o[N̏i|Pւj
 *
 *	@param[in]	sp	T[op[^\̂̃|C^
 */
//============================================================================================
void	ST_ServerReshuffleWorkInit(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	int				i;
	int				client_set_max;
	u32				fight_type;
	u8				*adr;
	WAZA_KOUKA_WORK	wkw_temp;

	wkw_temp=sp->psp[client_no].wkw;
	client_set_max=BattleWorkClientSetMaxGet(bw);
	fight_type=BattleWorkFightTypeGet(bw);

	if((sp->server_status_flag&SERVER_STATUS_FLAG_BATON_TOUCH)==0){
		for(i=0;i<client_set_max;i++){
			//u낢܂ȂvAuN̂vւAʂ
			if((sp->psp[i].condition2&CONDITION2_KUROIMANAZASHI)&&(sp->psp[i].wkw.manazashi_client_no==client_no)){
				sp->psp[i].condition2&=CONDITION2_KUROIMANAZASHI_OFF;
			}
			//bNIւAʂ
			if((sp->psp[i].waza_kouka&WAZAKOUKA_LOCKON)&&(sp->psp[i].wkw.lockon_client_no==client_no)){
				sp->psp[i].waza_kouka&=WAZAKOUKA_LOCKON_OFF;
				sp->psp[i].wkw.lockon_client_no=0;
			}
		}
		sp->psp[client_no].condition2=0;
		sp->psp[client_no].waza_kouka=0;
	}
	else{
		sp->psp[client_no].condition2&=CONDITION2_BATON_TOUCH_ON;
		sp->psp[client_no].waza_kouka&=WAZAKOUKA_BATON_TOUCH_ON;
		for(i=0;i<client_set_max;i++){
			//bNIog^b`AJE^ɖ߂Čʂp
			if((sp->psp[i].waza_kouka&WAZAKOUKA_LOCKON)&&(sp->psp[i].wkw.lockon_client_no==client_no)){
				sp->psp[i].waza_kouka&=WAZAKOUKA_LOCKON_OFF;
				sp->psp[i].waza_kouka|=(LOCKON_COUNT*2);
			}
		}
	}

	for(i=0;i<client_set_max;i++){
	//uvւAʂ
		if(sp->psp[i].condition2&(No2Bit(client_no)<<MEROMERO_SHIFT)){
			sp->psp[i].condition2&=((No2Bit(client_no)<<MEROMERO_SHIFT)^0xffffffff);
		}
	//ߌn̋ZւAʂ
		if((sp->psp[i].condition2&CONDITION2_SHIME)&&(sp->psp[i].wkw.shime_client_no==client_no)){
			sp->psp[i].condition2&=CONDITION2_SHIME_OFF;
		}
	}

	adr=(u8 *)&sp->psp[client_no].wkw;
	for(i=0;i<sizeof(WAZA_KOUKA_WORK);i++){
		adr[i]=0;
	}
	if(sp->server_status_flag&SERVER_STATUS_FLAG_BATON_TOUCH){
		sp->psp[client_no].wkw.migawari_hp=			wkw_temp.migawari_hp;
		sp->psp[client_no].wkw.lockon_client_no=	wkw_temp.lockon_client_no;
		sp->psp[client_no].wkw.horobinouta_count=	wkw_temp.horobinouta_count;
		sp->psp[client_no].wkw.manazashi_client_no=	wkw_temp.manazashi_client_no;
	}

	sp->psp[client_no].wkw.nekodamashi_count=sp->total_turn+1;		//lR܂JE^

	sp->waza_no_out[client_no]=0;						///<1^[OɌJoĂZǂ
	sp->waza_no_hit[client_no]=0;						///<1^[OɌJoĂZ󂯂ǂ
	sp->waza_no_hit_client[client_no]=NONE_CLIENT_NO;	///<1^[OɌJoĂZ𔭓ClientNo
	sp->waza_no_hit_type[client_no]=0;					///<1^[OɃqbgZ̃^Cv
	sp->waza_no_old[client_no]=0;						///<1^[OɌJoĂZ
	sp->waza_no_oumu[client_no]=0;						///<OɎ󂯂Zi[iIEpj
	sp->waza_no_oumu_hit[client_no][0]=0;				///<OɎ󂯂Zi[i2vs2̃IEpj
	sp->waza_no_oumu_hit[client_no][1]=0;				///<OɎ󂯂Zi[i2vs2̃IEpj
	sp->waza_no_oumu_hit[client_no][2]=0;				///<OɎ󂯂Zi[i2vs2̃IEpj
	sp->waza_no_oumu_hit[client_no][3]=0;				///<OɎ󂯂Zi[i2vs2̃IEpj
	sp->waza_no_sketch[client_no]=0;					///<XPb`p̋Zio[[N

	//p[gbNtOĂꍇ́AUƖh̒lւ
	if(sp->psp[client_no].waza_kouka&WAZAKOUKA_POWER_TRICK){
		i=sp->psp[client_no].pow;
		sp->psp[client_no].pow=sp->psp[client_no].def;
		sp->psp[client_no].def=i;
	}

///<C⎞̊mFĂ鎞ɓւ̕s𔭌̂
///<̃[NNA悤ɏCiGBłƓdlɂȂ܂j
	for(i=0;i<client_set_max;i++){
		if((i!=client_no)&&(BattleWorkMineEnemyCheck(bw,i)!=BattleWorkMineEnemyCheck(bw,client_no))){
			sp->waza_no_oumu[i]=0;
		}
		sp->waza_no_oumu_hit[i][client_no]=0;
	}

#warning KODAWARI SAD_WORK NoClear
//	BattleWork_P[KODAWARI_WAZANO+ClientNo*2]=0;
//	BattleWork_P[KODAWARI_WAZANO+ClientNo*2+1]=0;
//	SAD_WORK->abirityflag[ClientNo]=0;

#warning AI_WORK NoClear
//	WazaNoStockClear(ClientNo);		//AIp̋Zio[XgbN[NNA
//	TokusyuNoClear(ClientNo);		//AIp̓io[[NNA

	//Zʔ̂߂̑fvZ
	ST_ServerPSPAgiCalc(bw,sp);
}

//============================================================================================
/**
 *	T[o[N̏i|PC⎞j
 *
 *	@param[in]	sp	T[op[^\̂̃|C^
 */
//============================================================================================
void	ST_ServerKizetsuWorkInit(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	int				i;
	int				client_set_max;
	u8				*adr;

	client_set_max=BattleWorkClientSetMaxGet(bw);

	for(i=COND_HP;i<COND_MAX;i++){
		sp->psp[client_no].abiritycnt[i]=6;
	}

	sp->psp[client_no].condition2=0;
	sp->psp[client_no].waza_kouka=0;

	//u낢܂ȂvAuN̂vC₵Aʂ
	for(i=0;i<client_set_max;i++){
		if((sp->psp[i].condition2&CONDITION2_KUROIMANAZASHI)&&(sp->psp[i].wkw.manazashi_client_no==client_no)){
			sp->psp[i].condition2&=CONDITION2_KUROIMANAZASHI_OFF;
		}
	//uvւAʂ
		if(sp->psp[i].condition2&(No2Bit(client_no)<<MEROMERO_SHIFT)){
			sp->psp[i].condition2&=((No2Bit(client_no)<<MEROMERO_SHIFT)^0xffffffff);
		}
	//ߌn̋ZւAʂ
		if((sp->psp[i].condition2&CONDITION2_SHIME)&&(sp->psp[i].wkw.shime_client_no==client_no)){
			sp->psp[i].condition2&=CONDITION2_SHIME_OFF;
		}
	}

	//̃^[ɂĂʌnSď
	adr=(u8 *)&sp->psp[client_no].wkw;
	for(i=0;i<sizeof(WAZA_KOUKA_WORK);i++){
		adr[i]=0;
	}

#warning OTF Clear Undefine
#if 0
//͂ƂƁA悱ǂ΍􂾂܂oāANA
#if 0
	adr=(u8 *)&OTF[ClientNo];
	for(i=0;i<sizeof(OneTurnFlag);i++)
		adr[i]=0;
#else
	OTF[ClientNo].guardflag=0;
	OTF[ClientNo].koraeruflag=0;
	OTF[ClientNo].waruagakiflag=0;
	OTF[ClientNo].tedasukeflag=0;
	OTF[ClientNo].magiccortflag=0;
	OTF[ClientNo].yokodoriflag=0;
	OTF[ClientNo].michidureflag=0;		//݂Â
	OTF[ClientNo].mahiflag=0;			//܂ЂōUłȂ
	OTF[ClientNo].konranflag=0;			//ŎU
	OTF[ClientNo].koukanaiflag=0;		//Ȃ
	OTF[ClientNo].tamewazaflag=0;		//ߌn̋Ẑ߃^[
	OTF[ClientNo].itemescapeflag=0;		//ACeœ
	OTF[ClientNo].huuinflag=0;			//ӂŋZoȂ
	OTF[ClientNo].meromeroflag=0;		//ŋZoȂ
	OTF[ClientNo].kanashibariflag=0;	//Ȃ΂ŋZoȂ
	OTF[ClientNo].chouhatsuflag=0;		//傤͂ŋZoȂ
	OTF[ClientNo].ichamonflag=0;		//ŋZoȂ
	OTF[ClientNo].hirumuflag=0;			//ЂŋZoȂ
	OTF[ClientNo].ppdecflag=0;			//PP_DECʂ
#endif
#endif

	sp->psp[client_no].wkw.nekodamashi_count=sp->total_turn+1;		//lR܂JE^

	sp->waza_no_out[client_no]=0;						///<1^[OɌJoĂZǂ
	sp->waza_no_hit[client_no]=0;						///<1^[OɌJoĂZ󂯂ǂ
	sp->waza_no_hit_client[client_no]=NONE_CLIENT_NO;	///<1^[OɌJoĂZ𔭓ClientNo
	sp->waza_no_hit_type[client_no]=0;					///<1^[OɃqbgZ̃^Cv
	sp->waza_no_old[client_no]=0;						///<1^[OɌJoĂZ
	sp->waza_no_oumu[client_no]=0;						///<OɎ󂯂Zi[iIEpj
	sp->waza_no_oumu_hit[client_no][0]=0;				///<OɎ󂯂Zi[i2vs2̃IEpj
	sp->waza_no_oumu_hit[client_no][1]=0;				///<OɎ󂯂Zi[i2vs2̃IEpj
	sp->waza_no_oumu_hit[client_no][2]=0;				///<OɎ󂯂Zi[i2vs2̃IEpj
	sp->waza_no_oumu_hit[client_no][3]=0;				///<OɎ󂯂Zi[i2vs2̃IEpj
	sp->waza_no_sketch[client_no]=0;					///<XPb`p̋Zio[[N

///<C⎞̊mFĂ鎞ɓւ̕s𔭌̂
///<̃[NNA悤ɏCiGBłƓdlɂȂ܂j
	for(i=0;i<client_set_max;i++){
		if((i!=client_no)&&(BattleWorkMineEnemyCheck(bw,i)!=BattleWorkMineEnemyCheck(bw,client_no))){
			sp->waza_no_oumu[i]=0;
		}
		sp->waza_no_oumu_hit[i][client_no]=0;
	}

#warning KODAWARI SAD_WORK NoClear
#warning AI_WORK NoClear
//	SAD_WORK->abirityflag[ClientNo]=0;
//	PSP[ClientNo].type1=PPD[PSP[ClientNo].monsno].type1;
//	PSP[ClientNo].type2=PPD[PSP[ClientNo].monsno].type2;
//	WazaNoStockClear(ClientNo);		//AIp̋Zio[XgbN[NNA
//	TokusyuNoClear(ClientNo);		//AIp̓io[[NNA
}

//============================================================================================
/**
 *	P^[LȃtO
 *
 * @param[in]	sp		T[op[^̍\̃|C^
 */
//============================================================================================
void	ST_ServerOneTurnFlagInit(SERVER_PARAM *sp)
{
	int	client_no;

	for(client_no=0;client_no<CLIENT_MAX;client_no++){
		MI_CpuClearFast(&sp->otf[client_no],sizeof(ONE_TURN_FLAG));
		MI_CpuClearFast(&sp->wocf[client_no],sizeof(WAZA_OUT_CHECK_FLAG));
		sp->psp[client_no].condition2&=CONDITION2_HIRUMU_OFF;
		if(sp->psp[client_no].wkw.handou_count+1<sp->total_turn){
			sp->psp[client_no].condition2&=CONDITION2_HANDOU_OFF;
		}
	}
}

//============================================================================================
/**
 *	邠ɂȂ邩`FbN
 *
 * @param[in]	bw				퓬VXep[N\
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	client_no	`FbNClientNo
 * @param[in]	check_bit	`FbN鍀ځibattle_common.hɒ`j
 */
//============================================================================================
int		ST_ServerWaruagakiCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int waza_bit,int check_bit)
{
	int	pos;
	u8	eqp;

	eqp=ST_ServerSoubiEqpGet(sp,client_no);

	for(pos=0;pos<4;pos++){
		//킴Ȃ
		if((sp->psp[client_no].waza[pos]==0)&&(check_bit&SSWC_WAZA_NONE)){
			waza_bit|=No2Bit(pos);
		}
		//PPȂ
		if((sp->psp[client_no].pp[pos]==0)&&(check_bit&SSWC_PP_NONE)){
			waza_bit|=No2Bit(pos);
		}
		//Ȃ΂肳Ă
		if((sp->psp[client_no].waza[pos]==sp->psp[client_no].wkw.kanashibari_wazano)&&(check_bit&SSWC_KANASHIBARI)){
			waza_bit|=No2Bit(pos);
		}
		//Ă
		if((sp->psp[client_no].waza[pos]==sp->waza_no_old[client_no])&&(check_bit&SSWC_ICHAMON)&&
		   (sp->psp[client_no].condition2&CONDITION2_ICHAMON)){
			waza_bit|=No2Bit(pos);
		}
		//傤͂Ă
		if((sp->psp[client_no].wkw.chouhatsu_count)&&(check_bit&SSWC_CHOUHATSU)&&
	   	   (WT_WazaDataParaGet(sp->psp[client_no].waza[pos],ID_WTD_damage)==0)){
			waza_bit|=No2Bit(pos);
		}
		//ӂ񂳂Ă
		if((ST_ServerHuuinCheck(bw,sp,client_no,sp->psp[client_no].waza[pos]))&&(check_bit&SSWC_HUUIN)){
			waza_bit|=No2Bit(pos);
		}
		//イ傭󂯂Ă
		if((ST_ServerJuuryokuCheck(bw,sp,client_no,sp->psp[client_no].waza[pos]))&&(check_bit&SSWC_JUURYOKU)){
			waza_bit|=No2Bit(pos);
		}
		//q[ubN󂯂Ă
		if((ST_ServerHealblockCheck(bw,sp,client_no,sp->psp[client_no].waza[pos]))&&(check_bit&SSWC_HEALBLOCK)){
			waza_bit|=No2Bit(pos);
		}
		//AR[
		if((sp->psp[client_no].wkw.encore_count)&&(sp->psp[client_no].wkw.encore_wazano!=sp->psp[client_no].waza[pos])){
			waza_bit|=No2Bit(pos);
		}
		//n`}L`FbN
		if(((eqp==SOUBI_ONAZIWAZAONLY)||(eqp==SOUBI_ONAZIWAZAONLYSUBAYASAUP)||(eqp==SOUBI_ONAZIAWZAONLYTOKUSYUUP))&&
		    (check_bit&SSWC_KODAWARI)){
			//ZYłn`}Lñ[NɊi[ZĂȂ`FbN
			if(ST_ServerWazaPosGet(&sp->psp[client_no],sp->psp[client_no].wkw.kodawari_wazano)==WAZA_TEMOTI_MAX){
				sp->psp[client_no].wkw.kodawari_wazano=0;
			}
			else{
				if((sp->psp[client_no].wkw.kodawari_wazano)&&
				   (sp->psp[client_no].wkw.kodawari_wazano!=sp->psp[client_no].waza[pos])){
					waza_bit|=No2Bit(pos);
				}
			}
		}
	}
	return waza_bit;
}

//============================================================================================
/**
 *	IZoƂo邩`FbN
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	waza_no		|WV擾Zio[
 *
 * @retval	TRUE:o@FALSE:oȂ
 */
//============================================================================================
BOOL	ST_ServerWazaNGCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int pos,MESSAGE_PARAM *mp)
{
	BOOL	ret;

	ret=TRUE;

	//Ȃ΂`FbN
	if(ST_ServerWaruagakiCheck(bw,sp,client_no,0,SSWC_KANASHIBARI)&No2Bit(pos)){
		mp->msg_tag=TAG_NICK_WAZA;
		mp->msg_id=KanashibariNGMineMsg;
		mp->msg_para[0]=ST_ServerTagNickParaMake(sp,client_no);
		mp->msg_para[1]=sp->psp[client_no].waza[pos];
		ret=FALSE;
	}
	//`FbN
	else if(ST_ServerWaruagakiCheck(bw,sp,client_no,0,SSWC_ICHAMON)&No2Bit(pos)){
		mp->msg_tag=TAG_NICK;
		mp->msg_id=IchamonNGMsg;
		mp->msg_para[0]=ST_ServerTagNickParaMake(sp,client_no);
		ret=FALSE;
	}
	//傤͂`FbN
	else if(ST_ServerWaruagakiCheck(bw,sp,client_no,0,SSWC_CHOUHATSU)&No2Bit(pos)){
		mp->msg_tag=TAG_NICK_WAZA;
		mp->msg_id=ChouhatsuNGMineMsg;
		mp->msg_para[0]=ST_ServerTagNickParaMake(sp,client_no);
		mp->msg_para[1]=sp->psp[client_no].waza[pos];
		ret=FALSE;
	}
	//ӂ`FbN
	else if(ST_ServerWaruagakiCheck(bw,sp,client_no,0,SSWC_HUUIN)&No2Bit(pos)){
		mp->msg_tag=TAG_NICK_WAZA;
		mp->msg_id=HuuinNGMineMsg;
		mp->msg_para[0]=ST_ServerTagNickParaMake(sp,client_no);
		mp->msg_para[1]=sp->psp[client_no].waza[pos];
		ret=FALSE;
	}
	//イ傭`FbN
	else if(ST_ServerWaruagakiCheck(bw,sp,client_no,0,SSWC_JUURYOKU)&No2Bit(pos)){
		mp->msg_tag=TAG_NICK_WAZA;
		mp->msg_id=JuuryokuNGMineMsg;
		mp->msg_para[0]=ST_ServerTagNickParaMake(sp,client_no);
		mp->msg_para[1]=sp->psp[client_no].waza[pos];
		ret=FALSE;
	}
	//q[ubN`FbN
	else if(ST_ServerWaruagakiCheck(bw,sp,client_no,0,SSWC_HEALBLOCK)&No2Bit(pos)){
		mp->msg_tag=TAG_NICK_WAZA_WAZA;
		mp->msg_id=HealblockNGMineMsg;
		mp->msg_para[0]=ST_ServerTagNickParaMake(sp,client_no);
		mp->msg_para[1]=WAZANO_HIIRUBUROKKU;
		mp->msg_para[2]=sp->psp[client_no].waza[pos];
		ret=FALSE;
	}
	//n`}L`FbN
	else if(ST_ServerWaruagakiCheck(bw,sp,client_no,0,SSWC_KODAWARI)&No2Bit(pos)){
		mp->msg_tag=TAG_ITEM_WAZA;
		mp->msg_id=ItemOnaziWazaOnlyMsg;
		mp->msg_para[0]=sp->psp[client_no].item;
		mp->msg_para[1]=sp->psp[client_no].wkw.kodawari_wazano;
		ret=FALSE;
	}
	//PP`FbNíAȂ炸Ōɂj
	else if(ST_ServerWaruagakiCheck(bw,sp,client_no,0,SSWC_PP_NONE)&No2Bit(pos)){
		mp->msg_tag=TAG_NONE;
		mp->msg_id=PPNoneMsg;
		ret=FALSE;
	}

	return ret;
}

//============================================================================================
/**
 *	Z̃|WV擾
 *
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	waza_no		|WV擾Zio[
 */
//============================================================================================
int	ST_ServerWazaPosGet(POKEMON_SERVER_PARAM *psp,u16 waza_no)
{
	int	pos;

	for(pos=0;pos<WAZA_TEMOTI_MAX;pos++){
		if(psp->waza[pos]==waza_no){
			break;
		}
	}

	return pos;
}

//============================================================================================
/**
 *	Zƃ|P̑`FbNpe[u
 */
//============================================================================================
#define	KOUKANAI	(0)
#define	IMAHITOTSU	(5)
#define	BATSUGUN	(20)

enum{
	WAZA_TYPE=0,
	POKE_TYPE,
	POWER
};

static	const	u8	TypeCheckTable[][3]={
	{NORMAL_TYPE,	IWA_TYPE,		IMAHITOTSU},	// NORMAL  IWA ɍUƁA
													// З͂ODT{
	{NORMAL_TYPE,	METAL_TYPE,		IMAHITOTSU},

	{FIRE_TYPE,		FIRE_TYPE,		IMAHITOTSU},
	{FIRE_TYPE,		WATER_TYPE,		IMAHITOTSU},
	{FIRE_TYPE,		KUSA_TYPE,		BATSUGUN},	
	{FIRE_TYPE,		KOORI_TYPE,		BATSUGUN},	
	{FIRE_TYPE,		MUSHI_TYPE,		BATSUGUN},
	{FIRE_TYPE,		IWA_TYPE,		IMAHITOTSU},
	{FIRE_TYPE,		DRAGON_TYPE,	IMAHITOTSU},
	{FIRE_TYPE,		METAL_TYPE,		BATSUGUN},

	{WATER_TYPE,	FIRE_TYPE,		BATSUGUN},
	{WATER_TYPE,	WATER_TYPE,		IMAHITOTSU},
	{WATER_TYPE,	KUSA_TYPE,		IMAHITOTSU},
	{WATER_TYPE,	JIMEN_TYPE,		BATSUGUN},
	{WATER_TYPE,	IWA_TYPE,		BATSUGUN},
	{WATER_TYPE,	DRAGON_TYPE,	IMAHITOTSU},

	{ELECTRIC_TYPE,	WATER_TYPE,		BATSUGUN},
	{ELECTRIC_TYPE,	ELECTRIC_TYPE,	IMAHITOTSU},
	{ELECTRIC_TYPE,	KUSA_TYPE,		IMAHITOTSU},
	{ELECTRIC_TYPE,	JIMEN_TYPE,		KOUKANAI},
	{ELECTRIC_TYPE,	HIKOU_TYPE,		BATSUGUN},
	{ELECTRIC_TYPE,	DRAGON_TYPE,	IMAHITOTSU},

	{KUSA_TYPE,		FIRE_TYPE,		IMAHITOTSU},
	{KUSA_TYPE,		WATER_TYPE,		BATSUGUN},
	{KUSA_TYPE,		KUSA_TYPE,		IMAHITOTSU},
	{KUSA_TYPE,		POISON_TYPE,	IMAHITOTSU},
	{KUSA_TYPE,		JIMEN_TYPE,		BATSUGUN},
	{KUSA_TYPE,		HIKOU_TYPE,		IMAHITOTSU},
	{KUSA_TYPE,		MUSHI_TYPE,		IMAHITOTSU},
	{KUSA_TYPE,		IWA_TYPE,		BATSUGUN},
	{KUSA_TYPE,		DRAGON_TYPE,	IMAHITOTSU},
	{KUSA_TYPE,		METAL_TYPE,		IMAHITOTSU},

	{KOORI_TYPE,	WATER_TYPE,		IMAHITOTSU},
	{KOORI_TYPE,	KUSA_TYPE,		BATSUGUN},
	{KOORI_TYPE,	KOORI_TYPE,		IMAHITOTSU},
	{KOORI_TYPE,	JIMEN_TYPE,		BATSUGUN},
	{KOORI_TYPE,	HIKOU_TYPE,		BATSUGUN},
	{KOORI_TYPE,	DRAGON_TYPE,	BATSUGUN},
	{KOORI_TYPE,	METAL_TYPE,		IMAHITOTSU},
	{KOORI_TYPE,	FIRE_TYPE,		IMAHITOTSU},

	{BATTLE_TYPE,	NORMAL_TYPE,	BATSUGUN},
	{BATTLE_TYPE,	KOORI_TYPE,		BATSUGUN},
	{BATTLE_TYPE,	POISON_TYPE,	IMAHITOTSU},
	{BATTLE_TYPE,	HIKOU_TYPE,		IMAHITOTSU},
	{BATTLE_TYPE,	SP_TYPE,		IMAHITOTSU},
	{BATTLE_TYPE,	MUSHI_TYPE,		IMAHITOTSU},
	{BATTLE_TYPE,	IWA_TYPE,		BATSUGUN},
	{BATTLE_TYPE,	AKU_TYPE,		BATSUGUN},
	{BATTLE_TYPE,	METAL_TYPE,		BATSUGUN},

	{POISON_TYPE,	KUSA_TYPE,		BATSUGUN},
	{POISON_TYPE,	POISON_TYPE,	IMAHITOTSU},
	{POISON_TYPE,	JIMEN_TYPE,		IMAHITOTSU},
	{POISON_TYPE,	IWA_TYPE,		IMAHITOTSU},
	{POISON_TYPE,	GHOST_TYPE,		IMAHITOTSU},
	{POISON_TYPE,	METAL_TYPE,		KOUKANAI},

	{JIMEN_TYPE,	FIRE_TYPE,		BATSUGUN},
	{JIMEN_TYPE,	ELECTRIC_TYPE,	BATSUGUN},
	{JIMEN_TYPE,	KUSA_TYPE,		IMAHITOTSU},
	{JIMEN_TYPE,	POISON_TYPE,	BATSUGUN},
	{JIMEN_TYPE,	HIKOU_TYPE,		KOUKANAI},
	{JIMEN_TYPE,	MUSHI_TYPE,		IMAHITOTSU},
	{JIMEN_TYPE,	IWA_TYPE,		BATSUGUN},
	{JIMEN_TYPE,	METAL_TYPE,		BATSUGUN},

	{HIKOU_TYPE,	ELECTRIC_TYPE,	IMAHITOTSU},
	{HIKOU_TYPE,	KUSA_TYPE,		BATSUGUN},
	{HIKOU_TYPE,	BATTLE_TYPE,	BATSUGUN},
	{HIKOU_TYPE,	MUSHI_TYPE,		BATSUGUN},
	{HIKOU_TYPE,	IWA_TYPE,		IMAHITOTSU},
	{HIKOU_TYPE,	METAL_TYPE,		IMAHITOTSU},

	{SP_TYPE,		BATTLE_TYPE,	BATSUGUN},
	{SP_TYPE,		POISON_TYPE,	BATSUGUN},
	{SP_TYPE,		SP_TYPE,		IMAHITOTSU},
	{SP_TYPE,		AKU_TYPE,		KOUKANAI},
	{SP_TYPE,		METAL_TYPE,		IMAHITOTSU},	

	{MUSHI_TYPE,	FIRE_TYPE,		IMAHITOTSU},
	{MUSHI_TYPE,	KUSA_TYPE,		BATSUGUN},
	{MUSHI_TYPE,	BATTLE_TYPE,	IMAHITOTSU},
	{MUSHI_TYPE,	POISON_TYPE,	IMAHITOTSU},
	{MUSHI_TYPE,	HIKOU_TYPE,		IMAHITOTSU},
	{MUSHI_TYPE,	SP_TYPE,		BATSUGUN},
	{MUSHI_TYPE,	GHOST_TYPE,		IMAHITOTSU},
	{MUSHI_TYPE,	AKU_TYPE,		BATSUGUN},
	{MUSHI_TYPE,	METAL_TYPE,		IMAHITOTSU},

	{IWA_TYPE,		FIRE_TYPE,		BATSUGUN},
	{IWA_TYPE,		KOORI_TYPE,		BATSUGUN},
	{IWA_TYPE,		BATTLE_TYPE,	IMAHITOTSU},
	{IWA_TYPE,		JIMEN_TYPE,		IMAHITOTSU},
	{IWA_TYPE,		HIKOU_TYPE,		BATSUGUN},
	{IWA_TYPE,		MUSHI_TYPE,		BATSUGUN},
	{IWA_TYPE,		METAL_TYPE,		IMAHITOTSU},

	{GHOST_TYPE,	NORMAL_TYPE,	KOUKANAI},
	{GHOST_TYPE,	SP_TYPE,		BATSUGUN},
	{GHOST_TYPE,	AKU_TYPE,		IMAHITOTSU},
	{GHOST_TYPE,	METAL_TYPE,		IMAHITOTSU},
	{GHOST_TYPE,	GHOST_TYPE,		BATSUGUN},	

	{DRAGON_TYPE,	DRAGON_TYPE,	BATSUGUN},
	{DRAGON_TYPE,	METAL_TYPE,		IMAHITOTSU},

	{AKU_TYPE,		BATTLE_TYPE,	IMAHITOTSU},
	{AKU_TYPE,		SP_TYPE,		BATSUGUN},
	{AKU_TYPE,		GHOST_TYPE,		BATSUGUN},
	{AKU_TYPE,		AKU_TYPE,		IMAHITOTSU},
	{AKU_TYPE,		METAL_TYPE,		IMAHITOTSU},

	{METAL_TYPE,	FIRE_TYPE,		IMAHITOTSU},
	{METAL_TYPE,	WATER_TYPE,		IMAHITOTSU},
	{METAL_TYPE,	ELECTRIC_TYPE,	IMAHITOTSU},
	{METAL_TYPE,	KOORI_TYPE,		BATSUGUN},
	{METAL_TYPE,	IWA_TYPE,		BATSUGUN},
	{METAL_TYPE,	METAL_TYPE,		IMAHITOTSU},

	{0xfe,			0xfe,			KOUKANAI},	// miyaburi check

	{NORMAL_TYPE,	GHOST_TYPE,		KOUKANAI},
	{BATTLE_TYPE,	GHOST_TYPE,		KOUKANAI},

	{0xff,			0xff,			KOUKANAI},
};


//============================================================================================
/**
 *	ʂȂ|P̑𓖂ĂZʂ̃`FbN
 *
 * @param[in]	sp				T[op[^̍\̃|C^
 * @param[in]	attack_client	UClientNo
 * @param[in]	defence_client	h䑤ClientNo
 * @param[in]	pos				TypeCheckTableIndex
 *
 * @retval	FALSE:@TRUE:ʂȂ܂܂OK
 */
//============================================================================================
static	BOOL	ST_KoukanaiCheck(SERVER_PARAM *sp,int attack_client,int defence_client,int pos)
{
	BOOL	ret;
	u8		eqp;

	eqp=ST_ServerSoubiEqpGet(sp,defence_client);

	ret=TRUE;

	//͂˂₷߃`FbN&ʂ΂₳DOWN
	if((sp->otf[defence_client].haneyasume_flag)||(eqp==SOUBI_SUBAYASADOWN)){
		//ЂɃqbg
		if((TypeCheckTable[pos][POKE_TYPE]==HIKOU_TYPE)&&
		   (TypeCheckTable[pos][POWER]==KOUKANAI)){
			ret=FALSE;
		}
	}
	//イ傭`FbN
	if(sp->field_condition&FIELD_CONDITION_JUURYOKU){
		//ЂɃqbg
		if((TypeCheckTable[pos][POKE_TYPE]==HIKOU_TYPE)&&
		   (TypeCheckTable[pos][POWER]==KOUKANAI)){
			ret=FALSE;
		}
	}
	//~NAC`FbN
	if(sp->psp[defence_client].waza_kouka&WAZAKOUKA_MIRACLE_EYE){
		//Ƀqbg
		if((TypeCheckTable[pos][POKE_TYPE]==AKU_TYPE)&&
		   (TypeCheckTable[pos][POWER]==KOUKANAI)){
			ret=FALSE;
		}
	}

	return ret;
}

//============================================================================================
/**
 * ʂŁAʔQ~Pɂ`FbNpe[u
 */
//============================================================================================
static	const	u16	EqpItemWazaPowDownTable[][2]={
	{SOUBI_HONOWOBATUGUNGUARD,FIRE_TYPE},
	{SOUBI_MIZUBATUGUNGUARD,WATER_TYPE},
	{SOUBI_DENKIBATUGUNGUARD,ELECTRIC_TYPE},
	{SOUBI_KUSABATUGUNGUARD,KUSA_TYPE},
	{SOUBI_KOORIBATUGUNGUARD,KOORI_TYPE},
	{SOUBI_KAKUTOUBATUGUNGUARD,BATTLE_TYPE},
	{SOUBI_DOKUBATUGUNGUARD,POISON_TYPE},
	{SOUBI_ZIMENBATUGUNGUARD,JIMEN_TYPE},
	{SOUBI_HIKOUBATUGUNGUARD,HIKOU_TYPE},
	{SOUBI_ESUPAABATUGUNGUARD,SP_TYPE},
	{SOUBI_MUSIGUARD,MUSHI_TYPE},
	{SOUBI_IWAGUARD,IWA_TYPE},
	{SOUBI_GOOSUTOGUARD,GHOST_TYPE},
	{SOUBI_DORAGONGUARD,DRAGON_TYPE},
	{SOUBI_AKUGUARD,AKU_TYPE},
	{SOUBI_HAGANEGUARD,METAL_TYPE},
};

enum{
	SOUBI=0,
	TYPE
};

//============================================================================================
/**
 *	Zƃ|P̑`FbN
 *
 * @param[in]	bw				퓬VXep[N\
 * @param[in]	sp				T[op[^̍\̃|C^
 * @param[in]	waza_no			`FbNZ
 * @param[in]	attack_client	UClientNo
 * @param[in]	defence_client	h䑤ClientNo
 * @param[out]	flag			`FbNʂ̃tOi[郏[N
 */
//============================================================================================
void	ST_ServerTypeCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int waza_no,int attack_client,int defence_client,u32 *flag)
{
	int	i;
	int	bairitu;
	u8	wazatype;
	u32	damage;
	u8	eqp_a;
	u8	eqp_d;
	u8	atk_a;
	u8	atk_d;

	bairitu=1;
	
	//邠́AȂ̂TypeCheckȂ
	if(waza_no==WAZANO_WARUAGAKI){
		return;
	}

	eqp_a=ST_ServerSoubiEqpGet(sp,attack_client);
	atk_a=ST_ServerSoubiAtkGet(sp,attack_client);
	eqp_d=ST_ServerSoubiEqpGet(sp,defence_client);
	atk_d=ST_ServerSoubiAtkGet(sp,defence_client);

	//m[}XĹAZ^Cvm[}ɂ
	if(ST_ServerTokuseiGet(sp,attack_client)==TOKUSYU_NOOMARUSUKIN){
		wazatype=NORMAL_TYPE;
	}
	else if(sp->waza_type){
		wazatype=sp->waza_type;
	}
	else{
		wazatype=WT_WazaDataParaGet(waza_no,ID_WTD_wazatype);
	}

	damage=WT_WazaDataParaGet(waza_no,ID_WTD_damage);

	if((sp->psp[attack_client].type1==wazatype)||(sp->psp[attack_client].type2==wazatype)){
		//Ă傭́A^CvvA1.5{2{ɂ
		if(ST_ServerTokuseiGet(sp,attack_client)==TOKUSYU_TEKIOURYOKU){
			sp->damage*=2;
		}
		else{
			sp->damage=sp->damage*15/10;
		}
	}

	//ʂӂ䂤ɂ́A߂^Cv̋Z͓ȂiʂőfDOWN̓qbgj
	if((ST_ServerKatayaburiTokuseiCheck(sp,attack_client,defence_client,TOKUSYU_HUYUU)==TRUE)&&
  	   (wazatype==JIMEN_TYPE)&&
	   (eqp_d!=SOUBI_SUBAYASADOWN)){
		flag[0]|=WAZA_STATUS_FLAG_JIMEN_NOHIT;
#warning AI TOKUSEI HATSUGEN Undefine
		//AIɓƂm点
//		TokusyuNoSet(DefenceClient,SpeabiNo);
	}
	//Zʂł񂶂ӂ䂤ɂ́A߂^Cv̋Z͓Ȃiイ傭́Ał񂶂ӂ䂤𖳌ɂj
	//iʂőfDOWN̓qbgj
	else if((sp->psp[defence_client].wkw.denzihuyuu_count)&&
			(wazatype==JIMEN_TYPE)&&
			(eqp_d!=SOUBI_SUBAYASADOWN)){
		flag[0]|=WAZA_STATUS_FLAG_DENZIHUYUU_NOHIT;
	}
	else{
		i=0;
		while(TypeCheckTable[i][WAZA_TYPE]!=0xff){
			if(TypeCheckTable[i][WAZA_TYPE]==0xfe){
				//݂Ԃ`FbNor܂Ă
				if((sp->psp[defence_client].condition2&CONDITION2_MIYABURU)||
				   (ST_ServerTokuseiGet(sp,attack_client)==TOKUSYU_KIMOTTAMA)){
					break;
				}
				else{
					i++;
					continue;
				}
			}
			if(TypeCheckTable[i][WAZA_TYPE]==wazatype){
				if(TypeCheckTable[i][POKE_TYPE]==sp->psp[defence_client].type1){
					if(ST_KoukanaiCheck(sp,attack_client,defence_client,i)==TRUE){
						ST_TypeCheckCalc(sp,attack_client,TypeCheckTable[i][POWER],damage,flag);
						if(TypeCheckTable[i][POWER]==BATSUGUN){
							bairitu*=2;
						}
					}
				}
				if((TypeCheckTable[i][POKE_TYPE]==sp->psp[defence_client].type2)&&
				   (sp->psp[defence_client].type1!=sp->psp[defence_client].type2)){
					if(ST_KoukanaiCheck(sp,attack_client,defence_client,i)==TRUE){
						ST_TypeCheckCalc(sp,attack_client,TypeCheckTable[i][POWER],damage,flag);
						if(TypeCheckTable[i][POWER]==BATSUGUN){
							bairitu*=2;
						}
					}
				}
			}
			i++;
		}
	}

	if((flag[0]&WAZA_STATUS_FLAG_BATSUGUN)&&(damage)){
		//tB^[́AQœA_[W3/4ɂ
		if((ST_ServerKatayaburiTokuseiCheck(sp,attack_client,defence_client,TOKUSYU_FIRUTAA)==TRUE)){
			sp->damage=ST_ServerDamageDiv(sp->damage*3,4);
		}
		//ʂŔQ~Pɂʂ̎́AQ~Pɂ
		for(i=0;i<NELEMS(EqpItemWazaPowDownTable);i++){
			if((EqpItemWazaPowDownTable[i][SOUBI]==eqp_d)&&
			   (EqpItemWazaPowDownTable[i][TYPE]==wazatype)){
				flag[0]&=WAZA_STATUS_FLAG_BATSUGUN_OFF;
				sp->damage/=bairitu;
				ST_ServerOSTFStatusFlagSet(sp,attack_client,OSTF_STATUS_FLAG_EQPITEM_POWDOWN);
			}
		}
		//ʂŔQЗ́Abv
		if(eqp_a==SOUBI_BATUGUNIRYOKUUP){
			sp->damage=sp->damage*(100+atk_a)/100;
		}
	}
	//\͂ӂȂ܂́AʂQȂ
	if((ST_ServerKatayaburiTokuseiCheck(sp,attack_client,defence_client,TOKUSYU_HUSIGINAMAMORI)==TRUE)&&
	   (ST_TameWazaTurnCheck(sp,waza_no))&&
	 (((flag[0]&WAZA_STATUS_FLAG_BATSUGUN)==0)||
	  ((flag[0]&WAZA_STATUS_FLAG_SOUSAI)==WAZA_STATUS_FLAG_SOUSAI))&&
	   (damage)){
		flag[0]|=WAZA_STATUS_FLAG_BATSUGUN_NOHIT;
#warning AI TOKUSEI HATSUGEN Undefine
		//AIɓƂm点
//		TokusyuNoSet(DefenceClient,SpeabiNo);
	}
//	if(WazaStatusFlag&WAZASTATUSFLAG_KOUKANAI){
//		OTF[AttackClient].koukanaiflag=1;
//	}
}

//============================================================================================
/**
 *	Z̔Wꂽ`FbN
 *
 * @param[in]	sp	T[op[^̍\̃|C^
 *
 * @retval	FALSE:WĂȂ@TRUE:Wꂽ
 */
//============================================================================================
BOOL	ST_ServerWazaOutCheck(SERVER_PARAM *sp,int client_no)
{
	if( (sp->wocf[client_no].mahi_flag)||
		(sp->wocf[client_no].koukanai_flag)||
		(sp->wocf[client_no].huuin_flag)||
		(sp->wocf[client_no].meromero_flag)||
		(sp->wocf[client_no].kanashibari_flag)||
		(sp->wocf[client_no].chouhatsu_flag)||
		(sp->wocf[client_no].hirumu_flag)||
		(sp->wocf[client_no].juuryoku_flag)||
		(sp->wocf[client_no].konran_flag)){
		return TRUE;
	}
	else{
		return FALSE;
	}
}

//============================================================================================
/**
 *	U𓖂Ă邱Ƃ̏o|P̂邩`FbN
 *
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	flag		`FbNΏۃtO
 * @param[in]	client_no	`FbNΏClientNo
 *
 * @retval	FALSE:WĂȂ@TRUE:Wꂽ
 */
//============================================================================================
u8		ST_ServerHitCountCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int flag,int client_no)
{
	int	no;
	u8	count;
	int	client_set_max;

	count=0;

	client_set_max=BattleWorkClientSetMaxGet(bw);

	switch(flag){
	case SHCC_NORMAL:
		for(no=0;no<client_set_max;no++){
			if((no!=client_no)&&(sp->no_reshuffle_client&No2Bit(no))){
				count++;
			}
		}
		break;
	case SHCC_SIDE:
		for(no=0;no<client_set_max;no++){
			if((BattleWorkMineEnemyCheck(bw,no)==BattleWorkMineEnemyCheck(bw,client_no))&&
			  ((sp->no_reshuffle_client&No2Bit(no))==0)){
				count++;
			}
		}
		break;
	}
	return count;
}

//============================================================================================
/**
 *	bZ[W\p[^̃jbNl[f[^𐶐
 *
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	client_no	ΏClientNo
 *
 * @retval	p[^
 */
//============================================================================================
int		ST_ServerTagNickParaMake(SERVER_PARAM *sp,int client_no)
{
	return (client_no|(sp->sel_mons_no[client_no]<<8));
}

//============================================================================================
/**
 *	IZio[擾
 *
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	client_no	擾ClientNo
 *
 * @retval	IZio[
 */
//============================================================================================
u16		ST_ServerSelectWazaGet(SERVER_PARAM *sp,int client_no)
{
	u16	wazano;

	wazano=0;

	if(sp->client_act_work[client_no][ACT_PARA_SELECT_COMMAND]==SELECT_FIGHT_COMMAND){
		wazano=sp->psp[client_no].waza[sp->client_act_work[client_no][ACT_PARA_WORK]-1];
	}
	return wazano;
}

//============================================================================================
/**
 *	|P邩`FbN
 *
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	flag		`FbN̎
 * @param[in]	client_no	`FbNClientNoi`FbN̎ނɂӖωj
 * @param[in]	speabi		`FbNio[
 *
 * @retval	Ă|P
 */
//============================================================================================
int		ST_ServerTokuseiCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int flag,int client_no,int speabi)
{
	int	cnt;
	int	no;
	int	client_set_max;

	cnt=0;
	client_set_max=BattleWorkClientSetMaxGet(bw);

	switch(flag){
	case STC_HAVE_MINE_SIDE:	//Ă邩`FbN
		for(no=0;no<client_set_max;no++){
			if((BattleWorkMineEnemyCheck(bw,no)==BattleWorkMineEnemyCheck(bw,client_no))&&
			   (ST_ServerTokuseiGet(sp,no)==speabi)){
				cnt++;
			}
		}
		break;
	case STC_HAVE_ENEMY_SIDE:	//葤Ă邩`FbN
		for(no=0;no<client_set_max;no++){
			if((BattleWorkMineEnemyCheck(bw,no)!=BattleWorkMineEnemyCheck(bw,client_no))&&
			   (ST_ServerTokuseiGet(sp,no)==speabi)){
				cnt++;
			}
		}
		break;
	case STC_HAVE_ALL:			//܂ߎĂ邩`FbN
		for(no=0;no<client_set_max;no++){
			if(ST_ServerTokuseiGet(sp,no)==speabi){
				cnt++;
			}
		}
		break;
	case STC_HAVE_ALL_NOMINE:	//ȊÕ|PĂ邩`FbN
		for(no=0;no<client_set_max;no++){
			if((no!=client_no)&&(ST_ServerTokuseiGet(sp,no)==speabi)){
				cnt++;
			}
		}
		break;
	case STC_HAVE_ALL_NOMINE_RET:	//ȊÕ|PĂ邩`FbNĎĂClientNoԂ
		for(no=0;no<client_set_max;no++){
			if((no!=client_no)&&(ST_ServerTokuseiGet(sp,no)==speabi)){
				cnt=no;
				break;
			}
		}
		break;
	case STC_HAVE_ALL_HP:			//܂ߎĂ邩`FbNiHP0͖j
		for(no=0;no<client_set_max;no++){
			if((ST_ServerTokuseiGet(sp,no)==speabi)&&(sp->psp[no].hp)){
				cnt++;
			}
		}
		break;
	}

	return cnt;
}

//============================================================================================
/**
 *	ߋZIĂ邩`FbN
 *
 * @param[in]	waza_no		`FbNZio[
 *
 * @retval	TRUEFߋZ@FALSE:ߋZȂ
 */
//============================================================================================
BOOL	ST_TameWazaCheck(SERVER_PARAM *sp,int waza_no)
{
	switch(WT_WazaDataParaGet(waza_no,ID_WTD_battleeffect)){
	case 26:	//܂
	case 39:	//܂
	case 75:	//Sbho[h
	case 145:	//Pbg˂
	case 151:	//\[[r[
	case 155:	//ƂԁAƂт͂˂
	case 255:	//_CrO
	case 256:	//Ȃق
		return TRUE;
		break;
	}

	return FALSE;
}

//============================================================================================
/**
 *	TypeCheckTablẽp[^擾
 *
 * @param[in]	pos		e[ũCfbNX
 * @param[in]	type_w	Z^Cvi[
 * @param[in]	type_p	|P^Cvi[
 * @param[in]	value	type_wtype_p̑
 *
 * @retval	FALSE:e[uI[o[@TRUE:e[uȂ擾
 *
 */
//============================================================================================
BOOL	ST_ServerTypeCheckTableParaGet(int pos,u8 *type_w,u8 *type_p,u8 *value)
{
	BOOL	ret;

	ret=TRUE;

	if(pos>=NELEMS(TypeCheckTable)){
		pos=gf_rand()%(NELEMS(TypeCheckTable));
		ret=FALSE;
	}
	type_w[0]=TypeCheckTable[pos][WAZA_TYPE];
	type_p[0]=TypeCheckTable[pos][POKE_TYPE];
	value[0]=TypeCheckTable[pos][POWER];

	return ret;
}

//============================================================================================
/**
 *	ႤZ֔hZ̃`FbN
 *
 * @param[in]	waza_no	`FbNZio[
 *
 * @retval	FALSE:hZł͂Ȃ@TRUE:hZ
 */
//============================================================================================
BOOL	ST_RendouWazaCheck(u16 waza_no)
{
	if((waza_no==0)||
	   (waza_no==WAZANO_NEGOTO)||
	   (waza_no==WAZANO_NEKONOTE)||
	   (waza_no==WAZANO_OUMUGAESI)||
	   (waza_no==WAZANO_YUBIWOHURU)){
		return TRUE;
	}
	return FALSE;
}

//============================================================================================
/**
 *	JoƂĂ̂낢Am[}AS[Xg`FbN
 *
 * @param[in]	sp			T[o[N\
 * @param[in]	waza_no		`FbNZio[
 * @param[in]	client_no	JoƂĂClientNo
 *
 * @retval	FALSE:m[}@TRUE:S[Xg
 */
//============================================================================================
BOOL	ST_ServerWazaNoroiCheck(SERVER_PARAM *sp,u16 waza_no,int client_no)
{
	return ((waza_no==WAZANO_NOROI)&&((sp->psp[client_no].type1==GHOST_TYPE)||(sp->psp[client_no].type2==GHOST_TYPE)));
}

//============================================================================================
/**
 *	ǂڂłACe`FbN
 *
 * @param[in]	sp			T[o[N\
 * @param[in]	client_no	ǂڂĂClientNo
 *
 * @retval	FALSE:łȂ@TRUE:ł
 */
//============================================================================================
BOOL	ST_ServerDorobouItemCheck(SERVER_PARAM *sp,int client_no)
{
	BOOL	ret;

	ret=FALSE;

	if((sp->psp[client_no].item)&&
	  (ItemMailCheck(sp->psp[client_no].item)==FALSE)){
		ret=TRUE;
	}

	return ret;
}

//============================================================================================
/**
 *	gbNłACe`FbN
 *
 * @param[in]	sp			T[o[N\
 * @param[in]	client_no	gbNĂClientNo
 *
 * @retval	FALSE:łȂ@TRUE:ł
 */
//============================================================================================
BOOL	ST_ServerTrickItemCheck(SERVER_PARAM *sp,int client_no)
{
	return (ItemMailCheck(sp->psp[client_no].item)==FALSE);
}

//============================================================================================
/**
 *	ӂƂ΂۔
 *
 * @param[in]	sp			T[o[N\
 *
 * @retval	FALSE:łȂ@TRUE:ł
 */
//============================================================================================
BOOL	ST_ServerHukitobasiCheck(SERVER_PARAM *sp)
{
	BOOL	ret;

	ret=FALSE;

	//õx΁A100%
	if(sp->psp[sp->attack_client].level>=sp->psp[sp->defence_client].level){
		ret=TRUE;
	}
	else{
		{
			int	level;

			level=(((gf_rand()&0xff)*(sp->psp[sp->attack_client].level+sp->psp[sp->defence_client].level))>>8)+1;

			if(level>(sp->psp[sp->defence_client].level/4)){
				ret=TRUE;
			}
		}
	}

	return ret;
}

//============================================================================================
/**
 *	擾iZuv̌ʂfĎ擾j
 *
 * @param[in]	psp			|PT[o[N\
 *
 * @retval	io[
 */
//============================================================================================
u8	ST_ServerTokuseiGet(SERVER_PARAM *sp,int client_no)
{
	//́A
	if(sp->psp[client_no].waza_kouka&WAZAKOUKA_IEKI){
		return 0;
	}
	//イ傭́Aӂ䂤͖
	else if((sp->field_condition&FIELD_CONDITION_JUURYOKU)&&(sp->psp[client_no].speabino==TOKUSYU_HUYUU)){
		return 0;
	}
	else{
		return sp->psp[client_no].speabino;
	}
}

//============================================================================================
/**
 *	Ԃ𔽉fă`FbN
 *
 * @param[in]	sp			T[o[N\
 * @param[in]	attack		U
 * @param[in]	defence		h䑤
 * @param[in]	tokusei		`FbN
 *
 * @retval	FALSE:Ԃœ@TRUEFԂ֌WȂ
 */
//============================================================================================
BOOL	ST_ServerKatayaburiTokuseiCheck(SERVER_PARAM *sp,int attack,int defence,int tokusei)
{
	BOOL	ret;

	ret=FALSE;

	if(ST_ServerTokuseiGet(sp,attack)!=TOKUSYU_KATAYABURI){
		if(ST_ServerTokuseiGet(sp,defence)==tokusei){
			ret=TRUE;
		}
	}
	else{
		if((ST_ServerTokuseiGet(sp,defence)==tokusei)&&(sp->ostf[attack].katayaburi_flag==0)){
			sp->ostf[attack].katayaburi_flag=1;
			sp->server_status_flag|=SERVER_STATUS_FLAG_KATAYABURI;
		}
	}

	return ret;
}

//============================================================================================
/**
 *	ւ|P邩`FbN
 *
 * @param[in]	bw			퓬VXe[N\
 * @param[in]	sp			T[o[N\
 * @param[in]	client_no	`FbNClientNo
 *
 * @retval	FALSE:Ȃ@TRUE:
 */
//============================================================================================
BOOL	ST_ServerReshuffleCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	BOOL			ret;
	POKEPARTY		*poke_p;
	POKEMON_PARAM	*pp;
	int				poke_count;
	int				cnt=0,cntmax,i,start,end,rnd_max;
	int				selmons1,selmons2;
	u32				fight_type;

	ret=FALSE;
	fight_type=BattleWorkFightTypeGet(bw);
	poke_p=BattleWorkPokePartyGet(bw,client_no);
	poke_count=BattleWorkPokeCountGet(bw,client_no);

	//_u
	if(fight_type&FIGHT_TYPE_2vs2){
		start=0;
		end=poke_count;
		rnd_max=poke_count;
		cntmax=2;
		selmons1=sp->sel_mons_no[client_no];
		selmons2=sp->sel_mons_no[BattleWorkPartnerClientNoGet(bw,client_no)];
	}
	//VO
	else{
		start=0;
		end=poke_count;
		rnd_max=poke_count;
		cntmax=1;
		selmons1=sp->sel_mons_no[client_no];
		selmons2=sp->sel_mons_no[client_no];
	}

	for(i=start;i<end;i++){
		pp=PokeParty_GetMemberPointer(poke_p,i);
		if((PokeParaGet(pp,ID_PARA_monsno,NULL))&&
		   (PokeParaGet(pp,ID_PARA_tamago_flag,NULL)==0)&&
		   (PokeParaGet(pp,ID_PARA_hp,NULL))&&
		   (selmons1!=i)&&(selmons2!=i)){
			cnt++;
		}
	}
	if(cnt>=cntmax){
		ret=TRUE;
	}

	return ret;
}

//============================================================================================
/**
 *	퓬瓦邩`FbN
 *
 *	@param[in]	bw			퓬VXe\̂̃|C^
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *	@param[in]	mp			A[gbZ[W̃p[^i[\
 *	
 *	@retval	FALSE:@TRUE:Ȃ
 */
//============================================================================================
BOOL	ST_EscapeNGCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,MESSAGE_PARAM *mp)
{
	int	i;
	int	client_set_max;
	u8	dir;
	u8	eqp;
	u32	fight_type;

	fight_type=BattleWorkFightTypeGet(bw);

	eqp=ST_ServerSoubiEqpGet(sp,client_no);

	//ACeŕK̑ʂ100%
	if((eqp==SOUBI_KANARAZUNIGERARERU)||
	//ʐMΐ͕K̂Ń`FbNȂ
	   (fight_type&FIGHT_TYPE_SIO)||
	//\͂ɂ͕K̂Ń`FbNȂ
	   (ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_NIGEASI)){
		return 0;
	}

	dir=BattleWorkMineEnemyCheck(bw,client_no);
	client_set_max=BattleWorkClientSetMaxGet(bw);

	//ӂ݂͓Ȃi݂ӂ݂̎͗Oj
	if((i=ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_NOMINE,client_no,TOKUSYU_KAGEHUMI))&&
	   (ST_ServerTokuseiGet(sp,client_no)!=TOKUSYU_KAGEHUMI)){
		if(mp==NULL){
			return TRUE;
		}
		mp->msg_tag=TAG_NICK_TOKU;
		mp->msg_id=TokuseiEscapeNGMineMsg;
		mp->msg_para[0]=ST_ServerTagNickParaMake(sp,i);
		mp->msg_para[1]=TOKUSYU_KAGEHUMI;
		return TRUE;
	}
	//肶͓Ȃ
	if((i=ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_NOMINE,client_no,TOKUSYU_ARIZIGOKU))&&
		//ӂ䂤As^Cvɂ́A肶͌ʂ
	   (ST_ServerTokuseiGet(sp,client_no)!=TOKUSYU_HUYUU)&&
	  ((sp->psp[client_no].type1!=HIKOU_TYPE)&&
	   (sp->psp[client_no].type2!=HIKOU_TYPE))){
		if(mp==NULL){
			return TRUE;
		}
		mp->msg_tag=TAG_NICK_TOKU;
		mp->msg_id=TokuseiEscapeNGMineMsg;
		mp->msg_para[0]=ST_ServerTagNickParaMake(sp,i);
		mp->msg_para[1]=TOKUSYU_ARIZIGOKU;
		return TRUE;
	}
	//傭|^Cṽ|P͓Ȃ
	if((i=ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_NOMINE,client_no,TOKUSYU_ZIRYOKU))&&
	  ((sp->psp[client_no].type1==METAL_TYPE)||
	   (sp->psp[client_no].type2==METAL_TYPE))){
		if(mp==NULL){
			return TRUE;
		}
		mp->msg_tag=TAG_NICK_TOKU;
		mp->msg_id=TokuseiEscapeNGMineMsg;
		mp->msg_para[0]=ST_ServerTagNickParaMake(sp,i);
		mp->msg_para[1]=TOKUSYU_ZIRYOKU;
		return TRUE;
	}

	//߂ĂA낢܂ȂĂA˂͂Ă鎞͓Ȃ
	if((sp->psp[client_no].condition2&(CONDITION2_SHIME|CONDITION2_KUROIMANAZASHI))||
	   (sp->psp[client_no].waza_kouka&WAZAKOUKA_NEWOHARU)){
		if(mp==NULL){
			return TRUE;
		}
		mp->msg_tag=TAG_NONE;
		mp->msg_id=EscapeNGMsg;
		return TRUE;
	}

#if 0
	//퓬^CvKChog͓̎Ȃ
	if(FightType&FIGHT_TYPE_GUIDE){
		ServerWork[5]=1;
		return 1;
	}
#endif
	return	FALSE;
}

//============================================================================================
/**
 *	Ȃ܂`FbN
 *
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *	
 *	@retval	FALSE:Ȃ܂Ȃ@TRUE:Ȃ܂
 */
//============================================================================================
BOOL	ST_ServerNamakeCheck(SERVER_PARAM *sp,int client_no)
{
	BOOL	ret;

	ret=FALSE;

	if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_NAMAKE){
		if(sp->psp[client_no].wkw.namake_bit!=(sp->total_turn&1)){
			ret=TRUE;
		}
	}
	
	return ret;
}

//============================================================================================
/**
 *	킮`FbN
 *
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *	
 *	@retval	FALSE:@TRUE:킪
 */
//============================================================================================
BOOL	ST_ServerSawaguCheck(SERVER_PARAM *sp,int client_no)
{
	BOOL	ret;

	ret=FALSE;

	if(ST_ServerTokuseiGet(sp,client_no)!=TOKUSYU_BOUON){
		if(sp->field_condition&FIELD_CONDITION_SAWAGU){
			ret=TRUE;
		}
	}
	return ret;
}

//============================================================================================
/**
 *	ӂ`FbN
 *
 *	@param[in]	bw			퓬VXe\̂̃|C^
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *	@param[in]	waza_no		`FbNWazaNo
 *	
 *	@retval	FALSE:ӂ񂳂ĂȂ@TRUE:ӂ񂳂Ă
 */
//============================================================================================
BOOL	ST_ServerHuuinCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int waza_no)
{
	int		client;
	int		client_set_max;
	int		dir;
	int		pos;
	BOOL	ret;

	ret=FALSE;

	client_set_max=BattleWorkClientSetMaxGet(bw);
	dir=BattleWorkMineEnemyCheck(bw,client_no);

	for(client=0;client<client_set_max;client++){
		if((dir!=BattleWorkMineEnemyCheck(bw,client))&&(sp->psp[client].waza_kouka&WAZAKOUKA_HUUIN)){
			for(pos=0;pos<WAZA_TEMOTI_MAX;pos++){
				if(waza_no==sp->psp[client].waza[pos]){
					break;
				}
			}
			if(pos!=WAZA_TEMOTI_MAX){
				ret=TRUE;
			}
		}
	}

	return ret;
}

//============================================================================================
/**
 *	ɂ|PɋZʂĂ邩`FbN
 *
 *	@param[in]	bw			퓬VXe\̂̃|C^
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	waza_kouka	`FbNZ
 *	
 *	@retval	FALSE:ʂĂȂ@TRUE:ʂ
 */
//============================================================================================
BOOL	ST_ServerWazaKoukaCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int waza_kouka)
{
	int		client_no;
	int		client_set_max;
	BOOL	ret;

	ret=FALSE;
	client_set_max=BattleWorkClientSetMaxGet(bw);

	for(client_no=0;client_no<client_set_max;client_no++){
		if(sp->psp[client_no].waza_kouka&waza_kouka){
			ret=TRUE;
			break;
		}
	}

	return ret;
}

//============================================================================================
/**
 *	[vn̋ZŃ[v鎞ɏ郏[N
 *
 *	@param[in]	bw			퓬VXe\̂̃|C^
 *	@param[in]	sp			T[op[^\̂̃|C^
 */
//============================================================================================
void	ST_ServerLoopInit(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	sp->waza_status_flag=0;
	sp->damage_value=10;
	sp->critical=1;
}

//============================================================================================
/**
 *	fɂZԂ̂߂̃[N𐶐
 *
 *	@param[in]	bw			퓬VXe\̂̃|C^
 *	@param[in]	sp			T[op[^\̂̃|C^
 */
//============================================================================================
void	ST_ServerPSPAgiCalc(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	client_set_max;
	int	i,j;
	int	cl1,cl2;

	client_set_max=BattleWorkClientSetMaxGet(bw);

	for(client_no=0;client_no<client_set_max;client_no++){
		sp->psp_agi_work[client_no]=client_no;
	}
	for(i=0;i<client_set_max-1;i++){
		for(j=i+1;j<client_set_max;j++){
			cl1=sp->psp_agi_work[i];
			cl2=sp->psp_agi_work[j];
			if(ST_ServerAgiCalc(bw,sp,cl1,cl2,1)){
				sp->psp_agi_work[i]=cl2;
				sp->psp_agi_work[j]=cl1;
			}
		}
	}
}

//============================================================================================
/**
 *	イ傭`FbNe[u
 */
//============================================================================================
static	const	u16	JuuryokuWazaTable[]={
	WAZANO_SORAWOTOBU,
	WAZANO_GODDOBAADO,
	WAZANO_TOBIHANERU,
	WAZANO_TOBIGERI,
	WAZANO_TOBIHIZAGERI,
	WAZANO_HANERU,
	WAZANO_DENZIHUYUU,
};

//============================================================================================
/**
 *	イ傭`FbN
 *
 *	@param[in]	bw			퓬VXe\̂̃|C^
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *	@param[in]	waza_no		`FbNWazaNo
 *	
 *	@retval	FALSE:イ傭̉eȂ@TRUE:イ傭̉e
 */
//============================================================================================
BOOL	ST_ServerJuuryokuCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int waza_no)
{
	int		no;
	BOOL	ret;

	ret=FALSE;

	if(sp->field_condition&FIELD_CONDITION_JUURYOKU){
		for(no=0;no<NELEMS(JuuryokuWazaTable);no++){
			if(JuuryokuWazaTable[no]==waza_no){
				ret=TRUE;
				break;
			}
		}
	}

	return ret;
}

//============================================================================================
/**
 *	q[ubN`FbNe[u
 */
//============================================================================================
static	const	u16	HealblockWazaTable[]={
	WAZANO_ZIKOSAISEI,
	WAZANO_TAMAGOUMI,
	WAZANO_NEMURU,
	WAZANO_MIRUKUNOMI,
	WAZANO_ASANOHIZASI,
	WAZANO_KOUGOUSEI,
	WAZANO_TUKINOHIKARI,
	WAZANO_NOMIKOMU,
	WAZANO_NAMAKERU,
	WAZANO_HANEYASUME,
	WAZANO_IYASINONEGAI,
	WAZANO_NEGAIGOTO,
};

//============================================================================================
/**
 *	q[ubN`FbN
 *
 *	@param[in]	bw			퓬VXe\̂̃|C^
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *	@param[in]	waza_no		`FbNWazaNo
 *	
 *	@retval	FALSE:q[ubN̉eȂ@TRUE:q[ubN̉e
 */
//============================================================================================
BOOL	ST_ServerHealblockCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int waza_no)
{
	int		no;
	BOOL	ret;

	ret=FALSE;

	if(sp->psp[client_no].wkw.healblock_count){
		OS_TPrintf("wazano:%d\n",waza_no);
		for(no=0;no<NELEMS(HealblockWazaTable);no++){
			if(HealblockWazaTable[no]==waza_no){
				ret=TRUE;
				break;
			}
		}
	}

	return ret;
}

//============================================================================================
/**
 *	ƂĂJEgvZ
 *
 *	@param[in]	bw			퓬VXe\̂̃|C^
 *	@param[in]	sp			T[op[^\̂̃|C^
 */
//============================================================================================
void	ST_ServerTotteokiCountCalc(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	pos;

	for(pos=0;pos<sp->psp[sp->attack_client].wkw.totteoki_count;pos++){
		if(sp->psp[sp->attack_client].wkw.totteoki_wazano[pos]==sp->waza_no_temp){
			return;
		}
	}
	sp->psp[sp->attack_client].wkw.totteoki_wazano[pos]=sp->waza_no_temp;
	sp->psp[sp->attack_client].wkw.totteoki_count++;
}

//============================================================================================
/**
 *	ZĂ邩JEg
 *
 *	@param[in]	bw			퓬VXe\̂̃|C^
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	JEgClientNo
 */
//============================================================================================
int		ST_ServerWazaCountGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	int	count;

	for(count=0;count<WAZA_TEMOTI_MAX;count++){
		if(sp->psp[client_no].waza[count]==0){
			break;
		}
	}

	return count;
}

//============================================================================================
/**
 *	_[W̃`FbNpf[^e[u
 */
//============================================================================================
//ڂe[u
static	u16	BouonWazaTable[]={
	WAZANO_NAKIGOE,
	WAZANO_HOERU,
	WAZANO_UTAU,
	WAZANO_TYOUONPA,
	WAZANO_IYANAOTO,
	WAZANO_IBIKI,
	WAZANO_SAWAGU,
	WAZANO_KINZOKUON,
	WAZANO_KUSABUE,
	WAZANO_HAIPAABOISU,
};

//============================================================================================
/**
 *	_[W̃`FbN
 *
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	attack		UClientNo
 *	@param[in]	defence		h䂷ClientNo
 */
//============================================================================================
int		ST_ServerDamageTokuseiCheck(SERVER_PARAM *sp,int attack,int defence)
{
	int	seq_no;

	seq_no=0;

	//ł`FbN
	if(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_TIKUDEN)==TRUE){
		if((WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_wazatype)==ELECTRIC_TYPE)&&
		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_damage))){
			sp->hp_calc_work=sp->damage*-1;
			seq_no=SUB_SEQ_TOKUSEI_HP_KAIFUKU;
		}
	}
	//傷`FbN
	if(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_TYOSUI)==TRUE){
		if((WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_wazatype)==WATER_TYPE)&&
		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_damage))){
			sp->hp_calc_work=sp->damage*-1;
			seq_no=SUB_SEQ_TOKUSEI_HP_KAIFUKU;
		}
	}
	//炢у`FbN
	if(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_MORAIBI)==TRUE){
		if((WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_wazatype)==FIRE_TYPE)){
			seq_no=SUB_SEQ_MORAIBI;
		}
	}
	//ڂ`FbN
	if(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_BOUON)==TRUE){
		{
			int	no;

			for(no=0;no<NELEMS(BouonWazaTable);no++){
				if(BouonWazaTable[no]==sp->waza_no_now){
					seq_no=SUB_SEQ_BOUON;
					break;
				}
			}
		}
	}
	//ł񂫃GW`FbN	
	if(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_DENKIENZIN)==TRUE){
		if(WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_wazatype)==ELECTRIC_TYPE){
			seq_no=SUB_SEQ_DENKIENZIN;
		}
	}
	//񂻂͂`FbN
	if(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_KANSOUHADA)==TRUE){
		if((WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_wazatype)==WATER_TYPE)&&
		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_damage))){
			sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[defence].hpmax,4);
			seq_no=SUB_SEQ_TOKUSEI_HP_KAIFUKU;
		}
	}

	return seq_no;
}

//============================================================================================
/**
 *	^[`FbN̓̃`FbN
 *
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 */
//============================================================================================
BOOL	ST_ServerPCCTokuseiCheck(SERVER_PARAM *sp,int client_no)
{
	BOOL	ret;
	int		seq_no;

	ret=FALSE;

	switch(ST_ServerTokuseiGet(sp,client_no)){
	//
	case TOKUSYU_KASOKU:
		if((sp->psp[client_no].hp)&&
		   (sp->psp[client_no].abiritycnt[COND_AGI]<12)&&
		   //oĂŏ̃^[́A𖳎
		   (sp->psp[client_no].wkw.nekodamashi_count!=sp->total_turn+1)){
			sp->tsuika_para=ADD_COND2_AGIUP;
			sp->tsuika_type=ADD_STATUS_TOKUSEI;
			sp->tsuika_client=client_no;
			seq_no=SUB_SEQ_ABICNT_CALC;
			ret=TRUE;
		}
		break;
	//
	case TOKUSYU_DAPPI:
		if((sp->psp[client_no].condition&CONDITION_BAD)&&
		   (gf_rand()%10<3)){
			if(sp->psp[client_no].condition&CONDITION_NEMURI){
				sp->msg_work=MSG_COND_NEMURI;
			}
			else if(sp->psp[client_no].condition&CONDITION_DOKUALL){
				sp->msg_work=MSG_COND_DOKU;
			}
			else if(sp->psp[client_no].condition&CONDITION_YAKEDO){
				sp->msg_work=MSG_COND_YAKEDO;
			}
			else if(sp->psp[client_no].condition&CONDITION_MAHI){
				sp->msg_work=MSG_COND_MAHI;
			}
			else{
				sp->msg_work=MSG_COND_KOORI;
			}
			sp->client_work=client_no;
			seq_no=SUB_SEQ_DAPPI;
			ret=TRUE;
		}
		break;
	default:
		break;
	}
	if(ret==TRUE){
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
		sp->next_server_seq_no=sp->server_seq_no;
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
	}

	return ret;
}

//============================================================================================
/**
 *	_[WvZp̊ZsiʂO̎́A1or-1␳
 *
 *	@param[in]	data	鐔
 *	@param[in]	value	鐔
 *
 *	@retval	
 */
//============================================================================================
int		ST_ServerDamageDiv(int data,int value)
{
	int	zero_flag;

	if(data<0){
		zero_flag=-1;
	}
	else{
		zero_flag=1;
	}

	data/=value;

	if(data==0){
		data=zero_flag;
	}

	return data;
}

//============================================================================================
//			ST_ServerPokeAppearCheck̃V[PXio[
//============================================================================================
enum{
	SPAC_WEATHER=0,
	SPAC_TRACE,
	SPAC_WEATHER_TOKUSEI,
	SPAC_IKAKU,
	SPAC_DOWNLOAD,
	SPAC_KIKENYOCHI,
	SPAC_YOCHIMU,
	SPAC_SLOWSTART,
	SPAC_TENKIYA,
	SPAC_OKANE2BAI,
	SPAC_END
};

enum{
	SPAC_LOOP=0,
	SPAC_WAZA_SEQ,
	SPAC_CHECK_END
};

//============================================================================================
/**
 *	|Poꎞ̃`FbNȂ
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[opp[^[N\
 *
 * @retval	`FbNɈɋNSUB_SEQ_NO
 */
//============================================================================================
int	ST_ServerPokeAppearCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	i;
	int	seq_no;
	int	ret;
	int	client_no;
	int	client_set_max;

	client_set_max=BattleWorkClientSetMaxGet(bw);

	seq_no=0;
	ret=SPAC_LOOP;

	do{
		switch(sp->spac_seq_no){
		//V`FbN
		case SPAC_WEATHER:
			sp->spac_seq_no++;
			break;
		//g[X`FbN
		case SPAC_TRACE:
			for(i=0;i<client_set_max;i++){
				client_no=sp->psp_agi_work[i];
				if((sp->psp[client_no].trace_flag==0)&&(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_TOREESU)){
					sp->psp[client_no].trace_flag=1;
					sp->client_work=client_no;
					sp->defence_client_work=ST_ServerDirClientGet(bw,sp,client_no);
					seq_no=SUB_SEQ_TRACE;
					ret=SPAC_WAZA_SEQ;
					break;
				}
			}
			if(i==client_set_max){
				sp->spac_seq_no++;
			}
			break;
		//Vn`FbN
		case SPAC_WEATHER_TOKUSEI:
			for(i=0;i<client_set_max;i++){
				client_no=sp->psp_agi_work[i];
				if(sp->psp[client_no].appear_check_flag==0){
					sp->psp[client_no].appear_check_flag=1;
					switch(ST_ServerTokuseiGet(sp,client_no)){
					//߂ӂ炵
					case TOKUSYU_AMEHURASI:
						if((sp->field_condition&FIELD_CONDITION_AMEHURASHI)==0){
							seq_no=SUB_SEQ_AMEHURASI;
							ret=SPAC_WAZA_SEQ;
						}
						break;
					//Ȃ
					case TOKUSYU_SUNAOKOSI:
						if((sp->field_condition&FIELD_CONDITION_SUNAOKOSHI)==0){
							seq_no=SUB_SEQ_SUNAOKOSI;
							ret=SPAC_WAZA_SEQ;
						}
						break;
					//Ђł
					case TOKUSYU_HIDERI:
						if((sp->field_condition&FIELD_CONDITION_HIDERI)==0){
							seq_no=SUB_SEQ_HIDERI;
							ret=SPAC_WAZA_SEQ;
						}
						break;
					}
				}
				if(ret==SPAC_WAZA_SEQ){
					sp->client_work=client_no;
					break;
				}
			}
			if(i==client_set_max){
				sp->spac_seq_no++;
			}
			break;
		//`FbN
		case SPAC_IKAKU:
			for(i=0;i<client_set_max;i++){
				client_no=sp->psp_agi_work[i];
				if((sp->psp[client_no].ikaku_flag==0)&&(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_IKAKU)){
					sp->psp[client_no].ikaku_flag=1;
					sp->attack_client=client_no;
					seq_no=SUB_SEQ_IKAKU;
					ret=SPAC_WAZA_SEQ;
					break;
				}
			}
			if(i==client_set_max){
				sp->spac_seq_no++;
			}
			break;
		//_E[h`FbN
		case SPAC_DOWNLOAD:
			for(i=0;i<client_set_max;i++){
				client_no=sp->psp_agi_work[i];
				if((sp->psp[client_no].download_flag==0)&&(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_DAUNROODO)){
					{
						int	no;
						int	def,spedef;

						def=0;
						spedef=0;

						for(no=0;no<client_set_max;no++){
							if((BattleWorkMineEnemyCheck(bw,client_no)!=BattleWorkMineEnemyCheck(bw,no))&&(sp->psp[no].hp)){
								def+=sp->psp[no].def;
								spedef+=sp->psp[no].spedef;
							}
						}
						if(def>=spedef){
							sp->tsuika_para=ADD_COND2_SPEPOWUP;
						}
						else{
							sp->tsuika_para=ADD_COND2_POWUP;
						}
						sp->psp[client_no].download_flag=1;
						sp->tsuika_type=ADD_STATUS_TOKUSEI;
						sp->tsuika_client=client_no;
						seq_no=SUB_SEQ_ABICNT_CALC;
						ret=SPAC_WAZA_SEQ;
						break;
					}
				}
			}
			if(i==client_set_max){
				sp->spac_seq_no++;
			}
			break;
		//悿
		case SPAC_KIKENYOCHI:
			for(i=0;i<client_set_max;i++){
				client_no=sp->psp_agi_work[i];
				if((sp->psp[client_no].kikenyochi_flag==0)&&(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KIKENYOTI)){
					sp->psp[client_no].kikenyochi_flag=1;
					{
						int	no,pos;
						u16	waza_no;
						u32	flag;

						flag=0;

						for(no=0;no<client_set_max;no++){
							if((BattleWorkMineEnemyCheck(bw,client_no)!=BattleWorkMineEnemyCheck(bw,no))&&(sp->psp[no].hp)){
								for(pos=0;pos<WAZA_TEMOTI_MAX;pos++){
									waza_no=sp->psp[no].waza[pos];
									if(waza_no){
										ST_ServerTypeCheck(bw,sp,waza_no,no,client_no,&flag);
										//悿́AʔQAꌂKE̋Zɑ΂ČxbZ[Wo
										if(((flag&WAZA_STATUS_FLAG_KOUKANAI)==0)&&
										   ((flag&WAZA_STATUS_FLAG_BATSUGUN)||
											(WT_WazaDataParaGet(waza_no,ID_WTD_battleeffect)==38))){
											ret=SPAC_WAZA_SEQ;
											break;
										}
									}
								}
								if(ret==SPAC_WAZA_SEQ){
									break;
								}
							}
						}
						if(ret==SPAC_WAZA_SEQ){
							sp->client_work=client_no;
							seq_no=SUB_SEQ_KIKENYOCHI;
						}
						break;
					}
				}
			}
			if(i==client_set_max){
				sp->spac_seq_no++;
			}
			break;
		//悿
		case SPAC_YOCHIMU:
			for(i=0;i<client_set_max;i++){
				client_no=sp->psp_agi_work[i];
				if((sp->psp[client_no].yochimu_flag==0)&&(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_YOTIMU)){
					sp->psp[client_no].yochimu_flag=1;
					{
						int	no,pos;
						u16	waza_no;
						u32	pow,pow_temp;

						pow_temp=0;

						for(no=0;no<client_set_max;no++){
							if((BattleWorkMineEnemyCheck(bw,client_no)!=BattleWorkMineEnemyCheck(bw,no))&&(sp->psp[no].hp)){
								for(pos=0;pos<WAZA_TEMOTI_MAX;pos++){
									waza_no=sp->psp[no].waza[pos];
									pow=WT_WazaDataParaGet(waza_no,ID_WTD_damage);
									switch(pow){
									//З͂P
									case 1:
										switch(WT_WazaDataParaGet(waza_no,ID_WTD_battleeffect)){
										//ꌂKE
										case 38:
											if((pow_temp<150)||
											  ((pow_temp==150)&&(gf_rand()&1))){
												pow_temp=150;
												sp->waza_work=waza_no;
											}
											break;
										//JE^[
										//~[R[g
										//
										case 89:
										case 144:
										case 227:
											if((pow_temp<120)||
											  ((pow_temp==120)&&(gf_rand()&1))){
												pow_temp=120;
												sp->waza_work=waza_no;
											}
											break;
										default:
											if((pow_temp<80)||
											  ((pow_temp==80)&&(gf_rand()&1))){
												pow_temp=80;
												sp->waza_work=waza_no;
											}
											break;
										}
										break;
									default:
										if((pow_temp<pow)||
										  ((pow_temp==pow)&&(gf_rand()&1))){
											pow_temp=pow;
											sp->waza_work=waza_no;
										}
										break;
									}
								}
							}
						}
						if(pow_temp){
							sp->client_work=client_no;
							seq_no=SUB_SEQ_YOCHIMU;
							ret=SPAC_WAZA_SEQ;
						}
						//Ȃꍇ́AĂZ烉_őI
						else{
							no=ST_ServerDirClientGet(bw,sp,client_no);
							pos=ST_ServerWazaCountGet(bw,sp,no);
							sp->waza_work=sp->psp[no].waza[gf_rand()%pos];
							sp->client_work=client_no;
							seq_no=SUB_SEQ_YOCHIMU;
							ret=SPAC_WAZA_SEQ;
						}
						break;
					}
				}
			}
			if(i==client_set_max){
				sp->spac_seq_no++;
			}
			break;
		case SPAC_SLOWSTART:
			for(i=0;i<client_set_max;i++){
				client_no=sp->psp_agi_work[i];
				//^[ƌʐ؂^[ɃbZ[W
				if((sp->psp[client_no].slow_start_flag==0)&&
				   (ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_SUROOSUTAATO)&&
				   (sp->total_turn<=sp->psp[client_no].wkw.nekodamashi_count)){
					sp->psp[client_no].slow_start_flag=1;
					sp->client_work=client_no;
					seq_no=SUB_SEQ_SLOWSTART;
					ret=SPAC_WAZA_SEQ;
					break;
				}
				if((sp->psp[client_no].slow_start_end_flag==0)&&
				   (ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_SUROOSUTAATO)&&
				  ((sp->total_turn-sp->psp[client_no].wkw.nekodamashi_count)==5)){
					sp->psp[client_no].slow_start_end_flag=1;
					sp->client_work=client_no;
					seq_no=SUB_SEQ_SLOWSTART_END;
					ret=SPAC_WAZA_SEQ;
					break;
				}
			}
			if(i==client_set_max){
				sp->spac_seq_no++;
			}
			break;
		//Ă񂫂
		case SPAC_TENKIYA:
			sp->spac_seq_no++;
			break;
		//ʂ2{
		case SPAC_OKANE2BAI:
			if(ST_ServerSoubiEqpGet(sp,client_no)==SOUBI_OKANENIBAI){
				sp->okodukai_value=2;	///<̔{[N
			}
			sp->spac_seq_no++;
			break;
		//`FbNI
		case SPAC_END:
			sp->spac_seq_no=0;
			ret=SPAC_CHECK_END;
			break;
		}
	}while(ret==SPAC_LOOP);

	return seq_no;
}

//============================================================================================
/**
 *	葤2̂̂1̂_őIi1vs1̎͑fɑ葤Ij
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	`FbNClientNo
 *
 * @retval	IClientNo
 */
//============================================================================================
int	ST_ServerDirClientGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	u32	fight_type;
	int	defence;

	fight_type=BattleWorkFightTypeGet(bw);

	if(fight_type&FIGHT_TYPE_2vs2){
		defence=(client_no^1)^(gf_rand()&2);
		if(sp->psp[defence].hp==0){
			defence^=2;
		}
	}
	else{
		defence=client_no^1;
	}

	return defence;
}

//============================================================================================
/**
 *	ZqbgɃ`FbN
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[opp[^[N\
 *
 * @retval	TRUE:@FALSE:s
 */
//============================================================================================
BOOL	ST_ServerWazaHitTokuseiCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	BOOL	ret;
	int		seq_no;

	ret=FALSE;

	switch(ST_ServerTokuseiGet(sp,sp->defence_client)){
	//ł
	case TOKUSYU_SEIDENKI:
		if((sp->psp[sp->attack_client].hp)&&
		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_flag)&FLAG_DAGEKI)&&
		   (gf_rand()%10<3)){
			sp->tsuika_type=ADD_STATUS_TOKUSEI;
			sp->tsuika_client=sp->attack_client;
			sp->client_work=sp->defence_client;
			seq_no=SUB_SEQ_MAHI;
			ret=TRUE;
		}
		break;
	//ւ񂵂傭
	case TOKUSYU_HENSYOKU:
		{
			u8	wazatype;

			wazatype=WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_wazatype);

			if((sp->psp[sp->defence_client].hp)&&
			   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_damage))&&
			   (sp->psp[sp->defence_client].type1!=wazatype)&&
			   (sp->psp[sp->defence_client].type2!=wazatype)){
				seq_no=SUB_SEQ_HENSYOKU;
				sp->msg_work=wazatype;
				ret=TRUE;
			}
		}
		break;
	//߂͂
	case TOKUSYU_SAMEHADA:
		if((sp->psp[sp->attack_client].hp)&&
		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_flag)&FLAG_DAGEKI)){
			sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->attack_client].hpmax*-1,16);
			sp->client_work=sp->attack_client;
			seq_no=SUB_SEQ_SAMEHADA;
			ret=TRUE;
		}
		break;
	//ق
	case TOKUSYU_HOUSI:
		if((sp->psp[sp->attack_client].hp)&&
		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_flag)&FLAG_DAGEKI)&&
		   (gf_rand()%10<3)){
			switch(gf_rand()%3){
			case 0:
			default:
				seq_no=SUB_SEQ_DOKU;
				break;
			case 1:
				seq_no=SUB_SEQ_MAHI;
				break;
			case 2:
				seq_no=SUB_SEQ_NEMURI;
				break;
			}
			sp->tsuika_type=ADD_STATUS_TOKUSEI;
			sp->tsuika_client=sp->attack_client;
			sp->client_work=sp->defence_client;
			ret=TRUE;
		}
		break;
	//ǂ̂Ƃ
	case TOKUSYU_DOKUNOTOGE:
		if((sp->psp[sp->attack_client].hp)&&
		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_flag)&FLAG_DAGEKI)&&
		   (gf_rand()%10<3)){
			sp->tsuika_type=ADD_STATUS_TOKUSEI;
			sp->tsuika_client=sp->attack_client;
			sp->client_work=sp->defence_client;
			seq_no=SUB_SEQ_DOKU;
			ret=TRUE;
		}
		break;
	//ق̂̂炾
	case TOKUSYU_HONOONOKARADA:
		if((sp->psp[sp->attack_client].hp)&&
		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_flag)&FLAG_DAGEKI)&&
		   (gf_rand()%10<3)){
			sp->tsuika_type=ADD_STATUS_TOKUSEI;
			sp->tsuika_client=sp->attack_client;
			sp->client_work=sp->defence_client;
			seq_no=SUB_SEQ_YAKEDO;
			ret=TRUE;
		}
		break;
	//{fB
	case TOKUSYU_MEROMEROBODHI:
		if((sp->psp[sp->attack_client].hp)&&
		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_flag)&FLAG_DAGEKI)&&
		   (sp->psp[sp->defence_client].hp)&&
		   (gf_rand()%10<3)){
			sp->tsuika_type=ADD_STATUS_TOKUSEI;
			sp->tsuika_client=sp->attack_client;
			sp->client_work=sp->defence_client;
			seq_no=SUB_SEQ_MEROMERO;
			ret=TRUE;
		}
		break;
	//䂤΂
	case TOKUSYU_YUUBAKU:
		if((sp->server_status_flag&(No2Bit(sp->defence_client)<<SERVER_STATUS_FLAG_KIZETSU_SHIFT))&&
		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_flag)&FLAG_DAGEKI)){
			sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->attack_client].hpmax*-1,4);
			sp->client_work=sp->attack_client;
			seq_no=SUB_SEQ_YUUBAKU;
			ret=TRUE;
		}
		break;
	default:
		break;
	}
	if(ret==TRUE){
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
		sp->next_server_seq_no=sp->server_seq_no;
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
	}

	return ret;
}

//============================================================================================
/**
 *	ZqbgɃ`FbNiXLXbvȂǂŁAւďԈُ𒼂`FbNj
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	`FbNClientNo
 *
 * @retval	TRUE:@FALSE:s
 */
//============================================================================================
BOOL	ST_ServerTokuseiStatusRecoverCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	BOOL	ret;

	ret=FALSE;

	switch(ST_ServerTokuseiGet(sp,client_no)){
	case TOKUSYU_MENEKI:
		if(sp->psp[client_no].condition&CONDITION_DOKUALL){
			sp->msg_work=MSG_COND_DOKU;
			ret=TRUE;
		}
		break;
	case TOKUSYU_MAIPEESU:
		if(sp->psp[client_no].condition2&CONDITION2_KONRAN){
			sp->msg_work=MSG_COND_KONRAN;
			ret=TRUE;
		}
		break;
	case TOKUSYU_ZYUUNAN:
		if(sp->psp[client_no].condition&CONDITION_MAHI){
			sp->msg_work=MSG_COND_MAHI;
			ret=TRUE;
		}
		break;
	case TOKUSYU_HUMIN:
	case TOKUSYU_YARUKI:
		if(sp->psp[client_no].condition&CONDITION_NEMURI){
			sp->msg_work=MSG_COND_NEMURI;
			ret=TRUE;
		}
		break;
	case TOKUSYU_MIZUNOBEERU:
		if(sp->psp[client_no].condition&CONDITION_YAKEDO){
			sp->msg_work=MSG_COND_YAKEDO;
			ret=TRUE;
		}
		break;
	case TOKUSYU_MAGUMANOYOROI:
		if(sp->psp[client_no].condition&CONDITION_KOORI){
			sp->msg_work=MSG_COND_KOORI;
			ret=TRUE;
		}
		break;
	case TOKUSYU_DONKAN:
		if(sp->psp[client_no].condition2&CONDITION2_MEROMERO){
			sp->msg_work=MSG_COND_MEROMERO;
		}
		break;
	}
	if(ret==TRUE){
		sp->client_work=client_no;
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_TOKUSEI_CONDITION_RECOVER);
		sp->next_server_seq_no=sp->server_seq_no;
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
	}

	return ret;
}

//============================================================================================
/**
 *	ZqbgɃ`FbNiVN̂݁j
 *
 * @param[in]	bw				퓬VXep[N\
 * @param[in]	sp				T[opp[^[N\
 * @param[in]	server_seq_no	sp->next_server_seq_noɃZbgio[
 *
 * @retval	TRUE:@FALSE:s
 */
//============================================================================================
BOOL	ST_ServerSinkuroCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int server_seq_no)
{
	BOOL	ret;
	int		seq_no;

	ret=FALSE;

	//h䑤`FbN
	if((ST_ServerTokuseiGet(sp,sp->defence_client)==TOKUSYU_SINKURO)&&
	   (sp->defence_client==sp->tsuika_client)&&
	   (sp->server_status_flag&SERVER_STATUS_FLAG_SINKURO_TSUIKA)){
		sp->client_work=sp->defence_client;
		sp->tsuika_client=sp->attack_client;
		ret=TRUE;
	}
	//U`FbN
	else if((ST_ServerTokuseiGet(sp,sp->attack_client)==TOKUSYU_SINKURO)&&
	   (sp->attack_client==sp->tsuika_client)&&
	   (sp->server_status_flag&SERVER_STATUS_FLAG_SINKURO_TSUIKA)){
		sp->client_work=sp->attack_client;
		sp->tsuika_client=sp->defence_client;
		ret=TRUE;
	}

	if(ret==TRUE){
		if(sp->psp[sp->client_work].condition&CONDITION_DOKUALL){
			seq_no=SUB_SEQ_DOKU;
		}
		else if(sp->psp[sp->client_work].condition&CONDITION_YAKEDO){
			seq_no=SUB_SEQ_YAKEDO;
		}
		else{
			seq_no=SUB_SEQ_MAHI;
		}
		sp->tsuika_type=ADD_STATUS_TOKUSEI;
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
		sp->next_server_seq_no=server_seq_no;
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
	}

	//`FbN^C~O͓Ȃ̂ŁAACeuƁv`FbN
	//h䑤`FbN
	if((ST_ServerSoubiEqpGet(sp,sp->defence_client)==SOUBI_MEROMERODETEKIMOMEROMERO)&&
	   (sp->defence_client==sp->tsuika_client)&&
	   (sp->ostf[sp->defence_client].status_flag&OSTF_STATUS_FLAG_MEROMERO)){
		sp->client_work=sp->defence_client;
		sp->tsuika_client=sp->attack_client;
		ret=TRUE;
	}
	//U`FbN
	else if((ST_ServerSoubiEqpGet(sp,sp->attack_client)==SOUBI_MEROMERODETEKIMOMEROMERO)&&
	   (sp->attack_client==sp->tsuika_client)&&
	   (sp->ostf[sp->attack_client].status_flag&OSTF_STATUS_FLAG_MEROMERO)){
		sp->client_work=sp->attack_client;
		sp->tsuika_client=sp->defence_client;
		ret=TRUE;
	}

	if(ret==TRUE){
		seq_no=SUB_SEQ_MEROMERO;
		sp->tsuika_type=ADD_STATUS_SOUBIITEM;
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
		sp->next_server_seq_no=server_seq_no;
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
	}

	return ret;
}

//============================================================================================
/**
 *	^[`FbN̑ACeʂ̃`FbN
 *
 *	@param[in]	bw			퓬VXep[N\
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *
 *	@retval	FALSE:ȂɂȂ	TRUE:ʔ
 */
//============================================================================================
BOOL	ST_ServerSoubiItemCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	BOOL	ret;
	int		seq_no;
	s32		eqp;
	s32		atk;

	ret=FALSE;

	eqp=ST_ServerSoubiEqpGet(sp,client_no);
	atk=ST_ServerSoubiAtkGet(sp,client_no);

	if(sp->psp[client_no].hp){
		switch(eqp){
		case SOUBI_HPKAIHUKU:
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/2)){
				sp->hp_calc_work=atk;
				seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				ret=TRUE;
			}
			break;
		case SOUBI_MAHINAOSI:
			if(sp->psp[client_no].condition&CONDITION_MAHI){
				seq_no=SUB_SEQ_EQPITEM_NO_MAHI;
				ret=TRUE;
			}
			break;
		case SOUBI_NEMUKEZAMASI:
			if(sp->psp[client_no].condition&CONDITION_NEMURI){
				seq_no=SUB_SEQ_EQPITEM_NO_NEMURI;
				ret=TRUE;
			}
			break;
		case SOUBI_DOKUKESI:
			if(sp->psp[client_no].condition&CONDITION_DOKUALL){
				seq_no=SUB_SEQ_EQPITEM_NO_DOKU;
				ret=TRUE;
			}
			break;
		case SOUBI_YAKEDONAOSI:
			if(sp->psp[client_no].condition&CONDITION_YAKEDO){
				seq_no=SUB_SEQ_EQPITEM_NO_YAKEDO;
				ret=TRUE;
			}
			break;
		case SOUBI_KOORINAOSI:
			if(sp->psp[client_no].condition&CONDITION_KOORI){
				seq_no=SUB_SEQ_EQPITEM_NO_KOORI;
				ret=TRUE;
			}
			break;
		case SOUBI_PPKAIHUKU:
			{
				int	pos;

				for(pos=0;pos<WAZA_TEMOTI_MAX;pos++){
					if((sp->psp[client_no].waza[pos])&&
					   (sp->psp[client_no].pp[pos]==0)){
						break;
					}
				}
				if(pos!=WAZA_TEMOTI_MAX){
					ST_PokemonServerParamAdd(&sp->psp[client_no],ID_PSP_pp1+pos,atk);
					ST_PSPtoPPCopy(bw,sp,client_no);
					sp->waza_work=sp->psp[client_no].waza[pos];
					seq_no=SUB_SEQ_EQPITEM_PP_KAIHUKU;
					ret=TRUE;
				}
			}
			break;
		case SOUBI_KONRANNAOSI:
			if(sp->psp[client_no].condition2&CONDITION2_KONRAN){
				seq_no=SUB_SEQ_EQPITEM_NO_KONRAN;
				ret=TRUE;
			}
			break;
		case SOUBI_ZYOUTAIIZYOUNAOSI:
			if((sp->psp[client_no].condition&CONDITION_BAD)||
			   (sp->psp[client_no].condition2&CONDITION2_KONRAN)){
				if(sp->psp[client_no].condition&CONDITION_MAHI){
					seq_no=SUB_SEQ_EQPITEM_NO_MAHI;
				}
				if(sp->psp[client_no].condition&CONDITION_NEMURI){
					seq_no=SUB_SEQ_EQPITEM_NO_NEMURI;
				}
				if(sp->psp[client_no].condition&CONDITION_DOKUALL){
					seq_no=SUB_SEQ_EQPITEM_NO_DOKU;
				}
				if(sp->psp[client_no].condition&CONDITION_YAKEDO){
					seq_no=SUB_SEQ_EQPITEM_NO_YAKEDO;
				}
				if(sp->psp[client_no].condition&CONDITION_KOORI){
					seq_no=SUB_SEQ_EQPITEM_NO_KOORI;
				}
				if(sp->psp[client_no].condition2&CONDITION2_KONRAN){
					seq_no=SUB_SEQ_EQPITEM_NO_KONRAN;
				}
				if((sp->psp[client_no].condition&CONDITION_BAD)&&
				   (sp->psp[client_no].condition2&CONDITION2_KONRAN)){
					seq_no=SUB_SEQ_EQPITEM_NO_JOUTAIIJOU;
				}
				ret=TRUE;
			}
			break;
		case SOUBI_KARAIKONRAN:
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/2)){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,atk);
				sp->msg_work=TASTE_KARAI;
				if(PokeLikeTasteCheck(sp->psp[client_no].personal_rnd,TASTE_KARAI)==DISLIKE_TASTE){
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
				}
				else{
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				}
				ret=TRUE;
			}
			break;
		case SOUBI_SIBUIKONRAN:
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/2)){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,atk);
				sp->msg_work=TASTE_SIBUI;
				if(PokeLikeTasteCheck(sp->psp[client_no].personal_rnd,TASTE_SIBUI)==DISLIKE_TASTE){
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
				}
				else{
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				}
				ret=TRUE;
			}
			break;
		case SOUBI_AMAIKONRAN:
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/2)){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,atk);
				sp->msg_work=TASTE_AMAI;
				if(PokeLikeTasteCheck(sp->psp[client_no].personal_rnd,TASTE_AMAI)==DISLIKE_TASTE){
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
				}
				else{
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				}
				ret=TRUE;
			}
			break;
		case SOUBI_NIGAIKONRAN:
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/2)){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,atk);
				sp->msg_work=TASTE_NIGAI;
				if(PokeLikeTasteCheck(sp->psp[client_no].personal_rnd,TASTE_NIGAI)==DISLIKE_TASTE){
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
				}
				else{
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				}
				ret=TRUE;
			}
			break;
		case SOUBI_SUPPAIKONRAN:
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/2)){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,atk);
				sp->msg_work=TASTE_SUPPAI;
				if(PokeLikeTasteCheck(sp->psp[client_no].personal_rnd,TASTE_SUPPAI)==DISLIKE_TASTE){
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
				}
				else{
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				}
				ret=TRUE;
			}
			break;
		case SOUBI_KOUGEKIUP:
			//ڂ́AiKŋN悤
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if((sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk))&&
			   (sp->psp[client_no].abiritycnt[COND_POW]<12)){
				sp->msg_work=COND_POW;
				seq_no=SUB_SEQ_EQPITEM_CONDUP;
				ret=TRUE;
			}
			break;
		case SOUBI_BOUGYOUP:
			//ڂ́AiKŋN悤
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if((sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk))&&
			   (sp->psp[client_no].abiritycnt[COND_DEF]<12)){
				sp->msg_work=COND_DEF;
				seq_no=SUB_SEQ_EQPITEM_CONDUP;
				ret=TRUE;
			}
			break;
		case SOUBI_SUBAYASAUP:
			//ڂ́AiKŋN悤
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if((sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk))&&
			   (sp->psp[client_no].abiritycnt[COND_AGI]<12)){
				sp->msg_work=COND_AGI;
				seq_no=SUB_SEQ_EQPITEM_CONDUP;
				ret=TRUE;
			}
			break;
		case SOUBI_TOKUKOUUP:
			//ڂ́AiKŋN悤
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if((sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk))&&
			   (sp->psp[client_no].abiritycnt[COND_SPEPOW]<12)){
				sp->msg_work=COND_SPEPOW;
				seq_no=SUB_SEQ_EQPITEM_CONDUP;
				ret=TRUE;
			}
			break;
		case SOUBI_TOKUBOUUP:
			//ڂ́AiKŋN悤
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if((sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk))&&
			   (sp->psp[client_no].abiritycnt[COND_SPEDEF]<12)){
				sp->msg_work=COND_SPEDEF;
				seq_no=SUB_SEQ_EQPITEM_CONDUP;
				ret=TRUE;
			}
			break;
		case SOUBI_KURITHIKARUUP:
			//ڂ́AiKŋN悤
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if((sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk))&&
			  ((sp->psp[client_no].condition2&CONDITION2_KIAIDAME)==0)){
				seq_no=SUB_SEQ_EQPITEM_CRITICALUP;
				ret=TRUE;
			}
			break;
		case SOUBI_NOURYOKURNDUP:
			//ڂ́AiKŋN悤
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if((sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk))&&
			   (sp->psp[client_no].abiritycnt[COND_POW]<12)){
				{
					int	i;

					for(i=0;i<5;i++){
						if(sp->psp[client_no].abiritycnt[COND_POW+i]<12){
							break;
						}
					}
					if(i!=5){
						do{
							i=gf_rand()%5;
						}while(sp->psp[client_no].abiritycnt[COND_POW+i]==12);
						sp->msg_work=COND_POW+i;
						seq_no=SUB_SEQ_EQPITEM_CONDUP_MAX;
						ret=TRUE;
					}
				}
			}
			break;
		case SOUBI_NOURYOKUKAIHUKU:
			{
				int	i;

				for(i=0;i<COND_MAX;i++){
					if(sp->psp[client_no].abiritycnt[i]<6){
						sp->psp[client_no].abiritycnt[i]=6;
						ret=TRUE;
					}
				}
				if(ret==TRUE){
					seq_no=SUB_SEQ_EQPITEM_ABIRITY_KAIHUKU;
				}
			}
			break;
		case SOUBI_MEROMERONAOSI:
			if(sp->psp[client_no].condition2&CONDITION2_MEROMERO){
				sp->msg_work=MSG_COND_MEROMERO;
				seq_no=SUB_SEQ_EQPITEM_NO_MEROMERO;
				ret=TRUE;
			}
			break;
		case SOUBI_HPKAIHUKUMAITURN:
			if(sp->psp[client_no].hp<(sp->psp[client_no].hpmax)){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,16);
				seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKUMAITURN;
				ret=TRUE;
			}
			break;
		case SOUBI_DOKUKAIHUKU:
			if((sp->psp[client_no].type1==POISON_TYPE)||(sp->psp[client_no].type2==POISON_TYPE)){
				if(sp->psp[client_no].hp<(sp->psp[client_no].hpmax)){
					sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,16);
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKUMAITURN;
					ret=TRUE;
				}
			}
			else{
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax*-1,8);
				seq_no=SUB_SEQ_EQPITEM_DAMAGE;
				ret=TRUE;
			}
			break;
		default:
			break;
		}
		if(ret==TRUE){
			sp->client_work=client_no;
			sp->item_work=ST_ServerSoubiItemNoGet(sp,client_no);
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
			sp->next_server_seq_no=sp->server_seq_no;
			sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		}
	}

	return ret;
}

//============================================================================================
/**
 *	ACeʂ̃`FbNiԈُn𒼂ẑ݁j
 *
 *	@param[in]	bw			퓬VXep[N\
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *
 *	@retval	FALSE:ȂɂȂ	TRUE:ʔ
 */
//============================================================================================
BOOL	ST_ServerSoubiItemConditionBadCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	BOOL	ret;
	int		seq_no;
	u16		item_no;
	s32		eqp;
	s32		atk;

	ret=FALSE;

	eqp=ST_ServerSoubiEqpGet(sp,client_no);
	atk=ST_ServerSoubiAtkGet(sp,client_no);

	if(sp->psp[client_no].hp){
		switch(eqp){
		case SOUBI_MAHINAOSI:
			if(sp->psp[client_no].condition&CONDITION_MAHI){
				seq_no=SUB_SEQ_EQPITEM_NO_MAHI;
				ret=TRUE;
			}
			break;
		case SOUBI_NEMUKEZAMASI:
			if(sp->psp[client_no].condition&CONDITION_NEMURI){
				seq_no=SUB_SEQ_EQPITEM_NO_NEMURI;
				ret=TRUE;
			}
			break;
		case SOUBI_DOKUKESI:
			if(sp->psp[client_no].condition&CONDITION_DOKUALL){
				seq_no=SUB_SEQ_EQPITEM_NO_DOKU;
				ret=TRUE;
			}
			break;
		case SOUBI_YAKEDONAOSI:
			if(sp->psp[client_no].condition&CONDITION_YAKEDO){
				seq_no=SUB_SEQ_EQPITEM_NO_YAKEDO;
				ret=TRUE;
			}
			break;
		case SOUBI_KOORINAOSI:
			if(sp->psp[client_no].condition&CONDITION_KOORI){
				seq_no=SUB_SEQ_EQPITEM_NO_KOORI;
				ret=TRUE;
			}
			break;
		case SOUBI_KONRANNAOSI:
			if(sp->psp[client_no].condition2&CONDITION2_KONRAN){
				seq_no=SUB_SEQ_EQPITEM_NO_KONRAN;
				ret=TRUE;
			}
			break;
		case SOUBI_ZYOUTAIIZYOUNAOSI:
			if((sp->psp[client_no].condition&CONDITION_BAD)||
			   (sp->psp[client_no].condition2&CONDITION2_KONRAN)){
				if(sp->psp[client_no].condition&CONDITION_MAHI){
					seq_no=SUB_SEQ_EQPITEM_NO_MAHI;
				}
				if(sp->psp[client_no].condition&CONDITION_NEMURI){
					seq_no=SUB_SEQ_EQPITEM_NO_NEMURI;
				}
				if(sp->psp[client_no].condition&CONDITION_DOKUALL){
					seq_no=SUB_SEQ_EQPITEM_NO_DOKU;
				}
				if(sp->psp[client_no].condition&CONDITION_YAKEDO){
					seq_no=SUB_SEQ_EQPITEM_NO_YAKEDO;
				}
				if(sp->psp[client_no].condition&CONDITION_KOORI){
					seq_no=SUB_SEQ_EQPITEM_NO_KOORI;
				}
				if(sp->psp[client_no].condition2&CONDITION2_KONRAN){
					seq_no=SUB_SEQ_EQPITEM_NO_KONRAN;
				}
				if((sp->psp[client_no].condition&CONDITION_BAD)&&
				   (sp->psp[client_no].condition2&CONDITION2_KONRAN)){
					seq_no=SUB_SEQ_EQPITEM_NO_JOUTAIIJOU;
				}
				ret=TRUE;
			}
			break;
		case SOUBI_NOURYOKUKAIHUKU:
			{
				int	i;

				for(i=0;i<COND_MAX;i++){
					if(sp->psp[client_no].abiritycnt[i]<6){
						sp->psp[client_no].abiritycnt[i]=6;
						ret=TRUE;
					}
				}
				if(ret==TRUE){
					seq_no=SUB_SEQ_EQPITEM_ABIRITY_KAIHUKU;
				}
			}
			break;
		case SOUBI_MEROMERONAOSI:
			if(sp->psp[client_no].condition2&CONDITION2_MEROMERO){
				sp->msg_work=MSG_COND_MEROMERO;
				seq_no=SUB_SEQ_EQPITEM_NO_MEROMERO;
				ret=TRUE;
			}
			break;
		default:
			break;
		}
		if(ret==TRUE){
			sp->client_work=client_no;
			sp->item_work=ST_ServerSoubiItemNoGet(sp,client_no);
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
			sp->next_server_seq_no=sp->server_seq_no;
			sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		}
	}

	return ret;
}

//============================================================================================
/*
 *	ACeʂ̃`FbNi_[Wnj
 *
 *	@param[in]	bw			퓬VXep[N\
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *
 *	@retval	ACeio[
 */
//============================================================================================
BOOL	ST_ServerSoubiItemDamageCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	BOOL	ret;
	int		seq_no;
	u16		item_no;
	s32		eqp;
	s32		atk;

	ret=FALSE;

	eqp=ST_ServerSoubiEqpGet(sp,client_no);
	atk=ST_ServerSoubiAtkGet(sp,client_no);

	if(sp->psp[client_no].hp){
		switch(eqp){
		case SOUBI_TEKINIMOTASERUTOMOUDOKU:
			sp->tsuika_client=client_no;
			sp->tsuika_type=ADD_STATUS_SOUBIITEM;
			seq_no=SUB_SEQ_DOKUDOKU;
			ret=TRUE;
			break;
		case SOUBI_TTEKINIMOTASERUTOYAKEDO:
			sp->tsuika_client=client_no;
			sp->tsuika_type=ADD_STATUS_SOUBIITEM;
			seq_no=SUB_SEQ_YAKEDO;
			ret=TRUE;
			break;
		case SOUBI_TEKINIMOTASETEDAMEEZI:
			sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax*-1,atk);
			seq_no=SUB_SEQ_EQPITEM_DAMAGE;
			ret=TRUE;
			break;
		default:
			break;
		}
		if(ret==TRUE){
			sp->client_work=client_no;
			sp->item_work=ST_ServerSoubiItemNoGet(sp,client_no);
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
			sp->next_server_seq_no=sp->server_seq_no;
			sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		}
	}
	return ret;
}

//============================================================================================
/*
 *	ACeio[̎擾
 *
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *
 *	@retval	ACeio[
 */
//============================================================================================
u16	ST_ServerSoubiItemNoGet(SERVER_PARAM *sp,int client_no)
{
	//Ԃ悤́AACegȂȂ
	if((ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_BUKIYOU)){
		return 0;
	}
	//VbgAEg̋Zʔ́AACegȂ
	if(sp->psp[client_no].wkw.shutout_count){
		return 0;
	}
	
	return sp->psp[client_no].item;
}

//============================================================================================
/*
 *	`FbNΏۂIĂ邩`FbN
 *
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *
 *	@retval	FALSE:܂삵ĂȂ@TRUE:I
 */
//============================================================================================
BOOL	ST_ServerWazaEndCheck(SERVER_PARAM *sp,int client_no)
{
	return (sp->client_act_work[client_no][ACT_PARA_ACT_NO]==SERVER_WAZA_END_NO);
}

//============================================================================================
/**
 *	ZqbgɃ`FbN鑕
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[opp[^[N\
 *
 * @retval	TRUE:ʔ@FALSE:ʕs
 */
//============================================================================================
BOOL	ST_ServerWazaHitSoubiItemCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	BOOL	ret;
	int		seq_no;
	u16		item_no;
	u8		eqp;
	u8		atk;

	ret=FALSE;

	eqp=ST_ServerSoubiEqpGet(sp,sp->defence_client);
	atk=ST_ServerSoubiAtkGet(sp,sp->defence_client);

	switch(eqp){
	case SOUBI_TEKINIMOTASETEDAMEEZI:
		if((sp->psp[sp->attack_client].hp)&&
		   (sp->psp[sp->attack_client].item==0)&&
		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_flag)&FLAG_DAGEKI)){
			seq_no=SUB_SEQ_EQPITEM_KUTTUKI;
			ret=TRUE;
		}
		break;
	default:
		break;
	}
	if(ret==TRUE){
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
		sp->next_server_seq_no=sp->server_seq_no;
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
	}

	return ret;
}

//============================================================================================
/**
 *	ʃio[擾
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	ʃio[擾ClientNo
 *
 * @retval	ʃio[
 */
//============================================================================================
u8	ST_ServerSoubiEqpGet(SERVER_PARAM *sp,int client_no)
{
	u16		item_no;

	item_no=ST_ServerSoubiItemNoGet(sp,client_no);

	return ItemParamGet(item_no,ITEM_PRM_EQUIP,HEAPID_BATTLE);
}

//============================================================================================
/**
 *	ʈЗ͂擾
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	ʈЗ͂擾ClientNo
 *
 * @retval	ʈЗ
 */
//============================================================================================
u8	ST_ServerSoubiAtkGet(SERVER_PARAM *sp,int client_no)
{
	u16		item_no;

	item_no=ST_ServerSoubiItemNoGet(sp,client_no);

	return ItemParamGet(item_no,ITEM_PRM_ATTACK,HEAPID_BATTLE);
}

//============================================================================================
/**
 *	̂߂݈З͂擾
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	З͂擾ClientNo
 *
 * @retval	̂߂݈З
 */
//============================================================================================
u8	ST_ServerShizennomegumiAtkGet(SERVER_PARAM *sp,int client_no)
{
	u16	item_no;

	item_no=ST_ServerSoubiItemNoGet(sp,client_no);

	return ItemParamGet(item_no,ITEM_PRM_SIZENNOMEGUMI_ATC,HEAPID_BATTLE);
}

//============================================================================================
/**
 *	̂߂݃^Cv擾
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	^Cv擾ClientNo
 *
 * @retval	̂߂݃^Cv
 */
//============================================================================================
u8	ST_ServerShizennomegumiTypeGet(SERVER_PARAM *sp,int client_no)
{
	u16	item_no;

	item_no=ST_ServerSoubiItemNoGet(sp,client_no);

	return ItemParamGet(item_no,ITEM_PRM_SIZENNOMEGUMI_TYPE,HEAPID_BATTLE);
}

//============================================================================================
/**
 *	΂ތʃio[擾
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	΂ތʃio[擾ClientNo
 *
 * @retval	΂ތʃio[
 */
//============================================================================================
u8	ST_ServerTsuibamuEqpGet(SERVER_PARAM *sp,int client_no)
{
	u16	item_no;
	u8	eqp;

	item_no=ST_ServerSoubiItemNoGet(sp,client_no);
	eqp=ItemParamGet(item_no,ITEM_PRM_TUIBAMU_EFF,HEAPID_BATTLE);

	if(eqp){
		//˂񂿂Ⴍ́A΂߂Ȃ
		if(ST_ServerKatayaburiTokuseiCheck(sp,sp->attack_client,client_no,TOKUSYU_NENTYAKU)==TRUE){
			eqp=0;
		}
	}

	return eqp;
}

//============================================================================================
/**
 *	Ȃʃio[擾
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	Ȃʃio[擾ClientNo
 *
 * @retval	Ȃʃio[
 */
//============================================================================================
u8	ST_ServerNagetsukeruEqpGet(SERVER_PARAM *sp,int client_no)
{
	u16	item_no;

	item_no=ST_ServerSoubiItemNoGet(sp,client_no);

	return ItemParamGet(item_no,ITEM_PRM_TUIBAMU_EFF,HEAPID_BATTLE);
}

//============================================================================================
/**
 *	ȂЗ͂擾
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	З͂擾ClientNo
 *
 * @retval	ȂЗ
 */
//============================================================================================
u8	ST_ServerNagetsukeruAtkGet(SERVER_PARAM *sp,int client_no)
{
	u16	item_no;

	item_no=ST_ServerSoubiItemNoGet(sp,client_no);

	return ItemParamGet(item_no,ITEM_PRM_TUIBAMU_EFF,HEAPID_BATTLE);
}

//============================================================================================
/**
 *	|Pւ\`FbN
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	`FbNClientNo
 *
 * @retval	ւłȂZʂ̋Zio[
 */
//============================================================================================
int		ST_ServerPokemonSelectCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	int	wazano;

	wazano=0;

	//ʂłȂ炸ւʂ̏ꍇ́Aւ
	if(ST_ServerSoubiEqpGet(sp,client_no)==SOUBI_KANARAZUIREKAWARERU){
		return 0;
	}

	//߂nA낢܂ȂA˂͂́AւłȂ
	if((sp->psp[client_no].condition2&(CONDITION2_SHIME|CONDITION2_KUROIMANAZASHI))||
	   (sp->psp[client_no].waza_kouka&WAZAKOUKA_NEWOHARU)){
		wazano=1;
	}

	//肪ӂ݁A肶A傭ĂƂ́AւłȂ
	if( ((ST_ServerTokuseiGet(sp,client_no)!=TOKUSYU_KAGEHUMI)&&
		 (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ENEMY_SIDE,client_no,TOKUSYU_KAGEHUMI)))||
		((ST_ServerTokuseiGet(sp,client_no)!=TOKUSYU_HUYUU)&&
		 (sp->psp[client_no].type1!=HIKOU_TYPE)&&
		 (sp->psp[client_no].type2!=HIKOU_TYPE)&&
		 (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ENEMY_SIDE,client_no,TOKUSYU_ARIZIGOKU)))||
	   (((sp->psp[client_no].type1==METAL_TYPE)||
		 (sp->psp[client_no].type2==METAL_TYPE))&&
		 (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ENEMY_SIDE,client_no,TOKUSYU_ZIRYOKU))) ){
		wazano=1;
	}

	return wazano;
}

//============================================================================================
/**
 *	΂ތʂ̃`FbN
 *
 *	@param[in]	bw			퓬VXep[N\
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *
 *	@retval	FALSE:ȂɂȂ	TRUE:΂ތʔ
 */
//============================================================================================
BOOL	ST_ServerTsuibamuCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	BOOL	ret;
	int		seq_no;
	u8		eqp;
	u8		atk;

	ret=FALSE;

	eqp=ST_ServerTsuibamuEqpGet(sp,client_no);
	atk=ST_ServerSoubiAtkGet(sp,client_no);

	if(eqp){
		switch(eqp){
		case TUIBAMU_HPKAIHUKU:
			if(sp->psp[sp->attack_client].hp!=sp->psp[sp->attack_client].hpmax){
				sp->hp_calc_work=atk;
				seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				ret=TRUE;
			}
			break;
		case TUIBAMU_MAHINAOSI:
			if(sp->psp[sp->attack_client].condition&CONDITION_MAHI){
				seq_no=SUB_SEQ_EQPITEM_NO_MAHI;
				ret=TRUE;
			}
			break;
		case TUIBAMU_NEMUKEZAMASI:
			if(sp->psp[sp->attack_client].condition&CONDITION_NEMURI){
				seq_no=SUB_SEQ_EQPITEM_NO_NEMURI;
				ret=TRUE;
			}
			break;
		case TUIBAMU_DOKUKESI:
			if(sp->psp[sp->attack_client].condition&CONDITION_DOKUALL){
				seq_no=SUB_SEQ_EQPITEM_NO_DOKU;
				ret=TRUE;
			}
			break;
		case TUIBAMU_YAKEDONAOSI:
			if(sp->psp[sp->attack_client].condition&CONDITION_YAKEDO){
				seq_no=SUB_SEQ_EQPITEM_NO_YAKEDO;
				ret=TRUE;
			}
			break;
		case TUIBAMU_KOORINAOSI:
			if(sp->psp[sp->attack_client].condition&CONDITION_KOORI){
				seq_no=SUB_SEQ_EQPITEM_NO_KOORI;
				ret=TRUE;
			}
			break;
		case TUIBAMU_PPKAIHUKU:
			{
				int	pos;

				for(pos=0;pos<WAZA_TEMOTI_MAX;pos++){
					if(sp->psp[sp->attack_client].pp[pos]==0){
						break;
					}
				}
				if(pos!=WAZA_TEMOTI_MAX){
					ST_PokemonServerParamAdd(&sp->psp[sp->attack_client],ID_PSP_pp1+pos,atk);
					ST_PSPtoPPCopy(bw,sp,sp->attack_client);
					sp->waza_work=sp->psp[sp->attack_client].waza[pos];
					seq_no=SUB_SEQ_EQPITEM_PP_KAIHUKU;
					ret=TRUE;
				}
			}
			break;
		case TUIBAMU_KONRANNAOSI:
			if(sp->psp[sp->attack_client].condition2&CONDITION2_KONRAN){
				seq_no=SUB_SEQ_EQPITEM_NO_KONRAN;
				ret=TRUE;
			}
			break;
		case TUIBAMU_ZYOUTAIIZYOUNAOSI:
			if((sp->psp[sp->attack_client].condition&CONDITION_BAD)||
			   (sp->psp[sp->attack_client].condition2&CONDITION2_KONRAN)){
				if(sp->psp[sp->attack_client].condition&CONDITION_MAHI){
					seq_no=SUB_SEQ_EQPITEM_NO_MAHI;
				}
				if(sp->psp[sp->attack_client].condition&CONDITION_NEMURI){
					seq_no=SUB_SEQ_EQPITEM_NO_NEMURI;
				}
				if(sp->psp[sp->attack_client].condition&CONDITION_DOKUALL){
					seq_no=SUB_SEQ_EQPITEM_NO_DOKU;
				}
				if(sp->psp[sp->attack_client].condition&CONDITION_YAKEDO){
					seq_no=SUB_SEQ_EQPITEM_NO_YAKEDO;
				}
				if(sp->psp[sp->attack_client].condition&CONDITION_KOORI){
					seq_no=SUB_SEQ_EQPITEM_NO_KOORI;
				}
				if(sp->psp[sp->attack_client].condition2&CONDITION2_KONRAN){
					seq_no=SUB_SEQ_EQPITEM_NO_KONRAN;
				}
				if((sp->psp[sp->attack_client].condition&CONDITION_BAD)&&
				   (sp->psp[sp->attack_client].condition2&CONDITION2_KONRAN)){
					seq_no=SUB_SEQ_EQPITEM_NO_JOUTAIIJOU;
				}
				ret=TRUE;
			}
			break;
		case TUIBAMU_KARAIKONRAN:
			if(sp->psp[sp->attack_client].hp!=sp->psp[sp->attack_client].hpmax){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->attack_client].hpmax,atk);
				sp->msg_work=TASTE_KARAI;
				if(PokeLikeTasteCheck(sp->psp[sp->attack_client].personal_rnd,TASTE_KARAI)==DISLIKE_TASTE){
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
				}
				else{
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				}
				ret=TRUE;
			}
			break;
		case TUIBAMU_SIBUIKONRAN:
			if(sp->psp[sp->attack_client].hp!=sp->psp[sp->attack_client].hpmax){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->attack_client].hpmax,atk);
				sp->msg_work=TASTE_SIBUI;
				if(PokeLikeTasteCheck(sp->psp[sp->attack_client].personal_rnd,TASTE_SIBUI)==DISLIKE_TASTE){
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
				}
				else{
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				}
				ret=TRUE;
			}
			break;
		case TUIBAMU_AMAIKONRAN:
			if(sp->psp[sp->attack_client].hp!=sp->psp[sp->attack_client].hpmax){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->attack_client].hpmax,atk);
				sp->msg_work=TASTE_AMAI;
				if(PokeLikeTasteCheck(sp->psp[sp->attack_client].personal_rnd,TASTE_AMAI)==DISLIKE_TASTE){
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
				}
				else{
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				}
				ret=TRUE;
			}
			break;
		case TUIBAMU_NIGAIKONRAN:
			if(sp->psp[sp->attack_client].hp!=sp->psp[sp->attack_client].hpmax){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->attack_client].hpmax,atk);
				sp->msg_work=TASTE_NIGAI;
				if(PokeLikeTasteCheck(sp->psp[sp->attack_client].personal_rnd,TASTE_NIGAI)==DISLIKE_TASTE){
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
				}
				else{
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				}
				ret=TRUE;
			}
			break;
		case TUIBAMU_SUPPAIKONRAN:
			if(sp->psp[sp->attack_client].hp!=sp->psp[sp->attack_client].hpmax){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->attack_client].hpmax,atk);
				sp->msg_work=TASTE_SUPPAI;
				if(PokeLikeTasteCheck(sp->psp[sp->attack_client].personal_rnd,TASTE_SUPPAI)==DISLIKE_TASTE){
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
				}
				else{
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				}
				ret=TRUE;
			}
			break;
#if 0
		case TUIBAMU_NOURYOKUKAIHUKU:
			{
				int	i;

				for(i=0;i<COND_MAX;i++){
					if(sp->psp[sp->attack_client].abiritycnt[i]<6){
						sp->psp[sp->attack_client].abiritycnt[i]=6;
						ret=TRUE;
					}
				}
				if(ret==TRUE){
					seq_no=SUB_SEQ_EQPITEM_ABIRITY_KAIHUKU;
				}
			}
			break;
		case TUIBAMU_MEROMERONAOSI:
			if(sp->psp[sp->attack_client].condition2&CONDITION2_MEROMERO){
				sp->msg_work=MSG_COND_MEROMERO;
				seq_no=SUB_SEQ_EQPITEM_NO_MEROMERO;
				ret=TRUE;
			}
			break;
#endif
		default:
			break;
		}
		if(ret==TRUE){
			sp->temp_work=seq_no;
			sp->item_work=ST_ServerSoubiItemNoGet(sp,client_no);
			sp->ostf[sp->attack_client].status_flag|=OSTF_STATUS_FLAG_TSUIBAMU;
		}
	}

	return ret;
}

//============================================================================================
/**
 *	Ȃʂ̃`FbN
 *
 *	@param[in]	bw			퓬VXep[N\
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *
 *	@retval	FALSE:ȂɂȂ	TRUE:Ȃʔ
 */
//============================================================================================
BOOL	ST_ServerNagetsukeruCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	int		seq_no;
	u8		eqp;
	u8		atk;

	eqp=ST_ServerNagetsukeruEqpGet(sp,client_no);
	atk=ST_ServerSoubiAtkGet(sp,client_no);
	sp->damage_power=ST_ServerNagetsukeruAtkGet(sp,client_no);
	sp->nagetsukeru_seq_no=0;

	//З͂̂ȂACéAłȂ
	if(sp->damage_power==0){
		return FALSE;
	}

	switch(eqp){
	case NAGETUKERU_HPKAIHUKU:
		if(sp->psp[sp->defence_client].hp!=sp->psp[sp->defence_client].hpmax){
			sp->nagetsukeru_work=atk;
			sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
		}
		break;
	case NAGETUKERU_MAHINAOSI:
		if(sp->psp[sp->defence_client].condition&CONDITION_MAHI){
			sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_MAHI;
		}
		break;
	case NAGETUKERU_NEMUKEZAMASI:
		if(sp->psp[sp->defence_client].condition&CONDITION_NEMURI){
			sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_NEMURI;
		}
		break;
	case NAGETUKERU_DOKUKESI:
		if(sp->psp[sp->defence_client].condition&CONDITION_DOKUALL){
			sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_DOKU;
		}
		break;
	case NAGETUKERU_YAKEDONAOSI:
		if(sp->psp[sp->defence_client].condition&CONDITION_YAKEDO){
			sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_YAKEDO;
		}
		break;
	case NAGETUKERU_KOORINAOSI:
		if(sp->psp[sp->defence_client].condition&CONDITION_KOORI){
			sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_KOORI;
		}
		break;
	case NAGETUKERU_PPKAIHUKU:
		{
			int	pos;

			for(pos=0;pos<WAZA_TEMOTI_MAX;pos++){
				if(sp->psp[sp->defence_client].pp[pos]==0){
					break;
				}
			}
			if(pos!=WAZA_TEMOTI_MAX){
				ST_PokemonServerParamAdd(&sp->psp[sp->defence_client],ID_PSP_pp1+pos,atk);
				ST_PSPtoPPCopy(bw,sp,sp->defence_client);
				sp->waza_work=sp->psp[sp->defence_client].waza[pos];
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_PP_KAIHUKU;
			}
		}
		break;
	case NAGETUKERU_KONRANNAOSI:
		if(sp->psp[sp->defence_client].condition2&CONDITION2_KONRAN){
			sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_KONRAN;
		}
		break;
	case NAGETUKERU_ZYOUTAIIZYOUNAOSI:
		if((sp->psp[sp->defence_client].condition&CONDITION_BAD)||
		   (sp->psp[sp->defence_client].condition2&CONDITION2_KONRAN)){
			if(sp->psp[sp->defence_client].condition&CONDITION_MAHI){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_MAHI;
			}
			if(sp->psp[sp->defence_client].condition&CONDITION_NEMURI){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_NEMURI;
			}
			if(sp->psp[sp->defence_client].condition&CONDITION_DOKUALL){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_DOKU;
			}
			if(sp->psp[sp->defence_client].condition&CONDITION_YAKEDO){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_YAKEDO;
			}
			if(sp->psp[sp->defence_client].condition&CONDITION_KOORI){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_KOORI;
			}
			if(sp->psp[sp->defence_client].condition2&CONDITION2_KONRAN){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_KONRAN;
			}
			if((sp->psp[sp->defence_client].condition&CONDITION_BAD)&&
			   (sp->psp[sp->defence_client].condition2&CONDITION2_KONRAN)){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_JOUTAIIJOU;
			}
		}
		break;
	case NAGETUKERU_KARAIKONRAN:
		if(sp->psp[sp->defence_client].hp!=sp->psp[sp->defence_client].hpmax){
			sp->nagetsukeru_work=ST_ServerDamageDiv(sp->psp[sp->defence_client].hpmax,atk);
			sp->msg_work=TASTE_KARAI;
			if(PokeLikeTasteCheck(sp->psp[sp->defence_client].personal_rnd,TASTE_KARAI)==DISLIKE_TASTE){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
			}
			else{
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
			}
		}
		break;
	case NAGETUKERU_SIBUIKONRAN:
		if(sp->psp[sp->defence_client].hp!=sp->psp[sp->defence_client].hpmax){
			sp->nagetsukeru_work=ST_ServerDamageDiv(sp->psp[sp->defence_client].hpmax,atk);
			sp->msg_work=TASTE_SIBUI;
			if(PokeLikeTasteCheck(sp->psp[sp->defence_client].personal_rnd,TASTE_SIBUI)==DISLIKE_TASTE){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
			}
			else{
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
			}
		}
		break;
	case NAGETUKERU_AMAIKONRAN:
		if(sp->psp[sp->defence_client].hp!=sp->psp[sp->defence_client].hpmax){
			sp->nagetsukeru_work=ST_ServerDamageDiv(sp->psp[sp->defence_client].hpmax,atk);
			sp->msg_work=TASTE_AMAI;
			if(PokeLikeTasteCheck(sp->psp[sp->defence_client].personal_rnd,TASTE_AMAI)==DISLIKE_TASTE){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
			}
			else{
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
			}
		}
		break;
	case NAGETUKERU_NIGAIKONRAN:
		if(sp->psp[sp->defence_client].hp!=sp->psp[sp->defence_client].hpmax){
			sp->nagetsukeru_work=ST_ServerDamageDiv(sp->psp[sp->defence_client].hpmax,atk);
			sp->msg_work=TASTE_NIGAI;
			if(PokeLikeTasteCheck(sp->psp[sp->defence_client].personal_rnd,TASTE_NIGAI)==DISLIKE_TASTE){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
			}
			else{
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
			}
		}
		break;
	case NAGETUKERU_SUPPAIKONRAN:
		if(sp->psp[sp->defence_client].hp!=sp->psp[sp->defence_client].hpmax){
			sp->nagetsukeru_work=ST_ServerDamageDiv(sp->psp[sp->defence_client].hpmax,atk);
			sp->msg_work=TASTE_SUPPAI;
			if(PokeLikeTasteCheck(sp->psp[sp->defence_client].personal_rnd,TASTE_SUPPAI)==DISLIKE_TASTE){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
			}
			else{
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
			}
		}
		break;
	case NAGETUKERU_NOURYOKUKAIHUKU:
		{
			int	i;

			for(i=0;i<COND_MAX;i++){
				if(sp->psp[sp->defence_client].abiritycnt[i]<6){
					sp->psp[sp->defence_client].abiritycnt[i]=6;
					sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_ABIRITY_KAIHUKU;
				}
			}
		}
		break;
#if 0
	case NAGETUKERU_MEROMERONAOSI:
		if(sp->psp[sp->defence_client].condition2&CONDITION2_MEROMERO){
			sp->msg_work=MSG_COND_MEROMERO;
			sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_MEROMERO;
		}
		break;
	case NAGETUKERU_HIRUMASERU:
	case NAGETUKERU_MAHINISURU:
	case NAGETUKERU_DOKUNISURU:
	case NAGETUKERU_MOUDOKUNISURU:
	case NAGETUKERU_YAKEDONISURU:
		break;
#endif
	default:
		break;
	}

	sp->item_work=ST_ServerSoubiItemNoGet(sp,client_no);
	sp->ostf[sp->defence_client].status_flag|=OSTF_STATUS_FLAG_TSUIBAMU;

	return TRUE;
}

//============================================================================================
/**
 *	gm[`FbN
 *
 *	@param[in]	bw			퓬VXep[N\
 *	@param[in]	sp			T[op[^\̂̃|C^
 */
//============================================================================================
void	ST_ServerMetronomeCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	if(ST_ServerSoubiEqpGet(sp,sp->attack_client)==SOUBI_ONAZIWAZANOIRYOKUUP){
		if((sp->waza_no_out[sp->attack_client])&&(sp->waza_no_temp==sp->waza_no_old[sp->attack_client])){
			if(sp->psp[sp->attack_client].wkw.metronome_work<10){
				sp->psp[sp->attack_client].wkw.metronome_work++;
			}
		}
		else{
			sp->psp[sp->attack_client].wkw.metronome_work=0;
		}
	}
	else{
		sp->psp[sp->attack_client].wkw.metronome_work=0;
	}
}

//============================================================================================
/**
 *	|P̂C`FbNāAp^[擾
 *
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 */
//============================================================================================
int		ST_ServerPokeVoiceEffNoGet(SERVER_PARAM *sp,int client_no)
{
	int	ptn;
	int	col;

	ptn=PV_NORMAL;
	col=GetHPGaugeDottoColor(sp->psp[client_no].hp,sp->psp[client_no].hpmax,GAUGE_HP_DOTTOMAX);

	if((sp->psp[client_no].condition&CONDITION_BAD)||
	   ((col!=HP_DOTTO_MAX)&&(col!=HP_DOTTO_GREEN))){
		ptn=PV_PINCHNORMAL;
	}

	return ptn;
}

//============================================================================================
//			p[^Qbgn
//============================================================================================
//============================================================================================
/**
 *	SERVER_PARAM\̂̃o̒l擾
 *
 * @param[in]	bw			퓬p[^̍\̃|C^
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	id			擾õCfbNX
 * @param[in]	client_no	擾oClientNoiKvȏꍇj
 *
 * @retval	l
 */
//============================================================================================
int		ST_ServerParamDataGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int id,int client_no)
{
	int	dir;

	switch(id){
	case ID_SP_side_condition:
		dir=BattleWorkMineEnemyCheck(bw,client_no);
		return sp->side_condition[dir];
		break;
	case ID_SP_shiroikiri_count:
		dir=BattleWorkMineEnemyCheck(bw,client_no);
		return sp->scw[dir].shiroikiri_count;
		break;
	case ID_SP_win_lose_flag:
		return sp->win_lose_flag;
		break;
	case ID_SP_sel_mons_no:
		return sp->sel_mons_no[client_no];
		break;
	case ID_SP_total_turn:
		return sp->total_turn;
		break;
	}
	GF_ASSERT("`ĂȂIDł\n");
	return 0;
}

//============================================================================================
//			p[^Zbgn
//============================================================================================
//============================================================================================
/**
 *	ostf_status_flagZbg
 *
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	client_no	ZbgClientNo
 * @param[in]	value		Zbgl
 */
//============================================================================================
void	ST_ServerOSTFStatusFlagSet(SERVER_PARAM *sp,int client_no,u32 value)
{
	sp->ostf[client_no].status_flag|=value;
}

//============================================================================================
/**
 *	SERVER_PARAM̃oɒlZbg
 *
 * @param[in]	bw			퓬p[^̍\̃|C^
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	id			ZbgõCfbNX
 * @param[in]	client_no	ZbgoClientNoiKvȏꍇj
 * @param[in]	data		Zbgl
 */
//============================================================================================
void	ST_ServerParamDataPut(BATTLE_WORK *bw,SERVER_PARAM *sp,int id,int client_no,int data)
{
	int	dir;

	switch(id){
	case ID_SP_side_condition:
		dir=BattleWorkMineEnemyCheck(bw,client_no);
		sp->side_condition[dir]=data;
		break;
	case ID_SP_shiroikiri_count:
		dir=BattleWorkMineEnemyCheck(bw,client_no);
		sp->scw[dir].shiroikiri_count=data;
		break;
	case ID_SP_win_lose_flag:
		sp->win_lose_flag=data;
		break;
	case ID_SP_sel_mons_no:
		sp->sel_mons_no[client_no]=data;
		break;
	case ID_SP_total_turn:
		sp->total_turn=data;
		break;
	default:
		GF_ASSERT("`ĂȂIDł\n");
		break;
	}
}

//============================================================================================
//			OJȂn
//============================================================================================
//============================================================================================
//			ǉʓV[PXio[e[u
//============================================================================================
static const int AddStatusSeqNoTable[]=
{
	NULL,		//_~[
	SUB_SEQ_NEMURI,				//˂ނ
	SUB_SEQ_DOKU,				//
	SUB_SEQ_YAKEDO,				//₯
	SUB_SEQ_KOORI,				//
	SUB_SEQ_MAHI,				//܂
	SUB_SEQ_DOKUDOKU,			//ǂǂ
	SUB_SEQ_KONRAN,				//
	SUB_SEQ_HIRUMU,				//Ђ
	SUB_SEQ_NEMURU,				//˂ނ
	SUB_SEQ_SAWAGU,				//킮
	SUB_SEQ_NEKONIKOBAN,		//˂ɂ΂
	SUB_SEQ_KEEP,				//ߌn̋Z
	SUB_SEQ_SHIME,				//ߌn̋Z
	SUB_SEQ_HANEKAERI,			//͂˂n̋Z(1/4)
	SUB_SEQ_ABICNT_CALC,		//U̓Abv
	SUB_SEQ_ABICNT_CALC,		//h̓Abv
	SUB_SEQ_ABICNT_CALC,		//fAbv
	SUB_SEQ_ABICNT_CALC,		//UAbv
	SUB_SEQ_ABICNT_CALC,		//hAbv
	SUB_SEQ_ABICNT_CALC,		//Abv
	SUB_SEQ_ABICNT_CALC,		//𗦃Abv
	SUB_SEQ_ABICNT_CALC,		//U̓_E
	SUB_SEQ_ABICNT_CALC,		//h̓_E
	SUB_SEQ_ABICNT_CALC,		//f_E
	SUB_SEQ_ABICNT_CALC,		//U_E
	SUB_SEQ_ABICNT_CALC,		//h_E
	SUB_SEQ_ABICNT_CALC,		//_E
	SUB_SEQ_ABICNT_CALC,		//𗦃_E
	SUB_SEQ_HANDOU,				//͂ǂ
	SUB_SEQ_IKARI,				//
	SUB_SEQ_DOROBOU,			//ǂڂ
	SUB_SEQ_KUROIMANAZASI,		//낢܂Ȃ
	SUB_SEQ_AKUMU,				//
	SUB_SEQ_GENSHINOCHIKARA,	//񂵂̂
	SUB_SEQ_KOUSOKUSPIN,		//Xs
	SUB_SEQ_NO_MAHI,			//܂ЂȂ
	SUB_SEQ_BAKADIKARA,			//΂
	SUB_SEQ_HANEKAERI2,			//͂˂n̋Z(1/3)
	SUB_SEQ_ABICNT_CALC,		//U̓Abv(2iKj
	SUB_SEQ_ABICNT_CALC,		//h̓Abv(2iKj
	SUB_SEQ_ABICNT_CALC,		//fAbv(2iKj
	SUB_SEQ_ABICNT_CALC,		//UAbv(2iKj
	SUB_SEQ_ABICNT_CALC,		//hAbv(2iKj
	SUB_SEQ_ABICNT_CALC,		//Abv(2iKj
	SUB_SEQ_ABICNT_CALC,		//𗦃Abv(2iKj
	SUB_SEQ_ABICNT_CALC,		//U̓_E(2iKj
	SUB_SEQ_ABICNT_CALC,		//h̓_E(2iKj
	SUB_SEQ_ABICNT_CALC,		//f_E(2iKj
	SUB_SEQ_ABICNT_CALC,		//U_E(2iKj
	SUB_SEQ_ABICNT_CALC,		//h_E(2iKj
	SUB_SEQ_ABICNT_CALC,		//_E(2iKj
	SUB_SEQ_ABICNT_CALC,		//𗦃_E(2iKj
	SUB_SEQ_ABARERU,			//΂
	SUB_SEQ_HATAKIOTOSU,		//͂Ƃ
	SUB_SEQ_COSMO_POWER,		//RXp[iAbviabiritycntnjj
	SUB_SEQ_BUILD_UP,			//rhAbviAbviabiritycntnjj
	SUB_SEQ_KUSUGURU,			//i_Eiabiritycntnjj
	SUB_SEQ_MEISOU,				//߂iAbviabiritycntnjj
	SUB_SEQ_RYUUNOMAI,			//イ̂܂iAbviabiritycntnjj
	SUB_SEQ_SUITORI,			//HPƂn
	SUB_SEQ_YUMEKUI,			//߂
	SUB_SEQ_KUROIKIRI,			//낢
	SUB_SEQ_GAMAN,				//܂
	SUB_SEQ_WARUAGAKI,			//邠
	SUB_SEQ_TEXTURE,			//eNX`
	SUB_SEQ_JIKOSAISEI,			//
	SUB_SEQ_HIKARINOKABE,		//Ђ̂
	SUB_SEQ_RIHUREKUTAA,		//tN^[
	SUB_SEQ_SIROIKIRI,			//낢
	SUB_SEQ_KIAIDAME,			//
	SUB_SEQ_MONOMANE,			//̂܂
	SUB_SEQ_YADORIGI,			//ǂ肬̂
	SUB_SEQ_KANASIBARI,			//Ȃ΂
	SUB_SEQ_ENCORE,				//AR[
	SUB_SEQ_ITAMIWAKE,			//݂킯
	SUB_SEQ_TEXTURE2,			//eNX`Q
	SUB_SEQ_LOCKON,				//bNI
	SUB_SEQ_SKETCH,				//XPb`
	SUB_SEQ_NEGOTO,				//˂
	SUB_SEQ_MICHIDURE,			//݂Â
	SUB_SEQ_URAMI,				//
	SUB_SEQ_GUARD,				//܂A݂A炦Ȃ
	SUB_SEQ_IYASINOSUZU,		//₵̂
	SUB_SEQ_MIGAWARI,			//݂
	SUB_SEQ_HUKITOBASI,			//ӂƂ΂
	SUB_SEQ_HENSIN,				//ւ񂵂
	SUB_SEQ_CHIISAKUNARU,		//Ȃ
	SUB_SEQ_NORMAL_NOROI,		//̂낢im[}j
	SUB_SEQ_GHOST_NOROI,		//̂낢iS[Xgj
	SUB_SEQ_ADD_MESSAGE_WORK,	//bZ[W\
	SUB_SEQ_MIYABURU,			//݂Ԃ
	SUB_SEQ_HOROBINOUTA,		//قт̂
	SUB_SEQ_TENKOU,				//Vn
	SUB_SEQ_IBARU,				//΂
	SUB_SEQ_MEROMERO,			//
	SUB_SEQ_SHINPI,				//҂̂܂
	SUB_SEQ_PRESENT,			//v[g
	SUB_SEQ_MAGNITUDE,			//}Oj`[h
	SUB_SEQ_BATONTOUCH,			//og^b`
	SUB_SEQ_HARADAIKO,			//͂炾
	SUB_SEQ_TELEPORT,			//e|[g
	SUB_SEQ_HUKURODATAKI,		//ӂ낾
	SUB_SEQ_TAKUWAERU,			//킦
	SUB_SEQ_NOMIKOMU,			//݂̂
	SUB_SEQ_ICHAMON,			//
	SUB_SEQ_ODATERU,			//Ă
	SUB_SEQ_OKIMIYAGE,			//݂₰
	SUB_SEQ_JUUDEN,				//イł
	SUB_SEQ_CHOUHATSU,			//傤͂
	SUB_SEQ_TRICK,				//gbN
	SUB_SEQ_NARIKIRI,			//Ȃ肫
	SUB_SEQ_KAWARAWARI,			//
	SUB_SEQ_AKUBI,				//
	SUB_SEQ_SKILLSWAP,			//XLXbv
	SUB_SEQ_REFRESH,			//tbV
	SUB_SEQ_HANEYASUME,			//͂˂₷
	SUB_SEQ_NO_NEMURI,			//߂܂r^
	SUB_SEQ_JUURYOKU,			//イ傭
	SUB_SEQ_MIRACLE_EYE,		//~NAC
	SUB_SEQ_IYASINONEGAI,		//₵̂˂
	SUB_SEQ_OIKAZE,				//
	SUB_SEQ_INFIGHT,			//Ct@Cg
	SUB_SEQ_POWER_TRICK,		//p[gbN
	SUB_SEQ_IEKI,				//
	SUB_SEQ_OMAZINAI,			//܂Ȃ
	SUB_SEQ_POWER_SWAP,			//p[Xbv
	SUB_SEQ_GUARD_SWAP,			//K[hXbv
	SUB_SEQ_NAYAMINOTANE,		//Ȃ݂̂
	SUB_SEQ_HEART_SWAP,			//n[gXbv
	SUB_SEQ_HEAT_ATTACK,		//q[gA^bN
	SUB_SEQ_KIRIHARAI,			//͂炢
	SUB_SEQ_HEALBLOCK,			//q[ubN
	SUB_SEQ_TONBOGAERI,			//Ƃڂ
	SUB_SEQ_SHUTOUT,			//VbgAEg
};

//============================================================================================
/**
 *	ǉʂ邽߂̃p[^Zbg
 *
 * @param[in]	sp		T[op[^̍\̃|C^
 * @param[in]	type	ǉʂ̃^Cv
 * @param[in]	flag	ǉʂ̎
 *
 * @retval	ǉʓV[PXio[
 */
//============================================================================================
static	int		ST_ServerAddStatusParamSet(SERVER_PARAM *sp,int type,u32 flag)
{
	sp->tsuika_type=type;
	sp->tsuika_para=flag&ADD_STATUS_MASK;

	if(flag&ADD_STATUS_ATTACK){
		sp->tsuika_client=sp->attack_client;
	}
	else if(flag&ADD_STATUS_DEFENCE){
		sp->tsuika_client=sp->defence_client;
	}
	else if((flag&ADD_STATUS_WAZAKOUKA)||(flag&ADD_STATUS_WAZAKOUKA_NOHIT)){
		sp->tsuika_client=0;
	}
	else{
		OS_TPrintf("ST_ServerAddStausParamSet:ɂ̂͂->%08x\n",flag);
	}

	GF_ASSERT_MSG(NELEMS(AddStatusSeqNoTable)>(flag&ADD_STATUS_MASK),"݂ȂSUB_SEQ_NOł");

	return AddStatusSeqNoTable[flag&ADD_STATUS_MASK];
}

//============================================================================================
/**
 *	|PƋZ̃^Cv̑ŃtOZbg
 *
 * @param[in]	client_no	ZJoClientNo
 * @param[in]	power		З
 * @param[in]	damage		Z̈З
 * @param[out]	flag		tOZbg郏[N
 */
//============================================================================================
static	void	ST_TypeCheckCalc(SERVER_PARAM *sp,int client_no,int power,int damage,u32 *flag)
{
	//^Cvɂ␳vZ
	if(((sp->server_status_flag&SERVER_STATUS_FLAG_TYPE_FLAT)==0)&&
	   ((sp->server_status_flag&SERVER_STATUS_FLAG_TYPE_NONE)==0)&&
		(sp->damage)){
		//߂˂́A܂ЂƂ0.75{ɂ
		if((ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_IROMEGANE)&&(power==IMAHITOTSU)){
			sp->damage=ST_ServerDamageDiv(sp->damage*75,100);
		}
		else{
			sp->damage=ST_ServerDamageDiv(sp->damage*power,10);
		}
	}
	switch(power){
	case KOUKANAI:
		flag[0]|=WAZA_STATUS_FLAG_KOUKANAI;
		flag[0]&=WAZA_STATUS_FLAG_IMAHITOTSU_OFF;
		flag[0]&=WAZA_STATUS_FLAG_BATSUGUN_OFF;
		break;
	case IMAHITOTSU:
		if(((damage)&&(flag[0]&WAZA_STATUS_FLAG_HAZURE)==0)){
			if(flag[0]&WAZA_STATUS_FLAG_BATSUGUN){
				flag[0]&=WAZA_STATUS_FLAG_BATSUGUN_OFF;
			}
			else{
				flag[0]|=WAZA_STATUS_FLAG_IMAHITOTSU;
			}
		}
		break;
	case BATSUGUN:
		if((damage)&&((flag[0]&WAZA_STATUS_FLAG_HAZURE)==0)){
			if(flag[0]&WAZA_STATUS_FLAG_IMAHITOTSU){
				flag[0]&=WAZA_STATUS_FLAG_IMAHITOTSU_OFF;
			}
			else{
				flag[0]|=WAZA_STATUS_FLAG_BATSUGUN;
			}
		}
		break;
	}
}

//============================================================================================
/**
 *	ߋZ^[Ȃ̂`FbNiߋZȊO͋Iɔj
 *
 * @param[in]	waza_no		`FbNZio[
 *
 * @retval	TRUEF@FALSE:߂^[
 */
//============================================================================================
static BOOL	ST_TameWazaTurnCheck(SERVER_PARAM *sp,int waza_no)
{
	switch(WT_WazaDataParaGet(waza_no,ID_WTD_battleeffect)){
	case 26:	//܂
	case 39:	//܂
	case 75:	//Sbho[h
	case 145:	//Pbg˂
	case 151:	//\[[r[
	case 155:	//ƂԁAƂт͂˂
	case 255:	//_CrO
	case 256:	//Ȃق
		return (sp->server_status_flag&SERVER_STATUS_FLAG_TAME_AFTER);
		break;
	}

	return TRUE;
}

